/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.tab;

import jadx.api.JavaClass;
import jadx.api.metadata.ICodeAnnotation;
import jadx.api.metadata.ICodeNodeRef;
import jadx.api.metadata.annotations.NodeDeclareRef;
import jadx.gui.jobs.IBackgroundTask;
import jadx.gui.jobs.SimpleTask;
import jadx.gui.jobs.TaskWithExtraOnFinish;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JNode;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.codearea.EditorViewState;
import jadx.gui.ui.tab.ITabStatesListener;
import jadx.gui.ui.tab.LogTabStates;
import jadx.gui.ui.tab.TabBlueprint;
import jadx.gui.utils.JumpPosition;
import jadx.gui.utils.UiUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabsController {
    private static final Logger LOG = LoggerFactory.getLogger(TabsController.class);
    private final MainWindow mainWindow;
    private final Map<JNode, TabBlueprint> tabsMap = new HashMap<JNode, TabBlueprint>();
    private final List<ITabStatesListener> listeners = new ArrayList<ITabStatesListener>();
    private boolean forceClose;
    @Nullable
    private TabBlueprint selectedTab;

    public TabsController(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
        if (UiUtils.JADX_GUI_DEBUG) {
            this.addListener(new LogTabStates());
        }
    }

    public MainWindow getMainWindow() {
        return this.mainWindow;
    }

    public void addListener(ITabStatesListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ITabStatesListener listener) {
        this.listeners.remove(listener);
    }

    @Nullable
    public TabBlueprint getTabByNode(JNode node) {
        return this.tabsMap.get(node);
    }

    public TabBlueprint openTab(JNode node) {
        return this.openTab(node, false, false);
    }

    public TabBlueprint openTab(JNode node, boolean hidden, boolean preview) {
        TabBlueprint blueprint;
        if (!node.hasContent()) {
            LOG.warn("Can't open tab for node without content, node: {}", (Object)node);
        }
        if ((blueprint = this.getTabByNode(node)) == null) {
            TabBlueprint newBlueprint = new TabBlueprint(node);
            newBlueprint.setHidden(hidden);
            newBlueprint.setPreviewTab(preview);
            this.tabsMap.put(node, newBlueprint);
            this.listeners.forEach(l15 -> l15.onTabOpen(newBlueprint));
            if (hidden) {
                this.listeners.forEach(l15 -> l15.onTabVisibilityChange(newBlueprint));
            }
            blueprint = newBlueprint;
        }
        this.setTabHiddenInternal(blueprint, hidden);
        return blueprint;
    }

    public TabBlueprint previewTab(JNode node) {
        TabBlueprint blueprint = this.getPreviewTab();
        if (blueprint != null) {
            this.closeTab(blueprint.getNode());
        }
        return this.openTab(node, false, true);
    }

    public void selectTab(JNode node) {
        this.selectTab(node, false);
    }

    public void selectTab(JNode node, boolean fromTree) {
        if (this.selectedTab != null && this.selectedTab.getNode() == node) {
            return;
        }
        this.selectedTab = this.mainWindow.getSettings().isEnablePreviewTab() && fromTree ? this.previewTab(node) : this.openTab(node);
        this.listeners.forEach(l15 -> l15.onTabSelect(this.selectedTab));
    }

    public void deselectTab() {
        this.selectedTab = null;
    }

    public void codeJump(JNode node) {
        this.codeJump(node, false);
    }

    public void codeJump(JNode node, boolean fromTree) {
        JClass clsRootClass;
        JClass parentCls = node.getJParent();
        if (parentCls != null) {
            JavaClass cls = node.getJParent().getCls();
            JavaClass origTopCls = cls.getOriginalTopParentClass();
            JavaClass codeParent = cls.getTopParentClass();
            if (!Objects.equals(codeParent, origTopCls)) {
                JClass jumpCls = this.mainWindow.getCacheObject().getNodeCache().makeFrom(codeParent);
                this.loadCodeWithUIAction(jumpCls, () -> this.jumpToInnerClass(node, codeParent, jumpCls, fromTree));
                return;
            }
        }
        if ((clsRootClass = node.getRootClass()) == null) {
            this.selectTab(node, fromTree);
            return;
        }
        this.loadCodeWithUIAction(clsRootClass, () -> this.codeJump(new JumpPosition(node), fromTree));
    }

    private void loadCodeWithUIAction(JClass cls, Runnable action) {
        SimpleTask loadTask = cls.getLoadTask();
        if (loadTask == null) {
            UiUtils.uiRun(action);
            return;
        }
        this.mainWindow.getBackgroundExecutor().execute(new TaskWithExtraOnFinish((IBackgroundTask)loadTask, action));
    }

    private void jumpToInnerClass(JNode node, JavaClass codeParent, JClass jumpCls, boolean fromTree) {
        codeParent.getCodeInfo().getCodeMetadata().searchDown(0, (pos, ann) -> {
            ICodeNodeRef declNode;
            if (ann.getAnnType() == ICodeAnnotation.AnnType.DECLARATION && (declNode = ((NodeDeclareRef)ann).getNode()).equals(node.getJavaNode().getCodeNodeRef())) {
                this.codeJump(new JumpPosition(jumpCls, (int)pos), fromTree);
                return true;
            }
            return null;
        });
    }

    public void codeJump(JumpPosition pos) {
        this.codeJump(pos, false);
    }

    public void codeJump(JumpPosition pos, boolean fromTree) {
        JumpPosition currentPosition = this.mainWindow.getTabbedPane().getCurrentPosition();
        if (this.selectedTab == null || this.selectedTab.getNode() != pos.getNode()) {
            this.selectTab(pos.getNode(), fromTree);
        }
        this.listeners.forEach(l15 -> l15.onTabCodeJump(this.selectedTab, currentPosition, pos));
    }

    public void smaliJump(JClass cls, int pos, boolean debugMode) {
        this.selectTab(cls);
        TabBlueprint blueprint = this.getTabByNode(cls);
        this.listeners.forEach(l15 -> l15.onTabSmaliJump(blueprint, pos, debugMode));
    }

    public void closeTab(JNode node) {
        this.closeTab(node, false);
    }

    public void closeTab(JNode node, boolean considerPins) {
        TabBlueprint blueprint = this.getTabByNode(node);
        if (blueprint != null) {
            this.closeTab(blueprint, considerPins);
        }
    }

    public void closeTab(TabBlueprint blueprint, boolean considerPins) {
        if (this.forceClose) {
            this.closeTabForce(blueprint);
            return;
        }
        if (!considerPins || !blueprint.isPinned()) {
            if (!blueprint.isReferenced()) {
                this.closeTabForce(blueprint);
            } else {
                this.closeTabSoft(blueprint);
            }
        }
    }

    private void closeTabForce(TabBlueprint blueprint) {
        this.listeners.forEach(l15 -> l15.onTabClose(blueprint));
        this.tabsMap.remove(blueprint.getNode());
    }

    private void closeTabSoft(TabBlueprint blueprint) {
        this.setTabHidden(blueprint.getNode(), true);
    }

    public void setTabPositionFirst(JNode node) {
        TabBlueprint blueprint = this.openTab(node);
        this.listeners.forEach(l15 -> l15.onTabPositionFirst(blueprint));
    }

    public void setTabPinned(JNode node, boolean pinned) {
        TabBlueprint blueprint = this.openTab(node);
        this.setTabPinnedInternal(blueprint, pinned);
    }

    public void setTabPinnedInternal(TabBlueprint blueprint, boolean pinned) {
        if (blueprint.isPinned() != pinned) {
            blueprint.setPreviewTab(false);
            blueprint.setPinned(pinned);
            this.listeners.forEach(l15 -> l15.onTabPinChange(blueprint));
        }
    }

    public void setTabBookmarked(JNode node, boolean bookmarked) {
        TabBlueprint blueprint = this.openTab(node);
        this.setTabBookmarkedInternal(blueprint, bookmarked);
    }

    private void setTabBookmarkedInternal(TabBlueprint blueprint, boolean bookmarked) {
        if (blueprint.isBookmarked() != bookmarked) {
            blueprint.setPreviewTab(false);
            blueprint.setBookmarked(bookmarked);
            this.listeners.forEach(l15 -> l15.onTabBookmarkChange(blueprint));
            this.removeTabIfNotReferenced(blueprint);
        }
    }

    public void setTabHidden(JNode node, boolean hidden) {
        TabBlueprint blueprint = this.getTabByNode(node);
        this.setTabHiddenInternal(blueprint, hidden);
    }

    private void setTabHiddenInternal(TabBlueprint blueprint, boolean hidden) {
        if (blueprint != null && blueprint.isHidden() != hidden) {
            blueprint.setPreviewTab(false);
            blueprint.setHidden(hidden);
            this.listeners.forEach(l15 -> l15.onTabVisibilityChange(blueprint));
        }
    }

    public void setTabPreview(JNode node, boolean isPreview) {
        TabBlueprint blueprint = this.getTabByNode(node);
        this.setTabPreviewInternal(blueprint, isPreview);
    }

    private void setTabPreviewInternal(TabBlueprint blueprint, boolean isPreview) {
        if (blueprint != null && blueprint.isPreviewTab() != isPreview) {
            blueprint.setPreviewTab(isPreview);
            this.listeners.forEach(l15 -> l15.onTabPreviewChange(blueprint));
        }
    }

    private void removeTabIfNotReferenced(TabBlueprint blueprint) {
        if (blueprint.isHidden() && !blueprint.isReferenced()) {
            this.tabsMap.remove(blueprint.getNode());
        }
    }

    public void closeAllTabs() {
        this.closeAllTabs(false);
    }

    public void forceCloseAllTabs() {
        this.forceClose = true;
        this.closeAllTabs();
        this.forceClose = false;
        this.selectedTab = null;
    }

    public boolean isForceClose() {
        return this.forceClose;
    }

    public void closeAllTabs(boolean considerPins) {
        List.copyOf(this.tabsMap.values()).forEach(t15 -> this.closeTab(t15.getNode(), considerPins));
    }

    public void unpinAllTabs() {
        this.tabsMap.values().forEach(t15 -> this.setTabPinned(t15.getNode(), false));
    }

    public void unbookmarkAllTabs() {
        this.tabsMap.values().forEach(t15 -> this.setTabBookmarked(t15.getNode(), false));
    }

    public TabBlueprint getSelectedTab() {
        return this.selectedTab;
    }

    public List<TabBlueprint> getTabs() {
        return List.copyOf(this.tabsMap.values());
    }

    public List<TabBlueprint> getOpenTabs() {
        return List.copyOf(this.tabsMap.values());
    }

    public List<TabBlueprint> getPinnedTabs() {
        return this.tabsMap.values().stream().filter(TabBlueprint::isPinned).collect(Collectors.toUnmodifiableList());
    }

    public List<TabBlueprint> getBookmarkedTabs() {
        return this.tabsMap.values().stream().filter(TabBlueprint::isBookmarked).collect(Collectors.toUnmodifiableList());
    }

    public TabBlueprint getPreviewTab() {
        return this.tabsMap.values().stream().filter(TabBlueprint::isPreviewTab).findFirst().orElse(null);
    }

    public void restoreEditorViewState(EditorViewState viewState) {
        JNode node = viewState.getNode();
        TabBlueprint blueprint = this.openTab(node, viewState.isHidden(), viewState.isPreviewTab());
        this.setTabPinnedInternal(blueprint, viewState.isPinned());
        this.setTabBookmarkedInternal(blueprint, viewState.isBookmarked());
        this.listeners.forEach(l15 -> l15.onTabRestore(blueprint, viewState));
        if (viewState.isActive()) {
            this.selectTab(node);
        }
    }

    public void notifyRestoreEditorViewStateDone() {
        if (this.selectedTab == null && !this.tabsMap.isEmpty()) {
            JNode node = this.tabsMap.values().iterator().next().getNode();
            LOG.warn("No active tab found, select {}", (Object)node);
            this.selectTab(node);
        }
        this.listeners.forEach(ITabStatesListener::onTabsRestoreDone);
    }

    public List<EditorViewState> getEditorViewStates() {
        ArrayList<TabBlueprint> reorderedTabs = new ArrayList<TabBlueprint>(this.tabsMap.values());
        this.listeners.forEach(l15 -> l15.onTabsReorder(reorderedTabs));
        ArrayList<EditorViewState> states = new ArrayList<EditorViewState>();
        for (TabBlueprint blueprint : reorderedTabs) {
            states.add(this.getEditorViewState(blueprint));
        }
        return states;
    }

    public EditorViewState getEditorViewState(TabBlueprint blueprint) {
        EditorViewState viewState = new EditorViewState(blueprint.getNode());
        this.listeners.forEach(l15 -> l15.onTabSave(blueprint, viewState));
        viewState.setActive(blueprint == this.selectedTab);
        viewState.setPinned(blueprint.isPinned());
        viewState.setBookmarked(blueprint.isBookmarked());
        viewState.setHidden(blueprint.isHidden());
        viewState.setPreviewTab(blueprint.isPreviewTab());
        return viewState;
    }
}

