/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.utils.dbg;

import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.gui.utils.UiUtils;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UIWatchDog {
    private static final Logger LOG = LoggerFactory.getLogger(UIWatchDog.class);
    private static final int UI_MAX_DELAY_MS = 200;
    private static final int CHECK_INTERVAL_MS = 50;
    private static final UIWatchDog INSTANCE = new UIWatchDog();
    private final AtomicBoolean enabled = new AtomicBoolean(false);
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private Future<?> taskFuture;

    public static boolean onStart() {
        UiUtils.uiRunAndWait(UIWatchDog::toggle);
        return INSTANCE.isEnabled();
    }

    public static synchronized void toggle() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new JadxRuntimeException("This method should be called in UI thread");
        }
        INSTANCE.toggleState(Thread.currentThread());
    }

    private UIWatchDog() {
    }

    private void toggleState(Thread uiThread) {
        if (this.enabled.get()) {
            this.enabled.set(false);
            if (this.taskFuture != null) {
                try {
                    this.taskFuture.get(250L, TimeUnit.MILLISECONDS);
                }
                catch (Throwable e15) {
                    LOG.warn("Stopping UI watchdog error", e15);
                }
            }
        } else {
            this.enabled.set(true);
            this.taskFuture = this.executor.submit(() -> this.start(uiThread));
        }
    }

    private boolean isEnabled() {
        return this.enabled.get();
    }

    private void start(Thread uiThread) {
        LOG.debug("UI watchdog started");
        try {
            JadxRuntimeException e15 = new JadxRuntimeException("at");
            TimeMeasure tm4 = new TimeMeasure();
            boolean stuck = false;
            long reportTime = 0L;
            while (this.enabled.get()) {
                if (uiThread.getState() == Thread.State.TIMED_WAITING) {
                    if (!stuck) {
                        tm4.start();
                        stuck = true;
                        reportTime = 200L;
                    } else {
                        tm4.end();
                        long time = tm4.getTime();
                        if (time > reportTime) {
                            e15.setStackTrace(uiThread.getStackTrace());
                            LOG.warn("UI events thread stuck for {}ms", (Object)time, (Object)e15);
                            reportTime += 200L;
                        }
                    }
                } else {
                    stuck = false;
                }
                Thread.sleep(50L);
            }
        }
        catch (Throwable e16) {
            LOG.error("UI watchdog fail", e16);
        }
        LOG.debug("UI watchdog stopped");
    }

    private static final class TimeMeasure {
        private long start;
        private long end;

        private TimeMeasure() {
        }

        public void start() {
            this.start = System.currentTimeMillis();
        }

        public void end() {
            this.end = System.currentTimeMillis();
        }

        public long getTime() {
            return this.end - this.start;
        }
    }
}

