/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.misc;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.antlr.misc.IntSet;
import org.antlr.misc.Interval;
import org.antlr.misc.IntervalSet;
import org.antlr.tool.Grammar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BitSet
implements IntSet,
Cloneable {
    protected static final int BITS = 64;
    protected static final int LOG_BITS = 6;
    protected static final int MOD_MASK = 63;
    protected long[] bits;

    public BitSet() {
        this(64);
    }

    public BitSet(long[] bits_) {
        this.bits = bits_;
    }

    public BitSet(int nbits) {
        this.bits = new long[(nbits - 1 >> 6) + 1];
    }

    @Override
    public void add(int el4) {
        int n15 = BitSet.wordNumber(el4);
        if (n15 >= this.bits.length) {
            this.growToInclude(el4);
        }
        int n16 = n15;
        this.bits[n16] = this.bits[n16] | BitSet.bitMask(el4);
    }

    @Override
    public void addAll(IntSet set) {
        if (set instanceof BitSet) {
            this.orInPlace((BitSet)set);
        } else if (set instanceof IntervalSet) {
            IntervalSet other = (IntervalSet)set;
            for (Interval I11 : other.intervals) {
                this.orInPlace(BitSet.range(I11.a, I11.b));
            }
        } else {
            throw new IllegalArgumentException("can't add " + set.getClass().getName() + " to BitSet");
        }
    }

    public void addAll(int[] elements) {
        if (elements == null) {
            return;
        }
        for (int i15 = 0; i15 < elements.length; ++i15) {
            int e15 = elements[i15];
            this.add(e15);
        }
    }

    public void addAll(Iterable<Integer> elements) {
        if (elements == null) {
            return;
        }
        for (Integer element : elements) {
            this.add(element);
        }
    }

    @Override
    public IntSet and(IntSet a15) {
        BitSet s15 = (BitSet)this.clone();
        s15.andInPlace((BitSet)a15);
        return s15;
    }

    public void andInPlace(BitSet a15) {
        int i15;
        int min = Math.min(this.bits.length, a15.bits.length);
        for (i15 = min - 1; i15 >= 0; --i15) {
            int n15 = i15;
            this.bits[n15] = this.bits[n15] & a15.bits[i15];
        }
        for (i15 = min; i15 < this.bits.length; ++i15) {
            this.bits[i15] = 0L;
        }
    }

    private static long bitMask(int bitNumber) {
        int bitPosition = bitNumber & 0x3F;
        return 1L << bitPosition;
    }

    public void clear() {
        for (int i15 = this.bits.length - 1; i15 >= 0; --i15) {
            this.bits[i15] = 0L;
        }
    }

    public void clear(int el4) {
        int n15 = BitSet.wordNumber(el4);
        if (n15 >= this.bits.length) {
            this.growToInclude(el4);
        }
        int n16 = n15;
        this.bits[n16] = this.bits[n16] & (BitSet.bitMask(el4) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public Object clone() {
        BitSet s15;
        try {
            s15 = (BitSet)super.clone();
            s15.bits = new long[this.bits.length];
            System.arraycopy(this.bits, 0, s15.bits, 0, this.bits.length);
        }
        catch (CloneNotSupportedException e15) {
            throw new InternalError();
        }
        return s15;
    }

    @Override
    public int size() {
        int deg = 0;
        for (int i15 = this.bits.length - 1; i15 >= 0; --i15) {
            long word = this.bits[i15];
            if (word == 0L) continue;
            for (int bit = 63; bit >= 0; --bit) {
                if ((word & 1L << bit) == 0L) continue;
                ++deg;
            }
        }
        return deg;
    }

    @Override
    public boolean equals(Object other) {
        block5: {
            int i15;
            int n15;
            BitSet otherSet;
            block4: {
                if (other == null || !(other instanceof BitSet)) {
                    return false;
                }
                otherSet = (BitSet)other;
                n15 = Math.min(this.bits.length, otherSet.bits.length);
                for (i15 = 0; i15 < n15; ++i15) {
                    if (this.bits[i15] == otherSet.bits[i15]) continue;
                    return false;
                }
                if (this.bits.length <= n15) break block4;
                for (i15 = n15 + 1; i15 < this.bits.length; ++i15) {
                    if (this.bits[i15] == 0L) continue;
                    return false;
                }
                break block5;
            }
            if (otherSet.bits.length <= n15) break block5;
            for (i15 = n15 + 1; i15 < otherSet.bits.length; ++i15) {
                if (otherSet.bits[i15] == 0L) continue;
                return false;
            }
        }
        return true;
    }

    public void growToInclude(int bit) {
        int newSize = Math.max(this.bits.length << 1, this.numWordsToHold(bit));
        long[] newbits = new long[newSize];
        System.arraycopy(this.bits, 0, newbits, 0, this.bits.length);
        this.bits = newbits;
    }

    @Override
    public boolean member(int el4) {
        int n15 = BitSet.wordNumber(el4);
        if (n15 >= this.bits.length) {
            return false;
        }
        return (this.bits[n15] & BitSet.bitMask(el4)) != 0L;
    }

    @Override
    public int getSingleElement() {
        for (int i15 = 0; i15 < this.bits.length << 6; ++i15) {
            if (!this.member(i15)) continue;
            return i15;
        }
        return -7;
    }

    @Override
    public boolean isNil() {
        for (int i15 = this.bits.length - 1; i15 >= 0; --i15) {
            if (this.bits[i15] == 0L) continue;
            return false;
        }
        return true;
    }

    public IntSet complement() {
        BitSet s15 = (BitSet)this.clone();
        s15.notInPlace();
        return s15;
    }

    @Override
    public IntSet complement(IntSet set) {
        if (set == null) {
            return this.complement();
        }
        return set.subtract(this);
    }

    public void notInPlace() {
        for (int i15 = this.bits.length - 1; i15 >= 0; --i15) {
            this.bits[i15] = this.bits[i15] ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }

    public void notInPlace(int maxBit) {
        this.notInPlace(0, maxBit);
    }

    public void notInPlace(int minBit, int maxBit) {
        this.growToInclude(maxBit);
        for (int i15 = minBit; i15 <= maxBit; ++i15) {
            int n15;
            int n16 = n15 = BitSet.wordNumber(i15);
            this.bits[n16] = this.bits[n16] ^ BitSet.bitMask(i15);
        }
    }

    private int numWordsToHold(int el4) {
        return (el4 >> 6) + 1;
    }

    public static BitSet of(int el4) {
        BitSet s15 = new BitSet(el4 + 1);
        s15.add(el4);
        return s15;
    }

    public static BitSet of(Collection<? extends Integer> elements) {
        BitSet s15 = new BitSet();
        for (Integer n15 : elements) {
            s15.add(n15);
        }
        return s15;
    }

    public static BitSet of(IntSet set) {
        if (set == null) {
            return null;
        }
        if (set instanceof BitSet) {
            return (BitSet)set;
        }
        if (set instanceof IntervalSet) {
            BitSet s15 = new BitSet();
            s15.addAll(set);
            return s15;
        }
        throw new IllegalArgumentException("can't create BitSet from " + set.getClass().getName());
    }

    public static BitSet of(Map<? extends Integer, ?> elements) {
        return BitSet.of(elements.keySet());
    }

    public static BitSet range(int a15, int b15) {
        BitSet s15 = new BitSet(b15 + 1);
        for (int i15 = a15; i15 <= b15; ++i15) {
            int n15;
            int n16 = n15 = BitSet.wordNumber(i15);
            s15.bits[n16] = s15.bits[n16] | BitSet.bitMask(i15);
        }
        return s15;
    }

    @Override
    public IntSet or(IntSet a15) {
        if (a15 == null) {
            return this;
        }
        BitSet s15 = (BitSet)this.clone();
        s15.orInPlace((BitSet)a15);
        return s15;
    }

    public void orInPlace(BitSet a15) {
        if (a15 == null) {
            return;
        }
        if (a15.bits.length > this.bits.length) {
            this.setSize(a15.bits.length);
        }
        int min = Math.min(this.bits.length, a15.bits.length);
        for (int i15 = min - 1; i15 >= 0; --i15) {
            int n15 = i15;
            this.bits[n15] = this.bits[n15] | a15.bits[i15];
        }
    }

    @Override
    public void remove(int el4) {
        int n15 = BitSet.wordNumber(el4);
        if (n15 >= this.bits.length) {
            this.growToInclude(el4);
        }
        int n16 = n15;
        this.bits[n16] = this.bits[n16] & (BitSet.bitMask(el4) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private void setSize(int nwords) {
        long[] newbits = new long[nwords];
        int n15 = Math.min(nwords, this.bits.length);
        System.arraycopy(this.bits, 0, newbits, 0, n15);
        this.bits = newbits;
    }

    public int numBits() {
        return this.bits.length << 6;
    }

    public int lengthInLongWords() {
        return this.bits.length;
    }

    public boolean subset(BitSet a15) {
        if (a15 == null) {
            return false;
        }
        return this.and(a15).equals(this);
    }

    public void subtractInPlace(BitSet a15) {
        if (a15 == null) {
            return;
        }
        for (int i15 = 0; i15 < this.bits.length && i15 < a15.bits.length; ++i15) {
            int n15 = i15;
            this.bits[n15] = this.bits[n15] & (a15.bits[i15] ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    @Override
    public IntSet subtract(IntSet a15) {
        if (a15 == null || !(a15 instanceof BitSet)) {
            return null;
        }
        BitSet s15 = (BitSet)this.clone();
        s15.subtractInPlace((BitSet)a15);
        return s15;
    }

    @Override
    public List<Integer> toList() {
        throw new NoSuchMethodError("BitSet.toList() unimplemented");
    }

    public int[] toArray() {
        int[] elems = new int[this.size()];
        int en4 = 0;
        for (int i15 = 0; i15 < this.bits.length << 6; ++i15) {
            if (!this.member(i15)) continue;
            elems[en4++] = i15;
        }
        return elems;
    }

    public long[] toPackedArray() {
        return this.bits;
    }

    @Override
    public String toString() {
        return this.toString(null);
    }

    @Override
    public String toString(Grammar g15) {
        StringBuilder buf = new StringBuilder();
        String separator = ",";
        boolean havePrintedAnElement = false;
        buf.append('{');
        for (int i15 = 0; i15 < this.bits.length << 6; ++i15) {
            if (!this.member(i15)) continue;
            if (i15 > 0 && havePrintedAnElement) {
                buf.append(separator);
            }
            if (g15 != null) {
                buf.append(g15.getTokenDisplayName(i15));
            } else {
                buf.append(i15);
            }
            havePrintedAnElement = true;
        }
        buf.append('}');
        return buf.toString();
    }

    public String toString(String separator, List<String> vocabulary) {
        if (vocabulary == null) {
            return this.toString(null);
        }
        String str = "";
        for (int i15 = 0; i15 < this.bits.length << 6; ++i15) {
            if (!this.member(i15)) continue;
            if (str.length() > 0) {
                str = str + separator;
            }
            str = i15 >= vocabulary.size() ? str + "'" + (char)i15 + "'" : (vocabulary.get(i15) == null ? str + "'" + (char)i15 + "'" : str + vocabulary.get(i15));
        }
        return str;
    }

    public String toStringOfHalfWords() {
        StringBuilder s15 = new StringBuilder();
        for (int i15 = 0; i15 < this.bits.length; ++i15) {
            if (i15 != 0) {
                s15.append(", ");
            }
            long tmp = this.bits[i15];
            s15.append(tmp &= 0xFFFFFFFFL);
            s15.append("UL");
            s15.append(", ");
            tmp = this.bits[i15] >>> 32;
            s15.append(tmp &= 0xFFFFFFFFL);
            s15.append("UL");
        }
        return s15.toString();
    }

    public String toStringOfWords() {
        StringBuilder s15 = new StringBuilder();
        for (int i15 = 0; i15 < this.bits.length; ++i15) {
            if (i15 != 0) {
                s15.append(", ");
            }
            s15.append(this.bits[i15]);
            s15.append("L");
        }
        return s15.toString();
    }

    public String toStringWithRanges() {
        return this.toString();
    }

    private static int wordNumber(int bit) {
        return bit >> 6;
    }
}

