/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.misc;

import java.util.AbstractList;
import org.antlr.misc.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntArrayList
extends AbstractList<Integer>
implements Cloneable {
    private static final int DEFAULT_CAPACITY = 10;
    protected int n = 0;
    protected int[] elements = null;

    public IntArrayList() {
        this(10);
    }

    public IntArrayList(int initialCapacity) {
        this.elements = new int[initialCapacity];
    }

    @Override
    public int set(int i15, int newValue) {
        if (i15 >= this.n) {
            this.setSize(i15);
        }
        int v15 = this.elements[i15];
        this.elements[i15] = newValue;
        return v15;
    }

    @Override
    public boolean add(int o15) {
        if (this.n >= this.elements.length) {
            this.grow();
        }
        this.elements[this.n] = o15;
        ++this.n;
        return true;
    }

    public void setSize(int newSize) {
        if (newSize >= this.elements.length) {
            this.ensureCapacity(newSize);
        }
        this.n = newSize;
    }

    protected void grow() {
        this.ensureCapacity(this.elements.length * 3 / 2 + 1);
    }

    public boolean contains(int v15) {
        for (int i15 = 0; i15 < this.n; ++i15) {
            int element = this.elements[i15];
            if (element != v15) continue;
            return true;
        }
        return false;
    }

    public void ensureCapacity(int newCapacity) {
        int oldCapacity = this.elements.length;
        if (this.n >= oldCapacity) {
            int[] oldData = this.elements;
            this.elements = new int[newCapacity];
            System.arraycopy(oldData, 0, this.elements, 0, this.n);
        }
    }

    @Override
    public Integer get(int i15) {
        return Utils.integer(this.element(i15));
    }

    public int element(int i15) {
        return this.elements[i15];
    }

    public int[] elements() {
        int[] a15 = new int[this.n];
        System.arraycopy(this.elements, 0, a15, 0, this.n);
        return a15;
    }

    @Override
    public int size() {
        return this.n;
    }

    public int capacity() {
        return this.elements.length;
    }

    @Override
    public boolean equals(Object o15) {
        if (o15 == null) {
            return false;
        }
        IntArrayList other = (IntArrayList)o15;
        if (this.size() != other.size()) {
            return false;
        }
        for (int i15 = 0; i15 < this.n; ++i15) {
            if (this.elements[i15] == other.elements[i15]) continue;
            return false;
        }
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        IntArrayList a15 = (IntArrayList)super.clone();
        a15.n = this.n;
        System.arraycopy(this.elements, 0, a15.elements, 0, this.elements.length);
        return a15;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (int i15 = 0; i15 < this.n; ++i15) {
            if (i15 > 0) {
                buf.append(", ");
            }
            buf.append(this.elements[i15]);
        }
        return buf.toString();
    }
}

