/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime.debug;

import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.debug.DebugEventListener;
import org.antlr.runtime.tree.TreeAdaptor;

public class DebugTreeAdaptor
implements TreeAdaptor {
    protected DebugEventListener dbg;
    protected TreeAdaptor adaptor;

    public DebugTreeAdaptor(DebugEventListener dbg, TreeAdaptor adaptor) {
        this.dbg = dbg;
        this.adaptor = adaptor;
    }

    public Object create(Token payload) {
        if (payload.getTokenIndex() < 0) {
            return this.create(payload.getType(), payload.getText());
        }
        Object node = this.adaptor.create(payload);
        this.dbg.createNode(node, payload);
        return node;
    }

    public Object errorNode(TokenStream input, Token start, Token stop, RecognitionException e15) {
        Object node = this.adaptor.errorNode(input, start, stop, e15);
        if (node != null) {
            this.dbg.errorNode(node);
        }
        return node;
    }

    public Object dupTree(Object tree) {
        Object t15 = this.adaptor.dupTree(tree);
        this.simulateTreeConstruction(t15);
        return t15;
    }

    protected void simulateTreeConstruction(Object t15) {
        this.dbg.createNode(t15);
        int n15 = this.adaptor.getChildCount(t15);
        for (int i15 = 0; i15 < n15; ++i15) {
            Object child = this.adaptor.getChild(t15, i15);
            this.simulateTreeConstruction(child);
            this.dbg.addChild(t15, child);
        }
    }

    public Object dupNode(Object treeNode) {
        Object d15 = this.adaptor.dupNode(treeNode);
        this.dbg.createNode(d15);
        return d15;
    }

    public Object nil() {
        Object node = this.adaptor.nil();
        this.dbg.nilNode(node);
        return node;
    }

    public boolean isNil(Object tree) {
        return this.adaptor.isNil(tree);
    }

    public void addChild(Object t15, Object child) {
        if (t15 == null || child == null) {
            return;
        }
        this.adaptor.addChild(t15, child);
        this.dbg.addChild(t15, child);
    }

    public Object becomeRoot(Object newRoot, Object oldRoot) {
        Object n15 = this.adaptor.becomeRoot(newRoot, oldRoot);
        this.dbg.becomeRoot(newRoot, oldRoot);
        return n15;
    }

    public Object rulePostProcessing(Object root) {
        return this.adaptor.rulePostProcessing(root);
    }

    public void addChild(Object t15, Token child) {
        Object n15 = this.create(child);
        this.addChild(t15, n15);
    }

    public Object becomeRoot(Token newRoot, Object oldRoot) {
        Object n15 = this.create(newRoot);
        this.adaptor.becomeRoot(n15, oldRoot);
        this.dbg.becomeRoot(newRoot, oldRoot);
        return n15;
    }

    public Object create(int tokenType, Token fromToken) {
        Object node = this.adaptor.create(tokenType, fromToken);
        this.dbg.createNode(node);
        return node;
    }

    public Object create(int tokenType, Token fromToken, String text) {
        Object node = this.adaptor.create(tokenType, fromToken, text);
        this.dbg.createNode(node);
        return node;
    }

    public Object create(int tokenType, String text) {
        Object node = this.adaptor.create(tokenType, text);
        this.dbg.createNode(node);
        return node;
    }

    public int getType(Object t15) {
        return this.adaptor.getType(t15);
    }

    public void setType(Object t15, int type) {
        this.adaptor.setType(t15, type);
    }

    public String getText(Object t15) {
        return this.adaptor.getText(t15);
    }

    public void setText(Object t15, String text) {
        this.adaptor.setText(t15, text);
    }

    public Token getToken(Object t15) {
        return this.adaptor.getToken(t15);
    }

    public void setTokenBoundaries(Object t15, Token startToken, Token stopToken) {
        this.adaptor.setTokenBoundaries(t15, startToken, stopToken);
        if (t15 != null && startToken != null && stopToken != null) {
            this.dbg.setTokenBoundaries(t15, startToken.getTokenIndex(), stopToken.getTokenIndex());
        }
    }

    public int getTokenStartIndex(Object t15) {
        return this.adaptor.getTokenStartIndex(t15);
    }

    public int getTokenStopIndex(Object t15) {
        return this.adaptor.getTokenStopIndex(t15);
    }

    public Object getChild(Object t15, int i15) {
        return this.adaptor.getChild(t15, i15);
    }

    public void setChild(Object t15, int i15, Object child) {
        this.adaptor.setChild(t15, i15, child);
    }

    public Object deleteChild(Object t15, int i15) {
        return this.deleteChild(t15, i15);
    }

    public int getChildCount(Object t15) {
        return this.adaptor.getChildCount(t15);
    }

    public int getUniqueID(Object node) {
        return this.adaptor.getUniqueID(node);
    }

    public Object getParent(Object t15) {
        return this.adaptor.getParent(t15);
    }

    public int getChildIndex(Object t15) {
        return this.adaptor.getChildIndex(t15);
    }

    public void setParent(Object t15, Object parent) {
        this.adaptor.setParent(t15, parent);
    }

    public void setChildIndex(Object t15, int index) {
        this.adaptor.setChildIndex(t15, index);
    }

    public void replaceChildren(Object parent, int startChildIndex, int stopChildIndex, Object t15) {
        this.adaptor.replaceChildren(parent, startChildIndex, stopChildIndex, t15);
    }

    public DebugEventListener getDebugListener() {
        return this.dbg;
    }

    public void setDebugListener(DebugEventListener dbg) {
        this.dbg = dbg;
    }

    public TreeAdaptor getTreeAdaptor() {
        return this.adaptor;
    }
}

