/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime.debug;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.antlr.runtime.IntStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.debug.BlankDebugEventListener;
import org.antlr.runtime.debug.DebugParser;
import org.antlr.runtime.misc.DoubleKeyMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Profiler
extends BlankDebugEventListener {
    public static final String DATA_SEP = "\t";
    public static final String newline = System.getProperty("line.separator");
    static boolean dump = false;
    public static final String Version = "3";
    public static final String RUNTIME_STATS_FILENAME = "runtime.stats";
    public DebugParser parser = null;
    protected int ruleLevel = 0;
    protected Token lastRealTokenTouchedInDecision;
    protected Set<String> uniqueRules = new HashSet<String>();
    protected Stack<String> currentGrammarFileName = new Stack();
    protected Stack<String> currentRuleName = new Stack();
    protected Stack<Integer> currentLine = new Stack();
    protected Stack<Integer> currentPos = new Stack();
    protected DoubleKeyMap<String, Integer, DecisionDescriptor> decisions = new DoubleKeyMap();
    protected List<DecisionEvent> decisionEvents = new ArrayList<DecisionEvent>();
    protected Stack<DecisionEvent> decisionStack = new Stack();
    protected int backtrackDepth;
    ProfileStats stats = new ProfileStats();

    public Profiler() {
    }

    public Profiler(DebugParser parser) {
        this.parser = parser;
    }

    @Override
    public void enterRule(String grammarFileName, String ruleName) {
        ++this.ruleLevel;
        ++this.stats.numRuleInvocations;
        this.uniqueRules.add(grammarFileName + ":" + ruleName);
        this.stats.maxRuleInvocationDepth = Math.max(this.stats.maxRuleInvocationDepth, this.ruleLevel);
        this.currentGrammarFileName.push(grammarFileName);
        this.currentRuleName.push(ruleName);
    }

    @Override
    public void exitRule(String grammarFileName, String ruleName) {
        --this.ruleLevel;
        this.currentGrammarFileName.pop();
        this.currentRuleName.pop();
    }

    public void examineRuleMemoization(IntStream input, int ruleIndex, int stopIndex, String ruleName) {
        if (dump) {
            System.out.println("examine memo " + ruleName + " at " + input.index() + ": " + stopIndex);
        }
        if (stopIndex == -1) {
            ++this.stats.numMemoizationCacheMisses;
            ++this.stats.numGuessingRuleInvocations;
            ++this.currentDecision().numMemoizationCacheMisses;
        } else {
            ++this.stats.numMemoizationCacheHits;
            ++this.currentDecision().numMemoizationCacheHits;
        }
    }

    public void memoize(IntStream input, int ruleIndex, int ruleStartIndex, String ruleName) {
        if (dump) {
            System.out.println("memoize " + ruleName);
        }
        ++this.stats.numMemoizationCacheEntries;
    }

    @Override
    public void location(int line, int pos) {
        this.currentLine.push(line);
        this.currentPos.push(pos);
    }

    @Override
    public void enterDecision(int decisionNumber, boolean couldBacktrack) {
        String g15;
        DecisionDescriptor descriptor2;
        this.lastRealTokenTouchedInDecision = null;
        ++this.stats.numDecisionEvents;
        int startingLookaheadIndex = this.parser.getTokenStream().index();
        TokenStream input = this.parser.getTokenStream();
        if (dump) {
            System.out.println("enterDecision canBacktrack=" + couldBacktrack + " " + decisionNumber + " backtrack depth " + this.backtrackDepth + " @ " + input.get(input.index()) + " rule " + this.locationDescription());
        }
        if ((descriptor2 = this.decisions.get(g15 = this.currentGrammarFileName.peek(), decisionNumber)) == null) {
            descriptor2 = new DecisionDescriptor();
            this.decisions.put(g15, decisionNumber, descriptor2);
            descriptor2.decision = decisionNumber;
            descriptor2.fileName = this.currentGrammarFileName.peek();
            descriptor2.ruleName = this.currentRuleName.peek();
            descriptor2.line = this.currentLine.peek();
            descriptor2.pos = this.currentPos.peek();
            descriptor2.couldBacktrack = couldBacktrack;
        }
        ++descriptor2.n;
        DecisionEvent d15 = new DecisionEvent();
        this.decisionStack.push(d15);
        d15.decision = descriptor2;
        d15.startTime = System.currentTimeMillis();
        d15.startIndex = startingLookaheadIndex;
    }

    @Override
    public void exitDecision(int decisionNumber) {
        int depth;
        DecisionEvent d15 = this.decisionStack.pop();
        d15.stopTime = System.currentTimeMillis();
        int lastTokenIndex = this.lastRealTokenTouchedInDecision.getTokenIndex();
        int numHidden = this.getNumberOfHiddenTokens(d15.startIndex, lastTokenIndex);
        d15.k = depth = lastTokenIndex - d15.startIndex - numHidden + 1;
        d15.decision.maxk = Math.max(d15.decision.maxk, depth);
        if (dump) {
            System.out.println("exitDecision " + decisionNumber + " in " + d15.decision.ruleName + " lookahead " + d15.k + " max token " + this.lastRealTokenTouchedInDecision);
        }
        this.decisionEvents.add(d15);
    }

    @Override
    public void consumeToken(Token token) {
        if (dump) {
            System.out.println("consume token " + token);
        }
        if (!this.inDecision()) {
            ++this.stats.numTokens;
            return;
        }
        if (this.lastRealTokenTouchedInDecision == null || this.lastRealTokenTouchedInDecision.getTokenIndex() < token.getTokenIndex()) {
            this.lastRealTokenTouchedInDecision = token;
        }
        DecisionEvent d15 = this.currentDecision();
        int thisRefIndex = token.getTokenIndex();
        int numHidden = this.getNumberOfHiddenTokens(d15.startIndex, thisRefIndex);
        int depth = thisRefIndex - d15.startIndex - numHidden + 1;
        if (dump) {
            System.out.println("consume " + thisRefIndex + " " + depth + " tokens ahead in " + d15.decision.ruleName + "-" + d15.decision.decision + " start index " + d15.startIndex);
        }
    }

    public boolean inDecision() {
        return this.decisionStack.size() > 0;
    }

    @Override
    public void consumeHiddenToken(Token token) {
        if (!this.inDecision()) {
            ++this.stats.numHiddenTokens;
        }
    }

    @Override
    public void LT(int i15, Token t15) {
        if (this.inDecision() && i15 > 0) {
            DecisionEvent d15 = this.currentDecision();
            if (dump) {
                System.out.println("LT(" + i15 + ")=" + t15 + " index " + t15.getTokenIndex() + " relative to " + d15.decision.ruleName + "-" + d15.decision.decision + " start index " + d15.startIndex);
            }
            if (this.lastRealTokenTouchedInDecision == null || this.lastRealTokenTouchedInDecision.getTokenIndex() < t15.getTokenIndex()) {
                this.lastRealTokenTouchedInDecision = t15;
                if (dump) {
                    System.out.println("set last token " + this.lastRealTokenTouchedInDecision);
                }
            }
        }
    }

    @Override
    public void beginBacktrack(int level) {
        if (dump) {
            System.out.println("enter backtrack " + level);
        }
        ++this.backtrackDepth;
        DecisionEvent e15 = this.currentDecision();
        if (e15.decision.couldBacktrack) {
            ++this.stats.numBacktrackOccurrences;
            ++e15.decision.numBacktrackOccurrences;
            e15.backtracks = true;
        }
    }

    @Override
    public void endBacktrack(int level, boolean successful) {
        if (dump) {
            System.out.println("exit backtrack " + level + ": " + successful);
        }
        --this.backtrackDepth;
    }

    @Override
    public void mark(int i15) {
        if (dump) {
            System.out.println("mark " + i15);
        }
    }

    @Override
    public void rewind(int i15) {
        if (dump) {
            System.out.println("rewind " + i15);
        }
    }

    @Override
    public void rewind() {
        if (dump) {
            System.out.println("rewind");
        }
    }

    protected DecisionEvent currentDecision() {
        return this.decisionStack.peek();
    }

    @Override
    public void recognitionException(RecognitionException e15) {
        ++this.stats.numReportedErrors;
    }

    @Override
    public void semanticPredicate(boolean result, String predicate) {
        ++this.stats.numSemanticPredicates;
        if (this.inDecision()) {
            DecisionEvent d15 = this.currentDecision();
            d15.evalSemPred = true;
            ++d15.decision.numSemPredEvals;
            if (dump) {
                System.out.println("eval " + predicate + " in " + d15.decision.ruleName + "-" + d15.decision.decision);
            }
        }
    }

    @Override
    public void terminate() {
        for (DecisionEvent e15 : this.decisionEvents) {
            e15.decision.avgk += (float)e15.k;
            this.stats.avgkPerDecisionEvent += (float)e15.k;
            if (!e15.backtracks) continue;
            this.stats.avgkPerBacktrackingDecisionEvent += (float)e15.k;
        }
        this.stats.averageDecisionPercentBacktracks = 0.0f;
        for (DecisionDescriptor d15 : this.decisions.values()) {
            ++this.stats.numDecisionsCovered;
            d15.avgk = (float)((double)d15.avgk / (double)d15.n);
            if (d15.couldBacktrack) {
                ++this.stats.numDecisionsThatPotentiallyBacktrack;
                float percentBacktracks = (float)d15.numBacktrackOccurrences / (float)d15.n;
                this.stats.averageDecisionPercentBacktracks += percentBacktracks;
            }
            if (d15.numBacktrackOccurrences <= 0) continue;
            ++this.stats.numDecisionsThatDoBacktrack;
        }
        this.stats.averageDecisionPercentBacktracks /= (float)this.stats.numDecisionsThatPotentiallyBacktrack;
        this.stats.averageDecisionPercentBacktracks *= 100.0f;
        this.stats.avgkPerDecisionEvent /= (float)this.stats.numDecisionEvents;
        this.stats.avgkPerBacktrackingDecisionEvent = (float)((double)this.stats.avgkPerBacktrackingDecisionEvent / (double)this.stats.numBacktrackOccurrences);
        System.err.println(this.toString());
        System.err.println(this.getDecisionStatsDump());
    }

    public void setParser(DebugParser parser) {
        this.parser = parser;
    }

    public String toNotifyString() {
        StringBuilder buf = new StringBuilder();
        buf.append(Version);
        buf.append('\t');
        buf.append(this.parser.getClass().getName());
        return buf.toString();
    }

    public String toString() {
        return Profiler.toString(this.getReport());
    }

    public ProfileStats getReport() {
        this.stats.Version = Version;
        this.stats.name = this.parser.getClass().getName();
        this.stats.numUniqueRulesInvoked = this.uniqueRules.size();
        return this.stats;
    }

    public DoubleKeyMap<String, Integer, DecisionDescriptor> getDecisionStats() {
        return this.decisions;
    }

    public List<DecisionEvent> getDecisionEvents() {
        return this.decisionEvents;
    }

    public static String toString(ProfileStats stats) {
        StringBuilder buf = new StringBuilder();
        buf.append("ANTLR Runtime Report; Profile Version ");
        buf.append(stats.Version);
        buf.append(newline);
        buf.append("parser name ");
        buf.append(stats.name);
        buf.append(newline);
        buf.append("Number of rule invocations ");
        buf.append(stats.numRuleInvocations);
        buf.append(newline);
        buf.append("Number of unique rules visited ");
        buf.append(stats.numUniqueRulesInvoked);
        buf.append(newline);
        buf.append("Number of decision events ");
        buf.append(stats.numDecisionEvents);
        buf.append(newline);
        buf.append("Overall average k per decision event ");
        buf.append(stats.avgkPerDecisionEvent);
        buf.append(newline);
        buf.append("Number of backtracking occurrences (can be multiple per decision) ");
        buf.append(stats.numBacktrackOccurrences);
        buf.append(newline);
        buf.append("Overall average k per decision event that backtracks ");
        buf.append(stats.avgkPerBacktrackingDecisionEvent);
        buf.append(newline);
        buf.append("Number of rule invocations while backtracking ");
        buf.append(stats.numGuessingRuleInvocations);
        buf.append(newline);
        buf.append("num decisions that potentially backtrack ");
        buf.append(stats.numDecisionsThatPotentiallyBacktrack);
        buf.append(newline);
        buf.append("num decisions that do backtrack ");
        buf.append(stats.numDecisionsThatDoBacktrack);
        buf.append(newline);
        buf.append("num decisions that potentially backtrack but don't ");
        buf.append(stats.numDecisionsThatPotentiallyBacktrack - stats.numDecisionsThatDoBacktrack);
        buf.append(newline);
        buf.append("average % of time a potentially backtracking decision backtracks ");
        buf.append(stats.averageDecisionPercentBacktracks);
        buf.append(newline);
        buf.append("num unique decisions covered ");
        buf.append(stats.numDecisionsCovered);
        buf.append(newline);
        buf.append("max rule invocation nesting depth ");
        buf.append(stats.maxRuleInvocationDepth);
        buf.append(newline);
        buf.append("rule memoization cache size ");
        buf.append(stats.numMemoizationCacheEntries);
        buf.append(newline);
        buf.append("number of rule memoization cache hits ");
        buf.append(stats.numMemoizationCacheHits);
        buf.append(newline);
        buf.append("number of rule memoization cache misses ");
        buf.append(stats.numMemoizationCacheMisses);
        buf.append(newline);
        buf.append("number of tokens ");
        buf.append(stats.numTokens);
        buf.append(newline);
        buf.append("number of hidden tokens ");
        buf.append(stats.numHiddenTokens);
        buf.append(newline);
        buf.append("number of char ");
        buf.append(stats.numCharsMatched);
        buf.append(newline);
        buf.append("number of hidden char ");
        buf.append(stats.numHiddenCharsMatched);
        buf.append(newline);
        buf.append("number of syntax errors ");
        buf.append(stats.numReportedErrors);
        buf.append(newline);
        return buf.toString();
    }

    public String getDecisionStatsDump() {
        StringBuilder buf = new StringBuilder();
        buf.append("location");
        buf.append(DATA_SEP);
        buf.append("n");
        buf.append(DATA_SEP);
        buf.append("avgk");
        buf.append(DATA_SEP);
        buf.append("maxk");
        buf.append(DATA_SEP);
        buf.append("synpred");
        buf.append(DATA_SEP);
        buf.append("sempred");
        buf.append(DATA_SEP);
        buf.append("canbacktrack");
        buf.append("\n");
        for (String fileName : this.decisions.keySet()) {
            for (int d15 : this.decisions.keySet(fileName)) {
                DecisionDescriptor s15 = this.decisions.get(fileName, d15);
                buf.append(s15.decision);
                buf.append("@");
                buf.append(this.locationDescription(s15.fileName, s15.ruleName, s15.line, s15.pos));
                buf.append(DATA_SEP);
                buf.append(s15.n);
                buf.append(DATA_SEP);
                buf.append(String.format("%.2f", Float.valueOf(s15.avgk)));
                buf.append(DATA_SEP);
                buf.append(s15.maxk);
                buf.append(DATA_SEP);
                buf.append(s15.numBacktrackOccurrences);
                buf.append(DATA_SEP);
                buf.append(s15.numSemPredEvals);
                buf.append(DATA_SEP);
                buf.append(s15.couldBacktrack ? "1" : "0");
                buf.append(newline);
            }
        }
        return buf.toString();
    }

    protected int[] trim(int[] X11, int n15) {
        if (n15 < X11.length) {
            int[] trimmed = new int[n15];
            System.arraycopy(X11, 0, trimmed, 0, n15);
            X11 = trimmed;
        }
        return X11;
    }

    protected int[] toArray(List<Integer> a15) {
        int[] x15 = new int[a15.size()];
        for (int i15 = 0; i15 < a15.size(); ++i15) {
            Integer I11 = a15.get(i15);
            x15[i15] = I11;
        }
        return x15;
    }

    public int getNumberOfHiddenTokens(int i15, int j15) {
        int n15 = 0;
        TokenStream input = this.parser.getTokenStream();
        for (int ti4 = i15; ti4 < input.size() && ti4 <= j15; ++ti4) {
            Token t15 = input.get(ti4);
            if (t15.getChannel() == 0) continue;
            ++n15;
        }
        return n15;
    }

    protected String locationDescription() {
        return this.locationDescription(this.currentGrammarFileName.peek(), this.currentRuleName.peek(), this.currentLine.peek(), this.currentPos.peek());
    }

    protected String locationDescription(String file2, String rule, int line, int pos) {
        return file2 + ":" + line + ":" + pos + "(" + rule + ")";
    }

    public static class DecisionEvent {
        public DecisionDescriptor decision;
        public int startIndex;
        public int k;
        public boolean backtracks;
        public boolean evalSemPred;
        public long startTime;
        public long stopTime;
        public int numMemoizationCacheHits;
        public int numMemoizationCacheMisses;
    }

    public static class DecisionDescriptor {
        public int decision;
        public String fileName;
        public String ruleName;
        public int line;
        public int pos;
        public boolean couldBacktrack;
        public int n;
        public float avgk;
        public int maxk;
        public int numBacktrackOccurrences;
        public int numSemPredEvals;
    }

    public static class ProfileStats {
        public String Version;
        public String name;
        public int numRuleInvocations;
        public int numUniqueRulesInvoked;
        public int numDecisionEvents;
        public int numDecisionsCovered;
        public int numDecisionsThatPotentiallyBacktrack;
        public int numDecisionsThatDoBacktrack;
        public int maxRuleInvocationDepth;
        public float avgkPerDecisionEvent;
        public float avgkPerBacktrackingDecisionEvent;
        public float averageDecisionPercentBacktracks;
        public int numBacktrackOccurrences;
        public int numFixedDecisions;
        public int minDecisionMaxFixedLookaheads;
        public int maxDecisionMaxFixedLookaheads;
        public int avgDecisionMaxFixedLookaheads;
        public int stddevDecisionMaxFixedLookaheads;
        public int numCyclicDecisions;
        public int minDecisionMaxCyclicLookaheads;
        public int maxDecisionMaxCyclicLookaheads;
        public int avgDecisionMaxCyclicLookaheads;
        public int stddevDecisionMaxCyclicLookaheads;
        public int numSemanticPredicates;
        public int numTokens;
        public int numHiddenTokens;
        public int numCharsMatched;
        public int numHiddenCharsMatched;
        public int numReportedErrors;
        public int numMemoizationCacheHits;
        public int numMemoizationCacheMisses;
        public int numGuessingRuleInvocations;
        public int numMemoizationCacheEntries;
    }
}

