/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.file.PathVisitor;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.function.IOSupplier;

public abstract class AbstractFileFilter
implements IOFileFilter,
PathVisitor {
    private final FileVisitResult onAccept;
    private final FileVisitResult onReject;

    static FileVisitResult toDefaultFileVisitResult(boolean accept) {
        return accept ? FileVisitResult.CONTINUE : FileVisitResult.TERMINATE;
    }

    public AbstractFileFilter() {
        this(FileVisitResult.CONTINUE, FileVisitResult.TERMINATE);
    }

    protected AbstractFileFilter(FileVisitResult onAccept, FileVisitResult onReject) {
        this.onAccept = onAccept;
        this.onReject = onReject;
    }

    @Override
    public boolean accept(File file2) {
        Objects.requireNonNull(file2, "file");
        return this.accept(file2.getParentFile(), file2.getName());
    }

    @Override
    public boolean accept(File dir, String name) {
        Objects.requireNonNull(name, "name");
        return this.accept(new File(dir, name));
    }

    void append(List<?> list2, StringBuilder buffer) {
        for (int i15 = 0; i15 < list2.size(); ++i15) {
            if (i15 > 0) {
                buffer.append(",");
            }
            buffer.append(list2.get(i15));
        }
    }

    void append(Object[] array, StringBuilder buffer) {
        for (int i15 = 0; i15 < array.length; ++i15) {
            if (i15 > 0) {
                buffer.append(",");
            }
            buffer.append(array[i15]);
        }
    }

    FileVisitResult get(IOSupplier<FileVisitResult> supplier) {
        try {
            return supplier.get();
        }
        catch (IOException e15) {
            return this.handle(e15);
        }
    }

    protected FileVisitResult handle(Throwable t15) {
        return FileVisitResult.TERMINATE;
    }

    boolean isDirectory(File file2) {
        return file2 != null && file2.isDirectory();
    }

    boolean isFile(File file2) {
        return file2 != null && file2.isFile();
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attributes) throws IOException {
        return this.accept(dir, attributes);
    }

    FileVisitResult toFileVisitResult(boolean accept) {
        return accept ? this.onAccept : this.onReject;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public FileVisitResult visitFile(Path file2, BasicFileAttributes attributes) throws IOException {
        return this.accept(file2, attributes);
    }

    @Override
    public FileVisitResult visitFileFailed(Path file2, IOException exc) throws IOException {
        return FileVisitResult.CONTINUE;
    }
}

