/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.basic;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.bined.CodeAreaCaretPosition;
import org.exbin.bined.CodeType;
import org.exbin.bined.DataProvider;
import org.exbin.bined.RowWrappingMode;
import org.exbin.bined.basic.BasicCodeAreaLayout;
import org.exbin.bined.basic.CodeAreaViewMode;
import org.exbin.bined.basic.MovementDirection;
import org.exbin.bined.capability.CodeTypeCapable;
import org.exbin.bined.capability.RowWrappingCapable;
import org.exbin.bined.capability.ViewModeCapable;

@ParametersAreNonnullByDefault
public class BasicCodeAreaStructure {
    protected final BasicCodeAreaLayout layout = new BasicCodeAreaLayout();
    @Nonnull
    protected CodeAreaViewMode viewMode = CodeAreaViewMode.DUAL;
    @Nonnull
    protected CodeType codeType = CodeType.HEXADECIMAL;
    protected long dataSize;
    @Nonnull
    protected RowWrappingMode rowWrapping = RowWrappingMode.NO_WRAPPING;
    protected int maxBytesPerLine;
    protected int wrappingBytesGroupSize;
    protected long rowsPerDocument;
    protected int bytesPerRow;
    protected int charactersPerRow;

    public void updateCache(DataProvider codeArea, int charactersPerPage) {
        this.viewMode = ((ViewModeCapable)((Object)codeArea)).getViewMode();
        this.codeType = ((CodeTypeCapable)((Object)codeArea)).getCodeType();
        this.dataSize = codeArea.getDataSize();
        this.rowWrapping = ((RowWrappingCapable)((Object)codeArea)).getRowWrapping();
        this.maxBytesPerLine = ((RowWrappingCapable)((Object)codeArea)).getMaxBytesPerRow();
        this.wrappingBytesGroupSize = ((RowWrappingCapable)((Object)codeArea)).getWrappingBytesGroupSize();
        this.bytesPerRow = this.layout.computeBytesPerRow(this, charactersPerPage);
        this.charactersPerRow = this.layout.computeCharactersPerRow(this);
        this.rowsPerDocument = this.layout.computeRowsPerDocument(this);
    }

    public int computePositionByte(int rowCharPosition) {
        return this.layout.computePositionByte(this, rowCharPosition);
    }

    public int computeFirstCodeCharacterPos(int byteOffset) {
        return this.layout.computeFirstCodeCharacterPos(this, byteOffset);
    }

    @Nonnull
    public CodeAreaCaretPosition computeMovePosition(CodeAreaCaretPosition position, MovementDirection direction, int rowsPerPage) {
        return this.layout.computeMovePosition(this, position, direction, rowsPerPage);
    }

    @Nonnull
    public CodeAreaViewMode getViewMode() {
        return this.viewMode;
    }

    @Nonnull
    public CodeType getCodeType() {
        return this.codeType;
    }

    public long getDataSize() {
        return this.dataSize;
    }

    @Nonnull
    public RowWrappingMode getRowWrapping() {
        return this.rowWrapping;
    }

    public int getMaxBytesPerLine() {
        return this.maxBytesPerLine;
    }

    public int getWrappingBytesGroupSize() {
        return this.wrappingBytesGroupSize;
    }

    public long getRowsPerDocument() {
        return this.rowsPerDocument;
    }

    public int getBytesPerRow() {
        return this.bytesPerRow;
    }

    public int getCharactersPerRow() {
        return this.charactersPerRow;
    }
}

