/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.event.ActionEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import org.fife.ui.rsyntaxtextarea.AbstractJFlexTokenMaker;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaEditorKit;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rtextarea.RTextArea;

public abstract class AbstractJFlexCTokenMaker
extends AbstractJFlexTokenMaker {
    private final Action INSERT_BREAK_ACTION = this.createInsertBreakAction();
    private static final Pattern MLC_PATTERN = Pattern.compile("([ \\t]*)(/?[\\*]+)([ \\t]*)");

    protected AbstractJFlexCTokenMaker() {
    }

    protected Action createInsertBreakAction() {
        return new CStyleInsertBreakAction();
    }

    @Override
    public boolean getCurlyBracesDenoteCodeBlocks(int languageIndex) {
        return true;
    }

    @Override
    public Action getInsertBreakAction() {
        return this.INSERT_BREAK_ACTION;
    }

    @Override
    public boolean getMarkOccurrencesOfTokenType(int type) {
        return type == 20 || type == 8;
    }

    @Override
    public boolean getShouldIndentNextLineAfter(Token t15) {
        if (t15 != null && t15.length() == 1) {
            char ch4 = t15.charAt(0);
            return ch4 == '{' || ch4 == '(';
        }
        return false;
    }

    private boolean isInternalEolTokenForMLCs(Token t15) {
        int type = t15.getType();
        if (type < 0) {
            return (type = this.getClosestStandardTokenTypeForInternalType(type)) == 2 || type == 3;
        }
        return false;
    }

    protected class CStyleInsertBreakAction
    extends RSyntaxTextAreaEditorKit.InsertBreakAction {
        protected CStyleInsertBreakAction() {
        }

        @Override
        public void actionPerformedImpl(ActionEvent e15, RTextArea textArea) {
            int line;
            if (!textArea.isEditable() || !textArea.isEnabled()) {
                UIManager.getLookAndFeel().provideErrorFeedback(textArea);
                return;
            }
            RSyntaxTextArea rsta = (RSyntaxTextArea)this.getTextComponent(e15);
            RSyntaxDocument doc = (RSyntaxDocument)rsta.getDocument();
            int type = doc.getLastTokenTypeOnLine(line = textArea.getCaretLineNumber());
            if (type < 0) {
                type = doc.getClosestStandardTokenTypeForInternalType(type);
            }
            if (type == 3 || type == 2) {
                this.insertBreakInMLC(e15, rsta, line);
            } else {
                this.handleInsertBreak(rsta, true);
            }
        }

        private boolean appearsNested(RSyntaxTextArea textArea, int line, int offs) {
            int firstLine = line;
            while (line < textArea.getLineCount()) {
                int i15;
                Token t15 = textArea.getTokenListForLine(line);
                if (line++ == firstLine) {
                    if ((t15 = RSyntaxUtilities.getTokenAtOffset(t15, offs)) == null) continue;
                    i15 = t15.documentToToken(offs);
                } else {
                    i15 = t15.getTextOffset();
                }
                int textOffset = t15.getTextOffset();
                while (i15 < textOffset + t15.length() - 1) {
                    if (t15.charAt(i15 - textOffset) == '/' && t15.charAt(i15 - textOffset + 1) == '*') {
                        return true;
                    }
                    ++i15;
                }
                if ((t15 = t15.getNextToken()) == null || AbstractJFlexCTokenMaker.this.isInternalEolTokenForMLCs(t15)) continue;
                return false;
            }
            return true;
        }

        private void insertBreakInMLC(ActionEvent e15, RSyntaxTextArea textArea, int line) {
            Matcher m15;
            String text;
            int end;
            int start;
            try {
                start = textArea.getLineStartOffset(line);
                end = textArea.getLineEndOffset(line);
                text = textArea.getText(start, end - start);
                m15 = MLC_PATTERN.matcher(text);
            }
            catch (BadLocationException ble) {
                UIManager.getLookAndFeel().provideErrorFeedback(textArea);
                ble.printStackTrace();
                return;
            }
            if (m15.lookingAt()) {
                String leadingWS = m15.group(1);
                String mlcMarker = m15.group(2);
                int dot = textArea.getCaretPosition();
                if (dot >= start && dot < start + leadingWS.length() + mlcMarker.length()) {
                    if (mlcMarker.charAt(0) == '/') {
                        this.handleInsertBreak(textArea, true);
                        return;
                    }
                    textArea.setCaretPosition(end - 1);
                } else {
                    boolean moved = false;
                    while (dot < end - 1 && Character.isWhitespace(text.charAt(dot - start))) {
                        moved = true;
                        ++dot;
                    }
                    if (moved) {
                        textArea.setCaretPosition(dot);
                    }
                }
                boolean firstMlcLine = mlcMarker.charAt(0) == '/';
                boolean nested = this.appearsNested(textArea, line, start + leadingWS.length() + 2);
                String header = leadingWS + (firstMlcLine ? " * " : "*") + m15.group(3);
                textArea.replaceSelection("\n" + header);
                if (nested) {
                    dot = textArea.getCaretPosition();
                    textArea.insert("\n" + leadingWS + (firstMlcLine ? " " : "") + "*/", dot);
                    textArea.setCaretPosition(dot);
                }
            } else {
                this.handleInsertBreak(textArea, true);
            }
        }
    }
}

