/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.Icon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.folding.FoldManager;
import org.fife.ui.rtextarea.IconRowHeader;

public class FoldingAwareIconRowHeader
extends IconRowHeader {
    public FoldingAwareIconRowHeader(RSyntaxTextArea textArea) {
        super(textArea);
    }

    @Override
    protected void paintComponent(Graphics g15) {
        if (this.textArea == null) {
            return;
        }
        RSyntaxTextArea rsta = (RSyntaxTextArea)this.textArea;
        FoldManager fm4 = rsta.getFoldManager();
        if (!fm4.isCodeFoldingSupportedAndEnabled()) {
            super.paintComponent(g15);
            return;
        }
        this.visibleRect = g15.getClipBounds(this.visibleRect);
        if (this.visibleRect == null) {
            this.visibleRect = this.getVisibleRect();
        }
        if (this.visibleRect == null) {
            return;
        }
        this.paintBackgroundImpl(g15, this.visibleRect);
        if (this.textArea.getLineWrap()) {
            this.paintComponentWrapped(g15);
            return;
        }
        Document doc = this.textArea.getDocument();
        Element root = doc.getDefaultRootElement();
        this.textAreaInsets = this.textArea.getInsets(this.textAreaInsets);
        if (this.visibleRect.y < this.textAreaInsets.top) {
            this.visibleRect.height -= this.textAreaInsets.top - this.visibleRect.y;
            this.visibleRect.y = this.textAreaInsets.top;
        }
        int cellHeight = this.textArea.getLineHeight();
        int topLine = (this.visibleRect.y - this.textAreaInsets.top) / cellHeight;
        int y15 = topLine * cellHeight + this.textAreaInsets.top;
        topLine += fm4.getHiddenLineCountAbove(topLine, true);
        if (this.activeLineRangeStart > -1 && this.activeLineRangeEnd > -1) {
            Color activeLineRangeColor = this.getActiveLineRangeColor();
            g15.setColor(activeLineRangeColor);
            try {
                int realY1 = rsta.yForLine(this.activeLineRangeStart);
                if (realY1 > -1) {
                    int y16 = realY1;
                    int y25 = rsta.yForLine(this.activeLineRangeEnd);
                    if (y25 == -1) {
                        y25 = y16;
                    }
                    if ((y25 += cellHeight - 1) < this.visibleRect.y || y16 > this.visibleRect.y + this.visibleRect.height) {
                        return;
                    }
                    y16 = Math.max(y15, realY1);
                    y25 = Math.min(y25, this.visibleRect.y + this.visibleRect.height);
                    for (int j15 = y16; j15 <= y25; j15 += 2) {
                        int yEnd = Math.min(y25, j15 + this.getWidth());
                        int xEnd = yEnd - j15;
                        g15.drawLine(0, j15, xEnd, yEnd);
                    }
                    for (int i15 = 2; i15 < this.getWidth(); i15 += 2) {
                        int yEnd = y16 + this.getWidth() - i15;
                        g15.drawLine(i15, y16, this.getWidth(), yEnd);
                    }
                    if (realY1 >= y15 && realY1 < this.visibleRect.y + this.visibleRect.height) {
                        g15.drawLine(0, realY1, this.getWidth(), realY1);
                    }
                    if (y25 >= y15 && y25 < this.visibleRect.y + this.visibleRect.height) {
                        g15.drawLine(0, y25, this.getWidth(), y25);
                    }
                }
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
        }
        if (this.trackingIcons != null) {
            int lastLine = this.textArea.getLineCount() - 1;
            for (int i16 = this.trackingIcons.size() - 1; i16 >= 0; --i16) {
                IconRowHeader.GutterIconImpl ti4 = this.getTrackingIcon(i16);
                int offs = ti4.getMarkedOffset();
                if (offs < 0 || offs > doc.getLength()) continue;
                int line = root.getElementIndex(offs);
                if (line <= lastLine && line >= topLine) {
                    try {
                        int lineY;
                        Icon icon = ti4.getIcon();
                        if (icon == null || (lineY = rsta.yForLine(line)) < y15 || lineY > this.visibleRect.y + this.visibleRect.height) continue;
                        int y26 = lineY + (cellHeight - icon.getIconHeight()) / 2;
                        icon.paintIcon(this, g15, 0, y26);
                        lastLine = line - 1;
                    }
                    catch (BadLocationException ble) {
                        ble.printStackTrace();
                    }
                    continue;
                }
                if (line < topLine) break;
            }
        }
    }

    private void paintComponentWrapped(Graphics g15) {
        RSyntaxTextArea rsta = (RSyntaxTextArea)this.textArea;
        Document doc = this.textArea.getDocument();
        Element root = doc.getDefaultRootElement();
        int topPosition = this.textArea.viewToModel(new Point(this.visibleRect.x, this.visibleRect.y));
        int topLine = root.getElementIndex(topPosition);
        int topY = this.visibleRect.y;
        int bottomY = this.visibleRect.y + this.visibleRect.height;
        int cellHeight = this.textArea.getLineHeight();
        if (this.trackingIcons != null) {
            int lastLine = this.textArea.getLineCount() - 1;
            for (int i15 = this.trackingIcons.size() - 1; i15 >= 0; --i15) {
                IconRowHeader.GutterIconImpl ti4 = this.getTrackingIcon(i15);
                Icon icon = ti4.getIcon();
                if (icon == null) continue;
                int iconH = icon.getIconHeight();
                int offs = ti4.getMarkedOffset();
                if (offs < 0 || offs > doc.getLength()) continue;
                int line = root.getElementIndex(offs);
                if (line <= lastLine && line >= topLine) {
                    try {
                        int lineY = rsta.yForLine(line);
                        if (lineY > bottomY || lineY + iconH < topY) continue;
                        int y25 = lineY + (cellHeight - iconH) / 2;
                        ti4.getIcon().paintIcon(this, g15, 0, y25);
                        lastLine = line - 1;
                    }
                    catch (BadLocationException ble) {
                        ble.printStackTrace();
                    }
                    continue;
                }
                if (line < topLine) break;
            }
        }
    }
}

