/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.apksig.internal.apk.stamp;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import shadow.bundletool.com.android.apksig.ApkVerifier;
import shadow.bundletool.com.android.apksig.apk.ApkFormatException;
import shadow.bundletool.com.android.apksig.apk.ApkUtils;
import shadow.bundletool.com.android.apksig.internal.apk.ApkSigningBlockUtils;
import shadow.bundletool.com.android.apksig.internal.apk.ContentDigestAlgorithm;
import shadow.bundletool.com.android.apksig.internal.apk.SignatureAlgorithm;
import shadow.bundletool.com.android.apksig.internal.apk.SignatureInfo;
import shadow.bundletool.com.android.apksig.internal.util.GuaranteedEncodedFormX509Certificate;
import shadow.bundletool.com.android.apksig.internal.util.Pair;
import shadow.bundletool.com.android.apksig.internal.util.X509CertificateUtils;
import shadow.bundletool.com.android.apksig.util.DataSource;

public abstract class SourceStampVerifier {
    private SourceStampVerifier() {
    }

    public static ApkSigningBlockUtils.Result verify(DataSource apk, ApkUtils.ZipSections zipSections, byte[] sourceStampCertificateDigest, Map<ContentDigestAlgorithm, byte[]> apkContentDigests, int minSdkVersion, int maxSdkVersion) throws IOException, NoSuchAlgorithmException, ApkSigningBlockUtils.SignatureNotFoundException {
        ApkSigningBlockUtils.Result result = new ApkSigningBlockUtils.Result(0);
        SignatureInfo signatureInfo = ApkSigningBlockUtils.findSignature(apk, zipSections, 722016414, result);
        SourceStampVerifier.verify(signatureInfo.signatureBlock, sourceStampCertificateDigest, apkContentDigests, minSdkVersion, maxSdkVersion, result);
        return result;
    }

    private static void verify(ByteBuffer sourceStampBlock, byte[] sourceStampCertificateDigest, Map<ContentDigestAlgorithm, byte[]> apkContentDigests, int minSdkVersion, int maxSdkVersion, ApkSigningBlockUtils.Result result) throws NoSuchAlgorithmException {
        ApkSigningBlockUtils.Result.SignerInfo signerInfo = new ApkSigningBlockUtils.Result.SignerInfo();
        result.signers.add(signerInfo);
        try {
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            ByteBuffer sourceStampBlockData = ApkSigningBlockUtils.getLengthPrefixedSlice(sourceStampBlock);
            SourceStampVerifier.parseSourceStamp(sourceStampBlockData, certFactory, signerInfo, apkContentDigests, sourceStampCertificateDigest, minSdkVersion, maxSdkVersion);
            result.verified = !result.containsErrors() && !result.containsWarnings();
        }
        catch (CertificateException e15) {
            throw new IllegalStateException("Failed to obtain X.509 CertificateFactory", e15);
        }
        catch (BufferUnderflowException | ApkFormatException e16) {
            signerInfo.addWarning(ApkVerifier.Issue.SOURCE_STAMP_MALFORMED_SIGNATURE, new Object[0]);
        }
    }

    private static void parseSourceStamp(ByteBuffer sourceStampBlockData, CertificateFactory certFactory, ApkSigningBlockUtils.Result.SignerInfo result, Map<ContentDigestAlgorithm, byte[]> apkContentDigests, byte[] sourceStampCertificateDigest, int minSdkVersion, int maxSdkVersion) throws ApkFormatException, NoSuchAlgorithmException {
        List<ApkSigningBlockUtils.SupportedSignature> signaturesToVerify;
        SignatureAlgorithm signatureAlgorithm;
        X509Certificate sourceStampCertificate;
        ArrayList<Pair<Integer, byte[]>> digests = new ArrayList<Pair<Integer, byte[]>>();
        for (Map.Entry<ContentDigestAlgorithm, byte[]> apkContentDigest : apkContentDigests.entrySet()) {
            digests.add(Pair.of(apkContentDigest.getKey().getId(), apkContentDigest.getValue()));
        }
        Collections.sort(digests, Comparator.comparing(Pair::getFirst));
        byte[] digestBytes = ApkSigningBlockUtils.encodeAsSequenceOfLengthPrefixedPairsOfIntAndLengthPrefixedBytes(digests);
        byte[] sourceStampEncodedCertificate = ApkSigningBlockUtils.readLengthPrefixedByteArray(sourceStampBlockData);
        try {
            sourceStampCertificate = X509CertificateUtils.generateCertificate(sourceStampEncodedCertificate, certFactory);
        }
        catch (CertificateException e15) {
            result.addWarning(ApkVerifier.Issue.SOURCE_STAMP_MALFORMED_CERTIFICATE, e15);
            return;
        }
        sourceStampCertificate = new GuaranteedEncodedFormX509Certificate(sourceStampCertificate, sourceStampEncodedCertificate);
        result.certs.add(sourceStampCertificate);
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        messageDigest.update(sourceStampEncodedCertificate);
        byte[] sourceStampBlockCertificateDigest = messageDigest.digest();
        if (!Arrays.equals(sourceStampCertificateDigest, sourceStampBlockCertificateDigest)) {
            result.addWarning(ApkVerifier.Issue.SOURCE_STAMP_CERTIFICATE_MISMATCH_BETWEEN_SIGNATURE_BLOCK_AND_APK, ApkSigningBlockUtils.toHex(sourceStampBlockCertificateDigest), ApkSigningBlockUtils.toHex(sourceStampCertificateDigest));
            return;
        }
        ByteBuffer signatures = ApkSigningBlockUtils.getLengthPrefixedSlice(sourceStampBlockData);
        int signatureCount = 0;
        ArrayList<ApkSigningBlockUtils.SupportedSignature> supportedSignatures = new ArrayList<ApkSigningBlockUtils.SupportedSignature>(1);
        while (signatures.hasRemaining()) {
            ++signatureCount;
            try {
                ByteBuffer signature = ApkSigningBlockUtils.getLengthPrefixedSlice(signatures);
                int sigAlgorithmId = signature.getInt();
                byte[] sigBytes = ApkSigningBlockUtils.readLengthPrefixedByteArray(signature);
                result.signatures.add(new ApkSigningBlockUtils.Result.SignerInfo.Signature(sigAlgorithmId, sigBytes));
                signatureAlgorithm = SignatureAlgorithm.findById(sigAlgorithmId);
                if (signatureAlgorithm == null) {
                    result.addWarning(ApkVerifier.Issue.SOURCE_STAMP_UNKNOWN_SIG_ALGORITHM, sigAlgorithmId);
                    continue;
                }
                supportedSignatures.add(new ApkSigningBlockUtils.SupportedSignature(signatureAlgorithm, sigBytes));
            }
            catch (BufferUnderflowException | ApkFormatException e16) {
                result.addWarning(ApkVerifier.Issue.SOURCE_STAMP_MALFORMED_SIGNATURE, signatureCount);
                return;
            }
        }
        if (result.signatures.isEmpty()) {
            result.addWarning(ApkVerifier.Issue.SOURCE_STAMP_NO_SIGNATURE, new Object[0]);
            return;
        }
        try {
            signaturesToVerify = ApkSigningBlockUtils.getSignaturesToVerify(supportedSignatures, minSdkVersion, maxSdkVersion);
        }
        catch (ApkSigningBlockUtils.NoSupportedSignaturesException e17) {
            result.addWarning(ApkVerifier.Issue.SOURCE_STAMP_NO_SUPPORTED_SIGNATURE, new Object[0]);
            return;
        }
        for (ApkSigningBlockUtils.SupportedSignature signature : signaturesToVerify) {
            signatureAlgorithm = signature.algorithm;
            String jcaSignatureAlgorithm = signatureAlgorithm.getJcaSignatureAlgorithmAndParams().getFirst();
            AlgorithmParameterSpec jcaSignatureAlgorithmParams = signatureAlgorithm.getJcaSignatureAlgorithmAndParams().getSecond();
            PublicKey publicKey = sourceStampCertificate.getPublicKey();
            try {
                Signature sig = Signature.getInstance(jcaSignatureAlgorithm);
                sig.initVerify(publicKey);
                if (jcaSignatureAlgorithmParams != null) {
                    sig.setParameter(jcaSignatureAlgorithmParams);
                }
                sig.update(digestBytes);
                byte[] sigBytes = signature.signature;
                if (!sig.verify(sigBytes)) {
                    result.addWarning(ApkVerifier.Issue.SOURCE_STAMP_DID_NOT_VERIFY, new Object[]{signatureAlgorithm});
                    return;
                }
                result.verifiedSignatures.put(signatureAlgorithm, sigBytes);
            }
            catch (InvalidAlgorithmParameterException | InvalidKeyException | SignatureException e18) {
                result.addWarning(ApkVerifier.Issue.SOURCE_STAMP_VERIFY_EXCEPTION, new Object[]{signatureAlgorithm, e18});
                return;
            }
        }
    }
}

