/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.utils;

import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SdkUtils {
    public static final String FILENAME_PREFIX = "From: ";
    public static final List<String> IMAGE_EXTENSIONS = ImmutableList.of(".png", ".9.png", ".gif", ".jpeg", ".jpg", ".bmp", ".webp", ".avif");

    public static boolean endsWithIgnoreCase(String string, String suffix) {
        return string.regionMatches(true, string.length() - suffix.length(), suffix, 0, suffix.length());
    }

    public static boolean endsWith(CharSequence sequence, CharSequence suffix) {
        return SdkUtils.endsWith(sequence, sequence.length(), suffix);
    }

    public static boolean endsWith(CharSequence sequence, int endOffset, CharSequence suffix) {
        if (endOffset < suffix.length()) {
            return false;
        }
        int i15 = endOffset - 1;
        for (int j15 = suffix.length() - 1; j15 >= 0; --j15) {
            if (sequence.charAt(i15) != suffix.charAt(j15)) {
                return false;
            }
            --i15;
        }
        return true;
    }

    public static boolean startsWithIgnoreCase(String string, String prefix) {
        return string.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    public static String wrap(String text, int lineWidth, String hangingIndent) {
        return SdkUtils.wrap(text, lineWidth, lineWidth, hangingIndent);
    }

    public static String wrap(String text, int firstLineWidth, int nextLineWidth, String hangingIndent) {
        return SdkUtils.wrap(text, firstLineWidth, nextLineWidth, hangingIndent, true);
    }

    public static String wrap(String text, int firstLineWidth, int nextLineWidth, String hangingIndent, boolean forceBreak) {
        if (hangingIndent == null) {
            hangingIndent = "";
        }
        int lineWidth = firstLineWidth;
        int explanationLength = text.length();
        StringBuilder sb5 = new StringBuilder(explanationLength * 2);
        int index = 0;
        while (index < explanationLength) {
            int next;
            int lineEnd = text.indexOf(10, index);
            if (lineEnd != -1 && lineEnd - index < lineWidth) {
                next = lineEnd + 1;
            } else {
                lineEnd = Math.min(index + lineWidth, explanationLength);
                if (lineEnd - index < lineWidth) {
                    next = explanationLength;
                } else {
                    int lastSpace = text.lastIndexOf(32, lineEnd);
                    if (lastSpace > index) {
                        lineEnd = lastSpace;
                        next = lastSpace + 1;
                    } else if (!forceBreak) {
                        char c15;
                        for (next = lineEnd; next < explanationLength && !Character.isWhitespace(c15 = text.charAt(next)); ++next) {
                            ++lineEnd;
                        }
                    }
                }
            }
            if (sb5.length() > 0) {
                sb5.append(hangingIndent);
            } else {
                lineWidth = nextLineWidth - hangingIndent.length();
            }
            sb5.append(text, index, lineEnd);
            sb5.append('\n');
            index = next;
        }
        return sb5.toString();
    }

    public static File urlToFile(String url) throws MalformedURLException {
        return SdkUtils.urlToFile(new URL(url));
    }

    public static File urlToFile(URL url) throws MalformedURLException {
        try {
            return new File(url.toURI());
        }
        catch (IllegalArgumentException e15) {
            MalformedURLException ex4 = new MalformedURLException(e15.getLocalizedMessage());
            ex4.initCause(e15);
            throw ex4;
        }
        catch (URISyntaxException e16) {
            return new File(url.getPath());
        }
    }

    public static FileLineColumnUrlData parseDecoratedFileUrlString(String string) {
        Matcher matcher = FileLineColumnUrlData.PATTERN.matcher(string);
        if (matcher.matches()) {
            Integer line = matcher.group(2) == null ? null : Integer.decode(matcher.group(2));
            Integer column = matcher.group(3) == null ? null : Integer.decode(matcher.group(3));
            return new FileLineColumnUrlData(string.substring(0, matcher.start(1)), line, column);
        }
        return new FileLineColumnUrlData(string, null, null);
    }

    public static String fileToUrlString(File file2) throws MalformedURLException {
        String url = SdkUtils.fileToUrl(file2).toExternalForm();
        if (!url.startsWith("file:///")) {
            url = url.replaceFirst("file:/", "file:///");
        }
        return url;
    }

    public static URL fileToUrl(File file2) throws MalformedURLException {
        return file2.toURI().toURL();
    }

    public static String createPathComment(File file2, boolean includePadding) throws MalformedURLException {
        String url = SdkUtils.fileToUrlString(file2);
        int dashes = url.indexOf("--");
        if (dashes != -1) {
            url = url.replace("--", "%2D%2D");
        }
        if (includePadding) {
            return " From: " + url + " ";
        }
        return FILENAME_PREFIX + url;
    }

    public static String xmlNameToConstantName(String xmlName) {
        return CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_UNDERSCORE, xmlName);
    }

    public static String camelCaseToConstantName(String camelCaseName) {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, camelCaseName);
    }

    public static String constantNameToCamelCase(String constantName) {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, constantName);
    }

    public static String constantNameToXmlName(String constantName) {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_HYPHEN, constantName);
    }

    public static String fileNameToResourceName(String fileName) {
        int lastExtension = fileName.lastIndexOf(46);
        if (lastExtension <= 0) {
            return fileName;
        }
        if (fileName.endsWith(".9.png")) {
            if (fileName.length() > ".9.png".length()) {
                return fileName.substring(0, fileName.length() - ".9.png".length());
            }
            return fileName;
        }
        return fileName.substring(0, lastExtension);
    }

    public static String getLayoutName(File layoutFile) {
        String name = layoutFile.getName();
        int dotIndex = name.indexOf(46);
        if (dotIndex != -1) {
            name = name.substring(0, dotIndex);
        }
        return name;
    }

    public static boolean hasImageExtension(String path) {
        for (String ext : IMAGE_EXTENSIONS) {
            if (!SdkUtils.endsWithIgnoreCase(path, ext)) continue;
            return true;
        }
        return false;
    }

    public static boolean isBitmapFile(File file2) {
        return SdkUtils.hasImageExtension(file2.getPath());
    }

    public static String escapePropertyValue(String value) {
        Properties properties = new Properties();
        properties.setProperty("k", value);
        StringWriter writer = new StringWriter();
        try {
            properties.store(writer, null);
            String s15 = writer.toString();
            int end = s15.length();
            String lineSeparator = System.lineSeparator();
            if (s15.endsWith(lineSeparator)) {
                end -= lineSeparator.length();
            }
            int start = s15.indexOf(61);
            assert (start != -1) : s15;
            return s15.substring(start + 1, end);
        }
        catch (IOException e15) {
            return value;
        }
    }

    public static String globToRegexp(String glob) {
        StringBuilder sb5 = new StringBuilder(glob.length() * 2);
        int begin = 0;
        sb5.append('^');
        int n15 = glob.length();
        for (int i15 = 0; i15 < n15; ++i15) {
            char c15 = glob.charAt(i15);
            if (c15 == '*') {
                begin = SdkUtils.appendQuoted(sb5, glob, begin, i15) + 1;
                if (i15 < n15 - 1 && glob.charAt(i15 + 1) == '*') {
                    ++i15;
                    ++begin;
                }
                sb5.append(".*?");
                continue;
            }
            if (c15 != '?') continue;
            begin = SdkUtils.appendQuoted(sb5, glob, begin, i15) + 1;
            sb5.append(".?");
        }
        SdkUtils.appendQuoted(sb5, glob, begin, glob.length());
        sb5.append('$');
        return sb5.toString();
    }

    private static int appendQuoted(StringBuilder sb5, String s15, int from, int to4) {
        if (to4 > from) {
            int i15;
            boolean isSimple = true;
            for (i15 = from; i15 < to4; ++i15) {
                char c15 = s15.charAt(i15);
                if (Character.isLetterOrDigit(c15) || c15 == '/' || c15 == ' ') continue;
                isSimple = false;
                break;
            }
            if (isSimple) {
                for (i15 = from; i15 < to4; ++i15) {
                    sb5.append(s15.charAt(i15));
                }
                return to4;
            }
            sb5.append(Pattern.quote(s15.substring(from, to4)));
        }
        return to4;
    }

    public static boolean isServiceKey(String name) {
        switch (name) {
            case "gcm_defaultSenderId": 
            case "google_app_id": 
            case "google_api_key": 
            case "google_storage_bucket": 
            case "ga_trackingID": 
            case "default_web_client_id": 
            case "firebase_database_url": 
            case "google_crash_reporting_api_key": {
                return true;
            }
        }
        return false;
    }

    public static class FileLineColumnUrlData {
        public static final Pattern PATTERN = Pattern.compile(".*?(:(\\d+)(?::(\\d+))?)$");
        public final String urlString;
        public final Integer line;
        public final Integer column;

        FileLineColumnUrlData(String urlString, Integer line, Integer column) {
            this.urlString = urlString;
            this.line = line;
            this.column = column;
        }
    }
}

