/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.zipflinger;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import shadow.bundletool.com.android.zipflinger.Location;

public class PayloadInputStream
extends InputStream {
    private FileChannel channel;
    private Location boundaries;
    private long position;

    public PayloadInputStream(FileChannel channel, Location location) throws IOException {
        this.channel = channel;
        this.boundaries = location;
        this.position = location.first;
        if (location.first < 0L || location.last >= channel.size()) {
            throw new IllegalStateException("Location not within channel boundaries");
        }
    }

    @Override
    public int read() throws IOException {
        if (this.position > this.boundaries.last) {
            return -1;
        }
        byte[] buffer = new byte[1];
        this.read(buffer);
        return buffer[0] & 0xFF;
    }

    @Override
    public int read(byte[] b15, int off, int len) throws IOException {
        if (this.position > this.boundaries.last) {
            return -1;
        }
        long available = this.boundaries.last - this.position + 1L;
        available = Math.min(available, Integer.MAX_VALUE);
        int toRead = Math.min(Math.toIntExact(available), len);
        ByteBuffer buffer = ByteBuffer.wrap(b15, off, toRead);
        int read = this.channel.read(buffer, this.position);
        this.position += (long)read;
        return read;
    }
}

