/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.model;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;

public class ResourceWrapper
implements Resource {
    private final Resource resource;
    private final String name;
    private final ResourceServer resourceServer;
    private final Set<Scope> scopes;
    private final String id;

    public ResourceWrapper(String name, Set<Scope> scopes, ResourceServer resourceServer) {
        this(null, name, scopes, resourceServer);
    }

    public ResourceWrapper(String id, String name, Set<Scope> scopes, ResourceServer resourceServer) {
        this.id = id;
        this.name = name;
        this.scopes = scopes;
        this.resourceServer = resourceServer;
        this.resource = null;
    }

    @Override
    public String getId() {
        return Optional.ofNullable(this.resource).map(Resource::getId).orElse(this.id);
    }

    @Override
    public String getName() {
        return Optional.ofNullable(this.resource).map(Resource::getName).orElse(this.name);
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public String getDisplayName() {
        return Optional.ofNullable(this.resource).map(Resource::getDisplayName).orElse(null);
    }

    @Override
    public void setDisplayName(String name) {
    }

    @Override
    public Set<String> getUris() {
        return Optional.ofNullable(this.resource).map(Resource::getUris).orElse(Set.of());
    }

    @Override
    public void updateUris(Set<String> uri) {
    }

    @Override
    public String getType() {
        return Optional.ofNullable(this.resource).map(Resource::getType).orElse(null);
    }

    @Override
    public void setType(String type) {
    }

    @Override
    public List<Scope> getScopes() {
        return Optional.ofNullable(this.resource).map(Resource::getScopes).orElse(this.scopes.stream().toList());
    }

    @Override
    public String getIconUri() {
        return Optional.ofNullable(this.resource).map(Resource::getIconUri).orElse(null);
    }

    @Override
    public void setIconUri(String iconUri) {
    }

    @Override
    public ResourceServer getResourceServer() {
        return this.resourceServer;
    }

    @Override
    public String getOwner() {
        return Optional.ofNullable(this.resource).map(Resource::getOwner).orElse(this.resourceServer.getId());
    }

    @Override
    public boolean isOwnerManagedAccess() {
        return Optional.ofNullable(this.resource).map(Resource::isOwnerManagedAccess).orElse(false);
    }

    @Override
    public void setOwnerManagedAccess(boolean ownerManagedAccess) {
    }

    @Override
    public void updateScopes(Set<Scope> scopes) {
    }

    @Override
    public Map<String, List<String>> getAttributes() {
        return Optional.ofNullable(this.resource).map(Resource::getAttributes).orElse(Map.of());
    }

    @Override
    public String getSingleAttribute(String name) {
        return this.getAttributes().getOrDefault(name, List.of()).stream().findFirst().orElse(null);
    }

    @Override
    public List<String> getAttribute(String name) {
        return this.getAttributes().getOrDefault(name, List.of());
    }

    @Override
    public void setAttribute(String name, List<String> values) {
    }

    @Override
    public void removeAttribute(String name) {
    }
}

