/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.rest.handler;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.RangeQueryBuilder;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregationBuilders;
import org.opensearch.search.aggregations.Aggregations;
import org.opensearch.search.aggregations.BucketOrder;
import org.opensearch.search.aggregations.PipelineAggregationBuilder;
import org.opensearch.search.aggregations.PipelineAggregatorBuilders;
import org.opensearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.opensearch.search.aggregations.bucket.composite.CompositeAggregation;
import org.opensearch.search.aggregations.bucket.composite.TermsValuesSourceBuilder;
import org.opensearch.search.aggregations.bucket.histogram.LongBounds;
import org.opensearch.search.aggregations.bucket.terms.Terms;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.sort.FieldSortBuilder;
import org.opensearch.search.sort.SortOrder;
import org.opensearch.timeseries.AnalysisType;
import org.opensearch.timeseries.feature.SearchFeatureDao;
import org.opensearch.timeseries.model.Config;
import org.opensearch.timeseries.model.IntervalTimeConfiguration;
import org.opensearch.timeseries.rest.handler.AggregationPrep;
import org.opensearch.timeseries.util.SecurityClientUtil;
import org.opensearch.transport.client.Client;

public class LatestTimeRetriever {
    public static final Logger logger = LogManager.getLogger(LatestTimeRetriever.class);
    protected static final String AGG_NAME_TOP = "top_agg";
    private final Config config;
    private final AggregationPrep aggregationPrep;
    private final SecurityClientUtil clientUtil;
    private final Client client;
    private final User user;
    private final AnalysisType context;
    private final SearchFeatureDao searchFeatureDao;
    private final boolean convertFutureDatetoNow;

    public LatestTimeRetriever(Config config, TimeValue requestTimeout, SecurityClientUtil clientUtil, Client client, User user, AnalysisType context, SearchFeatureDao searchFeatureDao, boolean convertFutureDatetoNow) {
        this.config = config;
        this.aggregationPrep = new AggregationPrep(searchFeatureDao, requestTimeout, config);
        this.clientUtil = clientUtil;
        this.client = client;
        this.user = user;
        this.context = context;
        this.searchFeatureDao = searchFeatureDao;
        this.convertFutureDatetoNow = convertFutureDatetoNow;
    }

    public void checkIfHC(ActionListener<Pair<Optional<Long>, Map<String, Object>>> listener) {
        this.searchFeatureDao.getLatestDataTime(this.user, this.config, Optional.empty(), this.context, (ActionListener<Optional<Long>>)ActionListener.wrap(latestTime -> {
            if (latestTime.isEmpty()) {
                listener.onResponse((Object)Pair.of(Optional.empty(), Collections.emptyMap()));
            } else {
                long timeRangeEnd;
                long currentEpochMillis = Instant.now().toEpochMilli();
                if (currentEpochMillis < (timeRangeEnd = ((Long)latestTime.get()).longValue())) {
                    logger.info((Message)new ParameterizedMessage("Future date is detected: [{}]", latestTime.get()));
                    if (this.convertFutureDatetoNow) {
                        logger.info("Convert future date to now");
                        timeRangeEnd = currentEpochMillis;
                    }
                }
                if (this.config.isHighCardinality()) {
                    this.getTopEntity(listener, timeRangeEnd);
                } else {
                    listener.onResponse((Object)Pair.of(Optional.of(timeRangeEnd), Collections.emptyMap()));
                }
            }
        }, e -> {
            if (e instanceof IndexNotFoundException) {
                listener.onResponse((Object)Pair.of(Optional.empty(), Collections.emptyMap()));
            }
            listener.onFailure(e);
        }));
    }

    public void getTopEntity(ActionListener<Pair<Optional<Long>, Map<String, Object>>> topEntityListener, long latestTimeMillis) {
        long maxIntervalInMinutes = Math.max(60L, this.config.getIntervalInMinutes());
        LongBounds timeRangeBounds = this.aggregationPrep.getTimeRangeBounds(new IntervalTimeConfiguration(maxIntervalInMinutes, ChronoUnit.MINUTES), latestTimeMillis);
        RangeQueryBuilder rangeQuery = new RangeQueryBuilder(this.config.getTimeField()).from((Object)timeRangeBounds.getMin()).to((Object)timeRangeBounds.getMax()).format("epoch_millis");
        HashMap topKeys = new HashMap();
        Object bucketAggs = this.config.getCategoryFields().size() == 1 ? ((TermsAggregationBuilder)AggregationBuilders.terms((String)AGG_NAME_TOP).field(this.config.getCategoryFields().get(0))).order(BucketOrder.count((boolean)true)) : AggregationBuilders.composite((String)AGG_NAME_TOP, this.config.getCategoryFields().stream().map(f -> (TermsValuesSourceBuilder)new TermsValuesSourceBuilder(f).field(f)).collect(Collectors.toList())).size(1000).subAggregation((PipelineAggregationBuilder)PipelineAggregatorBuilders.bucketSort((String)"bucketSort", Collections.singletonList((FieldSortBuilder)new FieldSortBuilder("_count").order(SortOrder.DESC))).size(Integer.valueOf(1000)));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)rangeQuery).aggregation((AggregationBuilder)bucketAggs).trackTotalHits(false).size(0);
        SearchRequest searchRequest = new SearchRequest().indices(this.config.getIndices().toArray(new String[0])).source(searchSourceBuilder);
        ActionListener searchResponseListener = ActionListener.wrap(response -> {
            Aggregations aggs = response.getAggregations();
            if (aggs == null) {
                logger.warn("empty aggregation");
                topEntityListener.onResponse((Object)Pair.of(Optional.empty(), Collections.emptyMap()));
                return;
            }
            if (this.config.getCategoryFields().size() == 1) {
                Terms entities = (Terms)aggs.get(AGG_NAME_TOP);
                List sortedBuckets = entities.getBuckets().stream().sorted(Comparator.comparingLong(MultiBucketsAggregation.Bucket::getDocCount)).collect(Collectors.toList());
                if (!sortedBuckets.isEmpty()) {
                    medianIndex = (sortedBuckets.size() - 1) / 2;
                    medianBucket = (Terms.Bucket)sortedBuckets.get(medianIndex);
                    String medianKey = medianBucket.getKeyAsString();
                    topKeys.put(this.config.getCategoryFields().get(0), medianKey);
                } else {
                    topKeys.put(this.config.getCategoryFields().get(0), null);
                }
            } else {
                CompositeAggregation compositeAgg = (CompositeAggregation)aggs.get(AGG_NAME_TOP);
                List sortedCompositeBuckets = compositeAgg.getBuckets().stream().sorted(Comparator.comparingLong(MultiBucketsAggregation.Bucket::getDocCount)).collect(Collectors.toList());
                if (!sortedCompositeBuckets.isEmpty()) {
                    medianIndex = (sortedCompositeBuckets.size() - 1) / 2;
                    medianBucket = (CompositeAggregation.Bucket)sortedCompositeBuckets.get(medianIndex);
                    topKeys.putAll(medianBucket.getKey());
                } else {
                    this.config.getCategoryFields().forEach(f -> topKeys.put(f, null));
                }
            }
            for (Map.Entry entry : topKeys.entrySet()) {
                if (entry.getValue() != null) continue;
                topEntityListener.onResponse((Object)Pair.of(Optional.empty(), Collections.emptyMap()));
                return;
            }
            topEntityListener.onResponse((Object)Pair.of(Optional.of(latestTimeMillis), (Object)topKeys));
        }, arg_0 -> topEntityListener.onFailure(arg_0));
        this.clientUtil.asyncRequestWithInjectedSecurity(searchRequest, (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1), this.user, this.client, this.context, searchResponseListener);
    }
}

