"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InternalDynamicConfigurationClient = void 0;
var _operators = require("rxjs/operators");
var _utils = require("../utils/utils");
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); } /*
                                                                                                                                                                                                     * Copyright OpenSearch Contributors
                                                                                                                                                                                                     * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                     */
var _client = /*#__PURE__*/new WeakMap();
var _logger = /*#__PURE__*/new WeakMap();
var _schemas = /*#__PURE__*/new WeakMap();
var _configService = /*#__PURE__*/new WeakMap();
class InternalDynamicConfigurationClient {
  constructor(props) {
    _classPrivateFieldInitSpec(this, _client, void 0);
    _classPrivateFieldInitSpec(this, _logger, void 0);
    _classPrivateFieldInitSpec(this, _schemas, void 0);
    _classPrivateFieldInitSpec(this, _configService, void 0);
    const {
      client,
      logger,
      schemas,
      configService
    } = props;
    _classPrivateFieldSet(_client, this, client);
    _classPrivateFieldSet(_schemas, this, schemas);
    _classPrivateFieldSet(_configService, this, configService);
    _classPrivateFieldSet(_logger, this, logger);
  }
  async getConfig(getConfigProps, options) {
    const namespace = (0, _utils.pathToString)(getConfigProps);
    const defaultConfig = await this.getDefaultConfig(namespace);

    // If this call fails/returns undefined, default to the defaultConfig
    const configStoreConfig = await _classPrivateFieldGet(_client, this).getConfig(namespace, options);
    return configStoreConfig ? (0, _utils.mergeConfigs)(defaultConfig, configStoreConfig) : defaultConfig;
  }
  async bulkGetConfigs(bulkGetConfig, options) {
    const namespaces = bulkGetConfig.paths.map(path => (0, _utils.pathToString)(path));
    const defaultConfigsMap = new Map();

    // TODO Determine whether to pass through or completely fail a bulkGet() call if a namespace does not exist
    for (const namespace of namespaces) {
      const config = await this.getDefaultConfig(namespace);
      defaultConfigsMap.set(namespace, config);
    }

    // If this call fails/returns undefined, default to the defaultConfig
    const configStoreConfig = await _classPrivateFieldGet(_client, this).bulkGetConfigs(namespaces, options);
    if (!configStoreConfig.size) {
      return defaultConfigsMap;
    }
    const finalConfigsMap = new Map([...defaultConfigsMap]);
    configStoreConfig.forEach((newConfig, configName) => {
      const oldConfig = defaultConfigsMap.get(configName);
      if (!oldConfig) {
        _classPrivateFieldGet(_logger, this).warn(`Config ${configName} not found`);
        return defaultConfigsMap;
      }
      const finalConfig = (0, _utils.mergeConfigs)(oldConfig, newConfig);
      finalConfigsMap.set(configName, finalConfig);
    });
    return finalConfigsMap;
  }

  // TODO Determine if the listConfigs() should only list the configs for the config store or ALL configs
  async listConfigs(options) {
    return await _classPrivateFieldGet(_client, this).listConfigs(options);
  }
  async createConfig(createConfigProps, options) {
    // TODO Add validation logic
    return await _classPrivateFieldGet(_client, this).createConfig(createConfigProps, options);
  }
  async bulkCreateConfigs(bulkCreateConfigProps, options) {
    // TODO Add validation logic
    return await _classPrivateFieldGet(_client, this).bulkCreateConfigs(bulkCreateConfigProps, options);
  }
  async deleteConfig(deleteConfigs, options) {
    return await _classPrivateFieldGet(_client, this).deleteConfig(deleteConfigs, options);
  }
  async bulkDeleteConfigs(bulkDeleteConfigProps, options) {
    return await _classPrivateFieldGet(_client, this).bulkDeleteConfigs(bulkDeleteConfigProps, options);
  }

  /**
   * Given the top level config, obtain the top level config from the config store
   *
   * @param namespace The config name to fetch the registered schema
   * @private
   */
  async getDefaultConfig(namespace) {
    const schema = _classPrivateFieldGet(_schemas, this).get(namespace);
    if (!schema) {
      throw new Error(`schema for ${namespace} not found`);
    }
    return await _classPrivateFieldGet(_configService, this).atPath(namespace).pipe((0, _operators.first)()).toPromise();
  }

  /**
   * Returns the entire config as a Map of config names and schema values
   *
   * @private
   *
   * TODO This should only be implemented if listConfigs() will show configs not shown in config store
   * private async getAllDefaultConfigs(): Promise<Map<string, Record<string, any>>> {
   *  const configStore = await this.configService.getConfig$().toPromise();
   *  const configMap = new Map();
   *  Array.from(this.schemas.keys()).map((configName) => {
   *    configMap.set(configName, configStore.get(configName));
   *  });
   *  return configMap;
   * }
   */

  /**
   * TODO Implement validateConfig, which given a config blob and top level config name, validates it against the registered schema
   *  - see {@link ConfigService} validateAtPath() for reference
   *
   * @param configIdentifier
   * @param config
   * @private
   */
}
exports.InternalDynamicConfigurationClient = InternalDynamicConfigurationClient;