/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.json;

import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;

class JsonDataImpl
implements JsonData {
    private final Object value;
    private final JsonpMapper mapper;

    JsonDataImpl(Object value, JsonpMapper mapper) {
        this.value = value;
        this.mapper = mapper;
    }

    public String toString() {
        return this.value.toString();
    }

    @Override
    public JsonValue toJson() {
        return this.toJson(null);
    }

    @Override
    public JsonValue toJson(JsonpMapper mapper) {
        if (this.value instanceof JsonValue) {
            return (JsonValue)this.value;
        }
        JsonpMapper jsonpMapper = mapper = mapper != null ? mapper : this.mapper;
        if (mapper == null) {
            throw new IllegalStateException("Contains a '" + this.value.getClass().getName() + "' that cannot be converted to a JsonValue without a mapper");
        }
        JsonParser parser = this.getParser(mapper);
        parser.next();
        return parser.getValue();
    }

    @Override
    public <T> T to(Class<T> clazz) {
        return this.to(clazz, null);
    }

    @Override
    public <T> T to(Class<T> clazz, JsonpMapper mapper) {
        if (clazz.isAssignableFrom(this.value.getClass())) {
            return (T)this.value;
        }
        mapper = this.getMapper(mapper);
        JsonParser parser = this.getParser(mapper);
        return mapper.deserialize(parser, clazz);
    }

    @Override
    public <T> T deserialize(JsonpDeserializer<T> deserializer) {
        return this.deserialize(deserializer, null);
    }

    @Override
    public <T> T deserialize(JsonpDeserializer<T> deserializer, JsonpMapper mapper) {
        mapper = this.getMapper(mapper);
        return deserializer.deserialize(this.getParser(mapper), mapper);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        if (this.value instanceof JsonValue) {
            generator.write((JsonValue)this.value);
        } else if (this.value instanceof String) {
            generator.write((String)this.value);
        } else if (this.value instanceof BigDecimal) {
            generator.write((BigDecimal)this.value);
        } else if (this.value instanceof BigInteger) {
            generator.write((BigInteger)this.value);
        } else if (this.value instanceof Short) {
            generator.write((int)((Short)this.value).shortValue());
        } else if (this.value instanceof Integer) {
            generator.write(((Integer)this.value).intValue());
        } else if (this.value instanceof Long) {
            generator.write(((Long)this.value).longValue());
        } else if (this.value instanceof Float) {
            generator.write((double)((Float)this.value).floatValue());
        } else if (this.value instanceof Double) {
            generator.write(((Double)this.value).doubleValue());
        } else if (this.value instanceof Boolean) {
            generator.write(((Boolean)this.value).booleanValue());
        } else {
            (this.mapper != null ? this.mapper : mapper).serialize(this.value, generator);
        }
    }

    private JsonpMapper getMapper(JsonpMapper localMapper) {
        JsonpMapper jsonpMapper = localMapper = localMapper != null ? localMapper : this.mapper;
        if (localMapper == null) {
            throw new IllegalStateException("A JsonpMapper is needed to convert JsonData");
        }
        return localMapper;
    }

    private JsonParser getParser(JsonpMapper mapper) {
        StringWriter sw = new StringWriter();
        JsonGenerator generator = mapper.jsonProvider().createGenerator((Writer)sw);
        if (this.value instanceof JsonValue) {
            generator.write((JsonValue)this.value);
        } else {
            mapper.serialize(this.value, generator);
        }
        generator.close();
        return mapper.jsonProvider().createParser((Reader)new StringReader(sw.toString()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonDataImpl jsonDataImpl = (JsonDataImpl)o;
        return Objects.equals(this.value, jsonDataImpl.value);
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }
}

