/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.keystore.model;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Objects;

public class BranchKeyMaterials {
    private final String branchKeyIdentifier;
    private final String branchKeyVersion;
    private final Map<String, String> encryptionContext;
    private final ByteBuffer branchKey;

    protected BranchKeyMaterials(BuilderImpl builder) {
        this.branchKeyIdentifier = builder.branchKeyIdentifier();
        this.branchKeyVersion = builder.branchKeyVersion();
        this.encryptionContext = builder.encryptionContext();
        this.branchKey = builder.branchKey();
    }

    public String branchKeyIdentifier() {
        return this.branchKeyIdentifier;
    }

    public String branchKeyVersion() {
        return this.branchKeyVersion;
    }

    public Map<String, String> encryptionContext() {
        return this.encryptionContext;
    }

    public ByteBuffer branchKey() {
        return this.branchKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected String branchKeyIdentifier;
        protected String branchKeyVersion;
        protected Map<String, String> encryptionContext;
        protected ByteBuffer branchKey;

        protected BuilderImpl() {
        }

        protected BuilderImpl(BranchKeyMaterials model) {
            this.branchKeyIdentifier = model.branchKeyIdentifier();
            this.branchKeyVersion = model.branchKeyVersion();
            this.encryptionContext = model.encryptionContext();
            this.branchKey = model.branchKey();
        }

        @Override
        public Builder branchKeyIdentifier(String branchKeyIdentifier) {
            this.branchKeyIdentifier = branchKeyIdentifier;
            return this;
        }

        @Override
        public String branchKeyIdentifier() {
            return this.branchKeyIdentifier;
        }

        @Override
        public Builder branchKeyVersion(String branchKeyVersion) {
            this.branchKeyVersion = branchKeyVersion;
            return this;
        }

        @Override
        public String branchKeyVersion() {
            return this.branchKeyVersion;
        }

        @Override
        public Builder encryptionContext(Map<String, String> encryptionContext) {
            this.encryptionContext = encryptionContext;
            return this;
        }

        @Override
        public Map<String, String> encryptionContext() {
            return this.encryptionContext;
        }

        @Override
        public Builder branchKey(ByteBuffer branchKey) {
            this.branchKey = branchKey;
            return this;
        }

        @Override
        public ByteBuffer branchKey() {
            return this.branchKey;
        }

        @Override
        public BranchKeyMaterials build() {
            if (Objects.isNull(this.branchKeyIdentifier())) {
                throw new IllegalArgumentException("Missing value for required field `branchKeyIdentifier`");
            }
            if (Objects.isNull(this.branchKeyVersion())) {
                throw new IllegalArgumentException("Missing value for required field `branchKeyVersion`");
            }
            if (Objects.isNull(this.encryptionContext())) {
                throw new IllegalArgumentException("Missing value for required field `encryptionContext`");
            }
            if (Objects.isNull(this.branchKey())) {
                throw new IllegalArgumentException("Missing value for required field `branchKey`");
            }
            return new BranchKeyMaterials(this);
        }
    }

    public static interface Builder {
        public Builder branchKeyIdentifier(String var1);

        public String branchKeyIdentifier();

        public Builder branchKeyVersion(String var1);

        public String branchKeyVersion();

        public Builder encryptionContext(Map<String, String> var1);

        public Map<String, String> encryptionContext();

        public Builder branchKey(ByteBuffer var1);

        public ByteBuffer branchKey();

        public BranchKeyMaterials build();
    }
}

