/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.policy;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.RedirectStrategy;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.logging.LogLevel;
import java.lang.invoke.LambdaMetafactory;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Supplier;

public final class DefaultRedirectStrategy
implements RedirectStrategy {
    private static final ClientLogger LOGGER = new ClientLogger(DefaultRedirectStrategy.class);
    private static final int DEFAULT_MAX_REDIRECT_ATTEMPTS = 3;
    private static final int PERMANENT_REDIRECT_STATUS_CODE = 308;
    private static final int TEMPORARY_REDIRECT_STATUS_CODE = 307;
    private static final Set<HttpMethod> DEFAULT_REDIRECT_ALLOWED_METHODS = EnumSet.of(HttpMethod.GET, HttpMethod.HEAD);
    private static final String REDIRECT_URLS_KEY = "redirectUrls";
    private final int maxAttempts;
    private final HttpHeaderName locationHeader;
    private final Set<HttpMethod> allowedRedirectHttpMethods;

    public DefaultRedirectStrategy() {
        this(3, HttpHeaderName.LOCATION, DEFAULT_REDIRECT_ALLOWED_METHODS);
    }

    public DefaultRedirectStrategy(int maxAttempts) {
        this(maxAttempts, HttpHeaderName.LOCATION, DEFAULT_REDIRECT_ALLOWED_METHODS);
    }

    public DefaultRedirectStrategy(int maxAttempts, String locationHeader, Set<HttpMethod> allowedMethods) {
        this(maxAttempts, DefaultRedirectStrategy.validateLocationHeader(locationHeader), DefaultRedirectStrategy.validateAllowedMethods(allowedMethods));
    }

    private DefaultRedirectStrategy(int maxAttempts, HttpHeaderName locationHeader, Set<HttpMethod> allowedMethods) {
        if (maxAttempts < 0) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("Max attempts cannot be less than 0."));
        }
        this.maxAttempts = maxAttempts;
        this.locationHeader = locationHeader;
        this.allowedRedirectHttpMethods = allowedMethods;
    }

    private static HttpHeaderName validateLocationHeader(String locationHeader) {
        if (CoreUtils.isNullOrEmpty(locationHeader)) {
            LOGGER.log(LogLevel.INFORMATIONAL, () -> "'locationHeader' provided as null will be defaulted to " + HttpHeaderName.LOCATION);
            return HttpHeaderName.LOCATION;
        }
        return HttpHeaderName.fromString(locationHeader);
    }

    private static Set<HttpMethod> validateAllowedMethods(Set<HttpMethod> allowedMethods) {
        if (CoreUtils.isNullOrEmpty(allowedMethods)) {
            LOGGER.log(LogLevel.INFORMATIONAL, () -> "'allowedMethods' provided as null will be defaulted to " + DEFAULT_REDIRECT_ALLOWED_METHODS);
            return DEFAULT_REDIRECT_ALLOWED_METHODS;
        }
        return EnumSet.copyOf(allowedMethods);
    }

    @Override
    public boolean shouldAttemptRedirect(HttpPipelineCallContext context, HttpResponse httpResponse, int tryCount, Set<String> attemptedRedirectUrls) {
        if (this.isValidRedirectStatusCode(httpResponse.getStatusCode()) && this.isValidRedirectCount(tryCount) && this.isAllowedRedirectMethod(httpResponse.getRequest().getHttpMethod())) {
            String redirectUrl = httpResponse.getHeaderValue(this.locationHeader);
            if (redirectUrl != null && !this.alreadyAttemptedRedirectUrl(redirectUrl, attemptedRedirectUrls)) {
                LOGGER.atVerbose().addKeyValue("tryCount", tryCount).addKeyValue(REDIRECT_URLS_KEY, (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, toString(), ()Ljava/lang/String;)(attemptedRedirectUrls)).log("Redirecting.");
                attemptedRedirectUrls.add(redirectUrl);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public HttpRequest createRedirectRequest(HttpResponse httpResponse) {
        return httpResponse.getRequest().setUrl(httpResponse.getHeaderValue(this.locationHeader));
    }

    @Override
    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    private boolean alreadyAttemptedRedirectUrl(String redirectUrl, Set<String> attemptedRedirectUrls) {
        if (attemptedRedirectUrls.contains(redirectUrl)) {
            LOGGER.atError().addKeyValue("redirectUrl", redirectUrl).log("Request was redirected more than once to the same URL.");
            return true;
        }
        return false;
    }

    private boolean isValidRedirectCount(int tryCount) {
        if (tryCount >= this.getMaxAttempts()) {
            LOGGER.atError().addKeyValue("maxAttempts", this.getMaxAttempts()).log("Redirect attempts have been exhausted.");
            return false;
        }
        return true;
    }

    private boolean isAllowedRedirectMethod(HttpMethod httpMethod) {
        if (this.allowedRedirectHttpMethods.contains((Object)httpMethod)) {
            return true;
        }
        LOGGER.atError().addKeyValue("method", (Object)httpMethod).log("Request was redirected from an invalid redirect allowed method.");
        return false;
    }

    private boolean isValidRedirectStatusCode(int statusCode) {
        return statusCode == 302 || statusCode == 301 || statusCode == 308 || statusCode == 307;
    }
}

