\name{BSplineTransform}
\alias{BSplineTransform}
\title{BSplineTransform}
\Rdversion{1.1}
\docType{class}
\description{
A deformable transform over a bounded spatial domain using a BSpline
representation for a 2D or 3D coordinate space.
BSplineTransform}
\details{
See:
itk::BSplineTransform
BSplineTransform}
%C++ includes: sitkBSplineTransform.h
\section{Methods}{
\describe{
\item{ BSplineTransform(const BSplineTransform &):}{}
\item{ BSplineTransform(const std::vector< Image > &coefficientImages, unsigned int order=3):}{
Construct a BSpline from a set of coeefficientImages
The coefficient images must be of pixel type sitkFloat64, the number
of images must equal the dimension of the transform ( 2 or 3 ), all
must be the same dimensions. The image's spacing, origin, size and
direction cosine matrix are used to define the transform domain. The
transform domain is reduced by the spline order.
}
\item{ BSplineTransform(const Transform &):}{}
\item{ BSplineTransform(unsigned int dimensions, unsigned int order=3):}{}
\item{std::vector<  GetCoefficientImages() const:}{
Get a vector of the coefficient images representing the BSpline.
A lazy shallow copy of the images from ITK is performed. If they are
modified in SimpleITK a deep copy will occur. However, if the
coefficient images are modified in ITK, then no copy will occur and
the images held by SimpleITK may unexpectedly change.
}
\item{std::string GetName() const override:}{
Name of this class
}
\item{unsigned int GetOrder() const:}{}
\item{std::vector< double > GetTransformDomainDirection() const:}{}
\item{std::vector< unsigned int > GetTransformDomainMeshSize() const:}{}
\item{std::vector< double > GetTransformDomainOrigin() const:}{}
\item{std::vector< double > GetTransformDomainPhysicalDimensions() const:}{}
\item{Self SetTransformDomainDirection(const std::vector< double > &):}{
parameters fixed parameter
}
\item{Self SetTransformDomainMeshSize(const std::vector< unsigned int > &):}{}
\item{Self SetTransformDomainOrigin(const std::vector< double > &):}{}
\item{Self SetTransformDomainPhysicalDimensions(const std::vector< double > &):}{}
\item{ ~BSplineTransform() override:}{}
}
}
