"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const path = __importStar(require("path"));
const perf_hooks_1 = require("perf_hooks");
const typescript_1 = __importDefault(require("typescript"));
const vscode_languageserver_1 = require("vscode-languageserver");
const documents_1 = require("../../../src/lib/documents");
const ls_config_1 = require("../../../src/ls-config");
const plugins_1 = require("../../../src/plugins");
const utils_1 = require("../../../src/utils");
describe('TypeScript Plugin Performance Tests', () => {
    function setup(filename) {
        const docManager = new documents_1.DocumentManager(() => document);
        const testDir = path.join(__dirname, 'testfiles');
        const filePath = path.join(testDir, filename);
        const uri = (0, utils_1.pathToUrl)(filePath);
        const document = new documents_1.Document(uri, typescript_1.default.sys.readFile(filePath) || '');
        const pluginManager = new ls_config_1.LSConfigManager();
        const workspaceUris = [(0, utils_1.pathToUrl)(testDir)];
        const plugin = new plugins_1.TypeScriptPlugin(pluginManager, new plugins_1.LSAndTSDocResolver(docManager, workspaceUris, pluginManager), workspaceUris, docManager);
        docManager.openClientDocument({ uri, text: document.getText() });
        const append = (newText) => docManager.updateDocument({ uri, version: 1 }, [
            { range: vscode_languageserver_1.Range.create(vscode_languageserver_1.Position.create(9, 0), vscode_languageserver_1.Position.create(9, 0)), text: newText }
        ]);
        const prepend = (newText) => docManager.updateDocument({ uri, version: 1 }, [
            { range: vscode_languageserver_1.Range.create(vscode_languageserver_1.Position.create(1, 0), vscode_languageserver_1.Position.create(1, 0)), text: newText }
        ]);
        return { plugin, document, append, prepend };
    }
    it('should be fast enough', async function () {
        // allow to set a higher timeout for slow machines from cli flag
        const performanceTimeout = Math.max(this.timeout(), 25_000);
        this.timeout(performanceTimeout);
        const { document, plugin, append, prepend } = setup('performance.svelte');
        const benchmarkElapse = Math.ceil(await benchmark());
        // it usually takes around 5-6 times of the benchmark result
        // plus 1 for the benchmark itself
        const newTimeout = benchmarkElapse * 7;
        if (newTimeout < performanceTimeout) {
            console.log(`Benchmark took ${benchmarkElapse}ms. Setting timeout to ${newTimeout}ms`);
            this.timeout(newTimeout);
        }
        const start = perf_hooks_1.performance.now();
        for (let i = 0; i < 100; i++) {
            const position = vscode_languageserver_1.Position.create(Math.floor(i / 2) + 1, 15);
            await plugin.doHover(document, position);
            await plugin.getDiagnostics(document);
            await plugin.findReferences(document, position, {
                includeDeclaration: true
            });
            await plugin.getDocumentSymbols(document);
            await plugin.getSemanticTokens(document);
            await plugin.prepareRename(document, position);
            if (i % 2) {
                prepend('function asd() {}\n');
            }
            else {
                append('function asd() {}\n');
            }
        }
        const end = perf_hooks_1.performance.now();
        console.log(`Performance test took ${end - start}ms`);
        async function benchmark() {
            const start = perf_hooks_1.performance.now();
            for (let i = 0; i < 5; i++) {
                typescript_1.default.createProgram({
                    options: {},
                    rootNames: [document.getFilePath()]
                });
            }
            const end = perf_hooks_1.performance.now();
            return end - start;
        }
    });
});
//# sourceMappingURL=typescript-performance.test.js.map