/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.tomcat.dbcp.dbcp2.LifetimeExceededException;
import org.apache.tomcat.dbcp.pool2.PooledObject;

public final class Utils {
    private static final ResourceBundle messages = ResourceBundle.getBundle(Utils.class.getPackage().getName() + ".LocalStrings");
    @Deprecated
    public static final boolean IS_SECURITY_ENABLED = Utils.isSecurityEnabled();
    public static final String DISCONNECTION_SQL_CODE_PREFIX = "08";
    @Deprecated
    public static final Set<String> DISCONNECTION_SQL_CODES;
    static final ResultSet[] EMPTY_RESULT_SET_ARRAY;
    static final String[] EMPTY_STRING_ARRAY;

    static void checkSqlCodes(Collection<String> collection, Collection<String> collection2) {
        if (collection != null && collection2 != null) {
            HashSet<String> hashSet = new HashSet<String>(collection);
            hashSet.retainAll(collection2);
            if (!hashSet.isEmpty()) {
                throw new IllegalArgumentException(String.valueOf(hashSet) + " cannot be in both disconnectionSqlCodes and disconnectionIgnoreSqlCodes.");
            }
        }
    }

    public static char[] clone(char[] cArray) {
        return cArray == null ? null : (char[])cArray.clone();
    }

    public static Properties cloneWithoutCredentials(Properties properties) {
        if (properties != null) {
            Properties properties2 = (Properties)properties.clone();
            properties2.remove("user");
            properties2.remove("password");
            return properties2;
        }
        return properties;
    }

    public static void close(AutoCloseable autoCloseable, Consumer<Exception> consumer) {
        block3: {
            if (autoCloseable != null) {
                try {
                    autoCloseable.close();
                }
                catch (Exception exception) {
                    if (consumer == null) break block3;
                    consumer.accept(exception);
                }
            }
        }
    }

    public static void closeQuietly(AutoCloseable autoCloseable) {
        Utils.close(autoCloseable, null);
    }

    @Deprecated
    public static void closeQuietly(Connection connection) {
        Utils.closeQuietly((AutoCloseable)connection);
    }

    @Deprecated
    public static void closeQuietly(ResultSet resultSet) {
        Utils.closeQuietly((AutoCloseable)resultSet);
    }

    @Deprecated
    public static void closeQuietly(Statement statement) {
        Utils.closeQuietly((AutoCloseable)statement);
    }

    public static Set<String> getDisconnectionSqlCodes() {
        return new HashSet<String>(DISCONNECTION_SQL_CODES);
    }

    public static String getMessage(String string) {
        return Utils.getMessage(string, null);
    }

    public static String getMessage(String string, Object ... objectArray) {
        String string2 = messages.getString(string);
        if (objectArray == null || objectArray.length == 0) {
            return string2;
        }
        MessageFormat messageFormat = new MessageFormat(string2);
        return messageFormat.format(objectArray, new StringBuffer(), (FieldPosition)null).toString();
    }

    static boolean isDisconnectionSqlCode(String string) {
        return DISCONNECTION_SQL_CODES.contains(string);
    }

    static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    static boolean isSecurityEnabled() {
        return System.getSecurityManager() != null;
    }

    public static char[] toCharArray(String string) {
        return string != null ? string.toCharArray() : null;
    }

    public static String toString(char[] cArray) {
        return cArray == null ? null : String.valueOf(cArray);
    }

    public static void validateLifetime(PooledObject<?> pooledObject, Duration duration) throws LifetimeExceededException {
        Duration duration2;
        if (duration.compareTo(Duration.ZERO) > 0 && (duration2 = Duration.between(pooledObject.getCreateInstant(), Instant.now())).compareTo(duration) > 0) {
            throw new LifetimeExceededException(Utils.getMessage("connectionFactory.lifetimeExceeded", duration2, duration));
        }
    }

    private Utils() {
    }

    static {
        EMPTY_RESULT_SET_ARRAY = new ResultSet[0];
        EMPTY_STRING_ARRAY = new String[0];
        DISCONNECTION_SQL_CODES = new HashSet<String>();
        DISCONNECTION_SQL_CODES.add("57P01");
        DISCONNECTION_SQL_CODES.add("57P02");
        DISCONNECTION_SQL_CODES.add("57P03");
        DISCONNECTION_SQL_CODES.add("01002");
        DISCONNECTION_SQL_CODES.add("JZ0C0");
        DISCONNECTION_SQL_CODES.add("JZ0C1");
    }
}

