/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks;

import com.jgoodies.common.base.SystemUtils;
import com.jgoodies.looks.LookUtils;
import java.awt.Font;
import java.awt.Toolkit;

public final class Fonts {
    public static final String TAHOMA_NAME = "Tahoma";
    public static final String SEGOE_UI_NAME = "Segoe UI";
    public static final Font TAHOMA_11PT = new Font("Tahoma", 0, 11);
    public static final Font TAHOMA_13PT = new Font("Tahoma", 0, 13);
    public static final Font TAHOMA_14PT = new Font("Tahoma", 0, 14);
    public static final Font SEGOE_UI_12PT = new Font("Segoe UI", 0, 12);
    public static final Font SEGOE_UI_13PT = new Font("Segoe UI", 0, 13);
    public static final Font SEGOE_UI_15PT = new Font("Segoe UI", 0, 15);
    public static final Font WINDOWS_XP_96DPI_NORMAL = TAHOMA_11PT;
    public static final Font WINDOWS_XP_96DPI_DEFAULT_GUI = TAHOMA_11PT;
    public static final Font WINDOWS_XP_96DPI_LARGE = TAHOMA_13PT;
    public static final Font WINDOWS_XP_120DPI_NORMAL = TAHOMA_14PT;
    public static final Font WINDOWS_XP_120DPI_DEFAULT_GUI = TAHOMA_13PT;
    public static final Font WINDOWS_VISTA_96DPI_NORMAL = SEGOE_UI_12PT;
    public static final Font WINDOWS_VISTA_96DPI_LARGE = SEGOE_UI_15PT;
    public static final Font WINDOWS_VISTA_120DPI_NORMAL = SEGOE_UI_15PT;

    private Fonts() {
    }

    static Font getDefaultGUIFontWesternModernWindowsNormal() {
        return SystemUtils.IS_LOW_RESOLUTION ? WINDOWS_XP_96DPI_DEFAULT_GUI : WINDOWS_XP_120DPI_DEFAULT_GUI;
    }

    static Font getDefaultIconFontWesternModernWindowsNormal() {
        return SystemUtils.IS_LOW_RESOLUTION ? WINDOWS_XP_96DPI_NORMAL : WINDOWS_XP_120DPI_NORMAL;
    }

    static Font getDefaultIconFontWesternWindowsVistaNormal() {
        return SystemUtils.IS_LOW_RESOLUTION ? WINDOWS_VISTA_96DPI_NORMAL : WINDOWS_VISTA_120DPI_NORMAL;
    }

    static Font getLooks1xWindowsControlFont() {
        if (!SystemUtils.IS_OS_WINDOWS) {
            throw new UnsupportedOperationException();
        }
        return Fonts.getDesktopFont("win.defaultGUI.font");
    }

    public static Font getWindowsControlFont() {
        if (!SystemUtils.IS_OS_WINDOWS) {
            throw new UnsupportedOperationException("The Windows control font can be computed only on the Windows platform.");
        }
        if (LookUtils.IS_OS_WINDOWS_95 || SystemUtils.IS_OS_WINDOWS_98 || LookUtils.IS_OS_WINDOWS_NT || SystemUtils.IS_OS_WINDOWS_ME) {
            return Fonts.getDefaultGUIFont();
        }
        return Fonts.getIconFont();
    }

    private static Font getDefaultGUIFont() {
        Font font = Fonts.getDesktopFont("win.defaultGUI.font");
        return font != null ? font : Fonts.getFallbackFont();
    }

    private static Font getIconFont() {
        Font font = Fonts.getDesktopFont("win.icon.font");
        return font != null ? font : Fonts.getFallbackFont();
    }

    private static Font getFallbackFont() {
        return new Font("Dialog", 0, 12);
    }

    private static Font getDesktopFont(String fontName) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        return (Font)toolkit.getDesktopProperty(fontName);
    }
}

