# lynx.cfg file.
# The default placement for this file is /usr/local/lib/lynx.cfg (Unix)
#                                     or Lynx_Dir:lynx.cfg (VMS)
#
#
# Definition pairs are of the form  VARIABLE:DEFINITION
# NO spaces are allowed between the pair items.
#
#  If you do not have write access to /usr/local/lib you may change
#  the default location of this file in the userdefs.h file and recompile,
#  or specify its location on the command line with the "-cfg"
#  command line option.
#
# Items may be commented out by putting a '#' as the FIRST char of the line
# (Any line beginning with punctuation is ignored).  Leading blanks on each
# line are ignored; trailing blanks may be significant depending on the option.

# An HTML'ized description of all settings (based on comments in this file,
# with alphabetical table of settings and with table of settings by category)
# is available at http://www.hippo.ru/~hvv/lynxcfg_toc.html
#
### The conversion is done via the scripts/cfg2html.pl script.
### Several directives beginning with '.' are used for this purpose.


.h1 Auxiliary Facilities
# These settings control the auxiliary navigating facilities of lynx, e.g.,
# jumpfiles, bookmarks, default URLs.


.h2 INCLUDE
# Starting with Lynx 2.8.1, the lynx.cfg file has a crude "include"
# facility.  This means that you can take advantage of the global lynx.cfg
# while also supplying your own tweaks.
#
# You can use a command-line argument (-cfg /where/is/lynx.cfg) or an
# environment variable (LYNX_CFG=/where/is/lynx.cfg).
# For instance, put in your .profile or .login:
#
#   LYNX_CFG=~/lynx.cfg; export LYNX_CFG   # in .profile for sh/ksh/bash/etc.
#   setenv LYNX_CFG ~/lynx.cfg             # in .login for [t]csh
#
# Then in ~/lynx.cfg:
#
#   INCLUDE:/usr/local/lib/lynx.cfg
#           ^^^^^^^^^^^^^^^^^^^^^^^ or whatever is appropriate on your system
# and now your own tweaks.
#
# Starting with Lynx 2.8.2, the INCLUDE facility is yet more powerful.  You can
# suppress all but specific settings that will be read from included files.
# This allows sysadmins to provide users the ability to customize lynx with
# options that normally do not affect security, such as COLOR, VIEWER, KEYMAP.
#
# The syntax is
#
#   INCLUDE:filename for <space-separated-list-of-allowed-settings>
#
# sample:
.ex
#INCLUDE:~/lynx.cfg for COLOR VIEWER KEYMAP
# only one space character should surround the word 'for'.  On Unix systems ':'
# is also accepted as separator.  In that case, the example can be written as
.ex
#INCLUDE:~/lynx.cfg:COLOR VIEWER KEYMAP
# In the example, only the settings COLOR, VIEWER and KEYMAP are accepted by
# lynx.  Other settings are ignored.  Note:  INCLUDE is also treated as a
# setting, so to allow an included file to include other files, put INCLUDE in
# the list of allowed settings.
#
# If you allow an included file to include other files, and if a list of
# allowed settings is specified for that file with the INCLUDE command, nested
# files are only allowed to include the list of settings that is the set AND of
# settings allowed for the included file and settings allowed by nested INCLUDE
# commands.  In short, there is no security hole introduced by including a
# user-defined configuration file if the original list of allowed settings is
# secure.


.h2 STARTFILE
# STARTFILE is the default starting URL if none is specified
#   on the command line or via a WWW_HOME environment variable;
#   Lynx will refuse to start without a starting URL of some kind.
# STARTFILE can be remote, e.g. http://www.w3.org/default.html ,
#                or local, e.g. file://localhost/PATH_TO/FILENAME ,
#           where PATH_TO is replaced with the complete path to FILENAME
#           using Unix shell syntax and including the device on VMS.
#
# Normally we expect you will connect to a remote site, e.g., the Lynx starting
# site:
STARTFILE:file:/usr/share/doc/HTML/index.html
#
# As an alternative, you may want to use a local URL.  A good choice for this is
# the user's home directory:
.ex
#STARTFILE:file://localhost/~/
#
# Your choice of STARTFILE should reflect your site's needs, and be a URL that
# you can connect to reliably.  Otherwise users will become confused and think
# that they cannot run Lynx.


.h2 HELPFILE
# HELPFILE must be defined as a URL and must have a
# complete path if local:
# file://localhost/PATH_TO/lynx_help/lynx_help_main.html
#   Replace PATH_TO with the path to the lynx_help subdirectory
#   for this distribution (use SHELL syntax including the device
#   on VMS systems).
# The default HELPFILE is:
# http://www.trill-home.com/lynx/lynx_help/lynx_help_main.html
#   This should be changed to the local path.
#
#HELPFILE:http://www.trill-home.com/lynx/lynx_help/lynx_help_main.html
.ex
HELPFILE:file://localhost/usr/share/doc/lynx-2.8.4/lynx_help/lynx_help_main.html



.h2 DEFAULT_INDEX_FILE
# DEFAULT_INDEX_FILE is the default file retrieved when the
# user presses the 'I' key when viewing any document.
# An index to your CWIS can be placed here or a document containing
# pointers to lots of interesting places on the web.
#
DEFAULT_INDEX_FILE:http://www.google.com/


.h1 Interaction

.h2 GOTOBUFFER
# Set GOTOBUFFER to TRUE if you want to have the previous goto URL,
# if any, offered for reuse or editing when using the 'g'oto command.
# The default is defined in userdefs.h.  If left FALSE, the circular
# buffer of previously entered goto URLs can still be invoked via the
# Up-Arrow or Down-Arrow keys after entering the 'g'oto command.
#
#GOTOBUFFER:FALSE


.h2 JUMP_PROMPT
# JUMP_PROMPT is the default statusline prompt for selecting a jumps file
# shortcut.  (see below).
# You can change the prompt here from that defined in userdefs.h.  Any
# trailing white space will be trimmed, and a single space is added by Lynx
# following the last non-white character.  You must set the default prompt
# before setting the default jumps file (below).  If a default jumps file
# was set via userdefs.h, and you change the prompt here, you must set the
# default jumps file again (below) for the change to be implemented.
#
#JUMP_PROMPT:Jump to (use '?' for list):


.h1 Auxiliary Facilities

.h2 JUMPFILE
# JUMPFILE is the local file checked for short-cut names for URLs
# when the user presses the 'j' (JUMP) key.  The user will be prompted
# to enter a short-cut name for an URL, which Lynx will then follow
# in a similar manner to 'g'oto; alternatively, s/he can enter '?'
# to view the full JUMPFILE list of short-cuts with associated URLs.
# There is an example jumps file in the samples subdirectory.
# If not defined here or in userdefs.h, the JUMP command will invoke
# the NO_JUMPFILE statusline message (see  LYMessages_en.h ).
#
# To allow '?' to work, include in the JUMPFILE
# a short-cut to the JUMPFILE itself, e.g.
# <dt>?<dd><a href="file://localhost/path/jumps.html">This Shortcut List</a>
#
# On VMS, use Unix SHELL syntax (including a lead slash) to define it.
#
# Alternate jumps files can be defined and mapped to keys here.  If the
# keys have already been mapped, then those mappings will be replaced,
# but you should leave at least one key mapped to the default jumps
# file.  You optionally may include a statusline prompt string for the
# mapping.  You must map upper and lowercase keys separately (beware of
# mappings to keys which the user can further remap via the 'o'ptions
# menu).  The format is:
#
#	JUMPFILE:path:key[:prompt]
#
# where path should begin with a '/' (i.e., not include file://localhost).
# Any white space following a prompt string will be trimmed, and a single
# space will be added by Lynx.
#
# In the following line, include the actual full local path to JUMPFILE,
# but do not include 'file://localhost' in the line.
#JUMPFILE:/FULL_LOCAL_PATH/jumps.html
.ex
#JUMPFILE:/Lynx_Dir/ips.html:i:IP or Interest group (? for list):


.h2 JUMPBUFFER
# Set JUMPBUFFER to TRUE if you want to have the previous jump target,
# if any, offered for reuse or editing when using the 'J'ump command.
# The default is defined in userdefs.h.  If left FALSE, the circular
# buffer of previously entered targets (shortcuts) can still be invoked
# via the Up-Arrow or Down-Arrow keys after entering the 'J'ump command.
# If multiple jumps files are installed, the recalls of shortcuts will
# be specific to each file.  If Lynx was built with PERMIT_GOTO_FROM_JUMP
# defined, any random URLs used instead of shortcuts will be stored in the
# goto URL buffer, not in the shortcuts buffer(s), and the single character
# ':' can be used as a target to invoke the goto URL buffer (as if 'g'oto
# followed by Up-Arrow had been entered).
#
#JUMPBUFFER:FALSE


.h1 Internal Behavior

.h2 SAVE_SPACE
# If SAVE_SPACE is defined, it will be used as a path prefix for the
# suggested filename in "Save to Disk" operations from the 'p'rint or
# 'd'ownload menus.  On VMS, you can use either VMS (e.g., "SYS$LOGIN:")
# or Unix syntax (including '~' for the HOME directory).  On Unix, you
# must use Unix syntax.  If the symbol is not defined, or is zero-length
# (""), no prefix will be used, and only a filename for saving in the
# current default directory will be suggested.
# This definition will be overridden if a "LYNX_SAVE_SPACE" environment
# variable has been set on Unix, or logical has been defined on VMS.
#
#SAVE_SPACE:~/foo/


.h2 REUSE_TEMPFILES
# Lynx uses temporary files for (among other purposes) the content of
# various user interface pages.  REUSE_TEMPFILES changes the behavior
# for some of these temp files, among them pages shown for HISTORY,
# VLINKS, OPTIONS, INFO, PRINT, DOWNLOAD commands.
# If set to TRUE, the same file can be used multiple times for the same
# purpose.  If set to FALSE, a new filename is generated each time before
# rewriting such a page.  With TRUE, repeated invocation of these commands
# is less likely to push previous documents out of the cache of rendered
# texts (see also DEFAULT_CACHE_SIZE).  This is especially useful with
# intermittent (dialup) network connections, when it is desirable to
# continue browsing through the cached documents after disconnecting.
# With the default setting of FALSE, there can be more than one incarnation
# of e.g. the VLINKS page cached in memory (but still only the most recently
# generated one is kept as a file), resulting in sometimes less surprising
# behaviour when returning to such a page via HISTORY or PREV_DOC functions
# (most users will not encounter and notice this difference).
#
#REUSE_TEMPFILES:FALSE


.h2 LYNX_HOST_NAME
# If LYNX_HOST_NAME is defined here or in userdefs.h, it will be
# treated as an alias for the local host name in checks for URLs on
# the local host (e.g., when the -localhost switch is set), and this
# host name, "localhost", and HTHostName (the fully qualified domain
# name of the system on which Lynx is running) will all be passed as
# local.  A different definition here will override that in userdefs.h.
#
#LYNX_HOST_NAME:www.cc.ukans.edu


.h2 LOCALHOST_ALIAS
# localhost aliases
# Any LOCALHOST_ALIAS definitions also will be accepted as local when
# the -localhost switch is set.  These need not actually be local, i.e.,
# in contrast to LYNX_HOST_NAME, you can define them to trusted hosts at
# other Internet sites.
#
.ex 2
#LOCALHOST_ALIAS:gopher.server.domain
#LOCALHOST_ALIAS:news.server.domain


.h2 LOCAL_DOMAIN
# LOCAL_DOMAIN is used for a tail match with the ut_host element of
# the utmp or utmpx structure on systems with utmp capabilities, to
# determine if a user is local to your campus or organization when
# handling -restrictions=inside_foo or outside_foo settings for ftp,
# news, telnet/tn3270 and rlogin URLs.  An "inside" user is assumed
# if your system does not have utmp capabilities.  CHANGE THIS here
# if it was not changed in userdefs.h at compilation time.
#
#LOCAL_DOMAIN:ukans.edu


.h1 Character sets

.h2 CHARACTER_SET
# CHARACTER_SET defines the display character set, i.e., assumed to be
# installed on the user's terminal.  It determines which characters or strings
# will be used to represent 8-bit character entities within HTML.  New
# character sets may be defined as explained in the README files of the
# src/chrtrans directory in the Lynx source code distribution.  For Asian (CJK)
# character sets, it also determines how Kanji code will be handled.  The
# default is defined in userdefs.h and can be changed here or via the
# 'o'ptions menu.  The 'o'ptions menu setting will be stored in the user's RC
# file whenever those settings are saved, and thereafter will be used as the
# default.  For Lynx a "character set" has two names:  a MIME name (for
# recognizing properly labeled charset parameters in HTTP headers etc.), and a
# human-readable string for the 'O'ptions Menu (so you may find info about
# language or group of languages besides MIME name).  Not all 'human-readable'
# names correspond to exactly one valid MIME charset (example is "Chinese");
# in that case an appropriate valid (and more specific) MIME name should be
# used where required.  Well-known synonyms are also processed in the code.
#
# Raw (CJK) mode
#
# Lynx normally translates characters from a document's charset to display
# charset, using ASSUME_CHARSET value (see below) if the document's charset
# is not specified explicitly.  Raw (CJK) mode is OFF for this case.
# When the document charset is specified explicitly, that charset
# overrides any assumption like ASSUME_CHARSET or raw (CJK) mode.
#
# For the Asian (CJK) display character sets, the corresponding charset is
# assumed in documents, i.e., raw (CJK) mode is ON by default.  In raw CJK
# mode, 8-bit characters are not reverse translated in relation to the entity
# conversion arrays, i.e., they are assumed to be appropriate for the display
# character set.  The mode should be toggled OFF when an Asian (CJK) display
# character set is selected but the document is not CJK and its charset not
# specified explicitly.
#
# Raw (CJK) mode may be toggled by user via '@' (LYK_RAW_TOGGLE) key,
# the -raw command line switch or from the 'o'ptions menu.
#
# Raw (CJK) mode effectively changes the charset assumption about unlabeled
# documents.  You can toggle raw mode ON if you believe the document has a
# charset which does correspond to your Display Character Set.  On the other
# hand, if you set ASSUME_CHARSET the same as Display Character Set you get raw
# mode ON by default (but you get assume_charset=iso-8859-1 if you try raw mode
# OFF after it).
#
# Note that "raw" does not mean that every byte will be passed to the screen.
# HTML character entities may get expanded and translated, inappropriate
# control characters filtered out, etc.  There is a "Transparent" pseudo
# character set for more "rawness".
#
# Since Lynx now supports a wide range of platforms it may be useful to note
# the cpXXX codepages used by IBM PC compatible computers, and windows-xxxx
# used by native MS-Windows apps.  We also note that cpXXX pages rarely are
# found on Internet, but are mostly for local needs on DOS.
#
# Recognized character sets include:
#
.nf
#    string for 'O'ptions Menu          MIME name
#    ===========================        =========
#    7 bit approximations (US-ASCII)    us-ascii
#    Western (ISO-8859-1)               iso-8859-1
#    Western (ISO-8859-15)              iso-8859-15
#    Western (cp850)                    cp850
#    Western (windows-1252)             windows-1252
#    IBM PC US codepage (cp437)         cp437
#    DEC Multinational                  dec-mcs
#    Macintosh (8 bit)                  macintosh
#    NeXT character set                 next
#    HP Roman8                          hp-roman8
#    Chinese                            euc-cn
#    Japanese (EUC-JP)                  euc-jp
#    Japanese (Shift_JIS)               shift_jis
#    Korean                             euc-kr
#    Taipei (Big5)                      big5
#    Vietnamese (VISCII)                viscii
#    Eastern European (ISO-8859-2)      iso-8859-2
#    Eastern European (cp852)           cp852
#    Eastern European (windows-1250)    windows-1250
#    Latin 3 (ISO-8859-3)               iso-8859-3
#    Latin 4 (ISO-8859-4)               iso-8859-4
#    Baltic Rim (cp775)                 cp775
#    Baltic Rim (windows-1257)          windows-1257
#    Cyrillic (ISO-8859-5)              iso-8859-5
#    Cyrillic (cp866)                   cp866
#    Cyrillic (windows-1251)            windows-1251
#    Cyrillic (KOI8-R)                  koi8-r
#    Arabic (ISO-8859-6)                iso-8859-6
#    Arabic (cp864)                     cp864
#    Arabic (windows-1256)              windows-1256
#    Greek (ISO-8859-7)                 iso-8859-7
#    Greek (cp737)                      cp737
#    Greek2 (cp869)                     cp869
#    Greek (windows-1253)               windows-1253
#    Hebrew (ISO-8859-8)                iso-8859-8
#    Hebrew (cp862)                     cp862
#    Hebrew (windows-1255)              windows-1255
#    Turkish (ISO-8859-9)               iso-8859-9
#    ISO-8859-10                        iso-8859-10
#    Ukrainian Cyrillic (cp866u)        cp866u
#    Ukrainian Cyrillic (KOI8-U)        koi8-u
#    UNICODE (UTF-8)                    utf-8
#    RFC 1345 w/o Intro                 mnemonic+ascii+0
#    RFC 1345 Mnemonic                  mnemonic
#    Transparent                        x-transparent
.fi
#
# The value should be the MIME name of a character set recognized by
# Lynx (case insensitive).
# Find RFC 1345 at http://www.ics.uci.edu/pub/ietf/uri/rfc1345.txt .
#
#CHARACTER_SET:iso-8859-1
CHARACTER_SET:iso-8859-2


.h2 ASSUME_CHARSET
# ASSUME_CHARSET changes the handling of documents which do not
# explicitly specify a charset.  Normally Lynx assumes that 8-bit
# characters in those documents are encoded according to iso-8859-1
# (the official default for the HTTP protocol).  When ASSUME_CHARSET
# is defined here or by an -assume_charset command line flag is in effect,
# Lynx will treat documents as if they were encoded accordingly.
# See above on how this interacts with "raw mode" and the Display
# Character Set.
# ASSUME_CHARSET can also be changed via the 'o'ptions menu but will
# not be saved as permanent value in user's .lynxrc file to avoid more chaos.
#
#ASSUME_CHARSET:iso-8859-1
ASSUME_CHARSET:iso-8859-2


.h2 ASSUMED_DOC_CHARSET_CHOICE
.h2 DISPLAY_CHARSET_CHOICE
# It is possible to reduce the number of charset choices in the 'O'ptions menu
# for "display charset" and "assumed document charset" fields via
# DISPLAY_CHARSET_CHOICE and ASSUMED_DOC_CHARSET_CHOICE settings correspondingly.
# Each of these settings can be used several times to define the set of possible
# choices for corresponding field. The syntax for the values is
#
#	string | prefix* | *
#
# where
#
#	'string' is either the MIME name of charset or it's full name (listed
#		either in the left or in the right column of table of
#		recognized charsets), case-insensitive - e.g.  'Koi8-R' or
#		'Cyrillic (KOI8-R)' (both without quotes),
#
#	'prefix' is any string, and such value will select all charsets having
#		the name with prefix matching given (case insensitive), i.e.,
#		for the charsets listed in the table of recognized charsets,
#
.ex
# ASSUMED_DOC_CHARSET_CHOICE:cyrillic*
#		will be equal to specifying
.ex 4
# ASSUMED_DOC_CHARSET_CHOICE:cp866
# ASSUMED_DOC_CHARSET_CHOICE:windows-1251
# ASSUMED_DOC_CHARSET_CHOICE:koi8-r
# ASSUMED_DOC_CHARSET_CHOICE:iso-8859-5
#		or lines with full names of charsets.
#
#	literal string '*' (without quotes) will enable all charset choices
#		in corresponding field.  This is useful for overriding site
#		defaults in private pieces of lynx.cfg included via INCLUDE
#		directive.
#
# Default values for both settings are '*', but any occurrence of settings
# with values that denote any charsets will make only listed choices available
# for corresponding field.
#ASSUMED_DOC_CHARSET_CHOICE:*
#DISPLAY_CHARSET_CHOICE:*


.h2 ASSUME_LOCAL_CHARSET
# ASSUME_LOCAL_CHARSET is like ASSUME_CHARSET but only applies to local
# files.  If no setting is given here or by an -assume_local_charset
# command line option, the value for ASSUME_CHARSET or -assume_charset
# is used.  It works for both text/plain and text/html files.
# This option will ignore "raw mode" toggling when local files are viewed
# (it is "stronger" than "assume_charset" or the effective change
# of the charset assumption caused by changing "raw mode"),
# so only use when necessary.
#
#ASSUME_LOCAL_CHARSET:iso-8859-1
ASSUME_LOCAL_CHARSET:iso-8859-2


.h2 PREPEND_CHARSET_TO_SOURCE
# PREPEND_CHARSET_TO_SOURCE:TRUE tells Lynx to prepend a META CHARSET line
# to text/html source files when they are retrieved for 'd'ownloading
# or passed to 'p'rint functions, so HTTP headers will not be lost.
# This is necessary for resolving charset for local html files,
# while the assume_local_charset is just an assumption.
# For the 'd'ownload option, a META CHARSET will be added only if the HTTP
# charset is present.  The compilation default is TRUE.
# It is generally desirable to have charset information for every local
# html file, but META CHARSET string potentially could cause
# compatibility problems with other browsers, see also PREPEND_BASE_TO_SOURCE.
# Note that the prepending is not done for -source dumps.
#
#PREPEND_CHARSET_TO_SOURCE:TRUE


.h2 NCR_IN_BOOKMARKS
# NCR_IN_BOOKMARKS:TRUE allows you to save 8-bit characters in bookmark titles
# in the unicode format (NCR).  This may be useful if you need to switch
# display charsets frequently.  This is the case when you use Lynx on different
# platforms, e.g., on UNIX and from a remote PC, and want to keep the bookmarks
# file persistent.
# Another aspect is compatibility:  NCR is part of I18N and HTML4.0
# specifications supported starting with Lynx 2.7.2, Netscape 4.0 and MSIE 4.0.
# Older browser versions will fail so keep NCR_IN_BOOKMARKS:FALSE if you
# plan to use them.
#
#NCR_IN_BOOKMARKS:FALSE


.h2 FORCE_8BIT_TOUPPER
# FORCE_8BIT_TOUPPER overrides locale settings and uses internal 8-bit
# case-conversion mechanism for case-insensitive searches in non-ASCII display
# character sets.  It is FALSE by default and should not be changed unless
# you encounter problems with case-insensitive searches.
#
#FORCE_8BIT_TOUPPER:FALSE


.h2 OUTGOING_MAIL_CHARSET
# While Lynx supports different platforms and display character sets
# we need to limit the charset in outgoing mail to reduce
# trouble for remote recipients who may not recognize our charset.
# You may try US-ASCII as the safest value (7 bit), any other MIME name,
# or leave this field blank (default) to use the display character set.
# Charset translations currently are implemented for mail "subjects= " only.
#
#OUTGOING_MAIL_CHARSET:
OUTGOING_MAIL_CHARSET:iso-8859-2


.h2 ASSUME_UNREC_CHARSET
# If Lynx encounters a charset parameter it doesn't recognize, it will
# replace the value given by ASSUME_UNREC_CHARSET (or a corresponding
# -assume_unrec_charset command line option) for it.  This can be used
# to deal with charsets unknown to Lynx, if they are "sufficiently
# similar" to one that Lynx does know about, by forcing the same
# treatment.  There is no default, and you probably should leave this
# undefined unless necessary.
#
#ASSUME_UNREC_CHARSET:iso-8859-1
ASSUME_UNREC_CHARSET:iso-8859-2

.h2 PREFERRED_LANGUAGE
# PREFERRED_LANGUAGE is the language in MIME notation (e.g., "en",
# "fr") which will be indicated by Lynx in its Accept-Language headers
# as the preferred language.  If available, the document will be
# transmitted in that language.  Users can override this setting via
# the 'o'ptions menu and save that preference in their RC file.
# This may be a comma-separated list of languages in decreasing preference.
#
#PREFERRED_LANGUAGE:en
PREFERRED_LANGUAGE:cs


.h2 PREFERRED_CHARSET
# PREFERRED_CHARSET specifies the character set in MIME notation (e.g.,
# "ISO-8859-2", "ISO-8859-5") which Lynx will indicate you prefer in
# requests to http servers using an Accept-Charsets header.  Users can
# change it via the 'o'ptions menu and save that preference in their RC file.
# The value should NOT include "ISO-8859-1" or "US-ASCII",
# since those values are always assumed by default.
# If a file in that character set is available, the server will send it.
# If no Accept-Charset header is present, the default is that any
# character set is acceptable.  If an Accept-Charset header is present,
# and if the server cannot send a response which is acceptable
# according to the Accept-Charset header, then the server SHOULD send
# an error response with the 406 (not acceptable) status code, though
# the sending of an unacceptable response is also allowed.  See RFC 2068
# (http://www.ics.uci.edu/pub/ietf/uri/rfc2068.txt).
#
#PREFERRED_CHARSET:
PREFERRED_CHARSET:iso-8859-2


.h1 Interaction

.h2 URL_DOMAIN_PREFIXES
.h2 URL_DOMAIN_SUFFIXES
# URL_DOMAIN_PREFIXES and URL_DOMAIN_SUFFIXES are strings which will be
# prepended (together with a scheme://) and appended to the first element
# of command line or 'g'oto arguments which are not complete URLs and
# cannot be opened as a local file (file://localhost/string).  Both
# can be comma-separated lists.  Each prefix must end with a dot, each
# suffix must begin with a dot, and either may contain other dots (e.g.,
# .com.jp).  The default lists are defined in userdefs.h and can be
# replaced here.  Each prefix will be used with each suffix, in order,
# until a valid Internet host is created, based on a successful DNS
# lookup (e.g., foo will be tested as www.foo.com and then www.foo.edu
# etc.).  The first element can include a :port and/or /path which will
# be restored with the expanded host (e.g., wfbr:8002/dir/lynx will
# become http://www.wfbr.edu:8002/dir/lynx).  The prefixes will not be
# used if the first element ends in a dot (or has a dot before the
# :port or /path), and similarly the suffixes will not be used if the
# the first element begins with a dot (e.g., .nyu.edu will become
# http://www.nyu.edu without testing www.nyu.com).  Lynx will try to
# guess the scheme based on the first field of the expanded host name,
# and use "http://" as the default (e.g., gopher.wfbr.edu or gopher.wfbr.
# will be made gopher://gopher.wfbr.edu).
#
#URL_DOMAIN_PREFIXES:www.
#URL_DOMAIN_SUFFIXES:.com,.edu,.net,.org


.h2 FORMS_OPTIONS
# Toggle whether the Options Menu is key-based or form-based;
# the key-based version is available only if specified at compile time.
#FORMS_OPTIONS:TRUE


.h2 PARTIAL
# Display partial pages while downloading
#PARTIAL:TRUE


.h2 PARTIAL_THRES
# Set the threshold # of lines Lynx must render before it
# redraws the screen in PARTIAL mode.  Anything < 0 implies
# use of the screen size.
#PARTIAL_THRES:-1


.h2 SHOW_KB_RATE
# While getting large files, Lynx shows the approximate rate of transfer.
# Set this to change the units shown:
# TRUE for KB/sec or FALSE for bytes/sec:  default is TRUE.
#SHOW_KB_RATE:TRUE


.h1 Timeouts

.h2 INFOSECS
.h2 MESSAGESECS
.h2 ALERTSECS
# The following three definitions set the number of seconds for
# pauses following statusline messages that would otherwise be
# replaced immediately, and are more important than the unpaused
# progress messages.  Those set by INFOSECS are also basically
# progress messages (e.g., that a prompted input has been canceled)
# and should have the shortest pause.  Those set by MESSAGESECS are
# informational (e.g., that a function is disabled) and should have
# a pause of intermediate duration.  Those set by ALERTSECS typically
# report a serious problem and should be paused long enough to read
# whenever they appear (typically unexpectedly).  The default values
# are defined in userdefs.h, and can be modified here should longer
# pauses be desired for braille-based access to Lynx.
#
#INFOSECS:1
#MESSAGESECS:2
#ALERTSECS:3


.h1 Appearance
# These settings category control the appearance of Lynx's screen and the way
# Lynx renders some tags.

.h2 USE_SELECT_POPUPS
# If USE_SELECT_POPUPS is set FALSE, Lynx will present a vertical list of
# radio buttons for the OPTIONs in SELECT blocks which lack the MULTIPLE
# attribute, instead of using a popup menu.  Note that if the MULTIPLE
# attribute is present in the SELECT start tag, Lynx always will create a
# vertical list of checkboxes for the OPTIONs.
# The default defined here or in userdefs.h can be changed via the 'o'ptions
# menu and saved in the RC file, and always can be toggled via the -popup
# command line switch.
#
#USE_SELECT_POPUPS:TRUE


.h2 SHOW_CURSOR
# SHOW_CURSOR controls whether or not the cursor is hidden or appears
# over the current link in documents or the current option in popups.
# Showing the cursor is handy if you are a sighted user with a poor
# terminal that can't do bold and reverse video at the same time or
# at all.  It also can be useful to blind users, as an alternative
# or supplement to setting LINKS_AND_FIELDS_ARE_NUMBERED or
# LINKS_ARE_NUMBERED.
# The default defined here or in userdefs.h can be changed via the
# 'o'ptions menu and saved in the RC file, and always can be toggled
# via the -show_cursor command line switch.
#
#SHOW_CURSOR:FALSE


.h2 BOLD_HEADERS
# If BOLD_HEADERS is set to TRUE the HT_BOLD default style will be acted
# upon for <H1> through <H6> headers.  The compilation default is FALSE
# (only the indentation styles are acted upon, but see BOLD_H1, below).
# On Unix, compilation with -DUNDERLINE_LINKS also will apply to the
# HT_BOLD style for headers when BOLD_HEADERS is TRUE.
#
#BOLD_HEADERS:FALSE


.h2 BOLD_H1
# If BOLD_H1 is set to TRUE the HT_BOLD default style will be acted
# upon for <H1> headers even if BOLD_HEADERS is FALSE.  The compilation
# default is FALSE.  On Unix, compilation with -DUNDERLINE_LINKS also
# will apply to the HT_BOLD style for headers when BOLD_H1 is TRUE.
#
#BOLD_H1:FALSE


.h2 BOLD_NAME_ANCHORS
# If BOLD_NAME_ANCHORS is set to TRUE the content of anchors without
# an HREF attribute, (i.e., anchors with a NAME or ID attribute) will
# have the HT_BOLD default style.  The compilation default is FALSE.
# On Unix, compilation with -DUNDERLINE_LINKS also will apply to the
# HT_BOLD style for NAME (ID) anchors when BOLD_NAME_ANCHORS is TRUE.
#
#BOLD_NAME_ANCHORS:FALSE


.h1 Internal Behavior

.h2 DEFAULT_CACHE_SIZE
.h2 DEFAULT_VIRTUAL_MEMORY_SIZE
# The DEFAULT_CACHE_SIZE specifies the number of WWW documents to be
# cached in memory at one time.
#
# This so-called cache size (actually, number) is defined in userdefs.h and
# may be modified here and/or with the command line argument -cache=NUMBER
# The minimum allowed value is 2, for the current document and at least one
# to fetch, and there is no absolute maximum number of cached documents.
# On Unix, and VMS not compiled with VAXC, whenever the number is exceeded
# the least recently displayed document will be removed from memory.
#
# On VMS compiled with VAXC, the DEFAULT_VIRTUAL_MEMORY_SIZE specifies the
# amount (bytes) of virtual memory that can be allocated and not yet be freed
# before previous documents are removed from memory.  If the values for both
# the DEFAULT_CACHE_SIZE and DEFAULT_VIRTUAL_MEMORY_SIZE are exceeded, then
# the least recently displayed documents will be freed until one or the other
# value is no longer exceeded.  The default value is defined in userdefs.h.
#
# The Unix and VMS (but not VAXC) implementations use the C library malloc's
# and calloc's for memory allocation, but procedures for taking the actual
# amount of cache into account still need to be developed.  They use only
# the DEFAULT_CACHE_SIZE value, and that specifies the absolute maximum
# number of documents to cache (rather than the maximum number only if
# DEFAULT_VIRTUAL_MEMORY_SIZE has been exceeded, as with VAXC/VAX).
#
#DEFAULT_CACHE_SIZE:10
#DEFAULT_VIRTUAL_MEMORY_SIZE:512000


.h2 SOURCE_CACHE
# SOURCE_CACHE sets the source caching behavior for Lynx:
# FILE causes Lynx to keep a temporary file for each cached document
#   containing the HTML source of the document, which it uses to regenerate
#   the document when certain settings are changed (for instance,
#   historical vs. minimal vs. valid comment parsing) instead of reloading
#   the source from the network.
# MEMORY is like FILE, except the document source is kept in memory.  You
#   may wish to adjust DEFAULT_CACHE_SIZE and DEFAULT_VIRTUAL_MEMORY_SIZE
#   accordingly.
# NONE is the default; the document source is not cached, and is reloaded
#   from the network when needed.
#
#SOURCE_CACHE:NONE


.h2 SOURCE_CACHE_FOR_ABORTED
# This setting controls what will happen with cached source for the document
# being fetched from the net if fetching was aborted (either user pressed
# 'z' or network went down). If set to KEEP, the source fetched so far will
# be preserved (and used as cache), if set to DROP lynx will drop the
# source cache for that document (i.e. only completely downloaded documents
# will be cached in that case).
#SOURCE_CACHE_FOR_ABORTED:DROP

.h2 ALWAYS_RESUBMIT_POSTS
# If ALWAYS_RESUBMIT_POSTS is set TRUE, Lynx always will resubmit forms
# with method POST, dumping any cache from a previous submission of the
# form, including when the document returned by that form is sought with
# the PREV_DOC command or via the history list.  Lynx always resubmits
# forms with method POST when a submit button or a submitting text input
# is activated, but normally retrieves the previously returned document
# if it had links which you activated, and then go back with the PREV_DOC
# command or via the history list.
#
# The default defined here or in userdefs.h can be toggled via
# the -resubmit_forms command line switch.
#
#ALWAYS_RESUBMIT_POSTS:FALSE


.h1 HTML Parsing

.h2 NO_ISMAP_IF_USEMAP
# If NO_ISMAP_IF_USEMAP is set TRUE, Lynx will not include a link to the
# server-side image map if both a server-side and client-side map for the
# same image is indicated in the HTML markup.  The compilation default is
# FALSE, such that a link with "[ISMAP]" as the link name, followed by a
# hyphen, will be prepended to the ALT string or "[USEMAP]" pseudo-ALT for
# accessing Lynx's text-based rendition of the client-side map (based on
# the content of the associated MAP element).  If the "[ISMAP]" link is
# activated, Lynx will send a 0,0 coordinate pair to the server, which
# Lynx-friendly sites can map to a for-text-client document, homologous
# to what is intended for the content of a FIG element.
#
# The compilation default, or default defined here, can be toggled via
# the "-ismap" command line switch.
#
#NO_ISMAP_IF_USEMAP:FALSE


.h2 SEEK_FRAG_MAP_IN_CUR
# If SEEK_FRAG_MAP_IN_CUR is set FALSE, then USEMAP attribute values
# (in IMG or OBJECT tags) consisting of only a fragment (USEMAP="#foo")
# will be resolved with respect to the current document's base, which
# might not be the same as the current document's URL.
# The compilation default is to use the current document's URL in all
# cases (i.e., assume the MAP is present below, if it wasn't present
# above the point in the HTML stream where the USEMAP attribute was
# detected).  Lynx's present "single pass" rendering engine precludes
# checking below before making the decision on how to resolve a USEMAP
# reference consisting solely of a fragment.
#
#SEEK_FRAG_MAP_IN_CUR:TRUE


.h2 SEEK_FRAG_AREA_IN_CUR
# If SEEK_FRAG_AREA_IN_CUR is set FALSE, then HREF attribute values
# in AREA tags consisting of only a fragment (HREF="#foo") will be
# resolved with respect to the current document's base, which might
# not be the same as the current document's URL.  The compilation
# default is to use the current document's URL, as is done for the
# HREF attribute values of Anchors and LINKs that consist solely of
# a fragment.
#
#SEEK_FRAG_AREA_IN_CUR:TRUE


.h1 CGI scripts
# These settings control Lynx's ability to execute various types of scripts.

.h2 LOCAL_EXECUTION_LINKS_ALWAYS_ON
.h2 LOCAL_EXECUTION_LINKS_ON_BUT_NOT_REMOTE
# Local execution links and scripts are by default completely disabled,
# unless a change is made to the userdefs.h file to enable them or
# the configure script is used with the corresponding options
# (--enable-exec-links and --enable-exec-scripts).
# See the Lynx source code distribution and the userdefs.h
# file for more detail on enabling execution links and scripts.
#
# If you have enabled execution links or scripts the following
# two variables control Lynx's action when an execution link
# or script is encountered.
#
# If LOCAL_EXECUTION_LINKS_ALWAYS_ON is set to TRUE any execution
# link or script will be executed no matter where it came from.
# This is EXTREMELY dangerous.  Since Lynx can access files from
# anywhere in the world, you may encounter links or scripts that
# will cause damage or compromise the security of your system.
#
# If LOCAL_EXECUTION_LINKS_ON_BUT_NOT_REMOTE is set to TRUE only
# links or scripts that reside on the local machine and are
# referenced with a URL beginning with "file://localhost/" or meet
# TRUSTED_EXEC or ALWAYS_TRUSTED_EXEC rules (see below) will be
# executed.  This is much less dangerous than enabling all execution
# links, but can still be dangerous.
#
#LOCAL_EXECUTION_LINKS_ALWAYS_ON:FALSE
#LOCAL_EXECUTION_LINKS_ON_BUT_NOT_REMOTE:FALSE


.h2 TRUSTED_EXEC
# If LOCAL_EXECUTION_LINK_ON_BUT_NOT_REMOTE is TRUE, and no TRUSTED_EXEC
# rule is defined, it defaults to "file://localhost/" and any lynxexec
# or lynxprog command will be permitted if it was referenced from within
# a document whose URL begins with that string.  If you wish to restrict the
# referencing URLs further, you can extend the string to include a trusted
# path.  You also can specify a trusted directory for http URLs, which will
# then be treated as if they were local rather than remote.  For example:
#
#	TRUSTED_EXEC:file://localhost/trusted/
#	TRUSTED_EXEC:http://www.wfbr.edu/trusted/
#
# If you also wish to restrict the commands which can be executed, create
# a series of rules with the path (Unix) or command name (VMS) following
# the string, separated by a tab.  For example:
#
# Unix:
# ====
#	TRUSTED_EXEC:file://localhost/<tab>/bin/cp
#	TRUSTED_EXEC:file://localhost/<tab>/bin/rm
# VMS:
# ===
#	TRUSTED_EXEC:file://localhost/<tab>copy
#	TRUSTED_EXEC:file://localhost/<tab>delete
#
# Once you specify a TRUSTED_EXEC referencing string, the default is
# replaced, and all the referencing strings you desire must be specified
# as a series.  Similarly, if you associate a command with the referencing
# string, you must specify all of the allowable commands as a series of
# TRUSTED_EXEC rules for that string.  If you specify ALWAYS_TRUSTED_EXEC
# rules below, you need not repeat them as TRUSTED_EXEC rules.
#
# If EXEC_LINKS and JUMPFILE have been defined, any lynxexec or lynxprog
# URLs in that file will be permitted, regardless of other settings.  If
# you also set LOCAL_EXECUTION_LINKS_ON_BUT_NOT_REMOTE:TRUE and a single
# TRUSTED_EXEC rule that will always fail (e.g., "none"), then *ONLY* the
# lynxexec or lynxprog URLs in JUMPFILE (and any ALWAYS_TRUSTED_EXEC rules,
# see below) will be allowed.  Note, however, that if Lynx was compiled with
# CAN_ANONYMOUS_JUMP set to FALSE (default is TRUE), or -restrictions=jump
# is included with the -anonymous switch at run time, then users of an
# anonymous account will not be able to access the jumps file or enter
# 'j'ump shortcuts, and this selective execution feature will be overridden
# as well (i.e., they will only be able to access lynxexec or lynxprog
# URLs which meet any ALWAYS_TRUSTED_EXEC rules).
#
#TRUSTED_EXEC:none


.h2 ALWAYS_TRUSTED_EXEC
# If EXEC_LINKS was defined, any lynxexec or lynxprog URL can be made
# always enabled by an ALWAYS_TRUSTED_EXEC rule for it.  This is useful for
# anonymous accounts in which you have disabled execution links generally,
# and may also have disabled jumps file links, but still want to allow
# execution of particular utility scripts or programs.  The format is
# like that for TRUSTED_EXEC.  For example:
#
# Unix:
# ====
#   ALWAYS_TRUSTED_EXEC:file://localhost/<tab>/usr/local/kinetic/bin/usertime
#   ALWAYS_TRUSTED_EXEC:http://www.more.net/<tab>/usr/local/kinetic/bin/who.sh
# VMS:
# ===
#   ALWAYS_TRUSTED_EXEC:file://localhost/<tab>usertime
#   ALWAYS_TRUSTED_EXEC:http://www.more.net/<tab>show users
#
# The default ALWAYS_TRUSTED_EXEC rule is "none".
#
#ALWAYS_TRUSTED_EXEC:none


.h2 TRUSTED_LYNXCGI
# Unix:
# =====
# TRUSTED_LYNXCGI rules define the permitted sources and/or paths for
# lynxcgi links (if LYNXCGI_LINKS is defined in userdefs.h).  The format
# is the same as for TRUSTED_EXEC rules (see above), but no defaults are
# defined, i.e., if no TRUSTED_LYNXCGI rules are defined here, any source
# and path for lynxcgi links will be permitted.  Example rules:
#
#	TRUSTED_LYNXCGI:file://localhost/
# 	TRUSTED_LYNXCGI:<tab>/usr/local/etc/httpd/cgi-bin/
# 	TRUSTED_LYNXCGI:file://localhost/<tab>/usr/local/www/cgi-bin/
#
# VMS:
# ====
# Do not define this.
#
#TRUSTED_LYNXCGI:none


.h2 LYNXCGI_ENVIRONMENT
# Unix:
# =====
# LYNXCGI_ENVIRONMENT adds the current value of the specified
# environment variable to the list of environment variables passed on to the
# lynxcgi script.  Useful variables are HOME, USER, etc...  If proxies
# are in use, and the script invokes another copy of lynx (or a program like
# wget) in a subsidiary role, it can be useful to add http_proxy and other
# *_proxy variables.
#
# VMS:
# ====
# Do not define this.
#
#LYNXCGI_ENVIRONMENT:


.h2 LYNXCGI_DOCUMENT_ROOT
# Unix:
# =====
# LYNXCGI_DOCUMENT_ROOT is the value of DOCUMENT_ROOT that will be passed
# to lynxcgi scripts.  If set and the URL has PATH_INFO data, then
# PATH_TRANSLATED will also be generated.  Examples:
#	LYNXCGI_DOCUMENT_ROOT:/usr/local/etc/httpd/htdocs
#	LYNXCGI_DOCUMENT_ROOT:/data/htdocs/
#
# VMS:
# ====
# Do not define this.
#
#LYNXCGI_DOCUMENT_ROOT:


.h1 Cookies

.h2 FORCE_SSL_COOKIES_SECURE
# If FORCE_SSL_COOKIES_SECURE is set to TRUE, then SSL encrypted cookies
# received from https servers never will be sent unencrypted to http
# servers.  The compilation default is to impose this block only if the
# https server included a secure attribute for the cookie.  The normal
# default or that defined here can be toggled via the -force_secure
# command line switch.
#
#FORCE_SSL_COOKIES_SECURE:FALSE


.h1 Internal Behavior

.h2 MAIL_SYSTEM_ERROR_LOGGING
#  MAIL_SYSTEM_ERROR_LOGGING will send a message to the owner of
#  the information, or ALERTMAIL if there is no owner, every time
#  that a document cannot be accessed!
#
#  NOTE:  This can generate A LOT of mail, be warned.
#
#MAIL_SYSTEM_ERROR_LOGGING:FALSE


.h2 CHECKMAIL
# If CHECKMAIL is set to TRUE, the user will be informed (via a statusline
# message) about the existence of any unread mail at startup of Lynx, and
# will get statusline messages if subsequent new mail arrives.  If a jumps
# file with a lynxprog URL for invoking mail is available, or your html
# pages include an mail launch file URL, the user thereby can access mail
# and read the messages.  The checks and statusline reports will not be
# performed if Lynx has been invoked with the -restrictions=mail switch.
#
# VMS USERS !!!
# =============
# New mail is normally broadcast as it arrives, via "unsolicited screen
# broadcasts", which can be "wiped" from the Lynx display via the Ctrl-W
# command.  You may prefer to disable the broadcasts and use CHECKMAIL
# instead (e.g., in a public account which will be used by people who
# are ignorant about VMS).
#
#CHECKMAIL:FALSE


.h1 News-groups

.h2 NNTPSERVER
# To enable news reading ability via Lynx, the environment variable NNTPSERVER
# must be set so that it points to your site's NNTP server
# (see Lynx Users Guide on environment variables).
# Lynx respects RFC 1738 (http://www.ics.uci.edu/pub/ietf/uri/rfc1738.txt)
# and does not accept a host field in news URLs (use nntp: instead of news: for
# the scheme if you wish to specify an NNTP host in a URL, as explained in the
# RFC).  If you have not set the variable externally, you can set it at run
# time via this configuration file.  It will not override an external setting.
# Note that on VMS it is set as a process logical rather than symbol, and will
# outlive the Lynx image.
# The news reading facility in Lynx is quite limited.  Lynx does not provide a
# full featured news reader with elaborate error checking and safety features.
#
#NNTPSERVER:news.server.dom


.h2 LIST_NEWS_NUMBERS
# If LIST_NEWS_NUMBERS is set TRUE, Lynx will use an ordered list and include
# the numbers of articles in news listings, instead of using an unordered
# list.  The default is defined in userdefs.h, and can be overridden here.
#
#LIST_NEWS_NUMBERS:FALSE


.h2 LIST_NEWS_DATES
# If LIST_NEWS_DATES is set TRUE, Lynx will include the dates of articles in
# news listings.  The dates always are included in the articles, themselves.
# The default is defined in userdefs.h, and can be overridden here.
#
#LIST_NEWS_DATES:FALSE


.h2 NEWS_CHUNK_SIZE
.h2 NEWS_MAX_CHUNK
# NEWS_CHUNK_SIZE and NEWS_MAX_CHUNK regulate the chunking of news article
# listings with inclusion of links for listing earlier and/or later articles.
# The defaults are defined in HTNews.c as 30 and 40, respectively.  If the
# news group contains more than NEWS_MAX_CHUNK articles, they will be listed
# in NEWS_CHUNK_SIZE chunks.  You can change the defaults here, and/or on
# the command line via -newschunksize=NUMBER and/or -newsmaxchunk=NUMBER
# switches.  Note that if the chunk size is increased, here or on the command
# line, to a value greater than the current maximum, the maximum will be
# increased to that number.  Conversely, if the maximum is set to a number
# less than the current chunk size, the chunk size will be reduced to that
# number.  Thus, you need use only one of the two switches on the command
# line, based on the direction of intended change relative to the compilation
# or configuration defaults.  The compilation defaults ensure that there will
# be at least 10 earlier articles before bothering to chunk and create a link
# for earlier articles.
#
#NEWS_CHUNK_SIZE:30
#NEWS_MAX_CHUNK:40


.h2 NEWS_POSTING
# Set NEWS_POSTING to FALSE if you do not want to support posting to
# news groups via Lynx.  If left TRUE, Lynx will use its news gateway to
# post new messages or followups to news groups, using the URL schemes
# described in the "Supported URLs" section of the online 'h'elp.  The
# posts will be attempted via the nntp server specified in the URL, or
# if none was specified, via the NNTPSERVER configuration or environment
# variable.  Links with these URLs for posting or sending followups are
# created by the news gateway when reading group listings or articles
# from nntp servers if the server indicates that it permits posting.
# The compilation default set in userdefs.h can be changed here.  If
# the default is TRUE, posting can still be disallowed via the
# -restrictions command line switch.
# The posting facility in Lynx is quite limited.  Lynx does not provide a
# full featured news poster with elaborate error checking and safety features.
#
#NEWS_POSTING:TRUE


.h2 LYNX_SIG_FILE
# LYNX_SIG_FILE defines the name of a file containing a signature which
# can be appended to email messages and news postings or followups.  The
# user will be prompted whether to append it.  It is sought in the home
# directory.  If it is in a subdirectory, begin it with a dot-slash
# (e.g., ./lynx/.lynxsig).  The definition is set in userdefs.h and can
# be changed here.
#
#LYNX_SIG_FILE:.lynxsig


.h1 Interaction
# These settings control interaction of the user with lynx.

.h2 SCROLLBAR
# If SCROLLBAR is set TRUE, Lynx will show scrollbar on windows.  With mouse
# enabled, the scrollbar strip outside the bar is clickable, and scrolls the
# window by pages.  The appearance of the scrollbar can be changed from
# LYNX_LSS file:  define attributes scroll.bar, scroll.back (for the bar, and
# for the strip along which the scrollbar moves).
#SCROLLBAR:FALSE


.h2 SCROLLBAR_ARROW
# If SCROLLBAR_ARROW is set TRUE, Lynx's scrollbar will have arrows at the
# ends.  With mouse enabled, the arrows are clickable, and scroll the window by
# 2 lines.  The appearance of the scrollbar arrows can be changed from LYNX_LSS
# file:  define attributes scroll.arrow, scroll.noarrow (for enabled-arrows,
# and disabled arrows).  An arrow is "disabled" if the bar is at this end of
# the strip.
#SCROLLBAR_ARROW:TRUE


.h2 USE_MOUSE
# If USE_MOUSE is set TRUE, Lynx (when configured with ncurses, PDcurses or
# slang) will allow the user to click with button-1 on links to select them. 
# Other mouse-usable operations include:  clicking on the top or bottom of a
# page to make it scroll up or down, clicking on the left edge to pop the
# history stack, to move to a text entry field, or manipulate a popup menu.
#
# ncurses and slang have built-in support for the xterm mouse protocol.  In
# addition, ncurses can be linked with the gpm mouse library, to automatically
# provide support for this interface in applications such as Lynx.  (Please
# read the ncurses faq to work around broken gpm configurations packaged by
# some distributors).  PDCurses implements mouse support for win32 console
# windows, as does slang.
#USE_MOUSE:FALSE


.h1 HTML Parsing
# These settings control the way Lynx parses invalid HTML
# and how it may resolve such issues.

.h2 COLLAPSE_BR_TAGS
# If COLLAPSE_BR_TAGS is set FALSE, Lynx will not collapse serial BR tags.
# If set TRUE, two or more concurrent BRs will be collapsed into a single
# line break.  Note that the valid way to insert extra blank lines in HTML
# is via a PRE block with only newlines in the block.
#
#COLLAPSE_BR_TAGS:TRUE


.h2 TAGSOUP
# If TAGSOUP is set, Lynx uses the "Tag Soup DTD" rather than "SortaSGML".
# The two approaches differ by the style of error detection and recovery.
# Tag Soup DTD allows for improperly nested tags; SortaSGML is stricter.
#TAGSOUP:FALSE


.h1 Cookies

.h2 SET_COOKIES
# If SET_COOKIES is set FALSE, Lynx will ignore Set-Cookie headers
# in http server replies.  Note that if a COOKIE_FILE is in use (see
# below) that contains cookies at startup, Lynx will still send those
# persistent cookies in requests as appropriate.  Setting SET_COOKIES
# to FALSE just prevents accepting any new cookies from servers.  To
# prevent all cookie processing (sending *and* receiving) in a session,
# make sure that PERSISTENT_COOKIES is not TRUE or that COOKIE_FILE does
# not point to a file with cookies, in addition to setting SET_COOKIES
# to FALSE.
# The default is defined in userdefs.h, and can be overridden here,
# and/or toggled via the -cookies command line switch.
#
#SET_COOKIES:TRUE


.h2 ACCEPT_ALL_COOKIES
# If ACCEPT_ALL_COOKIES is set TRUE, Lynx will accept cookies from all
# domains with no user interaction.  This is equivalent to automatically
# replying to all cookie 'Allow?' prompts with 'A'lways.  Note that it
# does not preempt validity checking, which has to be controlled separately
# (see below).
# The default is defined in userdefs.h and can be overridden here, or
# in the .lynxrc file via an o(ptions) screen setting.  It may also be
# toggled via the -accept_all_cookies command line switch.
#
#ACCEPT_ALL_COOKIES:FALSE


.h2 COOKIE_ACCEPT_DOMAINS
.h2 COOKIE_REJECT_DOMAINS
# COOKIE_ACCEPT_DOMAINS and COOKIE_REJECT_DOMAINS are comma-delimited lists
# of domains from which Lynx should automatically accept or reject cookies
# without asking for confirmation.  If the same domain is specified in both
# lists, rejection will take precedence.
# Note that in order to match cookies, domains have to be spelled out exactly
# in the form in which they would appear on the Cookie Jar page (case is
# insignificant).  They are not wildcards.  Domains that apply to more than
# one host have a leading '.', but have to match *the cookie's* domain
# exactly.
#
#COOKIE_ACCEPT_DOMAINS:
#COOKIE_REJECT_DOMAINS:


.h2 COOKIE_LOOSE_INVALID_DOMAINS
.h2 COOKIE_STRICT_INVALID_DOMAINS
.h2 COOKIE_QUERY_INVALID_DOMAINS
# COOKIE_LOOSE_INVALID_DOMAINS, COOKIE_STRICT_INVALID_DOMAINS, and
# COOKIE_QUERY_INVALID_DOMAINS are comma-delimited lists of domains.
# They control the degree of validity checking that is applied to cookies
# for the specified domains.
# Note that in order to match cookies, domains have to be spelled out exactly
# in the form in which they would appear on the Cookie Jar page (case is
# insignificant).  They are not wildcards.  Domains that apply to more than
# one host have a leading '.', but have to match *the cookie's* domain
# exactly.
# If a domain is set to strict checking, strict conformance to RFC2109 will
# be applied.  A domain with loose checking will be allowed to set cookies
# with an invalid path or domain attribute.  All domains will default to
# asking the user for confirmation in case of an invalid path or domain.
# Cookie validity checking takes place as a separate step before the
# final decision to accept or reject (see previous options), therefore
# a cookie that passes validity checking may still be automatically
# rejected or cause another prompt.
#
#COOKIE_LOOSE_INVALID_DOMAINS:
#COOKIE_STRICT_INVALID_DOMAINS:
#COOKIE_QUERY_INVALID_DOMAINS:


.h2 PERSISTENT_COOKIES
# PERSISTENT_COOKIES indicates that cookies should be read at startup from
# the COOKIE_FILE, and saved at exit for storage between Lynx sessions.
# It is not used if Lynx was compiled without EXP_PERSISTENT_COOKIES.
# The default is FALSE, so that the feature needs to be enabled here
# explicitly if you want it.
#
#PERSISTENT_COOKIES:FALSE


.h2 COOKIE_FILE
# COOKIE_FILE is the default file from which persistent cookies are read
# at startup (if the file exists), if Lynx was compiled with
# EXP_PERSISTENT_COOKIES and the PERSISTENT_COOKIES option is enabled.
# The cookie file can also be specified in .lynxrc or on the command line.
#
#COOKIE_FILE:~/.lynx_cookies


.h2 COOKIE_SAVE_FILE
# COOKIE_SAVE_FILE is the default file in which persistent cookies are
# stored at exit, if Lynx was compiled with EXP_PERSISTENT_COOKIES and the
# PERSISTENT_COOKIES option is enabled.  The cookie save file can also be
# specified on the command line.
#
# With an interactive Lynx session, COOKIE_SAVE_FILE will default to
# COOKIE_FILE if it is not set.  With a non-interactive Lynx session (e.g.,
# -dump), cookies will only be saved to file if COOKIE_SAVE_FILE is set.
#
#COOKIE_SAVE_FILE:~/.lynx_cookies


.h1 Mail-related

.h2 SYSTEM_MAIL
.h2 SYSTEM_MAIL_FLAGS
# VMS:
# ===
# The mail command and qualifiers are defined in userdefs.h.  Lynx
# will spawn a subprocess to send replies and error messages.  The
# command, and qualifiers (if any), can be re-defined here.  If
# you use PMDF then headers will we passed via a header file.
# If you use "generic" VMS MAIL, the subject will be passed on the
# command line via a /subject="SUBJECT" qualifier, and inclusion
# of other relevant headers may not be possible.
# If your mailer uses another syntax, some hacking of the mailform()
# mailmsg() and reply_by_mail() functions in LYMail.c, and send_file_to_mail()
# function in LYPrint.c, may be required.
#
.ex 2
#SYSTEM_MAIL:PMDF SEND
#SYSTEM_MAIL_FLAGS:/headers
#
.ex 2
#SYSTEM_MAIL:MAIL
#SYSTEM_MAIL_FLAGS:
#
# Unix:
#======
# The mail path and flags normally are defined for sendmail (or submit
# with MMDF) in userdefs.h.  You can change them here, but should first
# read the zillions of CERT advisories about security problems with Unix
# mailers.
#
.ex 2
#SYSTEM_MAIL:/usr/mmdf/bin/submit
#SYSTEM_MAIL_FLAGS:-mlruxto,cc\*
#
.ex 2
#SYSTEM_MAIL:/usr/sbin/sendmail
#SYSTEM_MAIL_FLAGS:-t -oi
#
.ex 2
#SYSTEM_MAIL:/usr/lib/sendmail
#SYSTEM_MAIL_FLAGS:-t -oi

# Win32:
#=======
# Please read sendmail.txt in the LYNX_W32.ZIP distribution
#
#SYSTEM_MAIL:sendmail -f me@my.host -h my.host -r my.smtp.mailer -m SMTP


.h2 MAIL_ADRS
# VMS ONLY:
# ========
# MAIL_ADRS is defined in userdefs.h and normally is structured for PMDF's
# IN%"INTERNET_ADDRESS" scheme.  The %s is replaced with the address given
# by the user.  If you are using a different Internet mail transport, change
# the IN appropriately (e.g., to SMTP, MX, or WINS).
#
#MAIL_ADRS:"IN%%""%s"""


.h2 USE_FIXED_RECORDS
# VMS ONLY:
# ========
# If USE_FIXED_RECORDS is set to TRUE here or in userdefs.h, Lynx will
# convert 'd'ownloaded binary files to FIXED 512 record format before saving
# them to disk or acting on a DOWNLOADER option.  If set to FALSE, the
# headers of such files will indicate that they are Stream_LF with Implied
# Carriage Control, which is incorrect, and can cause downloading software
# to get confused and unhappy.  If you do set it FALSE, you can use the
# FIXED512.COM command file, which is included in this distribution, to do
# the conversion externally.
#
#USE_FIXED_RECORDS:TRUE


.h1 Keyboard Input
# These settings control the way Lynx interprets user input.


.h2 VI_KEYS_ALWAYS_ON
.h2 EMACS_KEYS_ALWAYS_ON
# Vi or Emacs movement keys, i.e. familiar hjkl or ^N^P^F^B .
# These are defaults, which can be changed in the Options Menu or .lynxrc .
#VI_KEYS_ALWAYS_ON:FALSE
#EMACS_KEYS_ALWAYS_ON:FALSE


.h2 DEFAULT_KEYPAD_MODE
# DEFAULT_KEYPAD_MODE may be set to NUMBERS_AS_ARROWS
#                                or LINKS_ARE_NUMBERED
#                                or LINKS_AND_FIELDS_ARE_NUMBERED
# to specify whether numbers (e.g. [10]) appear before all links,
# allowing immediate access by entering the number on the keyboard,
# or numbers on the numeric key-pad work like arrows;
# the 3rd option causes form fields also to be preceded by numbers.
# The first two options (but not the last) can be changed in lynx.cfg
# and all three can be changed via the Options Menu.
#
#DEFAULT_KEYPAD_MODE:NUMBERS_AS_ARROWS


.h2 DEFAULT_KEYPAD_MODE_IS_NUMBERS_AS_ARROWS
# Obsolete form of DEFAULT_KEYPAD_MODE,
# numbers work like arrows or numbered links.
# Set to TRUE, indicates numbers act as arrows,
# and set to FALSE indicates numbers refer to numbered links on the page.
# LINKS_AND_FIELDS_ARE_NUMBERED cannot be set by this option because
# it allows only two values (true and false).
#
#DEFAULT_KEYPAD_MODE_IS_NUMBERS_AS_ARROWS:TRUE


.h2 CASE_SENSITIVE_ALWAYS_ON
# The default search type.
# This is a default that can be overridden by the user!
#
#CASE_SENSITIVE_ALWAYS_ON:FALSE


.h1 Auxiliary Facilities

.h2 DEFAULT_BOOKMARK_FILE
# DEFAULT_BOOKMARK_FILE is the filename used for storing personal bookmarks.
# It will be prepended by the user's home directory.
# NOTE that a file ending in .html or other suffix mapped to text/html
# should be used to ensure its treatment as HTML.  The built-in default
# is lynx_bookmarks.html.  On both Unix and VMS, if a subdirectory off of
# the HOME directory is desired, the path should begin with "./" (e.g.,
# ./BM/lynx_bookmarks.html), but the subdirectory must already exist.
# Lynx will create the bookmark file, if it does not already exist, on
# the first ADD_BOOKMARK attempt if the HOME directory is indicated
# (i.e., if the definition is just filename.html without any slashes),
# but requires a pre-existing subdirectory to create the file there.
# The user can re-define the default bookmark file, as well as a set
# of sub-bookmark files if multiple bookmark file support is enabled
# (see below), via the 'o'ptions menu, and can save those definitions
# in the .lynxrc file.
#
#DEFAULT_BOOKMARK_FILE:lynx_bookmarks.html


.h2 MULTI_BOOKMARK_SUPPORT
# If MULTI_BOOKMARK_SUPPORT is set TRUE, and BLOCK_MULTI_BOOKMARKS (see
# below) is FALSE, and sub-bookmarks exist, all bookmark operations will
# first prompt the user to select an active sub-bookmark file or the
# default bookmark file.  FALSE is the default so that one (the default)
# bookmark file will be available initially.  The definition here will
# override that in userdefs.h.  The user can turn on multiple bookmark
# support via the 'o'ptions menu, and can save that choice as the startup
# default via the .lynxrc file.  When on, the setting can be STANDARD or
# ADVANCED.  If SUPPORT is set to the latter, and the user mode also is
# ADVANCED, the VIEW_BOOKMARK command will invoke a statusline prompt at
# which the user can enter the letter token (A - Z) of the desired bookmark,
# or '=' to get a menu of available bookmark files.  The menu always is
# presented in NOVICE or INTERMEDIATE mode, or if the SUPPORT is set to
# STANDARD.  No prompting or menu display occurs if only one (the startup
# default) bookmark file has been defined (define additional ones via the
# 'o'ptions menu).  The startup default, however set, can be overridden on
# the command line via the -restrictions=multibook or the -anonymous or
# -validate switches.
#
#MULTI_BOOKMARK_SUPPORT:FALSE


.h2 BLOCK_MULTI_BOOKMARKS
# If BLOCK_MULTI_BOOKMARKS is set TRUE, multiple bookmark support will
# be forced off, and cannot to toggled on via the 'o'ptions menu.  The
# compilation setting is normally FALSE, and can be overridden here.
# It can also be set via the -restrictions=multibook or the -anonymous
# or -validate command line switches.
#
#BLOCK_MULTI_BOOKMARKS:FALSE


.h1 Interaction

.h2 DEFAULT_USER_MODE
# DEFAULT_USER_MODE sets the default user mode for Lynx users.
# NOVICE shows a three line help message at the bottom of the screen.
# INTERMEDIATE shows normal amount of help (one line).
# ADVANCED help is replaced by the URL of the current link.
#
#DEFAULT_USER_MODE:NOVICE


.h1 External Programs

.h2 DEFAULT_EDITOR
# If DEFAULT_EDITOR is defined, users may edit local documents with it
# & it will also be used for sending mail messages.
# If no editor is defined here or by the user,
# the user will not be able to edit local documents
# and a primitive line-oriented mail-input mode will be used.
#
# For sysadmins: do not define a default editor
# unless you know EVERY user will know how to use it;
# users can easily define their own editor in the Options Menu.
#
#DEFAULT_EDITOR:


.h2 SYSTEM_EDITOR
# SYSTEM_EDITOR behaves the same as DEFAULT_EDITOR,
# except that it can't be changed by users.
#
#SYSTEM_EDITOR:


.h1 Proxy

.h2 HTTP_PROXY
.h2 HTTPS_PROXY
.h2 FTP_PROXY
.h2 GOPHER_PROXY
.h2 NEWSPOST_PROXY
.h2 NEWSREPLY_PROXY
.h2 NEWS_PROXY
.h2 NNTP_PROXY
.h2 SNEWSPOST_PROXY
.h2 SNEWSREPLY_PROXY
.h2 SNEWS_PROXY
.h2 WAIS_PROXY
.h2 FINGER_PROXY
.h2 CSO_PROXY
# Lynx version 2.2 and beyond supports the use of proxy servers that can act as
# firewall gateways and caching servers.  They are preferable to the older
# gateway servers.  Each protocol used by Lynx can be mapped separately using
# PROTOCOL_proxy environment variables (see Lynx Users Guide).  If you have not set
# them externally, you can set them at run time via this configuration file.
# They will not override external settings.  The no_proxy variable can be used
# to inhibit proxying to selected regions of the Web (see below).  Note that on
# VMS these proxy variables are set as process logicals rather than symbols, to
# preserve lowercasing, and will outlive the Lynx image.
#
.ex 15
#http_proxy:http://some.server.dom:port/
#https_proxy:http://some.server.dom:port/
#ftp_proxy:http://some.server.dom:port/
#gopher_proxy:http://some.server.dom:port/
#news_proxy:http://some.server.dom:port/
#newspost_proxy:http://some.server.dom:port/
#newsreply_proxy:http://some.server.dom:port/
#snews_proxy:http://some.server.dom:port/
#snewspost_proxy:http://some.server.dom:port/
#snewsreply_proxy:http://some.server.dom:port/
#nntp_proxy:http://some.server.dom:port/
#wais_proxy:http://some.server.dom:port/
#finger_proxy:http://some.server.dom:port/
#cso_proxy:http://some.server.dom:port/
#no_proxy:host.domain.dom


.h2 NO_PROXY
# The no_proxy variable can be a comma-separated list of strings defining
# no-proxy zones in the DNS domain name space.  If a tail substring of the
# domain-path for a host matches one of these strings, transactions with that
# node will not be proxied.
.ex
#no_proxy:domain.path1,path2
#
# A single asterisk as an entry will override all proxy variables and no
# transactions will be proxied.
.ex
#no_proxy:*
# This is the only allowed use of * in no_proxy.
#
# Warning:  Note that setting 'il' as an entry in this list will block proxying
# for the .mil domain as well as the .il domain.  If the entry is '.il' this
# will not happen.


.h1 External Programs

.h2 PRINTER
.h2 DOWNLOADER
.h2 UPLOADER
# PRINTER, DOWNLOADER & UPLOADER DEFINITIONS:
# Lynx has 4 pre-defined print options & 1 pre-defined download option,
# which are called up on-screen when `p' or `d' are entered;
# any number of options can be added by the user, as explained below.
# Uploaders can be defined only for UNIX with DIRED_SUPPORT:
# see the Makefile in the top directory & the header of src/LYUpload.c .
#
# For `p' pre-defined options are: `Save to local file', `E-mail the file',
# `Print to screen' and `Print to local printer attached to vt100'.
# `Print to screen' allows file transfers in the absence of alternatives
# and is often the only option allowed here for anonymous users;
# the 3rd & 4th options are not pre-defined for DOS/WINDOWS versions of Lynx.
# For `d' the pre-defined option is: `Download to local file'.
#
# To define your own print or download option use the following formats:
#
# PRINTER:<name>:<command>:<option>:<lines/page>
#
# DOWNLOADER:<name>:<command>:<option>
#
# <name>       is what you will see on the print/download screen.
#
# <command>    is the command your system will execute:
#              the 1st %s in the command will be replaced
#              by the temporary filename used by Lynx;
#              a 2nd %s will be replaced by a filename of your choice,
#              for which Lynx will prompt, offering a suggestion.
#              On Unix, which has pipes, you may use a '|' as the first
#              character of the command, and Lynx will open a pipe to
#              the command.
#              If the command format of your printer/downloader requires
#              a different layout, you will need to use a script
#              (see the last 2 download examples below).
#
# <option>     TRUE : the printer/downloader will always be ENABLED,
#              except that downloading is disabled when -validate is used;
#              FALSE : both will be DISABLED for anonymous users
#              and printing will be disabled when -noprint is used.
#
# <lines/page> (printers: optional) the number of lines/page (default 66):
#              used to compute the approximate output size
#              and prompt if the document is > 4 printer pages;
#              it uses current screen length for the computation
#              when `Print to screen' is selected.
#
# You must put the whole definition on one line;
# if you use a colon, precede it with a backslash.
#
# `Printer' can be any file-handling program you find useful,
# even if it does not physically print anything.
#
# Usually, down/up-loading involves the use of (e.g.) Ckermit or ZModem
# to transfer files to a user's local machine over a serial link,
# but download options do not have to be download-protocol programs.
#
# Printer examples:
.ex 3
#PRINTER:Computer Center printer:lpr -Pccprt %s:FALSE
#PRINTER:Office printer:lpr -POffprt %s:TRUE
#PRINTER:VMS printer:print /queue=cc$print %s:FALSE:58
# If you have a very busy VMS print queue
# and Lynx deletes the temporary files before they have been queued,
# use the VMSPrint.com included in the distribution:
.ex
#PRINTER:Busy VMS printer:@Lynx_Dir\:VMSPrint sys$print %s:FALSE:58
# To specify a print option at run-time:
# NBB if you have ANONYMOUS users, DO NOT allow this option!
.ex
#PRINTER:Specify at run-time:echo -n "Enter a print command\: "; read word; sh -c "$word %s":FALSE
# To pass to a sophisticated file viewer: -k suppresses invocation
# of hex display mode if 8-bit or control characters are present;
# +s invokes secure mode (see ftp://space.mit.edu/pub/davis/most):
.ex
#PRINTER:Use Most to view:most -k +s %s:TRUE:23
#
# Downloader examples:
# in Kermit, -s %s is the filename sent, -a %s the filename on arrival
# (if they are given in reverse order here, the command will fail):
.ex
#DOWNLOADER:Use Kermit to download to the terminal:kermit -i -s %s -a %s:TRUE
# NB don't use -k with Most, so that binaries will invoke hexadecimal mode:
.ex
#DOWNLOADER:Use Most to view:most +s %s:TRUE
# The following example gives wrong filenames
# (`sz' doesn't support a suggested filename parameter):
.ex
#DOWNLOADER:Use Zmodem to download to the local terminal:sz %s:TRUE
# The following example returns correct filenames
# by using a script to make a subdirectory in /tmp,
# but may conflict with very strong security or permissions restrictions:
.ex
#DOWNLOADER:Use Zmodem to download to the local terminal:set %s %s;td=/tmp/Lsz$$;mkdir $td;ln -s $1 $td/"$2";sz $td/"$2";rm -r $td:TRUE
.ex 2
#UPLOADER:Use Kermit to upload from your computer: kermit -i -r -a %s:TRUE
#UPLOADER:Use Zmodem to upload from your computer: rz %s:TRUE
#
# Note for OS/390: /* S/390 -- gil -- 1464 */
# The following is strongly recommended to undo ASCII->EBCDIC conversion.
.ex
#DOWNLOADER:Save OS/390 binary file: iconv -f IBM-1047 -t ISO8859-1 %s >%s:FALSE

# Added by Red Hat: 
DOWNLOADER:View with less:less %s:TRUE 


.h1 Interaction

.h2 NO_DOT_FILES
# If NO_DOT_FILES is TRUE (normal default via userdefs.h), the user will not
# be allowed to specify files beginning with a dot in reply to output filename
# prompts, and files beginning with a dot (e.g., file://localhost/path/.lynxrc)
# will not be included in the directory browser's listings.  If set FALSE, you
# can force it to be treated as TRUE via -restrictions=dotfiles.  If set FALSE
# and not forced TRUE, the user can regulate it via the 'o'ptions menu (and
# may save the preference in the RC file).
#
#NO_DOT_FILES:TRUE


.h1 Internal Behavior

.h2 NO_FROM_HEADER
# If NO_FROM_HEADER is set FALSE, From headers will be sent in transmissions
# to http or https servers if the personal_mail_address has been defined via
# the 'o'ptions menu.  The compilation default is TRUE (no From header is
# sent) and the default can be changed here.  The default can be toggled at
# run time via the -from switch.  Note that transmissions of From headers
# have become widely considered to create an invasion of privacy risk.
#
#NO_FROM_HEADER:TRUE


.h2 NO_REFERER_HEADER
# If NO_REFERER_HEADER is TRUE, Referer headers never will be sent in
# transmissions to servers.  Lynx normally sends the URL of the document
# from which the link was derived, but not for startfile URLs, 'g'oto
# URLs, 'j'ump shortcuts, bookmark file links, history list links, or
# URLs that include the content from form submissions with method GET.
# If left FALSE here, it can be set TRUE at run time via the -noreferer
# switch.
#
#NO_REFERER_HEADER:FALSE


.h1 Internal Behavior

.h2 NO_FILE_REFERER
# If NO_FILE_REFERER is TRUE, Referer headers never will be sent in
# transmissions to servers for links or actions derived from documents
# or forms with file URLs.  This ensures that paths associated with
# the local file system are never indicated to servers, even if
# NO_REFERER_HEADER is FALSE.  If set to FALSE here, it can still be
# set TRUE at run time via the -nofilereferer switch.
#
#NO_FILE_REFERER:TRUE


.h2 REFERER_WITH_QUERY
# REFERER_WITH_QUERY controls what happens when the URL in a Referer
# header to be sent would contain a query part in the form of a '?'
# character followed by one or more attribute=value pairs.  Query parts
# often contain sensitive or personal information resulting from filling
# out forms, or other info that allows tracking of a user's browsing path
# through a site, an thus should not be put in a Referer header (which may
# get sent to an unrelated third-party site).  On the other hand, some
# sites (improperly) rely on browsers sending Referer headers, even when
# the user is coming from a page whose URL has a query part.
#
# If REFERER_WITH_QUERY is SEND, full Referer headers will be sent
# including the query part (unless sending of Referer is disabled in
# general, see NO_REFERER_HEADER above).  If REFERER_WITH_QUERY is
# PARTIAL, the Referer header will contain a partial URL, with the query
# part stripped off.  This is not strictly correct, but should satisfy
# those sites that check only whether the user arrived at a page from an
# "outside" link.  If REFERER_WITH_QUERY is set to DROP (or anything else
# unrecognized), the default, no Referer header is sent at all in this
# situation.
#
#REFERER_WITH_QUERY:DROP


.h1 Appearance

.h2 VERBOSE_IMAGES
# VERBOSE_IMAGES controls whether Lynx replaces [LINK], [INLINE] and [IMAGE]
# (for images without ALT) with filenames of these images.
# This can be useful in determining what images are important
# and which are mere decorations, e.g. button.gif, line.gif,
# provided the author uses meaningful names.
#
# The definition here will override the setting in userdefs.h.
#
#VERBOSE_IMAGES:TRUE


.h2 MAKE_LINKS_FOR_ALL_IMAGES
# If MAKE_LINKS_FOR_ALL_IMAGES is TRUE, all images will be given links
# which can be ACTIVATEd.  For inlines, the ALT or pseudo-ALT ("[INLINE]")
# strings will be links for the resolved SRC rather than just text.
# For ISMAP or other graphic links, ALT or pseudo-ALT ("[ISMAP]" or "[LINK]")
# will have '-' and a link labeled "[IMAGE]" for the resolved SRC appended.
# See also VERBOSE_IMAGES flag.
#
# The definition here will override that in userdefs.h
# and can be toggled via an "-image_links" command-line switch.
# The user can also use the LYK_IMAGE_TOGGLE key (default `*')
# or `Show Images' in the Form-based Options Menu.
#
#MAKE_LINKS_FOR_ALL_IMAGES:FALSE

.h2 MAKE_PSEUDO_ALTS_FOR_INLINES
# If MAKE_PSEUDO_ALTS_FOR_INLINES is FALSE, inline images which don't specify
# an ALT string will not have "[INLINE]" inserted as a pseudo-ALT,
# i.e. they'll be treated as having ALT="".
# Otherwise (if TRUE), pseudo-ALTs will be created for inlines,
# so that they can be used as links to the SRCs.
# See also VERBOSE_IMAGES flag.
#
# The definition here will override that in userdefs.h
# and can be toggled via a "-pseudo_inlines" command-line switch.
# The user can also use the LYK_INLINE_TOGGLE key (default `[')
# or `Show Images' in the Form-based Options Menu.
#
#MAKE_PSEUDO_ALTS_FOR_INLINES:TRUE


.h2 SUBSTITUTE_UNDERSCORES
# If SUBSTITUTE_UNDERSCORES is TRUE, the _underline_ format will be used
# for emphasis tags in dumps.
#
# The default defined here will override that in userdefs.h, and the user
# can toggle the default via a "-underscore" command line switch.
#
#SUBSTITUTE_UNDERSCORES:FALSE


.h1 Interaction

.h2 QUIT_DEFAULT_YES
# If QUIT_DEFAULT_YES is TRUE then when the QUIT command is entered, any
# response other than n or N will confirm.  It should be FALSE if you
# prefer the more conservative action of requiring an explicit Y or y to
# confirm.  The default defined here will override that in userdefs.h.
#
#QUIT_DEFAULT_YES:TRUE


.h1 HTML Parsing

.h2 HISTORICAL_COMMENTS
# If HISTORICAL_COMMENTS is TRUE, Lynx will revert to the "Historical"
# behavior of treating any '>' as a terminator for comments, instead of
# seeking a valid '-->' terminator (note that white space can be present
# between the '--' and '>' in valid terminators).  The compilation default
# is FALSE.
#
# The compilation default, or default defined here, can be toggled via a
# "-historical" command line switch, and via the LYK_HISTORICAL command key.
#
#HISTORICAL_COMMENTS:FALSE


.h2 MINIMAL_COMMENTS
# If MINIMAL_COMMENTS is TRUE, Lynx will not use Valid comment parsing
# of '--' pairs as serial comments within an overall comment element,
# and instead will seek only a '-->' terminator for the overall comment
# element.  This emulates the Netscape v2.0 comment parsing bug, and
# will help Lynx cope with the use of dashes as "decorations", which
# consequently has become common in so-called "Enhanced for Netscape"
# pages.  Note that setting Historical comments on will override the
# Minimal or Valid setting.
#
# The compilation default for MINIMAL_COMMENTS is FALSE, but we'll
# set it TRUE here, until Netscape gets its comment parsing right,
# and "decorative" dashes cease to be so common.
#
# The compilation default, or default defined here, can be toggled via a
# "-minimal" command line switch, and via the LYK_MINIMAL command key.
#
MINIMAL_COMMENTS:TRUE


.h2 SOFT_DQUOTES
# If SOFT_DQUOTES is TRUE, Lynx will emulate the invalid behavior of
# treating '>' as a co-terminator of a double-quoted attribute value
# and the tag which contains it, as was done in old versions of Netscape
# and Mosaic.  The compilation default is FALSE.
#
# The compilation default, or default defined here, can be toggled via
# a "-soft_dquotes" command line switch.
#
#SOFT_DQUOTES:FALSE


.h2 STRIP_DOTDOT_URLS
# If STRIP_DOTDOT_URLS is TRUE, Lynx emulates the invalid behavior of many
# browsers to strip a leading "../" segment from relative URLs in HTML
# documents with a http or https base URL, if this would otherwise lead to
# an absolute URLs with those characters still in it.  Such URLs are normally
# erroneous and not what is intended by page authors.  Lynx will issue
# a warning message when this occurs.
#
# If STRIP_DOTDOT_URLS is FALSE, Lynx will use those URLs for requests
# without taking any special actions or issuing Warnings, in most cases
# this will result in an error response from the server.
#
# Note that Lynx never tries to fix similar URLs for protocols other than
# http and https, since they are less common and may actually be valid in
# some cases.
#
#STRIP_DOTDOT_URLS:TRUE


.h1 Appearance

.h2 ENABLE_SCROLLBACK
# If ENABLE_SCROLLBACK is TRUE, Lynx will clear the entire screen before
# displaying each new screenful of text.  Though less efficient for normal
# use, this allows programs that maintain a buffer of previously-displayed
# text to recognize the continuity of what has been displayed, so that
# previous screenfuls can be reviewed by whatever method the program uses
# to scroll back through previous text.  For example, the PC comm program
# QModem has a key that can be pressed to scroll back; if ENABLE_SCROLLBACK
# is TRUE, pressing the scrollback key will access previous screenfuls which
# will have been stored on the local PC and will therefore be displayed
# instantaneously, instead of needing to be retransmitted by Lynx at the
# speed of the comm connection (but Lynx will not know about the change,
# so you must restore the last screen before resuming with Lynx commands).
#
# The compilation default is FALSE (if REVERSE_CLEAR_SCREEN_PROBLEM was not
# defined in the Unix Makefile to invoke this behavior as a workaround for
# some poor curses implementations).
#
# The default compilation or configuration setting can be toggled via an
# "-enable_scrollback" command line switch.
#
#ENABLE_SCROLLBACK:FALSE


.h2 SCAN_FOR_BURIED_NEWS_REFS
# If SCAN_FOR_BURIED_NEWS_REFS is set to TRUE, Lynx will scan the bodies
# of news articles for buried article and URL references and convert them
# to links.  The compilation default is TRUE, but some email addresses
# enclosed in angle brackets ("<user@address>") might be converted to false
# news links, and uuencoded messages might be corrupted.  The conversion is
# not done when the display is toggled to source or when 'd'ownloading, so
# uuencoded articles can be saved intact regardless of these settings.
#
# The default setting can be toggled via a "-buried_news" command line
# switch.
#
#SCAN_FOR_BURIED_NEWS_REFS:TRUE


.h2 PREPEND_BASE_TO_SOURCE
# If PREPEND_BASE_TO_SOURCE is set to FALSE, Lynx will not prepend a
# Request URL comment and BASE element to text/html source files when
# they are retrieved for 'd'ownloading or passed to 'p'rint functions.
# The compilation default is TRUE.  Note that this prepending is not
# done for -source dumps, unless the -base switch also was included on
# the command line, and the latter switch overrides the setting of the
# PREPEND_BASE_TO_SOURCE configuration variable.
#
#PREPEND_BASE_TO_SOURCE:TRUE


# MIME types and viewers!
#
# file extensions may be assigned to MIME types using
# the SUFFIX: definition.
#
# NOTE: It is normally preferable to define new extension mappings in
#       EXTENSION_MAP files (see below) instead of here:  Definitions
#       here are overridden by those in EXTENSION_MAP files and even by
#       some built-in defaults in src/HTInit.c.  On the other hand,
#       definitions here allow some more fields that are not possible
#       in those files.
#
#       Extension mappings have an effect mostly for ftp and local files,
#       they are NOT used to determine the type of content for URLs with
#       the http protocol.  This is because HTTP servers already specify
#       the MIME type in the Content-Type header.  [It may still be
#       necessary to set up an appropriate suffix for some MIME types,
#       even if they are accessed only via the HTTP protocol, if the viewer
#       (see below) for those MIME types requires a certain suffix for the
#       temporary file passed to it.]


.h1 External Programs

.h2 GLOBAL_EXTENSION_MAP
.h2 PERSONAL_EXTENSION_MAP
# The global and personal EXTENSION_MAP files allow you to assign extensions
# to MIME types which will override any of the suffix maps in this (lynx.cfg)
# configuration file, or in src/HTInit.c.  See the example mime.types file
# in the samples subdirectory.
#
# Unix:
# ====
#GLOBAL_EXTENSION_MAP:/usr/local/lib/mosaic/mime.types
# VMS:
# ===
#GLOBAL_EXTENSION_MAP:Lynx_Dir:mime.types
#
#	Unix (sought in user's home directory):
#PERSONAL_EXTENSION_MAP:.mime.types
#	VMS (sought in user's sys$login directory):
#PERSONAL_EXTENSION_MAP:mime.types


.h2 SUFFIX_ORDER
# With SUFFIX_ORDER the precedence of suffix mappings can be changed.
# Two kinds of settings are recognized:
#
#    PRECEDENCE_OTHER or PRECEDENCE_HERE
#      Suffix mappings can come from four sources: (1) SUFFIX rules
#      given here - see below, (2) builtin defaults (HTInit.c), and the
#      (3) GLOBAL_EXTENSION_MAP and (4) PERSONAL_EXTENSION_MAP files.
#      The order of precedence is normally as listed: (1) has the
#      *lowest*, (4) has the *highest* precedence if there are conflicts.
#      In other words, SUFFIX mappings here are overridden by conflicting
#      ones elsewhere.  This default ordering is called PRECEDENCE_OTHER.
#      With PRECEDENCE_HERE, the order becomes (2) (3) (4) (1), i.e.
#      mappings here override others made elsewhere.
#
#    NO_BUILTIN
#      This disables all builtin default rules.  In other words, (2) in the
#      list above is skipped.  Some recognition for compressed files (".gz",
#      ".Z") is still hardwired.   A mapping for some basic types, at least
#      for text/html is probably necessary to get a usable configuration,
#      it can be given in a SUFFIX rule below or an extension map file.
# Both kinds of settings can be combined, separated by comma as in
#        SUFFIX_ORDER:PRECEDENCE_HERE,NO_BUILTIN
# Note: Using PRECEDENCE_HERE has only an effect on SUFFIX rules that follow.
# Moreover, if GLOBAL_EXTENSION_MAP or PERSONAL_EXTENSION_MAP directives
# are used, they should come *before* a SUFFIX_ORDER:PRECEDENCE_HERE.
#
#SUFFIX_ORDER:PRECEDENCE_OTHER


.h2 SUFFIX
# The SUFFIX definition takes the form of:
#
#    SUFFIX:<file extension>:<mime type>:<encoding>:<quality>:<description>
#
# All fields after <mime type> are optional (including the separators
# if no more fields follow).
#
#     <file extension> trailing end of file name.  This need not strictly
#                      be a file extension as understood by the OS, a dot
#                      has to be given explicitly if it is indented, for
#                      some uses one could even match full filenames here.
#                      In addition, two forms are special: "*.*" and "*"
#                      refer to the defaults for otherwise unmatched files
#                      (the first for filenames with a dot somewhere in
#                      the name, the second without), these are currently
#                      mapped to text/plain in the (HTInit.c) builtin code.
#
#     <mime type> a MIME content type.  It can also contain a charset
#                 parameter, see example below.  This should be given in
#                 all lowercase, use <description> for more fancy labels.
#                 It can be left empty if an HTTP style encoding is given.
#
# Fields in addition to the usual ones are
#
#     <encoding>  either a mail style trivial encoding (7bit, 8bit, binary)
#                 which could be used on some systems to determine how to
#                 open local files (currently it isn't), and is used to
#                 determine transfer mode for some FTP URLs; or a HTTP style
#                 content encoding (gzip (equivalent to x-gzip), compress)
#
#     <quality> a floating point quality factor, usually between 0.0 and 1.0
#               currently unused in most situations.
#
#     <description> text that can appear in FTP directory listings, and in
#                   local directory listings (see LIST_FORMAT, code %t)
#
# For instance the following definition maps the
# extension ".gif" to the mime type "image/gif"
.ex
#    SUFFIX:.gif:image/gif
#
# The following can be used if you have a convention to label
# HTML files in some character set that differs from your local
# default (see also ASSUME_LOCAL_CHARSET) with a different
# extension, here ".html-u8".  It also demonstrates use of the
# description field, note extra separators for omitted fields:
.ex
#    SUFFIX:.html-u8:text/html;charset=utf-8:::UTF-8 HTML
#
# The following shows how a suffix can indicate a combination
# of MIME type and compression method. (The ending ".ps.gz" should
# already be recognized by default; the form below could be used on
# systems that don't allow more than one dot in filenames.)
.ex
#    SUFFIX:.ps_gz:application/postscript:gzip::gzip'd Postscript
#
# The following is meant to match a full filename (but can match
# any file ending in "core", so be careful):
.ex
#    SUFFIX:core:application/x-core-file
#
# file suffixes are case INsensitive!
#
# The suffix definitions listed here in the default lynx.cfg file are
# similar to those normally established via src/HTInit.c.  You can change
# the defaults by editing that file or disable them, or via the global or
# personal mime.types files at run time (except for the additional fields).
# Assignments made here are overridden by entries in those files
# unless preceded with a SUFFIX_ORDER:PRECEDENCE_HERE.
#
.ex 29
#SUFFIX:.ps:application/postscript
#SUFFIX:.eps:application/postscript
#SUFFIX:.ai:application/postscript
#SUFFIX:.rtf:application/rtf
#SUFFIX:.snd:audio/basic
#SUFFIX:.gif:image/gif
#SUFFIX:.rgb:image/x-rgb
#SUFFIX:.png:image/png
#SUFFIX:.xbm:image/x-xbitmap
#SUFFIX:.tiff:image/tiff
#SUFFIX:.jpg:image/jpeg
#SUFFIX:.jpeg:image/jpeg
#SUFFIX:.mpg:video/mpeg
#SUFFIX:.mpeg:video/mpeg
#SUFFIX:.mov:video/quicktime
#SUFFIX:.hqx:application/mac-binhex40
#SUFFIX:.bin:application/octet-stream
#SUFFIX:.exe:application/octet-stream
#SUFFIX:.tar:application/x-tar
#SUFFIX:.tgz:application/x-tar:gzip
#SUFFIX:.Z::compress
#SUFFIX:.gz::gzip
#SUFFIX:.bz2:application/x-bzip2
#SUFFIX:.zip:application/zip
#SUFFIX:.lzh:application/x-lzh
#SUFFIX:.lha:application/x-lha
#SUFFIX:.dms:application/x-dms
#SUFFIX:.html:text/html
#SUFFIX:.txt:text/plain


.h2 XLOADIMAGE_COMMAND
# VMS:
# ====
# XLOADIMAGE_COMMAND will be used as a default in src/HTInit.c
# for viewing image content types when the DECW$DISPLAY logical
# is set.  Make it the foreign command for your system's X image
# viewer (commonly, "xv").  It can be anything that will handle GIF,
# TIFF and other popular image formats.  Freeware ports of xv for
# VMS are available in the ftp://ftp.wku.edu/vms/unsupported and
# http://www.openvms.digital.com/cd/XV310A/ subdirectories.  You
# must also have a "%s" for the filename.  The default is defined
# in userdefs.h and can be overridden here, or via the global or
# personal mailcap files (see below).
#
# Make this empty (but no commented out) if you don't have such a
# viewer or don't want to disable the built-in default viewer
# mappings for image types.
#
#XLOADIMAGE_COMMAND:xv %s

# Unix:
# =====
# XLOADIMAGE_COMMAND will be used as a default in src/HTInit.c for
# viewing image content types when the DISPLAY environment variable
# is set.  Make it the full path and name of the xli (also know as
# xloadimage or xview) command, or other image viewer.  It can be
# anything that will handle GIF, TIFF and other popular image formats
# (xli does).  The freeware distribution of xli is available in the
# ftp://ftp.x.org/contrib subdirectory.  The shareware, xv, also is
# suitable.  You must also have a "%s" for the filename; "&" for
# background is optional.  The default is defined in userdefs.h and can be
# overridden here, or via the global or personal mailcap files (see below).
# Make this empty (but not commented out) if you don't have such a
# viewer or don't want to disable the built-in default viewer
# mappings for image types.
# Note that open is used as the default for NeXT, instead of the
# XLOADIMAGE_COMMAND definition.
# If you use xli, you may want to add the -quiet flag.
#
#XLOADIMAGE_COMMAND:xli %s &

.h2 VIEWER
# MIME types may be assigned to external viewers using
# the VIEWER definition.
#
# NOTE: if you do not define a viewer to a new MIME type
#       that you assigned above then it will be saved to
#       disk by default.
#       It is normally preferable to define new viewers in
#       MAILCAP files (see below) instead of here:  Definitions
#       here are overridden by those in MAILCAP files and even
#       by some built-in defaults in src/HTInit.c.
#
# The VIEWER definition takes the form of:
#    VIEWER:<mime type>:<viewer command>[:environment]
#      where -mime type is the MIME content type of the file
#	     -viewer command is a system command that can be
#             used to display the file where %s is replaced
#             within the command with the physical filename
#             (e.g., "ghostview %s" becomes "ghostview /tmp/temppsfile")
#            -environment is optional.  The only valid keywords
#             are currently XWINDOWS and NON_XWINDOWS.  If the XWINDOWS
#             environment is specified then the viewer will only be
#             defined when the user has the environment variable DISPLAY
#             (DECW$DISPLAY on VMS) defined.  If the NON_XWINDOWS environment
#             is specified the specified viewer will only be defined when the
#             user DOES NOT have the environment variable DISPLAY defined.
#  examples:
#		VIEWER:image/gif:xli %s:XWINDOWS
#               VIEWER:image/gif:ascii-view %s:NON_XWINDOWS
#               VIEWER:application/start-elm:elm
#
# You must put the whole definition on one line.
#
# If you must use a colon in the viewer command, precede it with a backslash!
#
# The MIME_type:viewer:XWINDOWS definitions listed here in the lynx.cfg
# file are among those established via src/HTInit.c.  For the image types,
# HTInit.c uses the XLOADIMAGE_COMMAND definition in userdefs.h or above
# (open is used for NeXT).  You can change any of these defaults via the
# global or personal mailcap files.  Assignments made here will be overridden
# by entries in those files.
#
.ex 7
#VIEWER:application/postscript:ghostview %s&:XWINDOWS
#VIEWER:image/gif:xli %s&:XWINDOWS
#VIEWER:image/x-xbm:xli %s&:XWINDOWS
#VIEWER:image/png:xli %s&:XWINDOWS
#VIEWER:image/tiff:xli %s&:XWINDOWS
#VIEWER:image/jpeg:xli %s&:XWINDOWS
#VIEWER:video/mpeg:mpeg_play %s &:XWINDOWS


.h2 GLOBAL_MAILCAP
.h2 PERSONAL_MAILCAP
# The global and personal MAILCAP files allow you to specify external
# viewers to be spawned when Lynx encounters different MIME types, which
# will override any of the suffix maps in this (lynx.cfg) configuration
# file, or in src/HTInit.c.  See http://www.internic.net/rfc/rfc1524.txt
# and the example mailcap file in the samples subdirectory.
#
# Unix:
# ====
#GLOBAL_MAILCAP:/usr/local/lib/mosaic/mailcap
# VMS:
# ===
#GLOBAL_MAILCAP:Lynx_Dir:mailcap
#
# 	Sought in user's home (Unix) or sys$login (VMS) directory.
#PERSONAL_MAILCAP:.mailcap


.h1 Keyboard Input

.h2 KEYBOARD_LAYOUT
# If your terminal (or terminal emulator, or operating system) does not
# support 8-bit input (at all or in easy way), you can use Lynx to
# generate 8-bit characters from 7-bit ones output by terminal.
#
# Currently available keyboard layouts:
#	ROT13'd keyboard layout
#	JCUKEN Cyrillic, for AT 101-key kbd
#	YAWERTY Cyrillic, for DEC LK201 kbd
#
# This feature is ifdef'd with EXP_KEYBOARD_LAYOUT.
#KEYBOARD_LAYOUT:JCUKEN Cyrillic, for AT 101-key kbd


.h2 KEYMAP
# Key remapping definitions!
#
# You may redefine the keymapping of any function in Lynx by
# using the KEYMAP option.  The basic form of KEYMAP is:
#  KEYMAP:<KEYSTROKE>:<LYNX FUNCTION>
# (See below for an extended format.)
#
# You must map upper and lowercase keys separately.
#
# A representative list of functions mapped to their default keys is
# provided below.  All of the mappings are commented out by default
# since they just repeat the default mappings, except for TOGGLE_HELP
# (see below).  See LYKeymap.c for the complete key mapping.  Use the
# 'K'eymap command when running Lynx for a list of the _current_ keymappings.
#
# (However, in contrast to the output of 'K' command,
# 'H'elp (lynx_help/*.html and lynx_help/keystrokes/*.html files) shows
# the default mapping unless you change that files manually,
# so you are responsible for possible deviations
# when you are changing any KEYMAP below).
.nf
#
# Keystrokes for special keys are represented by the following codes:
#         Up Arrow: 0x100
#       Down Arrow: 0x101
#      Right Arrow: 0x102
#       Left Arrow: 0x103
#        Page Down: 0x104
#          Page Up: 0x105
#      Keypad Home: 0x106 (see also 0x10A)
#       Keypad End: 0x107 (see also 0x10B)
#   Function key 1: 0x108
# vt100   Help Key: 0x108
# vt100     Do Key: 0x109
# vt100   Find Key: 0x10A (The key with label "Home" may be treated as Find)
# vt100 Select Key: 0x10B (The key with label "End" may be treated as Select)
#       Insert Key: 0x10C
# Remove (Del) Key: 0x10D
#      ignored key  0x10E (reserved for internal use, DO_NOTHING)
# Back (Shift) Tab: 0x10F
#    reserved code  0x11D (reserved for internal use with -use_mouse)
#    reserved code  0x290 (reserved for internal use with -use_mouse)
#
.fi
# Other codes not listed above may be available for additional keys,
# depending on operating system and libraries used to compile Lynx.
# On some systems, if compiled with recent versions of slang or ncurses
# (if macro USE_KEYMAPS was in effect during compilation), an additional
# level of key mapping is supported via an external ".lynx-keymaps" file.
# This file, if found in the home directory at startup, will always be
# used under those conditions; see lynx-keymaps distributed in the samples
# subdirectory for further explanation.  Note that mapping via
# .lynx-keymaps, if applicable, is a step that logically comes before the
# mappings done here: KEYMAP maps the result of that step (which still
# represents a key) to a function (which represents an action that Lynx
# should perform).
#
.nf
#KEYMAP:0x5C:SOURCE		# Toggle source viewing mode (show HTML source)
#KEYMAP:^R:RELOAD		# Reload the current document and redisplay
#KEYMAP:q:QUIT			# Ask the user to quit
#KEYMAP:Q:ABORT			# Quit without verification
#KEYMAP:0x20:NEXT_PAGE		# Move down to next page
#KEYMAP:-:PREV_PAGE		# Move up to previous page
#KEYMAP:^P:UP_TWO		# Move display up two lines
#KEYMAP:0x10C:UP_TWO		# Function key Insert - Move display up two lines
#KEYMAP:^N:DOWN_TWO		# Move display down two lines
#KEYMAP:0x10D:DOWN_TWO		# Function key Remove - Move display down two lines
#KEYMAP:(:UP_HALF		# Move display up half a page
#KEYMAP:):DOWN_HALF		# Move display down half a page
#KEYMAP:^W:REFRESH		# Refresh the screen
#KEYMAP:^A:HOME			# Go to top of current document
#KEYMAP:0x106:HOME		# Keypad Home - Go to top of current document
#KEYMAP:0x10A:HOME		# Function key Find - Go to top of current document
#KEYMAP:^E:END			# Go to bottom of current document
#KEYMAP:0x107:END		# Keypad End - Go to bottom of current document
#KEYMAP:0x10B:END		# Function key Select - Go to bottom of current document
#KEYMAP:0x100:PREV_LINK		# Move to the previous link or page
#KEYMAP:0x101:NEXT_LINK		# Move to the next link or page
#KEYMAP:0x10F:FASTBACKW_LINK 	# Back Tab - Move to previous link or text area
#KEYMAP:^I:FASTFORW_LINK	# Tab key - Move always to next link or text area
#KEYMAP:^:FIRST_LINK		# Move to the first link on line
#KEYMAP:$:LAST_LINK		# Move to the last link on line
#KEYMAP:<:UP_LINK		# Move to the link above
#KEYMAP:>:DOWN_LINK		# Move to the link below
#KEYMAP:0x7F:HISTORY		# Show the history list
#KEYMAP:0x08:HISTORY		# Show the history list
#KEYMAP:0x103:PREV_DOC		# Return to the previous document in history stack
#KEYMAP:0x102:ACTIVATE		# Select the current link
#KEYMAP:0x109:ACTIVATE		# Function key Do - Select the current link
#KEYMAP:g:GOTO			# Goto a random URL
#KEYMAP:G:ECGOTO		# Edit the current document's URL and go to it
#KEYMAP:H:HELP			# Show default help screen
#KEYMAP:0x108:DWIMHELP		# Function key Help - Show a help screen
#KEYMAP:i:INDEX			# Show default index
#*** Edit FORM_LINK_* messages in LYMessages_en.h if you change NOCACHE ***
#KEYMAP:x:NOCACHE		# Force submission of form or link with no-cache
#*** Do not change INTERRUPT from 'z' & 'Z' ***
#KEYMAP:z:INTERRUPT		# Interrupt network transmission
#KEYMAP:m:MAIN_MENU		# Return to the main menu
#KEYMAP:o:OPTIONS		# Show the options menu
#KEYMAP:i:INDEX_SEARCH		# Search a server based index
#KEYMAP:/:WHEREIS		# Find a string within the current document
#KEYMAP:n:NEXT			# Find next occurrence of string within document
#KEYMAP:c:COMMENT		# Comment to the author of the current document
#KEYMAP:C:CHDIR			# Change current directory
#KEYMAP:e:EDIT			# Edit current document or form's textarea (call: ^Ve)
#KEYMAP:E:ELGOTO		# Edit the current link's URL or ACTION and go to it
#KEYMAP:=:INFO			# Show info about current document
#KEYMAP:p:PRINT			# Show print options
#KEYMAP:a:ADD_BOOKMARK		# Add current document to bookmark list
#KEYMAP:v:VIEW_BOOKMARK		# View the bookmark list
#KEYMAP:V:VLINKS		# List links visited during the current Lynx session
#KEYMAP:!:SHELL			# Spawn default shell
#KEYMAP:d:DOWNLOAD		# Download current link
#KEYMAP:j:JUMP			# Jump to a predefined target
#KEYMAP:k:KEYMAP		# Display the current key map
#KEYMAP:l:LIST			# List the references (links) in the current document
#KEYMAP:#:TOOLBAR		# Go to the Toolbar or Banner in the current document
#KEYMAP:^T:TRACE_TOGGLE		# Toggle detailed tracing for debugging
#KEYMAP:;:TRACE_LOG		# View trace log if available for the current session
#KEYMAP:*:IMAGE_TOGGLE		# Toggle inclusion of links for all images
#KEYMAP:[:INLINE_TOGGLE		# Toggle pseudo-ALTs for inlines with no ALT string
#KEYMAP:]:HEAD			# Send a HEAD request for current document or link
#*** Must be compiled with USE_EXTERNALS to enable EXTERN ***
#KEYMAP:.:EXTERN		# Run external program with url
#*** Escaping from text input fields with ^V is independent from this: ***
#KEYMAP:^V:SWITCH_DTD		# Toggle between SortaSGML and TagSoup HTML parsing
#KEYMAP:0x00:DO_NOTHING		# Does nothing (ignore this key)
#KEYMAP:0x10E:DO_NOTHING	# Does nothing (ignore this key)
#
.fi
# In addition to the bindings available by default, the following functions
# are not directly mapped to any keys by default, although some of them may
# be mapped in specific line-editor bindings (effective while in text input
# fields):
.nf
#
#KEYMAP:???:RIGHT_LINK		# Move to the link to the right
#KEYMAP:???:LEFT_LINK		# Move to the link to the left
#KEYMAP:???:LPOS_PREV_LINK	# Like PREV_LINK, last column pos if form input
#KEYMAP:???:LPOS_NEXT_LINK	# Like NEXT_LINK, last column pos if form input
#*** Only useful in form text fields , need PASS or prefixing with ^V: ***
#KEYMAP:???:DWIMHELP		# Display help page that may depend on context
#KEYMAP:???:DWIMEDIT		# Use external editor for context-dependent purpose
#*** Only useful in a form textarea, need PASS or prefixing with ^V: ***
#KEYMAP:???:EDITTEXTAREA	# use external editor to edit a form textarea
#KEYMAP:???:GROWTEXTAREA	# Add some blank lines to bottom of textarea
#KEYMAP:???:INSERTFILE		# Insert file into a textarea (just above cursor)
#*** Only useful with dired support and OK_INSTALL: ***
#KEYMAP:???:INSTALL		# install (i.e. copy) local files to new location
.fi
#
# If TOGGLE_HELP is mapped, in novice mode the second help menu line
# can be toggled among NOVICE_LINE_TWO_A, _B, and _C, as defined in
# LYMessages_en.h  Otherwise, it will be NOVICE_LINE_TWO.
#
#KEYMAP:O:TOGGLE_HELP		# Show other commands in the novice help menu
#
# KEYMAP lines can have one or two additional fields.  The extended format is
#  KEYMAP:<KEYSTROKE>:[<MAIN LYNX FUNCTION>]:<OTHER BINDING>[:<SELECT>]
#
# If the additional field OTHER BINDING specifies DIRED, then the function is
# mapped in the override table used only in DIRED mode.  This is only valid
# if lynx was compiled with dired support and OK_OVERRIDE defined.  A
# MAIN LYNX FUNCTION must be given (it should of course be one that makes
# sense in Dired mode), and SELECT is meaningless.  Default built-in override
# mappings are
#
#KEYMAP:^U:PREV_DOC:DIRED	# Return to the previous document
#KEYMAP:.:TAG_LINK:DIRED	# Tag a file or directory for later action
#KEYMAP:c:CREATE:DIRED		# Create a new file or directory
#KEYMAP:C:CHDIR:DIRED		# change current directory
#KEYMAP:f:DIRED_MENU:DIRED	# Display a menu of file operations
#KEYMAP:m:MODIFY:DIRED		# Modify name or location of a file or directory
#KEYMAP:r:REMOVE:DIRED		# Remove files or directories
#KEYMAP:t:TAG_LINK:DIRED	# Tag a file or directory for later action
#KEYMAP:u:UPLOAD:DIRED		# Show menu of "Upload Options"
#
# If the OTHER BINDING field does not specify DIRED, then it is taken as a
# line-editor action.  It is possible to keep the MAIN LYNX FUNCTION field
# empty in that case, for changing only the line-editing behavior.
# If alternative line edit styles are compiled in, and modifying a key's
# line-editor binding on a per style basis is possible, then SELECT can be
# used to specify which styles are affected.  By default, or if SELECT is
# 0, all line edit styles are affected.  If SELECT is a positive integer
# number, only the binding for the numbered style is changed (numbering
# is in the order in which styles are shown in the Options Menu, starting
# with 1 for the Default style).  If SELECT is negative (-n), all styles
# except n are affected.
.nf
#
#  NOP		# Do Nothing
#  ABORT	# Input cancelled
#
#  BOL		# Go to begin of line
#  EOL		# Go to end   of line
#  FORW		# Cursor forwards
#  BACK		# Cursor backwards
#  FORWW	# Word forward
#  BACKW	# Word back
#
#  DELN		# Delete next/curr char
#  DELP		# Delete prev      char
#  DELNW	# Delete next word
#  DELPW	# Delete prev word
#  DELBL	# Delete back to BOL
#  DELEL	# Delete thru EOL
#  ERASE	# Erase the line
#  LOWER	# Lower case the line
#  UPPER	# Upper case the line
#
#  LKCMD	# In fields: Invoke key command prompt (default for ^V)
#  PASS		# In fields: handle as non-lineedit key; in prompts: ignore
#
.fi
# Modify following key (prefixing only works within line-editing, edit actions
# of some resulting prefixed keys are built-in, see Line Editor help pages)
#  SETM1	# Set modifier 1 flag (default for ^X - key prefix)
#  SETM2	# Set modifier 2 flag (another key prefix - same effect)
#
# May not always be compiled in:
.nf
#
#  TPOS		# Transpose characters
#  SETMARK	# emacs-like set-mark-command
#  XPMARK	# emacs-like exchange-point-and-mark
#  KILLREG	# emacs-like kill-region
#  YANK		# emacs-like yank
#  SWMAP	# Switch input keymap
#  PASTE	# ClipBoard to Lynx - Windows Extension
#
.fi
# May work differently from expected if not bound to their expected keys:
.nf
#
#  CHAR		# Insert printable char (default for all ASCII printable)
#  ENTER	# Input complete, return char/lynxkeycode (for RETURN/ENTER)
#  TAB		# Input complete, return TAB (for ASCII TAB char ^I)
#
.fi
# Internal use, probably not useful for binding, listed for completeness:
.nf
#
#  UNMOD	# Fall back to no-modifier command
#  AIX		# Hex 97
#  C1CHAR	# Insert C1 char if printable
#
.fi
# If OTHER BINDING specifies PASS, then if the key is pressed in a text input
# field it is passed by the built-in line-editor to normal KEYMAP handling,
# i.e. this flag acts like an implied ^V escape (always overrides line-editor
# behavior of the key).  For example,
#KEYMAP:0x10C:UP_TWO:PASS # Function key Insert - Move display up two lines
#
# Other examples (repeating built-in bindings)
#KEYMAP:^V::LKCMD	# set (only) line-edit action for ^V
#KEYMAP:^V:SWITCH_DTD:LKCMD # set main lynxaction and line-edit action for ^V
#KEYMAP:^U::ERASE:1	# set line-edit binding for ^U, for default style
#KEYMAP:^[::SETM2:3	# use escape key as modifier - works only sometimes


.h1 External Programs
# These settings control the ability of Lynx to invoke various programs for
# the user.

.h2 CSWING_PATH
# VMS ONLY:
#==========
# On VMS, CSwing (an XTree emulation for VTxxx terminals) is intended for
# use as the Directory/File Manager (sources, objects, or executables are
# available from ftp://narnia.memst.edu/).  CSWING_PATH should be defined
# here or in userdefs.h to your foreign command for CSwing, with any
# regulatory switches you want included.  If not defined, or defined as
# a zero-length string ("") or "none" (case-insensitive), the support
# will be disabled.  It will also be disabled if the -nobrowse or
# -selective switches are used, or if the file_url restriction is set.
#
# When enabled, the DIRED_MENU command (normally 'f' or 'F') will invoke
# CSwing, normally with the current default directory as an argument to
# position the user on that node of the directory tree.  However, if the
# current document is a local directory listing, or a local file and not
# one of the temporary menu or list files, the associated directory will
# be passed as an argument, to position the user on that node of the tree.
#
#CSWING_PATH:swing


.h1 Internal Behavior

.h2 AUTO_UNCACHE_DIRLISTS
# AUTO_UNCACHE_DIRLISTS determines when local file directory listings are
# automatically regenerated (by re-reading the actual directory from disk). 
# Set the value to 0 to avoid automatic regeneration in most cases.  This is
# useful for browsing large directories that take some time to read and format. 
# An update can still always be forced with the RELOAD key, and specific DIRED
# actions may cause a refresh anyway.  Set the value to 1 to force regeneration
# after commands that usually change the directory or some files and would make
# the displayed info stale, like EDIT and REMOVE.  Set it to 2 (the default) or
# greater to force regeneration even after leaving the displayed directory
# listing by some action that usually causes no change, like GOTO or entering a
# file with the ACTIVATE key.  This option is only honored in DIRED mode (i.e. 
# when lynx is compiled with DIRED_SUPPORT and it is not disabled with a
# -restriction).  Local directories displayed without DIRED normally act as if
# AUTO_UNCACHE_DIRLISTS:0 was in effect.
#
#AUTO_UNCACHE_DIRLISTS:2


.h1 Appearance

.h2 LIST_FORMAT
# Unix ONLY:
#===========
# LIST_FORMAT defines the display for local files when Lynx has been
# compiled with LONG_LIST defined in the Makefile.  The default is set
# in userdefs.h, normally to "ls -l" format, and can be changed here
# by uncommenting the indicated lines, or adding a definition with a
# modified parameter list.
#
# The percent items in the list are interpreted as follows:
.nf
#
#	%p	Unix-style permission bits
#	%l	link count
#	%o	owner of file
#	%g	group of file
#	%d	date of last modification
#	%a	anchor pointing to file or directory
#	%A	as above but don't show symbolic links
#	%t	type of file (description derived from MIME type)
#	%T	MIME type as known by Lynx (from mime.types or default)
#	%k	size of file in Kilobytes
#	%K	as above but omit size for directories
#	%s	size of file in bytes
#
.fi
# Anything between the percent and the letter is passed on to sprintf.
# A double percent yields a literal percent on output.  Other characters
# are passed through literally.
#
# If you want only the filename:
#
.ex
#LIST_FORMAT:    %a
#
# If you want a brief output:
#
.ex
#LIST_FORMAT:   %4K %-12.12d %a
#
# If you want the Unix "ls -l" format:
#
.ex
#LIST_FORMAT:    %p %4l %-8.8o %-8.8g %7s %-12.12d %a


.h1 External Programs

.h2 DIRED_MENU
# Unix ONLY:
#===========
# DIRED_MENU items are used to compose the F)ull menu list in DIRED mode
# The behavior of the default configuration given here is much the same
# as it was when this menu was hard-coded but these items can now be adjusted
# to suit local needs.  In particular, many of the LYNXDIRED actions can be
# replaced with lynxexec, lynxprog and lynxcgi script references.
#
# NOTE that defining even one DIRED_MENU line overrides all the built-in
# definitions, so a complete set must then be defined here.
#
# Each line consists of the following fields:
.nf
#
#	DIRED_MENU:type:suffix:link text:extra text:action
#
#	type: TAG:   list only when one or more files are tagged
#	      FILE:  list only when the current selection is a regular file
#	      DIR:   list only when the current selection is a directory
#	      LINK:  list only when the current selection is a symbolic link
#
#	suffix:  list only if the current selection ends in this pattern
#
#	link text:  the displayed text of the link
#
#	extra text:  the text displayed following the link
#
#	action:  the URL to be followed upon selection
#
#	link text and action are scanned for % sequences that are expanded
#	at display time as follows:
#
#		%p  path of current selection
#		%f  filename (last component) of current selection
#		%t  tagged list (full paths)
#		%l  list of tagged file names
#		%d  the current directory
#
.fi
#DIRED_MENU:::New File:(in current directory):LYNXDIRED://NEW_FILE%d
#DIRED_MENU:::New Directory:(in current directory):LYNXDIRED://NEW_FOLDER%d

# Following depends on OK_INSTALL
#DIRED_MENU:FILE::Install:selected file to new location:LYNXDIRED://INSTALL_SRC%p
#DIRED_MENU:DIR::Install:selected directory to new location:LYNXDIRED://INSTALL_SRC%p

#DIRED_MENU:FILE::Modify File Name:(of current selection):LYNXDIRED://MODIFY_NAME%p
#DIRED_MENU:DIR::Modify Directory Name:(of current selection):LYNXDIRED://MODIFY_NAME%p
#DIRED_MENU:LINK::Modify Name:(of selected symbolic link):LYNXDIRED://MODIFY_NAME%p

# Following depends on OK_PERMIT
#DIRED_MENU:FILE::Modify File Permissions:(of current selection):LYNXDIRED://PERMIT_SRC%p
#DIRED_MENU:DIR::Modify Directory Permissions:(of current selection):LYNXDIRED://PERMIT_SRC%p

#DIRED_MENU:FILE::Change Location:(of selected file):LYNXDIRED://MODIFY_LOCATION%p
#DIRED_MENU:DIR::Change Location:(of selected directory):LYNXDIRED://MODIFY_LOCATION%p
#DIRED_MENU:LINK::Change Location:(of selected symbolic link):LYNXDIRED://MODIFY_LOCATION%p
#DIRED_MENU:FILE::Remove File:(current selection):LYNXDIRED://REMOVE_SINGLE%p
#DIRED_MENU:DIR::Remove Directory:(current selection):LYNXDIRED://REMOVE_SINGLE%p
#DIRED_MENU:LINK::Remove Symbolic Link:(current selection):LYNXDIRED://REMOVE_SINGLE%p

# Following depends on OK_UUDECODE and !ARCHIVE_ONLY
#DIRED_MENU:FILE::UUDecode:(current selection):LYNXDIRED://UUDECODE%p

# Following depends on OK_TAR and !ARCHIVE_ONLY
#DIRED_MENU:FILE:.tar.Z:Expand:(current selection):LYNXDIRED://UNTAR_Z%p

# Following depend on OK_TAR and OK_GZIP and !ARCHIVE_ONLY
#DIRED_MENU:FILE:.tar.gz:Expand:(current selection):LYNXDIRED://UNTAR_GZ%p
#DIRED_MENU:FILE:.tgz:Expand:(current selection):LYNXDIRED://UNTAR_GZ%p

# Following depends on !ARCHIVE_ONLY
#DIRED_MENU:FILE:.Z:Uncompress:(current selection):LYNXDIRED://DECOMPRESS%p

# Following depends on OK_GZIP and !ARCHIVE_ONLY
#DIRED_MENU:FILE:.gz:Uncompress:(current selection):LYNXDIRED://UNGZIP%p

# Following depends on OK_ZIP and !ARCHIVE_ONLY
#DIRED_MENU:FILE:.zip:Uncompress:(current selection):LYNXDIRED://UNZIP%p

# Following depends on OK_TAR and !ARCHIVE_ONLY
#DIRED_MENU:FILE:.tar:UnTar:(current selection):LYNXDIRED://UNTAR%p

# Following depends on OK_TAR
#DIRED_MENU:DIR::Tar:(current selection):LYNXDIRED://TAR%p

# Following depends on OK_TAR and OK_GZIP
#DIRED_MENU:DIR::Tar and compress:(using GNU gzip):LYNXDIRED://TAR_GZ%p

# Following depends on OK_ZIP
#DIRED_MENU:DIR::Package and compress:(using zip):LYNXDIRED://ZIP%p

#DIRED_MENU:FILE::Compress:(using Unix compress):LYNXDIRED://COMPRESS%p

# Following depends on OK_GZIP
#DIRED_MENU:FILE::Compress:(using gzip):LYNXDIRED://GZIP%p

# Following depends on OK_ZIP
#DIRED_MENU:FILE::Compress:(using zip):LYNXDIRED://ZIP%p

#DIRED_MENU:TAG::Move all tagged items to another location.::LYNXDIRED://MOVE_TAGGED%d

# Following depends on OK_INSTALL
#DIRED_MENU:TAG::Install tagged files into another directory.::LYNXDIRED://INSTALL_SRC%00

#DIRED_MENU:TAG::Remove all tagged files and directories.::LYNXDIRED://REMOVE_TAGGED
#DIRED_MENU:TAG::Untag all tagged items.::LYNXDIRED://CLEAR_TAGGED


.h1 Internal Behavior

.h2 NONRESTARTING_SIGWINCH
# Some systems only:
#===================
# Lynx tries to detect window size changes with a signal handler for
# SIGWINCH if supported.  If NONRESTARTING_SIGWINCH is set to TRUE,
# and the sigaction interface is available on the system, the handler
# is installed as 'non-restarting'.  On some systems (depending on the
# library used for handling keyboard input, e.g. ncurses), this allows
# more immediate notification of window size change events.  If the value
# is set to FALSE, the signal() interface is used; this normally makes
# the handler 'restarting', with the effect that lynx can react to size
# changes only after some key is pressed.  The value can also be set to
# XWINDOWS; this is equivalent to TRUE when the user has the environment
# variable DISPLAY defined *at program start*, and equivalent to FALSE
# otherwise.  The non-restarting behavior can also be changed to TRUE
# or FALSE with the -nonrestarting_sigwinch switch, which overrides the
# value in this file.
#
# Note that Lynx never re-parses document text purely as a result of a
# window size change, so text lines may appear truncated after narrowing
# the window, until the document is reloaded with ^R or a similar key
# or until a different text is loaded.
#
# The default is FALSE since there is a possibility that non-restarting
# interrupts may be mis-interpreted as fatal input errors in some
# configurations (leading to an abrupt program exit), and since this
# option is useful mostly only for users running Lynx under xterm or a
# similar X terminal emulator.  On systems where the preconditions don't
# apply this option is ignored.
#
#NONRESTARTING_SIGWINCH:FALSE


.h2 NO_FORCED_CORE_DUMP
# Unix ONLY:
#===========
# If NO_FORCED_CORE_DUMP is set to TRUE, Lynx will not force
# core dumps via abort() calls on fatal errors or assert()
# calls to check potentially fatal errors.  The compilation
# default normally is FALSE, and can be changed here.  The
# compilation or configuration default can be toggled via
# the -core command line switch.
# Note that this setting cannot be used to prevent core dumps
# with certainty.  If this is important, means provided by the
# operating system or kernel should be used.
#
#NO_FORCED_CORE_DUMP:FALSE


.h1 Appearance

.h2 COLOR
# COLORS (only available if compiled with SVr4 curses or slang)
#
# The line must be of the form:
#
# COLOR:Integer:Foreground:Background
.nf
#
# The Integer value is interpreted as follows:
#   0 - normal                      - normal text
#   1 - bold                        - hyperlinks, see also BOLD_* options above
#   2 - reverse                     - statusline
#   3 - bold + reverse              (not used)
#   4 - underline                   - text emphasis (EM, I, B tags etc.)
#   5 - bold + underline            - hyperlinks within text emphasis
#   6 - reverse + underline         - currently selected hyperlink
#   7 - reverse + underline + bold  - WHEREIS search hits
#
# Each Foreground and Background value must be one of:
#   black         red            green         brown
#   blue          magenta        cyan          lightgray
#   gray          brightred      brightgreen   yellow
#   brightblue    brightmagenta  brightcyan    white
#
.fi
# or (if you have configured using --enable-default-colors with ncurses or
# slang), "default" may be used for foreground and background.
#
# Uncomment and change any of the compilation defaults.
#
#COLOR:0:black:white
#COLOR:1:blue:white
#COLOR:2:yellow:blue
#COLOR:3:green:white
#COLOR:4:magenta:white
#COLOR:5:blue:white
#COLOR:6:red:white
#COLOR:7:magenta:cyan


.h2 ASSUMED_COLOR
# If built with a library that recognizes default colors, initializes it
# to assume the corresponding foreground and background colors.  Default
# colors are those that the terminal (emulator) itself is initialized to.
# For instance, you might have an xterm running with black text on a white
# background, and want lynx to display colored text on the white background,
# but leave the possibility of using the same configuration to draw colored
# text on a different xterm, this time using its background set to black.
#
# The first value given is the foreground, the second is the background.
#ASSUMED_COLOR:default:default


.h1 External Programs

.h2 EXTERNAL
# External application support.  This feature allows Lynx to pass a given
# URL to an external program.  It was written for three reasons.
#
# 1) To overcome the deficiency	of Lynx_386 not supporting ftp and news.
#    External programs can be used instead by passing the URL.
#
# 2) To allow for background	transfers in multitasking systems.
#    I use wget for http and ftp transfers via the external command.
#
# 3) To allow for new URLs to be used through Lynx.
#	  URLs can be made up such as mymail: to spawn desired applications
#	  via the external command.
#
# Restrictions can be imposed using -restrictions=externals at the Lynx command
# line.  This will disallow all EXTERNAL lines in lynx.cfg that have FALSE in
# the 3rd field (not counting the name of the setting).  TRUE lines will still
# function.
#
# The lynx.cfg line is as follows:
#
# EXTERNAL:<url>:<command> %s:<norestriction>:<allow_for_activate>
#
# <url> Any given URL.  This can be normal ones like ftp or http or it
# can be one made up like mymail.
#
# <command> The command to run with %s being the URL that will be passed.
# In Linux I use "wget -q %s &" (no quotes) to spawn a copy of wget for
# downloading http and ftp files in the background.  In Win95 I use
# "start ncftp %s" to spawn ncftp in a new window.
#
# <norestriction> This complements the -restrictions=externals feature to allow
# for certain externals to be enabled while restricting others.  TRUE means
# a command will still function while Lynx is restricted.  WB
#
# <allow_for_activate> Setting this to TRUE allows the use of this command not
# only when EXTERN key is pressed, but also when ACTIVATE command is invoked
# (i.e activating the link with the given prefix will be equivalent to
# pressing EXTERN key on it).  If this component of the line is absent, then
# FALSE is assumed.
# 
# For invoking the command use the EXTERN key.  By default it is mapped
# to '.' (if the feature is enabled), see the KEYMAP section above.
#
#EXTERNAL:ftp:wget %s &:TRUE


.h1 Internal Behavior

.h2 RULE
.h2 RULESFILE
# CERN-style rules, EXPERIMENTAL  -  URL-specific rules
#
# A CERN-style rules file can be given with RULESFILE.  Use the system's
# native format for filenames, on Unix '~' is also recognized.  If a filename
# is given, the file must exist.
#
# Single CERN-style rules can be specified with RULES.
#
# Both options can be repeated, rules accumulate in the order
# given, they will be applied in first-to-last order.  See cernrules.txt
# in the samples subdirectory for further explanation.
#
# Examples:
.ex 5
#	RULESFILE:/etc/lynx/cernrules
#	RULE:Fail	gopher:*		     # reject by scheme
#	RULE:Pass	finger://*@localhost/	     # allow this,
#	RULE:Fail	finger:*		     # but not others
#	RULE:Redirect	http://old.server/*	http://new.server/*


.h1 Appearance

.h2 PRETTYSRC
# Enable pretty source view
#PRETTYSRC:FALSE

.h2 PRETTYSRC_SPEC
# Pretty source view settings. These settings are in effect when -prettysrc
# is specified.
# The following lexical elements (lexemes) are recognized:
# comment, tag, attribute, attribute value, generalized angle brackets (
# '<' '>' '</' ), entity, hyperlink destination, entire file, bad sequence,
# bad tag, bad attribute, sgml special.
#  The following group of option tells which styles will surround each
# lexeme. The syntax of option in this group is:
#PRETTYSRC_SPEC:<LEXEMENAME>:<TAGSPEC>:<TAGSPEC>
# The first <TAGSPEC> specifies what tags will precede lexemes of that class
# in the internal html markup. The second - what will be placed (internally)
# after it.
# TAGSPEC has the following syntax:
# <TAGSPEC>:= [ (<TAGOPEN> | <TAGCLOSE>) <SPACE>+ ]*
# <TAGOPEN>:= tagname[.classname]
# <TAGCLOSE>:= !tagname
#
# The following table gives correspondence between lexeme and lexeme name
.nf
# Lexeme                   LEXEMENAME  FURTHER EXPLANATION
# =========================================================
# comment                  COMM
# tag                      TAG         recognized tag name only
# attribute                ATTRIB
# attribute value          ATTRVAL
# generalized brackets     ABRACKET    <  >  </
# entity                   ENTITY
# hyperlink destination    HREF
# entire file              ENTIRE
# bad sequence             BADSEQ      bad entity or invalid construct at text
#                                      level.
# bad tag                  BADTAG      Unrecognized construct in generalized
#                                      brackets.
# bad attribute            BADATTR     The name of the attribute unknown to lynx
#                                      of the tag known to lynx. (i.e.,
#                                      attributes of unknown tags will have
#                                      markup of  ATTRIB)
# sgml special             SGMLSPECIAL doctype, sgmlelt, sgmlele,
#                                      sgmlattlist, marked section, identifier
.fi
#
# Notes:
#
# 1) The markup for HTML_ENTIRE will be emitted only once - it will surround
#    entire file source.
#
# 2) The tagnames specified by TAGSPEC should be valid html tag names.
#
# 3) If the tag/class combination given by TAGOPEN is not assigned a color
#    style in lss file (for lynx compiled with lss support), that tag/class
#    combination will be emitted anyway during internal html markup. Such
#    combinations will be also reported to the trace log.
#
# 4) Lexeme 'tag' means tag name only
#
# 5) Angle brackets of html specials won't be surrounded by markup for ABRACKET
#
.ex
# PRETTYSRC_SPEC:COMM:B I:!I !B
#           HTML comments will be surrounded by <b><i> and </i></b> in the
#           internal html markup
.ex
# PRETTYSRC_SPEC:ATTRVAL: span.attrval : !span
#           Values of the attributes will be surrounded by the
#           <SPAN class=attrval> </SPAN>
.ex
# PRETTYSRC_SPEC:HREF::
#           No special html markup will surround hyperlink destinations (
#           this means that only default color style for hrefs will be applied
#           to them)
#
# For lynx compiled with lss support, the following settings are the default:
#PRETTYSRC_SPEC:COMM:span.htmlsrc_comment:!span
#PRETTYSRC_SPEC:TAG:span.htmlsrc_tag:!span
#PRETTYSRC_SPEC:ATTRIB:span.htmlsrc_attrib:!span
#PRETTYSRC_SPEC:ATTRVAL:span.htmlsrc_attrval:!span
#PRETTYSRC_SPEC:ABRACKET:span.htmlsrc_abracket:!span
#PRETTYSRC_SPEC:ENTITY:span.htmlsrc_entity:!span
#PRETTYSRC_SPEC:HREF:span.htmlsrc_href:!span
#PRETTYSRC_SPEC:ENTIRE:span.htmlsrc_entire:!span
#PRETTYSRC_SPEC:BADSEQ:span.htmlsrc_badseq:!span
#PRETTYSRC_SPEC:BADTAG:span.htmlsrc_badtag:!span
#PRETTYSRC_SPEC:BADATTR:span.htmlsrc_badattr:!span
#PRETTYSRC_SPEC:SGMLSPECIAL:span.htmlsrc_sgmlspecial:!span
# the styles corresponding to them are present in sample .lss file.
# For lynx compiled without lss support, the following settings are the default:
#PRETTYSRC_SPEC:COMM:b:!b
#PRETTYSRC_SPEC:TAG:b:!b
#PRETTYSRC_SPEC:ATTRIB:b:!b
#PRETTYSRC_SPEC:ATTRVAL::
#PRETTYSRC_SPEC:ABRACKET:b:!b
#PRETTYSRC_SPEC:ENTITY:b:!b
#PRETTYSRC_SPEC:HREF::
#PRETTYSRC_SPEC:ENTIRE::
#PRETTYSRC_SPEC:BADSEQ:b:!b
#PRETTYSRC_SPEC:BADTAG::
#PRETTYSRC_SPEC:BADATTR::
#PRETTYSRC_SPEC:SGMLSPECIAL:b:!b


.h2 HTMLSRC_ATTRNAME_XFORM
.h2 HTMLSRC_TAGNAME_XFORM
# Options HTMLSRC_TAGNAME_XFORM and HTMLSRC_ATTRNAME_XFORM control the way the
# names of tags and names of attributes are transformed correspondingly.
# Possible values: 0 - lowercase, 1 - leave as is, 2 - uppercase.
#HTMLSRC_TAGNAME_XFORM:2
#HTMLSRC_ATTRNAME_XFORM:2


.h2 PRETTYSRC_VIEW_NO_ANCHOR_NUMBERING
# PRETTYSRC_VIEW_NO_ANCHOR_NUMBERING - pretty source view setting
# If "keypad mode" in 'O'ptions screen is "Links are numbered" or
# "Links and form fields are numbered", and PRETTYSRC_VIEW_NO_ANCHOR_NUMBERING is
# TRUE, then links won't be numbered in psrc view and will be numbered
# otherwise. Set this setting to TRUE if you prefer numbered links, but wish
# to get valid HTML source when printing or mailing when in psrc view.
# Default is FALSE.
#PRETTYSRC_VIEW_NO_ANCHOR_NUMBERING:FALSE


.h1 HTML Parsing

.h2 FORCE_EMPTY_HREFLESS_A
# FORCE_EMPTY_HREFLESS_A - HTML parsing
# This option mirrors command-line option with the same name.  Default is
# FALSE.  If true, then any 'A' element without HREF will be closed
# immediately.  This is useful when viewing documentation produced by broken
# translator that doesn't emit balanced A elements.  If lynx was compiled with
# color styles, setting this option to TRUE will make lynx screen much more
# reasonable (otherwise all text will probably have color corresponding to the
# A element).
#
#FORCE_EMPTY_HREFLESS_A:FALSE

.h2 HIDDEN_LINK_MARKER
# HIDDEN_LINK_MARKER - HTML parsing
# This option defines the string that will be used as title of hidden link (a
# link that otherwise will have no label associated with it).  Using an empty
# string as the value will cause lynx to behave in the old way - hidden links
# will be handled according to other settings (mostly the parameter of
# --hiddenlinks command-line switch).  If the value is non-empty string, hidden
# link becomes non-hidden so it won't be handled as hidden link, e.g., listed
# among hidden links on 'l'isting page.
#
#HIDDEN_LINK_MARKER:

.h1 Appearance

.h2 JUSTIFY
# JUSTIFY - Appearance
# This option mirrors command-line option with same name.  Default is TRUE.  If
# true, most of text (except headers and like this) will be justified.  This
# has no influence on CJK text rendering.
#
# This option is only available if Lynx was compiled with EXP_JUSTIFY_ELTS.
#
#JUSTIFY:TRUE

.h2 JUSTIFY_MAX_VOID_PERCENT 
# JUSTIFY_MAX_VOID_PERCENT - Appearance
# This option controls the maximum allowed value for ratio (in percents) of
# 'the number of spaces to spread across the line to justify it' to
# 'max line size for current style and nesting' when justification is allowed.
# When that ratio exceeds the value specified, that particular line won't be
# justified. I.e. the value 28 for this setting will mean maximum value for
# that ratio is 0.28.
#
#JUSTIFY_MAX_VOID_PERCENT:35


.h1 Interaction

.h2 TEXTFIELDS_NEED_ACTIVATION
# If TEXTFIELDS_NEED_ACTIVATION is set to TRUE, and lynx was compiled with
# TEXTFIELDS_MAY_NEED_ACTIVATION defined, then text input form fields need
# to be activated (by pressing the Enter key or similar) before the user
# can enter or modify input.  By default, input fields become automatically
# activated when selected.  Requiring explicit activation can be desired for
# users who use alphanumeric keys for navigation (or other keys that have
# special meaning in the line editor - ' ', 'b', INS, DEL, etc), and don't
# want to 'get stuck' in form fields.  Instead of setting the option here,
# explicit activation can also be requested with the -tna command line
# option.
#
#TEXTFIELDS_NEED_ACTIVATION:FALSE

.h2 LEFTARROW_IN_TEXTFIELD_PROMPT
# LEFTARROW_IN_TEXTFIELD_PROMPT
# This option controls what happens when a Left Arrow key is pressed while
# in the first position of an active text input field.  By default, Lynx
# asks for confirmation ("Do you want to go back to the previous document?")
# only if the contents of the fields have been changed since entering it.
# If set to TRUE, the confirmation prompt is always issued.
#
#LEFTARROW_IN_TEXTFIELD_PROMPT:FALSE


.h1 Timeouts

.h2 CONNECT_TIMEOUT
# Specifies (in seconds) connect timeout. Not available under DOS (use
# sockdelay parameter of wattcp). Default value is rather huge.
#CONNECT_TIMEOUT:18000


.h1 Internal Behavior
# These settings control internal lynx behavior - the way it interacts with the
# operating system and Internet.  Modifying these settings will not change
# the rendition of documents that you browse with lynx, but can change various
# delays and resource utilization.

.h2 FTP_PASSIVE
# Set FTP_PASSIVE to TRUE if you want to use passive mode ftp transfers.
# You might have to do this if you're behind a restrictive firewall.
#FTP_PASSIVE:FALSE
