# Copyright 1999-2011 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /var/cvsroot/gentoo-x86/dev-python/chaco/chaco-3.4.0.ebuild,v 1.2 2011/03/27 22:35:58 arfrever Exp $

EAPI="3"
PYTHON_DEPEND="2"
SUPPORT_PYTHON_ABIS="1"
RESTRICT_PYTHON_ABIS="3.* *-jython"
DISTUTILS_SRC_TEST="setup.py"

inherit distutils virtualx

MY_PN="Chaco"
MY_P="${MY_PN}-${PV}"

DESCRIPTION="Interactive plotting toolkit"
HOMEPAGE="http://code.enthought.com/projects/chaco/ http://pypi.python.org/pypi/Chaco"
SRC_URI="http://www.enthought.com/repo/ETS/${MY_P}.tar.gz"

LICENSE="BSD"
SLOT="0"
KEYWORDS="~amd64 ~x86"
IUSE="doc examples test"

RDEPEND=">=dev-python/enable-3.4.0
	>=dev-python/enthoughtbase-3.1.0
	dev-python/numpy"
DEPEND="${RDEPEND}
	dev-python/setuptools
	doc? (
		dev-python/sphinx
		media-fonts/font-cursor-misc
		media-fonts/font-misc-misc
		x11-apps/xhost
	)
	test? (
		dev-python/coverage
		dev-python/nose
		media-fonts/font-cursor-misc
		media-fonts/font-misc-misc
		x11-apps/xhost
	)"

S="${WORKDIR}/${MY_P}"

PYTHON_CFLAGS=("2.* + -fno-strict-aliasing")

DOCS="docs/*.txt"
PYTHON_MODNAME="enthought"

src_prepare() {
	distutils_src_prepare

	# "${S}/enthought/chaco2/tests and "${S}/enthought/chaco2/shell/tests" do not exist.
	sed \
		-e "s:,enthought/chaco2/tests::" \
		-e "s:,enthought/chaco2/shell/tests::" \
		-i setup.cfg || die "sed setup.cfg failed"

	# Disable failing test.
	sed -e "s/test_draw_border_simple/_&/" -i enthought/chaco/tests/border_test_case.py
}

src_compile() {
	distutils_src_compile

	if use doc; then
		einfo "Generation of documentation"
		pushd docs > /dev/null
		doc_generation() {
			emake html || die "Generation of documentation failed"
		}
		VIRTUALX_COMMAND="doc_generation" virtualmake
		popd > /dev/null
	fi
}

src_test() {
	VIRTUALX_COMMAND="distutils_src_test" virtualmake
}

src_install() {
	find -name "*LICENSE.txt" -delete
	distutils_src_install

	if use doc; then
		pushd docs/build/html > /dev/null
		insinto /usr/share/doc/${PF}/html
		doins -r [a-z]* _images _static || die "Installation of documentation failed"
		popd > /dev/null
	fi

	if use examples; then
		insinto /usr/share/doc/${PF}/examples
		doins -r examples/* || die "Installation of examples failed"
	fi
}
