# Copyright 1999-2011 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /var/cvsroot/gentoo-x86/sys-libs/libchipcard/libchipcard-5.0.0.ebuild,v 1.6 2011/03/13 15:39:57 xarthisius Exp $

EAPI=2
inherit eutils

DESCRIPTION="Libchipcard is a library for easy access to chip cards via chip card readers (terminals)."
HOMEPAGE="http://www.aquamaniac.de/aqbanking/"
SRC_URI="http://www.aquamaniac.de/sites/download/download.php?package=02&release=24&file=01&dummy=${P}.tar.gz -> ${P}.tar.gz"

LICENSE="LGPL-2.1"
SLOT="0"
KEYWORDS="amd64 hppa ppc ~ppc64 ~sparc x86"
IUSE="doc examples"

RDEPEND=">=sys-libs/gwenhywfar-4.0.1
	>=sys-apps/pcsc-lite-1.6.2
	sys-libs/zlib
	virtual/libintl"
DEPEND="${RDEPEND}
	sys-devel/gettext
	doc? ( app-doc/doxygen )"

src_prepare() {
	epatch "${FILESDIR}"/${P}-pcsc-lite-1.6.2.patch
}

src_configure() {
	econf \
		--disable-dependency-tracking \
		--disable-static \
		$(use_enable doc full-doc) \
		--with-docpath=/usr/share/doc/${PF}/apidoc
}

src_install() {
	emake DESTDIR="${D}" install || die

	dodoc AUTHORS ChangeLog NEWS README TODO \
		doc/{CERTIFICATES,CONFIG,IPCCOMMANDS}

	if use examples; then
		docinto tutorials
		dodoc tutorials/*.{c,h,xml} tutorials/README
	fi

	find "${D}" -name '*.la' -exec rm -f {} +
}
