# To get a package list without version numbers from a target system
# rpm -qa --qf "%{n} " > packages.txt
# Put contents of packages.txt after "-y install \" line below

rm -rf /ostemplate ; mkdir /ostemplate
mkdir -p /ostemplate/etc/yum/vars/ ; cp /etc/yum/vars/releasever /etc/yum/vars/slreleasever /ostemplate/etc/yum/vars/

yum -y install --nogpg \
--disablerepo=* --enablerepo=sl --enablerepo=sl-fastbugs --enablerepo=sl-security \
--installroot /ostemplate \
libblkid nss filesystem httpd-tools ncurses-base perl-libs mailcap perl tzdata p11-kit glibc-common util-linux xz-libs python ncurses-libs \
nss-tools pcre openssl libselinux sl-release info vim-filesystem libdb vim-enhanced popt sed libcom_err expat libacl libgpg-error \
dbus-libs gawk lua libxml2 shared-mime-info apr cpio gmp tcp_wrappers-libs perl-parent perl-podlators perl-Text-ParseWords perl-threads \
perl-constant perl-Filter perl-Time-Local perl-threads-shared perl-File-Path perl-Scalar-List-Utils perl-Getopt-Long libcap-ng nss-softokn \
libassuan libunistring diffutils gpm-libs libnfnetlink keyutils-libs gettext-libs nettle gobject-introspection vim-minimal pinentry make \
libselinux-utils ncurses libverto libsemanage krb5-libs openldap cracklib systemd-libs libuser dhcp-libs libcurl python-urlgrabber rpm-libs \
dhcp-common libselinux-python python-iniparse python-chardet yum-metadata-parser python-backports-ssl_match_hostname newt-python pyxattr \
binutils logrotate procps-ng mariadb-libs fipscheck-lib openssh iptables json-c device-mapper cryptsetup-libs dbus iputils cronie-anacron \
crontabs libestr gnupg2 rpm-python pygpgme libnl3 yum-utils man-db dhclient audit openssh-server libgudev1 net-tools elinks python-pyudev \
policycoreutils python-configobj pygobject3-base sudo wget file tar which psmisc libpcap libsysfs libdaemon lzo openssl-libs libuuid libgcc \
nss-sysinit setup libmount basesystem python-libs kbd-misc perl-macros bind-license pam nss-softokn-freebl p11-kit-trust glibc \
perl-Pod-Escapes libstdc++ httpd bash libssh2 libsepol glib2 zlib libmnl audit-libs vim-common chkconfig bzip2-libs nss-util grep libattr \
libcap elfutils-libelf libgcrypt readline libidn libffi pkgconfig sqlite groff-base file-libs libtasn1 slang gdbm perl-HTTP-Tiny \
perl-Pod-Perldoc perl-Encode perl-Pod-Usage perl-Storable perl-Carp perl-Exporter perl-Socket perl-File-Temp perl-PathTools perl-Pod-Simple \
apr-util libcroco cyrus-sasl-lib libgomp kmod-libs libedit hostname js newt ca-certificates less dbus-glib acl libdb-utils findutils xz \
sysvinit-tools ustr gzip cracklib-dicts libpwquality coreutils shadow-utils libutempter python-pycurl curl rpm python-decorator python-slip \
dbus-python python-kitchen python-backports python-setuptools pyliblzma sl-logos kmod nss_compat_ossl bind-libs-lite fipscheck \
libnetfilter_conntrack iproute qrencode-libs device-mapper-libs systemd systemd-sysv initscripts cronie libpipeline pth rpm-build-libs \
gpgme yum libnl3-cli rsyslog mlocate kbd postfix ebtables openssh-clients authconfig python-slip-dbus mc gettext screen passwd gnutls \
elfutils-libs libss nano snappy libndp ethtool hardlink rootfiles nspr yum-conf-sl7x

# Do some cleanup
rm -rf /ostemplate/var/cache/yum/x86_64

# Copy our script and related files
cp /root/create-sl7*.sh /ostemplate/root/

ln -sf /proc/mounts /ostemplate/etc/mtab
touch /ostemplate/etc/fstab

# I want Mountain time to be the default
ln -sf /usr/share/zoneinfo/America/Denver /ostemplate/etc/localtime

# Now compress that sucker, assumes you have xz installed
cd /ostemplate ; tar -cvJf /root/scientific-7-x86_64-$(date +%Y%m%d).tar.xz . ; cd
ls -lh /root/scientific-7-x86_64-$(date +%Y%m%d).tar.xz
echo "Done building OS Template.  Now test it."

