/* -*- mode: C++; c-basic-offset: 4; indent-tabs-mode: nil -*- */
// vim: ft=cpp:expandtab:ts=8:sw=4:softtabstop=4:
/*======
This file is part of Percona TokuBackup.

Copyright (c) 2006, 2015, Percona and/or its affiliates. All rights reserved.

    Percona TokuBackup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License, version 2,
    as published by the Free Software Foundation.

     Percona TokuBackup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Percona TokuBackup.  If not, see <http://www.gnu.org/licenses/>.

----------------------------------------

    Percona TokuBackup is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License, version 3,
    as published by the Free Software Foundation.

    Percona TokuBackup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with Percona TokuBackup.  If not, see <http://www.gnu.org/licenses/>.
======= */

#ident "$Id: 6c156563b7cd54dac608c7a2eb4dc661ba7a013d $"

#include "backup_debug.h"
#include "backup.h"
// Call all the trace and warn code (for coverage)
int test_main (int argc __attribute__((__unused__)), const char *argv[] __attribute__((__unused__))) {
    HotBackup::CopyTrace("hello", "there");
    HotBackup::CopyWarn("hello", "there");
    HotBackup::CopyError("hello", "there");

    HotBackup::CaptureTrace("hello", "there");
    HotBackup::CaptureTrace("hello", 3);
    HotBackup::CaptureWarn("hello", "there");
    HotBackup::CaptureError("hello", "there");
    HotBackup::CaptureError("hello", 3);

    HotBackup::InterposeTrace("hello", "there");
    HotBackup::InterposeTrace("hello", 3);
    HotBackup::InterposeWarn("hello", "there");
    HotBackup::InterposeError("hello", "there");

    HotBackup::should_pause(HotBackup::MANAGER_IN_PREPARE);
    HotBackup::should_pause(HotBackup::MANAGER_IN_DISABLE);
    HotBackup::should_pause(-1);

    return 0;
}
