/*
 Copyright (c) 2013, 2021, Oracle and/or its affiliates. All rights
 reserved.
 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License, version 2.0,
 as published by the Free Software Foundation.

 This program is also distributed with certain software (including
 but not limited to OpenSSL) that is licensed under separate terms,
 as designated in a particular file or component or in included license
 documentation.  The authors of MySQL hereby grant you an additional
 permission to link the program and your derivative works with the
 separately licensed software that they have included with MySQL.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License, version 2.0, for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 02110-1301  USA
 */

"use strict";

var udebug = unified_debug.getLogger("autoincrement/lib.js");

/** The autopk domain object with autogenerated id*/
global.autopk = function(name, age, magic) {
  if (typeof name !== 'undefined') this.name = name;
  if (typeof age !== 'undefined') this.age = age;
  if (typeof magic !== 'undefined') this.magic = magic;
};

global.autopk.prototype.getAge = function() {return this.age;};

/** The autopk key */
global.autopk_key = function(id) {
  this.id = id;
};

/** The autopk unique key */
global.autopk_magic_key = function(magic) {
  this.magic = magic;
};

/** map autopk domain object */
var mapping_autopk = new mynode.TableMapping("test.autopk");
mapping_autopk.mapField("id");
mapping_autopk.mapField("age");
mapping_autopk.mapField("name");
mapping_autopk.mapField("magic");
mapping_autopk.applyToClass(global.autopk);

/** Verify the instance or append an error message to the test case */
global.verify_autopk = function(err, instance, id, testCase, domainObject) {
  if (err) {
    testCase.appendErrorMessage(err);
    return;
  }
  if (typeof(instance) !== 'object') {
    testCase.appendErrorMessage('Result for id ' + id + ' is not an object; actual type: ' + typeof(instance));
  }
  if (instance === null) {
    testCase.appendErrorMessage('Result for id ' + id + ' is null.');
    return;
  }
  if (domainObject) {
    if (typeof(instance.getAge) !== 'function') {
      testCase.appendErrorMessage('Result for id ' + id + ' is not a domain object');
      return;
    }
  }
  udebug.log_detail('instance for id ', id, ':', instance);
  testCase.errorIfNotEqual('fail to verify age', id, instance.age);
  testCase.errorIfNotEqual('fail to verify name', 'Employee ' + id, instance.name);
  testCase.errorIfNotEqual('fail to verify magic', id, instance.magic);
};

/** Verify the instance or fail the test case */
global.fail_verify_autopk = function(err, instance, id, testCase, domainObject, checkId) {
  if (err) {
    testCase.fail(err);
    return;
  }
  if (typeof(instance) !== 'object') {
    testCase.fail(new Error('Result for id ' + id + ' is not an object; actual type: ' + typeof(instance)));
    return;
  }
  if (instance === null) {
    testCase.fail(new Error('Result for id ' + id + ' is null.'));
    return;
  }
  if (domainObject) {
    if (typeof(instance.getAge) !== 'function') {
      testCase.fail(new Error('Result for id ' + id + ' is not a domain object'));
      return;
    }
  }
  udebug.log_detail('instance:', instance);
  var message = '';
  if (!instance.id) {
    testCase.appendErrorMessage('autoincrement instance.id is not set; instance.id: ' + instance.id);
  }
  if (checkId && instance.id != id) {
    message += 'fail to verify id: expected: ' + id + ', actual: ' + instance.id + '\n';
  }
  if (instance.age != id) {
    message += 'fail to verify age: expected: ' + id + ', actual: ' + instance.age + '\n';
  }
  if (instance.magic != id) {
    message += 'fail to verify magic: expected: ' + id + ', actual: ' + instance.magic + '\n';
  }
  if (instance.name !== "Employee " + id) {
    message += 'fail to verify name: expected: ' + "Employee " + id + ', actual: ' + instance.name + '\n';
  }
  if (message !== '') {
    testCase.appendErrorMessage(message);
  }
  // close the session and pass or fail
  if (testCase.session) {
    testCase.session.close(function(err) {
      if (err) {
        testCase.appendErrorMessage(err);
      }
      testCase.session = null;
      testCase.failOnError();
    });
  }
};

/** The autouk domain object with autogenerated magic*/
global.autouk = function(id, name, age, magic) {
  if (typeof id !== 'undefined') this.id = id;
  if (typeof name !== 'undefined') this.name = name;
  if (typeof age !== 'undefined') this.age = age;
  if (typeof magic !== 'undefined') this.magic = magic;
};

global.autouk.prototype.getAge = function() {return this.age;};

/** The autouk key */
global.autouk_key = function(id) {
  this.id = id;
};

/** The autouk unique key */
global.autouk_magic_key = function(magic) {
  this.magic = magic;
};

/** map autouk domain object */
var mapping_autouk = new mynode.TableMapping("test.autouk");
mapping_autouk.mapField("id");
mapping_autouk.mapField("age");
mapping_autouk.mapField("name");
mapping_autouk.mapField("magic");
mapping_autouk.applyToClass(global.autouk);

/** Verify the instance or append an error message to the test case */
global.verify_autouk = function(err, instance, id, testCase, domainObject) {
  if (err) {
    testCase.appendErrorMessage(err);
    return;
  }
  if (typeof(instance) !== 'object') {
    testCase.appendErrorMessage('Result for id ' + id + ' is not an object; actual type: ' + typeof(instance));
  }
  if (instance === null) {
    testCase.appendErrorMessage('Result for id ' + id + ' is null.');
    return;
  }
  if (domainObject) {
    if (typeof(instance.getAge) !== 'function') {
      testCase.appendErrorMessage('Result for id ' + id + ' is not a domain object');
      return;
    }
  }
  udebug.log_detail('instance for id ', id, ':', instance);
  testCase.errorIfNotEqual('fail to verify id', id, instance.id);
  testCase.errorIfNotEqual('fail to verify age', id, instance.age);
  testCase.errorIfNotEqual('fail to verify name', 'Employee ' + id, instance.name);
};

/** Verify the instance or fail the test case */
global.fail_verify_autouk = function(err, instance, id, testCase, domainObject) {
  if (err) {
    testCase.fail(err);
    return;
  }
  if (typeof(instance) !== 'object') {
    testCase.fail(new Error('Result for id ' + id + ' is not an object; actual type: ' + typeof(instance)));
    return;
  }
  if (instance === null) {
    testCase.fail(new Error('Result for id ' + id + ' is null.'));
    return;
  }
  if (domainObject) {
    if (typeof(instance.getAge) !== 'function') {
      testCase.fail(new Error('Result for id ' + id + ' is not a domain object'));
      return;
    }
  }
  udebug.log_detail('instance:', instance);
  var message = '';
  if (instance.id != id) {
    message += 'fail to verify id: expected: ' + id + ', actual: ' + instance.id + '\n';
  }
  if (instance.age != id) {
    message += 'fail to verify age: expected: ' + id + ', actual: ' + instance.age + '\n';
  }
  if (instance.name !== "Employee " + id) {
    message += 'fail to verify name: expected: ' + "Employee " + id + ', actual: ' + instance.name + '\n';
  }
  if (message !== '') {
    testCase.appendErrorMessage(message);
  }
  // close the session and pass or fail
  if (testCase.session) {
    testCase.session.close(function(err) {
      if (err) {
        testCase.appendErrorMessage(err);
      }
      testCase.session = null;
      testCase.failOnError();
    });
  }
};

