(function() {
    'use strict';

    var conn = MongoRunner.runMongod({});
    var db = conn.getDB('test');

    var status = db.serverStatus();
    if (status.storageEngine.name == 'rocksdb') {
        var rocksdb = db.serverStatus().rocksdb;

        assert(rocksdb.hasOwnProperty('compaction-stats'));
        assert(!rocksdb['compaction-stats'].hasOwnProperty('error'));
        assert.eq(22, Object.keys(rocksdb['compaction-stats']).length)

        var cstats = rocksdb['compaction-stats'];
        assert(cstats.hasOwnProperty('level-stats'));
        assert(cstats.hasOwnProperty('flush-cumulative-GB'));
        assert(cstats.hasOwnProperty('flush-interval-GB'));
        assert(cstats.hasOwnProperty('stalls-level0-slowdown'));
        assert(cstats.hasOwnProperty('stalls-level0-slowdown-with-compaction'));
        assert(cstats.hasOwnProperty('stalls-level0-numfiles'));
        assert(cstats.hasOwnProperty('stalls-level0-numfiles-with-compaction'));
        assert(cstats.hasOwnProperty('stalls-stop-for-pending-compaction-bytes'));
        assert(cstats.hasOwnProperty('stalls-slowdown-for-pending-compaction-bytes'));
        assert(cstats.hasOwnProperty('stalls-memtable-compaction'));
        assert(cstats.hasOwnProperty('stalls-memtable-slowdown'));
        assert(cstats.hasOwnProperty('stalls-interval-total-count'));
        assert(cstats.hasOwnProperty('cumulative-written-GB'));
        assert(cstats.hasOwnProperty('cumulative-written-MB-s'));
        assert(cstats.hasOwnProperty('cumulative-read-GB'));
        assert(cstats.hasOwnProperty('cumulative-read-MB-s'));
        assert(cstats.hasOwnProperty('cumulative-seconds'));
        assert(cstats.hasOwnProperty('interval-written-GB'));
        assert(cstats.hasOwnProperty('interval-written-MB-s'));
        assert(cstats.hasOwnProperty('interval-read-GB'));
        assert(cstats.hasOwnProperty('interval-read-MB-s'));
        assert(cstats.hasOwnProperty('interval-seconds'));

        assert(rocksdb.hasOwnProperty('db-stats'));
        assert(!rocksdb['db-stats'].hasOwnProperty('error'));
        assert.eq(28, Object.keys(rocksdb['db-stats']).length)

        var dbstats = rocksdb['db-stats'];
        assert(dbstats.hasOwnProperty('uptime-total-sec'));
        assert(dbstats.hasOwnProperty('uptime-interval-sec'));
        assert(dbstats.hasOwnProperty('cumulative-writes-cnt'));
        assert(dbstats.hasOwnProperty('cumulative-writes-keys'));
        assert(dbstats.hasOwnProperty('cumulative-writes-commit-groups'));
        assert(dbstats.hasOwnProperty('cumulative-writes-per-commit-group'));
        assert(dbstats.hasOwnProperty('cumulative-writes-ingest-GB'));
        assert(dbstats.hasOwnProperty('cumulative-writes-ingest-MB-s'));
        assert(dbstats.hasOwnProperty('cumulative-WAL-writes'));
        assert(dbstats.hasOwnProperty('cumulative-WAL-syncs'));
        assert(dbstats.hasOwnProperty('cumulative-WAL-writes-per-sync'));
        assert(dbstats.hasOwnProperty('cumulative-WAL-written-GB'));
        assert(dbstats.hasOwnProperty('cumulative-WAL-written-MB-s'));
        assert(dbstats.hasOwnProperty('cumulative-stall-sec'));
        assert(dbstats.hasOwnProperty('cumulative-stall-percent'));
        assert(dbstats.hasOwnProperty('interval-writes-cnt'));
        assert(dbstats.hasOwnProperty('interval-writes-keys'));
        assert(dbstats.hasOwnProperty('interval-writes-commit-groups'));
        assert(dbstats.hasOwnProperty('interval-writes-per-commit-group'));
        assert(dbstats.hasOwnProperty('interval-writes-ingest-MB'));
        assert(dbstats.hasOwnProperty('interval-writes-ingest-MB-s'));
        assert(dbstats.hasOwnProperty('interval-WAL-writes'));
        assert(dbstats.hasOwnProperty('interval-WAL-syncs'));
        assert(dbstats.hasOwnProperty('interval-WAL-writes-per-sync'));
        assert(dbstats.hasOwnProperty('interval-WAL-written-MB'));
        assert(dbstats.hasOwnProperty('interval-WAL-written-MB-s'));
        assert(dbstats.hasOwnProperty('interval-stall-sec'));
        assert(dbstats.hasOwnProperty('interval-stall-percent'));

    }

    MongoRunner.stopMongod(conn);
})();
