﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#include <aws/eks/model/VpcConfigRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace EKS
{
namespace Model
{

VpcConfigRequest::VpcConfigRequest() : 
    m_subnetIdsHasBeenSet(false),
    m_securityGroupIdsHasBeenSet(false),
    m_endpointPublicAccess(false),
    m_endpointPublicAccessHasBeenSet(false),
    m_endpointPrivateAccess(false),
    m_endpointPrivateAccessHasBeenSet(false)
{
}

VpcConfigRequest::VpcConfigRequest(JsonView jsonValue) : 
    m_subnetIdsHasBeenSet(false),
    m_securityGroupIdsHasBeenSet(false),
    m_endpointPublicAccess(false),
    m_endpointPublicAccessHasBeenSet(false),
    m_endpointPrivateAccess(false),
    m_endpointPrivateAccessHasBeenSet(false)
{
  *this = jsonValue;
}

VpcConfigRequest& VpcConfigRequest::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("subnetIds"))
  {
    Array<JsonView> subnetIdsJsonList = jsonValue.GetArray("subnetIds");
    for(unsigned subnetIdsIndex = 0; subnetIdsIndex < subnetIdsJsonList.GetLength(); ++subnetIdsIndex)
    {
      m_subnetIds.push_back(subnetIdsJsonList[subnetIdsIndex].AsString());
    }
    m_subnetIdsHasBeenSet = true;
  }

  if(jsonValue.ValueExists("securityGroupIds"))
  {
    Array<JsonView> securityGroupIdsJsonList = jsonValue.GetArray("securityGroupIds");
    for(unsigned securityGroupIdsIndex = 0; securityGroupIdsIndex < securityGroupIdsJsonList.GetLength(); ++securityGroupIdsIndex)
    {
      m_securityGroupIds.push_back(securityGroupIdsJsonList[securityGroupIdsIndex].AsString());
    }
    m_securityGroupIdsHasBeenSet = true;
  }

  if(jsonValue.ValueExists("endpointPublicAccess"))
  {
    m_endpointPublicAccess = jsonValue.GetBool("endpointPublicAccess");

    m_endpointPublicAccessHasBeenSet = true;
  }

  if(jsonValue.ValueExists("endpointPrivateAccess"))
  {
    m_endpointPrivateAccess = jsonValue.GetBool("endpointPrivateAccess");

    m_endpointPrivateAccessHasBeenSet = true;
  }

  return *this;
}

JsonValue VpcConfigRequest::Jsonize() const
{
  JsonValue payload;

  if(m_subnetIdsHasBeenSet)
  {
   Array<JsonValue> subnetIdsJsonList(m_subnetIds.size());
   for(unsigned subnetIdsIndex = 0; subnetIdsIndex < subnetIdsJsonList.GetLength(); ++subnetIdsIndex)
   {
     subnetIdsJsonList[subnetIdsIndex].AsString(m_subnetIds[subnetIdsIndex]);
   }
   payload.WithArray("subnetIds", std::move(subnetIdsJsonList));

  }

  if(m_securityGroupIdsHasBeenSet)
  {
   Array<JsonValue> securityGroupIdsJsonList(m_securityGroupIds.size());
   for(unsigned securityGroupIdsIndex = 0; securityGroupIdsIndex < securityGroupIdsJsonList.GetLength(); ++securityGroupIdsIndex)
   {
     securityGroupIdsJsonList[securityGroupIdsIndex].AsString(m_securityGroupIds[securityGroupIdsIndex]);
   }
   payload.WithArray("securityGroupIds", std::move(securityGroupIdsJsonList));

  }

  if(m_endpointPublicAccessHasBeenSet)
  {
   payload.WithBool("endpointPublicAccess", m_endpointPublicAccess);

  }

  if(m_endpointPrivateAccessHasBeenSet)
  {
   payload.WithBool("endpointPrivateAccess", m_endpointPrivateAccess);

  }

  return payload;
}

} // namespace Model
} // namespace EKS
} // namespace Aws
