
/* A Bison parser, made by GNU Bison 2.4.1.  */

/* Skeleton implementation for Bison's Yacc-like parsers in C
   
      Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004, 2005, 2006
   Free Software Foundation, Inc.
   
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.
   
   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.4.1"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1

/* Using locations.  */
#define YYLSP_NEEDED 0

/* Substitute the variable and function names.  */
#define yyparse         MYSQLparse
#define yylex           MYSQLlex
#define yyerror         MYSQLerror
#define yylval          MYSQLlval
#define yychar          MYSQLchar
#define yydebug         MYSQLdebug
#define yynerrs         MYSQLnerrs


/* Copy the first part of user declarations.  */

/* Line 189 of yacc.c  */
#line 24 "/export/home/pb2/build/sb_0-8905559-1365164376.65/mysql-5.6.11-release-export-5034961_gpl/sql/sql_yacc.yy"

/* thd is passed as an argument to yyparse(), and subsequently to yylex().
** The type will be void*, so it must be  cast to (THD*) when used.
** Use the YYTHD macro for this.
*/
#define YYPARSE_PARAM yythd
#define YYLEX_PARAM yythd
#define YYTHD ((THD *)yythd)
#define YYLIP (& YYTHD->m_parser_state->m_lip)
#define YYPS (& YYTHD->m_parser_state->m_yacc)
#define YYCSCL  YYTHD->variables.character_set_client

#define MYSQL_YACC
#define YYINITDEPTH 100
#define YYMAXDEPTH 3200                        /* Because of 64K stack */
#define Lex (YYTHD->lex)
#define Select Lex->current_select
#include "sql_priv.h"
#include "unireg.h"                    // REQUIRED: for other includes
#include "sql_parse.h"                        /* comp_*_creator */
#include "sql_table.h"                        /* primary_key_name */
#include "sql_partition.h"  /* mem_alloc_error, partition_info, HASH_PARTITION */
#include "sql_acl.h"                          /* *_ACL */
#include "password.h"       /* my_make_scrambled_password_323, my_make_scrambled_password */
#include "sql_class.h"      /* Key_part_spec, enum_filetype, Diag_condition_item_name */
#include "rpl_slave.h"
#include "lex_symbol.h"
#include "item_create.h"
#include "sp_head.h"
#include "sp_instr.h"
#include "sp_pcontext.h"
#include "sp_rcontext.h"
#include "sp.h"
#include "sql_alter.h"                         // Sql_cmd_alter_table*
#include "sql_truncate.h"                      // Sql_cmd_truncate_table
#include "sql_admin.h"                         // Sql_cmd_analyze/Check..._table
#include "sql_partition_admin.h"               // Sql_cmd_alter_table_*_part.
#include "sql_handler.h"                       // Sql_cmd_handler_*
#include "sql_signal.h"
#include "sql_get_diagnostics.h"               // Sql_cmd_get_diagnostics
#include "event_parse_data.h"
#include <myisam.h>
#include <myisammrg.h>
#include "keycaches.h"
#include "set_var.h"
#include "opt_explain_traditional.h"
#include "opt_explain_json.h"

/* this is to get the bison compilation windows warnings out */
#ifdef _MSC_VER
/* warning C4065: switch statement contains 'default' but no 'case' labels */
#pragma warning (disable : 4065)
#endif

using std::min;
using std::max;

int yylex(void *yylval, void *yythd);

#define yyoverflow(A,B,C,D,E,F)               \
  {                                           \
    ulong val= *(F);                          \
    if (my_yyoverflow((B), (D), &val))        \
    {                                         \
      yyerror((char*) (A));                   \
      return 2;                               \
    }                                         \
    else                                      \
    {                                         \
      *(F)= (YYSIZE_T)val;                    \
    }                                         \
  }

#define MYSQL_YYABORT                         \
  do                                          \
  {                                           \
    LEX::cleanup_lex_after_parse_error(YYTHD);\
    YYABORT;                                  \
  } while (0)

#define MYSQL_YYABORT_UNLESS(A)         \
  if (!(A))                             \
  {                                     \
    my_parse_error(ER(ER_SYNTAX_ERROR));\
    MYSQL_YYABORT;                      \
  }

/*
  Work around for broken code generated by bison 1.875.

  The code generated by bison 1.875a and later, bison 2.1 and bison 2.2 is ok.
  With bison 1.875 however, the generated code contains:
<pre>
  yyerrlab1:
  #if defined (__GNUC_MINOR__) && 2093 <= (__GNUC__ * 1000 + __GNUC_MINOR__)
    __attribute__ ((__unused__))
  #endif
</pre>
  This usage of __attribute__ is illegal, so we remove it.
  See the following references for details:
  http://lists.gnu.org/archive/html/bug-bison/2004-02/msg00014.html
  http://gcc.gnu.org/bugzilla/show_bug.cgi?id=14273
*/

#if defined (__GNUC_MINOR__) && 2093 <= (__GNUC__ * 1000 + __GNUC_MINOR__)
#undef __attribute__
#define __attribute__(X)
#endif


#ifndef DBUG_OFF
#define YYDEBUG 1
#else
#define YYDEBUG 0
#endif

/**
  @brief Push an error message into MySQL error stack with line
  and position information.

  This function provides semantic action implementers with a way
  to push the famous "You have a syntax error near..." error
  message into the error stack, which is normally produced only if
  a parse error is discovered internally by the Bison generated
  parser.
*/

void my_parse_error(const char *s)
{
  THD *thd= current_thd;
  Lex_input_stream *lip= & thd->m_parser_state->m_lip;

  const char *yytext= lip->get_tok_start();
  if (!yytext)
    yytext= "";

  /* Push an error into the error stack */
  ErrConvString err(yytext, thd->variables.character_set_client);
  my_printf_error(ER_PARSE_ERROR,  ER(ER_PARSE_ERROR), MYF(0), s,
                  err.ptr(), lip->yylineno);
}

/**
  @brief Bison callback to report a syntax/OOM error

  This function is invoked by the bison-generated parser
  when a syntax error, a parse error or an out-of-memory
  condition occurs. This function is not invoked when the
  parser is requested to abort by semantic action code
  by means of YYABORT or YYACCEPT macros. This is why these
  macros should not be used (use MYSQL_YYABORT/MYSQL_YYACCEPT
  instead).

  The parser will abort immediately after invoking this callback.

  This function is not for use in semantic actions and is internal to
  the parser, as it performs some pre-return cleanup. 
  In semantic actions, please use my_parse_error or my_error to
  push an error into the error stack and MYSQL_YYABORT
  to abort from the parser.
*/

void MYSQLerror(const char *s)
{
  THD *thd= current_thd;

  /*
    Restore the original LEX if it was replaced when parsing
    a stored procedure. We must ensure that a parsing error
    does not leave any side effects in the THD.
  */
  LEX::cleanup_lex_after_parse_error(thd);

  /* "parse error" changed into "syntax error" between bison 1.75 and 1.875 */
  if (strcmp(s,"parse error") == 0 || strcmp(s,"syntax error") == 0)
    s= ER(ER_SYNTAX_ERROR);
  my_parse_error(s);
}


#ifndef DBUG_OFF
void turn_parser_debug_on()
{
  /*
     MYSQLdebug is in sql/sql_yacc.cc, in bison generated code.
     Turning this option on is **VERY** verbose, and should be
     used when investigating a syntax error problem only.

     The syntax to run with bison traces is as follows :
     - Starting a server manually :
       mysqld --debug="d,parser_debug" ...
     - Running a test :
       mysql-test-run.pl --mysqld="--debug=d,parser_debug" ...

     The result will be in the process stderr (var/log/master.err)
   */

  extern int yydebug;
  yydebug= 1;
}
#endif

static bool is_native_function(THD *thd, const LEX_STRING *name)
{
  if (find_native_function_builder(thd, *name))
    return true;

  if (is_lex_native_function(name))
    return true;

  return false;
}


/**
  Helper action for a case statement (entering the CASE).
  This helper is used for both 'simple' and 'searched' cases.
  This helper, with the other case_stmt_action_..., is executed when
  the following SQL code is parsed:
<pre>
CREATE PROCEDURE proc_19194_simple(i int)
BEGIN
  DECLARE str CHAR(10);

  CASE i
    WHEN 1 THEN SET str="1";
    WHEN 2 THEN SET str="2";
    WHEN 3 THEN SET str="3";
    ELSE SET str="unknown";
  END CASE;

  SELECT str;
END
</pre>
  The actions are used to generate the following code:
<pre>
SHOW PROCEDURE CODE proc_19194_simple;
Pos     Instruction
0       set str@1 NULL
1       set_case_expr (12) 0 i@0
2       jump_if_not 5(12) (case_expr@0 = 1)
3       set str@1 _latin1'1'
4       jump 12
5       jump_if_not 8(12) (case_expr@0 = 2)
6       set str@1 _latin1'2'
7       jump 12
8       jump_if_not 11(12) (case_expr@0 = 3)
9       set str@1 _latin1'3'
10      jump 12
11      set str@1 _latin1'unknown'
12      stmt 0 "SELECT str"
</pre>

  @param thd thread handler
*/

void case_stmt_action_case(THD *thd)
{
  LEX *lex= thd->lex;
  sp_head *sp= lex->sphead;
  sp_pcontext *pctx= lex->get_sp_current_parsing_ctx();

  sp->m_parser_data.new_cont_backpatch();

  /*
    BACKPATCH: Creating target label for the jump to
    "case_stmt_action_end_case"
    (Instruction 12 in the example)
  */

  pctx->push_label(thd, EMPTY_STR, sp->instructions());
}

/**
  Helper action for a case then statements.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
*/

bool case_stmt_action_then(THD *thd, LEX *lex)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *pctx= lex->get_sp_current_parsing_ctx();

  sp_instr_jump *i =
    new (thd->mem_root) sp_instr_jump(sp->instructions(), pctx);

  if (!i || sp->add_instr(thd, i))
    return true;

  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  sp->m_parser_data.do_backpatch(pctx->pop_label(), sp->instructions());

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */

  return sp->m_parser_data.add_backpatch_entry(i, pctx->last_label());
}

/**
  Helper action for an end case.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param simple true for simple cases, false for searched cases
*/

void case_stmt_action_end_case(LEX *lex, bool simple)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *pctx= lex->get_sp_current_parsing_ctx();

  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */
  sp->m_parser_data.do_backpatch(pctx->pop_label(), sp->instructions());

  if (simple)
    pctx->pop_case_expr_id();

  sp->m_parser_data.do_cont_backpatch(sp->instructions());
}


static bool
find_sys_var_null_base(THD *thd, struct sys_var_with_base *tmp)
{
  tmp->var= find_sys_var(thd, tmp->base_name.str, tmp->base_name.length);

  if (tmp->var == NULL)
    my_error(ER_UNKNOWN_SYSTEM_VARIABLE, MYF(0), tmp->base_name.str);
  else
    tmp->base_name= null_lex_str;

  return thd->is_error();
}


/**
  Helper action for a SET statement.
  Used to push a system variable into the assignment list.

  @param thd      the current thread
  @param tmp      the system variable with base name
  @param var_type the scope of the variable
  @param val      the value being assigned to the variable

  @return TRUE if error, FALSE otherwise.
*/

static bool
set_system_variable(THD *thd, struct sys_var_with_base *tmp,
                    enum enum_var_type var_type, Item *val)
{
  set_var *var;
  LEX *lex= thd->lex;
  sp_head *sp= lex->sphead;
  sp_pcontext *pctx= lex->get_sp_current_parsing_ctx();

  /* No AUTOCOMMIT from a stored function or trigger. */
  if (pctx && tmp->var == Sys_autocommit_ptr)
    sp->m_flags|= sp_head::HAS_SET_AUTOCOMMIT_STMT;

#ifdef HAVE_REPLICATION
  if (lex->uses_stored_routines() &&
      ((tmp->var == Sys_gtid_next_ptr
#ifdef HAVE_GTID_NEXT_LIST
       || tmp->var == Sys_gtid_next_list_ptr
#endif
       ) ||
       Sys_gtid_purged_ptr == tmp->var))
  {
    my_error(ER_SET_STATEMENT_CANNOT_INVOKE_FUNCTION, MYF(0),
             tmp->var->name.str);
    return TRUE;
  }
#endif

  if (! (var= new set_var(var_type, tmp->var, &tmp->base_name, val)))
    return TRUE;

  return lex->var_list.push_back(var);
}


/**
  Helper action for a SET statement.
  Used to SET a field of NEW row.

  @param thd                thread handler
  @param trigger_field_name the NEW-row field name
  @param expr_item          the value expression being assigned
  @param expr_query         the value expression query

  @return error status (true if error, false otherwise).
*/

static bool set_trigger_new_row(THD *thd,
                                LEX_STRING trigger_field_name,
                                Item *expr_item,
                                LEX_STRING expr_query)
{
  LEX *lex= thd->lex;
  sp_head *sp= lex->sphead;

  DBUG_ASSERT(expr_item);
  DBUG_ASSERT(sp->m_trg_chistics.action_time == TRG_ACTION_BEFORE &&
              (sp->m_trg_chistics.event == TRG_EVENT_INSERT ||
               sp->m_trg_chistics.event == TRG_EVENT_UPDATE));

  Item_trigger_field *trg_fld=
    new (thd->mem_root) Item_trigger_field(lex->current_context(),
                                           Item_trigger_field::NEW_ROW,
                                           trigger_field_name.str,
                                           UPDATE_ACL, false);

  if (!trg_fld)
    return true;

  sp_instr_set_trigger_field *i=
    new (thd->mem_root)
      sp_instr_set_trigger_field(sp->instructions(),
                                 lex,
                                 trigger_field_name,
                                 trg_fld, expr_item,
                                 expr_query);

  if (!i)
    return true;

  /*
    Let us add this item to list of all Item_trigger_field
    objects in trigger.
  */
  sp->m_trg_table_fields.link_in_list(trg_fld, &trg_fld->next_trg_field);

  return sp->add_instr(thd, i);
}


/**
  Create an object to represent a SP variable in the Item-hierarchy.

  @param thd              The current thread.
  @param name             The SP variable name.
  @param spv              The SP variable (optional).
  @param query_start_ptr  Start of the SQL-statement query string (optional).
  @param start_in_q       Start position of the SP variable name in the query.
  @param end_in_q         End position of the SP variable name in the query.

  @remark If spv is not specified, the name is used to search for the
          variable in the parse-time context. If the variable does not
          exist, a error is set and NULL is returned to the caller.

  @return An Item_splocal object representing the SP variable, or NULL on error.
*/
static Item_splocal* create_item_for_sp_var(THD *thd,
                                            LEX_STRING name,
                                            sp_variable *spv,
                                            const char *query_start_ptr,
                                            const char *start_in_q,
                                            const char *end_in_q)
{
  LEX *lex= thd->lex;
  uint spv_pos_in_query= 0;
  uint spv_len_in_query= 0;
  sp_pcontext *pctx= lex->get_sp_current_parsing_ctx();

  /* If necessary, look for the variable. */
  if (pctx && !spv)
    spv= pctx->find_variable(name, false);

  if (!spv)
  {
    my_error(ER_SP_UNDECLARED_VAR, MYF(0), name.str);
    return NULL;
  }

  DBUG_ASSERT(pctx && spv);

  if (query_start_ptr)
  {
    /* Position and length of the SP variable name in the query. */
    spv_pos_in_query= start_in_q - query_start_ptr;
    spv_len_in_query= end_in_q - start_in_q;
  }

  Item_splocal *item=
    new (thd->mem_root) Item_splocal(
      name, spv->offset, spv->type, spv_pos_in_query, spv_len_in_query);

#ifndef DBUG_OFF
  if (item)
    item->m_sp= lex->sphead;
#endif

  return item;
}


/**
  Helper to resolve the SQL:2003 Syntax exception 1) in <in predicate>.
  See SQL:2003, Part 2, section 8.4 <in predicate>, Note 184, page 383.
  This function returns the proper item for the SQL expression
  <code>left [NOT] IN ( expr )</code>
  @param thd the current thread
  @param left the in predicand
  @param equal true for IN predicates, false for NOT IN predicates
  @param expr first and only expression of the in value list
  @return an expression representing the IN predicate.
*/
Item* handle_sql2003_note184_exception(THD *thd, Item* left, bool equal,
                                       Item *expr)
{
  /*
    Relevant references for this issue:
    - SQL:2003, Part 2, section 8.4 <in predicate>, page 383,
    - SQL:2003, Part 2, section 7.2 <row value expression>, page 296,
    - SQL:2003, Part 2, section 6.3 <value expression primary>, page 174,
    - SQL:2003, Part 2, section 7.15 <subquery>, page 370,
    - SQL:2003 Feature F561, "Full value expressions".

    The exception in SQL:2003 Note 184 means:
    Item_singlerow_subselect, which corresponds to a <scalar subquery>,
    should be re-interpreted as an Item_in_subselect, which corresponds
    to a <table subquery> when used inside an <in predicate>.

    Our reading of Note 184 is reccursive, so that all:
    - IN (( <subquery> ))
    - IN ((( <subquery> )))
    - IN '('^N <subquery> ')'^N
    - etc
    should be interpreted as a <table subquery>, no matter how deep in the
    expression the <subquery> is.
  */

  Item *result;

  DBUG_ENTER("handle_sql2003_note184_exception");

  if (expr->type() == Item::SUBSELECT_ITEM)
  {
    Item_subselect *expr2 = (Item_subselect*) expr;

    if (expr2->substype() == Item_subselect::SINGLEROW_SUBS)
    {
      Item_singlerow_subselect *expr3 = (Item_singlerow_subselect*) expr2;
      st_select_lex *subselect;

      /*
        Implement the mandated change, by altering the semantic tree:
          left IN Item_singlerow_subselect(subselect)
        is modified to
          left IN (subselect)
        which is represented as
          Item_in_subselect(left, subselect)
      */
      subselect= expr3->invalidate_and_restore_select_lex();
      result= new (thd->mem_root) Item_in_subselect(left, subselect);

      if (! equal)
        result = negate_expression(thd, result);

      DBUG_RETURN(result);
    }
  }

  if (equal)
    result= new (thd->mem_root) Item_func_eq(left, expr);
  else
    result= new (thd->mem_root) Item_func_ne(left, expr);

  DBUG_RETURN(result);
}

/**
   @brief Creates a new SELECT_LEX for a UNION branch.

   Sets up and initializes a SELECT_LEX structure for a query once the parser
   discovers a UNION token. The current SELECT_LEX is pushed on the stack and
   the new SELECT_LEX becomes the current one.

   @param lex The parser state.

   @param is_union_distinct True if the union preceding the new select statement
   uses UNION DISTINCT.

   @param is_top_level This should be @c TRUE if the newly created SELECT_LEX
   is a non-nested statement.

   @return <code>false</code> if successful, <code>true</code> if an error was
   reported. In the latter case parsing should stop.
 */
bool add_select_to_union_list(LEX *lex, bool is_union_distinct, 
                              bool is_top_level)
{
  /* 
     Only the last SELECT can have INTO. Since the grammar won't allow INTO in
     a nested SELECT, we make this check only when creating a top-level SELECT.
  */
  if (is_top_level && lex->result)
  {
    my_error(ER_WRONG_USAGE, MYF(0), "UNION", "INTO");
    return TRUE;
  }
  if (lex->proc_analyse)
  {
    my_error(ER_WRONG_USAGE, MYF(0), "UNION", "SELECT ... PROCEDURE ANALYSE()");
    return TRUE;
  }
  if (lex->current_select->linkage == GLOBAL_OPTIONS_TYPE)
  {
    my_parse_error(ER(ER_SYNTAX_ERROR));
    return TRUE;
  }
  /* This counter shouldn't be incremented for UNION parts */
  lex->nest_level--;
  if (mysql_new_select(lex, 0))
    return TRUE;
  mysql_init_select(lex);
  lex->current_select->linkage=UNION_TYPE;
  if (is_union_distinct) /* UNION DISTINCT - remember position */
    lex->current_select->master_unit()->union_distinct=
      lex->current_select;
  return FALSE;
}

/**
   @brief Initializes a SELECT_LEX for a query within parentheses (aka
   braces).

   @return false if successful, true if an error was reported. In the latter
   case parsing should stop.
 */
bool setup_select_in_parentheses(LEX *lex) 
{
  SELECT_LEX * sel= lex->current_select;
  if (sel->set_braces(1))
  {
    my_parse_error(ER(ER_SYNTAX_ERROR));
    return TRUE;
  }
  if (sel->linkage == UNION_TYPE &&
      !sel->master_unit()->first_select()->braces &&
      sel->master_unit()->first_select()->linkage ==
      UNION_TYPE)
  {
    my_parse_error(ER(ER_SYNTAX_ERROR));
    return TRUE;
  }
  if (sel->linkage == UNION_TYPE &&
      sel->olap != UNSPECIFIED_OLAP_TYPE &&
      sel->master_unit()->fake_select_lex)
  {
    my_error(ER_WRONG_USAGE, MYF(0), "CUBE/ROLLUP", "ORDER BY");
    return TRUE;
  }
  /* select in braces, can't contain global parameters */
  if (sel->master_unit()->fake_select_lex)
    sel->master_unit()->global_parameters=
      sel->master_unit()->fake_select_lex;
  return FALSE;
}

static bool add_create_index_prepare (LEX *lex, Table_ident *table)
{
  lex->sql_command= SQLCOM_CREATE_INDEX;
  if (!lex->current_select->add_table_to_list(lex->thd, table, NULL,
                                              TL_OPTION_UPDATING,
                                              TL_READ_NO_INSERT,
                                              MDL_SHARED_UPGRADABLE))
    return TRUE;
  lex->alter_info.reset();
  lex->alter_info.flags= Alter_info::ALTER_ADD_INDEX;
  lex->col_list.empty();
  lex->change= NullS;
  return FALSE;
}

static bool add_create_index (LEX *lex, Key::Keytype type,
                              const LEX_STRING &name,
                              KEY_CREATE_INFO *info= NULL, bool generated= 0)
{
  Key *key;
  key= new Key(type, name, info ? info : &lex->key_create_info, generated, 
               lex->col_list);
  if (key == NULL)
    return TRUE;

  lex->alter_info.key_list.push_back(key);
  lex->col_list.empty();
  return FALSE;
}

/**
  Make a new string allocated on THD's mem-root.

  @param thd        thread handler.
  @param start_ptr  start of the new string.
  @param end_ptr    end of the new string.

  @return LEX_STRING object, containing a pointer to a newly
  constructed/allocated string, and its length. The pointer is NULL
  in case of out-of-memory error.
*/
static LEX_STRING make_string(THD *thd,
                              const char *start_ptr,
                              const char *end_ptr)
{
  LEX_STRING s;

  s.length= end_ptr - start_ptr;
  s.str= (char *) thd->alloc(s.length + 1);

  if (s.str)
    strmake(s.str, start_ptr, s.length);

  return s;
}

/*
  The start is either lip->ptr, if there was no lookahead, lip->tok_start
  otherwise.
*/
#define YY_TOKEN_START \
  ((yychar == YYEMPTY) ?  YYLIP->get_ptr() : YYLIP->get_tok_start())

/*
   The end is either lip->ptr, if there was no lookahead,
   or lip->tok_end otherwise.
*/

#define YY_TOKEN_END \
  ((yychar == YYEMPTY) ?  YYLIP->get_ptr() : YYLIP->get_tok_end())

/**
  Create a separate LEX for each assignment if in SP.

  If we are in SP we want have own LEX for each assignment.
  This is mostly because it is hard for several sp_instr_set
  and sp_instr_set_trigger instructions share one LEX.
  (Well, it is theoretically possible but adds some extra
  overhead on preparation for execution stage and IMO less
  robust).

  @see sp_create_assignment_instr

  @param thd        Thread context
  @param option_ptr Option-value-expression start pointer
*/

static void sp_create_assignment_lex(THD *thd, const char *option_ptr)
{
  LEX *lex= thd->lex;
  sp_head *sp= lex->sphead;

  /*
    We can come here in the following cases:

      1. it's a regular SET statement outside stored programs
        (lex->sphead is NULL);

      2. we're parsing a stored program normally (loading from mysql.proc, ...);

      3. we're re-parsing SET-statement with a user variable after meta-data
        change. It's guaranteed, that:
        - this SET-statement deals with a user/system variable (otherwise, it
          would be a different SP-instruction, and we would parse an expression);
        - this SET-statement has a single user/system variable assignment
          (that's how we generate sp_instr_stmt-instructions for SET-statements).
        So, in this case, even if lex->sphead is set, we should not process
        further.
  */

  if (!sp ||            // case #1
      sp->is_invoked()) // case #3
  {
    return;
  }

  LEX *old_lex= lex;
  sp->reset_lex(thd);
  lex= thd->lex;

  /* Set new LEX as if we at start of set rule. */
  mysql_init_select(lex);
  lex->sql_command= SQLCOM_SET_OPTION;
  lex->var_list.empty();
  lex->one_shot_set= 0;
  lex->autocommit= 0;

  /*
    It's a SET statement within SP. It will be either translated
    into one or more sp_instr_stmt instructions, or it will be
    sp_instr_set / sp_instr_set_trigger_field instructions.
    In any case, position of SP-variable can not be determined
    reliably. So, we set the start pointer of the current statement
    to NULL.
  */
  sp->m_parser_data.set_current_stmt_start_ptr(NULL);
  sp->m_parser_data.set_option_start_ptr(option_ptr);

  /* Inherit from outer lex. */
  lex->option_type= old_lex->option_type;
}


/**
  Create a SP instruction for a SET assignment.

  @see sp_create_assignment_lex

  @param thd           Thread context
  @param expr_end_ptr  Option-value-expression end pointer

  @return false if success, true otherwise.
*/

static bool sp_create_assignment_instr(THD *thd, const char *expr_end_ptr)
{
  LEX *lex= thd->lex;
  sp_head *sp= lex->sphead;

  /*
    We can come here in the following cases:

      1. it's a regular SET statement outside stored programs
        (lex->sphead is NULL);

      2. we're parsing a stored program normally (loading from mysql.proc, ...);

      3. we're re-parsing SET-statement with a user variable after meta-data
        change. It's guaranteed, that:
        - this SET-statement deals with a user/system variable (otherwise, it
          would be a different SP-instruction, and we would parse an expression);
        - this SET-statement has a single user/system variable assignment
          (that's how we generate sp_instr_stmt-instructions for SET-statements).
        So, in this case, even if lex->sphead is set, we should not process
        further.
  */

  if (!sp ||            // case #1
      sp->is_invoked()) // case #3
  {
    return false;
  }

  if (!lex->var_list.is_empty())
  {
    /* Extract expression string. */

    const char *expr_start_ptr= sp->m_parser_data.get_option_start_ptr();

    LEX_STRING expr;
    expr.str= (char *) expr_start_ptr;
    expr.length= expr_end_ptr - expr_start_ptr;

    /* Construct SET-statement query. */

    LEX_STRING set_stmt_query;

    set_stmt_query.length= expr.length + 3;
    set_stmt_query.str= (char *) thd->alloc(set_stmt_query.length + 1);

    if (!set_stmt_query.str)
      return true;

    strmake(strmake(set_stmt_query.str, "SET", 3),
            expr.str, expr.length);

    /*
      We have assignment to user or system variable or option setting, so we
      should construct sp_instr_stmt for it.
    */

    sp_instr_stmt *i=
      new (thd->mem_root)
        sp_instr_stmt(sp->instructions(), lex, set_stmt_query);

    if (!i || sp->add_instr(thd, i))
      return true;
  }

  /* Remember option_type of the currently parsed LEX. */
  enum_var_type inner_option_type= lex->option_type;

  if (sp->restore_lex(thd))
    return true;

  /* Copy option_type to outer lex in case it has changed. */
  thd->lex->option_type= inner_option_type;

  return false;
}

/**
  Compare a LEX_USER against the current user as defined by the exact user and
  host used during authentication.

  @param user A pointer to a user which needs to be matched against the
              current.

  @see SET PASSWORD rules

  @retval true The specified user is the authorized user
  @retval false The user doesn't match
*/

bool match_authorized_user(Security_context *ctx, LEX_USER *user)
{
  if(user->user.str && my_strcasecmp(system_charset_info,
                                     ctx->priv_user,
                                     user->user.str) == 0)
  {
    /*
      users match; let's compare hosts.
      1. first compare with the host we actually authorized,
      2. then see if we match the host mask of the priv_host
    */
    if (user->host.str && my_strcasecmp(system_charset_info,
                                        user->host.str,
                                        ctx->priv_host) == 0)
    {
      /* specified user exactly match the authorized user */
      return true;
    }
  }
  return false;
}




/* Line 189 of yacc.c  */
#line 1024 "/export/home/pb2/build/sb_0-8905559-1365164376.65/dist_GPL/sql/sql_yacc.cc"

/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* Enabling the token table.  */
#ifndef YYTOKEN_TABLE
# define YYTOKEN_TABLE 0
#endif


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     ABORT_SYM = 258,
     ACCESSIBLE_SYM = 259,
     ACTION = 260,
     ADD = 261,
     ADDDATE_SYM = 262,
     AFTER_SYM = 263,
     AGAINST = 264,
     AGGREGATE_SYM = 265,
     ALGORITHM_SYM = 266,
     ALL = 267,
     ALTER = 268,
     ANALYSE_SYM = 269,
     ANALYZE_SYM = 270,
     AND_AND_SYM = 271,
     AND_SYM = 272,
     ANY_SYM = 273,
     AS = 274,
     ASC = 275,
     ASCII_SYM = 276,
     ASENSITIVE_SYM = 277,
     AT_SYM = 278,
     AUTOEXTEND_SIZE_SYM = 279,
     AUTO_INC = 280,
     AVG_ROW_LENGTH = 281,
     AVG_SYM = 282,
     BACKUP_SYM = 283,
     BEFORE_SYM = 284,
     BEGIN_SYM = 285,
     BETWEEN_SYM = 286,
     BIGINT = 287,
     BINARY = 288,
     BINLOG_SYM = 289,
     BIN_NUM = 290,
     BIT_AND = 291,
     BIT_OR = 292,
     BIT_SYM = 293,
     BIT_XOR = 294,
     BLOB_SYM = 295,
     BLOCK_SYM = 296,
     BOOLEAN_SYM = 297,
     BOOL_SYM = 298,
     BOTH = 299,
     BTREE_SYM = 300,
     BY = 301,
     BYTE_SYM = 302,
     CACHE_SYM = 303,
     CALL_SYM = 304,
     CASCADE = 305,
     CASCADED = 306,
     CASE_SYM = 307,
     CAST_SYM = 308,
     CATALOG_NAME_SYM = 309,
     CHAIN_SYM = 310,
     CHANGE = 311,
     CHANGED = 312,
     CHARSET = 313,
     CHAR_SYM = 314,
     CHECKSUM_SYM = 315,
     CHECK_SYM = 316,
     CIPHER_SYM = 317,
     CLASS_ORIGIN_SYM = 318,
     CLIENT_SYM = 319,
     CLOSE_SYM = 320,
     COALESCE = 321,
     CODE_SYM = 322,
     COLLATE_SYM = 323,
     COLLATION_SYM = 324,
     COLUMNS = 325,
     COLUMN_SYM = 326,
     COLUMN_FORMAT_SYM = 327,
     COLUMN_NAME_SYM = 328,
     COMMENT_SYM = 329,
     COMMITTED_SYM = 330,
     COMMIT_SYM = 331,
     COMPACT_SYM = 332,
     COMPLETION_SYM = 333,
     COMPRESSED_SYM = 334,
     CONCURRENT = 335,
     CONDITION_SYM = 336,
     CONNECTION_SYM = 337,
     CONSISTENT_SYM = 338,
     CONSTRAINT = 339,
     CONSTRAINT_CATALOG_SYM = 340,
     CONSTRAINT_NAME_SYM = 341,
     CONSTRAINT_SCHEMA_SYM = 342,
     CONTAINS_SYM = 343,
     CONTEXT_SYM = 344,
     CONTINUE_SYM = 345,
     CONVERT_SYM = 346,
     COUNT_SYM = 347,
     CPU_SYM = 348,
     CREATE = 349,
     CROSS = 350,
     CUBE_SYM = 351,
     CURDATE = 352,
     CURRENT_SYM = 353,
     CURRENT_USER = 354,
     CURSOR_SYM = 355,
     CURSOR_NAME_SYM = 356,
     CURTIME = 357,
     DATABASE = 358,
     DATABASES = 359,
     DATAFILE_SYM = 360,
     DATA_SYM = 361,
     DATETIME = 362,
     DATE_ADD_INTERVAL = 363,
     DATE_SUB_INTERVAL = 364,
     DATE_SYM = 365,
     DAY_HOUR_SYM = 366,
     DAY_MICROSECOND_SYM = 367,
     DAY_MINUTE_SYM = 368,
     DAY_SECOND_SYM = 369,
     DAY_SYM = 370,
     DEALLOCATE_SYM = 371,
     DECIMAL_NUM = 372,
     DECIMAL_SYM = 373,
     DECLARE_SYM = 374,
     DEFAULT = 375,
     DEFAULT_AUTH_SYM = 376,
     DEFINER_SYM = 377,
     DELAYED_SYM = 378,
     DELAY_KEY_WRITE_SYM = 379,
     DELETE_SYM = 380,
     DESC = 381,
     DESCRIBE = 382,
     DES_KEY_FILE = 383,
     DETERMINISTIC_SYM = 384,
     DIAGNOSTICS_SYM = 385,
     DIRECTORY_SYM = 386,
     DISABLE_SYM = 387,
     DISCARD = 388,
     DISK_SYM = 389,
     DISTINCT = 390,
     DIV_SYM = 391,
     DOUBLE_SYM = 392,
     DO_SYM = 393,
     DROP = 394,
     DUAL_SYM = 395,
     DUMPFILE = 396,
     DUPLICATE_SYM = 397,
     DYNAMIC_SYM = 398,
     EACH_SYM = 399,
     ELSE = 400,
     ELSEIF_SYM = 401,
     ENABLE_SYM = 402,
     ENCLOSED = 403,
     END = 404,
     ENDS_SYM = 405,
     END_OF_INPUT = 406,
     ENGINES_SYM = 407,
     ENGINE_SYM = 408,
     ENUM = 409,
     EQ = 410,
     EQUAL_SYM = 411,
     ERROR_SYM = 412,
     ERRORS = 413,
     ESCAPED = 414,
     ESCAPE_SYM = 415,
     EVENTS_SYM = 416,
     EVENT_SYM = 417,
     EVERY_SYM = 418,
     EXCHANGE_SYM = 419,
     EXECUTE_SYM = 420,
     EXISTS = 421,
     EXIT_SYM = 422,
     EXPANSION_SYM = 423,
     EXPIRE_SYM = 424,
     EXPORT_SYM = 425,
     EXTENDED_SYM = 426,
     EXTENT_SIZE_SYM = 427,
     EXTRACT_SYM = 428,
     FALSE_SYM = 429,
     FAST_SYM = 430,
     FAULTS_SYM = 431,
     FETCH_SYM = 432,
     FILE_SYM = 433,
     FIRST_SYM = 434,
     FIXED_SYM = 435,
     FLOAT_NUM = 436,
     FLOAT_SYM = 437,
     FLUSH_SYM = 438,
     FORCE_SYM = 439,
     FOREIGN = 440,
     FOR_SYM = 441,
     FORMAT_SYM = 442,
     FOUND_SYM = 443,
     FROM = 444,
     FULL = 445,
     FULLTEXT_SYM = 446,
     FUNCTION_SYM = 447,
     GE = 448,
     GENERAL = 449,
     GEOMETRYCOLLECTION = 450,
     GEOMETRY_SYM = 451,
     GET_FORMAT = 452,
     GET_SYM = 453,
     GLOBAL_SYM = 454,
     GRANT = 455,
     GRANTS = 456,
     GROUP_SYM = 457,
     GROUP_CONCAT_SYM = 458,
     GT_SYM = 459,
     HANDLER_SYM = 460,
     HASH_SYM = 461,
     HAVING = 462,
     HELP_SYM = 463,
     HEX_NUM = 464,
     HIGH_PRIORITY = 465,
     HOST_SYM = 466,
     HOSTS_SYM = 467,
     HOUR_MICROSECOND_SYM = 468,
     HOUR_MINUTE_SYM = 469,
     HOUR_SECOND_SYM = 470,
     HOUR_SYM = 471,
     IDENT = 472,
     IDENTIFIED_SYM = 473,
     IDENT_QUOTED = 474,
     IF = 475,
     IGNORE_SYM = 476,
     IGNORE_SERVER_IDS_SYM = 477,
     IMPORT = 478,
     INDEXES = 479,
     INDEX_SYM = 480,
     INFILE = 481,
     INITIAL_SIZE_SYM = 482,
     INNER_SYM = 483,
     INOUT_SYM = 484,
     INSENSITIVE_SYM = 485,
     INSERT = 486,
     INSERT_METHOD = 487,
     INSTALL_SYM = 488,
     INTERVAL_SYM = 489,
     INTO = 490,
     INT_SYM = 491,
     INVOKER_SYM = 492,
     IN_SYM = 493,
     IO_AFTER_GTIDS = 494,
     IO_BEFORE_GTIDS = 495,
     IO_SYM = 496,
     IPC_SYM = 497,
     IS = 498,
     ISOLATION = 499,
     ISSUER_SYM = 500,
     ITERATE_SYM = 501,
     JOIN_SYM = 502,
     KEYS = 503,
     KEY_BLOCK_SIZE = 504,
     KEY_SYM = 505,
     KILL_SYM = 506,
     LANGUAGE_SYM = 507,
     LAST_SYM = 508,
     LE = 509,
     LEADING = 510,
     LEAVES = 511,
     LEAVE_SYM = 512,
     LEFT = 513,
     LESS_SYM = 514,
     LEVEL_SYM = 515,
     LEX_HOSTNAME = 516,
     LIKE = 517,
     LIMIT = 518,
     LINEAR_SYM = 519,
     LINES = 520,
     LINESTRING = 521,
     LIST_SYM = 522,
     LOAD = 523,
     LOCAL_SYM = 524,
     LOCATOR_SYM = 525,
     LOCKS_SYM = 526,
     LOCK_SYM = 527,
     LOGFILE_SYM = 528,
     LOGS_SYM = 529,
     LONGBLOB = 530,
     LONGTEXT = 531,
     LONG_NUM = 532,
     LONG_SYM = 533,
     LOOP_SYM = 534,
     LOW_PRIORITY = 535,
     LT = 536,
     MASTER_AUTO_POSITION_SYM = 537,
     MASTER_BIND_SYM = 538,
     MASTER_CONNECT_RETRY_SYM = 539,
     MASTER_DELAY_SYM = 540,
     MASTER_HOST_SYM = 541,
     MASTER_LOG_FILE_SYM = 542,
     MASTER_LOG_POS_SYM = 543,
     MASTER_PASSWORD_SYM = 544,
     MASTER_PORT_SYM = 545,
     MASTER_RETRY_COUNT_SYM = 546,
     MASTER_SERVER_ID_SYM = 547,
     MASTER_SSL_CAPATH_SYM = 548,
     MASTER_SSL_CA_SYM = 549,
     MASTER_SSL_CERT_SYM = 550,
     MASTER_SSL_CIPHER_SYM = 551,
     MASTER_SSL_CRL_SYM = 552,
     MASTER_SSL_CRLPATH_SYM = 553,
     MASTER_SSL_KEY_SYM = 554,
     MASTER_SSL_SYM = 555,
     MASTER_SSL_VERIFY_SERVER_CERT_SYM = 556,
     MASTER_SYM = 557,
     MASTER_USER_SYM = 558,
     MASTER_HEARTBEAT_PERIOD_SYM = 559,
     MATCH = 560,
     MAX_CONNECTIONS_PER_HOUR = 561,
     MAX_QUERIES_PER_HOUR = 562,
     MAX_ROWS = 563,
     MAX_SIZE_SYM = 564,
     MAX_SYM = 565,
     MAX_UPDATES_PER_HOUR = 566,
     MAX_USER_CONNECTIONS_SYM = 567,
     MAX_VALUE_SYM = 568,
     MEDIUMBLOB = 569,
     MEDIUMINT = 570,
     MEDIUMTEXT = 571,
     MEDIUM_SYM = 572,
     MEMORY_SYM = 573,
     MERGE_SYM = 574,
     MESSAGE_TEXT_SYM = 575,
     MICROSECOND_SYM = 576,
     MIGRATE_SYM = 577,
     MINUTE_MICROSECOND_SYM = 578,
     MINUTE_SECOND_SYM = 579,
     MINUTE_SYM = 580,
     MIN_ROWS = 581,
     MIN_SYM = 582,
     MODE_SYM = 583,
     MODIFIES_SYM = 584,
     MODIFY_SYM = 585,
     MOD_SYM = 586,
     MONTH_SYM = 587,
     MULTILINESTRING = 588,
     MULTIPOINT = 589,
     MULTIPOLYGON = 590,
     MUTEX_SYM = 591,
     MYSQL_ERRNO_SYM = 592,
     NAMES_SYM = 593,
     NAME_SYM = 594,
     NATIONAL_SYM = 595,
     NATURAL = 596,
     NCHAR_STRING = 597,
     NCHAR_SYM = 598,
     NDBCLUSTER_SYM = 599,
     NE = 600,
     NEG = 601,
     NEW_SYM = 602,
     NEXT_SYM = 603,
     NODEGROUP_SYM = 604,
     NONE_SYM = 605,
     NOT2_SYM = 606,
     NOT_SYM = 607,
     NOW_SYM = 608,
     NO_SYM = 609,
     NO_WAIT_SYM = 610,
     NO_WRITE_TO_BINLOG = 611,
     NULL_SYM = 612,
     NUM = 613,
     NUMBER_SYM = 614,
     NUMERIC_SYM = 615,
     NVARCHAR_SYM = 616,
     OFFSET_SYM = 617,
     OLD_PASSWORD = 618,
     ON = 619,
     ONE_SYM = 620,
     ONLY_SYM = 621,
     OPEN_SYM = 622,
     OPTIMIZE = 623,
     OPTIONS_SYM = 624,
     OPTION = 625,
     OPTIONALLY = 626,
     OR2_SYM = 627,
     ORDER_SYM = 628,
     OR_OR_SYM = 629,
     OR_SYM = 630,
     OUTER = 631,
     OUTFILE = 632,
     OUT_SYM = 633,
     OWNER_SYM = 634,
     PACK_KEYS_SYM = 635,
     PAGE_SYM = 636,
     PARAM_MARKER = 637,
     PARSER_SYM = 638,
     PARTIAL = 639,
     PARTITION_SYM = 640,
     PARTITIONS_SYM = 641,
     PARTITIONING_SYM = 642,
     PASSWORD = 643,
     PHASE_SYM = 644,
     PLUGIN_DIR_SYM = 645,
     PLUGIN_SYM = 646,
     PLUGINS_SYM = 647,
     POINT_SYM = 648,
     POLYGON = 649,
     PORT_SYM = 650,
     POSITION_SYM = 651,
     PRECISION = 652,
     PREPARE_SYM = 653,
     PRESERVE_SYM = 654,
     PREV_SYM = 655,
     PRIMARY_SYM = 656,
     PRIVILEGES = 657,
     PROCEDURE_SYM = 658,
     PROCESS = 659,
     PROCESSLIST_SYM = 660,
     PROFILE_SYM = 661,
     PROFILES_SYM = 662,
     PROXY_SYM = 663,
     PURGE = 664,
     QUARTER_SYM = 665,
     QUERY_SYM = 666,
     QUICK = 667,
     RANGE_SYM = 668,
     READS_SYM = 669,
     READ_ONLY_SYM = 670,
     READ_SYM = 671,
     READ_WRITE_SYM = 672,
     REAL = 673,
     REBUILD_SYM = 674,
     RECOVER_SYM = 675,
     REDOFILE_SYM = 676,
     REDO_BUFFER_SIZE_SYM = 677,
     REDUNDANT_SYM = 678,
     REFERENCES = 679,
     REGEXP = 680,
     RELAY = 681,
     RELAYLOG_SYM = 682,
     RELAY_LOG_FILE_SYM = 683,
     RELAY_LOG_POS_SYM = 684,
     RELAY_THREAD = 685,
     RELEASE_SYM = 686,
     RELOAD = 687,
     REMOVE_SYM = 688,
     RENAME = 689,
     REORGANIZE_SYM = 690,
     REPAIR = 691,
     REPEATABLE_SYM = 692,
     REPEAT_SYM = 693,
     REPLACE = 694,
     REPLICATION = 695,
     REQUIRE_SYM = 696,
     RESET_SYM = 697,
     RESIGNAL_SYM = 698,
     RESOURCES = 699,
     RESTORE_SYM = 700,
     RESTRICT = 701,
     RESUME_SYM = 702,
     RETURNED_SQLSTATE_SYM = 703,
     RETURNS_SYM = 704,
     RETURN_SYM = 705,
     REVERSE_SYM = 706,
     REVOKE = 707,
     RIGHT = 708,
     ROLLBACK_SYM = 709,
     ROLLUP_SYM = 710,
     ROUTINE_SYM = 711,
     ROWS_SYM = 712,
     ROW_FORMAT_SYM = 713,
     ROW_SYM = 714,
     ROW_COUNT_SYM = 715,
     RTREE_SYM = 716,
     SAVEPOINT_SYM = 717,
     SCHEDULE_SYM = 718,
     SCHEMA_NAME_SYM = 719,
     SECOND_MICROSECOND_SYM = 720,
     SECOND_SYM = 721,
     SECURITY_SYM = 722,
     SELECT_SYM = 723,
     SENSITIVE_SYM = 724,
     SEPARATOR_SYM = 725,
     SERIALIZABLE_SYM = 726,
     SERIAL_SYM = 727,
     SESSION_SYM = 728,
     SERVER_SYM = 729,
     SERVER_OPTIONS = 730,
     SET = 731,
     SET_VAR = 732,
     SHARE_SYM = 733,
     SHIFT_LEFT = 734,
     SHIFT_RIGHT = 735,
     SHOW = 736,
     SHUTDOWN = 737,
     SIGNAL_SYM = 738,
     SIGNED_SYM = 739,
     SIMPLE_SYM = 740,
     SLAVE = 741,
     SLOW = 742,
     SMALLINT = 743,
     SNAPSHOT_SYM = 744,
     SOCKET_SYM = 745,
     SONAME_SYM = 746,
     SOUNDS_SYM = 747,
     SOURCE_SYM = 748,
     SPATIAL_SYM = 749,
     SPECIFIC_SYM = 750,
     SQLEXCEPTION_SYM = 751,
     SQLSTATE_SYM = 752,
     SQLWARNING_SYM = 753,
     SQL_AFTER_GTIDS = 754,
     SQL_AFTER_MTS_GAPS = 755,
     SQL_BEFORE_GTIDS = 756,
     SQL_BIG_RESULT = 757,
     SQL_BUFFER_RESULT = 758,
     SQL_CACHE_SYM = 759,
     SQL_CALC_FOUND_ROWS = 760,
     SQL_NO_CACHE_SYM = 761,
     SQL_SMALL_RESULT = 762,
     SQL_SYM = 763,
     SQL_THREAD = 764,
     SSL_SYM = 765,
     STARTING = 766,
     STARTS_SYM = 767,
     START_SYM = 768,
     STATS_AUTO_RECALC_SYM = 769,
     STATS_PERSISTENT_SYM = 770,
     STATS_SAMPLE_PAGES_SYM = 771,
     STATUS_SYM = 772,
     STDDEV_SAMP_SYM = 773,
     STD_SYM = 774,
     STOP_SYM = 775,
     STORAGE_SYM = 776,
     STRAIGHT_JOIN = 777,
     STRING_SYM = 778,
     SUBCLASS_ORIGIN_SYM = 779,
     SUBDATE_SYM = 780,
     SUBJECT_SYM = 781,
     SUBPARTITIONS_SYM = 782,
     SUBPARTITION_SYM = 783,
     SUBSTRING = 784,
     SUM_SYM = 785,
     SUPER_SYM = 786,
     SUSPEND_SYM = 787,
     SWAPS_SYM = 788,
     SWITCHES_SYM = 789,
     SYSDATE = 790,
     TABLES = 791,
     TABLESPACE = 792,
     TABLE_REF_PRIORITY = 793,
     TABLE_SYM = 794,
     TABLE_CHECKSUM_SYM = 795,
     TABLE_NAME_SYM = 796,
     TEMPORARY = 797,
     TEMPTABLE_SYM = 798,
     TERMINATED = 799,
     TEXT_STRING = 800,
     TEXT_SYM = 801,
     THAN_SYM = 802,
     THEN_SYM = 803,
     TIMESTAMP = 804,
     TIMESTAMP_ADD = 805,
     TIMESTAMP_DIFF = 806,
     TIME_SYM = 807,
     TINYBLOB = 808,
     TINYINT = 809,
     TINYTEXT = 810,
     TO_SYM = 811,
     TRAILING = 812,
     TRANSACTION_SYM = 813,
     TRIGGERS_SYM = 814,
     TRIGGER_SYM = 815,
     TRIM = 816,
     TRUE_SYM = 817,
     TRUNCATE_SYM = 818,
     TYPES_SYM = 819,
     TYPE_SYM = 820,
     UDF_RETURNS_SYM = 821,
     ULONGLONG_NUM = 822,
     UNCOMMITTED_SYM = 823,
     UNDEFINED_SYM = 824,
     UNDERSCORE_CHARSET = 825,
     UNDOFILE_SYM = 826,
     UNDO_BUFFER_SIZE_SYM = 827,
     UNDO_SYM = 828,
     UNICODE_SYM = 829,
     UNINSTALL_SYM = 830,
     UNION_SYM = 831,
     UNIQUE_SYM = 832,
     UNKNOWN_SYM = 833,
     UNLOCK_SYM = 834,
     UNSIGNED = 835,
     UNTIL_SYM = 836,
     UPDATE_SYM = 837,
     UPGRADE_SYM = 838,
     USAGE = 839,
     USER = 840,
     USE_FRM = 841,
     USE_SYM = 842,
     USING = 843,
     UTC_DATE_SYM = 844,
     UTC_TIMESTAMP_SYM = 845,
     UTC_TIME_SYM = 846,
     VALUES = 847,
     VALUE_SYM = 848,
     VARBINARY = 849,
     VARCHAR = 850,
     VARIABLES = 851,
     VARIANCE_SYM = 852,
     VARYING = 853,
     VAR_SAMP_SYM = 854,
     VIEW_SYM = 855,
     WAIT_SYM = 856,
     WARNINGS = 857,
     WEEK_SYM = 858,
     WEIGHT_STRING_SYM = 859,
     WHEN_SYM = 860,
     WHERE = 861,
     WHILE_SYM = 862,
     WITH = 863,
     WITH_CUBE_SYM = 864,
     WITH_ROLLUP_SYM = 865,
     WORK_SYM = 866,
     WRAPPER_SYM = 867,
     WRITE_SYM = 868,
     X509_SYM = 869,
     XA_SYM = 870,
     XML_SYM = 871,
     XOR = 872,
     YEAR_MONTH_SYM = 873,
     YEAR_SYM = 874,
     ZEROFILL = 875
   };
#endif
/* Tokens.  */
#define ABORT_SYM 258
#define ACCESSIBLE_SYM 259
#define ACTION 260
#define ADD 261
#define ADDDATE_SYM 262
#define AFTER_SYM 263
#define AGAINST 264
#define AGGREGATE_SYM 265
#define ALGORITHM_SYM 266
#define ALL 267
#define ALTER 268
#define ANALYSE_SYM 269
#define ANALYZE_SYM 270
#define AND_AND_SYM 271
#define AND_SYM 272
#define ANY_SYM 273
#define AS 274
#define ASC 275
#define ASCII_SYM 276
#define ASENSITIVE_SYM 277
#define AT_SYM 278
#define AUTOEXTEND_SIZE_SYM 279
#define AUTO_INC 280
#define AVG_ROW_LENGTH 281
#define AVG_SYM 282
#define BACKUP_SYM 283
#define BEFORE_SYM 284
#define BEGIN_SYM 285
#define BETWEEN_SYM 286
#define BIGINT 287
#define BINARY 288
#define BINLOG_SYM 289
#define BIN_NUM 290
#define BIT_AND 291
#define BIT_OR 292
#define BIT_SYM 293
#define BIT_XOR 294
#define BLOB_SYM 295
#define BLOCK_SYM 296
#define BOOLEAN_SYM 297
#define BOOL_SYM 298
#define BOTH 299
#define BTREE_SYM 300
#define BY 301
#define BYTE_SYM 302
#define CACHE_SYM 303
#define CALL_SYM 304
#define CASCADE 305
#define CASCADED 306
#define CASE_SYM 307
#define CAST_SYM 308
#define CATALOG_NAME_SYM 309
#define CHAIN_SYM 310
#define CHANGE 311
#define CHANGED 312
#define CHARSET 313
#define CHAR_SYM 314
#define CHECKSUM_SYM 315
#define CHECK_SYM 316
#define CIPHER_SYM 317
#define CLASS_ORIGIN_SYM 318
#define CLIENT_SYM 319
#define CLOSE_SYM 320
#define COALESCE 321
#define CODE_SYM 322
#define COLLATE_SYM 323
#define COLLATION_SYM 324
#define COLUMNS 325
#define COLUMN_SYM 326
#define COLUMN_FORMAT_SYM 327
#define COLUMN_NAME_SYM 328
#define COMMENT_SYM 329
#define COMMITTED_SYM 330
#define COMMIT_SYM 331
#define COMPACT_SYM 332
#define COMPLETION_SYM 333
#define COMPRESSED_SYM 334
#define CONCURRENT 335
#define CONDITION_SYM 336
#define CONNECTION_SYM 337
#define CONSISTENT_SYM 338
#define CONSTRAINT 339
#define CONSTRAINT_CATALOG_SYM 340
#define CONSTRAINT_NAME_SYM 341
#define CONSTRAINT_SCHEMA_SYM 342
#define CONTAINS_SYM 343
#define CONTEXT_SYM 344
#define CONTINUE_SYM 345
#define CONVERT_SYM 346
#define COUNT_SYM 347
#define CPU_SYM 348
#define CREATE 349
#define CROSS 350
#define CUBE_SYM 351
#define CURDATE 352
#define CURRENT_SYM 353
#define CURRENT_USER 354
#define CURSOR_SYM 355
#define CURSOR_NAME_SYM 356
#define CURTIME 357
#define DATABASE 358
#define DATABASES 359
#define DATAFILE_SYM 360
#define DATA_SYM 361
#define DATETIME 362
#define DATE_ADD_INTERVAL 363
#define DATE_SUB_INTERVAL 364
#define DATE_SYM 365
#define DAY_HOUR_SYM 366
#define DAY_MICROSECOND_SYM 367
#define DAY_MINUTE_SYM 368
#define DAY_SECOND_SYM 369
#define DAY_SYM 370
#define DEALLOCATE_SYM 371
#define DECIMAL_NUM 372
#define DECIMAL_SYM 373
#define DECLARE_SYM 374
#define DEFAULT 375
#define DEFAULT_AUTH_SYM 376
#define DEFINER_SYM 377
#define DELAYED_SYM 378
#define DELAY_KEY_WRITE_SYM 379
#define DELETE_SYM 380
#define DESC 381
#define DESCRIBE 382
#define DES_KEY_FILE 383
#define DETERMINISTIC_SYM 384
#define DIAGNOSTICS_SYM 385
#define DIRECTORY_SYM 386
#define DISABLE_SYM 387
#define DISCARD 388
#define DISK_SYM 389
#define DISTINCT 390
#define DIV_SYM 391
#define DOUBLE_SYM 392
#define DO_SYM 393
#define DROP 394
#define DUAL_SYM 395
#define DUMPFILE 396
#define DUPLICATE_SYM 397
#define DYNAMIC_SYM 398
#define EACH_SYM 399
#define ELSE 400
#define ELSEIF_SYM 401
#define ENABLE_SYM 402
#define ENCLOSED 403
#define END 404
#define ENDS_SYM 405
#define END_OF_INPUT 406
#define ENGINES_SYM 407
#define ENGINE_SYM 408
#define ENUM 409
#define EQ 410
#define EQUAL_SYM 411
#define ERROR_SYM 412
#define ERRORS 413
#define ESCAPED 414
#define ESCAPE_SYM 415
#define EVENTS_SYM 416
#define EVENT_SYM 417
#define EVERY_SYM 418
#define EXCHANGE_SYM 419
#define EXECUTE_SYM 420
#define EXISTS 421
#define EXIT_SYM 422
#define EXPANSION_SYM 423
#define EXPIRE_SYM 424
#define EXPORT_SYM 425
#define EXTENDED_SYM 426
#define EXTENT_SIZE_SYM 427
#define EXTRACT_SYM 428
#define FALSE_SYM 429
#define FAST_SYM 430
#define FAULTS_SYM 431
#define FETCH_SYM 432
#define FILE_SYM 433
#define FIRST_SYM 434
#define FIXED_SYM 435
#define FLOAT_NUM 436
#define FLOAT_SYM 437
#define FLUSH_SYM 438
#define FORCE_SYM 439
#define FOREIGN 440
#define FOR_SYM 441
#define FORMAT_SYM 442
#define FOUND_SYM 443
#define FROM 444
#define FULL 445
#define FULLTEXT_SYM 446
#define FUNCTION_SYM 447
#define GE 448
#define GENERAL 449
#define GEOMETRYCOLLECTION 450
#define GEOMETRY_SYM 451
#define GET_FORMAT 452
#define GET_SYM 453
#define GLOBAL_SYM 454
#define GRANT 455
#define GRANTS 456
#define GROUP_SYM 457
#define GROUP_CONCAT_SYM 458
#define GT_SYM 459
#define HANDLER_SYM 460
#define HASH_SYM 461
#define HAVING 462
#define HELP_SYM 463
#define HEX_NUM 464
#define HIGH_PRIORITY 465
#define HOST_SYM 466
#define HOSTS_SYM 467
#define HOUR_MICROSECOND_SYM 468
#define HOUR_MINUTE_SYM 469
#define HOUR_SECOND_SYM 470
#define HOUR_SYM 471
#define IDENT 472
#define IDENTIFIED_SYM 473
#define IDENT_QUOTED 474
#define IF 475
#define IGNORE_SYM 476
#define IGNORE_SERVER_IDS_SYM 477
#define IMPORT 478
#define INDEXES 479
#define INDEX_SYM 480
#define INFILE 481
#define INITIAL_SIZE_SYM 482
#define INNER_SYM 483
#define INOUT_SYM 484
#define INSENSITIVE_SYM 485
#define INSERT 486
#define INSERT_METHOD 487
#define INSTALL_SYM 488
#define INTERVAL_SYM 489
#define INTO 490
#define INT_SYM 491
#define INVOKER_SYM 492
#define IN_SYM 493
#define IO_AFTER_GTIDS 494
#define IO_BEFORE_GTIDS 495
#define IO_SYM 496
#define IPC_SYM 497
#define IS 498
#define ISOLATION 499
#define ISSUER_SYM 500
#define ITERATE_SYM 501
#define JOIN_SYM 502
#define KEYS 503
#define KEY_BLOCK_SIZE 504
#define KEY_SYM 505
#define KILL_SYM 506
#define LANGUAGE_SYM 507
#define LAST_SYM 508
#define LE 509
#define LEADING 510
#define LEAVES 511
#define LEAVE_SYM 512
#define LEFT 513
#define LESS_SYM 514
#define LEVEL_SYM 515
#define LEX_HOSTNAME 516
#define LIKE 517
#define LIMIT 518
#define LINEAR_SYM 519
#define LINES 520
#define LINESTRING 521
#define LIST_SYM 522
#define LOAD 523
#define LOCAL_SYM 524
#define LOCATOR_SYM 525
#define LOCKS_SYM 526
#define LOCK_SYM 527
#define LOGFILE_SYM 528
#define LOGS_SYM 529
#define LONGBLOB 530
#define LONGTEXT 531
#define LONG_NUM 532
#define LONG_SYM 533
#define LOOP_SYM 534
#define LOW_PRIORITY 535
#define LT 536
#define MASTER_AUTO_POSITION_SYM 537
#define MASTER_BIND_SYM 538
#define MASTER_CONNECT_RETRY_SYM 539
#define MASTER_DELAY_SYM 540
#define MASTER_HOST_SYM 541
#define MASTER_LOG_FILE_SYM 542
#define MASTER_LOG_POS_SYM 543
#define MASTER_PASSWORD_SYM 544
#define MASTER_PORT_SYM 545
#define MASTER_RETRY_COUNT_SYM 546
#define MASTER_SERVER_ID_SYM 547
#define MASTER_SSL_CAPATH_SYM 548
#define MASTER_SSL_CA_SYM 549
#define MASTER_SSL_CERT_SYM 550
#define MASTER_SSL_CIPHER_SYM 551
#define MASTER_SSL_CRL_SYM 552
#define MASTER_SSL_CRLPATH_SYM 553
#define MASTER_SSL_KEY_SYM 554
#define MASTER_SSL_SYM 555
#define MASTER_SSL_VERIFY_SERVER_CERT_SYM 556
#define MASTER_SYM 557
#define MASTER_USER_SYM 558
#define MASTER_HEARTBEAT_PERIOD_SYM 559
#define MATCH 560
#define MAX_CONNECTIONS_PER_HOUR 561
#define MAX_QUERIES_PER_HOUR 562
#define MAX_ROWS 563
#define MAX_SIZE_SYM 564
#define MAX_SYM 565
#define MAX_UPDATES_PER_HOUR 566
#define MAX_USER_CONNECTIONS_SYM 567
#define MAX_VALUE_SYM 568
#define MEDIUMBLOB 569
#define MEDIUMINT 570
#define MEDIUMTEXT 571
#define MEDIUM_SYM 572
#define MEMORY_SYM 573
#define MERGE_SYM 574
#define MESSAGE_TEXT_SYM 575
#define MICROSECOND_SYM 576
#define MIGRATE_SYM 577
#define MINUTE_MICROSECOND_SYM 578
#define MINUTE_SECOND_SYM 579
#define MINUTE_SYM 580
#define MIN_ROWS 581
#define MIN_SYM 582
#define MODE_SYM 583
#define MODIFIES_SYM 584
#define MODIFY_SYM 585
#define MOD_SYM 586
#define MONTH_SYM 587
#define MULTILINESTRING 588
#define MULTIPOINT 589
#define MULTIPOLYGON 590
#define MUTEX_SYM 591
#define MYSQL_ERRNO_SYM 592
#define NAMES_SYM 593
#define NAME_SYM 594
#define NATIONAL_SYM 595
#define NATURAL 596
#define NCHAR_STRING 597
#define NCHAR_SYM 598
#define NDBCLUSTER_SYM 599
#define NE 600
#define NEG 601
#define NEW_SYM 602
#define NEXT_SYM 603
#define NODEGROUP_SYM 604
#define NONE_SYM 605
#define NOT2_SYM 606
#define NOT_SYM 607
#define NOW_SYM 608
#define NO_SYM 609
#define NO_WAIT_SYM 610
#define NO_WRITE_TO_BINLOG 611
#define NULL_SYM 612
#define NUM 613
#define NUMBER_SYM 614
#define NUMERIC_SYM 615
#define NVARCHAR_SYM 616
#define OFFSET_SYM 617
#define OLD_PASSWORD 618
#define ON 619
#define ONE_SYM 620
#define ONLY_SYM 621
#define OPEN_SYM 622
#define OPTIMIZE 623
#define OPTIONS_SYM 624
#define OPTION 625
#define OPTIONALLY 626
#define OR2_SYM 627
#define ORDER_SYM 628
#define OR_OR_SYM 629
#define OR_SYM 630
#define OUTER 631
#define OUTFILE 632
#define OUT_SYM 633
#define OWNER_SYM 634
#define PACK_KEYS_SYM 635
#define PAGE_SYM 636
#define PARAM_MARKER 637
#define PARSER_SYM 638
#define PARTIAL 639
#define PARTITION_SYM 640
#define PARTITIONS_SYM 641
#define PARTITIONING_SYM 642
#define PASSWORD 643
#define PHASE_SYM 644
#define PLUGIN_DIR_SYM 645
#define PLUGIN_SYM 646
#define PLUGINS_SYM 647
#define POINT_SYM 648
#define POLYGON 649
#define PORT_SYM 650
#define POSITION_SYM 651
#define PRECISION 652
#define PREPARE_SYM 653
#define PRESERVE_SYM 654
#define PREV_SYM 655
#define PRIMARY_SYM 656
#define PRIVILEGES 657
#define PROCEDURE_SYM 658
#define PROCESS 659
#define PROCESSLIST_SYM 660
#define PROFILE_SYM 661
#define PROFILES_SYM 662
#define PROXY_SYM 663
#define PURGE 664
#define QUARTER_SYM 665
#define QUERY_SYM 666
#define QUICK 667
#define RANGE_SYM 668
#define READS_SYM 669
#define READ_ONLY_SYM 670
#define READ_SYM 671
#define READ_WRITE_SYM 672
#define REAL 673
#define REBUILD_SYM 674
#define RECOVER_SYM 675
#define REDOFILE_SYM 676
#define REDO_BUFFER_SIZE_SYM 677
#define REDUNDANT_SYM 678
#define REFERENCES 679
#define REGEXP 680
#define RELAY 681
#define RELAYLOG_SYM 682
#define RELAY_LOG_FILE_SYM 683
#define RELAY_LOG_POS_SYM 684
#define RELAY_THREAD 685
#define RELEASE_SYM 686
#define RELOAD 687
#define REMOVE_SYM 688
#define RENAME 689
#define REORGANIZE_SYM 690
#define REPAIR 691
#define REPEATABLE_SYM 692
#define REPEAT_SYM 693
#define REPLACE 694
#define REPLICATION 695
#define REQUIRE_SYM 696
#define RESET_SYM 697
#define RESIGNAL_SYM 698
#define RESOURCES 699
#define RESTORE_SYM 700
#define RESTRICT 701
#define RESUME_SYM 702
#define RETURNED_SQLSTATE_SYM 703
#define RETURNS_SYM 704
#define RETURN_SYM 705
#define REVERSE_SYM 706
#define REVOKE 707
#define RIGHT 708
#define ROLLBACK_SYM 709
#define ROLLUP_SYM 710
#define ROUTINE_SYM 711
#define ROWS_SYM 712
#define ROW_FORMAT_SYM 713
#define ROW_SYM 714
#define ROW_COUNT_SYM 715
#define RTREE_SYM 716
#define SAVEPOINT_SYM 717
#define SCHEDULE_SYM 718
#define SCHEMA_NAME_SYM 719
#define SECOND_MICROSECOND_SYM 720
#define SECOND_SYM 721
#define SECURITY_SYM 722
#define SELECT_SYM 723
#define SENSITIVE_SYM 724
#define SEPARATOR_SYM 725
#define SERIALIZABLE_SYM 726
#define SERIAL_SYM 727
#define SESSION_SYM 728
#define SERVER_SYM 729
#define SERVER_OPTIONS 730
#define SET 731
#define SET_VAR 732
#define SHARE_SYM 733
#define SHIFT_LEFT 734
#define SHIFT_RIGHT 735
#define SHOW 736
#define SHUTDOWN 737
#define SIGNAL_SYM 738
#define SIGNED_SYM 739
#define SIMPLE_SYM 740
#define SLAVE 741
#define SLOW 742
#define SMALLINT 743
#define SNAPSHOT_SYM 744
#define SOCKET_SYM 745
#define SONAME_SYM 746
#define SOUNDS_SYM 747
#define SOURCE_SYM 748
#define SPATIAL_SYM 749
#define SPECIFIC_SYM 750
#define SQLEXCEPTION_SYM 751
#define SQLSTATE_SYM 752
#define SQLWARNING_SYM 753
#define SQL_AFTER_GTIDS 754
#define SQL_AFTER_MTS_GAPS 755
#define SQL_BEFORE_GTIDS 756
#define SQL_BIG_RESULT 757
#define SQL_BUFFER_RESULT 758
#define SQL_CACHE_SYM 759
#define SQL_CALC_FOUND_ROWS 760
#define SQL_NO_CACHE_SYM 761
#define SQL_SMALL_RESULT 762
#define SQL_SYM 763
#define SQL_THREAD 764
#define SSL_SYM 765
#define STARTING 766
#define STARTS_SYM 767
#define START_SYM 768
#define STATS_AUTO_RECALC_SYM 769
#define STATS_PERSISTENT_SYM 770
#define STATS_SAMPLE_PAGES_SYM 771
#define STATUS_SYM 772
#define STDDEV_SAMP_SYM 773
#define STD_SYM 774
#define STOP_SYM 775
#define STORAGE_SYM 776
#define STRAIGHT_JOIN 777
#define STRING_SYM 778
#define SUBCLASS_ORIGIN_SYM 779
#define SUBDATE_SYM 780
#define SUBJECT_SYM 781
#define SUBPARTITIONS_SYM 782
#define SUBPARTITION_SYM 783
#define SUBSTRING 784
#define SUM_SYM 785
#define SUPER_SYM 786
#define SUSPEND_SYM 787
#define SWAPS_SYM 788
#define SWITCHES_SYM 789
#define SYSDATE 790
#define TABLES 791
#define TABLESPACE 792
#define TABLE_REF_PRIORITY 793
#define TABLE_SYM 794
#define TABLE_CHECKSUM_SYM 795
#define TABLE_NAME_SYM 796
#define TEMPORARY 797
#define TEMPTABLE_SYM 798
#define TERMINATED 799
#define TEXT_STRING 800
#define TEXT_SYM 801
#define THAN_SYM 802
#define THEN_SYM 803
#define TIMESTAMP 804
#define TIMESTAMP_ADD 805
#define TIMESTAMP_DIFF 806
#define TIME_SYM 807
#define TINYBLOB 808
#define TINYINT 809
#define TINYTEXT 810
#define TO_SYM 811
#define TRAILING 812
#define TRANSACTION_SYM 813
#define TRIGGERS_SYM 814
#define TRIGGER_SYM 815
#define TRIM 816
#define TRUE_SYM 817
#define TRUNCATE_SYM 818
#define TYPES_SYM 819
#define TYPE_SYM 820
#define UDF_RETURNS_SYM 821
#define ULONGLONG_NUM 822
#define UNCOMMITTED_SYM 823
#define UNDEFINED_SYM 824
#define UNDERSCORE_CHARSET 825
#define UNDOFILE_SYM 826
#define UNDO_BUFFER_SIZE_SYM 827
#define UNDO_SYM 828
#define UNICODE_SYM 829
#define UNINSTALL_SYM 830
#define UNION_SYM 831
#define UNIQUE_SYM 832
#define UNKNOWN_SYM 833
#define UNLOCK_SYM 834
#define UNSIGNED 835
#define UNTIL_SYM 836
#define UPDATE_SYM 837
#define UPGRADE_SYM 838
#define USAGE 839
#define USER 840
#define USE_FRM 841
#define USE_SYM 842
#define USING 843
#define UTC_DATE_SYM 844
#define UTC_TIMESTAMP_SYM 845
#define UTC_TIME_SYM 846
#define VALUES 847
#define VALUE_SYM 848
#define VARBINARY 849
#define VARCHAR 850
#define VARIABLES 851
#define VARIANCE_SYM 852
#define VARYING 853
#define VAR_SAMP_SYM 854
#define VIEW_SYM 855
#define WAIT_SYM 856
#define WARNINGS 857
#define WEEK_SYM 858
#define WEIGHT_STRING_SYM 859
#define WHEN_SYM 860
#define WHERE 861
#define WHILE_SYM 862
#define WITH 863
#define WITH_CUBE_SYM 864
#define WITH_ROLLUP_SYM 865
#define WORK_SYM 866
#define WRAPPER_SYM 867
#define WRITE_SYM 868
#define X509_SYM 869
#define XA_SYM 870
#define XML_SYM 871
#define XOR 872
#define YEAR_MONTH_SYM 873
#define YEAR_SYM 874
#define ZEROFILL 875




#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE
{

/* Line 214 of yacc.c  */
#line 965 "/export/home/pb2/build/sb_0-8905559-1365164376.65/mysql-5.6.11-release-export-5034961_gpl/sql/sql_yacc.yy"

  int  num;
  ulong ulong_num;
  ulonglong ulonglong_number;
  longlong longlong_number;
  LEX_STRING lex_str;
  LEX_STRING *lex_str_ptr;
  LEX_SYMBOL symbol;
  Table_ident *table;
  char *simple_string;
  Item *item;
  Item_num *item_num;
  List<Item> *item_list;
  List<String> *string_list;
  String *string;
  Key_part_spec *key_part;
  TABLE_LIST *table_list;
  udf_func *udf;
  LEX_USER *lex_user;
  struct sys_var_with_base variable;
  enum enum_var_type var_type;
  Key::Keytype key_type;
  enum ha_key_alg key_alg;
  handlerton *db_type;
  enum row_type row_type;
  enum ha_rkey_function ha_rkey_mode;
  enum enum_ha_read_modes ha_read_mode;
  enum enum_tx_isolation tx_isolation;
  enum Cast_target cast_type;
  enum Item_udftype udf_type;
  const CHARSET_INFO *charset;
  thr_lock_type lock_type;
  interval_type interval, interval_time_st;
  timestamp_type date_time_type;
  st_select_lex *select_lex;
  chooser_compare_func_creator boolfunc2creator;
  class sp_condition_value *spcondvalue;
  struct { int vars, conds, hndlrs, curs; } spblock;
  sp_name *spname;
  LEX *lex;
  sp_head *sphead;
  struct p_elem_val *p_elem_value;
  enum index_hint_type index_hint;
  enum enum_filetype filetype;
  enum Foreign_key::fk_option m_fk_option;
  enum enum_yes_no_unknown m_yes_no_unk;
  Diag_condition_item_name diag_condition_item_name;
  Diagnostics_information::Which_area diag_area;
  Diagnostics_information *diag_info;
  Statement_information_item *stmt_info_item;
  Statement_information_item::Name stmt_info_item_name;
  List<Statement_information_item> *stmt_info_list;
  Condition_information_item *cond_info_item;
  Condition_information_item::Name cond_info_item_name;
  List<Condition_information_item> *cond_info_list;
  bool is_not_empty;



/* Line 214 of yacc.c  */
#line 2360 "/export/home/pb2/build/sb_0-8905559-1365164376.65/dist_GPL/sql/sql_yacc.cc"
} YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
#endif


/* Copy the second part of user declarations.  */

/* Line 264 of yacc.c  */
#line 1023 "/export/home/pb2/build/sb_0-8905559-1365164376.65/mysql-5.6.11-release-export-5034961_gpl/sql/sql_yacc.yy"

bool my_yyoverflow(short **a, YYSTYPE **b, ulong *yystacksize);


/* Line 264 of yacc.c  */
#line 2377 "/export/home/pb2/build/sb_0-8905559-1365164376.65/dist_GPL/sql/sql_yacc.cc"

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#elif (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
typedef signed char yytype_int8;
#else
typedef short int yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(e) ((void) (e))
#else
# define YYUSE(e) /* empty */
#endif

/* Identity function, used to suppress warnings about constant conditions.  */
#ifndef lint
# define YYID(n) (n)
#else
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static int
YYID (int yyi)
#else
static int
YYID (yyi)
    int yyi;
#endif
{
  return yyi;
}
#endif

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#     ifndef _STDLIB_H
#      define _STDLIB_H 1
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (YYID (0))
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined _STDLIB_H \
       && ! ((defined YYMALLOC || defined malloc) \
	     && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef _STDLIB_H
#    define _STDLIB_H 1
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
	 || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (YYID (0))
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)				\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack_alloc, Stack, yysize);			\
	Stack = &yyptr->Stack_alloc;					\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (YYID (0))

#endif

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  597
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   55604

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  640
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  948
/* YYNRULES -- Number of rules.  */
#define YYNRULES  2665
/* YYNRULES -- Number of states.  */
#define YYNSTATES  4520

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   875

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const yytype_uint16 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   633,     2,     2,     2,   627,   622,     2,
     630,   631,   625,   624,   632,   623,   638,   626,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   639,   636,
       2,     2,     2,     2,   637,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,   628,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   634,   621,   635,   629,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const yytype_uint16 yyprhs[] =
{
       0,     0,     3,     5,     6,    11,    14,    15,    17,    19,
      21,    23,    25,    27,    29,    31,    33,    35,    37,    39,
      41,    43,    45,    47,    49,    51,    53,    55,    57,    59,
      61,    63,    65,    67,    69,    71,    73,    75,    77,    79,
      81,    83,    85,    87,    89,    91,    93,    95,    97,    99,
     101,   103,   105,   107,   109,   111,   113,   115,   117,   119,
     121,   123,   125,   129,   131,   133,   138,   140,   143,   144,
     149,   150,   153,   157,   159,   162,   163,   167,   168,   174,
     176,   180,   184,   188,   192,   196,   200,   204,   208,   212,
     216,   220,   224,   228,   232,   236,   240,   244,   248,   252,
     258,   262,   264,   265,   267,   271,   273,   277,   281,   285,
     289,   290,   298,   299,   300,   315,   316,   317,   332,   333,
     334,   349,   350,   357,   358,   362,   367,   372,   376,   379,
     390,   392,   396,   399,   402,   405,   408,   411,   414,   417,
     418,   432,   433,   440,   443,   444,   446,   450,   452,   453,
     456,   457,   460,   461,   463,   467,   472,   473,   476,   477,
     480,   482,   484,   486,   488,   490,   492,   494,   496,   498,
     500,   502,   504,   506,   507,   511,   513,   514,   517,   518,
     521,   524,   527,   530,   533,   537,   541,   543,   545,   547,
     550,   554,   558,   559,   564,   565,   569,   570,   572,   576,
     578,   579,   581,   585,   587,   588,   592,   593,   595,   599,
     601,   606,   607,   609,   611,   613,   614,   618,   621,   625,
     626,   630,   631,   637,   643,   644,   652,   653,   660,   662,
     664,   666,   670,   672,   674,   676,   680,   681,   683,   685,
     687,   689,   692,   694,   698,   700,   702,   703,   705,   706,
     709,   713,   719,   721,   723,   725,   727,   729,   731,   733,
     735,   737,   739,   741,   743,   745,   747,   749,   753,   758,
     759,   761,   763,   767,   769,   773,   777,   779,   782,   784,
     786,   788,   790,   794,   798,   800,   802,   804,   806,   808,
     810,   812,   814,   816,   818,   820,   822,   824,   826,   830,
     831,   832,   836,   838,   840,   842,   844,   846,   848,   850,
     852,   854,   856,   858,   860,   862,   863,   869,   870,   873,
     874,   878,   879,   882,   885,   888,   891,   892,   899,   902,
     903,   906,   908,   910,   914,   915,   916,   917,   925,   926,
     929,   932,   934,   936,   937,   938,   947,   948,   955,   957,
     960,   962,   965,   966,   967,   974,   975,   976,   983,   984,
     987,   988,   994,   995,   997,   998,  1004,  1005,  1008,  1009,
    1015,  1020,  1021,  1022,  1031,  1032,  1033,  1042,  1044,  1046,
    1048,  1050,  1052,  1055,  1060,  1066,  1067,  1072,  1077,  1082,
    1086,  1090,  1093,  1096,  1097,  1100,  1102,  1105,  1109,  1111,
    1113,  1115,  1116,  1118,  1120,  1123,  1127,  1129,  1131,  1133,
    1135,  1137,  1139,  1141,  1143,  1144,  1146,  1148,  1151,  1155,
    1157,  1159,  1161,  1163,  1165,  1166,  1168,  1170,  1173,  1177,
    1179,  1181,  1183,  1185,  1187,  1189,  1191,  1192,  1194,  1196,
    1199,  1203,  1205,  1207,  1209,  1212,  1215,  1218,  1220,  1222,
    1224,  1226,  1229,  1233,  1237,  1241,  1245,  1249,  1253,  1257,
    1261,  1266,  1268,  1270,  1272,  1274,  1277,  1281,  1284,  1289,
    1295,  1296,  1302,  1303,  1304,  1310,  1311,  1319,  1321,  1322,
    1324,  1325,  1330,  1331,  1332,  1336,  1342,  1349,  1350,  1355,
    1358,  1361,  1364,  1367,  1368,  1370,  1371,  1375,  1376,  1378,
    1380,  1384,  1386,  1391,  1397,  1403,  1404,  1407,  1408,  1409,
    1417,  1418,  1429,  1431,  1435,  1437,  1439,  1440,  1443,  1444,
    1448,  1450,  1454,  1455,  1462,  1464,  1465,  1466,  1472,  1473,
    1478,  1480,  1482,  1484,  1488,  1490,  1494,  1495,  1496,  1502,
    1504,  1508,  1510,  1512,  1513,  1517,  1519,  1523,  1524,  1529,
    1531,  1532,  1534,  1537,  1539,  1543,  1548,  1552,  1556,  1560,
    1565,  1570,  1574,  1575,  1576,  1583,  1584,  1586,  1587,  1589,
    1591,  1594,  1596,  1598,  1599,  1601,  1603,  1606,  1608,  1609,
    1613,  1614,  1616,  1618,  1621,  1623,  1626,  1630,  1634,  1638,
    1642,  1646,  1650,  1654,  1658,  1662,  1666,  1670,  1674,  1678,
    1682,  1686,  1690,  1694,  1698,  1702,  1706,  1707,  1714,  1716,
    1718,  1722,  1727,  1732,  1735,  1738,  1741,  1745,  1749,  1754,
    1759,  1761,  1763,  1765,  1767,  1769,  1771,  1773,  1775,  1777,
    1779,  1781,  1783,  1786,  1788,  1790,  1792,  1794,  1796,  1798,
    1802,  1804,  1806,  1809,  1812,  1820,  1829,  1838,  1847,  1856,
    1859,  1860,  1862,  1867,  1868,  1870,  1873,  1874,  1879,  1883,
    1887,  1891,  1893,  1896,  1898,  1900,  1904,  1907,  1911,  1914,
    1917,  1919,  1923,  1927,  1930,  1934,  1936,  1939,  1942,  1945,
    1947,  1950,  1952,  1954,  1956,  1959,  1963,  1966,  1970,  1973,
    1976,  1980,  1984,  1988,  1989,  1996,  1997,  2004,  2007,  2009,
    2011,  2013,  2015,  2017,  2019,  2021,  2023,  2025,  2027,  2029,
    2032,  2035,  2037,  2040,  2042,  2045,  2049,  2052,  2054,  2056,
    2058,  2060,  2062,  2064,  2066,  2069,  2070,  2072,  2074,  2080,
    2081,  2085,  2086,  2089,  2093,  2094,  2096,  2099,  2101,  2103,
    2105,  2107,  2111,  2115,  2119,  2123,  2124,  2126,  2127,  2129,
    2130,  2132,  2135,  2137,  2139,  2142,  2145,  2149,  2151,  2155,
    2158,  2160,  2163,  2166,  2169,  2172,  2175,  2178,  2181,  2184,
    2187,  2190,  2193,  2195,  2197,  2200,  2202,  2204,  2206,  2208,
    2210,  2211,  2214,  2216,  2218,  2220,  2222,  2224,  2225,  2228,
    2230,  2232,  2233,  2235,  2237,  2240,  2243,  2245,  2248,  2251,
    2252,  2254,  2256,  2258,  2262,  2264,  2268,  2269,  2271,  2272,
    2277,  2279,  2281,  2283,  2284,  2286,  2289,  2291,  2293,  2296,
    2298,  2302,  2306,  2308,  2310,  2311,  2314,  2315,  2317,  2323,
    2324,  2328,  2332,  2334,  2335,  2338,  2341,  2344,  2345,  2349,
    2353,  2360,  2367,  2369,  2371,  2374,  2377,  2380,  2382,  2385,
    2388,  2390,  2392,  2393,  2395,  2397,  2399,  2401,  2402,  2404,
    2406,  2408,  2409,  2411,  2414,  2415,  2417,  2418,  2420,  2421,
    2423,  2425,  2428,  2430,  2433,  2435,  2438,  2441,  2444,  2448,
    2451,  2453,  2455,  2457,  2459,  2463,  2465,  2467,  2469,  2474,
    2477,  2479,  2484,  2485,  2487,  2488,  2491,  2493,  2497,  2498,
    2505,  2506,  2512,  2520,  2521,  2527,  2528,  2534,  2535,  2541,
    2542,  2547,  2548,  2559,  2563,  2568,  2572,  2576,  2584,  2589,
    2593,  2599,  2600,  2604,  2606,  2611,  2612,  2616,  2617,  2620,
    2621,  2623,  2624,  2627,  2630,  2633,  2636,  2638,  2640,  2642,
    2646,  2651,  2652,  2659,  2664,  2665,  2671,  2672,  2679,  2684,
    2688,  2690,  2698,  2702,  2704,  2706,  2707,  2713,  2714,  2718,
    2721,  2722,  2728,  2729,  2730,  2737,  2739,  2743,  2745,  2747,
    2751,  2754,  2758,  2761,  2766,  2767,  2774,  2775,  2776,  2785,
    2790,  2795,  2799,  2803,  2806,  2809,  2816,  2822,  2826,  2832,
    2834,  2836,  2838,  2840,  2842,  2843,  2845,  2847,  2850,  2853,
    2857,  2861,  2865,  2869,  2870,  2872,  2873,  2875,  2876,  2878,
    2880,  2881,  2884,  2886,  2887,  2889,  2891,  2893,  2894,  2901,
    2905,  2909,  2910,  2912,  2914,  2918,  2922,  2925,  2928,  2933,
    2934,  2938,  2939,  2943,  2944,  2948,  2949,  2953,  2954,  2956,
    2958,  2962,  2964,  2966,  2967,  2970,  2972,  2976,  2980,  2984,
    2986,  2987,  2993,  2994,  2996,  2998,  2999,  3006,  3007,  3009,
    3011,  3014,  3016,  3018,  3020,  3021,  3027,  3030,  3031,  3037,
    3038,  3040,  3042,  3045,  3047,  3049,  3051,  3053,  3055,  3058,
    3059,  3065,  3066,  3068,  3070,  3071,  3076,  3081,  3085,  3091,
    3093,  3097,  3101,  3102,  3109,  3111,  3113,  3115,  3119,  3122,
    3126,  3128,  3130,  3131,  3138,  3140,  3142,  3144,  3148,  3152,
    3157,  3158,  3165,  3166,  3169,  3170,  3175,  3176,  3179,  3181,
    3184,  3189,  3192,  3196,  3199,  3203,  3204,  3208,  3209,  3210,
    3217,  3220,  3222,  3224,  3227,  3230,  3239,  3244,  3245,  3247,
    3250,  3252,  3254,  3256,  3258,  3259,  3262,  3267,  3271,  3273,
    3275,  3279,  3284,  3285,  3286,  3287,  3290,  3293,  3295,  3297,
    3298,  3301,  3305,  3309,  3313,  3316,  3320,  3325,  3329,  3334,
    3338,  3343,  3345,  3349,  3354,  3358,  3362,  3369,  3371,  3377,
    3384,  3390,  3398,  3405,  3414,  3420,  3427,  3432,  3437,  3443,
    3447,  3452,  3454,  3458,  3462,  3466,  3470,  3474,  3478,  3484,
    3490,  3494,  3498,  3502,  3506,  3510,  3514,  3516,  3518,  3520,
    3522,  3524,  3526,  3528,  3530,  3532,  3534,  3536,  3538,  3540,
    3542,  3544,  3546,  3548,  3550,  3552,  3554,  3556,  3558,  3562,
    3564,  3566,  3568,  3570,  3574,  3577,  3580,  3583,  3586,  3590,
    3594,  3600,  3607,  3612,  3617,  3625,  3628,  3635,  3641,  3648,
    3655,  3660,  3665,  3671,  3676,  3683,  3686,  3691,  3696,  3701,
    3712,  3719,  3728,  3735,  3740,  3745,  3752,  3757,  3762,  3767,
    3774,  3779,  3787,  3795,  3803,  3810,  3817,  3824,  3831,  3835,
    3840,  3847,  3856,  3859,  3862,  3871,  3880,  3887,  3894,  3896,
    3903,  3910,  3919,  3928,  3935,  3944,  3951,  3954,  3963,  3972,
    3975,  3978,  3981,  3986,  3991,  3996,  4001,  4005,  4014,  4021,
    4030,  4035,  4042,  4047,  4052,  4057,  4064,  4073,  4078,  4082,
    4089,  4094,  4101,  4107,  4116,  4124,  4135,  4137,  4144,  4149,
    4154,  4159,  4164,  4169,  4176,  4181,  4182,  4188,  4195,  4198,
    4202,  4203,  4208,  4209,  4213,  4214,  4216,  4218,  4222,  4227,
    4232,  4238,  4243,  4248,  4253,  4259,  4264,  4265,  4266,  4274,
    4279,  4285,  4290,  4296,  4301,  4306,  4311,  4316,  4321,  4327,
    4328,  4337,  4338,  4342,  4346,  4348,  4353,  4354,  4356,  4357,
    4360,  4361,  4363,  4364,  4368,  4371,  4375,  4378,  4380,  4383,
    4385,  4388,  4390,  4393,  4396,  4399,  4400,  4402,  4404,  4408,
    4410,  4414,  4416,  4420,  4421,  4423,  4424,  4427,  4432,  4438,
    4440,  4442,  4444,  4446,  4451,  4453,  4457,  4461,  4465,  4466,
    4473,  4474,  4481,  4482,  4491,  4496,  4497,  4506,  4507,  4518,
    4525,  4526,  4535,  4536,  4547,  4554,  4556,  4559,  4562,  4563,
    4565,  4571,  4572,  4578,  4582,  4588,  4591,  4592,  4593,  4601,
    4603,  4604,  4605,  4612,  4613,  4617,  4618,  4619,  4625,  4626,
    4628,  4629,  4631,  4632,  4635,  4639,  4643,  4645,  4647,  4648,
    4656,  4657,  4665,  4667,  4670,  4671,  4672,  4675,  4676,  4679,
    4680,  4682,  4684,  4686,  4688,  4692,  4694,  4698,  4700,  4702,
    4704,  4706,  4708,  4710,  4712,  4714,  4716,  4718,  4720,  4722,
    4724,  4726,  4728,  4730,  4732,  4734,  4736,  4738,  4740,  4742,
    4744,  4746,  4748,  4749,  4751,  4753,  4754,  4757,  4758,  4760,
    4761,  4762,  4766,  4767,  4768,  4772,  4775,  4776,  4777,  4782,
    4787,  4790,  4791,  4793,  4795,  4799,  4803,  4805,  4808,  4809,
    4811,  4812,  4817,  4822,  4825,  4826,  4828,  4830,  4831,  4833,
    4834,  4836,  4839,  4841,  4845,  4849,  4851,  4853,  4855,  4857,
    4859,  4860,  4863,  4865,  4867,  4869,  4871,  4873,  4875,  4877,
    4879,  4881,  4883,  4885,  4887,  4889,  4891,  4893,  4895,  4897,
    4899,  4901,  4903,  4905,  4907,  4909,  4910,  4911,  4918,  4919,
    4921,  4925,  4927,  4928,  4931,  4935,  4937,  4940,  4942,  4943,
    4947,  4948,  4949,  4957,  4960,  4962,  4963,  4967,  4968,  4976,
    4977,  4978,  4987,  4992,  4999,  5004,  5009,  5014,  5015,  5022,
    5027,  5032,  5037,  5043,  5048,  5050,  5054,  5056,  5059,  5061,
    5065,  5067,  5068,  5071,  5072,  5074,  5075,  5077,  5079,  5082,
    5086,  5088,  5090,  5091,  5092,  5101,  5102,  5103,  5110,  5111,
    5113,  5115,  5117,  5119,  5121,  5124,  5126,  5128,  5130,  5134,
    5139,  5140,  5144,  5148,  5150,  5153,  5156,  5157,  5161,  5162,
    5168,  5172,  5174,  5178,  5180,  5184,  5186,  5188,  5189,  5191,
    5192,  5197,  5198,  5200,  5204,  5206,  5208,  5210,  5211,  5212,
    5219,  5220,  5221,  5233,  5237,  5239,  5243,  5247,  5249,  5253,
    5254,  5256,  5257,  5262,  5263,  5271,  5272,  5278,  5279,  5286,
    5288,  5292,  5295,  5300,  5301,  5304,  5305,  5308,  5310,  5312,
    5314,  5315,  5320,  5321,  5323,  5324,  5326,  5328,  5332,  5334,
    5336,  5339,  5342,  5345,  5347,  5349,  5351,  5353,  5354,  5358,
    5359,  5363,  5366,  5371,  5376,  5380,  5385,  5390,  5392,  5396,
    5400,  5407,  5410,  5413,  5414,  5421,  5422,  5429,  5435,  5438,
    5440,  5446,  5452,  5455,  5458,  5460,  5465,  5469,  5472,  5476,
    5479,  5482,  5484,  5488,  5493,  5497,  5501,  5504,  5507,  5511,
    5515,  5519,  5523,  5527,  5531,  5535,  5539,  5541,  5543,  5545,
    5547,  5549,  5550,  5552,  5553,  5556,  5557,  5559,  5561,  5563,
    5564,  5567,  5568,  5571,  5572,  5575,  5578,  5579,  5584,  5585,
    5590,  5592,  5594,  5596,  5598,  5600,  5602,  5604,  5605,  5607,
    5609,  5613,  5614,  5616,  5618,  5619,  5624,  5625,  5626,  5632,
    5634,  5635,  5639,  5640,  5644,  5648,  5650,  5653,  5656,  5659,
    5662,  5665,  5668,  5671,  5673,  5675,  5677,  5679,  5681,  5683,
    5684,  5686,  5687,  5691,  5695,  5697,  5698,  5702,  5704,  5707,
    5708,  5710,  5711,  5715,  5719,  5722,  5725,  5729,  5730,  5732,
    5734,  5737,  5738,  5739,  5740,  5741,  5764,  5766,  5768,  5769,
    5771,  5772,  5774,  5776,  5777,  5779,  5781,  5782,  5785,  5788,
    5790,  5794,  5799,  5803,  5807,  5808,  5811,  5814,  5816,  5820,
    5824,  5825,  5830,  5831,  5835,  5837,  5839,  5840,  5844,  5847,
    5851,  5853,  5855,  5858,  5859,  5862,  5866,  5868,  5874,  5876,
    5878,  5881,  5884,  5886,  5888,  5890,  5892,  5894,  5897,  5900,
    5902,  5904,  5906,  5908,  5910,  5912,  5914,  5916,  5919,  5922,
    5924,  5926,  5928,  5930,  5932,  5935,  5938,  5941,  5943,  5945,
    5949,  5955,  5957,  5959,  5961,  5963,  5965,  5969,  5974,  5980,
    5982,  5988,  5992,  5995,  5997,  6001,  6004,  6007,  6012,  6014,
    6016,  6018,  6020,  6022,  6024,  6026,  6028,  6030,  6032,  6034,
    6036,  6038,  6040,  6042,  6046,  6049,  6051,  6053,  6055,  6057,
    6059,  6061,  6063,  6065,  6067,  6069,  6071,  6073,  6075,  6077,
    6079,  6081,  6083,  6085,  6087,  6089,  6091,  6093,  6095,  6097,
    6099,  6101,  6103,  6105,  6107,  6109,  6111,  6113,  6115,  6117,
    6119,  6121,  6123,  6125,  6127,  6129,  6131,  6133,  6135,  6137,
    6139,  6141,  6143,  6145,  6147,  6149,  6151,  6153,  6155,  6157,
    6159,  6161,  6163,  6165,  6167,  6169,  6171,  6173,  6175,  6177,
    6179,  6181,  6183,  6185,  6187,  6189,  6191,  6193,  6195,  6197,
    6199,  6201,  6203,  6205,  6207,  6209,  6211,  6213,  6215,  6217,
    6219,  6221,  6223,  6225,  6227,  6229,  6231,  6233,  6235,  6237,
    6239,  6241,  6243,  6245,  6247,  6249,  6251,  6253,  6255,  6257,
    6259,  6261,  6263,  6265,  6267,  6269,  6271,  6273,  6275,  6277,
    6279,  6281,  6283,  6285,  6287,  6289,  6291,  6293,  6295,  6297,
    6299,  6301,  6303,  6305,  6307,  6309,  6311,  6313,  6315,  6317,
    6319,  6321,  6323,  6325,  6327,  6329,  6331,  6333,  6335,  6337,
    6339,  6341,  6343,  6345,  6347,  6349,  6351,  6353,  6355,  6357,
    6359,  6361,  6363,  6365,  6367,  6369,  6371,  6373,  6375,  6377,
    6379,  6381,  6383,  6385,  6387,  6389,  6391,  6393,  6395,  6397,
    6399,  6401,  6403,  6405,  6407,  6409,  6411,  6413,  6415,  6417,
    6419,  6421,  6423,  6425,  6427,  6429,  6431,  6433,  6435,  6437,
    6439,  6441,  6443,  6445,  6447,  6449,  6451,  6453,  6455,  6457,
    6459,  6461,  6463,  6465,  6467,  6469,  6471,  6473,  6475,  6477,
    6479,  6481,  6483,  6485,  6487,  6489,  6491,  6493,  6495,  6497,
    6499,  6501,  6503,  6505,  6507,  6509,  6511,  6513,  6515,  6517,
    6519,  6521,  6523,  6525,  6527,  6529,  6531,  6533,  6535,  6537,
    6539,  6541,  6543,  6545,  6547,  6549,  6551,  6553,  6555,  6557,
    6559,  6561,  6563,  6565,  6567,  6569,  6571,  6573,  6575,  6577,
    6579,  6581,  6583,  6585,  6587,  6589,  6591,  6593,  6595,  6597,
    6599,  6601,  6603,  6605,  6607,  6609,  6611,  6613,  6615,  6617,
    6619,  6621,  6623,  6625,  6627,  6629,  6631,  6633,  6635,  6637,
    6639,  6641,  6643,  6645,  6647,  6649,  6651,  6653,  6655,  6657,
    6659,  6661,  6663,  6665,  6667,  6669,  6671,  6673,  6675,  6677,
    6679,  6681,  6683,  6685,  6687,  6689,  6691,  6693,  6695,  6697,
    6699,  6701,  6703,  6705,  6707,  6709,  6711,  6713,  6715,  6717,
    6719,  6721,  6723,  6725,  6727,  6729,  6731,  6733,  6735,  6737,
    6739,  6741,  6743,  6745,  6747,  6749,  6751,  6752,  6756,  6757,
    6761,  6762,  6766,  6767,  6771,  6772,  6776,  6779,  6780,  6783,
    6784,  6787,  6788,  6793,  6794,  6798,  6800,  6802,  6804,  6806,
    6807,  6809,  6811,  6813,  6814,  6817,  6820,  6823,  6827,  6828,
    6833,  6838,  6845,  6848,  6852,  6856,  6860,  6866,  6868,  6872,
    6876,  6878,  6880,  6884,  6888,  6890,  6894,  6897,  6900,  6903,
    6906,  6909,  6911,  6913,  6918,  6923,  6925,  6927,  6929,  6931,
    6933,  6934,  6939,  6941,  6943,  6945,  6949,  6953,  6955,  6957,
    6960,  6963,  6964,  6968,  6973,  6977,  6978,  6986,  6988,  6991,
    6993,  6995,  6997,  6999,  7001,  7003,  7004,  7010,  7012,  7014,
    7016,  7018,  7020,  7024,  7031,  7038,  7045,  7053,  7059,  7063,
    7072,  7081,  7090,  7097,  7098,  7100,  7102,  7105,  7106,  7108,
    7110,  7114,  7115,  7119,  7120,  7124,  7125,  7129,  7130,  7134,
    7136,  7138,  7140,  7142,  7144,  7146,  7148,  7150,  7152,  7154,
    7156,  7159,  7162,  7164,  7168,  7171,  7174,  7177,  7180,  7183,
    7186,  7189,  7192,  7194,  7196,  7199,  7200,  7202,  7206,  7208,
    7211,  7214,  7217,  7219,  7223,  7227,  7229,  7231,  7235,  7237,
    7241,  7246,  7252,  7257,  7264,  7266,  7267,  7271,  7275,  7277,
    7279,  7280,  7283,  7286,  7289,  7292,  7293,  7296,  7297,  7301,
    7304,  7306,  7309,  7312,  7315,  7318,  7321,  7322,  7326,  7327,
    7329,  7330,  7334,  7337,  7338,  7340,  7343,  7344,  7346,  7351,
    7356,  7362,  7365,  7369,  7370,  7372,  7373,  7378,  7379,  7381,
    7383,  7384,  7386,  7387,  7390,  7393,  7395,  7396,  7398,  7400,
    7403,  7407,  7410,  7411,  7418,  7422,  7423,  7424,  7425,  7427,
    7430,  7432,  7434,  7436,  7438,  7440,  7442,  7444,  7446,  7448,
    7451,  7454,  7458,  7460,  7462,  7464,  7466,  7468,  7470,  7472,
    7474,  7476,  7478,  7480,  7482,  7484,  7485,  7489,  7491,  7494,
    7496,  7499,  7503,  7507,  7511,  7512,  7516,  7520,  7521,  7529,
    7530,  7534,  7536,  7540,  7541,  7545,  7546,  7550,  7555,  7557,
    7561,  7562,  7566,  7567,  7571,  7576,  7581,  7582,  7583,  7584,
    7601,  7610,  7618,  7619,  7620,  7621,  7622,  7623,  7639,  7640,
    7641,  7642,  7643,  7656,  7661,  7666,  7670,  7675,  7679,  7682,
    7684,  7688,  7694,  7696,  7698,  7699,  7701,  7703,  7704,  7707,
    7708,  7709,  7713,  7714,  7717,  7723
};

/* YYRHS -- A `-1'-separated list of the rules' RHS.  */
static const yytype_int16 yyrhs[] =
{
     641,     0,    -1,   151,    -1,    -1,   644,   642,   636,   643,
      -1,   644,   151,    -1,    -1,   151,    -1,   645,    -1,  1512,
      -1,  1016,    -1,  1082,    -1,  1084,    -1,   697,    -1,   657,
      -1,  1085,    -1,  1074,    -1,  1518,    -1,   664,    -1,   646,
      -1,  1327,    -1,  1359,    -1,  1274,    -1,  1276,    -1,   650,
      -1,  1366,    -1,   732,    -1,  1486,    -1,  1477,    -1,   655,
      -1,  1291,    -1,  1586,    -1,  1386,    -1,  1389,    -1,  1469,
      -1,  1090,    -1,  1098,    -1,   851,    -1,  1105,    -1,   648,
      -1,  1382,    -1,  1521,    -1,  1093,    -1,  1077,    -1,  1294,
      -1,  1376,    -1,   731,    -1,  1484,    -1,  1519,    -1,  1520,
      -1,  1117,    -1,  1441,    -1,   724,    -1,  1345,    -1,  1058,
      -1,  1060,    -1,  1338,    -1,  1587,    -1,  1475,    -1,  1319,
      -1,  1388,    -1,  1578,    -1,   647,   398,  1435,    -1,   116,
      -1,   139,    -1,   398,  1435,   189,   649,    -1,  1432,    -1,
     637,  1437,    -1,    -1,   165,  1435,   651,   652,    -1,    -1,
     588,   653,    -1,   653,   632,   654,    -1,   654,    -1,   637,
    1437,    -1,    -1,   208,   656,  1437,    -1,    -1,    56,   302,
     556,   658,   659,    -1,   660,    -1,   659,   632,   660,    -1,
     286,   155,  1431,    -1,   283,   155,  1431,    -1,   303,   155,
    1431,    -1,   289,   155,  1431,    -1,   290,   155,  1255,    -1,
     284,   155,  1255,    -1,   291,   155,  1255,    -1,   285,   155,
    1255,    -1,   300,   155,  1255,    -1,   294,   155,  1431,    -1,
     293,   155,  1431,    -1,   295,   155,  1431,    -1,   296,   155,
    1431,    -1,   299,   155,  1431,    -1,   301,   155,  1255,    -1,
     297,   155,  1431,    -1,   298,   155,  1431,    -1,   304,   155,
    1418,    -1,   222,   155,   630,   661,   631,    -1,   282,   155,
    1255,    -1,   663,    -1,    -1,   662,    -1,   661,   632,   662,
      -1,  1255,    -1,   287,   155,  1431,    -1,   288,   155,  1257,
      -1,   428,   155,  1431,    -1,   429,   155,  1255,    -1,    -1,
      94,   903,   539,   906,  1427,   665,   840,    -1,    -1,    -1,
      94,   994,   225,  1435,   998,   364,  1427,   666,   630,  1011,
     631,   999,   667,  1050,    -1,    -1,    -1,    94,   995,   225,
    1435,   997,   364,  1427,   668,   630,  1011,   631,  1000,   669,
    1050,    -1,    -1,    -1,    94,   996,   225,  1435,   997,   364,
    1427,   670,   630,  1011,   631,  1001,   671,  1050,    -1,    -1,
      94,   103,   906,  1435,   672,   900,    -1,    -1,    94,   673,
    1540,    -1,    94,   585,   690,  1502,    -1,    94,   273,   202,
     804,    -1,    94,   537,   801,    -1,    94,   674,    -1,   474,
    1437,   185,   106,   612,  1437,   369,   630,   675,   631,    -1,
     676,    -1,   675,   632,   676,    -1,   585,  1432,    -1,   211,
    1432,    -1,   103,  1432,    -1,   379,  1432,    -1,   388,  1432,
      -1,   490,  1432,    -1,   395,  1255,    -1,    -1,  1134,   162,
     906,   691,   678,   364,   463,   679,   684,   681,   686,   138,
     687,    -1,    -1,   163,  1138,  1227,   680,   682,   683,    -1,
      23,  1138,    -1,    -1,   147,    -1,   132,   364,   486,    -1,
     132,    -1,    -1,   512,  1138,    -1,    -1,   150,  1138,    -1,
      -1,   685,    -1,   364,    78,   399,    -1,   364,    78,   352,
     399,    -1,    -1,    74,  1432,    -1,    -1,   688,   689,    -1,
     749,    -1,   751,    -1,   747,    -1,   768,    -1,   786,    -1,
     788,    -1,   783,    -1,   753,    -1,   755,    -1,   756,    -1,
     757,    -1,   758,    -1,   760,    -1,    -1,  1435,   638,  1435,
      -1,  1435,    -1,    -1,   692,   694,    -1,    -1,   693,   695,
      -1,    74,  1432,    -1,   252,   508,    -1,   354,   508,    -1,
      88,   508,    -1,   414,   508,   106,    -1,   329,   508,   106,
      -1,   696,    -1,   694,    -1,   129,    -1,  1144,   129,    -1,
     508,   467,   122,    -1,   508,   467,   237,    -1,    -1,    49,
     691,   698,   699,    -1,    -1,   630,   700,   631,    -1,    -1,
     701,    -1,   701,   632,  1138,    -1,  1138,    -1,    -1,   703,
      -1,   703,   632,   705,    -1,   705,    -1,    -1,  1435,   704,
     954,    -1,    -1,   707,    -1,   707,   632,   708,    -1,   708,
      -1,   709,   704,  1435,   954,    -1,    -1,   238,    -1,   378,
      -1,   229,    -1,    -1,   710,   746,   636,    -1,   746,   636,
      -1,   711,   746,   636,    -1,    -1,   712,   713,   636,    -1,
      -1,   119,   743,   714,   954,   744,    -1,   119,  1435,    81,
     186,   720,    -1,    -1,   119,   717,   205,   186,   715,   718,
     746,    -1,    -1,   119,  1435,   100,   186,   716,  1117,    -1,
     167,    -1,    90,    -1,   719,    -1,   718,   632,   719,    -1,
     723,    -1,  1255,    -1,   721,    -1,   497,   722,  1433,    -1,
      -1,   593,    -1,   720,    -1,  1435,    -1,   498,    -1,  1144,
     188,    -1,   496,    -1,   483,   725,   727,    -1,  1435,    -1,
     721,    -1,    -1,   725,    -1,    -1,   476,   728,    -1,   730,
     155,   729,    -1,   728,   632,   730,   155,   729,    -1,  1417,
      -1,  1165,    -1,  1423,    -1,    63,    -1,   524,    -1,    85,
      -1,    87,    -1,    86,    -1,    54,    -1,   464,    -1,   541,
      -1,    73,    -1,   101,    -1,   320,    -1,   337,    -1,   443,
     726,   727,    -1,   198,   733,   130,   734,    -1,    -1,    98,
      -1,   735,    -1,    81,   739,   740,    -1,   736,    -1,   735,
     632,   736,    -1,   737,   155,   738,    -1,  1435,    -1,   637,
    1437,    -1,   359,    -1,   460,    -1,   729,    -1,   741,    -1,
     740,   632,   741,    -1,   737,   155,   742,    -1,    63,    -1,
     524,    -1,    85,    -1,    87,    -1,    86,    -1,    54,    -1,
     464,    -1,   541,    -1,    73,    -1,   101,    -1,   320,    -1,
     337,    -1,   448,    -1,  1435,    -1,   743,   632,  1435,    -1,
      -1,    -1,   120,   745,  1138,    -1,   749,    -1,   751,    -1,
     747,    -1,   768,    -1,   786,    -1,   788,    -1,   783,    -1,
     753,    -1,   755,    -1,   756,    -1,   757,    -1,   758,    -1,
     760,    -1,    -1,   220,   748,   763,   149,   220,    -1,    -1,
     750,   645,    -1,    -1,   450,   752,  1138,    -1,    -1,   754,
     792,    -1,   257,  1436,    -1,   246,  1436,    -1,   367,  1435,
      -1,    -1,   177,   761,  1435,   235,   759,   762,    -1,    65,
    1435,    -1,    -1,   348,   189,    -1,   189,    -1,  1435,    -1,
     762,   632,  1435,    -1,    -1,    -1,    -1,   764,  1138,   765,
     548,   711,   766,   767,    -1,    -1,   146,   763,    -1,   145,
     711,    -1,   769,    -1,   772,    -1,    -1,    -1,    52,   770,
    1138,   771,   774,   782,   149,    52,    -1,    -1,    52,   773,
     775,   782,   149,    52,    -1,   776,    -1,   774,   776,    -1,
     779,    -1,   775,   779,    -1,    -1,    -1,   605,   777,  1138,
     778,   548,   711,    -1,    -1,    -1,   605,   780,  1138,   781,
     548,   711,    -1,    -1,   145,   711,    -1,    -1,  1436,   639,
     784,   792,   785,    -1,    -1,  1436,    -1,    -1,  1436,   639,
     787,   790,   785,    -1,    -1,   789,   790,    -1,    -1,    30,
     791,   712,   710,   149,    -1,   279,   711,   149,   279,    -1,
      -1,    -1,   607,   793,  1138,   794,   138,   711,   149,   607,
      -1,    -1,    -1,   438,   711,   581,   795,  1138,   796,   149,
     438,    -1,    29,    -1,     8,    -1,   231,    -1,   582,    -1,
     125,    -1,   826,   828,    -1,   826,    56,   823,   807,    -1,
     826,     6,   823,   802,   811,    -1,    -1,   587,   273,   202,
    1435,    -1,   826,     6,   823,   814,    -1,   826,   139,   823,
     814,    -1,   827,   806,   817,    -1,   827,   806,   820,    -1,
       6,   824,    -1,     6,   825,    -1,    -1,   808,   809,    -1,
     810,    -1,   809,   810,    -1,   809,   632,   810,    -1,   829,
      -1,   830,    -1,   831,    -1,    -1,   812,    -1,   813,    -1,
     812,   813,    -1,   812,   632,   813,    -1,   829,    -1,   830,
      -1,   831,    -1,   832,    -1,   835,    -1,   837,    -1,   838,
      -1,   836,    -1,    -1,   815,    -1,   816,    -1,   815,   816,
      -1,   815,   632,   816,    -1,   829,    -1,   830,    -1,   831,
      -1,   837,    -1,   838,    -1,    -1,   818,    -1,   819,    -1,
     818,   819,    -1,   818,   632,   819,    -1,   829,    -1,   833,
      -1,   834,    -1,   835,    -1,   837,    -1,   838,    -1,   836,
      -1,    -1,   821,    -1,   822,    -1,   821,   822,    -1,   821,
     632,   822,    -1,   829,    -1,   837,    -1,   838,    -1,   105,
    1432,    -1,   571,  1432,    -1,   421,  1432,    -1,  1435,    -1,
    1435,    -1,   415,    -1,   417,    -1,   352,     4,    -1,   227,
    1311,   839,    -1,    24,  1311,   839,    -1,   309,  1311,   839,
      -1,   172,  1311,   839,    -1,   572,  1311,   839,    -1,   422,
    1311,   839,    -1,   349,  1311,  1256,    -1,    74,  1311,  1432,
      -1,  1352,   153,  1311,   914,    -1,   601,    -1,   355,    -1,
    1256,    -1,   217,    -1,   630,   841,    -1,   907,   846,   843,
      -1,   262,  1427,    -1,   630,   262,  1427,   631,    -1,   920,
     631,   907,   846,   843,    -1,    -1,   846,   896,   631,   842,
    1525,    -1,    -1,    -1,  1397,   899,   896,   844,  1522,    -1,
      -1,  1397,   899,   630,   896,   631,   845,  1525,    -1,   847,
      -1,    -1,   848,    -1,    -1,   385,   850,   849,   853,    -1,
      -1,    -1,   385,   852,   853,    -1,    46,   854,   864,   865,
     872,    -1,   856,   250,   857,   630,   858,   631,    -1,    -1,
     856,   206,   855,   862,    -1,   413,   862,    -1,   413,   861,
      -1,   267,   862,    -1,   267,   861,    -1,    -1,   264,    -1,
      -1,    11,   155,  1256,    -1,    -1,   859,    -1,   860,    -1,
     859,   632,   860,    -1,  1435,    -1,    70,   630,   858,   631,
      -1,   630,  1134,   870,  1135,   631,    -1,   630,  1134,   870,
    1135,   631,    -1,    -1,   386,  1256,    -1,    -1,    -1,   528,
      46,   856,   206,   863,   866,   871,    -1,    -1,   528,    46,
     856,   250,   857,   630,   868,   631,   867,   871,    -1,   869,
      -1,   868,   632,   869,    -1,  1435,    -1,  1141,    -1,    -1,
     527,  1256,    -1,    -1,   630,   873,   631,    -1,   874,    -1,
     873,   632,   874,    -1,    -1,   385,   875,   876,   877,   893,
     888,    -1,  1435,    -1,    -1,    -1,   592,   259,   547,   878,
     880,    -1,    -1,   592,   238,   879,   881,    -1,   313,    -1,
     883,    -1,   883,    -1,   630,   882,   631,    -1,   883,    -1,
     882,   632,   883,    -1,    -1,    -1,   630,   884,   886,   885,
     631,    -1,   887,    -1,   886,   632,   887,    -1,   313,    -1,
    1141,    -1,    -1,   630,   889,   631,    -1,   890,    -1,   889,
     632,   890,    -1,    -1,   528,   891,   892,   893,    -1,  1437,
      -1,    -1,   894,    -1,   894,   895,    -1,   895,    -1,   537,
    1311,  1437,    -1,  1352,   153,  1311,   914,    -1,   349,  1311,
    1256,    -1,   308,  1311,  1258,    -1,   326,  1311,  1258,    -1,
     106,   131,  1311,  1432,    -1,   225,   131,  1311,  1432,    -1,
      74,  1311,  1432,    -1,    -1,    -1,   468,   897,  1128,  1132,
     898,   918,    -1,    -1,    19,    -1,    -1,   901,    -1,   902,
      -1,   901,   902,    -1,   913,    -1,   912,    -1,    -1,   904,
      -1,   905,    -1,   905,   904,    -1,   542,    -1,    -1,   220,
    1144,   166,    -1,    -1,   909,    -1,   910,    -1,   910,   908,
      -1,   910,    -1,   910,   909,    -1,   910,   632,   909,    -1,
     153,  1311,   914,    -1,   308,  1311,  1257,    -1,   326,  1311,
    1257,    -1,    26,  1311,  1255,    -1,   388,  1311,  1432,    -1,
      74,  1311,  1432,    -1,    25,  1311,  1257,    -1,   380,  1311,
    1255,    -1,   380,  1311,   120,    -1,   514,  1311,  1255,    -1,
     514,  1311,   120,    -1,   515,  1311,  1255,    -1,   515,  1311,
     120,    -1,   516,  1311,  1255,    -1,   516,  1311,   120,    -1,
      60,  1311,  1255,    -1,   540,  1311,  1255,    -1,   124,  1311,
    1255,    -1,   458,  1311,   916,    -1,    -1,   576,  1311,   911,
     630,  1375,   631,    -1,   912,    -1,   913,    -1,   232,  1311,
     917,    -1,   106,   131,  1311,  1432,    -1,   225,   131,  1311,
    1432,    -1,   537,  1435,    -1,   521,   134,    -1,   521,   318,
      -1,    82,  1311,  1432,    -1,   249,  1311,  1255,    -1,   966,
     957,  1311,   959,    -1,   966,    68,  1311,   965,    -1,  1437,
      -1,  1437,    -1,   120,    -1,   180,    -1,   143,    -1,    79,
      -1,   423,    -1,    77,    -1,   354,    -1,   179,    -1,   253,
      -1,  1250,    -1,  1127,  1131,    -1,   523,    -1,   418,    -1,
     118,    -1,   236,    -1,   921,    -1,   922,    -1,   921,   632,
     922,    -1,   923,    -1,   924,    -1,   929,   925,    -1,   929,
     983,    -1,   989,  1013,   998,   630,  1011,   631,   999,    -1,
     995,   992,  1013,   997,   630,  1011,   631,  1000,    -1,   996,
     992,  1013,   997,   630,  1011,   631,  1001,    -1,   927,   990,
    1013,   998,   630,  1011,   631,   999,    -1,   927,   185,   250,
    1013,   630,  1011,   631,   983,    -1,   927,   926,    -1,    -1,
     926,    -1,    61,   630,  1138,   631,    -1,    -1,   928,    -1,
      84,  1013,    -1,    -1,  1426,   930,   931,   951,    -1,   939,
     949,   945,    -1,   940,   950,   945,    -1,   182,   941,   945,
      -1,    38,    -1,    38,   948,    -1,    43,    -1,    42,    -1,
     935,   948,   969,    -1,   935,   969,    -1,   936,   948,   970,
      -1,   936,   970,    -1,    33,   948,    -1,    33,    -1,   937,
     948,   969,    -1,   938,   948,   970,    -1,   594,   948,    -1,
     619,   949,   945,    -1,   110,    -1,   552,   943,    -1,   549,
     943,    -1,   107,   943,    -1,   553,    -1,    40,   949,    -1,
     934,    -1,   314,    -1,   275,    -1,   278,   594,    -1,   278,
     937,   969,    -1,   555,   969,    -1,   546,   949,   969,    -1,
     316,   969,    -1,   276,   969,    -1,   118,   941,   945,    -1,
     360,   941,   945,    -1,   180,   941,   945,    -1,    -1,   154,
     932,   630,  1015,   631,   969,    -1,    -1,   476,   933,   630,
    1015,   631,   969,    -1,   278,   969,    -1,   472,    -1,   196,
      -1,   195,    -1,   393,    -1,   334,    -1,   266,    -1,   333,
      -1,   394,    -1,   335,    -1,    59,    -1,   343,    -1,   340,
      59,    -1,   935,   598,    -1,   595,    -1,   340,   595,    -1,
     361,    -1,   343,   595,    -1,   340,    59,   598,    -1,   343,
     598,    -1,   236,    -1,   554,    -1,   488,    -1,   315,    -1,
      32,    -1,   418,    -1,   137,    -1,   137,   397,    -1,    -1,
     948,    -1,   942,    -1,   630,   358,   632,   358,   631,    -1,
      -1,   630,   358,   631,    -1,    -1,   630,   631,    -1,   630,
     358,   631,    -1,    -1,   946,    -1,   946,   947,    -1,   947,
      -1,   484,    -1,   580,    -1,   620,    -1,   630,   277,   631,
      -1,   630,   567,   631,    -1,   630,   117,   631,    -1,   630,
     358,   631,    -1,    -1,   948,    -1,    -1,   942,    -1,    -1,
     952,    -1,   952,   953,    -1,   953,    -1,   357,    -1,  1144,
     357,    -1,   120,   956,    -1,   364,   582,   955,    -1,    25,
      -1,   472,   120,   593,    -1,   982,   250,    -1,   577,    -1,
     577,   250,    -1,    74,  1432,    -1,    68,   963,    -1,    72,
     120,    -1,    72,   180,    -1,    72,   143,    -1,   521,   120,
      -1,   521,   134,    -1,   521,   318,    -1,   931,   964,    -1,
     353,   944,    -1,   955,    -1,  1416,    -1,    59,   476,    -1,
      58,    -1,  1437,    -1,    33,    -1,   958,    -1,   120,    -1,
      -1,   957,   959,    -1,  1437,    -1,    33,    -1,   961,    -1,
     120,    -1,  1437,    -1,    -1,    68,   965,    -1,   963,    -1,
     120,    -1,    -1,   120,    -1,    21,    -1,    33,    21,    -1,
      21,    33,    -1,   574,    -1,   574,    33,    -1,    33,   574,
      -1,    -1,   967,    -1,   968,    -1,    47,    -1,   957,   958,
     970,    -1,    33,    -1,    33,   957,   958,    -1,    -1,    33,
      -1,    -1,   630,  1256,   972,   631,    -1,    20,    -1,   126,
      -1,   451,    -1,    -1,   973,    -1,   973,   974,    -1,   974,
      -1,  1256,    -1,   976,   975,    -1,   977,    -1,   978,   632,
     977,    -1,   976,   623,   976,    -1,   978,    -1,   979,    -1,
      -1,   260,   980,    -1,    -1,   401,    -1,   424,  1427,   984,
     986,   987,    -1,    -1,   630,   985,   631,    -1,   985,   632,
    1435,    -1,  1435,    -1,    -1,   305,   190,    -1,   305,   384,
      -1,   305,   485,    -1,    -1,   364,   582,   988,    -1,   364,
     125,   988,    -1,   364,   582,   988,   364,   125,   988,    -1,
     364,   125,   988,   364,   582,   988,    -1,   446,    -1,    50,
      -1,   476,   357,    -1,   354,     5,    -1,   476,   120,    -1,
     991,    -1,   401,   250,    -1,   577,   992,    -1,   250,    -1,
     225,    -1,    -1,   991,    -1,   248,    -1,   225,    -1,   224,
      -1,    -1,   577,    -1,   191,    -1,   494,    -1,    -1,   997,
      -1,   997,  1005,    -1,    -1,  1002,    -1,    -1,  1004,    -1,
      -1,  1003,    -1,  1007,    -1,  1002,  1007,    -1,  1008,    -1,
    1003,  1008,    -1,  1009,    -1,  1004,  1009,    -1,   588,  1010,
      -1,   565,  1010,    -1,   249,  1311,  1255,    -1,    74,  1432,
      -1,  1006,    -1,  1005,    -1,  1006,    -1,  1006,    -1,   608,
     383,  1430,    -1,    45,    -1,   461,    -1,   206,    -1,  1011,
     632,  1012,  1248,    -1,  1012,  1248,    -1,  1435,    -1,  1435,
     630,   358,   631,    -1,    -1,  1426,    -1,    -1,   638,  1435,
      -1,  1414,    -1,  1015,   632,  1414,    -1,    -1,    13,  1054,
     539,  1427,  1017,  1029,    -1,    -1,    13,   103,  1028,  1018,
     901,    -1,    13,   103,  1435,   583,   106,   131,   339,    -1,
      -1,    13,   403,   691,  1019,   692,    -1,    -1,    13,   192,
     691,  1020,   692,    -1,    -1,    13,  1548,  1543,  1021,  1550,
      -1,    -1,    13,  1543,  1022,  1550,    -1,    -1,    13,  1543,
     162,   691,  1023,  1025,  1026,   681,   686,  1027,    -1,    13,
     537,   803,    -1,    13,   273,   202,   805,    -1,    13,   537,
     800,    -1,    13,   537,   799,    -1,    13,   474,  1437,   369,
     630,   675,   631,    -1,    13,   585,   690,  1024,    -1,  1438,
     388,   169,    -1,  1024,   632,  1438,   388,   169,    -1,    -1,
     364,   463,   679,    -1,   685,    -1,   364,   463,   679,   685,
      -1,    -1,   434,   556,   691,    -1,    -1,   138,   687,    -1,
      -1,  1435,    -1,    -1,   133,   537,    -1,   223,   537,    -1,
    1044,   847,    -1,  1044,  1033,    -1,  1033,    -1,   848,    -1,
    1035,    -1,   139,   385,  1042,    -1,   419,   385,  1092,  1034,
      -1,    -1,   368,   385,  1092,  1034,  1030,  1092,    -1,    15,
     385,  1092,  1034,    -1,    -1,    61,   385,  1034,  1031,  1087,
      -1,    -1,   436,   385,  1092,  1034,  1032,  1079,    -1,    66,
     385,  1092,  1256,    -1,   563,   385,  1034,    -1,  1038,    -1,
     164,   385,  1043,   608,   539,  1427,   850,    -1,   433,   387,
     850,    -1,    12,    -1,  1042,    -1,    -1,     6,   385,  1092,
    1036,  1037,    -1,    -1,   630,   873,   631,    -1,   386,  1256,
      -1,    -1,   435,   385,  1092,  1039,  1040,    -1,    -1,    -1,
    1042,  1041,   235,   630,   873,   631,    -1,  1043,    -1,  1042,
     632,  1043,    -1,  1435,    -1,  1046,    -1,  1044,   632,  1046,
      -1,     6,  1053,    -1,  1045,   923,  1056,    -1,     6,   924,
      -1,  1045,   630,   920,   631,    -1,    -1,    56,  1053,  1426,
    1047,   929,  1056,    -1,    -1,    -1,   330,  1053,  1426,  1048,
     931,   951,  1049,  1056,    -1,   139,  1053,  1426,  1055,    -1,
     139,   185,   250,  1426,    -1,   139,   401,   250,    -1,   139,
     991,  1426,    -1,   132,   248,    -1,   147,   248,    -1,    13,
    1053,  1426,   476,   120,  1416,    -1,    13,  1053,  1426,   139,
     120,    -1,   434,  1057,  1427,    -1,    91,   556,   957,   959,
     964,    -1,   908,    -1,   184,    -1,  1241,    -1,  1051,    -1,
    1052,    -1,    -1,  1052,    -1,  1051,    -1,  1052,  1051,    -1,
    1051,  1052,    -1,    11,  1311,   120,    -1,    11,  1311,  1435,
      -1,   272,  1311,   120,    -1,   272,  1311,  1435,    -1,    -1,
      71,    -1,    -1,   221,    -1,    -1,   446,    -1,    50,    -1,
      -1,     8,  1435,    -1,   179,    -1,    -1,   556,    -1,   155,
      -1,    19,    -1,    -1,   513,   486,  1069,  1059,  1072,  1064,
      -1,   520,   486,  1069,    -1,   513,   558,  1061,    -1,    -1,
    1062,    -1,  1063,    -1,  1062,   632,  1063,    -1,   608,    83,
     489,    -1,   416,   366,    -1,   416,   613,    -1,  1065,  1066,
    1067,  1068,    -1,    -1,   585,   155,  1432,    -1,    -1,   388,
     155,  1432,    -1,    -1,   121,   155,  1432,    -1,    -1,   390,
     155,  1432,    -1,    -1,  1070,    -1,  1071,    -1,  1070,   632,
    1071,    -1,   509,    -1,   430,    -1,    -1,   581,  1073,    -1,
     663,    -1,  1073,   632,   663,    -1,   501,   155,  1432,    -1,
     499,   155,  1432,    -1,   500,    -1,    -1,    60,  1471,  1075,
    1281,  1076,    -1,    -1,   412,    -1,   171,    -1,    -1,   436,
    1092,  1471,  1078,  1281,  1079,    -1,    -1,  1080,    -1,  1081,
      -1,  1081,  1080,    -1,   412,    -1,   171,    -1,   586,    -1,
      -1,    15,  1092,  1471,  1083,  1281,    -1,    34,  1432,    -1,
      -1,    61,  1471,  1086,  1281,  1087,    -1,    -1,  1088,    -1,
    1089,    -1,  1089,  1088,    -1,   412,    -1,   175,    -1,   317,
      -1,   171,    -1,    57,    -1,   186,   583,    -1,    -1,   368,
    1092,  1471,  1091,  1281,    -1,    -1,   356,    -1,   269,    -1,
      -1,   434,  1471,  1094,  1096,    -1,   434,   585,   690,  1095,
      -1,  1438,   556,  1438,    -1,  1095,   632,  1438,   556,  1438,
      -1,  1097,    -1,  1096,   632,  1097,    -1,  1427,   556,  1427,
      -1,    -1,    48,   225,  1099,  1100,   238,  1104,    -1,  1101,
      -1,  1103,    -1,  1102,    -1,  1101,   632,  1102,    -1,  1427,
    1113,    -1,  1427,  1111,  1113,    -1,  1435,    -1,   120,    -1,
      -1,   268,   225,   235,    48,  1106,  1107,    -1,  1110,    -1,
    1108,    -1,  1109,    -1,  1108,   632,  1109,    -1,  1427,  1113,
    1116,    -1,  1427,  1111,  1113,  1116,    -1,    -1,   385,   850,
    1112,   630,  1034,   631,    -1,    -1,  1114,  1115,    -1,    -1,
     991,   630,  1223,   631,    -1,    -1,   221,   256,    -1,  1118,
      -1,   468,  1121,    -1,   630,  1119,   631,  1525,    -1,   468,
    1123,    -1,   630,  1119,   631,    -1,   468,  1202,    -1,   630,
    1120,   631,    -1,    -1,  1123,  1122,  1522,    -1,    -1,    -1,
    1124,  1128,  1132,  1125,  1126,  1131,    -1,  1244,  1250,    -1,
    1269,    -1,  1127,    -1,  1269,  1127,    -1,  1127,  1269,    -1,
     189,  1182,  1233,  1238,  1235,  1244,  1250,  1261,    -1,   189,
     140,  1233,  1250,    -1,    -1,  1129,    -1,  1129,  1130,    -1,
    1130,    -1,  1539,    -1,   506,    -1,   504,    -1,    -1,   186,
     582,    -1,   272,   238,   478,   328,    -1,  1132,   632,  1133,
      -1,  1133,    -1,   625,    -1,  1134,  1421,  1135,    -1,  1134,
    1138,  1135,  1136,    -1,    -1,    -1,    -1,    19,  1435,    -1,
      19,  1432,    -1,  1435,    -1,  1432,    -1,    -1,   630,   631,
      -1,  1138,  1142,  1138,    -1,  1138,   617,  1138,    -1,  1138,
    1143,  1138,    -1,   352,  1138,    -1,  1139,   243,   562,    -1,
    1139,   243,  1144,   562,    -1,  1139,   243,   174,    -1,  1139,
     243,  1144,   174,    -1,  1139,   243,   578,    -1,  1139,   243,
    1144,   578,    -1,  1139,    -1,  1139,   243,   357,    -1,  1139,
     243,  1144,   357,    -1,  1139,   156,  1140,    -1,  1139,  1146,
    1140,    -1,  1139,  1146,  1147,   630,  1534,   631,    -1,  1140,
      -1,  1141,   238,   630,  1534,   631,    -1,  1141,  1144,   238,
     630,  1534,   631,    -1,  1141,   238,   630,  1138,   631,    -1,
    1141,   238,   630,  1138,   632,  1175,   631,    -1,  1141,  1144,
     238,   630,  1138,   631,    -1,  1141,  1144,   238,   630,  1138,
     632,  1175,   631,    -1,  1141,    31,  1141,    17,  1140,    -1,
    1141,  1144,    31,  1141,    17,  1140,    -1,  1141,   492,   262,
    1141,    -1,  1141,   262,  1148,  1237,    -1,  1141,  1144,   262,
    1148,  1237,    -1,  1141,   425,  1141,    -1,  1141,  1144,   425,
    1141,    -1,  1141,    -1,  1141,   621,  1141,    -1,  1141,   622,
    1141,    -1,  1141,   479,  1141,    -1,  1141,   480,  1141,    -1,
    1141,   624,  1141,    -1,  1141,   623,  1141,    -1,  1141,   624,
     234,  1138,  1227,    -1,  1141,   623,   234,  1138,  1227,    -1,
    1141,   625,  1141,    -1,  1141,   626,  1141,    -1,  1141,   627,
    1141,    -1,  1141,   136,  1141,    -1,  1141,   331,  1141,    -1,
    1141,   628,  1141,    -1,  1148,    -1,   375,    -1,   372,    -1,
      17,    -1,    16,    -1,   352,    -1,   351,    -1,   633,    -1,
     351,    -1,   155,    -1,   193,    -1,   204,    -1,   254,    -1,
     281,    -1,   345,    -1,    12,    -1,    18,    -1,  1423,    -1,
    1149,    -1,  1150,    -1,  1153,    -1,  1151,    -1,  1148,    68,
    1437,    -1,  1417,    -1,  1415,    -1,  1165,    -1,  1161,    -1,
    1148,   374,  1148,    -1,   624,  1148,    -1,   623,  1148,    -1,
     629,  1148,    -1,  1145,  1148,    -1,   630,  1534,   631,    -1,
     630,  1138,   631,    -1,   630,  1138,   632,  1175,   631,    -1,
     459,   630,  1138,   632,  1175,   631,    -1,   166,   630,  1534,
     631,    -1,   634,  1435,  1138,   635,    -1,   305,  1176,     9,
     630,  1141,  1155,   631,    -1,    33,  1148,    -1,    53,   630,
    1138,    19,  1173,   631,    -1,    52,  1178,  1180,  1179,   149,
      -1,    91,   630,  1138,   632,  1173,   631,    -1,    91,   630,
    1138,   588,   958,   631,    -1,   120,   630,  1423,   631,    -1,
     592,   630,  1424,   631,    -1,   234,  1138,  1227,   624,  1138,
      -1,    59,   630,  1175,   631,    -1,    59,   630,  1175,   588,
     958,   631,    -1,    99,  1137,    -1,   110,   630,  1138,   631,
      -1,   115,   630,  1138,   631,    -1,   216,   630,  1138,   631,
      -1,   231,   630,  1138,   632,  1138,   632,  1138,   632,  1138,
     631,    -1,   234,   630,  1138,   632,  1138,   631,    -1,   234,
     630,  1138,   632,  1138,   632,  1175,   631,    -1,   258,   630,
    1138,   632,  1138,   631,    -1,   325,   630,  1138,   631,    -1,
     332,   630,  1138,   631,    -1,   453,   630,  1138,   632,  1138,
     631,    -1,   466,   630,  1138,   631,    -1,   552,   630,  1138,
     631,    -1,   549,   630,  1138,   631,    -1,   549,   630,  1138,
     632,  1138,   631,    -1,   561,   630,  1138,   631,    -1,   561,
     630,   255,  1138,   189,  1138,   631,    -1,   561,   630,   557,
    1138,   189,  1138,   631,    -1,   561,   630,    44,  1138,   189,
    1138,   631,    -1,   561,   630,   255,   189,  1138,   631,    -1,
     561,   630,   557,   189,  1138,   631,    -1,   561,   630,    44,
     189,  1138,   631,    -1,   561,   630,  1138,   189,  1138,   631,
      -1,   585,   630,   631,    -1,   619,   630,  1138,   631,    -1,
       7,   630,  1138,   632,  1138,   631,    -1,     7,   630,  1138,
     632,   234,  1138,  1227,   631,    -1,    97,  1137,    -1,   102,
     944,    -1,   108,   630,  1138,   632,   234,  1138,  1227,   631,
      -1,   109,   630,  1138,   632,   234,  1138,  1227,   631,    -1,
     173,   630,  1227,   189,  1138,   631,    -1,   197,   630,  1229,
     632,  1138,   631,    -1,   955,    -1,   396,   630,  1141,   238,
    1138,   631,    -1,   525,   630,  1138,   632,  1138,   631,    -1,
     525,   630,  1138,   632,   234,  1138,  1227,   631,    -1,   529,
     630,  1138,   632,  1138,   632,  1138,   631,    -1,   529,   630,
    1138,   632,  1138,   631,    -1,   529,   630,  1138,   189,  1138,
     186,  1138,   631,    -1,   529,   630,  1138,   189,  1138,   631,
      -1,   535,   944,    -1,   550,   630,  1228,   632,  1138,   632,
    1138,   631,    -1,   551,   630,  1228,   632,  1138,   632,  1138,
     631,    -1,   589,  1137,    -1,   591,   944,    -1,   590,   944,
      -1,    21,   630,  1138,   631,    -1,    58,   630,  1138,   631,
      -1,    66,   630,  1175,   631,    -1,    69,   630,  1138,   631,
      -1,   103,   630,   631,    -1,   220,   630,  1138,   632,  1138,
     632,  1138,   631,    -1,   187,   630,  1138,   632,  1138,   631,
      -1,   187,   630,  1138,   632,  1138,   632,  1138,   631,    -1,
     321,   630,  1138,   631,    -1,   331,   630,  1138,   632,  1138,
     631,    -1,   363,   630,  1138,   631,    -1,   388,   630,  1138,
     631,    -1,   410,   630,  1138,   631,    -1,   438,   630,  1138,
     632,  1138,   631,    -1,   439,   630,  1138,   632,  1138,   632,
    1138,   631,    -1,   451,   630,  1138,   631,    -1,   460,   630,
     631,    -1,   563,   630,  1138,   632,  1138,   631,    -1,   603,
     630,  1138,   631,    -1,   603,   630,  1138,   632,  1138,   631,
      -1,   604,   630,  1138,   981,   631,    -1,   604,   630,  1138,
      19,    59,   971,   981,   631,    -1,   604,   630,  1138,    19,
      33,   971,   631,    -1,   604,   630,  1138,   632,  1255,   632,
    1255,   632,  1255,   631,    -1,  1152,    -1,    88,   630,  1138,
     632,  1138,   631,    -1,   195,   630,  1175,   631,    -1,   266,
     630,  1175,   631,    -1,   333,   630,  1175,   631,    -1,   334,
     630,  1175,   631,    -1,   335,   630,  1175,   631,    -1,   393,
     630,  1138,   632,  1138,   631,    -1,   394,   630,  1175,   631,
      -1,    -1,  1430,   630,  1154,  1158,   631,    -1,  1435,   638,
    1435,   630,  1174,   631,    -1,  1156,  1157,    -1,   238,    42,
     328,    -1,    -1,   238,   341,   252,   328,    -1,    -1,   608,
     411,   168,    -1,    -1,  1159,    -1,  1160,    -1,  1159,   632,
    1160,    -1,  1134,  1138,  1135,  1136,    -1,    27,   630,  1171,
     631,    -1,    27,   630,   135,  1171,   631,    -1,    36,   630,
    1171,   631,    -1,    37,   630,  1171,   631,    -1,    39,   630,
    1171,   631,    -1,    92,   630,  1232,   625,   631,    -1,    92,
     630,  1171,   631,    -1,    -1,    -1,    92,   630,   135,  1162,
    1175,  1163,   631,    -1,   327,   630,  1171,   631,    -1,   327,
     630,   135,  1171,   631,    -1,   310,   630,  1171,   631,    -1,
     310,   630,   135,  1171,   631,    -1,   519,   630,  1171,   631,
      -1,   597,   630,  1171,   631,    -1,   518,   630,  1171,   631,
      -1,   599,   630,  1171,   631,    -1,   530,   630,  1171,   631,
      -1,   530,   630,   135,  1171,   631,    -1,    -1,   203,   630,
    1168,  1164,  1175,  1170,  1169,   631,    -1,    -1,   637,  1166,
    1167,    -1,  1437,   477,  1138,    -1,  1437,    -1,   637,  1457,
    1437,  1014,    -1,    -1,   135,    -1,    -1,   470,  1414,    -1,
      -1,  1245,    -1,    -1,  1232,  1172,  1138,    -1,    33,   949,
      -1,    59,   949,   969,    -1,   343,   949,    -1,   484,    -1,
     484,   236,    -1,   580,    -1,   580,   236,    -1,   110,    -1,
     552,   943,    -1,   107,   943,    -1,   118,   941,    -1,    -1,
    1175,    -1,  1138,    -1,  1175,   632,  1138,    -1,  1177,    -1,
     630,  1177,   631,    -1,  1423,    -1,  1177,   632,  1423,    -1,
      -1,  1138,    -1,    -1,   145,  1138,    -1,   605,  1138,   548,
    1138,    -1,  1180,   605,  1138,   548,  1138,    -1,  1196,    -1,
    1185,    -1,  1184,    -1,  1181,    -1,   634,  1435,  1181,   635,
      -1,  1183,    -1,  1184,   632,  1183,    -1,  1181,  1193,  1181,
      -1,  1181,   522,  1196,    -1,    -1,  1181,  1193,  1181,   364,
    1186,  1138,    -1,    -1,  1181,   522,  1196,   364,  1187,  1138,
      -1,    -1,  1181,  1193,  1181,   588,  1188,   630,  1226,   631,
      -1,  1181,   341,   247,  1196,    -1,    -1,  1181,   258,  1212,
     247,  1181,   364,  1189,  1138,    -1,    -1,  1181,   258,  1212,
     247,  1196,  1190,   588,   630,  1226,   631,    -1,  1181,   341,
     258,  1212,   247,  1196,    -1,    -1,  1181,   453,  1212,   247,
    1181,   364,  1191,  1138,    -1,    -1,  1181,   453,  1212,   247,
    1196,  1192,   588,   630,  1226,   631,    -1,  1181,   341,   453,
    1212,   247,  1196,    -1,   247,    -1,   228,   247,    -1,    95,
     247,    -1,    -1,  1195,    -1,   385,   630,  1226,   631,   850,
      -1,    -1,  1197,  1427,  1194,  1231,  1221,    -1,  1211,  1210,
    1207,    -1,   630,  1210,  1198,   631,  1231,    -1,  1205,  1526,
      -1,    -1,    -1,  1198,   576,  1530,  1199,  1531,  1200,  1526,
      -1,  1202,    -1,    -1,    -1,  1203,  1537,  1132,  1204,   918,
    1131,    -1,    -1,  1210,  1206,  1184,    -1,    -1,    -1,  1208,
    1128,  1132,  1209,   918,    -1,    -1,   468,    -1,    -1,   376,
      -1,    -1,   186,   247,    -1,   186,   373,    46,    -1,   186,
     202,    46,    -1,   184,    -1,   221,    -1,    -1,  1214,   991,
    1213,  1216,   630,  1225,   631,    -1,    -1,   587,   991,  1213,
    1217,   630,  1223,   631,    -1,  1215,    -1,  1218,  1215,    -1,
      -1,    -1,  1220,  1218,    -1,    -1,  1222,  1219,    -1,    -1,
    1225,    -1,  1435,    -1,   401,    -1,  1224,    -1,  1225,   632,
    1224,    -1,  1435,    -1,  1226,   632,  1435,    -1,  1228,    -1,
     111,    -1,   112,    -1,   113,    -1,   114,    -1,   213,    -1,
     214,    -1,   215,    -1,   323,    -1,   324,    -1,   465,    -1,
     618,    -1,   115,    -1,   603,    -1,   216,    -1,   325,    -1,
     332,    -1,   410,    -1,   466,    -1,   321,    -1,   619,    -1,
     110,    -1,   552,    -1,   549,    -1,   107,    -1,    -1,    19,
      -1,   155,    -1,    -1,  1230,  1435,    -1,    -1,    12,    -1,
      -1,    -1,   606,  1234,  1138,    -1,    -1,    -1,   207,  1236,
    1138,    -1,   160,  1148,    -1,    -1,    -1,   202,    46,  1239,
    1240,    -1,  1239,   632,  1422,  1248,    -1,  1422,  1248,    -1,
      -1,   609,    -1,   610,    -1,   373,    46,  1242,    -1,  1242,
     632,  1243,    -1,  1243,    -1,  1424,  1248,    -1,    -1,  1245,
      -1,    -1,   373,    46,  1246,  1247,    -1,  1247,   632,  1422,
    1248,    -1,  1422,  1248,    -1,    -1,    20,    -1,   126,    -1,
      -1,  1251,    -1,    -1,  1251,    -1,   263,  1252,    -1,  1253,
      -1,  1253,   632,  1253,    -1,  1253,   362,  1253,    -1,  1435,
      -1,  1415,    -1,   567,    -1,   277,    -1,   358,    -1,    -1,
     263,  1253,    -1,   358,    -1,   209,    -1,   277,    -1,   567,
      -1,   117,    -1,   181,    -1,   358,    -1,   209,    -1,   277,
      -1,   567,    -1,  1259,    -1,   358,    -1,   567,    -1,   277,
      -1,   117,    -1,   181,    -1,   358,    -1,   567,    -1,   277,
      -1,  1259,    -1,  1260,    -1,   117,    -1,   181,    -1,    -1,
      -1,   403,    14,  1262,   630,  1263,   631,    -1,    -1,  1264,
      -1,  1264,   632,  1264,    -1,   358,    -1,    -1,  1266,  1267,
      -1,  1267,   632,  1268,    -1,  1268,    -1,   637,  1437,    -1,
    1437,    -1,    -1,   235,  1270,  1271,    -1,    -1,    -1,   377,
    1434,  1272,   960,  1273,  1398,  1401,    -1,   141,  1434,    -1,
    1265,    -1,    -1,   138,  1275,  1175,    -1,    -1,   139,  1287,
    1471,  1286,  1277,  1281,  1055,    -1,    -1,    -1,   139,   225,
    1435,   364,  1427,  1278,  1279,  1050,    -1,   139,   103,  1286,
    1435,    -1,   139,   192,  1286,  1435,   638,  1435,    -1,   139,
     192,  1286,  1435,    -1,   139,   403,  1286,   691,    -1,   139,
     585,   690,  1501,    -1,    -1,   139,   600,  1286,  1280,  1281,
    1055,    -1,   139,   162,  1286,   691,    -1,   139,   560,  1286,
     691,    -1,   139,   537,   826,  1288,    -1,   139,   273,   202,
     827,  1288,    -1,   139,   474,  1286,  1437,    -1,  1282,    -1,
    1281,   632,  1282,    -1,  1427,    -1,  1427,  1194,    -1,  1285,
      -1,  1284,   632,  1285,    -1,  1428,    -1,    -1,   220,   166,
      -1,    -1,   542,    -1,    -1,  1289,    -1,  1290,    -1,  1289,
    1290,    -1,  1288,   632,  1290,    -1,   837,    -1,   838,    -1,
      -1,    -1,   231,  1292,  1297,  1054,  1299,  1293,  1301,  1317,
      -1,    -1,    -1,   439,  1295,  1298,  1299,  1296,  1301,    -1,
      -1,   280,    -1,   123,    -1,   210,    -1,  1326,    -1,   123,
      -1,   235,  1300,    -1,  1300,    -1,  1283,    -1,  1304,    -1,
     630,   631,  1304,    -1,   630,  1303,   631,  1304,    -1,    -1,
     476,  1302,  1308,    -1,  1303,   632,  1420,    -1,  1420,    -1,
     592,  1307,    -1,   593,  1307,    -1,    -1,   896,  1305,  1522,
      -1,    -1,   630,   896,   631,  1306,  1525,    -1,  1307,   632,
    1312,    -1,  1312,    -1,  1308,   632,  1309,    -1,  1309,    -1,
    1424,  1310,  1316,    -1,   155,    -1,   477,    -1,    -1,  1310,
      -1,    -1,   630,  1313,  1314,   631,    -1,    -1,  1315,    -1,
    1315,   632,  1316,    -1,  1316,    -1,  1138,    -1,   120,    -1,
      -1,    -1,   364,   142,  1318,   250,   582,  1324,    -1,    -1,
      -1,   582,  1320,  1326,  1054,  1182,   476,  1322,  1321,  1233,
    1244,  1254,    -1,  1322,   632,  1323,    -1,  1323,    -1,  1424,
    1310,  1316,    -1,  1324,   632,  1325,    -1,  1325,    -1,  1424,
    1310,  1316,    -1,    -1,   280,    -1,    -1,   125,  1328,  1336,
    1329,    -1,    -1,   189,  1427,  1194,  1330,  1233,  1244,  1254,
      -1,    -1,  1333,  1331,   189,  1182,  1233,    -1,    -1,   189,
    1284,  1332,   588,  1182,  1233,    -1,  1334,    -1,  1333,   632,
    1334,    -1,  1435,  1335,    -1,  1435,   638,  1435,  1335,    -1,
      -1,   638,   625,    -1,    -1,  1337,  1336,    -1,   412,    -1,
     280,    -1,   221,    -1,    -1,   563,  1340,  1339,  1282,    -1,
      -1,   539,    -1,    -1,  1342,    -1,  1343,    -1,  1342,   632,
    1343,    -1,    93,    -1,   318,    -1,    41,   241,    -1,    89,
     534,    -1,   381,   176,    -1,   242,    -1,   533,    -1,   493,
      -1,    12,    -1,    -1,   186,   411,   358,    -1,    -1,   481,
    1346,  1347,    -1,   104,  1358,    -1,  1354,   536,  1353,  1358,
      -1,  1354,   559,  1353,  1358,    -1,   161,  1353,  1358,    -1,
     539,   517,  1353,  1358,    -1,   367,   536,  1353,  1358,    -1,
     392,    -1,   153,   915,  1350,    -1,   153,    12,  1350,    -1,
    1354,    70,  1355,  1427,  1353,  1358,    -1,  1351,   274,    -1,
     486,   212,    -1,    -1,    34,   161,  1356,  1357,  1348,  1249,
      -1,    -1,   427,   161,  1356,  1357,  1349,  1249,    -1,   993,
    1355,  1427,  1353,  1233,    -1,  1352,   152,    -1,   402,    -1,
      92,   630,   625,   631,   602,    -1,    92,   630,   625,   631,
     158,    -1,   602,  1249,    -1,   158,  1249,    -1,   407,    -1,
     406,  1341,  1344,  1249,    -1,  1456,   517,  1358,    -1,  1354,
     405,    -1,  1456,   596,  1358,    -1,   957,  1358,    -1,    69,
    1358,    -1,   201,    -1,   201,   186,  1438,    -1,    94,   103,
     906,  1435,    -1,    94,   539,  1427,    -1,    94,   600,  1427,
      -1,   302,   517,    -1,   486,   517,    -1,    94,   403,   691,
      -1,    94,   192,   691,    -1,    94,   560,   691,    -1,   403,
     517,  1358,    -1,   192,   517,  1358,    -1,   403,    67,   691,
      -1,   192,    67,   691,    -1,    94,   162,   691,    -1,   517,
      -1,   336,    -1,   274,    -1,   302,    -1,    33,    -1,    -1,
     521,    -1,    -1,  1355,  1435,    -1,    -1,   190,    -1,   189,
      -1,   238,    -1,    -1,   238,  1432,    -1,    -1,   189,  1257,
      -1,    -1,   262,  1432,    -1,   606,  1138,    -1,    -1,  1363,
    1427,  1360,  1365,    -1,    -1,  1363,  1364,  1361,  1362,    -1,
    1117,    -1,  1291,    -1,  1294,    -1,  1319,    -1,  1327,    -1,
     126,    -1,   127,    -1,    -1,   171,    -1,   386,    -1,   187,
     155,  1437,    -1,    -1,  1414,    -1,  1435,    -1,    -1,   183,
    1092,  1367,  1368,    -1,    -1,    -1,  1471,  1369,  1375,  1370,
    1371,    -1,  1373,    -1,    -1,   608,   416,   272,    -1,    -1,
     186,  1372,   170,    -1,  1373,   632,  1374,    -1,  1374,    -1,
     157,   274,    -1,   153,   274,    -1,   194,   274,    -1,   487,
     274,    -1,    33,   274,    -1,   426,   274,    -1,   411,    48,
      -1,   212,    -1,   402,    -1,   274,    -1,   517,    -1,   128,
      -1,   444,    -1,    -1,  1281,    -1,    -1,   442,  1377,  1378,
      -1,  1378,   632,  1379,    -1,  1379,    -1,    -1,   486,  1380,
    1381,    -1,   302,    -1,   411,    48,    -1,    -1,    12,    -1,
      -1,   409,  1383,  1384,    -1,  1351,   274,  1385,    -1,   556,
    1432,    -1,    29,  1138,    -1,   251,  1387,  1138,    -1,    -1,
      82,    -1,   411,    -1,   587,  1435,    -1,    -1,    -1,    -1,
      -1,   268,  1394,  1390,  1396,  1395,   226,  1434,  1391,  1397,
     235,   539,  1427,  1194,  1392,   960,  1393,  1404,  1398,  1401,
    1405,  1407,  1410,    -1,   106,    -1,   616,    -1,    -1,   269,
      -1,    -1,    80,    -1,   280,    -1,    -1,   439,    -1,   221,
      -1,    -1,    70,  1399,    -1,  1399,  1400,    -1,  1400,    -1,
     544,    46,  1414,    -1,   371,   148,    46,  1414,    -1,   148,
      46,  1414,    -1,   159,    46,  1414,    -1,    -1,   265,  1402,
      -1,  1402,  1403,    -1,  1403,    -1,   544,    46,  1414,    -1,
     511,    46,  1414,    -1,    -1,   457,   218,    46,  1414,    -1,
      -1,   221,   358,  1406,    -1,   265,    -1,   457,    -1,    -1,
     630,  1408,   631,    -1,   630,   631,    -1,  1408,   632,  1409,
      -1,  1409,    -1,  1424,    -1,   637,  1437,    -1,    -1,   476,
    1411,    -1,  1411,   632,  1412,    -1,  1412,    -1,  1424,  1310,
    1134,  1316,  1135,    -1,   545,    -1,   342,    -1,   570,   545,
      -1,  1413,  1433,    -1,  1433,    -1,   209,    -1,    35,    -1,
     382,    -1,  1417,    -1,   624,  1418,    -1,   623,  1418,    -1,
    1413,    -1,  1418,    -1,  1419,    -1,   357,    -1,   174,    -1,
     562,    -1,   209,    -1,    35,    -1,   570,   209,    -1,   570,
      35,    -1,   358,    -1,   277,    -1,   567,    -1,   117,    -1,
     181,    -1,   110,   545,    -1,   552,   545,    -1,   549,   545,
      -1,  1424,    -1,  1421,    -1,  1435,   638,   625,    -1,  1435,
     638,  1435,   638,   625,    -1,  1138,    -1,  1435,    -1,  1425,
      -1,  1435,    -1,  1425,    -1,  1435,   638,  1435,    -1,   638,
    1435,   638,  1435,    -1,  1435,   638,  1435,   638,  1435,    -1,
    1435,    -1,  1435,   638,  1435,   638,  1435,    -1,  1435,   638,
    1435,    -1,   638,  1435,    -1,  1435,    -1,  1435,   638,  1435,
      -1,   638,  1435,    -1,  1435,  1335,    -1,  1435,   638,  1435,
    1335,    -1,  1435,    -1,   217,    -1,   219,    -1,  1432,    -1,
     545,    -1,   545,    -1,   545,    -1,  1430,    -1,  1439,    -1,
    1430,    -1,  1440,    -1,  1435,    -1,  1432,    -1,   261,    -1,
    1437,    -1,  1437,   637,  1437,    -1,    99,  1137,    -1,  1440,
      -1,    21,    -1,    28,    -1,    30,    -1,    47,    -1,    48,
      -1,    58,    -1,    60,    -1,    65,    -1,    74,    -1,    76,
      -1,    88,    -1,   116,    -1,   138,    -1,   149,    -1,   165,
      -1,   183,    -1,   187,    -1,   205,    -1,   208,    -1,   211,
      -1,   233,    -1,   252,    -1,   354,    -1,   367,    -1,   369,
      -1,   379,    -1,   383,    -1,   395,    -1,   398,    -1,   433,
      -1,   436,    -1,   442,    -1,   445,    -1,   454,    -1,   462,
      -1,   467,    -1,   474,    -1,   484,    -1,   490,    -1,   486,
      -1,   491,    -1,   513,    -1,   520,    -1,   563,    -1,   574,
      -1,   575,    -1,   612,    -1,   615,    -1,   583,    -1,     5,
      -1,     7,    -1,     8,    -1,     9,    -1,    10,    -1,    11,
      -1,    14,    -1,    18,    -1,    23,    -1,    25,    -1,    24,
      -1,    26,    -1,    27,    -1,    34,    -1,    38,    -1,    41,
      -1,    43,    -1,    42,    -1,    45,    -1,    51,    -1,    54,
      -1,    55,    -1,    57,    -1,    62,    -1,    64,    -1,    63,
      -1,    66,    -1,    67,    -1,    69,    -1,    73,    -1,    72,
      -1,    70,    -1,    75,    -1,    77,    -1,    78,    -1,    79,
      -1,    80,    -1,    82,    -1,    83,    -1,    85,    -1,    87,
      -1,    86,    -1,    89,    -1,    93,    -1,    96,    -1,    98,
      -1,   101,    -1,   106,    -1,   105,    -1,   107,    -1,   110,
      -1,   115,    -1,   121,    -1,   122,    -1,   124,    -1,   128,
      -1,   130,    -1,   131,    -1,   132,    -1,   133,    -1,   134,
      -1,   141,    -1,   142,    -1,   143,    -1,   150,    -1,   154,
      -1,   153,    -1,   152,    -1,   157,    -1,   158,    -1,   160,
      -1,   162,    -1,   161,    -1,   163,    -1,   164,    -1,   168,
      -1,   169,    -1,   170,    -1,   171,    -1,   172,    -1,   176,
      -1,   175,    -1,   188,    -1,   147,    -1,   190,    -1,   178,
      -1,   179,    -1,   180,    -1,   194,    -1,   196,    -1,   195,
      -1,   197,    -1,   201,    -1,   199,    -1,   206,    -1,   212,
      -1,   216,    -1,   218,    -1,   222,    -1,   237,    -1,   223,
      -1,   224,    -1,   227,    -1,   241,    -1,   242,    -1,   244,
      -1,   245,    -1,   232,    -1,   249,    -1,   253,    -1,   256,
      -1,   259,    -1,   260,    -1,   266,    -1,   267,    -1,   269,
      -1,   271,    -1,   273,    -1,   274,    -1,   308,    -1,   302,
      -1,   304,    -1,   286,    -1,   290,    -1,   287,    -1,   288,
      -1,   303,    -1,   289,    -1,   292,    -1,   284,    -1,   291,
      -1,   285,    -1,   300,    -1,   294,    -1,   293,    -1,   295,
      -1,   296,    -1,   297,    -1,   298,    -1,   299,    -1,   282,
      -1,   306,    -1,   307,    -1,   309,    -1,   311,    -1,   312,
      -1,   317,    -1,   318,    -1,   319,    -1,   320,    -1,   321,
      -1,   322,    -1,   325,    -1,   326,    -1,   330,    -1,   328,
      -1,   332,    -1,   333,    -1,   334,    -1,   335,    -1,   336,
      -1,   337,    -1,   339,    -1,   338,    -1,   340,    -1,   343,
      -1,   344,    -1,   348,    -1,   347,    -1,   355,    -1,   349,
      -1,   350,    -1,   359,    -1,   361,    -1,   362,    -1,   363,
      -1,   365,    -1,   366,    -1,   380,    -1,   381,    -1,   384,
      -1,   387,    -1,   386,    -1,   388,    -1,   389,    -1,   390,
      -1,   391,    -1,   392,    -1,   393,    -1,   394,    -1,   399,
      -1,   400,    -1,   402,    -1,   404,    -1,   405,    -1,   406,
      -1,   407,    -1,   408,    -1,   410,    -1,   411,    -1,   412,
      -1,   415,    -1,   419,    -1,   420,    -1,   422,    -1,   421,
      -1,   423,    -1,   426,    -1,   427,    -1,   428,    -1,   429,
      -1,   430,    -1,   432,    -1,   435,    -1,   437,    -1,   440,
      -1,   444,    -1,   447,    -1,   448,    -1,   449,    -1,   451,
      -1,   455,    -1,   456,    -1,   457,    -1,   460,    -1,   458,
      -1,   459,    -1,   461,    -1,   463,    -1,   464,    -1,   466,
      -1,   472,    -1,   471,    -1,   473,    -1,   485,    -1,   478,
      -1,   482,    -1,   487,    -1,   489,    -1,   492,    -1,   493,
      -1,   499,    -1,   500,    -1,   501,    -1,   504,    -1,   503,
      -1,   506,    -1,   509,    -1,   512,    -1,   514,    -1,   515,
      -1,   516,    -1,   517,    -1,   521,    -1,   523,    -1,   524,
      -1,   525,    -1,   526,    -1,   528,    -1,   527,    -1,   531,
      -1,   532,    -1,   533,    -1,   534,    -1,   541,    -1,   536,
      -1,   540,    -1,   537,    -1,   542,    -1,   543,    -1,   546,
      -1,   547,    -1,   558,    -1,   559,    -1,   549,    -1,   550,
      -1,   551,    -1,   552,    -1,   564,    -1,   565,    -1,   566,
      -1,   192,    -1,   568,    -1,   569,    -1,   572,    -1,   571,
      -1,   578,    -1,   581,    -1,   585,    -1,   586,    -1,   596,
      -1,   600,    -1,   593,    -1,   602,    -1,   601,    -1,   603,
      -1,   611,    -1,   604,    -1,   614,    -1,   616,    -1,   619,
      -1,    -1,   476,  1442,  1443,    -1,    -1,  1459,  1444,  1449,
      -1,    -1,   558,  1445,  1462,    -1,    -1,  1455,  1446,  1447,
      -1,    -1,  1458,  1448,  1449,    -1,   558,  1462,    -1,    -1,
     632,  1450,    -1,    -1,  1451,  1453,    -1,    -1,  1450,   632,
    1452,  1453,    -1,    -1,  1455,  1454,  1458,    -1,  1459,    -1,
     199,    -1,   269,    -1,   473,    -1,    -1,   199,    -1,   269,
      -1,   473,    -1,    -1,   199,   638,    -1,   269,   638,    -1,
     473,   638,    -1,  1461,  1310,  1468,    -1,    -1,  1461,  1310,
    1460,  1468,    -1,   637,  1437,  1310,  1138,    -1,   637,   637,
    1457,  1461,  1310,  1468,    -1,   957,   962,    -1,   338,  1310,
    1138,    -1,   338,   959,   964,    -1,   388,  1310,  1467,    -1,
     388,   186,  1438,  1310,  1467,    -1,  1435,    -1,  1435,   638,
    1435,    -1,   120,   638,  1435,    -1,  1463,    -1,  1464,    -1,
    1463,   632,  1464,    -1,  1464,   632,  1463,    -1,  1465,    -1,
     244,   260,  1466,    -1,   416,   366,    -1,   416,   613,    -1,
     416,   568,    -1,   416,    75,    -1,   437,   416,    -1,   471,
      -1,   545,    -1,   388,   630,   545,   631,    -1,   363,   630,
     545,   631,    -1,  1138,    -1,   120,    -1,   364,    -1,    12,
      -1,    33,    -1,    -1,   272,  1471,  1470,  1472,    -1,   539,
      -1,   536,    -1,  1473,    -1,  1472,   632,  1473,    -1,  1427,
    1231,  1474,    -1,   416,    -1,   613,    -1,   280,   613,    -1,
     416,   269,    -1,    -1,   579,  1476,  1471,    -1,   205,  1427,
     367,  1231,    -1,   205,  1429,    65,    -1,    -1,   205,  1429,
     416,  1478,  1479,  1233,  1250,    -1,  1480,    -1,  1435,  1481,
      -1,   179,    -1,   348,    -1,   179,    -1,   348,    -1,   400,
      -1,   253,    -1,    -1,  1483,  1482,   630,  1315,   631,    -1,
     155,    -1,   193,    -1,   254,    -1,   204,    -1,   281,    -1,
     452,   690,  1485,    -1,  1489,   364,  1488,  1500,   189,  1502,
      -1,  1489,   364,   192,  1500,   189,  1502,    -1,  1489,   364,
     403,  1500,   189,  1502,    -1,    12,  1490,   632,   200,   370,
     189,  1502,    -1,   408,   364,  1438,   189,  1502,    -1,   200,
     690,  1487,    -1,  1489,   364,  1488,  1500,   556,  1502,  1507,
    1508,    -1,  1489,   364,   192,  1500,   556,  1502,  1507,  1508,
      -1,  1489,   364,   403,  1500,   556,  1502,  1507,  1508,    -1,
     408,   364,  1438,   556,  1502,  1509,    -1,    -1,   539,    -1,
    1491,    -1,    12,  1490,    -1,    -1,   402,    -1,  1492,    -1,
    1491,   632,  1492,    -1,    -1,   468,  1493,  1504,    -1,    -1,
     231,  1494,  1504,    -1,    -1,   582,  1495,  1504,    -1,    -1,
     424,  1496,  1504,    -1,   125,    -1,   584,    -1,   225,    -1,
      13,    -1,    94,    -1,   139,    -1,   165,    -1,   432,    -1,
     482,    -1,   404,    -1,   178,    -1,   200,   370,    -1,   481,
     104,    -1,   531,    -1,    94,   542,   536,    -1,   272,   536,
      -1,   440,   486,    -1,   440,    64,    -1,    94,   600,    -1,
     481,   600,    -1,    94,   456,    -1,    13,   456,    -1,    94,
     585,    -1,   162,    -1,   560,    -1,    94,   537,    -1,    -1,
      17,    -1,  1499,  1497,  1498,    -1,  1499,    -1,   526,   545,
      -1,   245,   545,    -1,    62,   545,    -1,   625,    -1,  1435,
     638,   625,    -1,   625,   638,   625,    -1,  1427,    -1,  1438,
      -1,  1501,   632,  1438,    -1,  1503,    -1,  1502,   632,  1503,
      -1,  1438,   218,    46,   545,    -1,  1438,   218,    46,   388,
     545,    -1,  1438,   218,   608,  1437,    -1,  1438,   218,   608,
    1437,    19,  1432,    -1,  1438,    -1,    -1,   630,  1505,   631,
      -1,  1505,   632,  1506,    -1,  1506,    -1,  1435,    -1,    -1,
     441,  1498,    -1,   441,   510,    -1,   441,   614,    -1,   441,
     350,    -1,    -1,   608,  1510,    -1,    -1,   608,   200,   370,
      -1,  1510,  1511,    -1,  1511,    -1,   200,   370,    -1,   307,
    1255,    -1,   311,  1255,    -1,   306,  1255,    -1,   312,  1255,
      -1,    -1,    30,  1513,  1514,    -1,    -1,   611,    -1,    -1,
      17,   354,    55,    -1,    17,    55,    -1,    -1,   431,    -1,
     354,   431,    -1,    -1,   462,    -1,    76,  1514,  1515,  1516,
      -1,   454,  1514,  1515,  1516,    -1,   454,  1514,   556,  1517,
    1435,    -1,   462,  1435,    -1,   431,   462,  1435,    -1,    -1,
    1523,    -1,    -1,   576,  1530,  1524,  1118,    -1,    -1,  1523,
      -1,  1527,    -1,    -1,  1527,    -1,    -1,  1528,  1529,    -1,
    1245,  1249,    -1,  1251,    -1,    -1,   135,    -1,    12,    -1,
     468,  1201,    -1,   630,  1120,   631,    -1,  1531,  1526,    -1,
      -1,  1532,   576,  1530,  1533,  1531,  1526,    -1,  1535,  1532,
    1536,    -1,    -1,    -1,    -1,  1538,    -1,  1538,  1539,    -1,
    1539,    -1,   522,    -1,   210,    -1,   135,    -1,   507,    -1,
     502,    -1,   503,    -1,   505,    -1,    12,    -1,  1545,  1541,
      -1,  1544,  1542,    -1,  1546,  1543,  1550,    -1,  1550,    -1,
    1562,    -1,  1573,    -1,  1567,    -1,   677,    -1,  1550,    -1,
    1562,    -1,  1573,    -1,  1567,    -1,  1566,    -1,   677,    -1,
    1544,    -1,  1545,    -1,    -1,   122,   155,  1438,    -1,  1547,
      -1,  1547,  1548,    -1,  1548,    -1,   375,   439,    -1,    11,
     155,   569,    -1,    11,   155,   319,    -1,    11,   155,   543,
      -1,    -1,   508,   467,   122,    -1,   508,   467,   237,    -1,
      -1,  1549,   600,  1427,  1551,  1552,    19,  1554,    -1,    -1,
     630,  1553,   631,    -1,  1435,    -1,  1553,   632,  1435,    -1,
      -1,  1555,  1556,  1561,    -1,    -1,  1559,  1557,  1522,    -1,
     630,  1558,   631,  1525,    -1,  1559,    -1,   630,  1558,   631,
      -1,    -1,   468,  1560,  1123,    -1,    -1,   608,    61,   370,
      -1,   608,    51,    61,   370,    -1,   608,   269,    61,   370,
      -1,    -1,    -1,    -1,   560,  1134,   691,   797,   798,   364,
    1134,  1563,  1427,   186,  1134,  1564,   144,   459,  1565,   746,
      -1,    10,  1134,   192,  1435,   449,   919,   491,  1432,    -1,
    1134,   192,  1435,   449,   919,   491,  1432,    -1,    -1,    -1,
      -1,    -1,    -1,  1134,   192,   691,   630,  1568,   702,   631,
    1569,   449,  1570,   954,  1571,   693,  1572,   746,    -1,    -1,
      -1,    -1,    -1,   403,  1134,   691,  1574,   630,  1575,   706,
     631,  1576,   693,  1577,   746,    -1,   615,  1580,  1579,  1581,
      -1,   615,   149,  1579,  1583,    -1,   615,   398,  1579,    -1,
     615,    76,  1579,  1582,    -1,   615,   454,  1579,    -1,   615,
     420,    -1,  1414,    -1,  1414,   632,  1414,    -1,  1414,   632,
    1414,   632,  1255,    -1,    30,    -1,   513,    -1,    -1,   247,
      -1,   447,    -1,    -1,   365,   389,    -1,    -1,    -1,   532,
    1584,  1585,    -1,    -1,   186,   322,    -1,   233,   391,  1435,
     491,  1432,    -1,   575,   391,  1435,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,  1964,  1964,  1977,  1976,  2001,  2008,  2010,  2014,  2015,
    2020,  2021,  2022,  2023,  2024,  2025,  2026,  2027,  2028,  2029,
    2030,  2031,  2032,  2033,  2034,  2035,  2036,  2037,  2038,  2039,
    2040,  2041,  2042,  2043,  2044,  2045,  2046,  2047,  2048,  2049,
    2050,  2051,  2052,  2053,  2054,  2055,  2056,  2057,  2058,  2059,
    2060,  2061,  2062,  2063,  2064,  2065,  2066,  2067,  2068,  2069,
    2070,  2071,  2075,  2085,  2086,  2090,  2100,  2107,  2118,  2117,
    2128,  2130,  2134,  2135,  2139,  2152,  2151,  2171,  2170,  2188,
    2189,  2193,  2197,  2201,  2205,  2210,  2214,  2218,  2223,  2233,
    2238,  2242,  2246,  2250,  2254,  2258,  2263,  2267,  2272,  2303,
    2308,  2315,  2318,  2320,  2321,  2325,  2339,  2343,  2359,  2363,
    2376,  2375,  2420,  2425,  2419,  2432,  2437,  2430,  2444,  2449,
    2442,  2455,  2454,  2467,  2466,  2474,  2478,  2482,  2486,  2493,
    2506,  2507,  2511,  2515,  2519,  2523,  2527,  2532,  2536,  2544,
    2543,  2575,  2574,  2581,  2588,  2589,  2595,  2601,  2611,  2617,
    2623,  2625,  2632,  2633,  2637,  2643,  2652,  2653,  2661,  2661,
    2716,  2717,  2718,  2719,  2720,  2721,  2722,  2723,  2724,  2725,
    2726,  2727,  2728,  2733,  2747,  2761,  2780,  2781,  2785,  2786,
    2791,  2793,  2795,  2797,  2799,  2801,  2803,  2809,  2810,  2811,
    2815,  2819,  2827,  2826,  2839,  2841,  2844,  2846,  2850,  2854,
    2861,  2863,  2867,  2868,  2873,  2892,  2922,  2924,  2928,  2929,
    2933,  2962,  2963,  2964,  2965,  2969,  2970,  2974,  2975,  2980,
    2983,  3010,  3009,  3093,  3110,  3109,  3184,  3183,  3256,  3257,
    3262,  3264,  3269,  3292,  3303,  3307,  3329,  3330,  3334,  3338,
    3351,  3357,  3363,  3372,  3387,  3413,  3419,  3420,  3426,  3429,
    3433,  3441,  3461,  3463,  3481,  3487,  3489,  3491,  3493,  3495,
    3497,  3499,  3501,  3503,  3505,  3507,  3509,  3514,  3530,  3546,
    3547,  3552,  3558,  3567,  3573,  3582,  3590,  3619,  3628,  3630,
    3639,  3644,  3650,  3659,  3667,  3669,  3671,  3673,  3675,  3677,
    3679,  3681,  3683,  3685,  3687,  3689,  3691,  3696,  3716,  3740,
    3742,  3741,  3748,  3749,  3750,  3751,  3752,  3753,  3754,  3755,
    3756,  3757,  3758,  3759,  3760,  3765,  3764,  3775,  3775,  3832,
    3831,  3888,  3888,  3910,  3969,  4019,  4044,  4043,  4069,  4092,
    4094,  4095,  4099,  4117,  4138,  4147,  4183,  4138,  4212,  4214,
    4215,  4219,  4220,  4225,  4236,  4224,  4287,  4286,  4300,  4301,
    4305,  4306,  4311,  4320,  4310,  4369,  4378,  4368,  4422,  4435,
    4440,  4439,  4477,  4478,  4483,  4482,  4516,  4516,  4535,  4534,
    4584,  4601,  4610,  4600,  4664,  4673,  4663,  4713,  4715,  4720,
    4722,  4724,  4741,  4746,  4752,  4759,  4760,  4768,  4774,  4783,
    4789,  4795,  4796,  4800,  4800,  4805,  4806,  4807,  4811,  4812,
    4813,  4816,  4818,  4822,  4823,  4824,  4828,  4829,  4830,  4831,
    4832,  4833,  4834,  4835,  4838,  4840,  4844,  4845,  4846,  4850,
    4851,  4852,  4853,  4854,  4857,  4859,  4863,  4864,  4865,  4869,
    4870,  4871,  4872,  4873,  4874,  4875,  4878,  4880,  4884,  4885,
    4886,  4890,  4891,  4892,  4897,  4905,  4913,  4921,  4933,  4945,
    4950,  4955,  4963,  4971,  4979,  4987,  4995,  5003,  5011,  5024,
    5037,  5051,  5056,  5069,  5070,  5121,  5122,  5125,  5140,  5158,
    5163,  5161,  5168,  5170,  5169,  5173,  5172,  5178,  5215,  5216,
    5221,  5220,  5239,  5258,  5257,  5274,  5278,  5286,  5285,  5288,
    5290,  5292,  5294,  5299,  5300,  5306,  5307,  5324,  5325,  5329,
    5330,  5334,  5353,  5363,  5374,  5383,  5384,  5400,  5402,  5401,
    5406,  5404,  5415,  5416,  5420,  5438,  5454,  5455,  5471,  5486,
    5508,  5509,  5514,  5513,  5537,  5547,  5569,  5568,  5586,  5585,
    5605,  5627,  5631,  5660,  5672,  5673,  5678,  5689,  5677,  5714,
    5715,  5719,  5732,  5753,  5766,  5792,  5793,  5798,  5797,  5834,
    5839,  5840,  5844,  5845,  5849,  5851,  5857,  5859,  5861,  5863,
    5865,  5867,  5877,  5892,  5876,  5906,  5907,  5911,  5912,  5916,
    5917,  5921,  5922,  5926,  5927,  5931,  5932,  5936,  5940,  5941,
    5944,  5946,  5950,  5951,  5955,  5956,  5957,  5961,  5966,  5971,
    5976,  5981,  5986,  5991,  5996,  6011,  6017,  6032,  6037,  6052,
    6058,  6076,  6081,  6086,  6091,  6096,  6102,  6101,  6127,  6128,
    6129,  6134,  6139,  6144,  6146,  6148,  6150,  6156,  6164,  6182,
    6199,  6225,  6243,  6244,  6245,  6246,  6247,  6248,  6252,  6253,
    6254,  6258,  6259,  6263,  6264,  6265,  6266,  6271,  6278,  6279,
    6283,  6284,  6288,  6289,  6296,  6301,  6307,  6313,  6319,  6338,
    6344,  6346,  6350,  6354,  6355,  6359,  6364,  6363,  6386,  6387,
    6388,  6389,  6394,  6398,  6403,  6408,  6412,  6417,  6422,  6428,
    6433,  6439,  6443,  6448,  6453,  6471,  6473,  6475,  6491,  6493,
    6498,  6503,  6515,  6520,  6525,  6530,  6532,  6534,  6536,  6538,
    6540,  6542,  6544,  6547,  6546,  6551,  6550,  6554,  6556,  6565,
    6566,  6567,  6572,  6573,  6574,  6575,  6576,  6580,  6584,  6585,
    6589,  6590,  6594,  6595,  6596,  6597,  6598,  6602,  6603,  6604,
    6605,  6606,  6610,  6615,  6617,  6623,  6624,  6626,  6631,  6641,
    6642,  6646,  6647,  6648,  6656,  6657,  6661,  6662,  6666,  6667,
    6668,  6672,  6673,  6674,  6675,  6678,  6679,  6683,  6684,  6688,
    6689,  6693,  6694,  6698,  6699,  6700,  6701,  6702,  6703,  6709,
    6715,  6721,  6727,  6728,  6741,  6747,  6753,  6759,  6764,  6769,
    6778,  6799,  6807,  6808,  6813,  6814,  6818,  6826,  6830,  6831,
    6835,  6836,  6840,  6849,  6853,  6854,  6858,  6866,  6867,  6871,
    6872,  6876,  6877,  6882,  6883,  6887,  6894,  6903,  6908,  6916,
    6917,  6918,  6919,  6920,  6921,  6926,  6934,  6935,  6940,  6939,
    6952,  6953,  6957,  6960,  6961,  6962,  6963,  6967,  6975,  6982,
    6983,  6987,  6997,  6998,  7002,  7003,  7006,  7008,  7012,  7024,
    7025,  7029,  7036,  7049,  7050,  7052,  7054,  7060,  7065,  7071,
    7077,  7084,  7094,  7095,  7096,  7097,  7098,  7102,  7106,  7107,
    7111,  7112,  7116,  7117,  7121,  7122,  7123,  7127,  7128,  7132,
    7136,  7149,  7161,  7162,  7166,  7167,  7171,  7172,  7176,  7177,
    7181,  7182,  7186,  7187,  7191,  7192,  7196,  7197,  7201,  7203,
    7207,  7208,  7212,  7216,  7217,  7230,  7231,  7232,  7236,  7237,
    7241,  7247,  7261,  7262,  7266,  7267,  7271,  7272,  7280,  7279,
    7318,  7317,  7331,  7343,  7342,  7361,  7360,  7379,  7378,  7397,
    7391,  7411,  7410,  7443,  7448,  7453,  7458,  7463,  7470,  7477,
    7482,  7490,  7491,  7492,  7493,  7497,  7498,  7510,  7511,  7515,
    7516,  7519,  7521,  7529,  7537,  7539,  7541,  7542,  7550,  7551,
    7555,  7564,  7562,  7576,  7590,  7589,  7603,  7601,  7615,  7622,
    7633,  7634,  7662,  7669,  7673,  7678,  7677,  7693,  7695,  7700,
    7708,  7707,  7723,  7727,  7726,  7738,  7739,  7743,  7758,  7759,
    7763,  7772,  7776,  7781,  7787,  7786,  7797,  7806,  7796,  7821,
    7830,  7839,  7848,  7857,  7863,  7869,  7878,  7887,  7915,  7936,
    7946,  7950,  7955,  7956,  7959,  7961,  7962,  7963,  7964,  7967,
    7972,  7983,  7988,  7999,  8000,  8004,  8005,  8009,  8010,  8011,
    8015,  8016,  8021,  8029,  8030,  8031,  8032,  8037,  8036,  8065,
    8075,  8092,  8095,  8102,  8106,  8113,  8117,  8121,  8128,  8133,
    8136,  8143,  8146,  8153,  8156,  8163,  8166,  8174,  8177,  8184,
    8188,  8195,  8199,  8206,  8207,  8232,  8233,  8234,  8239,  8244,
    8252,  8251,  8263,  8264,  8265,  8270,  8269,  8291,  8292,  8296,
    8297,  8301,  8302,  8303,  8308,  8307,  8329,  8338,  8337,  8364,
    8365,  8369,  8370,  8374,  8375,  8376,  8377,  8378,  8379,  8384,
    8383,  8405,  8406,  8407,  8412,  8411,  8417,  8424,  8429,  8437,
    8438,  8442,  8456,  8455,  8468,  8469,  8473,  8474,  8478,  8488,
    8498,  8499,  8504,  8503,  8514,  8515,  8519,  8520,  8524,  8534,
    8545,  8544,  8552,  8552,  8563,  8564,  8569,  8570,  8579,  8588,
    8589,  8593,  8598,  8603,  8608,  8613,  8612,  8632,  8640,  8632,
    8647,  8648,  8649,  8650,  8651,  8655,  8662,  8669,  8671,  8682,
    8683,  8687,  8688,  8716,  8746,  8748,  8754,  8764,  8765,  8766,
    8781,  8788,  8813,  8819,  8825,  8826,  8827,  8828,  8829,  8833,
    8834,  8839,  8890,  8897,  8940,  8946,  8952,  8958,  8964,  8970,
    8976,  8982,  8986,  8992,  8998,  9004,  9010,  9016,  9020,  9026,
    9036,  9042,  9050,  9056,  9066,  9072,  9081,  9091,  9097,  9107,
    9113,  9122,  9126,  9132,  9138,  9144,  9150,  9156,  9162,  9168,
    9174,  9180,  9186,  9192,  9198,  9204,  9210,  9214,  9215,  9219,
    9220,  9224,  9225,  9229,  9230,  9234,  9235,  9236,  9237,  9238,
    9239,  9243,  9244,  9248,  9249,  9250,  9251,  9252,  9253,  9265,
    9266,  9267,  9268,  9269,  9275,  9279,  9285,  9291,  9297,  9303,
    9305,  9312,  9319,  9325,  9366,  9375,  9382,  9390,  9396,  9403,
    9409,  9423,  9430,  9446,  9452,  9458,  9466,  9472,  9478,  9484,
    9490,  9505,  9517,  9523,  9529,  9535,  9541,  9547,  9553,  9559,
    9565,  9571,  9577,  9583,  9589,  9595,  9601,  9607,  9613,  9621,
    9642,  9649,  9655,  9662,  9669,  9676,  9683,  9689,  9695,  9700,
    9706,  9713,  9719,  9725,  9731,  9737,  9743,  9761,  9767,  9773,
    9780,  9787,  9802,  9808,  9814,  9820,  9826,  9833,  9839,  9845,
    9851,  9857,  9863,  9870,  9883,  9889,  9895,  9901,  9907,  9915,
    9921,  9933,  9939,  9945,  9953,  9963,  9969,  9985,  9991,  9998,
   10005, 10012, 10019, 10026, 10030, 10050, 10049, 10122, 10162, 10164,
   10169, 10170, 10174, 10175, 10179, 10180, 10184, 10191, 10199, 10225,
   10231, 10237, 10243, 10249, 10255, 10264, 10271, 10273, 10270, 10280,
   10291, 10297, 10303, 10309, 10315, 10321, 10327, 10333, 10339, 10346,
   10345, 10364, 10363, 10378, 10389, 10397, 10413, 10414, 10419, 10424,
   10429, 10432, 10445, 10444, 10461, 10463, 10465, 10467, 10469, 10471,
   10473, 10475, 10477, 10479, 10481, 10486, 10487, 10491, 10498, 10506,
   10507, 10511, 10518, 10526, 10527, 10531, 10532, 10536, 10544, 10555,
   10556, 10565, 10576, 10577, 10583, 10584, 10604, 10606, 10610, 10608,
   10625, 10623, 10641, 10639, 10646, 10655, 10653, 10671, 10670, 10680,
   10691, 10689, 10708, 10707, 10718, 10729, 10730, 10731, 10739, 10740,
   10744, 10759, 10759, 10774, 10814, 10887, 10898, 10903, 10895, 10922,
   10942, 10950, 10942, 10959, 10958, 10981, 10998, 10981, 11005, 11009,
   11035, 11036, 11041, 11044, 11045, 11046, 11050, 11051, 11056, 11055,
   11061, 11060, 11068, 11069, 11072, 11074, 11074, 11078, 11078, 11083,
   11084, 11088, 11090, 11095, 11096, 11100, 11111, 11124, 11125, 11126,
   11127, 11128, 11129, 11130, 11131, 11132, 11133, 11134, 11135, 11139,
   11140, 11141, 11142, 11143, 11144, 11145, 11146, 11147, 11151, 11152,
   11153, 11154, 11157, 11159, 11160, 11164, 11165, 11173, 11175, 11179,
   11181, 11180, 11194, 11197, 11196, 11211, 11217, 11232, 11234, 11238,
   11240, 11245, 11246, 11266, 11291, 11295, 11296, 11300, 11313, 11315,
   11320, 11319, 11354, 11356, 11361, 11362, 11363, 11368, 11374, 11378,
   11379, 11383, 11390, 11397, 11404, 11414, 11441, 11445, 11451, 11457,
   11467, 11471, 11481, 11482, 11483, 11484, 11485, 11486, 11490, 11491,
   11492, 11493, 11494, 11498, 11499, 11500, 11501, 11502, 11506, 11507,
   11508, 11509, 11513, 11518, 11519, 11522, 11525, 11524, 11558, 11559,
   11563, 11571, 11584, 11584, 11594, 11595, 11599, 11618, 11658, 11657,
   11670, 11678, 11669, 11680, 11692, 11704, 11703, 11721, 11720, 11731,
   11732, 11731, 11748, 11755, 11776, 11797, 11809, 11814, 11813, 11823,
   11829, 11836, 11841, 11846, 11856, 11857, 11861, 11872, 11885, 11886,
   11890, 11901, 11902, 11906, 11907, 11910, 11912, 11915, 11916, 11917,
   11921, 11922, 11930, 11938, 11929, 11948, 11955, 11947, 11965, 11977,
   11978, 11991, 11995, 11996, 12012, 12013, 12017, 12026, 12027, 12028,
   12030, 12029, 12040, 12041, 12045, 12046, 12048, 12047, 12051, 12050,
   12056, 12057, 12061, 12062, 12066, 12076, 12077, 12081, 12082, 12087,
   12086, 12100, 12101, 12105, 12110, 12118, 12119, 12127, 12129, 12129,
   12137, 12145, 12136, 12167, 12168, 12172, 12180, 12181, 12185, 12195,
   12196, 12203, 12202, 12218, 12217, 12231, 12230, 12242, 12241, 12255,
   12256, 12260, 12273, 12289, 12290, 12294, 12295, 12299, 12300, 12301,
   12306, 12305, 12327, 12329, 12332, 12334, 12337, 12338, 12341, 12345,
   12349, 12353, 12357, 12361, 12365, 12369, 12373, 12381, 12384, 12394,
   12393, 12408, 12415, 12423, 12431, 12439, 12447, 12455, 12462, 12464,
   12466, 12475, 12479, 12484, 12483, 12489, 12488, 12493, 12502, 12509,
   12514, 12516, 12518, 12520, 12522, 12530, 12541, 12549, 12551, 12559,
   12566, 12573, 12583, 12590, 12596, 12605, 12613, 12617, 12621, 12628,
   12635, 12641, 12648, 12655, 12660, 12665, 12673, 12675, 12677, 12682,
   12683, 12686, 12688, 12692, 12693, 12697, 12698, 12702, 12703, 12707,
   12708, 12712, 12713, 12716, 12718, 12725, 12736, 12735, 12751, 12750,
   12757, 12758, 12759, 12760, 12761, 12765, 12766, 12771, 12775, 12781,
   12787, 12809, 12810, 12811, 12826, 12825, 12838, 12847, 12837, 12849,
   12853, 12854, 12866, 12865, 12887, 12888, 12893, 12895, 12897, 12899,
   12901, 12903, 12905, 12907, 12909, 12911, 12913, 12915, 12917, 12922,
   12923, 12928, 12927, 12937, 12938, 12942, 12942, 12944, 12945, 12949,
   12950, 12955, 12954, 12965, 12969, 12973, 12985, 12995, 12996, 12997,
   13003, 13015, 13027, 13037, 13047, 13014, 13055, 13056, 13060, 13061,
   13065, 13066, 13078, 13082, 13083, 13084, 13087, 13089, 13093, 13094,
   13098, 13103, 13110, 13115, 13122, 13124, 13128, 13129, 13133, 13138,
   13146, 13147, 13150, 13152, 13160, 13162, 13166, 13167, 13168, 13172,
   13174, 13179, 13180, 13189, 13190, 13194, 13195, 13199, 13212, 13236,
   13248, 13259, 13278, 13286, 13298, 13313, 13334, 13335, 13336, 13345,
   13346, 13347, 13348, 13355, 13361, 13367, 13373, 13379, 13408, 13439,
   13449, 13459, 13465, 13474, 13486, 13492, 13498, 13514, 13515, 13519,
   13528, 13544, 13548, 13599, 13603, 13621, 13625, 13705, 13730, 13761,
   13762, 13778, 13788, 13792, 13798, 13804, 13814, 13820, 13829, 13839,
   13840, 13870, 13883, 13899, 13915, 13932, 13933, 13944, 13945, 13956,
   13957, 13958, 13962, 13989, 14022, 14037, 14038, 14039, 14040, 14041,
   14042, 14043, 14044, 14045, 14046, 14047, 14048, 14049, 14050, 14051,
   14052, 14053, 14054, 14055, 14056, 14057, 14058, 14059, 14060, 14061,
   14062, 14063, 14064, 14065, 14066, 14067, 14068, 14069, 14070, 14071,
   14072, 14073, 14074, 14075, 14076, 14077, 14078, 14079, 14080, 14081,
   14082, 14083, 14084, 14085, 14086, 14096, 14097, 14098, 14099, 14100,
   14101, 14102, 14103, 14104, 14105, 14106, 14107, 14108, 14109, 14110,
   14111, 14112, 14113, 14114, 14115, 14116, 14117, 14118, 14119, 14120,
   14121, 14122, 14123, 14124, 14125, 14126, 14127, 14128, 14129, 14130,
   14131, 14132, 14133, 14134, 14135, 14136, 14137, 14138, 14139, 14140,
   14145, 14146, 14147, 14148, 14149, 14150, 14151, 14152, 14153, 14154,
   14155, 14156, 14157, 14158, 14159, 14160, 14161, 14162, 14163, 14164,
   14165, 14166, 14167, 14168, 14169, 14170, 14171, 14172, 14173, 14174,
   14175, 14176, 14177, 14178, 14179, 14180, 14181, 14182, 14183, 14184,
   14185, 14186, 14187, 14188, 14189, 14190, 14191, 14192, 14193, 14194,
   14195, 14196, 14197, 14198, 14199, 14200, 14201, 14202, 14203, 14204,
   14205, 14206, 14207, 14208, 14209, 14210, 14211, 14212, 14213, 14214,
   14215, 14216, 14217, 14218, 14219, 14220, 14221, 14222, 14223, 14224,
   14225, 14226, 14227, 14228, 14229, 14230, 14231, 14232, 14233, 14234,
   14235, 14236, 14237, 14238, 14239, 14240, 14241, 14242, 14243, 14244,
   14245, 14246, 14247, 14248, 14249, 14250, 14251, 14252, 14253, 14254,
   14255, 14256, 14257, 14258, 14259, 14260, 14261, 14262, 14263, 14264,
   14265, 14266, 14267, 14268, 14269, 14270, 14271, 14272, 14273, 14274,
   14275, 14276, 14277, 14278, 14279, 14280, 14281, 14282, 14283, 14284,
   14285, 14286, 14287, 14288, 14289, 14290, 14291, 14292, 14293, 14294,
   14295, 14296, 14297, 14298, 14299, 14300, 14301, 14302, 14303, 14304,
   14305, 14306, 14307, 14308, 14309, 14310, 14311, 14312, 14313, 14314,
   14315, 14316, 14317, 14318, 14319, 14320, 14321, 14322, 14323, 14324,
   14325, 14326, 14327, 14328, 14329, 14330, 14331, 14332, 14333, 14334,
   14335, 14336, 14337, 14338, 14339, 14340, 14341, 14342, 14343, 14344,
   14345, 14346, 14347, 14348, 14349, 14350, 14351, 14352, 14353, 14354,
   14355, 14356, 14357, 14358, 14359, 14360, 14361, 14362, 14363, 14364,
   14365, 14366, 14367, 14368, 14369, 14370, 14371, 14372, 14373, 14374,
   14375, 14376, 14377, 14378, 14379, 14380, 14381, 14382, 14383, 14384,
   14385, 14386, 14387, 14388, 14389, 14390, 14391, 14392, 14393, 14394,
   14395, 14396, 14397, 14398, 14399, 14400, 14412, 14411, 14431, 14430,
   14437, 14436, 14446, 14445, 14456, 14455, 14461, 14469, 14471, 14476,
   14476, 14485, 14484, 14498, 14497, 14502, 14506, 14507, 14508, 14512,
   14513, 14514, 14515, 14519, 14520, 14521, 14522, 14527, 14553, 14552,
   14652, 14663, 14676, 14692, 14705, 14727, 14762, 14804, 14832, 14878,
   14892, 14893, 14894, 14895, 14899, 14917, 14935, 14936, 14940, 14941,
   14942, 14943, 14947, 14948, 14966, 14979, 14980, 14981, 14987, 14993,
   15005, 15004, 15020, 15021, 15025, 15026, 15030, 15043, 15044, 15045,
   15050, 15055, 15054, 15074, 15090, 15107, 15106, 15145, 15146, 15150,
   15151, 15155, 15156, 15157, 15158, 15160, 15159, 15173, 15174, 15175,
   15176, 15177, 15183, 15188, 15194, 15205, 15216, 15220, 15230, 15235,
   15242, 15254, 15266, 15275, 15277, 15281, 15282, 15289, 15291, 15295,
   15296, 15301, 15300, 15304, 15303, 15307, 15306, 15310, 15309, 15312,
   15313, 15314, 15315, 15316, 15317, 15318, 15319, 15320, 15321, 15322,
   15323, 15324, 15325, 15326, 15327, 15328, 15329, 15330, 15331, 15332,
   15333, 15334, 15335, 15336, 15337, 15341, 15342, 15346, 15347, 15351,
   15361, 15371, 15384, 15399, 15412, 15425, 15437, 15442, 15450, 15455,
   15463, 15478, 15489, 15498, 15508, 15517, 15521, 15525, 15526, 15530,
   15557, 15559, 15563, 15567, 15571, 15578, 15579, 15583, 15584, 15588,
   15589, 15593, 15594, 15600, 15606, 15612, 15622, 15621, 15631, 15632,
   15637, 15638, 15639, 15644, 15645, 15646, 15650, 15651, 15655, 15667,
   15676, 15686, 15695, 15709, 15710, 15715, 15714, 15730, 15731, 15732,
   15736, 15737, 15741, 15741, 15765, 15766, 15770, 15771, 15772, 15776,
   15780, 15787, 15790, 15788, 15804, 15811, 15832, 15849, 15851, 15855,
   15856, 15860, 15861, 15869, 15870, 15871, 15872, 15878, 15884, 15894,
   15896, 15898, 15903, 15904, 15905, 15906, 15907, 15911, 15912, 15913,
   15914, 15915, 15916, 15926, 15927, 15932, 15945, 15958, 15960, 15962,
   15967, 15972, 15974, 15976, 15982, 15983, 15985, 15991, 15990, 16008,
   16009, 16013, 16018, 16026, 16026, 16052, 16051, 16068, 16072, 16077,
   16082, 16081, 16093, 16094, 16096, 16098, 16116, 16122, 16127, 16109,
   16190, 16208, 16233, 16265, 16270, 16278, 16301, 16229, 16367, 16387,
   16400, 16410, 16366, 16431, 16435, 16439, 16443, 16447, 16451, 16458,
   16465, 16472, 16482, 16483, 16487, 16488, 16489, 16493, 16494, 16499,
   16501, 16500, 16506, 16507, 16511, 16521
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || YYTOKEN_TABLE
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "ABORT_SYM", "ACCESSIBLE_SYM", "ACTION",
  "ADD", "ADDDATE_SYM", "AFTER_SYM", "AGAINST", "AGGREGATE_SYM",
  "ALGORITHM_SYM", "ALL", "ALTER", "ANALYSE_SYM", "ANALYZE_SYM",
  "AND_AND_SYM", "AND_SYM", "ANY_SYM", "AS", "ASC", "ASCII_SYM",
  "ASENSITIVE_SYM", "AT_SYM", "AUTOEXTEND_SIZE_SYM", "AUTO_INC",
  "AVG_ROW_LENGTH", "AVG_SYM", "BACKUP_SYM", "BEFORE_SYM", "BEGIN_SYM",
  "BETWEEN_SYM", "BIGINT", "BINARY", "BINLOG_SYM", "BIN_NUM", "BIT_AND",
  "BIT_OR", "BIT_SYM", "BIT_XOR", "BLOB_SYM", "BLOCK_SYM", "BOOLEAN_SYM",
  "BOOL_SYM", "BOTH", "BTREE_SYM", "BY", "BYTE_SYM", "CACHE_SYM",
  "CALL_SYM", "CASCADE", "CASCADED", "CASE_SYM", "CAST_SYM",
  "CATALOG_NAME_SYM", "CHAIN_SYM", "CHANGE", "CHANGED", "CHARSET",
  "CHAR_SYM", "CHECKSUM_SYM", "CHECK_SYM", "CIPHER_SYM",
  "CLASS_ORIGIN_SYM", "CLIENT_SYM", "CLOSE_SYM", "COALESCE", "CODE_SYM",
  "COLLATE_SYM", "COLLATION_SYM", "COLUMNS", "COLUMN_SYM",
  "COLUMN_FORMAT_SYM", "COLUMN_NAME_SYM", "COMMENT_SYM", "COMMITTED_SYM",
  "COMMIT_SYM", "COMPACT_SYM", "COMPLETION_SYM", "COMPRESSED_SYM",
  "CONCURRENT", "CONDITION_SYM", "CONNECTION_SYM", "CONSISTENT_SYM",
  "CONSTRAINT", "CONSTRAINT_CATALOG_SYM", "CONSTRAINT_NAME_SYM",
  "CONSTRAINT_SCHEMA_SYM", "CONTAINS_SYM", "CONTEXT_SYM", "CONTINUE_SYM",
  "CONVERT_SYM", "COUNT_SYM", "CPU_SYM", "CREATE", "CROSS", "CUBE_SYM",
  "CURDATE", "CURRENT_SYM", "CURRENT_USER", "CURSOR_SYM",
  "CURSOR_NAME_SYM", "CURTIME", "DATABASE", "DATABASES", "DATAFILE_SYM",
  "DATA_SYM", "DATETIME", "DATE_ADD_INTERVAL", "DATE_SUB_INTERVAL",
  "DATE_SYM", "DAY_HOUR_SYM", "DAY_MICROSECOND_SYM", "DAY_MINUTE_SYM",
  "DAY_SECOND_SYM", "DAY_SYM", "DEALLOCATE_SYM", "DECIMAL_NUM",
  "DECIMAL_SYM", "DECLARE_SYM", "DEFAULT", "DEFAULT_AUTH_SYM",
  "DEFINER_SYM", "DELAYED_SYM", "DELAY_KEY_WRITE_SYM", "DELETE_SYM",
  "DESC", "DESCRIBE", "DES_KEY_FILE", "DETERMINISTIC_SYM",
  "DIAGNOSTICS_SYM", "DIRECTORY_SYM", "DISABLE_SYM", "DISCARD", "DISK_SYM",
  "DISTINCT", "DIV_SYM", "DOUBLE_SYM", "DO_SYM", "DROP", "DUAL_SYM",
  "DUMPFILE", "DUPLICATE_SYM", "DYNAMIC_SYM", "EACH_SYM", "ELSE",
  "ELSEIF_SYM", "ENABLE_SYM", "ENCLOSED", "END", "ENDS_SYM",
  "END_OF_INPUT", "ENGINES_SYM", "ENGINE_SYM", "ENUM", "EQ", "EQUAL_SYM",
  "ERROR_SYM", "ERRORS", "ESCAPED", "ESCAPE_SYM", "EVENTS_SYM",
  "EVENT_SYM", "EVERY_SYM", "EXCHANGE_SYM", "EXECUTE_SYM", "EXISTS",
  "EXIT_SYM", "EXPANSION_SYM", "EXPIRE_SYM", "EXPORT_SYM", "EXTENDED_SYM",
  "EXTENT_SIZE_SYM", "EXTRACT_SYM", "FALSE_SYM", "FAST_SYM", "FAULTS_SYM",
  "FETCH_SYM", "FILE_SYM", "FIRST_SYM", "FIXED_SYM", "FLOAT_NUM",
  "FLOAT_SYM", "FLUSH_SYM", "FORCE_SYM", "FOREIGN", "FOR_SYM",
  "FORMAT_SYM", "FOUND_SYM", "FROM", "FULL", "FULLTEXT_SYM",
  "FUNCTION_SYM", "GE", "GENERAL", "GEOMETRYCOLLECTION", "GEOMETRY_SYM",
  "GET_FORMAT", "GET_SYM", "GLOBAL_SYM", "GRANT", "GRANTS", "GROUP_SYM",
  "GROUP_CONCAT_SYM", "GT_SYM", "HANDLER_SYM", "HASH_SYM", "HAVING",
  "HELP_SYM", "HEX_NUM", "HIGH_PRIORITY", "HOST_SYM", "HOSTS_SYM",
  "HOUR_MICROSECOND_SYM", "HOUR_MINUTE_SYM", "HOUR_SECOND_SYM", "HOUR_SYM",
  "IDENT", "IDENTIFIED_SYM", "IDENT_QUOTED", "IF", "IGNORE_SYM",
  "IGNORE_SERVER_IDS_SYM", "IMPORT", "INDEXES", "INDEX_SYM", "INFILE",
  "INITIAL_SIZE_SYM", "INNER_SYM", "INOUT_SYM", "INSENSITIVE_SYM",
  "INSERT", "INSERT_METHOD", "INSTALL_SYM", "INTERVAL_SYM", "INTO",
  "INT_SYM", "INVOKER_SYM", "IN_SYM", "IO_AFTER_GTIDS", "IO_BEFORE_GTIDS",
  "IO_SYM", "IPC_SYM", "IS", "ISOLATION", "ISSUER_SYM", "ITERATE_SYM",
  "JOIN_SYM", "KEYS", "KEY_BLOCK_SIZE", "KEY_SYM", "KILL_SYM",
  "LANGUAGE_SYM", "LAST_SYM", "LE", "LEADING", "LEAVES", "LEAVE_SYM",
  "LEFT", "LESS_SYM", "LEVEL_SYM", "LEX_HOSTNAME", "LIKE", "LIMIT",
  "LINEAR_SYM", "LINES", "LINESTRING", "LIST_SYM", "LOAD", "LOCAL_SYM",
  "LOCATOR_SYM", "LOCKS_SYM", "LOCK_SYM", "LOGFILE_SYM", "LOGS_SYM",
  "LONGBLOB", "LONGTEXT", "LONG_NUM", "LONG_SYM", "LOOP_SYM",
  "LOW_PRIORITY", "LT", "MASTER_AUTO_POSITION_SYM", "MASTER_BIND_SYM",
  "MASTER_CONNECT_RETRY_SYM", "MASTER_DELAY_SYM", "MASTER_HOST_SYM",
  "MASTER_LOG_FILE_SYM", "MASTER_LOG_POS_SYM", "MASTER_PASSWORD_SYM",
  "MASTER_PORT_SYM", "MASTER_RETRY_COUNT_SYM", "MASTER_SERVER_ID_SYM",
  "MASTER_SSL_CAPATH_SYM", "MASTER_SSL_CA_SYM", "MASTER_SSL_CERT_SYM",
  "MASTER_SSL_CIPHER_SYM", "MASTER_SSL_CRL_SYM", "MASTER_SSL_CRLPATH_SYM",
  "MASTER_SSL_KEY_SYM", "MASTER_SSL_SYM",
  "MASTER_SSL_VERIFY_SERVER_CERT_SYM", "MASTER_SYM", "MASTER_USER_SYM",
  "MASTER_HEARTBEAT_PERIOD_SYM", "MATCH", "MAX_CONNECTIONS_PER_HOUR",
  "MAX_QUERIES_PER_HOUR", "MAX_ROWS", "MAX_SIZE_SYM", "MAX_SYM",
  "MAX_UPDATES_PER_HOUR", "MAX_USER_CONNECTIONS_SYM", "MAX_VALUE_SYM",
  "MEDIUMBLOB", "MEDIUMINT", "MEDIUMTEXT", "MEDIUM_SYM", "MEMORY_SYM",
  "MERGE_SYM", "MESSAGE_TEXT_SYM", "MICROSECOND_SYM", "MIGRATE_SYM",
  "MINUTE_MICROSECOND_SYM", "MINUTE_SECOND_SYM", "MINUTE_SYM", "MIN_ROWS",
  "MIN_SYM", "MODE_SYM", "MODIFIES_SYM", "MODIFY_SYM", "MOD_SYM",
  "MONTH_SYM", "MULTILINESTRING", "MULTIPOINT", "MULTIPOLYGON",
  "MUTEX_SYM", "MYSQL_ERRNO_SYM", "NAMES_SYM", "NAME_SYM", "NATIONAL_SYM",
  "NATURAL", "NCHAR_STRING", "NCHAR_SYM", "NDBCLUSTER_SYM", "NE", "NEG",
  "NEW_SYM", "NEXT_SYM", "NODEGROUP_SYM", "NONE_SYM", "NOT2_SYM",
  "NOT_SYM", "NOW_SYM", "NO_SYM", "NO_WAIT_SYM", "NO_WRITE_TO_BINLOG",
  "NULL_SYM", "NUM", "NUMBER_SYM", "NUMERIC_SYM", "NVARCHAR_SYM",
  "OFFSET_SYM", "OLD_PASSWORD", "ON", "ONE_SYM", "ONLY_SYM", "OPEN_SYM",
  "OPTIMIZE", "OPTIONS_SYM", "OPTION", "OPTIONALLY", "OR2_SYM",
  "ORDER_SYM", "OR_OR_SYM", "OR_SYM", "OUTER", "OUTFILE", "OUT_SYM",
  "OWNER_SYM", "PACK_KEYS_SYM", "PAGE_SYM", "PARAM_MARKER", "PARSER_SYM",
  "PARTIAL", "PARTITION_SYM", "PARTITIONS_SYM", "PARTITIONING_SYM",
  "PASSWORD", "PHASE_SYM", "PLUGIN_DIR_SYM", "PLUGIN_SYM", "PLUGINS_SYM",
  "POINT_SYM", "POLYGON", "PORT_SYM", "POSITION_SYM", "PRECISION",
  "PREPARE_SYM", "PRESERVE_SYM", "PREV_SYM", "PRIMARY_SYM", "PRIVILEGES",
  "PROCEDURE_SYM", "PROCESS", "PROCESSLIST_SYM", "PROFILE_SYM",
  "PROFILES_SYM", "PROXY_SYM", "PURGE", "QUARTER_SYM", "QUERY_SYM",
  "QUICK", "RANGE_SYM", "READS_SYM", "READ_ONLY_SYM", "READ_SYM",
  "READ_WRITE_SYM", "REAL", "REBUILD_SYM", "RECOVER_SYM", "REDOFILE_SYM",
  "REDO_BUFFER_SIZE_SYM", "REDUNDANT_SYM", "REFERENCES", "REGEXP", "RELAY",
  "RELAYLOG_SYM", "RELAY_LOG_FILE_SYM", "RELAY_LOG_POS_SYM",
  "RELAY_THREAD", "RELEASE_SYM", "RELOAD", "REMOVE_SYM", "RENAME",
  "REORGANIZE_SYM", "REPAIR", "REPEATABLE_SYM", "REPEAT_SYM", "REPLACE",
  "REPLICATION", "REQUIRE_SYM", "RESET_SYM", "RESIGNAL_SYM", "RESOURCES",
  "RESTORE_SYM", "RESTRICT", "RESUME_SYM", "RETURNED_SQLSTATE_SYM",
  "RETURNS_SYM", "RETURN_SYM", "REVERSE_SYM", "REVOKE", "RIGHT",
  "ROLLBACK_SYM", "ROLLUP_SYM", "ROUTINE_SYM", "ROWS_SYM",
  "ROW_FORMAT_SYM", "ROW_SYM", "ROW_COUNT_SYM", "RTREE_SYM",
  "SAVEPOINT_SYM", "SCHEDULE_SYM", "SCHEMA_NAME_SYM",
  "SECOND_MICROSECOND_SYM", "SECOND_SYM", "SECURITY_SYM", "SELECT_SYM",
  "SENSITIVE_SYM", "SEPARATOR_SYM", "SERIALIZABLE_SYM", "SERIAL_SYM",
  "SESSION_SYM", "SERVER_SYM", "SERVER_OPTIONS", "SET", "SET_VAR",
  "SHARE_SYM", "SHIFT_LEFT", "SHIFT_RIGHT", "SHOW", "SHUTDOWN",
  "SIGNAL_SYM", "SIGNED_SYM", "SIMPLE_SYM", "SLAVE", "SLOW", "SMALLINT",
  "SNAPSHOT_SYM", "SOCKET_SYM", "SONAME_SYM", "SOUNDS_SYM", "SOURCE_SYM",
  "SPATIAL_SYM", "SPECIFIC_SYM", "SQLEXCEPTION_SYM", "SQLSTATE_SYM",
  "SQLWARNING_SYM", "SQL_AFTER_GTIDS", "SQL_AFTER_MTS_GAPS",
  "SQL_BEFORE_GTIDS", "SQL_BIG_RESULT", "SQL_BUFFER_RESULT",
  "SQL_CACHE_SYM", "SQL_CALC_FOUND_ROWS", "SQL_NO_CACHE_SYM",
  "SQL_SMALL_RESULT", "SQL_SYM", "SQL_THREAD", "SSL_SYM", "STARTING",
  "STARTS_SYM", "START_SYM", "STATS_AUTO_RECALC_SYM",
  "STATS_PERSISTENT_SYM", "STATS_SAMPLE_PAGES_SYM", "STATUS_SYM",
  "STDDEV_SAMP_SYM", "STD_SYM", "STOP_SYM", "STORAGE_SYM", "STRAIGHT_JOIN",
  "STRING_SYM", "SUBCLASS_ORIGIN_SYM", "SUBDATE_SYM", "SUBJECT_SYM",
  "SUBPARTITIONS_SYM", "SUBPARTITION_SYM", "SUBSTRING", "SUM_SYM",
  "SUPER_SYM", "SUSPEND_SYM", "SWAPS_SYM", "SWITCHES_SYM", "SYSDATE",
  "TABLES", "TABLESPACE", "TABLE_REF_PRIORITY", "TABLE_SYM",
  "TABLE_CHECKSUM_SYM", "TABLE_NAME_SYM", "TEMPORARY", "TEMPTABLE_SYM",
  "TERMINATED", "TEXT_STRING", "TEXT_SYM", "THAN_SYM", "THEN_SYM",
  "TIMESTAMP", "TIMESTAMP_ADD", "TIMESTAMP_DIFF", "TIME_SYM", "TINYBLOB",
  "TINYINT", "TINYTEXT", "TO_SYM", "TRAILING", "TRANSACTION_SYM",
  "TRIGGERS_SYM", "TRIGGER_SYM", "TRIM", "TRUE_SYM", "TRUNCATE_SYM",
  "TYPES_SYM", "TYPE_SYM", "UDF_RETURNS_SYM", "ULONGLONG_NUM",
  "UNCOMMITTED_SYM", "UNDEFINED_SYM", "UNDERSCORE_CHARSET", "UNDOFILE_SYM",
  "UNDO_BUFFER_SIZE_SYM", "UNDO_SYM", "UNICODE_SYM", "UNINSTALL_SYM",
  "UNION_SYM", "UNIQUE_SYM", "UNKNOWN_SYM", "UNLOCK_SYM", "UNSIGNED",
  "UNTIL_SYM", "UPDATE_SYM", "UPGRADE_SYM", "USAGE", "USER", "USE_FRM",
  "USE_SYM", "USING", "UTC_DATE_SYM", "UTC_TIMESTAMP_SYM", "UTC_TIME_SYM",
  "VALUES", "VALUE_SYM", "VARBINARY", "VARCHAR", "VARIABLES",
  "VARIANCE_SYM", "VARYING", "VAR_SAMP_SYM", "VIEW_SYM", "WAIT_SYM",
  "WARNINGS", "WEEK_SYM", "WEIGHT_STRING_SYM", "WHEN_SYM", "WHERE",
  "WHILE_SYM", "WITH", "WITH_CUBE_SYM", "WITH_ROLLUP_SYM", "WORK_SYM",
  "WRAPPER_SYM", "WRITE_SYM", "X509_SYM", "XA_SYM", "XML_SYM", "XOR",
  "YEAR_MONTH_SYM", "YEAR_SYM", "ZEROFILL", "'|'", "'&'", "'-'", "'+'",
  "'*'", "'/'", "'%'", "'^'", "'~'", "'('", "')'", "','", "'!'", "'{'",
  "'}'", "';'", "'@'", "'.'", "':'", "$accept", "query", "$@1",
  "opt_end_of_input", "verb_clause", "statement", "deallocate",
  "deallocate_or_drop", "prepare", "prepare_src", "execute", "$@2",
  "execute_using", "execute_var_list", "execute_var_ident", "help", "$@3",
  "change", "$@4", "master_defs", "master_def", "ignore_server_id_list",
  "ignore_server_id", "master_file_def", "create", "$@5", "$@6", "$@7",
  "$@8", "$@9", "$@10", "$@11", "$@12", "$@13", "server_def",
  "server_options_list", "server_option", "event_tail", "$@14",
  "ev_schedule_time", "$@15", "opt_ev_status", "ev_starts", "ev_ends",
  "opt_ev_on_completion", "ev_on_completion", "opt_ev_comment",
  "ev_sql_stmt", "$@16", "ev_sql_stmt_inner", "clear_privileges",
  "sp_name", "sp_a_chistics", "sp_c_chistics", "sp_chistic",
  "sp_c_chistic", "sp_suid", "call", "$@17", "opt_sp_cparam_list",
  "opt_sp_cparams", "sp_cparams", "sp_fdparam_list", "sp_fdparams",
  "sp_init_param", "sp_fdparam", "sp_pdparam_list", "sp_pdparams",
  "sp_pdparam", "sp_opt_inout", "sp_proc_stmts", "sp_proc_stmts1",
  "sp_decls", "sp_decl", "$@18", "$@19", "$@20", "sp_handler_type",
  "sp_hcond_list", "sp_hcond_element", "sp_cond", "sqlstate", "opt_value",
  "sp_hcond", "signal_stmt", "signal_value", "opt_signal_value",
  "opt_set_signal_information", "signal_information_item_list",
  "signal_allowed_expr", "signal_condition_information_item_name",
  "resignal_stmt", "get_diagnostics", "which_area",
  "diagnostics_information", "statement_information",
  "statement_information_item", "simple_target_specification",
  "statement_information_item_name", "condition_number",
  "condition_information", "condition_information_item",
  "condition_information_item_name", "sp_decl_idents", "sp_opt_default",
  "$@21", "sp_proc_stmt", "sp_proc_stmt_if", "$@22",
  "sp_proc_stmt_statement", "$@23", "sp_proc_stmt_return", "$@24",
  "sp_proc_stmt_unlabeled", "$@25", "sp_proc_stmt_leave",
  "sp_proc_stmt_iterate", "sp_proc_stmt_open", "sp_proc_stmt_fetch",
  "$@26", "sp_proc_stmt_close", "sp_opt_fetch_noise", "sp_fetch_list",
  "sp_if", "$@27", "$@28", "$@29", "sp_elseifs", "case_stmt_specification",
  "simple_case_stmt", "$@30", "$@31", "searched_case_stmt", "$@32",
  "simple_when_clause_list", "searched_when_clause_list",
  "simple_when_clause", "$@33", "$@34", "searched_when_clause", "$@35",
  "$@36", "else_clause_opt", "sp_labeled_control", "$@37", "sp_opt_label",
  "sp_labeled_block", "$@38", "sp_unlabeled_block", "$@39",
  "sp_block_content", "$@40", "sp_unlabeled_control", "$@41", "$@42",
  "$@43", "$@44", "trg_action_time", "trg_event",
  "change_tablespace_access", "change_tablespace_info", "tablespace_info",
  "opt_logfile_group_name", "alter_tablespace_info", "logfile_group_info",
  "alter_logfile_group_info", "add_log_file", "change_ts_option_list",
  "$@45", "change_ts_options", "change_ts_option",
  "tablespace_option_list", "tablespace_options", "tablespace_option",
  "alter_tablespace_option_list", "alter_tablespace_options",
  "alter_tablespace_option", "logfile_group_option_list",
  "logfile_group_options", "logfile_group_option",
  "alter_logfile_group_option_list", "alter_logfile_group_options",
  "alter_logfile_group_option", "ts_datafile", "lg_undofile",
  "lg_redofile", "tablespace_name", "logfile_group_name", "ts_access_mode",
  "opt_ts_initial_size", "opt_ts_autoextend_size", "opt_ts_max_size",
  "opt_ts_extent_size", "opt_ts_undo_buffer_size",
  "opt_ts_redo_buffer_size", "opt_ts_nodegroup", "opt_ts_comment",
  "opt_ts_engine", "ts_wait", "size_number", "create2", "create2a", "$@46",
  "create3", "$@47", "$@48", "opt_create_partitioning", "opt_partitioning",
  "partitioning", "$@49", "have_partitioning", "partition_entry", "$@50",
  "partition", "part_type_def", "$@51", "opt_linear", "opt_key_algo",
  "part_field_list", "part_field_item_list", "part_field_item",
  "part_column_list", "part_func", "sub_part_func", "opt_num_parts",
  "opt_sub_part", "$@52", "$@53", "sub_part_field_list",
  "sub_part_field_item", "part_func_expr", "opt_num_subparts", "part_defs",
  "part_def_list", "part_definition", "$@54", "part_name",
  "opt_part_values", "$@55", "$@56", "part_func_max", "part_values_in",
  "part_value_list", "part_value_item", "$@57", "$@58",
  "part_value_item_list", "part_value_expr_item", "opt_sub_partition",
  "sub_part_list", "sub_part_definition", "$@59", "sub_name",
  "opt_part_options", "opt_part_option_list", "opt_part_option",
  "create_select", "$@60", "$@61", "opt_as", "opt_create_database_options",
  "create_database_options", "create_database_option", "opt_table_options",
  "table_options", "table_option", "opt_if_not_exists",
  "opt_create_table_options", "create_table_options_space_separated",
  "create_table_options", "create_table_option", "$@62", "default_charset",
  "default_collation", "storage_engines", "known_storage_engines",
  "row_types", "merge_insert_types", "opt_select_from", "udf_type",
  "create_field_list", "field_list", "field_list_item", "column_def",
  "key_def", "opt_check_constraint", "check_constraint", "opt_constraint",
  "constraint", "field_spec", "$@63", "type", "$@64", "$@65",
  "spatial_type", "char", "nchar", "varchar", "nvarchar", "int_type",
  "real_type", "float_options", "precision", "type_datetime_precision",
  "func_datetime_precision", "field_options", "field_opt_list",
  "field_option", "field_length", "opt_field_length", "opt_precision",
  "opt_attribute", "opt_attribute_list", "attribute",
  "type_with_opt_collate", "now", "now_or_signed_literal", "charset",
  "charset_name", "charset_name_or_default", "opt_load_data_charset",
  "old_or_new_charset_name", "old_or_new_charset_name_or_default",
  "collation_name", "opt_collate", "collation_name_or_default",
  "opt_default", "ascii", "unicode", "opt_binary", "opt_bin_mod",
  "ws_nweights", "$@66", "ws_level_flag_desc", "ws_level_flag_reverse",
  "ws_level_flags", "ws_level_number", "ws_level_list_item",
  "ws_level_list", "ws_level_range", "ws_level_list_or_range",
  "opt_ws_levels", "opt_primary", "references", "opt_ref_list", "ref_list",
  "opt_match_clause", "opt_on_update_delete", "delete_option",
  "normal_key_type", "constraint_key_type", "key_or_index",
  "opt_key_or_index", "keys_or_index", "opt_unique", "fulltext", "spatial",
  "init_key_options", "key_alg", "normal_key_options",
  "fulltext_key_options", "spatial_key_options", "normal_key_opts",
  "spatial_key_opts", "fulltext_key_opts", "key_using_alg", "all_key_opt",
  "normal_key_opt", "spatial_key_opt", "fulltext_key_opt",
  "btree_or_rtree", "key_list", "key_part", "opt_ident", "opt_component",
  "string_list", "alter", "$@67", "$@68", "$@69", "$@70", "$@71", "$@72",
  "$@73", "alter_user_list", "ev_alter_on_schedule_completion",
  "opt_ev_rename_to", "opt_ev_sql_stmt", "ident_or_empty",
  "alter_commands", "$@74", "$@75", "$@76", "remove_partitioning",
  "all_or_alt_part_name_list", "add_partition_rule", "$@77",
  "add_part_extra", "reorg_partition_rule", "$@78", "reorg_parts_rule",
  "$@79", "alt_part_name_list", "alt_part_name_item", "alter_list",
  "add_column", "alter_list_item", "$@80", "$@81", "$@82",
  "opt_index_lock_algorithm", "alter_algorithm_option",
  "alter_lock_option", "opt_column", "opt_ignore", "opt_restrict",
  "opt_place", "opt_to", "slave", "$@83", "start",
  "opt_start_transaction_option_list", "start_transaction_option_list",
  "start_transaction_option", "slave_connection_opts",
  "slave_user_name_opt", "slave_user_pass_opt", "slave_plugin_auth_opt",
  "slave_plugin_dir_opt", "opt_slave_thread_option_list",
  "slave_thread_option_list", "slave_thread_option", "slave_until",
  "slave_until_opts", "checksum", "$@84", "opt_checksum_type", "repair",
  "$@85", "opt_mi_repair_type", "mi_repair_types", "mi_repair_type",
  "analyze", "$@86", "binlog_base64_event", "check", "$@87",
  "opt_mi_check_type", "mi_check_types", "mi_check_type", "optimize",
  "$@88", "opt_no_write_to_binlog", "rename", "$@89", "rename_list",
  "table_to_table_list", "table_to_table", "keycache", "$@90",
  "keycache_list_or_parts", "keycache_list", "assign_to_keycache",
  "assign_to_keycache_parts", "key_cache_name", "preload", "$@91",
  "preload_list_or_parts", "preload_list", "preload_keys",
  "preload_keys_parts", "adm_partition", "$@92", "cache_keys_spec", "$@93",
  "cache_key_list_or_empty", "opt_ignore_leaves", "select", "select_init",
  "select_paren", "select_paren_derived", "select_init2", "$@94",
  "select_part2", "$@95", "$@96", "select_into", "select_from",
  "select_options", "select_option_list", "select_option",
  "select_lock_type", "select_item_list", "select_item", "remember_name",
  "remember_end", "select_alias", "optional_braces", "expr", "bool_pri",
  "predicate", "bit_expr", "or", "and", "not", "not2", "comp_op",
  "all_or_any", "simple_expr", "function_call_keyword",
  "function_call_nonkeyword", "function_call_conflict",
  "geometry_function", "function_call_generic", "@97", "fulltext_options",
  "opt_natural_language_mode", "opt_query_expansion", "opt_udf_expr_list",
  "udf_expr_list", "udf_expr", "sum_expr", "$@98", "$@99", "$@100",
  "variable", "$@101", "variable_aux", "opt_distinct",
  "opt_gconcat_separator", "opt_gorder_clause", "in_sum_expr", "$@102",
  "cast_type", "opt_expr_list", "expr_list", "ident_list_arg",
  "ident_list", "opt_expr", "opt_else", "when_list", "table_ref",
  "join_table_list", "esc_table_ref", "derived_table_list", "join_table",
  "$@103", "$@104", "$@105", "$@106", "$@107", "$@108", "$@109",
  "normal_join", "opt_use_partition", "use_partition", "table_factor",
  "$@110", "select_derived_union", "$@111", "$@112",
  "select_init2_derived", "select_part2_derived", "$@113", "$@114",
  "select_derived", "$@115", "select_derived2", "$@116", "$@117",
  "get_select_lex", "select_derived_init", "opt_outer",
  "index_hint_clause", "index_hint_type", "index_hint_definition", "$@118",
  "$@119", "index_hints_list", "opt_index_hints_list", "$@120",
  "opt_key_definition", "$@121", "opt_key_usage_list", "key_usage_element",
  "key_usage_list", "using_list", "interval", "interval_time_stamp",
  "date_time_type", "table_alias", "opt_table_alias", "opt_all",
  "where_clause", "$@122", "having_clause", "$@123", "opt_escape",
  "group_clause", "group_list", "olap_opt", "alter_order_clause",
  "alter_order_list", "alter_order_item", "opt_order_clause",
  "order_clause", "$@124", "order_list", "order_dir",
  "opt_limit_clause_init", "opt_limit_clause", "limit_clause",
  "limit_options", "limit_option", "delete_limit_clause", "ulong_num",
  "real_ulong_num", "ulonglong_num", "real_ulonglong_num", "dec_num_error",
  "dec_num", "procedure_analyse_clause", "$@125",
  "opt_procedure_analyse_params", "procedure_analyse_param",
  "select_var_list_init", "$@126", "select_var_list", "select_var_ident",
  "into", "$@127", "into_destination", "$@128", "$@129", "do", "$@130",
  "drop", "$@131", "$@132", "$@133", "$@134", "table_list", "table_name",
  "table_name_with_opt_use_partition", "table_alias_ref_list",
  "table_alias_ref", "if_exists", "opt_temporary", "drop_ts_options_list",
  "drop_ts_options", "drop_ts_option", "insert", "$@135", "$@136",
  "replace", "$@137", "$@138", "insert_lock_option", "replace_lock_option",
  "insert2", "insert_table", "insert_field_spec", "$@139", "fields",
  "insert_values", "$@140", "$@141", "values_list", "ident_eq_list",
  "ident_eq_value", "equal", "opt_equal", "no_braces", "$@142",
  "opt_values", "values", "expr_or_default", "opt_insert_update", "$@143",
  "update", "$@144", "$@145", "update_list", "update_elem",
  "insert_update_list", "insert_update_elem", "opt_low_priority", "delete",
  "$@146", "single_multi", "$@147", "$@148", "$@149", "table_wild_list",
  "table_wild_one", "opt_wild", "opt_delete_options", "opt_delete_option",
  "truncate", "$@150", "opt_table_sym", "opt_profile_defs", "profile_defs",
  "profile_def", "opt_profile_args", "show", "$@151", "show_param",
  "$@152", "$@153", "show_engine_param", "master_or_binary", "opt_storage",
  "opt_db", "opt_full", "from_or_in", "binlog_in", "binlog_from",
  "wild_and_where", "describe", "$@154", "$@155", "explanable_command",
  "describe_command", "opt_extended_describe", "opt_describe_column",
  "flush", "$@156", "flush_options", "$@157", "$@158", "opt_flush_lock",
  "$@159", "flush_options_list", "flush_option", "opt_table_list", "reset",
  "$@160", "reset_options", "reset_option", "$@161", "slave_reset_options",
  "purge", "$@162", "purge_options", "purge_option", "kill", "kill_option",
  "use", "load", "$@163", "$@164", "$@165", "$@166", "data_or_xml",
  "opt_local", "load_data_lock", "opt_duplicate", "opt_field_term",
  "field_term_list", "field_term", "opt_line_term", "line_term_list",
  "line_term", "opt_xml_rows_identified_by", "opt_ignore_lines",
  "lines_or_rows", "opt_field_or_var_spec", "fields_or_vars",
  "field_or_var", "opt_load_data_set_spec", "load_data_set_list",
  "load_data_set_elem", "text_literal", "text_string", "param_marker",
  "signed_literal", "literal", "NUM_literal", "temporal_literal",
  "insert_ident", "table_wild", "order_ident", "simple_ident",
  "simple_ident_nospvar", "simple_ident_q", "field_ident", "table_ident",
  "table_ident_opt_wild", "table_ident_nodb", "IDENT_sys",
  "TEXT_STRING_sys_nonewline", "TEXT_STRING_sys", "TEXT_STRING_literal",
  "TEXT_STRING_filesystem", "ident", "label_ident", "ident_or_text",
  "user", "keyword", "keyword_sp", "set", "$@167",
  "start_option_value_list", "$@168", "$@169", "$@170",
  "start_option_value_list_following_option_type", "$@171",
  "option_value_list_continued", "option_value_list", "$@172", "$@173",
  "option_value", "$@174", "option_type", "opt_var_type",
  "opt_var_ident_type", "option_value_following_option_type",
  "option_value_no_option_type", "$@175", "internal_variable_name",
  "transaction_characteristics", "transaction_access_mode",
  "isolation_level", "transaction_access_mode_types", "isolation_types",
  "text_or_password", "set_expr_or_default", "lock", "$@176",
  "table_or_tables", "table_lock_list", "table_lock", "lock_option",
  "unlock", "$@177", "handler", "$@178", "handler_read_or_scan",
  "handler_scan_function", "handler_rkey_function", "$@179",
  "handler_rkey_mode", "revoke", "revoke_command", "grant",
  "grant_command", "opt_table", "grant_privileges", "opt_privileges",
  "object_privilege_list", "object_privilege", "$@180", "$@181", "$@182",
  "$@183", "opt_and", "require_list", "require_list_element",
  "grant_ident", "user_list", "grant_list", "grant_user",
  "opt_column_list", "column_list", "column_list_id", "require_clause",
  "grant_options", "opt_grant_option", "grant_option_list", "grant_option",
  "begin", "$@184", "opt_work", "opt_chain", "opt_release",
  "opt_savepoint", "commit", "rollback", "savepoint", "release",
  "union_clause", "union_list", "$@185", "union_opt",
  "opt_union_order_or_limit", "union_order_or_limit", "$@186",
  "order_or_limit", "union_option", "query_specification",
  "query_expression_body", "$@187", "subselect", "subselect_start",
  "subselect_end", "opt_query_expression_options",
  "query_expression_option_list", "query_expression_option",
  "view_or_trigger_or_sp_or_event", "definer_tail", "no_definer_tail",
  "definer_opt", "no_definer", "definer", "view_replace_or_algorithm",
  "view_replace", "view_algorithm", "view_suid", "view_tail", "$@188",
  "view_list_opt", "view_list", "view_select", "$@189", "view_select_aux",
  "$@190", "create_view_select_paren", "create_view_select", "$@191",
  "view_check_option", "trigger_tail", "$@192", "$@193", "$@194",
  "udf_tail", "sf_tail", "$@195", "$@196", "$@197", "$@198", "$@199",
  "sp_tail", "$@200", "$@201", "$@202", "$@203", "xa", "xid",
  "begin_or_start", "opt_join_or_resume", "opt_one_phase", "opt_suspend",
  "$@204", "opt_migrate", "install", "uninstall", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,   750,   751,   752,   753,   754,
     755,   756,   757,   758,   759,   760,   761,   762,   763,   764,
     765,   766,   767,   768,   769,   770,   771,   772,   773,   774,
     775,   776,   777,   778,   779,   780,   781,   782,   783,   784,
     785,   786,   787,   788,   789,   790,   791,   792,   793,   794,
     795,   796,   797,   798,   799,   800,   801,   802,   803,   804,
     805,   806,   807,   808,   809,   810,   811,   812,   813,   814,
     815,   816,   817,   818,   819,   820,   821,   822,   823,   824,
     825,   826,   827,   828,   829,   830,   831,   832,   833,   834,
     835,   836,   837,   838,   839,   840,   841,   842,   843,   844,
     845,   846,   847,   848,   849,   850,   851,   852,   853,   854,
     855,   856,   857,   858,   859,   860,   861,   862,   863,   864,
     865,   866,   867,   868,   869,   870,   871,   872,   873,   874,
     875,   124,    38,    45,    43,    42,    47,    37,    94,   126,
      40,    41,    44,    33,   123,   125,    59,    64,    46,    58
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint16 yyr1[] =
{
       0,   640,   641,   642,   641,   641,   643,   643,   644,   644,
     645,   645,   645,   645,   645,   645,   645,   645,   645,   645,
     645,   645,   645,   645,   645,   645,   645,   645,   645,   645,
     645,   645,   645,   645,   645,   645,   645,   645,   645,   645,
     645,   645,   645,   645,   645,   645,   645,   645,   645,   645,
     645,   645,   645,   645,   645,   645,   645,   645,   645,   645,
     645,   645,   646,   647,   647,   648,   649,   649,   651,   650,
     652,   652,   653,   653,   654,   656,   655,   658,   657,   659,
     659,   660,   660,   660,   660,   660,   660,   660,   660,   660,
     660,   660,   660,   660,   660,   660,   660,   660,   660,   660,
     660,   660,   661,   661,   661,   662,   663,   663,   663,   663,
     665,   664,   666,   667,   664,   668,   669,   664,   670,   671,
     664,   672,   664,   673,   664,   664,   664,   664,   664,   674,
     675,   675,   676,   676,   676,   676,   676,   676,   676,   678,
     677,   680,   679,   679,   681,   681,   681,   681,   682,   682,
     683,   683,   684,   684,   685,   685,   686,   686,   688,   687,
     689,   689,   689,   689,   689,   689,   689,   689,   689,   689,
     689,   689,   689,   690,   691,   691,   692,   692,   693,   693,
     694,   694,   694,   694,   694,   694,   694,   695,   695,   695,
     696,   696,   698,   697,   699,   699,   700,   700,   701,   701,
     702,   702,   703,   703,   704,   705,   706,   706,   707,   707,
     708,   709,   709,   709,   709,   710,   710,   711,   711,   712,
     712,   714,   713,   713,   715,   713,   716,   713,   717,   717,
     718,   718,   719,   720,   720,   721,   722,   722,   723,   723,
     723,   723,   723,   724,   725,   725,   726,   726,   727,   727,
     728,   728,   729,   729,   729,   730,   730,   730,   730,   730,
     730,   730,   730,   730,   730,   730,   730,   731,   732,   733,
     733,   734,   734,   735,   735,   736,   737,   737,   738,   738,
     739,   740,   740,   741,   742,   742,   742,   742,   742,   742,
     742,   742,   742,   742,   742,   742,   742,   743,   743,   744,
     745,   744,   746,   746,   746,   746,   746,   746,   746,   746,
     746,   746,   746,   746,   746,   748,   747,   750,   749,   752,
     751,   754,   753,   755,   756,   757,   759,   758,   760,   761,
     761,   761,   762,   762,   764,   765,   766,   763,   767,   767,
     767,   768,   768,   770,   771,   769,   773,   772,   774,   774,
     775,   775,   777,   778,   776,   780,   781,   779,   782,   782,
     784,   783,   785,   785,   787,   786,   789,   788,   791,   790,
     792,   793,   794,   792,   795,   796,   792,   797,   797,   798,
     798,   798,   799,   800,   801,   802,   802,   803,   803,   804,
     805,   806,   806,   808,   807,   809,   809,   809,   810,   810,
     810,   811,   811,   812,   812,   812,   813,   813,   813,   813,
     813,   813,   813,   813,   814,   814,   815,   815,   815,   816,
     816,   816,   816,   816,   817,   817,   818,   818,   818,   819,
     819,   819,   819,   819,   819,   819,   820,   820,   821,   821,
     821,   822,   822,   822,   823,   824,   825,   826,   827,   828,
     828,   828,   829,   830,   831,   832,   833,   834,   835,   836,
     837,   838,   838,   839,   839,   840,   840,   840,   840,   841,
     842,   841,   843,   844,   843,   845,   843,   846,   847,   847,
     849,   848,   850,   852,   851,   853,   854,   855,   854,   854,
     854,   854,   854,   856,   856,   857,   857,   858,   858,   859,
     859,   860,   861,   862,   863,   864,   864,   865,   866,   865,
     867,   865,   868,   868,   869,   870,   871,   871,   872,   872,
     873,   873,   875,   874,   876,   877,   878,   877,   879,   877,
     880,   880,   881,   881,   882,   882,   884,   885,   883,   886,
     886,   887,   887,   888,   888,   889,   889,   891,   890,   892,
     893,   893,   894,   894,   895,   895,   895,   895,   895,   895,
     895,   895,   897,   898,   896,   899,   899,   900,   900,   901,
     901,   902,   902,   903,   903,   904,   904,   905,   906,   906,
     907,   907,   908,   908,   909,   909,   909,   910,   910,   910,
     910,   910,   910,   910,   910,   910,   910,   910,   910,   910,
     910,   910,   910,   910,   910,   910,   911,   910,   910,   910,
     910,   910,   910,   910,   910,   910,   910,   910,   912,   913,
     914,   915,   916,   916,   916,   916,   916,   916,   917,   917,
     917,   918,   918,   919,   919,   919,   919,   920,   921,   921,
     922,   922,   923,   923,   924,   924,   924,   924,   924,   924,
     925,   925,   926,   927,   927,   928,   930,   929,   931,   931,
     931,   931,   931,   931,   931,   931,   931,   931,   931,   931,
     931,   931,   931,   931,   931,   931,   931,   931,   931,   931,
     931,   931,   931,   931,   931,   931,   931,   931,   931,   931,
     931,   931,   931,   932,   931,   933,   931,   931,   931,   934,
     934,   934,   934,   934,   934,   934,   934,   935,   936,   936,
     937,   937,   938,   938,   938,   938,   938,   939,   939,   939,
     939,   939,   940,   940,   940,   941,   941,   941,   942,   943,
     943,   944,   944,   944,   945,   945,   946,   946,   947,   947,
     947,   948,   948,   948,   948,   949,   949,   950,   950,   951,
     951,   952,   952,   953,   953,   953,   953,   953,   953,   953,
     953,   953,   953,   953,   953,   953,   953,   953,   953,   953,
     954,   955,   956,   956,   957,   957,   958,   958,   959,   959,
     960,   960,   961,   961,   962,   962,   963,   964,   964,   965,
     965,   966,   966,   967,   967,   967,   968,   968,   968,   969,
     969,   969,   969,   969,   969,   969,   970,   970,   972,   971,
     973,   973,   974,   975,   975,   975,   975,   976,   977,   978,
     978,   979,   980,   980,   981,   981,   982,   982,   983,   984,
     984,   985,   985,   986,   986,   986,   986,   987,   987,   987,
     987,   987,   988,   988,   988,   988,   988,   989,   990,   990,
     991,   991,   992,   992,   993,   993,   993,   994,   994,   995,
     996,   997,   998,   998,   999,   999,  1000,  1000,  1001,  1001,
    1002,  1002,  1003,  1003,  1004,  1004,  1005,  1005,  1006,  1006,
    1007,  1007,  1008,  1009,  1009,  1010,  1010,  1010,  1011,  1011,
    1012,  1012,  1013,  1013,  1014,  1014,  1015,  1015,  1017,  1016,
    1018,  1016,  1016,  1019,  1016,  1020,  1016,  1021,  1016,  1022,
    1016,  1023,  1016,  1016,  1016,  1016,  1016,  1016,  1016,  1024,
    1024,  1025,  1025,  1025,  1025,  1026,  1026,  1027,  1027,  1028,
    1028,  1029,  1029,  1029,  1029,  1029,  1029,  1029,  1029,  1029,
    1029,  1030,  1029,  1029,  1031,  1029,  1032,  1029,  1029,  1029,
    1029,  1029,  1033,  1034,  1034,  1036,  1035,  1037,  1037,  1037,
    1039,  1038,  1040,  1041,  1040,  1042,  1042,  1043,  1044,  1044,
    1045,  1046,  1046,  1046,  1047,  1046,  1048,  1049,  1046,  1046,
    1046,  1046,  1046,  1046,  1046,  1046,  1046,  1046,  1046,  1046,
    1046,  1046,  1046,  1046,  1050,  1050,  1050,  1050,  1050,  1051,
    1051,  1052,  1052,  1053,  1053,  1054,  1054,  1055,  1055,  1055,
    1056,  1056,  1056,  1057,  1057,  1057,  1057,  1059,  1058,  1058,
    1060,  1061,  1061,  1062,  1062,  1063,  1063,  1063,  1064,  1065,
    1065,  1066,  1066,  1067,  1067,  1068,  1068,  1069,  1069,  1070,
    1070,  1071,  1071,  1072,  1072,  1073,  1073,  1073,  1073,  1073,
    1075,  1074,  1076,  1076,  1076,  1078,  1077,  1079,  1079,  1080,
    1080,  1081,  1081,  1081,  1083,  1082,  1084,  1086,  1085,  1087,
    1087,  1088,  1088,  1089,  1089,  1089,  1089,  1089,  1089,  1091,
    1090,  1092,  1092,  1092,  1094,  1093,  1093,  1095,  1095,  1096,
    1096,  1097,  1099,  1098,  1100,  1100,  1101,  1101,  1102,  1103,
    1104,  1104,  1106,  1105,  1107,  1107,  1108,  1108,  1109,  1110,
    1112,  1111,  1114,  1113,  1115,  1115,  1116,  1116,  1117,  1118,
    1118,  1119,  1119,  1120,  1120,  1122,  1121,  1124,  1125,  1123,
    1126,  1126,  1126,  1126,  1126,  1127,  1127,  1128,  1128,  1129,
    1129,  1130,  1130,  1130,  1131,  1131,  1131,  1132,  1132,  1132,
    1133,  1133,  1134,  1135,  1136,  1136,  1136,  1136,  1136,  1137,
    1137,  1138,  1138,  1138,  1138,  1138,  1138,  1138,  1138,  1138,
    1138,  1138,  1139,  1139,  1139,  1139,  1139,  1139,  1140,  1140,
    1140,  1140,  1140,  1140,  1140,  1140,  1140,  1140,  1140,  1140,
    1140,  1140,  1141,  1141,  1141,  1141,  1141,  1141,  1141,  1141,
    1141,  1141,  1141,  1141,  1141,  1141,  1141,  1142,  1142,  1143,
    1143,  1144,  1144,  1145,  1145,  1146,  1146,  1146,  1146,  1146,
    1146,  1147,  1147,  1148,  1148,  1148,  1148,  1148,  1148,  1148,
    1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,
    1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,  1148,
    1148,  1148,  1148,  1149,  1149,  1149,  1149,  1149,  1149,  1149,
    1149,  1149,  1149,  1149,  1149,  1149,  1149,  1149,  1149,  1149,
    1149,  1149,  1149,  1149,  1149,  1149,  1149,  1149,  1149,  1149,
    1150,  1150,  1150,  1150,  1150,  1150,  1150,  1150,  1150,  1150,
    1150,  1150,  1150,  1150,  1150,  1150,  1150,  1150,  1150,  1150,
    1150,  1150,  1151,  1151,  1151,  1151,  1151,  1151,  1151,  1151,
    1151,  1151,  1151,  1151,  1151,  1151,  1151,  1151,  1151,  1151,
    1151,  1151,  1151,  1151,  1151,  1151,  1151,  1152,  1152,  1152,
    1152,  1152,  1152,  1152,  1152,  1154,  1153,  1153,  1155,  1155,
    1156,  1156,  1157,  1157,  1158,  1158,  1159,  1159,  1160,  1161,
    1161,  1161,  1161,  1161,  1161,  1161,  1162,  1163,  1161,  1161,
    1161,  1161,  1161,  1161,  1161,  1161,  1161,  1161,  1161,  1164,
    1161,  1166,  1165,  1167,  1167,  1167,  1168,  1168,  1169,  1169,
    1170,  1170,  1172,  1171,  1173,  1173,  1173,  1173,  1173,  1173,
    1173,  1173,  1173,  1173,  1173,  1174,  1174,  1175,  1175,  1176,
    1176,  1177,  1177,  1178,  1178,  1179,  1179,  1180,  1180,  1181,
    1181,  1182,  1183,  1183,  1184,  1184,  1185,  1185,  1186,  1185,
    1187,  1185,  1188,  1185,  1185,  1189,  1185,  1190,  1185,  1185,
    1191,  1185,  1192,  1185,  1185,  1193,  1193,  1193,  1194,  1194,
    1195,  1197,  1196,  1196,  1196,  1198,  1199,  1200,  1198,  1201,
    1203,  1204,  1202,  1206,  1205,  1208,  1209,  1207,  1210,  1211,
    1212,  1212,  1213,  1213,  1213,  1213,  1214,  1214,  1216,  1215,
    1217,  1215,  1218,  1218,  1219,  1220,  1219,  1222,  1221,  1223,
    1223,  1224,  1224,  1225,  1225,  1226,  1226,  1227,  1227,  1227,
    1227,  1227,  1227,  1227,  1227,  1227,  1227,  1227,  1227,  1228,
    1228,  1228,  1228,  1228,  1228,  1228,  1228,  1228,  1229,  1229,
    1229,  1229,  1230,  1230,  1230,  1231,  1231,  1232,  1232,  1233,
    1234,  1233,  1235,  1236,  1235,  1237,  1237,  1238,  1238,  1239,
    1239,  1240,  1240,  1240,  1241,  1242,  1242,  1243,  1244,  1244,
    1246,  1245,  1247,  1247,  1248,  1248,  1248,  1249,  1249,  1250,
    1250,  1251,  1252,  1252,  1252,  1253,  1253,  1253,  1253,  1253,
    1254,  1254,  1255,  1255,  1255,  1255,  1255,  1255,  1256,  1256,
    1256,  1256,  1256,  1257,  1257,  1257,  1257,  1257,  1258,  1258,
    1258,  1258,  1259,  1260,  1260,  1261,  1262,  1261,  1263,  1263,
    1263,  1264,  1266,  1265,  1267,  1267,  1268,  1268,  1270,  1269,
    1272,  1273,  1271,  1271,  1271,  1275,  1274,  1277,  1276,  1278,
    1279,  1276,  1276,  1276,  1276,  1276,  1276,  1280,  1276,  1276,
    1276,  1276,  1276,  1276,  1281,  1281,  1282,  1283,  1284,  1284,
    1285,  1286,  1286,  1287,  1287,  1288,  1288,  1289,  1289,  1289,
    1290,  1290,  1292,  1293,  1291,  1295,  1296,  1294,  1297,  1297,
    1297,  1297,  1298,  1298,  1299,  1299,  1300,  1301,  1301,  1301,
    1302,  1301,  1303,  1303,  1304,  1304,  1305,  1304,  1306,  1304,
    1307,  1307,  1308,  1308,  1309,  1310,  1310,  1311,  1311,  1313,
    1312,  1314,  1314,  1315,  1315,  1316,  1316,  1317,  1318,  1317,
    1320,  1321,  1319,  1322,  1322,  1323,  1324,  1324,  1325,  1326,
    1326,  1328,  1327,  1330,  1329,  1331,  1329,  1332,  1329,  1333,
    1333,  1334,  1334,  1335,  1335,  1336,  1336,  1337,  1337,  1337,
    1339,  1338,  1340,  1340,  1341,  1341,  1342,  1342,  1343,  1343,
    1343,  1343,  1343,  1343,  1343,  1343,  1343,  1344,  1344,  1346,
    1345,  1347,  1347,  1347,  1347,  1347,  1347,  1347,  1347,  1347,
    1347,  1347,  1347,  1348,  1347,  1349,  1347,  1347,  1347,  1347,
    1347,  1347,  1347,  1347,  1347,  1347,  1347,  1347,  1347,  1347,
    1347,  1347,  1347,  1347,  1347,  1347,  1347,  1347,  1347,  1347,
    1347,  1347,  1347,  1347,  1347,  1347,  1350,  1350,  1350,  1351,
    1351,  1352,  1352,  1353,  1353,  1354,  1354,  1355,  1355,  1356,
    1356,  1357,  1357,  1358,  1358,  1358,  1360,  1359,  1361,  1359,
    1362,  1362,  1362,  1362,  1362,  1363,  1363,  1364,  1364,  1364,
    1364,  1365,  1365,  1365,  1367,  1366,  1369,  1370,  1368,  1368,
    1371,  1371,  1372,  1371,  1373,  1373,  1374,  1374,  1374,  1374,
    1374,  1374,  1374,  1374,  1374,  1374,  1374,  1374,  1374,  1375,
    1375,  1377,  1376,  1378,  1378,  1380,  1379,  1379,  1379,  1381,
    1381,  1383,  1382,  1384,  1385,  1385,  1386,  1387,  1387,  1387,
    1388,  1390,  1391,  1392,  1393,  1389,  1394,  1394,  1395,  1395,
    1396,  1396,  1396,  1397,  1397,  1397,  1398,  1398,  1399,  1399,
    1400,  1400,  1400,  1400,  1401,  1401,  1402,  1402,  1403,  1403,
    1404,  1404,  1405,  1405,  1406,  1406,  1407,  1407,  1407,  1408,
    1408,  1409,  1409,  1410,  1410,  1411,  1411,  1412,  1413,  1413,
    1413,  1413,  1414,  1414,  1414,  1415,  1416,  1416,  1416,  1417,
    1417,  1417,  1417,  1417,  1417,  1417,  1417,  1417,  1417,  1418,
    1418,  1418,  1418,  1418,  1419,  1419,  1419,  1420,  1420,  1421,
    1421,  1422,  1423,  1423,  1424,  1424,  1425,  1425,  1425,  1426,
    1426,  1426,  1426,  1427,  1427,  1427,  1428,  1428,  1429,  1430,
    1430,  1431,  1432,  1433,  1434,  1435,  1435,  1436,  1436,  1437,
    1437,  1437,  1438,  1438,  1438,  1439,  1439,  1439,  1439,  1439,
    1439,  1439,  1439,  1439,  1439,  1439,  1439,  1439,  1439,  1439,
    1439,  1439,  1439,  1439,  1439,  1439,  1439,  1439,  1439,  1439,
    1439,  1439,  1439,  1439,  1439,  1439,  1439,  1439,  1439,  1439,
    1439,  1439,  1439,  1439,  1439,  1439,  1439,  1439,  1439,  1439,
    1439,  1439,  1439,  1439,  1439,  1440,  1440,  1440,  1440,  1440,
    1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,
    1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,
    1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,
    1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,
    1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,
    1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,
    1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,
    1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,
    1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,
    1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,
    1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,
    1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,
    1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,
    1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,
    1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,
    1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,
    1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,
    1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,
    1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,
    1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,
    1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,
    1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,
    1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,
    1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,
    1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,
    1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,
    1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,
    1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,
    1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,  1440,
    1440,  1440,  1440,  1440,  1440,  1440,  1442,  1441,  1444,  1443,
    1445,  1443,  1446,  1443,  1448,  1447,  1447,  1449,  1449,  1451,
    1450,  1452,  1450,  1454,  1453,  1453,  1455,  1455,  1455,  1456,
    1456,  1456,  1456,  1457,  1457,  1457,  1457,  1458,  1460,  1459,
    1459,  1459,  1459,  1459,  1459,  1459,  1459,  1461,  1461,  1461,
    1462,  1462,  1462,  1462,  1463,  1464,  1465,  1465,  1466,  1466,
    1466,  1466,  1467,  1467,  1467,  1468,  1468,  1468,  1468,  1468,
    1470,  1469,  1471,  1471,  1472,  1472,  1473,  1474,  1474,  1474,
    1474,  1476,  1475,  1477,  1477,  1478,  1477,  1479,  1479,  1480,
    1480,  1481,  1481,  1481,  1481,  1482,  1481,  1483,  1483,  1483,
    1483,  1483,  1484,  1485,  1485,  1485,  1485,  1485,  1486,  1487,
    1487,  1487,  1487,  1488,  1488,  1489,  1489,  1490,  1490,  1491,
    1491,  1493,  1492,  1494,  1492,  1495,  1492,  1496,  1492,  1492,
    1492,  1492,  1492,  1492,  1492,  1492,  1492,  1492,  1492,  1492,
    1492,  1492,  1492,  1492,  1492,  1492,  1492,  1492,  1492,  1492,
    1492,  1492,  1492,  1492,  1492,  1497,  1497,  1498,  1498,  1499,
    1499,  1499,  1500,  1500,  1500,  1500,  1501,  1501,  1502,  1502,
    1503,  1503,  1503,  1503,  1503,  1504,  1504,  1505,  1505,  1506,
    1507,  1507,  1507,  1507,  1507,  1508,  1508,  1509,  1509,  1510,
    1510,  1511,  1511,  1511,  1511,  1511,  1513,  1512,  1514,  1514,
    1515,  1515,  1515,  1516,  1516,  1516,  1517,  1517,  1518,  1519,
    1519,  1520,  1521,  1522,  1522,  1524,  1523,  1525,  1525,  1525,
    1526,  1526,  1528,  1527,  1529,  1529,  1530,  1530,  1530,  1531,
    1531,  1532,  1533,  1532,  1534,  1535,  1536,  1537,  1537,  1538,
    1538,  1539,  1539,  1539,  1539,  1539,  1539,  1539,  1539,  1540,
    1540,  1540,  1541,  1541,  1541,  1541,  1541,  1542,  1542,  1542,
    1542,  1542,  1542,  1543,  1543,  1544,  1545,  1546,  1546,  1546,
    1547,  1548,  1548,  1548,  1549,  1549,  1549,  1551,  1550,  1552,
    1552,  1553,  1553,  1555,  1554,  1557,  1556,  1556,  1558,  1558,
    1560,  1559,  1561,  1561,  1561,  1561,  1563,  1564,  1565,  1562,
    1566,  1566,  1568,  1569,  1570,  1571,  1572,  1567,  1574,  1575,
    1576,  1577,  1573,  1578,  1578,  1578,  1578,  1578,  1578,  1579,
    1579,  1579,  1580,  1580,  1581,  1581,  1581,  1582,  1582,  1583,
    1584,  1583,  1585,  1585,  1586,  1587
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     1,     0,     4,     2,     0,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     3,     1,     1,     4,     1,     2,     0,     4,
       0,     2,     3,     1,     2,     0,     3,     0,     5,     1,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     5,
       3,     1,     0,     1,     3,     1,     3,     3,     3,     3,
       0,     7,     0,     0,    14,     0,     0,    14,     0,     0,
      14,     0,     6,     0,     3,     4,     4,     3,     2,    10,
       1,     3,     2,     2,     2,     2,     2,     2,     2,     0,
      13,     0,     6,     2,     0,     1,     3,     1,     0,     2,
       0,     2,     0,     1,     3,     4,     0,     2,     0,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     0,     3,     1,     0,     2,     0,     2,
       2,     2,     2,     2,     3,     3,     1,     1,     1,     2,
       3,     3,     0,     4,     0,     3,     0,     1,     3,     1,
       0,     1,     3,     1,     0,     3,     0,     1,     3,     1,
       4,     0,     1,     1,     1,     0,     3,     2,     3,     0,
       3,     0,     5,     5,     0,     7,     0,     6,     1,     1,
       1,     3,     1,     1,     1,     3,     0,     1,     1,     1,
       1,     2,     1,     3,     1,     1,     0,     1,     0,     2,
       3,     5,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     3,     4,     0,
       1,     1,     3,     1,     3,     3,     1,     2,     1,     1,
       1,     1,     3,     3,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     3,     0,
       0,     3,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     0,     5,     0,     2,     0,
       3,     0,     2,     2,     2,     2,     0,     6,     2,     0,
       2,     1,     1,     3,     0,     0,     0,     7,     0,     2,
       2,     1,     1,     0,     0,     8,     0,     6,     1,     2,
       1,     2,     0,     0,     6,     0,     0,     6,     0,     2,
       0,     5,     0,     1,     0,     5,     0,     2,     0,     5,
       4,     0,     0,     8,     0,     0,     8,     1,     1,     1,
       1,     1,     2,     4,     5,     0,     4,     4,     4,     3,
       3,     2,     2,     0,     2,     1,     2,     3,     1,     1,
       1,     0,     1,     1,     2,     3,     1,     1,     1,     1,
       1,     1,     1,     1,     0,     1,     1,     2,     3,     1,
       1,     1,     1,     1,     0,     1,     1,     2,     3,     1,
       1,     1,     1,     1,     1,     1,     0,     1,     1,     2,
       3,     1,     1,     1,     2,     2,     2,     1,     1,     1,
       1,     2,     3,     3,     3,     3,     3,     3,     3,     3,
       4,     1,     1,     1,     1,     2,     3,     2,     4,     5,
       0,     5,     0,     0,     5,     0,     7,     1,     0,     1,
       0,     4,     0,     0,     3,     5,     6,     0,     4,     2,
       2,     2,     2,     0,     1,     0,     3,     0,     1,     1,
       3,     1,     4,     5,     5,     0,     2,     0,     0,     7,
       0,    10,     1,     3,     1,     1,     0,     2,     0,     3,
       1,     3,     0,     6,     1,     0,     0,     5,     0,     4,
       1,     1,     1,     3,     1,     3,     0,     0,     5,     1,
       3,     1,     1,     0,     3,     1,     3,     0,     4,     1,
       0,     1,     2,     1,     3,     4,     3,     3,     3,     4,
       4,     3,     0,     0,     6,     0,     1,     0,     1,     1,
       2,     1,     1,     0,     1,     1,     2,     1,     0,     3,
       0,     1,     1,     2,     1,     2,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     0,     6,     1,     1,
       3,     4,     4,     2,     2,     2,     3,     3,     4,     4,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     2,     1,     1,     1,     1,     1,     1,     3,
       1,     1,     2,     2,     7,     8,     8,     8,     8,     2,
       0,     1,     4,     0,     1,     2,     0,     4,     3,     3,
       3,     1,     2,     1,     1,     3,     2,     3,     2,     2,
       1,     3,     3,     2,     3,     1,     2,     2,     2,     1,
       2,     1,     1,     1,     2,     3,     2,     3,     2,     2,
       3,     3,     3,     0,     6,     0,     6,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     2,
       2,     1,     2,     1,     2,     3,     2,     1,     1,     1,
       1,     1,     1,     1,     2,     0,     1,     1,     5,     0,
       3,     0,     2,     3,     0,     1,     2,     1,     1,     1,
       1,     3,     3,     3,     3,     0,     1,     0,     1,     0,
       1,     2,     1,     1,     2,     2,     3,     1,     3,     2,
       1,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     1,     1,     2,     1,     1,     1,     1,     1,
       0,     2,     1,     1,     1,     1,     1,     0,     2,     1,
       1,     0,     1,     1,     2,     2,     1,     2,     2,     0,
       1,     1,     1,     3,     1,     3,     0,     1,     0,     4,
       1,     1,     1,     0,     1,     2,     1,     1,     2,     1,
       3,     3,     1,     1,     0,     2,     0,     1,     5,     0,
       3,     3,     1,     0,     2,     2,     2,     0,     3,     3,
       6,     6,     1,     1,     2,     2,     2,     1,     2,     2,
       1,     1,     0,     1,     1,     1,     1,     0,     1,     1,
       1,     0,     1,     2,     0,     1,     0,     1,     0,     1,
       1,     2,     1,     2,     1,     2,     2,     2,     3,     2,
       1,     1,     1,     1,     3,     1,     1,     1,     4,     2,
       1,     4,     0,     1,     0,     2,     1,     3,     0,     6,
       0,     5,     7,     0,     5,     0,     5,     0,     5,     0,
       4,     0,    10,     3,     4,     3,     3,     7,     4,     3,
       5,     0,     3,     1,     4,     0,     3,     0,     2,     0,
       1,     0,     2,     2,     2,     2,     1,     1,     1,     3,
       4,     0,     6,     4,     0,     5,     0,     6,     4,     3,
       1,     7,     3,     1,     1,     0,     5,     0,     3,     2,
       0,     5,     0,     0,     6,     1,     3,     1,     1,     3,
       2,     3,     2,     4,     0,     6,     0,     0,     8,     4,
       4,     3,     3,     2,     2,     6,     5,     3,     5,     1,
       1,     1,     1,     1,     0,     1,     1,     2,     2,     3,
       3,     3,     3,     0,     1,     0,     1,     0,     1,     1,
       0,     2,     1,     0,     1,     1,     1,     0,     6,     3,
       3,     0,     1,     1,     3,     3,     2,     2,     4,     0,
       3,     0,     3,     0,     3,     0,     3,     0,     1,     1,
       3,     1,     1,     0,     2,     1,     3,     3,     3,     1,
       0,     5,     0,     1,     1,     0,     6,     0,     1,     1,
       2,     1,     1,     1,     0,     5,     2,     0,     5,     0,
       1,     1,     2,     1,     1,     1,     1,     1,     2,     0,
       5,     0,     1,     1,     0,     4,     4,     3,     5,     1,
       3,     3,     0,     6,     1,     1,     1,     3,     2,     3,
       1,     1,     0,     6,     1,     1,     1,     3,     3,     4,
       0,     6,     0,     2,     0,     4,     0,     2,     1,     2,
       4,     2,     3,     2,     3,     0,     3,     0,     0,     6,
       2,     1,     1,     2,     2,     8,     4,     0,     1,     2,
       1,     1,     1,     1,     0,     2,     4,     3,     1,     1,
       3,     4,     0,     0,     0,     2,     2,     1,     1,     0,
       2,     3,     3,     3,     2,     3,     4,     3,     4,     3,
       4,     1,     3,     4,     3,     3,     6,     1,     5,     6,
       5,     7,     6,     8,     5,     6,     4,     4,     5,     3,
       4,     1,     3,     3,     3,     3,     3,     3,     5,     5,
       3,     3,     3,     3,     3,     3,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     3,     1,
       1,     1,     1,     3,     2,     2,     2,     2,     3,     3,
       5,     6,     4,     4,     7,     2,     6,     5,     6,     6,
       4,     4,     5,     4,     6,     2,     4,     4,     4,    10,
       6,     8,     6,     4,     4,     6,     4,     4,     4,     6,
       4,     7,     7,     7,     6,     6,     6,     6,     3,     4,
       6,     8,     2,     2,     8,     8,     6,     6,     1,     6,
       6,     8,     8,     6,     8,     6,     2,     8,     8,     2,
       2,     2,     4,     4,     4,     4,     3,     8,     6,     8,
       4,     6,     4,     4,     4,     6,     8,     4,     3,     6,
       4,     6,     5,     8,     7,    10,     1,     6,     4,     4,
       4,     4,     4,     6,     4,     0,     5,     6,     2,     3,
       0,     4,     0,     3,     0,     1,     1,     3,     4,     4,
       5,     4,     4,     4,     5,     4,     0,     0,     7,     4,
       5,     4,     5,     4,     4,     4,     4,     4,     5,     0,
       8,     0,     3,     3,     1,     4,     0,     1,     0,     2,
       0,     1,     0,     3,     2,     3,     2,     1,     2,     1,
       2,     1,     2,     2,     2,     0,     1,     1,     3,     1,
       3,     1,     3,     0,     1,     0,     2,     4,     5,     1,
       1,     1,     1,     4,     1,     3,     3,     3,     0,     6,
       0,     6,     0,     8,     4,     0,     8,     0,    10,     6,
       0,     8,     0,    10,     6,     1,     2,     2,     0,     1,
       5,     0,     5,     3,     5,     2,     0,     0,     7,     1,
       0,     0,     6,     0,     3,     0,     0,     5,     0,     1,
       0,     1,     0,     2,     3,     3,     1,     1,     0,     7,
       0,     7,     1,     2,     0,     0,     2,     0,     2,     0,
       1,     1,     1,     1,     3,     1,     3,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     1,     1,     0,     2,     0,     1,     0,
       0,     3,     0,     0,     3,     2,     0,     0,     4,     4,
       2,     0,     1,     1,     3,     3,     1,     2,     0,     1,
       0,     4,     4,     2,     0,     1,     1,     0,     1,     0,
       1,     2,     1,     3,     3,     1,     1,     1,     1,     1,
       0,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     0,     0,     6,     0,     1,
       3,     1,     0,     2,     3,     1,     2,     1,     0,     3,
       0,     0,     7,     2,     1,     0,     3,     0,     7,     0,
       0,     8,     4,     6,     4,     4,     4,     0,     6,     4,
       4,     4,     5,     4,     1,     3,     1,     2,     1,     3,
       1,     0,     2,     0,     1,     0,     1,     1,     2,     3,
       1,     1,     0,     0,     8,     0,     0,     6,     0,     1,
       1,     1,     1,     1,     2,     1,     1,     1,     3,     4,
       0,     3,     3,     1,     2,     2,     0,     3,     0,     5,
       3,     1,     3,     1,     3,     1,     1,     0,     1,     0,
       4,     0,     1,     3,     1,     1,     1,     0,     0,     6,
       0,     0,    11,     3,     1,     3,     3,     1,     3,     0,
       1,     0,     4,     0,     7,     0,     5,     0,     6,     1,
       3,     2,     4,     0,     2,     0,     2,     1,     1,     1,
       0,     4,     0,     1,     0,     1,     1,     3,     1,     1,
       2,     2,     2,     1,     1,     1,     1,     0,     3,     0,
       3,     2,     4,     4,     3,     4,     4,     1,     3,     3,
       6,     2,     2,     0,     6,     0,     6,     5,     2,     1,
       5,     5,     2,     2,     1,     4,     3,     2,     3,     2,
       2,     1,     3,     4,     3,     3,     2,     2,     3,     3,
       3,     3,     3,     3,     3,     3,     1,     1,     1,     1,
       1,     0,     1,     0,     2,     0,     1,     1,     1,     0,
       2,     0,     2,     0,     2,     2,     0,     4,     0,     4,
       1,     1,     1,     1,     1,     1,     1,     0,     1,     1,
       3,     0,     1,     1,     0,     4,     0,     0,     5,     1,
       0,     3,     0,     3,     3,     1,     2,     2,     2,     2,
       2,     2,     2,     1,     1,     1,     1,     1,     1,     0,
       1,     0,     3,     3,     1,     0,     3,     1,     2,     0,
       1,     0,     3,     3,     2,     2,     3,     0,     1,     1,
       2,     0,     0,     0,     0,    22,     1,     1,     0,     1,
       0,     1,     1,     0,     1,     1,     0,     2,     2,     1,
       3,     4,     3,     3,     0,     2,     2,     1,     3,     3,
       0,     4,     0,     3,     1,     1,     0,     3,     2,     3,
       1,     1,     2,     0,     2,     3,     1,     5,     1,     1,
       2,     2,     1,     1,     1,     1,     1,     2,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     2,     2,     1,
       1,     1,     1,     1,     2,     2,     2,     1,     1,     3,
       5,     1,     1,     1,     1,     1,     3,     4,     5,     1,
       5,     3,     2,     1,     3,     2,     2,     4,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     3,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     0,     3,     0,     3,
       0,     3,     0,     3,     0,     3,     2,     0,     2,     0,
       2,     0,     4,     0,     3,     1,     1,     1,     1,     0,
       1,     1,     1,     0,     2,     2,     2,     3,     0,     4,
       4,     6,     2,     3,     3,     3,     5,     1,     3,     3,
       1,     1,     3,     3,     1,     3,     2,     2,     2,     2,
       2,     1,     1,     4,     4,     1,     1,     1,     1,     1,
       0,     4,     1,     1,     1,     3,     3,     1,     1,     2,
       2,     0,     3,     4,     3,     0,     7,     1,     2,     1,
       1,     1,     1,     1,     1,     0,     5,     1,     1,     1,
       1,     1,     3,     6,     6,     6,     7,     5,     3,     8,
       8,     8,     6,     0,     1,     1,     2,     0,     1,     1,
       3,     0,     3,     0,     3,     0,     3,     0,     3,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       2,     2,     1,     3,     2,     2,     2,     2,     2,     2,
       2,     2,     1,     1,     2,     0,     1,     3,     1,     2,
       2,     2,     1,     3,     3,     1,     1,     3,     1,     3,
       4,     5,     4,     6,     1,     0,     3,     3,     1,     1,
       0,     2,     2,     2,     2,     0,     2,     0,     3,     2,
       1,     2,     2,     2,     2,     2,     0,     3,     0,     1,
       0,     3,     2,     0,     1,     2,     0,     1,     4,     4,
       5,     2,     3,     0,     1,     0,     4,     0,     1,     1,
       0,     1,     0,     2,     2,     1,     0,     1,     1,     2,
       3,     2,     0,     6,     3,     0,     0,     0,     1,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     2,
       2,     3,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     0,     3,     1,     2,     1,
       2,     3,     3,     3,     0,     3,     3,     0,     7,     0,
       3,     1,     3,     0,     3,     0,     3,     4,     1,     3,
       0,     3,     0,     3,     4,     4,     0,     0,     0,    16,
       8,     7,     0,     0,     0,     0,     0,    15,     0,     0,
       0,     0,    12,     4,     4,     3,     4,     3,     2,     1,
       3,     5,     1,     1,     0,     1,     1,     0,     2,     0,
       0,     3,     0,     2,     5,     3
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
       0,  2595,  1081,  2526,     0,     0,     0,     0,     0,     0,
    2528,   123,    63,  1701,  1815,  1816,  1605,  1633,     2,     0,
    1081,   269,   173,     0,    75,  1642,     0,  1867,     0,     0,
    1081,   483,     0,  1861,     0,     0,  1081,  1645,  1851,   246,
     173,  2528,     0,  1127,  2336,  1739,     0,     0,     0,  1722,
       0,  2411,  1690,     0,     0,     0,     0,     3,     8,    19,
       0,    39,    24,    29,    14,    18,    13,    52,    46,    26,
      37,    10,    54,    55,    16,    43,    11,    12,    15,    35,
      42,    36,    38,    50,  1118,    22,    23,    30,    44,    59,
      20,    56,    53,    21,  1817,    25,    45,    40,    32,    60,
      33,    51,    34,    58,    28,    47,    27,     9,    17,    48,
      49,    41,    61,    31,    57,     0,   929,     0,     0,  1006,
       0,     0,     0,     0,   173,     0,   909,  2593,  2594,  2595,
    1083,  1082,     0,  2528,  1972,  1066,  1092,  2035,  2036,  2037,
    2038,  2039,  2040,  2041,  2042,  1986,  2043,  2045,  2044,  2046,
    2047,  1987,  1988,  2048,  2049,  2050,  2052,  2051,  2053,  1989,
    1990,  2054,  2055,  2056,  2057,  1991,  1992,  2058,  2060,  2059,
    1993,  2061,  2062,  2063,  2066,  2065,  2064,  1994,  2067,  1995,
    2068,  2069,  2070,  2071,  2072,  2073,  2074,  2076,  2075,  1996,
    2077,  2078,  2079,  2080,  2081,  2083,  2082,  2084,  2085,  2086,
    1997,  2087,  2088,  2089,  2090,  2091,  2092,  2093,  2094,  2095,
    1998,  2096,  2097,  2098,  2118,  1999,  2099,  2102,  2101,  2100,
    2103,  2104,  2105,  2107,  2106,  2108,  2109,  2000,  2110,  2111,
    2112,  2113,  2114,  2116,  2115,  2120,  2121,  2122,  2001,  2002,
    2117,  2119,  2316,  2123,  2125,  2124,  2126,  2128,  2127,  2003,
    2129,  2004,  2005,  2130,  2131,  1969,  2132,  1970,  2133,  2135,
    2136,  2137,  2142,  2006,  2134,  2138,  2139,  2140,  2141,  2143,
    2007,  2144,  2145,  2146,  2147,  2148,  2149,  2150,  2151,  2152,
    2153,  2175,  2164,  2166,  2157,  2159,  2160,  2162,  2158,  2165,
    2163,  2169,  2168,  2170,  2171,  2172,  2173,  2174,  2167,  2155,
    2161,  2156,  2176,  2177,  2154,  2178,  2179,  2180,  2181,  2182,
    2183,  2184,  2185,  2186,  2187,  2188,  2190,  2189,  2191,  2192,
    2193,  2194,  2195,  2196,  2198,  2197,  2199,  2200,  2201,  2203,
    2202,  2205,  2206,  2008,  2204,  2207,  2208,  2209,  2210,  2211,
    2212,  2009,  2010,  2011,  2213,  2214,  2012,  2215,  2217,  2216,
    2218,  2219,  2220,  2221,  2222,  2223,  2224,  2013,  2014,  2225,
    2226,  2227,  2228,  2229,  2230,  2231,  2232,  2233,  2234,  2235,
    2236,  2237,  2238,  2240,  2239,  2241,  2242,  2243,  2244,  2245,
    2246,  2247,  2015,  2248,  2016,  2249,  2250,  2017,  2251,  2018,
    2252,  2253,  2254,  2255,  2019,  2256,  2257,  2258,  2260,  2261,
    2259,  2262,  2020,  2263,  2264,  2265,  2021,  2267,  2266,  2268,
    2022,  2270,  2271,  2023,  2269,  2025,  2272,  2273,  2024,  2026,
    2274,  2275,  2276,  2277,  2278,  2280,  2279,  2281,  2282,  2283,
    2027,  2284,  2285,  2286,  2287,  2028,  2288,  2289,  2290,  2291,
    2292,  2294,  2293,  2295,  2296,  2297,  2298,  2300,  2302,  2301,
    2299,  2303,  2304,  2305,  2306,  2309,  2310,  2311,  2312,  2307,
    2308,  2029,  2313,  2314,  2315,  2317,  2318,  2320,  2319,  2030,
    2031,  2321,  2322,  2034,  2323,  2324,  2327,  2325,  2326,  2329,
    2328,  2330,  2332,  2331,  2032,  2333,  2033,  2334,  2335,   192,
    1975,   175,  1976,  1985,     0,  2403,  2402,  1050,  1067,  2529,
    2530,   578,   859,     0,     0,   860,     0,   577,   858,   173,
    2595,   128,     0,   574,   575,     0,     0,     0,  1715,     0,
    1631,  1631,  1631,     0,     0,  1631,  1631,     0,  1634,  1631,
     173,  1631,     0,    68,  1824,   270,     0,     0,     0,     0,
       0,  1968,     0,  1648,     0,  1868,  1869,     0,  1876,     0,
    1877,  1871,  2400,     0,     0,     0,     0,     0,   173,  1084,
       0,  1699,     0,   236,   245,   247,   248,   244,     0,  2530,
    2541,  1119,  1125,  1137,     0,  1795,   248,  1037,  1021,  1037,
    1723,  1720,     0,     0,  1699,  1870,  2652,     0,     0,     0,
    2648,     0,  2653,     0,  1127,     0,     0,     1,     5,     0,
       0,  2113,  2002,  2217,  1808,  1806,  1963,     0,   900,   930,
       0,   905,     0,   903,  1981,  1980,  1979,     0,   916,   915,
     913,     0,   447,     0,     0,     0,  2604,   907,  1064,  2527,
       0,   194,     0,    77,     0,     0,     0,  2533,     0,     0,
       0,     0,   127,     0,     0,     0,   124,  1152,  1152,  2595,
    2597,  2599,   578,   576,     0,     0,     0,  1719,  1718,  1717,
       0,  1715,  2036,  1986,  2047,     0,  1936,     0,     0,     0,
    1403,     0,  1991,     0,  2061,  2063,  1996,     0,     0,  1159,
    1159,   731,     0,     0,     0,  2085,  2086,  1942,     0,     0,
       0,  1933,  1943,  2002,  2125,  2126,     0,  1935,  2131,     0,
       0,     0,     0,  2148,  1940,     0,     0,  2185,  2187,     0,
       0,  2191,  2192,  2193,  2194,  1919,  1214,     0,   731,  1932,
    1939,  2210,  1925,  2218,  2223,  2224,     0,  2233,     0,     0,
    2255,     0,  2261,  2259,  2265,     0,     0,  2291,     0,     0,
     731,  1918,  2309,  2310,  2311,  2312,     0,  1934,  2029,  1941,
       0,  2323,  1159,   731,   731,     0,     0,     0,  2330,  2332,
    2335,     0,     0,     0,  2565,  1213,     0,  1371,     0,  1288,
    1397,  1171,  1177,  1191,     0,  1206,  1224,  1225,  1227,  1326,
    1226,  1232,  1231,  1606,  1929,  1230,  1229,  1930,  1931,  1223,
    1953,  1975,  1952,     0,     0,     0,     0,     0,     0,     0,
       0,  1635,     0,     0,  1617,  1631,    70,     0,     0,  2447,
    2462,  2463,  2459,  2464,  2482,  2465,  2469,     0,  2461,  2453,
       0,  2468,     0,  2457,  2466,     0,  2451,     0,  2467,  2472,
    2483,  2455,  2460,  2438,     0,  2445,  2449,  1965,  1512,  2414,
    2415,     0,    76,  1650,  1651,  1649,  1005,     0,  1866,     0,
    1880,     0,  1079,   493,   484,     0,  1790,  1789,     0,  1862,
    2542,     0,     0,  1055,  1653,  1700,     0,  1652,  1857,     0,
    1855,  1852,  1854,   237,     0,     0,   267,  2447,     0,  2432,
       0,  2536,  2533,  2543,  2578,  2573,  2572,  2575,  2576,  1143,
    2577,  1142,  2574,  2571,  1152,  1138,  1140,  1141,   775,     0,
       0,  2356,  2357,  2198,  2218,  2358,  2307,     0,     0,  2377,
    2337,  2342,  2338,     0,     0,   775,  1803,     0,     0,  1803,
       0,  1547,  1793,  1796,     0,  2360,  1771,   856,   855,   854,
    2361,  1789,     0,  1747,  1759,     0,  1724,  1764,     0,  2362,
       0,  1792,     0,  1547,  1803,     0,  1740,     0,     0,     0,
       0,   243,  1042,  1041,  1017,  1038,  1039,     0,     0,  1020,
    1022,  1023,  1019,     0,  2665,  2412,  1005,  1924,  1923,  1973,
    2649,  1922,  2657,  2659,  2645,  2647,  2654,  1121,     0,  2547,
       6,    62,     0,     0,  1821,  2602,  2603,  2601,   791,     0,
    1159,  1982,  2596,   176,   914,     0,   448,   176,     0,     0,
       0,     0,     0,   449,   450,   382,   918,     0,   898,   911,
       0,     0,   910,  2604,     0,     0,  1094,  1096,  1095,  1112,
     196,   193,   174,     0,  1052,  1624,  1626,  1069,  2532,     0,
       0,  2534,  2538,  1212,  1211,     0,   121,   126,     0,     0,
       0,  2504,   125,  2498,  2600,  1152,  1152,  1152,  2592,     0,
    2580,  2587,  2588,  2591,  2590,  2589,  2586,     0,  2579,  2582,
    2583,  2585,  2584,  2604,  2598,     0,   861,   861,   861,     0,
    1702,  1705,  1709,  1713,  1716,     0,     0,  1517,  1245,  1517,
    1517,  1517,  1404,     0,     0,     0,     0,     0,     0,     0,
       0,  1517,     0,  1282,  1255,     0,  1283,     0,     0,     0,
    1944,     0,     0,     0,  2565,     0,     0,     0,     0,  1376,
       0,     0,     0,  2565,     0,     0,     0,     0,     0,  1399,
    1401,  1952,  1517,     0,     0,  1517,     0,     0,     0,     0,
       0,  1164,   771,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1517,  1517,     0,     0,
    1517,  1296,  1946,     0,     0,     0,  1945,     0,     0,     0,
    1938,  1937,  1920,     0,  1299,  1301,  1300,     0,  1517,  1517,
       0,     0,     0,  1235,  1234,  1236,     0,     0,     0,     0,
       0,     0,  1210,  1209,  1208,  1207,     0,     0,     0,  1215,
       0,  1216,  1217,     0,  1218,  1219,  1220,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1237,     0,     0,     0,
    1921,  1335,     0,  1632,  1612,  1619,  1614,     0,  1635,  1615,
    1623,   462,   461,  1640,  1641,  1621,  1636,  1637,     0,  1620,
    2496,  1616,     0,  1607,     0,    69,     0,  1847,     0,     0,
       0,  1843,  1845,  1844,     0,     0,  1848,     0,  1846,  1825,
    1829,  1835,  1826,     0,     0,   268,   271,   273,     0,   276,
    2448,  2446,  2480,  2479,  2484,     0,  2481,  2477,  2470,  2505,
    2474,     0,  2505,  2476,  2475,  2505,  2471,  2478,  2505,  2443,
       0,  1513,  1514,     0,  2413,     0,  1964,     0,     0,  1102,
    1881,  1882,  1878,  1512,  2401,  2404,     0,   494,     0,     0,
     505,     0,     0,    65,    66,     0,  1086,     0,  1085,  1089,
       0,     0,     0,  1656,  1646,  1655,  1438,  1858,  1859,     0,
     235,   260,   255,   263,   257,   259,   258,   264,   265,   266,
     261,   256,   262,   249,     0,  2446,     0,  2443,  2537,     0,
    2539,  2556,  1126,  2544,  1149,  1128,  1148,     0,  1139,   774,
       0,   777,   779,  1675,  1676,   778,   787,     0,   776,     0,
       0,     0,  2363,     0,   783,   785,   784,  2372,   782,     0,
       0,  2347,  2368,  1799,     0,     0,  1770,     0,   578,     0,
       0,     0,     0,     0,     0,  1741,     0,     0,   621,     0,
    1763,  1548,  1797,  1798,  1803,     0,     0,  1803,     0,  1776,
    1793,     0,  1803,  1736,     0,     0,  1728,  1733,  1729,     0,
    1735,  1734,  1737,  1725,  1726,  1799,  1752,  1777,  1793,  1762,
    1769,     0,  1751,  1758,     0,  1767,  1793,  1793,  1803,  1803,
    1043,     0,  1026,  1027,     0,     0,  1721,  1441,     0,     0,
    2646,  2660,  2644,  2655,  2656,  2643,  1122,  2548,  1120,  2549,
       0,     7,     4,  1820,  1810,  1811,  1812,  1813,  1814,  1809,
    1807,  1822,  1823,   792,   791,   569,   572,   571,     0,     0,
    1984,     0,   906,     0,   436,   904,     0,     0,   414,   393,
     414,   451,     0,     0,   791,   921,     0,     0,   908,  1065,
       0,     0,   482,  1112,  1098,  1114,     0,   197,   199,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    78,    79,   101,  1054,  1053,     0,  1051,
    1077,  1076,  1074,     0,  1075,  1073,  1068,  1070,  1071,  2531,
    2535,   579,   791,   424,     0,   385,     0,     0,     0,     0,
       0,   578,     0,     0,  2581,   110,   862,     0,     0,     0,
    1707,  1628,  1438,  1630,  1963,     0,     0,     0,  1711,     0,
       0,  1518,  1517,     0,  1382,     0,     0,     0,     0,  1405,
       0,     0,     0,     0,     0,     0,     0,  1356,     0,  1382,
    1160,     0,   732,  1306,     0,     0,     0,     0,     0,     0,
    1488,  1489,  1490,  1491,  1499,  1492,  1493,  1494,  1501,  1506,
    1495,  1496,  1502,  1503,  1504,  1497,  1505,  1500,  1498,  1507,
       0,  1487,     0,     0,  1511,  1508,  1510,  1509,     0,  1377,
    1369,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1517,     0,     0,     0,  1517,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1318,     0,     0,     0,     0,     0,
    1517,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1278,     0,  1955,  1954,     0,     0,     0,   824,     0,
    1239,     0,  1238,  1450,     0,  2550,  2566,     0,  2363,  1372,
    1374,     0,  1162,  1161,  1163,  1174,  1167,  1172,  1165,  1169,
       0,  1221,  2042,  1175,     0,     0,  1203,  2565,  1526,  1204,
    1189,  1194,  1195,     0,  1192,  1193,     0,  1197,     0,  1196,
    1200,  1201,  1202,  1205,     0,     0,     0,     0,  1228,  1233,
    1398,  1152,  1956,     0,  1609,  1622,  1791,  1638,  1677,     0,
    1007,     0,     0,    71,    73,  1840,  1837,  1836,  1838,  1842,
    1841,  1839,     0,  1849,  2085,  2309,  2312,   280,     0,   253,
     252,   254,   277,     0,     0,  2473,     0,  2454,     0,  2458,
    2452,  2456,     0,     0,  2444,     0,  2450,  1516,  2121,  2202,
       0,  1519,  2417,  1643,  2664,     0,  1879,     0,     0,     0,
    1080,     0,  1152,   492,   491,   490,   489,     0,   507,   487,
     495,    67,     0,     0,  1863,     0,     0,     0,     0,  1057,
    1654,     0,     0,  1627,  1439,  1860,  1856,  1853,     0,     0,
       0,     0,     0,     0,     0,  2540,  2558,  2557,  2545,  1152,
    1538,  1153,  1153,  1952,  2379,     0,  2374,  2373,     0,     0,
       0,  2392,  2375,     0,     0,  2341,  2380,  2381,  2384,     0,
       0,     0,     0,     0,  2378,  2307,  2343,  2344,     0,  2349,
    2339,     0,     0,  1801,  1804,  1805,     0,     0,  1785,  1779,
    1778,  1774,  1780,  1775,  1788,  1787,  1786,  1749,  1748,  1558,
    1559,  1557,  1551,  1552,  1556,  1555,  1744,  1794,  1784,  1782,
    1772,  1803,  1783,  1781,  1730,  1731,  1732,     0,  1547,     0,
    1801,  1803,  1793,     0,  1803,  1803,  1766,  1768,     0,  1029,
    1040,  1025,  1024,  1459,  1458,     0,  1412,     0,  1414,  1411,
    1410,  1409,     0,  1458,  2650,  2658,  2662,     0,  1547,  2555,
    2553,   570,  1677,  1677,     0,  1983,     0,     0,     0,     0,
       0,     0,     0,   177,   186,     0,     0,   391,   392,  1677,
     390,   437,   438,   441,   442,   443,     0,     0,     0,     0,
       0,     0,     0,     0,   130,   444,  1677,  1677,   387,   415,
     416,   419,   420,   421,   422,   423,   383,     0,   388,     0,
     919,  1003,  1677,  1003,     0,  1677,  1677,  1003,  1677,     0,
       0,  1677,  1677,     0,     0,  1677,     0,     0,  1003,     0,
    1677,     0,   990,     0,     0,  1677,  1677,  1677,  1677,  1677,
    1003,     0,     0,  1677,   482,  1677,     0,     0,  1013,     0,
       0,  1677,  1677,  1677,  1677,     0,     0,  1677,     0,  1677,
     937,   989,   582,   608,   609,   899,   936,   938,   950,   478,
       0,   968,   992,   993,   991,     0,   923,   925,  2605,  2606,
    2607,  1101,  1093,  1100,  1097,  1112,  1110,  1099,   851,   850,
       0,  1113,   195,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1625,
    1078,  1072,   122,   791,  1677,  1677,  1677,  1677,   389,   425,
     426,   429,   430,   431,   432,   435,   433,   434,     0,     0,
     401,     0,     0,  2499,     0,  2638,     0,     0,     0,   175,
     580,     0,     0,   863,     0,     0,     0,     0,     0,  1703,
       0,  1966,  1710,  1441,  1714,  1713,     0,  1302,     0,  1349,
       0,  1351,  1352,  1353,     0,     0,     0,     0,     0,  1303,
       0,  1253,  1304,  1305,     0,     0,     0,     0,  1355,     0,
     733,     0,     0,  1256,  1257,  1250,  1242,     0,     0,  1328,
       0,     0,  1258,     0,     0,     0,     0,     0,  1329,  1400,
       0,  1402,  1956,     0,  1361,  1310,  1263,     0,  1359,     0,
    1264,  1330,  1331,  1332,  1312,  1313,     0,  1334,     0,  1314,
       0,     0,  1317,     0,     0,  1266,  1365,  1363,     0,     0,
       0,     0,  1367,  1268,     0,     0,     0,  1267,     0,     0,
       0,     0,     0,     0,     0,  1270,     0,  1251,  1364,  1366,
    1320,     0,     0,     0,     0,     0,  1279,     0,  2559,  1449,
    2567,  1450,     0,     0,  2561,  2551,  2556,  2564,  1243,     0,
       0,  1957,  1168,  1173,  1166,  1170,  2565,     0,     0,     0,
       0,  1187,  1186,     0,     0,     0,  2565,  1526,  1190,     0,
       0,  1345,  1346,  1395,     0,  1613,  1610,  1639,  1678,     0,
    2497,  1009,  1008,  1618,  1007,    74,     0,  1834,  1850,  1827,
       0,   272,   281,   274,   278,   279,   275,  2509,     0,  2508,
       0,  2492,  2495,  1963,     0,     0,     0,  2427,  2421,  2428,
    2430,  2424,  2429,  2431,  2422,  2423,  2418,  2425,  1520,  1549,
       0,  1103,  1105,  1106,  1104,  1112,     0,     0,  2407,  2408,
    2406,  2405,   497,     0,  1583,  1584,  1569,  1570,  1568,  1571,
     506,  1572,  1582,     0,   518,     0,     0,     0,  1865,  1864,
       0,  1087,  1090,  1091,  1062,  1061,  1063,  1056,  1058,  1059,
     562,  1660,     0,     0,     0,  1666,  1647,  1657,     0,     0,
     250,     0,     0,     0,     0,     0,     0,  1147,  1441,  1598,
    1144,  1132,  1549,  1539,  1131,  1154,  1150,     0,   790,   789,
     788,   786,     0,     0,     0,     0,  2386,  2387,     0,     0,
    2364,  2365,  2366,     0,  2370,  2346,  2347,     0,  2348,     0,
    2398,  2399,  2396,  2397,  2395,  2369,  1800,     0,  1753,     0,
    1773,     0,     0,  1746,     0,  1765,  1727,  1755,  1745,  1519,
    1793,  1742,  1743,     0,  1049,     0,  1045,  1044,     0,  1018,
    1031,  1458,  1441,     0,     0,  1435,  1460,     0,  1460,  1441,
    1441,     0,  1441,  1438,  1455,     0,     0,  2661,  1540,  2554,
       0,     0,   902,   180,   183,   181,     0,   182,     0,     0,
     446,   445,     0,  1791,   439,   134,   133,   135,   136,  1566,
    1567,  1563,  1564,  1562,  1565,   138,   137,   132,   917,     0,
       0,     0,  1791,   417,   394,   395,   398,   399,   400,     0,
    1004,   892,  1081,   972,     0,   654,   892,   847,   852,   852,
     970,     0,     0,  1081,     0,     0,     0,     0,     0,  1081,
       0,     0,     0,  1677,     0,   983,   932,     0,     0,     0,
       0,     0,   984,     0,     0,   933,  1677,     0,     0,     0,
       0,     0,     0,  1081,     0,     0,   480,     0,  1081,   482,
    1016,  1015,  1014,     0,  1081,  1081,     0,     0,     0,     0,
     614,   615,   613,     0,     0,   606,   583,   791,   934,   479,
     935,   653,     0,  1010,   650,   656,  1959,     0,     0,     0,
     144,  2609,     0,  1479,   198,   102,   100,    82,  1971,    86,
      88,    81,   106,  1576,  1577,  1575,  1573,  1574,   107,    84,
      85,    87,    91,    90,    92,    93,    96,    97,    94,    89,
      95,    83,    98,   108,   109,    80,     0,     0,     0,     0,
    1791,   427,     0,     0,  1677,   384,   402,   403,   406,   407,
     408,   409,   410,   413,   411,   412,     0,  2500,  2502,     0,
       0,   378,   377,     0,   139,  2632,     0,     0,   653,   111,
     478,   581,   584,   885,   887,   886,   877,   876,   112,   115,
     118,  1629,  1713,  1441,  1519,  1964,  1519,     0,  1712,     0,
       0,  1350,  1383,     0,  1406,     0,  1247,   745,   745,   729,
    1391,   725,   745,  1387,   729,  1389,     0,     0,     0,     0,
       0,  1357,  1354,     0,     0,     0,     0,     0,  1380,     0,
       0,     0,  1252,     0,  1340,  1362,  1360,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1368,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   813,   819,   822,   823,   825,   817,     0,
    1322,  1240,  1152,  2568,  2570,  1123,     0,  2560,  2562,   894,
    1373,     0,  1184,  1180,     0,  1178,  1525,  1199,  1198,     0,
       0,     0,  1188,  1153,  1336,  1152,     0,  1396,  1958,   994,
     460,   620,  1608,    72,  1830,     0,     0,  2506,     0,  2517,
       0,     0,     0,     0,     0,     0,     0,  2416,  1550,  1687,
       0,  1112,  1116,  1974,  1872,  2409,  2410,     0,   498,   499,
     501,  1153,   515,   493,     0,   485,   488,     0,   497,     0,
    1060,  1137,     0,  1679,  1664,  1671,  1665,     0,     0,     0,
    1663,  1948,  1947,  1954,  2543,     0,  1485,     0,     0,  2437,
       0,     0,     0,  2546,  1519,  1519,  1592,     0,     0,  1129,
    1134,  1130,  1133,     0,  1151,  1158,  1157,  1949,  1956,  2376,
       0,     0,     0,     0,  2391,  2385,  2382,  2383,     0,  2345,
    2367,  2351,  2350,  2353,  2355,  1802,  1547,  1761,  1760,  1554,
    1553,  1738,  1547,  1757,  1803,     0,     0,     0,     0,     0,
    1033,     0,  2550,  1453,     0,  1437,  1436,  1461,     0,  1441,
    1460,  1460,     0,  1417,  1416,  1691,  1694,     0,  1415,  1512,
    1443,  1137,  2651,  2663,     0,   619,   618,   185,   184,   190,
     191,   464,   452,   463,   440,   131,   453,   454,   418,     0,
     396,   920,   655,   893,   955,     0,     0,     0,   852,   649,
     892,   861,   853,   892,   892,   999,  1000,     0,     0,   593,
     590,   974,   602,   953,   944,   954,   965,   967,     0,   592,
     616,     0,     0,   604,     0,   939,   981,   982,  1007,   587,
       0,     0,   629,   630,   628,   610,   617,  1001,  1002,   588,
     589,   976,     0,  1534,  1536,  1544,   595,   594,     0,   591,
       0,   952,   987,   960,     0,   627,   625,   622,   624,   623,
     626,   605,   597,   596,   599,   598,   601,   600,   603,   949,
       0,  1003,  1003,   969,     0,   637,   638,   640,   641,  1962,
       0,  1012,   971,     0,   642,   651,   643,     0,     0,     0,
     154,     0,     0,   922,     0,   147,   145,   156,     0,     0,
       0,  1482,     0,  1483,  1480,  1481,     0,   103,   105,   459,
     458,   457,   456,   428,     0,     0,     0,  1791,   404,  2501,
       0,     0,  2639,   381,   379,   380,     0,     0,   200,   635,
     636,   634,   633,     0,   467,     0,   465,     0,   477,     0,
    1883,   791,   585,     0,     0,     0,     0,  1519,  1538,  1967,
    1706,     0,  1280,  1407,     0,     0,   746,  1384,   799,     0,
    1393,     0,  1394,   727,   726,  1386,  1388,  1392,  1390,  1246,
    1254,  1327,  1249,  1248,     0,     0,     0,  1286,  1308,     0,
    1287,  1378,  1381,     0,     0,  1260,     0,  1262,     0,     0,
    1342,  1311,  1333,  1289,  1315,     0,  1265,  1241,     0,  1290,
       0,  1295,  1293,     0,  1269,     0,     0,  1276,     0,  1274,
       0,  1275,     0,  1277,  1319,  1321,     0,     0,   824,   810,
     811,   812,     0,   814,   816,   818,     0,     0,  1451,  2569,
    1124,     0,     0,  1375,  1176,     0,  1185,  1182,     0,  1179,
    1154,  1347,  1337,  1611,   996,   995,  1832,     0,  1828,   289,
     284,   292,   286,   288,   287,   293,   294,   295,   296,   290,
     285,   291,   283,   282,  2507,     0,  2442,  2494,  2493,  2510,
    2510,  2510,     0,  1521,     0,  1644,  1107,  1112,  1116,     0,
    1108,  1883,   502,     0,     0,     0,   522,     0,   520,   496,
       0,  1088,  1152,  1661,  1673,     0,  1681,     0,     0,  1658,
    1668,     0,     0,     0,  1667,   482,     0,   251,     0,  2434,
    2435,  2433,  1549,  1527,     0,     0,  1604,     0,  1599,  1145,
       0,  1156,  1155,     0,  2394,  2393,  2389,  2388,  2390,  2371,
       0,     0,  1754,  1756,  1750,  1048,  1047,  1046,  1030,     0,
       0,  1035,  2556,  1512,  1445,  1441,  1413,  1441,  1424,     0,
       0,  1441,  1420,  1418,  1422,     0,  1519,     0,  1477,  1152,
    1951,  1541,  1544,   397,   957,     0,   892,   848,   849,   861,
       0,   861,   861,     0,     0,   943,     0,  1069,     0,   948,
     787,   611,   980,   979,     0,   612,     0,   941,     0,  1545,
    1546,  1537,   481,   940,   962,   946,  1849,   973,   653,  1011,
     829,   721,   670,   661,   745,   664,   663,   707,   729,   675,
     725,   723,   693,   725,   725,   700,   699,   717,   703,   683,
     799,   799,   682,   720,   799,   704,   702,   706,     0,   708,
     725,   713,   701,   705,   722,   698,   695,   719,   745,   729,
     729,   679,   718,   799,     0,   711,   745,   749,   681,   799,
     806,     0,     0,   745,   747,  1961,   155,   143,     0,     0,
     924,   926,     0,     0,   927,  2611,     0,  2613,     0,  1115,
       0,    99,     0,     0,   386,   455,   405,  2503,     0,   211,
    1152,     0,     0,   201,   203,   204,     0,     0,     0,   580,
    1885,  1884,   466,   565,   586,     0,     0,     0,  1713,  1708,
    1560,     0,  1408,     0,     0,     0,     0,   793,   804,   802,
     796,     0,   800,   801,  1385,     0,     0,  1358,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1244,     0,
    1338,     0,     0,     0,     0,     0,     0,  1273,  1271,  1272,
     808,  1324,     0,   821,   815,   813,   820,     0,  1549,  2550,
     895,  1181,     0,  1348,   998,   997,     0,     0,     0,     0,
    2515,  2515,  2515,  1686,  1685,     0,  1684,  1688,  1109,  1117,
       0,   500,   503,     0,   495,     0,   519,     0,   486,   563,
       0,     0,     0,  1682,  1670,  2547,  1659,  1662,  1956,  1440,
    1486,  2436,  1136,     0,  1522,  1603,  1600,     0,  1593,  1595,
    1597,     0,  1950,  2352,  2354,  1032,     0,     0,  1028,  1446,
    1444,  1454,     0,  1409,  1441,  1441,     0,  1409,     0,     0,
       0,  1693,  1538,  1695,  1442,  1474,  1456,     0,  1543,     0,
       0,   956,     0,     0,     0,     0,     0,     0,   986,     0,
    1010,   945,   966,   988,     0,   749,  1081,  1535,   961,   963,
    1057,     0,   639,     0,   833,   669,   662,   680,   678,   734,
     724,     0,   734,   734,   689,   707,   684,     0,   799,   697,
     688,   709,   712,   714,   716,   734,     0,   799,   677,   676,
     686,   673,   734,   757,     0,     0,     0,     0,   753,     0,
     827,     0,     0,   760,   657,   750,   752,     0,     0,   710,
     799,   666,   807,   806,   668,   799,   806,   734,     0,   748,
     734,     0,   141,   146,   157,   158,   912,  2610,     0,  2608,
       0,  1111,  1484,   104,     0,     0,   214,   212,   213,     0,
     207,   209,   204,  2626,     0,  2633,     0,     0,  2631,   468,
     470,   478,   566,     0,     0,  1544,   890,     0,     0,     0,
    1704,  1281,   743,   741,   744,   742,   795,   794,   798,     0,
     797,   806,   730,     0,  1284,  1285,  1309,  1379,  1370,  1307,
       0,  1261,  1339,     0,     0,  1316,  1291,  1294,  1292,  1297,
    1298,     0,  1323,     0,  1144,  1144,   631,  2563,  1183,  1833,
    1831,  2518,     0,     0,  2514,  2512,     0,  2513,  2511,  2485,
       0,  2440,  2441,  2439,  2426,     0,     0,     0,  1152,   508,
       0,   525,   524,   521,  1549,  1672,  1674,  1680,  1669,     0,
    1523,  1538,   780,  1596,     0,  1146,  1034,     0,     0,  1425,
       0,  1429,  1434,  1430,     0,  1421,  1419,     0,  1560,  1478,
       0,  1549,  1544,   959,     0,   652,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   985,  1926,   975,   482,
     977,   942,     0,   947,   607,     0,   832,     0,   837,   738,
     739,   740,   690,   735,   737,     0,   692,   660,   685,   715,
     691,     0,   687,   674,   763,   764,   766,   765,   762,   772,
     755,   773,     0,     0,   767,   768,   769,   761,   751,   759,
     754,   665,   667,   671,   672,   658,     0,   659,  1960,   148,
     928,   317,  2612,  2620,     0,  2622,  2615,   129,  2630,  2640,
     211,     0,     0,   152,     0,   202,   787,   205,  2547,  1883,
       0,   473,   864,     0,   889,     0,   866,   868,  1561,   805,
     803,     0,     0,  1341,  1343,   809,     0,  1452,   632,  2491,
    2490,  2489,  2486,     0,     0,     0,     0,     0,     0,  2516,
    2520,  1683,     0,     0,     0,   516,     0,     0,   550,   564,
    1531,  1544,     0,  1549,     0,  1601,  1594,  1036,  1447,     0,
       0,     0,     0,     0,  1692,  1466,  1467,     0,     0,  1472,
    1476,  1457,  1542,   958,     0,     0,   864,     0,     0,  1928,
    1927,   951,  1010,     0,   830,     0,   834,   835,   836,     0,
     828,   736,     0,   896,     0,   756,   758,     0,   150,   343,
       0,   329,   315,     0,     0,     0,   319,   159,   162,   160,
       0,   161,   167,     0,   168,   169,   170,   171,   172,   163,
     341,   342,   166,   164,   165,     0,  1977,     0,  1978,  1127,
       0,     0,  2618,     0,  2614,  2543,   178,   208,     0,     0,
     144,   153,  2634,   770,   471,   469,     0,  2543,     0,  1677,
     113,   865,   881,   880,   870,  1544,     0,     0,   116,   867,
     883,   874,   119,   869,   882,   872,   728,  1259,  1325,  2487,
    2521,  2524,  2522,  2523,  2525,  2519,     0,  1438,  1153,     0,
     509,     0,   512,   514,   528,     0,  1677,     0,     0,  1677,
    1677,  1677,  1677,   543,   551,   553,     0,  1532,  1533,     0,
    1528,  1530,  1524,  1585,   781,  1886,  2550,  1426,     0,  1431,
       0,  1423,  1462,  1462,  1473,     0,   864,   644,   866,   868,
     978,     0,   831,     0,     0,   799,     0,   799,   149,     0,
     142,     0,     0,   328,   331,     0,     0,   334,   324,   323,
     325,     0,   318,   317,   317,   371,   322,   368,   367,   360,
    2621,     0,  2547,     0,     0,     0,  2616,  2641,   210,  1152,
     156,     0,   475,   474,   879,     0,   994,   871,   888,   891,
       0,   994,   875,   994,   873,  1689,  1697,     0,  1873,     0,
     517,   510,     0,     0,   526,     0,  1677,  1677,     0,     0,
       0,     0,     0,   523,   552,  1677,  1544,     0,  1135,     0,
    1894,  1448,     0,     0,     0,  1470,  1468,   648,   647,   645,
     646,     0,   843,     0,   842,     0,   839,   838,   694,   897,
     696,   151,   344,   355,   358,   350,   330,     0,     0,     0,
     320,   317,     0,   304,   302,   303,   309,   310,   311,   312,
     313,   314,   305,   308,   306,   307,   317,     0,   219,     0,
       0,  2619,  2617,     0,  2623,     0,   188,   187,   179,     0,
     317,  2627,     0,  2635,  2547,   878,   114,   884,   117,   120,
       0,     0,   780,   504,   516,   513,   536,   529,   532,     0,
     561,     0,     0,  1580,  1578,  1579,   557,  1581,   558,   556,
     554,   547,     0,   545,     0,  1529,  1586,     0,     0,     0,
       0,  1887,  1889,     0,  1602,  1428,  1433,     0,  1463,     0,
       0,     0,   964,   845,   846,   844,     0,     0,     0,     0,
     317,   351,     0,   326,     0,   335,     0,     0,   217,   374,
     372,   215,   362,   362,  2624,  2625,   189,  2642,     0,   158,
     178,   476,  1696,  1698,  1874,   511,   536,     0,   534,     0,
     530,   527,   531,   559,   560,     0,   544,     0,   555,     0,
       0,     0,     0,     0,  1888,     0,     0,  1895,  1897,  1465,
    1464,  1479,     0,     0,     0,   352,   358,   348,   356,   317,
       0,     0,   316,     0,   370,   218,     0,     0,     0,   317,
       0,   361,   363,   365,     0,   140,  2636,  1900,   533,     0,
     541,   537,   539,   542,   550,   549,   546,  1588,  1892,  1893,
       0,  1890,     0,     0,  1896,     0,     0,   841,   840,     0,
     349,     0,     0,   347,   327,   332,   317,   375,   317,   229,
     228,     0,   221,   297,   369,     0,   220,  2628,   317,     0,
    1886,   535,     0,     0,   548,  1591,     0,  1589,  1891,  1899,
    1898,  1471,  1469,   353,     0,   317,     0,   317,     0,   317,
       0,     0,     0,     0,     0,   216,   317,  2637,     0,  1894,
     540,   538,  1587,     0,     0,   345,   317,   333,   338,     0,
       0,   224,   298,   299,     0,   226,  2629,     0,  1902,  1590,
     317,   317,   334,   337,   376,   373,     0,   300,   222,   223,
     234,   233,     0,  1901,     0,  1906,   317,   317,   339,   242,
     240,   317,   230,   238,   232,     0,   239,     0,   227,     0,
       0,  1913,     0,   225,   241,   301,  1904,  1905,  1903,  1908,
       0,     0,  1910,  1911,     0,  1875,   231,  1912,  1907,     0,
    1914,  1916,     0,  1909,     0,  1152,  1915,     0,  1153,  1917
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,    56,   599,  1462,    57,    58,    59,    60,    61,  1313,
      62,   806,  1245,  1763,  1764,    63,   542,    64,  1023,  1533,
    1534,  3056,  3057,  1535,    65,  2140,  3093,  4136,  3094,  4141,
    3095,  4143,  1552,   510,   511,  1983,  1984,  1048,  3077,  3043,
    3859,  3047,  3968,  4100,  4010,  2066,  3414,  3860,  3861,  3977,
     537,  2138,  1482,  4127,  1963,  4228,  1964,    66,   631,  1021,
    1506,  1507,  3432,  3433,  3687,  3434,  3679,  3680,  3681,  3682,
    4359,  4201,  4301,  4360,  4432,  4466,  4472,  4401,  4481,  4482,
    4483,  4470,   874,  4484,    67,   565,   566,   876,  1343,  1777,
    1344,    68,    69,   536,  1265,  1266,  1267,  1268,  2316,  1778,
    2311,  2312,  3212,  4402,  4468,  4487,  4202,  4203,  4107,  4204,
    3980,  4205,  4111,  4206,  3983,  4207,  4208,  4209,  4210,  4351,
    4211,  4106,  4394,  4198,  4199,  4353,  4448,  4463,  4212,  3990,
    4101,  4288,  3991,  4102,  4346,  4194,  4347,  4389,  4444,  4195,
    4289,  4392,  4292,  4213,  4219,  4361,  4214,  4220,  4215,  3995,
    4118,  4218,  4116,  4217,  4357,  4356,  4428,  2663,  3076,   618,
     619,   642,  2130,   620,  1037,   994,  1484,  1996,  1997,  2514,
    2515,  2645,  2646,  2647,  1988,  1989,  1990,  2118,  2119,  2120,
    1970,  1971,  1972,  1488,  1967,  1968,   621,   995,  1005,  1991,
    1992,  1993,  2651,  2122,  2123,  2124,  2125,  1233,  1234,  2932,
    2669,  3086,  3878,  3442,  4017,  4234,  3087,  3088,  2589,  2998,
    2076,    70,   554,   854,  1310,  2365,  1311,  2367,  2817,  2818,
    2819,  1813,  1814,  3759,  1818,  2364,  3915,  4244,  4051,  4052,
    2821,  4050,  2825,  3237,  3238,  3525,  3761,  3918,  4249,  4153,
    4321,  4247,  4317,  4248,  4319,  4413,  4371,  4372,  4163,  4262,
    4263,  4325,  4374,  4063,  4064,  4065,  2385,  2831,  3764,  3693,
    2112,  1474,  1475,   512,   513,   514,   639,  2670,  2051,  2671,
    2672,  3020,  2053,  2054,  2790,  1397,  3011,  2985,  3734,  3083,
    3024,  3025,  3026,  3027,  3028,  3034,  2949,  2524,  2525,  2594,
    3037,  3876,  3611,  3626,  3398,  3399,  3400,  3401,  3402,  3403,
    3404,  3112,  3113,  3110,  1096,  3822,  3823,  3824,  3106,  3107,
    3660,  3644,  3645,  3646,  3877,   769,  3840,  3461,  1365,  1366,
    3925,  1376,  1377,  2409,  1856,  2410,  1478,  3462,  3463,  3464,
    3654,  3167,  3731,  3173,  3174,  3175,  2753,  2754,  2755,  2756,
    2757,  2255,  3647,  3036,  3604,  3815,  3818,  3960,  4186,  2526,
    2950,  2527,  2953,   945,   515,  2528,  2529,  1566,  1567,  4020,
    4028,  4032,  4021,  4033,  4029,  4022,  4023,  4024,  4035,  4031,
    2676,  3694,  3695,  2942,  3183,  3962,    71,  1494,   988,   997,
     993,  1013,   626,  1495,  1006,  2067,  2600,  3666,   608,  2055,
    3596,  3327,  3600,  2056,  2964,  2057,  3314,  3581,  2058,  3344,
    3598,  3812,  2965,  2966,  2059,  2060,  2061,  3326,  3336,  3952,
    3193,  3194,  3195,  2530,   125,  2303,  3032,  2573,    72,  1440,
      73,   959,   960,   961,  2459,  2460,  2900,  3291,  3558,   954,
     955,   956,  1929,  2457,    74,   634,  1539,    75,  1321,  2377,
    2378,  2379,    76,  1014,    77,    78,   635,  1546,  1547,  1548,
      79,  1306,   132,    80,   862,  1316,  1318,  1319,    81,   630,
    1015,  1016,  1017,  1018,  2072,    82,  1805,  2341,  2342,  2343,
    2344,  1503,  2602,  1504,  1505,  2081,  3230,    83,    84,   596,
    2263,   571,   883,   572,   573,  1850,  2400,  3735,   894,   895,
     896,  2859,  1355,  1356,  1357,  2405,  2864,  1093,   770,   771,
     772,   773,  1187,  1188,  3648,   774,  1197,  1724,   775,   776,
     777,   778,   779,   780,  1751,  3139,  3140,  3480,  2290,  2291,
    2292,   781,  2177,  3124,  2191,   782,  1180,  1709,  1640,  3472,
    3131,  1583,  2160,  2706,  2786,  2257,  1118,  1119,  1083,  2167,
    1589,  1936,  1937,  1938,  1939,  1940,  3569,  3568,  3570,  3929,
    3780,  3931,  3784,  2470,  1833,  1834,  1941,  1942,  2901,  3778,
    4076,  2258,  2259,  2260,  3498,  2902,  3295,  2920,  2921,  3791,
    2461,  1943,  2908,  4175,  3938,  3939,  4281,  4280,  3940,  3789,
    3790,  3574,  3575,  3052,  3053,  3054,  2845,  1630,  1631,  1638,
    1293,  1294,  1584,  2339,  2806,  3771,  3922,  2281,  3544,  3920,
    4070,  2064,  2993,  2994,  2402,  2403,  2924,  3311,  3341,  1400,
    3736,  2808,  1902,  1903,  3700,  4471,  2933,  2618,  4256,  2361,
    2362,  4168,  4329,  4416,  4417,  3266,  3267,  3548,  3549,  2404,
    2856,  3268,  3772,  4075,    85,   519,    86,  1761,  2296,  2789,
    1242,  2308,  1025,  1323,  1570,  1571,   794,   532,  1235,  1236,
    1237,    87,   543,  2340,    88,   561,  1831,   846,   866,  1324,
    1325,  2386,  2832,  2839,  2387,  2844,  3535,  2834,  3243,  3244,
    2298,  2299,  2835,  3246,  3532,  3515,  3516,  3225,  3756,    89,
     584,  3306,  2915,  2916,  4145,  4146,   867,    90,   518,  1070,
    2684,  1576,  2148,  1071,  1072,  2151,   660,   661,    91,   963,
     581,  1422,  1423,  1424,  1918,    92,   575,   946,  2886,  2892,
    1897,   858,  1238,  1404,   949,  1405,  1883,  2438,  1386,    93,
     984,   983,  1469,    94,   604,  1470,    95,   807,  1259,  1773,
    2794,  3198,  3506,  1260,  1261,  2309,    96,   562,   871,   872,
    1328,  1836,    97,   556,   859,  1824,    98,   547,    99,   100,
     850,  3231,  4242,  4367,   551,  1807,  1302,  3443,  4170,  4271,
    4272,  4274,  4337,  4338,  4410,  4475,  4498,  4491,  4501,  4502,
    4505,  4510,  4511,   784,   970,   785,  3806,   786,   787,   788,
    2840,  2841,  3312,   789,  2842,   790,  2943,  1026,  1573,   540,
     490,  2607,   615,   971,  2814,   792,  3997,   991,  1041,   492,
     493,   101,   574,   910,  1381,  1371,  1380,  1876,  2426,  1880,
    2428,  2429,  3280,  2882,  3281,  2883,   950,  1872,  1877,  2884,
    1881,   913,  1865,  1866,  1867,  1868,  2875,  1862,  2435,   102,
     851,   497,  1304,  1305,  2350,   103,   583,   104,  1295,  1801,
    1802,  2336,  2805,  2337,   105,   879,   106,   833,  1795,   834,
    1271,   835,   836,  1285,  1279,  1288,  1282,  3903,  3748,  3749,
    2324,  1241,  1042,  1043,  1787,  2318,  2319,  3510,  3751,  3216,
    3909,  3910,   107,   133,   500,   637,  1032,  1349,   108,   109,
     110,   111,  1352,  1457,  2396,  1458,  2264,  1459,  1460,  1950,
    1848,  1705,  1706,  3181,  1177,  1178,  2267,  2762,  2763,   897,
     646,  1058,  1050,   126,   127,   128,   649,   650,   129,  1011,
    1012,  2601,  3049,  3416,  3669,  3670,  3865,  4005,  4001,  4002,
    3999,  4004,  1052,  3872,  4308,  4436,  1053,  1054,  3078,  3874,
    4131,  4310,  4408,  1055,  2660,  3429,  4006,  4230,   112,   972,
     593,  1455,  1450,  1452,  1946,  2477,   113,   114
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -3853
static const int yypact[] =
{
    5290,  2245,   114, -3853,  -160,   712, 47629,   767,   961,   961,
     467,  3179, -3853, -3853, -3853, -3853, -3853,  2857, -3853, 47629,
     114,  1064, -3853, 23696, -3853, -3853,   808,   135,    73,   961,
     114, -3853, 47629, -3853,   934,  1369,   114, -3853, -3853, 41499,
   -3853,   467, 47629, -3853, -3853, -3853, 41499,  1028,   828,   806,
    1019, -3853, -3853, 47629,  2619,   520,  1441,  1318, -3853, -3853,
    1118, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, 24312, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853,  1333, 47629,  1385, 47629, -3853,
    1422, 47629, 39660, 47629, -3853,  1076,  1499, -3853, -3853,  1563,
   -3853, -3853,   961,   467, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853,  1041, -3853, -3853,  1174, -3853, -3853, -3853, -3853, -3853,
    1716,  1585, -3853,  1628, 39660, -3853, 47629, -3853, -3853, -3853,
     213, -3853,  1345, -3853,  1346,  1674,  1697,  1717,   852, 11183,
    1730,  1730,  1730, 47629,  1768,  1730,  1730, 47629, -3853,  1730,
   -3853,  1730,   961, -3853, -3853, -3853,  1843,  3827, 47629,  1610,
     151,   -80, 39660,   174, 47629, -3853, -3853, 11183, -3853,  1750,
   -3853, -3853, -3853,   961,  1957,  1822,   999, 47629, -3853, -3853,
     961,   899,  1246,  1428, -3853, -3853,  1550, -3853,  4151,   136,
   -3853, -3853, -3853,  2500, 26160,  6219,  1550,   542,  -109,   542,
   -3853, -3853, 47629,   961,  1749, -3853, -3853,   266,   266,   266,
   -3853,   266, -3853,   266, -3853,   520,  1406, -3853, -3853,  1405,
   47629,   827,  1894,   885, -3853, -3853,  1414,   736, -3853,  1485,
   36595, -3853, 47629, -3853, -3853, -3853, -3853,  1705, -3853, -3853,
   -3853,  1675, -3853, 36595, 23696, 47629,  1590, -3853, -3853, -3853,
   23696,  1459, 47629, -3853, 23696, 23696,   215,  1081,    71, 47629,
   47629,  1924, -3853,  2105, 36595,  1704, -3853,   127,  1142,  1563,
    2134, -3853,  1585, -3853, 47629, 47629, 47629, -3853, -3853, -3853,
   42112,   852,  1523,  1528,  1532, 15621, -3853,  1540,  1558,  1562,
   11183,  1564,  1567,  1575,  1602,  1622,  1629,  1634,  1647,  1664,
    1664,  1667,  1669,  1678,  1682,  -128,  1689, -3853,  1707,  1713,
    1715, -3853, -3853,  1725,  1743,  1751,  1760, -3853,  1763,  1770,
    1773, 11817,  1792,  1797, -3853, 20607,  1799,  1808,  1815,  1817,
    1834,  1840,  1842,  1846,  1870, -3853, -3853, 11183,  1667, -3853,
   -3853,  1881, -3853,  1884,  1889,  1899,  1903,  1906,  1908,  1922,
    1927,  1931,  1939,  1942,  1945,  1949,  1959,  1962,  1966,  1971,
    1667, -3853,   863,  1997,  2000,   900,  2006, -3853,  2008, -3853,
     273,  2024,  1664,  1667,  1667,  2026,  2039,  2047,  2068,  2078,
    2083, 15621, 15621, 15621, 11183, -3853, 47629, -3853, 47629, -3853,
    1255,  2466, -3853,  2669, 15621,   185, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853,  1515,  1645, -3853, -3853, -3853, -3853, -3853,
   -3853,  2094,  1653,  2102, 47629, 47629, 47629,  1958, 47629, 47629,
   39660,   765, 47629, 36595, -3853,  1730,  1728,  3170, 29235,  1925,
    1883,  1614, -3853, -3853, -3853, -3853, -3853,  1991, -3853, -3853,
    1905, -3853,  2015, -3853, -3853,   172, -3853,    93, -3853, -3853,
   -3853, -3853, -3853, -3853,  2120,  2096, -3853, -3853,   105, -3853,
   -3853, 47629, -3853, -3853, -3853, -3853,  2509,  2246,  1255,  2692,
     188, 23696, -3853,  1542, -3853,  -192, -3853, -3853,  2478, -3853,
   -3853, 36595, 23696, -3853, -3853, -3853, 21225, -3853, -3853,  2719,
   -3853,  2139, -3853, -3853,  1645,  3435, -3853,  1925,  2411, -3853,
    2419,  2324,  1081,  2213, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853,  2176,  2500, -3853, -3853,   389,  2332,
    2175,   415,   418, 34143,   100,   448,    77, 26775, 34756,  2183,
   -3853, -3853, -3853,   108,  2664, -3853,    -1,  2202,  1771,    -1,
   37208,  2571,   203, -3853,   144, -3853,  2650, -3853, -3853, -3853,
   -3853,  2326,  2316, -3853, -3853,   292,  2384, -3853,  2693, -3853,
     727, -3853,  2344,  2571,    -1,   203, -3853,  2584,  2708,   396,
    1115, -3853, -3853, -3853, -3853,  2234, -3853,   -87,  2786, -3853,
    2238, -3853, -3853, 23696, -3853, -3853,  2509, -3853, -3853, -3853,
    2241, -3853,  2511,  2342, -3853, -3853,    30, -3853,  2247,   799,
    2728, -3853, 39660,   891, 37821, -3853, -3853, -3853,  2762,  2778,
    1664,  2248, -3853, -3853, -3853,  2880, -3853, -3853,  2259,  2805,
    2805,  2805,  2887, -3853, -3853, -3853,  2280,  2525, -3853, -3853,
    2448,  2318, -3853,  1590, 23696,  2678,  2287, -3853, -3853,  2535,
   11183, -3853, -3853,  4248,    28, -3853, -3853,   262, -3853,  2866,
    2494, -3853, -3853, -3853, -3853,  2761, -3853, -3853,  2880,  2822,
    2805,  2717,  2304, -3853, -3853, -3853, -3853, -3853, -3853,  1632,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853,  1686, -3853, -3853,
   -3853, -3853, -3853,  1590, -3853, 23696, -3853, -3853, -3853, 23696,
   -3853,  2307, -3853,  2305, -3853, 11183, 11183,  1077,  2881,  2938,
    2938,  2938,  1255,  2349, 11183, 11183, 11183, 11183, 11183, 11183,
   11183,  1407,  2325, -3853, -3853,   -96, -3853,  2333, 11183, 11183,
   -3853, 11183, 11183, 24928, -3853,  4861, 11183, 11183,   300,  2820,
   11183, 11183, 11183, 11183,  2941, 11183, 11183, 24928,  2957,  2340,
   -3853,  2331,  1409, 11183, 11183,  1466, 11183, 11183, 11183, 11183,
   11183, -3853, -3853, 11183, 11183, 11183, 11183, 15621, 11183, 11183,
   11183, 11183, 11183, 11183,  2345, 11183,  2938,  2938, 11183, 11183,
    1578, -3853, -3853, 11183,  2343,  2343, -3853, 11183,  8013, 11183,
   -3853, -3853, -3853,  2348, -3853, -3853, -3853, 24928,  2938,  2938,
   11183, 11183, 11183,  2881,  2881,  2881,   349,  2351,   673, 11183,
   27390,  2336, -3853, -3853, -3853, -3853, 11183, 11183, 11183, -3853,
   15621, -3853, -3853,  1413, -3853, -3853, -3853, 12451, 15621, 15621,
    2350, 15621, 15621, 15621, 15621, 15621,  2725, 15621, 15621, 16255,
   16889, 15621, 15621, 15621, 15621,   198,  2881, 39660, 15621, 11183,
   -3853, -3853, 47629, -3853, -3853, -3853,  2357, 23696,   765, -3853,
   -3853, -3853, -3853, -3853, -3853,  2360,   765, -3853,  2844, -3853,
   -3853,  2376, 23696, -3853,  2372, -3853,  2736, -3853,  2737,  2738,
    2742, -3853, -3853, -3853,  2977,  2752, -3853,  2754, -3853, -3853,
    2397, -3853, -3853, 17523, 39660, -3853,  2398, -3853,  2876, -3853,
   -3853, -3853, -3853, -3853, -3853,  2499, -3853, -3853, -3853,  2407,
   -3853, 36595,  2407, -3853, -3853,  2407, -3853, -3853,  2407,    26,
    4268, -3853, -3853, 47629, -3853, 48242, -3853, 21225,  -160, -3853,
   -3853, -3853,  2772,   193,  2416, -3853, 23696, -3853,   120,   120,
    2660,   200, 39660, -3853, -3853,   125,  2428,  2487,  2429, -3853,
    2495, 23696, 23696, -3853, -3853, -3853,  2679, -3853,  3055,  1246,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853,  2436,  2914,  2438, 36595,    52, -3853, 47629,
   -3853,  1583, -3853, -3853, -3853,  2442, -3853, 11183, -3853, -3853,
   47629, -3853, -3853, -3853, -3853, -3853,  3012, 11183, -3853, 36595,
     -71,    94,  1327,   108, -3853, -3853, -3853, -3853, -3853, 47629,
   42725,  2449, -3853,  2845,  -160, 11183, -3853,  2459,  1585, 47629,
   47629, 47629, 23696, 47629, 23696, -3853,  1062,  1062, -3853, 35369,
   -3853, -3853, -3853, -3853,    -1, 47629, 47629,    -1, 36595, -3853,
     203, 47629,    -1, -3853,  2846,  2555, -3853, -3853, -3853,  2916,
   -3853, -3853,  2907,  2464, -3853,  2845, -3853, -3853,   203, -3853,
   -3853, 23696, -3853, -3853,   203, -3853,   203,   203,    -1,    -1,
    2522,   542, -3853, -3853,  2617,  -109, -3853,  -173,   266,  2718,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
      74, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853,   212, -3853, -3853, -3853,  1929,  2978,
   -3853, 39660,  2925,  -106,   759,  2925,  1205,  -160,   207, -3853,
     207, -3853, 36595,  2944,  4857,  2757,   927, 23696, -3853,  2482,
   43338, 23696, -3853, -3853, -3853,  1388,  2485,  2490,  1255,  2968,
    2972,  2973,  2976,  2981,  2983,  2985,  2986,  2989,  2991,  2992,
    3003,  3004,  3007,  3009,  3010,  3013,  3014,  3016,  3017,  3018,
    3020,  3023,  3024,  2521, -3853, -3853, -3853, -3853, 23696, -3853,
   -3853, -3853, -3853,  2597, -3853, -3853, -3853, -3853,  1759, -3853,
   -3853, -3853,   244,  2279,  2569,  2580,    95, 36595,  2990, 47629,
   47629,  1585, 47629, 47629, -3853, -3853,  1134,  2819,  2829,  2831,
    2564, -3853,  2679, -3853,  1227, 47629,  3008, 31078, -3853,   134,
    1084, -3853,  2938,  2568, -3853,  2570,  2574,  2575, 11183,    47,
     159,  1086,  1038,  1326,  1093,   536,   362, -3853,  2582,  2577,
   -3853,  2586, -3853, -3853,   596,   656,  1112,  1129,  2589,  2590,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
    3011, -3853,   830,  1362, -3853, -3853, -3853, -3853,  2579, -3853,
   -3853,  1135,   834,   847,   380,  2600,   873,  1426,  1431,  2595,
   24928, 47629,  2938,  2604,  1164,  1208,  2938,  2608,   906,  1281,
    1609,  1635,  1639,  1296,  1321,   918,  1651,  2271,  1365,   932,
     946,  1373,   953,   974, -3853,  1401,  2609,  2610,   986,   392,
    2938,  2611,   402,  2594,  2605,  1438,  9281,  9915, 10549,  1067,
     990, -3853,  2618, -3853,  2331,  2620,  2625,   502,   221,  1460,
   -3853, 11183, -3853, -3853,   705,    83,  2672,   122,  1327, -3853,
    2780, 47629,  2313,   178, -3853, -3853, -3853, -3853, -3853, -3853,
     764, -3853,  2628, -3853,  2633,  1982,  2640, 11183,   957,  2640,
    2764,  2136,  2136, 15621,  2606,  2798, 11817,  1480, 11817,  1480,
    2640,  2640,  2640, -3853, 15621,  2639, 15621, 15621, -3853,  2881,
    1255,  2641,   565, 47629, -3853,  2360,  1162, -3853,   108, 36595,
     141, 23696, 39660,  2638, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853,  3275, 23696,  2735,  2739,  2740, -3853, 29850, -3853,
   -3853, -3853, -3853, 29850,    -8, -3853, 47629, -3853,  2727, -3853,
   -3853, -3853, 21841, 21841, -3853, 21841, -3853, -3853,   394,   742,
    2933,  2680, -3853, -3853, -3853, 23696, -3853,  3063,   671, 23696,
    2482,  2670, -3853, -3853, -3853, -3853, -3853,  2224,  2774, -3853,
    3293, -3853, 11183,  -160, -3853, 36595, 36595, 23696, 23696,   782,
   -3853,  1740,  2675, -3853, -3853, -3853, -3853, -3853,  3435, 17523,
    3106,  3118, 21841, 21841, 21841, -3853, -3853, -3853, -3853, -3853,
    1339,  1255, -3853,  2671, -3853, 38434, -3853,  1255,   108,  2681,
    2682, -3853, -3853,  3061,   714, -3853,  2683,  2702, -3853,  2697,
    2698,  2699, 43951, 11183, -3853,    94, -3853, -3853,   108, -3853,
   -3853,  8647,  -160,  3154, -3853,  1255,  2713, 47629, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853,   -60, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853,    -1, -3853, -3853, -3853, -3853, -3853,  2935,  2571,  2384,
    3154,    -1,   203, 23696,    -1,    -1, -3853, -3853,  3038,  2765,
   -3853, -3853, -3853, -3853, -3853, 47629,  1865,  2871, -3853,  2721,
   -3853, -3853, 23696, -3853,  2722, -3853,  3163,  3309,  2571, -3853,
   -3853, -3853,   108,   108,  3021, -3853,  -160,  2848,  2855,  2860,
    2865,  2867,  2910, -3853, -3853,  -160,  -160, -3853, -3853,   108,
   -3853,  1616, -3853, -3853, -3853, -3853,  -160,  -160,  -160,  -160,
    2530,  -160,  -160,  1732, -3853, -3853,   108,   108, -3853,   199,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853,   240, -3853,  2993,
   -3853,  2337,   108,  3307,  2995,   108,   108,  3307,   108,  3030,
    3031,   108,   108,  2827,  3262,   108,  3147,  2864,  1951,  3157,
     108,  3034, -3853,  2872,  3271,   108,   108,   108,   108,   108,
    3307,  3035,  3383,   108, -3853,   108,  3046,  3049,   216,  3052,
    3053,   108,   108,   108,   108,   883, 47629,   108,  3060,   108,
   -3853, -3853,  5514, -3853, -3853, -3853, -3853, -3853, -3853,   771,
   22460, -3853, -3853, -3853, -3853,   412, -3853,  3015, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
    2816, -3853, -3853, 11183,  2817,  2530,  -160,  2530,  2530,  -160,
    -160,  1557,  -160,  2530,  2530,  -160,  -160,  -160,  -160,  -160,
    -160,  -160,  2530,  2530,  -160,  1739,  -160,  2530,  4248, -3853,
   -3853, -3853, -3853,   248,   108,   108,   108,   108, -3853,  1724,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, 39660,  3175,
    1823,   819, 39660, -3853, 47629, -3853,  1754, 47629,  2821,  -150,
    3458,   886,   886, -3853, 23696, 23696, 23696, 47629,  2862, -3853,
   31078, -3853, -3853,  -173, -3853,  2818, 13085, -3853,  2823, -3853,
   11183, -3853, -3853, -3853,   924, 11183, 11183,  3310,  2371, -3853,
   39047, -3853, -3853, -3853, 11183, 39047,  2371, 11183, -3853,  2830,
   -3853,  3224,  3226, -3853, -3853, -3853, -3853, 11183, 11183, -3853,
   11183, 11183, -3853, 11183, 11183, 11183, 11183, 11183, -3853, -3853,
   15621, -3853,  2824,  2832, -3853, -3853, -3853,  2834, -3853, 11183,
   -3853, -3853, -3853, -3853, -3853, -3853, 11183, -3853, 11183, -3853,
   11183, 11183, -3853, 11183, 11183, -3853, -3853, -3853, 13719, 11183,
   11183,  2837, -3853, -3853, 11183, 11183, 11183, -3853, 11183,   167,
   11183,   255, 11183,  1572, 11183, -3853, 11183, -3853, -3853, -3853,
   -3853, 11183,   368,  2224,  2530,  2839, -3853,  1737, -3853, -3853,
     337, -3853,   705,  2840, -3853, -3853,  1583, -3853, -3853, 39660,
   11183, -3853, -3853, -3853, -3853, -3853, -3853, 15621,   507,  2842,
   15621, -3853,  2764,  2941,  2941,  2018, 11183,   957,  2764, 11183,
    2843,  2847, -3853, 11183, 47629, -3853, -3853, -3853, -3853, 39660,
   -3853, -3853, -3853, -3853,   141, -3853,  2372, -3853,  2482, -3853,
    3320,  2849, -3853, -3853, -3853, -3853, -3853, -3853,  1752, -3853,
   36595,  2838, -3853,  2850,  2926,  2937,  2939, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,  2571,
    1740, -3853,  2868, -3853, -3853,  2535,  2949,  2883,  3232, -3853,
   -3853, -3853, 47629, 15621, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853,  3456,  2873,  2874,  3352,  2879,  1255, -3853,
    2955, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,   818,
   -3853, -3853,  2884,  2884, 19373, -3853, -3853, -3853, 47629,  3360,
   -3853,  3155, 36595,  3340,  3344,  3345,   888, -3853,   420, -3853,
     171,  3300,  2571, -3853,  3353, 40273, -3853, 31691, -3853, -3853,
   -3853, -3853,   -71,  3000,  3001,   -46, -3853, -3853,  3299,  3132,
   -3853, -3853, -3853,   108,  1255, -3853,  2449,  8647,  2920, 28005,
   -3853, 15621,  1707, -3853,  1255, -3853, -3853,  1557, -3853,    61,
   -3853, 35369, 35369, -3853,  3195, -3853, -3853, -3853, -3853,  2680,
     203, -3853, -3853,  3399, -3853,  3400, -3853,  2924,  3402, -3853,
    3173, -3853,   964,  3315,  3316, -3853,  3189,   897,  3189,   964,
     964, 24928,  -173,  2679, -3853,  2530,  3244, -3853, -3853, -3853,
   38434, 35982, -3853, -3853, -3853, -3853,  3461, -3853,  3462,  1201,
   -3853, -3853,  2004,  1286, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,  1205,
    2004,  2004,   558, -3853,    84, -3853, -3853, -3853, -3853,  3404,
   -3853, 25544,   114, -3853,   306, -3853, 25544, -3853,  1388,  1388,
   -3853, 44564, 25544,   114,  1557,  2530, 25544,  2530, 45177,   114,
    -160,  -160,  2354,   108,  2530, -3853, -3853,  3321, 47629,  3325,
   25544, 25544, -3853, 39660, 47629, -3853,   108,   895,  2530, 45790,
    1557,  1557, 25544,   114, 24928,  2314, -3853,  -160,   114, -3853,
   -3853, -3853, -3853, 23696,   114,   114,  1864,  2414,  2656,  2930,
   -3853, -3853, -3853,  2530, 45177, -3853, -3853,  6066, -3853, -3853,
   -3853, 18757, 47629,  1082,   537, -3853,  2942,   910,   299,  3027,
    1541,  2947,  2956, 46403,  1255,  2530, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853,  -160,  2224,  2004,  2004,
    2366, -3853,  3218,  3387,   108, -3853,  2341, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853,  3045, -3853,  3572,  3143,
    2963, -3853, -3853,   261, -3853, -3853,   139, 23696, 18141, -3853,
    3209, -3853,  3092, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853,  2962,  -173,  2680,  1497,  2680,  2970, -3853, 11817,
    1482, -3853,  1255, 11183,  1255,  1508, -3853,  2969,  2969,  2971,
   -3853,  2979,  2969,  3366,  2971,  3367,  2984,  2996,  1517,  2999,
    3002,  1515, -3853, 11183, 11183,  1544,   620,  1549,  -119,   997,
    1004,   651, -3853,  1551,  2998, -3853, -3853,  1556,  1560,  1581,
    1592,  1020,  1594,  1786, 11817,  1626,   854,   812, -3853,  1630,
    1048,  1055,  1638, 11183,  1659, 11183,  1661, 11183,  1692,  1703,
    1709,  2982,  2982,   113, -3853,  3005, -3853, -3853, -3853,  3006,
   -3853, -3853,  2176,   337, -3853, -3853,  3029, -3853, -3853,  2997,
    1255,  3032, -3853, -3853, 11183, -3853,   185, -3853, -3853, 15621,
     817,  3033, -3853,  1255, -3853, -3853,  3036,  1515, -3853,   235,
   -3853, -3853, -3853, -3853,   219,  3311, 29850, -3853, 47629,   874,
    3019, 32304, 36595, 36595, 36595,  2987, 11183, -3853, -3853,  3246,
   23696, -3853,  3413, -3853, -3853, -3853, -3853,  3044,  3022, -3853,
   -3853, -3853,  2764,  3372,  3231, -3853, -3853,  2224, 47629, 36595,
   -3853,  2500, 24928, -3853,  3026, -3853,  3026,  1450,  3047,  1788,
   -3853, -3853, -3853,  3028,  2213,  1812, -3853, 17523,  3450,  2304,
   36595, 36595, 36595, -3853,  2680,  2680,   164,  3058,  3403, -3853,
   -3853, -3853, -3853, 47016, -3853, -3853, -3853, -3853,  1273, -3853,
    3048,  3051,   239,  3227, -3853, -3853, -3853, -3853,  8647, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853,  2571, -3853, -3853, -3853,
   -3853, -3853,  2571, -3853,    -1,  -160,  -160,  1721,  -160,  3487,
    3525,  -215,    83, -3853,  1731, -3853, -3853, -3853,  3414,   964,
    3189,  3189,  3418,  3283,   -76,  3037, -3853,   108, -3853,  2353,
   -3853,  2500, -3853, -3853, 11183, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,   240,
   -3853, -3853, -3853, -3853, -3853,  3054,  3401,  3426,  1388, -3853,
   25544, -3853, -3853, 25544, 25544, -3853, -3853,   794, 45177, -3853,
   -3853, -3853, -3853, -3853, -3853,  3056, -3853, -3853,  2224, -3853,
   -3853, 35982,  -160, -3853, 25544,  3056, -3853, -3853,   170, -3853,
    3041,  -160, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, 45177,  3057, -3853,   338, -3853, -3853,  1957, -3853,
   45177, -3853, -3853, -3853, 45177, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
    3062,  2189,  1107, -3853,  3064,  3059, -3853, -3853, -3853, -3853,
   47629, -3853, -3853, 23696, -3853, -3853, -3853,  4102, 47629,  3297,
   -3853, 11183, 11183,  3334, 47629,  3335, -3853,  3626, 47629,  3683,
   45177, -3853,  3073, -3853,  3076, -3853,  1819, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853,  3075, 47629,  2004,  1710, -3853, -3853,
    -160,   139, -3853, -3853, -3853, -3853,  3346,  3347, 47629, -3853,
   -3853, -3853, -3853,  3221, -3853, 23696, -3853,  3245, -3853,  3083,
     824,  4909, -3853,  3085,  3087,  3093, 31078,  2680,  3349, -3853,
   -3853,  2941, -3853,  1255, 11183,   800, -3853, -3853,   322,  3368,
   -3853,   976, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853,  3094,  2941,  2941, -3853, -3853, 11183,
   -3853,  3257, -3853, 11183, 11183, -3853, 11183, -3853,   905,  3099,
    3123, -3853, -3853, -3853, -3853, 11183, -3853, -3853,  2941, -3853,
   11183, -3853, -3853, 11183, -3853, 11183, 11183, -3853,  1711, -3853,
    1758, -3853,  1780, -3853, -3853, -3853,  2224,  3101,  3473, -3853,
   -3853, -3853,  2224,  3284, -3853, -3853,  2224,  2530,  2442, -3853,
   -3853,   673, 47629, -3853, -3853,  1825, -3853, -3853, 11183, -3853,
   40273, -3853, -3853, -3853,  3464,  3723, -3853,  3322, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853,  3539, -3853, -3853, -3853,  -152,
    -152,  -152, 14353,  1255,  3598, -3853, -3853, -3853,  3413,  3489,
   -3853,    57, -3853, 47629,  3115,  1543, -3853,  1828, -3853, -3853,
    3116, -3853,  2176,  3117, -3853,   108, 14353,  2884,  3245, -3853,
   -3853,  1450, 24928, 31691, -3853, -3853, 47629, -3853, 36595,  2304,
    2304,  2304,  2571,  3546,  2949,  2949, -3853, 28620, -3853, -3853,
    3272, -3853, -3853, 32917, -3853, -3853, -3853, -3853, -3853, -3853,
   28005, 43951, -3853, -3853, -3853, -3853, -3853, -3853, -3853,  -160,
    3596,  3370,  1583,  2469, -3853,  -173, -3853,   964, -3853,  3510,
    3511,   964, -3853, -3853, -3853, 24928,  2680, 14353, -3853,  2176,
    1255,  3129,   338, -3853,  -110, 11183, 25544, -3853, -3853, -3853,
    3133, -3853, -3853,  3645,  3647, -3853, 25544,  1759, 47629, -3853,
    3012, -3853, -3853, -3853,  3230, -3853,  4102, -3853, 24928, -3853,
   -3853, -3853, -3853, -3853, 47629, -3853, 23696, -3853, 18757, -3853,
    3140, -3853,  2969,  2969,  2969, -3853, -3853, -3853,  2971, -3853,
    2979,  3374, -3853,  2979,  2979, -3853, -3853, -3853, -3853, -3853,
     322,  2160, -3853, -3853,   322, -3853, -3853, -3853,    90,  1370,
    2979, -3853, -3853, -3853, -3853, -3853, -3853, -3853,  2969,  2971,
    2971, -3853, -3853,   322,  2969, -3853,  2969,  2858, -3853,   329,
      99,  2969,  2969,  2969,  3146,  3135, -3853,  1255,  2941,  3699,
   -3853, -3853,  3292,  -160,  3641, -3853,  1837, -3853,  3149, -3853,
   46403, -3853,  2530,  1205, -3853, -3853, -3853, -3853,  3291,  1245,
   -3853,  3323,  3152,  3153, -3853, -3853,  -160,  3156,  3158,  5514,
   -3853, -3853, -3853,  3769, -3853, 47629, 47629, 47629,  2818, -3853,
    3532,  1083,  1255,  3165,  3166,  3167,  3168,  3767,   123, -3853,
    3770, 39047, -3853, -3853, -3853,  3171,  1848, -3853,  3174,  3176,
    1785,   266,  3177,  1811,  1065,  1851,  3478,  3557, -3853,  3406,
   -3853,  1854,  1147,  1874,  1879,  1890,  1923, -3853, -3853, -3853,
   -3853, -3853,  3180, -3853, -3853,   190, -3853,  3178,   902,    83,
   -3853, -3853,  1855, -3853, -3853, -3853,  3642,  3547,  3463,   145,
    3220,  3220,  3220,  1707,  1255,  1861, -3853, -3853, -3853, -3853,
    3599, -3853, -3853,  3201,  3293, 47629, -3853,  3231, -3853,  2442,
   24928, 14353,  3205,  3210, -3853,   799, -3853, -3853,  3199, -3853,
   -3853,  2304, -3853,  3795,  3636, -3853, -3853, 39660,  3212, -3853,
   -3853,  3517, -3853, -3853, -3853, -3853,  -160,  3692, -3853, -3853,
   -3853,  2721,  2471,  3260,   964,   964,  3206,  3261, 11183, 11183,
    3223, -3853,  3349, -3853, -3853,   752,  2442, 11183, -3853,  2224,
    3231, -3853,  1932,  3228,  3229, 47629,  3234,  3237, -3853,  3395,
    1082, -3853, -3853, -3853, 23696,  2858,   114, -3853, -3853,  3056,
     818,  3219, -3853, 47629,  3549, -3853, -3853, -3853, -3853,  1232,
   -3853,  3238,  1232,  1232, -3853,  2332, -3853,  3253,   322, -3853,
   -3853,  3258, -3853, -3853, -3853,  1232,  3239,   322, -3853, -3853,
   -3853, -3853,  1232, -3853, 39660,  1432,  -160,  2961, -3853,  3278,
   -3853,  3737,  1113,  3611, -3853,  2858, -3853,  3612,  3513, -3853,
     322, -3853, -3853,  3838, -3853,   322,  3838,  1232,  3515, -3853,
    1232, 47629, -3853, -3853, -3853, -3853, -3853, -3853, 47629, -3853,
    1034, -3853, -3853, -3853,  1871,  -160, -3853, -3853, -3853,  3243,
    3247, -3853, -3853, -3853,   299, -3853, 47629,  4102, -3853, -3853,
   -3853,  3209, -3853,  1059,  1885,   338,  3248,  1919,  1952, 35369,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, 39047,
   -3853,  3838, -3853,  3518, -3853, -3853, -3853, -3853, -3853, -3853,
   11183, -3853, -3853,  3552,  3707, -3853, -3853, -3853, -3853, -3853,
   -3853,  3250, -3853,  2530,   171,   171, -3853, -3853, -3853, -3853,
   -3853, -3853,  3338,  3341, -3853, -3853,  3342, -3853, -3853,   118,
    2346, -3853, -3853, -3853, -3853, 14353,  3635,  3350, -3853, -3853,
    3263,  3296, -3853, -3853,   902, -3853, -3853, -3853, -3853, 11183,
   -3853,  3349,  2354, -3853, 28620, -3853, -3853,  -160,   673, -3853,
    3302, -3853, -3853, -3853,  3304,  1255,  1255, 47629,  3532, -3853,
     783,   902,   338, -3853,  1967, -3853, 47629, 47629,  1981, 47629,
   47629,  2735,  2739,  2740,  1739,  1739, -3853, -3853, -3853, -3853,
   -3853, -3853,  3659, -3853, -3853,  1983, -3853,   691,  3531, -3853,
   -3853, -3853, -3853,  1232, -3853,   266, -3853, -3853, -3853, -3853,
   -3853,   266, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853,  3543,  3305, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853,  3265, -3853, -3853,  3388,
   -3853, 53759, -3853, -3853,  1149,  3294, -3853, -3853, -3853, -3853,
    1462, 47629, 23696,  3334,  3454, -3853,  3012, -3853,   799,   824,
    3245, -3853,   222, 47629, -3853,  3548,   140,  1092, -3853, -3853,
   -3853,  3273,  1963, -3853, -3853, -3853,  3274, -3853, -3853, -3853,
   -3853, -3853, -3853,   310,  3538,  2530,  2530,  2530,  2530,  2346,
   -3853, -3853,  3327, 23696, 15621,  3384, 47629,  1666,  2750, -3853,
    1670,   338, 11183,  2571, 35982, -3853, -3853, -3853, -3853, 11183,
    3282, 11183,  3287,  2001, -3853, -3853, -3853,  1388,  1388, -3853,
     783, -3853, -3853, -3853,  2035,  2042,   222,  2050,  2055, -3853,
   -3853, -3853,  1082,  3289, -3853, 47629, -3853, -3853, -3853,    88,
   -3853, -3853,  2061, -3853,  2112, -3853, -3853, 11183,  3763,  3317,
   47629,   155, -3853, 54985, 54985, 47629, -3853, -3853, -3853, -3853,
    5866, -3853, -3853,   667, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853,  3884, -3853,  3281, -3853, -3853,
    1149,  3295, -3853,   232, -3853,  2213, -3853, -3853,  4102,  3738,
    1541, -3853, -3853, -3853, -3853, -3853,  3298,  2213,  -160,   108,
   -3853,   222, -3853, -3853, -3853,   338,  3303,  3540, -3853,   140,
   -3853, -3853, -3853,  1092, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853, 24928,  2679, -3853,  2224,
   -3853,  2114, -3853, -3853, -3853,  3378,   108,  3796,  3797,   108,
     108,   108,   108,  3308,  2750, -3853,  3780, -3853, -3853, 11183,
   -3853, -3853,  1255,  3534, -3853,  3865,    83,  1255, 47629,  1255,
   47629, -3853,  3753,  3753, -3853,  3519,   222, -3853,   140,  1092,
   -3853,  3231, -3853,   948,   948,   322,   266,   322,  1255, 11183,
   -3853, 11183,  3336, -3853, -3853,  3756, 47629, -3853, -3853, -3853,
   -3853, 11183, -3853, 53759, 53759, -3853, -3853, -3853, -3853,  3912,
   -3853,  3319,   799,  3885,  3578,  3890, -3853,  2711, -3853, -3853,
    3626,  4102, -3853, -3853, -3853,  2530,   235, -3853, -3853, -3853,
    1798,   235, -3853,   235, -3853,  3324, -3853,   108, -3853,  3329,
   -3853, -3853, 47629,  3328, -3853,  -160,   108,   108,  2169,  2169,
    2224, 39660,  3425, -3853, -3853,   108,   338,  3940, -3853,  1075,
    3690, -3853,  2117,  2126,   938, -3853, -3853, -3853, -3853, -3853,
   -3853,  2138, -3853,  3956, -3853,   154,  3603,  3604, -3853, -3853,
   -3853,  1255,  1255, -3853,    48, -3853, -3853,  3728,  3821, 11183,
    1255, 50694,  3339, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853, 54372, 11183, -3853,   667,
    3884, -3853, -3853,  3607, -3853,  3608, -3853, -3853, -3853,  3851,
   53759, -3853,  3843, -3853,   799, -3853, -3853, -3853, -3853, -3853,
   24928, 14353,  2354, -3853,  3384, -3853,  3354, -3853, -3853,   630,
   -3853,  -160,  -160, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853,  2146, -3853, 39660, -3853, -3853,  3936,  3937,  3837,
    3941,  1075, -3853,  -113, -3853, -3853, -3853,  3942, -3853,  3944,
    3356,  3361, -3853, -3853, -3853, -3853,  3411,  3869,  3391, 11183,
   53759, -3853,  3848, -3853,  3779,  1255,  3722,  3371, -3853,  3363,
    1255,  3887, 54985, 54985, -3853, -3853, -3853, -3853,  3859, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853,  2148, -3853, 14987,
   -3853, -3853, -3853, -3853, -3853, 39660, -3853,  3425, -3853,  3379,
     266,   266,  3958,   266, -3853,  3962,  3964,  -113, -3853, -3853,
   -3853, 46403, 46403,   948,   948, -3853,    60, -3853,  1255, 51307,
    3959, 47629, -3853,  3465, -3853, -3853, 11183,  3874, 40886, 51920,
    3380, -3853, -3853, -3853,  3555, -3853,  2711,  3558, -3853,  3354,
   -3853,  3385, -3853,  2764,  2750, -3853, -3853,  3662, -3853, -3853,
     266, -3853,   266,   266, -3853,  3390,  2162, -3853, -3853, 11183,
   -3853,  3873,  3475, -3853,  3392, -3853, 53759,  1255, 53759, -3853,
   -3853,  3820,  3394,   339, -3853,  3393, -3853, -3853, 53759,  3810,
    3865, -3853, 14987,  3405, -3853, -3853,  3407,  3398, -3853, -3853,
   -3853, -3853, -3853,  1255,  3979, 53759, 47629, 48855,  3883, 52533,
    3847, 47629,  4102,  3849,  3853, -3853, 53759, -3853,  3991,  3690,
   -3853, -3853, -3853,  3662,  3493, -3853, 49468, -3853,  2657,  3605,
    3437, -3853, -3853,  3922,  2456, -3853, -3853,   266,  3824, -3853,
   53759, 53759, -3853, -3853, -3853, -3853, 33530, -3853, -3853, -3853,
   -3853, -3853,   888, -3853,  3688,  3417, 50081, 53146, -3853, -3853,
   -3853, 30465, -3853, -3853, -3853,  3860, -3853, 11183, -3853,   679,
   19989,  3573, 33530, -3853, -3853,  1255, -3853, -3853, -3853, -3853,
   39660,  2184, -3853, -3853, 24928, -3853, -3853, -3853, -3853, 23078,
    3419, -3853,   108, -3853, 24928, -3853, -3853, 14353, -3853, -3853
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -3853, -3853, -3853, -3853, -3853,    70, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853,  1747, -3853, -3853, -3853, -3853, -3853,
    1946, -3853,   637, -1851, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853,   638,  1553,  3412, -3853,   379,
   -3853,    63, -3853, -3853, -3853, -2945,   -59,  -234, -3853, -3853,
    1090,    22,  3079,  -233, -3852, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853,   398,   397, -3853, -3853,   214, -3853,
   -3853, -2794, -3853, -3853, -3853, -3853, -3853, -3853, -3853,  -407,
    -365,  1829, -3853, -3853, -3853,  4048, -3853,  3521, -3853, -1753,
    2260, -3853, -3853, -3853, -3853, -3853,  2319, -1700, -3853, -3853,
   -3853,  1305, -3853, -3853, -3853, -3853,  -545,   250, -3853,   251,
   -3853,   263, -3853,   265, -3853,   269,   270,   271,   275, -3853,
     280, -3853, -3853,  -357, -3853, -3853, -3853, -3853,   282, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853,  -219, -3853, -3853,   -47,
   -3853, -3853,  -198,   288, -3853,  -149,   296, -3853,   297, -3853,
     -67, -3853,   -57, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853,  3127, -3853, -3853, -3853,
   -2293, -3853, -3853, -2235,  2684, -3853, -1826, -3853, -3853, -1962,
   -3853, -3853, -1791,  1087, -3853, -3853,  1456,   356, -3853, -1408,
   -1904, -1900, -3853, -3853, -3853, -2026, -2025, -1405, -1381, -2310,
   -3853, -3853, -3853,   290, -3853, -3853, -2596,  2113,  2677, -3853,
   -1986, -3853, -3853,  1175, -3853, -3853,  1352,   652,  1358, -3853,
     947,  2886, -1239, -3853, -3853, -3853, -3853, -3853, -3853,    44,
     283,   -44, -3853, -3422,   674, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -2505, -3853, -3853, -3853,  -209, -3853, -3853,
    -123, -3853, -3853,  -169, -3853,   142, -2322, -3853, -3853, -3853,
   -3853,  2655, -1344, -3853,  3694, -3853,  -562,   772,  2158, -2427,
   -1412, -3853,  -913,  -896, -2507, -3853, -3853, -3853, -2131,  1143,
    1545, -3853,   867,  2156, -1917, -3853,  1623, -3853, -3853,   892,
   -3853, -2060, -3853, -3853, -3853,   848, -3853,   851, -3853, -3853,
   -3853,  -954,   820, -2576,  1342,  -642, -3853,   400, -2495, -2573,
   -3853,   631, -3853,   580, -3749, -3357, -3853,  -568, -2117, -2421,
     -15, -3853, -3853,   594, -3108,  1753, -3853, -3853, -3853, -3197,
   -3279,  1477, -3853, -3853,  1057, -3853, -1330,  1056, -3853, -3853,
   -3853,  1068, -3853,   152, -3853, -3853, -3853, -3853, -2863, -3853,
   -3853, -1485, -2087, -3853, -3853,  4227,  4229, -1037, -2748, -2961,
     153,   157, -3853, -3853, -3853,  2676, -3605,   223,   210,   218,
    2106,  -608,   366, -2425, -3853,   419, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853,  2193,  -269, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -2457, -2452, -3853, -3853,  1668, -3853, -3853, -3853,
   -1921, -1445, -1440, -1907,   183, -2173, -3341, -3853, -3853, -3853,
   -3853, -3853, -3853,  2808, -3853, -3853, -3853, -3853, -3853,  3675,
   -3853,  2825, -3853, -3853, -3853, -3853, -3853, -3853, -3853,   657,
    1882, -3853, -3853, -3853, -3853, -3853, -3853,   933,  2714, -3853,
   -3853, -3853,     2, -3853, -3853, -3853, -3853,  2437, -3853, -3853,
   -3853, -3853,  2767, -3853, -3853, -3853, -3853, -3853, -3853,  1453,
   -3853,  1920, -3853, -1459, -3853, -3853,  1042,  -980,  1873,  3676,
    2010, -3853, -3853,  -586, -3853, -3853, -3853, -1704, -2458, -3853,
    3382,  -917, -2489,  2424,  -643, -1838,  1085,   463,  3655, -3853,
   -1140, -1043, -3853, -3853,  -637, -3853, -3853, -3853,  -576, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
    1489, -3853, -3853, -3853, -3853, -1207, -3853, -3853, -3853, -3853,
   -3853,  1538, -3853,  2103, -3853,  -485, -3853,  3161, -3853, -3853,
   -3853, -2343, -1912,  1813,   985, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -1557, -3853, -2382, -3853, -3853, -3853,
   -3853, -3853,  2022, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -1691, -3853, -1981,   204, -3853,   346, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853,   -53,   869,   -51, -2569, -1087,  1665, -3853,
   -3853, -1268,  3203, -2350, -3853, -3853, -3853,  2005, -3853, -3853,
   -3853, -3853, -3853,   958, -2980, -1399, -3853, -3853, -3206,  -900,
   -2288,  -880, -3853, -2377,   511, -1860, -1775,  -716,   143, -1331,
   -3853, -3853, -3853, -3853,  -143, -3853, -3853, -3853,   527,  1902,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853,  -563,  -829, -3853, -3853,  2157,  2380, -3853,  3077, -3853,
   -1048,  3331, -3853, -3853,  3332, -3853, -3853, -3853, -3853,  3025,
    2988,  1972, -3853, -3853, -2378, -3853, -3853,  1928, -3853,   776,
    -894, -1702,  1060, -3853, -3853,  1071, -3240, -3853, -3853,  3337,
   -3853, -3853, -3853,  1013, -3853,    81,  3739,  3343, -3853, -3853,
   -3853, -3853, -3853, -3853,  2749, -1057,  3666, -3853, -3853, -3853,
   -3853, -3853, -3853,  2409, -3853, -3853, -3853, -3853, -3853, -3853,
    2934,  3755,  -573, -1315, -3853,  -651,  2908,  2412,  -864, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853,  2562,   993, -3853, -3853, -3853,  3040,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853,  1109,   -69, -3853,
      72,   -97, -3853,     7, -3853, -3853, -3853, -3853, -3853,  -163,
   -3853, -3853,  -166, -3853,  -972, -1375,   713, -1242, -2046, -3853,
    1097,  3042, -3247,  -668, -1138, -1142, -1856,    58, -3853, -3853,
    2980,  1726,   138,   393,  -417,    -6, -2783,  -104,  -571, -3853,
   -2567, -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,  1933,
   -3853, -3853, -3853,  1073, -3853,  3781, -3853,  2646,  1079,  3783,
   -3853, -1335,  2486,  1944,  1948, -3853, -3853,  1955, -2219, -3853,
   -3853,   180, -3853,  2561, -3853, -3853, -3853, -3853, -3853, -3853,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853,  3039,  3803,
    3496, -3853,  3074, -3853, -3853, -3853, -3853, -3853,   471, -3853,
     258, -3853, -2072,  2826,   503, -3853,  1577,  -371,  -648, -3853,
   -3853,   470, -3853, -3853,   313,  3812,  3502, -3853, -3853, -3853,
   -3853, -3853, -2778,  -872, -3853, -3409, -2833, -1682, -3853, -3853,
   -2193, -3034, -3853, -3853, -1036, -3853, -3853, -3853, -3853, -2002,
   -3853, -3853, -3853,   137,  3875,  3878, -3853, -3853,   560, -3853,
     -48, -3853, -3853, -3853, -3853, -3853, -3853, -3853,   391,   722,
   -3853, -3853,  3746, -3853, -3853, -3853, -3853,  3747, -3853, -3853,
   -3853, -3853, -3853,  3749, -3853, -3853, -3853, -3853, -3853,  1712,
   -3853, -3853, -3853, -3853, -3853, -3853, -3853, -3853
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -2605
static const yytype_int16 yytable[] =
{
     491,  1035,   948,  1464,  1049,  1057,   908,   944,   977,  1367,
    1370,  1353,  1471,   533,  2406,  2149,  1578,   541,   617,  1382,
    2080,  1780,   534,  2265,  1904,  1693,   555,  1645,   489,  1692,
    1568,  1569,   553,   567,   783,  1808,   570,  1120,   560,   992,
     567,  1401,  2360,  1429,  2077,  1878,  2979,   585,  2566,  2062,
    1715,  2807,  1007,  2707,  2063,  1395,  1779,  1723,  2709,  2632,
    2926,  1948,  2838,  1401,  2889,  2890,  3254,  3573,  1609,  3294,
    1816,  1024,  1027,  2768,  3090,  1476,  1973,  2456,  2310,  1974,
    1430,   539,  2052,  1994,  2523,  1994,  2390,  2913,   606,  1078,
    1065,  2975,  1477,  2517,  1667,  1911,  2532,  2518,  3410,  2893,
    2536,  2951,  2980,  1975,  2652,  2653,  3578,  1995,  1986,  1995,
     609,  2551,   491,  1921,  2861,   491,   616,   622,  3450,  2904,
    2505,  1924,  1925,  2562,  1291,  3108,  3768,  2914,  3117,  3115,
    1951,  2792,  3652,  3169,  1446,  3902,  1215,  1045,  1182,  1183,
     611,  2131,   135,   613,  3707,  2121,  2401,  3499,  2126,  3621,
    1182,  1183,   605,   636,  1822,  1725,  1726,  2641,  3794,  1729,
    1730,  1731,  1732,  2513,  1734,  1735,  1737,  1739,  1740,  1741,
    1742,  1743,  2127,  3614,  3619,  1182,  1183,  3620,  2168,   548,
    2494,   915,   899,  1182,  1183,  1173,  1174,  1175,  1757,   498,
    1811,  2301,  2165,  4290,  1182,  1183,  3630,  1286,  1216,  1536,
    2936,  2937,  3651,  3320,  2595,  4290,  3114,  3742,  2880,   552,
    3169,  1406,  1291,  4093,  4018,   559,   839,   545,  1792,  2887,
    2301,  2940,  3593,  1986,   115,  2606,  2649,  2609,  2610,  1744,
    2650,  1986,  1240,  2620,  2621,  2570,  1283,  1182,  1183,  3170,
    2252,  2686,  2629,  2630,  1842,  3092,  2002,  2634,  2799,  3808,
    2480,  2481,  2474,  1217,  1947,  1363, -1515,  3079,  2764,  4128,
    1292,  1384,  1601,  1363,  1986,  2467,   627,  2492,  1300, -2488,
    1028,  1182,  1183,  3178,  4284,  4227,  3579,  1453,  3440,  1442,
    3839,  4030,  4034,  4123,  2510,  2511,  1369, -1963,  3303,  3509,
    1317,  3766,  1859,  4124,  1431,  1933,  4018,   843,   549,  2666,
    2531,   967,  2441,  2534,  2535,  3264,  2537,   957,  1160,  2540,
    2541,  1969,   628,  2544,  3276,  1965,  3170,  1860,  2553,  1540,
    2849, -2340,  3041,  2557,  2558,  2559,  2560,  2561,  3061,  3062,
    3792,  2565,  1473,  2567,  3098,   117,  3100,  1399,  1863,  2576,
    2577,  2578,  2579,  3457,  4104,  2583, -2552,  2585,  1292,   884,
    3457,  2314, -1791,   134,   569,  3458,  2743,  2857,  3339,  1411,
   -1791,  3292,  3458,  -901,  1473,  1182,  1183,  2945,  1473,  3459,
    2872,  2571,  3742,  3242,  3852,  3080,  3459,  3854,  1182,  1183,
     915,   899,  4233,   130,   844,   134,  3073,   915,   899,  4019,
    3743,  2873,  1402,  1987,  2759,  -567,  1182,  1183,  4335,  -568,
     641,  2751,  1558,  1559,  1560,  3196,  1819,  1634,  1182,  1183,
    1635,  3068,  2636,  2637,  2638,  2639,  3293,  1100,  1182,  1183,
    4433,  3828,  1033,  1034,  4030,  2874,  1969,  2752,  4034,  1793,
    3832,  4336,  3890,  1541,  1969,  1608,  1745,  1542,   842,  4434,
    1537,  1403,  2954,  2858,  2745,  1312,   629,  1947,  1543,  1120,
    1820,  1499,  2315,  3851,   845,  1843, -2552,  1934,  3853,  3249,
    1746,  1935,  3042,  3309,  3340,  1966,  1434,  1969,  1301,  4014,
     131,  4019,   885, -1515,  1861,   968,  1944,  1454,  2758,  1873,
    1557,  2253,  1161,  4030,  4034,  3965,  2855,  2912,   632,  3884,
    2597,  2946,  3074, -2340,  1184,  3744,  3441,  1185,   616,   958,
     622,  4125,  1101,  4105,  3262,  3263,  1184,  2027,  1987,  1185,
    1864,  4285,  3304,  1219,  4227,  3911,  1987,   797,  1182,  1183,
    3580,   622,  3921,  1182,  1183,  3319,  1443,  3298,  3321,  3322,
    1046,  1184,   837,  2550,  1185,  1602,   616,  2423,   847,  1184,
    1906,  3265,  1185,  1909, -1991, -2419,   546,   886,  1913,  1987,
    3330,   860,  1182,  1183,  1231,  3743,  1720,  3081,   841,  1218,
    2854,  1476,  1231,  1973,  3171,  1794,  1974,   840,   909,  1029,
   -2128,  3584,  2442, -2150,  1926,  1927,   964,  1364,  1477,  1544,
    1949,  2229,  1986,  3001,  1994,  1364,  3942,  2302,   645,  2516,
    1975,  1794,  3788,  1184,   981,  1781,  1185,  1780,  2945,  1051,
    1059,  1592,  1593, -2268,   616,  1385,   996,  2449,  1995, -1515,
    2517,  4090,  1182,  1183,  2518,  2922,  2302,   616,   606,   491,
    2652,  2653,  1633,  1747,   606,  1728,  1022,  1184,   606,   606,
    1185,  1647,  1779,  1036,   996,  1010,  1182,  1183,   616,  1476,
    2052,  3171,  1749,  1660,  1661,  1662,  3313,  1009,  1066,  1067,
    1068,  1666,  2166,  4193,  1073,  3745,  1477, -2419,  1284,  3279,
    1538,  1407,  3082,  2888,  3444,  4345,  3737,  1182,  1183,  4181,
    4094,  3746,  1182,  1183,  1545,  2960,  2957,  2962,  3063,  1760,
    2961,  1823,  1008,  4453,  2973,  3622,  2938,  1047,  1019,   550,
    2282,  2279,   881,  1287,  2977,  2978,  1230,  3708,  2986,  1121,
    2862,  2285,  2934,  2132,  2288,  2997,  2991,  2947,  2297,  2109,
    1788,  2121,   805,  4222,  2126,  4071,  2939,  3013,  3015,  3017,
     941,  1184,  2648,  3018,  1185,  2654, -2488, -2604,   941,  3105,
    3219,  3220,  3221,   852,  1184,  2595,  3172,  1185,  2127,  1186,
     863, -1515,  2649,  1810,  3928,  3058,  2650,  3449,  4027,  2655,
    1812,  1186,  1184,  3529, -2488,  1185,  3425,  2268,  1829,  3747,
    1179,  3179,  1181,   965,  1184,  3438,  2156,  1185,  4013,  1951,
    2903,  3097,  2572,  1538,  1184,  1841,  1186,  1185,  3259,  3260,
    3261,  3607,  3608,  1923,  1186,  1969,  1063,  2141,  1224,   491,
    1226,  3923,   996,   491,   616,  1186,   491,   616,  1858,  1368,
    1232,  1435,  1269,  1373,  1378,  3333, -1515,  3277,  1232,  1412,
    2142,   969,  2595,  3628,  3629,  3627,  1398,  1225,  1162,  4138,
    3576,  1229,  4166,  3632,  1239,  4311,  1887,  3197,  1182,  1183,
    3657,  2512,  3426,  1182,  1183,  1296,  3746,  1910,  1186,   887,
     888,  2972,   890,  3075,   892,   606,  1182,  1183,  -901,  1636,
    1182,  1183,  1637,  2254,  2981,   616,   606,  3605,  3606,   893,
     606,  3318,  3060,  1182,  1183,  3114, -1991,  1987,  3114,  3114,
    1182,  1183,  1186,  3536,  1184,  2598,  3592,  1185,  1463,  1184,
    -567,  3956,  1185,  2948,  -568,  3114,  2812,  3599,  1933,  1182,
    1183,  3583, -2128, -2420,  1538, -2150,  3460,   616,  4188,  3631,
    4190,   616,   616,  3460,  3650,  3653,  3655,  3656,  1184,  1303,
    1953,  1185, -1791,  1231,   616,  3563,  2919,  3453, -1791,  3567,
    1320,  1999,  1182,  1183,  1326, -2268,  2838,  3649,  4011,  3299,
    3300,  2673,  1436,  3323,  1182,  1183, -1475,   136,  2272,  1426,
    1182,  1183,  3066,  4320,  4496,  3190,  4113,  3476,  1182,  1183,
    2175,  2347, -1818,  2374,  3562,  1437,  3572,   606,  3566,  3105,
    4265,  3033,  1182,  1183,  2412,  1498,  1186,  3935,  1184,  1182,
    1183,  1185,   952, -1475,  3542,  -472,   616,  3397,  1472,  1186,
    1700,  1701,  2201,  3234,  2427,  4087,  1969,  1262,   594,  2374,
    1182,  1183,  1184,  1314,  2176,  1185,  1038,  1186,  4182,  2137,
   -2419,  4313,  1182,  1183,  3936, -2420,  1182,  1183,   606,  1186,
   -1819,  1700,  2195,  1182,  1183,  1564,    13,  2580,  2445,  1186,
    1182,  1183,   864,  1184,  2230,  1217,  1185, -1991,  1184,  1297,
   -2419,  1185,   856,  2233,  2234,  2517,  1182,  1183,  1401,  2518,
    3150,  2652,  2653,  2952,  2952,  3440,  3287,  2443,  2479,  2068,
    1934,   953,  3239, -2128,  1935,   985, -2150,  2448, -1818,   606,
    2451,  2452, -2552,  1574,  1182,  1183,  1904,  1904,  1401,   494,
     651,  1182,  1183,   657,  2982,  3957,  1710,  3454,   499,   941,
    2416,  1182,  1183,  1182,  1183,  1973, -2268,  2348,  1974,  1581,
    3030,  2398,  2674,  3453,  3257,  3879,  2310,  1121,  2688,  3559,
    1182,  1183,  1182,  1183,  2523,  4114,  2516,  1994,  2289,  1182,
    1183,  1121,  1975,  1748,  1231,  2551, -1819,  2280,  3332,  1186,
    1231,  2273,    25,  1565,  1186,  4178,  2826,  1572,  1182,  1183,
     568,  1995,   658,  2250,  2251,  2894,  4497,  2772,  2773,  2774,
    4277,  1703,  2062,  1094,  2909,  1182,  1183,  2063,  2983,  1447,
     595,  1182,  1183,  1186,  1228,  2910,  2034,  2724,  3455,  1232,
    1782,  1694,   535,  2649,  2069,  1399,  4018,  2650,  2174,  2353,
    2287,  1781, -2552,  2261,   616,  2052,  3958,  1220,  2520,   865,
    1182,  1183,  3781,  3782,  1184,  4278,  3541,  1185,  2300,  1184,
    4108,  4109,  1185,  3329,  2375,  2293,  2777,  2778,  2304,   544,
    1476,  2581,  1184,  2294,  2037,  1185,  1184,  2656,  1821,  1185,
    1064,   616,  1582,  1186,   623,  1164,  1752,  1477,  3933,  1184,
    2265,   606,  1185,  4267,  1182,  1183,  1184,  4126,  2181,  1185,
    2375,  4187,  2121,  3844,  4268,  2126,   606,  1186,  2648,  4133,
    2771,  2654,  1693,  4171,  1427,  1184,  3477,  3845,  1185,  2984,
    2781,  3128,  3129,  3454,  2370,  2371,  2244,  1121,   616,  2127,
    4316,  3031,  3039,  3441,   659,  2655, -1818,  1330,  1186,  3539,
    3324,  1182,  1183,  1186,  4115,   616,  3595,  4518,  1184,   986,
     941,  1185,  3135,  3136,  2349,  1754,   941,  1797,  2182,  1800,
    1184,   606,  2547,  1185,  3998, -1818,  1184,  1182,  1183,  1185,
     606,   857,  4183,  1704,  1184,   987,   616,  1185,  1976,  3040,
    2822,  4279,  1182,  1183,   579,   606,   606,  3497,  1184,  3132,
    4216,  1185,  3888,  2929, -1819,  1184,  2274,  2417,  1185,  1693,
      37,  1218,  2078,  2917,  3466,  2262,  1894,  1182,  1183, -1475,
     616,  4019,  2275,  1845,  3711,   580,  1184,  2675, -2420,  1185,
    2911,  1853,  3228, -1819,  1854,  1326,    43,  2079,  1184,    43,
    1232,  1185,  1184,   616,  2657,  1185,  1232,  3456,  2376,  1184,
    3937,  3881,  1185,  1874,   909,  1351,  1184,  1955, -2420,  1185,
    1326,  1182,  1183,   491,   491,   491,   606,   491,   606,  1182,
    1183,  3490,  1184,  1905,  4184,  1185,   557,  2758,  1895,  1907,
     491,  2758,   616,  2587,  2376,   491,  3998,  3998,  1152, -1818,
     582,  1888,  1889,  1890,  1538,  1892,  1977,  1182,  1183,  1581,
    1184,  1581,  1693,  1185,  4185,   606,  2995,  1184,  1908,  1186,
    1185,  3846,  1933,  1912,  1186,  1030,  1804,  1184,  2930,  1184,
    1185,   597,  1185,  3152,  3153,  1156,  4269,  1186,  3187,  3188,
    1891,  1186,  1893,  1480,  1182,  1183,  1184, -1818,  1184,  1185,
    -472,  1185,  2188,  2952,  1186,  1184,  2193, -1819,  1185,   598,
    2595,  1186,  2693,    52,  3676,   616,  1182,  1183,  1581,  2194,
    4387,  4388,  3215,  3677,  1184,  3151,   616,  1185,   607,  1922,
    1186,   606,  2595,  1153,  2073,   606,  4349,   495,  1182,  1183,
     496,  1184,  3863,  4074,  1185,  2197,  1557,  1184,  2549,  4172,
    1185,  4173,  1031,  1969,   577, -1819,   600,  1231,    55,  4362,
    4362,    55,  1884,  1186,  1182,  1183,  1869,  2380,  2398,  2878,
    1157,  2516,   606,  1182,  1183,  1186,  1184,  2550,  2209,  1185,
     610,  1186,  1597,  3456,  1652,  1046,  3998,  3998,   868,  1186,
    2216,   616,  3835,   491,   491,  2070,  2139,   491,  4016,  2075,
    1182,  1183,  3058,  1186,  2220,  1182,  1183,  1182,  1183,  1073,
    1186,  2155,  1182,  1183,  2399,  3836,  1182,  1183,  2221,  1896,
    1184,  2135,  2136,  1185,  1978,  2223,   578,  1716,  1182,  1183,
    1581,  1186,  3889,  1979,  1934,  1846,  1870,  1182,  1183,   644,
    1980,  1656,  4427,  1186,  4429,  1780,  2224,  1186,  1182,  1183,
    1182,  1183,  3837,  2078,  1186,   624,  1199,  3863,  2228,  4270,
     803,  1186,  2246,  3678,   612,  1985,  2170,  1184,  3099,  3133,
    1185,  4446,  1438,  3919,  3998,  4073,  3134,  1186,  2079,  3186,
    1779,  1231,  1182,  1183,  1121,  2202,  1182,  1183,   861,  3998,
    1010,  3308,  3145,  1184,  1182,  1183,  1185,   869,  2305,  2648,
    3941,   625,  2654,  3998,  3864,  1186,  4476,  4477,  1184,  2171,
    1219,  1185,  1186,  3045,  2613,  1182,  1183,  1182,  1183,   632,
    3155,   999,  1186,   941,  1186,   117,  2655,  3156,  3046,  3880,
    1693,  3676,  2711,  1184,  3245,  1981,  1185,  3720,  2245,  2141,
    3677,  1186,  1047,  1186,  2776,  2271,  2718,  2196,  1182,  1183,
    1186,  1439,  1947,  1680,  3701,  2157,  3819,  2169,  1847,  1182,
    1183,  2885,  2142,  3998,  2173,  1182,  1183,  1182,  1183,  1186,
     633,  1000,   870,   636,  1986,  3998,  3998,  1184,  2614,  2733,
    1185,  4318, -2604,  2183,  4322,  1184,  1186,  2295,  1185,  3523,
    3505,  2411,  1186,   616,  3504,   606,   616,  4328,  3949,  3950,
    2184,  2747,  2661,  1232,  1033,  1034,  2192,   606,  2812, -1791,
    1717,  2196,  1269,  1184,  1182,  1183,  1185,  1269,  3726,  4000,
    2317,  1186,  3998,  2662,  2114,  1789,  2323,  2323,  1790,  2323,
    1982,  1791,  3998,  3524,  1561,  2205,  1182,  1183,  2114,   606,
    1871,  1182,  1183,   606,  3793,   638,  1307,   941,  2787,  1308,
    1184,  1202,  3820,  1185,  1001, -1713,  1540,  2265,  2959,   616,
     616,   606,   606,  3951,  1562,  1186,  2463,  1182,  1183,  3998,
     640,  3998,  1184,  1121,  2615,  1185,  2323,  2323,  2323,  2206,
    3678,  3998,  3493,  1969,  2989,  2990,  3495,  1986,  1561,   616,
    2322,  2322,  3821,  2322,  1184,  1078,   687,  1185,  3998, -1713,
    3998,   908,  3998,  2345,  4411,  2150,   909,  1303,   564,  3998,
    1182,  1183,  1186,  3896,  1388,   564,  -206, -1791,  1563,  3998,
    1184,  2440,  2644,  1185,   652,  1320,  2373,  1232,   507,  1184,
    1182,  1183,  1185,  3998,  3998,  1182,  1183,  2114,  1186,   654,
    2322,  2322,  2322,  2293,  4054,   495,  1182,  1183,   496,  3998,
    3998,  3273,  2210,  1186,  3998,  2616,  1184,   606,  2380,  1185,
     692,  1184,   655,  1184,  1185,  4055,  1185,  2214,  1184,  2462,
    1541,  1185,  1184,  1389,  1542,  1185,   606,  1969,  1186,  1182,
    1183,  3005,   656,  3006,  1184,  1543,  1878,  1185,  1182,  1183,
     793,  1969,  2215,  1184,   558,  1309,  1185,  2172,  1219,  2464,
    2463,  2369,   643,  1390,  1184,  3623,  1184,  1185,  3624,  1185,
     798,  1231,  1353,   808,  2971,  1718, -1791,   838,  2465,  1182,
    1183,  2450,  1186,   801,  3007,   849,  3282,   915,   899,  2466,
    1186,  1719,  3283,  2189,  1219,  2644,  2219,  1952,  1184,  2277,
    2473,  1185,  1184,   853,  2222,  1185,  1401,  3008,  1515,  1516,
    1184,   855,  1401,  1185,  3451,   255,   704,   257,  1186,  1987,
    2436,   873,  2520,  3307,  2642,  3560,   875,  1002,  2658,   865,
    3284,  1184,  2225,  1184,  1185,  2779,  1185,   979,  3468,  3469,
    2582,   980,  2382,  2383,  3009,  4041,  4042,  4043,  4044,   982,
    1969,  2325,   841,  2326,  2596,  1186,  3104,  2198,  1219,  2115,
    1132,  3482,  2199,  1650,  1184,  1231,  1368,  1185,   989,  2237,
    1273,  1368,  2467,  2115,   998,  1184,  1544,  1186,  1185,  1231,
    3248,  1184,  1151,  1184,  1185, -1713,  1185,  1489,  1490,  1020,
    1003,  2256,  1004,  2464,  2483,  1165,  1166,   720,  1010,  1186,
    2393,  2394,  2395,  2490,  2491,  1211,  1212,  1213,  1214,  1039,
    1693,  1040,  2465,  3102,  2495,  2496,  2497,  2498,  1199,  2506,
    2507,  2354,   616,  2466,  2617,  1186,   616,  1555,  2659, -1713,
    1184,   491,  1987,  1185,  1186,  2687,  2547,   941,   606,   606,
     606,  2682,  2289,  1044,  2685,   115,  2116,  1219,  3121,  1531,
    1532,  1274,  1184,  1075,  1199,  1185,  1275,  1184,  1076,  2664,
    1185,  1186,  1077,  1693,   616,  2769,  1186,  2917,  1186,   616,
    1079,  1545,  2115,  1186,  1391,  3127,  2078,  1186,  1231,  1781,
    3130,  3457,  3137,  1184,  2468,  2355,  1185,  3141,  1080,  1186,
     969,  3142,  1081,  3458,  1084,  2791,  1693,  1085,  1186,  1276,
    2995,  2079,  2678,  2679,  2680,  1086,  2467,  3459,  2380,  1186,
    4149,  1186,  3143,  2356,  1277,  4236,  2381,  1232,   915,  3615,
    4238,  2931,  4239,  3144,  2608,  3146,  1184,  2608,  2608,  1185,
    2608,   941,  1087,  2608,  2608,  2608,  2608,  2608,  2608,  2608,
    2211,  1219,  2608,  1186,  2608,   941,  1184,  1186,  2493,  1185,
    -653,  1184,  1088,  2469,  1185,  1186,   115,  3149,  3241,  1089,
    2520,  3154,  1184,   616,  1090,  1185,  2212,  1219,  1223,  3157,
    2213,  1219,  1199,  2521,  4150,  4235,  1186,  1091,  1186,  4067,
    4068,  2357,  2217,  1219,  3586,  3587,  2354,  3010,  2788,  3185,
    3159,  1222,  3161,   616,  1092,  1184,  2117,  1095,  1185,  1097,
     973,   974,  4069,   975,  1184,   976,   749,  1185,  1098,  1186,
    1392,  1232,  1099,  1202,   616,  3019,  1244,  4135,  2468,  1102,
    1186,  3662,  1227,  3163,  1904,  1232,  1186,  1270,  1186,  1182,
    1183,  1393,  2382,  2383,  3164,  1184,  2548,  1103,  1185,  1272,
    3165,  2354,  3487,  1104,   941,  1105,  2820,  3807,   116,  1202,
    2355,  3531,  2549,  2114,  4155,  1106,  2640,  4158,  4159,  4160,
    4161,  1278,  2358,  2508,  2509,  1986,  3296,   117,  2761,  1219,
    2384,  1394,  1291,  1107,  -653,  1186,  2411,  1368,  2843,  1281,
     502,  1108,  2846,  2797,  2798,  4259,   616,  2469,  1693,  3488,
    1109,  3099,  3245,  1110,  2265,  3807,  1413,  1186,  -653,  2866,
    1111,  2868,  1186,  1112,  2697,  2355,  3609,  1199,  2520,  3612,
    3613,  3489,   915,   899,  2078,  2114,  3716,  3147,  1219,  3251,
    3252,  2521,  1115,   909,  1232,  1414,  3625,  1116,  1186,  1122,
    2698,  2499, -1791,  2356,  2996,  1905,  1905,   118,  1123,  2079,
    2114,  1280,  3719,  3255,  3256,  1124,  4253,  1125, -1515,  2791,
    3421,  3422,  4082,  4083,  4251,  4252,  3501,  1219,  1614,  3526,
    3527,  1204,  1205,  4264,  1126,  1694,   119,  1202,  3667,  3668,
    1127,  1186,  1128,  1415,   616,   616,  1129,  1416,  2699,  3704,
    3713,  2700,  3721,  1219,  1289,  3725,  3738,  1219,  1291,  2701,
    4148,  1186,  3754,  3755, -1791,  2500,  1186,  1204,  1205,  3717,
    1130,  2357,  3867,  2509, -1515,  3727,  1969,  1186,  1292,  2218,
    3728,  1133,   884,  2644,  1134,  2596,  3882,  3883,   120,  1135,
    2596,  3729,  -653,  2501,  2944,  2956,  2596,  4254,   502,  1136,
    2596,  2499,  2967,  1137,  3012,  2958,  1138, -1515,  1139, -1515,
    1186,  2968,  2967,  2865,  2596,  2596,  3904,   616,  2967,  1186,
    3886,  3883,  1140,  2988,  3730, -1515,  2596,  1141,  1694,  1618,
   -1515,  1142,  2078,  3795, -1515,  2992,  2463,   606,  1969,  1143,
    3000,  2359,  1144,  2499, -1515,  1145,  3003,  3004,  2967,  1146,
    1186, -1515,  2358,  3887,  3883,  2596,  3029,  2079, -1515,  1147,
    -653,  2502,  1148,  1969,  4037,  2500,  1149,  3055,  3943,  3527,
   -1515,  1150,  1202,  1207,  1208,  1209,  1210,  1211,  1212,  1213,
    1214, -1515,  3946,  3883,  3954,  3955, -1515,  1585,  1586,  1587,
   -1515,  1189,  1190,  2501,  1292, -1515,  1417,  1154,  2115,  1598,
    1155,  3002,  4081,  3256,  1231,   885,  1158,  2500,  1159,  1207,
    1208,  1209,  1210,  1211,  1212,  1213,  1214,  2499,   121,   586,
    1987,  3475,  3905,  3906,  1163, -1515,  1167,  3907,  3908,  1191,
    1653,   606,  2596,  1657,  1619,  2501,  4085,  3883,  1622,  1168,
    1192, -1515,  2503,  4086,  3883,  1623, -1515,  1169,  2969,  2970,
    4519,  4088,  3883,   505,  1676,  1677,  4089,  3883,  1681,  3325,
    2115,  2502,  4095,  4096, -1515,   587,  1231, -1515,  1170,  2464,
    1198,  2116,  1418,  3502, -1515,  2999,  1695,  1696,  1171,  1193,
     886,  2500,   908,  1172,  2702,  2115, -1515, -1515,  2465,   122,
    1194,  1231,  2522,  3337,  1221,  3084, -1515, -1515,  1290,  2466,
     119,  3343, -1515,  2502,  3460,  3345,  4255,  1298,  -653,  2501,
    1299, -1515,  1199,  4097,  4096,  4151,  4152,  1195,  4275,  3256,
    1204,  1205,  1315,  1624,  3616,  3395, -1515,  4276,  3256,  1209,
    1210,  1211,  1212,  1213,  1214,  1419,  -653,  1327,   588,  4282,
    3527,  1329,  2503,  2499,  3059,  1346,  3014,  4326,  4327,  4368,
    4369,  3418,   123,  1347, -1005,  1956,  1348,  3683,  2116,  1351,
    1269,  2359,  2317,  4422,  3420,  1296,   616,   616,   616,  1957,
     941,  1354,  4461,  4462,   606,  1199, -1515,  2502,  1359,  1626,
   -1515,  1196,  2467,  1360,  2503,  4508,  4509,  3897,  3898,  1683,
    1684,  1379,  2820,   616,  4056,  1383,  1694,  4257,  4257, -1515,
     124,   505,  1387, -1515,  1399,  3779,  1408,  2500,  3697,  3698,
    4226,  1121, -1515,  1409,   616,   616,   616,  3545,  3546,  3511,
    3512,  2117,  1410,  3963,  1425,  2703,  4057,  3272,  1432,  3963,
    1433,  1428,   941,  3752,  3753,  2501,  1441,  1368,  3227,  1444,
    1445,  2822, -1515,  1448,  1451, -1515,  1449,  1420,  1456,  1461,
    1232,  2504,  1473,  3633,  1479,  1481,  1483,   941,  2503,  1486,
    3709,  1491,  1207,  1208,  1209,  1210,  1211,  1212,  1213,  1214,
    1199,   795,   796, -1791,  1693,   799,   800,  1200,  4147,   802,
    1487,   804,  1492,  1493,  -653,  1496,  1500,  1421,  1497,  1501,
    1502,  1549, -1515,  2704,  2468,  1550,  3634,  1551,  1554, -1515,
    3635,  1201,  3636,  2502,  1199,  1556,  1557,  1202,  2117,  1575,
   -1515, -1515,  1232,  1577,  2596, -1515,  1627,  2596,  2596,  1217,
    1581,  2705,  2967,   563,  1588,  1639,  1600,  1182,  1183, -1515,
     520, -1515,  1629,  1958,  1603,   616,  1649,  1232,  2596,  1651,
    3826,  3827,  1650,  3067,  1711,  4058,  1674,  3798,  3637,  1691,
    1727,  2504,  1702,  3830, -1515, -1515,  2967,  1733, -1515, -1515,
    3833, -1515,  1756,  2469,  2967,  1753,   666,  1758,  2967,  1956,
    1202,  3271,   887,   888,   889,   890,   891,   892,  1759,  1762,
    1765,  1766,  1767,  1957,  2503,  3855,  1768,   589,  3857,   521,
    1033,  1034,   893,  2504,  3349,  1769,  1770,   606,  1771,  1772,
    1783,  1784,  3405,  3285,  3286,  1785,  3288,  1786,   491,   590,
    1959,  1806,  3415,  1826,  2967, -1515,  1817,  2499,  1809,   522,
    3016,  1828,  1610,  1611,  1612,  1613,  1614, -1515,  4059,  3424,
    1825,  1827,  1033,  1034,  1832,  1960,  3411,  1835,  1838,  1839,
    1840,  3801,  3435,   591,  1849, -1515,  4060, -1515,   687,   606,
    1855,  1879,   523,  1882,  1886,  1204,  1205,  1914,  2327,  1915,
    3448,  3350,  1916,  1917,  1203,  1202,  1919,  2504,  1693,  4061,
   -1515, -1515,  4147,  1928, -1515, -1515,  1931,  1945,  -826,  1954,
    3331,  2500,  2328,  2000,  1538,  3914,  2082,  2005,  2006,  3335,
    2158,  2065,  2083,  2084,  4189,  1961,  2329,  2085,  2086,  1202,
     524,  2087,   592,  1353,  1199,   691,  2088,  2330,  2089,  2501,
    2090,  2091,   692,  3437,  2092,  1353,  2093,  2094,  1204,  1205,
    -791,  -791,  2008,  2108,  1615,  1616,  1617,  1618,  2095,  2096,
    -791,  1206,  2097,  3550,  2098,  2099,  2011,  2129,  2100,  2101,
     697,  2102,  2103,  2104,  2012,  2105,  3500,  1958,  2106,  2107,
    2110,  2128,  2134,  2144,  2866,  1243,  2331,  2332,  3944,  3945,
    2203,  3947,  3948,  2145,  2207,  2146,  2147,  2153,  2014,  2159,
    2187,  2161,  2179,  1246,  3924,  2162,  2163,  2502,  3427,  1033,
    1034,  2190,  1473,  2178,  2333,  3638,  2015,  2180,  2231,  1962,
    2185,  2186,  3639,  2504,  2196,  2200,  2235,  2820,  1208,  1209,
    1210,  1211,  1212,  1213,  1214,  2204,  3138,  2236,   704,  2208,
    2226,  2227,  2232,  1204,  1205,  2020,  2843,  3538,  2266,  2247,
    3540,  2248,   616,  4241,  1959,   -64,  2249,  2270, -1222,  3640,
     525,   616,  1619,  2276,  1620,  1621,  1622,  2788,  1214,  2286,
    2306,   941, -1344,  1623,   909,   909,  4373,  1204,  1205,  1960,
    1100,  2334,   501,  2320,  1152,  1156,  2338,  4062,  2503,  2346,
    1207,  1208,  1209,  1210,  1211,  1212,  1213,  1214,  1247,  1694,
    2352,  2463,  2363,   715,  2366,  2388,  2391,  2392,  1246,  2407,
    2596,  2413,  2414,  1184,   718,  2418,  1185,  2024,   719,   720,
    2596,  2415,  2967,  1248,  2025,  1515,  1516,  1249,  2865,  1202,
    3641,   526,  1694,  2335,  2419,  2420,  2421,  2422,  2967,  1961,
     606,  2026,  2596,  2437,  2439,  4066,  2444,  2471,  1693,  2476,
    2458,  1624,  4503,  2472,  2475,  2478,  2484,  1368,  4378,  4379,
    2482,  4381,  1693,  2485,  1250,  3199,  4512,  1693,  2486,  4373,
     502,  4503,  1693,  2487,  3200,  2488,  4512,  2489,  2520,  3642,
    2533,  2519,  1251,  2542,  3201,  1207,  1208,  1209,  1210,  1211,
    1212,  1213,  1214,  2543,   527,  2545,  3202,  3203,  3204,   528,
    2028,  2546,  2556,  1247,  -857,  2552,  1625,  1626,  4418,  2555,
    4419,  4420,  3205,  4120,  3055,  2538,  2539,   529,  2029,  2554,
    2563,  1209,  1210,  1211,  1212,  1213,  1214,  3555,  1248,  2564,
     666,  2568,  1249,  1962,  2464,  3643,  2569,  2574,  2575,  3696,
    3696,  3696,   530,  3773,  1252,  2584,  2603,  2605,  2643,  2599,
    2683,  2665,   503,  2465,  2691,   616,  2687,   531,  2713,  2696,
    2714,  2712,  2294,  2725,  2466,  2726,  1531,  1532,  2738,  1250,
    2760,  2767,  2033,  2775,  2784,  2795,  2800,  1204,  1205,  2785,
    2035,  2796,  2802,  2005,  2006,  4473,  4231,  1251,  2801,  1331,
    4229,  4066,  4488,  2803,  2813,  2804,  2815,  2504,  1332,   791,
    2810,  2816,  2823,  2824,  1812,  3801,   741,  2827,  1333,  2828,
    3802,  2829,   687,  3803,  2833,  2847,  -791,  -791,  2008,  3762,
    1334,  1335,  1336,   747,  1694,  2848,  -791,   791,   749,  2850,
    2411,   750,  2011,  2851,  2852,  2399,  1337,  2453,  2454,  2455,
    2012,   616,  2398,  1863,  1627,  2870,  2871,  2467,  1864,  1252,
    2041,  3664,  2881,  2891,  2895,  2896,  2897,  2898,  1186,  1628,
    1629,  2899,  2905,  2906,  2014,  2907,  2923,  2927,  2928,   691,
    3783,  2974,  1253,  2941,  3688,  2976,   692,  3048,  1473,  3696,
    3038,  1254,  2015,  3044,  3804,  3805,  3050,  3064,   606,  3065,
    3069,  3070,  3071,  3072,  2034,  2154,  1255,  3816,  3811,  3105,
    3096,  3109,  3116,  3118,   697,  1368,  2042,  2043,  2044,  3111,
    3224,  2020,  3166,  2045,  1256,  3119,  3236,  3222,  4515,  1207,
    1208,  1209,  1210,  1211,  1212,  1213,  1214,  3120,   616,  2046,
    3122,  3206,  2047,  3123,  3229,  3182,  1307,  3176,  3177,  3258,
    3269,  3270,  3289,  3278,  3217,   791,  3290,  3302,  3207,  3334,
     791,  3316,  3809,   504,  3233,  3858,  4297,  1257,  3247,  2468,
    3180,  3297,  3862,  3184,  3189,  3301,  3253,  3192,  2049,  3305,
    3550,  4297,   704,   505,  3924,  3232,  3317,  1253,  3250,  3274,
    3435,   791,  3275,  2024,  3315,  4307,  1254,  1258,  3328,  3338,
    2025,  3348,  3346,  1905,  3776,  3347,  3406,   791,  3409,  3412,
    3413,  1255,  3417,   616,  3419,  3423,   495,  2026,  3420,   496,
    3430,  3431,  3436,  2380,  3439,  3445,   506,  3446,  -573,  1256,
    2667,   507,  1947,  3447,  3091,  3467,  3465,  3471,  2469,  4229,
    3478,  3479,  3491,  2253,  2002,  3171,  2027,   715,  3507,  3508,
    3517,   791,   791,   791,   791,  3519,  3522,  3528,  3543,  3530,
    3551,  3556,   719,   720,   791,  1338,   508,  3564,  3565,  3208,
    3557,  3577,  1257,  3585,   509,  3588,  2028,  3589,   616,  3594,
    3603,  3610,  1339,  3661,  3838,  3209,  3658,  2597,  3663,  3665,
    3671,  2846,  3675,  3685,  2029,  3686,  3684,  3689,  3692,  3690,
    3696,  3696,  1258,  3696,  3696,  3699,  3702,  3703,  3704,  3705,
    3706,  4066,  3712,  3710,  4297,  3714,  3722,  3715,  3718,  3723,
    3733,  3732,  3739,  3868,  4405,  2611,  2612,  3724,  2619,  3740,
    1368,  2622,  2623,  2624,  2625,  2626,  2627,  2628,  3750,  4485,
    2631,  3758,  2633,  3741,  3757,  3210,  3767,  3273,  2033,   809,
     810,  3769,  3755,  3770,  3774,  3775,  2035,  3777, -1427, -1432,
    3814,  3649,  3211,  3787,  3817,  4485,  3829,  3843,  3796,  3797,
    3842,  3847,  3849,  4437,  3799,  4008,   606,  3800,  3825,  3831,
    3850,  3652,  4517,  3856,  3869,  3894,  3891,  3696,  3885,  3870,
    3893,  3895,  4297,  3899,  4297,  3912,  3900,  3901,  3917,  3913,
    3930,  4456,  3932,  3916,  3953,  3959,   718,  3713,  3966,  1340,
    3967,  4297,  4003,  4012,  4036,  4038,  4026,   606,  4040,  4046,
    4053,  4049,  4078,  4099,  4117,  3927,  2041,  4080,   616,  4091,
    4119,   811,  -346,  4140,  4129,  4154,  4122,  4156,  4157,  4132,
    4009,  4297,  4297,  4165,  4139,  4169,  4493,  4167,  4162,  4174,
     741,  4193,  -364,  3033,  3802,  4196,  4223,  3803,  4224,  4092,
    4221,  4225,   812,  4261,  4266,  4273,  4240,   747,  4246,  1341,
    4243,  4283,   749,  4293,  4103,   750,   813,  4286,  4287,  4110,
    4294,  4047,  2042,  2043,  2044,  4298,  1342,  4304,  4305,  2045,
    4306,  4309,  4330,  4331,  4316,  4332,  4341,  4333,  4339,   814,
    4340,  4342,   815,  4343,  4344,  2046,  4345,  4350,  2047,  4352,
     791,  4354, -2322,  4364,  4380,   816,  4358,  4355,  4382,  4377,
    4383,  4393,  4398,  4396,  4407,  4409,  4406,  4412,  3804,  3805,
    4415,  4421,  4424,  4425,  4426,  4430,  4431,   817,  4438,  4435,
    4443,  4445,  4449,  4451,  2049,  4454,  4441,  4457,  4442,  4455,
    1694,  4460,  4467,  4464,  4465,  4474,  4489,  4490,  4494,  4504,
    4112,  4514,   818,  2793,  2635,   791,   791,  4260,   819,  3673,
    1056,  3674,  2935,  3873,   791,   791,   791,   791,   791,   791,
     791,  4232,  2846,  4130,  2846,  4365,  1485,  4366,   791,   791,
    3871,   791,   791,  3875,  4007,  4506,   791,   791,  2668,  4469,
     791,   791,   791,   791,   576,   791,   791,   951,  2389,   820,
    4197,  3213,  2313,   791,   791,  4478,   791,   791,   791,   791,
     791,  3978,  3979,   791,   791,   791,   791,   791,   791,   791,
     791,   791,   791,   791,  3981,   791,  3982,  4390,   791,   791,
    3984,  3985,  3986,   791,  3351,  3352,  3987,   791,   791,   791,
    3353,  3988,  3354,  3989,  3355,  3356,  4053,  4291,  4391,  3992,
     791,   791,   791,  4303,  4363,   616,  4134,  3993,  3994,   791,
    2791,  3357,  4302,   877,   810,  1553,   791,   791,   791,  4015,
     791,  2050,  2588,  3342,  1998,  3235,  3760,   791,   791,   791,
    3521,   791,   791,   791,   791,   791,  3240,   791,   791,   791,
     791,   791,   791,   791,   791,  1815,  4245,  4048,   791,   791,
    4315,  3763,   848,  4440,  4376,  4414,  4164,  2113,   653,  3358,
    2586,  3691,  3359,  3089,  3428,  3602,  2593,  3035,  3590,  3617,
    3360,  4375,  3618,  3961,  3659,  3848,  3810,  4314,  3834,  3168,
    3494,   821,  3496,  2925,  1694,   822,  3492,  4177,   516,  3361,
     517,  4179,  2143,  4144,  4137,   811,  4180,  4142,  2677,  4025,
    3964,   823,  2590,  1932,   962,  3023,  3362,  3813,   616,   824,
    3591,  2830,  2111,  3226,  2372,  2811,  1930,   825,  2074,  2853,
    3518,   978,  2766,  2397,  3191,  3503,   812,  1358,  1648,  2710,
    3561,   810,  3363,  2765,  3364,  2918,  4084,  4176,  4385,  3672,
     813,  4386,  2782,  4250,  1599,   826,  3597,  3365,  3366,  3934,
    4459,  3926,  4258,  2860,  2681,  1755,  3765,  3534,   827,   828,
    1830,  2836,  2809,   814,  1465,  1466,   815,  3533,  3571,   616,
    1467,  4312,  1803,   966,  2152,  1082,  1468,  1074,  2446,   816,
     947,  1898,  2447,  1920,  2307,  3055,  3055,   791,  3367,  3601,
    3520,  4439,  4458,  4334,  4384,  4395,  4513,   791,  4516,  3537,
    3841,   817,  4403,  3553,  2269,   911,  1114,   912,   829,  2879,
    3554,  2425,   811,  2877,  1796,   791,  2876,  2869,  3368,  1837,
    2351,   880,  1131,  1345,  4039,  3214,   818,  3369,  3370,  4045,
    3371,   882,   819,  2133,  1350,   647,  1844,   830,   648,  4323,
    4324,  4121,  3866,   812,  1060,  1061,  4507,  1062,     0,  1852,
       0,     0,     0,     0,     0,     0,     0,   813,     0,   831,
       0,   832,     0,     0,     0,     0,  3372,  3373,  3374,  1176,
    4447,     0,     0,   820,     0,  4452,     0,     0,     0,     0,
     814,     0,     0,   815,     0,  3375,  3376,  3377,     0,     0,
       0,     0,  3378,     0,     0,  3379,   816,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4486,     0,  3380,  3381,     0,     0,     0,     0,   817,     0,
    1509,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1694,     0,  4486,     0,     0,     0,
       0,     0,     0,   818,   616,  3382,  3383,     0,  1694,   819,
       0,     0,     0,  1694,     0,     0,     0,     0,  1694,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3384,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1510,  1511,  1512,  1513,  1514,  1515,  1516,  1517,  1518,  1519,
     820,  1520,  1521,  1522,  1523,  1524,  1525,  1526,  1527,  1528,
       0,  1529,  1530,     0,     0,   821,     0,     0,     0,   878,
       0,     0,     0,     0,     0,     0,     0,     0,   791,     0,
       0,     0,     0,     0,  3385,   823,     0,     0,  3386,     0,
       0,     0,     0,   824,     0,     0,     0,     0,     0,     0,
    3387,   825,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   826,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   827,   828,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3388,     0,
       0,  3389,     0,     0,  3390,  3391,  3392,  3393,     0,     0,
       0,     0,     0,     0,     0,     0,   791,   791,   791,     0,
       0,     0,   821,     0,     0,  1508,  1531,  1532,     0,     0,
       0,   791,   829,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   823,     0,     0,     0,  3394,  3395,     0,     0,
     824,     0,     0,     0,     0,     0,     0,   791,   825,     0,
       0,   830,     0,   791,     0,     0,   791,     0,   791,     0,
       0,  3396,     0,     0,   791,     0,   791,   791,     0,     0,
    1579,  1580,     0,   831,     0,   832,   826,     0,     0,  1590,
    1591,     0,     0,  1594,  1595,  1596,     0,     0,     0,   827,
     828,     0,     0,  1604,  1605,     0,  1606,  1607,     0,     0,
       0,  1632,     0,     0,     0,  1641,  1642,  1643,  1644,     0,
    1646,     0,     0,     0,     0,     0,     0,     0,  1654,  1655,
       0,  1658,  1659,     0,     0,     0,     0,     0,  1663,  1664,
    1665,     0,     0,  1668,  1669,  1670,  1671,  1672,  1673,   829,
    1675,     0,   791,  1678,  1679,     0,     0,     0,  1682,     0,
       0,     0,  1685,  1689,  1690,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1697,  1698,  1699,   830,     0,
       0,     0,     0,     0,  1707,     0,     0,     0,     0,     0,
       0,  1712,  1713,  1714,     0,     0,     0,     0,     0,     0,
     831,     0,   832,   791,     0,     0,     0,     0,     0,     0,
       0,   791,     0,  2001,     0,     0,     0,     0,  2002,     0,
    2003,     0,  2004,     0,  1750,     0,     0,     0,     0,     0,
       0,     0,  2005,  2006,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2007,     0,     0,     0,  2008,  2009,     0,
       0,     0,     0,  2010,     0,     0,     0,     0,     0,     0,
       0,  2011,     0,     0,  2005,  2006,     0,     0,     0,  2012,
       0,     0,     0,     0,     0,     0,     0,     0,  2013,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2014,     0,     0,     0,     0,     0,  2008,
       0,     0,  1610,  1611,  1612,  1613,  1614,  1473,     0,     0,
       0,  2015,     0,  2011,     0,     0,     0,     0,     0,  2016,
    2017,  2012,     0,     0,     0,     0,  2018,     0,     0,     0,
       0,     0,     0,     0,  2019,     0,     0,     0,  -931,     0,
    2020,     0,  1851,     0,     0,  2014,     0,     0,     0,     0,
       0,  2021,  1857,     0,     0,     0,     0,     0,     0,  1473,
       0,     0,     0,  2015,     0,     0,     0,     0,     0,     0,
    1885,  2022,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2020,   791,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1615,  1616,  1617,  1618,     0,     0,
    2023,     0,  2024,     0,     0,     0,     0,     0,     0,  2025,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2026,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2027,
       0,     0,     0,     0,  2024,     0,   791,     0,     0,     0,
     791,  2025,     0,     0,     0,   791,   791,     0,     0,     0,
       0,     0,     0,     0,   791,     0,     0,   791,  2026,     0,
       0,     0,     0,     0,     0,  2028,     0,   791,   791,     0,
     791,   791,     0,   791,   791,   791,   791,   791,     0,     0,
     791,     0,  1619,  2029,  1620,  1621,  1622,  2030,     0,   791,
       0,     0,     0,  1623,     0,     0,   791,     0,   791,     0,
     791,   791,     0,   791,   791,     0,     0,     0,   791,   791,
     791,     0,     0,     0,   791,   791,   791,  2028,   791,     0,
     791,     0,   791,     0,   791,  2031,   791,     0,     0,     0,
    2032,   791,     0,     0,     0,  2029,     0,  2033,     0,     0,
       0,     0,  2034,  2164,     0,  2035,     0,     0,     0,     0,
     791,     0,     0,     0,     0,     0,     0,   791,     0,     0,
     791,     0,     0,     0,     0,     0,   791,     0,     0,   791,
       0,  1624,     0,   791,     0,     0,  2036,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2033,
    2037,  2038,  2039,  2040,     0,     0,     0,  2035,     0,     0,
       0,     0,     0,     1,     0,     2,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2041,     0,     0,     0,     0,
       3,     0,     0,     0,     4,     0,  1625,  1626,     0,     0,
       0,     0,     0,   791,     0,     0,     0,     0,     5,     6,
       0,  2239,  2241,  2243,     0,     0,     7,     0,     0,     0,
       8,     9,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    10,  2041,     0,     0,
       0,  2042,  2043,  2044,     0,     0,     0,     0,  2045,     0,
       0,     0,  2278,     0,    11,     0,     0,     0,     0,     0,
       0,  2283,     0,  2284,  2046,     0,     0,  2047,     0,     0,
       0,     0,     0,     0,     0,     0,    12,   791,     0,     0,
       0,   791,     0,     0,     0,    13,    14,    15,     0,     0,
    2048,     0,     0,  2042,  2043,  2044,     0,     0,    16,    17,
    2045,     0,     0,  2049,     0,     0,     0,     0,     0,     0,
       0,    18,     0,     0,     0,     0,  2046,     0,     0,  2047,
       0,     0,     0,     0,     0,    19,     0,     0,     0,     0,
       0,     0,     0,     0,  1627,     0,     0,     0,     0,     0,
       0,     0,     0,    20,     0,     0,     0,  2368,     0,  1628,
    1629,     0,     0,     0,     0,  2049,     0,     0,    21,     0,
      22,     0,     0,  -931,     0,    23,     0,     0,    24,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    25,     0,    26,     0,     0,     0,     0,  2424,     0,
       0,     0,     0,     0,     0,     0,  2434,     0,     0,  2005,
    2006,    27,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    28,     0,
       0,     0,    29,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  -791,  -791,  2008,     0,     0,     0,     0,     0,
       0,     0,  -791,     0,     0,     0,     0,     0,  2011,     0,
       0,     0,     0,     0,     0,     0,  2012,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2014,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1473,     0,     0,     0,  2015,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    30,     0,
       0,     0,     0,     0,     0,     0,     0,  2020,     0,   791,
       0,     0,     0,   791,     0,    31,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    32,     0,
       0,     0,     0,   791,   791,     0,     0,     0,     0,    33,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   791,     0,     0,     0,     0,     0,
       0,    34,     0,   791,    35,   791,    36,   791,     0,    37,
       0,     0,    38,    39,     0,     0,     0,     0,  2604,  2024,
       0,     0,    40,     0,    41,     0,  2025,     0,     0,     0,
       0,     0,    42,     0,   791,     0,     0,     0,    43,   791,
       0,     0,     0,  2026,     0,     0,    44,     0,     0,     0,
       0,    45,     0,    46,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   791,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    47,     0,     0,     0,     0,     0,     0,
      48,  2690,     0,     0,     0,  2692,     0,     0,     0,     0,
    2694,  2695,  2028,     0,     0,     0,     0,     0,     0,  2708,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2029,     0,  2715,  2716,     0,  2717,     0,     0,  2719,  2720,
    2721,  2722,  2723,    49,     0,     0,     0,     0,   791,     0,
       0,     0,     0,     0,  2727,    50,     0,     0,     0,    51,
       0,  2728,    52,  2729,     0,  2730,  2731,    53,  2732,     1,
       0,     2,     0,  2735,  2736,  2737,     0,     0,     0,  2739,
    2740,  2741,     0,  2742,  2033,  2744,     0,  2746,     0,  2748,
       4,  2749,  2035,     0,   791,    54,  2750,     0,     0,     0,
       0,     0,     0,     0,     5,     6,     0,     0,     0,     0,
      55,     0,     7,     0,     0,  2770,     8,     9,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2780,    10,     0,  2783,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      11,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2041,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    12,     0,     0,     0,     0,     0,     0,     0,
       0,    13,    14,    15,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    16,    17,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   791,   791,     0,     0,     0,     0,     0,  2042,  2043,
    2044,    19,     0,     0,     0,  2045,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    20,
       0,  2046,     0,     0,  2047,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    21,     0,    22,     0,     0,     0,
       0,    23,  3021,     0,    24,     0,     0,  2002,     0,  2003,
       0,     0,  2434,     0,   791,     0,     0,     0,     0,     0,
    2049,  2005,  2006,     0,     0,     0,     0,    25,     0,    26,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   791,
       0,     0,     0,   791,   791,     0,   791,    27,     0,     0,
       0,     0,  2007,     0,     0,   791,  2008,     0,     0,     0,
     791,     0,     0,   791,    28,   791,   791,     0,    29,     0,
    2011,     0,     0,     0,     0,     0,     0,     0,  2012,     0,
       0,     0,     0,     0,     0,     0,     0,  2013,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   791,     0,
       0,     0,  2014,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1473,     0,     0,     0,
    2015,     0,     0,     0,     0,     0,     0,     0,  2016,     0,
       0,     0,   791,     0,     0,  3022,     0,     0,     0,     0,
       0,     0,     0,  2019,     0,     0,     0,     0,     0,  2020,
       0,     0,     0,     0,     0,     0,   791,     0,     0,     0,
       0,     0,     0,     0,    30,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2022,    31,   856,   914,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    32,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    33,     0,   915,   899,     0,
       0,     0,     0,     0,     0,     0,     0,   791,   916,     0,
       0,  2024,     0,     0,     0,   791,     0,    34,  2025,     0,
      35,     0,    36,     0,     0,    37,     0,     0,    38,    39,
       0,   917,     0,   918,     0,  2026,     0,     0,    40,     0,
      41,     0,     0,   919,     0,     0,     0,     0,    42,     0,
       0,     0,     0,     0,    43,     0,     0,     0,  2027,     0,
       0,     0,    44,     0,  3101,     0,     0,    45,  3103,    46,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3125,  3126,
       0, -1791,   920,     0,  2028,     0,     0,   921,     0,    47,
     922,     0,     0,     0,     0,     0,    48,     0,     0,  3148,
       0,     0,  2029,     0,     0,     0,  2030,     0,  3158,     0,
    3160,     0,  3162,     0,     0,     0,     0,     0,     0,   923,
       0,   924,     0,     0,     0,     0,     0,     0,   925,     0,
     926,     0,     0,     0,     0,     0,     0,     0,     0,    49,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2032,
       0,    50,     0,   927,   928,    51,  2033,     0,    52,     0,
       0,     0,     0,    53,  2035,     0,     0,     0,     0,     0,
       0,  3223,     0,     0,     0,     0,     0,   929,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    54,     0,     0,     0,     0,     0,     0,   930,     0,
       0,     0,     0,     0,     0,     0,    55,     0,     0,     0,
    2038,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   791,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   931,     0,     0,  2041,     0,     0,     0,     0,     0,
       0,     0,     0,  2434,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   791,   791,
       0,     0,     0,     0,     0,     0,     0,   791,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3310,
    2042,  2043,  2044,     0,     0,     0,   932,  2045,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2046,     0,     0,  2047,     0,     0,     0,
       0,   933,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   934,   935,     0,     0,   936,   937,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2049,     0,     0,     0,   938,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   939,     0,     0,     0,  3407,  3408,     0,     0,
     791,     0,     0,     0,     0,   940,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   791, -2359,     0,     0,     0,
     941,     0,     0,     0,     0,     0,     0,     0,     0,   791,
       0,     0,     0,     0,     0,     0,     0,     0,   942,  3452,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3470,     0,     0,     0,  3473,  3474,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3481,     0,     0,     0,     0,  3483,     0,     0,  3484,     0,
    3485,  3486,     0,     0,     0, -2359,     0,     0,     0,     0,
       0,   943,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3996,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3514,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   791,     0,     0,     0,     0,     0,
       0,  3514,   791,     0,     0,     0,     0,     0,     0,   791,
       0,   791,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   791,     0,     0,
       0,     0,     0,  3996,  3996,     0,     0,     0,     0,     0,
       0,     0,  3514,     0,     0,     0,     0,     0,     0,     0,
    3582,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   791,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   791,
       0,   791,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   791,     0,  3996,  3996,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4237,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   791,
       0,  3996,     0,     0,     0,     0,  3514,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3996,   791,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3996,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   791,     0,  3785,  3786,     0,     0,     0,     0,     0,
       0,     0,  3310,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   791,
    3996,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3996,  3996,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   791,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3996,
       0,     0,     0,     0,     0,     0,   791,     0,     0,  3996,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   791,
       0,     0,     0,     0,     0,  3892,  3996,     0,  3996,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3996,     0,
       0,     0,   791,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3996,     0,  3996,     0,  3996,
    3514,     0,     0,     0,     0,     0,  3996,     0,     0,     0,
       0,     0,     0,     0,  3310,     0,  3996,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3996,  3996,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3996,  3996,     0,     0,
       0,  3996,     0,     0,     0,     0,     0,   791,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   791,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4072,     0,     0,
       0,     0,     0,     0,  4077,     0,  4079,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4098,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3310,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4191,     0,  4192,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4200,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4295,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4300,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3514,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4348,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4397,     0,     0,     0,     0,     0,     0,   137,     0,
     662,   139,   140,   141,   142,     0,     0,   143,     0,     0,
       0,   144,     0,     0,   663,     0,   146,   147,   148,   149,
     664,   151,     0,   152,  4423,     0,   665,   153,   666,   667,
     668,   154,   669,     0,   155,   156,   157,  1686,   158,     0,
     159,   160,     0,     0,   161,   670,   671,   162,   163,     0,
     164,   672,   673,   166,     0,   167,   168,   169,   170,   674,
     172,     0,   675,   174,     0,   175,   176,   177,   178,   179,
     180,   181,   182,   183,     0,   184,   185,     0,   186,   187,
     188,   676,   190,     0,   677,   678,   191,     0,     0,   192,
     679,   193,   680,     0,   194,   681,   682,     0,   195,   196,
     197,   683,   684,   685,     0,     0,     0,     0,   686,   200,
     687,     0,     0,   688,   201,   202,     0,   203,     0,     0,
       0,   204,  4495,   205,   206,   207,   208,   209,     0,     0,
       0,   210,     0,     0,   211,   212,   213,     0,     0,     0,
     214,     0,   215,   216,     0,   217,   218,   219,     0,     0,
     220,   221,  3514,   222,   223,   224,   225,   226,   227,   689,
       0,   228,   229,   230,   231,   232,   690,   691,   233,   234,
       0,   235,   236,   237,   692,     0,   238,     0,     0,     0,
     693,   240,     0,   241,     0,   242,     0,   243,   694,   245,
     695,     0,   247,     0,   248,     0,   696,     0,   249,   250,
       0,   251,   697,     0,   252,   253,     0,     0,     0,   698,
     255,   256,   257,   699,     0,   258,   259,   260,     0,     0,
     261,     0,     0,     0,   700,   262,   263,   701,     0,     0,
     264,     0,     0,     0,   265,   266,     0,   267,   268,     0,
       0,     0,   269,     0,     0,   270,   271,     0,  1687,   272,
       0,   702,   273,   274,     0,     0,     0,     0,     0,   703,
     276,     0,   277,     0,   278,     0,   279,   280,     0,     0,
     704,     0,     0,     0,     0,   281,     0,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,     0,   299,   300,   301,   705,   302,
     303,   304,   305,   706,   306,   307,     0,     0,     0,     0,
     308,   309,   310,   311,   707,   313,     0,     0,   708,   315,
     709,   316,     0,   317,   710,   711,   712,   713,   714,   322,
     323,   324,   325,   326,     0,   715,   327,   328,     0,     0,
     329,   330,   331,   332,   716,   717,   718,   333,   334,     0,
     719,   720,   335,     0,   336,   337,   721,     0,   339,   340,
     341,     0,   342,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   343,   344,   345,   722,   346,   347,     0,   348,
     349,   723,   351,   352,   353,   354,   724,   725,   357,   726,
       0,   358,   359,   360,     0,   361,     0,   362,   363,   364,
     365,   366,     0,   727,   368,   369,     0,     0,   370,     0,
       0,     0,   371,   372,   373,   374,   375,     0,     0,   376,
     377,   378,   379,   380,     0,   381,   382,     0,   383,   384,
     385,   728,   729,   386,     0,   387,     0,   388,   389,     0,
     390,   391,   392,     0,   730,     0,   731,   394,   395,   396,
     397,   398,   732,   733,   401,   402,   403,   404,     0,   734,
     406,     0,     0,     0,   407,   408,   409,   410,     0,     0,
       0,   411,     0,     0,     0,   412,     0,   413,   414,   415,
     416,     0,   417,   418,   419,   420,   421,     0,     0,     0,
       0,     0,   422,   423,   424,     0,   425,   426,     0,   427,
       0,     0,   428,     0,     0,   429,   430,   431,   432,   433,
     434,   735,   736,   435,   436,     0,   437,   438,   737,   440,
     441,   442,   738,   739,   443,   444,   445,   446,   740,   447,
     448,     0,     0,   449,   450,   451,   452,     0,   741,   453,
     454,     0,   742,   743,   744,   745,     0,     0,     0,     0,
    1688,   459,   460,     0,   746,   747,   748,   462,   463,   464,
     749,   465,   466,   750,   467,   468,     0,   469,   470,     0,
       0,   471,     0,     0,   472,     0,   473,     0,   751,   475,
       0,     0,   752,   753,   754,   755,   476,     0,     0,   477,
     756,     0,   757,   478,   479,   480,   758,   759,     0,     0,
       0,     0,     0,     0,   483,   484,     0,   485,   486,   487,
       0,     0,   760,     0,     0,     0,   761,   762,     0,     0,
       0,     0,   763,   764,     0,     0,   765,   766,     0,     0,
     767,   768,   137,     0,   662,   139,   140,   141,   142,  2430,
       0,   143,     0,     0,     0,   144,     0,     0,   663,     0,
     146,   147,   148,   149,   664,   151,     0,   152,     0,     0,
    2431,   153,   666,   667,   668,   154,   669,     0,   155,   156,
     157,     0,   158,     0,   159,   160,     0,     0,   161,   670,
     671,   162,   163,     0,   164,   672,   673,   166,     0,   167,
     168,   169,   170,   674,   172,     0,   675,   174,     0,   175,
     176,   177,   178,   179,   180,   181,   182,   183,     0,   184,
     185,     0,   186,   187,   188,   676,   190,     0,   677,   678,
     191,     0,     0,   192,   679,   193,   680,     0,   194,   681,
     682,     0,   195,   196,   197,   683,   684,   685,     0,     0,
       0,     0,   686,   200,   687,     0,     0,  2432,   201,   202,
       0,   203,     0,     0,     0,   204,     0,   205,   206,   207,
     208,   209,     0,     0,     0,   210,     0,     0,   211,   212,
     213,     0,     0,     0,   214,     0,   215,   216,     0,   217,
     218,   219,     0,     0,   220,   221,     0,   222,   223,   224,
     225,   226,   227,   689,     0,   228,   229,   230,   231,   232,
     690,   691,   233,   234,     0,   235,   236,   237,   692,     0,
     238,     0,     0,     0,   693,   240,     0,   241,     0,   242,
       0,   243,   694,   245,   695,     0,   247,     0,   248,     0,
     696,     0,   249,   250,     0,   251,   697,     0,   252,   253,
       0,     0,     0,   698,   255,   256,   257,   699,     0,   258,
     259,   260,     0,     0,   261,     0,     0,     0,   700,   262,
     263,   701,     0,     0,   264,     0,     0,     0,   265,   266,
       0,   267,   268,     0,     0,     0,   269,     0,     0,   270,
     271,     0,     0,   272,     0,   702,   273,   274,     0,     0,
       0,     0,     0,   703,   276,     0,   277,     0,   278,     0,
     279,   280,     0,     0,   704,     0,     0,     0,     0,   281,
       0,   282,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,     0,   299,
     300,   301,   705,   302,   303,   304,   305,   706,   306,   307,
       0,     0,     0,     0,   308,   309,   310,   311,   707,   313,
       0,     0,   708,   315,   709,   316,     0,   317,   710,   711,
     712,   713,   714,   322,   323,   324,   325,   326,     0,   715,
     327,   328,     0,     0,   329,   330,   331,   332,   716,   717,
     718,   333,   334,     0,   719,   720,   335,     0,   336,   337,
     721,  2433,   339,   340,   341,     0,   342,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   343,   344,   345,   722,
     346,   347,     0,   348,   349,   723,   351,   352,   353,   354,
     724,   725,   357,   726,     0,   358,   359,   360,     0,   361,
       0,   362,   363,   364,   365,   366,     0,   727,   368,   369,
       0,     0,   370,     0,     0,     0,   371,   372,   373,   374,
     375,     0,     0,   376,   377,   378,   379,   380,     0,   381,
     382,     0,   383,   384,   385,   728,   729,   386,     0,   387,
       0,   388,   389,     0,   390,   391,   392,     0,   730,     0,
     731,   394,   395,   396,   397,   398,   732,   733,   401,   402,
     403,   404,     0,   734,   406,     0,     0,     0,   407,   408,
     409,   410,     0,     0,     0,   411,     0,     0,     0,   412,
       0,   413,   414,   415,   416,     0,   417,   418,   419,   420,
     421,     0,     0,     0,     0,     0,   422,   423,   424,     0,
     425,   426,     0,   427,     0,     0,   428,     0,     0,   429,
     430,   431,   432,   433,   434,   735,   736,   435,   436,     0,
     437,   438,   737,   440,   441,   442,   738,   739,   443,   444,
     445,   446,   740,   447,   448,     0,     0,   449,   450,   451,
     452,     0,   741,   453,   454,     0,   742,   743,   744,   745,
       0,     0,     0,     0,     0,   459,   460,     0,   746,   747,
     748,   462,   463,   464,   749,   465,   466,   750,   467,   468,
       0,   469,   470,     0,     0,   471,     0,     0,   472,     0,
     473,     0,   751,   475,     0,     0,   752,   753,   754,   755,
     476,     0,     0,   477,   756,     0,   757,   478,   479,   480,
     758,   759,     0,     0,     0,     0,     0,     0,   483,   484,
       0,   485,   486,   487,     0,     0,   760,     0,     0,     0,
     761,   762,     0,     0,     0,     0,   763,   764,     0,     0,
     765,   766,     0,     0,   767,   768,   137,     0,   662,   139,
     140,   141,   142,     0,     0,   143,     0,     0,     0,   144,
       0,     0,   663,     0,   146,   147,   148,   149,   664,   151,
       0,   152,     0,     0,   665,   153,   666,   667,   668,   154,
     669,     0,   155,   156,   157,     0,   158,     0,   159,   160,
       0,     0,   161,   670,   671,   162,   163,     0,   164,   672,
     673,   166,     0,   167,   168,   169,   170,   674,   172,     0,
     675,   174,     0,   175,   176,   177,   178,   179,   180,   181,
     182,   183,     0,   184,   185,     0,   186,   187,   188,   676,
     190,     0,   677,   678,   191,     0,     0,   192,   679,   193,
     680,     0,   194,   681,   682,     0,   195,   196,   197,   683,
     684,   685,     0,     0,     0,     0,   686,   200,   687,     0,
       0,   688,   201,   202,     0,   203,     0,     0,     0,   204,
       0,   205,   206,   207,   208,   209,     0,     0,     0,   210,
       0,     0,   211,   212,   213,     0,     0,     0,   214,     0,
     215,   216,     0,   217,   218,   219,     0,     0,   220,   221,
       0,   222,   223,   224,   225,   226,   227,   689,     0,   228,
     229,   230,   231,   232,   690,   691,   233,   234,     0,   235,
     236,   237,   692,     0,   238,     0,     0,     0,   693,   240,
    2238,   241,     0,   242,     0,   243,   694,   245,   695,     0,
     247,     0,   248,     0,   696,     0,   249,   250,     0,   251,
     697,     0,   252,   253,     0,     0,     0,   698,   255,   256,
     257,   699,     0,   258,   259,   260,     0,     0,   261,     0,
       0,     0,   700,   262,   263,   701,     0,     0,   264,     0,
       0,     0,   265,   266,     0,   267,   268,     0,     0,     0,
     269,     0,     0,   270,   271,     0,     0,   272,     0,   702,
     273,   274,     0,     0,     0,     0,     0,   703,   276,     0,
     277,     0,   278,     0,   279,   280,     0,     0,   704,     0,
       0,     0,     0,   281,     0,   282,   283,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,     0,   299,   300,   301,   705,   302,   303,   304,
     305,   706,   306,   307,     0,     0,     0,     0,   308,   309,
     310,   311,   707,   313,     0,     0,   708,   315,   709,   316,
       0,   317,   710,   711,   712,   713,   714,   322,   323,   324,
     325,   326,     0,   715,   327,   328,     0,     0,   329,   330,
     331,   332,   716,   717,   718,   333,   334,     0,   719,   720,
     335,     0,   336,   337,   721,     0,   339,   340,   341,     0,
     342,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     343,   344,   345,   722,   346,   347,     0,   348,   349,   723,
     351,   352,   353,   354,   724,   725,   357,   726,     0,   358,
     359,   360,     0,   361,     0,   362,   363,   364,   365,   366,
       0,   727,   368,   369,     0,     0,   370,     0,     0,     0,
     371,   372,   373,   374,   375,     0,     0,   376,   377,   378,
     379,   380,     0,   381,   382,     0,   383,   384,   385,   728,
     729,   386,     0,   387,     0,   388,   389,     0,   390,   391,
     392,     0,   730,     0,   731,   394,   395,   396,   397,   398,
     732,   733,   401,   402,   403,   404,     0,   734,   406,     0,
       0,     0,   407,   408,   409,   410,     0,     0,     0,   411,
       0,     0,     0,   412,     0,   413,   414,   415,   416,     0,
     417,   418,   419,   420,   421,     0,     0,     0,     0,     0,
     422,   423,   424,     0,   425,   426,     0,   427,     0,     0,
     428,     0,     0,   429,   430,   431,   432,   433,   434,   735,
     736,   435,   436,     0,   437,   438,   737,   440,   441,   442,
     738,   739,   443,   444,   445,   446,   740,   447,   448,     0,
       0,   449,   450,   451,   452,     0,   741,   453,   454,     0,
     742,   743,   744,   745,     0,     0,     0,     0,     0,   459,
     460,     0,   746,   747,   748,   462,   463,   464,   749,   465,
     466,   750,   467,   468,     0,   469,   470,     0,     0,   471,
       0,     0,   472,     0,   473,     0,   751,   475,     0,     0,
     752,   753,   754,   755,   476,     0,     0,   477,   756,     0,
     757,   478,   479,   480,   758,   759,     0,     0,     0,     0,
       0,     0,   483,   484,     0,   485,   486,   487,     0,     0,
     760,     0,     0,     0,   761,   762,     0,     0,     0,     0,
     763,   764,     0,     0,   765,   766,     0,     0,   767,   768,
     137,     0,   662,   139,   140,   141,   142,     0,     0,   143,
       0,     0,     0,   144,     0,     0,   663,     0,   146,   147,
     148,   149,   664,   151,     0,   152,     0,     0,   665,   153,
     666,   667,   668,   154,   669,     0,   155,   156,   157,     0,
     158,     0,   159,   160,     0,     0,   161,   670,   671,   162,
     163,     0,   164,   672,   673,   166,     0,   167,   168,   169,
     170,   674,   172,     0,   675,   174,     0,   175,   176,   177,
     178,   179,   180,   181,   182,   183,     0,   184,   185,     0,
     186,   187,   188,   676,   190,     0,   677,   678,   191,     0,
       0,   192,   679,   193,   680,     0,   194,   681,   682,     0,
     195,   196,   197,   683,   684,   685,     0,     0,     0,     0,
     686,   200,   687,     0,     0,   688,   201,   202,     0,   203,
       0,     0,     0,   204,     0,   205,   206,   207,   208,   209,
       0,     0,     0,   210,     0,     0,   211,   212,   213,     0,
       0,     0,   214,     0,   215,   216,     0,   217,   218,   219,
       0,     0,   220,   221,     0,   222,   223,   224,   225,   226,
     227,   689,     0,   228,   229,   230,   231,   232,   690,   691,
     233,   234,     0,   235,   236,   237,   692,     0,   238,     0,
       0,     0,   693,   240,  2240,   241,     0,   242,     0,   243,
     694,   245,   695,     0,   247,     0,   248,     0,   696,     0,
     249,   250,     0,   251,   697,     0,   252,   253,     0,     0,
       0,   698,   255,   256,   257,   699,     0,   258,   259,   260,
       0,     0,   261,     0,     0,     0,   700,   262,   263,   701,
       0,     0,   264,     0,     0,     0,   265,   266,     0,   267,
     268,     0,     0,     0,   269,     0,     0,   270,   271,     0,
       0,   272,     0,   702,   273,   274,     0,     0,     0,     0,
       0,   703,   276,     0,   277,     0,   278,     0,   279,   280,
       0,     0,   704,     0,     0,     0,     0,   281,     0,   282,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,     0,   299,   300,   301,
     705,   302,   303,   304,   305,   706,   306,   307,     0,     0,
       0,     0,   308,   309,   310,   311,   707,   313,     0,     0,
     708,   315,   709,   316,     0,   317,   710,   711,   712,   713,
     714,   322,   323,   324,   325,   326,     0,   715,   327,   328,
       0,     0,   329,   330,   331,   332,   716,   717,   718,   333,
     334,     0,   719,   720,   335,     0,   336,   337,   721,     0,
     339,   340,   341,     0,   342,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   343,   344,   345,   722,   346,   347,
       0,   348,   349,   723,   351,   352,   353,   354,   724,   725,
     357,   726,     0,   358,   359,   360,     0,   361,     0,   362,
     363,   364,   365,   366,     0,   727,   368,   369,     0,     0,
     370,     0,     0,     0,   371,   372,   373,   374,   375,     0,
       0,   376,   377,   378,   379,   380,     0,   381,   382,     0,
     383,   384,   385,   728,   729,   386,     0,   387,     0,   388,
     389,     0,   390,   391,   392,     0,   730,     0,   731,   394,
     395,   396,   397,   398,   732,   733,   401,   402,   403,   404,
       0,   734,   406,     0,     0,     0,   407,   408,   409,   410,
       0,     0,     0,   411,     0,     0,     0,   412,     0,   413,
     414,   415,   416,     0,   417,   418,   419,   420,   421,     0,
       0,     0,     0,     0,   422,   423,   424,     0,   425,   426,
       0,   427,     0,     0,   428,     0,     0,   429,   430,   431,
     432,   433,   434,   735,   736,   435,   436,     0,   437,   438,
     737,   440,   441,   442,   738,   739,   443,   444,   445,   446,
     740,   447,   448,     0,     0,   449,   450,   451,   452,     0,
     741,   453,   454,     0,   742,   743,   744,   745,     0,     0,
       0,     0,     0,   459,   460,     0,   746,   747,   748,   462,
     463,   464,   749,   465,   466,   750,   467,   468,     0,   469,
     470,     0,     0,   471,     0,     0,   472,     0,   473,     0,
     751,   475,     0,     0,   752,   753,   754,   755,   476,     0,
       0,   477,   756,     0,   757,   478,   479,   480,   758,   759,
       0,     0,     0,     0,     0,     0,   483,   484,     0,   485,
     486,   487,     0,     0,   760,     0,     0,     0,   761,   762,
       0,     0,     0,     0,   763,   764,     0,     0,   765,   766,
       0,     0,   767,   768,   137,     0,   662,   139,   140,   141,
     142,     0,     0,   143,     0,     0,     0,   144,     0,     0,
     663,     0,   146,   147,   148,   149,   664,   151,     0,   152,
       0,     0,   665,   153,   666,   667,   668,   154,   669,     0,
     155,   156,   157,     0,   158,     0,   159,   160,     0,     0,
     161,   670,   671,   162,   163,     0,   164,   672,   673,   166,
       0,   167,   168,   169,   170,   674,   172,     0,   675,   174,
       0,   175,   176,   177,   178,   179,   180,   181,   182,   183,
       0,   184,   185,     0,   186,   187,   188,   676,   190,     0,
     677,   678,   191,     0,     0,   192,   679,   193,   680,     0,
     194,   681,   682,     0,   195,   196,   197,   683,   684,   685,
       0,     0,     0,     0,   686,   200,   687,     0,     0,   688,
     201,   202,     0,   203,     0,     0,     0,   204,     0,   205,
     206,   207,   208,   209,     0,     0,     0,   210,     0,     0,
     211,   212,   213,     0,     0,     0,   214,     0,   215,   216,
       0,   217,   218,   219,     0,     0,   220,   221,     0,   222,
     223,   224,   225,   226,   227,   689,     0,   228,   229,   230,
     231,   232,   690,   691,   233,   234,     0,   235,   236,   237,
     692,     0,   238,     0,     0,     0,   693,   240,  2242,   241,
       0,   242,     0,   243,   694,   245,   695,     0,   247,     0,
     248,     0,   696,     0,   249,   250,     0,   251,   697,     0,
     252,   253,     0,     0,     0,   698,   255,   256,   257,   699,
       0,   258,   259,   260,     0,     0,   261,     0,     0,     0,
     700,   262,   263,   701,     0,     0,   264,     0,     0,     0,
     265,   266,     0,   267,   268,     0,     0,     0,   269,     0,
       0,   270,   271,     0,     0,   272,     0,   702,   273,   274,
       0,     0,     0,     0,     0,   703,   276,     0,   277,     0,
     278,     0,   279,   280,     0,     0,   704,     0,     0,     0,
       0,   281,     0,   282,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
       0,   299,   300,   301,   705,   302,   303,   304,   305,   706,
     306,   307,     0,     0,     0,     0,   308,   309,   310,   311,
     707,   313,     0,     0,   708,   315,   709,   316,     0,   317,
     710,   711,   712,   713,   714,   322,   323,   324,   325,   326,
       0,   715,   327,   328,     0,     0,   329,   330,   331,   332,
     716,   717,   718,   333,   334,     0,   719,   720,   335,     0,
     336,   337,   721,     0,   339,   340,   341,     0,   342,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   343,   344,
     345,   722,   346,   347,     0,   348,   349,   723,   351,   352,
     353,   354,   724,   725,   357,   726,     0,   358,   359,   360,
       0,   361,     0,   362,   363,   364,   365,   366,     0,   727,
     368,   369,     0,     0,   370,     0,     0,     0,   371,   372,
     373,   374,   375,     0,     0,   376,   377,   378,   379,   380,
       0,   381,   382,     0,   383,   384,   385,   728,   729,   386,
       0,   387,     0,   388,   389,     0,   390,   391,   392,     0,
     730,     0,   731,   394,   395,   396,   397,   398,   732,   733,
     401,   402,   403,   404,     0,   734,   406,     0,     0,     0,
     407,   408,   409,   410,     0,     0,     0,   411,     0,     0,
       0,   412,     0,   413,   414,   415,   416,     0,   417,   418,
     419,   420,   421,     0,     0,     0,     0,     0,   422,   423,
     424,     0,   425,   426,     0,   427,     0,     0,   428,     0,
       0,   429,   430,   431,   432,   433,   434,   735,   736,   435,
     436,     0,   437,   438,   737,   440,   441,   442,   738,   739,
     443,   444,   445,   446,   740,   447,   448,     0,     0,   449,
     450,   451,   452,     0,   741,   453,   454,     0,   742,   743,
     744,   745,     0,     0,     0,     0,     0,   459,   460,     0,
     746,   747,   748,   462,   463,   464,   749,   465,   466,   750,
     467,   468,     0,   469,   470,     0,     0,   471,     0,     0,
     472,     0,   473,     0,   751,   475,     0,     0,   752,   753,
     754,   755,   476,     0,     0,   477,   756,     0,   757,   478,
     479,   480,   758,   759,     0,     0,     0,     0,     0,     0,
     483,   484,     0,   485,   486,   487,     0,     0,   760,     0,
       0,     0,   761,   762,     0,     0,     0,     0,   763,   764,
       0,     0,   765,   766,     0,     0,   767,   768,   137,     0,
     662,   139,   140,   141,   142,     0,     0,   143,     0,     0,
       0,   144,     0,     0,   663,     0,   146,   147,   148,   149,
     664,   151,     0,   152,     0,     0,   665,   153,   666,   667,
     668,   154,   669,     0,   155,   156,   157,     0,   158,     0,
     159,   160,     0,     0,   161,   670,   671,   162,   163,     0,
     164,   672,   673,   166,     0,   167,   168,   169,   170,   674,
     172,     0,   675,   174,     0,   175,   176,   177,   178,   179,
     180,   181,   182,   183,     0,   184,   185,     0,   186,   187,
     188,   676,   190,     0,   677,   678,   191,     0,     0,   192,
     679,   193,   680,     0,   194,   681,   682,     0,   195,   196,
     197,   683,   684,   685,     0,     0,     0,     0,   686,   200,
     687,     0,     0,   688,   201,   202,     0,   203,     0,     0,
       0,   204,     0,   205,   206,   207,   208,   209,     0,     0,
       0,   210,     0,     0,   211,   212,   213,     0,     0,     0,
     214,     0,   215,   216,     0,   217,   218,   219,     0,     0,
     220,   221,     0,   222,   223,   224,   225,   226,   227,   689,
       0,   228,   229,   230,   231,   232,   690,   691,   233,   234,
       0,   235,   236,   237,   692,     0,   238,     0,     0,     0,
     693,   240,     0,   241,     0,   242,     0,   243,   694,   245,
     695,     0,   247,     0,   248,     0,   696,     0,   249,   250,
       0,   251,   697,     0,   252,   253,     0,     0,     0,   698,
     255,   256,   257,   699,     0,   258,   259,   260,     0,     0,
     261,     0,     0,     0,   700,   262,   263,   701,     0,     0,
     264,     0,     0,     0,   265,   266,     0,   267,   268,     0,
       0,     0,   269,     0,     0,   270,   271,     0,     0,   272,
       0,   702,   273,   274,     0,     0,     0,     0,     0,   703,
     276,     0,   277,     0,   278,     0,   279,   280,     0,     0,
     704,     0,     0,     0,     0,   281,     0,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,     0,   299,   300,   301,   705,   302,
     303,   304,   305,   706,   306,   307,     0,     0,     0,     0,
     308,   309,   310,   311,   707,   313,     0,     0,   708,   315,
     709,   316,     0,   317,   710,   711,   712,   713,   714,   322,
     323,   324,   325,   326,     0,   715,   327,   328,     0,     0,
     329,   330,   331,   332,   716,   717,   718,   333,   334,     0,
     719,   720,   335,     0,   336,   337,   721,     0,   339,   340,
     341,     0,   342,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   343,   344,   345,   722,   346,   347,     0,   348,
     349,   723,   351,   352,   353,   354,   724,   725,   357,   726,
       0,   358,   359,   360,     0,   361,     0,   362,   363,   364,
     365,   366,     0,   727,   368,   369,     0,     0,   370,     0,
       0,     0,   371,   372,   373,   374,   375,     0,     0,   376,
     377,   378,   379,   380,     0,   381,   382,     0,   383,   384,
     385,   728,   729,   386,     0,   387,     0,   388,   389,     0,
     390,   391,   392,     0,   730,     0,   731,   394,   395,   396,
     397,   398,   732,   733,   401,   402,   403,   404,     0,   734,
     406,     0,     0,     0,   407,   408,   409,   410,     0,     0,
       0,   411,     0,     0,     0,   412,     0,   413,   414,   415,
     416,     0,   417,   418,   419,   420,   421,     0,     0,     0,
       0,     0,   422,   423,   424,     0,   425,   426,     0,   427,
       0,     0,   428,     0,     0,   429,   430,   431,   432,   433,
     434,   735,   736,   435,   436,     0,   437,   438,   737,   440,
     441,   442,   738,   739,   443,   444,   445,   446,   740,   447,
     448,     0,     0,   449,   450,   451,   452,     0,   741,   453,
     454,     0,   742,   743,   744,   745,     0,     0,     0,     0,
       0,   459,   460,     0,   746,   747,   748,   462,   463,   464,
     749,   465,   466,   750,   467,   468,     0,   469,   470,     0,
       0,   471,     0,     0,   472,     0,   473,     0,   751,   475,
       0,     0,   752,   753,   754,   755,   476,     0,     0,   477,
     756,     0,   757,   478,   479,   480,   758,   759,     0,     0,
       0,     0,     0,     0,   483,   484,     0,   485,   486,   487,
       0,     0,   760,     0,     0,     0,   761,   762,     0,     0,
       0,     0,   763,   764,     0,     0,   765,   766,     0,     0,
     767,   768,   137,     0,   662,   139,   140,   141,   142,     0,
       0,   143,     0,     0,     0,   144,     0,     0,   663,     0,
     146,   147,   148,   149,   664,   151,     0,   152,     0,     0,
     665,   153,   666,   667,   668,   154,   669,     0,   155,   156,
     157,     0,   158,     0,   159,   160,     0,     0,   161,   670,
     671,   162,   163,     0,   164,   672,   673,   166,     0,   167,
     168,   169,   170,   674,   172,     0,   675,   174,     0,   175,
     176,   177,   178,   179,   180,   181,   182,   183,     0,   184,
     185,     0,   186,   187,   188,   676,   190,     0,   677,   678,
     191,     0,     0,   192,   679,   193,   680,     0,   194,   681,
     682,     0,   195,   196,   197,   683,   684,   685,     0,     0,
       0,     0,   686,   200,   687,     0,     0,   688,   201,   202,
       0,   203,     0,     0,     0,   204,     0,   205,   206,   207,
     208,   209,     0,     0,     0,   210,     0,     0,   211,   212,
     213,     0,     0,     0,   214,     0,   215,   216,     0,   217,
     218,   219,     0,     0,   220,   221,     0,   222,   223,   224,
     225,   226,   227,   689,     0,   228,   229,   230,   231,   232,
     690,   691,   233,   234,     0,   235,   236,   237,   692,     0,
     238,     0,     0,     0,   693,   240,     0,   241,     0,   242,
       0,   243,   694,   245,   695,     0,   247,     0,   248,     0,
     696,     0,   249,   250,     0,   251,   697,     0,   252,   253,
       0,     0,     0,   698,   255,   256,   257,   699,     0,   258,
     259,   260,     0,     0,   261,     0,     0,     0,   700,   262,
     263,   701,     0,     0,   264,     0,     0,     0,   265,   266,
       0,   267,   268,     0,     0,     0,   269,     0,     0,   270,
     271,     0,     0,   272,     0,   702,   273,   274,     0,     0,
       0,     0,     0,   703,   276,     0,   277,     0,   278,     0,
     279,   280,     0,     0,   704,     0,     0,     0,     0,   281,
       0,   282,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,     0,   299,
     300,   301,   705,   302,   303,   304,   305,   706,   306,   307,
       0,     0,     0,     0,   308,   309,   310,   311,   707,   313,
       0,     0,   708,   315,   709,   316,     0,   317,   710,   711,
     712,   713,   714,   322,   323,   324,   325,   326,     0,   715,
     327,   328,     0,     0,   329,   330,   331,   332,   716,   717,
     718,   333,   334,     0,   719,   720,   335,     0,   336,   337,
     721,     0,   339,   340,   341,     0,   342,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   343,   344,   345,   722,
     346,   347,     0,   348,   349,   723,   351,   352,   353,   354,
     724,   725,   357,   726,     0,   358,   359,   360,     0,   361,
       0,   362,   363,   364,   365,   366,     0,   727,   368,   369,
       0,     0,   370,     0,     0,     0,   371,   372,   373,   374,
     375,     0,     0,   376,   377,   378,   379,   380,     0,   381,
     382,     0,   383,   384,   385,   728,   729,   386,     0,   387,
       0,   388,   389,     0,   390,   391,   392,     0,   730,     0,
     731,   394,   395,   396,   397,   398,   732,   733,   401,   402,
     403,   404,     0,   734,   406,     0,     0,     0,   407,   408,
     409,   410,     0,     0,     0,   411,     0,     0,     0,   412,
       0,   413,   414,   415,   416,     0,   417,   418,   419,   420,
     421,     0,     0,     0,     0,     0,   422,   423,   424,     0,
     425,   426,     0,   427,     0,     0,   428,     0,     0,   429,
     430,   431,   432,   433,   434,   735,   736,   435,   436,     0,
     437,   438,   737,   440,   441,   442,   738,   739,   443,   444,
     445,   446,   740,   447,   448,     0,     0,   449,   450,   451,
     452,     0,   741,   453,   454,     0,   742,   743,   744,   745,
       0,     0,     0,     0,     0,   459,   460,     0,   746,   747,
     748,   462,   463,   464,   749,   465,   466,   750,   467,   468,
       0,   469,   470,     0,     0,   471,     0,     0,   472,     0,
     473,     0,   751,   475,     0,     0,   752,   753,   754,   755,
     476,     0,     0,   477,   756,     0,   757,   478,   479,   480,
     758,   759,     0,     0,     0,     0,     0,     0,   483,   484,
       0,   485,   486,   487,     0,     0,   760,     0,     0,     0,
     761,   762,     0,     0,     0,     0,   763,  1113,     0,     0,
     765,   766,     0,     0,   767,   768,   137,     0,   662,   139,
     140,   141,   142,  1721,     0,   143,     0,     0,     0,  1722,
       0,     0,   663,     0,   146,   147,   148,   149,   664,   151,
       0,   152,     0,     0,   665,   153,   666,   667,   668,   154,
     669,     0,   155,   156,   157,     0,   158,     0,   159,   160,
       0,     0,   161,   670,   671,   162,   163,     0,   164,   672,
     673,   166,     0,   167,   168,   169,   170,   674,   172,     0,
     675,   174,     0,   175,   176,   177,   178,   179,   180,   181,
     182,   183,     0,   184,   185,     0,   186,   187,   188,   676,
     190,     0,   677,   678,   191,     0,     0,   192,   679,   193,
     680,     0,   194,   681,   682,     0,   195,   196,   197,   683,
     684,   685,     0,     0,     0,     0,   686,   200,   687,     0,
       0,   688,   201,   202,     0,   203,     0,     0,     0,   204,
       0,   205,   206,   207,   208,   209,     0,     0,     0,   210,
       0,     0,   211,   212,   213,     0,     0,     0,   214,     0,
     215,   216,     0,   217,   218,   219,     0,     0,   220,   221,
       0,   222,   223,   224,   225,   226,   227,   689,     0,   228,
     229,   230,   231,   232,   690,   691,   233,   234,     0,   235,
     236,   237,   692,     0,   238,     0,     0,     0,   693,   240,
       0,   241,     0,   242,     0,   243,   694,   245,   695,     0,
     247,     0,   248,     0,   696,     0,   249,   250,     0,   251,
     697,     0,   252,   253,     0,     0,     0,   698,   255,   256,
     257,   699,     0,   258,   259,   260,     0,     0,   261,     0,
       0,     0,   700,   262,   263,   701,     0,     0,   264,     0,
       0,     0,   265,   266,     0,   267,   268,     0,     0,     0,
     269,     0,     0,   270,   271,     0,     0,   272,     0,   702,
     273,   274,     0,     0,     0,     0,     0,   703,   276,     0,
     277,     0,   278,     0,   279,   280,     0,     0,   704,     0,
       0,     0,     0,   281,     0,   282,   283,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,     0,   299,   300,   301,   705,   302,   303,   304,
     305,   706,   306,   307,     0,     0,     0,     0,   308,   309,
     310,   311,   707,   313,     0,     0,   708,   315,   709,   316,
       0,   317,   710,   711,   712,   713,   714,   322,   323,   324,
     325,   326,     0,   715,   327,   328,     0,     0,   329,   330,
     331,   332,   716,     0,   718,   333,   334,     0,   719,   720,
     335,     0,   336,   337,   721,     0,   339,   340,   341,     0,
     342,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     343,   344,   345,   722,   346,   347,     0,   348,   349,   723,
     351,   352,   353,   354,   724,   725,   357,   726,     0,   358,
     359,   360,     0,   361,     0,   362,   363,   364,   365,   366,
       0,   727,   368,   369,     0,     0,   370,     0,     0,     0,
     371,   372,   373,   374,   375,     0,     0,   376,   377,   378,
     379,   380,     0,   381,   382,     0,   383,   384,   385,   728,
     729,   386,     0,   387,     0,   388,   389,     0,   390,   391,
     392,     0,   730,     0,   731,   394,   395,   396,   397,   398,
     732,   733,   401,   402,   403,   404,     0,   734,   406,     0,
       0,     0,   407,   408,   409,   410,     0,     0,     0,   411,
       0,     0,     0,   412,     0,   413,   414,   415,   416,     0,
     417,   418,   419,   420,   421,     0,     0,     0,     0,     0,
     422,   423,   424,     0,   425,   426,     0,   427,     0,     0,
     428,     0,     0,   429,   430,   431,   432,   433,   434,   735,
     736,   435,   436,     0,   437,   438,   737,   440,   441,   442,
     738,   739,   443,   444,   445,   446,   740,   447,   448,     0,
       0,   449,   450,   451,   452,     0,   741,   453,   454,     0,
     742,   743,   744,   745,     0,     0,     0,     0,     0,   459,
     460,     0,   746,   747,   748,   462,   463,   464,   749,   465,
     466,   750,   467,   468,     0,   469,   470,     0,     0,   471,
       0,     0,   472,     0,   473,     0,   751,   475,     0,     0,
     752,   753,   754,   755,   476,     0,     0,   477,   756,     0,
     757,   478,   479,   480,   758,   759,     0,     0,     0,     0,
       0,     0,   483,   484,     0,   485,   486,   487,     0,     0,
     760,     0,     0,     0,   761,   762,     0,     0,     0,     0,
     763,   764,     0,     0,   765,   766,     0,     0,   767,   768,
     137,     0,   662,   139,   140,   141,   142,     0,     0,   143,
       0,     0,     0,   144,     0,     0,   663,     0,   146,   147,
     148,   149,   664,   151,     0,   152,     0,     0,   665,   153,
     666,   667,   668,   154,   669,     0,   155,   156,   157,     0,
     158,     0,   159,   160,     0,     0,   161,   670,   671,   162,
     163,     0,   164,   672,   673,   166,     0,   167,   168,   169,
     170,   674,   172,     0,   675,   174,     0,   175,   176,   177,
     178,   179,   180,   181,   182,   183,     0,   184,   185,     0,
     186,   187,   188,   676,   190,     0,   677,   678,   191,     0,
       0,   192,   679,   193,   680,     0,   194,   681,   682,     0,
     195,   196,   197,   683,   684,   685,     0,     0,     0,     0,
     686,   200,   687,     0,     0,   688,   201,   202,     0,   203,
       0,     0,     0,   204,     0,   205,   206,   207,   208,   209,
       0,     0,     0,   210,     0,     0,   211,   212,   213,     0,
       0,     0,   214,     0,   215,   216,     0,   217,   218,   219,
       0,     0,   220,   221,     0,   222,   223,   224,   225,   226,
     227,   689,     0,   228,   229,   230,   231,   232,   690,   691,
     233,   234,     0,   235,   236,   237,   692,     0,   238,     0,
       0,     0,   693,   240,     0,   241,     0,   242,     0,   243,
     694,   245,   695,     0,   247,     0,   248,     0,   696,     0,
     249,   250,     0,   251,   697,     0,   252,   253,     0,     0,
       0,   698,   255,   256,   257,   699,     0,   258,   259,   260,
       0,     0,   261,     0,     0,     0,   700,   262,   263,  2689,
       0,     0,   264,     0,     0,     0,   265,   266,     0,   267,
     268,     0,     0,     0,   269,     0,     0,   270,   271,     0,
       0,   272,     0,   702,   273,   274,     0,     0,     0,     0,
       0,   703,   276,     0,   277,     0,   278,     0,   279,   280,
       0,     0,   704,     0,     0,     0,     0,   281,     0,   282,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,     0,   299,   300,   301,
     705,   302,   303,   304,   305,   706,   306,   307,     0,     0,
       0,     0,   308,   309,   310,   311,   707,   313,     0,     0,
     708,   315,   709,   316,     0,   317,   710,   711,   712,   713,
     714,   322,   323,   324,   325,   326,     0,   715,   327,   328,
       0,     0,   329,   330,   331,   332,   716,   717,   718,   333,
     334,     0,   719,   720,   335,     0,   336,   337,   721,     0,
     339,   340,   341,     0,   342,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   343,   344,   345,   722,   346,   347,
       0,   348,   349,   723,   351,   352,   353,   354,   724,   725,
     357,   726,     0,   358,   359,   360,     0,   361,     0,   362,
     363,   364,   365,   366,     0,   727,   368,   369,     0,     0,
     370,     0,     0,     0,   371,   372,   373,   374,   375,     0,
       0,   376,   377,   378,   379,   380,     0,   381,   382,     0,
     383,   384,   385,   728,   729,   386,     0,   387,     0,   388,
     389,     0,   390,   391,   392,     0,   730,     0,   731,   394,
     395,   396,   397,   398,   732,   733,   401,   402,   403,   404,
       0,   734,   406,     0,     0,     0,   407,   408,   409,   410,
       0,     0,     0,   411,     0,     0,     0,   412,     0,   413,
     414,   415,   416,     0,   417,   418,   419,   420,   421,     0,
       0,     0,     0,     0,   422,   423,   424,     0,   425,   426,
       0,   427,     0,     0,   428,     0,     0,   429,   430,   431,
     432,   433,   434,   735,   736,   435,   436,     0,   437,   438,
     737,   440,   441,   442,   738,   739,   443,   444,   445,   446,
     740,   447,   448,     0,     0,   449,   450,   451,   452,     0,
     741,   453,   454,     0,   742,   743,   744,   745,     0,     0,
       0,     0,     0,   459,   460,     0,   746,   747,   748,   462,
     463,   464,   749,   465,   466,   750,   467,   468,     0,   469,
     470,     0,     0,   471,     0,     0,   472,     0,   473,     0,
     751,   475,     0,     0,   752,   753,   754,   755,   476,     0,
       0,   477,   756,     0,   757,   478,   479,   480,   758,   759,
       0,     0,     0,     0,     0,     0,   483,   484,     0,   485,
     486,   487,     0,     0,   760,     0,     0,     0,   761,   762,
       0,     0,     0,     0,   763,   764,     0,     0,   765,   766,
       0,     0,   767,   768,   137,     0,   662,   139,   140,   141,
     142,     0,     0,   143,     0,     0,     0,   144,     0,     0,
     663,     0,   146,   147,   148,   149,   664,   151,     0,   152,
       0,     0,   665,   153,   666,   667,   668,   154,   669,     0,
     155,   156,   157,     0,   158,     0,   159,   160,     0,     0,
     161,   670,   671,   162,   163,     0,   164,   672,   673,   166,
       0,   167,   168,   169,   170,   674,   172,     0,   675,   174,
       0,   175,   176,   177,   178,   179,   180,   181,   182,   183,
       0,   184,   185,     0,   186,   187,   188,   676,   190,     0,
     677,   678,   191,     0,     0,   192,   679,   193,   680,     0,
     194,   681,   682,     0,   195,   196,   197,   683,   684,   685,
       0,     0,     0,     0,   686,   200,   687,     0,     0,   688,
     201,   202,     0,   203,     0,     0,     0,   204,     0,   205,
     206,   207,   208,   209,     0,     0,     0,   210,     0,     0,
     211,   212,   213,     0,     0,     0,   214,     0,   215,   216,
       0,   217,   218,   219,     0,     0,   220,   221,     0,   222,
     223,   224,   225,   226,   227,   689,     0,   228,   229,   230,
     231,   232,   690,   691,   233,   234,     0,   235,   236,   237,
     692,     0,   238,     0,     0,     0,   693,   240,     0,   241,
       0,   242,     0,   243,   694,   245,   695,     0,   247,     0,
     248,     0,   696,     0,   249,   250,     0,   251,   697,     0,
     252,   253,     0,     0,     0,   698,   255,   256,   257,   699,
       0,   258,   259,   260,     0,     0,   261,     0,     0,     0,
     700,   262,   263,  2734,     0,     0,   264,     0,     0,     0,
     265,   266,     0,   267,   268,     0,     0,     0,   269,     0,
       0,   270,   271,     0,     0,   272,     0,   702,   273,   274,
       0,     0,     0,     0,     0,   703,   276,     0,   277,     0,
     278,     0,   279,   280,     0,     0,   704,     0,     0,     0,
       0,   281,     0,   282,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
       0,   299,   300,   301,   705,   302,   303,   304,   305,   706,
     306,   307,     0,     0,     0,     0,   308,   309,   310,   311,
     707,   313,     0,     0,   708,   315,   709,   316,     0,   317,
     710,   711,   712,   713,   714,   322,   323,   324,   325,   326,
       0,   715,   327,   328,     0,     0,   329,   330,   331,   332,
     716,   717,   718,   333,   334,     0,   719,   720,   335,     0,
     336,   337,   721,     0,   339,   340,   341,     0,   342,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   343,   344,
     345,   722,   346,   347,     0,   348,   349,   723,   351,   352,
     353,   354,   724,   725,   357,   726,     0,   358,   359,   360,
       0,   361,     0,   362,   363,   364,   365,   366,     0,   727,
     368,   369,     0,     0,   370,     0,     0,     0,   371,   372,
     373,   374,   375,     0,     0,   376,   377,   378,   379,   380,
       0,   381,   382,     0,   383,   384,   385,   728,   729,   386,
       0,   387,     0,   388,   389,     0,   390,   391,   392,     0,
     730,     0,   731,   394,   395,   396,   397,   398,   732,   733,
     401,   402,   403,   404,     0,   734,   406,     0,     0,     0,
     407,   408,   409,   410,     0,     0,     0,   411,     0,     0,
       0,   412,     0,   413,   414,   415,   416,     0,   417,   418,
     419,   420,   421,     0,     0,     0,     0,     0,   422,   423,
     424,     0,   425,   426,     0,   427,     0,     0,   428,     0,
       0,   429,   430,   431,   432,   433,   434,   735,   736,   435,
     436,     0,   437,   438,   737,   440,   441,   442,   738,   739,
     443,   444,   445,   446,   740,   447,   448,     0,     0,   449,
     450,   451,   452,     0,   741,   453,   454,     0,   742,   743,
     744,   745,     0,     0,     0,     0,     0,   459,   460,     0,
     746,   747,   748,   462,   463,   464,   749,   465,   466,   750,
     467,   468,     0,   469,   470,     0,     0,   471,     0,     0,
     472,     0,   473,     0,   751,   475,     0,     0,   752,   753,
     754,   755,   476,     0,     0,   477,   756,     0,   757,   478,
     479,   480,   758,   759,     0,     0,     0,     0,     0,     0,
     483,   484,     0,   485,   486,   487,     0,     0,   760,     0,
       0,     0,   761,   762,     0,     0,     0,     0,   763,   764,
       0,     0,   765,   766,     0,     0,   767,   768,   137,     0,
     662,   139,   140,   141,   142,     0,     0,   143,     0,     0,
       0,   144,     0,     0,   663,     0,   146,   147,   148,   149,
     664,   151,     0,   152,     0,     0,   665,   153,   666,   667,
     668,   154,   669,     0,   155,   156,   157,     0,   158,     0,
     159,   160,     0,     0,   161,   670,   671,   162,   163,     0,
     164,   672,   673,   166,     0,   167,   168,   169,   170,   674,
     172,     0,   675,   174,     0,   175,   176,   177,   178,   179,
     180,   181,   182,   183,     0,   184,   185,     0,   186,   187,
     188,   676,   190,     0,   677,   678,   191,     0,     0,   192,
     679,   193,   680,     0,   194,   681,   682,     0,   195,   196,
     197,   683,   684,   685,     0,     0,     0,     0,   686,   200,
     687,     0,     0,  3513,   201,   202,     0,   203,     0,     0,
       0,   204,     0,   205,   206,   207,   208,   209,     0,     0,
       0,   210,     0,     0,   211,   212,   213,     0,     0,     0,
     214,     0,   215,   216,     0,   217,   218,   219,     0,     0,
     220,   221,     0,   222,   223,   224,   225,   226,   227,   689,
       0,   228,   229,   230,   231,   232,   690,   691,   233,   234,
       0,   235,   236,   237,   692,     0,   238,     0,     0,     0,
     693,   240,     0,   241,     0,   242,     0,   243,   694,   245,
     695,     0,   247,     0,   248,     0,   696,     0,   249,   250,
       0,   251,   697,     0,   252,   253,     0,     0,     0,   698,
     255,   256,   257,   699,     0,   258,   259,   260,     0,     0,
     261,     0,     0,     0,   700,   262,   263,   701,     0,     0,
     264,     0,     0,     0,   265,   266,     0,   267,   268,     0,
       0,     0,   269,     0,     0,   270,   271,     0,     0,   272,
       0,   702,   273,   274,     0,     0,     0,     0,     0,   703,
     276,     0,   277,     0,   278,     0,   279,   280,     0,     0,
     704,     0,     0,     0,     0,   281,     0,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,     0,   299,   300,   301,   705,   302,
     303,   304,   305,   706,   306,   307,     0,     0,     0,     0,
     308,   309,   310,   311,   707,   313,     0,     0,   708,   315,
     709,   316,     0,   317,   710,   711,   712,   713,   714,   322,
     323,   324,   325,   326,     0,   715,   327,   328,     0,     0,
     329,   330,   331,   332,   716,   717,   718,   333,   334,     0,
     719,   720,   335,     0,   336,   337,   721,     0,   339,   340,
     341,     0,   342,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   343,   344,   345,   722,   346,   347,     0,   348,
     349,   723,   351,   352,   353,   354,   724,   725,   357,   726,
       0,   358,   359,   360,     0,   361,     0,   362,   363,   364,
     365,   366,     0,   727,   368,   369,     0,     0,   370,     0,
       0,     0,   371,   372,   373,   374,   375,     0,     0,   376,
     377,   378,   379,   380,     0,   381,   382,     0,   383,   384,
     385,   728,   729,   386,     0,   387,     0,   388,   389,     0,
     390,   391,   392,     0,   730,     0,   731,   394,   395,   396,
     397,   398,   732,   733,   401,   402,   403,   404,     0,   734,
     406,     0,     0,     0,   407,   408,   409,   410,     0,     0,
       0,   411,     0,     0,     0,   412,     0,   413,   414,   415,
     416,     0,   417,   418,   419,   420,   421,     0,     0,     0,
       0,     0,   422,   423,   424,     0,   425,   426,     0,   427,
       0,     0,   428,     0,     0,   429,   430,   431,   432,   433,
     434,   735,   736,   435,   436,     0,   437,   438,   737,   440,
     441,   442,   738,   739,   443,   444,   445,   446,   740,   447,
     448,     0,     0,   449,   450,   451,   452,     0,   741,   453,
     454,     0,   742,   743,   744,   745,     0,     0,     0,     0,
       0,   459,   460,     0,   746,   747,   748,   462,   463,   464,
     749,   465,   466,   750,   467,   468,     0,   469,   470,     0,
       0,   471,     0,     0,   472,     0,   473,     0,   751,   475,
       0,     0,   752,   753,   754,   755,   476,     0,     0,   477,
     756,     0,   757,   478,   479,   480,   758,   759,     0,     0,
       0,     0,     0,     0,   483,   484,     0,   485,   486,   487,
       0,     0,   760,     0,     0,     0,   761,   762,     0,     0,
       0,     0,   763,   764,     0,     0,   765,   766,     0,     0,
     767,   768,   137,     0,   662,   139,   140,   141,   142,     0,
       0,   143,     0,     0,     0,   144,     0,     0,   663,     0,
     146,   147,   148,   149,   664,   151,     0,   152,     0,     0,
     665,   153,   666,   667,   668,   154,   669,     0,   155,   156,
     157,     0,   158,     0,   159,   160,     0,     0,   161,   670,
     671,   162,   163,     0,   164,   672,   673,   166,     0,   167,
     168,   169,   170,   674,   172,     0,   675,   174,     0,   175,
     176,   177,   178,   179,   180,   181,   182,   183,     0,   184,
     185,     0,   186,   187,   188,   676,   190,     0,   677,   678,
     191,     0,     0,   192,   679,   193,   680,     0,   194,   681,
     682,     0,   195,   196,   197,   683,   684,   685,     0,     0,
       0,     0,   686,   200,   687,     0,     0,   688,   201,   202,
       0,   203,     0,     0,     0,   204,     0,   205,   206,   207,
     208,   209,     0,     0,     0,   210,     0,     0,   211,   212,
     213,     0,     0,     0,   214,     0,   215,   216,     0,   217,
     218,   219,     0,     0,   220,   221,     0,   222,   223,   224,
     225,   226,   227,   689,     0,   228,   229,   230,   231,   232,
     690,   691,   233,   234,     0,   235,   236,   237,   692,     0,
     238,     0,     0,     0,   693,   240,     0,   241,     0,   242,
       0,   243,   694,   245,   695,     0,   247,     0,   248,     0,
     696,     0,   249,   250,     0,   251,   697,     0,   252,   253,
       0,     0,     0,   698,   255,   256,   257,   699,     0,   258,
     259,   260,     0,     0,   261,     0,     0,     0,   700,   262,
     263,   701,     0,     0,   264,     0,     0,     0,   265,   266,
       0,   267,   268,     0,     0,     0,   269,     0,     0,   270,
     271,     0,     0,   272,     0,   702,   273,   274,     0,     0,
       0,     0,     0,   703,   276,     0,   277,     0,   278,     0,
     279,   280,     0,     0,   704,     0,     0,     0,     0,   281,
       0,   282,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,     0,   299,
     300,   301,   705,   302,   303,   304,   305,   706,   306,   307,
    4370,     0,     0,     0,   308,   309,   310,   311,   707,   313,
       0,     0,   708,   315,   709,   316,     0,   317,   710,   711,
     712,   713,   714,   322,   323,   324,   325,   326,     0,   715,
     327,   328,     0,     0,   329,   330,   331,   332,   716,     0,
     718,   333,   334,     0,   719,   720,   335,     0,   336,   337,
     721,     0,   339,   340,   341,     0,   342,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   343,   344,   345,   722,
     346,   347,     0,   348,   349,   723,   351,   352,   353,   354,
     724,   725,   357,   726,     0,   358,   359,   360,     0,   361,
       0,   362,   363,   364,   365,   366,     0,   727,   368,   369,
       0,     0,   370,     0,     0,     0,   371,   372,   373,   374,
     375,     0,     0,   376,   377,   378,   379,   380,     0,   381,
     382,     0,   383,   384,   385,   728,   729,   386,     0,   387,
       0,   388,   389,     0,   390,   391,   392,     0,   730,     0,
     731,   394,   395,   396,   397,   398,   732,   733,   401,   402,
     403,   404,     0,   734,   406,     0,     0,     0,   407,   408,
     409,   410,     0,     0,     0,   411,     0,     0,     0,   412,
       0,   413,   414,   415,   416,     0,   417,   418,   419,   420,
     421,     0,     0,     0,     0,     0,   422,   423,   424,     0,
     425,   426,     0,   427,     0,     0,   428,     0,     0,   429,
     430,   431,   432,   433,   434,   735,   736,   435,   436,     0,
     437,   438,   737,   440,   441,   442,   738,   739,   443,   444,
     445,   446,   740,   447,   448,     0,     0,   449,   450,   451,
     452,     0,   741,   453,   454,     0,   742,   743,   744,   745,
       0,     0,     0,     0,     0,   459,   460,     0,   746,   747,
     748,   462,   463,   464,   749,   465,   466,   750,   467,   468,
       0,   469,   470,     0,     0,   471,     0,     0,   472,     0,
     473,     0,   751,   475,     0,     0,   752,   753,   754,   755,
     476,     0,     0,   477,   756,     0,   757,   478,   479,   480,
     758,   759,     0,     0,     0,     0,     0,     0,   483,   484,
       0,   485,   486,   487,     0,     0,   760,     0,     0,     0,
     761,   762,     0,     0,     0,     0,   763,   764,     0,     0,
     765,   766,     0,     0,   767,   768,   137,     0,   662,   139,
     140,   141,   142,     0,     0,   143,     0,     0,     0,   144,
       0,     0,   663,     0,   146,   147,   148,   149,   664,   151,
       0,   152,     0,     0,   665,   153,   666,   667,   668,   154,
     669,     0,   155,   156,   157,     0,   158,     0,   159,   160,
       0,     0,   161,   670,   671,   162,   163,     0,   164,   672,
     673,   166,     0,   167,   168,   169,   170,   674,   172,     0,
     675,   174,     0,   175,   176,   177,   178,   179,   180,   181,
     182,   183,     0,   184,   185,     0,   186,   187,   188,   676,
     190,     0,   677,   678,   191,     0,     0,   192,   679,   193,
     680,     0,   194,   681,   682,     0,   195,   196,   197,   683,
     684,   685,     0,     0,     0,     0,   686,   200,   687,     0,
       0,   688,   201,   202,     0,   203,     0,     0,     0,   204,
       0,   205,   206,   207,   208,   209,     0,     0,     0,   210,
       0,     0,   211,   212,   213,     0,     0,     0,   214,     0,
     215,   216,     0,   217,   218,   219,     0,     0,   220,   221,
       0,   222,   223,   224,   225,   226,   227,   689,     0,   228,
     229,   230,   231,   232,   690,   691,   233,   234,     0,   235,
     236,   237,   692,     0,   238,     0,     0,     0,   693,   240,
       0,   241,     0,   242,     0,   243,   694,   245,   695,     0,
     247,     0,   248,     0,   696,     0,   249,   250,     0,   251,
     697,     0,   252,   253,     0,     0,     0,   698,   255,   256,
     257,   699,     0,   258,   259,   260,     0,     0,   261,     0,
       0,     0,   700,   262,   263,   701,     0,     0,   264,     0,
       0,     0,   265,   266,     0,   267,   268,     0,     0,     0,
     269,     0,     0,   270,   271,     0,     0,   272,     0,   702,
     273,   274,     0,     0,     0,     0,     0,   703,   276,     0,
     277,     0,   278,     0,   279,   280,     0,     0,   704,     0,
       0,     0,     0,   281,     0,   282,   283,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,     0,   299,   300,   301,   705,   302,   303,   304,
     305,   706,   306,   307,     0,     0,     0,     0,   308,   309,
     310,   311,   707,   313,     0,     0,   708,   315,   709,   316,
       0,   317,   710,   711,   712,   713,   714,   322,   323,   324,
     325,   326,     0,   715,   327,   328,     0,     0,   329,   330,
     331,   332,   716,     0,   718,   333,   334,     0,   719,   720,
     335,     0,   336,   337,   721,     0,   339,   340,   341,     0,
     342,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     343,   344,   345,   722,   346,   347,     0,   348,   349,   723,
     351,   352,   353,   354,   724,   725,   357,   726,     0,   358,
     359,   360,     0,   361,     0,   362,   363,   364,   365,   366,
       0,   727,   368,   369,     0,     0,   370,     0,     0,     0,
     371,   372,   373,   374,   375,     0,     0,   376,   377,   378,
     379,   380,     0,   381,   382,     0,   383,   384,   385,   728,
     729,   386,     0,   387,     0,   388,   389,     0,   390,   391,
     392,     0,   730,     0,   731,   394,   395,   396,   397,   398,
     732,   733,   401,   402,   403,   404,     0,   734,   406,     0,
       0,     0,   407,   408,   409,   410,     0,     0,     0,   411,
       0,     0,     0,   412,     0,   413,   414,   415,   416,     0,
     417,   418,   419,   420,   421,     0,     0,     0,     0,     0,
     422,   423,   424,     0,   425,   426,     0,   427,     0,     0,
     428,     0,     0,   429,   430,   431,   432,   433,   434,   735,
     736,   435,   436,     0,   437,   438,   737,   440,   441,   442,
     738,   739,   443,   444,   445,   446,   740,   447,   448,     0,
       0,   449,   450,   451,   452,     0,   741,   453,   454,     0,
     742,   743,   744,   745,     0,     0,     0,     0,     0,   459,
     460,     0,   746,   747,   748,   462,   463,   464,   749,   465,
     466,   750,   467,   468,     0,   469,   470,     0,     0,   471,
       0,     0,   472,     0,   473,     0,   751,   475,     0,     0,
     752,   753,   754,   755,   476,     0,     0,   477,   756,     0,
     757,   478,   479,   480,   758,   759,     0,     0,     0,     0,
       0,     0,   483,   484,     0,   485,   486,   487,     0,     0,
     760,     0,     0,     0,   761,   762,     0,     0,     0,     0,
     763,   764,     0,     0,   765,   766,     0,     0,   767,   768,
     137,     0,   662,   139,   140,   141,   142,     0,     0,   143,
       0,     0,     0,   144,     0,     0,   663,     0,   146,   147,
     148,   149,   664,   151,     0,   152,     0,     0,   665,   153,
     666,   667,   668,   154,   669,     0,   155,   156,   157,     0,
     158,     0,   159,   160,     0,     0,   161,   670,   671,   162,
     163,     0,   164,   672,   673,   166,     0,   167,   168,   169,
     170,   674,   172,     0,   675,   174,     0,   175,   176,   177,
     178,   179,   180,   181,   182,   183,     0,   184,   185,     0,
     186,   187,   188,   676,   190,     0,   677,   678,   191,     0,
       0,   192,   679,   193,   680,     0,   194,   681,   682,     0,
     195,   196,   197,   683,   684,   685,     0,     0,     0,     0,
     686,   200,   687,     0,     0,   688,   201,   202,     0,   203,
       0,     0,     0,   204,     0,   205,   206,   207,   208,   209,
       0,     0,     0,   210,     0,     0,   211,   212,   213,     0,
       0,     0,   214,     0,   215,   216,     0,   217,   218,   219,
       0,     0,   220,   221,     0,   222,   223,   224,   225,   226,
     227,   689,     0,   228,   229,   230,   231,   232,   690,   691,
     233,   234,     0,   235,   236,   237,   692,     0,   238,     0,
       0,     0,   693,   240,     0,   241,     0,   242,     0,   243,
     694,   245,   695,     0,   247,     0,   248,     0,   696,     0,
     249,   250,     0,   251,   697,     0,   252,   253,     0,     0,
       0,   698,   255,   256,   257,   699,     0,   258,   259,   260,
       0,     0,   261,     0,     0,     0,   700,   262,   263,  1736,
       0,     0,   264,     0,     0,     0,   265,   266,     0,   267,
     268,     0,     0,     0,   269,     0,     0,   270,   271,     0,
       0,   272,     0,   702,   273,   274,     0,     0,     0,     0,
       0,   703,   276,     0,   277,     0,   278,     0,   279,   280,
       0,     0,   704,     0,     0,     0,     0,   281,     0,   282,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,     0,   299,   300,   301,
     705,   302,   303,   304,   305,   706,   306,   307,     0,     0,
       0,     0,   308,   309,   310,   311,   707,   313,     0,     0,
     708,   315,   709,   316,     0,   317,   710,   711,   712,   713,
     714,   322,   323,   324,   325,   326,     0,   715,   327,   328,
       0,     0,   329,   330,   331,   332,   716,     0,   718,   333,
     334,     0,   719,   720,   335,     0,   336,   337,   721,     0,
     339,   340,   341,     0,   342,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   343,   344,   345,   722,   346,   347,
       0,   348,   349,   723,   351,   352,   353,   354,   724,   725,
     357,   726,     0,   358,   359,   360,     0,   361,     0,   362,
     363,   364,   365,   366,     0,   727,   368,   369,     0,     0,
     370,     0,     0,     0,   371,   372,   373,   374,   375,     0,
       0,   376,   377,   378,   379,   380,     0,   381,   382,     0,
     383,   384,   385,   728,   729,   386,     0,   387,     0,   388,
     389,     0,   390,   391,   392,     0,   730,     0,   731,   394,
     395,   396,   397,   398,   732,   733,   401,   402,   403,   404,
       0,   734,   406,     0,     0,     0,   407,   408,   409,   410,
       0,     0,     0,   411,     0,     0,     0,   412,     0,   413,
     414,   415,   416,     0,   417,   418,   419,   420,   421,     0,
       0,     0,     0,     0,   422,   423,   424,     0,   425,   426,
       0,   427,     0,     0,   428,     0,     0,   429,   430,   431,
     432,   433,   434,   735,   736,   435,   436,     0,   437,   438,
     737,   440,   441,   442,   738,   739,   443,   444,   445,   446,
     740,   447,   448,     0,     0,   449,   450,   451,   452,     0,
     741,   453,   454,     0,   742,   743,   744,   745,     0,     0,
       0,     0,     0,   459,   460,     0,   746,   747,   748,   462,
     463,   464,   749,   465,   466,   750,   467,   468,     0,   469,
     470,     0,     0,   471,     0,     0,   472,     0,   473,     0,
     751,   475,     0,     0,   752,   753,   754,   755,   476,     0,
       0,   477,   756,     0,   757,   478,   479,   480,   758,   759,
       0,     0,     0,     0,     0,     0,   483,   484,     0,   485,
     486,   487,     0,     0,   760,     0,     0,     0,   761,   762,
       0,     0,     0,     0,   763,   764,     0,     0,   765,   766,
       0,     0,   767,   768,   137,     0,   662,   139,   140,   141,
     142,     0,     0,   143,     0,     0,     0,   144,     0,     0,
     663,     0,   146,   147,   148,   149,   664,   151,     0,   152,
       0,     0,   665,   153,   666,   667,   668,   154,   669,     0,
     155,   156,   157,     0,   158,     0,   159,   160,     0,     0,
     161,   670,   671,   162,   163,     0,   164,   672,   673,   166,
       0,   167,   168,   169,   170,   674,   172,     0,   675,   174,
       0,   175,   176,   177,   178,   179,   180,   181,   182,   183,
       0,   184,   185,     0,   186,   187,   188,   676,   190,     0,
     677,   678,   191,     0,     0,   192,   679,   193,   680,     0,
     194,   681,   682,     0,   195,   196,   197,   683,   684,   685,
       0,     0,     0,     0,   686,   200,   687,     0,     0,   688,
     201,   202,     0,   203,     0,     0,     0,   204,     0,   205,
     206,   207,   208,   209,     0,     0,     0,   210,     0,     0,
     211,   212,   213,     0,     0,     0,   214,     0,   215,   216,
       0,   217,   218,   219,     0,     0,   220,   221,     0,   222,
     223,   224,   225,   226,   227,   689,     0,   228,   229,   230,
     231,   232,   690,   691,   233,   234,     0,   235,   236,   237,
     692,     0,   238,     0,     0,     0,   693,   240,     0,   241,
       0,   242,     0,   243,   694,   245,   695,     0,   247,     0,
     248,     0,   696,     0,   249,   250,     0,   251,   697,     0,
     252,   253,     0,     0,     0,   698,   255,   256,   257,   699,
       0,   258,   259,   260,     0,     0,   261,     0,     0,     0,
     700,   262,   263,  1738,     0,     0,   264,     0,     0,     0,
     265,   266,     0,   267,   268,     0,     0,     0,   269,     0,
       0,   270,   271,     0,     0,   272,     0,   702,   273,   274,
       0,     0,     0,     0,     0,   703,   276,     0,   277,     0,
     278,     0,   279,   280,     0,     0,   704,     0,     0,     0,
       0,   281,     0,   282,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
       0,   299,   300,   301,   705,   302,   303,   304,   305,   706,
     306,   307,     0,     0,     0,     0,   308,   309,   310,   311,
     707,   313,     0,     0,   708,   315,   709,   316,     0,   317,
     710,   711,   712,   713,   714,   322,   323,   324,   325,   326,
       0,   715,   327,   328,     0,     0,   329,   330,   331,   332,
     716,     0,   718,   333,   334,     0,   719,   720,   335,     0,
     336,   337,   721,     0,   339,   340,   341,     0,   342,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   343,   344,
     345,   722,   346,   347,     0,   348,   349,   723,   351,   352,
     353,   354,   724,   725,   357,   726,     0,   358,   359,   360,
       0,   361,     0,   362,   363,   364,   365,   366,     0,   727,
     368,   369,     0,     0,   370,     0,     0,     0,   371,   372,
     373,   374,   375,     0,     0,   376,   377,   378,   379,   380,
       0,   381,   382,     0,   383,   384,   385,   728,   729,   386,
       0,   387,     0,   388,   389,     0,   390,   391,   392,     0,
     730,     0,   731,   394,   395,   396,   397,   398,   732,   733,
     401,   402,   403,   404,     0,   734,   406,     0,     0,     0,
     407,   408,   409,   410,     0,     0,     0,   411,     0,     0,
       0,   412,     0,   413,   414,   415,   416,     0,   417,   418,
     419,   420,   421,     0,     0,     0,     0,     0,   422,   423,
     424,     0,   425,   426,     0,   427,     0,     0,   428,     0,
       0,   429,   430,   431,   432,   433,   434,   735,   736,   435,
     436,     0,   437,   438,   737,   440,   441,   442,   738,   739,
     443,   444,   445,   446,   740,   447,   448,     0,     0,   449,
     450,   451,   452,     0,   741,   453,   454,     0,   742,   743,
     744,   745,     0,     0,     0,     0,     0,   459,   460,     0,
     746,   747,   748,   462,   463,   464,   749,   465,   466,   750,
     467,   468,     0,   469,   470,     0,     0,   471,     0,     0,
     472,     0,   473,     0,   751,   475,     0,     0,   752,   753,
     754,   755,   476,     0,     0,   477,   756,     0,   757,   478,
     479,   480,   758,   759,     0,     0,     0,     0,     0,     0,
     483,   484,     0,   485,   486,   487,     0,     0,   760,     0,
       0,     0,   761,   762,     0,     0,     0,     0,   763,   764,
       0,     0,   765,   766,     0,     0,   767,   768,   137,     0,
     138,   139,   140,   141,   142,     0,     0,   143,     0,     0,
       0,   144,     0,     0,   145,     0,   146,   147,   148,   149,
     150,   151,     0,   152,     0,     0,     0,   153,   666,     0,
       0,   154,     0,     0,   155,   156,   157,     0,   158,     0,
     159,   160,     0,     0,   161,     0,     0,   162,   163,     0,
     164,   165,     0,   166,     0,   167,   168,   169,   170,   171,
     172,     0,   173,   174,     0,   175,   176,   177,   178,   179,
     180,   181,   182,   183,     0,   184,   185,     0,   186,   187,
     188,   189,   190,     0,     0,     0,   191,     0,     0,   192,
       0,   193,     0,     0,   194,     0,     0,     0,   195,   196,
     197,     0,     0,  1774,     0,     0,     0,     0,   199,   200,
     687,     0,     0,     0,   201,   202,     0,   203,     0,     0,
       0,   204,     0,   205,   206,   207,   208,   209,     0,     0,
       0,   210,     0,     0,   211,   212,   213,     0,     0,     0,
     214,     0,   215,   216,     0,   217,   218,   219,     0,     0,
     220,   221,     0,   222,   223,   224,   225,   226,   227,     0,
       0,   228,   229,   230,   231,   232,     0,   691,   233,   234,
       0,   235,   236,   237,   692,     0,   238,     0,     0,     0,
     239,   240,     0,   241,     0,   242,     0,   243,   244,   245,
     246,     0,   247,     0,   248,     0,     0,     0,   249,   250,
       0,   251,   697,     0,   252,   253,     0,     0,     0,   254,
     255,   256,   257,     0,     0,   258,   259,   260,     0,     0,
     261,     0,     0,     0,     0,   262,   263,     0,     0,     0,
     264,     0,     0,     0,   265,   266,     0,   267,   268,     0,
       0,     0,   269,     0,     0,   270,   271,     0,     0,   272,
       0,     0,   273,   274,     0,     0,     0,     0,     0,   275,
     276,     0,   277,     0,   278,     0,   279,   280,     0,     0,
     704,     0,     0,     0,     0,   281,     0,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,     0,   299,   300,   301,     0,   302,
     303,   304,   305,     0,   306,   307,     0,     0,     0,     0,
     308,   309,   310,   311,   312,   313,     0,     0,   314,   315,
       0,   316,     0,   317,     0,   318,   319,   320,   321,   322,
     323,   324,   325,   326,     0,   715,   327,   328,     0,     0,
     329,   330,   331,   332,     0,     0,     0,   333,   334,     0,
     719,   720,   335,     0,   336,   337,   338,     0,   339,   340,
     341,     0,   342,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   343,   344,   345,     0,   346,   347,     0,   348,
     349,   350,   351,   352,   353,   354,   355,   356,   357,     0,
       0,   358,   359,   360,     0,   361,     0,   362,   363,   364,
     365,   366,     0,   367,   368,   369,     0,     0,   370,     0,
       0,     0,   371,   372,   373,   374,   375,     0,     0,   376,
     377,   378,   379,   380,     0,   381,   382,     0,   383,   384,
     385,     0,     0,   386,     0,   387,     0,   388,   389,     0,
     390,   391,   392,     0,   393,     0,     0,   394,   395,   396,
     397,   398,   399,   400,   401,   402,   403,   404,     0,   405,
     406,     0,     0,     0,   407,   408,   409,   410,     0,     0,
       0,   411,     0,     0,     0,   412,     0,   413,   414,   415,
     416,     0,   417,   418,   419,   420,   421,     0,     0,     0,
       0,     0,   422,   423,   424,     0,   425,   426,     0,   427,
       0,     0,   428,     0,     0,   429,   430,   431,   432,   433,
     434,     0,     0,   435,   436,     0,   437,   438,   439,   440,
     441,   442,     0,     0,   443,   444,   445,   446,     0,   447,
     448,     0,     0,   449,   450,   451,   452,     0,   741,   453,
     454,     0,  1775,   456,   457,  1776,     0,     0,     0,     0,
       0,   459,   460,     0,     0,   747,   461,   462,   463,   464,
     749,   465,   466,   750,   467,   468,     0,   469,   470,     0,
       0,   471,     0,     0,   472,     0,   473,     0,   474,   475,
       0,     0,     0,     0,     0,     0,   476,     0,     0,   477,
       0,     0,     0,   478,   479,   480,   481,   482,     0,     0,
       0,     0,     0,     0,   483,   484,     0,   485,   486,   487,
       0,     0,   488,     0,     0,     0,   137,     0,   138,   139,
     140,   141,   142,     0,     0,   143,     0,     0,     0,   144,
     767,   768,   145,     0,   146,   147,   148,   149,   150,   151,
       0,   152,     0,     0,     0,   153,     0,     0,     0,   154,
       0,     0,   155,   156,   157,     0,   158,     0,   159,   160,
       0,     0,   161,     0,     0,   162,   163,     0,   164,   165,
       0,   166,     0,   167,   168,   169,   170,   171,   172,     0,
     173,   174,     0,   175,   176,   177,   178,   179,   180,   181,
     182,   183,     0,   184,   185,  2521,   186,   187,   188,   189,
     190,     0,     0,     0,   191,     0,     0,   192,     0,   193,
       0,     0,   194,     0,     0,     0,   195,   196,   197,     0,
       0,   198,     0,     0,     0,     0,   199,   200,     0,     0,
       0,     0,   201,   202,     0,   203,     0,     0,     0,   204,
       0,   205,   206,   207,   208,   209,     0,     0,     0,   210,
       0,     0,   211,   212,   213,     0,     0,     0,   214,     0,
     215,   216,     0,   217,   218,   219,     0,     0,   220,   221,
       0,   222,   223,   224,   225,   226,   227,     0,     0,   228,
     229,   230,   231,   232,     0,     0,   233,   234,     0,   235,
     236,   237,     0,     0,   238,     0,     0,     0,   239,   240,
       0,   241,   502,   242,     0,   243,   244,   245,   246,     0,
     247,     0,   248,     0,     0,     0,   249,   250,     0,   251,
       0,     0,   252,   253,     0,     0,     0,   254,   255,   256,
     257,     0,     0,   258,   259,   260,  2078,     0,   261,     0,
       0,     0,     0,   262,   263,     0,     0,     0,   264,     0,
       0,     0,   265,   266,     0,   267,   268,     0,     0,     0,
     269,  2079,     0,   270,   271,     0,     0,   272,     0,     0,
     273,   274,     0,  3085,     0,     0,     0,   275,   276,     0,
     277,     0,   278,     0,   279,   280,     0,     0,     0,     0,
       0,     0,     0,   281,     0,   282,   283,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,     0,   299,   300,   301,     0,   302,   303,   304,
     305,     0,   306,   307,     0,     0,     0,     0,   308,   309,
     310,   311,   312,   313,     0,     0,   314,   315,     0,   316,
       0,   317,     0,   318,   319,   320,   321,   322,   323,   324,
     325,   326,     0,     0,   327,   328,     0,     0,   329,   330,
     331,   332,     0,     0,     0,   333,   334,     0,     0,     0,
     335,     0,   336,   337,   338,     0,   339,   340,   341,     0,
     342,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     343,   344,   345,     0,   346,   347,  2034,   348,   349,   350,
     351,   352,   353,   354,   355,   356,   357,     0,     0,   358,
     359,   360,     0,   361,     0,   362,   363,   364,   365,   366,
       0,   367,   368,   369,     0,     0,   370,     0,     0,     0,
     371,   372,   373,   374,   375,     0,     0,   376,   377,   378,
     379,   380,     0,   381,   382,     0,   383,   384,   385,     0,
       0,   386,     0,   387,     0,   388,   389,     0,   390,   391,
     392,     0,   393,     0,     0,   394,   395,   396,   397,   398,
     399,   400,   401,   402,   403,   404,     0,   405,   406,  -478,
       0,     0,   407,   408,   409,   410,     0,     0,     0,   411,
       0,     0,     0,   412,     0,   413,   414,   415,   416,     0,
     417,   418,   419,   420,   421,   505,     0,     0,     0,     0,
     422,   423,   424,     0,   425,   426,     0,   427,     0,     0,
     428,     0,     0,   429,   430,   431,   432,   433,   434,     0,
       0,   435,   436,     0,   437,   438,   439,   440,   441,   442,
       0,     0,   443,   444,   445,   446,     0,   447,   448,     0,
       0,   449,   450,   451,   452,     0,     0,   453,   454,     0,
     455,   456,   457,   458,     0,     0,     0,     0,     0,   459,
     460,     0,     0,     0,   461,   462,   463,   464,     0,   465,
     466,     0,   467,   468,     0,   469,   470,     0,     0,   471,
       0,     0,   472,     0,   473,     0,   474,   475,     0,     0,
       0,     0,     0,     0,   476,     0,     0,   477,     0,     0,
       0,   478,   479,   480,   481,   482,     0,     0,     0,     0,
       0,     0,   483,   484,     0,   485,   486,   487,     0,     0,
     488,     0,   137,     0,   138,   139,   140,   141,   142,     0,
       0,   143,     0,     0,     0,   144,     0,     0,   145,  2592,
     146,   147,   148,   149,   150,   151,     0,   152,     0,     0,
       0,   153,     0,     0,     0,   154,     0,     0,   155,   156,
     157,     0,   158,     0,   159,   160,     0,     0,   161,     0,
       0,   162,   163,     0,   164,   165,     0,   166,     0,   167,
     168,   169,   170,   171,   172,     0,   173,   174,     0,   175,
     176,   177,   178,   179,   180,   181,   182,   183,     0,   184,
     185,  2521,   186,   187,   188,   189,   190,     0,     0,     0,
     191,     0,     0,   192,     0,   193,     0,     0,   194,     0,
       0,     0,   195,   196,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,     0,     0,   201,   202,
       0,   203,     0,     0,     0,   204,     0,   205,   206,   207,
     208,   209,     0,     0,     0,   210,     0,     0,   211,   212,
     213,     0,     0,     0,   214,     0,   215,   216,     0,   217,
     218,   219,     0,     0,   220,   221,     0,   222,   223,   224,
     225,   226,   227,     0,     0,   228,   229,   230,   231,   232,
       0,     0,   233,   234,     0,   235,   236,   237,     0,     0,
     238,     0,     0,     0,   239,   240,     0,   241,   502,   242,
       0,   243,   244,   245,   246,     0,   247,     0,   248,     0,
       0,     0,   249,   250,     0,   251,     0,     0,   252,   253,
       0,     0,     0,   254,   255,   256,   257,     0,     0,   258,
     259,   260,  2078,     0,   261,     0,     0,     0,     0,   262,
     263,     0,     0,     0,   264,     0,     0,     0,   265,   266,
       0,   267,   268,     0,     0,     0,   269,  2079,     0,   270,
     271,     0,     0,   272,     0,     0,   273,   274,     0,     0,
       0,     0,     0,   275,   276,     0,   277,     0,   278,     0,
     279,   280,     0,     0,     0,     0,     0,     0,     0,   281,
       0,   282,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,     0,   299,
     300,   301,     0,   302,   303,   304,   305,     0,   306,   307,
       0,     0,     0,     0,   308,   309,   310,   311,   312,   313,
       0,     0,   314,   315,     0,   316,     0,   317,     0,   318,
     319,   320,   321,   322,   323,   324,   325,   326,     0,     0,
     327,   328,     0,     0,   329,   330,   331,   332,     0,     0,
       0,   333,   334,     0,     0,     0,   335,     0,   336,   337,
     338,     0,   339,   340,   341,     0,   342,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   343,   344,   345,     0,
     346,   347,     0,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,     0,     0,   358,   359,   360,     0,   361,
       0,   362,   363,   364,   365,   366,     0,   367,   368,   369,
       0,     0,   370,     0,     0,     0,   371,   372,   373,   374,
     375,     0,     0,   376,   377,   378,   379,   380,     0,   381,
     382,     0,   383,   384,   385,     0,     0,   386,     0,   387,
       0,   388,   389,     0,   390,   391,   392,     0,   393,     0,
       0,   394,   395,   396,   397,   398,   399,   400,   401,   402,
     403,   404,     0,   405,   406,     0,     0,     0,   407,   408,
     409,   410,     0,     0,     0,   411,     0,     0,     0,   412,
       0,   413,   414,   415,   416,     0,   417,   418,   419,   420,
     421,   505,     0,     0,     0,     0,   422,   423,   424,     0,
     425,   426,     0,   427,     0,     0,   428,     0,     0,   429,
     430,   431,   432,   433,   434,     0,     0,   435,   436,     0,
     437,   438,   439,   440,   441,   442,     0,     0,   443,   444,
     445,   446,     0,   447,   448,     0,     0,   449,   450,   451,
     452,     0,     0,   453,   454,     0,   455,   456,   457,   458,
       0,     0,     0,     0,     0,   459,   460,     0,     0,     0,
     461,   462,   463,   464,     0,   465,   466,     0,   467,   468,
       0,   469,   470,     0,     0,   471,     0,     0,   472,     0,
     473,     0,   474,   475,     0,     0,     0,     0,     0,     0,
     476,     0,     0,   477,     0,     0,     0,   478,   479,   480,
     481,   482,     0,     0,     0,     0,     0,     0,   483,   484,
       0,   485,   486,   487,     0,     0,   488,     0,   137,     0,
     138,   139,   140,   141,   142,     0,     0,   143,     0,     0,
       0,   144,     0,     0,   145,  2592,   146,   147,   148,   149,
     150,   151,     0,   152,     0,     0,     0,   153,     0,     0,
       0,   154,     0,     0,   155,   156,   157,     0,   158,     0,
     159,   160,     0,     0,   161,     0,     0,   162,   163,     0,
     164,   165,     0,   166,     0,   167,   168,   169,   170,   171,
     172,     0,   173,   174,     0,   175,   176,   177,   178,   179,
     180,   181,   182,   183,     0,   184,   185,     0,   186,   187,
     188,   189,   190,     0,     0,     0,   191,     0,     0,   192,
       0,   193,     0,     0,   194,     0,     0,     0,   195,   196,
     197,     0,     0,   198,     0,     0,     0,     0,   199,   200,
       0,     0,     0,     0,   201,   202,     0,   203,     0,     0,
       0,   204,     0,   205,   206,   207,   208,   209,     0,     0,
       0,   210,     0,     0,   211,   212,   213,     0,     0,     0,
     214,     0,   215,   216,     0,   217,   218,   219,     0,     0,
     220,   221,     0,   222,   223,   224,   225,   226,   227,     0,
       0,   228,   229,   230,   231,   232,     0,     0,   233,   234,
       0,   235,   236,   237,     0,     0,   238,     0,     0,     0,
     239,   240,     0,   241,     0,   242,     0,   243,   244,   245,
     246,     0,   247,     0,   248,     0,     0,     0,   249,   250,
       0,   251,     0,     0,   252,   253,     0,     0,     0,   254,
     255,   256,   257,     0,     0,   258,   259,   260,     0,     0,
     261,     0,     0,     0,     0,   262,   263,     0,     0,     0,
     264,     0,     0,     0,   265,   266,     0,   267,   268,     0,
       0,     0,   269,     0,     0,   270,   271,     0,     0,   272,
       0,     0,   273,   274,     0,     0,     0,     0,     0,   275,
     276,     0,   277,     0,   278,     0,   279,   280,     0,     0,
       0,     0,     0,     0,     0,   281,     0,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,     0,   299,   300,   301,     0,   302,
     303,   304,   305,     0,   306,   307,     0,     0,     0,     0,
     308,   309,   310,   311,   312,   313,     0,     0,   314,   315,
       0,   316,     0,   317,     0,   318,   319,   320,   321,   322,
     323,   324,   325,   326,     0,     0,   327,   328,     0,     0,
     329,   330,   331,   332,     0,     0,     0,   333,   334,     0,
       0,     0,   335,     0,   336,   337,   338,     0,   339,   340,
     341,     0,   342,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   343,   344,   345,     0,   346,   347,     0,   348,
     349,   350,   351,   352,   353,   354,   355,   356,   357,     0,
       0,   358,   359,   360,     0,   361,     0,   362,   363,   364,
     365,   366,     0,   367,   368,   369,     0,     0,   370,     0,
       0,     0,   371,   372,   373,   374,   375,     0,     0,   376,
     377,   378,   379,   380,     0,   381,   382,     0,   383,   384,
     385,     0,     0,   386,     0,   387,     0,   388,   389,     0,
     390,   391,   392,     0,   393,     0,     0,   394,   395,   396,
     397,   398,   399,   400,   401,   402,   403,   404,     0,   405,
     406,  2380,     0,     0,   407,   408,   409,   410,     0,     0,
       0,   411,     0,     0,     0,   412,     0,   413,   414,   415,
     416,     0,   417,   418,   419,   420,   421,     0,     0,     0,
       0,     0,   422,   423,   424,     0,   425,   426,     0,   427,
       0,     0,   428,     0,     0,   429,   430,   431,   432,   433,
     434,     0,     0,   435,   436,     0,   437,   438,   439,   440,
     441,   442,     0,     0,   443,   444,   445,   446,     0,   447,
     448,     0,     0,   449,   450,   451,   452,     0,     0,   453,
     454,     0,   455,   456,   457,   458,     0,     0,     0,     0,
       0,   459,   460,     0,     0,     0,   461,   462,   463,   464,
       0,   465,   466,     0,   467,   468,     0,   469,   470,     0,
       0,   471,     0,     0,   472,     0,   473,     0,   474,   475,
       0,     0,     0,     0,     0,     0,   476,     0,     0,   477,
       0,     0,     0,   478,   479,   480,   481,   482,     0,     0,
       0,     0,     0,     0,   483,   484,     0,   485,   486,   487,
       0,     0,   488,     0,   137,     0,   138,   139,   140,   141,
     142,     0,     0,   143,  2837,     0,     0,   144,     0,     0,
     145,   768,   146,   147,   148,   149,   150,   151,     0,   152,
       0,     0,     0,   153,     0,     0,     0,   154,     0,     0,
     155,   156,   157,     0,   158,     0,   159,   160,     0,     0,
     161,     0,     0,   162,   163,     0,   164,   165,     0,   166,
       0,   167,   168,   169,   170,   171,   172,     0,   173,   174,
       0,   175,   176,   177,   178,   179,   180,   181,   182,   183,
       0,   184,   185,     0,   186,   187,   188,   189,   190,     0,
       0,     0,   191,     0,     0,   192,     0,   193,     0,     0,
     194,     0,     0,     0,   195,   196,   197,     0,     0,   198,
       0,     0,     0,     0,   199,   200,     0,     0,     0,     0,
     201,   202,     0,   203,     0,     0,     0,   204,     0,   205,
     206,   207,   208,   209,     0,     0,     0,   210,     0,     0,
     211,   212,   213,     0,     0,     0,   214,     0,   215,   216,
       0,   217,   218,   219,     0,     0,   220,   221,     0,   222,
     223,   224,   225,   226,   227,     0,     0,   228,   229,   230,
     231,   232,     0,     0,   233,   234,     0,   235,   236,   237,
       0,     0,   238,     0,     0,     0,   239,   240,     0,   241,
       0,   242,     0,   243,   244,   245,   246,     0,   247,     0,
     248,     0,     0,     0,   249,   250,     0,   251,     0,     0,
     252,   253,     0,     0,     0,   254,   255,   256,   257,     0,
       0,   258,   259,   260,     0,     0,   261,     0,     0,     0,
       0,   262,   263,     0,     0,     0,   264,     0,     0,     0,
     265,   266,     0,   267,   268,     0,     0,     0,   269,     0,
       0,   270,   271,     0,     0,   272,     0,     0,   273,   274,
       0,     0,     0,     0,     0,   275,   276,     0,   277,     0,
     278,     0,   279,   280,     0,     0,     0,     0,     0,     0,
       0,   281,     0,   282,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
       0,   299,   300,   301,     0,   302,   303,   304,   305,     0,
     306,   307,     0,     0,     0,     0,   308,   309,   310,   311,
     312,   313,     0,     0,   314,   315,     0,   316,     0,   317,
       0,   318,   319,   320,   321,   322,   323,   324,   325,   326,
       0,     0,   327,   328,     0,     0,   329,   330,   331,   332,
       0,     0,     0,   333,   334,     0,     0,     0,   335,     0,
     336,   337,   338,     0,   339,   340,   341,     0,   342,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   343,   344,
     345,     0,   346,   347,     0,   348,   349,   350,   351,   352,
     353,   354,   355,   356,   357,     0,     0,   358,   359,   360,
       0,   361,     0,   362,   363,   364,   365,   366,     0,   367,
     368,   369,     0,     0,   370,     0,     0,     0,   371,   372,
     373,   374,   375,     0,     0,   376,   377,   378,   379,   380,
       0,   381,   382,     0,   383,   384,   385,     0,     0,   386,
       0,   387,     0,   388,   389,     0,   390,   391,   392,     0,
     393,     0,     0,   394,   395,   396,   397,   398,   399,   400,
     401,   402,   403,   404,     0,   405,   406,     0,     0,     0,
     407,   408,   409,   410,     0,     0,     0,   411,     0,     0,
       0,   412,     0,   413,   414,   415,   416,     0,   417,   418,
     419,   420,   421,     0,     0,     0,     0,     0,   422,   423,
     424,     0,   425,   426,     0,   427,     0,     0,   428,     0,
       0,   429,   430,   431,   432,   433,   434,     0,     0,   435,
     436,     0,   437,   438,   439,   440,   441,   442,     0,     0,
     443,   444,   445,   446,     0,   447,   448,     0,     0,   449,
     450,   451,   452,     0,     0,   453,   454,     0,   455,   456,
     457,   458,     0,     0,     0,     0,     0,   459,   460,     0,
       0,     0,   461,   462,   463,   464,     0,   465,   466,     0,
     467,   468,     0,   469,   470,     0,     0,   471,     0,     0,
     472,     0,   473,     0,   474,   475,     0,     0,     0,     0,
       0,     0,   476,     0,     0,   477,     0,     0,     0,   478,
     479,   480,   481,   482,     0,     0,     0,     0,     0,     0,
     483,   484,     0,   485,   486,   487,     0,     0,   488,     0,
       0,     0,   137,     0,   138,   139,   140,   141,   142,     0,
    4499,   143,     0,     0,     0,   144,  4500,   768,   145,     0,
     146,   147,   148,   149,   150,   151,     0,   152,     0,     0,
       0,   153,     0,     0,     0,   154,     0,     0,   155,   156,
     157,     0,   158,     0,   159,   160,     0,     0,   161,     0,
       0,   162,   163,     0,   164,   165,     0,   166,     0,   167,
     168,   169,   170,   171,   172,     0,   173,   174,     0,   175,
     176,   177,   178,   179,   180,   181,   182,   183,     0,   184,
     185,     0,   186,   187,   188,   189,   190,     0,     0,     0,
     191,     0,     0,   192,     0,   193,     0,     0,   194,     0,
       0,     0,   195,   196,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,     0,     0,   201,   202,
       0,   203,     0,     0,     0,   204,     0,   205,   206,   207,
     208,   209,     0,     0,     0,   210,     0,     0,   211,   212,
     213,     0,     0,     0,   214,     0,   215,   216,     0,   217,
     218,   219,     0,     0,   220,   221,     0,   222,   223,   224,
     225,   226,   227,     0,     0,   228,   229,   230,   231,   232,
       0,     0,   233,   234,     0,   235,   236,   237,     0,     0,
     238,     0,     0,     0,   239,   240,     0,   241,     0,   242,
       0,   243,   244,   245,   246,     0,   247,     0,   248,     0,
       0,     0,   249,   250,     0,   251,     0,     0,   252,   253,
       0,     0,     0,   254,   255,   256,   257,     0,     0,   258,
     259,   260,     0,     0,   261,     0,     0,     0,     0,   262,
     263,     0,     0,     0,   264,     0,     0,     0,   265,   266,
       0,   267,   268,     0,     0,     0,   269,     0,     0,   270,
     271,     0,     0,   272,     0,     0,   273,   274,     0,     0,
       0,     0,     0,   275,   276,     0,   277,     0,   278,     0,
     279,   280,     0,     0,     0,     0,     0,     0,     0,   281,
       0,   282,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,     0,   299,
     300,   301,     0,   302,   303,   304,   305,     0,   306,   307,
       0,     0,     0,     0,   308,   309,   310,   311,   312,   313,
       0,     0,   314,   315,     0,   316,     0,   317,     0,   318,
     319,   320,   321,   322,   323,   324,   325,   326,     0,     0,
     327,   328,     0,     0,   329,   330,   331,   332,     0,     0,
       0,   333,   334,     0,     0,     0,   335,     0,   336,   337,
     338,     0,   339,   340,   341,     0,   342,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   343,   344,   345,     0,
     346,   347,     0,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,     0,     0,   358,   359,   360,     0,   361,
       0,   362,   363,   364,   365,   366,     0,   367,   368,   369,
       0,     0,   370,     0,     0,     0,   371,   372,   373,   374,
     375,     0,     0,   376,   377,   378,   379,   380,     0,   381,
     382,     0,   383,   384,   385,     0,     0,   386,     0,   387,
       0,   388,   389,     0,   390,   391,   392,     0,   393,     0,
       0,   394,   395,   396,   397,   398,   399,   400,   401,   402,
     403,   404,     0,   405,   406,     0,     0,     0,   407,   408,
     409,   410,     0,     0,     0,   411,     0,     0,     0,   412,
       0,   413,   414,   415,   416,     0,   417,   418,   419,   420,
     421,     0,     0,     0,     0,     0,   422,   423,   424,     0,
     425,   426,     0,   427,     0,     0,   428,     0,     0,   429,
     430,   431,   432,   433,   434,     0,     0,   435,   436,     0,
     437,   438,   439,   440,   441,   442,     0,     0,   443,   444,
     445,   446,     0,   447,   448,     0,     0,   449,   450,   451,
     452,     0,     0,   453,   454,     0,   455,   456,   457,   458,
       0,     0,     0,     0,     0,   459,   460,     0,     0,     0,
     461,   462,   463,   464,     0,   465,   466,     0,   467,   468,
       0,   469,   470,     0,     0,   471,     0,     0,   472,     0,
     473,     0,   474,   475,     0,     0,     0,     0,     0,     0,
     476,     0,     0,   477,     0,     0,     0,   478,   479,   480,
     481,   482,     0,     0,     0,     0,     0,     0,   483,   484,
       0,   485,   486,   487,     0,     0,   488,     0,     0,     0,
     137,     0,   138,   139,   140,   141,   142,  1117,     0,   143,
       0,     0,     0,   144,     0,   768,   145,     0,   146,   147,
     148,   149,   150,   151,     0,   152,     0,     0,     0,   153,
       0,     0,     0,   154,     0,     0,   155,   156,   157,     0,
     158,     0,   159,   160,     0,     0,   161,     0,     0,   162,
     163,     0,   164,   165,     0,   166,     0,   167,   168,   169,
     170,   171,   172,     0,   173,   174,     0,   175,   176,   177,
     178,   179,   180,   181,   182,   183,     0,   184,   185,     0,
     186,   187,   188,   189,   190,     0,     0,     0,   191,     0,
       0,   192,     0,   193,     0,     0,   194,     0,     0,     0,
     195,   196,   197,     0,     0,   198,     0,     0,     0,     0,
     199,   200,     0,     0,     0,     0,   201,   202,     0,   203,
       0,     0,     0,   204,     0,   205,   206,   207,   208,   209,
       0,     0,     0,   210,     0,     0,   211,   212,   213,     0,
       0,     0,   214,     0,   215,   216,     0,   217,   218,   219,
       0,     0,   220,   221,     0,   222,   223,   224,   225,   226,
     227,     0,     0,   228,   229,   230,   231,   232,     0,     0,
     233,   234,     0,   235,   236,   237,     0,     0,   238,     0,
       0,     0,   239,   240,     0,   241,     0,   242,     0,   243,
     244,   245,   246,     0,   247,     0,   248,     0,     0,     0,
     249,   250,     0,   251,     0,     0,   252,   253,     0,     0,
       0,   254,   255,   256,   257,     0,     0,   258,   259,   260,
       0,     0,   261,     0,     0,     0,     0,   262,   263,     0,
    1322,     0,   264,     0,     0,     0,   265,   266,     0,   267,
     268,     0,     0,     0,   269,     0,     0,   270,   271,     0,
       0,   272,     0,     0,   273,   274,     0,     0,     0,     0,
       0,   275,   276,     0,   277,     0,   278,     0,   279,   280,
       0,     0,     0,     0,     0,     0,     0,   281,     0,   282,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,     0,   299,   300,   301,
       0,   302,   303,   304,   305,     0,   306,   307,     0,     0,
       0,     0,   308,   309,   310,   311,   312,   313,     0,     0,
     314,   315,     0,   316,     0,   317,     0,   318,   319,   320,
     321,   322,   323,   324,   325,   326,     0,     0,   327,   328,
       0,     0,   329,   330,   331,   332,     0,     0,     0,   333,
     334,     0,     0,     0,   335,     0,   336,   337,   338,     0,
     339,   340,   341,     0,   342,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   343,   344,   345,     0,   346,   347,
       0,   348,   349,   350,   351,   352,   353,   354,   355,   356,
     357,     0,     0,   358,   359,   360,     0,   361,     0,   362,
     363,   364,   365,   366,     0,   367,   368,   369,     0,     0,
     370,     0,     0,     0,   371,   372,   373,   374,   375,     0,
       0,   376,   377,   378,   379,   380,     0,   381,   382,     0,
     383,   384,   385,     0,     0,   386,     0,   387,     0,   388,
     389,     0,   390,   391,   392,     0,   393,     0,     0,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
       0,   405,   406,     0,     0,     0,   407,   408,   409,   410,
       0,     0,     0,   411,     0,     0,     0,   412,     0,   413,
     414,   415,   416,     0,   417,   418,   419,   420,   421,     0,
       0,     0,     0,     0,   422,   423,   424,     0,   425,   426,
       0,   427,     0,     0,   428,     0,     0,   429,   430,   431,
     432,   433,   434,     0,     0,   435,   436,     0,   437,   438,
     439,   440,   441,   442,     0,     0,   443,   444,   445,   446,
       0,   447,   448,     0,     0,   449,   450,   451,   452,     0,
       0,   453,   454,     0,   455,   456,   457,   458,     0,     0,
       0,     0,     0,   459,   460,     0,     0,     0,   461,   462,
     463,   464,     0,   465,   466,     0,   467,   468,     0,   469,
     470,     0,     0,   471,     0,     0,   472,     0,   473,     0,
     474,   475,     0,     0,     0,     0,     0,     0,   476,     0,
       0,   477,     0,     0,     0,   478,   479,   480,   481,   482,
       0,     0,     0,     0,     0,     0,   483,   484,     0,   485,
     486,   487,     0,     0,   488,     0,   137,     0,   138,   139,
     140,   141,   142,     0,     0,   143,     0,     0,     0,   144,
       0,     0,   145,   538,   146,   147,   148,   149,   150,   151,
       0,   152,     0,     0,     0,   153,     0,     0,     0,   154,
       0,     0,   155,   156,   157,     0,   158,     0,   159,   160,
       0,     0,   161,     0,     0,   162,   163,     0,   164,   165,
       0,   166,     0,   167,   168,   169,   170,   171,   172,     0,
     173,   174,     0,   175,   176,   177,   178,   179,   180,   181,
     182,   183,     0,   184,   185,     0,   186,   187,   188,   189,
     190,     0,     0,     0,   191,     0,     0,   192,     0,   193,
       0,     0,   194,     0,     0,     0,   195,   196,   197,     0,
       0,   198,     0,     0,     0,     0,   199,   200,     0,     0,
       0,     0,   201,   202,     0,   203,     0,     0,     0,   204,
       0,   205,   206,   207,   208,   209,     0,     0,     0,   210,
       0,     0,   211,   212,   213,     0,     0,     0,   214,     0,
     215,   216,     0,   217,   218,   219,     0,     0,   220,   221,
       0,   222,   223,   224,   225,   226,   227,     0,     0,   228,
     229,   230,   231,   232,     0,     0,   233,   234,     0,   235,
     236,   237,     0,     0,   238,     0,     0,     0,   239,   240,
       0,   241,     0,   242,     0,   243,   244,   245,   246,     0,
     247,     0,   248,     0,     0,     0,   249,   250,     0,   251,
       0,     0,   252,   253,     0,     0,     0,   254,   255,   256,
     257,     0,     0,   258,   259,   260,     0,     0,   261,     0,
       0,     0,     0,   262,   263,     0,     0,     0,   264,     0,
       0,     0,   265,   266,     0,   267,   268,     0,     0,     0,
     269,     0,     0,   270,   271,     0,     0,   272,     0,     0,
     273,   274,     0,     0,     0,     0,     0,   275,   276,     0,
     277,     0,   278,     0,   279,   280,     0,     0,     0,     0,
       0,     0,     0,   281,     0,   282,   283,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,     0,   299,   300,   301,     0,   302,   303,   304,
     305,     0,   306,   307,     0,     0,     0,     0,   308,   309,
     310,   311,   312,   313,     0,     0,   314,   315,     0,   316,
       0,   317,     0,   318,   319,   320,   321,   322,   323,   324,
     325,   326,     0,     0,   327,   328,     0,     0,   329,   330,
     331,   332,     0,     0,     0,   333,   334,     0,     0,     0,
     335,     0,   336,   337,   338,     0,   339,   340,   341,     0,
     342,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     343,   344,   345,     0,   346,   347,     0,   348,   349,   350,
     351,   352,   353,   354,   355,   356,   357,     0,     0,   358,
     359,   360,     0,   361,     0,   362,   363,   364,   365,   366,
       0,   367,   368,   369,     0,     0,   370,     0,     0,     0,
     371,   372,   373,   374,   375,     0,     0,   376,   377,   378,
     379,   380,     0,   381,   382,     0,   383,   384,   385,     0,
       0,   386,     0,   387,     0,   388,   389,     0,   390,   391,
     392,     0,   393,     0,     0,   394,   395,   396,   397,   398,
     399,   400,   401,   402,   403,   404,     0,   405,   406,     0,
       0,     0,   407,   408,   409,   410,     0,     0,     0,   411,
       0,     0,     0,   412,     0,   413,   414,   415,   416,     0,
     417,   418,   419,   420,   421,     0,     0,     0,     0,     0,
     422,   423,   424,     0,   425,   426,     0,   427,     0,     0,
     428,     0,     0,   429,   430,   431,   432,   433,   434,     0,
       0,   435,   436,     0,   437,   438,   439,   440,   441,   442,
       0,     0,   443,   444,   445,   446,     0,   447,   448,     0,
       0,   449,   450,   451,   452,     0,     0,   453,   454,     0,
     455,   456,   457,   458,     0,     0,     0,     0,     0,   459,
     460,     0,     0,     0,   461,   462,   463,   464,     0,   465,
     466,     0,   467,   468,     0,   469,   470,     0,     0,   471,
       0,     0,   472,     0,   473,     0,   474,   475,     0,     0,
       0,     0,     0,     0,   476,     0,     0,   477,     0,     0,
       0,   478,   479,   480,   481,   482,     0,     0,     0,     0,
       0,     0,   483,   484,     0,   485,   486,   487,     0,     0,
     488,     0,     0,     0,     0,   137,  2321,   138,   139,   140,
     141,   142,     0,     0,   143,     0,     0,     0,   144,   538,
       0,   145,     0,   146,   147,   148,   149,   150,   151,     0,
     152,     0,     0,     0,   153,     0,     0,     0,   154,     0,
       0,   155,   156,   157,     0,   158,     0,   159,   160,     0,
       0,   161,     0,     0,   162,   163,     0,   164,   165,     0,
     166,     0,   167,   168,   169,   170,   171,   172,     0,   173,
     174,     0,   175,   176,   177,   178,   179,   180,   181,   182,
     183,     0,   184,   185,     0,   186,   187,   188,   189,   190,
       0,     0,     0,   191,     0,     0,   192,     0,   193,     0,
       0,   194,     0,     0,     0,   195,   196,   197,     0,     0,
     198,     0,     0,     0,     0,   199,   200,     0,     0,     0,
       0,   201,   202,     0,   203,     0,     0,     0,   204,     0,
     205,   206,   207,   208,   209,     0,     0,     0,   210,     0,
       0,   211,   212,   213,     0,     0,     0,   214,     0,   215,
     216,     0,   217,   218,   219,     0,     0,   220,   221,     0,
     222,   223,   224,   225,   226,   227,     0,     0,   228,   229,
     230,   231,   232,     0,     0,   233,   234,     0,   235,   236,
     237,     0,     0,   238,     0,     0,     0,   239,   240,     0,
     241,     0,   242,     0,   243,   244,   245,   246,     0,   247,
       0,   248,     0,     0,     0,   249,   250,     0,   251,     0,
       0,   252,   253,     0,     0,     0,   254,   255,   256,   257,
       0,     0,   258,   259,   260,     0,     0,   261,     0,     0,
       0,     0,   262,   263,     0,     0,     0,   264,     0,     0,
       0,   265,   266,     0,   267,   268,     0,     0,     0,   269,
       0,     0,   270,   271,     0,     0,   272,     0,     0,   273,
     274,     0,     0,     0,     0,     0,   275,   276,     0,   277,
       0,   278,     0,   279,   280,     0,     0,     0,     0,     0,
       0,     0,   281,     0,   282,   283,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,     0,   299,   300,   301,     0,   302,   303,   304,   305,
       0,   306,   307,     0,     0,     0,     0,   308,   309,   310,
     311,   312,   313,     0,     0,   314,   315,     0,   316,     0,
     317,     0,   318,   319,   320,   321,   322,   323,   324,   325,
     326,     0,     0,   327,   328,     0,     0,   329,   330,   331,
     332,     0,     0,     0,   333,   334,     0,     0,     0,   335,
       0,   336,   337,   338,     0,   339,   340,   341,     0,   342,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   343,
     344,   345,     0,   346,   347,     0,   348,   349,   350,   351,
     352,   353,   354,   355,   356,   357,     0,     0,   358,   359,
     360,     0,   361,     0,   362,   363,   364,   365,   366,     0,
     367,   368,   369,     0,     0,   370,     0,     0,     0,   371,
     372,   373,   374,   375,     0,     0,   376,   377,   378,   379,
     380,     0,   381,   382,     0,   383,   384,   385,     0,     0,
     386,     0,   387,     0,   388,   389,     0,   390,   391,   392,
       0,   393,     0,     0,   394,   395,   396,   397,   398,   399,
     400,   401,   402,   403,   404,     0,   405,   406,     0,     0,
       0,   407,   408,   409,   410,     0,     0,     0,   411,     0,
       0,     0,   412,     0,   413,   414,   415,   416,     0,   417,
     418,   419,   420,   421,     0,     0,     0,     0,     0,   422,
     423,   424,     0,   425,   426,     0,   427,     0,     0,   428,
       0,     0,   429,   430,   431,   432,   433,   434,     0,     0,
     435,   436,     0,   437,   438,   439,   440,   441,   442,     0,
       0,   443,   444,   445,   446,     0,   447,   448,     0,     0,
     449,   450,   451,   452,     0,     0,   453,   454,     0,   455,
     456,   457,   458,     0,     0,     0,     0,     0,   459,   460,
       0,     0,     0,   461,   462,   463,   464,     0,   465,   466,
       0,   467,   468,     0,   469,   470,     0,     0,   471,     0,
       0,   472,     0,   473,     0,   474,   475,     0,     0,     0,
       0,     0,     0,   476,     0,     0,   477,     0,     0,     0,
     478,   479,   480,   481,   482,     0,     0,     0,     0,     0,
       0,   483,   484,     0,   485,   486,   487,     0,     0,   488,
       0,     0,     0,   137,     0,   138,   139,   140,   141,   142,
    2591,     0,   143,     0,     0,     0,   144,     0,  2592,   145,
       0,   146,   147,   148,   149,   150,   151,     0,   152,     0,
       0,     0,   153,     0,     0,     0,   154,     0,     0,   155,
     156,   157,     0,   158,     0,   159,   160,     0,     0,   161,
       0,     0,   162,   163,     0,   164,   165,     0,   166,     0,
     167,   168,   169,   170,   171,   172,     0,   173,   174,     0,
     175,   176,   177,   178,   179,   180,   181,   182,   183,     0,
     184,   185,     0,   186,   187,   188,   189,   190,     0,     0,
       0,   191,     0,     0,   192,     0,   193,     0,     0,   194,
       0,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,     0,     0,   201,
     202,     0,   203,     0,     0,     0,   204,     0,   205,   206,
     207,   208,   209,     0,     0,     0,   210,     0,     0,   211,
     212,   213,     0,     0,     0,   214,     0,   215,   216,     0,
     217,   218,   219,     0,     0,   220,   221,     0,   222,   223,
     224,   225,   226,   227,     0,     0,   228,   229,   230,   231,
     232,     0,     0,   233,   234,     0,   235,   236,   237,     0,
       0,   238,     0,     0,     0,   239,   240,     0,   241,     0,
     242,     0,   243,   244,   245,   246,     0,   247,     0,   248,
       0,     0,     0,   249,   250,     0,   251,     0,     0,   252,
     253,     0,     0,     0,   254,   255,   256,   257,     0,     0,
     258,   259,   260,     0,     0,   261,     0,     0,     0,     0,
     262,   263,     0,     0,     0,   264,     0,     0,     0,   265,
     266,     0,   267,   268,     0,     0,     0,   269,     0,     0,
     270,   271,     0,     0,   272,     0,     0,   273,   274,     0,
       0,     0,     0,     0,   275,   276,     0,   277,     0,   278,
       0,   279,   280,     0,     0,     0,     0,     0,     0,     0,
     281,     0,   282,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,     0,
     299,   300,   301,     0,   302,   303,   304,   305,     0,   306,
     307,     0,     0,     0,     0,   308,   309,   310,   311,   312,
     313,     0,     0,   314,   315,     0,   316,     0,   317,     0,
     318,   319,   320,   321,   322,   323,   324,   325,   326,     0,
       0,   327,   328,     0,     0,   329,   330,   331,   332,     0,
       0,     0,   333,   334,     0,     0,     0,   335,     0,   336,
     337,   338,     0,   339,   340,   341,     0,   342,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   343,   344,   345,
       0,   346,   347,     0,   348,   349,   350,   351,   352,   353,
     354,   355,   356,   357,     0,     0,   358,   359,   360,     0,
     361,     0,   362,   363,   364,   365,   366,     0,   367,   368,
     369,     0,     0,   370,     0,     0,     0,   371,   372,   373,
     374,   375,     0,     0,   376,   377,   378,   379,   380,     0,
     381,   382,     0,   383,   384,   385,     0,     0,   386,     0,
     387,     0,   388,   389,     0,   390,   391,   392,     0,   393,
       0,     0,   394,   395,   396,   397,   398,   399,   400,   401,
     402,   403,   404,     0,   405,   406,     0,     0,     0,   407,
     408,   409,   410,     0,     0,     0,   411,     0,     0,     0,
     412,     0,   413,   414,   415,   416,     0,   417,   418,   419,
     420,   421,     0,     0,     0,     0,     0,   422,   423,   424,
       0,   425,   426,     0,   427,     0,     0,   428,     0,     0,
     429,   430,   431,   432,   433,   434,     0,     0,   435,   436,
       0,   437,   438,   439,   440,   441,   442,     0,     0,   443,
     444,   445,   446,     0,   447,   448,     0,     0,   449,   450,
     451,   452,     0,     0,   453,   454,     0,   455,   456,   457,
     458,     0,     0,     0,     0,     0,   459,   460,     0,     0,
       0,   461,   462,   463,   464,     0,   465,   466,     0,   467,
     468,     0,   469,   470,     0,     0,   471,     0,     0,   472,
       0,   473,     0,   474,   475,     0,     0,     0,     0,     0,
       0,   476,     0,     0,   477,     0,     0,     0,   478,   479,
     480,   481,   482,     0,     0,     0,     0,     0,     0,   483,
     484,     0,   485,   486,   487,     0,     0,   488,     0,     0,
       0,   137,     0,   138,   139,   140,   141,   142,     0,     0,
     143,     0,     0,     0,   144,  4500,   768,   145,     0,   146,
     147,   148,   149,   150,   151,     0,   152,     0,     0,     0,
     153,     0,     0,     0,   154,     0,     0,   155,   156,   157,
       0,   158,     0,   159,   160,     0,     0,   161,     0,     0,
     162,   163,     0,   164,   165,     0,   166,     0,   167,   168,
     169,   170,   171,   172,     0,   173,   174,     0,   175,   176,
     177,   178,   179,   180,   181,   182,   183,     0,   184,   185,
       0,   186,   187,   188,   189,   190,     0,     0,     0,   191,
       0,     0,   192,     0,   193,     0,     0,   194,     0,     0,
       0,   195,   196,   197,     0,     0,   198,     0,     0,     0,
       0,   199,   200,     0,     0,     0,     0,   201,   202,     0,
     203,     0,     0,     0,   204,     0,   205,   206,   207,   208,
     209,     0,     0,     0,   210,     0,     0,   211,   212,   213,
       0,     0,     0,   214,     0,   215,   216,     0,   217,   218,
     219,     0,     0,   220,   221,     0,   222,   223,   224,   225,
     226,   227,     0,     0,   228,   229,   230,   231,   232,     0,
       0,   233,   234,     0,   235,   236,   237,     0,     0,   238,
       0,     0,     0,   239,   240,     0,   241,     0,   242,     0,
     243,   244,   245,   246,     0,   247,     0,   248,     0,     0,
       0,   249,   250,     0,   251,     0,     0,   252,   253,     0,
       0,     0,   254,   255,   256,   257,     0,     0,   258,   259,
     260,     0,     0,   261,     0,     0,     0,     0,   262,   263,
       0,     0,     0,   264,     0,     0,     0,   265,   266,     0,
     267,   268,     0,     0,     0,   269,     0,     0,   270,   271,
       0,     0,   272,     0,     0,   273,   274,     0,     0,     0,
       0,     0,   275,   276,     0,   277,     0,   278,     0,   279,
     280,     0,     0,     0,     0,     0,     0,     0,   281,     0,
     282,   283,   284,   285,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,     0,   299,   300,
     301,     0,   302,   303,   304,   305,     0,   306,   307,     0,
       0,     0,     0,   308,   309,   310,   311,   312,   313,     0,
       0,   314,   315,     0,   316,     0,   317,     0,   318,   319,
     320,   321,   322,   323,   324,   325,   326,     0,     0,   327,
     328,     0,     0,   329,   330,   331,   332,     0,     0,     0,
     333,   334,     0,     0,     0,   335,     0,   336,   337,   338,
       0,   339,   340,   341,     0,   342,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   343,   344,   345,     0,   346,
     347,     0,   348,   349,   350,   351,   352,   353,   354,   355,
     356,   357,     0,     0,   358,   359,   360,     0,   361,     0,
     362,   363,   364,   365,   366,     0,   367,   368,   369,     0,
       0,   370,     0,     0,     0,   371,   372,   373,   374,   375,
       0,     0,   376,   377,   378,   379,   380,     0,   381,   382,
       0,   383,   384,   385,     0,     0,   386,     0,   387,     0,
     388,   389,     0,   390,   391,   392,     0,   393,     0,     0,
     394,   395,   396,   397,   398,   399,   400,   401,   402,   403,
     404,     0,   405,   406,     0,     0,     0,   407,   408,   409,
     410,     0,     0,     0,   411,     0,     0,     0,   412,     0,
     413,   414,   415,   416,     0,   417,   418,   419,   420,   421,
       0,     0,     0,     0,     0,   422,   423,   424,     0,   425,
     426,     0,   427,     0,     0,   428,     0,     0,   429,   430,
     431,   432,   433,   434,     0,     0,   435,   436,     0,   437,
     438,   439,   440,   441,   442,     0,     0,   443,   444,   445,
     446,     0,   447,   448,     0,     0,   449,   450,   451,   452,
       0,     0,   453,   454,     0,   455,   456,   457,   458,     0,
       0,     0,     0,     0,   459,   460,     0,     0,     0,   461,
     462,   463,   464,     0,   465,   466,     0,   467,   468,     0,
     469,   470,     0,     0,   471,     0,     0,   472,     0,   473,
       0,   474,   475,     0,     0,     0,     0,     0,     0,   476,
       0,     0,   477,     0,     0,     0,   478,   479,   480,   481,
     482,     0,     0,     0,     0,     0,     0,   483,   484,     0,
     485,   486,   487,     0,     0,   488,     0,   137,     0,   138,
     139,   140,   141,   142,     0,     0,   143,     0,     0,     0,
     144,     0,     0,   145,   538,   146,   147,   148,   149,   150,
     151,     0,   152,     0,     0,     0,   153,     0,     0,     0,
     154,     0,     0,   155,   156,   157,     0,   158,     0,   159,
     160,     0,     0,   161,     0,     0,   162,   163,     0,   164,
     165,     0,   166,     0,   167,   168,   169,   170,   171,   172,
       0,   173,   174,     0,   175,   176,   177,   178,   179,   180,
     181,   182,   183,     0,   184,   185,     0,   186,   187,   188,
     189,   190,     0,     0,     0,   191,     0,     0,   192,     0,
     193,     0,     0,   194,     0,     0,     0,   195,   196,   197,
       0,     0,   198,     0,     0,     0,     0,   199,   200,     0,
       0,     0,     0,   201,   202,     0,   203,     0,     0,     0,
     204,     0,   205,   206,   207,   208,   209,     0,     0,     0,
     210,     0,     0,   211,   212,   213,     0,     0,     0,   214,
       0,   215,   216,     0,   217,   218,   219,     0,     0,   220,
     221,     0,   222,   223,   224,   225,   226,   227,     0,     0,
     228,   229,   230,   601,   232,     0,     0,   233,   234,     0,
     235,   236,   237,     0,     0,   238,     0,     0,     0,   602,
     240,     0,   241,     0,   242,     0,   243,   244,   245,   246,
       0,   247,     0,   248,     0,     0,     0,   249,   250,     0,
     251,     0,     0,   252,   253,     0,     0,     0,   254,   255,
     256,   257,     0,     0,   258,   259,   260,     0,     0,   261,
       0,     0,     0,     0,   262,   263,     0,     0,     0,   264,
       0,     0,     0,   265,   266,     0,   267,   268,     0,     0,
       0,   269,     0,     0,   270,   271,     0,     0,   272,     0,
       0,   273,   274,     0,     0,     0,     0,     0,   275,   276,
       0,   277,     0,   278,     0,   279,   280,     0,     0,     0,
       0,     0,     0,     0,   281,     0,   282,   283,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,     0,   299,   300,   301,     0,   302,   303,
     304,   305,     0,   306,   307,     0,     0,     0,     0,   308,
     309,   310,   311,   312,   313,     0,     0,   314,   315,     0,
     316,     0,   317,     0,   318,   319,   320,   321,   322,   323,
     324,   325,   326,     0,     0,   327,   328,     0,     0,   329,
     330,   331,   332,     0,     0,     0,   333,   334,     0,     0,
       0,   335,     0,   336,   337,   338,     0,   339,   340,   341,
       0,   342,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   343,   344,   345,     0,   346,   347,     0,   603,   349,
     350,   351,   352,   353,   354,   355,   356,   357,     0,     0,
     358,   359,   360,     0,   361,     0,   362,   363,   364,   365,
     366,     0,   367,   368,   369,     0,     0,   370,     0,     0,
       0,   371,   372,   373,   374,   375,     0,     0,   376,   377,
     378,   379,   380,     0,   381,   382,     0,   383,   384,   385,
       0,     0,   386,     0,   387,     0,   388,   389,     0,   390,
     391,   392,     0,   393,     0,     0,   394,   395,   396,   397,
     398,   399,   400,   401,   402,   403,   404,     0,   405,   406,
       0,     0,     0,   407,   408,   409,   410,     0,     0,     0,
     411,     0,     0,     0,   412,     0,   413,   414,   415,   416,
       0,   417,   418,   419,   420,   421,     0,     0,     0,     0,
       0,   422,   423,   424,     0,   425,   426,     0,   427,     0,
       0,   428,     0,     0,   429,   430,   431,   432,   433,   434,
       0,     0,   435,   436,     0,   437,   438,   439,   440,   441,
     442,     0,     0,   443,   444,   445,   446,     0,   447,   448,
       0,     0,   449,   450,   451,   452,     0,     0,   453,   454,
       0,   455,   456,   457,   458,     0,     0,     0,     0,     0,
     459,   460,     0,     0,     0,   461,   462,   463,   464,     0,
     465,   466,     0,   467,   468,     0,   469,   470,     0,     0,
     471,     0,     0,   472,     0,   473,     0,   474,   475,     0,
       0,     0,     0,     0,     0,   476,     0,     0,   477,     0,
       0,     0,   478,   479,   480,   481,   482,     0,     0,     0,
       0,     0,     0,   483,   484,     0,   485,   486,   487,     0,
       0,   488,     0,   137,     0,   138,   139,   140,   141,   142,
       0,     0,   143,     0,     0,     0,   144,     0,     0,   145,
     538,   146,   147,   148,   149,   150,   151,     0,   152,     0,
       0,     0,   153,     0,     0,     0,   154,     0,     0,   155,
     156,   157,     0,   158,     0,   159,   160,     0,     0,   161,
       0,     0,   162,   163,     0,   164,   165,     0,   166,     0,
     167,   168,   169,   170,   171,   172,     0,   173,   174,     0,
     175,   176,   177,   178,   179,   180,   181,   182,   183,     0,
     184,   185,     0,   186,   187,   188,   189,   190,     0,     0,
       0,   191,     0,     0,   192,     0,   193,     0,     0,   194,
       0,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,     0,     0,   201,
     202,     0,   203,     0,     0,     0,   204,     0,   205,   206,
     207,   208,   209,     0,     0,     0,   210,     0,     0,   211,
     212,   213,     0,     0,     0,   214,     0,   215,   216,     0,
     217,   218,   219,     0,     0,   220,   221,     0,   222,   223,
     224,   225,   226,   227,     0,     0,   228,   229,   230,   231,
     232,     0,     0,   233,   234,     0,   235,   236,   237,     0,
       0,   238,     0,     0,     0,   239,   240,     0,   241,     0,
     242,     0,   243,   244,   245,   246,     0,   247,     0,   248,
       0,     0,     0,   249,   250,     0,   251,     0,     0,   252,
     253,     0,     0,     0,   254,   255,   256,   257,     0,     0,
     258,   259,   260,     0,     0,   261,     0,     0,     0,     0,
     262,   263,     0,     0,     0,   264,     0,     0,     0,   265,
     266,     0,   267,   268,     0,     0,     0,   269,     0,     0,
     270,   271,     0,     0,   272,     0,     0,   273,   274,     0,
       0,     0,     0,     0,   275,   276,     0,   277,     0,   278,
       0,   279,   280,     0,     0,     0,     0,     0,     0,     0,
     281,     0,   282,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,     0,
     299,   300,   301,     0,   302,   303,   304,   305,     0,   306,
     307,     0,     0,     0,     0,   308,   309,   310,   311,   312,
     313,     0,     0,   314,   315,     0,   316,     0,   317,     0,
     318,   319,   320,   321,   322,   323,   324,   325,   326,     0,
       0,   327,   328,     0,     0,   329,   330,   331,   332,     0,
       0,     0,   333,   334,     0,     0,     0,   335,     0,   336,
     337,   338,     0,   339,   340,   341,     0,   342,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   343,   344,   345,
       0,   346,   347,     0,   348,   349,   350,   351,   352,   353,
     354,   355,   356,   357,     0,     0,   358,   359,   360,     0,
     361,     0,   362,   363,   364,   365,   366,     0,   367,   368,
     369,     0,     0,   370,     0,     0,     0,   371,   372,   373,
     374,   375,     0,     0,   376,   377,   378,   379,   380,     0,
     381,   382,     0,   383,   384,   385,     0,     0,   386,     0,
     387,     0,   388,   389,     0,   390,   391,   392,     0,   393,
       0,     0,   394,   395,   396,   397,   398,   399,   400,   401,
     402,   403,   404,     0,   405,   406,     0,     0,     0,   407,
     408,   409,   410,     0,     0,     0,   411,     0,     0,     0,
     412,     0,   413,   414,   415,   416,     0,   417,   418,   419,
     420,   421,     0,     0,     0,     0,     0,   422,   423,   424,
       0,   425,   426,     0,   427,     0,     0,   428,     0,     0,
     429,   430,   431,   432,   433,   434,     0,     0,   435,   436,
       0,   437,   438,   439,   440,   441,   442,     0,     0,   443,
     444,   445,   446,     0,   447,   448,     0,     0,   449,   450,
     451,   452,     0,     0,   453,   454,     0,   455,   456,   457,
     458,     0,     0,     0,     0,     0,   459,   460,     0,     0,
       0,   461,   462,   463,   464,     0,   465,   466,     0,   467,
     468,     0,   469,   470,     0,     0,   471,     0,     0,   472,
       0,   473,     0,   474,   475,     0,     0,     0,     0,     0,
       0,   476,     0,     0,   477,     0,     0,     0,   478,   479,
     480,   481,   482,     0,     0,     0,     0,     0,     0,   483,
     484,     0,   485,   486,   487,     0,     0,   488,     0,   137,
       0,   138,   139,   140,   141,   142,     0,     0,   143,     0,
       0,     0,   144,     0,     0,   145,   768,   146,   147,   148,
     149,   150,   151,     0,   152,     0,     0,     0,   153,     0,
       0,     0,   154,     0,     0,   155,   156,   157,     0,   158,
       0,   159,   160,     0,     0,   161,     0,     0,   162,   163,
       0,   164,   165,     0,   166,     0,   167,   168,   169,   170,
     171,   172,     0,   173,   174,     0,   175,   176,   177,   178,
     179,   180,   181,   182,   183,     0,   184,   185,     0,   186,
     187,   188,   189,   190,     0,     0,     0,   191,     0,     0,
     192,     0,   193,     0,     0,   194,     0,     0,     0,   195,
     196,   197,     0,     0,   198,     0,     0,     0,     0,   199,
     200,     0,     0,     0,     0,   201,   202,     0,   203,     0,
       0,     0,   204,     0,   205,   206,   207,   208,   209,     0,
       0,     0,   210,     0,     0,   211,   212,   213,     0,     0,
       0,   214,     0,   215,   216,     0,   217,   218,   219,     0,
       0,   220,   221,     0,   222,   223,   224,   225,   226,   227,
       0,     0,   228,   229,   230,   231,   232,     0,     0,   233,
     234,     0,   235,   236,   237,     0,     0,   238,     0,     0,
       0,   239,   240,     0,   241,     0,   242,     0,   243,   244,
     245,   246,     0,   247,     0,   248,     0,     0,     0,   249,
     250,     0,   251,     0,     0,   252,   253,     0,     0,     0,
     254,   255,   256,   257,     0,     0,   258,   259,   260,     0,
       0,   261,     0,     0,     0,     0,   262,   263,     0,     0,
       0,   264,     0,     0,     0,   265,   266,     0,   267,   268,
       0,     0,     0,   269,     0,     0,   270,   271,     0,     0,
     272,     0,     0,   273,   274,     0,     0,     0,     0,     0,
     275,   276,     0,   277,     0,   278,     0,   279,   280,     0,
       0,     0,     0,     0,     0,     0,   281,     0,   282,   283,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,   296,   297,   298,     0,   299,   300,   301,     0,
     302,   303,   304,   305,     0,   306,   307,     0,     0,     0,
       0,   308,   309,   310,   311,   312,   313,     0,     0,   314,
     315,     0,   316,     0,   317,     0,   318,   319,   320,   321,
     322,   323,   324,   325,   326,     0,     0,   327,   328,     0,
       0,   329,   330,   331,   332,     0,     0,     0,   333,   334,
       0,     0,     0,   335,     0,   336,   337,   338,     0,   339,
     340,   341,     0,   342,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   343,   344,   345,     0,   346,   347,     0,
     348,   349,   350,   351,   352,   353,   354,   355,   356,   357,
       0,     0,   358,   359,   360,     0,   361,     0,   362,   363,
     364,   365,   366,     0,   367,   368,   369,     0,     0,   370,
       0,     0,     0,   371,   372,   373,   374,   375,     0,     0,
     376,   377,   378,   379,   380,     0,   381,   382,     0,   383,
     384,   385,     0,     0,   386,     0,   387,     0,   388,   389,
       0,   390,   391,   392,     0,   393,     0,     0,   394,   395,
     396,   397,   398,   399,   400,   401,   402,   403,   404,     0,
     405,   406,     0,     0,     0,   407,   408,   409,   410,     0,
       0,     0,   411,     0,     0,     0,   412,     0,   413,   414,
     415,   416,     0,   417,   418,   419,   420,   421,     0,     0,
       0,     0,     0,   422,   423,   424,     0,   425,   426,     0,
     427,     0,     0,   428,     0,     0,   429,   430,   431,   432,
     433,   434,     0,     0,   435,   436,     0,   437,   438,   439,
     440,   441,   442,     0,     0,   443,   444,   445,   446,     0,
     447,   448,     0,     0,   449,   450,   451,   452,     0,     0,
     453,   454,     0,   455,   456,   457,   458,     0,     0,     0,
       0,     0,   459,   460,     0,     0,     0,   461,   462,   463,
     464,     0,   465,   466,     0,   467,   468,     0,   469,   470,
       0,     0,   471,     0,     0,   472,     0,   473,     0,   474,
     475,     0,     0,     0,     0,     0,     0,   476,     0,     0,
     477,     0,     0,     0,   478,   479,   480,   481,   482,     0,
       0,     0,     0,     0,     0,   483,   484,     0,   485,   486,
     487,     0,     0,   488,     0,   137,     0,   138,   139,   140,
     141,   142,     0,     0,   143,     0,     0,     0,   144,     0,
       0,   145,  2592,   146,   147,   148,   149,   150,   151,     0,
     152,     0,     0,     0,   153,     0,     0,     0,   154,     0,
       0,   155,   156,   157,     0,   158,     0,   159,   160,     0,
       0,   161,     0,     0,   162,   163,     0,   164,   898,   899,
     166,     0,   167,   168,   169,   170,   171,   172,     0,   173,
     174,     0,   175,   176,   177,   178,   179,   180,   181,   182,
     183,     0,   184,   185,     0,   186,   187,   188,   189,   190,
       0,     0,     0,   191,     0,     0,   192,     0,   193,     0,
       0,   194,     0,     0,     0,   195,   196,   197,     0,     0,
     198,     0,     0,     0,     0,   199,   200,     0,     0,     0,
     900,   201,   202,     0,   203,     0,     0,     0,   204,     0,
     205,   206,   207,   208,   209,     0,     0,     0,   210,     0,
       0,   211,   212,   213,     0,     0,     0,   214,     0,   215,
     216,     0,   217,   218,   219,     0,     0,   220,   221,     0,
     222,   223,   224,   225,   226,   227,     0,     0,   228,   229,
     230,   231,   232,     0,     0,   233,   234,     0,   235,   236,
     237,     0,     0,   238,     0,     0,     0,   239,   240,     0,
     241,     0,   242,     0,   243,   244,   245,   246,     0,   901,
       0,   248,     0,     0,     0,   249,   250,     0,   251,     0,
       0,   252,   253,     0,     0,     0,   254,   255,   256,   257,
       0,     0,   258,   259,   260,     0,     0,   261,     0,     0,
       0,     0,   262,   263,     0,     0,     0,   264,     0,     0,
       0,   265,   266,     0,   267,   268,     0,     0,     0,   269,
       0,     0,   270,   271,     0,     0,   272,     0,     0,   273,
     274,     0,     0,     0,     0,     0,   275,   276,     0,   902,
       0,   278,     0,   279,   280,     0,     0,     0,     0,     0,
       0,     0,   281,     0,   282,   283,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,     0,   299,   300,   301,     0,   302,   303,   304,   305,
       0,   306,   307,     0,     0,     0,     0,   308,   309,   310,
     311,   312,   313,     0,     0,   314,   315,     0,   316,     0,
     317,     0,   318,   319,   320,   321,   322,   323,   903,   325,
     326,     0,     0,   327,   328,     0,     0,   329,   330,   331,
     332,     0,     0,     0,   333,   334,     0,     0,     0,   335,
       0,   336,   337,   338,     0,   339,   340,   341,     0,   342,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   343,
     344,   345,     0,   346,   347,     0,   348,   349,   904,   351,
     352,   353,   354,   355,   356,   357,     0,     0,   358,   359,
     360,     0,   361,     0,   362,   363,   364,   365,   366,     0,
     367,   368,   369,     0,     0,   370,     0,     0,     0,   371,
     372,   373,   374,   375,     0,     0,   376,   377,   378,   379,
     380,     0,   381,   382,     0,   383,   384,   385,     0,     0,
     386,     0,   387,     0,   388,   389,     0,   390,   391,   392,
       0,   393,     0,     0,   394,   395,   396,   397,   398,   399,
     400,   401,   402,   403,   404,     0,   405,   406,     0,     0,
       0,   407,   408,   905,   410,     0,     0,     0,   411,     0,
       0,     0,   412,     0,   413,   414,   415,   416,     0,   417,
     418,   419,   420,   421,     0,     0,     0,     0,     0,   422,
     423,   424,     0,   425,   426,     0,   427,     0,     0,   428,
       0,     0,   429,   430,   431,   432,   433,   434,     0,     0,
     435,   436,     0,   437,   438,   439,   440,   441,   442,     0,
       0,   443,   444,   445,   446,     0,   447,   448,     0,     0,
     449,   450,   451,   452,     0,     0,   453,   454,     0,   455,
     456,   457,   458,     0,     0,     0,     0,     0,   906,   460,
       0,     0,     0,   461,   462,   463,   464,     0,   465,   466,
       0,   467,   468,     0,   469,   470,     0,     0,   471,     0,
       0,   472,     0,   473,     0,   474,   475,     0,     0,     0,
       0,     0,     0,   476,     0,     0,   477,     0,     0,     0,
     478,   479,   480,   481,   482,     0,     0,     0,     0,     0,
       0,   483,   484,     0,   485,   486,   487,     0,     0,   488,
     137,     0,   138,   139,   140,   141,   142,     0,     0,   143,
       0,     0,     0,   144,     0,     0,   145,   907,   146,   147,
     148,   149,   150,   151,     0,   152,     0,     0,     0,   153,
       0,     0,     0,   154,     0,     0,   155,   156,   157,     0,
     158,     0,   159,   160,     0,     0,   161,     0,     0,   162,
     163,     0,   164,   165,     0,   166,     0,   167,   168,   169,
     170,   171,   172,     0,   173,   174,     0,   175,   176,   177,
     178,   179,   180,   181,   182,   183,     0,   184,   185,     0,
     186,   187,   188,   189,   190,     0,     0,     0,   191,     0,
       0,   192,     0,   193,     0,     0,   194,     0,     0,     0,
     195,   196,   197,     0,     0,   198,     0,     0,     0,     0,
     199,   200,     0,     0,     0,     0,   201,   202,     0,   203,
       0,     0,     0,   204,     0,   205,   206,   207,   208,   209,
       0,     0,     0,   210,     0,     0,   211,   212,   213,     0,
       0,     0,   214,     0,   215,   216,     0,   217,   218,   219,
       0,     0,   220,   221,     0,   222,   223,   224,   225,   226,
     227,     0,     0,   228,   229,   230,   231,   232,     0,     0,
     233,   234,     0,   235,   236,   237,     0,     0,   238,     0,
       0,     0,   239,   240,     0,   241,     0,   242,     0,   243,
     244,   245,   246,     0,   247,     0,   248,     0,     0,     0,
     249,   250,     0,   251,     0,     0,   252,   253,     0,     0,
       0,   254,   255,   256,   257,     0,     0,   258,   259,   260,
       0,     0,   261,     0,     0,     0,     0,   262,   263,     0,
       0,     0,   264,     0,     0,     0,   265,   266,     0,   267,
     268,     0,     0,     0,   269,     0,     0,   270,   271,     0,
       0,   272,     0,     0,   273,   274,   614,     0,     0,     0,
       0,   275,   276,     0,   277,     0,   278,     0,   279,   280,
       0,     0,     0,     0,     0,     0,     0,   281,     0,   282,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,     0,   299,   300,   301,
       0,   302,   303,   304,   305,     0,   306,   307,     0,     0,
       0,     0,   308,   309,   310,   311,   312,   313,     0,     0,
     314,   315,     0,   316,     0,   317,     0,   318,   319,   320,
     321,   322,   323,   324,   325,   326,     0,     0,   327,   328,
       0,     0,   329,   330,   331,   332,     0,     0,     0,   333,
     334,     0,     0,     0,   335,     0,   336,   337,   338,     0,
     339,   340,   341,     0,   342,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   343,   344,   345,     0,   346,   347,
       0,   348,   349,   350,   351,   352,   353,   354,   355,   356,
     357,     0,     0,   358,   359,   360,     0,   361,     0,   362,
     363,   364,   365,   366,     0,   367,   368,   369,     0,     0,
     370,     0,     0,     0,   371,   372,   373,   374,   375,     0,
       0,   376,   377,   378,   379,   380,     0,   381,   382,     0,
     383,   384,   385,     0,     0,   386,     0,   387,     0,   388,
     389,     0,   390,   391,   392,     0,   393,     0,     0,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
       0,   405,   406,     0,     0,     0,   407,   408,   409,   410,
       0,     0,     0,   411,     0,     0,     0,   412,     0,   413,
     414,   415,   416,     0,   417,   418,   419,   420,   421,     0,
       0,     0,     0,     0,   422,   423,   424,     0,   425,   426,
       0,   427,     0,     0,   428,     0,     0,   429,   430,   431,
     432,   433,   434,     0,     0,   435,   436,     0,   437,   438,
     439,   440,   441,   442,     0,     0,   443,   444,   445,   446,
       0,   447,   448,     0,     0,   449,   450,   451,   452,     0,
     134,   453,   454,     0,   455,   456,   457,   458,     0,     0,
       0,     0,     0,   459,   460,     0,     0,     0,   461,   462,
     463,   464,     0,   465,   466,     0,   467,   468,     0,   469,
     470,     0,     0,   471,     0,     0,   472,     0,   473,     0,
     474,   475,     0,     0,     0,     0,     0,     0,   476,     0,
       0,   477,     0,     0,     0,   478,   479,   480,   481,   482,
       0,     0,     0,     0,     0,     0,   483,   484,     0,   485,
     486,   487,     0,     0,   488,   137,     0,   138,   139,   140,
     141,   142,     0,     0,   143,     0,     0,     0,   144,     0,
       0,   145,  1372,   146,   147,   148,   149,   150,   151,     0,
     152,     0,     0,     0,   153,     0,     0,     0,   154,     0,
       0,   155,   156,   157,     0,   158,     0,   159,   160,     0,
       0,   161,     0,     0,   162,   163,     0,   164,   165,     0,
     166,     0,   167,   168,   169,   170,   171,   172,     0,   173,
     174,     0,   175,   176,   177,   178,   179,   180,   181,   182,
     183,     0,   184,   185,     0,   186,   187,   188,   189,   190,
       0,     0,     0,   191,     0,     0,   192,     0,   193,     0,
       0,   194,     0,     0,     0,   195,   196,   197,     0,     0,
     198,     0,     0,     0,     0,   199,   200,     0,     0,     0,
       0,   201,   202,     0,   203,     0,     0,     0,   204,     0,
     205,   206,   207,   208,   209,     0,     0,     0,   210,     0,
       0,   211,   212,   213,     0,     0,     0,   214,     0,   215,
     216,     0,   217,   218,   219,     0,     0,   220,   221,     0,
     222,   223,   224,   225,   226,   227,     0,     0,   228,   229,
     230,   231,   232,     0,     0,   233,   234,     0,   235,   236,
     237,     0,     0,   238,     0,     0,     0,   239,   240,     0,
     241,     0,   242,     0,   243,   244,   245,   246,     0,   247,
       0,   248,     0,     0,     0,   249,   250,     0,   251,     0,
       0,   252,   253,     0,     0,     0,   254,   255,   256,   257,
       0,     0,   258,   259,   260,     0,     0,   261,     0,     0,
       0,     0,   262,   263,     0,     0,     0,   264,     0,     0,
       0,   265,   266,     0,   267,   268,     0,     0,     0,   269,
       0,     0,   270,   271,     0,     0,   272,     0,     0,   273,
     274,   614,     0,     0,     0,     0,   275,   276,     0,   277,
       0,   278,     0,   279,   280,     0,     0,     0,     0,     0,
       0,     0,   281,     0,   282,   283,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,     0,   299,   300,   301,     0,   302,   303,   304,   305,
       0,   306,   307,     0,     0,     0,     0,   308,   309,   310,
     311,   312,   313,     0,     0,   314,   315,     0,   316,     0,
     317,     0,   318,   319,   320,   321,   322,   323,   324,   325,
     326,     0,     0,   327,   328,     0,     0,   329,   330,   331,
     332,     0,     0,     0,   333,   334,     0,     0,     0,   335,
       0,   336,   337,   338,     0,   339,   340,   341,     0,   342,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   343,
     344,   345,     0,   346,   347,     0,   348,   349,   350,   351,
     352,   353,   354,   355,   356,   357,     0,     0,   358,   359,
     360,     0,   361,     0,   362,   363,   364,   365,   366,     0,
     367,   368,   369,     0,     0,   370,     0,     0,     0,   371,
     372,   373,   374,   375,     0,     0,   376,   377,   378,   379,
     380,     0,   381,   382,     0,   383,   384,   385,     0,     0,
     386,     0,   387,     0,   388,   389,     0,   390,   391,   392,
       0,   393,     0,     0,   394,   395,   396,   397,   398,   399,
     400,   401,   402,   403,   404,     0,   405,   406,     0,     0,
       0,   407,   408,   409,   410,     0,     0,     0,   411,     0,
       0,     0,   412,     0,   413,   414,   415,   416,     0,   417,
     418,   419,   420,   421,     0,     0,     0,     0,     0,   422,
     423,   424,     0,   425,   426,     0,   427,     0,     0,   428,
       0,     0,   429,   430,   431,   432,   433,   434,     0,     0,
     435,   436,     0,   437,   438,   439,   440,   441,   442,     0,
       0,   443,   444,   445,   446,     0,   447,   448,     0,     0,
     449,   450,   451,   452,     0,   134,   453,   454,     0,   455,
     456,   457,   458,     0,     0,     0,     0,     0,   459,   460,
       0,     0,     0,   461,   462,   463,   464,     0,   465,   466,
       0,   467,   468,     0,   469,   470,     0,     0,   471,     0,
       0,   472,     0,   473,     0,   474,   475,     0,     0,     0,
       0,     0,     0,   476,     0,     0,   477,     0,     0,     0,
     478,   479,   480,   481,   482,     0,     0,     0,     0,     0,
       0,   483,   484,     0,   485,   486,   487,     0,     0,   488,
     137,     0,   138,   139,   140,   141,   142,     0,     0,   143,
       0,     0,     0,   144,     0,     0,   145,  1708,   146,   147,
     148,   149,   150,   151,     0,   152,     0,     0,     0,   153,
       0,     0,     0,   154,     0,     0,   155,   156,   157,     0,
     158,     0,   159,   160,     0,     0,   161,     0,     0,   162,
     163,     0,   164,   898,   899,   166,     0,   167,   168,   169,
     170,   171,   172,     0,   173,   174,     0,   175,   176,   177,
     178,   179,   180,   181,   182,   183,     0,   184,   185,     0,
     186,   187,   188,   189,   190,     0,     0,     0,   191,     0,
       0,   192,     0,   193,     0,     0,   194,     0,     0,     0,
     195,   196,   197,     0,     0,   198,     0,     0,     0,     0,
     199,   200,     0,     0,     0,   900,   201,   202,     0,   203,
       0,     0,     0,   204,     0,   205,   206,   207,   208,   209,
       0,     0,     0,   210,     0,     0,   211,   212,   213,     0,
       0,     0,   214,     0,   215,   216,     0,   217,   218,   219,
       0,     0,   220,   221,     0,   222,   223,   224,   225,   226,
     227,     0,     0,   228,   229,   230,   231,   232,     0,     0,
     233,   234,     0,   235,   236,   237,     0,     0,   238,     0,
       0,     0,   239,   240,     0,   241,     0,   242,     0,   243,
     244,   245,   246,     0,   901,     0,   248,     0,     0,     0,
     249,   250,     0,   251,     0,     0,   252,   253,     0,     0,
       0,   254,   255,   256,   257,     0,     0,   258,   259,   260,
       0,     0,   261,     0,     0,     0,     0,   262,   263,     0,
       0,     0,   264,     0,     0,     0,   265,   266,     0,   267,
     268,     0,     0,     0,   269,     0,     0,   270,   271,     0,
       0,   272,     0,     0,   273,   274,     0,     0,     0,     0,
       0,   275,   276,     0,   902,     0,   278,     0,   279,   280,
       0,     0,     0,     0,     0,     0,     0,   281,     0,   282,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,     0,   299,   300,   301,
       0,   302,   303,   304,   305,     0,   306,   307,     0,     0,
       0,     0,   308,   309,   310,   311,   312,   313,     0,     0,
     314,   315,     0,   316,     0,   317,     0,   318,   319,   320,
     321,   322,   323,   903,   325,   326,     0,     0,   327,   328,
       0,     0,   329,   330,   331,   332,     0,     0,     0,   333,
     334,     0,     0,     0,   335,     0,   336,   337,   338,     0,
     339,   340,   341,     0,   342,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   343,   344,   345,     0,   346,   347,
       0,   348,   349,   904,   351,   352,   353,   354,   355,   356,
     357,     0,     0,   358,   359,   360,     0,   361,     0,   362,
     363,   364,   365,   366,     0,   367,   368,   369,     0,     0,
     370,     0,     0,     0,   371,   372,   373,   374,   375,     0,
       0,   376,   377,   378,   379,   380,     0,   381,   382,     0,
     383,   384,   385,     0,     0,   386,     0,   387,     0,   388,
     389,     0,   390,   391,   392,     0,   393,     0,     0,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
       0,   405,   406,     0,     0,     0,   407,   408,   905,   410,
       0,     0,     0,   411,     0,     0,     0,   412,     0,   413,
     414,   415,   416,     0,   417,   418,   419,   420,   421,     0,
       0,     0,     0,     0,   422,   423,   424,     0,   425,   426,
       0,   427,     0,     0,   428,     0,     0,   429,   430,   431,
     432,   433,   434,     0,     0,   435,   436,     0,   437,   438,
     439,   440,   441,   442,     0,     0,   443,   444,   445,   446,
       0,   447,   448,     0,     0,   449,   450,   451,   452,     0,
       0,   453,   454,     0,   455,   456,   457,   458,     0,     0,
       0,     0,     0,   459,   460,     0,     0,     0,   461,   462,
     463,   464,     0,   465,   466,     0,   467,   468,     0,   469,
     470,     0,     0,   471,     0,     0,   472,     0,   473,     0,
     474,   475,     0,     0,     0,     0,     0,     0,   476,     0,
       0,   477,     0,     0,     0,   478,   479,   480,   481,   482,
       0,     0,     0,     0,     0,     0,   483,   484,     0,   485,
     486,   487,     0,     0,   488,   137,     0,   138,   139,   140,
     141,   142,     0,     0,   143,     0,     0,     0,   144,     0,
       0,   145,   907,   146,   147,   148,   149,   150,   151,     0,
     152,     0,     0,     0,   153,     0,     0,     0,   154,     0,
       0,   155,   156,   157,     0,   158,     0,   159,   160,     0,
       0,   161,     0,     0,   162,   163,     0,   164,   165,     0,
     166,     0,   167,   168,   169,   170,   171,   172,     0,   173,
     174,     0,   175,   176,   177,   178,   179,   180,   181,   182,
     183,     0,   184,   185,     0,   186,   187,   188,   189,   190,
       0,     0,     0,   191,     0,     0,   192,     0,   193,     0,
       0,   194,     0,     0,     0,   195,   196,   197,     0,     0,
     198,     0,     0,     0,     0,   199,   200,     0,     0,     0,
       0,   201,   202,     0,   203,     0,     0,     0,   204,     0,
     205,   206,   207,   208,   209,     0,     0,     0,   210,     0,
       0,   211,   212,   213,     0,     0,     0,   214,     0,   215,
     216,     0,   217,   218,   219,     0,     0,   220,   221,     0,
     222,   223,   224,   225,   226,   227,     0,     0,   228,   229,
     230,   231,   232,     0,     0,   233,   234,     0,   235,   236,
     237,     0,     0,   238,     0,     0,     0,   239,   240,     0,
     241,     0,   242,     0,   243,   244,   245,   246,     0,   247,
       0,   248,     0,     0,     0,   249,   250,     0,   251,     0,
       0,   252,   253,     0,     0,     0,   254,   255,   256,   257,
       0,     0,   258,   259,   260,     0,     0,   261,     0,     0,
       0,     0,   262,   263,     0,     0,     0,   264,     0,     0,
       0,   265,   266,     0,   267,   268,     0,     0,     0,   269,
       0,     0,   270,   271,     0,     0,   272,     0,     0,   273,
     274,   614,     0,     0,     0,     0,   275,   276,     0,   277,
       0,   278,     0,   279,   280,     0,     0,     0,     0,     0,
       0,     0,   281,     0,   282,   283,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,     0,   299,   300,   301,     0,   302,   303,   304,   305,
       0,   306,   307,     0,     0,     0,     0,   308,   309,   310,
     311,   312,   313,     0,     0,   314,   315,     0,   316,     0,
     317,     0,   318,   319,   320,   321,   322,   323,   324,   325,
     326,     0,     0,   327,   328,     0,     0,   329,   330,   331,
     332,     0,     0,     0,   333,   334,     0,     0,     0,   335,
       0,   336,   337,   338,     0,   339,   340,   341,     0,   342,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   343,
     344,   345,     0,   346,   347,     0,   348,   349,   350,   351,
     352,   353,   354,   355,   356,   357,     0,     0,   358,   359,
     360,     0,   361,     0,   362,   363,   364,   365,   366,     0,
     367,   368,   369,     0,     0,   370,     0,     0,     0,   371,
     372,   373,   374,   375,     0,     0,   376,   377,   378,   379,
     380,     0,   381,   382,     0,   383,   384,   385,     0,     0,
     386,     0,   387,     0,   388,   389,     0,   390,   391,   392,
       0,   393,     0,     0,   394,   395,   396,   397,   398,   399,
     400,   401,   402,   403,   404,     0,   405,   406,     0,     0,
       0,   407,   408,   409,   410,     0,     0,     0,   411,     0,
       0,     0,   412,     0,   413,   414,   415,   416,     0,   417,
     418,   419,   420,   421,     0,     0,     0,     0,     0,   422,
     423,   424,     0,   425,   426,     0,   427,     0,     0,   428,
       0,     0,   429,   430,   431,   432,   433,   434,     0,     0,
     435,   436,     0,   437,   438,   439,   440,   441,   442,     0,
       0,   443,   444,   445,   446,     0,   447,   448,     0,     0,
     449,   450,   451,   452,     0,   134,   453,   454,     0,   455,
     456,   457,   458,     0,     0,     0,     0,     0,   459,   460,
       0,     0,     0,   461,   462,   463,   464,     0,   465,   466,
       0,   467,   468,     0,   469,   470,     0,     0,   471,     0,
       0,   472,     0,   473,     0,   474,   475,     0,     0,     0,
       0,     0,     0,   476,     0,     0,   477,     0,     0,     0,
     478,   479,   480,   481,   482,     0,     0,     0,     0,     0,
       0,   483,   484,     0,   485,   486,   487,     0,     0,   488,
     137,     0,   138,   139,   140,   141,   142,     0,     0,   143,
       0,     0,     0,   144,     0,     0,   145,  3547,   146,   147,
     148,   149,   150,   151,     0,   152,     0,     0,     0,   153,
       0,     0,     0,   154,     0,     0,   155,   156,   157,     0,
     158,     0,   159,   160,     0,     0,   161,     0,     0,   162,
     163,     0,   164,   165,     0,   166,     0,   167,   168,   169,
     170,   171,   172,     0,   173,   174,     0,   175,   176,   177,
     178,   179,   180,   181,   182,   183,  1263,   184,   185,     0,
     186,   187,   188,   189,   190,     0,     0,     0,   191,     0,
       0,   192,     0,   193,     0,     0,   194,     0,     0,     0,
     195,   196,   197,     0,     0,   198,     0,     0,     0,     0,
     199,   200,     0,     0,     0,     0,   201,   202,     0,   203,
       0,     0,     0,   204,     0,   205,   206,   207,   208,   209,
       0,     0,     0,   210,     0,     0,   211,   212,   213,     0,
       0,     0,   214,     0,   215,   216,     0,   217,   218,   219,
       0,     0,   220,   221,     0,   222,   223,   224,   225,   226,
     227,     0,     0,   228,   229,   230,   231,   232,     0,     0,
     233,   234,     0,   235,   236,   237,     0,     0,   238,     0,
       0,     0,   239,   240,     0,   241,     0,   242,     0,   243,
     244,   245,   246,     0,   247,     0,   248,     0,     0,     0,
     249,   250,     0,   251,     0,     0,   252,   253,     0,     0,
       0,   254,   255,   256,   257,     0,     0,   258,   259,   260,
       0,     0,   261,     0,     0,     0,     0,   262,   263,     0,
       0,     0,   264,     0,     0,     0,   265,   266,     0,   267,
     268,     0,     0,     0,   269,     0,     0,   270,   271,     0,
       0,   272,     0,     0,   273,   274,     0,     0,     0,     0,
       0,   275,   276,     0,   277,     0,   278,     0,   279,   280,
       0,     0,     0,     0,     0,     0,     0,   281,     0,   282,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,     0,   299,   300,   301,
       0,   302,   303,   304,   305,     0,   306,   307,     0,     0,
       0,     0,   308,   309,   310,   311,   312,   313,     0,     0,
     314,   315,     0,   316,     0,   317,     0,   318,   319,   320,
     321,   322,   323,   324,   325,   326,     0,     0,   327,   328,
       0,     0,   329,   330,   331,   332,     0,     0,     0,   333,
     334,     0,     0,     0,   335,     0,   336,   337,   338,     0,
     339,   340,   341,     0,   342,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   343,   344,   345,     0,   346,   347,
       0,   348,   349,   350,   351,   352,   353,   354,   355,   356,
     357,     0,     0,   358,   359,   360,     0,   361,     0,   362,
     363,   364,   365,   366,     0,   367,   368,   369,     0,     0,
     370,     0,     0,     0,   371,   372,   373,   374,   375,     0,
       0,   376,   377,   378,   379,   380,     0,   381,   382,     0,
     383,   384,   385,     0,     0,   386,     0,   387,     0,   388,
     389,     0,   390,   391,   392,     0,   393,     0,     0,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
       0,   405,   406,     0,     0,     0,   407,   408,   409,   410,
       0,     0,     0,   411,     0,     0,     0,   412,     0,   413,
     414,   415,   416,     0,   417,   418,   419,   420,   421,     0,
       0,     0,     0,     0,   422,   423,   424,     0,   425,   426,
       0,   427,     0,     0,   428,     0,     0,   429,   430,   431,
     432,   433,   434,     0,     0,   435,   436,     0,   437,   438,
     439,   440,   441,   442,     0,     0,   443,   444,   445,   446,
       0,   447,   448,     0,     0,   449,   450,   451,   452,     0,
       0,   453,   454,     0,   455,   456,   457,   458,     0,     0,
       0,     0,     0,   459,   460,     0,     0,     0,   461,   462,
     463,   464,     0,   465,   466,     0,   467,   468,     0,   469,
     470,     0,     0,   471,     0,     0,   472,     0,   473,     0,
     474,   475,     0,     0,     0,     0,     0,     0,   476,     0,
       0,   477,     0,     0,     0,   478,   479,   480,   481,   482,
       0,     0,     0,     0,     0,     0,   483,   484,     0,   485,
     486,   487,     0,     0,   488,   137,     0,   138,   139,   140,
     141,   142,     0,     0,   143,     0,     0,     0,   144,     0,
       0,   145,  1264,   146,   147,   148,   149,   150,   151,     0,
     152,     0,     0,     0,   153,     0,     0,     0,   154,     0,
       0,   155,   156,   157,     0,   158,     0,   159,   160,     0,
       0,   161,     0,     0,   162,   163,     0,   164,   165,     0,
     166,     0,   167,   168,   169,   170,   171,   172,     0,   173,
     174,     0,   175,   176,   177,   178,   179,   180,   181,   182,
     183,     0,   184,   185,     0,   186,   187,   188,   189,   190,
       0,     0,     0,   191,     0,     0,   192,     0,   193,     0,
       0,   194,     0,     0,     0,   195,   196,   197,     0,     0,
     198,     0,     0,     0,     0,   199,   200,     0,     0,     0,
       0,   201,   202,     0,   203,     0,     0,     0,   204,     0,
     205,   206,   207,   208,   209,     0,     0,     0,   210,     0,
       0,   211,   212,   213,     0,     0,     0,   214,     0,   215,
     216,     0,   217,   218,   219,     0,     0,   220,   221,     0,
     222,   223,   224,   225,   226,   227,     0,     0,   228,   229,
     230,   231,   232,     0,     0,   233,   234,     0,   235,   236,
     237,     0,     0,   238,     0,     0,     0,   239,   240,     0,
     241,     0,   242,     0,   243,   244,   245,   246,     0,   247,
       0,   248,     0,     0,     0,   249,   250,     0,   251,     0,
       0,   252,   253,     0,     0,     0,   254,   255,   256,   257,
       0,     0,   258,   259,   260,     0,     0,   261,     0,     0,
       0,     0,   262,   263,     0,     0,     0,   264,     0,     0,
       0,   265,   266,     0,   267,   268,     0,     0,     0,   269,
       0,     0,   270,   271,     0,     0,   272,     0,     0,   273,
     274,     0,     0,     0,     0,     0,   275,   276,     0,   277,
       0,   278,     0,   279,   280,     0,     0,     0,     0,     0,
       0,     0,   281,     0,   282,   283,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,     0,   299,   300,   301,     0,   302,   303,   304,   305,
       0,   306,   307,     0,     0,     0,     0,   308,   309,   310,
     311,   312,   313,     0,     0,   314,   315,     0,   316,     0,
     317,     0,   318,   319,   320,   321,   322,   323,   324,   325,
     326,     0,     0,   327,   328,     0,     0,   329,   330,   331,
     332,     0,     0,     0,   333,   334,     0,     0,     0,   335,
       0,   336,   337,   338,     0,   339,   340,   341,     0,   342,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   343,
     344,   345,     0,   346,   347,     0,   348,   349,   350,   351,
     352,   353,   354,   355,   356,   357,     0,     0,   358,   359,
     360,     0,   361,     0,   362,   363,   364,   365,   366,     0,
     367,   368,   369,     0,     0,   370,     0,     0,     0,   371,
     372,   373,   374,   375,     0,     0,   376,   377,   378,   379,
     380,     0,   381,   382,     0,   383,   384,   385,     0,     0,
     386,     0,   387,     0,   388,   389,     0,   390,   391,   392,
       0,   393,     0,     0,   394,   395,   396,   397,   398,   399,
     400,   401,   402,   403,   404,     0,   405,   406,     0,     0,
       0,   407,   408,   409,   410,     0,     0,     0,   411,     0,
       0,     0,   412,     0,   413,   414,   415,   416,     0,   417,
     418,   419,   420,   421,     0,     0,     0,     0,     0,   422,
     423,   424,     0,   425,   426,     0,   427,     0,     0,   428,
       0,     0,   429,   430,   431,   432,   433,   434,     0,     0,
     435,   436,     0,   437,   438,   439,   440,   441,   442,     0,
       0,   443,   444,   445,   446,     0,   447,   448,     0,     0,
     449,   450,   451,   452,     0,     0,   453,   454,     0,   455,
     456,   457,   458,     0,     0,     0,     0,     0,   459,   460,
       0,     0,     0,   461,   462,   463,   464,     0,   465,   466,
       0,   467,   468,     0,   469,   470,     0,     0,   471,     0,
       0,   472,     0,   473,     0,   474,   475,     0,     0,     0,
       0,     0,     0,   476,     0,     0,   477,     0,     0,     0,
     478,   479,   480,   481,   482,     0,     0,     0,     0,     0,
       0,   483,   484,     0,   485,   486,   487,     0,     0,   488,
     137,     0,   138,   139,   140,   141,   142,     0,     0,   143,
       0,     0,     0,   144,     0,     0,     0,  1264,   146,   147,
     148,   149,   150,     0,     0,  -366,     0,     0,     0,   153,
       0,     0,     0,   154,     0,     0,   155,   156,   157,     0,
     158,     0,     0,     0,     0,     0,   161,  3969,     0,   162,
     163,     0,   164,     0,     0,     0,     0,   167,   168,   169,
    3970,   171,   172,     0,   173,   174,     0,   175,   176,     0,
     178,     0,   180,   181,   182,   183,     0,   184,   185,     0,
     186,   187,   188,     0,   190,     0,     0,     0,   191,     0,
       0,   192,     0,   193,     0,     0,   194,     0,     0,     0,
     195,   196,   197,     0,     0,   198,     0,     0,     0,     0,
     199,     0,     0,     0,     0,     0,   201,   202,     0,   203,
       0,     0,     0,   204,     0,   205,   206,   207,   208,   209,
       0,     0,     0,     0,     0,     0,   211,   212,   213,     0,
       0,     0,   214,     0,     0,   216,     0,   217,   218,   219,
       0,     0,   220,   221,     0,   222,   223,   224,   225,   226,
       0,     0,     0,   228,   229,   230,   231,   232,     0,     0,
     233,   234,  3971,   235,   236,   237,     0,     0,     0,     0,
       0,     0,     0,   240,     0,   241,     0,   242,     0,   243,
     244,   245,   246,     0,   247,     0,   248,     0,     0,     0,
       0,   250,     0,     0,     0,     0,     0,   253,     0,     0,
       0,   254,   255,   256,   257,  3972,     0,   258,   259,   260,
       0,     0,   261,     0,     0,     0,     0,   262,     0,     0,
       0,     0,   264,     0,     0,     0,   265,   266,     0,   267,
     268,  3973,     0,     0,   269,     0,     0,     0,   271,     0,
       0,   272,  3974,     0,   273,   274,     0,     0,     0,     0,
       0,   275,   276,     0,   277,     0,   278,     0,   279,   280,
       0,     0,     0,     0,  -321,     0,     0,   281,     0,   282,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,     0,   299,   300,   301,
       0,   302,   303,   304,   305,     0,   306,   307,     0,     0,
       0,     0,   308,   309,   310,   311,   312,   313,     0,     0,
     314,   315,     0,   316,     0,   317,     0,   318,   319,   320,
     321,   322,   323,   324,   325,   326,     0,     0,   327,   328,
       0,     0,   329,   330,   331,   332,     0,     0,     0,     0,
     334,     0,     0,     0,   335,     0,   336,   337,   338,     0,
     339,   340,  3975,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   344,   345,     0,     0,   347,
       0,   348,   349,   350,   351,   352,   353,   354,   355,   356,
       0,     0,     0,     0,   359,   360,     0,   361,     0,   362,
     363,   364,   365,   366,     0,   367,   368,   369,     0,     0,
     370,     0,     0,     0,   371,   372,   373,   374,   375,     0,
       0,   376,   377,   378,   379,   380,     0,   381,     0,     0,
     383,     0,   385,  -321,     0,   386,     0,     0,     0,   388,
       0,     0,   390,   391,   392,  3976,   393,     0,     0,     0,
     395,   396,   397,   398,   399,   400,   401,     0,   403,   404,
       0,   405,     0,     0,     0,     0,   407,   408,   409,     0,
       0,     0,     0,   411,     0,     0,     0,   412,     0,     0,
     414,     0,   416,     0,   417,     0,     0,   420,   421,     0,
       0,     0,     0,     0,   422,   423,   424,     0,   425,   426,
       0,   427,     0,     0,   428,     0,     0,   429,     0,   431,
     432,   433,   434,     0,     0,     0,   436,     0,   437,   438,
     439,   440,   441,   442,     0,     0,   443,   444,   445,   446,
       0,   447,   448,     0,     0,   449,   450,   451,   452,     0,
       0,   453,   454,     0,   455,   456,   457,   458,     0,     0,
       0,     0,     0,   459,   460,     0,     0,     0,     0,   462,
     463,   464,     0,   465,   466,     0,   467,   468,     0,     0,
       0,     0,     0,   471,     0,     0,   472,     0,     0,     0,
     474,   475,     0,     0,     0,     0,     0,     0,   476,     0,
       0,   477,     0,     0,     0,   478,   479,   480,   481,   482,
       0,     0,  -321,     0,     0,     0,   483,     0,     0,   485,
       0,   487,     0,   137,   488,   138,   139,   140,   141,   142,
       0,     0,   143,     0,     0,     0,   144,  4492,     0,   145,
       0,   146,   147,   148,   149,   150,   151,     0,   152,     0,
       0,     0,   153,     0,     0,     0,   154,     0,     0,   155,
     156,   157,     0,   158,     0,   159,   160,     0,     0,   161,
       0,     0,   162,   163,     0,   164,   165,     0,   166,     0,
     167,   168,   169,   170,   171,   172,     0,   173,   174,     0,
     175,   176,   177,   178,   179,   180,   181,   182,   183,     0,
     184,   185,     0,   186,   187,   188,   189,   190,     0,     0,
       0,   191,     0,     0,   192,     0,   193,     0,     0,   194,
       0,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,     0,     0,   201,
     202,     0,   203,     0,     0,     0,   204,     0,   205,   206,
     207,   208,   209,     0,     0,     0,   210,     0,     0,   211,
     212,   213,     0,     0,     0,   214,     0,   215,   216,     0,
     217,   218,   219,     0,     0,   220,   221,     0,   222,   223,
     224,   225,   226,   227,     0,     0,   228,   229,   230,   231,
     232,     0,     0,   233,   234,     0,   235,   236,   237,     0,
       0,   238,     0,     0,     0,   239,   240,     0,   241,     0,
     242,     0,   243,   244,   245,   246,     0,   247,     0,   248,
       0,     0,     0,   249,   250,     0,   251,     0,     0,   252,
     253,     0,     0,     0,   254,   255,   256,   257,     0,     0,
     258,   259,   260,     0,     0,   261,     0,     0,     0,     0,
     262,   263,     0,     0,     0,   264,     0,     0,     0,   265,
     266,     0,   267,   268,     0,     0,     0,   269,     0,     0,
     270,   271,     0,     0,   272,     0,     0,   273,   274,     0,
       0,     0,     0,     0,   275,   276,     0,   277,     0,   278,
       0,   279,   280,     0,     0,     0,     0,     0,     0,     0,
     281,     0,   282,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,     0,
     299,   300,   301,     0,   302,   303,   304,   305,     0,   306,
     307,     0,     0,     0,     0,   308,   309,   310,   311,   312,
     313,     0,     0,   314,   315,     0,   316,     0,   317,     0,
     318,   319,   320,   321,   322,   323,   324,   325,   326,     0,
       0,   327,   328,     0,     0,   329,   330,   331,   332,     0,
       0,     0,   333,   334,     0,     0,     0,   335,     0,   336,
     337,   338,     0,   339,   340,   341,     0,   342,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   343,   344,   345,
       0,   346,   347,     0,   348,   349,   350,   351,   352,   353,
     354,   355,   356,   357,     0,     0,   358,   359,   360,     0,
     361,     0,   362,   363,   364,   365,   366,     0,   367,   368,
     369,     0,     0,   370,     0,     0,     0,   371,   372,   373,
     374,   375,     0,     0,   376,   377,   378,   379,   380,     0,
     381,   382,     0,   383,   384,   385,     0,     0,   386,     0,
     387,     0,   388,   389,     0,   390,   391,   392,     0,   393,
       0,     0,   394,   395,   396,   397,   398,   399,   400,   401,
     402,   403,   404,     0,   405,   406,     0,     0,     0,   407,
     408,   409,   410,     0,     0,     0,   411,     0,     0,     0,
     412,     0,   413,   414,   415,   416,     0,   417,   418,   419,
     420,   421,     0,     0,     0,     0,     0,   422,   423,   424,
       0,   425,   426,     0,   427,     0,     0,   428,     0,     0,
     429,   430,   431,   432,   433,   434,     0,     0,   435,   436,
       0,   437,   438,   439,   440,   441,   442,     0,     0,   443,
     444,   445,   446,     0,   447,   448,     0,     0,   449,   450,
     451,   452,     0,     0,   453,   454,     0,   455,   456,   457,
     458,     0,     0,     0,     0,     0,   459,   460,     0,     0,
       0,   461,   462,   463,   464,     0,   465,   466,     0,   467,
     468,     0,   469,   470,     0,     0,   471,     0,     0,   472,
       0,   473,     0,   474,   475,     0,     0,     0,     0,     0,
       0,   476,     0,     0,   477,     0,     0,     0,   478,   479,
     480,   481,   482,     0,     0,     0,     0,     0,     0,   483,
     484,     0,   485,   486,   487,     0,   137,   488,   138,   139,
     140,   141,   142,  2154,     0,   143,     0,     0,     0,   144,
       0,     0,   145,     0,   146,   147,   148,   149,   150,   151,
       0,   152,     0,     0,     0,   153,     0,     0,     0,   154,
       0,     0,   155,   156,   157,     0,   158,     0,   159,   160,
       0,     0,   161,     0,     0,   162,   163,     0,   164,   165,
       0,   166,     0,   167,   168,   169,   170,   171,   172,     0,
     173,   174,     0,   175,   176,   177,   178,   179,   180,   181,
     182,   183,     0,   184,   185,     0,   186,   187,   188,   189,
     190,     0,     0,     0,   191,     0,     0,   192,     0,   193,
       0,     0,   194,     0,     0,     0,   195,   196,   197,     0,
       0,   198,     0,     0,     0,     0,   199,   200,     0,     0,
       0,     0,   201,   202,     0,   203,     0,     0,     0,   204,
       0,   205,   206,   207,   208,   209,     0,     0,     0,   210,
       0,     0,   211,   212,   213,     0,     0,     0,   214,     0,
     215,   216,     0,   217,   218,   219,     0,     0,   220,   221,
       0,   222,   223,   224,   225,   226,   227,     0,     0,   228,
     229,   230,   231,   232,     0,     0,   233,   234,     0,   235,
     236,   237,     0,     0,   238,     0,     0,     0,   239,   240,
       0,   241,     0,   242,     0,   243,   244,   245,   246,     0,
     247,     0,   248,     0,     0,     0,   249,   250,     0,   251,
       0,     0,   252,   253,     0,     0,     0,   254,   255,   256,
     257,     0,     0,   258,   259,   260,     0,     0,   261,     0,
       0,     0,     0,   262,   263,     0,     0,     0,   264,     0,
       0,     0,   265,   266,     0,   267,   268,     0,     0,     0,
     269,     0,     0,   270,   271,     0,     0,   272,     0,     0,
     273,   274,     0,     0,     0,     0,     0,   275,   276,     0,
     277,     0,   278,     0,   279,   280,     0,     0,     0,     0,
       0,     0,     0,   281,     0,   282,   283,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,     0,   299,   300,   301,     0,   302,   303,   304,
     305,     0,   306,   307,     0,     0,     0,     0,   308,   309,
     310,   311,   312,   313,     0,     0,   314,   315,     0,   316,
       0,   317,     0,   318,   319,   320,   321,   322,   323,   324,
     325,   326,     0,     0,   327,   328,     0,     0,   329,   330,
     331,   332,     0,     0,     0,   333,   334,     0,     0,     0,
     335,     0,   336,   337,   338,     0,   339,   340,   341,     0,
     342,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     343,   344,   345,     0,   346,   347,     0,   348,   349,   350,
     351,   352,   353,   354,   355,   356,   357,     0,     0,   358,
     359,   360,     0,   361,     0,   362,   363,   364,   365,   366,
       0,   367,   368,   369,     0,     0,   370,     0,     0,     0,
     371,   372,   373,   374,   375,     0,     0,   376,   377,   378,
     379,   380,     0,   381,   382,     0,   383,   384,   385,     0,
       0,   386,     0,   387,     0,   388,   389,     0,   390,   391,
     392,     0,   393,     0,     0,   394,   395,   396,   397,   398,
     399,   400,   401,   402,   403,   404,     0,   405,   406,     0,
       0,     0,   407,   408,   409,   410,     0,     0,     0,   411,
       0,     0,     0,   412,     0,   413,   414,   415,   416,     0,
     417,   418,   419,   420,   421,     0,     0,     0,     0,     0,
     422,   423,   424,     0,   425,   426,     0,   427,     0,     0,
     428,     0,     0,   429,   430,   431,   432,   433,   434,     0,
       0,   435,   436,     0,   437,   438,   439,   440,   441,   442,
       0,     0,   443,   444,   445,   446,     0,   447,   448,     0,
       0,   449,   450,   451,   452,     0,     0,   453,   454,     0,
     455,   456,   457,   458,     0,     0,     0,     0,     0,   459,
     460,     0,     0,     0,   461,   462,   463,   464,     0,   465,
     466,     0,   467,   468,     0,   469,   470,     0,     0,   471,
       0,     0,   472,     0,   473,     0,   474,   475,     0,     0,
       0,     0,     0,     0,   476,     0,     0,   477,     0,     0,
       0,   478,   479,   480,   481,   482,     0,     0,     0,     0,
       0,     0,   483,   484,     0,   485,   486,   487,     0,   137,
     488,   138,   139,   140,   141,   142,  2867,     0,   143,     0,
       0,     0,   144,     0,     0,   145,     0,   146,   147,   148,
     149,   150,   151,     0,   152,     0,     0,     0,   153,     0,
       0,     0,   154,     0,     0,   155,   156,   157,     0,   158,
       0,   159,   160,     0,     0,   161,     0,     0,   162,   163,
       0,   164,   165,     0,   166,     0,   167,   168,   169,   170,
     171,   172,     0,   173,   174,     0,   175,   176,   177,   178,
     179,   180,   181,   182,   183,     0,   184,   185,     0,   186,
     187,   188,   189,   190,     0,     0,     0,   191,     0,     0,
     192,     0,   193,     0,     0,   194,     0,     0,     0,   195,
     196,   197,     0,     0,   198,     0,     0,     0,     0,   199,
     200,     0,     0,     0,     0,   201,   202,     0,   203,     0,
       0,     0,   204,     0,   205,   206,   207,   208,   209,     0,
       0,     0,   210,     0,     0,   211,   212,   213,     0,     0,
       0,   214,     0,   215,   216,     0,   217,   218,   219,     0,
       0,   220,   221,     0,   222,   223,   224,   225,   226,   227,
       0,     0,   228,   229,   230,   231,   232,     0,     0,   233,
     234,     0,   235,   236,   237,     0,     0,   238,     0,     0,
       0,   239,   240,     0,   241,     0,   242,     0,   243,   244,
     245,   246,     0,   247,     0,   248,     0,     0,     0,   249,
     250,     0,   251,     0,     0,   252,   253,     0,     0,     0,
     254,   255,   256,   257,     0,     0,   258,   259,   260,     0,
       0,   261,     0,     0,     0,     0,   262,   263,     0,     0,
       0,   264,     0,     0,     0,   265,   266,     0,   267,   268,
       0,     0,     0,   269,     0,     0,   270,   271,     0,     0,
     272,     0,     0,   273,   274,     0,     0,     0,     0,     0,
     275,   276,     0,   277,     0,   278,     0,   279,   280,     0,
       0,     0,     0,     0,     0,     0,   281,     0,   282,   283,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,   296,   297,   298,     0,   299,   300,   301,     0,
     302,   303,   304,   305,     0,   306,   307,     0,     0,     0,
       0,   308,   309,   310,   311,   312,   313,     0,     0,   314,
     315,     0,   316,     0,   317,     0,   318,   319,   320,   321,
     322,   323,   324,   325,   326,     0,     0,   327,   328,     0,
       0,   329,   330,   331,   332,     0,     0,     0,   333,   334,
       0,     0,     0,   335,     0,   336,   337,   338,     0,   339,
     340,   341,     0,   342,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   343,   344,   345,     0,   346,   347,     0,
     348,   349,   350,   351,   352,   353,   354,   355,   356,   357,
       0,     0,   358,   359,   360,     0,   361,     0,   362,   363,
     364,   365,   366,     0,   367,   368,   369,     0,     0,   370,
       0,     0,     0,   371,   372,   373,   374,   375,     0,     0,
     376,   377,   378,   379,   380,     0,   381,   382,     0,   383,
     384,   385,     0,     0,   386,     0,   387,     0,   388,   389,
       0,   390,   391,   392,     0,   393,     0,     0,   394,   395,
     396,   397,   398,   399,   400,   401,   402,   403,   404,     0,
     405,   406,     0,     0,     0,   407,   408,   409,   410,     0,
       0,     0,   411,     0,     0,     0,   412,     0,   413,   414,
     415,   416,     0,   417,   418,   419,   420,   421,     0,     0,
       0,     0,     0,   422,   423,   424,     0,   425,   426,     0,
     427,     0,     0,   428,     0,     0,   429,   430,   431,   432,
     433,   434,     0,     0,   435,   436,     0,   437,   438,   439,
     440,   441,   442,     0,     0,   443,   444,   445,   446,     0,
     447,   448,     0,     0,   449,   450,   451,   452,     0,     0,
     453,   454,     0,   455,   456,   457,   458,     0,     0,     0,
       0,     0,   459,   460,     0,     0,     0,   461,   462,   463,
     464,     0,   465,   466,     0,   467,   468,     0,   469,   470,
       0,     0,   471,     0,     0,   472,     0,   473,     0,   474,
     475,     0,     0,     0,     0,     0,     0,   476,     0,     0,
     477,     0,     0,     0,   478,   479,   480,   481,   482,     0,
       0,     0,     0,     0,     0,   483,   484,     0,   485,   486,
     487,     0,   137,   488,   138,   139,   140,   141,   142,  3218,
       0,   143,     0,     0,     0,   144,     0,     0,   145,     0,
     146,   147,   148,   149,   150,   151,     0,   152,     0,     0,
       0,   153,     0,     0,     0,   154,     0,     0,   155,   156,
     157,     0,   158,     0,   159,   160,     0,     0,   161,     0,
       0,   162,   163,     0,   164,   165,     0,   166,     0,   167,
     168,   169,   170,   171,   172,     0,   173,   174,     0,   175,
     176,   177,   178,   179,   180,   181,   182,   183,     0,   184,
     185,     0,   186,   187,   188,   189,   190,     0,     0,     0,
     191,     0,     0,   192,     0,   193,     0,     0,   194,     0,
       0,     0,   195,   196,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,     0,     0,   201,   202,
       0,   203,     0,     0,     0,   204,     0,   205,   206,   207,
     208,   209,     0,     0,     0,   210,     0,     0,   211,   212,
     213,     0,     0,     0,   214,     0,   215,   216,     0,   217,
     218,   219,     0,     0,   220,   221,     0,   222,   223,   224,
     225,   226,   227,     0,     0,   228,   229,   230,   231,   232,
       0,     0,   233,   234,     0,   235,   236,   237,     0,     0,
     238,     0,     0,     0,   239,   240,     0,   241,     0,   242,
       0,   243,   244,   245,   246,     0,   247,     0,   248,     0,
       0,     0,   249,   250,     0,   251,     0,     0,   252,   253,
       0,     0,     0,   254,   255,   256,   257,     0,     0,   258,
     259,   260,     0,     0,   261,     0,     0,     0,     0,   262,
     263,     0,     0,     0,   264,     0,     0,     0,   265,   266,
       0,   267,   268,     0,     0,     0,   269,     0,     0,   270,
     271,     0,     0,   272,     0,     0,   273,   274,     0,     0,
       0,     0,     0,   275,   276,     0,   277,     0,   278,     0,
     279,   280,     0,     0,     0,     0,     0,     0,     0,   281,
       0,   282,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,     0,   299,
     300,   301,     0,   302,   303,   304,   305,     0,   306,   307,
       0,     0,     0,     0,   308,   309,   310,   311,   312,   313,
       0,     0,   314,   315,     0,   316,     0,   317,     0,   318,
     319,   320,   321,   322,   323,   324,   325,   326,     0,     0,
     327,   328,     0,     0,   329,   330,   331,   332,     0,     0,
       0,   333,   334,     0,     0,     0,   335,     0,   336,   337,
     338,     0,   339,   340,   341,     0,   342,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   343,   344,   345,     0,
     346,   347,     0,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,     0,     0,   358,   359,   360,     0,   361,
       0,   362,   363,   364,   365,   366,     0,   367,   368,   369,
       0,     0,   370,     0,     0,     0,   371,   372,   373,   374,
     375,     0,     0,   376,   377,   378,   379,   380,     0,   381,
     382,     0,   383,   384,   385,     0,     0,   386,     0,   387,
       0,   388,   389,     0,   390,   391,   392,     0,   393,     0,
       0,   394,   395,   396,   397,   398,   399,   400,   401,   402,
     403,   404,     0,   405,   406,     0,     0,     0,   407,   408,
     409,   410,     0,     0,     0,   411,     0,     0,     0,   412,
       0,   413,   414,   415,   416,     0,   417,   418,   419,   420,
     421,     0,     0,     0,     0,     0,   422,   423,   424,     0,
     425,   426,     0,   427,     0,     0,   428,     0,     0,   429,
     430,   431,   432,   433,   434,     0,     0,   435,   436,     0,
     437,   438,   439,   440,   441,   442,     0,     0,   443,   444,
     445,   446,     0,   447,   448,     0,     0,   449,   450,   451,
     452,     0,     0,   453,   454,     0,   455,   456,   457,   458,
       0,     0,     0,     0,     0,   459,   460,     0,     0,     0,
     461,   462,   463,   464,     0,   465,   466,     0,   467,   468,
       0,   469,   470,     0,     0,   471,     0,     0,   472,     0,
     473,     0,   474,   475,     0,     0,     0,     0,     0,     0,
     476,     0,     0,   477,     0,     0,     0,   478,   479,   480,
     481,   482,     0,     0,     0,     0,     0,     0,   483,   484,
       0,   485,   486,   487,     0,   137,   488,   138,   139,   140,
     141,   142,  3552,     0,   143,     0,     0,     0,   144,     0,
       0,   145,     0,   146,   147,   148,   149,   150,   151,     0,
     152,     0,     0,     0,   153,     0,     0,     0,   154,     0,
       0,   155,   156,   157,     0,   158,     0,   159,   160,     0,
       0,   161,     0,     0,   162,   163,     0,   164,   165,     0,
     166,     0,   167,   168,   169,   170,   171,   172,     0,   173,
     174,     0,   175,   176,   177,   178,   179,   180,   181,   182,
     183,     0,   184,   185,     0,   186,   187,   188,   189,   190,
       0,     0,     0,   191,     0,     0,   192,     0,   193,     0,
       0,   194,     0,     0,     0,   195,   196,   197,     0,     0,
     198,     0,     0,     0,     0,   199,   200,  2499,     0,     0,
       0,   201,   202,     0,   203,     0,     0,     0,   204,     0,
     205,   206,   207,   208,   209,     0,     0,     0,   210,     0,
       0,   211,   212,   213,     0,     0,     0,   214,     0,   215,
     216,     0,   217,   218,   219,     0,     0,   220,   221,     0,
     222,   223,   224,   225,   226,   227,     0,     0,   228,   229,
     230,   231,   232,     0,     0,   233,   234,     0,   235,   236,
     237,  2500,     0,   238,     0,     0,     0,   239,   240,     0,
     241,     0,   242,     0,   243,   244,   245,   246,     0,   247,
       0,   248,     0,     0,     0,   249,   250,     0,   251,  2501,
       0,   252,   253,     0,     0,     0,   254,   255,   256,   257,
       0,     0,   258,   259,   260,     0,     0,   261,     0,     0,
       0,     0,   262,   263,     0,     0,     0,   264,     0,     0,
       0,   265,   266,     0,   267,   268,     0,     0,     0,   269,
       0,     0,   270,   271,     0,     0,   272,     0,     0,   273,
     274,     0,     0,     0,     0,     0,   275,   276,     0,   277,
       0,   278,     0,   279,   280,     0,     0,  2502,     0,     0,
       0,     0,   281,     0,   282,   283,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,     0,   299,   300,   301,     0,   302,   303,   304,   305,
       0,   306,   307,     0,     0,     0,     0,   308,   309,   310,
     311,   312,   313,     0,     0,   314,   315,     0,   316,     0,
     317,     0,   318,   319,   320,   321,   322,   323,   324,   325,
     326,     0,     0,   327,   328,     0,     0,   329,   330,   331,
     332,  1033,  1034,     0,   333,   334,     0,     0,  2503,   335,
       0,   336,   337,   338,     0,   339,   340,   341,     0,   342,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   343,
     344,   345,     0,   346,   347,     0,   348,   349,   350,   351,
     352,   353,   354,   355,   356,   357,     0,     0,   358,   359,
     360,     0,   361,     0,   362,   363,   364,   365,   366,     0,
     367,   368,   369,     0,     0,   370,     0,     0,     0,   371,
     372,   373,   374,   375,     0,     0,   376,   377,   378,   379,
     380,     0,   381,   382,     0,   383,   384,   385,     0,     0,
     386,     0,   387,     0,   388,   389,     0,   390,   391,   392,
       0,   393,     0,     0,   394,   395,   396,   397,   398,   399,
     400,   401,   402,   403,   404,     0,   405,   406,     0,     0,
       0,   407,   408,   409,   410,     0,     0,     0,   411,     0,
       0,     0,   412,     0,   413,   414,   415,   416,     0,   417,
     418,   419,   420,   421,     0,     0,  4479,   563,  4480,   422,
     423,   424,     0,   425,   426,     0,   427,     0,     0,   428,
       0,     0,   429,   430,   431,   432,   433,   434,     0,     0,
     435,   436,     0,   437,   438,   439,   440,   441,   442,     0,
       0,   443,   444,   445,   446,     0,   447,   448,     0,     0,
     449,   450,   451,   452,     0,     0,   453,   454,     0,   455,
     456,   457,   458,     0,     0,     0,     0,     0,   459,   460,
       0,     0,     0,   461,   462,   463,   464,  2504,   465,   466,
       0,   467,   468,     0,   469,   470,     0,     0,   471,     0,
       0,   472,     0,   473,     0,   474,   475,     0,     0,     0,
       0,     0,     0,   476,     0,     0,   477,     0,     0,     0,
     478,   479,   480,   481,   482,     0,     0,     0,     0,     0,
       0,   483,   484,     0,   485,   486,   487,     0,   137,   488,
     138,   139,   140,   141,   142,     0,     0,   143,     0,     0,
       0,   144,     0,     0,   145,     0,   146,   147,   148,   149,
     150,   151,     0,   152,     0,     0,  1361,   153,     0,     0,
       0,   154,     0,     0,   155,   156,   157,     0,   158,     0,
     159,   160,     0,     0,   161,     0,     0,   162,   163,     0,
     164,   165,     0,   166,     0,   167,   168,   169,   170,   171,
     172,     0,   173,   174,     0,   175,   176,   177,   178,   179,
     180,   181,   182,   183,     0,   184,   185,     0,   186,   187,
     188,   189,   190,     0,     0,     0,   191,     0,     0,   192,
       0,   193,     0,     0,   194,     0,     0,     0,   195,   196,
     197,     0,     0,   198,     0,     0,     0,     0,   199,   200,
       0,     0,     0,  1362,   201,   202,     0,   203,     0,     0,
       0,   204,     0,   205,   206,   207,   208,   209,     0,     0,
       0,   210,     0,     0,   211,   212,   213,     0,     0,     0,
     214,     0,   215,   216,     0,   217,   218,   219,  1363,     0,
     220,   221,     0,   222,   223,   224,   225,   226,   227,     0,
       0,   228,   229,   230,   231,   232,     0,     0,   233,   234,
       0,   235,   236,   237,     0,     0,   238,     0,     0,     0,
     239,   240,     0,   241,     0,   242,     0,   243,   244,   245,
     246,     0,   247,     0,   248,     0,     0,     0,   249,   250,
       0,   251,     0,     0,   252,   253,     0,     0,     0,   254,
     255,   256,   257,     0,     0,   258,   259,   260,     0,     0,
     261,     0,     0,     0,     0,   262,   263,     0,     0,     0,
     264,     0,     0,     0,   265,   266,     0,   267,   268,     0,
       0,     0,   269,     0,     0,   270,   271,     0,     0,   272,
       0,     0,   273,   274,   614,     0,     0,     0,     0,   275,
     276,     0,   277,     0,   278,     0,   279,   280,     0,     0,
       0,     0,     0,     0,     0,   281,     0,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,     0,   299,   300,   301,     0,   302,
     303,   304,   305,     0,   306,   307,     0,     0,     0,     0,
     308,   309,   310,   311,   312,   313,     0,     0,   314,   315,
       0,   316,     0,   317,     0,   318,   319,   320,   321,   322,
     323,   324,   325,   326,     0,     0,   327,   328,     0,     0,
     329,   330,   331,   332,     0,     0,     0,   333,   334,     0,
       0,     0,   335,     0,   336,   337,   338,     0,   339,   340,
     341,     0,   342,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   343,   344,   345,     0,   346,   347,     0,   348,
     349,   350,   351,   352,   353,   354,   355,   356,   357,     0,
       0,   358,   359,   360,     0,   361,     0,   362,   363,   364,
     365,   366,     0,   367,   368,   369,     0,     0,   370,     0,
       0,     0,   371,   372,   373,   374,   375,     0,     0,   376,
     377,   378,   379,   380,     0,   381,   382,     0,   383,   384,
     385,     0,     0,   386,     0,   387,     0,   388,   389,     0,
     390,   391,   392,     0,   393,     0,     0,   394,   395,   396,
     397,   398,   399,   400,   401,   402,   403,   404,     0,   405,
     406,     0,     0,     0,   407,   408,   409,   410,     0,     0,
    1364,   411,     0,     0,     0,   412,     0,   413,   414,   415,
     416,     0,   417,   418,   419,   420,   421,     0,     0,     0,
       0,     0,   422,   423,   424,     0,   425,   426,     0,   427,
       0,     0,   428,     0,     0,   429,   430,   431,   432,   433,
     434,     0,     0,   435,   436,     0,   437,   438,   439,   440,
     441,   442,     0,     0,   443,   444,   445,   446,     0,   447,
     448,     0,     0,   449,   450,   451,   452,     0,   134,   453,
     454,     0,   455,   456,   457,   458,     0,     0,     0,     0,
       0,   459,   460,     0,     0,     0,   461,   462,   463,   464,
       0,   465,   466,     0,   467,   468,     0,   469,   470,     0,
       0,   471,     0,     0,   472,     0,   473,     0,   474,   475,
       0,     0,     0,     0,     0,     0,   476,     0,     0,   477,
       0,     0,     0,   478,   479,   480,   481,   482,     0,     0,
       0,     0,     0,     0,   483,   484,     0,   485,   486,   487,
       0,   137,   488,   138,   139,   140,   141,   142,     0,     0,
     143,     0,     0,     0,   144,     0,     0,   145,     0,   146,
     147,   148,   149,   150,   151,     0,   152,     0,     0,  1374,
     153,     0,     0,     0,   154,     0,     0,   155,   156,   157,
       0,   158,     0,   159,   160,     0,     0,   161,     0,     0,
     162,   163,     0,   164,   165,     0,   166,     0,   167,   168,
     169,   170,   171,   172,     0,   173,   174,     0,   175,   176,
     177,   178,   179,   180,   181,   182,   183,     0,   184,   185,
       0,   186,   187,   188,   189,   190,     0,     0,     0,   191,
       0,     0,   192,     0,   193,     0,     0,   194,     0,     0,
       0,   195,   196,   197,     0,     0,   198,     0,     0,     0,
       0,   199,   200,     0,     0,     0,  1375,   201,   202,     0,
     203,     0,     0,     0,   204,     0,   205,   206,   207,   208,
     209,     0,     0,     0,   210,     0,     0,   211,   212,   213,
       0,     0,     0,   214,     0,   215,   216,     0,   217,   218,
     219,     0,     0,   220,   221,     0,   222,   223,   224,   225,
     226,   227,     0,     0,   228,   229,   230,   231,   232,     0,
       0,   233,   234,     0,   235,   236,   237,     0,     0,   238,
       0,     0,     0,   239,   240,     0,   241,     0,   242,     0,
     243,   244,   245,   246,     0,   247,     0,   248,     0,     0,
       0,   249,   250,     0,   251,     0,     0,   252,   253,     0,
       0,     0,   254,   255,   256,   257,     0,     0,   258,   259,
     260,     0,     0,   261,     0,     0,     0,     0,   262,   263,
       0,     0,     0,   264,     0,     0,     0,   265,   266,     0,
     267,   268,     0,     0,     0,   269,     0,     0,   270,   271,
       0,     0,   272,     0,     0,   273,   274,   614,     0,     0,
       0,     0,   275,   276,     0,   277,     0,   278,     0,   279,
     280,     0,     0,     0,     0,     0,     0,     0,   281,     0,
     282,   283,   284,   285,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,     0,   299,   300,
     301,     0,   302,   303,   304,   305,     0,   306,   307,     0,
       0,     0,     0,   308,   309,   310,   311,   312,   313,     0,
       0,   314,   315,     0,   316,     0,   317,     0,   318,   319,
     320,   321,   322,   323,   324,   325,   326,     0,     0,   327,
     328,     0,     0,   329,   330,   331,   332,     0,     0,     0,
     333,   334,     0,     0,     0,   335,     0,   336,   337,   338,
       0,   339,   340,   341,     0,   342,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   343,   344,   345,     0,   346,
     347,     0,   348,   349,   350,   351,   352,   353,   354,   355,
     356,   357,     0,     0,   358,   359,   360,     0,   361,     0,
     362,   363,   364,   365,   366,     0,   367,   368,   369,     0,
       0,   370,     0,     0,     0,   371,   372,   373,   374,   375,
       0,     0,   376,   377,   378,   379,   380,     0,   381,   382,
       0,   383,   384,   385,     0,     0,   386,     0,   387,     0,
     388,   389,     0,   390,   391,   392,     0,   393,     0,     0,
     394,   395,   396,   397,   398,   399,   400,   401,   402,   403,
     404,     0,   405,   406,     0,     0,     0,   407,   408,   409,
     410,     0,     0,     0,   411,     0,     0,     0,   412,     0,
     413,   414,   415,   416,     0,   417,   418,   419,   420,   421,
       0,     0,     0,     0,     0,   422,   423,   424,     0,   425,
     426,     0,   427,     0,     0,   428,     0,     0,   429,   430,
     431,   432,   433,   434,     0,     0,   435,   436,     0,   437,
     438,   439,   440,   441,   442,     0,     0,   443,   444,   445,
     446,     0,   447,   448,     0,     0,   449,   450,   451,   452,
       0,   134,   453,   454,     0,   455,   456,   457,   458,     0,
       0,     0,     0,     0,   459,   460,     0,     0,     0,   461,
     462,   463,   464,     0,   465,   466,     0,   467,   468,     0,
     469,   470,     0,     0,   471,     0,     0,   472,     0,   473,
       0,   474,   475,     0,     0,     0,     0,     0,     0,   476,
       0,     0,   477,     0,     0,     0,   478,   479,   480,   481,
     482,     0,     0,     0,     0,     0,     0,   483,   484,     0,
     485,   486,   487,     0,   137,   488,   138,   139,   140,   141,
     142,     0,     0,   143,     0,     0,     0,   144,     0,     0,
     145,     0,   146,   147,   148,   149,   150,   151,     0,   152,
       0,     0,     0,   153,     0,     0,     0,   154,     0,     0,
     155,   156,   157,     0,   158,     0,   159,   160,     0,     0,
     161,     0,     0,   162,   163,     0,   164,   165,     0,   166,
       0,   167,   168,   169,   170,   171,   172,     0,   173,   174,
       0,   175,   176,   177,   178,   179,   180,   181,   182,   183,
       0,   184,   185,     0,   186,   187,   188,   189,   190,     0,
       0,     0,   191,     0,     0,   192,     0,   193,     0,     0,
     194,     0,     0,     0,   195,   196,   197,     0,     0,   198,
       0,     0,     0,     0,   199,   200,     0,     0,     0,     0,
     201,   202,     0,   203,     0,     0,     0,   204,     0,   205,
     206,   207,   208,   209,     0,     0,     0,   210,     0,     0,
     211,   212,   213,     0,     0,     0,   214,     0,   215,   216,
       0,   217,   218,   219,     0,     0,   220,   221,     0,   222,
     223,   224,   225,   226,   227,     0,     0,   228,   229,   230,
     231,   232,     0,     0,   233,   234,     0,   235,   236,   237,
       0,     0,   238,     0,     0,     0,   239,   240,     0,   241,
       0,   242,     0,   243,   244,   245,   246,     0,   247,     0,
     248,     0,     0,     0,   249,   250,     0,   251,     0,     0,
     252,   253,     0,     0,     0,   254,   255,   256,   257,     0,
       0,   258,   259,   260,     0,     0,   261,     0,     0,     0,
       0,   262,   263,     0,     0,     0,   264,     0,     0,     0,
     265,   266,     0,   267,   268,     0,     0,     0,   269,     0,
       0,   270,   271,     0,     0,   272,     0,     0,   273,   274,
       0,     0,     0,     0,     0,   275,   276,     0,   277,     0,
     278,     0,   279,   280,     0,     0,  1899,     0,     0,     0,
       0,   281,     0,   282,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
       0,   299,   300,   301,     0,   302,   303,   304,   305,     0,
     306,   307,     0,     0,     0,     0,   308,   309,   310,   311,
     312,   313,     0,     0,   314,   315,     0,   316,     0,   317,
       0,   318,   319,   320,   321,   322,   323,   324,   325,   326,
       0,     0,   327,   328,     0,     0,   329,   330,   331,   332,
       0,     0,     0,   333,   334,     0,     0,  1900,   335,     0,
     336,   337,   338,     0,   339,   340,   341,     0,   342,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   343,   344,
     345,   722,   346,   347,     0,   348,   349,   350,   351,   352,
     353,   354,   355,   356,   357,     0,     0,   358,   359,   360,
       0,   361,     0,   362,   363,   364,   365,   366,     0,   367,
     368,   369,     0,     0,   370,     0,     0,     0,   371,   372,
     373,   374,   375,     0,     0,   376,   377,   378,   379,   380,
       0,   381,   382,     0,   383,   384,   385,     0,     0,   386,
       0,   387,     0,   388,   389,     0,   390,   391,   392,     0,
     393,     0,     0,   394,   395,   396,   397,   398,   399,   400,
     401,   402,   403,   404,     0,   405,   406,     0,     0,     0,
     407,   408,   409,   410,     0,     0,     0,   411,     0,     0,
       0,   412,     0,   413,   414,   415,   416,     0,   417,   418,
     419,   420,   421,     0,     0,     0,     0,     0,   422,   423,
     424,     0,   425,   426,     0,   427,     0,     0,   428,     0,
       0,   429,   430,   431,   432,   433,   434,     0,     0,   435,
     436,     0,   437,   438,   439,   440,   441,   442,     0,     0,
     443,   444,   445,   446,     0,   447,   448,     0,     0,   449,
     450,   451,   452,     0,     0,   453,   454,     0,   455,   456,
     457,   458,     0,     0,     0,     0,     0,   459,   460,     0,
       0,     0,   461,   462,   463,   464,  1901,   465,   466,     0,
     467,   468,     0,   469,   470,     0,     0,   471,     0,     0,
     472,     0,   473,     0,   474,   475,     0,     0,     0,     0,
       0,     0,   476,     0,     0,   477,     0,     0,     0,   478,
     479,   480,   481,   482,     0,     0,     0,     0,     0,     0,
     483,   484,     0,   485,   486,   487,     0,   137,   488,   138,
     139,   140,   141,   142,     0,     0,   143,     0,     0,     0,
     144,     0,     0,   145,     0,   146,   147,   148,   149,   150,
     151,     0,   152,     0,     0,  1361,   153,     0,     0,     0,
     154,     0,     0,   155,   156,   157,     0,   158,     0,   159,
     160,     0,     0,   161,     0,     0,   162,   163,     0,   164,
     165,     0,   166,     0,   167,   168,   169,   170,   171,   172,
       0,   173,   174,     0,   175,   176,   177,   178,   179,   180,
     181,   182,   183,     0,   184,   185,     0,   186,   187,   188,
     189,   190,     0,     0,     0,   191,     0,     0,   192,     0,
     193,     0,     0,   194,     0,     0,     0,   195,   196,   197,
       0,     0,   198,     0,     0,     0,     0,   199,   200,     0,
       0,     0,  1362,   201,   202,     0,   203,     0,     0,     0,
     204,     0,   205,   206,   207,   208,   209,     0,     0,     0,
     210,     0,     0,   211,   212,   213,     0,     0,     0,   214,
       0,   215,   216,     0,   217,   218,   219,     0,     0,   220,
     221,     0,   222,   223,   224,   225,   226,   227,     0,     0,
     228,   229,   230,   231,   232,     0,     0,   233,   234,     0,
     235,   236,   237,     0,     0,   238,     0,     0,     0,   239,
     240,     0,   241,     0,   242,     0,   243,   244,   245,   246,
       0,   247,     0,   248,     0,     0,     0,   249,   250,     0,
     251,     0,     0,   252,   253,     0,     0,     0,   254,   255,
     256,   257,     0,     0,   258,   259,   260,     0,     0,   261,
       0,     0,     0,     0,   262,   263,     0,     0,     0,   264,
       0,     0,     0,   265,   266,     0,   267,   268,     0,     0,
       0,   269,     0,     0,   270,   271,     0,     0,   272,     0,
       0,   273,   274,   614,     0,     0,     0,     0,   275,   276,
       0,   277,     0,   278,     0,   279,   280,     0,     0,     0,
       0,     0,     0,     0,   281,     0,   282,   283,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,     0,   299,   300,   301,     0,   302,   303,
     304,   305,     0,   306,   307,     0,     0,     0,     0,   308,
     309,   310,   311,   312,   313,     0,     0,   314,   315,     0,
     316,     0,   317,     0,   318,   319,   320,   321,   322,   323,
     324,   325,   326,     0,     0,   327,   328,     0,     0,   329,
     330,   331,   332,     0,     0,     0,   333,   334,     0,     0,
       0,   335,     0,   336,   337,   338,     0,   339,   340,   341,
       0,   342,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   343,   344,   345,     0,   346,   347,     0,   348,   349,
     350,   351,   352,   353,   354,   355,   356,   357,     0,     0,
     358,   359,   360,     0,   361,     0,   362,   363,   364,   365,
     366,     0,   367,   368,   369,     0,     0,   370,     0,     0,
       0,   371,   372,   373,   374,   375,     0,     0,   376,   377,
     378,   379,   380,     0,   381,   382,     0,   383,   384,   385,
       0,     0,   386,     0,   387,     0,   388,   389,     0,   390,
     391,   392,     0,   393,     0,     0,   394,   395,   396,   397,
     398,   399,   400,   401,   402,   403,   404,     0,   405,   406,
       0,     0,     0,   407,   408,   409,   410,     0,     0,     0,
     411,     0,     0,     0,   412,     0,   413,   414,   415,   416,
       0,   417,   418,   419,   420,   421,     0,     0,     0,     0,
       0,   422,   423,   424,     0,   425,   426,     0,   427,     0,
       0,   428,     0,     0,   429,   430,   431,   432,   433,   434,
       0,     0,   435,   436,     0,   437,   438,   439,   440,   441,
     442,     0,     0,   443,   444,   445,   446,     0,   447,   448,
       0,     0,   449,   450,   451,   452,     0,   134,   453,   454,
       0,   455,   456,   457,   458,     0,     0,     0,     0,     0,
     459,   460,     0,     0,     0,   461,   462,   463,   464,     0,
     465,   466,     0,   467,   468,     0,   469,   470,     0,     0,
     471,     0,     0,   472,     0,   473,     0,   474,   475,     0,
       0,     0,     0,     0,     0,   476,     0,     0,   477,     0,
       0,     0,   478,   479,   480,   481,   482,     0,     0,     0,
       0,     0,     0,   483,   484,     0,   485,   486,   487,     0,
     137,   488,   138,   139,   140,   141,   142,     0,     0,   143,
       0,     0,     0,   144,     0,     0,   145,     0,   146,   147,
     148,   149,   150,   151,     0,   152,     0,     0,     0,   153,
       0,     0,     0,   154,     0,     0,   155,   156,   157,     0,
     158,     0,   159,   160,     0,     0,   161,     0,     0,   162,
     163,     0,   164,   165,     0,   166,     0,   167,   168,   169,
     170,   171,   172,     0,   173,   174,     0,   175,   176,   177,
     178,   179,   180,   181,   182,   183,     0,   184,   185,     0,
     186,   187,   188,   189,   190,     0,     0,     0,   191,     0,
       0,   192,     0,   193,   990,     0,   194,     0,     0,     0,
     195,   196,   197,     0,     0,   198,     0,     0,     0,     0,
     199,   200,     0,     0,     0,     0,   201,   202,     0,   203,
       0,     0,     0,   204,     0,   205,   206,   207,   208,   209,
       0,     0,     0,   210,     0,     0,   211,   212,   213,     0,
       0,     0,   214,     0,   215,   216,     0,   217,   218,   219,
       0,     0,   220,   221,     0,   222,   223,   224,   225,   226,
     227,     0,     0,   228,   229,   230,   231,   232,     0,     0,
     233,   234,     0,   235,   236,   237,     0,     0,   238,     0,
       0,     0,   239,   240,     0,   241,     0,   242,     0,   243,
     244,   245,   246,     0,   247,     0,   248,     0,     0,     0,
     249,   250,     0,   251,     0,     0,   252,   253,     0,     0,
       0,   254,   255,   256,   257,     0,     0,   258,   259,   260,
       0,     0,   261,     0,     0,     0,     0,   262,   263,     0,
       0,     0,   264,     0,     0,     0,   265,   266,     0,   267,
     268,     0,     0,     0,   269,     0,     0,   270,   271,     0,
       0,   272,     0,     0,   273,   274,   614,     0,     0,     0,
       0,   275,   276,     0,   277,     0,   278,     0,   279,   280,
       0,     0,     0,     0,     0,     0,     0,   281,     0,   282,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,     0,   299,   300,   301,
       0,   302,   303,   304,   305,     0,   306,   307,     0,     0,
       0,     0,   308,   309,   310,   311,   312,   313,     0,     0,
     314,   315,     0,   316,     0,   317,     0,   318,   319,   320,
     321,   322,   323,   324,   325,   326,     0,     0,   327,   328,
       0,     0,   329,   330,   331,   332,     0,     0,     0,   333,
     334,     0,     0,     0,   335,     0,   336,   337,   338,     0,
     339,   340,   341,     0,   342,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   343,   344,   345,     0,   346,   347,
       0,   348,   349,   350,   351,   352,   353,   354,   355,   356,
     357,     0,     0,   358,   359,   360,     0,   361,     0,   362,
     363,   364,   365,   366,     0,   367,   368,   369,     0,     0,
     370,     0,     0,     0,   371,   372,   373,   374,   375,     0,
       0,   376,   377,   378,   379,   380,     0,   381,   382,     0,
     383,   384,   385,     0,     0,   386,     0,   387,     0,   388,
     389,     0,   390,   391,   392,     0,   393,     0,     0,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
       0,   405,   406,     0,     0,     0,   407,   408,   409,   410,
       0,     0,     0,   411,     0,     0,     0,   412,     0,   413,
     414,   415,   416,     0,   417,   418,   419,   420,   421,     0,
       0,     0,     0,     0,   422,   423,   424,     0,   425,   426,
       0,   427,     0,     0,   428,     0,     0,   429,   430,   431,
     432,   433,   434,     0,     0,   435,   436,     0,   437,   438,
     439,   440,   441,   442,     0,     0,   443,   444,   445,   446,
       0,   447,   448,     0,     0,   449,   450,   451,   452,     0,
     134,   453,   454,     0,   455,   456,   457,   458,     0,     0,
       0,     0,     0,   459,   460,     0,     0,     0,   461,   462,
     463,   464,     0,   465,   466,     0,   467,   468,     0,   469,
     470,     0,     0,   471,     0,     0,   472,     0,   473,     0,
     474,   475,     0,     0,     0,     0,     0,     0,   476,     0,
       0,   477,     0,     0,     0,   478,   479,   480,   481,   482,
       0,     0,     0,     0,     0,     0,   483,   484,     0,   485,
     486,   487,     0,   137,   488,   138,   139,   140,   141,   142,
    1396,     0,   143,     0,     0,     0,   144,     0,     0,   145,
       0,   146,   147,   148,   149,   150,   151,     0,   152,     0,
       0,     0,   153,     0,     0,     0,   154,     0,     0,   155,
     156,   157,     0,   158,     0,   159,   160,     0,     0,   161,
       0,     0,   162,   163,     0,   164,   165,     0,   166,     0,
     167,   168,   169,   170,   171,   172,     0,   173,   174,     0,
     175,   176,   177,   178,   179,   180,   181,   182,   183,     0,
     184,   185,     0,   186,   187,   188,   189,   190,     0,     0,
       0,   191,     0,     0,   192,     0,   193,     0,     0,   194,
       0,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,     0,     0,   201,
     202,     0,   203,     0,     0,     0,   204,     0,   205,   206,
     207,   208,   209,     0,     0,     0,   210,     0,     0,   211,
     212,   213,     0,     0,     0,   214,     0,   215,   216,     0,
     217,   218,   219,     0,     0,   220,   221,     0,   222,   223,
     224,   225,   226,   227,     0,     0,   228,   229,   230,   231,
     232,     0,     0,   233,   234,     0,   235,   236,   237,     0,
       0,   238,     0,     0,     0,   239,   240,     0,   241,     0,
     242,     0,   243,   244,   245,   246,     0,   247,     0,   248,
       0,     0,     0,   249,   250,     0,   251,     0,     0,   252,
     253,     0,     0,     0,   254,   255,   256,   257,     0,     0,
     258,   259,   260,     0,     0,   261,     0,     0,     0,     0,
     262,   263,     0,     0,     0,   264,     0,     0,     0,   265,
     266,     0,   267,   268,     0,     0,     0,   269,     0,     0,
     270,   271,     0,     0,   272,     0,     0,   273,   274,   614,
       0,     0,     0,     0,   275,   276,     0,   277,     0,   278,
       0,   279,   280,     0,     0,     0,     0,     0,     0,     0,
     281,     0,   282,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,     0,
     299,   300,   301,     0,   302,   303,   304,   305,     0,   306,
     307,     0,     0,     0,     0,   308,   309,   310,   311,   312,
     313,     0,     0,   314,   315,     0,   316,     0,   317,     0,
     318,   319,   320,   321,   322,   323,   324,   325,   326,     0,
       0,   327,   328,     0,     0,   329,   330,   331,   332,     0,
       0,     0,   333,   334,     0,     0,     0,   335,     0,   336,
     337,   338,     0,   339,   340,   341,     0,   342,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   343,   344,   345,
       0,   346,   347,     0,   348,   349,   350,   351,   352,   353,
     354,   355,   356,   357,     0,     0,   358,   359,   360,     0,
     361,     0,   362,   363,   364,   365,   366,     0,   367,   368,
     369,     0,     0,   370,     0,     0,     0,   371,   372,   373,
     374,   375,     0,     0,   376,   377,   378,   379,   380,     0,
     381,   382,     0,   383,   384,   385,     0,     0,   386,     0,
     387,     0,   388,   389,     0,   390,   391,   392,     0,   393,
       0,     0,   394,   395,   396,   397,   398,   399,   400,   401,
     402,   403,   404,     0,   405,   406,     0,     0,     0,   407,
     408,   409,   410,     0,     0,     0,   411,     0,     0,     0,
     412,     0,   413,   414,   415,   416,     0,   417,   418,   419,
     420,   421,     0,     0,     0,     0,     0,   422,   423,   424,
       0,   425,   426,     0,   427,     0,     0,   428,     0,     0,
     429,   430,   431,   432,   433,   434,     0,     0,   435,   436,
       0,   437,   438,   439,   440,   441,   442,     0,     0,   443,
     444,   445,   446,     0,   447,   448,     0,     0,   449,   450,
     451,   452,     0,   134,   453,   454,     0,   455,   456,   457,
     458,     0,     0,     0,     0,     0,   459,   460,     0,     0,
       0,   461,   462,   463,   464,     0,   465,   466,     0,   467,
     468,     0,   469,   470,     0,     0,   471,     0,     0,   472,
       0,   473,     0,   474,   475,     0,     0,     0,     0,     0,
       0,   476,     0,     0,   477,     0,     0,     0,   478,   479,
     480,   481,   482,     0,     0,     0,     0,     0,     0,   483,
     484,     0,   485,   486,   487,     0,   137,   488,   138,   139,
     140,   141,   142,     0,     0,   143,     0,     0,     0,   144,
       0,     0,   145,     0,   146,   147,   148,   149,   150,   151,
       0,   152,     0,     0,     0,   153,   967,     0,     0,   154,
       0,     0,   155,   156,   157,     0,   158,     0,   159,   160,
       0,     0,   161,     0,     0,   162,   163,     0,   164,   165,
       0,   166,     0,   167,   168,   169,   170,   171,   172,     0,
     173,   174,     0,   175,   176,   177,   178,   179,   180,   181,
     182,   183,     0,   184,   185,     0,   186,   187,   188,   189,
     190,     0,     0,     0,   191,     0,     0,   192,     0,   193,
       0,     0,   194,     0,     0,     0,   195,   196,   197,     0,
       0,   198,     0,     0,     0,     0,   199,   200,     0,     0,
       0,     0,   201,   202,     0,   203,     0,     0,     0,   204,
       0,   205,   206,   207,   208,   209,     0,     0,     0,   210,
       0,     0,   211,   212,   213,     0,     0,     0,   214,     0,
     215,   216,     0,   217,   218,   219,     0,     0,   220,   221,
       0,   222,   223,   224,   225,   226,   227,     0,     0,   228,
     229,   230,   231,   232,     0,     0,   233,   234,     0,   235,
     236,   237,     0,     0,   238,     0,     0,     0,   239,   240,
       0,   241,     0,   242,     0,   243,   244,   245,   246,     0,
     247,     0,   248,     0,     0,     0,   249,   250,     0,   251,
     968,     0,   252,   253,     0,     0,     0,   254,   255,   256,
     257,     0,     0,   258,   259,   260,     0,     0,   261,     0,
       0,     0,     0,   262,   263,     0,     0,     0,   264,     0,
       0,     0,   265,   266,     0,   267,   268,     0,     0,     0,
     269,     0,     0,   270,   271,     0,     0,   272,     0,     0,
     273,   274,     0,     0,     0,     0,     0,   275,   276,     0,
     277,     0,   278,     0,   279,   280,     0,     0,     0,     0,
       0,     0,     0,   281,     0,   282,   283,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,     0,   299,   300,   301,     0,   302,   303,   304,
     305,     0,   306,   307,     0,     0,     0,     0,   308,   309,
     310,   311,   312,   313,     0,     0,   314,   315,     0,   316,
       0,   317,     0,   318,   319,   320,   321,   322,   323,   324,
     325,   326,     0,     0,   327,   328,     0,     0,   329,   330,
     331,   332,     0,     0,     0,   333,   334,     0,     0,     0,
     335,     0,   336,   337,   338,     0,   339,   340,   341,     0,
     342,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     343,   344,   345,     0,   346,   347,     0,   348,   349,   350,
     351,   352,   353,   354,   355,   356,   357,     0,     0,   358,
     359,   360,     0,   361,     0,   362,   363,   364,   365,   366,
       0,   367,   368,   369,     0,     0,   370,     0,     0,     0,
     371,   372,   373,   374,   375,     0,     0,   376,   377,   378,
     379,   380,     0,   381,   382,     0,   383,   384,   385,     0,
       0,   386,     0,   387,     0,   388,   389,     0,   390,   391,
     392,     0,   393,     0,     0,   394,   395,   396,   397,   398,
     399,   400,   401,   402,   403,   404,     0,   405,   406,     0,
       0,     0,   407,   408,   409,   410,     0,     0,     0,   411,
       0,     0,     0,   412,     0,   413,   414,   415,   416,     0,
     417,   418,   419,   420,   421,     0,     0,     0,     0,     0,
     422,   423,   424,     0,   425,   426,     0,   427,     0,     0,
     428,     0,     0,   429,   430,   431,   432,   433,   434,     0,
       0,   435,   436,     0,   437,   438,   439,   440,   441,   442,
       0,     0,   443,   444,   445,   446,     0,   447,   448,     0,
       0,   449,   450,   451,   452,     0,   969,   453,   454,     0,
     455,   456,   457,   458,     0,     0,     0,     0,     0,   459,
     460,     0,     0,     0,   461,   462,   463,   464,     0,   465,
     466,     0,   467,   468,     0,   469,   470,     0,     0,   471,
       0,     0,   472,     0,   473,     0,   474,   475,     0,     0,
       0,     0,     0,     0,   476,     0,     0,   477,     0,     0,
       0,   478,   479,   480,   481,   482,     0,     0,     0,     0,
       0,     0,   483,   484,     0,   485,   486,   487,     0,   137,
     488,   138,   139,   140,   141,   142,     0,     0,   143,     0,
       0,     0,   144,     0,     0,   145,     0,   146,   147,   148,
     149,   150,   151,     0,   152,     0,     0,     0,   153,     0,
       0,     0,   154,     0,     0,   155,   156,   157,     0,   158,
       0,   159,   160,     0,     0,   161,     0,     0,   162,   163,
       0,   164,   165,     0,   166,     0,   167,   168,   169,   170,
     171,   172,     0,   173,   174,     0,   175,   176,   177,   178,
     179,   180,   181,   182,   183,     0,   184,   185,     0,   186,
     187,   188,   189,   190,     0,     0,     0,   191,     0,     0,
     192,     0,   193,     0,     0,   194,     0,     0,     0,   195,
     196,   197,     0,     0,   198,     0,     0,     0,     0,   199,
     200,     0,     0,     0,  2408,   201,   202,     0,   203,     0,
       0,     0,   204,     0,   205,   206,   207,   208,   209,     0,
       0,     0,   210,     0,     0,   211,   212,   213,     0,     0,
       0,   214,     0,   215,   216,     0,   217,   218,   219,     0,
       0,   220,   221,     0,   222,   223,   224,   225,   226,   227,
       0,     0,   228,   229,   230,   231,   232,     0,     0,   233,
     234,     0,   235,   236,   237,     0,     0,   238,     0,     0,
       0,   239,   240,     0,   241,     0,   242,     0,   243,   244,
     245,   246,     0,   247,     0,   248,     0,     0,     0,   249,
     250,     0,   251,     0,     0,   252,   253,     0,     0,     0,
     254,   255,   256,   257,     0,     0,   258,   259,   260,     0,
       0,   261,     0,     0,     0,     0,   262,   263,     0,     0,
       0,   264,     0,     0,     0,   265,   266,     0,   267,   268,
       0,     0,     0,   269,     0,     0,   270,   271,     0,     0,
     272,     0,     0,   273,   274,   614,     0,     0,     0,     0,
     275,   276,     0,   277,     0,   278,     0,   279,   280,     0,
       0,     0,     0,     0,     0,     0,   281,     0,   282,   283,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,   296,   297,   298,     0,   299,   300,   301,     0,
     302,   303,   304,   305,     0,   306,   307,     0,     0,     0,
       0,   308,   309,   310,   311,   312,   313,     0,     0,   314,
     315,     0,   316,     0,   317,     0,   318,   319,   320,   321,
     322,   323,   324,   325,   326,     0,     0,   327,   328,     0,
       0,   329,   330,   331,   332,     0,     0,     0,   333,   334,
       0,     0,     0,   335,     0,   336,   337,   338,     0,   339,
     340,   341,     0,   342,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   343,   344,   345,     0,   346,   347,     0,
     348,   349,   350,   351,   352,   353,   354,   355,   356,   357,
       0,     0,   358,   359,   360,     0,   361,     0,   362,   363,
     364,   365,   366,     0,   367,   368,   369,     0,     0,   370,
       0,     0,     0,   371,   372,   373,   374,   375,     0,     0,
     376,   377,   378,   379,   380,     0,   381,   382,     0,   383,
     384,   385,     0,     0,   386,     0,   387,     0,   388,   389,
       0,   390,   391,   392,     0,   393,     0,     0,   394,   395,
     396,   397,   398,   399,   400,   401,   402,   403,   404,     0,
     405,   406,     0,     0,     0,   407,   408,   409,   410,     0,
       0,     0,   411,     0,     0,     0,   412,     0,   413,   414,
     415,   416,     0,   417,   418,   419,   420,   421,     0,     0,
       0,     0,     0,   422,   423,   424,     0,   425,   426,     0,
     427,     0,     0,   428,     0,     0,   429,   430,   431,   432,
     433,   434,     0,     0,   435,   436,     0,   437,   438,   439,
     440,   441,   442,     0,     0,   443,   444,   445,   446,     0,
     447,   448,     0,     0,   449,   450,   451,   452,     0,   134,
     453,   454,     0,   455,   456,   457,   458,     0,     0,     0,
       0,     0,   459,   460,     0,     0,     0,   461,   462,   463,
     464,     0,   465,   466,     0,   467,   468,     0,   469,   470,
       0,     0,   471,     0,     0,   472,     0,   473,     0,   474,
     475,     0,     0,     0,     0,     0,     0,   476,     0,     0,
     477,     0,     0,     0,   478,   479,   480,   481,   482,     0,
       0,     0,     0,     0,     0,   483,   484,     0,   485,   486,
     487,     0,   137,   488,   138,   139,   140,   141,   142,     0,
       0,   143,     0,     0,     0,   144,     0,     0,   145,     0,
     146,   147,   148,   149,   150,   151,     0,   152,     0,     0,
    1361,   153,     0,     0,     0,   154,     0,     0,   155,   156,
     157,     0,   158,     0,   159,   160,     0,     0,   161,     0,
       0,   162,   163,     0,   164,   165,     0,   166,     0,   167,
     168,   169,   170,   171,   172,     0,   173,   174,     0,   175,
     176,   177,   178,   179,   180,   181,   182,   183,     0,   184,
     185,     0,   186,   187,   188,   189,   190,     0,     0,     0,
     191,     0,     0,   192,     0,   193,     0,     0,   194,     0,
       0,     0,   195,   196,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,     0,     0,   201,   202,
       0,   203,     0,     0,     0,   204,     0,   205,   206,   207,
     208,   209,     0,     0,     0,   210,     0,     0,   211,   212,
     213,     0,     0,     0,   214,     0,   215,   216,     0,   217,
     218,   219,     0,     0,   220,   221,     0,   222,   223,   224,
     225,   226,   227,     0,     0,   228,   229,   230,   231,   232,
       0,     0,   233,   234,     0,   235,   236,   237,     0,     0,
     238,     0,     0,     0,   239,   240,     0,   241,     0,   242,
       0,   243,   244,   245,   246,     0,   247,     0,   248,     0,
       0,     0,   249,   250,     0,   251,     0,     0,   252,   253,
       0,     0,     0,   254,   255,   256,   257,     0,     0,   258,
     259,   260,     0,     0,   261,     0,     0,     0,     0,   262,
     263,     0,     0,     0,   264,     0,     0,     0,   265,   266,
       0,   267,   268,     0,     0,     0,   269,     0,     0,   270,
     271,     0,     0,   272,     0,     0,   273,   274,   614,     0,
       0,     0,     0,   275,   276,     0,   277,     0,   278,     0,
     279,   280,     0,     0,     0,     0,     0,     0,     0,   281,
       0,   282,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,     0,   299,
     300,   301,     0,   302,   303,   304,   305,     0,   306,   307,
       0,     0,     0,     0,   308,   309,   310,   311,   312,   313,
       0,     0,   314,   315,     0,   316,     0,   317,     0,   318,
     319,   320,   321,   322,   323,   324,   325,   326,     0,     0,
     327,   328,     0,     0,   329,   330,   331,   332,     0,     0,
       0,   333,   334,     0,     0,     0,   335,     0,   336,   337,
     338,     0,   339,   340,   341,     0,   342,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   343,   344,   345,     0,
     346,   347,     0,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,     0,     0,   358,   359,   360,     0,   361,
       0,   362,   363,   364,   365,   366,     0,   367,   368,   369,
       0,     0,   370,     0,     0,     0,   371,   372,   373,   374,
     375,     0,     0,   376,   377,   378,   379,   380,     0,   381,
     382,     0,   383,   384,   385,     0,     0,   386,     0,   387,
       0,   388,   389,     0,   390,   391,   392,     0,   393,     0,
       0,   394,   395,   396,   397,   398,   399,   400,   401,   402,
     403,   404,     0,   405,   406,     0,     0,     0,   407,   408,
     409,   410,     0,     0,     0,   411,     0,     0,     0,   412,
       0,   413,   414,   415,   416,     0,   417,   418,   419,   420,
     421,     0,     0,     0,     0,     0,   422,   423,   424,     0,
     425,   426,     0,   427,     0,     0,   428,     0,     0,   429,
     430,   431,   432,   433,   434,     0,     0,   435,   436,     0,
     437,   438,   439,   440,   441,   442,     0,     0,   443,   444,
     445,   446,     0,   447,   448,     0,     0,   449,   450,   451,
     452,     0,   134,   453,   454,     0,   455,   456,   457,   458,
       0,     0,     0,     0,     0,   459,   460,     0,     0,     0,
     461,   462,   463,   464,     0,   465,   466,     0,   467,   468,
       0,   469,   470,     0,     0,   471,     0,     0,   472,     0,
     473,     0,   474,   475,     0,     0,     0,     0,     0,     0,
     476,     0,     0,   477,     0,     0,     0,   478,   479,   480,
     481,   482,     0,     0,     0,     0,     0,     0,   483,   484,
       0,   485,   486,   487,     0,   137,   488,   138,   139,   140,
     141,   142,     0,     0,   143,     0,     0,     0,   144,     0,
       0,   145,     0,   146,   147,   148,   149,   150,   151,     0,
     152,     0,     0,     0,   153,     0,     0,     0,   154,     0,
       0,   155,   156,   157,     0,   158,     0,   159,   160,     0,
       0,   161,     0,     0,   162,   163,     0,   164,   165,     0,
     166,     0,   167,   168,   169,   170,   171,   172,     0,   173,
     174,     0,   175,   176,   177,   178,   179,   180,   181,   182,
     183,     0,   184,   185,     0,   186,   187,   188,   189,   190,
       0,     0,     0,   191,     0,     0,   192,     0,   193,     0,
       0,   194,     0,     0,     0,   195,   196,   197,     0,     0,
     198,     0,     0,     0,     0,   199,   200,     0,     0,     0,
       0,   201,   202,     0,   203,     0,     0,     0,   204,     0,
     205,   206,   207,   208,   209,     0,     0,     0,   210,     0,
       0,   211,   212,   213,     0,     0,     0,   214,     0,   215,
     216,     0,   217,   218,   219,     0,     0,   220,   221,     0,
     222,   223,   224,   225,   226,   227,     0,     0,   228,   229,
     230,   231,   232,     0,     0,   233,   234,     0,   235,   236,
     237,     0,     0,   238,     0,     0,     0,   239,   240,     0,
     241,     0,   242,     0,   243,   244,   245,   246,     0,   247,
       0,   248,     0,     0,     0,   249,   250,     0,   251,     0,
       0,   252,   253,     0,     0,     0,   254,   255,   256,   257,
       0,     0,   258,   259,   260,     0,     0,   261,     0,     0,
       0,     0,   262,   263,     0,     0,     0,   264,     0,     0,
       0,   265,   266,     0,   267,   268,     0,     0,     0,   269,
       0,     0,   270,   271,     0,     0,   272,     0,     0,   273,
     274,   614,     0,     0,     0,     0,   275,   276,     0,   277,
       0,   278,     0,   279,   280,     0,     0,     0,     0,     0,
       0,     0,   281,     0,   282,   283,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,     0,   299,   300,   301,     0,   302,   303,   304,   305,
       0,   306,   307,     0,     0,     0,     0,   308,   309,   310,
     311,   312,   313,     0,     0,   314,   315,     0,   316,     0,
     317,     0,   318,   319,   320,   321,   322,   323,   324,   325,
     326,     0,     0,   327,   328,     0,     0,   329,   330,   331,
     332,     0,     0,     0,   333,   334,     0,     0,     0,   335,
       0,   336,   337,   338,     0,   339,   340,   341,     0,   342,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   343,
     344,   345,     0,   346,   347,     0,   348,   349,   350,   351,
     352,   353,   354,   355,   356,   357,     0,     0,   358,   359,
     360,     0,   361,     0,   362,   363,   364,   365,   366,     0,
     367,   368,   369,     0,     0,   370,     0,     0,     0,   371,
     372,   373,   374,   375,     0,     0,   376,   377,   378,   379,
     380,     0,   381,   382,     0,   383,   384,   385,     0,     0,
     386,     0,   387,     0,   388,   389,     0,   390,   391,   392,
       0,   393,     0,     0,   394,   395,   396,   397,   398,   399,
     400,   401,   402,   403,   404,     0,   405,   406,     0,     0,
       0,   407,   408,   409,   410,     0,     0,     0,   411,     0,
       0,     0,   412,     0,   413,   414,   415,   416,     0,   417,
     418,   419,   420,   421,     0,     0,     0,     0,     0,   422,
     423,   424,     0,   425,   426,     0,   427,     0,     0,   428,
       0,     0,   429,   430,   431,   432,   433,   434,     0,     0,
     435,   436,     0,   437,   438,   439,   440,   441,   442,     0,
       0,   443,   444,   445,   446,     0,   447,   448,     0,     0,
     449,   450,   451,   452,     0,   134,   453,   454,     0,   455,
     456,   457,   458,     0,     0,     0,     0,     0,   459,   460,
       0,     0,     0,   461,   462,   463,   464,     0,   465,   466,
       0,   467,   468,     0,   469,   470,     0,     0,   471,     0,
       0,   472,     0,   473,     0,   474,   475,     0,     0,     0,
       0,     0,     0,   476,     0,     0,   477,     0,     0,     0,
     478,   479,   480,   481,   482,     0,     0,     0,     0,     0,
       0,   483,   484,     0,   485,   486,   487,     0,   137,   488,
     138,   139,   140,   141,   142,     0,     0,   143,     0,     0,
       0,   144,  2863,     0,   145,     0,   146,   147,   148,   149,
     150,   151,     0,   152,     0,     0,     0,   153,     0,     0,
       0,   154,     0,     0,   155,   156,   157,     0,   158,     0,
     159,   160,     0,     0,   161,     0,     0,   162,   163,     0,
     164,   165,     0,   166,     0,   167,   168,   169,   170,   171,
     172,     0,   173,   174,     0,   175,   176,   177,   178,   179,
     180,   181,   182,   183,     0,   184,   185,     0,   186,   187,
     188,   189,   190,     0,     0,     0,   191,     0,     0,   192,
       0,   193,     0,     0,   194,     0,     0,     0,   195,   196,
     197,     0,     0,   198,     0,     0,     0,     0,   199,   200,
       0,     0,     0,     0,   201,   202,     0,   203,     0,     0,
       0,   204,     0,   205,   206,   207,   208,   209,     0,     0,
       0,   210,     0,     0,   211,   212,   213,     0,     0,     0,
     214,     0,   215,   216,     0,   217,   218,   219,     0,     0,
     220,   221,     0,   222,   223,   224,   225,   226,   227,     0,
       0,   228,   229,   230,   231,   232,     0,     0,   233,   234,
       0,   235,   236,   237,     0,     0,   238,     0,     0,     0,
     239,   240,     0,   241,     0,   242,     0,   243,   244,   245,
     246,     0,   247,     0,   248,     0,     0,     0,   249,   250,
       0,   251,     0,     0,   252,   253,     0,     0,     0,   254,
     255,   256,   257,     0,     0,   258,   259,   260,     0,     0,
     261,     0,     0,     0,     0,   262,   263,     0,     0,     0,
     264,     0,     0,     0,   265,   266,     0,   267,   268,     0,
       0,     0,   269,     0,     0,   270,   271,     0,     0,   272,
       0,     0,   273,   274,     0,     0,     0,     0,     0,   275,
     276,     0,   277,     0,   278,     0,   279,   280,     0,     0,
       0,     0,     0,     0,     0,   281,     0,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,     0,   299,   300,   301,     0,   302,
     303,   304,   305,     0,   306,   307,     0,     0,     0,     0,
     308,   309,   310,   311,   312,   313,     0,     0,   314,   315,
       0,   316,     0,   317,     0,   318,   319,   320,   321,   322,
     323,   324,   325,   326,     0,     0,   327,   328,     0,     0,
     329,   330,   331,   332,     0,     0,     0,   333,   334,     0,
       0,     0,   335,     0,   336,   337,   338,     0,   339,   340,
     341,     0,   342,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   343,   344,   345,     0,   346,   347,     0,   348,
     349,   350,   351,   352,   353,   354,   355,   356,   357,     0,
       0,   358,   359,   360,     0,   361,     0,   362,   363,   364,
     365,   366,     0,   367,   368,   369,     0,     0,   370,     0,
       0,     0,   371,   372,   373,   374,   375,     0,     0,   376,
     377,   378,   379,   380,     0,   381,   382,     0,   383,   384,
     385,     0,     0,   386,     0,   387,     0,   388,   389,     0,
     390,   391,   392,     0,   393,     0,     0,   394,   395,   396,
     397,   398,   399,   400,   401,   402,   403,   404,     0,   405,
     406,     0,     0,     0,   407,   408,   409,   410,     0,     0,
       0,   411,     0,     0,     0,   412,     0,   413,   414,   415,
     416,     0,   417,   418,   419,   420,   421,     0,     0,     0,
       0,     0,   422,   423,   424,     0,   425,   426,     0,   427,
       0,     0,   428,     0,     0,   429,   430,   431,   432,   433,
     434,     0,     0,   435,   436,     0,   437,   438,   439,   440,
     441,   442,     0,     0,   443,   444,   445,   446,     0,   447,
     448,     0,     0,   449,   450,   451,   452,     0,   134,   453,
     454,     0,   455,   456,   457,   458,     0,     0,     0,     0,
       0,   459,   460,     0,     0,     0,   461,   462,   463,   464,
       0,   465,   466,     0,   467,   468,     0,   469,   470,     0,
       0,   471,     0,     0,   472,     0,   473,     0,   474,   475,
       0,     0,     0,     0,     0,     0,   476,     0,     0,   477,
       0,     0,     0,   478,   479,   480,   481,   482,     0,     0,
       0,     0,     0,     0,   483,   484,     0,   485,   486,   487,
       0,   137,   488,   138,   139,   140,   141,   142,     0,     0,
     143,     0,     0,     0,   144,     0,     0,   145,     0,   146,
     147,   148,   149,   150,   151,     0,   152,     0,     0,     0,
     153,     0,     0,     0,   154,     0,     0,   155,   156,   157,
       0,   158,     0,   159,   160,     0,     0,   161,     0,     0,
     162,   163,     0,   164,   165,     0,   166,     0,   167,   168,
     169,   170,   171,   172,     0,   173,   174,     0,   175,   176,
     177,   178,   179,   180,   181,   182,   183,     0,   184,   185,
       0,   186,   187,   188,   189,   190,  4399,     0,     0,   191,
       0,     0,   192,     0,   193,     0,     0,   194,     0,     0,
       0,   195,   196,   197,     0,     0,   198,     0,     0,     0,
       0,   199,   200,     0,     0,     0,     0,   201,   202,     0,
     203,     0,     0,     0,   204,     0,   205,   206,   207,   208,
     209,     0,     0,     0,   210,     0,     0,   211,   212,   213,
       0,     0,     0,   214,     0,   215,   216,     0,   217,   218,
     219,     0,     0,   220,   221,     0,   222,   223,   224,   225,
     226,   227,     0,  4400,   228,   229,   230,   231,   232,     0,
       0,   233,   234,     0,   235,   236,   237,     0,     0,   238,
       0,     0,     0,   239,   240,     0,   241,     0,   242,     0,
     243,   244,   245,   246,     0,   247,     0,   248,     0,     0,
       0,   249,   250,     0,   251,     0,     0,   252,   253,     0,
       0,     0,   254,   255,   256,   257,     0,     0,   258,   259,
     260,     0,     0,   261,     0,     0,     0,     0,   262,   263,
       0,     0,     0,   264,     0,     0,     0,   265,   266,     0,
     267,   268,     0,     0,     0,   269,     0,     0,   270,   271,
       0,     0,   272,     0,     0,   273,   274,     0,     0,     0,
       0,     0,   275,   276,     0,   277,     0,   278,     0,   279,
     280,     0,     0,     0,     0,     0,     0,     0,   281,     0,
     282,   283,   284,   285,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,     0,   299,   300,
     301,     0,   302,   303,   304,   305,     0,   306,   307,     0,
       0,     0,     0,   308,   309,   310,   311,   312,   313,     0,
       0,   314,   315,     0,   316,     0,   317,     0,   318,   319,
     320,   321,   322,   323,   324,   325,   326,     0,     0,   327,
     328,     0,     0,   329,   330,   331,   332,     0,     0,     0,
     333,   334,     0,     0,     0,   335,     0,   336,   337,   338,
       0,   339,   340,   341,     0,   342,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   343,   344,   345,     0,   346,
     347,     0,   348,   349,   350,   351,   352,   353,   354,   355,
     356,   357,     0,     0,   358,   359,   360,     0,   361,     0,
     362,   363,   364,   365,   366,     0,   367,   368,   369,     0,
       0,   370,     0,     0,     0,   371,   372,   373,   374,   375,
       0,     0,   376,   377,   378,   379,   380,     0,   381,   382,
       0,   383,   384,   385,     0,     0,   386,     0,   387,     0,
     388,   389,     0,   390,   391,   392,     0,   393,     0,     0,
     394,   395,   396,   397,   398,   399,   400,   401,   402,   403,
     404,     0,   405,   406,     0,     0,     0,   407,   408,   409,
     410,     0,     0,     0,   411,     0,     0,     0,   412,     0,
     413,   414,   415,   416,     0,   417,   418,   419,   420,   421,
       0,     0,     0,     0,     0,   422,   423,   424,     0,   425,
     426,     0,   427,     0,     0,   428,     0,     0,   429,   430,
     431,   432,   433,   434,     0,     0,   435,   436,     0,   437,
     438,   439,   440,   441,   442,     0,     0,   443,   444,   445,
     446,     0,   447,   448,     0,     0,   449,   450,   451,   452,
       0,     0,   453,   454,     0,   455,   456,   457,   458,     0,
       0,     0,     0,     0,   459,   460,     0,     0,     0,   461,
     462,   463,   464,     0,   465,   466,     0,   467,   468,     0,
     469,   470,     0,     0,   471,     0,     0,   472,     0,   473,
       0,   474,   475,     0,     0,     0,     0,     0,     0,   476,
       0,     0,   477,     0,     0,     0,   478,   479,   480,   481,
     482,     0,     0,     0,     0,     0,     0,   483,   484,     0,
     485,   486,   487,     0,   137,   488,   138,   139,   140,   141,
     142,     0,     0,   143,     0,     0,     0,   144,     0,     0,
     145,     0,   146,   147,   148,   149,   150,   151,     0,   152,
       0,     0,     0,   153,     0,     0,     0,   154,     0,     0,
     155,   156,   157,     0,   158,     0,   159,   160,     0,     0,
     161,     0,     0,   162,   163,     0,   164,   165,     0,   166,
       0,   167,   168,   169,   170,   171,   172,     0,   173,   174,
       0,   175,   176,   177,   178,   179,   180,   181,   182,   183,
       0,   184,   185,     0,   186,   187,   188,   189,   190,     0,
       0,     0,   191,     0,     0,   192,     0,   193,     0,     0,
     194,     0,     0,     0,   195,   196,   197,     0,     0,   198,
       0,     0,     0,     0,   199,   200,     0,     0,     0,     0,
     201,   202,     0,   203,     0,     0,     0,   204,     0,   205,
     206,   207,   208,   209,     0,     0,     0,   210,     0,     0,
     211,   212,   213,     0,     0,     0,   214,     0,   215,   216,
       0,   217,   218,   219,     0,     0,   220,   221,     0,   222,
     223,   224,   225,   226,   227,     0,     0,   228,   229,   230,
     231,   232,     0,     0,   233,   234,     0,   235,   236,   237,
       0,     0,   238,     0,     0,     0,   239,   240,     0,   241,
       0,   242,     0,   243,   244,   245,   246,     0,   247,     0,
     248,     0,     0,     0,   249,   250,     0,   251,     0,     0,
     252,   253,     0,     0,     0,   254,   255,   256,   257,     0,
       0,   258,   259,   260,     0,     0,   261,     0,     0,     0,
       0,   262,   263,     0,     0,     0,   264,     0,     0,     0,
     265,   266,     0,   267,   268,     0,     0,     0,   269,     0,
       0,   270,   271,     0,     0,   272,     0,     0,   273,   274,
       0,     0,     0,     0,     0,   275,   276,     0,   277,     0,
     278,     0,   279,   280,     0,     0,     0,     0,     0,     0,
       0,   281,     0,   282,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
       0,   299,   300,   301,     0,   302,   303,   304,   305,     0,
     306,   307,     0,     0,     0,     0,   308,   309,   310,   311,
     312,   313,     0,     0,   314,   315,     0,   316,     0,   317,
       0,   318,   319,   320,   321,   322,   323,   324,   325,   326,
       0,     0,   327,   328,     0,     0,   329,   330,   331,   332,
       0,     0,     0,   333,   334,     0,     0,     0,   335,     0,
     336,   337,   338,     0,   339,   340,   341,     0,   342,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   343,   344,
     345,     0,   346,   347,     0,   348,   349,   350,   351,   352,
     353,   354,   355,   356,   357,     0,     0,   358,   359,   360,
       0,   361,     0,   362,   363,   364,   365,   366,     0,   367,
     368,   369,     0,     0,   370,     0,     0,     0,   371,   372,
     373,   374,   375,     0,     0,   376,   377,   378,   379,   380,
       0,   381,   382,     0,   383,   384,   385,     0,     0,   386,
       0,   387,     0,   388,   389,     0,   390,   391,   392,     0,
     393,     0,     0,   394,   395,   396,   397,   398,   399,   400,
     401,   402,   403,   404,     0,   405,   406,     0,     0,     0,
     407,   408,   409,   410,     0,     0,     0,   411,     0,     0,
       0,   412,     0,   413,   414,   415,   416,     0,   417,   418,
     419,   420,   421,     0,     0,     0,   563,     0,   422,   423,
     424,     0,   425,   426,     0,   427,     0,     0,   428,     0,
       0,   429,   430,   431,   432,   433,   434,     0,     0,   435,
     436,     0,   437,   438,   439,   440,   441,   442,     0,     0,
     443,   444,   445,   446,     0,   447,   448,     0,     0,   449,
     450,   451,   452,     0,     0,   453,   454,     0,   455,   456,
     457,   458,     0,     0,     0,     0,     0,   459,   460,     0,
       0,     0,   461,   462,   463,   464,     0,   465,   466,     0,
     467,   468,     0,   469,   470,     0,     0,   471,     0,     0,
     472,     0,   473,     0,   474,   475,     0,     0,     0,     0,
       0,     0,   476,     0,     0,   477,     0,     0,     0,   478,
     479,   480,   481,   482,     0,     0,     0,     0,     0,     0,
     483,   484,     0,   485,   486,   487,     0,   137,   488,   138,
     139,   140,   141,   142,     0,     0,   143,     0,     0,     0,
     144,     0,     0,   145,     0,   146,   147,   148,   149,   150,
     151,     0,   152,     0,     0,     0,   153,     0,     0,     0,
     154,     0,     0,   155,   156,   157,     0,   158,     0,   159,
     160,     0,     0,   161,     0,     0,   162,   163,     0,   164,
     165,     0,   166,     0,   167,   168,   169,   170,   171,   172,
       0,   173,   174,     0,   175,   176,   177,   178,   179,   180,
     181,   182,   183,     0,   184,   185,     0,   186,   187,   188,
     189,   190,     0,     0,     0,   191,     0,     0,   192,     0,
     193,     0,     0,   194,     0,     0,     0,   195,   196,   197,
       0,     0,   198,     0,     0,     0,     0,   199,   200,     0,
       0,     0,     0,   201,   202,     0,   203,     0,     0,     0,
     204,     0,   205,   206,   207,   208,   209,     0,     0,     0,
     210,     0,     0,   211,   212,   213,     0,     0,     0,   214,
       0,   215,   216,     0,   217,   218,   219,     0,     0,   220,
     221,     0,   222,   223,   224,   225,   226,   227,     0,     0,
     228,   229,   230,   231,   232,     0,     0,   233,   234,     0,
     235,   236,   237,     0,     0,   238,     0,     0,     0,   239,
     240,  1069,   241,     0,   242,     0,   243,   244,   245,   246,
       0,   247,     0,   248,     0,     0,     0,   249,   250,     0,
     251,     0,     0,   252,   253,     0,     0,     0,   254,   255,
     256,   257,     0,     0,   258,   259,   260,     0,     0,   261,
       0,     0,     0,     0,   262,   263,     0,     0,     0,   264,
       0,     0,     0,   265,   266,     0,   267,   268,     0,     0,
       0,   269,     0,     0,   270,   271,     0,     0,   272,     0,
       0,   273,   274,     0,     0,     0,     0,     0,   275,   276,
       0,   277,     0,   278,     0,   279,   280,     0,     0,     0,
       0,     0,     0,     0,   281,     0,   282,   283,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,     0,   299,   300,   301,     0,   302,   303,
     304,   305,     0,   306,   307,     0,     0,     0,     0,   308,
     309,   310,   311,   312,   313,     0,     0,   314,   315,     0,
     316,     0,   317,     0,   318,   319,   320,   321,   322,   323,
     324,   325,   326,     0,     0,   327,   328,     0,     0,   329,
     330,   331,   332,     0,     0,     0,   333,   334,     0,     0,
       0,   335,     0,   336,   337,   338,     0,   339,   340,   341,
       0,   342,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   343,   344,   345,     0,   346,   347,     0,   348,   349,
     350,   351,   352,   353,   354,   355,   356,   357,     0,     0,
     358,   359,   360,     0,   361,     0,   362,   363,   364,   365,
     366,     0,   367,   368,   369,     0,     0,   370,     0,     0,
       0,   371,   372,   373,   374,   375,     0,     0,   376,   377,
     378,   379,   380,     0,   381,   382,     0,   383,   384,   385,
       0,     0,   386,     0,   387,     0,   388,   389,     0,   390,
     391,   392,     0,   393,     0,     0,   394,   395,   396,   397,
     398,   399,   400,   401,   402,   403,   404,     0,   405,   406,
       0,     0,     0,   407,   408,   409,   410,     0,     0,     0,
     411,     0,     0,     0,   412,     0,   413,   414,   415,   416,
       0,   417,   418,   419,   420,   421,     0,     0,     0,     0,
       0,   422,   423,   424,     0,   425,   426,     0,   427,     0,
       0,   428,     0,     0,   429,   430,   431,   432,   433,   434,
       0,     0,   435,   436,     0,   437,   438,   439,   440,   441,
     442,     0,     0,   443,   444,   445,   446,     0,   447,   448,
       0,     0,   449,   450,   451,   452,     0,     0,   453,   454,
       0,   455,   456,   457,   458,     0,     0,     0,     0,     0,
     459,   460,     0,     0,     0,   461,   462,   463,   464,     0,
     465,   466,     0,   467,   468,     0,   469,   470,     0,     0,
     471,     0,     0,   472,     0,   473,     0,   474,   475,     0,
       0,     0,     0,     0,     0,   476,     0,     0,   477,     0,
       0,     0,   478,   479,   480,   481,   482,     0,     0,     0,
       0,     0,     0,   483,   484,     0,   485,   486,   487,     0,
     137,   488,   138,   139,   140,   141,   142,     0,     0,   143,
       0,     0,     0,   144,     0,     0,   145,     0,   146,   147,
     148,   149,   150,   151,     0,   152,     0,     0,     0,   153,
       0,     0,     0,   154,     0,     0,   155,   156,   157,     0,
     158,     0,   159,   160,     0,     0,   161,     0,     0,   162,
     163,     0,   164,   165,     0,   166,     0,   167,   168,   169,
     170,   171,   172,     0,   173,   174,     0,   175,   176,   177,
     178,   179,   180,   181,   182,   183,     0,   184,   185,     0,
     186,   187,   188,   189,   190,     0,     0,     0,   191,     0,
       0,   192,     0,   193,     0,     0,   194,     0,     0,     0,
     195,   196,   197,     0,     0,   198,     0,     0,     0,     0,
     199,   200,     0,     0,     0,   900,   201,   202,     0,   203,
       0,     0,     0,   204,     0,   205,   206,   207,   208,   209,
       0,     0,     0,   210,     0,     0,   211,   212,   213,     0,
       0,     0,   214,     0,   215,   216,     0,   217,   218,   219,
       0,     0,   220,   221,     0,   222,   223,   224,   225,   226,
     227,     0,     0,   228,   229,   230,   231,   232,     0,     0,
     233,   234,     0,   235,   236,   237,     0,     0,   238,     0,
       0,     0,   239,   240,     0,   241,     0,   242,     0,   243,
     244,   245,   246,     0,   247,     0,   248,     0,     0,     0,
     249,   250,     0,   251,     0,     0,   252,   253,     0,     0,
       0,   254,   255,   256,   257,     0,     0,   258,   259,   260,
       0,     0,   261,     0,     0,     0,     0,   262,   263,     0,
       0,     0,   264,     0,     0,     0,   265,   266,     0,   267,
     268,     0,     0,     0,   269,     0,     0,   270,   271,     0,
       0,   272,     0,     0,   273,   274,     0,     0,     0,     0,
       0,   275,   276,     0,   277,     0,   278,     0,   279,   280,
       0,     0,     0,     0,     0,     0,     0,   281,     0,   282,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,     0,   299,   300,   301,
       0,   302,   303,   304,   305,     0,   306,   307,     0,     0,
       0,     0,   308,   309,   310,   311,   312,   313,     0,     0,
     314,   315,     0,   316,     0,   317,     0,   318,   319,   320,
     321,   322,   323,   324,   325,   326,     0,     0,   327,   328,
       0,     0,   329,   330,   331,   332,     0,     0,     0,   333,
     334,     0,     0,     0,   335,     0,   336,   337,   338,     0,
     339,   340,   341,     0,   342,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   343,   344,   345,     0,   346,   347,
       0,   348,   349,   350,   351,   352,   353,   354,   355,   356,
     357,     0,     0,   358,   359,   360,     0,   361,     0,   362,
     363,   364,   365,   366,     0,   367,   368,   369,     0,     0,
     370,     0,     0,     0,   371,   372,   373,   374,   375,     0,
       0,   376,   377,   378,   379,   380,     0,   381,   382,     0,
     383,   384,   385,     0,     0,   386,     0,   387,     0,   388,
     389,     0,   390,   391,   392,     0,   393,     0,     0,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
       0,   405,   406,     0,     0,     0,   407,   408,   409,   410,
       0,     0,     0,   411,     0,     0,     0,   412,     0,   413,
     414,   415,   416,     0,   417,   418,   419,   420,   421,     0,
       0,     0,     0,     0,   422,   423,   424,     0,   425,   426,
       0,   427,     0,     0,   428,     0,     0,   429,   430,   431,
     432,   433,   434,     0,     0,   435,   436,     0,   437,   438,
     439,   440,   441,   442,     0,     0,   443,   444,   445,   446,
       0,   447,   448,     0,     0,   449,   450,   451,   452,     0,
       0,   453,   454,     0,   455,   456,   457,   458,     0,     0,
       0,     0,     0,  1875,   460,     0,     0,     0,   461,   462,
     463,   464,     0,   465,   466,     0,   467,   468,     0,   469,
     470,     0,     0,   471,     0,     0,   472,     0,   473,     0,
     474,   475,     0,     0,     0,     0,     0,     0,   476,     0,
       0,   477,     0,     0,     0,   478,   479,   480,   481,   482,
       0,     0,     0,     0,     0,     0,   483,   484,     0,   485,
     486,   487,     0,   137,   488,   138,   139,   140,   141,   142,
       0,     0,   143,     0,     0,     0,   144,     0,     0,   145,
       0,   146,   147,   148,   149,   150,   151,     0,   152,     0,
       0,     0,   153,     0,     0,     0,   154,     0,     0,   155,
     156,   157,     0,   158,     0,   159,   160,     0,     0,   161,
       0,     0,   162,   163,     0,   164,   165,     0,   166,     0,
     167,   168,   169,   170,   171,   172,     0,   173,   174,     0,
     175,   176,   177,   178,   179,   180,   181,   182,   183,     0,
     184,   185,     0,   186,   187,   188,   189,   190,     0,     0,
       0,   191,     0,     0,   192,     0,   193,     0,     0,   194,
       0,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,   200,     0,     0,     0,  2071,   201,
     202,     0,   203,     0,     0,     0,   204,     0,   205,   206,
     207,   208,   209,     0,     0,     0,   210,     0,     0,   211,
     212,   213,     0,     0,     0,   214,     0,   215,   216,     0,
     217,   218,   219,     0,     0,   220,   221,     0,   222,   223,
     224,   225,   226,   227,     0,     0,   228,   229,   230,   231,
     232,     0,     0,   233,   234,     0,   235,   236,   237,     0,
       0,   238,     0,     0,     0,   239,   240,     0,   241,     0,
     242,     0,   243,   244,   245,   246,     0,   247,     0,   248,
       0,     0,     0,   249,   250,     0,   251,     0,     0,   252,
     253,     0,     0,     0,   254,   255,   256,   257,     0,     0,
     258,   259,   260,     0,     0,   261,     0,     0,     0,     0,
     262,   263,     0,     0,     0,   264,     0,     0,     0,   265,
     266,     0,   267,   268,     0,     0,     0,   269,     0,     0,
     270,   271,     0,     0,   272,     0,     0,   273,   274,     0,
       0,     0,     0,     0,   275,   276,     0,   277,     0,   278,
       0,   279,   280,     0,     0,     0,     0,     0,     0,     0,
     281,     0,   282,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,     0,
     299,   300,   301,     0,   302,   303,   304,   305,     0,   306,
     307,     0,     0,     0,     0,   308,   309,   310,   311,   312,
     313,     0,     0,   314,   315,     0,   316,     0,   317,     0,
     318,   319,   320,   321,   322,   323,   324,   325,   326,     0,
       0,   327,   328,     0,     0,   329,   330,   331,   332,     0,
       0,     0,   333,   334,     0,     0,     0,   335,     0,   336,
     337,   338,     0,   339,   340,   341,     0,   342,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   343,   344,   345,
       0,   346,   347,     0,   348,   349,   350,   351,   352,   353,
     354,   355,   356,   357,     0,     0,   358,   359,   360,     0,
     361,     0,   362,   363,   364,   365,   366,     0,   367,   368,
     369,     0,     0,   370,     0,     0,     0,   371,   372,   373,
     374,   375,     0,     0,   376,   377,   378,   379,   380,     0,
     381,   382,     0,   383,   384,   385,     0,     0,   386,     0,
     387,     0,   388,   389,     0,   390,   391,   392,     0,   393,
       0,     0,   394,   395,   396,   397,   398,   399,   400,   401,
     402,   403,   404,     0,   405,   406,     0,     0,     0,   407,
     408,   409,   410,     0,     0,     0,   411,     0,     0,     0,
     412,     0,   413,   414,   415,   416,     0,   417,   418,   419,
     420,   421,     0,     0,     0,     0,     0,   422,   423,   424,
       0,   425,   426,     0,   427,     0,     0,   428,     0,     0,
     429,   430,   431,   432,   433,   434,     0,     0,   435,   436,
       0,   437,   438,   439,   440,   441,   442,     0,     0,   443,
     444,   445,   446,     0,   447,   448,     0,     0,   449,   450,
     451,   452,     0,     0,   453,   454,     0,   455,   456,   457,
     458,     0,     0,     0,     0,     0,   459,   460,     0,     0,
       0,   461,   462,   463,   464,     0,   465,   466,     0,   467,
     468,     0,   469,   470,     0,     0,   471,     0,     0,   472,
       0,   473,     0,   474,   475,     0,     0,     0,     0,     0,
       0,   476,     0,     0,   477,     0,     0,     0,   478,   479,
     480,   481,   482,     0,     0,     0,     0,     0,     0,   483,
     484,     0,   485,   486,   487,     0,   137,   488,   138,   139,
     140,   141,   142,     0,     0,   143,     0,     0,     0,   144,
       0,     0,   145,     0,   146,   147,   148,   149,   150,   151,
       0,   152,     0,     0,     0,   153,     0,     0,     0,   154,
       0,     0,   155,   156,   157,     0,   158,     0,   159,   160,
       0,     0,   161,     0,     0,   162,   163,     0,   164,   165,
       0,   166,     0,   167,   168,   169,   170,   171,   172,     0,
     173,   174,     0,   175,   176,   177,   178,   179,   180,   181,
     182,   183,     0,   184,   185,     0,   186,   187,   188,   189,
     190,     0,     0,     0,   191,     0,     0,   192,     0,   193,
       0,     0,   194,     0,     0,     0,   195,   196,   197,     0,
       0,   198,     0,     0,     0,     0,   199,   200,     0,     0,
       0,   900,   201,   202,     0,   203,     0,     0,     0,   204,
       0,   205,   206,   207,   208,   209,     0,     0,     0,   210,
       0,     0,   211,   212,   213,     0,     0,     0,   214,     0,
     215,   216,     0,   217,   218,   219,     0,     0,   220,   221,
       0,   222,   223,   224,   225,   226,   227,     0,     0,   228,
     229,   230,   231,   232,     0,     0,   233,   234,     0,   235,
     236,   237,     0,     0,   238,     0,     0,     0,   239,   240,
       0,   241,     0,   242,     0,   243,   244,   245,   246,     0,
     247,     0,   248,     0,     0,     0,   249,   250,     0,   251,
       0,     0,   252,   253,     0,     0,     0,   254,   255,   256,
     257,     0,     0,   258,   259,   260,     0,     0,   261,     0,
       0,     0,     0,   262,   263,     0,     0,     0,   264,     0,
       0,     0,   265,   266,     0,   267,   268,     0,     0,     0,
     269,     0,     0,   270,   271,     0,     0,   272,     0,     0,
     273,   274,     0,     0,     0,     0,     0,   275,   276,     0,
     277,     0,   278,     0,   279,   280,     0,     0,     0,     0,
       0,     0,     0,   281,     0,   282,   283,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,     0,   299,   300,   301,     0,   302,   303,   304,
     305,     0,   306,   307,     0,     0,     0,     0,   308,   309,
     310,   311,   312,   313,     0,     0,   314,   315,     0,   316,
       0,   317,     0,   318,   319,   320,   321,   322,   323,   324,
     325,   326,     0,     0,   327,   328,     0,     0,   329,   330,
     331,   332,     0,     0,     0,   333,   334,     0,     0,     0,
     335,     0,   336,   337,   338,     0,   339,   340,   341,     0,
     342,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     343,   344,   345,     0,   346,   347,     0,   348,   349,   350,
     351,   352,   353,   354,   355,   356,   357,     0,     0,   358,
     359,   360,     0,   361,     0,   362,   363,   364,   365,   366,
       0,   367,   368,   369,     0,     0,   370,     0,     0,     0,
     371,   372,   373,   374,   375,     0,     0,   376,   377,   378,
     379,   380,     0,   381,   382,     0,   383,   384,   385,     0,
       0,   386,     0,   387,     0,   388,   389,     0,   390,   391,
     392,     0,   393,     0,     0,   394,   395,   396,   397,   398,
     399,   400,   401,   402,   403,   404,     0,   405,   406,     0,
       0,     0,   407,   408,   409,   410,     0,     0,     0,   411,
       0,     0,     0,   412,     0,   413,   414,   415,   416,     0,
     417,   418,   419,   420,   421,     0,     0,     0,     0,     0,
     422,   423,   424,     0,   425,   426,     0,   427,     0,     0,
     428,     0,     0,   429,   430,   431,   432,   433,   434,     0,
       0,   435,   436,     0,   437,   438,   439,   440,   441,   442,
       0,     0,   443,   444,   445,   446,     0,   447,   448,     0,
       0,   449,   450,   451,   452,     0,     0,   453,   454,     0,
     455,   456,   457,   458,     0,     0,     0,     0,     0,   459,
     460,     0,     0,     0,   461,   462,   463,   464,     0,   465,
     466,     0,   467,   468,     0,   469,   470,     0,     0,   471,
       0,     0,   472,     0,   473,     0,   474,   475,     0,     0,
       0,     0,     0,     0,   476,     0,     0,   477,     0,     0,
       0,   478,   479,   480,   481,   482,     0,     0,     0,     0,
       0,     0,   483,   484,     0,   485,   486,   487,     0,   137,
     488,   138,   139,   140,   141,   142,     0,     0,   143,     0,
       0,     0,   144,     0,     0,   145,     0,   146,   147,   148,
     149,   150,   151,     0,   152,     0,     0,     0,   153,     0,
       0,     0,   154,     0,     0,   155,   156,   157,     0,   158,
       0,   159,   160,     0,     0,   161,     0,     0,   162,   163,
       0,   164,   165,     0,   166,     0,   167,   168,   169,   170,
     171,   172,     0,   173,   174,     0,   175,   176,   177,   178,
     179,   180,   181,   182,   183,     0,   184,   185,     0,   186,
     187,   188,   189,   190,     0,     0,     0,   191,     0,     0,
     192,     0,   193,     0,     0,   194,     0,     0,     0,   195,
     196,   197,     0,     0,   198,     0,     0,     0,     0,   199,
     200,     0,     0,     0,  2955,   201,   202,     0,   203,     0,
       0,     0,   204,     0,   205,   206,   207,   208,   209,     0,
       0,     0,   210,     0,     0,   211,   212,   213,     0,     0,
       0,   214,     0,   215,   216,     0,   217,   218,   219,     0,
       0,   220,   221,     0,   222,   223,   224,   225,   226,   227,
       0,     0,   228,   229,   230,   231,   232,     0,     0,   233,
     234,     0,   235,   236,   237,     0,     0,   238,     0,     0,
       0,   239,   240,     0,   241,     0,   242,     0,   243,   244,
     245,   246,     0,   247,     0,   248,     0,     0,     0,   249,
     250,     0,   251,     0,     0,   252,   253,     0,     0,     0,
     254,   255,   256,   257,     0,     0,   258,   259,   260,     0,
       0,   261,     0,     0,     0,     0,   262,   263,     0,     0,
       0,   264,     0,     0,     0,   265,   266,     0,   267,   268,
       0,     0,     0,   269,     0,     0,   270,   271,     0,     0,
     272,     0,     0,   273,   274,     0,     0,     0,     0,     0,
     275,   276,     0,   277,     0,   278,     0,   279,   280,     0,
       0,     0,     0,     0,     0,     0,   281,     0,   282,   283,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,   296,   297,   298,     0,   299,   300,   301,     0,
     302,   303,   304,   305,     0,   306,   307,     0,     0,     0,
       0,   308,   309,   310,   311,   312,   313,     0,     0,   314,
     315,     0,   316,     0,   317,     0,   318,   319,   320,   321,
     322,   323,   324,   325,   326,     0,     0,   327,   328,     0,
       0,   329,   330,   331,   332,     0,     0,     0,   333,   334,
       0,     0,     0,   335,     0,   336,   337,   338,     0,   339,
     340,   341,     0,   342,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   343,   344,   345,     0,   346,   347,     0,
     348,   349,   350,   351,   352,   353,   354,   355,   356,   357,
       0,     0,   358,   359,   360,     0,   361,     0,   362,   363,
     364,   365,   366,     0,   367,   368,   369,     0,     0,   370,
       0,     0,     0,   371,   372,   373,   374,   375,     0,     0,
     376,   377,   378,   379,   380,     0,   381,   382,     0,   383,
     384,   385,     0,     0,   386,     0,   387,     0,   388,   389,
       0,   390,   391,   392,     0,   393,     0,     0,   394,   395,
     396,   397,   398,   399,   400,   401,   402,   403,   404,     0,
     405,   406,     0,     0,     0,   407,   408,   409,   410,     0,
       0,     0,   411,     0,     0,     0,   412,     0,   413,   414,
     415,   416,     0,   417,   418,   419,   420,   421,     0,     0,
       0,     0,     0,   422,   423,   424,     0,   425,   426,     0,
     427,     0,     0,   428,     0,     0,   429,   430,   431,   432,
     433,   434,     0,     0,   435,   436,     0,   437,   438,   439,
     440,   441,   442,     0,     0,   443,   444,   445,   446,     0,
     447,   448,     0,     0,   449,   450,   451,   452,     0,     0,
     453,   454,     0,   455,   456,   457,   458,     0,     0,     0,
       0,     0,   459,   460,     0,     0,     0,   461,   462,   463,
     464,     0,   465,   466,     0,   467,   468,     0,   469,   470,
       0,     0,   471,     0,     0,   472,     0,   473,     0,   474,
     475,     0,     0,     0,     0,     0,     0,   476,     0,     0,
     477,     0,     0,     0,   478,   479,   480,   481,   482,     0,
       0,     0,     0,     0,     0,   483,   484,     0,   485,   486,
     487,     0,   137,   488,   138,   139,   140,   141,   142,  2963,
       0,   143,     0,     0,     0,   144,     0,     0,   145,     0,
     146,   147,   148,   149,   150,   151,     0,   152,     0,     0,
       0,   153,     0,     0,     0,   154,     0,     0,   155,   156,
     157,     0,   158,     0,   159,   160,     0,     0,   161,     0,
       0,   162,   163,     0,   164,   165,     0,   166,     0,   167,
     168,   169,   170,   171,   172,     0,   173,   174,     0,   175,
     176,   177,   178,   179,   180,   181,   182,   183,     0,   184,
     185,     0,   186,   187,   188,   189,   190,     0,     0,     0,
     191,     0,     0,   192,     0,   193,     0,     0,   194,     0,
       0,     0,   195,   196,   197,     0,     0,   198,     0,     0,
       0,     0,   199,   200,     0,     0,     0,     0,   201,   202,
       0,   203,     0,     0,     0,   204,     0,   205,   206,   207,
     208,   209,     0,     0,     0,   210,     0,     0,   211,   212,
     213,     0,     0,     0,   214,     0,   215,   216,     0,   217,
     218,   219,     0,     0,   220,   221,     0,   222,   223,   224,
     225,   226,   227,     0,     0,   228,   229,   230,   231,   232,
       0,     0,   233,   234,     0,   235,   236,   237,     0,     0,
     238,     0,     0,     0,   239,   240,     0,   241,     0,   242,
       0,   243,   244,   245,   246,     0,   247,     0,   248,     0,
       0,     0,   249,   250,     0,   251,     0,     0,   252,   253,
       0,     0,     0,   254,   255,   256,   257,     0,     0,   258,
     259,   260,     0,     0,   261,     0,     0,     0,     0,   262,
     263,     0,     0,     0,   264,     0,     0,     0,   265,   266,
       0,   267,   268,     0,     0,     0,   269,     0,     0,   270,
     271,     0,     0,   272,     0,     0,   273,   274,     0,     0,
       0,     0,     0,   275,   276,     0,   277,     0,   278,     0,
     279,   280,     0,     0,     0,     0,     0,     0,     0,   281,
       0,   282,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,     0,   299,
     300,   301,     0,   302,   303,   304,   305,     0,   306,   307,
       0,     0,     0,     0,   308,   309,   310,   311,   312,   313,
       0,     0,   314,   315,     0,   316,     0,   317,     0,   318,
     319,   320,   321,   322,   323,   324,   325,   326,     0,     0,
     327,   328,     0,     0,   329,   330,   331,   332,     0,     0,
       0,   333,   334,     0,     0,     0,   335,     0,   336,   337,
     338,     0,   339,   340,   341,     0,   342,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   343,   344,   345,     0,
     346,   347,     0,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,     0,     0,   358,   359,   360,     0,   361,
       0,   362,   363,   364,   365,   366,     0,   367,   368,   369,
       0,     0,   370,     0,     0,     0,   371,   372,   373,   374,
     375,     0,     0,   376,   377,   378,   379,   380,     0,   381,
     382,     0,   383,   384,   385,     0,     0,   386,     0,   387,
       0,   388,   389,     0,   390,   391,   392,     0,   393,     0,
       0,   394,   395,   396,   397,   398,   399,   400,   401,   402,
     403,   404,     0,   405,   406,     0,     0,     0,   407,   408,
     409,   410,     0,     0,     0,   411,     0,     0,     0,   412,
       0,   413,   414,   415,   416,     0,   417,   418,   419,   420,
     421,     0,     0,     0,     0,     0,   422,   423,   424,     0,
     425,   426,     0,   427,     0,     0,   428,     0,     0,   429,
     430,   431,   432,   433,   434,     0,     0,   435,   436,     0,
     437,   438,   439,   440,   441,   442,     0,     0,   443,   444,
     445,   446,     0,   447,   448,     0,     0,   449,   450,   451,
     452,     0,     0,   453,   454,     0,   455,   456,   457,   458,
       0,     0,     0,     0,     0,   459,   460,     0,     0,     0,
     461,   462,   463,   464,     0,   465,   466,     0,   467,   468,
       0,   469,   470,     0,     0,   471,     0,     0,   472,     0,
     473,     0,   474,   475,     0,     0,     0,     0,     0,     0,
     476,     0,     0,   477,     0,     0,     0,   478,   479,   480,
     481,   482,     0,     0,     0,     0,     0,     0,   483,   484,
       0,   485,   486,   487,     0,   137,   488,   138,   139,   140,
     141,   142,     0,     0,   143,     0,     0,     0,   144,     0,
       0,   145,     0,   146,   147,   148,   149,   150,   151,     0,
     152,     0,     0,     0,   153,     0,     0,     0,   154,     0,
       0,   155,   156,   157,     0,   158,     0,   159,   160,     0,
       0,   161,     0,     0,   162,   163,     0,   164,   165,     0,
     166,     0,   167,   168,   169,   170,   171,   172,     0,   173,
     174,     0,   175,   176,   177,   178,   179,   180,   181,   182,
     183,     0,   184,   185,     0,   186,   187,   188,   189,   190,
       0,     0,     0,   191,     0,     0,   192,     0,   193,     0,
       0,   194,     0,     0,     0,   195,   196,   197,     0,     0,
     198,     0,     0,     0,     0,   199,   200,     0,     0,     0,
    2987,   201,   202,     0,   203,     0,     0,     0,   204,     0,
     205,   206,   207,   208,   209,     0,     0,     0,   210,     0,
       0,   211,   212,   213,     0,     0,     0,   214,     0,   215,
     216,     0,   217,   218,   219,     0,     0,   220,   221,     0,
     222,   223,   224,   225,   226,   227,     0,     0,   228,   229,
     230,   231,   232,     0,     0,   233,   234,     0,   235,   236,
     237,     0,     0,   238,     0,     0,     0,   239,   240,     0,
     241,     0,   242,     0,   243,   244,   245,   246,     0,   247,
       0,   248,     0,     0,     0,   249,   250,     0,   251,     0,
       0,   252,   253,     0,     0,     0,   254,   255,   256,   257,
       0,     0,   258,   259,   260,     0,     0,   261,     0,     0,
       0,     0,   262,   263,     0,     0,     0,   264,     0,     0,
       0,   265,   266,     0,   267,   268,     0,     0,     0,   269,
       0,     0,   270,   271,     0,     0,   272,     0,     0,   273,
     274,     0,     0,     0,     0,     0,   275,   276,     0,   277,
       0,   278,     0,   279,   280,     0,     0,     0,     0,     0,
       0,     0,   281,     0,   282,   283,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,     0,   299,   300,   301,     0,   302,   303,   304,   305,
       0,   306,   307,     0,     0,     0,     0,   308,   309,   310,
     311,   312,   313,     0,     0,   314,   315,     0,   316,     0,
     317,     0,   318,   319,   320,   321,   322,   323,   324,   325,
     326,     0,     0,   327,   328,     0,     0,   329,   330,   331,
     332,     0,     0,     0,   333,   334,     0,     0,     0,   335,
       0,   336,   337,   338,     0,   339,   340,   341,     0,   342,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   343,
     344,   345,     0,   346,   347,     0,   348,   349,   350,   351,
     352,   353,   354,   355,   356,   357,     0,     0,   358,   359,
     360,     0,   361,     0,   362,   363,   364,   365,   366,     0,
     367,   368,   369,     0,     0,   370,     0,     0,     0,   371,
     372,   373,   374,   375,     0,     0,   376,   377,   378,   379,
     380,     0,   381,   382,     0,   383,   384,   385,     0,     0,
     386,     0,   387,     0,   388,   389,     0,   390,   391,   392,
       0,   393,     0,     0,   394,   395,   396,   397,   398,   399,
     400,   401,   402,   403,   404,     0,   405,   406,     0,     0,
       0,   407,   408,   409,   410,     0,     0,     0,   411,     0,
       0,     0,   412,     0,   413,   414,   415,   416,     0,   417,
     418,   419,   420,   421,     0,     0,     0,     0,     0,   422,
     423,   424,     0,   425,   426,     0,   427,     0,     0,   428,
       0,     0,   429,   430,   431,   432,   433,   434,     0,     0,
     435,   436,     0,   437,   438,   439,   440,   441,   442,     0,
       0,   443,   444,   445,   446,     0,   447,   448,     0,     0,
     449,   450,   451,   452,     0,     0,   453,   454,     0,   455,
     456,   457,   458,     0,     0,     0,     0,     0,   459,   460,
       0,     0,     0,   461,   462,   463,   464,     0,   465,   466,
       0,   467,   468,     0,   469,   470,     0,     0,   471,     0,
       0,   472,     0,   473,     0,   474,   475,     0,     0,     0,
       0,     0,     0,   476,     0,     0,   477,     0,     0,     0,
     478,   479,   480,   481,   482,     0,     0,     0,     0,     0,
       0,   483,   484,     0,   485,   486,   487,     0,   137,   488,
     138,   139,   140,   141,   142,     0,     0,   143,     0,     0,
       0,   144,     0,     0,   145,     0,   146,   147,   148,   149,
     150,   151,     0,   152,     0,     0,     0,   153,     0,     0,
       0,   154,     0,     0,   155,   156,   157,     0,   158,     0,
     159,   160,     0,     0,   161,     0,     0,   162,   163,     0,
     164,   165,     0,   166,     0,   167,   168,   169,   170,   171,
     172,     0,   173,   174,     0,   175,   176,   177,   178,   179,
     180,   181,   182,   183,     0,   184,   185,     0,   186,   187,
     188,   189,   190,     0,     0,     0,   191,     0,     0,   192,
       0,   193,     0,     0,   194,     0,     0,     0,   195,   196,
     197,     0,     0,   198,     0,     0,     0,     0,   199,   200,
       0,     0,     0,     0,   201,   202,     0,   203,     0,     0,
       0,   204,     0,   205,   206,   207,   208,   209,     0,     0,
       0,   210,     0,     0,   211,   212,   213,     0,     0,     0,
     214,     0,   215,   216,     0,   217,   218,   219,     0,     0,
     220,   221,     0,   222,   223,   224,   225,   226,   227,     0,
       0,   228,   229,   230,   231,   232,     0,     0,   233,   234,
       0,   235,   236,   237,     0,     0,   238,     0,     0,     0,
     239,   240,     0,   241,     0,   242,     0,   243,   244,   245,
     246,     0,   247,     0,   248,     0,     0,     0,   249,   250,
       0,   251,     0,     0,   252,   253,     0,     0,     0,   254,
     255,   256,   257,     0,     0,   258,   259,   260,     0,     0,
     261,     0,     0,     0,     0,   262,   263,     0,     0,     0,
     264,     0,     0,     0,   265,   266,     0,   267,   268,     0,
       0,     0,   269,     0,     0,   270,   271,     0,     0,   272,
       0,     0,   273,   274,     0,     0,     0,     0,     0,   275,
     276,     0,   277,     0,   278,     0,   279,   280,     0,     0,
       0,     0,     0,     0,     0,   281,     0,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,     0,   299,   300,   301,     0,   302,
     303,   304,   305,     0,   306,   307,     0,     0,     0,     0,
     308,   309,   310,   311,   312,   313,     0,     0,   314,   315,
       0,   316,     0,   317,     0,   318,   319,   320,   321,   322,
     323,   324,   325,   326,     0,     0,   327,   328,     0,     0,
     329,   330,   331,   332,     0,     0,     0,   333,   334,     0,
       0,     0,   335,     0,   336,   337,   338,     0,   339,   340,
     341,     0,   342,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   343,   344,   345,     0,   346,   347,     0,   348,
     349,   350,   351,   352,   353,   354,   355,   356,   357,     0,
       0,   358,   359,   360,  3051,   361,     0,   362,   363,   364,
     365,   366,     0,   367,   368,   369,     0,     0,   370,     0,
       0,     0,   371,   372,   373,   374,   375,     0,     0,   376,
     377,   378,   379,   380,     0,   381,   382,     0,   383,   384,
     385,     0,     0,   386,     0,   387,     0,   388,   389,     0,
     390,   391,   392,     0,   393,     0,     0,   394,   395,   396,
     397,   398,   399,   400,   401,   402,   403,   404,     0,   405,
     406,     0,     0,     0,   407,   408,   409,   410,     0,     0,
       0,   411,     0,     0,     0,   412,     0,   413,   414,   415,
     416,     0,   417,   418,   419,   420,   421,     0,     0,     0,
       0,     0,   422,   423,   424,     0,   425,   426,     0,   427,
       0,     0,   428,     0,     0,   429,   430,   431,   432,   433,
     434,     0,     0,   435,   436,     0,   437,   438,   439,   440,
     441,   442,     0,     0,   443,   444,   445,   446,     0,   447,
     448,     0,     0,   449,   450,   451,   452,     0,     0,   453,
     454,     0,   455,   456,   457,   458,     0,     0,     0,     0,
       0,   459,   460,     0,     0,     0,   461,   462,   463,   464,
       0,   465,   466,     0,   467,   468,     0,   469,   470,     0,
       0,   471,     0,     0,   472,     0,   473,     0,   474,   475,
       0,     0,     0,     0,     0,     0,   476,     0,     0,   477,
       0,     0,     0,   478,   479,   480,   481,   482,     0,     0,
       0,     0,     0,     0,   483,   484,     0,   485,   486,   487,
       0,   137,   488,   138,   139,   140,   141,   142,     0,     0,
     143,     0,     0,     0,   144,     0,     0,   145,     0,   146,
     147,   148,   149,   150,   151,     0,   152,     0,     0,     0,
     153,     0,     0,     0,   154,     0,     0,   155,   156,   157,
       0,   158,     0,   159,   160,     0,     0,   161,     0,     0,
     162,   163,     0,   164,   165,     0,   166,     0,   167,   168,
     169,   170,   171,   172,     0,   173,   174,     0,   175,   176,
     177,   178,   179,   180,   181,   182,   183,     0,   184,   185,
       0,   186,   187,   188,   189,   190,     0,     0,     0,   191,
       0,     0,   192,     0,   193,     0,     0,   194,     0,     0,
       0,   195,   196,   197,     0,     0,   198,     0,     0,     0,
       0,   199,   200,     0,     0,     0,     0,   201,   202,     0,
     203,     0,     0,     0,   204,     0,   205,   206,   207,   208,
     209,     0,     0,     0,   210,     0,     0,   211,   212,   213,
       0,     0,     0,   214,     0,   215,   216,     0,   217,   218,
     219,     0,     0,   220,   221,     0,   222,   223,   224,   225,
     226,   227,     0,     0,   228,   229,   230,   231,   232,     0,
       0,   233,   234,     0,   235,   236,   237,     0,     0,   238,
       0,     0,     0,   239,   240,     0,   241,     0,   242,     0,
     243,   244,   245,   246,     0,   247,     0,   248,     0,     0,
       0,   249,   250,     0,   251,     0,     0,   252,   253,     0,
       0,     0,   254,   255,   256,   257,     0,     0,   258,   259,
     260,     0,     0,   261,     0,     0,     0,     0,   262,   263,
       0,     0,     0,   264,     0,     0,     0,   265,   266,     0,
     267,   268,     0,     0,     0,   269,     0,     0,   270,   271,
       0,     0,   272,     0,     0,   273,   274,     0,     0,     0,
       0,     0,   275,   276,     0,   277,     0,   278,     0,   279,
     280,     0,     0,     0,     0,     0,     0,     0,   281,     0,
     282,   283,   284,   285,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,     0,   299,   300,
     301,     0,   302,   303,   304,   305,     0,   306,   307,     0,
       0,     0,     0,   308,   309,   310,   311,   312,   313,     0,
       0,   314,   315,     0,   316,     0,   317,     0,   318,   319,
     320,   321,   322,   323,   324,   325,   326,     0,     0,   327,
     328,     0,     0,   329,   330,   331,   332,     0,     0,     0,
     333,   334,     0,     0,     0,   335,     0,   336,   337,   338,
       0,   339,   340,   341,     0,   342,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   343,   344,   345,     0,   346,
     347,     0,   348,   349,   350,   351,   352,   353,   354,   355,
     356,   357,     0,     0,   358,   359,   360,     0,   361,     0,
     362,   363,   364,   365,   366,     0,   367,   368,   369,     0,
       0,   370,     0,     0,     0,   371,   372,   373,   374,   375,
       0,     0,   376,   377,   378,   379,   380,     0,   381,   382,
       0,   383,   384,   385,     0,     0,   386,     0,   387,     0,
     388,   389,     0,   390,   391,   392,     0,   393,     0,     0,
     394,   395,   396,   397,   398,   399,   400,   401,   402,   403,
     404,     0,   405,   406,     0,     0,     0,   407,   408,   409,
     410,     0,     0,     0,   411,     0,     0,     0,   412,     0,
     413,   414,   415,   416,     0,   417,   418,   419,   420,   421,
       0,     0,     0,     0,     0,   422,   423,   424,     0,   425,
     426,     0,   427,     0,     0,   428,     0,     0,   429,   430,
     431,   432,   433,   434,     0,     0,   435,   436,     0,   437,
     438,   439,   440,   441,   442,     0,     0,   443,   444,   445,
     446,     0,   447,   448,     0,     0,   449,   450,   451,   452,
       0,   134,   453,   454,     0,   455,   456,   457,   458,     0,
       0,     0,     0,     0,   459,   460,     0,     0,     0,   461,
     462,   463,   464,     0,   465,   466,     0,   467,   468,     0,
     469,   470,     0,     0,   471,     0,     0,   472,     0,   473,
       0,   474,   475,     0,     0,     0,     0,     0,     0,   476,
       0,     0,   477,     0,     0,     0,   478,   479,   480,   481,
     482,     0,     0,     0,     0,     0,     0,   483,   484,     0,
     485,   486,   487,     0,   137,   488,   138,   139,   140,   141,
     142,     0,     0,   143,     0,     0,     0,   144,     0,     0,
     145,     0,   146,   147,   148,   149,   150,   151,     0,   152,
       0,     0,     0,   153,     0,     0,     0,   154,     0,     0,
     155,   156,   157,     0,   158,     0,   159,   160,     0,     0,
     161,     0,     0,   162,   163,     0,   164,   165,     0,   166,
       0,   167,   168,   169,   170,   171,   172,     0,   173,   174,
       0,   175,   176,   177,   178,   179,   180,   181,   182,   183,
       0,   184,   185,     0,   186,   187,   188,   189,   190,     0,
       0,     0,   191,     0,     0,   192,     0,   193,     0,     0,
     194,     0,     0,     0,   195,   196,   197,     0,     0,   198,
       0,     0,     0,     0,   199,   200,     0,     0,     0,     0,
     201,   202,     0,   203,     0,     0,     0,   204,     0,   205,
     206,   207,   208,   209,     0,     0,     0,   210,     0,     0,
     211,   212,   213,     0,     0,     0,   214,     0,   215,   216,
       0,   217,   218,   219,     0,     0,   220,   221,     0,   222,
     223,   224,   225,   226,   227,     0,     0,   228,   229,   230,
     231,   232,     0,     0,   233,   234,     0,   235,   236,   237,
       0,     0,   238,     0,     0,     0,   239,   240,     0,   241,
       0,   242,     0,   243,   244,   245,   246,     0,   247,     0,
     248,     0,     0,     0,   249,   250,     0,   251,     0,     0,
     252,   253,     0,     0,     0,   254,   255,   256,   257,     0,
       0,   258,   259,   260,     0,     0,   261,     0,     0,     0,
       0,   262,   263,     0,     0,     0,   264,     0,     0,     0,
     265,   266,     0,   267,   268,     0,     0,     0,   269,     0,
       0,   270,   271,     0,     0,   272,     0,     0,   273,   274,
       0,     0,     0,     0,     0,   275,   276,     0,   277,     0,
     278,     0,   279,   280,     0,     0,     0,     0,     0,     0,
       0,   281,     0,   282,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
       0,   299,   300,   301,     0,   302,   303,   304,   305,     0,
     306,   307,     0,     0,     0,     0,   308,   309,   310,   311,
     312,   313,     0,     0,   314,   315,     0,   316,     0,   317,
       0,   318,   319,   320,   321,   322,   323,   324,   325,   326,
       0,     0,   327,   328,     0,     0,   329,   330,   331,   332,
       0,     0,     0,   333,   334,     0,     0,     0,   335,     0,
     336,   337,   338,     0,   339,   340,   341,     0,   342,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   343,   344,
     345,     0,   346,   347,     0,   348,   349,   350,   351,   352,
     353,   354,   355,   356,   357,     0,     0,   358,   359,   360,
       0,   361,     0,   362,   363,   364,   365,   366,     0,   367,
     368,   369,     0,     0,   370,     0,     0,     0,   371,   372,
     373,   374,   375,     0,     0,   376,   377,   378,   379,   380,
       0,   381,   382,     0,   383,   384,   385,     0,     0,   386,
       0,   387,     0,   388,   389,     0,   390,   391,   392,     0,
     393,     0,     0,   394,   395,   396,   397,   398,   399,   400,
     401,   402,   403,   404,     0,   405,   406,     0,     0,     0,
     407,   408,   409,   410,     0,     0,     0,   411,     0,     0,
       0,   412,     0,   413,   414,   415,   416,     0,   417,   418,
     419,   420,   421,     0,     0,     0,     0,     0,   422,   423,
     424,     0,   425,   426,     0,   427,     0,     0,   428,     0,
       0,   429,   430,   431,   432,   433,   434,     0,     0,   435,
     436,     0,   437,   438,   439,   440,   441,   442,     0,     0,
     443,   444,   445,   446,     0,   447,   448,     0,     0,   449,
     450,   451,   452,     0,     0,   453,   454,     0,   455,   456,
     457,   458,     0,     0,     0,     0,     0,   459,   460,     0,
       0,     0,   461,   462,   463,   464,     0,   465,   466,     0,
     467,   468,     0,   469,   470,     0,     0,   471,     0,     0,
     472,     0,   473,     0,   474,   475,     0,     0,     0,     0,
       0,     0,   476,     0,     0,   477,     0,     0,     0,   478,
     479,   480,   481,   482,     0,     0,     0,     0,     0,     0,
     483,   484,     0,   485,   486,   487,     0,   137,   488,   138,
     139,   140,   141,   142,     0,     0,   143,     0,     0,     0,
     144,     0,     0,   145,     0,   146,   147,   148,   149,   150,
     151,     0,   152,     0,     0,     0,   153,     0,     0,     0,
     154,     0,     0,   155,   156,   157,     0,   158,     0,   159,
     160,     0,     0,   161,     0,     0,   162,   163,     0,   164,
     165,     0,   166,     0,   167,   168,   169,   170,   171,   172,
       0,   173,   174,     0,   175,   176,   177,   178,   179,   180,
     181,   182,   183,     0,   184,   185,     0,   186,   187,   188,
     189,   190,     0,     0,     0,   191,     0,     0,   192,     0,
     193,     0,     0,   194,     0,     0,     0,   195,   196,   197,
       0,     0,   198,     0,     0,     0,     0,   199,   200,     0,
       0,     0,     0,   201,   202,     0,   203,     0,     0,     0,
     204,     0,   205,   206,   207,   208,   209,     0,     0,     0,
     210,     0,     0,   211,   212,   213,     0,     0,     0,   214,
       0,   215,   216,     0,   217,   218,   219,     0,     0,   220,
     221,     0,   222,   223,   224,   225,   226,   227,     0,     0,
     228,   229,   230,   231,   232,     0,     0,   233,   234,     0,
     235,  1798,   237,     0,     0,   238,     0,     0,     0,   239,
     240,     0,   241,     0,   242,     0,   243,   244,   245,   246,
       0,   247,     0,   248,     0,     0,     0,   249,   250,     0,
     251,     0,     0,   252,   253,     0,     0,     0,   254,   255,
     256,   257,     0,     0,   258,   259,   260,     0,     0,   261,
       0,     0,     0,     0,   262,   263,     0,     0,     0,   264,
       0,     0,     0,   265,   266,     0,   267,   268,     0,     0,
       0,   269,     0,     0,   270,   271,     0,     0,   272,     0,
       0,   273,   274,     0,     0,     0,     0,     0,   275,   276,
       0,   277,     0,   278,     0,   279,   280,     0,     0,     0,
       0,     0,     0,     0,   281,     0,   282,   283,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,     0,   299,   300,   301,     0,   302,   303,
     304,   305,     0,   306,   307,     0,     0,     0,     0,   308,
     309,   310,   311,   312,   313,     0,     0,   314,   315,     0,
     316,     0,   317,     0,   318,   319,   320,   321,   322,   323,
     324,   325,   326,     0,     0,   327,   328,     0,     0,   329,
    1799,   331,   332,     0,     0,     0,   333,   334,     0,     0,
       0,   335,     0,   336,   337,   338,     0,   339,   340,   341,
       0,   342,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   343,   344,   345,     0,   346,   347,     0,   348,   349,
     350,   351,   352,   353,   354,   355,   356,   357,     0,     0,
     358,   359,   360,     0,   361,     0,   362,   363,   364,   365,
     366,     0,   367,   368,   369,     0,     0,   370,     0,     0,
       0,   371,   372,   373,   374,   375,     0,     0,   376,   377,
     378,   379,   380,     0,   381,   382,     0,   383,   384,   385,
       0,     0,   386,     0,   387,     0,   388,   389,     0,   390,
     391,   392,     0,   393,     0,     0,   394,   395,   396,   397,
     398,   399,   400,   401,   402,   403,   404,     0,   405,   406,
       0,     0,     0,   407,   408,   409,   410,     0,     0,     0,
     411,     0,     0,     0,   412,     0,   413,   414,   415,   416,
       0,   417,   418,   419,   420,   421,     0,     0,     0,     0,
       0,   422,   423,   424,     0,   425,   426,     0,   427,     0,
       0,   428,     0,     0,   429,   430,   431,   432,   433,   434,
       0,     0,   435,   436,     0,   437,   438,   439,   440,   441,
     442,     0,     0,   443,   444,   445,   446,     0,   447,   448,
       0,     0,   449,   450,   451,   452,     0,     0,   453,   454,
       0,   455,   456,   457,   458,     0,     0,     0,     0,     0,
     459,   460,     0,     0,     0,   461,   462,   463,   464,     0,
     465,   466,     0,   467,   468,     0,   469,   470,     0,     0,
     471,     0,     0,   472,     0,   473,     0,   474,   475,     0,
       0,     0,     0,     0,     0,   476,     0,     0,   477,     0,
       0,     0,   478,   479,   480,   481,   482,     0,     0,     0,
       0,     0,     0,   483,   484,     0,   485,   486,   487,     0,
     137,   488,   138,   139,   140,   141,   142,     0,     0,   143,
       0,     0,     0,   144,     0,     0,     0,     0,   146,   147,
     148,   149,   150,     0,     0,  -366,     0,     0,     0,   153,
       0,     0,     0,   154,     0,     0,   155,   156,   157,     0,
     158,     0,     0,     0,     0,     0,   161,  3969,     0,   162,
     163,     0,   164,     0,     0,     0,     0,   167,   168,   169,
    3970,   171,   172,     0,   173,   174,     0,   175,   176,     0,
     178,     0,   180,   181,   182,   183,     0,   184,   185,     0,
     186,   187,   188,     0,   190,     0,     0,     0,   191,     0,
       0,   192,     0,   193,     0,     0,   194,     0,     0,     0,
     195,   196,   197,     0,     0,   198,     0,     0,     0,     0,
     199,     0,     0,     0,     0,     0,   201,   202,     0,   203,
       0,     0,     0,   204,     0,   205,   206,   207,   208,   209,
       0,     0,     0,     0,     0,     0,   211,   212,   213,     0,
    -336,  -336,   214,     0,  -336,   216,     0,   217,   218,   219,
       0,     0,   220,   221,     0,   222,   223,   224,   225,   226,
       0,     0,     0,   228,   229,   230,   231,   232,     0,     0,
     233,   234,  3971,   235,   236,   237,     0,     0,     0,     0,
       0,     0,     0,   240,     0,   241,     0,   242,     0,   243,
     244,   245,   246,     0,   247,     0,   248,     0,     0,     0,
       0,   250,     0,     0,     0,     0,     0,   253,     0,     0,
       0,   254,   255,   256,   257,  3972,     0,   258,   259,   260,
       0,     0,   261,     0,     0,     0,     0,   262,     0,     0,
       0,     0,   264,     0,     0,     0,   265,   266,     0,   267,
     268,  3973,     0,     0,   269,     0,     0,     0,   271,     0,
       0,   272,  3974,     0,   273,   274,     0,     0,     0,     0,
       0,   275,   276,     0,   277,     0,   278,     0,   279,   280,
       0,     0,     0,     0,  -321,     0,     0,   281,     0,   282,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,     0,   299,   300,   301,
       0,   302,   303,   304,   305,     0,   306,   307,     0,     0,
       0,     0,   308,   309,   310,   311,   312,   313,     0,     0,
     314,   315,     0,   316,     0,   317,     0,   318,   319,   320,
     321,   322,   323,   324,   325,   326,     0,     0,   327,   328,
       0,     0,   329,   330,   331,   332,     0,     0,     0,     0,
     334,     0,     0,     0,   335,     0,   336,   337,   338,     0,
     339,   340,  3975,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   344,   345,     0,     0,   347,
       0,   348,   349,   350,   351,   352,   353,   354,   355,   356,
       0,     0,     0,     0,   359,   360,     0,   361,     0,   362,
     363,   364,   365,   366,     0,   367,   368,   369,     0,     0,
     370,     0,     0,     0,   371,   372,   373,   374,   375,     0,
       0,   376,   377,   378,   379,   380,     0,   381,     0,     0,
     383,     0,   385,  -321,     0,   386,     0,     0,     0,   388,
       0,     0,   390,   391,   392,  3976,   393,     0,     0,     0,
     395,   396,   397,   398,   399,   400,   401,     0,   403,   404,
       0,   405,     0,     0,     0,     0,   407,   408,   409,     0,
       0,     0,     0,   411,     0,     0,     0,   412,     0,     0,
     414,     0,   416,     0,   417,     0,     0,   420,   421,     0,
       0,     0,     0,     0,   422,   423,   424,     0,   425,   426,
       0,   427,     0,     0,   428,     0,     0,   429,     0,   431,
     432,   433,   434,     0,     0,     0,   436,     0,   437,   438,
     439,   440,   441,   442,     0,     0,   443,   444,   445,   446,
       0,   447,   448,     0,     0,   449,   450,   451,   452,     0,
       0,   453,   454,     0,   455,   456,   457,   458,     0,     0,
       0,     0,     0,   459,   460,     0,     0,     0,     0,   462,
     463,   464,     0,   465,   466,     0,   467,   468,     0,     0,
       0,     0,     0,   471,     0,     0,   472,     0,     0,     0,
     474,   475,     0,     0,     0,     0,     0,     0,   476,     0,
       0,   477,     0,     0,     0,   478,   479,   480,   481,   482,
       0,     0,  -321,     0,     0,     0,   483,     0,     0,   485,
       0,   487,     0,   137,   488,   138,   139,   140,   141,   142,
       0,     0,   143,     0,     0,     0,   144,     0,     0,     0,
       0,   146,   147,   148,   149,   150,     0,     0,  -366,     0,
       0,     0,   153,     0,     0,     0,   154,     0,     0,   155,
     156,   157,     0,   158,     0,     0,     0,     0,     0,   161,
    3969,     0,   162,   163,     0,   164,     0,     0,     0,     0,
     167,   168,   169,  3970,   171,   172,     0,   173,   174,     0,
     175,   176,     0,   178,     0,   180,   181,   182,   183,     0,
     184,   185,     0,   186,   187,   188,     0,   190,     0,     0,
       0,   191,     0,     0,   192,     0,   193,     0,     0,   194,
       0,     0,     0,   195,   196,   197,     0,     0,   198,     0,
       0,     0,     0,   199,     0,     0,     0,     0,     0,   201,
     202,     0,   203,     0,     0,     0,   204,     0,   205,   206,
     207,   208,   209,     0,     0,     0,     0,     0,     0,   211,
     212,   213,     0,  -357,     0,   214,     0,  -357,   216,     0,
     217,   218,   219,     0,     0,   220,   221,     0,   222,   223,
     224,   225,   226,     0,     0,     0,   228,   229,   230,   231,
     232,     0,     0,   233,   234,  3971,   235,   236,   237,     0,
       0,     0,     0,     0,     0,     0,   240,     0,   241,     0,
     242,     0,   243,   244,   245,   246,     0,   247,     0,   248,
       0,     0,     0,     0,   250,     0,     0,     0,     0,     0,
     253,     0,     0,     0,   254,   255,   256,   257,  3972,     0,
     258,   259,   260,     0,     0,   261,     0,     0,     0,     0,
     262,     0,     0,     0,     0,   264,     0,     0,     0,   265,
     266,     0,   267,   268,  3973,     0,     0,   269,     0,     0,
       0,   271,     0,     0,   272,  3974,     0,   273,   274,     0,
       0,     0,     0,     0,   275,   276,     0,   277,     0,   278,
       0,   279,   280,     0,     0,     0,     0,  -321,     0,     0,
     281,     0,   282,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,     0,
     299,   300,   301,     0,   302,   303,   304,   305,     0,   306,
     307,     0,     0,     0,     0,   308,   309,   310,   311,   312,
     313,     0,     0,   314,   315,     0,   316,     0,   317,     0,
     318,   319,   320,   321,   322,   323,   324,   325,   326,     0,
       0,   327,   328,     0,     0,   329,   330,   331,   332,     0,
       0,     0,     0,   334,     0,     0,     0,   335,     0,   336,
     337,   338,     0,   339,   340,  3975,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   344,   345,
       0,     0,   347,     0,   348,   349,   350,   351,   352,   353,
     354,   355,   356,     0,     0,     0,     0,   359,   360,     0,
     361,     0,   362,   363,   364,   365,   366,     0,   367,   368,
     369,     0,     0,   370,     0,     0,     0,   371,   372,   373,
     374,   375,     0,     0,   376,   377,   378,   379,   380,     0,
     381,     0,     0,   383,     0,   385,  -321,     0,   386,     0,
       0,     0,   388,     0,     0,   390,   391,   392,  3976,   393,
       0,     0,     0,   395,   396,   397,   398,   399,   400,   401,
       0,   403,   404,     0,   405,     0,     0,     0,     0,   407,
     408,   409,     0,     0,     0,     0,   411,     0,     0,     0,
     412,     0,     0,   414,     0,   416,     0,   417,     0,     0,
     420,   421,     0,     0,     0,     0,     0,   422,   423,   424,
       0,   425,   426,     0,   427,     0,     0,   428,     0,     0,
     429,     0,   431,   432,   433,   434,     0,     0,     0,   436,
       0,   437,   438,   439,   440,   441,   442,     0,     0,   443,
     444,   445,   446,     0,   447,   448,     0,     0,   449,   450,
     451,   452,     0,     0,   453,   454,     0,   455,   456,   457,
     458,     0,     0,     0,     0,     0,   459,   460,     0,     0,
       0,     0,   462,   463,   464,     0,   465,   466,     0,   467,
     468,     0,     0,     0,     0,     0,   471,     0,     0,   472,
       0,     0,     0,   474,   475,     0,     0,     0,     0,     0,
       0,   476,     0,     0,   477,     0,     0,     0,   478,   479,
     480,   481,   482,  -357,     0,  -321,     0,     0,     0,   483,
       0,     0,   485,     0,   487,     0,   137,   488,   138,   139,
     140,   141,   142,     0,     0,   143,     0,     0,     0,   144,
       0,     0,     0,     0,   146,   147,   148,   149,   150,     0,
       0,  -366,     0,     0,     0,   153,     0,     0,     0,   154,
       0,     0,   155,   156,   157,     0,   158,     0,     0,     0,
       0,     0,   161,  3969,     0,   162,   163,     0,   164,     0,
       0,     0,     0,   167,   168,   169,  3970,   171,   172,     0,
     173,   174,     0,   175,   176,     0,   178,     0,   180,   181,
     182,   183,     0,   184,   185,     0,   186,   187,   188,     0,
     190,     0,     0,     0,   191,     0,     0,   192,     0,   193,
       0,     0,   194,     0,     0,     0,   195,   196,   197,     0,
       0,   198,     0,     0,     0,     0,   199,     0,     0,     0,
       0,     0,   201,   202,     0,   203,     0,     0,     0,   204,
       0,   205,   206,   207,   208,   209,     0,     0,     0,     0,
       0,     0,   211,   212,   213,     0,  -354,     0,   214,     0,
    -354,   216,     0,   217,   218,   219,     0,     0,   220,   221,
       0,   222,   223,   224,   225,   226,     0,     0,     0,   228,
     229,   230,   231,   232,     0,     0,   233,   234,  3971,   235,
     236,   237,     0,     0,     0,     0,     0,     0,     0,   240,
       0,   241,     0,   242,     0,   243,   244,   245,   246,     0,
     247,     0,   248,     0,     0,     0,     0,   250,     0,     0,
       0,     0,     0,   253,     0,     0,     0,   254,   255,   256,
     257,  3972,     0,   258,   259,   260,     0,     0,   261,     0,
       0,     0,     0,   262,     0,     0,     0,     0,   264,     0,
       0,     0,   265,   266,     0,   267,   268,  3973,     0,     0,
     269,     0,     0,     0,   271,     0,     0,   272,  3974,     0,
     273,   274,     0,     0,     0,     0,     0,   275,   276,     0,
     277,     0,   278,     0,   279,   280,     0,     0,     0,     0,
    -321,     0,     0,   281,     0,   282,   283,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,     0,   299,   300,   301,     0,   302,   303,   304,
     305,     0,   306,   307,     0,     0,     0,     0,   308,   309,
     310,   311,   312,   313,     0,     0,   314,   315,     0,   316,
       0,   317,     0,   318,   319,   320,   321,   322,   323,   324,
     325,   326,     0,     0,   327,   328,     0,     0,   329,   330,
     331,   332,     0,     0,     0,     0,   334,     0,     0,     0,
     335,     0,   336,   337,   338,     0,   339,   340,  3975,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   344,   345,     0,     0,   347,     0,   348,   349,   350,
     351,   352,   353,   354,   355,   356,     0,     0,     0,     0,
     359,   360,     0,   361,     0,   362,   363,   364,   365,   366,
       0,   367,   368,   369,     0,     0,   370,     0,     0,     0,
     371,   372,   373,   374,   375,     0,     0,   376,   377,   378,
     379,   380,     0,   381,     0,     0,   383,     0,   385,  -321,
       0,   386,     0,     0,     0,   388,     0,     0,   390,   391,
     392,  3976,   393,     0,     0,     0,   395,   396,   397,   398,
     399,   400,   401,     0,   403,   404,     0,   405,     0,     0,
       0,     0,   407,   408,   409,     0,     0,     0,     0,   411,
       0,     0,     0,   412,     0,     0,   414,     0,   416,     0,
     417,     0,     0,   420,   421,     0,     0,     0,     0,     0,
     422,   423,   424,     0,   425,   426,     0,   427,     0,     0,
     428,     0,     0,   429,     0,   431,   432,   433,   434,     0,
       0,     0,   436,     0,   437,   438,   439,   440,   441,   442,
       0,     0,   443,   444,   445,   446,     0,   447,   448,     0,
       0,   449,   450,   451,   452,     0,     0,   453,   454,     0,
     455,   456,   457,   458,     0,     0,     0,     0,     0,   459,
     460,     0,     0,     0,     0,   462,   463,   464,     0,   465,
     466,     0,   467,   468,     0,     0,     0,     0,     0,   471,
       0,     0,   472,     0,     0,     0,   474,   475,     0,     0,
       0,     0,     0,     0,   476,     0,     0,   477,     0,     0,
       0,   478,   479,   480,   481,   482,  -354,     0,  -321,     0,
       0,     0,   483,     0,     0,   485,     0,   487,     0,   137,
     488,   138,   139,   140,   141,   142,     0,     0,   143,     0,
       0,     0,   144,     0,     0,     0,     0,   146,   147,   148,
     149,   150,     0,     0,  -366,     0,     0,     0,   153,     0,
       0,     0,   154,     0,     0,   155,   156,   157,     0,   158,
       0,     0,     0,     0,     0,   161,  3969,     0,   162,   163,
       0,   164,     0,     0,     0,     0,   167,   168,   169,  3970,
     171,   172,     0,   173,   174,     0,   175,   176,     0,   178,
       0,   180,   181,   182,   183,     0,   184,   185,     0,   186,
     187,   188,     0,   190,     0,     0,     0,   191,     0,     0,
     192,     0,   193,     0,     0,   194,     0,     0,     0,   195,
     196,   197,     0,     0,   198,     0,     0,     0,     0,   199,
       0,     0,     0,     0,     0,   201,   202,     0,   203,     0,
       0,     0,   204,     0,   205,   206,   207,   208,   209,     0,
       0,     0,     0,     0,     0,   211,   212,   213,     0,     0,
       0,   214,     0,  4296,   216,     0,   217,   218,   219,     0,
       0,   220,   221,     0,   222,   223,   224,   225,   226,     0,
       0,     0,   228,   229,   230,   231,   232,     0,     0,   233,
     234,  3971,   235,   236,   237,     0,     0,     0,     0,     0,
       0,     0,   240,     0,   241,     0,   242,     0,   243,   244,
     245,   246,     0,   247,     0,   248,     0,     0,     0,     0,
     250,     0,     0,     0,     0,     0,   253,     0,     0,     0,
     254,   255,   256,   257,  3972,     0,   258,   259,   260,     0,
       0,   261,     0,     0,     0,     0,   262,     0,     0,     0,
       0,   264,     0,     0,     0,   265,   266,     0,   267,   268,
    3973,     0,     0,   269,     0,     0,     0,   271,     0,     0,
     272,  3974,     0,   273,   274,     0,     0,     0,     0,     0,
     275,   276,     0,   277,     0,   278,     0,   279,   280,     0,
       0,     0,     0,  -321,     0,     0,   281,     0,   282,   283,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,   296,   297,   298,     0,   299,   300,   301,     0,
     302,   303,   304,   305,     0,   306,   307,     0,     0,     0,
       0,   308,   309,   310,   311,   312,   313,     0,     0,   314,
     315,     0,   316,     0,   317,     0,   318,   319,   320,   321,
     322,   323,   324,   325,   326,     0,     0,   327,   328,     0,
       0,   329,   330,   331,   332,     0,     0,     0,     0,   334,
       0,     0,     0,   335,     0,   336,   337,   338,     0,   339,
     340,  3975,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   344,   345,     0,     0,   347,     0,
     348,   349,   350,   351,   352,   353,   354,   355,   356,     0,
       0,     0,     0,   359,   360,     0,   361,     0,   362,   363,
     364,   365,   366,     0,   367,   368,   369,     0,     0,   370,
       0,     0,     0,   371,   372,   373,   374,   375,     0,     0,
     376,   377,   378,   379,   380,     0,   381,     0,     0,   383,
       0,   385,  -321,     0,   386,     0,     0,     0,   388,     0,
       0,   390,   391,   392,  3976,   393,     0,     0,     0,   395,
     396,   397,   398,   399,   400,   401,     0,   403,   404,     0,
     405,     0,     0,     0,     0,   407,   408,   409,     0,     0,
       0,     0,   411,     0,     0,     0,   412,     0,     0,   414,
       0,   416,     0,   417,     0,     0,   420,   421,     0,     0,
       0,     0,     0,   422,   423,   424,     0,   425,   426,     0,
     427,     0,     0,   428,     0,     0,   429,     0,   431,   432,
     433,   434,     0,     0,     0,   436,     0,   437,   438,   439,
     440,   441,   442,     0,     0,   443,   444,   445,   446,     0,
     447,   448,     0,     0,   449,   450,   451,   452,     0,     0,
     453,   454,     0,   455,   456,   457,   458,     0,     0,     0,
       0,     0,   459,   460,     0,     0,     0,     0,   462,   463,
     464,     0,   465,   466,     0,   467,   468,     0,     0,     0,
       0,     0,   471,     0,     0,   472,     0,     0,     0,   474,
     475,     0,     0,     0,     0,     0,     0,   476,     0,     0,
     477,     0,     0,     0,   478,   479,   480,   481,   482,     0,
       0,  -321,     0,     0,     0,   483,     0,     0,   485,     0,
     487,     0,   137,   488,   138,   139,   140,   141,   142,     0,
       0,   143,     0,     0,     0,   144,     0,     0,     0,     0,
     146,   147,   148,   149,   150,     0,     0,  -366,     0,     0,
       0,   153,     0,     0,     0,   154,     0,     0,   155,   156,
     157,     0,   158,     0,     0,     0,     0,     0,   161,  3969,
       0,   162,   163,     0,   164,     0,     0,     0,     0,   167,
     168,   169,  3970,   171,   172,     0,   173,   174,     0,   175,
     176,     0,   178,     0,   180,   181,   182,   183,     0,   184,
     185,     0,   186,   187,   188,     0,   190,     0,     0,     0,
     191,     0,     0,   192,     0,   193,     0,     0,   194,     0,
       0,     0,   195,   196,   197,     0,     0,   198,     0,     0,
       0,     0,   199,     0,     0,     0,     0,     0,   201,   202,
       0,   203,     0,     0,     0,   204,     0,   205,   206,   207,
     208,   209,     0,     0,     0,     0,     0,     0,   211,   212,
     213,     0,     0,     0,   214,     0,  -359,   216,     0,   217,
     218,   219,     0,     0,   220,   221,     0,   222,   223,   224,
     225,   226,     0,     0,     0,   228,   229,   230,   231,   232,
       0,     0,   233,   234,  3971,   235,   236,   237,     0,     0,
       0,     0,     0,     0,     0,   240,     0,   241,     0,   242,
       0,   243,   244,   245,   246,     0,   247,     0,   248,     0,
       0,     0,     0,   250,     0,     0,     0,     0,     0,   253,
       0,     0,     0,   254,   255,   256,   257,  3972,     0,   258,
     259,   260,     0,     0,   261,     0,     0,     0,     0,   262,
       0,     0,     0,     0,   264,     0,     0,     0,   265,   266,
       0,   267,   268,  3973,     0,     0,   269,     0,     0,     0,
     271,     0,     0,   272,  3974,     0,   273,   274,     0,     0,
       0,     0,     0,   275,   276,     0,   277,     0,   278,     0,
     279,   280,     0,     0,     0,     0,  -321,     0,     0,   281,
       0,   282,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,     0,   299,
     300,   301,     0,   302,   303,   304,   305,     0,   306,   307,
       0,     0,     0,     0,   308,   309,   310,   311,   312,   313,
       0,     0,   314,   315,     0,   316,     0,   317,     0,   318,
     319,   320,   321,   322,   323,   324,   325,   326,     0,     0,
     327,   328,     0,     0,   329,   330,   331,   332,     0,     0,
       0,     0,   334,     0,     0,     0,   335,     0,   336,   337,
     338,     0,   339,   340,  3975,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   344,   345,     0,
       0,   347,     0,   348,   349,   350,   351,   352,   353,   354,
     355,   356,     0,     0,     0,     0,   359,   360,     0,   361,
       0,   362,   363,   364,   365,   366,     0,   367,   368,   369,
       0,     0,   370,     0,     0,     0,   371,   372,   373,   374,
     375,     0,     0,   376,   377,   378,   379,   380,     0,   381,
       0,     0,   383,     0,   385,  -321,     0,   386,     0,     0,
       0,   388,     0,     0,   390,   391,   392,  3976,   393,     0,
       0,     0,   395,   396,   397,   398,   399,   400,   401,     0,
     403,   404,     0,   405,     0,     0,     0,     0,   407,   408,
     409,     0,     0,     0,     0,   411,     0,     0,     0,   412,
       0,     0,   414,     0,   416,     0,   417,     0,     0,   420,
     421,     0,     0,     0,     0,     0,   422,   423,   424,     0,
     425,   426,     0,   427,     0,     0,   428,     0,     0,   429,
       0,   431,   432,   433,   434,     0,     0,     0,   436,     0,
     437,   438,   439,   440,   441,   442,     0,     0,   443,   444,
     445,   446,     0,   447,   448,     0,     0,   449,   450,   451,
     452,     0,     0,   453,   454,     0,   455,   456,   457,   458,
       0,     0,     0,     0,     0,   459,   460,     0,     0,     0,
       0,   462,   463,   464,     0,   465,   466,     0,   467,   468,
       0,     0,     0,     0,     0,   471,     0,     0,   472,     0,
       0,     0,   474,   475,     0,     0,     0,     0,     0,     0,
     476,     0,     0,   477,     0,     0,     0,   478,   479,   480,
     481,   482,     0,     0,  -321,     0,     0,     0,   483,     0,
       0,   485,     0,   487,     0,   137,   488,   138,   139,   140,
     141,   142,     0,     0,   143,     0,     0,     0,   144,     0,
       0,     0,     0,   146,   147,   148,   149,   150,     0,     0,
    -366,     0,     0,     0,   153,     0,     0,     0,   154,     0,
       0,   155,   156,   157,     0,   158,     0,     0,     0,     0,
       0,   161,  3969,     0,   162,   163,     0,   164,     0,     0,
       0,     0,   167,   168,   169,  3970,   171,   172,     0,   173,
     174,     0,   175,   176,     0,   178,     0,   180,   181,   182,
     183,     0,   184,   185,     0,   186,   187,   188,     0,   190,
       0,     0,     0,   191,     0,     0,   192,     0,   193,     0,
       0,   194,     0,     0,     0,   195,   196,   197,     0,     0,
     198,     0,     0,     0,     0,   199,     0,     0,     0,     0,
       0,   201,   202,     0,   203,     0,     0,     0,   204,     0,
     205,   206,   207,   208,   209,     0,     0,     0,     0,     0,
       0,   211,   212,   213,     0,     0,     0,   214,     0,  4404,
     216,     0,   217,   218,   219,     0,     0,   220,   221,     0,
     222,   223,   224,   225,   226,     0,     0,     0,   228,   229,
     230,   231,   232,     0,     0,   233,   234,  3971,   235,   236,
     237,     0,     0,     0,     0,     0,     0,     0,   240,     0,
     241,     0,   242,     0,   243,   244,   245,   246,     0,   247,
       0,   248,     0,     0,     0,     0,   250,     0,     0,     0,
       0,     0,   253,     0,     0,     0,   254,   255,   256,   257,
    3972,     0,   258,   259,   260,     0,     0,   261,     0,     0,
       0,     0,   262,     0,     0,     0,     0,   264,     0,     0,
       0,   265,   266,     0,   267,   268,  3973,     0,     0,   269,
       0,     0,     0,   271,     0,     0,   272,  3974,     0,   273,
     274,     0,     0,     0,     0,     0,   275,   276,     0,   277,
       0,   278,     0,   279,   280,     0,     0,     0,     0,  -321,
       0,     0,   281,     0,   282,   283,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,     0,   299,   300,   301,     0,   302,   303,   304,   305,
       0,   306,   307,     0,     0,     0,     0,   308,   309,   310,
     311,   312,   313,     0,     0,   314,   315,     0,   316,     0,
     317,     0,   318,   319,   320,   321,   322,   323,   324,   325,
     326,     0,     0,   327,   328,     0,     0,   329,   330,   331,
     332,     0,     0,     0,     0,   334,     0,     0,     0,   335,
       0,   336,   337,   338,     0,   339,   340,  3975,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     344,   345,     0,     0,   347,     0,   348,   349,   350,   351,
     352,   353,   354,   355,   356,     0,     0,     0,     0,   359,
     360,     0,   361,     0,   362,   363,   364,   365,   366,     0,
     367,   368,   369,     0,     0,   370,     0,     0,     0,   371,
     372,   373,   374,   375,     0,     0,   376,   377,   378,   379,
     380,     0,   381,     0,     0,   383,     0,   385,  -321,     0,
     386,     0,     0,     0,   388,     0,     0,   390,   391,   392,
    3976,   393,     0,     0,     0,   395,   396,   397,   398,   399,
     400,   401,     0,   403,   404,     0,   405,     0,     0,     0,
       0,   407,   408,   409,     0,     0,     0,     0,   411,     0,
       0,     0,   412,     0,     0,   414,     0,   416,     0,   417,
       0,     0,   420,   421,     0,     0,     0,     0,     0,   422,
     423,   424,     0,   425,   426,     0,   427,     0,     0,   428,
       0,     0,   429,     0,   431,   432,   433,   434,     0,     0,
       0,   436,     0,   437,   438,   439,   440,   441,   442,     0,
       0,   443,   444,   445,   446,     0,   447,   448,     0,     0,
     449,   450,   451,   452,     0,     0,   453,   454,     0,   455,
     456,   457,   458,     0,     0,     0,     0,     0,   459,   460,
       0,     0,     0,     0,   462,   463,   464,     0,   465,   466,
       0,   467,   468,     0,     0,     0,     0,     0,   471,     0,
       0,   472,     0,     0,     0,   474,   475,     0,     0,     0,
       0,     0,     0,   476,     0,     0,   477,     0,     0,     0,
     478,   479,   480,   481,   482,     0,     0,  -321,     0,     0,
       0,   483,     0,     0,   485,     0,   487,     0,   137,   488,
     138,   139,   140,   141,   142,     0,     0,   143,     0,     0,
       0,   144,     0,     0,     0,     0,   146,   147,   148,   149,
     150,     0,     0,  -366,     0,     0,     0,   153,     0,     0,
       0,   154,     0,     0,   155,   156,   157,     0,   158,     0,
       0,     0,     0,     0,   161,  3969,     0,   162,   163,     0,
     164,     0,     0,     0,     0,   167,   168,   169,  3970,   171,
     172,     0,   173,   174,     0,   175,   176,     0,   178,     0,
     180,   181,   182,   183,     0,   184,   185,     0,   186,   187,
     188,     0,   190,     0,     0,     0,   191,     0,     0,   192,
       0,   193,     0,     0,   194,     0,     0,     0,   195,   196,
     197,     0,     0,   198,     0,     0,     0,     0,   199,     0,
       0,     0,     0,     0,   201,   202,     0,   203,     0,     0,
       0,   204,     0,   205,   206,   207,   208,   209,     0,     0,
       0,     0,     0,     0,   211,   212,   213,     0,     0,     0,
     214,     0,  4450,   216,     0,   217,   218,   219,     0,     0,
     220,   221,     0,   222,   223,   224,   225,   226,     0,     0,
       0,   228,   229,   230,   231,   232,     0,     0,   233,   234,
    3971,   235,   236,   237,     0,     0,     0,     0,     0,     0,
       0,   240,     0,   241,     0,   242,     0,   243,   244,   245,
     246,     0,   247,     0,   248,     0,     0,     0,     0,   250,
       0,     0,     0,     0,     0,   253,     0,     0,     0,   254,
     255,   256,   257,  3972,     0,   258,   259,   260,     0,     0,
     261,     0,     0,     0,     0,   262,     0,     0,     0,     0,
     264,     0,     0,     0,   265,   266,     0,   267,   268,  3973,
       0,     0,   269,     0,     0,     0,   271,     0,     0,   272,
    3974,     0,   273,   274,     0,     0,     0,     0,     0,   275,
     276,     0,   277,     0,   278,     0,   279,   280,     0,     0,
       0,     0,  -321,     0,     0,   281,     0,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,     0,   299,   300,   301,     0,   302,
     303,   304,   305,     0,   306,   307,     0,     0,     0,     0,
     308,   309,   310,   311,   312,   313,     0,     0,   314,   315,
       0,   316,     0,   317,     0,   318,   319,   320,   321,   322,
     323,   324,   325,   326,     0,     0,   327,   328,     0,     0,
     329,   330,   331,   332,     0,     0,     0,     0,   334,     0,
       0,     0,   335,     0,   336,   337,   338,     0,   339,   340,
    3975,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   344,   345,     0,     0,   347,     0,   348,
     349,   350,   351,   352,   353,   354,   355,   356,     0,     0,
       0,     0,   359,   360,     0,   361,     0,   362,   363,   364,
     365,   366,     0,   367,   368,   369,     0,     0,   370,     0,
       0,     0,   371,   372,   373,   374,   375,     0,     0,   376,
     377,   378,   379,   380,     0,   381,     0,     0,   383,     0,
     385,  -321,     0,   386,     0,     0,     0,   388,     0,     0,
     390,   391,   392,  3976,   393,     0,     0,     0,   395,   396,
     397,   398,   399,   400,   401,     0,   403,   404,     0,   405,
       0,     0,     0,     0,   407,   408,   409,     0,     0,     0,
       0,   411,     0,     0,     0,   412,     0,     0,   414,     0,
     416,     0,   417,     0,     0,   420,   421,     0,     0,     0,
       0,     0,   422,   423,   424,     0,   425,   426,     0,   427,
       0,     0,   428,     0,     0,   429,     0,   431,   432,   433,
     434,     0,     0,     0,   436,     0,   437,   438,   439,   440,
     441,   442,     0,     0,   443,   444,   445,   446,     0,   447,
     448,     0,     0,   449,   450,   451,   452,     0,     0,   453,
     454,     0,   455,   456,   457,   458,     0,     0,     0,     0,
       0,   459,   460,     0,     0,     0,     0,   462,   463,   464,
       0,   465,   466,     0,   467,   468,     0,     0,     0,     0,
       0,   471,     0,     0,   472,     0,     0,     0,   474,   475,
       0,     0,     0,     0,     0,     0,   476,     0,     0,   477,
       0,     0,     0,   478,   479,   480,   481,   482,     0,     0,
    -321,     0,     0,     0,   483,     0,     0,   485,     0,   487,
       0,   137,   488,   138,   139,   140,   141,   142,     0,     0,
     143,     0,     0,     0,   144,     0,     0,     0,     0,   146,
     147,   148,   149,   150,     0,     0,  -366,     0,     0,     0,
     153,     0,     0,     0,   154,     0,     0,   155,   156,   157,
       0,   158,     0,     0,     0,     0,     0,   161,  3969,     0,
     162,   163,     0,   164,     0,     0,     0,     0,   167,   168,
     169,  3970,   171,   172,     0,   173,   174,     0,   175,   176,
       0,   178,     0,   180,   181,   182,   183,     0,   184,   185,
       0,   186,   187,   188,     0,   190,     0,     0,     0,   191,
       0,     0,   192,     0,   193,     0,     0,   194,     0,     0,
       0,   195,   196,   197,     0,     0,   198,     0,     0,     0,
       0,   199,     0,     0,     0,     0,     0,   201,   202,     0,
     203,     0,     0,     0,   204,     0,   205,   206,   207,   208,
     209,     0,     0,     0,     0,     0,     0,   211,   212,   213,
       0,     0,     0,   214,     0,  -340,   216,     0,   217,   218,
     219,     0,     0,   220,   221,     0,   222,   223,   224,   225,
     226,     0,     0,     0,   228,   229,   230,   231,   232,     0,
       0,   233,   234,  3971,   235,   236,   237,     0,     0,     0,
       0,     0,     0,     0,   240,     0,   241,     0,   242,     0,
     243,   244,   245,   246,     0,   247,     0,   248,     0,     0,
       0,     0,   250,     0,     0,     0,     0,     0,   253,     0,
       0,     0,   254,   255,   256,   257,  3972,     0,   258,   259,
     260,     0,     0,   261,     0,     0,     0,     0,   262,     0,
       0,     0,     0,   264,     0,     0,     0,   265,   266,     0,
     267,   268,  3973,     0,     0,   269,     0,     0,     0,   271,
       0,     0,   272,  3974,     0,   273,   274,     0,     0,     0,
       0,     0,   275,   276,     0,   277,     0,   278,     0,   279,
     280,     0,     0,     0,     0,  -321,     0,     0,   281,     0,
     282,   283,   284,   285,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,     0,   299,   300,
     301,     0,   302,   303,   304,   305,     0,   306,   307,     0,
       0,     0,     0,   308,   309,   310,   311,   312,   313,     0,
       0,   314,   315,     0,   316,     0,   317,     0,   318,   319,
     320,   321,   322,   323,   324,   325,   326,     0,     0,   327,
     328,     0,     0,   329,   330,   331,   332,     0,     0,     0,
       0,   334,     0,     0,     0,   335,     0,   336,   337,   338,
       0,   339,   340,  3975,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   344,   345,     0,     0,
     347,     0,   348,   349,   350,   351,   352,   353,   354,   355,
     356,     0,     0,     0,     0,   359,   360,     0,   361,     0,
     362,   363,   364,   365,   366,     0,   367,   368,   369,     0,
       0,   370,     0,     0,     0,   371,   372,   373,   374,   375,
       0,     0,   376,   377,   378,   379,   380,     0,   381,     0,
       0,   383,     0,   385,  -321,     0,   386,     0,     0,     0,
     388,     0,     0,   390,   391,   392,  3976,   393,     0,     0,
       0,   395,   396,   397,   398,   399,   400,   401,     0,   403,
     404,     0,   405,     0,     0,     0,     0,   407,   408,   409,
       0,     0,     0,     0,   411,     0,     0,     0,   412,     0,
       0,   414,     0,   416,     0,   417,     0,     0,   420,   421,
       0,     0,     0,     0,     0,   422,   423,   424,     0,   425,
     426,     0,   427,     0,     0,   428,     0,     0,   429,     0,
     431,   432,   433,   434,     0,     0,     0,   436,     0,   437,
     438,   439,   440,   441,   442,     0,     0,   443,   444,   445,
     446,     0,   447,   448,     0,     0,   449,   450,   451,   452,
       0,     0,   453,   454,     0,   455,   456,   457,   458,     0,
       0,     0,     0,     0,   459,   460,     0,     0,     0,     0,
     462,   463,   464,     0,   465,   466,     0,   467,   468,     0,
       0,     0,     0,     0,   471,     0,     0,   472,     0,     0,
       0,   474,   475,     0,     0,     0,     0,     0,     0,   476,
       0,     0,   477,     0,     0,     0,   478,   479,   480,   481,
     482,     0,     0,  -321,     0,     0,     0,   483,     0,     0,
     485,     0,   487,     0,   137,   488,   138,   139,   140,   141,
     142,     0,     0,   143,     0,     0,     0,   144,     0,     0,
       0,     0,   146,   147,   148,   149,   150,     0,     0,  -366,
       0,     0,     0,   153,     0,     0,     0,   154,     0,     0,
     155,   156,   157,     0,   158,     0,     0,     0,     0,     0,
     161,  3969,     0,   162,   163,     0,   164,     0,     0,     0,
       0,   167,   168,   169,  3970,   171,   172,     0,   173,   174,
       0,   175,   176,     0,   178,     0,   180,   181,   182,   183,
       0,   184,   185,     0,   186,   187,   188,     0,   190,     0,
       0,     0,   191,     0,     0,   192,     0,   193,     0,     0,
     194,     0,     0,     0,   195,   196,   197,     0,     0,   198,
       0,     0,     0,     0,   199,     0,     0,     0,     0,     0,
     201,   202,     0,   203,     0,     0,     0,   204,     0,   205,
     206,   207,   208,   209,     0,     0,     0,     0,     0,     0,
     211,   212,   213,     0,     0,     0,   214,     0,     0,   216,
       0,   217,   218,   219,     0,     0,   220,   221,     0,   222,
     223,   224,   225,   226,     0,     0,     0,   228,   229,   230,
     231,   232,     0,     0,   233,   234,  3971,   235,   236,   237,
       0,     0,     0,     0,     0,     0,     0,   240,     0,   241,
       0,   242,     0,   243,   244,   245,   246,     0,   247,     0,
     248,     0,     0,     0,     0,   250,     0,     0,     0,     0,
       0,   253,     0,     0,     0,   254,   255,   256,   257,  3972,
       0,   258,   259,   260,     0,     0,   261,     0,     0,     0,
       0,   262,     0,     0,     0,     0,   264,     0,     0,     0,
     265,   266,     0,   267,   268,  3973,     0,     0,   269,     0,
       0,     0,   271,     0,     0,   272,  3974,     0,   273,   274,
       0,     0,     0,     0,     0,   275,   276,     0,   277,     0,
     278,     0,   279,   280,     0,     0,     0,     0,  -321,     0,
       0,   281,     0,   282,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
       0,   299,   300,   301,     0,   302,   303,   304,   305,     0,
     306,   307,     0,     0,     0,     0,   308,   309,   310,   311,
     312,   313,     0,     0,   314,   315,     0,   316,     0,   317,
       0,   318,   319,   320,   321,   322,   323,   324,   325,   326,
       0,     0,   327,   328,     0,     0,   329,   330,   331,   332,
       0,     0,     0,     0,   334,     0,     0,     0,   335,     0,
     336,   337,   338,     0,   339,   340,  3975,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   344,
     345,     0,     0,   347,     0,   348,   349,   350,   351,   352,
     353,   354,   355,   356,     0,     0,     0,     0,   359,   360,
       0,   361,     0,   362,   363,   364,   365,   366,     0,   367,
     368,   369,     0,     0,   370,     0,     0,     0,   371,   372,
     373,   374,   375,     0,     0,   376,   377,   378,   379,   380,
       0,   381,     0,     0,   383,     0,   385,  -321,     0,   386,
       0,     0,     0,   388,     0,     0,   390,   391,   392,  3976,
     393,     0,     0,     0,   395,   396,   397,   398,   399,   400,
     401,     0,   403,   404,     0,   405,     0,     0,     0,     0,
     407,   408,   409,     0,     0,     0,     0,   411,     0,     0,
       0,   412,     0,     0,   414,     0,   416,     0,   417,     0,
       0,   420,   421,     0,     0,     0,     0,     0,   422,   423,
     424,     0,   425,   426,     0,   427,     0,     0,   428,     0,
       0,   429,     0,   431,   432,   433,   434,     0,     0,     0,
     436,     0,   437,   438,   439,   440,   441,   442,     0,     0,
     443,   444,   445,   446,     0,   447,   448,     0,     0,   449,
     450,   451,   452,     0,     0,   453,   454,     0,   455,   456,
     457,   458,     0,     0,     0,     0,     0,   459,   460,     0,
       0,     0,     0,   462,   463,   464,     0,   465,   466,     0,
     467,   468,     0,     0,     0,     0,     0,   471,     0,     0,
     472,     0,     0,     0,   474,   475,     0,     0,     0,     0,
       0,     0,   476,     0,     0,   477,     0,     0,     0,   478,
     479,   480,   481,   482,     0,     0,  -321,     0,     0,     0,
     483,     0,     0,   485,     0,   487,     0,   137,   488,   138,
     139,   140,   141,   142,     0,     0,   143,     0,     0,     0,
     144,     0,     0,     0,     0,   146,   147,   148,   149,   150,
       0,     0,  -366,     0,     0,     0,   153,     0,     0,     0,
     154,     0,     0,   155,   156,   157,     0,   158,     0,     0,
       0,     0,     0,   161,  3969,     0,   162,   163,     0,   164,
       0,     0,     0,     0,   167,   168,   169,  3970,   171,   172,
       0,   173,   174,     0,   175,   176,     0,   178,     0,   180,
     181,   182,   183,     0,   184,   185,     0,   186,   187,   188,
       0,   190,     0,     0,     0,   191,     0,     0,   192,     0,
     193,     0,     0,   194,     0,     0,     0,   195,   196,   197,
       0,     0,   198,     0,     0,     0,     0,   199,     0,     0,
       0,     0,     0,   201,   202,     0,   203,     0,     0,     0,
     204,     0,   205,   206,   207,   208,   209,     0,     0,     0,
       0,     0,     0,   211,   212,   213,     0,     0,     0,   214,
       0,     0,   216,     0,   217,   218,   219,     0,     0,   220,
     221,     0,   222,   223,   224,   225,   226,     0,     0,     0,
     228,   229,   230,   231,   232,     0,     0,   233,   234,  3971,
     235,   236,   237,     0,     0,     0,     0,     0,     0,     0,
     240,     0,   241,     0,   242,     0,   243,   244,   245,   246,
       0,   247,     0,   248,     0,     0,     0,     0,   250,     0,
       0,     0,     0,     0,   253,     0,     0,     0,   254,   255,
     256,   257,  3972,     0,   258,   259,   260,     0,     0,   261,
       0,     0,     0,     0,   262,     0,     0,     0,     0,   264,
       0,     0,     0,   265,   266,     0,   267,   268,  3973,     0,
       0,   269,     0,     0,     0,   271,     0,     0,   272,  3974,
       0,   273,   274,     0,     0,     0,     0,     0,   275,   276,
       0,   277,     0,   278,     0,   279,   280,     0,     0,     0,
       0,  -321,     0,     0,   281,     0,   282,   283,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,     0,   299,   300,   301,     0,   302,   303,
     304,   305,     0,   306,   307,     0,     0,     0,     0,   308,
     309,   310,   311,   312,   313,     0,     0,   314,   315,     0,
     316,     0,   317,     0,   318,   319,   320,   321,   322,   323,
     324,   325,   326,     0,     0,   327,   328,     0,     0,   329,
     330,   331,   332,     0,     0,     0,     0,   334,     0,     0,
       0,   335,     0,   336,   337,   338,     0,   339,   340,  3975,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   344,   345,     0,     0,   347,     0,   348,   349,
     350,   351,   352,   353,   354,   355,   356,     0,     0,     0,
       0,   359,   360,     0,   361,     0,   362,   363,   364,   365,
     366,     0,   367,   368,   369,     0,     0,   370,     0,     0,
       0,   371,   372,   373,   374,   375,     0,     0,   376,   377,
     378,   379,   380,     0,   381,     0,     0,   383,     0,   385,
    -321,     0,   386,     0,     0,     0,   388,     0,     0,   390,
     391,   392,  3976,   393,     0,     0,     0,   395,   396,   397,
     398,   399,   400,   401,     0,   403,   404,     0,   405,     0,
       0,     0,     0,   407,   408,   409,     0,     0,     0,     0,
     411,     0,     0,     0,   412,     0,     0,   414,     0,   416,
       0,   417,     0,     0,   420,   421,     0,     0,     0,     0,
       0,   422,   423,   424,     0,   425,   426,     0,   427,     0,
       0,   428,     0,     0,   429,     0,   431,   432,   433,   434,
       0,     0,     0,   436,     0,   437,   438,   439,   440,   441,
     442,     0,     0,   443,   444,   445,   446,     0,   447,   448,
       0,     0,   449,   450,   451,   452,     0,     0,   453,   454,
       0,   455,   456,   457,   458,     0,     0,     0,     0,     0,
     459,   460,     0,     0,     0,     0,   462,   463,   464,     0,
     465,   466,     0,   467,   468,     0,     0,     0,     0,     0,
     471,     0,     0,  4299,     0,     0,     0,   474,   475,     0,
       0,     0,     0,     0,     0,   476,     0,     0,   477,     0,
       0,     0,   478,   479,   480,   481,   482,     0,     0,  -321,
       0,     0,     0,   483,     0,     0,   485,     0,   487,     0,
     137,   488,   138,   139,   140,   141,   142,     0,     0,   143,
       0,     0,     0,   144,     0,     0,     0,     0,   146,   147,
     148,   149,   150,     0,     0,     0,     0,     0,     0,   153,
       0,     0,     0,   154,     0,     0,   155,   156,   157,     0,
     158,     0,     0,     0,     0,     0,   161,     0,     0,   162,
     163,     0,   164,     0,     0,     0,     0,   167,   168,   169,
       0,   171,   172,     0,   173,   174,     0,   175,   176,     0,
     178,     0,   180,   181,   182,   183,     0,   184,   185,     0,
     186,   187,   188,     0,   190,     0,     0,     0,   191,     0,
       0,   192,     0,   193,     0,     0,   194,     0,     0,     0,
     195,   196,   197,     0,     0,   198,     0,     0,     0,     0,
     199,     0,     0,     0,     0,     0,   201,   202,     0,   203,
       0,     0,     0,   204,     0,   205,   206,   207,   208,   209,
       0,     0,     0,     0,     0,     0,   211,   212,   213,     0,
       0,     0,   214,     0,     0,   216,     0,   217,   218,   219,
       0,     0,   220,   221,     0,   222,   223,   224,   225,   226,
       0,     0,     0,   228,   229,   230,   231,   232,     0,     0,
     233,   234,     0,   235,   236,   237,     0,     0,     0,     0,
       0,     0,     0,   240,     0,   241,     0,   242,     0,   243,
     244,   245,   246,     0,   247,     0,   248,     0,     0,     0,
       0,   250,     0,     0,     0,     0,     0,   253,     0,     0,
       0,   254,   255,   256,   257,     0,     0,   258,   259,   260,
       0,     0,   261,     0,     0,     0,     0,   262,     0,     0,
       0,     0,   264,     0,     0,     0,   265,   266,     0,   267,
     268,     0,     0,     0,   269,     0,     0,     0,   271,     0,
       0,   272,     0,     0,   273,   274,     0,     0,     0,     0,
       0,   275,   276,     0,   277,     0,   278,     0,   279,   280,
       0,     0,     0,     0,     0,     0,     0,   281,     0,   282,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,     0,   299,   300,   301,
       0,   302,   303,   304,   305,     0,   306,   307,     0,     0,
       0,     0,   308,   309,   310,   311,   312,   313,     0,     0,
     314,   315,     0,   316,     0,   317,     0,   318,   319,   320,
     321,   322,   323,   324,   325,   326,     0,     0,   327,   328,
       0,     0,   329,   330,   331,   332,     0,     0,     0,     0,
     334,     0,     0,     0,   335,     0,   336,   337,   338,     0,
     339,   340,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   344,   345,     0,     0,   347,
       0,   348,   349,   350,   351,   352,   353,   354,   355,   356,
       0,     0,     0,     0,   359,   360,     0,   361,     0,   362,
     363,   364,   365,   366,     0,   367,   368,   369,     0,     0,
     370,     0,     0,     0,   371,   372,   373,   374,   375,     0,
       0,   376,   377,   378,   379,   380,     0,   381,     0,     0,
     383,     0,   385,     0,     0,   386,     0,     0,     0,   388,
       0,     0,   390,   391,   392,     0,   393,     0,     0,     0,
     395,   396,   397,   398,   399,   400,   401,     0,   403,   404,
       0,   405,     0,     0,     0,     0,   407,   408,   409,     0,
       0,     0,     0,   411,     0,     0,     0,   412,     0,     0,
     414,     0,   416,     0,   417,     0,     0,   420,   421,     0,
       0,     0,     0,     0,   422,   423,   424,     0,   425,   426,
       0,   427,     0,     0,   428,     0,     0,   429,     0,   431,
     432,   433,   434,     0,     0,     0,   436,     0,   437,   438,
     439,   440,   441,   442,     0,     0,   443,   444,   445,   446,
       0,   447,   448,     0,     0,   449,   450,   451,   452,     0,
       0,   453,   454,     0,   455,   456,   457,   458,     0,     0,
       0,     0,     0,   459,   460,     0,     0,     0,     0,   462,
     463,   464,     0,   465,   466,     0,   467,   468,     0,     0,
       0,     0,     0,   471,     0,     0,   472,     0,     0,     0,
     474,   475,     0,     0,     0,     0,     0,     0,   476,     0,
       0,   477,     0,     0,     0,   478,   479,   480,   481,   482,
       0,     0,     0,     0,     0,     0,   483,     0,     0,   485,
       0,   487,     0,     0,   488
};

static const yytype_int16 yycheck[] =
{
       6,   638,   575,   983,   647,   648,   574,   575,   594,   903,
     904,   883,   984,    19,  1852,  1572,  1073,    23,   122,   913,
    1505,  1263,    20,  1705,  1399,  1167,    32,  1114,     6,  1167,
    1067,  1068,    30,    39,   519,  1303,    42,   705,    36,   610,
      46,   921,  1817,   943,  1503,  1380,  2553,    53,  2034,  1494,
    1190,  2339,   623,  2170,  1494,   919,  1263,  1197,  2175,  2105,
    2481,  1460,  2384,   943,  2441,  2442,  2844,  3307,  1104,  2902,
    1309,   634,   635,  2266,  2670,   988,  1484,  1928,  1778,  1484,
     944,    23,  1494,  1488,  2001,  1490,  1839,  2469,    94,   665,
     652,  2548,   988,  1997,  1137,  1410,  2003,  1997,  3043,  2449,
    2007,  2526,  2554,  1484,  2130,  2130,  3312,  1488,    24,  1490,
     116,  2018,   118,  1428,  2402,   121,   122,   123,  3098,  2462,
    1980,  1436,  1437,  2030,    19,  2698,  3535,  2470,  2704,  2702,
    1474,  2304,    33,    20,   963,    17,   773,    10,    16,    17,
     118,    46,     4,   121,    21,  1553,  1850,  3181,  1553,    59,
      16,    17,    94,    17,    29,  1198,  1199,  2119,  3580,  1202,
    1203,  1204,  1205,  1989,  1207,  1208,  1209,  1210,  1211,  1212,
    1213,  1214,  1553,  3370,  3371,    16,    17,  3374,    19,   106,
    1971,    58,    59,    16,    17,   761,   762,   763,  1236,     9,
      70,    50,   145,   145,    16,    17,  3393,   104,   774,   171,
    2510,  2511,  3399,  2951,  2060,   145,  2701,    62,  2427,    29,
      20,    67,    19,   125,    74,    35,    65,    82,   192,   158,
      50,  2514,  3330,    24,    11,  2085,  2130,  2087,  2088,    31,
    2130,    24,   803,  2093,  2094,    19,    64,    16,    17,   126,
      19,  2153,  2102,  2103,   192,  2672,    11,  2107,  2320,  3590,
    1952,  1953,  1943,    68,   373,   155,   151,   118,  2260,  4008,
     155,   262,   358,   155,    24,   341,   129,  1969,    80,   151,
      55,    16,    17,  2762,   120,  4127,   386,   247,   221,   366,
    3637,  3886,  3887,    51,  1986,  1987,   186,   367,   364,   441,
     861,  3531,   363,    61,   945,   468,    74,   123,   225,   449,
    2002,    35,   362,  2005,  2006,   141,  2008,   416,    35,  2011,
    2012,   227,   132,  2015,    75,   421,   126,   388,  2020,    57,
    2392,   244,    23,  2025,  2026,  2027,  2028,  2029,  2638,  2639,
    3577,  2033,   120,  2035,  2684,   122,  2686,   263,   244,  2041,
    2042,  2043,  2044,    21,   189,  2047,   263,  2049,   155,    12,
      21,   359,   153,   545,    41,    33,   189,   186,    20,    67,
     153,   576,    33,   151,   120,    16,    17,    61,   120,    47,
     416,   155,    62,  2831,  3653,   236,    47,  3656,    16,    17,
      58,    59,  4131,   269,   210,   545,   125,    58,    59,   249,
     245,   437,   189,   309,  2254,   151,    16,    17,   511,   151,
     504,    33,  1045,  1046,  1047,   186,   206,   107,    16,    17,
     110,  2646,  2114,  2115,  2116,  2117,   631,   545,    16,    17,
      81,  3618,   351,   352,  4029,   471,   227,    59,  4033,   403,
    3627,   544,  3711,   171,   227,  1103,   238,   175,   542,   100,
     412,   238,  2529,   272,   189,   637,   133,   373,   186,  1117,
     250,  1014,   460,  3650,   280,   403,   373,   630,  3655,  2837,
     262,   634,   163,  2921,   126,   571,    70,   227,   280,  3878,
     356,   249,   135,   280,   545,   209,  1448,   447,  2253,  1373,
     632,   260,   209,  4088,  4089,  3842,  2398,  2468,   638,  3695,
      78,   185,   231,   416,   372,   350,   439,   375,   504,   608,
     506,   269,   630,   348,  2854,  2855,   372,   272,   309,   375,
     416,   357,   588,   632,  4366,  3755,   309,   523,    16,    17,
     630,   527,  3769,    16,    17,  2950,   613,  2909,  2953,  2954,
     403,   372,   538,  2018,   375,   631,   542,  1872,   544,   372,
    1404,   377,   375,  1407,   155,   151,   411,   210,  1412,   309,
    2971,   557,    16,    17,   355,   245,  1193,   418,   638,   374,
     140,  1474,   355,  1971,   451,   539,  1971,   416,   574,   354,
     155,  3319,   632,   155,  1438,  1439,   582,   477,  1474,   317,
    1460,   189,    24,  2569,  1989,   477,  3792,   446,   375,  1997,
    1971,   539,  3572,   372,   600,  1263,   375,  1839,    61,   647,
     648,  1086,  1087,   155,   610,   606,   612,  1922,  1989,   416,
    2514,  3952,    16,    17,  2514,  2475,   446,   623,   624,   625,
    2646,  2646,  1107,   425,   630,  1201,   632,   372,   634,   635,
     375,  1116,  1839,   639,   640,   508,    16,    17,   644,  1552,
    2052,   451,  1218,  1128,  1129,  1130,  2939,   625,   654,   655,
     656,  1136,   605,   605,   660,   510,  1552,   263,   486,  2878,
     632,   517,   523,   602,  3091,   605,  3499,    16,    17,  4091,
     582,   526,    16,    17,   412,  2535,  2532,  2537,  2640,  1242,
    2536,   556,   624,  4432,  2544,   595,  2512,   560,   630,   616,
    1733,  1727,   556,   600,  2550,  2551,   800,   574,  2558,   705,
    2404,  1744,  2493,   608,  1747,  2565,  2562,   401,  1756,  1538,
    1281,  2119,   532,  4122,  2119,  3921,   632,  2577,  2578,  2579,
     521,   372,  2130,  2583,   375,  2130,   608,   600,   521,   630,
    2802,  2803,  2804,   553,   372,  2591,   623,   375,  2119,   617,
     560,   636,  2646,  1306,  3778,  2605,  2646,  3097,   608,  2130,
     630,   617,   372,  3242,   636,   375,  3066,   635,  1321,   614,
     766,  2763,   768,   583,   372,  3087,   632,   375,  3876,  2113,
    2461,  2683,   556,   632,   372,  1346,   617,   375,  2850,  2851,
    2852,  3354,  3358,  1434,   617,   227,   649,   565,   794,   795,
     796,  3771,   798,   799,   800,   617,   802,   803,  1369,   903,
     601,   405,   808,   907,   908,  2978,   613,   568,   601,   517,
     588,   545,  2668,  3389,  3390,  3388,   920,   795,   545,  4025,
    3309,   799,  4069,  3396,   802,  4234,  1388,   608,    16,    17,
    3403,   632,  3067,    16,    17,   841,   526,  1408,   617,   502,
     503,  2543,   505,   582,   507,   851,    16,    17,   636,   549,
      16,    17,   552,   632,  2556,   861,   862,  3352,  3353,   522,
     866,  2948,  2637,    16,    17,  3360,   477,   309,  3363,  3364,
      16,    17,   617,  3251,   372,   463,  3328,   375,   982,   372,
     636,   190,   375,   577,   636,  3380,  2345,  3344,   468,    16,
      17,  3316,   477,   151,   632,   477,   574,   903,  4095,  3394,
    4097,   907,   908,   574,  3399,  3400,  3401,  3402,   372,   851,
    1478,   375,   153,   355,   920,  3297,  2473,   117,   153,  3301,
     862,  1492,    16,    17,   866,   477,  3248,   598,  3873,  2910,
    2911,    45,   536,   139,    16,    17,   184,   225,   174,   212,
      16,    17,  2644,   313,   265,  2783,   279,    42,    16,    17,
     588,   280,   125,   171,  3297,   559,  3306,   963,  3301,   630,
    4166,   424,    16,    17,  1858,  1013,   617,   184,   372,    16,
      17,   375,   430,   221,  3262,   151,   982,  3037,   984,   617,
     631,   632,  1650,  2821,  1878,  3946,   227,   807,   468,   171,
      16,    17,   372,   855,   632,   375,   640,   617,    50,  1561,
     606,  4241,    16,    17,   221,   263,    16,    17,  1014,   617,
     125,   631,   632,    16,    17,  1063,   125,   134,  1918,   617,
      16,    17,   123,   372,   632,    68,   375,   638,   372,   846,
     636,   375,    33,   631,   632,  2939,    16,    17,  1918,  2939,
     186,  3067,  3067,  2528,  2529,   221,  2897,  1911,  1948,   122,
     630,   509,  2827,   638,   634,   319,   638,  1921,   231,  1065,
    1924,  1925,   263,  1069,    16,    17,  2441,  2442,  1948,   302,
     510,    16,    17,   221,   179,   384,  1180,   277,   611,   521,
     366,    16,    17,    16,    17,  2493,   638,   416,  2493,    12,
       8,   189,   206,   117,  2847,  3691,  2796,  1103,  2155,  3292,
      16,    17,    16,    17,  3021,   438,  2514,  2512,  1751,    16,
      17,  1117,  2493,  1217,   355,  3022,   231,   160,  2974,   617,
     355,   357,   231,  1065,   617,  4086,  2365,  1069,    16,    17,
      40,  2512,   280,   631,   632,  2450,   457,  2277,   631,   632,
     202,   468,  2587,   680,   247,    16,    17,  2587,   253,   966,
     630,    16,    17,   617,   798,   258,   385,  2200,   358,   601,
    1264,  1167,    98,  3067,   237,   263,    74,  3067,   632,  1812,
    1746,  1839,   373,   468,  1180,  2587,   485,   784,    71,   280,
      16,    17,  3564,  3565,   372,   247,  3258,   375,  1759,   372,
    3973,  3974,   375,  2968,   412,   630,  2283,  2284,  1761,   391,
    2113,   318,   372,   638,   433,   375,   372,   388,  1312,   375,
     650,  1217,   135,   617,   124,   752,  1222,  2113,  3787,   372,
    2902,  1227,   375,   148,    16,    17,   372,  4005,   632,   375,
     412,  4094,  2640,   120,   159,  2640,  1242,   617,  2646,  4017,
    2276,  2646,  2384,  4076,   517,   372,   341,   134,   375,   354,
    2286,   631,   632,   277,  1825,  1826,   189,  1263,  1264,  2640,
     630,   179,   352,   439,   412,  2646,   439,   874,   617,  3255,
     476,    16,    17,   617,   607,  1281,  3336,  4517,   372,   543,
     521,   375,   631,   632,   613,  1227,   521,  1293,   632,  1295,
     372,  1297,   185,   375,  3861,   468,   372,    16,    17,   375,
    1306,   302,   354,   630,   372,   569,  1312,   375,   103,   399,
    2353,   373,    16,    17,   486,  1321,  1322,  3177,   372,  2718,
    4114,   375,  3699,   122,   439,   372,   562,   613,   375,  2471,
     439,   374,   225,  2471,   358,   630,   274,    16,    17,   587,
    1346,   249,   578,  1349,  3461,   539,   372,   461,   606,   375,
     453,  1357,  2811,   468,  1360,  1297,   468,   250,   372,   468,
     601,   375,   372,  1369,   545,   375,   601,   567,   586,   372,
     587,  3693,   375,  1379,  1380,   576,   372,  1481,   636,   375,
    1322,    16,    17,  1389,  1390,  1391,  1392,  1393,  1394,    16,
      17,  3166,   372,  1399,   446,   375,   462,  3172,   336,  1405,
    1406,  3176,  1408,   632,   586,  1411,  3973,  3974,   545,   582,
     391,  1389,  1390,  1391,   632,  1393,   211,    16,    17,    12,
     372,    12,  2564,   375,   476,  1431,  2564,   372,  1406,   617,
     375,   318,   468,  1411,   617,   354,  1298,   372,   237,   372,
     375,     0,   375,   631,   632,   545,   371,   617,   631,   632,
    1392,   617,  1394,   990,    16,    17,   372,   630,   372,   375,
     636,   375,   632,  2948,   617,   372,   632,   582,   375,   151,
    3326,   617,   548,   582,   229,  1481,    16,    17,    12,   632,
    4343,  4344,   608,   238,   372,   631,  1492,   375,   155,  1431,
     617,  1497,  3348,   630,  1500,  1501,  4290,   536,    16,    17,
     539,   372,   468,  3924,   375,   632,   632,   372,   401,  4078,
     375,  4080,   431,   227,   486,   630,   398,   355,   630,  4302,
    4303,   630,  1384,   617,    16,    17,   199,   468,   189,  2423,
     630,  2939,  1538,    16,    17,   617,   372,  3022,   632,   375,
     155,   617,   135,   567,   135,   403,  4113,  4114,   302,   617,
     632,  1557,   120,  1559,  1560,  1497,  1562,  1563,  3880,  1501,
      16,    17,  3422,   617,   632,    16,    17,    16,    17,  1575,
     617,  1577,    16,    17,   235,   143,    16,    17,   632,   517,
     372,  1559,  1560,   375,   379,   632,   558,   174,    16,    17,
      12,   617,  3709,   388,   630,    12,   269,    16,    17,   509,
     395,   135,  4396,   617,  4398,  2847,   632,   617,    16,    17,
      16,    17,   180,   225,   617,   539,   136,   468,   632,   544,
     530,   617,   632,   378,   202,  1487,   588,   372,  2685,   632,
     375,  4425,   517,  3764,  4201,  3923,   632,   617,   250,  2779,
    2847,   355,    16,    17,  1650,  1651,    16,    17,   558,  4216,
     508,  2919,   632,   372,    16,    17,   375,   411,  1762,  3067,
    3791,   162,  3067,  4230,   630,   617,  4460,  4461,   372,   631,
     632,   375,   617,   132,   117,    16,    17,    16,    17,   638,
     632,     6,   617,   521,   617,   122,  3067,   632,   147,   630,
    2832,   229,  2177,   372,  2832,   490,   375,   632,   631,   565,
     238,   617,   560,   617,  2280,  1711,  2191,   624,    16,    17,
     617,   596,   373,   135,   631,   631,   484,   631,   135,    16,
      17,  2437,   588,  4290,   631,    16,    17,    16,    17,   617,
     556,    56,   486,    17,    24,  4302,  4303,   372,   181,  2224,
     375,  4246,   600,   631,  4249,   372,   617,  1753,   375,   206,
    3195,  1855,   617,  1759,  3194,  1761,  1762,  4264,  3804,  3805,
     631,   189,     8,   601,   351,   352,   631,  1773,  3227,   153,
     357,   624,  1778,   372,    16,    17,   375,  1783,   631,   630,
    1786,   617,  4349,    29,    74,  1282,  1792,  1793,  1285,  1795,
     585,  1288,  4359,   250,   162,   631,    16,    17,    74,  1805,
     473,    16,    17,  1809,  3579,   220,   264,   521,  2293,   267,
     372,   331,   580,   375,   139,   588,    57,  3499,  2534,  1825,
    1826,  1827,  1828,  3809,   192,   617,    95,    16,    17,  4396,
     202,  4398,   372,  1839,   277,   375,  1842,  1843,  1844,   631,
     378,  4408,  3172,   227,  2560,  2561,  3176,    24,   162,  1855,
    1792,  1793,   620,  1795,   372,  2431,   117,   375,  4425,   632,
    4427,  2429,  4429,  1805,  4369,   638,  1872,  1809,    39,  4436,
      16,    17,   617,  3733,   103,    46,   631,   153,   192,  4446,
     372,  1887,   172,   375,   539,  1827,  1828,   601,   542,   372,
      16,    17,   375,  4460,  4461,    16,    17,    74,   617,   225,
    1842,  1843,  1844,   630,   238,   536,    16,    17,   539,  4476,
    4477,   638,   631,   617,  4481,   358,   372,  1923,   468,   375,
     181,   372,   225,   372,   375,   259,   375,   631,   372,  1935,
     171,   375,   372,   162,   175,   375,  1942,   227,   617,    16,
      17,    77,   225,    79,   372,   186,  3281,   375,    16,    17,
     220,   227,   631,   372,   585,   413,   375,   631,   632,   228,
      95,  1823,   506,   192,   372,   595,   372,   375,   598,   375,
     202,   355,  2844,   130,  2542,   562,   153,   367,   247,    16,
      17,  1923,   617,   527,   120,   235,  2886,    58,    59,   258,
     617,   578,  2892,   631,   632,   172,   631,    68,   372,    17,
    1942,   375,   372,    46,   631,   375,  2886,   143,   287,   288,
     372,   189,  2892,   375,  3101,   217,   277,   219,   617,   309,
    1882,   593,    71,  2917,  2128,  3293,   476,   352,  2132,   280,
    2894,   372,   631,   372,   375,    17,   375,   631,  3125,  3126,
    2046,   636,   592,   593,   180,  3905,  3906,  3907,  3908,   155,
     227,  1793,   638,  1795,  2060,   617,   548,   631,   632,   349,
     718,  3148,   631,   632,   372,   355,  2170,   375,   583,   631,
     456,  2175,   341,   349,   369,   372,   317,   617,   375,   355,
     630,   372,   740,   372,   375,   588,   375,  1000,  1001,   630,
     415,   631,   417,   228,  1956,   753,   754,   358,   508,   617,
    1842,  1843,  1844,  1965,  1966,   625,   626,   627,   628,   185,
    3252,     6,   247,   631,  1976,  1977,  1978,  1979,   136,  1981,
    1982,   117,  2128,   258,   567,   617,  2132,  1040,  2134,   632,
     372,  2137,   309,   375,   617,   638,   185,   521,  2144,  2145,
    2146,  2147,  2785,   439,  2150,    11,   422,   632,   631,   428,
     429,   537,   372,   630,   136,   375,   542,   372,   630,  2137,
     375,   617,   630,  3305,  2170,  2269,   617,  3305,   617,  2175,
     630,   412,   349,   617,   403,   631,   225,   617,   355,  2847,
     631,    21,   631,   372,   453,   181,   375,   631,   630,   617,
     545,   631,   630,    33,   630,  2299,  3338,   630,   617,   585,
    3338,   250,  2144,  2145,  2146,   630,   341,    47,   468,   617,
    4048,   617,   631,   209,   600,  4136,   476,   601,    58,    59,
    4141,   217,  4143,   631,  2086,   631,   372,  2089,  2090,   375,
    2092,   521,   630,  2095,  2096,  2097,  2098,  2099,  2100,  2101,
     631,   632,  2104,   617,  2106,   521,   372,   617,   632,   375,
      61,   372,   630,   522,   375,   617,    11,   631,  2829,   630,
      71,   631,   372,  2269,   630,   375,   631,   632,   166,   631,
     631,   632,   136,    84,  4049,  4135,   617,   630,   617,   609,
     610,   277,   631,   632,  3321,  3322,   117,   423,  2294,  2774,
     631,   638,   631,  2299,   630,   372,   572,   630,   375,   630,
     588,   589,   632,   591,   372,   593,   567,   375,   630,   617,
     539,   601,   630,   331,  2320,  2584,   588,  4019,   453,   630,
     617,  3408,   364,   631,  3699,   601,   617,   402,   617,    16,
      17,   560,   592,   593,   631,   372,   385,   630,   375,   456,
     631,   117,   631,   630,   521,   630,  2352,  3589,   103,   331,
     181,  3245,   401,    74,  4056,   630,   632,  4059,  4060,  4061,
    4062,   370,   358,   631,   632,    24,   635,   122,   631,   632,
     630,   600,    19,   630,   185,   617,  2480,  2481,  2384,   364,
     191,   630,  2388,   631,   632,  4160,  2392,   522,  3530,   631,
     630,  3448,  3530,   630,  4076,  3637,    12,   617,    61,  2405,
     630,  2407,   617,   630,    33,   181,  3360,   136,    71,  3363,
    3364,   631,    58,    59,   225,    74,   631,   631,   632,   631,
     632,    84,   630,  2429,   601,    41,  3380,   630,   617,   630,
      59,   117,   153,   209,   120,  2441,  2442,   192,   630,   250,
      74,   536,   631,   631,   632,   630,   277,   630,    95,  2553,
     631,   632,  3937,  3938,  4156,  4157,   631,   632,   115,   631,
     632,   479,   480,  4165,   630,  2471,   221,   331,   631,   632,
     630,   617,   630,    89,  2480,  2481,   630,    93,   107,   631,
     632,   110,   631,   632,   364,   631,   631,   632,    19,   118,
    4047,   617,   631,   632,   153,   181,   617,   479,   480,  3471,
     630,   277,   631,   632,   151,   631,   227,   617,   155,   238,
     631,   630,    12,   172,   630,  2521,   631,   632,   273,   630,
    2526,   631,   185,   209,  2522,  2531,  2532,   358,   191,   630,
    2536,   117,  2538,   630,   120,  2533,   630,   184,   630,   186,
     617,  2539,  2548,  2405,  2550,  2551,   200,  2553,  2554,   617,
     631,   632,   630,  2559,   631,   202,  2562,   630,  2564,   216,
     207,   630,   225,   631,    95,  2563,    95,  2573,   227,   630,
    2568,   567,   630,   117,   221,   630,  2574,  2575,  2584,   630,
     617,   228,   358,   631,   632,  2591,  2592,   250,   235,   630,
     401,   277,   630,   227,   631,   181,   630,  2603,   631,   632,
     247,   630,   331,   621,   622,   623,   624,   625,   626,   627,
     628,   258,   631,   632,   631,   632,   263,  1079,  1080,  1081,
     151,   155,   156,   209,   155,   272,   242,   630,   349,  1091,
     630,  2573,   631,   632,   355,   135,   630,   181,   630,   621,
     622,   623,   624,   625,   626,   627,   628,   117,   403,    30,
     309,  3136,   306,   307,   630,   186,   630,   311,   312,   193,
    1122,  2667,  2668,  1125,   321,   209,   631,   632,   325,   630,
     204,   202,   358,   631,   632,   332,   207,   630,  2540,  2541,
    4518,   631,   632,   494,  1146,  1147,   631,   632,  1150,  2958,
     349,   277,   631,   632,   341,    76,   355,   228,   630,   228,
      31,   422,   318,  3188,   235,  2567,  1168,  1169,   630,   243,
     210,   181,  3280,   630,   343,   349,   247,   364,   247,   474,
     254,   355,   385,  2992,   630,  2667,   373,   258,   632,   258,
     221,  3000,   263,   277,   574,  3004,   567,   491,   401,   209,
      48,   272,   136,   631,   632,   631,   632,   281,   631,   632,
     479,   480,   274,   410,   594,   595,   403,   631,   632,   623,
     624,   625,   626,   627,   628,   381,   577,    48,   149,   631,
     632,   632,   358,   117,  2636,   364,   120,   631,   632,   631,
     632,  3050,   537,   364,   539,    74,   462,  3430,   422,   576,
    2796,   567,  2798,   631,   632,  2801,  2802,  2803,  2804,    88,
     521,   625,   145,   146,  2810,   136,   453,   277,   476,   466,
     341,   345,   341,   638,   358,   631,   632,  3734,  3735,  1154,
    1155,   638,  2828,  2829,    74,   161,  2832,  4158,  4159,   476,
     585,   494,   630,   364,   263,   364,   186,   181,  3446,  3447,
     129,  2847,   373,   517,  2850,  2851,  2852,  3264,  3265,  3220,
    3221,   572,   536,  3825,   161,   484,   106,  2863,   274,  3831,
     152,   517,   521,  3511,  3512,   209,   632,  2971,  2810,    83,
     632,  3914,   403,   632,   532,   522,   365,   493,   631,   151,
     601,   567,   120,    25,   106,   637,     6,   521,   358,   630,
    3458,     4,   621,   622,   623,   624,   625,   626,   627,   628,
     136,   521,   522,   153,  4046,   525,   526,   238,  4046,   529,
     105,   531,   632,   388,   577,   467,   238,   533,   600,   632,
     385,    55,   453,   552,   453,   431,    68,   166,   106,   576,
      72,   262,    74,   277,   136,   218,   632,   331,   572,   632,
     587,   588,   601,   638,  2950,   476,   603,  2953,  2954,    68,
      12,   580,  2958,   497,   605,   135,   631,    16,    17,   606,
     103,   608,   619,   252,   631,  2971,     9,   601,  2974,   638,
    3612,  3613,   632,   632,   638,   225,   631,  3585,   120,   631,
     630,   567,   631,  3625,   631,   632,  2992,   262,   635,   636,
    3632,   522,   632,   522,  3000,   638,    35,   153,  3004,    74,
     331,  2863,   502,   503,   504,   505,   506,   507,   632,   637,
     274,   274,   274,    88,   358,  3657,   274,   398,  3660,   162,
     351,   352,   522,   567,  3030,    48,   274,  3033,   274,   632,
     632,   155,  3038,  2895,  2896,   536,  2898,   630,  3044,   420,
     329,   269,  3048,   556,  3050,   576,   386,   117,   632,   192,
     120,   556,   111,   112,   113,   114,   115,   588,   308,  3065,
     632,   632,   351,   352,   385,   354,  3044,    12,   632,   155,
     632,   110,  3078,   454,   632,   606,   326,   608,   117,  3085,
      68,   632,   225,   238,   625,   479,   480,   241,   155,   534,
    3096,  3033,   176,   186,   425,   331,   632,   567,  4240,   349,
     631,   632,  4240,   581,   635,   636,   489,   389,   250,   131,
    2972,   181,   179,   169,   632,  3758,   631,    25,    26,  2981,
    1582,   364,   632,   155,  4096,   414,   193,   155,   155,   331,
     273,   155,   513,  4005,   136,   174,   155,   204,   155,   209,
     155,   155,   181,  3085,   155,  4017,   155,   155,   479,   480,
      58,    59,    60,   632,   213,   214,   215,   216,   155,   155,
      68,   492,   155,  3267,   155,   155,    74,   587,   155,   155,
     209,   155,   155,   155,    82,   155,  3182,   252,   155,   155,
     583,   612,   192,   364,  3190,   805,   253,   254,  3796,  3797,
    1652,  3799,  3800,   364,  1656,   364,   632,   189,   106,   631,
     189,   631,   625,    33,  3772,   631,   631,   277,  3070,   351,
     352,   632,   120,   631,   281,   357,   124,   631,  1680,   508,
     631,   631,   364,   567,   624,   630,   632,  3233,   622,   623,
     624,   625,   626,   627,   628,   631,   238,   632,   277,   631,
     631,   631,   631,   479,   480,   153,  3252,  3253,   576,   631,
    3256,   631,  3258,  4147,   329,   398,   631,   477,   630,   401,
     403,  3267,   321,   630,   323,   324,   325,  3273,   628,   630,
     632,   521,   631,   332,  3280,  3281,  4319,   479,   480,   354,
     545,   348,   103,   556,   545,   545,   606,   537,   358,   226,
     621,   622,   623,   624,   625,   626,   627,   628,   128,  3305,
     630,    95,   528,   342,    11,   630,   200,   189,    33,   638,
    3316,   630,   630,   372,   353,   632,   375,   225,   357,   358,
    3326,   260,  3328,   153,   232,   287,   288,   157,  3190,   331,
     472,   474,  3338,   400,   632,   638,   638,   638,  3344,   414,
    3346,   249,  3348,   189,   631,  3918,   411,   476,  4490,   186,
     585,   410,  4490,   632,   632,    46,   508,  3461,  4330,  4331,
     339,  4333,  4504,   508,   194,    54,  4504,  4509,   508,  4412,
     191,  4509,  4514,   508,    63,   508,  4514,   467,    71,   521,
     385,   388,   212,   556,    73,   621,   622,   623,   624,   625,
     626,   627,   628,   131,   537,   248,    85,    86,    87,   542,
     308,   537,   131,   128,   225,   248,   465,   466,  4380,   537,
    4382,  4383,   101,  3999,  3420,   385,   385,   560,   326,   385,
     385,   623,   624,   625,   626,   627,   628,  3289,   153,    46,
      35,   385,   157,   508,   228,   577,   387,   385,   385,  3445,
    3446,  3447,   585,  3547,   274,   385,   630,   630,   273,   434,
     588,   630,   273,   247,   631,  3461,   638,   600,   234,   149,
     234,   631,   638,   631,   258,   631,   428,   429,   631,   194,
     631,   631,   380,   631,   631,   155,   638,   479,   480,   632,
     388,   632,   556,    25,    26,  4457,  4129,   212,   638,    54,
    4127,  4064,  4472,   556,   545,   556,   613,   567,    63,   519,
     632,   269,    46,   630,   630,   110,   545,   155,    73,   630,
     549,   556,   117,   552,   630,   155,    58,    59,    60,  3525,
      85,    86,    87,   562,  3530,   370,    68,   547,   567,   189,
    3634,   570,    74,   189,   189,   235,   101,   499,   500,   501,
      82,  3547,   189,   244,   603,   545,   545,   341,   416,   274,
     458,  3413,   632,   358,   155,   155,   632,   155,   617,   618,
     619,   388,   247,   247,   106,   376,   322,   106,   106,   174,
     364,   250,   402,   169,  3436,   250,   181,   630,   120,  3585,
     638,   411,   124,   556,   623,   624,   630,   369,  3594,   202,
     545,    19,   449,   630,   385,   625,   426,  3603,  3596,   630,
     638,   630,   236,   236,   209,  3709,   514,   515,   516,   630,
     364,   153,   630,   521,   444,   631,   385,   630,  4512,   621,
     622,   623,   624,   625,   626,   627,   628,   631,  3634,   537,
     631,   320,   540,   631,   221,   638,   264,   632,   632,   189,
     582,   238,   155,   416,   625,   665,   121,   364,   337,   608,
     670,   250,  3594,   474,   632,  3661,  4201,   487,   632,   453,
     631,   247,  3668,   631,   631,   247,   638,   631,   576,   632,
    3774,  4216,   277,   494,  4242,   631,   250,   402,   631,   631,
    3686,   701,   631,   225,   630,  4230,   411,   517,   632,   632,
     232,   632,   630,  3699,  3556,   631,   399,   717,   364,   364,
      74,   426,    19,  3709,   631,   630,   536,   249,   632,   539,
     364,   364,   491,   468,   631,   630,   537,   630,   539,   444,
     262,   542,   373,   630,   632,   631,   358,   470,   522,  4366,
     631,   608,   631,   260,    11,   451,   272,   342,   416,   200,
     142,   761,   762,   763,   764,   256,   631,   631,   202,   632,
     478,   155,   357,   358,   774,   320,   577,   247,   247,   448,
     390,   632,   487,   630,   585,   120,   308,   120,  3774,   539,
     630,   397,   337,   638,  3636,   464,   630,    78,   486,   138,
     631,  3787,   491,   631,   326,   632,   463,   631,    19,   631,
    3796,  3797,   517,  3799,  3800,   263,   631,   631,   631,   631,
      33,  4374,   631,    33,  4349,   631,   328,   631,   631,   252,
     632,   631,   170,  3675,  4359,  2089,  2090,   411,  2092,   272,
    3924,  2095,  2096,  2097,  2098,  2099,  2100,  2101,   608,  4466,
    2104,   630,  2106,   370,   235,   524,   631,   638,   380,    12,
      13,    46,   632,   207,   632,   328,   388,   155,   588,   588,
     631,   598,   541,   630,   305,  4492,   598,   120,   630,   630,
     582,   250,   250,  4408,   630,  3871,  3872,   630,   630,   630,
     357,    33,  4515,   358,   631,   168,   358,  3883,   630,   632,
     328,   631,  4427,   545,  4429,   250,   545,   545,   592,   539,
     588,  4436,   588,   630,   235,   364,   353,   632,   593,   464,
     512,  4446,   608,   449,   631,   631,   358,  3913,   370,   582,
    3916,   527,   630,   150,    30,  3777,   458,   630,  3924,   630,
     639,    94,   605,   383,   186,   547,   631,   131,   131,   631,
    3872,  4476,  4477,   153,   631,    70,  4481,   403,   630,   186,
     545,   605,    30,   424,   549,   189,    61,   552,   370,  3955,
     631,    61,   125,   528,    14,   265,   632,   562,   630,   524,
     631,     5,   567,   235,  3970,   570,   139,   364,   364,  3975,
     149,  3913,   514,   515,   516,   636,   541,   370,   370,   521,
     129,   138,    46,    46,   630,   148,   630,    46,    46,   162,
      46,   630,   165,   582,   125,   537,   605,   149,   540,   220,
    1020,   279,   639,   144,    46,   178,   119,   636,    46,   630,
      46,    52,   138,   548,   459,   457,   636,   632,   623,   624,
     358,   631,   149,   548,   632,   205,   632,   200,   218,   636,
     632,    52,   149,   186,   576,   186,   631,    46,   631,   186,
    4046,   548,   120,   438,   607,   221,   358,   630,   188,   476,
    3980,   632,   225,  2306,  2108,  1075,  1076,  4161,   231,  3422,
     648,  3423,  2509,  3684,  1084,  1085,  1086,  1087,  1088,  1089,
    1090,  4130,  4078,  4010,  4080,  4309,   997,  4310,  1098,  1099,
    3682,  1101,  1102,  3686,  3870,  4492,  1106,  1107,   630,  4454,
    1110,  1111,  1112,  1113,    46,  1115,  1116,   576,  1838,   272,
    4106,  2796,  1783,  1123,  1124,  4462,  1126,  1127,  1128,  1129,
    1130,  3861,  3861,  1133,  1134,  1135,  1136,  1137,  1138,  1139,
    1140,  1141,  1142,  1143,  3861,  1145,  3861,  4346,  1148,  1149,
    3861,  3861,  3861,  1153,    32,    33,  3861,  1157,  1158,  1159,
      38,  3861,    40,  3861,    42,    43,  4152,  4194,  4346,  3861,
    1170,  1171,  1172,  4220,  4303,  4161,  4018,  3861,  3861,  1179,
    4264,    59,  4219,    12,    13,  1038,  1186,  1187,  1188,  3879,
    1190,  1494,  2059,  2998,  1490,  2823,  3524,  1197,  1198,  1199,
    3233,  1201,  1202,  1203,  1204,  1205,  2828,  1207,  1208,  1209,
    1210,  1211,  1212,  1213,  1214,  1309,  4152,  3914,  1218,  1219,
    4244,  3527,   547,  4412,  4327,  4374,  4064,  1552,   514,   107,
    2052,  3439,   110,  2668,  3071,  3348,  2060,  2594,  3326,  3371,
     118,  4325,  3371,  3823,  3404,  3645,  3595,  4242,  3634,  2752,
    3173,   404,  3176,  2480,  4240,   408,  3168,  4085,    11,   137,
      11,  4088,  1566,  4033,  4021,    94,  4089,  4029,  2142,  3883,
    3831,   424,  2059,  1445,   579,  2587,   154,  3600,  4264,   432,
    3327,  2379,  1548,  2810,  1827,  2345,  1441,   440,  1501,  2396,
    3228,   595,  2262,  1849,  2785,  3190,   125,   895,  1117,  2176,
    3295,    13,   180,  2261,   182,  2472,  3940,  4083,  4341,  3420,
     139,  4342,  2287,  4155,  1091,   468,  3338,   195,   196,  3788,
    4443,  3774,  4159,  2401,  2147,  1228,  3530,  3247,   481,   482,
    1322,  2383,  2340,   162,   983,   983,   165,  3246,  3305,  4325,
     983,  4240,  1297,   584,  1575,   670,   983,   661,  1919,   178,
     575,  1397,  1920,  1425,  1772,  4341,  4342,  1357,   236,  3346,
    3231,  4410,  4439,  4271,  4337,  4351,  4509,  1367,  4514,  3252,
    3637,   200,  4358,  3280,  1708,   574,   701,   574,   531,  2426,
    3281,  1875,    94,  2419,  1290,  1385,  2418,  2412,   266,  1329,
    1809,   568,   717,   877,  3903,  2798,   225,   275,   276,  3909,
     278,   569,   231,  1557,   882,   510,  1347,   560,   510,  4251,
    4252,  4000,  3670,   125,   648,   648,  4500,   648,    -1,  1357,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   139,    -1,   582,
      -1,   584,    -1,    -1,    -1,    -1,   314,   315,   316,   764,
    4426,    -1,    -1,   272,    -1,  4431,    -1,    -1,    -1,    -1,
     162,    -1,    -1,   165,    -1,   333,   334,   335,    -1,    -1,
      -1,    -1,   340,    -1,    -1,   343,   178,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4466,    -1,   360,   361,    -1,    -1,    -1,    -1,   200,    -1,
     222,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4490,    -1,  4492,    -1,    -1,    -1,
      -1,    -1,    -1,   225,  4500,   393,   394,    -1,  4504,   231,
      -1,    -1,    -1,  4509,    -1,    -1,    -1,    -1,  4514,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     418,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     282,   283,   284,   285,   286,   287,   288,   289,   290,   291,
     272,   293,   294,   295,   296,   297,   298,   299,   300,   301,
      -1,   303,   304,    -1,    -1,   404,    -1,    -1,    -1,   408,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1588,    -1,
      -1,    -1,    -1,    -1,   472,   424,    -1,    -1,   476,    -1,
      -1,    -1,    -1,   432,    -1,    -1,    -1,    -1,    -1,    -1,
     488,   440,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   468,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   481,   482,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,
      -1,   549,    -1,    -1,   552,   553,   554,   555,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1686,  1687,  1688,    -1,
      -1,    -1,   404,    -1,    -1,  1020,   428,   429,    -1,    -1,
      -1,  1701,   531,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   424,    -1,    -1,    -1,   594,   595,    -1,    -1,
     432,    -1,    -1,    -1,    -1,    -1,    -1,  1727,   440,    -1,
      -1,   560,    -1,  1733,    -1,    -1,  1736,    -1,  1738,    -1,
      -1,   619,    -1,    -1,  1744,    -1,  1746,  1747,    -1,    -1,
    1075,  1076,    -1,   582,    -1,   584,   468,    -1,    -1,  1084,
    1085,    -1,    -1,  1088,  1089,  1090,    -1,    -1,    -1,   481,
     482,    -1,    -1,  1098,  1099,    -1,  1101,  1102,    -1,    -1,
      -1,  1106,    -1,    -1,    -1,  1110,  1111,  1112,  1113,    -1,
    1115,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1123,  1124,
      -1,  1126,  1127,    -1,    -1,    -1,    -1,    -1,  1133,  1134,
    1135,    -1,    -1,  1138,  1139,  1140,  1141,  1142,  1143,   531,
    1145,    -1,  1822,  1148,  1149,    -1,    -1,    -1,  1153,    -1,
      -1,    -1,  1157,  1158,  1159,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1170,  1171,  1172,   560,    -1,
      -1,    -1,    -1,    -1,  1179,    -1,    -1,    -1,    -1,    -1,
      -1,  1186,  1187,  1188,    -1,    -1,    -1,    -1,    -1,    -1,
     582,    -1,   584,  1873,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1881,    -1,     6,    -1,    -1,    -1,    -1,    11,    -1,
      13,    -1,    15,    -1,  1219,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    25,    26,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    56,    -1,    -1,    -1,    60,    61,    -1,
      -1,    -1,    -1,    66,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    74,    -1,    -1,    25,    26,    -1,    -1,    -1,    82,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    91,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   106,    -1,    -1,    -1,    -1,    -1,    60,
      -1,    -1,   111,   112,   113,   114,   115,   120,    -1,    -1,
      -1,   124,    -1,    74,    -1,    -1,    -1,    -1,    -1,   132,
     133,    82,    -1,    -1,    -1,    -1,   139,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   147,    -1,    -1,    -1,   151,    -1,
     153,    -1,  1357,    -1,    -1,   106,    -1,    -1,    -1,    -1,
      -1,   164,  1367,    -1,    -1,    -1,    -1,    -1,    -1,   120,
      -1,    -1,    -1,   124,    -1,    -1,    -1,    -1,    -1,    -1,
    1385,   184,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   153,  2083,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   213,   214,   215,   216,    -1,    -1,
     223,    -1,   225,    -1,    -1,    -1,    -1,    -1,    -1,   232,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   249,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   272,
      -1,    -1,    -1,    -1,   225,    -1,  2156,    -1,    -1,    -1,
    2160,   232,    -1,    -1,    -1,  2165,  2166,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2174,    -1,    -1,  2177,   249,    -1,
      -1,    -1,    -1,    -1,    -1,   308,    -1,  2187,  2188,    -1,
    2190,  2191,    -1,  2193,  2194,  2195,  2196,  2197,    -1,    -1,
    2200,    -1,   321,   326,   323,   324,   325,   330,    -1,  2209,
      -1,    -1,    -1,   332,    -1,    -1,  2216,    -1,  2218,    -1,
    2220,  2221,    -1,  2223,  2224,    -1,    -1,    -1,  2228,  2229,
    2230,    -1,    -1,    -1,  2234,  2235,  2236,   308,  2238,    -1,
    2240,    -1,  2242,    -1,  2244,   368,  2246,    -1,    -1,    -1,
     373,  2251,    -1,    -1,    -1,   326,    -1,   380,    -1,    -1,
      -1,    -1,   385,  1588,    -1,   388,    -1,    -1,    -1,    -1,
    2270,    -1,    -1,    -1,    -1,    -1,    -1,  2277,    -1,    -1,
    2280,    -1,    -1,    -1,    -1,    -1,  2286,    -1,    -1,  2289,
      -1,   410,    -1,  2293,    -1,    -1,   419,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   380,
     433,   434,   435,   436,    -1,    -1,    -1,   388,    -1,    -1,
      -1,    -1,    -1,    13,    -1,    15,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   458,    -1,    -1,    -1,    -1,
      30,    -1,    -1,    -1,    34,    -1,   465,   466,    -1,    -1,
      -1,    -1,    -1,  2353,    -1,    -1,    -1,    -1,    48,    49,
      -1,  1686,  1687,  1688,    -1,    -1,    56,    -1,    -1,    -1,
      60,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    76,   458,    -1,    -1,
      -1,   514,   515,   516,    -1,    -1,    -1,    -1,   521,    -1,
      -1,    -1,  1727,    -1,    94,    -1,    -1,    -1,    -1,    -1,
      -1,  1736,    -1,  1738,   537,    -1,    -1,   540,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   116,  2427,    -1,    -1,
      -1,  2431,    -1,    -1,    -1,   125,   126,   127,    -1,    -1,
     563,    -1,    -1,   514,   515,   516,    -1,    -1,   138,   139,
     521,    -1,    -1,   576,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   151,    -1,    -1,    -1,    -1,   537,    -1,    -1,   540,
      -1,    -1,    -1,    -1,    -1,   165,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   603,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   183,    -1,    -1,    -1,  1822,    -1,   618,
     619,    -1,    -1,    -1,    -1,   576,    -1,    -1,   198,    -1,
     200,    -1,    -1,   636,    -1,   205,    -1,    -1,   208,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   231,    -1,   233,    -1,    -1,    -1,    -1,  1873,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1881,    -1,    -1,    25,
      26,   251,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   268,    -1,
      -1,    -1,   272,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    58,    59,    60,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    68,    -1,    -1,    -1,    -1,    -1,    74,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    82,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     106,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   120,    -1,    -1,    -1,   124,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   368,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   153,    -1,  2689,
      -1,    -1,    -1,  2693,    -1,   385,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   398,    -1,
      -1,    -1,    -1,  2713,  2714,    -1,    -1,    -1,    -1,   409,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2734,    -1,    -1,    -1,    -1,    -1,
      -1,   431,    -1,  2743,   434,  2745,   436,  2747,    -1,   439,
      -1,    -1,   442,   443,    -1,    -1,    -1,    -1,  2083,   225,
      -1,    -1,   452,    -1,   454,    -1,   232,    -1,    -1,    -1,
      -1,    -1,   462,    -1,  2774,    -1,    -1,    -1,   468,  2779,
      -1,    -1,    -1,   249,    -1,    -1,   476,    -1,    -1,    -1,
      -1,   481,    -1,   483,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2806,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   513,    -1,    -1,    -1,    -1,    -1,    -1,
     520,  2156,    -1,    -1,    -1,  2160,    -1,    -1,    -1,    -1,
    2165,  2166,   308,    -1,    -1,    -1,    -1,    -1,    -1,  2174,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     326,    -1,  2187,  2188,    -1,  2190,    -1,    -1,  2193,  2194,
    2195,  2196,  2197,   563,    -1,    -1,    -1,    -1,  2878,    -1,
      -1,    -1,    -1,    -1,  2209,   575,    -1,    -1,    -1,   579,
      -1,  2216,   582,  2218,    -1,  2220,  2221,   587,  2223,    13,
      -1,    15,    -1,  2228,  2229,  2230,    -1,    -1,    -1,  2234,
    2235,  2236,    -1,  2238,   380,  2240,    -1,  2242,    -1,  2244,
      34,  2246,   388,    -1,  2924,   615,  2251,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    48,    49,    -1,    -1,    -1,    -1,
     630,    -1,    56,    -1,    -1,  2270,    60,    61,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2286,    76,    -1,  2289,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      94,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   458,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   116,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   125,   126,   127,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   138,   139,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3041,  3042,    -1,    -1,    -1,    -1,    -1,   514,   515,
     516,   165,    -1,    -1,    -1,   521,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   183,
      -1,   537,    -1,    -1,   540,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   198,    -1,   200,    -1,    -1,    -1,
      -1,   205,     6,    -1,   208,    -1,    -1,    11,    -1,    13,
      -1,    -1,  2427,    -1,  3104,    -1,    -1,    -1,    -1,    -1,
     576,    25,    26,    -1,    -1,    -1,    -1,   231,    -1,   233,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3129,
      -1,    -1,    -1,  3133,  3134,    -1,  3136,   251,    -1,    -1,
      -1,    -1,    56,    -1,    -1,  3145,    60,    -1,    -1,    -1,
    3150,    -1,    -1,  3153,   268,  3155,  3156,    -1,   272,    -1,
      74,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    82,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    91,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3188,    -1,
      -1,    -1,   106,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   120,    -1,    -1,    -1,
     124,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,    -1,
      -1,    -1,  3222,    -1,    -1,   139,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   147,    -1,    -1,    -1,    -1,    -1,   153,
      -1,    -1,    -1,    -1,    -1,    -1,  3246,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   368,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     184,   385,    33,    34,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   398,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   409,    -1,    58,    59,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3307,    69,    -1,
      -1,   225,    -1,    -1,    -1,  3315,    -1,   431,   232,    -1,
     434,    -1,   436,    -1,    -1,   439,    -1,    -1,   442,   443,
      -1,    92,    -1,    94,    -1,   249,    -1,    -1,   452,    -1,
     454,    -1,    -1,   104,    -1,    -1,    -1,    -1,   462,    -1,
      -1,    -1,    -1,    -1,   468,    -1,    -1,    -1,   272,    -1,
      -1,    -1,   476,    -1,  2689,    -1,    -1,   481,  2693,   483,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2713,  2714,
      -1,   152,   153,    -1,   308,    -1,    -1,   158,    -1,   513,
     161,    -1,    -1,    -1,    -1,    -1,   520,    -1,    -1,  2734,
      -1,    -1,   326,    -1,    -1,    -1,   330,    -1,  2743,    -1,
    2745,    -1,  2747,    -1,    -1,    -1,    -1,    -1,    -1,   190,
      -1,   192,    -1,    -1,    -1,    -1,    -1,    -1,   199,    -1,
     201,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   563,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   373,
      -1,   575,    -1,   224,   225,   579,   380,    -1,   582,    -1,
      -1,    -1,    -1,   587,   388,    -1,    -1,    -1,    -1,    -1,
      -1,  2806,    -1,    -1,    -1,    -1,    -1,   248,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   615,    -1,    -1,    -1,    -1,    -1,    -1,   269,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   630,    -1,    -1,    -1,
     434,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3531,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   302,    -1,    -1,   458,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2878,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3568,  3569,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3577,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2924,
     514,   515,   516,    -1,    -1,    -1,   367,   521,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   537,    -1,    -1,   540,    -1,    -1,    -1,
      -1,   392,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   402,   403,    -1,    -1,   406,   407,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   576,    -1,    -1,    -1,   427,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   473,    -1,    -1,    -1,  3041,  3042,    -1,    -1,
    3720,    -1,    -1,    -1,    -1,   486,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3755,   517,    -1,    -1,    -1,
     521,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3769,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   539,  3104,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3129,    -1,    -1,    -1,  3133,  3134,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3145,    -1,    -1,    -1,    -1,  3150,    -1,    -1,  3153,    -1,
    3155,  3156,    -1,    -1,    -1,   596,    -1,    -1,    -1,    -1,
      -1,   602,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3861,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3222,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3914,    -1,    -1,    -1,    -1,    -1,
      -1,  3246,  3922,    -1,    -1,    -1,    -1,    -1,    -1,  3929,
      -1,  3931,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3967,    -1,    -1,
      -1,    -1,    -1,  3973,  3974,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3307,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3315,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4069,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4099,
      -1,  4101,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4111,    -1,  4113,  4114,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4140,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4199,
      -1,  4201,    -1,    -1,    -1,    -1,  3531,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4216,  4217,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4230,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4241,    -1,  3568,  3569,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3577,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4289,
    4290,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4302,  4303,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4319,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4349,
      -1,    -1,    -1,    -1,    -1,    -1,  4356,    -1,    -1,  4359,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4389,
      -1,    -1,    -1,    -1,    -1,  3720,  4396,    -1,  4398,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4408,    -1,
      -1,    -1,  4412,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4425,    -1,  4427,    -1,  4429,
    3755,    -1,    -1,    -1,    -1,    -1,  4436,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3769,    -1,  4446,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4460,  4461,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4476,  4477,    -1,    -1,
      -1,  4481,    -1,    -1,    -1,    -1,    -1,  4487,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4517,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3922,    -1,    -1,
      -1,    -1,    -1,    -1,  3929,    -1,  3931,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3967,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4069,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4099,    -1,  4101,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4111,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4199,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4217,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4241,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4289,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4356,    -1,    -1,    -1,    -1,    -1,    -1,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    14,    -1,    -1,
      -1,    18,    -1,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    -1,    30,  4389,    -1,    33,    34,    35,    36,
      37,    38,    39,    -1,    41,    42,    43,    44,    45,    -1,
      47,    48,    -1,    -1,    51,    52,    53,    54,    55,    -1,
      57,    58,    59,    60,    -1,    62,    63,    64,    65,    66,
      67,    -1,    69,    70,    -1,    72,    73,    74,    75,    76,
      77,    78,    79,    80,    -1,    82,    83,    -1,    85,    86,
      87,    88,    89,    -1,    91,    92,    93,    -1,    -1,    96,
      97,    98,    99,    -1,   101,   102,   103,    -1,   105,   106,
     107,   108,   109,   110,    -1,    -1,    -1,    -1,   115,   116,
     117,    -1,    -1,   120,   121,   122,    -1,   124,    -1,    -1,
      -1,   128,  4487,   130,   131,   132,   133,   134,    -1,    -1,
      -1,   138,    -1,    -1,   141,   142,   143,    -1,    -1,    -1,
     147,    -1,   149,   150,    -1,   152,   153,   154,    -1,    -1,
     157,   158,  4517,   160,   161,   162,   163,   164,   165,   166,
      -1,   168,   169,   170,   171,   172,   173,   174,   175,   176,
      -1,   178,   179,   180,   181,    -1,   183,    -1,    -1,    -1,
     187,   188,    -1,   190,    -1,   192,    -1,   194,   195,   196,
     197,    -1,   199,    -1,   201,    -1,   203,    -1,   205,   206,
      -1,   208,   209,    -1,   211,   212,    -1,    -1,    -1,   216,
     217,   218,   219,   220,    -1,   222,   223,   224,    -1,    -1,
     227,    -1,    -1,    -1,   231,   232,   233,   234,    -1,    -1,
     237,    -1,    -1,    -1,   241,   242,    -1,   244,   245,    -1,
      -1,    -1,   249,    -1,    -1,   252,   253,    -1,   255,   256,
      -1,   258,   259,   260,    -1,    -1,    -1,    -1,    -1,   266,
     267,    -1,   269,    -1,   271,    -1,   273,   274,    -1,    -1,
     277,    -1,    -1,    -1,    -1,   282,    -1,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,    -1,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,    -1,    -1,    -1,    -1,
     317,   318,   319,   320,   321,   322,    -1,    -1,   325,   326,
     327,   328,    -1,   330,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,    -1,   342,   343,   344,    -1,    -1,
     347,   348,   349,   350,   351,   352,   353,   354,   355,    -1,
     357,   358,   359,    -1,   361,   362,   363,    -1,   365,   366,
     367,    -1,   369,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   379,   380,   381,   382,   383,   384,    -1,   386,
     387,   388,   389,   390,   391,   392,   393,   394,   395,   396,
      -1,   398,   399,   400,    -1,   402,    -1,   404,   405,   406,
     407,   408,    -1,   410,   411,   412,    -1,    -1,   415,    -1,
      -1,    -1,   419,   420,   421,   422,   423,    -1,    -1,   426,
     427,   428,   429,   430,    -1,   432,   433,    -1,   435,   436,
     437,   438,   439,   440,    -1,   442,    -1,   444,   445,    -1,
     447,   448,   449,    -1,   451,    -1,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   462,   463,   464,    -1,   466,
     467,    -1,    -1,    -1,   471,   472,   473,   474,    -1,    -1,
      -1,   478,    -1,    -1,    -1,   482,    -1,   484,   485,   486,
     487,    -1,   489,   490,   491,   492,   493,    -1,    -1,    -1,
      -1,    -1,   499,   500,   501,    -1,   503,   504,    -1,   506,
      -1,    -1,   509,    -1,    -1,   512,   513,   514,   515,   516,
     517,   518,   519,   520,   521,    -1,   523,   524,   525,   526,
     527,   528,   529,   530,   531,   532,   533,   534,   535,   536,
     537,    -1,    -1,   540,   541,   542,   543,    -1,   545,   546,
     547,    -1,   549,   550,   551,   552,    -1,    -1,    -1,    -1,
     557,   558,   559,    -1,   561,   562,   563,   564,   565,   566,
     567,   568,   569,   570,   571,   572,    -1,   574,   575,    -1,
      -1,   578,    -1,    -1,   581,    -1,   583,    -1,   585,   586,
      -1,    -1,   589,   590,   591,   592,   593,    -1,    -1,   596,
     597,    -1,   599,   600,   601,   602,   603,   604,    -1,    -1,
      -1,    -1,    -1,    -1,   611,   612,    -1,   614,   615,   616,
      -1,    -1,   619,    -1,    -1,    -1,   623,   624,    -1,    -1,
      -1,    -1,   629,   630,    -1,    -1,   633,   634,    -1,    -1,
     637,   638,     5,    -1,     7,     8,     9,    10,    11,    12,
      -1,    14,    -1,    -1,    -1,    18,    -1,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    -1,    30,    -1,    -1,
      33,    34,    35,    36,    37,    38,    39,    -1,    41,    42,
      43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,    52,
      53,    54,    55,    -1,    57,    58,    59,    60,    -1,    62,
      63,    64,    65,    66,    67,    -1,    69,    70,    -1,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    -1,    82,
      83,    -1,    85,    86,    87,    88,    89,    -1,    91,    92,
      93,    -1,    -1,    96,    97,    98,    99,    -1,   101,   102,
     103,    -1,   105,   106,   107,   108,   109,   110,    -1,    -1,
      -1,    -1,   115,   116,   117,    -1,    -1,   120,   121,   122,
      -1,   124,    -1,    -1,    -1,   128,    -1,   130,   131,   132,
     133,   134,    -1,    -1,    -1,   138,    -1,    -1,   141,   142,
     143,    -1,    -1,    -1,   147,    -1,   149,   150,    -1,   152,
     153,   154,    -1,    -1,   157,   158,    -1,   160,   161,   162,
     163,   164,   165,   166,    -1,   168,   169,   170,   171,   172,
     173,   174,   175,   176,    -1,   178,   179,   180,   181,    -1,
     183,    -1,    -1,    -1,   187,   188,    -1,   190,    -1,   192,
      -1,   194,   195,   196,   197,    -1,   199,    -1,   201,    -1,
     203,    -1,   205,   206,    -1,   208,   209,    -1,   211,   212,
      -1,    -1,    -1,   216,   217,   218,   219,   220,    -1,   222,
     223,   224,    -1,    -1,   227,    -1,    -1,    -1,   231,   232,
     233,   234,    -1,    -1,   237,    -1,    -1,    -1,   241,   242,
      -1,   244,   245,    -1,    -1,    -1,   249,    -1,    -1,   252,
     253,    -1,    -1,   256,    -1,   258,   259,   260,    -1,    -1,
      -1,    -1,    -1,   266,   267,    -1,   269,    -1,   271,    -1,
     273,   274,    -1,    -1,   277,    -1,    -1,    -1,    -1,   282,
      -1,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,   300,    -1,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
      -1,    -1,    -1,    -1,   317,   318,   319,   320,   321,   322,
      -1,    -1,   325,   326,   327,   328,    -1,   330,   331,   332,
     333,   334,   335,   336,   337,   338,   339,   340,    -1,   342,
     343,   344,    -1,    -1,   347,   348,   349,   350,   351,   352,
     353,   354,   355,    -1,   357,   358,   359,    -1,   361,   362,
     363,   364,   365,   366,   367,    -1,   369,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   379,   380,   381,   382,
     383,   384,    -1,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,    -1,   398,   399,   400,    -1,   402,
      -1,   404,   405,   406,   407,   408,    -1,   410,   411,   412,
      -1,    -1,   415,    -1,    -1,    -1,   419,   420,   421,   422,
     423,    -1,    -1,   426,   427,   428,   429,   430,    -1,   432,
     433,    -1,   435,   436,   437,   438,   439,   440,    -1,   442,
      -1,   444,   445,    -1,   447,   448,   449,    -1,   451,    -1,
     453,   454,   455,   456,   457,   458,   459,   460,   461,   462,
     463,   464,    -1,   466,   467,    -1,    -1,    -1,   471,   472,
     473,   474,    -1,    -1,    -1,   478,    -1,    -1,    -1,   482,
      -1,   484,   485,   486,   487,    -1,   489,   490,   491,   492,
     493,    -1,    -1,    -1,    -1,    -1,   499,   500,   501,    -1,
     503,   504,    -1,   506,    -1,    -1,   509,    -1,    -1,   512,
     513,   514,   515,   516,   517,   518,   519,   520,   521,    -1,
     523,   524,   525,   526,   527,   528,   529,   530,   531,   532,
     533,   534,   535,   536,   537,    -1,    -1,   540,   541,   542,
     543,    -1,   545,   546,   547,    -1,   549,   550,   551,   552,
      -1,    -1,    -1,    -1,    -1,   558,   559,    -1,   561,   562,
     563,   564,   565,   566,   567,   568,   569,   570,   571,   572,
      -1,   574,   575,    -1,    -1,   578,    -1,    -1,   581,    -1,
     583,    -1,   585,   586,    -1,    -1,   589,   590,   591,   592,
     593,    -1,    -1,   596,   597,    -1,   599,   600,   601,   602,
     603,   604,    -1,    -1,    -1,    -1,    -1,    -1,   611,   612,
      -1,   614,   615,   616,    -1,    -1,   619,    -1,    -1,    -1,
     623,   624,    -1,    -1,    -1,    -1,   629,   630,    -1,    -1,
     633,   634,    -1,    -1,   637,   638,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    14,    -1,    -1,    -1,    18,
      -1,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    33,    34,    35,    36,    37,    38,
      39,    -1,    41,    42,    43,    -1,    45,    -1,    47,    48,
      -1,    -1,    51,    52,    53,    54,    55,    -1,    57,    58,
      59,    60,    -1,    62,    63,    64,    65,    66,    67,    -1,
      69,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    -1,    82,    83,    -1,    85,    86,    87,    88,
      89,    -1,    91,    92,    93,    -1,    -1,    96,    97,    98,
      99,    -1,   101,   102,   103,    -1,   105,   106,   107,   108,
     109,   110,    -1,    -1,    -1,    -1,   115,   116,   117,    -1,
      -1,   120,   121,   122,    -1,   124,    -1,    -1,    -1,   128,
      -1,   130,   131,   132,   133,   134,    -1,    -1,    -1,   138,
      -1,    -1,   141,   142,   143,    -1,    -1,    -1,   147,    -1,
     149,   150,    -1,   152,   153,   154,    -1,    -1,   157,   158,
      -1,   160,   161,   162,   163,   164,   165,   166,    -1,   168,
     169,   170,   171,   172,   173,   174,   175,   176,    -1,   178,
     179,   180,   181,    -1,   183,    -1,    -1,    -1,   187,   188,
     189,   190,    -1,   192,    -1,   194,   195,   196,   197,    -1,
     199,    -1,   201,    -1,   203,    -1,   205,   206,    -1,   208,
     209,    -1,   211,   212,    -1,    -1,    -1,   216,   217,   218,
     219,   220,    -1,   222,   223,   224,    -1,    -1,   227,    -1,
      -1,    -1,   231,   232,   233,   234,    -1,    -1,   237,    -1,
      -1,    -1,   241,   242,    -1,   244,   245,    -1,    -1,    -1,
     249,    -1,    -1,   252,   253,    -1,    -1,   256,    -1,   258,
     259,   260,    -1,    -1,    -1,    -1,    -1,   266,   267,    -1,
     269,    -1,   271,    -1,   273,   274,    -1,    -1,   277,    -1,
      -1,    -1,    -1,   282,    -1,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,   300,    -1,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,    -1,    -1,    -1,    -1,   317,   318,
     319,   320,   321,   322,    -1,    -1,   325,   326,   327,   328,
      -1,   330,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,    -1,   342,   343,   344,    -1,    -1,   347,   348,
     349,   350,   351,   352,   353,   354,   355,    -1,   357,   358,
     359,    -1,   361,   362,   363,    -1,   365,   366,   367,    -1,
     369,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     379,   380,   381,   382,   383,   384,    -1,   386,   387,   388,
     389,   390,   391,   392,   393,   394,   395,   396,    -1,   398,
     399,   400,    -1,   402,    -1,   404,   405,   406,   407,   408,
      -1,   410,   411,   412,    -1,    -1,   415,    -1,    -1,    -1,
     419,   420,   421,   422,   423,    -1,    -1,   426,   427,   428,
     429,   430,    -1,   432,   433,    -1,   435,   436,   437,   438,
     439,   440,    -1,   442,    -1,   444,   445,    -1,   447,   448,
     449,    -1,   451,    -1,   453,   454,   455,   456,   457,   458,
     459,   460,   461,   462,   463,   464,    -1,   466,   467,    -1,
      -1,    -1,   471,   472,   473,   474,    -1,    -1,    -1,   478,
      -1,    -1,    -1,   482,    -1,   484,   485,   486,   487,    -1,
     489,   490,   491,   492,   493,    -1,    -1,    -1,    -1,    -1,
     499,   500,   501,    -1,   503,   504,    -1,   506,    -1,    -1,
     509,    -1,    -1,   512,   513,   514,   515,   516,   517,   518,
     519,   520,   521,    -1,   523,   524,   525,   526,   527,   528,
     529,   530,   531,   532,   533,   534,   535,   536,   537,    -1,
      -1,   540,   541,   542,   543,    -1,   545,   546,   547,    -1,
     549,   550,   551,   552,    -1,    -1,    -1,    -1,    -1,   558,
     559,    -1,   561,   562,   563,   564,   565,   566,   567,   568,
     569,   570,   571,   572,    -1,   574,   575,    -1,    -1,   578,
      -1,    -1,   581,    -1,   583,    -1,   585,   586,    -1,    -1,
     589,   590,   591,   592,   593,    -1,    -1,   596,   597,    -1,
     599,   600,   601,   602,   603,   604,    -1,    -1,    -1,    -1,
      -1,    -1,   611,   612,    -1,   614,   615,   616,    -1,    -1,
     619,    -1,    -1,    -1,   623,   624,    -1,    -1,    -1,    -1,
     629,   630,    -1,    -1,   633,   634,    -1,    -1,   637,   638,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    14,
      -1,    -1,    -1,    18,    -1,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    -1,    -1,    33,    34,
      35,    36,    37,    38,    39,    -1,    41,    42,    43,    -1,
      45,    -1,    47,    48,    -1,    -1,    51,    52,    53,    54,
      55,    -1,    57,    58,    59,    60,    -1,    62,    63,    64,
      65,    66,    67,    -1,    69,    70,    -1,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    -1,    82,    83,    -1,
      85,    86,    87,    88,    89,    -1,    91,    92,    93,    -1,
      -1,    96,    97,    98,    99,    -1,   101,   102,   103,    -1,
     105,   106,   107,   108,   109,   110,    -1,    -1,    -1,    -1,
     115,   116,   117,    -1,    -1,   120,   121,   122,    -1,   124,
      -1,    -1,    -1,   128,    -1,   130,   131,   132,   133,   134,
      -1,    -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,
      -1,    -1,   147,    -1,   149,   150,    -1,   152,   153,   154,
      -1,    -1,   157,   158,    -1,   160,   161,   162,   163,   164,
     165,   166,    -1,   168,   169,   170,   171,   172,   173,   174,
     175,   176,    -1,   178,   179,   180,   181,    -1,   183,    -1,
      -1,    -1,   187,   188,   189,   190,    -1,   192,    -1,   194,
     195,   196,   197,    -1,   199,    -1,   201,    -1,   203,    -1,
     205,   206,    -1,   208,   209,    -1,   211,   212,    -1,    -1,
      -1,   216,   217,   218,   219,   220,    -1,   222,   223,   224,
      -1,    -1,   227,    -1,    -1,    -1,   231,   232,   233,   234,
      -1,    -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,
     245,    -1,    -1,    -1,   249,    -1,    -1,   252,   253,    -1,
      -1,   256,    -1,   258,   259,   260,    -1,    -1,    -1,    -1,
      -1,   266,   267,    -1,   269,    -1,   271,    -1,   273,   274,
      -1,    -1,   277,    -1,    -1,    -1,    -1,   282,    -1,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,    -1,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,    -1,    -1,
      -1,    -1,   317,   318,   319,   320,   321,   322,    -1,    -1,
     325,   326,   327,   328,    -1,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,    -1,   342,   343,   344,
      -1,    -1,   347,   348,   349,   350,   351,   352,   353,   354,
     355,    -1,   357,   358,   359,    -1,   361,   362,   363,    -1,
     365,   366,   367,    -1,   369,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   379,   380,   381,   382,   383,   384,
      -1,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,    -1,   398,   399,   400,    -1,   402,    -1,   404,
     405,   406,   407,   408,    -1,   410,   411,   412,    -1,    -1,
     415,    -1,    -1,    -1,   419,   420,   421,   422,   423,    -1,
      -1,   426,   427,   428,   429,   430,    -1,   432,   433,    -1,
     435,   436,   437,   438,   439,   440,    -1,   442,    -1,   444,
     445,    -1,   447,   448,   449,    -1,   451,    -1,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
      -1,   466,   467,    -1,    -1,    -1,   471,   472,   473,   474,
      -1,    -1,    -1,   478,    -1,    -1,    -1,   482,    -1,   484,
     485,   486,   487,    -1,   489,   490,   491,   492,   493,    -1,
      -1,    -1,    -1,    -1,   499,   500,   501,    -1,   503,   504,
      -1,   506,    -1,    -1,   509,    -1,    -1,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,    -1,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,    -1,    -1,   540,   541,   542,   543,    -1,
     545,   546,   547,    -1,   549,   550,   551,   552,    -1,    -1,
      -1,    -1,    -1,   558,   559,    -1,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,    -1,   574,
     575,    -1,    -1,   578,    -1,    -1,   581,    -1,   583,    -1,
     585,   586,    -1,    -1,   589,   590,   591,   592,   593,    -1,
      -1,   596,   597,    -1,   599,   600,   601,   602,   603,   604,
      -1,    -1,    -1,    -1,    -1,    -1,   611,   612,    -1,   614,
     615,   616,    -1,    -1,   619,    -1,    -1,    -1,   623,   624,
      -1,    -1,    -1,    -1,   629,   630,    -1,    -1,   633,   634,
      -1,    -1,   637,   638,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    14,    -1,    -1,    -1,    18,    -1,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      -1,    -1,    33,    34,    35,    36,    37,    38,    39,    -1,
      41,    42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,
      51,    52,    53,    54,    55,    -1,    57,    58,    59,    60,
      -1,    62,    63,    64,    65,    66,    67,    -1,    69,    70,
      -1,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    -1,    85,    86,    87,    88,    89,    -1,
      91,    92,    93,    -1,    -1,    96,    97,    98,    99,    -1,
     101,   102,   103,    -1,   105,   106,   107,   108,   109,   110,
      -1,    -1,    -1,    -1,   115,   116,   117,    -1,    -1,   120,
     121,   122,    -1,   124,    -1,    -1,    -1,   128,    -1,   130,
     131,   132,   133,   134,    -1,    -1,    -1,   138,    -1,    -1,
     141,   142,   143,    -1,    -1,    -1,   147,    -1,   149,   150,
      -1,   152,   153,   154,    -1,    -1,   157,   158,    -1,   160,
     161,   162,   163,   164,   165,   166,    -1,   168,   169,   170,
     171,   172,   173,   174,   175,   176,    -1,   178,   179,   180,
     181,    -1,   183,    -1,    -1,    -1,   187,   188,   189,   190,
      -1,   192,    -1,   194,   195,   196,   197,    -1,   199,    -1,
     201,    -1,   203,    -1,   205,   206,    -1,   208,   209,    -1,
     211,   212,    -1,    -1,    -1,   216,   217,   218,   219,   220,
      -1,   222,   223,   224,    -1,    -1,   227,    -1,    -1,    -1,
     231,   232,   233,   234,    -1,    -1,   237,    -1,    -1,    -1,
     241,   242,    -1,   244,   245,    -1,    -1,    -1,   249,    -1,
      -1,   252,   253,    -1,    -1,   256,    -1,   258,   259,   260,
      -1,    -1,    -1,    -1,    -1,   266,   267,    -1,   269,    -1,
     271,    -1,   273,   274,    -1,    -1,   277,    -1,    -1,    -1,
      -1,   282,    -1,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
      -1,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,    -1,    -1,    -1,    -1,   317,   318,   319,   320,
     321,   322,    -1,    -1,   325,   326,   327,   328,    -1,   330,
     331,   332,   333,   334,   335,   336,   337,   338,   339,   340,
      -1,   342,   343,   344,    -1,    -1,   347,   348,   349,   350,
     351,   352,   353,   354,   355,    -1,   357,   358,   359,    -1,
     361,   362,   363,    -1,   365,   366,   367,    -1,   369,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,   380,
     381,   382,   383,   384,    -1,   386,   387,   388,   389,   390,
     391,   392,   393,   394,   395,   396,    -1,   398,   399,   400,
      -1,   402,    -1,   404,   405,   406,   407,   408,    -1,   410,
     411,   412,    -1,    -1,   415,    -1,    -1,    -1,   419,   420,
     421,   422,   423,    -1,    -1,   426,   427,   428,   429,   430,
      -1,   432,   433,    -1,   435,   436,   437,   438,   439,   440,
      -1,   442,    -1,   444,   445,    -1,   447,   448,   449,    -1,
     451,    -1,   453,   454,   455,   456,   457,   458,   459,   460,
     461,   462,   463,   464,    -1,   466,   467,    -1,    -1,    -1,
     471,   472,   473,   474,    -1,    -1,    -1,   478,    -1,    -1,
      -1,   482,    -1,   484,   485,   486,   487,    -1,   489,   490,
     491,   492,   493,    -1,    -1,    -1,    -1,    -1,   499,   500,
     501,    -1,   503,   504,    -1,   506,    -1,    -1,   509,    -1,
      -1,   512,   513,   514,   515,   516,   517,   518,   519,   520,
     521,    -1,   523,   524,   525,   526,   527,   528,   529,   530,
     531,   532,   533,   534,   535,   536,   537,    -1,    -1,   540,
     541,   542,   543,    -1,   545,   546,   547,    -1,   549,   550,
     551,   552,    -1,    -1,    -1,    -1,    -1,   558,   559,    -1,
     561,   562,   563,   564,   565,   566,   567,   568,   569,   570,
     571,   572,    -1,   574,   575,    -1,    -1,   578,    -1,    -1,
     581,    -1,   583,    -1,   585,   586,    -1,    -1,   589,   590,
     591,   592,   593,    -1,    -1,   596,   597,    -1,   599,   600,
     601,   602,   603,   604,    -1,    -1,    -1,    -1,    -1,    -1,
     611,   612,    -1,   614,   615,   616,    -1,    -1,   619,    -1,
      -1,    -1,   623,   624,    -1,    -1,    -1,    -1,   629,   630,
      -1,    -1,   633,   634,    -1,    -1,   637,   638,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    14,    -1,    -1,
      -1,    18,    -1,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    -1,    30,    -1,    -1,    33,    34,    35,    36,
      37,    38,    39,    -1,    41,    42,    43,    -1,    45,    -1,
      47,    48,    -1,    -1,    51,    52,    53,    54,    55,    -1,
      57,    58,    59,    60,    -1,    62,    63,    64,    65,    66,
      67,    -1,    69,    70,    -1,    72,    73,    74,    75,    76,
      77,    78,    79,    80,    -1,    82,    83,    -1,    85,    86,
      87,    88,    89,    -1,    91,    92,    93,    -1,    -1,    96,
      97,    98,    99,    -1,   101,   102,   103,    -1,   105,   106,
     107,   108,   109,   110,    -1,    -1,    -1,    -1,   115,   116,
     117,    -1,    -1,   120,   121,   122,    -1,   124,    -1,    -1,
      -1,   128,    -1,   130,   131,   132,   133,   134,    -1,    -1,
      -1,   138,    -1,    -1,   141,   142,   143,    -1,    -1,    -1,
     147,    -1,   149,   150,    -1,   152,   153,   154,    -1,    -1,
     157,   158,    -1,   160,   161,   162,   163,   164,   165,   166,
      -1,   168,   169,   170,   171,   172,   173,   174,   175,   176,
      -1,   178,   179,   180,   181,    -1,   183,    -1,    -1,    -1,
     187,   188,    -1,   190,    -1,   192,    -1,   194,   195,   196,
     197,    -1,   199,    -1,   201,    -1,   203,    -1,   205,   206,
      -1,   208,   209,    -1,   211,   212,    -1,    -1,    -1,   216,
     217,   218,   219,   220,    -1,   222,   223,   224,    -1,    -1,
     227,    -1,    -1,    -1,   231,   232,   233,   234,    -1,    -1,
     237,    -1,    -1,    -1,   241,   242,    -1,   244,   245,    -1,
      -1,    -1,   249,    -1,    -1,   252,   253,    -1,    -1,   256,
      -1,   258,   259,   260,    -1,    -1,    -1,    -1,    -1,   266,
     267,    -1,   269,    -1,   271,    -1,   273,   274,    -1,    -1,
     277,    -1,    -1,    -1,    -1,   282,    -1,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,    -1,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,    -1,    -1,    -1,    -1,
     317,   318,   319,   320,   321,   322,    -1,    -1,   325,   326,
     327,   328,    -1,   330,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,    -1,   342,   343,   344,    -1,    -1,
     347,   348,   349,   350,   351,   352,   353,   354,   355,    -1,
     357,   358,   359,    -1,   361,   362,   363,    -1,   365,   366,
     367,    -1,   369,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   379,   380,   381,   382,   383,   384,    -1,   386,
     387,   388,   389,   390,   391,   392,   393,   394,   395,   396,
      -1,   398,   399,   400,    -1,   402,    -1,   404,   405,   406,
     407,   408,    -1,   410,   411,   412,    -1,    -1,   415,    -1,
      -1,    -1,   419,   420,   421,   422,   423,    -1,    -1,   426,
     427,   428,   429,   430,    -1,   432,   433,    -1,   435,   436,
     437,   438,   439,   440,    -1,   442,    -1,   444,   445,    -1,
     447,   448,   449,    -1,   451,    -1,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   462,   463,   464,    -1,   466,
     467,    -1,    -1,    -1,   471,   472,   473,   474,    -1,    -1,
      -1,   478,    -1,    -1,    -1,   482,    -1,   484,   485,   486,
     487,    -1,   489,   490,   491,   492,   493,    -1,    -1,    -1,
      -1,    -1,   499,   500,   501,    -1,   503,   504,    -1,   506,
      -1,    -1,   509,    -1,    -1,   512,   513,   514,   515,   516,
     517,   518,   519,   520,   521,    -1,   523,   524,   525,   526,
     527,   528,   529,   530,   531,   532,   533,   534,   535,   536,
     537,    -1,    -1,   540,   541,   542,   543,    -1,   545,   546,
     547,    -1,   549,   550,   551,   552,    -1,    -1,    -1,    -1,
      -1,   558,   559,    -1,   561,   562,   563,   564,   565,   566,
     567,   568,   569,   570,   571,   572,    -1,   574,   575,    -1,
      -1,   578,    -1,    -1,   581,    -1,   583,    -1,   585,   586,
      -1,    -1,   589,   590,   591,   592,   593,    -1,    -1,   596,
     597,    -1,   599,   600,   601,   602,   603,   604,    -1,    -1,
      -1,    -1,    -1,    -1,   611,   612,    -1,   614,   615,   616,
      -1,    -1,   619,    -1,    -1,    -1,   623,   624,    -1,    -1,
      -1,    -1,   629,   630,    -1,    -1,   633,   634,    -1,    -1,
     637,   638,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    14,    -1,    -1,    -1,    18,    -1,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    -1,    30,    -1,    -1,
      33,    34,    35,    36,    37,    38,    39,    -1,    41,    42,
      43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,    52,
      53,    54,    55,    -1,    57,    58,    59,    60,    -1,    62,
      63,    64,    65,    66,    67,    -1,    69,    70,    -1,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    -1,    82,
      83,    -1,    85,    86,    87,    88,    89,    -1,    91,    92,
      93,    -1,    -1,    96,    97,    98,    99,    -1,   101,   102,
     103,    -1,   105,   106,   107,   108,   109,   110,    -1,    -1,
      -1,    -1,   115,   116,   117,    -1,    -1,   120,   121,   122,
      -1,   124,    -1,    -1,    -1,   128,    -1,   130,   131,   132,
     133,   134,    -1,    -1,    -1,   138,    -1,    -1,   141,   142,
     143,    -1,    -1,    -1,   147,    -1,   149,   150,    -1,   152,
     153,   154,    -1,    -1,   157,   158,    -1,   160,   161,   162,
     163,   164,   165,   166,    -1,   168,   169,   170,   171,   172,
     173,   174,   175,   176,    -1,   178,   179,   180,   181,    -1,
     183,    -1,    -1,    -1,   187,   188,    -1,   190,    -1,   192,
      -1,   194,   195,   196,   197,    -1,   199,    -1,   201,    -1,
     203,    -1,   205,   206,    -1,   208,   209,    -1,   211,   212,
      -1,    -1,    -1,   216,   217,   218,   219,   220,    -1,   222,
     223,   224,    -1,    -1,   227,    -1,    -1,    -1,   231,   232,
     233,   234,    -1,    -1,   237,    -1,    -1,    -1,   241,   242,
      -1,   244,   245,    -1,    -1,    -1,   249,    -1,    -1,   252,
     253,    -1,    -1,   256,    -1,   258,   259,   260,    -1,    -1,
      -1,    -1,    -1,   266,   267,    -1,   269,    -1,   271,    -1,
     273,   274,    -1,    -1,   277,    -1,    -1,    -1,    -1,   282,
      -1,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,   300,    -1,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
      -1,    -1,    -1,    -1,   317,   318,   319,   320,   321,   322,
      -1,    -1,   325,   326,   327,   328,    -1,   330,   331,   332,
     333,   334,   335,   336,   337,   338,   339,   340,    -1,   342,
     343,   344,    -1,    -1,   347,   348,   349,   350,   351,   352,
     353,   354,   355,    -1,   357,   358,   359,    -1,   361,   362,
     363,    -1,   365,   366,   367,    -1,   369,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   379,   380,   381,   382,
     383,   384,    -1,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,    -1,   398,   399,   400,    -1,   402,
      -1,   404,   405,   406,   407,   408,    -1,   410,   411,   412,
      -1,    -1,   415,    -1,    -1,    -1,   419,   420,   421,   422,
     423,    -1,    -1,   426,   427,   428,   429,   430,    -1,   432,
     433,    -1,   435,   436,   437,   438,   439,   440,    -1,   442,
      -1,   444,   445,    -1,   447,   448,   449,    -1,   451,    -1,
     453,   454,   455,   456,   457,   458,   459,   460,   461,   462,
     463,   464,    -1,   466,   467,    -1,    -1,    -1,   471,   472,
     473,   474,    -1,    -1,    -1,   478,    -1,    -1,    -1,   482,
      -1,   484,   485,   486,   487,    -1,   489,   490,   491,   492,
     493,    -1,    -1,    -1,    -1,    -1,   499,   500,   501,    -1,
     503,   504,    -1,   506,    -1,    -1,   509,    -1,    -1,   512,
     513,   514,   515,   516,   517,   518,   519,   520,   521,    -1,
     523,   524,   525,   526,   527,   528,   529,   530,   531,   532,
     533,   534,   535,   536,   537,    -1,    -1,   540,   541,   542,
     543,    -1,   545,   546,   547,    -1,   549,   550,   551,   552,
      -1,    -1,    -1,    -1,    -1,   558,   559,    -1,   561,   562,
     563,   564,   565,   566,   567,   568,   569,   570,   571,   572,
      -1,   574,   575,    -1,    -1,   578,    -1,    -1,   581,    -1,
     583,    -1,   585,   586,    -1,    -1,   589,   590,   591,   592,
     593,    -1,    -1,   596,   597,    -1,   599,   600,   601,   602,
     603,   604,    -1,    -1,    -1,    -1,    -1,    -1,   611,   612,
      -1,   614,   615,   616,    -1,    -1,   619,    -1,    -1,    -1,
     623,   624,    -1,    -1,    -1,    -1,   629,   630,    -1,    -1,
     633,   634,    -1,    -1,   637,   638,     5,    -1,     7,     8,
       9,    10,    11,    12,    -1,    14,    -1,    -1,    -1,    18,
      -1,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    33,    34,    35,    36,    37,    38,
      39,    -1,    41,    42,    43,    -1,    45,    -1,    47,    48,
      -1,    -1,    51,    52,    53,    54,    55,    -1,    57,    58,
      59,    60,    -1,    62,    63,    64,    65,    66,    67,    -1,
      69,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    -1,    82,    83,    -1,    85,    86,    87,    88,
      89,    -1,    91,    92,    93,    -1,    -1,    96,    97,    98,
      99,    -1,   101,   102,   103,    -1,   105,   106,   107,   108,
     109,   110,    -1,    -1,    -1,    -1,   115,   116,   117,    -1,
      -1,   120,   121,   122,    -1,   124,    -1,    -1,    -1,   128,
      -1,   130,   131,   132,   133,   134,    -1,    -1,    -1,   138,
      -1,    -1,   141,   142,   143,    -1,    -1,    -1,   147,    -1,
     149,   150,    -1,   152,   153,   154,    -1,    -1,   157,   158,
      -1,   160,   161,   162,   163,   164,   165,   166,    -1,   168,
     169,   170,   171,   172,   173,   174,   175,   176,    -1,   178,
     179,   180,   181,    -1,   183,    -1,    -1,    -1,   187,   188,
      -1,   190,    -1,   192,    -1,   194,   195,   196,   197,    -1,
     199,    -1,   201,    -1,   203,    -1,   205,   206,    -1,   208,
     209,    -1,   211,   212,    -1,    -1,    -1,   216,   217,   218,
     219,   220,    -1,   222,   223,   224,    -1,    -1,   227,    -1,
      -1,    -1,   231,   232,   233,   234,    -1,    -1,   237,    -1,
      -1,    -1,   241,   242,    -1,   244,   245,    -1,    -1,    -1,
     249,    -1,    -1,   252,   253,    -1,    -1,   256,    -1,   258,
     259,   260,    -1,    -1,    -1,    -1,    -1,   266,   267,    -1,
     269,    -1,   271,    -1,   273,   274,    -1,    -1,   277,    -1,
      -1,    -1,    -1,   282,    -1,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,   300,    -1,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,    -1,    -1,    -1,    -1,   317,   318,
     319,   320,   321,   322,    -1,    -1,   325,   326,   327,   328,
      -1,   330,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,    -1,   342,   343,   344,    -1,    -1,   347,   348,
     349,   350,   351,    -1,   353,   354,   355,    -1,   357,   358,
     359,    -1,   361,   362,   363,    -1,   365,   366,   367,    -1,
     369,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     379,   380,   381,   382,   383,   384,    -1,   386,   387,   388,
     389,   390,   391,   392,   393,   394,   395,   396,    -1,   398,
     399,   400,    -1,   402,    -1,   404,   405,   406,   407,   408,
      -1,   410,   411,   412,    -1,    -1,   415,    -1,    -1,    -1,
     419,   420,   421,   422,   423,    -1,    -1,   426,   427,   428,
     429,   430,    -1,   432,   433,    -1,   435,   436,   437,   438,
     439,   440,    -1,   442,    -1,   444,   445,    -1,   447,   448,
     449,    -1,   451,    -1,   453,   454,   455,   456,   457,   458,
     459,   460,   461,   462,   463,   464,    -1,   466,   467,    -1,
      -1,    -1,   471,   472,   473,   474,    -1,    -1,    -1,   478,
      -1,    -1,    -1,   482,    -1,   484,   485,   486,   487,    -1,
     489,   490,   491,   492,   493,    -1,    -1,    -1,    -1,    -1,
     499,   500,   501,    -1,   503,   504,    -1,   506,    -1,    -1,
     509,    -1,    -1,   512,   513,   514,   515,   516,   517,   518,
     519,   520,   521,    -1,   523,   524,   525,   526,   527,   528,
     529,   530,   531,   532,   533,   534,   535,   536,   537,    -1,
      -1,   540,   541,   542,   543,    -1,   545,   546,   547,    -1,
     549,   550,   551,   552,    -1,    -1,    -1,    -1,    -1,   558,
     559,    -1,   561,   562,   563,   564,   565,   566,   567,   568,
     569,   570,   571,   572,    -1,   574,   575,    -1,    -1,   578,
      -1,    -1,   581,    -1,   583,    -1,   585,   586,    -1,    -1,
     589,   590,   591,   592,   593,    -1,    -1,   596,   597,    -1,
     599,   600,   601,   602,   603,   604,    -1,    -1,    -1,    -1,
      -1,    -1,   611,   612,    -1,   614,   615,   616,    -1,    -1,
     619,    -1,    -1,    -1,   623,   624,    -1,    -1,    -1,    -1,
     629,   630,    -1,    -1,   633,   634,    -1,    -1,   637,   638,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    14,
      -1,    -1,    -1,    18,    -1,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    -1,    -1,    33,    34,
      35,    36,    37,    38,    39,    -1,    41,    42,    43,    -1,
      45,    -1,    47,    48,    -1,    -1,    51,    52,    53,    54,
      55,    -1,    57,    58,    59,    60,    -1,    62,    63,    64,
      65,    66,    67,    -1,    69,    70,    -1,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    -1,    82,    83,    -1,
      85,    86,    87,    88,    89,    -1,    91,    92,    93,    -1,
      -1,    96,    97,    98,    99,    -1,   101,   102,   103,    -1,
     105,   106,   107,   108,   109,   110,    -1,    -1,    -1,    -1,
     115,   116,   117,    -1,    -1,   120,   121,   122,    -1,   124,
      -1,    -1,    -1,   128,    -1,   130,   131,   132,   133,   134,
      -1,    -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,
      -1,    -1,   147,    -1,   149,   150,    -1,   152,   153,   154,
      -1,    -1,   157,   158,    -1,   160,   161,   162,   163,   164,
     165,   166,    -1,   168,   169,   170,   171,   172,   173,   174,
     175,   176,    -1,   178,   179,   180,   181,    -1,   183,    -1,
      -1,    -1,   187,   188,    -1,   190,    -1,   192,    -1,   194,
     195,   196,   197,    -1,   199,    -1,   201,    -1,   203,    -1,
     205,   206,    -1,   208,   209,    -1,   211,   212,    -1,    -1,
      -1,   216,   217,   218,   219,   220,    -1,   222,   223,   224,
      -1,    -1,   227,    -1,    -1,    -1,   231,   232,   233,   234,
      -1,    -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,
     245,    -1,    -1,    -1,   249,    -1,    -1,   252,   253,    -1,
      -1,   256,    -1,   258,   259,   260,    -1,    -1,    -1,    -1,
      -1,   266,   267,    -1,   269,    -1,   271,    -1,   273,   274,
      -1,    -1,   277,    -1,    -1,    -1,    -1,   282,    -1,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,    -1,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,    -1,    -1,
      -1,    -1,   317,   318,   319,   320,   321,   322,    -1,    -1,
     325,   326,   327,   328,    -1,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,    -1,   342,   343,   344,
      -1,    -1,   347,   348,   349,   350,   351,   352,   353,   354,
     355,    -1,   357,   358,   359,    -1,   361,   362,   363,    -1,
     365,   366,   367,    -1,   369,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   379,   380,   381,   382,   383,   384,
      -1,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,    -1,   398,   399,   400,    -1,   402,    -1,   404,
     405,   406,   407,   408,    -1,   410,   411,   412,    -1,    -1,
     415,    -1,    -1,    -1,   419,   420,   421,   422,   423,    -1,
      -1,   426,   427,   428,   429,   430,    -1,   432,   433,    -1,
     435,   436,   437,   438,   439,   440,    -1,   442,    -1,   444,
     445,    -1,   447,   448,   449,    -1,   451,    -1,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
      -1,   466,   467,    -1,    -1,    -1,   471,   472,   473,   474,
      -1,    -1,    -1,   478,    -1,    -1,    -1,   482,    -1,   484,
     485,   486,   487,    -1,   489,   490,   491,   492,   493,    -1,
      -1,    -1,    -1,    -1,   499,   500,   501,    -1,   503,   504,
      -1,   506,    -1,    -1,   509,    -1,    -1,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,    -1,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,    -1,    -1,   540,   541,   542,   543,    -1,
     545,   546,   547,    -1,   549,   550,   551,   552,    -1,    -1,
      -1,    -1,    -1,   558,   559,    -1,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,    -1,   574,
     575,    -1,    -1,   578,    -1,    -1,   581,    -1,   583,    -1,
     585,   586,    -1,    -1,   589,   590,   591,   592,   593,    -1,
      -1,   596,   597,    -1,   599,   600,   601,   602,   603,   604,
      -1,    -1,    -1,    -1,    -1,    -1,   611,   612,    -1,   614,
     615,   616,    -1,    -1,   619,    -1,    -1,    -1,   623,   624,
      -1,    -1,    -1,    -1,   629,   630,    -1,    -1,   633,   634,
      -1,    -1,   637,   638,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    14,    -1,    -1,    -1,    18,    -1,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      -1,    -1,    33,    34,    35,    36,    37,    38,    39,    -1,
      41,    42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,
      51,    52,    53,    54,    55,    -1,    57,    58,    59,    60,
      -1,    62,    63,    64,    65,    66,    67,    -1,    69,    70,
      -1,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    -1,    85,    86,    87,    88,    89,    -1,
      91,    92,    93,    -1,    -1,    96,    97,    98,    99,    -1,
     101,   102,   103,    -1,   105,   106,   107,   108,   109,   110,
      -1,    -1,    -1,    -1,   115,   116,   117,    -1,    -1,   120,
     121,   122,    -1,   124,    -1,    -1,    -1,   128,    -1,   130,
     131,   132,   133,   134,    -1,    -1,    -1,   138,    -1,    -1,
     141,   142,   143,    -1,    -1,    -1,   147,    -1,   149,   150,
      -1,   152,   153,   154,    -1,    -1,   157,   158,    -1,   160,
     161,   162,   163,   164,   165,   166,    -1,   168,   169,   170,
     171,   172,   173,   174,   175,   176,    -1,   178,   179,   180,
     181,    -1,   183,    -1,    -1,    -1,   187,   188,    -1,   190,
      -1,   192,    -1,   194,   195,   196,   197,    -1,   199,    -1,
     201,    -1,   203,    -1,   205,   206,    -1,   208,   209,    -1,
     211,   212,    -1,    -1,    -1,   216,   217,   218,   219,   220,
      -1,   222,   223,   224,    -1,    -1,   227,    -1,    -1,    -1,
     231,   232,   233,   234,    -1,    -1,   237,    -1,    -1,    -1,
     241,   242,    -1,   244,   245,    -1,    -1,    -1,   249,    -1,
      -1,   252,   253,    -1,    -1,   256,    -1,   258,   259,   260,
      -1,    -1,    -1,    -1,    -1,   266,   267,    -1,   269,    -1,
     271,    -1,   273,   274,    -1,    -1,   277,    -1,    -1,    -1,
      -1,   282,    -1,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
      -1,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,    -1,    -1,    -1,    -1,   317,   318,   319,   320,
     321,   322,    -1,    -1,   325,   326,   327,   328,    -1,   330,
     331,   332,   333,   334,   335,   336,   337,   338,   339,   340,
      -1,   342,   343,   344,    -1,    -1,   347,   348,   349,   350,
     351,   352,   353,   354,   355,    -1,   357,   358,   359,    -1,
     361,   362,   363,    -1,   365,   366,   367,    -1,   369,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,   380,
     381,   382,   383,   384,    -1,   386,   387,   388,   389,   390,
     391,   392,   393,   394,   395,   396,    -1,   398,   399,   400,
      -1,   402,    -1,   404,   405,   406,   407,   408,    -1,   410,
     411,   412,    -1,    -1,   415,    -1,    -1,    -1,   419,   420,
     421,   422,   423,    -1,    -1,   426,   427,   428,   429,   430,
      -1,   432,   433,    -1,   435,   436,   437,   438,   439,   440,
      -1,   442,    -1,   444,   445,    -1,   447,   448,   449,    -1,
     451,    -1,   453,   454,   455,   456,   457,   458,   459,   460,
     461,   462,   463,   464,    -1,   466,   467,    -1,    -1,    -1,
     471,   472,   473,   474,    -1,    -1,    -1,   478,    -1,    -1,
      -1,   482,    -1,   484,   485,   486,   487,    -1,   489,   490,
     491,   492,   493,    -1,    -1,    -1,    -1,    -1,   499,   500,
     501,    -1,   503,   504,    -1,   506,    -1,    -1,   509,    -1,
      -1,   512,   513,   514,   515,   516,   517,   518,   519,   520,
     521,    -1,   523,   524,   525,   526,   527,   528,   529,   530,
     531,   532,   533,   534,   535,   536,   537,    -1,    -1,   540,
     541,   542,   543,    -1,   545,   546,   547,    -1,   549,   550,
     551,   552,    -1,    -1,    -1,    -1,    -1,   558,   559,    -1,
     561,   562,   563,   564,   565,   566,   567,   568,   569,   570,
     571,   572,    -1,   574,   575,    -1,    -1,   578,    -1,    -1,
     581,    -1,   583,    -1,   585,   586,    -1,    -1,   589,   590,
     591,   592,   593,    -1,    -1,   596,   597,    -1,   599,   600,
     601,   602,   603,   604,    -1,    -1,    -1,    -1,    -1,    -1,
     611,   612,    -1,   614,   615,   616,    -1,    -1,   619,    -1,
      -1,    -1,   623,   624,    -1,    -1,    -1,    -1,   629,   630,
      -1,    -1,   633,   634,    -1,    -1,   637,   638,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    14,    -1,    -1,
      -1,    18,    -1,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    -1,    30,    -1,    -1,    33,    34,    35,    36,
      37,    38,    39,    -1,    41,    42,    43,    -1,    45,    -1,
      47,    48,    -1,    -1,    51,    52,    53,    54,    55,    -1,
      57,    58,    59,    60,    -1,    62,    63,    64,    65,    66,
      67,    -1,    69,    70,    -1,    72,    73,    74,    75,    76,
      77,    78,    79,    80,    -1,    82,    83,    -1,    85,    86,
      87,    88,    89,    -1,    91,    92,    93,    -1,    -1,    96,
      97,    98,    99,    -1,   101,   102,   103,    -1,   105,   106,
     107,   108,   109,   110,    -1,    -1,    -1,    -1,   115,   116,
     117,    -1,    -1,   120,   121,   122,    -1,   124,    -1,    -1,
      -1,   128,    -1,   130,   131,   132,   133,   134,    -1,    -1,
      -1,   138,    -1,    -1,   141,   142,   143,    -1,    -1,    -1,
     147,    -1,   149,   150,    -1,   152,   153,   154,    -1,    -1,
     157,   158,    -1,   160,   161,   162,   163,   164,   165,   166,
      -1,   168,   169,   170,   171,   172,   173,   174,   175,   176,
      -1,   178,   179,   180,   181,    -1,   183,    -1,    -1,    -1,
     187,   188,    -1,   190,    -1,   192,    -1,   194,   195,   196,
     197,    -1,   199,    -1,   201,    -1,   203,    -1,   205,   206,
      -1,   208,   209,    -1,   211,   212,    -1,    -1,    -1,   216,
     217,   218,   219,   220,    -1,   222,   223,   224,    -1,    -1,
     227,    -1,    -1,    -1,   231,   232,   233,   234,    -1,    -1,
     237,    -1,    -1,    -1,   241,   242,    -1,   244,   245,    -1,
      -1,    -1,   249,    -1,    -1,   252,   253,    -1,    -1,   256,
      -1,   258,   259,   260,    -1,    -1,    -1,    -1,    -1,   266,
     267,    -1,   269,    -1,   271,    -1,   273,   274,    -1,    -1,
     277,    -1,    -1,    -1,    -1,   282,    -1,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,    -1,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,    -1,    -1,    -1,    -1,
     317,   318,   319,   320,   321,   322,    -1,    -1,   325,   326,
     327,   328,    -1,   330,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,    -1,   342,   343,   344,    -1,    -1,
     347,   348,   349,   350,   351,   352,   353,   354,   355,    -1,
     357,   358,   359,    -1,   361,   362,   363,    -1,   365,   366,
     367,    -1,   369,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   379,   380,   381,   382,   383,   384,    -1,   386,
     387,   388,   389,   390,   391,   392,   393,   394,   395,   396,
      -1,   398,   399,   400,    -1,   402,    -1,   404,   405,   406,
     407,   408,    -1,   410,   411,   412,    -1,    -1,   415,    -1,
      -1,    -1,   419,   420,   421,   422,   423,    -1,    -1,   426,
     427,   428,   429,   430,    -1,   432,   433,    -1,   435,   436,
     437,   438,   439,   440,    -1,   442,    -1,   444,   445,    -1,
     447,   448,   449,    -1,   451,    -1,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   462,   463,   464,    -1,   466,
     467,    -1,    -1,    -1,   471,   472,   473,   474,    -1,    -1,
      -1,   478,    -1,    -1,    -1,   482,    -1,   484,   485,   486,
     487,    -1,   489,   490,   491,   492,   493,    -1,    -1,    -1,
      -1,    -1,   499,   500,   501,    -1,   503,   504,    -1,   506,
      -1,    -1,   509,    -1,    -1,   512,   513,   514,   515,   516,
     517,   518,   519,   520,   521,    -1,   523,   524,   525,   526,
     527,   528,   529,   530,   531,   532,   533,   534,   535,   536,
     537,    -1,    -1,   540,   541,   542,   543,    -1,   545,   546,
     547,    -1,   549,   550,   551,   552,    -1,    -1,    -1,    -1,
      -1,   558,   559,    -1,   561,   562,   563,   564,   565,   566,
     567,   568,   569,   570,   571,   572,    -1,   574,   575,    -1,
      -1,   578,    -1,    -1,   581,    -1,   583,    -1,   585,   586,
      -1,    -1,   589,   590,   591,   592,   593,    -1,    -1,   596,
     597,    -1,   599,   600,   601,   602,   603,   604,    -1,    -1,
      -1,    -1,    -1,    -1,   611,   612,    -1,   614,   615,   616,
      -1,    -1,   619,    -1,    -1,    -1,   623,   624,    -1,    -1,
      -1,    -1,   629,   630,    -1,    -1,   633,   634,    -1,    -1,
     637,   638,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    14,    -1,    -1,    -1,    18,    -1,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    -1,    30,    -1,    -1,
      33,    34,    35,    36,    37,    38,    39,    -1,    41,    42,
      43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,    52,
      53,    54,    55,    -1,    57,    58,    59,    60,    -1,    62,
      63,    64,    65,    66,    67,    -1,    69,    70,    -1,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    -1,    82,
      83,    -1,    85,    86,    87,    88,    89,    -1,    91,    92,
      93,    -1,    -1,    96,    97,    98,    99,    -1,   101,   102,
     103,    -1,   105,   106,   107,   108,   109,   110,    -1,    -1,
      -1,    -1,   115,   116,   117,    -1,    -1,   120,   121,   122,
      -1,   124,    -1,    -1,    -1,   128,    -1,   130,   131,   132,
     133,   134,    -1,    -1,    -1,   138,    -1,    -1,   141,   142,
     143,    -1,    -1,    -1,   147,    -1,   149,   150,    -1,   152,
     153,   154,    -1,    -1,   157,   158,    -1,   160,   161,   162,
     163,   164,   165,   166,    -1,   168,   169,   170,   171,   172,
     173,   174,   175,   176,    -1,   178,   179,   180,   181,    -1,
     183,    -1,    -1,    -1,   187,   188,    -1,   190,    -1,   192,
      -1,   194,   195,   196,   197,    -1,   199,    -1,   201,    -1,
     203,    -1,   205,   206,    -1,   208,   209,    -1,   211,   212,
      -1,    -1,    -1,   216,   217,   218,   219,   220,    -1,   222,
     223,   224,    -1,    -1,   227,    -1,    -1,    -1,   231,   232,
     233,   234,    -1,    -1,   237,    -1,    -1,    -1,   241,   242,
      -1,   244,   245,    -1,    -1,    -1,   249,    -1,    -1,   252,
     253,    -1,    -1,   256,    -1,   258,   259,   260,    -1,    -1,
      -1,    -1,    -1,   266,   267,    -1,   269,    -1,   271,    -1,
     273,   274,    -1,    -1,   277,    -1,    -1,    -1,    -1,   282,
      -1,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,   300,    -1,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,    -1,    -1,    -1,   317,   318,   319,   320,   321,   322,
      -1,    -1,   325,   326,   327,   328,    -1,   330,   331,   332,
     333,   334,   335,   336,   337,   338,   339,   340,    -1,   342,
     343,   344,    -1,    -1,   347,   348,   349,   350,   351,    -1,
     353,   354,   355,    -1,   357,   358,   359,    -1,   361,   362,
     363,    -1,   365,   366,   367,    -1,   369,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   379,   380,   381,   382,
     383,   384,    -1,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,   396,    -1,   398,   399,   400,    -1,   402,
      -1,   404,   405,   406,   407,   408,    -1,   410,   411,   412,
      -1,    -1,   415,    -1,    -1,    -1,   419,   420,   421,   422,
     423,    -1,    -1,   426,   427,   428,   429,   430,    -1,   432,
     433,    -1,   435,   436,   437,   438,   439,   440,    -1,   442,
      -1,   444,   445,    -1,   447,   448,   449,    -1,   451,    -1,
     453,   454,   455,   456,   457,   458,   459,   460,   461,   462,
     463,   464,    -1,   466,   467,    -1,    -1,    -1,   471,   472,
     473,   474,    -1,    -1,    -1,   478,    -1,    -1,    -1,   482,
      -1,   484,   485,   486,   487,    -1,   489,   490,   491,   492,
     493,    -1,    -1,    -1,    -1,    -1,   499,   500,   501,    -1,
     503,   504,    -1,   506,    -1,    -1,   509,    -1,    -1,   512,
     513,   514,   515,   516,   517,   518,   519,   520,   521,    -1,
     523,   524,   525,   526,   527,   528,   529,   530,   531,   532,
     533,   534,   535,   536,   537,    -1,    -1,   540,   541,   542,
     543,    -1,   545,   546,   547,    -1,   549,   550,   551,   552,
      -1,    -1,    -1,    -1,    -1,   558,   559,    -1,   561,   562,
     563,   564,   565,   566,   567,   568,   569,   570,   571,   572,
      -1,   574,   575,    -1,    -1,   578,    -1,    -1,   581,    -1,
     583,    -1,   585,   586,    -1,    -1,   589,   590,   591,   592,
     593,    -1,    -1,   596,   597,    -1,   599,   600,   601,   602,
     603,   604,    -1,    -1,    -1,    -1,    -1,    -1,   611,   612,
      -1,   614,   615,   616,    -1,    -1,   619,    -1,    -1,    -1,
     623,   624,    -1,    -1,    -1,    -1,   629,   630,    -1,    -1,
     633,   634,    -1,    -1,   637,   638,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    14,    -1,    -1,    -1,    18,
      -1,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    33,    34,    35,    36,    37,    38,
      39,    -1,    41,    42,    43,    -1,    45,    -1,    47,    48,
      -1,    -1,    51,    52,    53,    54,    55,    -1,    57,    58,
      59,    60,    -1,    62,    63,    64,    65,    66,    67,    -1,
      69,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    -1,    82,    83,    -1,    85,    86,    87,    88,
      89,    -1,    91,    92,    93,    -1,    -1,    96,    97,    98,
      99,    -1,   101,   102,   103,    -1,   105,   106,   107,   108,
     109,   110,    -1,    -1,    -1,    -1,   115,   116,   117,    -1,
      -1,   120,   121,   122,    -1,   124,    -1,    -1,    -1,   128,
      -1,   130,   131,   132,   133,   134,    -1,    -1,    -1,   138,
      -1,    -1,   141,   142,   143,    -1,    -1,    -1,   147,    -1,
     149,   150,    -1,   152,   153,   154,    -1,    -1,   157,   158,
      -1,   160,   161,   162,   163,   164,   165,   166,    -1,   168,
     169,   170,   171,   172,   173,   174,   175,   176,    -1,   178,
     179,   180,   181,    -1,   183,    -1,    -1,    -1,   187,   188,
      -1,   190,    -1,   192,    -1,   194,   195,   196,   197,    -1,
     199,    -1,   201,    -1,   203,    -1,   205,   206,    -1,   208,
     209,    -1,   211,   212,    -1,    -1,    -1,   216,   217,   218,
     219,   220,    -1,   222,   223,   224,    -1,    -1,   227,    -1,
      -1,    -1,   231,   232,   233,   234,    -1,    -1,   237,    -1,
      -1,    -1,   241,   242,    -1,   244,   245,    -1,    -1,    -1,
     249,    -1,    -1,   252,   253,    -1,    -1,   256,    -1,   258,
     259,   260,    -1,    -1,    -1,    -1,    -1,   266,   267,    -1,
     269,    -1,   271,    -1,   273,   274,    -1,    -1,   277,    -1,
      -1,    -1,    -1,   282,    -1,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,   300,    -1,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,    -1,    -1,    -1,    -1,   317,   318,
     319,   320,   321,   322,    -1,    -1,   325,   326,   327,   328,
      -1,   330,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,    -1,   342,   343,   344,    -1,    -1,   347,   348,
     349,   350,   351,    -1,   353,   354,   355,    -1,   357,   358,
     359,    -1,   361,   362,   363,    -1,   365,   366,   367,    -1,
     369,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     379,   380,   381,   382,   383,   384,    -1,   386,   387,   388,
     389,   390,   391,   392,   393,   394,   395,   396,    -1,   398,
     399,   400,    -1,   402,    -1,   404,   405,   406,   407,   408,
      -1,   410,   411,   412,    -1,    -1,   415,    -1,    -1,    -1,
     419,   420,   421,   422,   423,    -1,    -1,   426,   427,   428,
     429,   430,    -1,   432,   433,    -1,   435,   436,   437,   438,
     439,   440,    -1,   442,    -1,   444,   445,    -1,   447,   448,
     449,    -1,   451,    -1,   453,   454,   455,   456,   457,   458,
     459,   460,   461,   462,   463,   464,    -1,   466,   467,    -1,
      -1,    -1,   471,   472,   473,   474,    -1,    -1,    -1,   478,
      -1,    -1,    -1,   482,    -1,   484,   485,   486,   487,    -1,
     489,   490,   491,   492,   493,    -1,    -1,    -1,    -1,    -1,
     499,   500,   501,    -1,   503,   504,    -1,   506,    -1,    -1,
     509,    -1,    -1,   512,   513,   514,   515,   516,   517,   518,
     519,   520,   521,    -1,   523,   524,   525,   526,   527,   528,
     529,   530,   531,   532,   533,   534,   535,   536,   537,    -1,
      -1,   540,   541,   542,   543,    -1,   545,   546,   547,    -1,
     549,   550,   551,   552,    -1,    -1,    -1,    -1,    -1,   558,
     559,    -1,   561,   562,   563,   564,   565,   566,   567,   568,
     569,   570,   571,   572,    -1,   574,   575,    -1,    -1,   578,
      -1,    -1,   581,    -1,   583,    -1,   585,   586,    -1,    -1,
     589,   590,   591,   592,   593,    -1,    -1,   596,   597,    -1,
     599,   600,   601,   602,   603,   604,    -1,    -1,    -1,    -1,
      -1,    -1,   611,   612,    -1,   614,   615,   616,    -1,    -1,
     619,    -1,    -1,    -1,   623,   624,    -1,    -1,    -1,    -1,
     629,   630,    -1,    -1,   633,   634,    -1,    -1,   637,   638,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    14,
      -1,    -1,    -1,    18,    -1,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    -1,    -1,    33,    34,
      35,    36,    37,    38,    39,    -1,    41,    42,    43,    -1,
      45,    -1,    47,    48,    -1,    -1,    51,    52,    53,    54,
      55,    -1,    57,    58,    59,    60,    -1,    62,    63,    64,
      65,    66,    67,    -1,    69,    70,    -1,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    -1,    82,    83,    -1,
      85,    86,    87,    88,    89,    -1,    91,    92,    93,    -1,
      -1,    96,    97,    98,    99,    -1,   101,   102,   103,    -1,
     105,   106,   107,   108,   109,   110,    -1,    -1,    -1,    -1,
     115,   116,   117,    -1,    -1,   120,   121,   122,    -1,   124,
      -1,    -1,    -1,   128,    -1,   130,   131,   132,   133,   134,
      -1,    -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,
      -1,    -1,   147,    -1,   149,   150,    -1,   152,   153,   154,
      -1,    -1,   157,   158,    -1,   160,   161,   162,   163,   164,
     165,   166,    -1,   168,   169,   170,   171,   172,   173,   174,
     175,   176,    -1,   178,   179,   180,   181,    -1,   183,    -1,
      -1,    -1,   187,   188,    -1,   190,    -1,   192,    -1,   194,
     195,   196,   197,    -1,   199,    -1,   201,    -1,   203,    -1,
     205,   206,    -1,   208,   209,    -1,   211,   212,    -1,    -1,
      -1,   216,   217,   218,   219,   220,    -1,   222,   223,   224,
      -1,    -1,   227,    -1,    -1,    -1,   231,   232,   233,   234,
      -1,    -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,
     245,    -1,    -1,    -1,   249,    -1,    -1,   252,   253,    -1,
      -1,   256,    -1,   258,   259,   260,    -1,    -1,    -1,    -1,
      -1,   266,   267,    -1,   269,    -1,   271,    -1,   273,   274,
      -1,    -1,   277,    -1,    -1,    -1,    -1,   282,    -1,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,    -1,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,    -1,    -1,
      -1,    -1,   317,   318,   319,   320,   321,   322,    -1,    -1,
     325,   326,   327,   328,    -1,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,    -1,   342,   343,   344,
      -1,    -1,   347,   348,   349,   350,   351,    -1,   353,   354,
     355,    -1,   357,   358,   359,    -1,   361,   362,   363,    -1,
     365,   366,   367,    -1,   369,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   379,   380,   381,   382,   383,   384,
      -1,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,    -1,   398,   399,   400,    -1,   402,    -1,   404,
     405,   406,   407,   408,    -1,   410,   411,   412,    -1,    -1,
     415,    -1,    -1,    -1,   419,   420,   421,   422,   423,    -1,
      -1,   426,   427,   428,   429,   430,    -1,   432,   433,    -1,
     435,   436,   437,   438,   439,   440,    -1,   442,    -1,   444,
     445,    -1,   447,   448,   449,    -1,   451,    -1,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
      -1,   466,   467,    -1,    -1,    -1,   471,   472,   473,   474,
      -1,    -1,    -1,   478,    -1,    -1,    -1,   482,    -1,   484,
     485,   486,   487,    -1,   489,   490,   491,   492,   493,    -1,
      -1,    -1,    -1,    -1,   499,   500,   501,    -1,   503,   504,
      -1,   506,    -1,    -1,   509,    -1,    -1,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,    -1,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,    -1,    -1,   540,   541,   542,   543,    -1,
     545,   546,   547,    -1,   549,   550,   551,   552,    -1,    -1,
      -1,    -1,    -1,   558,   559,    -1,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,    -1,   574,
     575,    -1,    -1,   578,    -1,    -1,   581,    -1,   583,    -1,
     585,   586,    -1,    -1,   589,   590,   591,   592,   593,    -1,
      -1,   596,   597,    -1,   599,   600,   601,   602,   603,   604,
      -1,    -1,    -1,    -1,    -1,    -1,   611,   612,    -1,   614,
     615,   616,    -1,    -1,   619,    -1,    -1,    -1,   623,   624,
      -1,    -1,    -1,    -1,   629,   630,    -1,    -1,   633,   634,
      -1,    -1,   637,   638,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    14,    -1,    -1,    -1,    18,    -1,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      -1,    -1,    33,    34,    35,    36,    37,    38,    39,    -1,
      41,    42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,
      51,    52,    53,    54,    55,    -1,    57,    58,    59,    60,
      -1,    62,    63,    64,    65,    66,    67,    -1,    69,    70,
      -1,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    -1,    85,    86,    87,    88,    89,    -1,
      91,    92,    93,    -1,    -1,    96,    97,    98,    99,    -1,
     101,   102,   103,    -1,   105,   106,   107,   108,   109,   110,
      -1,    -1,    -1,    -1,   115,   116,   117,    -1,    -1,   120,
     121,   122,    -1,   124,    -1,    -1,    -1,   128,    -1,   130,
     131,   132,   133,   134,    -1,    -1,    -1,   138,    -1,    -1,
     141,   142,   143,    -1,    -1,    -1,   147,    -1,   149,   150,
      -1,   152,   153,   154,    -1,    -1,   157,   158,    -1,   160,
     161,   162,   163,   164,   165,   166,    -1,   168,   169,   170,
     171,   172,   173,   174,   175,   176,    -1,   178,   179,   180,
     181,    -1,   183,    -1,    -1,    -1,   187,   188,    -1,   190,
      -1,   192,    -1,   194,   195,   196,   197,    -1,   199,    -1,
     201,    -1,   203,    -1,   205,   206,    -1,   208,   209,    -1,
     211,   212,    -1,    -1,    -1,   216,   217,   218,   219,   220,
      -1,   222,   223,   224,    -1,    -1,   227,    -1,    -1,    -1,
     231,   232,   233,   234,    -1,    -1,   237,    -1,    -1,    -1,
     241,   242,    -1,   244,   245,    -1,    -1,    -1,   249,    -1,
      -1,   252,   253,    -1,    -1,   256,    -1,   258,   259,   260,
      -1,    -1,    -1,    -1,    -1,   266,   267,    -1,   269,    -1,
     271,    -1,   273,   274,    -1,    -1,   277,    -1,    -1,    -1,
      -1,   282,    -1,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
      -1,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,    -1,    -1,    -1,    -1,   317,   318,   319,   320,
     321,   322,    -1,    -1,   325,   326,   327,   328,    -1,   330,
     331,   332,   333,   334,   335,   336,   337,   338,   339,   340,
      -1,   342,   343,   344,    -1,    -1,   347,   348,   349,   350,
     351,    -1,   353,   354,   355,    -1,   357,   358,   359,    -1,
     361,   362,   363,    -1,   365,   366,   367,    -1,   369,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,   380,
     381,   382,   383,   384,    -1,   386,   387,   388,   389,   390,
     391,   392,   393,   394,   395,   396,    -1,   398,   399,   400,
      -1,   402,    -1,   404,   405,   406,   407,   408,    -1,   410,
     411,   412,    -1,    -1,   415,    -1,    -1,    -1,   419,   420,
     421,   422,   423,    -1,    -1,   426,   427,   428,   429,   430,
      -1,   432,   433,    -1,   435,   436,   437,   438,   439,   440,
      -1,   442,    -1,   444,   445,    -1,   447,   448,   449,    -1,
     451,    -1,   453,   454,   455,   456,   457,   458,   459,   460,
     461,   462,   463,   464,    -1,   466,   467,    -1,    -1,    -1,
     471,   472,   473,   474,    -1,    -1,    -1,   478,    -1,    -1,
      -1,   482,    -1,   484,   485,   486,   487,    -1,   489,   490,
     491,   492,   493,    -1,    -1,    -1,    -1,    -1,   499,   500,
     501,    -1,   503,   504,    -1,   506,    -1,    -1,   509,    -1,
      -1,   512,   513,   514,   515,   516,   517,   518,   519,   520,
     521,    -1,   523,   524,   525,   526,   527,   528,   529,   530,
     531,   532,   533,   534,   535,   536,   537,    -1,    -1,   540,
     541,   542,   543,    -1,   545,   546,   547,    -1,   549,   550,
     551,   552,    -1,    -1,    -1,    -1,    -1,   558,   559,    -1,
     561,   562,   563,   564,   565,   566,   567,   568,   569,   570,
     571,   572,    -1,   574,   575,    -1,    -1,   578,    -1,    -1,
     581,    -1,   583,    -1,   585,   586,    -1,    -1,   589,   590,
     591,   592,   593,    -1,    -1,   596,   597,    -1,   599,   600,
     601,   602,   603,   604,    -1,    -1,    -1,    -1,    -1,    -1,
     611,   612,    -1,   614,   615,   616,    -1,    -1,   619,    -1,
      -1,    -1,   623,   624,    -1,    -1,    -1,    -1,   629,   630,
      -1,    -1,   633,   634,    -1,    -1,   637,   638,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    14,    -1,    -1,
      -1,    18,    -1,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    -1,    30,    -1,    -1,    -1,    34,    35,    -1,
      -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,
      47,    48,    -1,    -1,    51,    -1,    -1,    54,    55,    -1,
      57,    58,    -1,    60,    -1,    62,    63,    64,    65,    66,
      67,    -1,    69,    70,    -1,    72,    73,    74,    75,    76,
      77,    78,    79,    80,    -1,    82,    83,    -1,    85,    86,
      87,    88,    89,    -1,    -1,    -1,    93,    -1,    -1,    96,
      -1,    98,    -1,    -1,   101,    -1,    -1,    -1,   105,   106,
     107,    -1,    -1,   110,    -1,    -1,    -1,    -1,   115,   116,
     117,    -1,    -1,    -1,   121,   122,    -1,   124,    -1,    -1,
      -1,   128,    -1,   130,   131,   132,   133,   134,    -1,    -1,
      -1,   138,    -1,    -1,   141,   142,   143,    -1,    -1,    -1,
     147,    -1,   149,   150,    -1,   152,   153,   154,    -1,    -1,
     157,   158,    -1,   160,   161,   162,   163,   164,   165,    -1,
      -1,   168,   169,   170,   171,   172,    -1,   174,   175,   176,
      -1,   178,   179,   180,   181,    -1,   183,    -1,    -1,    -1,
     187,   188,    -1,   190,    -1,   192,    -1,   194,   195,   196,
     197,    -1,   199,    -1,   201,    -1,    -1,    -1,   205,   206,
      -1,   208,   209,    -1,   211,   212,    -1,    -1,    -1,   216,
     217,   218,   219,    -1,    -1,   222,   223,   224,    -1,    -1,
     227,    -1,    -1,    -1,    -1,   232,   233,    -1,    -1,    -1,
     237,    -1,    -1,    -1,   241,   242,    -1,   244,   245,    -1,
      -1,    -1,   249,    -1,    -1,   252,   253,    -1,    -1,   256,
      -1,    -1,   259,   260,    -1,    -1,    -1,    -1,    -1,   266,
     267,    -1,   269,    -1,   271,    -1,   273,   274,    -1,    -1,
     277,    -1,    -1,    -1,    -1,   282,    -1,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,    -1,   302,   303,   304,    -1,   306,
     307,   308,   309,    -1,   311,   312,    -1,    -1,    -1,    -1,
     317,   318,   319,   320,   321,   322,    -1,    -1,   325,   326,
      -1,   328,    -1,   330,    -1,   332,   333,   334,   335,   336,
     337,   338,   339,   340,    -1,   342,   343,   344,    -1,    -1,
     347,   348,   349,   350,    -1,    -1,    -1,   354,   355,    -1,
     357,   358,   359,    -1,   361,   362,   363,    -1,   365,   366,
     367,    -1,   369,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   379,   380,   381,    -1,   383,   384,    -1,   386,
     387,   388,   389,   390,   391,   392,   393,   394,   395,    -1,
      -1,   398,   399,   400,    -1,   402,    -1,   404,   405,   406,
     407,   408,    -1,   410,   411,   412,    -1,    -1,   415,    -1,
      -1,    -1,   419,   420,   421,   422,   423,    -1,    -1,   426,
     427,   428,   429,   430,    -1,   432,   433,    -1,   435,   436,
     437,    -1,    -1,   440,    -1,   442,    -1,   444,   445,    -1,
     447,   448,   449,    -1,   451,    -1,    -1,   454,   455,   456,
     457,   458,   459,   460,   461,   462,   463,   464,    -1,   466,
     467,    -1,    -1,    -1,   471,   472,   473,   474,    -1,    -1,
      -1,   478,    -1,    -1,    -1,   482,    -1,   484,   485,   486,
     487,    -1,   489,   490,   491,   492,   493,    -1,    -1,    -1,
      -1,    -1,   499,   500,   501,    -1,   503,   504,    -1,   506,
      -1,    -1,   509,    -1,    -1,   512,   513,   514,   515,   516,
     517,    -1,    -1,   520,   521,    -1,   523,   524,   525,   526,
     527,   528,    -1,    -1,   531,   532,   533,   534,    -1,   536,
     537,    -1,    -1,   540,   541,   542,   543,    -1,   545,   546,
     547,    -1,   549,   550,   551,   552,    -1,    -1,    -1,    -1,
      -1,   558,   559,    -1,    -1,   562,   563,   564,   565,   566,
     567,   568,   569,   570,   571,   572,    -1,   574,   575,    -1,
      -1,   578,    -1,    -1,   581,    -1,   583,    -1,   585,   586,
      -1,    -1,    -1,    -1,    -1,    -1,   593,    -1,    -1,   596,
      -1,    -1,    -1,   600,   601,   602,   603,   604,    -1,    -1,
      -1,    -1,    -1,    -1,   611,   612,    -1,   614,   615,   616,
      -1,    -1,   619,    -1,    -1,    -1,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    14,    -1,    -1,    -1,    18,
     637,   638,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,
      -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,    48,
      -1,    -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,
      -1,    60,    -1,    62,    63,    64,    65,    66,    67,    -1,
      69,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    -1,    82,    83,    84,    85,    86,    87,    88,
      89,    -1,    -1,    -1,    93,    -1,    -1,    96,    -1,    98,
      -1,    -1,   101,    -1,    -1,    -1,   105,   106,   107,    -1,
      -1,   110,    -1,    -1,    -1,    -1,   115,   116,    -1,    -1,
      -1,    -1,   121,   122,    -1,   124,    -1,    -1,    -1,   128,
      -1,   130,   131,   132,   133,   134,    -1,    -1,    -1,   138,
      -1,    -1,   141,   142,   143,    -1,    -1,    -1,   147,    -1,
     149,   150,    -1,   152,   153,   154,    -1,    -1,   157,   158,
      -1,   160,   161,   162,   163,   164,   165,    -1,    -1,   168,
     169,   170,   171,   172,    -1,    -1,   175,   176,    -1,   178,
     179,   180,    -1,    -1,   183,    -1,    -1,    -1,   187,   188,
      -1,   190,   191,   192,    -1,   194,   195,   196,   197,    -1,
     199,    -1,   201,    -1,    -1,    -1,   205,   206,    -1,   208,
      -1,    -1,   211,   212,    -1,    -1,    -1,   216,   217,   218,
     219,    -1,    -1,   222,   223,   224,   225,    -1,   227,    -1,
      -1,    -1,    -1,   232,   233,    -1,    -1,    -1,   237,    -1,
      -1,    -1,   241,   242,    -1,   244,   245,    -1,    -1,    -1,
     249,   250,    -1,   252,   253,    -1,    -1,   256,    -1,    -1,
     259,   260,    -1,   262,    -1,    -1,    -1,   266,   267,    -1,
     269,    -1,   271,    -1,   273,   274,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   282,    -1,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,   300,    -1,   302,   303,   304,    -1,   306,   307,   308,
     309,    -1,   311,   312,    -1,    -1,    -1,    -1,   317,   318,
     319,   320,   321,   322,    -1,    -1,   325,   326,    -1,   328,
      -1,   330,    -1,   332,   333,   334,   335,   336,   337,   338,
     339,   340,    -1,    -1,   343,   344,    -1,    -1,   347,   348,
     349,   350,    -1,    -1,    -1,   354,   355,    -1,    -1,    -1,
     359,    -1,   361,   362,   363,    -1,   365,   366,   367,    -1,
     369,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     379,   380,   381,    -1,   383,   384,   385,   386,   387,   388,
     389,   390,   391,   392,   393,   394,   395,    -1,    -1,   398,
     399,   400,    -1,   402,    -1,   404,   405,   406,   407,   408,
      -1,   410,   411,   412,    -1,    -1,   415,    -1,    -1,    -1,
     419,   420,   421,   422,   423,    -1,    -1,   426,   427,   428,
     429,   430,    -1,   432,   433,    -1,   435,   436,   437,    -1,
      -1,   440,    -1,   442,    -1,   444,   445,    -1,   447,   448,
     449,    -1,   451,    -1,    -1,   454,   455,   456,   457,   458,
     459,   460,   461,   462,   463,   464,    -1,   466,   467,   468,
      -1,    -1,   471,   472,   473,   474,    -1,    -1,    -1,   478,
      -1,    -1,    -1,   482,    -1,   484,   485,   486,   487,    -1,
     489,   490,   491,   492,   493,   494,    -1,    -1,    -1,    -1,
     499,   500,   501,    -1,   503,   504,    -1,   506,    -1,    -1,
     509,    -1,    -1,   512,   513,   514,   515,   516,   517,    -1,
      -1,   520,   521,    -1,   523,   524,   525,   526,   527,   528,
      -1,    -1,   531,   532,   533,   534,    -1,   536,   537,    -1,
      -1,   540,   541,   542,   543,    -1,    -1,   546,   547,    -1,
     549,   550,   551,   552,    -1,    -1,    -1,    -1,    -1,   558,
     559,    -1,    -1,    -1,   563,   564,   565,   566,    -1,   568,
     569,    -1,   571,   572,    -1,   574,   575,    -1,    -1,   578,
      -1,    -1,   581,    -1,   583,    -1,   585,   586,    -1,    -1,
      -1,    -1,    -1,    -1,   593,    -1,    -1,   596,    -1,    -1,
      -1,   600,   601,   602,   603,   604,    -1,    -1,    -1,    -1,
      -1,    -1,   611,   612,    -1,   614,   615,   616,    -1,    -1,
     619,    -1,     5,    -1,     7,     8,     9,    10,    11,    -1,
      -1,    14,    -1,    -1,    -1,    18,    -1,    -1,    21,   638,
      23,    24,    25,    26,    27,    28,    -1,    30,    -1,    -1,
      -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,
      43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,
      -1,    54,    55,    -1,    57,    58,    -1,    60,    -1,    62,
      63,    64,    65,    66,    67,    -1,    69,    70,    -1,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    -1,    82,
      83,    84,    85,    86,    87,    88,    89,    -1,    -1,    -1,
      93,    -1,    -1,    96,    -1,    98,    -1,    -1,   101,    -1,
      -1,    -1,   105,   106,   107,    -1,    -1,   110,    -1,    -1,
      -1,    -1,   115,   116,    -1,    -1,    -1,    -1,   121,   122,
      -1,   124,    -1,    -1,    -1,   128,    -1,   130,   131,   132,
     133,   134,    -1,    -1,    -1,   138,    -1,    -1,   141,   142,
     143,    -1,    -1,    -1,   147,    -1,   149,   150,    -1,   152,
     153,   154,    -1,    -1,   157,   158,    -1,   160,   161,   162,
     163,   164,   165,    -1,    -1,   168,   169,   170,   171,   172,
      -1,    -1,   175,   176,    -1,   178,   179,   180,    -1,    -1,
     183,    -1,    -1,    -1,   187,   188,    -1,   190,   191,   192,
      -1,   194,   195,   196,   197,    -1,   199,    -1,   201,    -1,
      -1,    -1,   205,   206,    -1,   208,    -1,    -1,   211,   212,
      -1,    -1,    -1,   216,   217,   218,   219,    -1,    -1,   222,
     223,   224,   225,    -1,   227,    -1,    -1,    -1,    -1,   232,
     233,    -1,    -1,    -1,   237,    -1,    -1,    -1,   241,   242,
      -1,   244,   245,    -1,    -1,    -1,   249,   250,    -1,   252,
     253,    -1,    -1,   256,    -1,    -1,   259,   260,    -1,    -1,
      -1,    -1,    -1,   266,   267,    -1,   269,    -1,   271,    -1,
     273,   274,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   282,
      -1,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,   300,    -1,   302,
     303,   304,    -1,   306,   307,   308,   309,    -1,   311,   312,
      -1,    -1,    -1,    -1,   317,   318,   319,   320,   321,   322,
      -1,    -1,   325,   326,    -1,   328,    -1,   330,    -1,   332,
     333,   334,   335,   336,   337,   338,   339,   340,    -1,    -1,
     343,   344,    -1,    -1,   347,   348,   349,   350,    -1,    -1,
      -1,   354,   355,    -1,    -1,    -1,   359,    -1,   361,   362,
     363,    -1,   365,   366,   367,    -1,   369,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   379,   380,   381,    -1,
     383,   384,    -1,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,    -1,    -1,   398,   399,   400,    -1,   402,
      -1,   404,   405,   406,   407,   408,    -1,   410,   411,   412,
      -1,    -1,   415,    -1,    -1,    -1,   419,   420,   421,   422,
     423,    -1,    -1,   426,   427,   428,   429,   430,    -1,   432,
     433,    -1,   435,   436,   437,    -1,    -1,   440,    -1,   442,
      -1,   444,   445,    -1,   447,   448,   449,    -1,   451,    -1,
      -1,   454,   455,   456,   457,   458,   459,   460,   461,   462,
     463,   464,    -1,   466,   467,    -1,    -1,    -1,   471,   472,
     473,   474,    -1,    -1,    -1,   478,    -1,    -1,    -1,   482,
      -1,   484,   485,   486,   487,    -1,   489,   490,   491,   492,
     493,   494,    -1,    -1,    -1,    -1,   499,   500,   501,    -1,
     503,   504,    -1,   506,    -1,    -1,   509,    -1,    -1,   512,
     513,   514,   515,   516,   517,    -1,    -1,   520,   521,    -1,
     523,   524,   525,   526,   527,   528,    -1,    -1,   531,   532,
     533,   534,    -1,   536,   537,    -1,    -1,   540,   541,   542,
     543,    -1,    -1,   546,   547,    -1,   549,   550,   551,   552,
      -1,    -1,    -1,    -1,    -1,   558,   559,    -1,    -1,    -1,
     563,   564,   565,   566,    -1,   568,   569,    -1,   571,   572,
      -1,   574,   575,    -1,    -1,   578,    -1,    -1,   581,    -1,
     583,    -1,   585,   586,    -1,    -1,    -1,    -1,    -1,    -1,
     593,    -1,    -1,   596,    -1,    -1,    -1,   600,   601,   602,
     603,   604,    -1,    -1,    -1,    -1,    -1,    -1,   611,   612,
      -1,   614,   615,   616,    -1,    -1,   619,    -1,     5,    -1,
       7,     8,     9,    10,    11,    -1,    -1,    14,    -1,    -1,
      -1,    18,    -1,    -1,    21,   638,    23,    24,    25,    26,
      27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,
      -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,
      47,    48,    -1,    -1,    51,    -1,    -1,    54,    55,    -1,
      57,    58,    -1,    60,    -1,    62,    63,    64,    65,    66,
      67,    -1,    69,    70,    -1,    72,    73,    74,    75,    76,
      77,    78,    79,    80,    -1,    82,    83,    -1,    85,    86,
      87,    88,    89,    -1,    -1,    -1,    93,    -1,    -1,    96,
      -1,    98,    -1,    -1,   101,    -1,    -1,    -1,   105,   106,
     107,    -1,    -1,   110,    -1,    -1,    -1,    -1,   115,   116,
      -1,    -1,    -1,    -1,   121,   122,    -1,   124,    -1,    -1,
      -1,   128,    -1,   130,   131,   132,   133,   134,    -1,    -1,
      -1,   138,    -1,    -1,   141,   142,   143,    -1,    -1,    -1,
     147,    -1,   149,   150,    -1,   152,   153,   154,    -1,    -1,
     157,   158,    -1,   160,   161,   162,   163,   164,   165,    -1,
      -1,   168,   169,   170,   171,   172,    -1,    -1,   175,   176,
      -1,   178,   179,   180,    -1,    -1,   183,    -1,    -1,    -1,
     187,   188,    -1,   190,    -1,   192,    -1,   194,   195,   196,
     197,    -1,   199,    -1,   201,    -1,    -1,    -1,   205,   206,
      -1,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,
     217,   218,   219,    -1,    -1,   222,   223,   224,    -1,    -1,
     227,    -1,    -1,    -1,    -1,   232,   233,    -1,    -1,    -1,
     237,    -1,    -1,    -1,   241,   242,    -1,   244,   245,    -1,
      -1,    -1,   249,    -1,    -1,   252,   253,    -1,    -1,   256,
      -1,    -1,   259,   260,    -1,    -1,    -1,    -1,    -1,   266,
     267,    -1,   269,    -1,   271,    -1,   273,   274,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   282,    -1,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,    -1,   302,   303,   304,    -1,   306,
     307,   308,   309,    -1,   311,   312,    -1,    -1,    -1,    -1,
     317,   318,   319,   320,   321,   322,    -1,    -1,   325,   326,
      -1,   328,    -1,   330,    -1,   332,   333,   334,   335,   336,
     337,   338,   339,   340,    -1,    -1,   343,   344,    -1,    -1,
     347,   348,   349,   350,    -1,    -1,    -1,   354,   355,    -1,
      -1,    -1,   359,    -1,   361,   362,   363,    -1,   365,   366,
     367,    -1,   369,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   379,   380,   381,    -1,   383,   384,    -1,   386,
     387,   388,   389,   390,   391,   392,   393,   394,   395,    -1,
      -1,   398,   399,   400,    -1,   402,    -1,   404,   405,   406,
     407,   408,    -1,   410,   411,   412,    -1,    -1,   415,    -1,
      -1,    -1,   419,   420,   421,   422,   423,    -1,    -1,   426,
     427,   428,   429,   430,    -1,   432,   433,    -1,   435,   436,
     437,    -1,    -1,   440,    -1,   442,    -1,   444,   445,    -1,
     447,   448,   449,    -1,   451,    -1,    -1,   454,   455,   456,
     457,   458,   459,   460,   461,   462,   463,   464,    -1,   466,
     467,   468,    -1,    -1,   471,   472,   473,   474,    -1,    -1,
      -1,   478,    -1,    -1,    -1,   482,    -1,   484,   485,   486,
     487,    -1,   489,   490,   491,   492,   493,    -1,    -1,    -1,
      -1,    -1,   499,   500,   501,    -1,   503,   504,    -1,   506,
      -1,    -1,   509,    -1,    -1,   512,   513,   514,   515,   516,
     517,    -1,    -1,   520,   521,    -1,   523,   524,   525,   526,
     527,   528,    -1,    -1,   531,   532,   533,   534,    -1,   536,
     537,    -1,    -1,   540,   541,   542,   543,    -1,    -1,   546,
     547,    -1,   549,   550,   551,   552,    -1,    -1,    -1,    -1,
      -1,   558,   559,    -1,    -1,    -1,   563,   564,   565,   566,
      -1,   568,   569,    -1,   571,   572,    -1,   574,   575,    -1,
      -1,   578,    -1,    -1,   581,    -1,   583,    -1,   585,   586,
      -1,    -1,    -1,    -1,    -1,    -1,   593,    -1,    -1,   596,
      -1,    -1,    -1,   600,   601,   602,   603,   604,    -1,    -1,
      -1,    -1,    -1,    -1,   611,   612,    -1,   614,   615,   616,
      -1,    -1,   619,    -1,     5,    -1,     7,     8,     9,    10,
      11,    -1,    -1,    14,   631,    -1,    -1,    18,    -1,    -1,
      21,   638,    23,    24,    25,    26,    27,    28,    -1,    30,
      -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,
      41,    42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,
      51,    -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,
      -1,    62,    63,    64,    65,    66,    67,    -1,    69,    70,
      -1,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    -1,    85,    86,    87,    88,    89,    -1,
      -1,    -1,    93,    -1,    -1,    96,    -1,    98,    -1,    -1,
     101,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,
      -1,    -1,    -1,    -1,   115,   116,    -1,    -1,    -1,    -1,
     121,   122,    -1,   124,    -1,    -1,    -1,   128,    -1,   130,
     131,   132,   133,   134,    -1,    -1,    -1,   138,    -1,    -1,
     141,   142,   143,    -1,    -1,    -1,   147,    -1,   149,   150,
      -1,   152,   153,   154,    -1,    -1,   157,   158,    -1,   160,
     161,   162,   163,   164,   165,    -1,    -1,   168,   169,   170,
     171,   172,    -1,    -1,   175,   176,    -1,   178,   179,   180,
      -1,    -1,   183,    -1,    -1,    -1,   187,   188,    -1,   190,
      -1,   192,    -1,   194,   195,   196,   197,    -1,   199,    -1,
     201,    -1,    -1,    -1,   205,   206,    -1,   208,    -1,    -1,
     211,   212,    -1,    -1,    -1,   216,   217,   218,   219,    -1,
      -1,   222,   223,   224,    -1,    -1,   227,    -1,    -1,    -1,
      -1,   232,   233,    -1,    -1,    -1,   237,    -1,    -1,    -1,
     241,   242,    -1,   244,   245,    -1,    -1,    -1,   249,    -1,
      -1,   252,   253,    -1,    -1,   256,    -1,    -1,   259,   260,
      -1,    -1,    -1,    -1,    -1,   266,   267,    -1,   269,    -1,
     271,    -1,   273,   274,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   282,    -1,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
      -1,   302,   303,   304,    -1,   306,   307,   308,   309,    -1,
     311,   312,    -1,    -1,    -1,    -1,   317,   318,   319,   320,
     321,   322,    -1,    -1,   325,   326,    -1,   328,    -1,   330,
      -1,   332,   333,   334,   335,   336,   337,   338,   339,   340,
      -1,    -1,   343,   344,    -1,    -1,   347,   348,   349,   350,
      -1,    -1,    -1,   354,   355,    -1,    -1,    -1,   359,    -1,
     361,   362,   363,    -1,   365,   366,   367,    -1,   369,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,   380,
     381,    -1,   383,   384,    -1,   386,   387,   388,   389,   390,
     391,   392,   393,   394,   395,    -1,    -1,   398,   399,   400,
      -1,   402,    -1,   404,   405,   406,   407,   408,    -1,   410,
     411,   412,    -1,    -1,   415,    -1,    -1,    -1,   419,   420,
     421,   422,   423,    -1,    -1,   426,   427,   428,   429,   430,
      -1,   432,   433,    -1,   435,   436,   437,    -1,    -1,   440,
      -1,   442,    -1,   444,   445,    -1,   447,   448,   449,    -1,
     451,    -1,    -1,   454,   455,   456,   457,   458,   459,   460,
     461,   462,   463,   464,    -1,   466,   467,    -1,    -1,    -1,
     471,   472,   473,   474,    -1,    -1,    -1,   478,    -1,    -1,
      -1,   482,    -1,   484,   485,   486,   487,    -1,   489,   490,
     491,   492,   493,    -1,    -1,    -1,    -1,    -1,   499,   500,
     501,    -1,   503,   504,    -1,   506,    -1,    -1,   509,    -1,
      -1,   512,   513,   514,   515,   516,   517,    -1,    -1,   520,
     521,    -1,   523,   524,   525,   526,   527,   528,    -1,    -1,
     531,   532,   533,   534,    -1,   536,   537,    -1,    -1,   540,
     541,   542,   543,    -1,    -1,   546,   547,    -1,   549,   550,
     551,   552,    -1,    -1,    -1,    -1,    -1,   558,   559,    -1,
      -1,    -1,   563,   564,   565,   566,    -1,   568,   569,    -1,
     571,   572,    -1,   574,   575,    -1,    -1,   578,    -1,    -1,
     581,    -1,   583,    -1,   585,   586,    -1,    -1,    -1,    -1,
      -1,    -1,   593,    -1,    -1,   596,    -1,    -1,    -1,   600,
     601,   602,   603,   604,    -1,    -1,    -1,    -1,    -1,    -1,
     611,   612,    -1,   614,   615,   616,    -1,    -1,   619,    -1,
      -1,    -1,     5,    -1,     7,     8,     9,    10,    11,    -1,
     631,    14,    -1,    -1,    -1,    18,   637,   638,    21,    -1,
      23,    24,    25,    26,    27,    28,    -1,    30,    -1,    -1,
      -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,
      43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,
      -1,    54,    55,    -1,    57,    58,    -1,    60,    -1,    62,
      63,    64,    65,    66,    67,    -1,    69,    70,    -1,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    -1,    82,
      83,    -1,    85,    86,    87,    88,    89,    -1,    -1,    -1,
      93,    -1,    -1,    96,    -1,    98,    -1,    -1,   101,    -1,
      -1,    -1,   105,   106,   107,    -1,    -1,   110,    -1,    -1,
      -1,    -1,   115,   116,    -1,    -1,    -1,    -1,   121,   122,
      -1,   124,    -1,    -1,    -1,   128,    -1,   130,   131,   132,
     133,   134,    -1,    -1,    -1,   138,    -1,    -1,   141,   142,
     143,    -1,    -1,    -1,   147,    -1,   149,   150,    -1,   152,
     153,   154,    -1,    -1,   157,   158,    -1,   160,   161,   162,
     163,   164,   165,    -1,    -1,   168,   169,   170,   171,   172,
      -1,    -1,   175,   176,    -1,   178,   179,   180,    -1,    -1,
     183,    -1,    -1,    -1,   187,   188,    -1,   190,    -1,   192,
      -1,   194,   195,   196,   197,    -1,   199,    -1,   201,    -1,
      -1,    -1,   205,   206,    -1,   208,    -1,    -1,   211,   212,
      -1,    -1,    -1,   216,   217,   218,   219,    -1,    -1,   222,
     223,   224,    -1,    -1,   227,    -1,    -1,    -1,    -1,   232,
     233,    -1,    -1,    -1,   237,    -1,    -1,    -1,   241,   242,
      -1,   244,   245,    -1,    -1,    -1,   249,    -1,    -1,   252,
     253,    -1,    -1,   256,    -1,    -1,   259,   260,    -1,    -1,
      -1,    -1,    -1,   266,   267,    -1,   269,    -1,   271,    -1,
     273,   274,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   282,
      -1,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,   300,    -1,   302,
     303,   304,    -1,   306,   307,   308,   309,    -1,   311,   312,
      -1,    -1,    -1,    -1,   317,   318,   319,   320,   321,   322,
      -1,    -1,   325,   326,    -1,   328,    -1,   330,    -1,   332,
     333,   334,   335,   336,   337,   338,   339,   340,    -1,    -1,
     343,   344,    -1,    -1,   347,   348,   349,   350,    -1,    -1,
      -1,   354,   355,    -1,    -1,    -1,   359,    -1,   361,   362,
     363,    -1,   365,   366,   367,    -1,   369,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   379,   380,   381,    -1,
     383,   384,    -1,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,    -1,    -1,   398,   399,   400,    -1,   402,
      -1,   404,   405,   406,   407,   408,    -1,   410,   411,   412,
      -1,    -1,   415,    -1,    -1,    -1,   419,   420,   421,   422,
     423,    -1,    -1,   426,   427,   428,   429,   430,    -1,   432,
     433,    -1,   435,   436,   437,    -1,    -1,   440,    -1,   442,
      -1,   444,   445,    -1,   447,   448,   449,    -1,   451,    -1,
      -1,   454,   455,   456,   457,   458,   459,   460,   461,   462,
     463,   464,    -1,   466,   467,    -1,    -1,    -1,   471,   472,
     473,   474,    -1,    -1,    -1,   478,    -1,    -1,    -1,   482,
      -1,   484,   485,   486,   487,    -1,   489,   490,   491,   492,
     493,    -1,    -1,    -1,    -1,    -1,   499,   500,   501,    -1,
     503,   504,    -1,   506,    -1,    -1,   509,    -1,    -1,   512,
     513,   514,   515,   516,   517,    -1,    -1,   520,   521,    -1,
     523,   524,   525,   526,   527,   528,    -1,    -1,   531,   532,
     533,   534,    -1,   536,   537,    -1,    -1,   540,   541,   542,
     543,    -1,    -1,   546,   547,    -1,   549,   550,   551,   552,
      -1,    -1,    -1,    -1,    -1,   558,   559,    -1,    -1,    -1,
     563,   564,   565,   566,    -1,   568,   569,    -1,   571,   572,
      -1,   574,   575,    -1,    -1,   578,    -1,    -1,   581,    -1,
     583,    -1,   585,   586,    -1,    -1,    -1,    -1,    -1,    -1,
     593,    -1,    -1,   596,    -1,    -1,    -1,   600,   601,   602,
     603,   604,    -1,    -1,    -1,    -1,    -1,    -1,   611,   612,
      -1,   614,   615,   616,    -1,    -1,   619,    -1,    -1,    -1,
       5,    -1,     7,     8,     9,    10,    11,   630,    -1,    14,
      -1,    -1,    -1,    18,    -1,   638,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,    34,
      -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,
      45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,    54,
      55,    -1,    57,    58,    -1,    60,    -1,    62,    63,    64,
      65,    66,    67,    -1,    69,    70,    -1,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    -1,    82,    83,    -1,
      85,    86,    87,    88,    89,    -1,    -1,    -1,    93,    -1,
      -1,    96,    -1,    98,    -1,    -1,   101,    -1,    -1,    -1,
     105,   106,   107,    -1,    -1,   110,    -1,    -1,    -1,    -1,
     115,   116,    -1,    -1,    -1,    -1,   121,   122,    -1,   124,
      -1,    -1,    -1,   128,    -1,   130,   131,   132,   133,   134,
      -1,    -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,
      -1,    -1,   147,    -1,   149,   150,    -1,   152,   153,   154,
      -1,    -1,   157,   158,    -1,   160,   161,   162,   163,   164,
     165,    -1,    -1,   168,   169,   170,   171,   172,    -1,    -1,
     175,   176,    -1,   178,   179,   180,    -1,    -1,   183,    -1,
      -1,    -1,   187,   188,    -1,   190,    -1,   192,    -1,   194,
     195,   196,   197,    -1,   199,    -1,   201,    -1,    -1,    -1,
     205,   206,    -1,   208,    -1,    -1,   211,   212,    -1,    -1,
      -1,   216,   217,   218,   219,    -1,    -1,   222,   223,   224,
      -1,    -1,   227,    -1,    -1,    -1,    -1,   232,   233,    -1,
     235,    -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,
     245,    -1,    -1,    -1,   249,    -1,    -1,   252,   253,    -1,
      -1,   256,    -1,    -1,   259,   260,    -1,    -1,    -1,    -1,
      -1,   266,   267,    -1,   269,    -1,   271,    -1,   273,   274,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   282,    -1,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,    -1,   302,   303,   304,
      -1,   306,   307,   308,   309,    -1,   311,   312,    -1,    -1,
      -1,    -1,   317,   318,   319,   320,   321,   322,    -1,    -1,
     325,   326,    -1,   328,    -1,   330,    -1,   332,   333,   334,
     335,   336,   337,   338,   339,   340,    -1,    -1,   343,   344,
      -1,    -1,   347,   348,   349,   350,    -1,    -1,    -1,   354,
     355,    -1,    -1,    -1,   359,    -1,   361,   362,   363,    -1,
     365,   366,   367,    -1,   369,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   379,   380,   381,    -1,   383,   384,
      -1,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,    -1,    -1,   398,   399,   400,    -1,   402,    -1,   404,
     405,   406,   407,   408,    -1,   410,   411,   412,    -1,    -1,
     415,    -1,    -1,    -1,   419,   420,   421,   422,   423,    -1,
      -1,   426,   427,   428,   429,   430,    -1,   432,   433,    -1,
     435,   436,   437,    -1,    -1,   440,    -1,   442,    -1,   444,
     445,    -1,   447,   448,   449,    -1,   451,    -1,    -1,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
      -1,   466,   467,    -1,    -1,    -1,   471,   472,   473,   474,
      -1,    -1,    -1,   478,    -1,    -1,    -1,   482,    -1,   484,
     485,   486,   487,    -1,   489,   490,   491,   492,   493,    -1,
      -1,    -1,    -1,    -1,   499,   500,   501,    -1,   503,   504,
      -1,   506,    -1,    -1,   509,    -1,    -1,   512,   513,   514,
     515,   516,   517,    -1,    -1,   520,   521,    -1,   523,   524,
     525,   526,   527,   528,    -1,    -1,   531,   532,   533,   534,
      -1,   536,   537,    -1,    -1,   540,   541,   542,   543,    -1,
      -1,   546,   547,    -1,   549,   550,   551,   552,    -1,    -1,
      -1,    -1,    -1,   558,   559,    -1,    -1,    -1,   563,   564,
     565,   566,    -1,   568,   569,    -1,   571,   572,    -1,   574,
     575,    -1,    -1,   578,    -1,    -1,   581,    -1,   583,    -1,
     585,   586,    -1,    -1,    -1,    -1,    -1,    -1,   593,    -1,
      -1,   596,    -1,    -1,    -1,   600,   601,   602,   603,   604,
      -1,    -1,    -1,    -1,    -1,    -1,   611,   612,    -1,   614,
     615,   616,    -1,    -1,   619,    -1,     5,    -1,     7,     8,
       9,    10,    11,    -1,    -1,    14,    -1,    -1,    -1,    18,
      -1,    -1,    21,   638,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,
      -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,    48,
      -1,    -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,
      -1,    60,    -1,    62,    63,    64,    65,    66,    67,    -1,
      69,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    -1,    82,    83,    -1,    85,    86,    87,    88,
      89,    -1,    -1,    -1,    93,    -1,    -1,    96,    -1,    98,
      -1,    -1,   101,    -1,    -1,    -1,   105,   106,   107,    -1,
      -1,   110,    -1,    -1,    -1,    -1,   115,   116,    -1,    -1,
      -1,    -1,   121,   122,    -1,   124,    -1,    -1,    -1,   128,
      -1,   130,   131,   132,   133,   134,    -1,    -1,    -1,   138,
      -1,    -1,   141,   142,   143,    -1,    -1,    -1,   147,    -1,
     149,   150,    -1,   152,   153,   154,    -1,    -1,   157,   158,
      -1,   160,   161,   162,   163,   164,   165,    -1,    -1,   168,
     169,   170,   171,   172,    -1,    -1,   175,   176,    -1,   178,
     179,   180,    -1,    -1,   183,    -1,    -1,    -1,   187,   188,
      -1,   190,    -1,   192,    -1,   194,   195,   196,   197,    -1,
     199,    -1,   201,    -1,    -1,    -1,   205,   206,    -1,   208,
      -1,    -1,   211,   212,    -1,    -1,    -1,   216,   217,   218,
     219,    -1,    -1,   222,   223,   224,    -1,    -1,   227,    -1,
      -1,    -1,    -1,   232,   233,    -1,    -1,    -1,   237,    -1,
      -1,    -1,   241,   242,    -1,   244,   245,    -1,    -1,    -1,
     249,    -1,    -1,   252,   253,    -1,    -1,   256,    -1,    -1,
     259,   260,    -1,    -1,    -1,    -1,    -1,   266,   267,    -1,
     269,    -1,   271,    -1,   273,   274,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   282,    -1,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,   300,    -1,   302,   303,   304,    -1,   306,   307,   308,
     309,    -1,   311,   312,    -1,    -1,    -1,    -1,   317,   318,
     319,   320,   321,   322,    -1,    -1,   325,   326,    -1,   328,
      -1,   330,    -1,   332,   333,   334,   335,   336,   337,   338,
     339,   340,    -1,    -1,   343,   344,    -1,    -1,   347,   348,
     349,   350,    -1,    -1,    -1,   354,   355,    -1,    -1,    -1,
     359,    -1,   361,   362,   363,    -1,   365,   366,   367,    -1,
     369,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     379,   380,   381,    -1,   383,   384,    -1,   386,   387,   388,
     389,   390,   391,   392,   393,   394,   395,    -1,    -1,   398,
     399,   400,    -1,   402,    -1,   404,   405,   406,   407,   408,
      -1,   410,   411,   412,    -1,    -1,   415,    -1,    -1,    -1,
     419,   420,   421,   422,   423,    -1,    -1,   426,   427,   428,
     429,   430,    -1,   432,   433,    -1,   435,   436,   437,    -1,
      -1,   440,    -1,   442,    -1,   444,   445,    -1,   447,   448,
     449,    -1,   451,    -1,    -1,   454,   455,   456,   457,   458,
     459,   460,   461,   462,   463,   464,    -1,   466,   467,    -1,
      -1,    -1,   471,   472,   473,   474,    -1,    -1,    -1,   478,
      -1,    -1,    -1,   482,    -1,   484,   485,   486,   487,    -1,
     489,   490,   491,   492,   493,    -1,    -1,    -1,    -1,    -1,
     499,   500,   501,    -1,   503,   504,    -1,   506,    -1,    -1,
     509,    -1,    -1,   512,   513,   514,   515,   516,   517,    -1,
      -1,   520,   521,    -1,   523,   524,   525,   526,   527,   528,
      -1,    -1,   531,   532,   533,   534,    -1,   536,   537,    -1,
      -1,   540,   541,   542,   543,    -1,    -1,   546,   547,    -1,
     549,   550,   551,   552,    -1,    -1,    -1,    -1,    -1,   558,
     559,    -1,    -1,    -1,   563,   564,   565,   566,    -1,   568,
     569,    -1,   571,   572,    -1,   574,   575,    -1,    -1,   578,
      -1,    -1,   581,    -1,   583,    -1,   585,   586,    -1,    -1,
      -1,    -1,    -1,    -1,   593,    -1,    -1,   596,    -1,    -1,
      -1,   600,   601,   602,   603,   604,    -1,    -1,    -1,    -1,
      -1,    -1,   611,   612,    -1,   614,   615,   616,    -1,    -1,
     619,    -1,    -1,    -1,    -1,     5,   625,     7,     8,     9,
      10,    11,    -1,    -1,    14,    -1,    -1,    -1,    18,   638,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,
      -1,    41,    42,    43,    -1,    45,    -1,    47,    48,    -1,
      -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,    -1,
      60,    -1,    62,    63,    64,    65,    66,    67,    -1,    69,
      70,    -1,    72,    73,    74,    75,    76,    77,    78,    79,
      80,    -1,    82,    83,    -1,    85,    86,    87,    88,    89,
      -1,    -1,    -1,    93,    -1,    -1,    96,    -1,    98,    -1,
      -1,   101,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,
     110,    -1,    -1,    -1,    -1,   115,   116,    -1,    -1,    -1,
      -1,   121,   122,    -1,   124,    -1,    -1,    -1,   128,    -1,
     130,   131,   132,   133,   134,    -1,    -1,    -1,   138,    -1,
      -1,   141,   142,   143,    -1,    -1,    -1,   147,    -1,   149,
     150,    -1,   152,   153,   154,    -1,    -1,   157,   158,    -1,
     160,   161,   162,   163,   164,   165,    -1,    -1,   168,   169,
     170,   171,   172,    -1,    -1,   175,   176,    -1,   178,   179,
     180,    -1,    -1,   183,    -1,    -1,    -1,   187,   188,    -1,
     190,    -1,   192,    -1,   194,   195,   196,   197,    -1,   199,
      -1,   201,    -1,    -1,    -1,   205,   206,    -1,   208,    -1,
      -1,   211,   212,    -1,    -1,    -1,   216,   217,   218,   219,
      -1,    -1,   222,   223,   224,    -1,    -1,   227,    -1,    -1,
      -1,    -1,   232,   233,    -1,    -1,    -1,   237,    -1,    -1,
      -1,   241,   242,    -1,   244,   245,    -1,    -1,    -1,   249,
      -1,    -1,   252,   253,    -1,    -1,   256,    -1,    -1,   259,
     260,    -1,    -1,    -1,    -1,    -1,   266,   267,    -1,   269,
      -1,   271,    -1,   273,   274,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   282,    -1,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
     300,    -1,   302,   303,   304,    -1,   306,   307,   308,   309,
      -1,   311,   312,    -1,    -1,    -1,    -1,   317,   318,   319,
     320,   321,   322,    -1,    -1,   325,   326,    -1,   328,    -1,
     330,    -1,   332,   333,   334,   335,   336,   337,   338,   339,
     340,    -1,    -1,   343,   344,    -1,    -1,   347,   348,   349,
     350,    -1,    -1,    -1,   354,   355,    -1,    -1,    -1,   359,
      -1,   361,   362,   363,    -1,   365,   366,   367,    -1,   369,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,
     380,   381,    -1,   383,   384,    -1,   386,   387,   388,   389,
     390,   391,   392,   393,   394,   395,    -1,    -1,   398,   399,
     400,    -1,   402,    -1,   404,   405,   406,   407,   408,    -1,
     410,   411,   412,    -1,    -1,   415,    -1,    -1,    -1,   419,
     420,   421,   422,   423,    -1,    -1,   426,   427,   428,   429,
     430,    -1,   432,   433,    -1,   435,   436,   437,    -1,    -1,
     440,    -1,   442,    -1,   444,   445,    -1,   447,   448,   449,
      -1,   451,    -1,    -1,   454,   455,   456,   457,   458,   459,
     460,   461,   462,   463,   464,    -1,   466,   467,    -1,    -1,
      -1,   471,   472,   473,   474,    -1,    -1,    -1,   478,    -1,
      -1,    -1,   482,    -1,   484,   485,   486,   487,    -1,   489,
     490,   491,   492,   493,    -1,    -1,    -1,    -1,    -1,   499,
     500,   501,    -1,   503,   504,    -1,   506,    -1,    -1,   509,
      -1,    -1,   512,   513,   514,   515,   516,   517,    -1,    -1,
     520,   521,    -1,   523,   524,   525,   526,   527,   528,    -1,
      -1,   531,   532,   533,   534,    -1,   536,   537,    -1,    -1,
     540,   541,   542,   543,    -1,    -1,   546,   547,    -1,   549,
     550,   551,   552,    -1,    -1,    -1,    -1,    -1,   558,   559,
      -1,    -1,    -1,   563,   564,   565,   566,    -1,   568,   569,
      -1,   571,   572,    -1,   574,   575,    -1,    -1,   578,    -1,
      -1,   581,    -1,   583,    -1,   585,   586,    -1,    -1,    -1,
      -1,    -1,    -1,   593,    -1,    -1,   596,    -1,    -1,    -1,
     600,   601,   602,   603,   604,    -1,    -1,    -1,    -1,    -1,
      -1,   611,   612,    -1,   614,   615,   616,    -1,    -1,   619,
      -1,    -1,    -1,     5,    -1,     7,     8,     9,    10,    11,
     630,    -1,    14,    -1,    -1,    -1,    18,    -1,   638,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,    -1,
      62,    63,    64,    65,    66,    67,    -1,    69,    70,    -1,
      72,    73,    74,    75,    76,    77,    78,    79,    80,    -1,
      82,    83,    -1,    85,    86,    87,    88,    89,    -1,    -1,
      -1,    93,    -1,    -1,    96,    -1,    98,    -1,    -1,   101,
      -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,    -1,
      -1,    -1,    -1,   115,   116,    -1,    -1,    -1,    -1,   121,
     122,    -1,   124,    -1,    -1,    -1,   128,    -1,   130,   131,
     132,   133,   134,    -1,    -1,    -1,   138,    -1,    -1,   141,
     142,   143,    -1,    -1,    -1,   147,    -1,   149,   150,    -1,
     152,   153,   154,    -1,    -1,   157,   158,    -1,   160,   161,
     162,   163,   164,   165,    -1,    -1,   168,   169,   170,   171,
     172,    -1,    -1,   175,   176,    -1,   178,   179,   180,    -1,
      -1,   183,    -1,    -1,    -1,   187,   188,    -1,   190,    -1,
     192,    -1,   194,   195,   196,   197,    -1,   199,    -1,   201,
      -1,    -1,    -1,   205,   206,    -1,   208,    -1,    -1,   211,
     212,    -1,    -1,    -1,   216,   217,   218,   219,    -1,    -1,
     222,   223,   224,    -1,    -1,   227,    -1,    -1,    -1,    -1,
     232,   233,    -1,    -1,    -1,   237,    -1,    -1,    -1,   241,
     242,    -1,   244,   245,    -1,    -1,    -1,   249,    -1,    -1,
     252,   253,    -1,    -1,   256,    -1,    -1,   259,   260,    -1,
      -1,    -1,    -1,    -1,   266,   267,    -1,   269,    -1,   271,
      -1,   273,   274,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     282,    -1,   284,   285,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,   300,    -1,
     302,   303,   304,    -1,   306,   307,   308,   309,    -1,   311,
     312,    -1,    -1,    -1,    -1,   317,   318,   319,   320,   321,
     322,    -1,    -1,   325,   326,    -1,   328,    -1,   330,    -1,
     332,   333,   334,   335,   336,   337,   338,   339,   340,    -1,
      -1,   343,   344,    -1,    -1,   347,   348,   349,   350,    -1,
      -1,    -1,   354,   355,    -1,    -1,    -1,   359,    -1,   361,
     362,   363,    -1,   365,   366,   367,    -1,   369,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,   380,   381,
      -1,   383,   384,    -1,   386,   387,   388,   389,   390,   391,
     392,   393,   394,   395,    -1,    -1,   398,   399,   400,    -1,
     402,    -1,   404,   405,   406,   407,   408,    -1,   410,   411,
     412,    -1,    -1,   415,    -1,    -1,    -1,   419,   420,   421,
     422,   423,    -1,    -1,   426,   427,   428,   429,   430,    -1,
     432,   433,    -1,   435,   436,   437,    -1,    -1,   440,    -1,
     442,    -1,   444,   445,    -1,   447,   448,   449,    -1,   451,
      -1,    -1,   454,   455,   456,   457,   458,   459,   460,   461,
     462,   463,   464,    -1,   466,   467,    -1,    -1,    -1,   471,
     472,   473,   474,    -1,    -1,    -1,   478,    -1,    -1,    -1,
     482,    -1,   484,   485,   486,   487,    -1,   489,   490,   491,
     492,   493,    -1,    -1,    -1,    -1,    -1,   499,   500,   501,
      -1,   503,   504,    -1,   506,    -1,    -1,   509,    -1,    -1,
     512,   513,   514,   515,   516,   517,    -1,    -1,   520,   521,
      -1,   523,   524,   525,   526,   527,   528,    -1,    -1,   531,
     532,   533,   534,    -1,   536,   537,    -1,    -1,   540,   541,
     542,   543,    -1,    -1,   546,   547,    -1,   549,   550,   551,
     552,    -1,    -1,    -1,    -1,    -1,   558,   559,    -1,    -1,
      -1,   563,   564,   565,   566,    -1,   568,   569,    -1,   571,
     572,    -1,   574,   575,    -1,    -1,   578,    -1,    -1,   581,
      -1,   583,    -1,   585,   586,    -1,    -1,    -1,    -1,    -1,
      -1,   593,    -1,    -1,   596,    -1,    -1,    -1,   600,   601,
     602,   603,   604,    -1,    -1,    -1,    -1,    -1,    -1,   611,
     612,    -1,   614,   615,   616,    -1,    -1,   619,    -1,    -1,
      -1,     5,    -1,     7,     8,     9,    10,    11,    -1,    -1,
      14,    -1,    -1,    -1,    18,   637,   638,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,
      54,    55,    -1,    57,    58,    -1,    60,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    -1,    82,    83,
      -1,    85,    86,    87,    88,    89,    -1,    -1,    -1,    93,
      -1,    -1,    96,    -1,    98,    -1,    -1,   101,    -1,    -1,
      -1,   105,   106,   107,    -1,    -1,   110,    -1,    -1,    -1,
      -1,   115,   116,    -1,    -1,    -1,    -1,   121,   122,    -1,
     124,    -1,    -1,    -1,   128,    -1,   130,   131,   132,   133,
     134,    -1,    -1,    -1,   138,    -1,    -1,   141,   142,   143,
      -1,    -1,    -1,   147,    -1,   149,   150,    -1,   152,   153,
     154,    -1,    -1,   157,   158,    -1,   160,   161,   162,   163,
     164,   165,    -1,    -1,   168,   169,   170,   171,   172,    -1,
      -1,   175,   176,    -1,   178,   179,   180,    -1,    -1,   183,
      -1,    -1,    -1,   187,   188,    -1,   190,    -1,   192,    -1,
     194,   195,   196,   197,    -1,   199,    -1,   201,    -1,    -1,
      -1,   205,   206,    -1,   208,    -1,    -1,   211,   212,    -1,
      -1,    -1,   216,   217,   218,   219,    -1,    -1,   222,   223,
     224,    -1,    -1,   227,    -1,    -1,    -1,    -1,   232,   233,
      -1,    -1,    -1,   237,    -1,    -1,    -1,   241,   242,    -1,
     244,   245,    -1,    -1,    -1,   249,    -1,    -1,   252,   253,
      -1,    -1,   256,    -1,    -1,   259,   260,    -1,    -1,    -1,
      -1,    -1,   266,   267,    -1,   269,    -1,   271,    -1,   273,
     274,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   282,    -1,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,   296,   297,   298,   299,   300,    -1,   302,   303,
     304,    -1,   306,   307,   308,   309,    -1,   311,   312,    -1,
      -1,    -1,    -1,   317,   318,   319,   320,   321,   322,    -1,
      -1,   325,   326,    -1,   328,    -1,   330,    -1,   332,   333,
     334,   335,   336,   337,   338,   339,   340,    -1,    -1,   343,
     344,    -1,    -1,   347,   348,   349,   350,    -1,    -1,    -1,
     354,   355,    -1,    -1,    -1,   359,    -1,   361,   362,   363,
      -1,   365,   366,   367,    -1,   369,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   379,   380,   381,    -1,   383,
     384,    -1,   386,   387,   388,   389,   390,   391,   392,   393,
     394,   395,    -1,    -1,   398,   399,   400,    -1,   402,    -1,
     404,   405,   406,   407,   408,    -1,   410,   411,   412,    -1,
      -1,   415,    -1,    -1,    -1,   419,   420,   421,   422,   423,
      -1,    -1,   426,   427,   428,   429,   430,    -1,   432,   433,
      -1,   435,   436,   437,    -1,    -1,   440,    -1,   442,    -1,
     444,   445,    -1,   447,   448,   449,    -1,   451,    -1,    -1,
     454,   455,   456,   457,   458,   459,   460,   461,   462,   463,
     464,    -1,   466,   467,    -1,    -1,    -1,   471,   472,   473,
     474,    -1,    -1,    -1,   478,    -1,    -1,    -1,   482,    -1,
     484,   485,   486,   487,    -1,   489,   490,   491,   492,   493,
      -1,    -1,    -1,    -1,    -1,   499,   500,   501,    -1,   503,
     504,    -1,   506,    -1,    -1,   509,    -1,    -1,   512,   513,
     514,   515,   516,   517,    -1,    -1,   520,   521,    -1,   523,
     524,   525,   526,   527,   528,    -1,    -1,   531,   532,   533,
     534,    -1,   536,   537,    -1,    -1,   540,   541,   542,   543,
      -1,    -1,   546,   547,    -1,   549,   550,   551,   552,    -1,
      -1,    -1,    -1,    -1,   558,   559,    -1,    -1,    -1,   563,
     564,   565,   566,    -1,   568,   569,    -1,   571,   572,    -1,
     574,   575,    -1,    -1,   578,    -1,    -1,   581,    -1,   583,
      -1,   585,   586,    -1,    -1,    -1,    -1,    -1,    -1,   593,
      -1,    -1,   596,    -1,    -1,    -1,   600,   601,   602,   603,
     604,    -1,    -1,    -1,    -1,    -1,    -1,   611,   612,    -1,
     614,   615,   616,    -1,    -1,   619,    -1,     5,    -1,     7,
       8,     9,    10,    11,    -1,    -1,    14,    -1,    -1,    -1,
      18,    -1,    -1,    21,   638,    23,    24,    25,    26,    27,
      28,    -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,
      38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,
      48,    -1,    -1,    51,    -1,    -1,    54,    55,    -1,    57,
      58,    -1,    60,    -1,    62,    63,    64,    65,    66,    67,
      -1,    69,    70,    -1,    72,    73,    74,    75,    76,    77,
      78,    79,    80,    -1,    82,    83,    -1,    85,    86,    87,
      88,    89,    -1,    -1,    -1,    93,    -1,    -1,    96,    -1,
      98,    -1,    -1,   101,    -1,    -1,    -1,   105,   106,   107,
      -1,    -1,   110,    -1,    -1,    -1,    -1,   115,   116,    -1,
      -1,    -1,    -1,   121,   122,    -1,   124,    -1,    -1,    -1,
     128,    -1,   130,   131,   132,   133,   134,    -1,    -1,    -1,
     138,    -1,    -1,   141,   142,   143,    -1,    -1,    -1,   147,
      -1,   149,   150,    -1,   152,   153,   154,    -1,    -1,   157,
     158,    -1,   160,   161,   162,   163,   164,   165,    -1,    -1,
     168,   169,   170,   171,   172,    -1,    -1,   175,   176,    -1,
     178,   179,   180,    -1,    -1,   183,    -1,    -1,    -1,   187,
     188,    -1,   190,    -1,   192,    -1,   194,   195,   196,   197,
      -1,   199,    -1,   201,    -1,    -1,    -1,   205,   206,    -1,
     208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,   217,
     218,   219,    -1,    -1,   222,   223,   224,    -1,    -1,   227,
      -1,    -1,    -1,    -1,   232,   233,    -1,    -1,    -1,   237,
      -1,    -1,    -1,   241,   242,    -1,   244,   245,    -1,    -1,
      -1,   249,    -1,    -1,   252,   253,    -1,    -1,   256,    -1,
      -1,   259,   260,    -1,    -1,    -1,    -1,    -1,   266,   267,
      -1,   269,    -1,   271,    -1,   273,   274,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   282,    -1,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,   300,    -1,   302,   303,   304,    -1,   306,   307,
     308,   309,    -1,   311,   312,    -1,    -1,    -1,    -1,   317,
     318,   319,   320,   321,   322,    -1,    -1,   325,   326,    -1,
     328,    -1,   330,    -1,   332,   333,   334,   335,   336,   337,
     338,   339,   340,    -1,    -1,   343,   344,    -1,    -1,   347,
     348,   349,   350,    -1,    -1,    -1,   354,   355,    -1,    -1,
      -1,   359,    -1,   361,   362,   363,    -1,   365,   366,   367,
      -1,   369,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   379,   380,   381,    -1,   383,   384,    -1,   386,   387,
     388,   389,   390,   391,   392,   393,   394,   395,    -1,    -1,
     398,   399,   400,    -1,   402,    -1,   404,   405,   406,   407,
     408,    -1,   410,   411,   412,    -1,    -1,   415,    -1,    -1,
      -1,   419,   420,   421,   422,   423,    -1,    -1,   426,   427,
     428,   429,   430,    -1,   432,   433,    -1,   435,   436,   437,
      -1,    -1,   440,    -1,   442,    -1,   444,   445,    -1,   447,
     448,   449,    -1,   451,    -1,    -1,   454,   455,   456,   457,
     458,   459,   460,   461,   462,   463,   464,    -1,   466,   467,
      -1,    -1,    -1,   471,   472,   473,   474,    -1,    -1,    -1,
     478,    -1,    -1,    -1,   482,    -1,   484,   485,   486,   487,
      -1,   489,   490,   491,   492,   493,    -1,    -1,    -1,    -1,
      -1,   499,   500,   501,    -1,   503,   504,    -1,   506,    -1,
      -1,   509,    -1,    -1,   512,   513,   514,   515,   516,   517,
      -1,    -1,   520,   521,    -1,   523,   524,   525,   526,   527,
     528,    -1,    -1,   531,   532,   533,   534,    -1,   536,   537,
      -1,    -1,   540,   541,   542,   543,    -1,    -1,   546,   547,
      -1,   549,   550,   551,   552,    -1,    -1,    -1,    -1,    -1,
     558,   559,    -1,    -1,    -1,   563,   564,   565,   566,    -1,
     568,   569,    -1,   571,   572,    -1,   574,   575,    -1,    -1,
     578,    -1,    -1,   581,    -1,   583,    -1,   585,   586,    -1,
      -1,    -1,    -1,    -1,    -1,   593,    -1,    -1,   596,    -1,
      -1,    -1,   600,   601,   602,   603,   604,    -1,    -1,    -1,
      -1,    -1,    -1,   611,   612,    -1,   614,   615,   616,    -1,
      -1,   619,    -1,     5,    -1,     7,     8,     9,    10,    11,
      -1,    -1,    14,    -1,    -1,    -1,    18,    -1,    -1,    21,
     638,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,    -1,
      62,    63,    64,    65,    66,    67,    -1,    69,    70,    -1,
      72,    73,    74,    75,    76,    77,    78,    79,    80,    -1,
      82,    83,    -1,    85,    86,    87,    88,    89,    -1,    -1,
      -1,    93,    -1,    -1,    96,    -1,    98,    -1,    -1,   101,
      -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,    -1,
      -1,    -1,    -1,   115,   116,    -1,    -1,    -1,    -1,   121,
     122,    -1,   124,    -1,    -1,    -1,   128,    -1,   130,   131,
     132,   133,   134,    -1,    -1,    -1,   138,    -1,    -1,   141,
     142,   143,    -1,    -1,    -1,   147,    -1,   149,   150,    -1,
     152,   153,   154,    -1,    -1,   157,   158,    -1,   160,   161,
     162,   163,   164,   165,    -1,    -1,   168,   169,   170,   171,
     172,    -1,    -1,   175,   176,    -1,   178,   179,   180,    -1,
      -1,   183,    -1,    -1,    -1,   187,   188,    -1,   190,    -1,
     192,    -1,   194,   195,   196,   197,    -1,   199,    -1,   201,
      -1,    -1,    -1,   205,   206,    -1,   208,    -1,    -1,   211,
     212,    -1,    -1,    -1,   216,   217,   218,   219,    -1,    -1,
     222,   223,   224,    -1,    -1,   227,    -1,    -1,    -1,    -1,
     232,   233,    -1,    -1,    -1,   237,    -1,    -1,    -1,   241,
     242,    -1,   244,   245,    -1,    -1,    -1,   249,    -1,    -1,
     252,   253,    -1,    -1,   256,    -1,    -1,   259,   260,    -1,
      -1,    -1,    -1,    -1,   266,   267,    -1,   269,    -1,   271,
      -1,   273,   274,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     282,    -1,   284,   285,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,   300,    -1,
     302,   303,   304,    -1,   306,   307,   308,   309,    -1,   311,
     312,    -1,    -1,    -1,    -1,   317,   318,   319,   320,   321,
     322,    -1,    -1,   325,   326,    -1,   328,    -1,   330,    -1,
     332,   333,   334,   335,   336,   337,   338,   339,   340,    -1,
      -1,   343,   344,    -1,    -1,   347,   348,   349,   350,    -1,
      -1,    -1,   354,   355,    -1,    -1,    -1,   359,    -1,   361,
     362,   363,    -1,   365,   366,   367,    -1,   369,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,   380,   381,
      -1,   383,   384,    -1,   386,   387,   388,   389,   390,   391,
     392,   393,   394,   395,    -1,    -1,   398,   399,   400,    -1,
     402,    -1,   404,   405,   406,   407,   408,    -1,   410,   411,
     412,    -1,    -1,   415,    -1,    -1,    -1,   419,   420,   421,
     422,   423,    -1,    -1,   426,   427,   428,   429,   430,    -1,
     432,   433,    -1,   435,   436,   437,    -1,    -1,   440,    -1,
     442,    -1,   444,   445,    -1,   447,   448,   449,    -1,   451,
      -1,    -1,   454,   455,   456,   457,   458,   459,   460,   461,
     462,   463,   464,    -1,   466,   467,    -1,    -1,    -1,   471,
     472,   473,   474,    -1,    -1,    -1,   478,    -1,    -1,    -1,
     482,    -1,   484,   485,   486,   487,    -1,   489,   490,   491,
     492,   493,    -1,    -1,    -1,    -1,    -1,   499,   500,   501,
      -1,   503,   504,    -1,   506,    -1,    -1,   509,    -1,    -1,
     512,   513,   514,   515,   516,   517,    -1,    -1,   520,   521,
      -1,   523,   524,   525,   526,   527,   528,    -1,    -1,   531,
     532,   533,   534,    -1,   536,   537,    -1,    -1,   540,   541,
     542,   543,    -1,    -1,   546,   547,    -1,   549,   550,   551,
     552,    -1,    -1,    -1,    -1,    -1,   558,   559,    -1,    -1,
      -1,   563,   564,   565,   566,    -1,   568,   569,    -1,   571,
     572,    -1,   574,   575,    -1,    -1,   578,    -1,    -1,   581,
      -1,   583,    -1,   585,   586,    -1,    -1,    -1,    -1,    -1,
      -1,   593,    -1,    -1,   596,    -1,    -1,    -1,   600,   601,
     602,   603,   604,    -1,    -1,    -1,    -1,    -1,    -1,   611,
     612,    -1,   614,   615,   616,    -1,    -1,   619,    -1,     5,
      -1,     7,     8,     9,    10,    11,    -1,    -1,    14,    -1,
      -1,    -1,    18,    -1,    -1,    21,   638,    23,    24,    25,
      26,    27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,
      -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,
      -1,    47,    48,    -1,    -1,    51,    -1,    -1,    54,    55,
      -1,    57,    58,    -1,    60,    -1,    62,    63,    64,    65,
      66,    67,    -1,    69,    70,    -1,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    -1,    85,
      86,    87,    88,    89,    -1,    -1,    -1,    93,    -1,    -1,
      96,    -1,    98,    -1,    -1,   101,    -1,    -1,    -1,   105,
     106,   107,    -1,    -1,   110,    -1,    -1,    -1,    -1,   115,
     116,    -1,    -1,    -1,    -1,   121,   122,    -1,   124,    -1,
      -1,    -1,   128,    -1,   130,   131,   132,   133,   134,    -1,
      -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,    -1,
      -1,   147,    -1,   149,   150,    -1,   152,   153,   154,    -1,
      -1,   157,   158,    -1,   160,   161,   162,   163,   164,   165,
      -1,    -1,   168,   169,   170,   171,   172,    -1,    -1,   175,
     176,    -1,   178,   179,   180,    -1,    -1,   183,    -1,    -1,
      -1,   187,   188,    -1,   190,    -1,   192,    -1,   194,   195,
     196,   197,    -1,   199,    -1,   201,    -1,    -1,    -1,   205,
     206,    -1,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,
     216,   217,   218,   219,    -1,    -1,   222,   223,   224,    -1,
      -1,   227,    -1,    -1,    -1,    -1,   232,   233,    -1,    -1,
      -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,   245,
      -1,    -1,    -1,   249,    -1,    -1,   252,   253,    -1,    -1,
     256,    -1,    -1,   259,   260,    -1,    -1,    -1,    -1,    -1,
     266,   267,    -1,   269,    -1,   271,    -1,   273,   274,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   282,    -1,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,    -1,   302,   303,   304,    -1,
     306,   307,   308,   309,    -1,   311,   312,    -1,    -1,    -1,
      -1,   317,   318,   319,   320,   321,   322,    -1,    -1,   325,
     326,    -1,   328,    -1,   330,    -1,   332,   333,   334,   335,
     336,   337,   338,   339,   340,    -1,    -1,   343,   344,    -1,
      -1,   347,   348,   349,   350,    -1,    -1,    -1,   354,   355,
      -1,    -1,    -1,   359,    -1,   361,   362,   363,    -1,   365,
     366,   367,    -1,   369,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   379,   380,   381,    -1,   383,   384,    -1,
     386,   387,   388,   389,   390,   391,   392,   393,   394,   395,
      -1,    -1,   398,   399,   400,    -1,   402,    -1,   404,   405,
     406,   407,   408,    -1,   410,   411,   412,    -1,    -1,   415,
      -1,    -1,    -1,   419,   420,   421,   422,   423,    -1,    -1,
     426,   427,   428,   429,   430,    -1,   432,   433,    -1,   435,
     436,   437,    -1,    -1,   440,    -1,   442,    -1,   444,   445,
      -1,   447,   448,   449,    -1,   451,    -1,    -1,   454,   455,
     456,   457,   458,   459,   460,   461,   462,   463,   464,    -1,
     466,   467,    -1,    -1,    -1,   471,   472,   473,   474,    -1,
      -1,    -1,   478,    -1,    -1,    -1,   482,    -1,   484,   485,
     486,   487,    -1,   489,   490,   491,   492,   493,    -1,    -1,
      -1,    -1,    -1,   499,   500,   501,    -1,   503,   504,    -1,
     506,    -1,    -1,   509,    -1,    -1,   512,   513,   514,   515,
     516,   517,    -1,    -1,   520,   521,    -1,   523,   524,   525,
     526,   527,   528,    -1,    -1,   531,   532,   533,   534,    -1,
     536,   537,    -1,    -1,   540,   541,   542,   543,    -1,    -1,
     546,   547,    -1,   549,   550,   551,   552,    -1,    -1,    -1,
      -1,    -1,   558,   559,    -1,    -1,    -1,   563,   564,   565,
     566,    -1,   568,   569,    -1,   571,   572,    -1,   574,   575,
      -1,    -1,   578,    -1,    -1,   581,    -1,   583,    -1,   585,
     586,    -1,    -1,    -1,    -1,    -1,    -1,   593,    -1,    -1,
     596,    -1,    -1,    -1,   600,   601,   602,   603,   604,    -1,
      -1,    -1,    -1,    -1,    -1,   611,   612,    -1,   614,   615,
     616,    -1,    -1,   619,    -1,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    14,    -1,    -1,    -1,    18,    -1,
      -1,    21,   638,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,
      -1,    41,    42,    43,    -1,    45,    -1,    47,    48,    -1,
      -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,    59,
      60,    -1,    62,    63,    64,    65,    66,    67,    -1,    69,
      70,    -1,    72,    73,    74,    75,    76,    77,    78,    79,
      80,    -1,    82,    83,    -1,    85,    86,    87,    88,    89,
      -1,    -1,    -1,    93,    -1,    -1,    96,    -1,    98,    -1,
      -1,   101,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,
     110,    -1,    -1,    -1,    -1,   115,   116,    -1,    -1,    -1,
     120,   121,   122,    -1,   124,    -1,    -1,    -1,   128,    -1,
     130,   131,   132,   133,   134,    -1,    -1,    -1,   138,    -1,
      -1,   141,   142,   143,    -1,    -1,    -1,   147,    -1,   149,
     150,    -1,   152,   153,   154,    -1,    -1,   157,   158,    -1,
     160,   161,   162,   163,   164,   165,    -1,    -1,   168,   169,
     170,   171,   172,    -1,    -1,   175,   176,    -1,   178,   179,
     180,    -1,    -1,   183,    -1,    -1,    -1,   187,   188,    -1,
     190,    -1,   192,    -1,   194,   195,   196,   197,    -1,   199,
      -1,   201,    -1,    -1,    -1,   205,   206,    -1,   208,    -1,
      -1,   211,   212,    -1,    -1,    -1,   216,   217,   218,   219,
      -1,    -1,   222,   223,   224,    -1,    -1,   227,    -1,    -1,
      -1,    -1,   232,   233,    -1,    -1,    -1,   237,    -1,    -1,
      -1,   241,   242,    -1,   244,   245,    -1,    -1,    -1,   249,
      -1,    -1,   252,   253,    -1,    -1,   256,    -1,    -1,   259,
     260,    -1,    -1,    -1,    -1,    -1,   266,   267,    -1,   269,
      -1,   271,    -1,   273,   274,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   282,    -1,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
     300,    -1,   302,   303,   304,    -1,   306,   307,   308,   309,
      -1,   311,   312,    -1,    -1,    -1,    -1,   317,   318,   319,
     320,   321,   322,    -1,    -1,   325,   326,    -1,   328,    -1,
     330,    -1,   332,   333,   334,   335,   336,   337,   338,   339,
     340,    -1,    -1,   343,   344,    -1,    -1,   347,   348,   349,
     350,    -1,    -1,    -1,   354,   355,    -1,    -1,    -1,   359,
      -1,   361,   362,   363,    -1,   365,   366,   367,    -1,   369,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,
     380,   381,    -1,   383,   384,    -1,   386,   387,   388,   389,
     390,   391,   392,   393,   394,   395,    -1,    -1,   398,   399,
     400,    -1,   402,    -1,   404,   405,   406,   407,   408,    -1,
     410,   411,   412,    -1,    -1,   415,    -1,    -1,    -1,   419,
     420,   421,   422,   423,    -1,    -1,   426,   427,   428,   429,
     430,    -1,   432,   433,    -1,   435,   436,   437,    -1,    -1,
     440,    -1,   442,    -1,   444,   445,    -1,   447,   448,   449,
      -1,   451,    -1,    -1,   454,   455,   456,   457,   458,   459,
     460,   461,   462,   463,   464,    -1,   466,   467,    -1,    -1,
      -1,   471,   472,   473,   474,    -1,    -1,    -1,   478,    -1,
      -1,    -1,   482,    -1,   484,   485,   486,   487,    -1,   489,
     490,   491,   492,   493,    -1,    -1,    -1,    -1,    -1,   499,
     500,   501,    -1,   503,   504,    -1,   506,    -1,    -1,   509,
      -1,    -1,   512,   513,   514,   515,   516,   517,    -1,    -1,
     520,   521,    -1,   523,   524,   525,   526,   527,   528,    -1,
      -1,   531,   532,   533,   534,    -1,   536,   537,    -1,    -1,
     540,   541,   542,   543,    -1,    -1,   546,   547,    -1,   549,
     550,   551,   552,    -1,    -1,    -1,    -1,    -1,   558,   559,
      -1,    -1,    -1,   563,   564,   565,   566,    -1,   568,   569,
      -1,   571,   572,    -1,   574,   575,    -1,    -1,   578,    -1,
      -1,   581,    -1,   583,    -1,   585,   586,    -1,    -1,    -1,
      -1,    -1,    -1,   593,    -1,    -1,   596,    -1,    -1,    -1,
     600,   601,   602,   603,   604,    -1,    -1,    -1,    -1,    -1,
      -1,   611,   612,    -1,   614,   615,   616,    -1,    -1,   619,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    14,
      -1,    -1,    -1,    18,    -1,    -1,    21,   637,    23,    24,
      25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,    34,
      -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,
      45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,    54,
      55,    -1,    57,    58,    -1,    60,    -1,    62,    63,    64,
      65,    66,    67,    -1,    69,    70,    -1,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    -1,    82,    83,    -1,
      85,    86,    87,    88,    89,    -1,    -1,    -1,    93,    -1,
      -1,    96,    -1,    98,    -1,    -1,   101,    -1,    -1,    -1,
     105,   106,   107,    -1,    -1,   110,    -1,    -1,    -1,    -1,
     115,   116,    -1,    -1,    -1,    -1,   121,   122,    -1,   124,
      -1,    -1,    -1,   128,    -1,   130,   131,   132,   133,   134,
      -1,    -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,
      -1,    -1,   147,    -1,   149,   150,    -1,   152,   153,   154,
      -1,    -1,   157,   158,    -1,   160,   161,   162,   163,   164,
     165,    -1,    -1,   168,   169,   170,   171,   172,    -1,    -1,
     175,   176,    -1,   178,   179,   180,    -1,    -1,   183,    -1,
      -1,    -1,   187,   188,    -1,   190,    -1,   192,    -1,   194,
     195,   196,   197,    -1,   199,    -1,   201,    -1,    -1,    -1,
     205,   206,    -1,   208,    -1,    -1,   211,   212,    -1,    -1,
      -1,   216,   217,   218,   219,    -1,    -1,   222,   223,   224,
      -1,    -1,   227,    -1,    -1,    -1,    -1,   232,   233,    -1,
      -1,    -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,
     245,    -1,    -1,    -1,   249,    -1,    -1,   252,   253,    -1,
      -1,   256,    -1,    -1,   259,   260,   261,    -1,    -1,    -1,
      -1,   266,   267,    -1,   269,    -1,   271,    -1,   273,   274,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   282,    -1,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,    -1,   302,   303,   304,
      -1,   306,   307,   308,   309,    -1,   311,   312,    -1,    -1,
      -1,    -1,   317,   318,   319,   320,   321,   322,    -1,    -1,
     325,   326,    -1,   328,    -1,   330,    -1,   332,   333,   334,
     335,   336,   337,   338,   339,   340,    -1,    -1,   343,   344,
      -1,    -1,   347,   348,   349,   350,    -1,    -1,    -1,   354,
     355,    -1,    -1,    -1,   359,    -1,   361,   362,   363,    -1,
     365,   366,   367,    -1,   369,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   379,   380,   381,    -1,   383,   384,
      -1,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,    -1,    -1,   398,   399,   400,    -1,   402,    -1,   404,
     405,   406,   407,   408,    -1,   410,   411,   412,    -1,    -1,
     415,    -1,    -1,    -1,   419,   420,   421,   422,   423,    -1,
      -1,   426,   427,   428,   429,   430,    -1,   432,   433,    -1,
     435,   436,   437,    -1,    -1,   440,    -1,   442,    -1,   444,
     445,    -1,   447,   448,   449,    -1,   451,    -1,    -1,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
      -1,   466,   467,    -1,    -1,    -1,   471,   472,   473,   474,
      -1,    -1,    -1,   478,    -1,    -1,    -1,   482,    -1,   484,
     485,   486,   487,    -1,   489,   490,   491,   492,   493,    -1,
      -1,    -1,    -1,    -1,   499,   500,   501,    -1,   503,   504,
      -1,   506,    -1,    -1,   509,    -1,    -1,   512,   513,   514,
     515,   516,   517,    -1,    -1,   520,   521,    -1,   523,   524,
     525,   526,   527,   528,    -1,    -1,   531,   532,   533,   534,
      -1,   536,   537,    -1,    -1,   540,   541,   542,   543,    -1,
     545,   546,   547,    -1,   549,   550,   551,   552,    -1,    -1,
      -1,    -1,    -1,   558,   559,    -1,    -1,    -1,   563,   564,
     565,   566,    -1,   568,   569,    -1,   571,   572,    -1,   574,
     575,    -1,    -1,   578,    -1,    -1,   581,    -1,   583,    -1,
     585,   586,    -1,    -1,    -1,    -1,    -1,    -1,   593,    -1,
      -1,   596,    -1,    -1,    -1,   600,   601,   602,   603,   604,
      -1,    -1,    -1,    -1,    -1,    -1,   611,   612,    -1,   614,
     615,   616,    -1,    -1,   619,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    14,    -1,    -1,    -1,    18,    -1,
      -1,    21,   637,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,
      -1,    41,    42,    43,    -1,    45,    -1,    47,    48,    -1,
      -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,    -1,
      60,    -1,    62,    63,    64,    65,    66,    67,    -1,    69,
      70,    -1,    72,    73,    74,    75,    76,    77,    78,    79,
      80,    -1,    82,    83,    -1,    85,    86,    87,    88,    89,
      -1,    -1,    -1,    93,    -1,    -1,    96,    -1,    98,    -1,
      -1,   101,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,
     110,    -1,    -1,    -1,    -1,   115,   116,    -1,    -1,    -1,
      -1,   121,   122,    -1,   124,    -1,    -1,    -1,   128,    -1,
     130,   131,   132,   133,   134,    -1,    -1,    -1,   138,    -1,
      -1,   141,   142,   143,    -1,    -1,    -1,   147,    -1,   149,
     150,    -1,   152,   153,   154,    -1,    -1,   157,   158,    -1,
     160,   161,   162,   163,   164,   165,    -1,    -1,   168,   169,
     170,   171,   172,    -1,    -1,   175,   176,    -1,   178,   179,
     180,    -1,    -1,   183,    -1,    -1,    -1,   187,   188,    -1,
     190,    -1,   192,    -1,   194,   195,   196,   197,    -1,   199,
      -1,   201,    -1,    -1,    -1,   205,   206,    -1,   208,    -1,
      -1,   211,   212,    -1,    -1,    -1,   216,   217,   218,   219,
      -1,    -1,   222,   223,   224,    -1,    -1,   227,    -1,    -1,
      -1,    -1,   232,   233,    -1,    -1,    -1,   237,    -1,    -1,
      -1,   241,   242,    -1,   244,   245,    -1,    -1,    -1,   249,
      -1,    -1,   252,   253,    -1,    -1,   256,    -1,    -1,   259,
     260,   261,    -1,    -1,    -1,    -1,   266,   267,    -1,   269,
      -1,   271,    -1,   273,   274,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   282,    -1,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
     300,    -1,   302,   303,   304,    -1,   306,   307,   308,   309,
      -1,   311,   312,    -1,    -1,    -1,    -1,   317,   318,   319,
     320,   321,   322,    -1,    -1,   325,   326,    -1,   328,    -1,
     330,    -1,   332,   333,   334,   335,   336,   337,   338,   339,
     340,    -1,    -1,   343,   344,    -1,    -1,   347,   348,   349,
     350,    -1,    -1,    -1,   354,   355,    -1,    -1,    -1,   359,
      -1,   361,   362,   363,    -1,   365,   366,   367,    -1,   369,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,
     380,   381,    -1,   383,   384,    -1,   386,   387,   388,   389,
     390,   391,   392,   393,   394,   395,    -1,    -1,   398,   399,
     400,    -1,   402,    -1,   404,   405,   406,   407,   408,    -1,
     410,   411,   412,    -1,    -1,   415,    -1,    -1,    -1,   419,
     420,   421,   422,   423,    -1,    -1,   426,   427,   428,   429,
     430,    -1,   432,   433,    -1,   435,   436,   437,    -1,    -1,
     440,    -1,   442,    -1,   444,   445,    -1,   447,   448,   449,
      -1,   451,    -1,    -1,   454,   455,   456,   457,   458,   459,
     460,   461,   462,   463,   464,    -1,   466,   467,    -1,    -1,
      -1,   471,   472,   473,   474,    -1,    -1,    -1,   478,    -1,
      -1,    -1,   482,    -1,   484,   485,   486,   487,    -1,   489,
     490,   491,   492,   493,    -1,    -1,    -1,    -1,    -1,   499,
     500,   501,    -1,   503,   504,    -1,   506,    -1,    -1,   509,
      -1,    -1,   512,   513,   514,   515,   516,   517,    -1,    -1,
     520,   521,    -1,   523,   524,   525,   526,   527,   528,    -1,
      -1,   531,   532,   533,   534,    -1,   536,   537,    -1,    -1,
     540,   541,   542,   543,    -1,   545,   546,   547,    -1,   549,
     550,   551,   552,    -1,    -1,    -1,    -1,    -1,   558,   559,
      -1,    -1,    -1,   563,   564,   565,   566,    -1,   568,   569,
      -1,   571,   572,    -1,   574,   575,    -1,    -1,   578,    -1,
      -1,   581,    -1,   583,    -1,   585,   586,    -1,    -1,    -1,
      -1,    -1,    -1,   593,    -1,    -1,   596,    -1,    -1,    -1,
     600,   601,   602,   603,   604,    -1,    -1,    -1,    -1,    -1,
      -1,   611,   612,    -1,   614,   615,   616,    -1,    -1,   619,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    14,
      -1,    -1,    -1,    18,    -1,    -1,    21,   637,    23,    24,
      25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,    34,
      -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,
      45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,    54,
      55,    -1,    57,    58,    59,    60,    -1,    62,    63,    64,
      65,    66,    67,    -1,    69,    70,    -1,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    -1,    82,    83,    -1,
      85,    86,    87,    88,    89,    -1,    -1,    -1,    93,    -1,
      -1,    96,    -1,    98,    -1,    -1,   101,    -1,    -1,    -1,
     105,   106,   107,    -1,    -1,   110,    -1,    -1,    -1,    -1,
     115,   116,    -1,    -1,    -1,   120,   121,   122,    -1,   124,
      -1,    -1,    -1,   128,    -1,   130,   131,   132,   133,   134,
      -1,    -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,
      -1,    -1,   147,    -1,   149,   150,    -1,   152,   153,   154,
      -1,    -1,   157,   158,    -1,   160,   161,   162,   163,   164,
     165,    -1,    -1,   168,   169,   170,   171,   172,    -1,    -1,
     175,   176,    -1,   178,   179,   180,    -1,    -1,   183,    -1,
      -1,    -1,   187,   188,    -1,   190,    -1,   192,    -1,   194,
     195,   196,   197,    -1,   199,    -1,   201,    -1,    -1,    -1,
     205,   206,    -1,   208,    -1,    -1,   211,   212,    -1,    -1,
      -1,   216,   217,   218,   219,    -1,    -1,   222,   223,   224,
      -1,    -1,   227,    -1,    -1,    -1,    -1,   232,   233,    -1,
      -1,    -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,
     245,    -1,    -1,    -1,   249,    -1,    -1,   252,   253,    -1,
      -1,   256,    -1,    -1,   259,   260,    -1,    -1,    -1,    -1,
      -1,   266,   267,    -1,   269,    -1,   271,    -1,   273,   274,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   282,    -1,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,    -1,   302,   303,   304,
      -1,   306,   307,   308,   309,    -1,   311,   312,    -1,    -1,
      -1,    -1,   317,   318,   319,   320,   321,   322,    -1,    -1,
     325,   326,    -1,   328,    -1,   330,    -1,   332,   333,   334,
     335,   336,   337,   338,   339,   340,    -1,    -1,   343,   344,
      -1,    -1,   347,   348,   349,   350,    -1,    -1,    -1,   354,
     355,    -1,    -1,    -1,   359,    -1,   361,   362,   363,    -1,
     365,   366,   367,    -1,   369,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   379,   380,   381,    -1,   383,   384,
      -1,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,    -1,    -1,   398,   399,   400,    -1,   402,    -1,   404,
     405,   406,   407,   408,    -1,   410,   411,   412,    -1,    -1,
     415,    -1,    -1,    -1,   419,   420,   421,   422,   423,    -1,
      -1,   426,   427,   428,   429,   430,    -1,   432,   433,    -1,
     435,   436,   437,    -1,    -1,   440,    -1,   442,    -1,   444,
     445,    -1,   447,   448,   449,    -1,   451,    -1,    -1,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
      -1,   466,   467,    -1,    -1,    -1,   471,   472,   473,   474,
      -1,    -1,    -1,   478,    -1,    -1,    -1,   482,    -1,   484,
     485,   486,   487,    -1,   489,   490,   491,   492,   493,    -1,
      -1,    -1,    -1,    -1,   499,   500,   501,    -1,   503,   504,
      -1,   506,    -1,    -1,   509,    -1,    -1,   512,   513,   514,
     515,   516,   517,    -1,    -1,   520,   521,    -1,   523,   524,
     525,   526,   527,   528,    -1,    -1,   531,   532,   533,   534,
      -1,   536,   537,    -1,    -1,   540,   541,   542,   543,    -1,
      -1,   546,   547,    -1,   549,   550,   551,   552,    -1,    -1,
      -1,    -1,    -1,   558,   559,    -1,    -1,    -1,   563,   564,
     565,   566,    -1,   568,   569,    -1,   571,   572,    -1,   574,
     575,    -1,    -1,   578,    -1,    -1,   581,    -1,   583,    -1,
     585,   586,    -1,    -1,    -1,    -1,    -1,    -1,   593,    -1,
      -1,   596,    -1,    -1,    -1,   600,   601,   602,   603,   604,
      -1,    -1,    -1,    -1,    -1,    -1,   611,   612,    -1,   614,
     615,   616,    -1,    -1,   619,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    14,    -1,    -1,    -1,    18,    -1,
      -1,    21,   637,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,
      -1,    41,    42,    43,    -1,    45,    -1,    47,    48,    -1,
      -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,    -1,
      60,    -1,    62,    63,    64,    65,    66,    67,    -1,    69,
      70,    -1,    72,    73,    74,    75,    76,    77,    78,    79,
      80,    -1,    82,    83,    -1,    85,    86,    87,    88,    89,
      -1,    -1,    -1,    93,    -1,    -1,    96,    -1,    98,    -1,
      -1,   101,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,
     110,    -1,    -1,    -1,    -1,   115,   116,    -1,    -1,    -1,
      -1,   121,   122,    -1,   124,    -1,    -1,    -1,   128,    -1,
     130,   131,   132,   133,   134,    -1,    -1,    -1,   138,    -1,
      -1,   141,   142,   143,    -1,    -1,    -1,   147,    -1,   149,
     150,    -1,   152,   153,   154,    -1,    -1,   157,   158,    -1,
     160,   161,   162,   163,   164,   165,    -1,    -1,   168,   169,
     170,   171,   172,    -1,    -1,   175,   176,    -1,   178,   179,
     180,    -1,    -1,   183,    -1,    -1,    -1,   187,   188,    -1,
     190,    -1,   192,    -1,   194,   195,   196,   197,    -1,   199,
      -1,   201,    -1,    -1,    -1,   205,   206,    -1,   208,    -1,
      -1,   211,   212,    -1,    -1,    -1,   216,   217,   218,   219,
      -1,    -1,   222,   223,   224,    -1,    -1,   227,    -1,    -1,
      -1,    -1,   232,   233,    -1,    -1,    -1,   237,    -1,    -1,
      -1,   241,   242,    -1,   244,   245,    -1,    -1,    -1,   249,
      -1,    -1,   252,   253,    -1,    -1,   256,    -1,    -1,   259,
     260,   261,    -1,    -1,    -1,    -1,   266,   267,    -1,   269,
      -1,   271,    -1,   273,   274,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   282,    -1,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
     300,    -1,   302,   303,   304,    -1,   306,   307,   308,   309,
      -1,   311,   312,    -1,    -1,    -1,    -1,   317,   318,   319,
     320,   321,   322,    -1,    -1,   325,   326,    -1,   328,    -1,
     330,    -1,   332,   333,   334,   335,   336,   337,   338,   339,
     340,    -1,    -1,   343,   344,    -1,    -1,   347,   348,   349,
     350,    -1,    -1,    -1,   354,   355,    -1,    -1,    -1,   359,
      -1,   361,   362,   363,    -1,   365,   366,   367,    -1,   369,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,
     380,   381,    -1,   383,   384,    -1,   386,   387,   388,   389,
     390,   391,   392,   393,   394,   395,    -1,    -1,   398,   399,
     400,    -1,   402,    -1,   404,   405,   406,   407,   408,    -1,
     410,   411,   412,    -1,    -1,   415,    -1,    -1,    -1,   419,
     420,   421,   422,   423,    -1,    -1,   426,   427,   428,   429,
     430,    -1,   432,   433,    -1,   435,   436,   437,    -1,    -1,
     440,    -1,   442,    -1,   444,   445,    -1,   447,   448,   449,
      -1,   451,    -1,    -1,   454,   455,   456,   457,   458,   459,
     460,   461,   462,   463,   464,    -1,   466,   467,    -1,    -1,
      -1,   471,   472,   473,   474,    -1,    -1,    -1,   478,    -1,
      -1,    -1,   482,    -1,   484,   485,   486,   487,    -1,   489,
     490,   491,   492,   493,    -1,    -1,    -1,    -1,    -1,   499,
     500,   501,    -1,   503,   504,    -1,   506,    -1,    -1,   509,
      -1,    -1,   512,   513,   514,   515,   516,   517,    -1,    -1,
     520,   521,    -1,   523,   524,   525,   526,   527,   528,    -1,
      -1,   531,   532,   533,   534,    -1,   536,   537,    -1,    -1,
     540,   541,   542,   543,    -1,   545,   546,   547,    -1,   549,
     550,   551,   552,    -1,    -1,    -1,    -1,    -1,   558,   559,
      -1,    -1,    -1,   563,   564,   565,   566,    -1,   568,   569,
      -1,   571,   572,    -1,   574,   575,    -1,    -1,   578,    -1,
      -1,   581,    -1,   583,    -1,   585,   586,    -1,    -1,    -1,
      -1,    -1,    -1,   593,    -1,    -1,   596,    -1,    -1,    -1,
     600,   601,   602,   603,   604,    -1,    -1,    -1,    -1,    -1,
      -1,   611,   612,    -1,   614,   615,   616,    -1,    -1,   619,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    14,
      -1,    -1,    -1,    18,    -1,    -1,    21,   637,    23,    24,
      25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,    34,
      -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,
      45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,    54,
      55,    -1,    57,    58,    -1,    60,    -1,    62,    63,    64,
      65,    66,    67,    -1,    69,    70,    -1,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    -1,
      85,    86,    87,    88,    89,    -1,    -1,    -1,    93,    -1,
      -1,    96,    -1,    98,    -1,    -1,   101,    -1,    -1,    -1,
     105,   106,   107,    -1,    -1,   110,    -1,    -1,    -1,    -1,
     115,   116,    -1,    -1,    -1,    -1,   121,   122,    -1,   124,
      -1,    -1,    -1,   128,    -1,   130,   131,   132,   133,   134,
      -1,    -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,
      -1,    -1,   147,    -1,   149,   150,    -1,   152,   153,   154,
      -1,    -1,   157,   158,    -1,   160,   161,   162,   163,   164,
     165,    -1,    -1,   168,   169,   170,   171,   172,    -1,    -1,
     175,   176,    -1,   178,   179,   180,    -1,    -1,   183,    -1,
      -1,    -1,   187,   188,    -1,   190,    -1,   192,    -1,   194,
     195,   196,   197,    -1,   199,    -1,   201,    -1,    -1,    -1,
     205,   206,    -1,   208,    -1,    -1,   211,   212,    -1,    -1,
      -1,   216,   217,   218,   219,    -1,    -1,   222,   223,   224,
      -1,    -1,   227,    -1,    -1,    -1,    -1,   232,   233,    -1,
      -1,    -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,
     245,    -1,    -1,    -1,   249,    -1,    -1,   252,   253,    -1,
      -1,   256,    -1,    -1,   259,   260,    -1,    -1,    -1,    -1,
      -1,   266,   267,    -1,   269,    -1,   271,    -1,   273,   274,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   282,    -1,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,    -1,   302,   303,   304,
      -1,   306,   307,   308,   309,    -1,   311,   312,    -1,    -1,
      -1,    -1,   317,   318,   319,   320,   321,   322,    -1,    -1,
     325,   326,    -1,   328,    -1,   330,    -1,   332,   333,   334,
     335,   336,   337,   338,   339,   340,    -1,    -1,   343,   344,
      -1,    -1,   347,   348,   349,   350,    -1,    -1,    -1,   354,
     355,    -1,    -1,    -1,   359,    -1,   361,   362,   363,    -1,
     365,   366,   367,    -1,   369,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   379,   380,   381,    -1,   383,   384,
      -1,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,    -1,    -1,   398,   399,   400,    -1,   402,    -1,   404,
     405,   406,   407,   408,    -1,   410,   411,   412,    -1,    -1,
     415,    -1,    -1,    -1,   419,   420,   421,   422,   423,    -1,
      -1,   426,   427,   428,   429,   430,    -1,   432,   433,    -1,
     435,   436,   437,    -1,    -1,   440,    -1,   442,    -1,   444,
     445,    -1,   447,   448,   449,    -1,   451,    -1,    -1,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
      -1,   466,   467,    -1,    -1,    -1,   471,   472,   473,   474,
      -1,    -1,    -1,   478,    -1,    -1,    -1,   482,    -1,   484,
     485,   486,   487,    -1,   489,   490,   491,   492,   493,    -1,
      -1,    -1,    -1,    -1,   499,   500,   501,    -1,   503,   504,
      -1,   506,    -1,    -1,   509,    -1,    -1,   512,   513,   514,
     515,   516,   517,    -1,    -1,   520,   521,    -1,   523,   524,
     525,   526,   527,   528,    -1,    -1,   531,   532,   533,   534,
      -1,   536,   537,    -1,    -1,   540,   541,   542,   543,    -1,
      -1,   546,   547,    -1,   549,   550,   551,   552,    -1,    -1,
      -1,    -1,    -1,   558,   559,    -1,    -1,    -1,   563,   564,
     565,   566,    -1,   568,   569,    -1,   571,   572,    -1,   574,
     575,    -1,    -1,   578,    -1,    -1,   581,    -1,   583,    -1,
     585,   586,    -1,    -1,    -1,    -1,    -1,    -1,   593,    -1,
      -1,   596,    -1,    -1,    -1,   600,   601,   602,   603,   604,
      -1,    -1,    -1,    -1,    -1,    -1,   611,   612,    -1,   614,
     615,   616,    -1,    -1,   619,     5,    -1,     7,     8,     9,
      10,    11,    -1,    -1,    14,    -1,    -1,    -1,    18,    -1,
      -1,    21,   637,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,
      -1,    41,    42,    43,    -1,    45,    -1,    47,    48,    -1,
      -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,    -1,
      60,    -1,    62,    63,    64,    65,    66,    67,    -1,    69,
      70,    -1,    72,    73,    74,    75,    76,    77,    78,    79,
      80,    -1,    82,    83,    -1,    85,    86,    87,    88,    89,
      -1,    -1,    -1,    93,    -1,    -1,    96,    -1,    98,    -1,
      -1,   101,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,
     110,    -1,    -1,    -1,    -1,   115,   116,    -1,    -1,    -1,
      -1,   121,   122,    -1,   124,    -1,    -1,    -1,   128,    -1,
     130,   131,   132,   133,   134,    -1,    -1,    -1,   138,    -1,
      -1,   141,   142,   143,    -1,    -1,    -1,   147,    -1,   149,
     150,    -1,   152,   153,   154,    -1,    -1,   157,   158,    -1,
     160,   161,   162,   163,   164,   165,    -1,    -1,   168,   169,
     170,   171,   172,    -1,    -1,   175,   176,    -1,   178,   179,
     180,    -1,    -1,   183,    -1,    -1,    -1,   187,   188,    -1,
     190,    -1,   192,    -1,   194,   195,   196,   197,    -1,   199,
      -1,   201,    -1,    -1,    -1,   205,   206,    -1,   208,    -1,
      -1,   211,   212,    -1,    -1,    -1,   216,   217,   218,   219,
      -1,    -1,   222,   223,   224,    -1,    -1,   227,    -1,    -1,
      -1,    -1,   232,   233,    -1,    -1,    -1,   237,    -1,    -1,
      -1,   241,   242,    -1,   244,   245,    -1,    -1,    -1,   249,
      -1,    -1,   252,   253,    -1,    -1,   256,    -1,    -1,   259,
     260,    -1,    -1,    -1,    -1,    -1,   266,   267,    -1,   269,
      -1,   271,    -1,   273,   274,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   282,    -1,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
     300,    -1,   302,   303,   304,    -1,   306,   307,   308,   309,
      -1,   311,   312,    -1,    -1,    -1,    -1,   317,   318,   319,
     320,   321,   322,    -1,    -1,   325,   326,    -1,   328,    -1,
     330,    -1,   332,   333,   334,   335,   336,   337,   338,   339,
     340,    -1,    -1,   343,   344,    -1,    -1,   347,   348,   349,
     350,    -1,    -1,    -1,   354,   355,    -1,    -1,    -1,   359,
      -1,   361,   362,   363,    -1,   365,   366,   367,    -1,   369,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,
     380,   381,    -1,   383,   384,    -1,   386,   387,   388,   389,
     390,   391,   392,   393,   394,   395,    -1,    -1,   398,   399,
     400,    -1,   402,    -1,   404,   405,   406,   407,   408,    -1,
     410,   411,   412,    -1,    -1,   415,    -1,    -1,    -1,   419,
     420,   421,   422,   423,    -1,    -1,   426,   427,   428,   429,
     430,    -1,   432,   433,    -1,   435,   436,   437,    -1,    -1,
     440,    -1,   442,    -1,   444,   445,    -1,   447,   448,   449,
      -1,   451,    -1,    -1,   454,   455,   456,   457,   458,   459,
     460,   461,   462,   463,   464,    -1,   466,   467,    -1,    -1,
      -1,   471,   472,   473,   474,    -1,    -1,    -1,   478,    -1,
      -1,    -1,   482,    -1,   484,   485,   486,   487,    -1,   489,
     490,   491,   492,   493,    -1,    -1,    -1,    -1,    -1,   499,
     500,   501,    -1,   503,   504,    -1,   506,    -1,    -1,   509,
      -1,    -1,   512,   513,   514,   515,   516,   517,    -1,    -1,
     520,   521,    -1,   523,   524,   525,   526,   527,   528,    -1,
      -1,   531,   532,   533,   534,    -1,   536,   537,    -1,    -1,
     540,   541,   542,   543,    -1,    -1,   546,   547,    -1,   549,
     550,   551,   552,    -1,    -1,    -1,    -1,    -1,   558,   559,
      -1,    -1,    -1,   563,   564,   565,   566,    -1,   568,   569,
      -1,   571,   572,    -1,   574,   575,    -1,    -1,   578,    -1,
      -1,   581,    -1,   583,    -1,   585,   586,    -1,    -1,    -1,
      -1,    -1,    -1,   593,    -1,    -1,   596,    -1,    -1,    -1,
     600,   601,   602,   603,   604,    -1,    -1,    -1,    -1,    -1,
      -1,   611,   612,    -1,   614,   615,   616,    -1,    -1,   619,
       5,    -1,     7,     8,     9,    10,    11,    -1,    -1,    14,
      -1,    -1,    -1,    18,    -1,    -1,    -1,   637,    23,    24,
      25,    26,    27,    -1,    -1,    30,    -1,    -1,    -1,    34,
      -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,
      45,    -1,    -1,    -1,    -1,    -1,    51,    52,    -1,    54,
      55,    -1,    57,    -1,    -1,    -1,    -1,    62,    63,    64,
      65,    66,    67,    -1,    69,    70,    -1,    72,    73,    -1,
      75,    -1,    77,    78,    79,    80,    -1,    82,    83,    -1,
      85,    86,    87,    -1,    89,    -1,    -1,    -1,    93,    -1,
      -1,    96,    -1,    98,    -1,    -1,   101,    -1,    -1,    -1,
     105,   106,   107,    -1,    -1,   110,    -1,    -1,    -1,    -1,
     115,    -1,    -1,    -1,    -1,    -1,   121,   122,    -1,   124,
      -1,    -1,    -1,   128,    -1,   130,   131,   132,   133,   134,
      -1,    -1,    -1,    -1,    -1,    -1,   141,   142,   143,    -1,
      -1,    -1,   147,    -1,    -1,   150,    -1,   152,   153,   154,
      -1,    -1,   157,   158,    -1,   160,   161,   162,   163,   164,
      -1,    -1,    -1,   168,   169,   170,   171,   172,    -1,    -1,
     175,   176,   177,   178,   179,   180,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   188,    -1,   190,    -1,   192,    -1,   194,
     195,   196,   197,    -1,   199,    -1,   201,    -1,    -1,    -1,
      -1,   206,    -1,    -1,    -1,    -1,    -1,   212,    -1,    -1,
      -1,   216,   217,   218,   219,   220,    -1,   222,   223,   224,
      -1,    -1,   227,    -1,    -1,    -1,    -1,   232,    -1,    -1,
      -1,    -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,
     245,   246,    -1,    -1,   249,    -1,    -1,    -1,   253,    -1,
      -1,   256,   257,    -1,   259,   260,    -1,    -1,    -1,    -1,
      -1,   266,   267,    -1,   269,    -1,   271,    -1,   273,   274,
      -1,    -1,    -1,    -1,   279,    -1,    -1,   282,    -1,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,    -1,   302,   303,   304,
      -1,   306,   307,   308,   309,    -1,   311,   312,    -1,    -1,
      -1,    -1,   317,   318,   319,   320,   321,   322,    -1,    -1,
     325,   326,    -1,   328,    -1,   330,    -1,   332,   333,   334,
     335,   336,   337,   338,   339,   340,    -1,    -1,   343,   344,
      -1,    -1,   347,   348,   349,   350,    -1,    -1,    -1,    -1,
     355,    -1,    -1,    -1,   359,    -1,   361,   362,   363,    -1,
     365,   366,   367,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   380,   381,    -1,    -1,   384,
      -1,   386,   387,   388,   389,   390,   391,   392,   393,   394,
      -1,    -1,    -1,    -1,   399,   400,    -1,   402,    -1,   404,
     405,   406,   407,   408,    -1,   410,   411,   412,    -1,    -1,
     415,    -1,    -1,    -1,   419,   420,   421,   422,   423,    -1,
      -1,   426,   427,   428,   429,   430,    -1,   432,    -1,    -1,
     435,    -1,   437,   438,    -1,   440,    -1,    -1,    -1,   444,
      -1,    -1,   447,   448,   449,   450,   451,    -1,    -1,    -1,
     455,   456,   457,   458,   459,   460,   461,    -1,   463,   464,
      -1,   466,    -1,    -1,    -1,    -1,   471,   472,   473,    -1,
      -1,    -1,    -1,   478,    -1,    -1,    -1,   482,    -1,    -1,
     485,    -1,   487,    -1,   489,    -1,    -1,   492,   493,    -1,
      -1,    -1,    -1,    -1,   499,   500,   501,    -1,   503,   504,
      -1,   506,    -1,    -1,   509,    -1,    -1,   512,    -1,   514,
     515,   516,   517,    -1,    -1,    -1,   521,    -1,   523,   524,
     525,   526,   527,   528,    -1,    -1,   531,   532,   533,   534,
      -1,   536,   537,    -1,    -1,   540,   541,   542,   543,    -1,
      -1,   546,   547,    -1,   549,   550,   551,   552,    -1,    -1,
      -1,    -1,    -1,   558,   559,    -1,    -1,    -1,    -1,   564,
     565,   566,    -1,   568,   569,    -1,   571,   572,    -1,    -1,
      -1,    -1,    -1,   578,    -1,    -1,   581,    -1,    -1,    -1,
     585,   586,    -1,    -1,    -1,    -1,    -1,    -1,   593,    -1,
      -1,   596,    -1,    -1,    -1,   600,   601,   602,   603,   604,
      -1,    -1,   607,    -1,    -1,    -1,   611,    -1,    -1,   614,
      -1,   616,    -1,     5,   619,     7,     8,     9,    10,    11,
      -1,    -1,    14,    -1,    -1,    -1,    18,   632,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,    -1,
      62,    63,    64,    65,    66,    67,    -1,    69,    70,    -1,
      72,    73,    74,    75,    76,    77,    78,    79,    80,    -1,
      82,    83,    -1,    85,    86,    87,    88,    89,    -1,    -1,
      -1,    93,    -1,    -1,    96,    -1,    98,    -1,    -1,   101,
      -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,    -1,
      -1,    -1,    -1,   115,   116,    -1,    -1,    -1,    -1,   121,
     122,    -1,   124,    -1,    -1,    -1,   128,    -1,   130,   131,
     132,   133,   134,    -1,    -1,    -1,   138,    -1,    -1,   141,
     142,   143,    -1,    -1,    -1,   147,    -1,   149,   150,    -1,
     152,   153,   154,    -1,    -1,   157,   158,    -1,   160,   161,
     162,   163,   164,   165,    -1,    -1,   168,   169,   170,   171,
     172,    -1,    -1,   175,   176,    -1,   178,   179,   180,    -1,
      -1,   183,    -1,    -1,    -1,   187,   188,    -1,   190,    -1,
     192,    -1,   194,   195,   196,   197,    -1,   199,    -1,   201,
      -1,    -1,    -1,   205,   206,    -1,   208,    -1,    -1,   211,
     212,    -1,    -1,    -1,   216,   217,   218,   219,    -1,    -1,
     222,   223,   224,    -1,    -1,   227,    -1,    -1,    -1,    -1,
     232,   233,    -1,    -1,    -1,   237,    -1,    -1,    -1,   241,
     242,    -1,   244,   245,    -1,    -1,    -1,   249,    -1,    -1,
     252,   253,    -1,    -1,   256,    -1,    -1,   259,   260,    -1,
      -1,    -1,    -1,    -1,   266,   267,    -1,   269,    -1,   271,
      -1,   273,   274,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     282,    -1,   284,   285,   286,   287,   288,   289,   290,   291,
     292,   293,   294,   295,   296,   297,   298,   299,   300,    -1,
     302,   303,   304,    -1,   306,   307,   308,   309,    -1,   311,
     312,    -1,    -1,    -1,    -1,   317,   318,   319,   320,   321,
     322,    -1,    -1,   325,   326,    -1,   328,    -1,   330,    -1,
     332,   333,   334,   335,   336,   337,   338,   339,   340,    -1,
      -1,   343,   344,    -1,    -1,   347,   348,   349,   350,    -1,
      -1,    -1,   354,   355,    -1,    -1,    -1,   359,    -1,   361,
     362,   363,    -1,   365,   366,   367,    -1,   369,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,   380,   381,
      -1,   383,   384,    -1,   386,   387,   388,   389,   390,   391,
     392,   393,   394,   395,    -1,    -1,   398,   399,   400,    -1,
     402,    -1,   404,   405,   406,   407,   408,    -1,   410,   411,
     412,    -1,    -1,   415,    -1,    -1,    -1,   419,   420,   421,
     422,   423,    -1,    -1,   426,   427,   428,   429,   430,    -1,
     432,   433,    -1,   435,   436,   437,    -1,    -1,   440,    -1,
     442,    -1,   444,   445,    -1,   447,   448,   449,    -1,   451,
      -1,    -1,   454,   455,   456,   457,   458,   459,   460,   461,
     462,   463,   464,    -1,   466,   467,    -1,    -1,    -1,   471,
     472,   473,   474,    -1,    -1,    -1,   478,    -1,    -1,    -1,
     482,    -1,   484,   485,   486,   487,    -1,   489,   490,   491,
     492,   493,    -1,    -1,    -1,    -1,    -1,   499,   500,   501,
      -1,   503,   504,    -1,   506,    -1,    -1,   509,    -1,    -1,
     512,   513,   514,   515,   516,   517,    -1,    -1,   520,   521,
      -1,   523,   524,   525,   526,   527,   528,    -1,    -1,   531,
     532,   533,   534,    -1,   536,   537,    -1,    -1,   540,   541,
     542,   543,    -1,    -1,   546,   547,    -1,   549,   550,   551,
     552,    -1,    -1,    -1,    -1,    -1,   558,   559,    -1,    -1,
      -1,   563,   564,   565,   566,    -1,   568,   569,    -1,   571,
     572,    -1,   574,   575,    -1,    -1,   578,    -1,    -1,   581,
      -1,   583,    -1,   585,   586,    -1,    -1,    -1,    -1,    -1,
      -1,   593,    -1,    -1,   596,    -1,    -1,    -1,   600,   601,
     602,   603,   604,    -1,    -1,    -1,    -1,    -1,    -1,   611,
     612,    -1,   614,   615,   616,    -1,     5,   619,     7,     8,
       9,    10,    11,   625,    -1,    14,    -1,    -1,    -1,    18,
      -1,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,
      -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,    48,
      -1,    -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,
      -1,    60,    -1,    62,    63,    64,    65,    66,    67,    -1,
      69,    70,    -1,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    -1,    82,    83,    -1,    85,    86,    87,    88,
      89,    -1,    -1,    -1,    93,    -1,    -1,    96,    -1,    98,
      -1,    -1,   101,    -1,    -1,    -1,   105,   106,   107,    -1,
      -1,   110,    -1,    -1,    -1,    -1,   115,   116,    -1,    -1,
      -1,    -1,   121,   122,    -1,   124,    -1,    -1,    -1,   128,
      -1,   130,   131,   132,   133,   134,    -1,    -1,    -1,   138,
      -1,    -1,   141,   142,   143,    -1,    -1,    -1,   147,    -1,
     149,   150,    -1,   152,   153,   154,    -1,    -1,   157,   158,
      -1,   160,   161,   162,   163,   164,   165,    -1,    -1,   168,
     169,   170,   171,   172,    -1,    -1,   175,   176,    -1,   178,
     179,   180,    -1,    -1,   183,    -1,    -1,    -1,   187,   188,
      -1,   190,    -1,   192,    -1,   194,   195,   196,   197,    -1,
     199,    -1,   201,    -1,    -1,    -1,   205,   206,    -1,   208,
      -1,    -1,   211,   212,    -1,    -1,    -1,   216,   217,   218,
     219,    -1,    -1,   222,   223,   224,    -1,    -1,   227,    -1,
      -1,    -1,    -1,   232,   233,    -1,    -1,    -1,   237,    -1,
      -1,    -1,   241,   242,    -1,   244,   245,    -1,    -1,    -1,
     249,    -1,    -1,   252,   253,    -1,    -1,   256,    -1,    -1,
     259,   260,    -1,    -1,    -1,    -1,    -1,   266,   267,    -1,
     269,    -1,   271,    -1,   273,   274,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   282,    -1,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,   300,    -1,   302,   303,   304,    -1,   306,   307,   308,
     309,    -1,   311,   312,    -1,    -1,    -1,    -1,   317,   318,
     319,   320,   321,   322,    -1,    -1,   325,   326,    -1,   328,
      -1,   330,    -1,   332,   333,   334,   335,   336,   337,   338,
     339,   340,    -1,    -1,   343,   344,    -1,    -1,   347,   348,
     349,   350,    -1,    -1,    -1,   354,   355,    -1,    -1,    -1,
     359,    -1,   361,   362,   363,    -1,   365,   366,   367,    -1,
     369,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     379,   380,   381,    -1,   383,   384,    -1,   386,   387,   388,
     389,   390,   391,   392,   393,   394,   395,    -1,    -1,   398,
     399,   400,    -1,   402,    -1,   404,   405,   406,   407,   408,
      -1,   410,   411,   412,    -1,    -1,   415,    -1,    -1,    -1,
     419,   420,   421,   422,   423,    -1,    -1,   426,   427,   428,
     429,   430,    -1,   432,   433,    -1,   435,   436,   437,    -1,
      -1,   440,    -1,   442,    -1,   444,   445,    -1,   447,   448,
     449,    -1,   451,    -1,    -1,   454,   455,   456,   457,   458,
     459,   460,   461,   462,   463,   464,    -1,   466,   467,    -1,
      -1,    -1,   471,   472,   473,   474,    -1,    -1,    -1,   478,
      -1,    -1,    -1,   482,    -1,   484,   485,   486,   487,    -1,
     489,   490,   491,   492,   493,    -1,    -1,    -1,    -1,    -1,
     499,   500,   501,    -1,   503,   504,    -1,   506,    -1,    -1,
     509,    -1,    -1,   512,   513,   514,   515,   516,   517,    -1,
      -1,   520,   521,    -1,   523,   524,   525,   526,   527,   528,
      -1,    -1,   531,   532,   533,   534,    -1,   536,   537,    -1,
      -1,   540,   541,   542,   543,    -1,    -1,   546,   547,    -1,
     549,   550,   551,   552,    -1,    -1,    -1,    -1,    -1,   558,
     559,    -1,    -1,    -1,   563,   564,   565,   566,    -1,   568,
     569,    -1,   571,   572,    -1,   574,   575,    -1,    -1,   578,
      -1,    -1,   581,    -1,   583,    -1,   585,   586,    -1,    -1,
      -1,    -1,    -1,    -1,   593,    -1,    -1,   596,    -1,    -1,
      -1,   600,   601,   602,   603,   604,    -1,    -1,    -1,    -1,
      -1,    -1,   611,   612,    -1,   614,   615,   616,    -1,     5,
     619,     7,     8,     9,    10,    11,   625,    -1,    14,    -1,
      -1,    -1,    18,    -1,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    -1,    -1,    -1,    34,    -1,
      -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,
      -1,    47,    48,    -1,    -1,    51,    -1,    -1,    54,    55,
      -1,    57,    58,    -1,    60,    -1,    62,    63,    64,    65,
      66,    67,    -1,    69,    70,    -1,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    -1,    85,
      86,    87,    88,    89,    -1,    -1,    -1,    93,    -1,    -1,
      96,    -1,    98,    -1,    -1,   101,    -1,    -1,    -1,   105,
     106,   107,    -1,    -1,   110,    -1,    -1,    -1,    -1,   115,
     116,    -1,    -1,    -1,    -1,   121,   122,    -1,   124,    -1,
      -1,    -1,   128,    -1,   130,   131,   132,   133,   134,    -1,
      -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,    -1,
      -1,   147,    -1,   149,   150,    -1,   152,   153,   154,    -1,
      -1,   157,   158,    -1,   160,   161,   162,   163,   164,   165,
      -1,    -1,   168,   169,   170,   171,   172,    -1,    -1,   175,
     176,    -1,   178,   179,   180,    -1,    -1,   183,    -1,    -1,
      -1,   187,   188,    -1,   190,    -1,   192,    -1,   194,   195,
     196,   197,    -1,   199,    -1,   201,    -1,    -1,    -1,   205,
     206,    -1,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,
     216,   217,   218,   219,    -1,    -1,   222,   223,   224,    -1,
      -1,   227,    -1,    -1,    -1,    -1,   232,   233,    -1,    -1,
      -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,   245,
      -1,    -1,    -1,   249,    -1,    -1,   252,   253,    -1,    -1,
     256,    -1,    -1,   259,   260,    -1,    -1,    -1,    -1,    -1,
     266,   267,    -1,   269,    -1,   271,    -1,   273,   274,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   282,    -1,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,    -1,   302,   303,   304,    -1,
     306,   307,   308,   309,    -1,   311,   312,    -1,    -1,    -1,
      -1,   317,   318,   319,   320,   321,   322,    -1,    -1,   325,
     326,    -1,   328,    -1,   330,    -1,   332,   333,   334,   335,
     336,   337,   338,   339,   340,    -1,    -1,   343,   344,    -1,
      -1,   347,   348,   349,   350,    -1,    -1,    -1,   354,   355,
      -1,    -1,    -1,   359,    -1,   361,   362,   363,    -1,   365,
     366,   367,    -1,   369,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   379,   380,   381,    -1,   383,   384,    -1,
     386,   387,   388,   389,   390,   391,   392,   393,   394,   395,
      -1,    -1,   398,   399,   400,    -1,   402,    -1,   404,   405,
     406,   407,   408,    -1,   410,   411,   412,    -1,    -1,   415,
      -1,    -1,    -1,   419,   420,   421,   422,   423,    -1,    -1,
     426,   427,   428,   429,   430,    -1,   432,   433,    -1,   435,
     436,   437,    -1,    -1,   440,    -1,   442,    -1,   444,   445,
      -1,   447,   448,   449,    -1,   451,    -1,    -1,   454,   455,
     456,   457,   458,   459,   460,   461,   462,   463,   464,    -1,
     466,   467,    -1,    -1,    -1,   471,   472,   473,   474,    -1,
      -1,    -1,   478,    -1,    -1,    -1,   482,    -1,   484,   485,
     486,   487,    -1,   489,   490,   491,   492,   493,    -1,    -1,
      -1,    -1,    -1,   499,   500,   501,    -1,   503,   504,    -1,
     506,    -1,    -1,   509,    -1,    -1,   512,   513,   514,   515,
     516,   517,    -1,    -1,   520,   521,    -1,   523,   524,   525,
     526,   527,   528,    -1,    -1,   531,   532,   533,   534,    -1,
     536,   537,    -1,    -1,   540,   541,   542,   543,    -1,    -1,
     546,   547,    -1,   549,   550,   551,   552,    -1,    -1,    -1,
      -1,    -1,   558,   559,    -1,    -1,    -1,   563,   564,   565,
     566,    -1,   568,   569,    -1,   571,   572,    -1,   574,   575,
      -1,    -1,   578,    -1,    -1,   581,    -1,   583,    -1,   585,
     586,    -1,    -1,    -1,    -1,    -1,    -1,   593,    -1,    -1,
     596,    -1,    -1,    -1,   600,   601,   602,   603,   604,    -1,
      -1,    -1,    -1,    -1,    -1,   611,   612,    -1,   614,   615,
     616,    -1,     5,   619,     7,     8,     9,    10,    11,   625,
      -1,    14,    -1,    -1,    -1,    18,    -1,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    -1,    30,    -1,    -1,
      -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,
      43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,
      -1,    54,    55,    -1,    57,    58,    -1,    60,    -1,    62,
      63,    64,    65,    66,    67,    -1,    69,    70,    -1,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    -1,    82,
      83,    -1,    85,    86,    87,    88,    89,    -1,    -1,    -1,
      93,    -1,    -1,    96,    -1,    98,    -1,    -1,   101,    -1,
      -1,    -1,   105,   106,   107,    -1,    -1,   110,    -1,    -1,
      -1,    -1,   115,   116,    -1,    -1,    -1,    -1,   121,   122,
      -1,   124,    -1,    -1,    -1,   128,    -1,   130,   131,   132,
     133,   134,    -1,    -1,    -1,   138,    -1,    -1,   141,   142,
     143,    -1,    -1,    -1,   147,    -1,   149,   150,    -1,   152,
     153,   154,    -1,    -1,   157,   158,    -1,   160,   161,   162,
     163,   164,   165,    -1,    -1,   168,   169,   170,   171,   172,
      -1,    -1,   175,   176,    -1,   178,   179,   180,    -1,    -1,
     183,    -1,    -1,    -1,   187,   188,    -1,   190,    -1,   192,
      -1,   194,   195,   196,   197,    -1,   199,    -1,   201,    -1,
      -1,    -1,   205,   206,    -1,   208,    -1,    -1,   211,   212,
      -1,    -1,    -1,   216,   217,   218,   219,    -1,    -1,   222,
     223,   224,    -1,    -1,   227,    -1,    -1,    -1,    -1,   232,
     233,    -1,    -1,    -1,   237,    -1,    -1,    -1,   241,   242,
      -1,   244,   245,    -1,    -1,    -1,   249,    -1,    -1,   252,
     253,    -1,    -1,   256,    -1,    -1,   259,   260,    -1,    -1,
      -1,    -1,    -1,   266,   267,    -1,   269,    -1,   271,    -1,
     273,   274,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   282,
      -1,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,   300,    -1,   302,
     303,   304,    -1,   306,   307,   308,   309,    -1,   311,   312,
      -1,    -1,    -1,    -1,   317,   318,   319,   320,   321,   322,
      -1,    -1,   325,   326,    -1,   328,    -1,   330,    -1,   332,
     333,   334,   335,   336,   337,   338,   339,   340,    -1,    -1,
     343,   344,    -1,    -1,   347,   348,   349,   350,    -1,    -1,
      -1,   354,   355,    -1,    -1,    -1,   359,    -1,   361,   362,
     363,    -1,   365,   366,   367,    -1,   369,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   379,   380,   381,    -1,
     383,   384,    -1,   386,   387,   388,   389,   390,   391,   392,
     393,   394,   395,    -1,    -1,   398,   399,   400,    -1,   402,
      -1,   404,   405,   406,   407,   408,    -1,   410,   411,   412,
      -1,    -1,   415,    -1,    -1,    -1,   419,   420,   421,   422,
     423,    -1,    -1,   426,   427,   428,   429,   430,    -1,   432,
     433,    -1,   435,   436,   437,    -1,    -1,   440,    -1,   442,
      -1,   444,   445,    -1,   447,   448,   449,    -1,   451,    -1,
      -1,   454,   455,   456,   457,   458,   459,   460,   461,   462,
     463,   464,    -1,   466,   467,    -1,    -1,    -1,   471,   472,
     473,   474,    -1,    -1,    -1,   478,    -1,    -1,    -1,   482,
      -1,   484,   485,   486,   487,    -1,   489,   490,   491,   492,
     493,    -1,    -1,    -1,    -1,    -1,   499,   500,   501,    -1,
     503,   504,    -1,   506,    -1,    -1,   509,    -1,    -1,   512,
     513,   514,   515,   516,   517,    -1,    -1,   520,   521,    -1,
     523,   524,   525,   526,   527,   528,    -1,    -1,   531,   532,
     533,   534,    -1,   536,   537,    -1,    -1,   540,   541,   542,
     543,    -1,    -1,   546,   547,    -1,   549,   550,   551,   552,
      -1,    -1,    -1,    -1,    -1,   558,   559,    -1,    -1,    -1,
     563,   564,   565,   566,    -1,   568,   569,    -1,   571,   572,
      -1,   574,   575,    -1,    -1,   578,    -1,    -1,   581,    -1,
     583,    -1,   585,   586,    -1,    -1,    -1,    -1,    -1,    -1,
     593,    -1,    -1,   596,    -1,    -1,    -1,   600,   601,   602,
     603,   604,    -1,    -1,    -1,    -1,    -1,    -1,   611,   612,
      -1,   614,   615,   616,    -1,     5,   619,     7,     8,     9,
      10,    11,   625,    -1,    14,    -1,    -1,    -1,    18,    -1,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,
      -1,    41,    42,    43,    -1,    45,    -1,    47,    48,    -1,
      -1,    51,    -1,    -1,    54,    55,    -1,    57,    58,    -1,
      60,    -1,    62,    63,    64,    65,    66,    67,    -1,    69,
      70,    -1,    72,    73,    74,    75,    76,    77,    78,    79,
      80,    -1,    82,    83,    -1,    85,    86,    87,    88,    89,
      -1,    -1,    -1,    93,    -1,    -1,    96,    -1,    98,    -1,
      -1,   101,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,
     110,    -1,    -1,    -1,    -1,   115,   116,   117,    -1,    -1,
      -1,   121,   122,    -1,   124,    -1,    -1,    -1,   128,    -1,
     130,   131,   132,   133,   134,    -1,    -1,    -1,   138,    -1,
      -1,   141,   142,   143,    -1,    -1,    -1,   147,    -1,   149,
     150,    -1,   152,   153,   154,    -1,    -1,   157,   158,    -1,
     160,   161,   162,   163,   164,   165,    -1,    -1,   168,   169,
     170,   171,   172,    -1,    -1,   175,   176,    -1,   178,   179,
     180,   181,    -1,   183,    -1,    -1,    -1,   187,   188,    -1,
     190,    -1,   192,    -1,   194,   195,   196,   197,    -1,   199,
      -1,   201,    -1,    -1,    -1,   205,   206,    -1,   208,   209,
      -1,   211,   212,    -1,    -1,    -1,   216,   217,   218,   219,
      -1,    -1,   222,   223,   224,    -1,    -1,   227,    -1,    -1,
      -1,    -1,   232,   233,    -1,    -1,    -1,   237,    -1,    -1,
      -1,   241,   242,    -1,   244,   245,    -1,    -1,    -1,   249,
      -1,    -1,   252,   253,    -1,    -1,   256,    -1,    -1,   259,
     260,    -1,    -1,    -1,    -1,    -1,   266,   267,    -1,   269,
      -1,   271,    -1,   273,   274,    -1,    -1,   277,    -1,    -1,
      -1,    -1,   282,    -1,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
     300,    -1,   302,   303,   304,    -1,   306,   307,   308,   309,
      -1,   311,   312,    -1,    -1,    -1,    -1,   317,   318,   319,
     320,   321,   322,    -1,    -1,   325,   326,    -1,   328,    -1,
     330,    -1,   332,   333,   334,   335,   336,   337,   338,   339,
     340,    -1,    -1,   343,   344,    -1,    -1,   347,   348,   349,
     350,   351,   352,    -1,   354,   355,    -1,    -1,   358,   359,
      -1,   361,   362,   363,    -1,   365,   366,   367,    -1,   369,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,
     380,   381,    -1,   383,   384,    -1,   386,   387,   388,   389,
     390,   391,   392,   393,   394,   395,    -1,    -1,   398,   399,
     400,    -1,   402,    -1,   404,   405,   406,   407,   408,    -1,
     410,   411,   412,    -1,    -1,   415,    -1,    -1,    -1,   419,
     420,   421,   422,   423,    -1,    -1,   426,   427,   428,   429,
     430,    -1,   432,   433,    -1,   435,   436,   437,    -1,    -1,
     440,    -1,   442,    -1,   444,   445,    -1,   447,   448,   449,
      -1,   451,    -1,    -1,   454,   455,   456,   457,   458,   459,
     460,   461,   462,   463,   464,    -1,   466,   467,    -1,    -1,
      -1,   471,   472,   473,   474,    -1,    -1,    -1,   478,    -1,
      -1,    -1,   482,    -1,   484,   485,   486,   487,    -1,   489,
     490,   491,   492,   493,    -1,    -1,   496,   497,   498,   499,
     500,   501,    -1,   503,   504,    -1,   506,    -1,    -1,   509,
      -1,    -1,   512,   513,   514,   515,   516,   517,    -1,    -1,
     520,   521,    -1,   523,   524,   525,   526,   527,   528,    -1,
      -1,   531,   532,   533,   534,    -1,   536,   537,    -1,    -1,
     540,   541,   542,   543,    -1,    -1,   546,   547,    -1,   549,
     550,   551,   552,    -1,    -1,    -1,    -1,    -1,   558,   559,
      -1,    -1,    -1,   563,   564,   565,   566,   567,   568,   569,
      -1,   571,   572,    -1,   574,   575,    -1,    -1,   578,    -1,
      -1,   581,    -1,   583,    -1,   585,   586,    -1,    -1,    -1,
      -1,    -1,    -1,   593,    -1,    -1,   596,    -1,    -1,    -1,
     600,   601,   602,   603,   604,    -1,    -1,    -1,    -1,    -1,
      -1,   611,   612,    -1,   614,   615,   616,    -1,     5,   619,
       7,     8,     9,    10,    11,    -1,    -1,    14,    -1,    -1,
      -1,    18,    -1,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    -1,    30,    -1,    -1,    33,    34,    -1,    -1,
      -1,    38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,
      47,    48,    -1,    -1,    51,    -1,    -1,    54,    55,    -1,
      57,    58,    -1,    60,    -1,    62,    63,    64,    65,    66,
      67,    -1,    69,    70,    -1,    72,    73,    74,    75,    76,
      77,    78,    79,    80,    -1,    82,    83,    -1,    85,    86,
      87,    88,    89,    -1,    -1,    -1,    93,    -1,    -1,    96,
      -1,    98,    -1,    -1,   101,    -1,    -1,    -1,   105,   106,
     107,    -1,    -1,   110,    -1,    -1,    -1,    -1,   115,   116,
      -1,    -1,    -1,   120,   121,   122,    -1,   124,    -1,    -1,
      -1,   128,    -1,   130,   131,   132,   133,   134,    -1,    -1,
      -1,   138,    -1,    -1,   141,   142,   143,    -1,    -1,    -1,
     147,    -1,   149,   150,    -1,   152,   153,   154,   155,    -1,
     157,   158,    -1,   160,   161,   162,   163,   164,   165,    -1,
      -1,   168,   169,   170,   171,   172,    -1,    -1,   175,   176,
      -1,   178,   179,   180,    -1,    -1,   183,    -1,    -1,    -1,
     187,   188,    -1,   190,    -1,   192,    -1,   194,   195,   196,
     197,    -1,   199,    -1,   201,    -1,    -1,    -1,   205,   206,
      -1,   208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,
     217,   218,   219,    -1,    -1,   222,   223,   224,    -1,    -1,
     227,    -1,    -1,    -1,    -1,   232,   233,    -1,    -1,    -1,
     237,    -1,    -1,    -1,   241,   242,    -1,   244,   245,    -1,
      -1,    -1,   249,    -1,    -1,   252,   253,    -1,    -1,   256,
      -1,    -1,   259,   260,   261,    -1,    -1,    -1,    -1,   266,
     267,    -1,   269,    -1,   271,    -1,   273,   274,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   282,    -1,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,    -1,   302,   303,   304,    -1,   306,
     307,   308,   309,    -1,   311,   312,    -1,    -1,    -1,    -1,
     317,   318,   319,   320,   321,   322,    -1,    -1,   325,   326,
      -1,   328,    -1,   330,    -1,   332,   333,   334,   335,   336,
     337,   338,   339,   340,    -1,    -1,   343,   344,    -1,    -1,
     347,   348,   349,   350,    -1,    -1,    -1,   354,   355,    -1,
      -1,    -1,   359,    -1,   361,   362,   363,    -1,   365,   366,
     367,    -1,   369,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   379,   380,   381,    -1,   383,   384,    -1,   386,
     387,   388,   389,   390,   391,   392,   393,   394,   395,    -1,
      -1,   398,   399,   400,    -1,   402,    -1,   404,   405,   406,
     407,   408,    -1,   410,   411,   412,    -1,    -1,   415,    -1,
      -1,    -1,   419,   420,   421,   422,   423,    -1,    -1,   426,
     427,   428,   429,   430,    -1,   432,   433,    -1,   435,   436,
     437,    -1,    -1,   440,    -1,   442,    -1,   444,   445,    -1,
     447,   448,   449,    -1,   451,    -1,    -1,   454,   455,   456,
     457,   458,   459,   460,   461,   462,   463,   464,    -1,   466,
     467,    -1,    -1,    -1,   471,   472,   473,   474,    -1,    -1,
     477,   478,    -1,    -1,    -1,   482,    -1,   484,   485,   486,
     487,    -1,   489,   490,   491,   492,   493,    -1,    -1,    -1,
      -1,    -1,   499,   500,   501,    -1,   503,   504,    -1,   506,
      -1,    -1,   509,    -1,    -1,   512,   513,   514,   515,   516,
     517,    -1,    -1,   520,   521,    -1,   523,   524,   525,   526,
     527,   528,    -1,    -1,   531,   532,   533,   534,    -1,   536,
     537,    -1,    -1,   540,   541,   542,   543,    -1,   545,   546,
     547,    -1,   549,   550,   551,   552,    -1,    -1,    -1,    -1,
      -1,   558,   559,    -1,    -1,    -1,   563,   564,   565,   566,
      -1,   568,   569,    -1,   571,   572,    -1,   574,   575,    -1,
      -1,   578,    -1,    -1,   581,    -1,   583,    -1,   585,   586,
      -1,    -1,    -1,    -1,    -1,    -1,   593,    -1,    -1,   596,
      -1,    -1,    -1,   600,   601,   602,   603,   604,    -1,    -1,
      -1,    -1,    -1,    -1,   611,   612,    -1,   614,   615,   616,
      -1,     5,   619,     7,     8,     9,    10,    11,    -1,    -1,
      14,    -1,    -1,    -1,    18,    -1,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    -1,    -1,    33,
      34,    -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,
      -1,    45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,
      54,    55,    -1,    57,    58,    -1,    60,    -1,    62,    63,
      64,    65,    66,    67,    -1,    69,    70,    -1,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    -1,    82,    83,
      -1,    85,    86,    87,    88,    89,    -1,    -1,    -1,    93,
      -1,    -1,    96,    -1,    98,    -1,    -1,   101,    -1,    -1,
      -1,   105,   106,   107,    -1,    -1,   110,    -1,    -1,    -1,
      -1,   115,   116,    -1,    -1,    -1,   120,   121,   122,    -1,
     124,    -1,    -1,    -1,   128,    -1,   130,   131,   132,   133,
     134,    -1,    -1,    -1,   138,    -1,    -1,   141,   142,   143,
      -1,    -1,    -1,   147,    -1,   149,   150,    -1,   152,   153,
     154,    -1,    -1,   157,   158,    -1,   160,   161,   162,   163,
     164,   165,    -1,    -1,   168,   169,   170,   171,   172,    -1,
      -1,   175,   176,    -1,   178,   179,   180,    -1,    -1,   183,
      -1,    -1,    -1,   187,   188,    -1,   190,    -1,   192,    -1,
     194,   195,   196,   197,    -1,   199,    -1,   201,    -1,    -1,
      -1,   205,   206,    -1,   208,    -1,    -1,   211,   212,    -1,
      -1,    -1,   216,   217,   218,   219,    -1,    -1,   222,   223,
     224,    -1,    -1,   227,    -1,    -1,    -1,    -1,   232,   233,
      -1,    -1,    -1,   237,    -1,    -1,    -1,   241,   242,    -1,
     244,   245,    -1,    -1,    -1,   249,    -1,    -1,   252,   253,
      -1,    -1,   256,    -1,    -1,   259,   260,   261,    -1,    -1,
      -1,    -1,   266,   267,    -1,   269,    -1,   271,    -1,   273,
     274,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   282,    -1,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,   296,   297,   298,   299,   300,    -1,   302,   303,
     304,    -1,   306,   307,   308,   309,    -1,   311,   312,    -1,
      -1,    -1,    -1,   317,   318,   319,   320,   321,   322,    -1,
      -1,   325,   326,    -1,   328,    -1,   330,    -1,   332,   333,
     334,   335,   336,   337,   338,   339,   340,    -1,    -1,   343,
     344,    -1,    -1,   347,   348,   349,   350,    -1,    -1,    -1,
     354,   355,    -1,    -1,    -1,   359,    -1,   361,   362,   363,
      -1,   365,   366,   367,    -1,   369,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   379,   380,   381,    -1,   383,
     384,    -1,   386,   387,   388,   389,   390,   391,   392,   393,
     394,   395,    -1,    -1,   398,   399,   400,    -1,   402,    -1,
     404,   405,   406,   407,   408,    -1,   410,   411,   412,    -1,
      -1,   415,    -1,    -1,    -1,   419,   420,   421,   422,   423,
      -1,    -1,   426,   427,   428,   429,   430,    -1,   432,   433,
      -1,   435,   436,   437,    -1,    -1,   440,    -1,   442,    -1,
     444,   445,    -1,   447,   448,   449,    -1,   451,    -1,    -1,
     454,   455,   456,   457,   458,   459,   460,   461,   462,   463,
     464,    -1,   466,   467,    -1,    -1,    -1,   471,   472,   473,
     474,    -1,    -1,    -1,   478,    -1,    -1,    -1,   482,    -1,
     484,   485,   486,   487,    -1,   489,   490,   491,   492,   493,
      -1,    -1,    -1,    -1,    -1,   499,   500,   501,    -1,   503,
     504,    -1,   506,    -1,    -1,   509,    -1,    -1,   512,   513,
     514,   515,   516,   517,    -1,    -1,   520,   521,    -1,   523,
     524,   525,   526,   527,   528,    -1,    -1,   531,   532,   533,
     534,    -1,   536,   537,    -1,    -1,   540,   541,   542,   543,
      -1,   545,   546,   547,    -1,   549,   550,   551,   552,    -1,
      -1,    -1,    -1,    -1,   558,   559,    -1,    -1,    -1,   563,
     564,   565,   566,    -1,   568,   569,    -1,   571,   572,    -1,
     574,   575,    -1,    -1,   578,    -1,    -1,   581,    -1,   583,
      -1,   585,   586,    -1,    -1,    -1,    -1,    -1,    -1,   593,
      -1,    -1,   596,    -1,    -1,    -1,   600,   601,   602,   603,
     604,    -1,    -1,    -1,    -1,    -1,    -1,   611,   612,    -1,
     614,   615,   616,    -1,     5,   619,     7,     8,     9,    10,
      11,    -1,    -1,    14,    -1,    -1,    -1,    18,    -1,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      -1,    -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,
      41,    42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,
      51,    -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,
      -1,    62,    63,    64,    65,    66,    67,    -1,    69,    70,
      -1,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    -1,    85,    86,    87,    88,    89,    -1,
      -1,    -1,    93,    -1,    -1,    96,    -1,    98,    -1,    -1,
     101,    -1,    -1,    -1,   105,   106,   107,    -1,    -1,   110,
      -1,    -1,    -1,    -1,   115,   116,    -1,    -1,    -1,    -1,
     121,   122,    -1,   124,    -1,    -1,    -1,   128,    -1,   130,
     131,   132,   133,   134,    -1,    -1,    -1,   138,    -1,    -1,
     141,   142,   143,    -1,    -1,    -1,   147,    -1,   149,   150,
      -1,   152,   153,   154,    -1,    -1,   157,   158,    -1,   160,
     161,   162,   163,   164,   165,    -1,    -1,   168,   169,   170,
     171,   172,    -1,    -1,   175,   176,    -1,   178,   179,   180,
      -1,    -1,   183,    -1,    -1,    -1,   187,   188,    -1,   190,
      -1,   192,    -1,   194,   195,   196,   197,    -1,   199,    -1,
     201,    -1,    -1,    -1,   205,   206,    -1,   208,    -1,    -1,
     211,   212,    -1,    -1,    -1,   216,   217,   218,   219,    -1,
      -1,   222,   223,   224,    -1,    -1,   227,    -1,    -1,    -1,
      -1,   232,   233,    -1,    -1,    -1,   237,    -1,    -1,    -1,
     241,   242,    -1,   244,   245,    -1,    -1,    -1,   249,    -1,
      -1,   252,   253,    -1,    -1,   256,    -1,    -1,   259,   260,
      -1,    -1,    -1,    -1,    -1,   266,   267,    -1,   269,    -1,
     271,    -1,   273,   274,    -1,    -1,   277,    -1,    -1,    -1,
      -1,   282,    -1,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
      -1,   302,   303,   304,    -1,   306,   307,   308,   309,    -1,
     311,   312,    -1,    -1,    -1,    -1,   317,   318,   319,   320,
     321,   322,    -1,    -1,   325,   326,    -1,   328,    -1,   330,
      -1,   332,   333,   334,   335,   336,   337,   338,   339,   340,
      -1,    -1,   343,   344,    -1,    -1,   347,   348,   349,   350,
      -1,    -1,    -1,   354,   355,    -1,    -1,   358,   359,    -1,
     361,   362,   363,    -1,   365,   366,   367,    -1,   369,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,   380,
     381,   382,   383,   384,    -1,   386,   387,   388,   389,   390,
     391,   392,   393,   394,   395,    -1,    -1,   398,   399,   400,
      -1,   402,    -1,   404,   405,   406,   407,   408,    -1,   410,
     411,   412,    -1,    -1,   415,    -1,    -1,    -1,   419,   420,
     421,   422,   423,    -1,    -1,   426,   427,   428,   429,   430,
      -1,   432,   433,    -1,   435,   436,   437,    -1,    -1,   440,
      -1,   442,    -1,   444,   445,    -1,   447,   448,   449,    -1,
     451,    -1,    -1,   454,   455,   456,   457,   458,   459,   460,
     461,   462,   463,   464,    -1,   466,   467,    -1,    -1,    -1,
     471,   472,   473,   474,    -1,    -1,    -1,   478,    -1,    -1,
      -1,   482,    -1,   484,   485,   486,   487,    -1,   489,   490,
     491,   492,   493,    -1,    -1,    -1,    -1,    -1,   499,   500,
     501,    -1,   503,   504,    -1,   506,    -1,    -1,   509,    -1,
      -1,   512,   513,   514,   515,   516,   517,    -1,    -1,   520,
     521,    -1,   523,   524,   525,   526,   527,   528,    -1,    -1,
     531,   532,   533,   534,    -1,   536,   537,    -1,    -1,   540,
     541,   542,   543,    -1,    -1,   546,   547,    -1,   549,   550,
     551,   552,    -1,    -1,    -1,    -1,    -1,   558,   559,    -1,
      -1,    -1,   563,   564,   565,   566,   567,   568,   569,    -1,
     571,   572,    -1,   574,   575,    -1,    -1,   578,    -1,    -1,
     581,    -1,   583,    -1,   585,   586,    -1,    -1,    -1,    -1,
      -1,    -1,   593,    -1,    -1,   596,    -1,    -1,    -1,   600,
     601,   602,   603,   604,    -1,    -1,    -1,    -1,    -1,    -1,
     611,   612,    -1,   614,   615,   616,    -1,     5,   619,     7,
       8,     9,    10,    11,    -1,    -1,    14,    -1,    -1,    -1,
      18,    -1,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    -1,    -1,    33,    34,    -1,    -1,    -1,
      38,    -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,
      48,    -1,    -1,    51,    -1,    -1,    54,    55,    -1,    57,
      58,    -1,    60,    -1,    62,    63,    64,    65,    66,    67,
      -1,    69,    70,    -1,    72,    73,    74,    75,    76,    77,
      78,    79,    80,    -1,    82,    83,    -1,    85,    86,    87,
      88,    89,    -1,    -1,    -1,    93,    -1,    -1,    96,    -1,
      98,    -1,    -1,   101,    -1,    -1,    -1,   105,   106,   107,
      -1,    -1,   110,    -1,    -1,    -1,    -1,   115,   116,    -1,
      -1,    -1,   120,   121,   122,    -1,   124,    -1,    -1,    -1,
     128,    -1,   130,   131,   132,   133,   134,    -1,    -1,    -1,
     138,    -1,    -1,   141,   142,   143,    -1,    -1,    -1,   147,
      -1,   149,   150,    -1,   152,   153,   154,    -1,    -1,   157,
     158,    -1,   160,   161,   162,   163,   164,   165,    -1,    -1,
     168,   169,   170,   171,   172,    -1,    -1,   175,   176,    -1,
     178,   179,   180,    -1,    -1,   183,    -1,    -1,    -1,   187,
     188,    -1,   190,    -1,   192,    -1,   194,   195,   196,   197,
      -1,   199,    -1,   201,    -1,    -1,    -1,   205,   206,    -1,
     208,    -1,    -1,   211,   212,    -1,    -1,    -1,   216,   217,
     218,   219,    -1,    -1,   222,   223,   224,    -1,    -1,   227,
      -1,    -1,    -1,    -1,   232,   233,    -1,    -1,    -1,   237,
      -1,    -1,    -1,   241,   242,    -1,   244,   245,    -1,    -1,
      -1,   249,    -1,    -1,   252,   253,    -1,    -1,   256,    -1,
      -1,   259,   260,   261,    -1,    -1,    -1,    -1,   266,   267,
      -1,   269,    -1,   271,    -1,   273,   274,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   282,    -1,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,   300,    -1,   302,   303,   304,    -1,   306,   307,
     308,   309,    -1,   311,   312,    -1,    -1,    -1,    -1,   317,
     318,   319,   320,   321,   322,    -1,    -1,   325,   326,    -1,
     328,    -1,   330,    -1,   332,   333,   334,   335,   336,   337,
     338,   339,   340,    -1,    -1,   343,   344,    -1,    -1,   347,
     348,   349,   350,    -1,    -1,    -1,   354,   355,    -1,    -1,
      -1,   359,    -1,   361,   362,   363,    -1,   365,   366,   367,
      -1,   369,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   379,   380,   381,    -1,   383,   384,    -1,   386,   387,
     388,   389,   390,   391,   392,   393,   394,   395,    -1,    -1,
     398,   399,   400,    -1,   402,    -1,   404,   405,   406,   407,
     408,    -1,   410,   411,   412,    -1,    -1,   415,    -1,    -1,
      -1,   419,   420,   421,   422,   423,    -1,    -1,   426,   427,
     428,   429,   430,    -1,   432,   433,    -1,   435,   436,   437,
      -1,    -1,   440,    -1,   442,    -1,   444,   445,    -1,   447,
     448,   449,    -1,   451,    -1,    -1,   454,   455,   456,   457,
     458,   459,   460,   461,   462,   463,   464,    -1,   466,   467,
      -1,    -1,    -1,   471,   472,   473,   474,    -1,    -1,    -1,
     478,    -1,    -1,    -1,   482,    -1,   484,   485,   486,   487,
      -1,   489,   490,   491,   492,   493,    -1,    -1,    -1,    -1,
      -1,   499,   500,   501,    -1,   503,   504,    -1,   506,    -1,
      -1,   509,    -1,    -1,   512,   513,   514,   515,   516,   517,
      -1,    -1,   520,   521,    -1,   523,   524,   525,   526,   527,
     528,    -1,    -1,   531,   532,   533,   534,    -1,   536,   537,
      -1,    -1,   540,   541,   542,   543,    -1,   545,   546,   547,
      -1,   549,   550,   551,   552,    -1,    -1,    -1,    -1,    -1,
     558,   559,    -1,    -1,    -1,   563,   564,   565,   566,    -1,
     568,   569,    -1,   571,   572,    -1,   574,   575,    -1,    -1,
     578,    -1,    -1,   581,    -1,   583,    -1,   585,   586,    -1,
      -1,    -1,    -1,    -1,    -1,   593,    -1,    -1,   596,    -1,
      -1,    -1,   600,   601,   602,   603,   604,    -1,    -1,    -1,
      -1,    -1,    -1,   611,   612,    -1,   614,   615,   616,    -1,
       5,   619,     7,     8,     9,    10,    11,    -1,    -1,    14,
      -1,    -1,    -1,    18,    -1,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    -1,    -1,    -1,    34,
      -1,    -1,    -1,    38,    -1,    -1,    41,    42,    43,    -1,
      45,    -1,    47,    48,    -1,    -1,    51,    -1,    -1,    54,
      55,    -1,    57,    58,    -1,    60,    -1,    62,    63,    64,
      65,    66,    67,    -1,    69,    70,    -1,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    -1,    82,    83,    -1,
      85,    86,    87,    88,    89,    -1,    -1,    -1,    93,    -1,
      -1,    96,    -1,    98,    99,    -1,   101,    -1,    -1,    -1,
     105,   106,   107,    -1,    -1,   110,    -1,    -1,    -1,    -1,
     115,   116,    -1,    -1,    -1,    -1,   121,   122,    -1,   124,
      -1,    -1,    -1,   128,    -1,   130,   131,   132,   133,   134,
      -1,    -1,    -1,   138,    -1,    -1,   141,   142,   143,    -1,
      -1,    -1,   147,    -1,   149,   150,    -1,   152,   153,   154,
      -1,    -1,   157,   158,    -1,   160,   161,   162,   163,   164,
     165,    -1,    -1,   168,   169,   170,   171,   172,    -1,    -1,
     175,   176,    -1,   178,   179,   180,    -1,    -1,   183,    -1,
      -1,    -1,   187,   188,    -1,   190,    -1,   192,    -1,   194,
     195,   196,   197,    -1,   199,    -1,   201,    -1,    -1,    -1,
     205,   206,    -1,   208,    -1,    -1,   211,   212,    -1,    -1,
      -1,   216,   217,   218,   219,    -1,    -1,   222,   223,   224,
      -1,    -1,   227,    -1,    -1,    -1,    -1,   232,   233,    -1,
      -1,    -1,   237,    -1,    -1,    -1,   241,   242,    -1,   244,
     245,    -1,    -1,    -1,   249,    -1,    -1,   252,   253,    -1,
      -1,   256,    -1,    -1,   259,   260,   261,    -1,    -1,    -1,
      -1,   266,   267,    -1,   269,    -1,   271,    -1,   273,   274,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   282,    -1,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,    -1,   302,   303,   304,
      -1,   306,   307,   308,   309,    -1,   311,   312,    -1,    -1,
      -1,    -1,   317,   318,   319,   320,   321,   322,    -1,    -1,
     325,   326,    -1,   328,    -1,   330,    -1,   332,   333,   334,
     335,   336,   337,   338,   339,   340,    -1,    -1,   343,   344,
      -1,    -1,   347,   348,   349,   350,    -1,    -1,    -1,   354,
     355,    -1,    -1,    -1,   359,    -1,   361,   362,   363,    -1,
     365,   366,   367,    -1,   369,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   379,   380,   381,    -1,   383,   384,
      -1,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,    -1,    -1,   398,   399,   400,    -1,   402,    -1,   404,
     405,   406,   407,   408,    -1,   410,   411,   412,    -1,    -1,
     415,    -1,    -1,    -1,   419,   420,   421,   422,   423,    -1,
      -1,   426,   427,   428,   429,   430,    -1,   432,   433,    -1,
     435,   436,   437,    -1,    -1,   440,    -1,   442,    -1,   444,
     445,    -1,   447,   448,   449,    -1,   451,    -1,    -1,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
      -1,   466,   467,    -1,    -1,    -1,   471,   472,   473,   474,
      -1,    -1,    -1,   478,    -1,    -1,    -1,   482,    -1,   484,
     485,   486,   487,    -1,   489,   490,   491,   492,   493,    -1,
      -1,    -1,    -1,    -1,   499,   500,   501,    -1,   503,   504,
      -1,   506,    -1,    -1,   509,    -1,    -1,   512,   513,   514,
     515,   516,   517,    -1,    -1,   520,   521,    -1,   523,   524,
     525,   526,   527,   528,    -1,    -1,   531,   532,   533,   534,
      -1,   536,   537,    -1,    -1,   540,   541,   542,   543,    -1,
     545,   546,   547,    -1,   549,   550,   551,   552,    -1,    -1,
      -1,    -1,    -1,   558,   559,    -1,    -1,    -1,   563,   564,
     565,   566,    -1,   568,   569,    -1,   571,   572,    -1,   574,
     575,    -1,    -1,   578,    -1,    -1,   581,    -1,   583,    -1,
     585,   586,    -1,    -1,    -1,    -1,    -1,    -1,   593,    -1,
      -1,   596,    -1,    -1,    -1,   600,   601,   602,   603,   604,
      -1,    -1,    -1,    -1,    -1,    -1,   611,   612,    -1,   614,
     615,   616,    -1,     5,   619,     7,     8,     9,    10,    11,
      12,    -1,    14,    -1,    -1,    -1,    18,    -1,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    -1,
      -1,    -1,    34,    -1,    -1,    -1,    38,    -1,    -1,    41,
      42,    43,    -1,    45,    -1,    47,    48,    -1,    -1,    51,
      -1,    -1,    54,    55,    -1,    57,    58,    -1,    60,    -1,
      62,    63,    64,    65,    66,    67,    -1,    69,    70,    -1,
      72,    73,    74,    75,    76,    77,    78,    79,    80,    -1,
      82,    83,    -1,    85,    86,    87,    88,    89,    -1,    -1,
      -1,    93,  