char * Chart_bundle_js_c = (char *) "/*!\n * Chart.js\n * http://chartjs.org/\n * Version: 2.7.1\n *\n * Copyright 2017 Nick Downie\n * Released under the MIT license\n * https://github.com/chartjs/Chart.js/blob/master/LICENSE.md\n */\n(function(f){if(typeof exports===\"object\"&&typeof module!==\"undefined\"){module.exports=f()}else if(typeof define===\"function\"&&define.amd){define([],f)}else{var g;if(typeof window!==\"undefined\"){g=window}else if(typeof global!==\"undefined\"){g=global}else if(typeof self!==\"undefined\"){g=self}else{g=this}g.Chart = f()}})(function(){var define,module,exports;return (function e(t,n,r){function s(o,u){if(!n[o]){if(!t[o]){var a=typeof require==\"function\"&&require;if(!u&&a)return a(o,!0);if(i)return i(o,!0);var f=new Error(\"Cannot find module '\"+o+\"'\");throw f.code=\"MODULE_NOT_FOUND\",f}var l=n[o]={exports:{}};t[o][0].call(l.exports,function(e){var n=t[o][1][e];return s(n?n:e)},l,l.exports,e,t,n,r)}return n[o].exports}var i=typeof require==\"function\"&&require;for(var o=0;o<r.length;o++)s(r[o]);return s})({1:[function(require,module,exports){\n/* MIT license */\nvar colorNames = require(5);\n\nmodule.exports = {\n   getRgba: getRgba,\n   getHsla: getHsla,\n   getRgb: getRgb,\n   getHsl: getHsl,\n   getHwb: getHwb,\n   getAlpha: getAlpha,\n\n   hexString: hexString,\n   rgbString: rgbString,\n   rgbaString: rgbaString,\n   percentString: percentString,\n   percentaString: percentaString,\n   hslString: hslString,\n   hslaString: hslaString,\n   hwbString: hwbString,\n   keyword: keyword\n}\n\nfunction getRgba(string) {\n   if (!string) {\n      return;\n   }\n   var abbr =  /^#([a-fA-F0-9]{3})$/i,\n       hex =  /^#([a-fA-F0-9]{6})$/i,\n       rgba = /^rgba?\\(\\s*([+-]?\\d+)\\s*,\\s*([+-]?\\d+)\\s*,\\s*([+-]?\\d+)\\s*(?:,\\s*([+-]?[\\d\\.]+)\\s*)?\\)$/i,\n       per = /^rgba?\\(\\s*([+-]?[\\d\\.]+)\\%\\s*,\\s*([+-]?[\\d\\.]+)\\%\\s*,\\s*([+-]?[\\d\\.]+)\\%\\s*(?:,\\s*([+-]?[\\d\\.]+)\\s*)?\\)$/i,\n       keyword = /(\\w+)/;\n\n   var rgb = [0, 0, 0],\n       a = 1,\n       match = string.match(abbr);\n   if (match) {\n      match = match[1];\n      for (var i = 0; i < rgb.length; i++) {\n         rgb[i] = parseInt(match[i] + match[i], 16);\n      }\n   }\n   else if (match = string.match(hex)) {\n      match = match[1];\n      for (var i = 0; i < rgb.length; i++) {\n         rgb[i] = parseInt(match.slice(i * 2, i * 2 + 2), 16);\n      }\n   }\n   else if (match = string.match(rgba)) {\n      for (var i = 0; i < rgb.length; i++) {\n         rgb[i] = parseInt(match[i + 1]);\n      }\n      a = parseFloat(match[4]);\n   }\n   else if (match = string.match(per)) {\n      for (var i = 0; i < rgb.length; i++) {\n         rgb[i] = Math.round(parseFloat(match[i + 1]) * 2.55);\n      }\n      a = parseFloat(match[4]);\n   }\n   else if (match = string.match(keyword)) {\n      if (match[1] == \"transparent\") {\n         return [0, 0, 0, 0];\n      }\n      rgb = colorNames[match[1]];\n      if (!rgb) {\n         return;\n      }\n   }\n\n   for (var i = 0; i < rgb.length; i++) {\n      rgb[i] = scale(rgb[i], 0, 255);\n   }\n   if (!a && a != 0) {\n      a = 1;\n   }\n   else {\n      a = scale(a, 0, 1);\n   }\n   rgb[3] = a;\n   return rgb;\n}\n\nfunction getHsla(string) {\n   if (!string) {\n      return;\n   }\n   var hsl = /^hsla?\\(\\s*([+-]?\\d+)(?:deg)?\\s*,\\s*([+-]?[\\d\\.]+)%\\s*,\\s*([+-]?[\\d\\.]+)%\\s*(?:,\\s*([+-]?[\\d\\.]+)\\s*)?\\)/;\n   var match = string.match(hsl);\n   if (match) {\n      var alpha = parseFloat(match[4]);\n      var h = scale(parseInt(match[1]), 0, 360),\n          s = scale(parseFloat(match[2]), 0, 100),\n          l = scale(parseFloat(match[3]), 0, 100),\n          a = scale(isNaN(alpha) ? 1 : alpha, 0, 1);\n      return [h, s, l, a];\n   }\n}\n\nfunction getHwb(string) {\n   if (!string) {\n      return;\n   }\n   var hwb = /^hwb\\(\\s*([+-]?\\d+)(?:deg)?\\s*,\\s*([+-]?[\\d\\.]+)%\\s*,\\s*([+-]?[\\d\\.]+)%\\s*(?:,\\s*([+-]?[\\d\\.]+)\\s*)?\\)/;\n   var match = string.match(hwb);\n   if (match) {\n    var alpha = parseFloat(match[4]);\n      var h = scale(parseInt(match[1]), 0, 360),\n          w = scale(parseFloat(match[2]), 0, 100),\n          b = scale(parseFloat(match[3]), 0, 100),\n          a = scale(isNaN(alpha) ? 1 : alpha, 0, 1);\n      return [h, w, b, a];\n   }\n}\n\nfunction getRgb(string) {\n   var rgba = getRgba(string);\n   return rgba && rgba.slice(0, 3);\n}\n\nfunction getHsl(string) {\n  var hsla = getHsla(string);\n  return hsla && hsla.slice(0, 3);\n}\n\nfunction getAlpha(string) {\n   var vals = getRgba(string);\n   if (vals) {\n      return vals[3];\n   }\n   else if (vals = getHsla(string)) {\n      return vals[3];\n   }\n   else if (vals = getHwb(string)) {\n      return vals[3];\n   }\n}\n\n// generators\nfunction hexString(rgb) {\n   return \"#\" + hexDouble(rgb[0]) + hexDouble(rgb[1])\n              + hexDouble(rgb[2]);\n}\n\nfunction rgbString(rgba, alpha) {\n   if (alpha < 1 || (rgba[3] && rgba[3] < 1)) {\n      return rgbaString(rgba, alpha);\n   }\n   return \"rgb(\" + rgba[0] + \", \" + rgba[1] + \", \" + rgba[2] + \")\";\n}\n\nfunction rgbaString(rgba, alpha) {\n   if (alpha === undefined) {\n      alpha = (rgba[3] !== undefined ? rgba[3] : 1);\n   }\n   return \"rgba(\" + rgba[0] + \", \" + rgba[1] + \", \" + rgba[2]\n           + \", \" + alpha + \")\";\n}\n\nfunction percentString(rgba, alpha) {\n   if (alpha < 1 || (rgba[3] && rgba[3] < 1)) {\n      return percentaString(rgba, alpha);\n   }\n   var r = Math.round(rgba[0]/255 * 100),\n       g = Math.round(rgba[1]/255 * 100),\n       b = Math.round(rgba[2]/255 * 100);\n\n   return \"rgb(\" + r + \"%, \" + g + \"%, \" + b + \"%)\";\n}\n\nfunction percentaString(rgba, alpha) {\n   var r = Math.round(rgba[0]/255 * 100),\n       g = Math.round(rgba[1]/255 * 100),\n       b = Math.round(rgba[2]/255 * 100);\n   return \"rgba(\" + r + \"%, \" + g + \"%, \" + b + \"%, \" + (alpha || rgba[3] || 1) + \")\";\n}\n\nfunction hslString(hsla, alpha) {\n   if (alpha < 1 || (hsla[3] && hsla[3] < 1)) {\n      return hslaString(hsla, alpha);\n   }\n   return \"hsl(\" + hsla[0] + \", \" + hsla[1] + \"%, \" + hsla[2] + \"%)\";\n}\n\nfunction hslaString(hsla, alpha) {\n   if (alpha === undefined) {\n      alpha = (hsla[3] !== undefined ? hsla[3] : 1);\n   }\n   return \"hsla(\" + hsla[0] + \", \" + hsla[1] + \"%, \" + hsla[2] + \"%, \"\n           + alpha + \")\";\n}\n\n// hwb is a bit different than rgb(a) & hsl(a) since there is no alpha specific syntax\n// (hwb have alpha optional & 1 is default value)\nfunction hwbString(hwb, alpha) {\n   if (alpha === undefined) {\n      alpha = (hwb[3] !== undefined ? hwb[3] : 1);\n   }\n   return \"hwb(\" + hwb[0] + \", \" + hwb[1] + \"%, \" + hwb[2] + \"%\"\n           + (alpha !== undefined && alpha !== 1 ? \", \" + alpha : \"\") + \")\";\n}\n\nfunction keyword(rgb) {\n  return reverseNames[rgb.slice(0, 3)];\n}\n\n// helpers\nfunction scale(num, min, max) {\n   return Math.min(Math.max(min, num), max);\n}\n\nfunction hexDouble(num) {\n  var str = num.toString(16).toUpperCase();\n  return (str.length < 2) ? \"0\" + str : str;\n}\n\n\n//create a list of reverse color names\nvar reverseNames = {};\nfor (var name in colorNames) {\n   reverseNames[colorNames[name]] = name;\n}\n\n},{\"5\":5}],2:[function(require,module,exports){\n/* MIT license */\nvar convert = require(4);\nvar string = require(1);\n\nvar Color = function (obj) {\n	if (obj instanceof Color) {\n		return obj;\n	}\n	if (!(this instanceof Color)) {\n		return new Color(obj);\n	}\n\n	this.valid = false;\n	this.values = {\n		rgb: [0, 0, 0],\n		hsl: [0, 0, 0],\n		hsv: [0, 0, 0],\n		hwb: [0, 0, 0],\n		cmyk: [0, 0, 0, 0],\n		alpha: 1\n	};\n\n	// parse Color() argument\n	var vals;\n	if (typeof obj === 'string') {\n		vals = string.getRgba(obj);\n		if (vals) {\n			this.setValues('rgb', vals);\n		} else if (vals = string.getHsla(obj)) {\n			this.setValues('hsl', vals);\n		} else if (vals = string.getHwb(obj)) {\n			this.setValues('hwb', vals);\n		}\n	} else if (typeof obj === 'object') {\n		vals = obj;\n		if (vals.r !== undefined || vals.red !== undefined) {\n			this.setValues('rgb', vals);\n		} else if (vals.l !== undefined || vals.lightness !== undefined) {\n			this.setValues('hsl', vals);\n		} else if (vals.v !== undefined || vals.value !== undefined) {\n			this.setValues('hsv', vals);\n		} else if (vals.w !== undefined || vals.whiteness !== undefined) {\n			this.setValues('hwb', vals);\n		} else if (vals.c !== undefined || vals.cyan !== undefined) {\n			this.setValues('cmyk', vals);\n		}\n	}\n};\n\nColor.prototype = {\n	isValid: function () {\n		return this.valid;\n	},\n	rgb: function () {\n		return this.setSpace('rgb', arguments);\n	},\n	hsl: function () {\n		return this.setSpace('hsl', arguments);\n	},\n	hsv: function () {\n		return this.setSpace('hsv', arguments);\n	},\n	hwb: function () {\n		return this.setSpace('hwb', arguments);\n	},\n	cmyk: function () {\n		return this.setSpace('cmyk', arguments);\n	},\n\n	rgbArray: function () {\n		return this.values.rgb;\n	},\n	hslArray: function () {\n		return this.values.hsl;\n	},\n	hsvArray: function () {\n		return this.values.hsv;\n	},\n	hwbArray: function () {\n		var values = this.values;\n		if (values.alpha !== 1) {\n			return values.hwb.concat([values.alpha]);\n		}\n		return values.hwb;\n	},\n	cmykArray: function () {\n		return this.values.cmyk;\n	},\n	rgbaArray: function () {\n		var values = this.values;\n		return values.rgb.concat([values.alpha]);\n	},\n	hslaArray: function () {\n		var values = this.values;\n		return values.hsl.concat([values.alpha]);\n	},\n	alpha: function (val) {\n		if (val === undefined) {\n			return this.values.alpha;\n		}\n		this.setValues('alpha', val);\n		return this;\n	},\n\n	red: function (val) {\n		return this.setChannel('rgb', 0, val);\n	},\n	green: function (val) {\n		return this.setChannel('rgb', 1, val);\n	},\n	blue: function (val) {\n		return this.setChannel('rgb', 2, val);\n	},\n	hue: function (val) {\n		if (val) {\n			val %= 360;\n			val = val < 0 ? 360 + val : val;\n		}\n		return this.setChannel('hsl', 0, val);\n	},\n	saturation: function (val) {\n		return this.setChannel('hsl', 1, val);\n	},\n	lightness: function (val) {\n		return this.setChannel('hsl', 2, val);\n	},\n	saturationv: function (val) {\n		return this.setChannel('hsv', 1, val);\n	},\n	whiteness: function (val) {\n		return this.setChannel('hwb', 1, val);\n	},\n	blackness: function (val) {\n		return this.setChannel('hwb', 2, val);\n	},\n	value: function (val) {\n		return this.setChannel('hsv', 2, val);\n	},\n	cyan: function (val) {\n		return this.setChannel('cmyk', 0, val);\n	},\n	magenta: function (val) {\n		return this.setChannel('cmyk', 1, val);\n	},\n	yellow: function (val) {\n		return this.setChannel('cmyk', 2, val);\n	},\n	black: function (val) {\n		return this.setChannel('cmyk', 3, val);\n	},\n\n	hexString: function () {\n		return string.hexString(this.values.rgb);\n	},\n	rgbString: function () {\n		return string.rgbString(this.values.rgb, this.values.alpha);\n	},\n	rgbaString: function () {\n		return string.rgbaString(this.values.rgb, this.values.alpha);\n	},\n	percentString: function () {\n		return string.percentString(this.values.rgb, this.values.alpha);\n	},\n	hslString: function () {\n		return string.hslString(this.values.hsl, this.values.alpha);\n	},\n	hslaString: function () {\n		return string.hslaString(this.values.hsl, this.values.alpha);\n	},\n	hwbString: function () {\n		return string.hwbString(this.values.hwb, this.values.alpha);\n	},\n	keyword: function () {\n		return string.keyword(this.values.rgb, this.values.alpha);\n	},\n\n	rgbNumber: function () {\n		var rgb = this.values.rgb;\n		return (rgb[0] << 16) | (rgb[1] << 8) | rgb[2];\n	},\n\n	luminosity: function () {\n		// http://www.w3.org/TR/WCAG20/#relativeluminancedef\n		var rgb = this.values.rgb;\n		var lum = [];\n		for (var i = 0; i < rgb.length; i++) {\n			var chan = rgb[i] / 255;\n			lum[i] = (chan <= 0.03928) ? chan / 12.92 : Math.pow(((chan + 0.055) / 1.055), 2.4);\n		}\n		return 0.2126 * lum[0] + 0.7152 * lum[1] + 0.0722 * lum[2];\n	},\n\n	contrast: function (color2) {\n		// http://www.w3.org/TR/WCAG20/#contrast-ratiodef\n		var lum1 = this.luminosity();\n		var lum2 = color2.luminosity();\n		if (lum1 > lum2) {\n			return (lum1 + 0.05) / (lum2 + 0.05);\n		}\n		return (lum2 + 0.05) / (lum1 + 0.05);\n	},\n\n	level: function (color2) {\n		var contrastRatio = this.contrast(color2);\n		if (contrastRatio >= 7.1) {\n			return 'AAA';\n		}\n\n		return (contrastRatio >= 4.5) ? 'AA' : '';\n	},\n\n	dark: function () {\n		// YIQ equation from http://24ways.org/2010/calculating-color-contrast\n		var rgb = this.values.rgb;\n		var yiq = (rgb[0] * 299 + rgb[1] * 587 + rgb[2] * 114) / 1000;\n		return yiq < 128;\n	},\n\n	light: function () {\n		return !this.dark();\n	},\n\n	negate: function () {\n		var rgb = [];\n		for (var i = 0; i < 3; i++) {\n			rgb[i] = 255 - this.values.rgb[i];\n		}\n		this.setValues('rgb', rgb);\n		return this;\n	},\n\n	lighten: function (ratio) {\n		var hsl = this.values.hsl;\n		hsl[2] += hsl[2] * ratio;\n		this.setValues('hsl', hsl);\n		return this;\n	},\n\n	darken: function (ratio) {\n		var hsl = this.values.hsl;\n		hsl[2] -= hsl[2] * ratio;\n		this.setValues('hsl', hsl);\n		return this;\n	},\n\n	saturate: function (ratio) {\n		var hsl = this.values.hsl;\n		hsl[1] += hsl[1] * ratio;\n		this.setValues('hsl', hsl);\n		return this;\n	},\n\n	desaturate: function (ratio) {\n		var hsl = this.values.hsl;\n		hsl[1] -= hsl[1] * ratio;\n		this.setValues('hsl', hsl);\n		return this;\n	},\n\n	whiten: function (ratio) {\n		var hwb = this.values.hwb;\n		hwb[1] += hwb[1] * ratio;\n		this.setValues('hwb', hwb);\n		return this;\n	},\n\n	blacken: function (ratio) {\n		var hwb = this.values.hwb;\n		hwb[2] += hwb[2] * ratio;\n		this.setValues('hwb', hwb);\n		return this;\n	},\n\n	greyscale: function () {\n		var rgb = this.values.rgb;\n		// http://en.wikipedia.org/wiki/Grayscale#Converting_color_to_grayscale\n		var val = rgb[0] * 0.3 + rgb[1] * 0.59 + rgb[2] * 0.11;\n		this.setValues('rgb', [val, val, val]);\n		return this;\n	},\n\n	clearer: function (ratio) {\n		var alpha = this.values.alpha;\n		this.setValues('alpha', alpha - (alpha * ratio));\n		return this;\n	},\n\n	opaquer: function (ratio) {\n		var alpha = this.values.alpha;\n		this.setValues('alpha', alpha + (alpha * ratio));\n		return this;\n	},\n\n	rotate: function (degrees) {\n		var hsl = this.values.hsl;\n		var hue = (hsl[0] + degrees) % 360;\n		hsl[0] = hue < 0 ? 360 + hue : hue;\n		this.setValues('hsl', hsl);\n		return this;\n	},\n\n	/**\n	 * Ported from sass implementation in C\n	 * https://github.com/sass/libsass/blob/0e6b4a2850092356aa3ece07c6b249f0221caced/functions.cpp#L209\n	 */\n	mix: function (mixinColor, weight) {\n		var color1 = this;\n		var color2 = mixinColor;\n		var p = weight === undefined ? 0.5 : weight;\n\n		var w = 2 * p - 1;\n		var a = color1.alpha() - color2.alpha();\n\n		var w1 = (((w * a === -1) ? w : (w + a) / (1 + w * a)) + 1) / 2.0;\n		var w2 = 1 - w1;\n\n		return this\n			.rgb(\n				w1 * color1.red() + w2 * color2.red(),\n				w1 * color1.green() + w2 * color2.green(),\n				w1 * color1.blue() + w2 * color2.blue()\n			)\n			.alpha(color1.alpha() * p + color2.alpha() * (1 - p));\n	},\n\n	toJSON: function () {\n		return this.rgb();\n	},\n\n	clone: function () {\n		// NOTE(SB): using node-clone creates a dependency to Buffer when using browserify,\n		// making the final build way to big to embed in Chart.js. So let's do it manually,\n		// assuming that values to clone are 1 dimension arrays containing only numbers,\n		// except 'alpha' which is a number.\n		var result = new Color();\n		var source = this.values;\n		var target = result.values;\n		var value, type;\n\n		for (var prop in source) {\n			if (source.hasOwnProperty(prop)) {\n				value = source[prop];\n				type = ({}).toString.call(value);\n				if (type === '[object Array]') {\n					target[prop] = value.slice(0);\n				} else if (type === '[object Number]') {\n					target[prop] = value;\n				} else {\n					console.error('unexpected color value:', value);\n				}\n			}\n		}\n\n		return result;\n	}\n};\n\nColor.prototype.spaces = {\n	rgb: ['red', 'green', 'blue'],\n	hsl: ['hue', 'saturation', 'lightness'],\n	hsv: ['hue', 'saturation', 'value'],\n	hwb: ['hue', 'whiteness', 'blackness'],\n	cmyk: ['cyan', 'magenta', 'yellow', 'black']\n};\n\nColor.prototype.maxes = {\n	rgb: [255, 255, 255],\n	hsl: [360, 100, 100],\n	hsv: [360, 100, 100],\n	hwb: [360, 100, 100],\n	cmyk: [100, 100, 100, 100]\n};\n\nColor.prototype.getValues = function (space) {\n	var values = this.values;\n	var vals = {};\n\n	for (var i = 0; i < space.length; i++) {\n		vals[space.charAt(i)] = values[space][i];\n	}\n\n	if (values.alpha !== 1) {\n		vals.a = values.alpha;\n	}\n\n	// {r: 255, g: 255, b: 255, a: 0.4}\n	return vals;\n};\n\nColor.prototype.setValues = function (space, vals) {\n	var values = this.values;\n	var spaces = this.spaces;\n	var maxes = this.maxes;\n	var alpha = 1;\n	var i;\n\n	this.valid = true;\n\n	if (space === 'alpha') {\n		alpha = vals;\n	} else if (vals.length) {\n		// [10, 10, 10]\n		values[space] = vals.slice(0, space.length);\n		alpha = vals[space.length];\n	} else if (vals[space.charAt(0)] !== undefined) {\n		// {r: 10, g: 10, b: 10}\n		for (i = 0; i < space.length; i++) {\n			values[space][i] = vals[space.charAt(i)];\n		}\n\n		alpha = vals.a;\n	} else if (vals[spaces[space][0]] !== undefined) {\n		// {red: 10, green: 10, blue: 10}\n		var chans = spaces[space];\n\n		for (i = 0; i < space.length; i++) {\n			values[space][i] = vals[chans[i]];\n		}\n\n		alpha = vals.alpha;\n	}\n\n	values.alpha = Math.max(0, Math.min(1, (alpha === undefined ? values.alpha : alpha)));\n\n	if (space === 'alpha') {\n		return false;\n	}\n\n	var capped;\n\n	// cap values of the space prior converting all values\n	for (i = 0; i < space.length; i++) {\n		capped = Math.max(0, Math.min(maxes[space][i], values[space][i]));\n		values[space][i] = Math.round(capped);\n	}\n\n	// convert to all the other color spaces\n	for (var sname in spaces) {\n		if (sname !== space) {\n			values[sname] = convert[space][sname](values[space]);\n		}\n	}\n\n	return true;\n};\n\nColor.prototype.setSpace = function (space, args) {\n	var vals = args[0];\n\n	if (vals === undefined) {\n		// color.rgb()\n		return this.getValues(space);\n	}\n\n	// color.rgb(10, 10, 10)\n	if (typeof vals === 'number') {\n		vals = Array.prototype.slice.call(args);\n	}\n\n	this.setValues(space, vals);\n	return this;\n};\n\nColor.prototype.setChannel = function (space, index, val) {\n	var svalues = this.values[space];\n	if (val === undefined) {\n		// color.red()\n		return svalues[index];\n	} else if (val === svalues[index]) {\n		// color.red(color.red())\n		return this;\n	}\n\n	// color.red(100)\n	svalues[index] = val;\n	this.setValues(space, svalues);\n\n	return this;\n};\n\nif (typeof window !== 'undefined') {\n	window.Color = Color;\n}\n\nmodule.exports = Color;\n\n},{\"1\":1,\"4\":4}],3:[function(require,module,exports){\n/* MIT license */\n\nmodule.exports = {\n  rgb2hsl: rgb2hsl,\n  rgb2hsv: rgb2hsv,\n  rgb2hwb: rgb2hwb,\n  rgb2cmyk: rgb2cmyk,\n  rgb2keyword: rgb2keyword,\n  rgb2xyz: rgb2xyz,\n  rgb2lab: rgb2lab,\n  rgb2lch: rgb2lch,\n\n  hsl2rgb: hsl2rgb,\n  hsl2hsv: hsl2hsv,\n  hsl2hwb: hsl2hwb,\n  hsl2cmyk: hsl2cmyk,\n  hsl2keyword: hsl2keyword,\n\n  hsv2rgb: hsv2rgb,\n  hsv2hsl: hsv2hsl,\n  hsv2hwb: hsv2hwb,\n  hsv2cmyk: hsv2cmyk,\n  hsv2keyword: hsv2keyword,\n\n  hwb2rgb: hwb2rgb,\n  hwb2hsl: hwb2hsl,\n  hwb2hsv: hwb2hsv,\n  hwb2cmyk: hwb2cmyk,\n  hwb2keyword: hwb2keyword,\n\n  cmyk2rgb: cmyk2rgb,\n  cmyk2hsl: cmyk2hsl,\n  cmyk2hsv: cmyk2hsv,\n  cmyk2hwb: cmyk2hwb,\n  cmyk2keyword: cmyk2keyword,\n\n  keyword2rgb: keyword2rgb,\n  keyword2hsl: keyword2hsl,\n  keyword2hsv: keyword2hsv,\n  keyword2hwb: keyword2hwb,\n  keyword2cmyk: keyword2cmyk,\n  keyword2lab: keyword2lab,\n  keyword2xyz: keyword2xyz,\n\n  xyz2rgb: xyz2rgb,\n  xyz2lab: xyz2lab,\n  xyz2lch: xyz2lch,\n\n  lab2xyz: lab2xyz,\n  lab2rgb: lab2rgb,\n  lab2lch: lab2lch,\n\n  lch2lab: lch2lab,\n  lch2xyz: lch2xyz,\n  lch2rgb: lch2rgb\n}\n\n\nfunction rgb2hsl(rgb) {\n  var r = rgb[0]/255,\n      g = rgb[1]/255,\n      b = rgb[2]/255,\n      min = Math.min(r, g, b),\n      max = Math.max(r, g, b),\n      delta = max - min,\n      h, s, l;\n\n  if (max == min)\n    h = 0;\n  else if (r == max)\n    h = (g - b) / delta;\n  else if (g == max)\n    h = 2 + (b - r) / delta;\n  else if (b == max)\n    h = 4 + (r - g)/ delta;\n\n  h = Math.min(h * 60, 360);\n\n  if (h < 0)\n    h += 360;\n\n  l = (min + max) / 2;\n\n  if (max == min)\n    s = 0;\n  else if (l <= 0.5)\n    s = delta / (max + min);\n  else\n    s = delta / (2 - max - min);\n\n  return [h, s * 100, l * 100];\n}\n\nfunction rgb2hsv(rgb) {\n  var r = rgb[0],\n      g = rgb[1],\n      b = rgb[2],\n      min = Math.min(r, g, b),\n      max = Math.max(r, g, b),\n      delta = max - min,\n      h, s, v;\n\n  if (max == 0)\n    s = 0;\n  else\n    s = (delta/max * 1000)/10;\n\n  if (max == min)\n    h = 0;\n  else if (r == max)\n    h = (g - b) / delta;\n  else if (g == max)\n    h = 2 + (b - r) / delta;\n  else if (b == max)\n    h = 4 + (r - g) / delta;\n\n  h = Math.min(h * 60, 360);\n\n  if (h < 0)\n    h += 360;\n\n  v = ((max / 255) * 1000) / 10;\n\n  return [h, s, v];\n}\n\nfunction rgb2hwb(rgb) {\n  var r = rgb[0],\n      g = rgb[1],\n      b = rgb[2],\n      h = rgb2hsl(rgb)[0],\n      w = 1/255 * Math.min(r, Math.min(g, b)),\n      b = 1 - 1/255 * Math.max(r, Math.max(g, b));\n\n  return [h, w * 100, b * 100];\n}\n\nfunction rgb2cmyk(rgb) {\n  var r = rgb[0] / 255,\n      g = rgb[1] / 255,\n      b = rgb[2] / 255,\n      c, m, y, k;\n\n  k = Math.min(1 - r, 1 - g, 1 - b);\n  c = (1 - r - k) / (1 - k) || 0;\n  m = (1 - g - k) / (1 - k) || 0;\n  y = (1 - b - k) / (1 - k) || 0;\n  return [c * 100, m * 100, y * 100, k * 100];\n}\n\nfunction rgb2keyword(rgb) {\n  return reverseKeywords[JSON.stringify(rgb)];\n}\n\nfunction rgb2xyz(rgb) {\n  var r = rgb[0] / 255,\n      g = rgb[1] / 255,\n      b = rgb[2] / 255;\n\n  // assume sRGB\n  r = r > 0.04045 ? Math.pow(((r + 0.055) / 1.055), 2.4) : (r / 12.92);\n  g = g > 0.04045 ? Math.pow(((g + 0.055) / 1.055), 2.4) : (g / 12.92);\n  b = b > 0.04045 ? Math.pow(((b + 0.055) / 1.055), 2.4) : (b / 12.92);\n\n  var x = (r * 0.4124) + (g * 0.3576) + (b * 0.1805);\n  var y = (r * 0.2126) + (g * 0.7152) + (b * 0.0722);\n  var z = (r * 0.0193) + (g * 0.1192) + (b * 0.9505);\n\n  return [x * 100, y *100, z * 100];\n}\n\nfunction rgb2lab(rgb) {\n  var xyz = rgb2xyz(rgb),\n        x = xyz[0],\n        y = xyz[1],\n        z = xyz[2],\n        l, a, b;\n\n  x /= 95.047;\n  y /= 100;\n  z /= 108.883;\n\n  x = x > 0.008856 ? Math.pow(x, 1/3) : (7.787 * x) + (16 / 116);\n  y = y > 0.008856 ? Math.pow(y, 1/3) : (7.787 * y) + (16 / 116);\n  z = z > 0.008856 ? Math.pow(z, 1/3) : (7.787 * z) + (16 / 116);\n\n  l = (116 * y) - 16;\n  a = 500 * (x - y);\n  b = 200 * (y - z);\n\n  return [l, a, b];\n}\n\nfunction rgb2lch(args) {\n  return lab2lch(rgb2lab(args));\n}\n\nfunction hsl2rgb(hsl) {\n  var h = hsl[0] / 360,\n      s = hsl[1] / 100,\n      l = hsl[2] / 100,\n      t1, t2, t3, rgb, val;\n\n  if (s == 0) {\n    val = l * 255;\n    return [val, val, val];\n  }\n\n  if (l < 0.5)\n    t2 = l * (1 + s);\n  else\n    t2 = l + s - l * s;\n  t1 = 2 * l - t2;\n\n  rgb = [0, 0, 0];\n  for (var i = 0; i < 3; i++) {\n    t3 = h + 1 / 3 * - (i - 1);\n    t3 < 0 && t3++;\n    t3 > 1 && t3--;\n\n    if (6 * t3 < 1)\n      val = t1 + (t2 - t1) * 6 * t3;\n    else if (2 * t3 < 1)\n      val = t2;\n    else if (3 * t3 < 2)\n      val = t1 + (t2 - t1) * (2 / 3 - t3) * 6;\n    else\n      val = t1;\n\n    rgb[i] = val * 255;\n  }\n\n  return rgb;\n}\n\nfunction hsl2hsv(hsl) {\n  var h = hsl[0],\n      s = hsl[1] / 100,\n      l = hsl[2] / 100,\n      sv, v;\n\n  if(l === 0) {\n      // no need to do calc on black\n      // also avoids divide by 0 error\n      return [0, 0, 0];\n  }\n\n  l *= 2;\n  s *= (l <= 1) ? l : 2 - l;\n  v = (l + s) / 2;\n  sv = (2 * s) / (l + s);\n  return [h, sv * 100, v * 100];\n}\n\nfunction hsl2hwb(args) {\n  return rgb2hwb(hsl2rgb(args));\n}\n\nfunction hsl2cmyk(args) {\n  return rgb2cmyk(hsl2rgb(args));\n}\n\nfunction hsl2keyword(args) {\n  return rgb2keyword(hsl2rgb(args));\n}\n\n\nfunction hsv2rgb(hsv) {\n  var h = hsv[0] / 60,\n      s = hsv[1] / 100,\n      v = hsv[2] / 100,\n      hi = Math.floor(h) % 6;\n\n  var f = h - Math.floor(h),\n      p = 255 * v * (1 - s),\n      q = 255 * v * (1 - (s * f)),\n      t = 255 * v * (1 - (s * (1 - f))),\n      v = 255 * v;\n\n  switch(hi) {\n    case 0:\n      return [v, t, p];\n    case 1:\n      return [q, v, p];\n    case 2:\n      return [p, v, t];\n    case 3:\n      return [p, q, v];\n    case 4:\n      return [t, p, v];\n    case 5:\n      return [v, p, q];\n  }\n}\n\nfunction hsv2hsl(hsv) {\n  var h = hsv[0],\n      s = hsv[1] / 100,\n      v = hsv[2] / 100,\n      sl, l;\n\n  l = (2 - s) * v;\n  sl = s * v;\n  sl /= (l <= 1) ? l : 2 - l;\n  sl = sl || 0;\n  l /= 2;\n  return [h, sl * 100, l * 100];\n}\n\nfunction hsv2hwb(args) {\n  return rgb2hwb(hsv2rgb(args))\n}\n\nfunction hsv2cmyk(args) {\n  return rgb2cmyk(hsv2rgb(args));\n}\n\nfunction hsv2keyword(args) {\n  return rgb2keyword(hsv2rgb(args));\n}\n\n// http://dev.w3.org/csswg/css-color/#hwb-to-rgb\nfunction hwb2rgb(hwb) {\n  var h = hwb[0] / 360,\n      wh = hwb[1] / 100,\n      bl = hwb[2] / 100,\n      ratio = wh + bl,\n      i, v, f, n;\n\n  // wh + bl cant be > 1\n  if (ratio > 1) {\n    wh /= ratio;\n    bl /= ratio;\n  }\n\n  i = Math.floor(6 * h);\n  v = 1 - bl;\n  f = 6 * h - i;\n  if ((i & 0x01) != 0) {\n    f = 1 - f;\n  }\n  n = wh + f * (v - wh);  // linear interpolation\n\n  switch (i) {\n    default:\n    case 6:\n    case 0: r = v; g = n; b = wh; break;\n    case 1: r = n; g = v; b = wh; break;\n    case 2: r = wh; g = v; b = n; break;\n    case 3: r = wh; g = n; b = v; break;\n    case 4: r = n; g = wh; b = v; break;\n    case 5: r = v; g = wh; b = n; break;\n  }\n\n  return [r * 255, g * 255, b * 255];\n}\n\nfunction hwb2hsl(args) {\n  return rgb2hsl(hwb2rgb(args));\n}\n\nfunction hwb2hsv(args) {\n  return rgb2hsv(hwb2rgb(args));\n}\n\nfunction hwb2cmyk(args) {\n  return rgb2cmyk(hwb2rgb(args));\n}\n\nfunction hwb2keyword(args) {\n  return rgb2keyword(hwb2rgb(args));\n}\n\nfunction cmyk2rgb(cmyk) {\n  var c = cmyk[0] / 100,\n      m = cmyk[1] / 100,\n      y = cmyk[2] / 100,\n      k = cmyk[3] / 100,\n      r, g, b;\n\n  r = 1 - Math.min(1, c * (1 - k) + k);\n  g = 1 - Math.min(1, m * (1 - k) + k);\n  b = 1 - Math.min(1, y * (1 - k) + k);\n  return [r * 255, g * 255, b * 255];\n}\n\nfunction cmyk2hsl(args) {\n  return rgb2hsl(cmyk2rgb(args));\n}\n\nfunction cmyk2hsv(args) {\n  return rgb2hsv(cmyk2rgb(args));\n}\n\nfunction cmyk2hwb(args) {\n  return rgb2hwb(cmyk2rgb(args));\n}\n\nfunction cmyk2keyword(args) {\n  return rgb2keyword(cmyk2rgb(args));\n}\n\n\nfunction xyz2rgb(xyz) {\n  var x = xyz[0] / 100,\n      y = xyz[1] / 100,\n      z = xyz[2] / 100,\n      r, g, b;\n\n  r = (x * 3.2406) + (y * -1.5372) + (z * -0.4986);\n  g = (x * -0.9689) + (y * 1.8758) + (z * 0.0415);\n  b = (x * 0.0557) + (y * -0.2040) + (z * 1.0570);\n\n  // assume sRGB\n  r = r > 0.0031308 ? ((1.055 * Math.pow(r, 1.0 / 2.4)) - 0.055)\n    : r = (r * 12.92);\n\n  g = g > 0.0031308 ? ((1.055 * Math.pow(g, 1.0 / 2.4)) - 0.055)\n    : g = (g * 12.92);\n\n  b = b > 0.0031308 ? ((1.055 * Math.pow(b, 1.0 / 2.4)) - 0.055)\n    : b = (b * 12.92);\n\n  r = Math.min(Math.max(0, r), 1);\n  g = Math.min(Math.max(0, g), 1);\n  b = Math.min(Math.max(0, b), 1);\n\n  return [r * 255, g * 255, b * 255];\n}\n\nfunction xyz2lab(xyz) {\n  var x = xyz[0],\n      y = xyz[1],\n      z = xyz[2],\n      l, a, b;\n\n  x /= 95.047;\n  y /= 100;\n  z /= 108.883;\n\n  x = x > 0.008856 ? Math.pow(x, 1/3) : (7.787 * x) + (16 / 116);\n  y = y > 0.008856 ? Math.pow(y, 1/3) : (7.787 * y) + (16 / 116);\n  z = z > 0.008856 ? Math.pow(z, 1/3) : (7.787 * z) + (16 / 116);\n\n  l = (116 * y) - 16;\n  a = 500 * (x - y);\n  b = 200 * (y - z);\n\n  return [l, a, b];\n}\n\nfunction xyz2lch(args) {\n  return lab2lch(xyz2lab(args));\n}\n\nfunction lab2xyz(lab) {\n  var l = lab[0],\n      a = lab[1],\n      b = lab[2],\n      x, y, z, y2;\n\n  if (l <= 8) {\n    y = (l * 100) / 903.3;\n    y2 = (7.787 * (y / 100)) + (16 / 116);\n  } else {\n    y = 100 * Math.pow((l + 16) / 116, 3);\n    y2 = Math.pow(y / 100, 1/3);\n  }\n\n  x = x / 95.047 <= 0.008856 ? x = (95.047 * ((a / 500) + y2 - (16 / 116))) / 7.787 : 95.047 * Math.pow((a / 500) + y2, 3);\n\n  z = z / 108.883 <= 0.008859 ? z = (108.883 * (y2 - (b / 200) - (16 / 116))) / 7.787 : 108.883 * Math.pow(y2 - (b / 200), 3);\n\n  return [x, y, z];\n}\n\nfunction lab2lch(lab) {\n  var l = lab[0],\n      a = lab[1],\n      b = lab[2],\n      hr, h, c;\n\n  hr = Math.atan2(b, a);\n  h = hr * 360 / 2 / Math.PI;\n  if (h < 0) {\n    h += 360;\n  }\n  c = Math.sqrt(a * a + b * b);\n  return [l, c, h];\n}\n\nfunction lab2rgb(args) {\n  return xyz2rgb(lab2xyz(args));\n}\n\nfunction lch2lab(lch) {\n  var l = lch[0],\n      c = lch[1],\n      h = lch[2],\n      a, b, hr;\n\n  hr = h / 360 * 2 * Math.PI;\n  a = c * Math.cos(hr);\n  b = c * Math.sin(hr);\n  return [l, a, b];\n}\n\nfunction lch2xyz(args) {\n  return lab2xyz(lch2lab(args));\n}\n\nfunction lch2rgb(args) {\n  return lab2rgb(lch2lab(args));\n}\n\nfunction keyword2rgb(keyword) {\n  return cssKeywords[keyword];\n}\n\nfunction keyword2hsl(args) {\n  return rgb2hsl(keyword2rgb(args));\n}\n\nfunction keyword2hsv(args) {\n  return rgb2hsv(keyword2rgb(args));\n}\n\nfunction keyword2hwb(args) {\n  return rgb2hwb(keyword2rgb(args));\n}\n\nfunction keyword2cmyk(args) {\n  return rgb2cmyk(keyword2rgb(args));\n}\n\nfunction keyword2lab(args) {\n  return rgb2lab(keyword2rgb(args));\n}\n\nfunction keyword2xyz(args) {\n  return rgb2xyz(keyword2rgb(args));\n}\n\nvar cssKeywords = {\n  aliceblue:  [240,248,255],\n  antiquewhite: [250,235,215],\n  aqua: [0,255,255],\n  aquamarine: [127,255,212],\n  azure:  [240,255,255],\n  beige:  [245,245,220],\n  bisque: [255,228,196],\n  black:  [0,0,0],\n  blanchedalmond: [255,235,205],\n  blue: [0,0,255],\n  blueviolet: [138,43,226],\n  brown:  [165,42,42],\n  burlywood:  [222,184,135],\n  cadetblue:  [95,158,160],\n  chartreuse: [127,255,0],\n  chocolate:  [210,105,30],\n  coral:  [255,127,80],\n  cornflowerblue: [100,149,237],\n  cornsilk: [255,248,220],\n  crimson:  [220,20,60],\n  cyan: [0,255,255],\n  darkblue: [0,0,139],\n  darkcyan: [0,139,139],\n  darkgoldenrod:  [184,134,11],\n  darkgray: [169,169,169],\n  darkgreen:  [0,100,0],\n  darkgrey: [169,169,169],\n  darkkhaki:  [189,183,107],\n  darkmagenta:  [139,0,139],\n  darkolivegreen: [85,107,47],\n  darkorange: [255,140,0],\n  darkorchid: [153,50,204],\n  darkred:  [139,0,0],\n  darksalmon: [233,150,122],\n  darkseagreen: [143,188,143],\n  darkslateblue:  [72,61,139],\n  darkslategray:  [47,79,79],\n  darkslategrey:  [47,79,79],\n  darkturquoise:  [0,206,209],\n  darkviolet: [148,0,211],\n  deeppink: [255,20,147],\n  deepskyblue:  [0,191,255],\n  dimgray:  [105,105,105],\n  dimgrey:  [105,105,105],\n  dodgerblue: [30,144,255],\n  firebrick:  [178,34,34],\n  floralwhite:  [255,250,240],\n  forestgreen:  [34,139,34],\n  fuchsia:  [255,0,255],\n  gainsboro:  [220,220,220],\n  ghostwhite: [248,248,255],\n  gold: [255,215,0],\n  goldenrod:  [218,165,32],\n  gray: [128,128,128],\n  green:  [0,128,0],\n  greenyellow:  [173,255,47],\n  grey: [128,128,128],\n  honeydew: [240,255,240],\n  hotpink:  [255,105,180],\n  indianred:  [205,92,92],\n  indigo: [75,0,130],\n  ivory:  [255,255,240],\n  khaki:  [240,230,140],\n  lavender: [230,230,250],\n  lavenderblush:  [255,240,245],\n  lawngreen:  [124,252,0],\n  lemonchiffon: [255,250,205],\n  lightblue:  [173,216,230],\n  lightcoral: [240,128,128],\n  lightcyan:  [224,255,255],\n  lightgoldenrodyellow: [250,250,210],\n  lightgray:  [211,211,211],\n  lightgreen: [144,238,144],\n  lightgrey:  [211,211,211],\n  lightpink:  [255,182,193],\n  lightsalmon:  [255,160,122],\n  lightseagreen:  [32,178,170],\n  lightskyblue: [135,206,250],\n  lightslategray: [119,136,153],\n  lightslategrey: [119,136,153],\n  lightsteelblue: [176,196,222],\n  lightyellow:  [255,255,224],\n  lime: [0,255,0],\n  limegreen:  [50,205,50],\n  linen:  [250,240,230],\n  magenta:  [255,0,255],\n  maroon: [128,0,0],\n  mediumaquamarine: [102,205,170],\n  mediumblue: [0,0,205],\n  mediumorchid: [186,85,211],\n  mediumpurple: [147,112,219],\n  mediumseagreen: [60,179,113],\n  mediumslateblue:  [123,104,238],\n  mediumspringgreen:  [0,250,154],\n  mediumturquoise:  [72,209,204],\n  mediumvioletred:  [199,21,133],\n  midnightblue: [25,25,112],\n  mintcream:  [245,255,250],\n  mistyrose:  [255,228,225],\n  moccasin: [255,228,181],\n  navajowhite:  [255,222,173],\n  navy: [0,0,128],\n  oldlace:  [253,245,230],\n  olive:  [128,128,0],\n  olivedrab:  [107,142,35],\n  orange: [255,165,0],\n  orangered:  [255,69,0],\n  orchid: [218,112,214],\n  palegoldenrod:  [238,232,170],\n  palegreen:  [152,251,152],\n  paleturquoise:  [175,238,238],\n  palevioletred:  [219,112,147],\n  papayawhip: [255,239,213],\n  peachpuff:  [255,218,185],\n  peru: [205,133,63],\n  pink: [255,192,203],\n  plum: [221,160,221],\n  powderblue: [176,224,230],\n  purple: [128,0,128],\n  rebeccapurple: [102, 51, 153],\n  red:  [255,0,0],\n  rosybrown:  [188,143,143],\n  royalblue:  [65,105,225],\n  saddlebrown:  [139,69,19],\n  salmon: [250,128,114],\n  sandybrown: [244,164,96],\n  seagreen: [46,139,87],\n  seashell: [255,245,238],\n  sienna: [160,82,45],\n  silver: [192,192,192],\n  skyblue:  [135,206,235],\n  slateblue:  [106,90,205],\n  slategray:  [112,128,144],\n  slategrey:  [112,128,144],\n  snow: [255,250,250],\n  springgreen:  [0,255,127],\n  steelblue:  [70,130,180],\n  tan:  [210,180,140],\n  teal: [0,128,128],\n  thistle:  [216,191,216],\n  tomato: [255,99,71],\n  turquoise:  [64,224,208],\n  violet: [238,130,238],\n  wheat:  [245,222,179],\n  white:  [255,255,255],\n  whitesmoke: [245,245,245],\n  yellow: [255,255,0],\n  yellowgreen:  [154,205,50]\n};\n\nvar reverseKeywords = {};\nfor (var key in cssKeywords) {\n  reverseKeywords[JSON.stringify(cssKeywords[key])] = key;\n}\n\n},{}],4:[function(require,module,exports){\nvar conversions = require(3);\n\nvar convert = function() {\n   return new Converter();\n}\n\nfor (var func in conversions) {\n  // export Raw versions\n  convert[func + \"Raw\"] =  (function(func) {\n    // accept array or plain args\n    return function(arg) {\n      if (typeof arg == \"number\")\n        arg = Array.prototype.slice.call(arguments);\n      return conversions[func](arg);\n    }\n  })(func);\n\n  var pair = /(\\w+)2(\\w+)/.exec(func),\n      from = pair[1],\n      to = pair[2];\n\n  // export rgb2hsl and [\"rgb\"][\"hsl\"]\n  convert[from] = convert[from] || {};\n\n  convert[from][to] = convert[func] = (function(func) { \n    return function(arg) {\n      if (typeof arg == \"number\")\n        arg = Array.prototype.slice.call(arguments);\n      \n      var val = conversions[func](arg);\n      if (typeof val == \"string\" || val === undefined)\n        return val; // keyword\n\n      for (var i = 0; i < val.length; i++)\n        val[i] = Math.round(val[i]);\n      return val;\n    }\n  })(func);\n}\n\n\n/* Converter does lazy conversion and caching */\nvar Converter = function() {\n   this.convs = {};\n};\n\n/* Either get the values for a space or\n  set the values for a space, depending on args */\nConverter.prototype.routeSpace = function(space, args) {\n   var values = args[0];\n   if (values === undefined) {\n      // color.rgb()\n      return this.getValues(space);\n   }\n   // color.rgb(10, 10, 10)\n   if (typeof values == \"number\") {\n      values = Array.prototype.slice.call(args);        \n   }\n\n   return this.setValues(space, values);\n};\n  \n/* Set the values for a space, invalidating cache */\nConverter.prototype.setValues = function(space, values) {\n   this.space = space;\n   this.convs = {};\n   this.convs[space] = values;\n   return this;\n};\n\n/* Get the values for a space. If there's already\n  a conversion for the space, fetch it, otherwise\n  compute it */\nConverter.prototype.getValues = function(space) {\n   var vals = this.convs[space];\n   if (!vals) {\n      var fspace = this.space,\n          from = this.convs[fspace];\n      vals = convert[fspace][space](from);\n\n      this.convs[space] = vals;\n   }\n  return vals;\n};\n\n[\"rgb\", \"hsl\", \"hsv\", \"cmyk\", \"keyword\"].forEach(function(space) {\n   Converter.prototype[space] = function(vals) {\n      return this.routeSpace(space, arguments);\n   }\n});\n\nmodule.exports = convert;\n},{\"3\":3}],5:[function(require,module,exports){\n'use strict'\n\nmodule.exports = {\n	\"aliceblue\": [240, 248, 255],\n	\"antiquewhite\": [250, 235, 215],\n	\"aqua\": [0, 255, 255],\n	\"aquamarine\": [127, 255, 212],\n	\"azure\": [240, 255, 255],\n	\"beige\": [245, 245, 220],\n	\"bisque\": [255, 228, 196],\n	\"black\": [0, 0, 0],\n	\"blanchedalmond\": [255, 235, 205],\n	\"blue\": [0, 0, 255],\n	\"blueviolet\": [138, 43, 226],\n	\"brown\": [165, 42, 42],\n	\"burlywood\": [222, 184, 135],\n	\"cadetblue\": [95, 158, 160],\n	\"chartreuse\": [127, 255, 0],\n	\"chocolate\": [210, 105, 30],\n	\"coral\": [255, 127, 80],\n	\"cornflowerblue\": [100, 149, 237],\n	\"cornsilk\": [255, 248, 220],\n	\"crimson\": [220, 20, 60],\n	\"cyan\": [0, 255, 255],\n	\"darkblue\": [0, 0, 139],\n	\"darkcyan\": [0, 139, 139],\n	\"darkgoldenrod\": [184, 134, 11],\n	\"darkgray\": [169, 169, 169],\n	\"darkgreen\": [0, 100, 0],\n	\"darkgrey\": [169, 169, 169],\n	\"darkkhaki\": [189, 183, 107],\n	\"darkmagenta\": [139, 0, 139],\n	\"darkolivegreen\": [85, 107, 47],\n	\"darkorange\": [255, 140, 0],\n	\"darkorchid\": [153, 50, 204],\n	\"darkred\": [139, 0, 0],\n	\"darksalmon\": [233, 150, 122],\n	\"darkseagreen\": [143, 188, 143],\n	\"darkslateblue\": [72, 61, 139],\n	\"darkslategray\": [47, 79, 79],\n	\"darkslategrey\": [47, 79, 79],\n	\"darkturquoise\": [0, 206, 209],\n	\"darkviolet\": [148, 0, 211],\n	\"deeppink\": [255, 20, 147],\n	\"deepskyblue\": [0, 191, 255],\n	\"dimgray\": [105, 105, 105],\n	\"dimgrey\": [105, 105, 105],\n	\"dodgerblue\": [30, 144, 255],\n	\"firebrick\": [178, 34, 34],\n	\"floralwhite\": [255, 250, 240],\n	\"forestgreen\": [34, 139, 34],\n	\"fuchsia\": [255, 0, 255],\n	\"gainsboro\": [220, 220, 220],\n	\"ghostwhite\": [248, 248, 255],\n	\"gold\": [255, 215, 0],\n	\"goldenrod\": [218, 165, 32],\n	\"gray\": [128, 128, 128],\n	\"green\": [0, 128, 0],\n	\"greenyellow\": [173, 255, 47],\n	\"grey\": [128, 128, 128],\n	\"honeydew\": [240, 255, 240],\n	\"hotpink\": [255, 105, 180],\n	\"indianred\": [205, 92, 92],\n	\"indigo\": [75, 0, 130],\n	\"ivory\": [255, 255, 240],\n	\"khaki\": [240, 230, 140],\n	\"lavender\": [230, 230, 250],\n	\"lavenderblush\": [255, 240, 245],\n	\"lawngreen\": [124, 252, 0],\n	\"lemonchiffon\": [255, 250, 205],\n	\"lightblue\": [173, 216, 230],\n	\"lightcoral\": [240, 128, 128],\n	\"lightcyan\": [224, 255, 255],\n	\"lightgoldenrodyellow\": [250, 250, 210],\n	\"lightgray\": [211, 211, 211],\n	\"lightgreen\": [144, 238, 144],\n	\"lightgrey\": [211, 211, 211],\n	\"lightpink\": [255, 182, 193],\n	\"lightsalmon\": [255, 160, 122],\n	\"lightseagreen\": [32, 178, 170],\n	\"lightskyblue\": [135, 206, 250],\n	\"lightslategray\": [119, 136, 153],\n	\"lightslategrey\": [119, 136, 153],\n	\"lightsteelblue\": [176, 196, 222],\n	\"lightyellow\": [255, 255, 224],\n	\"lime\": [0, 255, 0],\n	\"limegreen\": [50, 205, 50],\n	\"linen\": [250, 240, 230],\n	\"magenta\": [255, 0, 255],\n	\"maroon\": [128, 0, 0],\n	\"mediumaquamarine\": [102, 205, 170],\n	\"mediumblue\": [0, 0, 205],\n	\"mediumorchid\": [186, 85, 211],\n	\"mediumpurple\": [147, 112, 219],\n	\"mediumseagreen\": [60, 179, 113],\n	\"mediumslateblue\": [123, 104, 238],\n	\"mediumspringgreen\": [0, 250, 154],\n	\"mediumturquoise\": [72, 209, 204],\n	\"mediumvioletred\": [199, 21, 133],\n	\"midnightblue\": [25, 25, 112],\n	\"mintcream\": [245, 255, 250],\n	\"mistyrose\": [255, 228, 225],\n	\"moccasin\": [255, 228, 181],\n	\"navajowhite\": [255, 222, 173],\n	\"navy\": [0, 0, 128],\n	\"oldlace\": [253, 245, 230],\n	\"olive\": [128, 128, 0],\n	\"olivedrab\": [107, 142, 35],\n	\"orange\": [255, 165, 0],\n	\"orangered\": [255, 69, 0],\n	\"orchid\": [218, 112, 214],\n	\"palegoldenrod\": [238, 232, 170],\n	\"palegreen\": [152, 251, 152],\n	\"paleturquoise\": [175, 238, 238],\n	\"palevioletred\": [219, 112, 147],\n	\"papayawhip\": [255, 239, 213],\n	\"peachpuff\": [255, 218, 185],\n	\"peru\": [205, 133, 63],\n	\"pink\": [255, 192, 203],\n	\"plum\": [221, 160, 221],\n	\"powderblue\": [176, 224, 230],\n	\"purple\": [128, 0, 128],\n	\"rebeccapurple\": [102, 51, 153],\n	\"red\": [255, 0, 0],\n	\"rosybrown\": [188, 143, 143],\n	\"royalblue\": [65, 105, 225],\n	\"saddlebrown\": [139, 69, 19],\n	\"salmon\": [250, 128, 114],\n	\"sandybrown\": [244, 164, 96],\n	\"seagreen\": [46, 139, 87],\n	\"seashell\": [255, 245, 238],\n	\"sienna\": [160, 82, 45],\n	\"silver\": [192, 192, 192],\n	\"skyblue\": [135, 206, 235],\n	\"slateblue\": [106, 90, 205],\n	\"slategray\": [112, 128, 144],\n	\"slategrey\": [112, 128, 144],\n	\"snow\": [255, 250, 250],\n	\"springgreen\": [0, 255, 127],\n	\"steelblue\": [70, 130, 180],\n	\"tan\": [210, 180, 140],\n	\"teal\": [0, 128, 128],\n	\"thistle\": [216, 191, 216],\n	\"tomato\": [255, 99, 71],\n	\"turquoise\": [64, 224, 208],\n	\"violet\": [238, 130, 238],\n	\"wheat\": [245, 222, 179],\n	\"white\": [255, 255, 255],\n	\"whitesmoke\": [245, 245, 245],\n	\"yellow\": [255, 255, 0],\n	\"yellowgreen\": [154, 205, 50]\n};\n\n},{}],6:[function(require,module,exports){\n//! moment.js\n//! version : 2.18.1\n//! authors : Tim Wood, Iskren Chernev, Moment.js contributors\n//! license : MIT\n//! momentjs.com\n\n;(function (global, factory) {\n    typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :\n    typeof define === 'function' && define.amd ? define(factory) :\n    global.moment = factory()\n}(this, (function () { 'use strict';\n\nvar hookCallback;\n\nfunction hooks () {\n    return hookCallback.apply(null, arguments);\n}\n\n// This is done to register the method called with moment()\n// without creating circular dependencies.\nfunction setHookCallback (callback) {\n    hookCallback = callback;\n}\n\nfunction isArray(input) {\n    return input instanceof Array || Object.prototype.toString.call(input) === '[object Array]';\n}\n\nfunction isObject(input) {\n    // IE8 will treat undefined and null as object if it wasn't for\n    // input != null\n    return input != null && Object.prototype.toString.call(input) === '[object Object]';\n}\n\nfunction isObjectEmpty(obj) {\n    var k;\n    for (k in obj) {\n        // even if its not own property I'd still call it non-empty\n        return false;\n    }\n    return true;\n}\n\nfunction isUndefined(input) {\n    return input === void 0;\n}\n\nfunction isNumber(input) {\n    return typeof input === 'number' || Object.prototype.toString.call(input) === '[object Number]';\n}\n\nfunction isDate(input) {\n    return input instanceof Date || Object.prototype.toString.call(input) === '[object Date]';\n}\n\nfunction map(arr, fn) {\n    var res = [], i;\n    for (i = 0; i < arr.length; ++i) {\n        res.push(fn(arr[i], i));\n    }\n    return res;\n}\n\nfunction hasOwnProp(a, b) {\n    return Object.prototype.hasOwnProperty.call(a, b);\n}\n\nfunction extend(a, b) {\n    for (var i in b) {\n        if (hasOwnProp(b, i)) {\n            a[i] = b[i];\n        }\n    }\n\n    if (hasOwnProp(b, 'toString')) {\n        a.toString = b.toString;\n    }\n\n    if (hasOwnProp(b, 'valueOf')) {\n        a.valueOf = b.valueOf;\n    }\n\n    return a;\n}\n\nfunction createUTC (input, format, locale, strict) {\n    return createLocalOrUTC(input, format, locale, strict, true).utc();\n}\n\nfunction defaultParsingFlags() {\n    // We need to deep clone this object.\n    return {\n        empty           : false,\n        unusedTokens    : [],\n        unusedInput     : [],\n        overflow        : -2,\n        charsLeftOver   : 0,\n        nullInput       : false,\n        invalidMonth    : null,\n        invalidFormat   : false,\n        userInvalidated : false,\n        iso             : false,\n        parsedDateParts : [],\n        meridiem        : null,\n        rfc2822         : false,\n        weekdayMismatch : false\n    };\n}\n\nfunction getParsingFlags(m) {\n    if (m._pf == null) {\n        m._pf = defaultParsingFlags();\n    }\n    return m._pf;\n}\n\nvar some;\nif (Array.prototype.some) {\n    some = Array.prototype.some;\n} else {\n    some = function (fun) {\n        var t = Object(this);\n        var len = t.length >>> 0;\n\n        for (var i = 0; i < len; i++) {\n            if (i in t && fun.call(this, t[i], i, t)) {\n                return true;\n            }\n        }\n\n        return false;\n    };\n}\n\nvar some$1 = some;\n\nfunction isValid(m) {\n    if (m._isValid == null) {\n        var flags = getParsingFlags(m);\n        var parsedParts = some$1.call(flags.parsedDateParts, function (i) {\n            return i != null;\n        });\n        var isNowValid = !isNaN(m._d.getTime()) &&\n            flags.overflow < 0 &&\n            !flags.empty &&\n            !flags.invalidMonth &&\n            !flags.invalidWeekday &&\n            !flags.nullInput &&\n            !flags.invalidFormat &&\n            !flags.userInvalidated &&\n            (!flags.meridiem || (flags.meridiem && parsedParts));\n\n        if (m._strict) {\n            isNowValid = isNowValid &&\n                flags.charsLeftOver === 0 &&\n                flags.unusedTokens.length === 0 &&\n                flags.bigHour === undefined;\n        }\n\n        if (Object.isFrozen == null || !Object.isFrozen(m)) {\n            m._isValid = isNowValid;\n        }\n        else {\n            return isNowValid;\n        }\n    }\n    return m._isValid;\n}\n\nfunction createInvalid (flags) {\n    var m = createUTC(NaN);\n    if (flags != null) {\n        extend(getParsingFlags(m), flags);\n    }\n    else {\n        getParsingFlags(m).userInvalidated = true;\n    }\n\n    return m;\n}\n\n// Plugins that add properties should also add the key here (null value),\n// so we can properly clone ourselves.\nvar momentProperties = hooks.momentProperties = [];\n\nfunction copyConfig(to, from) {\n    var i, prop, val;\n\n    if (!isUndefined(from._isAMomentObject)) {\n        to._isAMomentObject = from._isAMomentObject;\n    }\n    if (!isUndefined(from._i)) {\n        to._i = from._i;\n    }\n    if (!isUndefined(from._f)) {\n        to._f = from._f;\n    }\n    if (!isUndefined(from._l)) {\n        to._l = from._l;\n    }\n    if (!isUndefined(from._strict)) {\n        to._strict = from._strict;\n    }\n    if (!isUndefined(from._tzm)) {\n        to._tzm = from._tzm;\n    }\n    if (!isUndefined(from._isUTC)) {\n        to._isUTC = from._isUTC;\n    }\n    if (!isUndefined(from._offset)) {\n        to._offset = from._offset;\n    }\n    if (!isUndefined(from._pf)) {\n        to._pf = getParsingFlags(from);\n    }\n    if (!isUndefined(from._locale)) {\n        to._locale = from._locale;\n    }\n\n    if (momentProperties.length > 0) {\n        for (i = 0; i < momentProperties.length; i++) {\n            prop = momentProperties[i];\n            val = from[prop];\n            if (!isUndefined(val)) {\n                to[prop] = val;\n            }\n        }\n    }\n\n    return to;\n}\n\nvar updateInProgress = false;\n\n// Moment prototype object\nfunction Moment(config) {\n    copyConfig(this, config);\n    this._d = new Date(config._d != null ? config._d.getTime() : NaN);\n    if (!this.isValid()) {\n        this._d = new Date(NaN);\n    }\n    // Prevent infinite loop in case updateOffset creates new moment\n    // objects.\n    if (updateInProgress === false) {\n        updateInProgress = true;\n        hooks.updateOffset(this);\n        updateInProgress = false;\n    }\n}\n\nfunction isMoment (obj) {\n    return obj instanceof Moment || (obj != null && obj._isAMomentObject != null);\n}\n\nfunction absFloor (number) {\n    if (number < 0) {\n        // -0 -> 0\n        return Math.ceil(number) || 0;\n    } else {\n        return Math.floor(number);\n    }\n}\n\nfunction toInt(argumentForCoercion) {\n    var coercedNumber = +argumentForCoercion,\n        value = 0;\n\n    if (coercedNumber !== 0 && isFinite(coercedNumber)) {\n        value = absFloor(coercedNumber);\n    }\n\n    return value;\n}\n\n// compare two arrays, return the number of differences\nfunction compareArrays(array1, array2, dontConvert) {\n    var len = Math.min(array1.length, array2.length),\n        lengthDiff = Math.abs(array1.length - array2.length),\n        diffs = 0,\n        i;\n    for (i = 0; i < len; i++) {\n        if ((dontConvert && array1[i] !== array2[i]) ||\n            (!dontConvert && toInt(array1[i]) !== toInt(array2[i]))) {\n            diffs++;\n        }\n    }\n    return diffs + lengthDiff;\n}\n\nfunction warn(msg) {\n    if (hooks.suppressDeprecationWarnings === false &&\n            (typeof console !==  'undefined') && console.warn) {\n        console.warn('Deprecation warning: ' + msg);\n    }\n}\n\nfunction deprecate(msg, fn) {\n    var firstTime = true;\n\n    return extend(function () {\n        if (hooks.deprecationHandler != null) {\n            hooks.deprecationHandler(null, msg);\n        }\n        if (firstTime) {\n            var args = [];\n            var arg;\n            for (var i = 0; i < arguments.length; i++) {\n                arg = '';\n                if (typeof arguments[i] === 'object') {\n                    arg += '\\n[' + i + '] ';\n                    for (var key in arguments[0]) {\n                        arg += key + ': ' + arguments[0][key] + ', ';\n                    }\n                    arg = arg.slice(0, -2); // Remove trailing comma and space\n                } else {\n                    arg = arguments[i];\n                }\n                args.push(arg);\n            }\n            warn(msg + '\\nArguments: ' + Array.prototype.slice.call(args).join('') + '\\n' + (new Error()).stack);\n            firstTime = false;\n        }\n        return fn.apply(this, arguments);\n    }, fn);\n}\n\nvar deprecations = {};\n\nfunction deprecateSimple(name, msg) {\n    if (hooks.deprecationHandler != null) {\n        hooks.deprecationHandler(name, msg);\n    }\n    if (!deprecations[name]) {\n        warn(msg);\n        deprecations[name] = true;\n    }\n}\n\nhooks.suppressDeprecationWarnings = false;\nhooks.deprecationHandler = null;\n\nfunction isFunction(input) {\n    return input instanceof Function || Object.prototype.toString.call(input) === '[object Function]';\n}\n\nfunction set (config) {\n    var prop, i;\n    for (i in config) {\n        prop = config[i];\n        if (isFunction(prop)) {\n            this[i] = prop;\n        } else {\n            this['_' + i] = prop;\n        }\n    }\n    this._config = config;\n    // Lenient ordinal parsing accepts just a number in addition to\n    // number + (possibly) stuff coming from _dayOfMonthOrdinalParse.\n    // TODO: Remove \"ordinalParse\" fallback in next major release.\n    this._dayOfMonthOrdinalParseLenient = new RegExp(\n        (this._dayOfMonthOrdinalParse.source || this._ordinalParse.source) +\n            '|' + (/\\d{1,2}/).source);\n}\n\nfunction mergeConfigs(parentConfig, childConfig) {\n    var res = extend({}, parentConfig), prop;\n    for (prop in childConfig) {\n        if (hasOwnProp(childConfig, prop)) {\n            if (isObject(parentConfig[prop]) && isObject(childConfig[prop])) {\n                res[prop] = {};\n                extend(res[prop], parentConfig[prop]);\n                extend(res[prop], childConfig[prop]);\n            } else if (childConfig[prop] != null) {\n                res[prop] = childConfig[prop];\n            } else {\n                delete res[prop];\n            }\n        }\n    }\n    for (prop in parentConfig) {\n        if (hasOwnProp(parentConfig, prop) &&\n                !hasOwnProp(childConfig, prop) &&\n                isObject(parentConfig[prop])) {\n            // make sure changes to properties don't modify parent config\n            res[prop] = extend({}, res[prop]);\n        }\n    }\n    return res;\n}\n\nfunction Locale(config) {\n    if (config != null) {\n        this.set(config);\n    }\n}\n\nvar keys;\n\nif (Object.keys) {\n    keys = Object.keys;\n} else {\n    keys = function (obj) {\n        var i, res = [];\n        for (i in obj) {\n            if (hasOwnProp(obj, i)) {\n                res.push(i);\n            }\n        }\n        return res;\n    };\n}\n\nvar keys$1 = keys;\n\nvar defaultCalendar = {\n    sameDay : '[Today at] LT',\n    nextDay : '[Tomorrow at] LT',\n    nextWeek : 'dddd [at] LT',\n    lastDay : '[Yesterday at] LT',\n    lastWeek : '[Last] dddd [at] LT',\n    sameElse : 'L'\n};\n\nfunction calendar (key, mom, now) {\n    var output = this._calendar[key] || this._calendar['sameElse'];\n    return isFunction(output) ? output.call(mom, now) : output;\n}\n\nvar defaultLongDateFormat = {\n    LTS  : 'h:mm:ss A',\n    LT   : 'h:mm A',\n    L    : 'MM/DD/YYYY',\n    LL   : 'MMMM D, YYYY',\n    LLL  : 'MMMM D, YYYY h:mm A',\n    LLLL : 'dddd, MMMM D, YYYY h:mm A'\n};\n\nfunction longDateFormat (key) {\n    var format = this._longDateFormat[key],\n        formatUpper = this._longDateFormat[key.toUpperCase()];\n\n    if (format || !formatUpper) {\n        return format;\n    }\n\n    this._longDateFormat[key] = formatUpper.replace(/MMMM|MM|DD|dddd/g, function (val) {\n        return val.slice(1);\n    });\n\n    return this._longDateFormat[key];\n}\n\nvar defaultInvalidDate = 'Invalid date';\n\nfunction invalidDate () {\n    return this._invalidDate;\n}\n\nvar defaultOrdinal = '%d';\nvar defaultDayOfMonthOrdinalParse = /\\d{1,2}/;\n\nfunction ordinal (number) {\n    return this._ordinal.replace('%d', number);\n}\n\nvar defaultRelativeTime = {\n    future : 'in %s',\n    past   : '%s ago',\n    s  : 'a few seconds',\n    ss : '%d seconds',\n    m  : 'a minute',\n    mm : '%d minutes',\n    h  : 'an hour',\n    hh : '%d hours',\n    d  : 'a day',\n    dd : '%d days',\n    M  : 'a month',\n    MM : '%d months',\n    y  : 'a year',\n    yy : '%d years'\n};\n\nfunction relativeTime (number, withoutSuffix, string, isFuture) {\n    var output = this._relativeTime[string];\n    return (isFunction(output)) ?\n        output(number, withoutSuffix, string, isFuture) :\n        output.replace(/%d/i, number);\n}\n\nfunction pastFuture (diff, output) {\n    var format = this._relativeTime[diff > 0 ? 'future' : 'past'];\n    return isFunction(format) ? format(output) : format.replace(/%s/i, output);\n}\n\nvar aliases = {};\n\nfunction addUnitAlias (unit, shorthand) {\n    var lowerCase = unit.toLowerCase();\n    aliases[lowerCase] = aliases[lowerCase + 's'] = aliases[shorthand] = unit;\n}\n\nfunction normalizeUnits(units) {\n    return typeof units === 'string' ? aliases[units] || aliases[units.toLowerCase()] : undefined;\n}\n\nfunction normalizeObjectUnits(inputObject) {\n    var normalizedInput = {},\n        normalizedProp,\n        prop;\n\n    for (prop in inputObject) {\n        if (hasOwnProp(inputObject, prop)) {\n            normalizedProp = normalizeUnits(prop);\n            if (normalizedProp) {\n                normalizedInput[normalizedProp] = inputObject[prop];\n            }\n        }\n    }\n\n    return normalizedInput;\n}\n\nvar priorities = {};\n\nfunction addUnitPriority(unit, priority) {\n    priorities[unit] = priority;\n}\n\nfunction getPrioritizedUnits(unitsObj) {\n    var units = [];\n    for (var u in unitsObj) {\n        units.push({unit: u, priority: priorities[u]});\n    }\n    units.sort(function (a, b) {\n        return a.priority - b.priority;\n    });\n    return units;\n}\n\nfunction makeGetSet (unit, keepTime) {\n    return function (value) {\n        if (value != null) {\n            set$1(this, unit, value);\n            hooks.updateOffset(this, keepTime);\n            return this;\n        } else {\n            return get(this, unit);\n        }\n    };\n}\n\nfunction get (mom, unit) {\n    return mom.isValid() ?\n        mom._d['get' + (mom._isUTC ? 'UTC' : '') + unit]() : NaN;\n}\n\nfunction set$1 (mom, unit, value) {\n    if (mom.isValid()) {\n        mom._d['set' + (mom._isUTC ? 'UTC' : '') + unit](value);\n    }\n}\n\n// MOMENTS\n\nfunction stringGet (units) {\n    units = normalizeUnits(units);\n    if (isFunction(this[units])) {\n        return this[units]();\n    }\n    return this;\n}\n\n\nfunction stringSet (units, value) {\n    if (typeof units === 'object') {\n        units = normalizeObjectUnits(units);\n        var prioritized = getPrioritizedUnits(units);\n        for (var i = 0; i < prioritized.length; i++) {\n            this[prioritized[i].unit](units[prioritized[i].unit]);\n        }\n    } else {\n        units = normalizeUnits(units);\n        if (isFunction(this[units])) {\n            return this[units](value);\n        }\n    }\n    return this;\n}\n\nfunction zeroFill(number, targetLength, forceSign) {\n    var absNumber = '' + Math.abs(number),\n        zerosToFill = targetLength - absNumber.length,\n        sign = number >= 0;\n    return (sign ? (forceSign ? '+' : '') : '-') +\n        Math.pow(10, Math.max(0, zerosToFill)).toString().substr(1) + absNumber;\n}\n\nvar formattingTokens = /(\\[[^\\[]*\\])|(\\\\)?([Hh]mm(ss)?|Mo|MM?M?M?|Do|DDDo|DD?D?D?|ddd?d?|do?|w[o|w]?|W[o|W]?|Qo?|YYYYYY|YYYYY|YYYY|YY|gg(ggg?)?|GG(GGG?)?|e|E|a|A|hh?|HH?|kk?|mm?|ss?|S{1,9}|x|X|zz?|ZZ?|.)/g;\n\nvar localFormattingTokens = /(\\[[^\\[]*\\])|(\\\\)?(LTS|LT|LL?L?L?|l{1,4})/g;\n\nvar formatFunctions = {};\n\nvar formatTokenFunctions = {};\n\n// token:    'M'\n// padded:   ['MM', 2]\n// ordinal:  'Mo'\n// callback: function () { this.month() + 1 }\nfunction addFormatToken (token, padded, ordinal, callback) {\n    var func = callback;\n    if (typeof callback === 'string') {\n        func = function () {\n            return this[callback]();\n        };\n    }\n    if (token) {\n        formatTokenFunctions[token] = func;\n    }\n    if (padded) {\n        formatTokenFunctions[padded[0]] = function () {\n            return zeroFill(func.apply(this, arguments), padded[1], padded[2]);\n        };\n    }\n    if (ordinal) {\n        formatTokenFunctions[ordinal] = function () {\n            return this.localeData().ordinal(func.apply(this, arguments), token);\n        };\n    }\n}\n\nfunction removeFormattingTokens(input) {\n    if (input.match(/\\[[\\s\\S]/)) {\n        return input.replace(/^\\[|\\]$/g, '');\n    }\n    return input.replace(/\\\\/g, '');\n}\n\nfunction makeFormatFunction(format) {\n    var array = format.match(formattingTokens), i, length;\n\n    for (i = 0, length = array.length; i < length; i++) {\n        if (formatTokenFunctions[array[i]]) {\n            array[i] = formatTokenFunctions[array[i]];\n        } else {\n            array[i] = removeFormattingTokens(array[i]);\n        }\n    }\n\n    return function (mom) {\n        var output = '', i;\n        for (i = 0; i < length; i++) {\n            output += isFunction(array[i]) ? array[i].call(mom, format) : array[i];\n        }\n        return output;\n    };\n}\n\n// format date using native date object\nfunction formatMoment(m, format) {\n    if (!m.isValid()) {\n        return m.localeData().invalidDate();\n    }\n\n    format = expandFormat(format, m.localeData());\n    formatFunctions[format] = formatFunctions[format] || makeFormatFunction(format);\n\n    return formatFunctions[format](m);\n}\n\nfunction expandFormat(format, locale) {\n    var i = 5;\n\n    function replaceLongDateFormatTokens(input) {\n        return locale.longDateFormat(input) || input;\n    }\n\n    localFormattingTokens.lastIndex = 0;\n    while (i >= 0 && localFormattingTokens.test(format)) {\n        format = format.replace(localFormattingTokens, replaceLongDateFormatTokens);\n        localFormattingTokens.lastIndex = 0;\n        i -= 1;\n    }\n\n    return format;\n}\n\nvar match1         = /\\d/;            //       0 - 9\nvar match2         = /\\d\\d/;          //      00 - 99\nvar match3         = /\\d{3}/;         //     000 - 999\nvar match4         = /\\d{4}/;         //    0000 - 9999\nvar match6         = /[+-]?\\d{6}/;    // -999999 - 999999\nvar match1to2      = /\\d\\d?/;         //       0 - 99\nvar match3to4      = /\\d\\d\\d\\d?/;     //     999 - 9999\nvar match5to6      = /\\d\\d\\d\\d\\d\\d?/; //   99999 - 999999\nvar match1to3      = /\\d{1,3}/;       //       0 - 999\nvar match1to4      = /\\d{1,4}/;       //       0 - 9999\nvar match1to6      = /[+-]?\\d{1,6}/;  // -999999 - 999999\n\nvar matchUnsigned  = /\\d+/;           //       0 - inf\nvar matchSigned    = /[+-]?\\d+/;      //    -inf - inf\n\nvar matchOffset    = /Z|[+-]\\d\\d:?\\d\\d/gi; // +00:00 -00:00 +0000 -0000 or Z\nvar matchShortOffset = /Z|[+-]\\d\\d(?::?\\d\\d)?/gi; // +00 -00 +00:00 -00:00 +0000 -0000 or Z\n\nvar matchTimestamp = /[+-]?\\d+(\\.\\d{1,3})?/; // 123456789 123456789.123\n\n// any word (or two) characters or numbers including two/three word month in arabic.\n// includes scottish gaelic two word and hyphenated months\nvar matchWord = /[0-9]*['a-z\\u00A0-\\u05FF\\u0700-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF]+|[\\u0600-\\u06FF\\/]+(\\s*?[\\u0600-\\u06FF]+){1,2}/i;\n\n\nvar regexes = {};\n\nfunction addRegexToken (token, regex, strictRegex) {\n    regexes[token] = isFunction(regex) ? regex : function (isStrict, localeData) {\n        return (isStrict && strictRegex) ? strictRegex : regex;\n    };\n}\n\nfunction getParseRegexForToken (token, config) {\n    if (!hasOwnProp(regexes, token)) {\n        return new RegExp(unescapeFormat(token));\n    }\n\n    return regexes[token](config._strict, config._locale);\n}\n\n// Code from http://stackoverflow.com/questions/3561493/is-there-a-regexp-escape-function-in-javascript\nfunction unescapeFormat(s) {\n    return regexEscape(s.replace('\\\\', '').replace(/\\\\(\\[)|\\\\(\\])|\\[([^\\]\\[]*)\\]|\\\\(.)/g, function (matched, p1, p2, p3, p4) {\n        return p1 || p2 || p3 || p4;\n    }));\n}\n\nfunction regexEscape(s) {\n    return s.replace(/[-\\/\\\\^$*+?.()|[\\]{}]/g, '\\\\$&');\n}\n\nvar tokens = {};\n\nfunction addParseToken (token, callback) {\n    var i, func = callback;\n    if (typeof token === 'string') {\n        token = [token];\n    }\n    if (isNumber(callback)) {\n        func = function (input, array) {\n            array[callback] = toInt(input);\n        };\n    }\n    for (i = 0; i < token.length; i++) {\n        tokens[token[i]] = func;\n    }\n}\n\nfunction addWeekParseToken (token, callback) {\n    addParseToken(token, function (input, array, config, token) {\n        config._w = config._w || {};\n        callback(input, config._w, config, token);\n    });\n}\n\nfunction addTimeToArrayFromToken(token, input, config) {\n    if (input != null && hasOwnProp(tokens, token)) {\n        tokens[token](input, config._a, config, token);\n    }\n}\n\nvar YEAR = 0;\nvar MONTH = 1;\nvar DATE = 2;\nvar HOUR = 3;\nvar MINUTE = 4;\nvar SECOND = 5;\nvar MILLISECOND = 6;\nvar WEEK = 7;\nvar WEEKDAY = 8;\n\nvar indexOf;\n\nif (Array.prototype.indexOf) {\n    indexOf = Array.prototype.indexOf;\n} else {\n    indexOf = function (o) {\n        // I know\n        var i;\n        for (i = 0; i < this.length; ++i) {\n            if (this[i] === o) {\n                return i;\n            }\n        }\n        return -1;\n    };\n}\n\nvar indexOf$1 = indexOf;\n\nfunction daysInMonth(year, month) {\n    return new Date(Date.UTC(year, month + 1, 0)).getUTCDate();\n}\n\n// FORMATTING\n\naddFormatToken('M', ['MM', 2], 'Mo', function () {\n    return this.month() + 1;\n});\n\naddFormatToken('MMM', 0, 0, function (format) {\n    return this.localeData().monthsShort(this, format);\n});\n\naddFormatToken('MMMM', 0, 0, function (format) {\n    return this.localeData().months(this, format);\n});\n\n// ALIASES\n\naddUnitAlias('month', 'M');\n\n// PRIORITY\n\naddUnitPriority('month', 8);\n\n// PARSING\n\naddRegexToken('M',    match1to2);\naddRegexToken('MM',   match1to2, match2);\naddRegexToken('MMM',  function (isStrict, locale) {\n    return locale.monthsShortRegex(isStrict);\n});\naddRegexToken('MMMM', function (isStrict, locale) {\n    return locale.monthsRegex(isStrict);\n});\n\naddParseToken(['M', 'MM'], function (input, array) {\n    array[MONTH] = toInt(input) - 1;\n});\n\naddParseToken(['MMM', 'MMMM'], function (input, array, config, token) {\n    var month = config._locale.monthsParse(input, token, config._strict);\n    // if we didn't find a month name, mark the date as invalid.\n    if (month != null) {\n        array[MONTH] = month;\n    } else {\n        getParsingFlags(config).invalidMonth = input;\n    }\n});\n\n// LOCALES\n\nvar MONTHS_IN_FORMAT = /D[oD]?(\\[[^\\[\\]]*\\]|\\s)+MMMM?/;\nvar defaultLocaleMonths = 'January_February_March_April_May_June_July_August_September_October_November_December'.split('_');\nfunction localeMonths (m, format) {\n    if (!m) {\n        return isArray(this._months) ? this._months :\n            this._months['standalone'];\n    }\n    return isArray(this._months) ? this._months[m.month()] :\n        this._months[(this._months.isFormat || MONTHS_IN_FORMAT).test(format) ? 'format' : 'standalone'][m.month()];\n}\n\nvar defaultLocaleMonthsShort = 'Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec'.split('_');\nfunction localeMonthsShort (m, format) {\n    if (!m) {\n        return isArray(this._monthsShort) ? this._monthsShort :\n            this._monthsShort['standalone'];\n    }\n    return isArray(this._monthsShort) ? this._monthsShort[m.month()] :\n        this._monthsShort[MONTHS_IN_FORMAT.test(format) ? 'format' : 'standalone'][m.month()];\n}\n\nfunction handleStrictParse(monthName, format, strict) {\n    var i, ii, mom, llc = monthName.toLocaleLowerCase();\n    if (!this._monthsParse) {\n        // this is not used\n        this._monthsParse = [];\n        this._longMonthsParse = [];\n        this._shortMonthsParse = [];\n        for (i = 0; i < 12; ++i) {\n            mom = createUTC([2000, i]);\n            this._shortMonthsParse[i] = this.monthsShort(mom, '').toLocaleLowerCase();\n            this._longMonthsParse[i] = this.months(mom, '').toLocaleLowerCase();\n        }\n    }\n\n    if (strict) {\n        if (format === 'MMM') {\n            ii = indexOf$1.call(this._shortMonthsParse, llc);\n            return ii !== -1 ? ii : null;\n        } else {\n            ii = indexOf$1.call(this._longMonthsParse, llc);\n            return ii !== -1 ? ii : null;\n        }\n    } else {\n        if (format === 'MMM') {\n            ii = indexOf$1.call(this._shortMonthsParse, llc);\n            if (ii !== -1) {\n                return ii;\n            }\n            ii = indexOf$1.call(this._longMonthsParse, llc);\n            return ii !== -1 ? ii : null;\n        } else {\n            ii = indexOf$1.call(this._longMonthsParse, llc);\n            if (ii !== -1) {\n                return ii;\n            }\n            ii = indexOf$1.call(this._shortMonthsParse, llc);\n            return ii !== -1 ? ii : null;\n        }\n    }\n}\n\nfunction localeMonthsParse (monthName, format, strict) {\n    var i, mom, regex;\n\n    if (this._monthsParseExact) {\n        return handleStrictParse.call(this, monthName, format, strict);\n    }\n\n    if (!this._monthsParse) {\n        this._monthsParse = [];\n        this._longMonthsParse = [];\n        this._shortMonthsParse = [];\n    }\n\n    // TODO: add sorting\n    // Sorting makes sure if one month (or abbr) is a prefix of another\n    // see sorting in computeMonthsParse\n    for (i = 0; i < 12; i++) {\n        // make the regex if we don't have it already\n        mom = createUTC([2000, i]);\n        if (strict && !this._longMonthsParse[i]) {\n            this._longMonthsParse[i] = new RegExp('^' + this.months(mom, '').replace('.', '') + '$', 'i');\n            this._shortMonthsParse[i] = new RegExp('^' + this.monthsShort(mom, '').replace('.', '') + '$', 'i');\n        }\n        if (!strict && !this._monthsParse[i]) {\n            regex = '^' + this.months(mom, '') + '|^' + this.monthsShort(mom, '');\n            this._monthsParse[i] = new RegExp(regex.replace('.', ''), 'i');\n        }\n        // test the regex\n        if (strict && format === 'MMMM' && this._longMonthsParse[i].test(monthName)) {\n            return i;\n        } else if (strict && format === 'MMM' && this._shortMonthsParse[i].test(monthName)) {\n            return i;\n        } else if (!strict && this._monthsParse[i].test(monthName)) {\n            return i;\n        }\n    }\n}\n\n// MOMENTS\n\nfunction setMonth (mom, value) {\n    var dayOfMonth;\n\n    if (!mom.isValid()) {\n        // No op\n        return mom;\n    }\n\n    if (typeof value === 'string') {\n        if (/^\\d+$/.test(value)) {\n            value = toInt(value);\n        } else {\n            value = mom.localeData().monthsParse(value);\n            // TODO: Another silent failure?\n            if (!isNumber(value)) {\n                return mom;\n            }\n        }\n    }\n\n    dayOfMonth = Math.min(mom.date(), daysInMonth(mom.year(), value));\n    mom._d['set' + (mom._isUTC ? 'UTC' : '') + 'Month'](value, dayOfMonth);\n    return mom;\n}\n\nfunction getSetMonth (value) {\n    if (value != null) {\n        setMonth(this, value);\n        hooks.updateOffset(this, true);\n        return this;\n    } else {\n        return get(this, 'Month');\n    }\n}\n\nfunction getDaysInMonth () {\n    return daysInMonth(this.year(), this.month());\n}\n\nvar defaultMonthsShortRegex = matchWord;\nfunction monthsShortRegex (isStrict) {\n    if (this._monthsParseExact) {\n        if (!hasOwnProp(this, '_monthsRegex')) {\n            computeMonthsParse.call(this);\n        }\n        if (isStrict) {\n            return this._monthsShortStrictRegex;\n        } else {\n            return this._monthsShortRegex;\n        }\n    } else {\n        if (!hasOwnProp(this, '_monthsShortRegex')) {\n            this._monthsShortRegex = defaultMonthsShortRegex;\n        }\n        return this._monthsShortStrictRegex && isStrict ?\n            this._monthsShortStrictRegex : this._monthsShortRegex;\n    }\n}\n\nvar defaultMonthsRegex = matchWord;\nfunction monthsRegex (isStrict) {\n    if (this._monthsParseExact) {\n        if (!hasOwnProp(this, '_monthsRegex')) {\n            computeMonthsParse.call(this);\n        }\n        if (isStrict) {\n            return this._monthsStrictRegex;\n        } else {\n            return this._monthsRegex;\n        }\n    } else {\n        if (!hasOwnProp(this, '_monthsRegex')) {\n            this._monthsRegex = defaultMonthsRegex;\n        }\n        return this._monthsStrictRegex && isStrict ?\n            this._monthsStrictRegex : this._monthsRegex;\n    }\n}\n\nfunction computeMonthsParse () {\n    function cmpLenRev(a, b) {\n        return b.length - a.length;\n    }\n\n    var shortPieces = [], longPieces = [], mixedPieces = [],\n        i, mom;\n    for (i = 0; i < 12; i++) {\n        // make the regex if we don't have it already\n        mom = createUTC([2000, i]);\n        shortPieces.push(this.monthsShort(mom, ''));\n        longPieces.push(this.months(mom, ''));\n        mixedPieces.push(this.months(mom, ''));\n        mixedPieces.push(this.monthsShort(mom, ''));\n    }\n    // Sorting makes sure if one month (or abbr) is a prefix of another it\n    // will match the longer piece.\n    shortPieces.sort(cmpLenRev);\n    longPieces.sort(cmpLenRev);\n    mixedPieces.sort(cmpLenRev);\n    for (i = 0; i < 12; i++) {\n        shortPieces[i] = regexEscape(shortPieces[i]);\n        longPieces[i] = regexEscape(longPieces[i]);\n    }\n    for (i = 0; i < 24; i++) {\n        mixedPieces[i] = regexEscape(mixedPieces[i]);\n    }\n\n    this._monthsRegex = new RegExp('^(' + mixedPieces.join('|') + ')', 'i');\n    this._monthsShortRegex = this._monthsRegex;\n    this._monthsStrictRegex = new RegExp('^(' + longPieces.join('|') + ')', 'i');\n    this._monthsShortStrictRegex = new RegExp('^(' + shortPieces.join('|') + ')', 'i');\n}\n\n// FORMATTING\n\naddFormatToken('Y', 0, 0, function () {\n    var y = this.year();\n    return y <= 9999 ? '' + y : '+' + y;\n});\n\naddFormatToken(0, ['YY', 2], 0, function () {\n    return this.year() % 100;\n});\n\naddFormatToken(0, ['YYYY',   4],       0, 'year');\naddFormatToken(0, ['YYYYY',  5],       0, 'year');\naddFormatToken(0, ['YYYYYY', 6, true], 0, 'year');\n\n// ALIASES\n\naddUnitAlias('year', 'y');\n\n// PRIORITIES\n\naddUnitPriority('year', 1);\n\n// PARSING\n\naddRegexToken('Y',      matchSigned);\naddRegexToken('YY',     match1to2, match2);\naddRegexToken('YYYY',   match1to4, match4);\naddRegexToken('YYYYY',  match1to6, match6);\naddRegexToken('YYYYYY', match1to6, match6);\n\naddParseToken(['YYYYY', 'YYYYYY'], YEAR);\naddParseToken('YYYY', function (input, array) {\n    array[YEAR] = input.length === 2 ? hooks.parseTwoDigitYear(input) : toInt(input);\n});\naddParseToken('YY', function (input, array) {\n    array[YEAR] = hooks.parseTwoDigitYear(input);\n});\naddParseToken('Y', function (input, array) {\n    array[YEAR] = parseInt(input, 10);\n});\n\n// HELPERS\n\nfunction daysInYear(year) {\n    return isLeapYear(year) ? 366 : 365;\n}\n\nfunction isLeapYear(year) {\n    return (year % 4 === 0 && year % 100 !== 0) || year % 400 === 0;\n}\n\n// HOOKS\n\nhooks.parseTwoDigitYear = function (input) {\n    return toInt(input) + (toInt(input) > 68 ? 1900 : 2000);\n};\n\n// MOMENTS\n\nvar getSetYear = makeGetSet('FullYear', true);\n\nfunction getIsLeapYear () {\n    return isLeapYear(this.year());\n}\n\nfunction createDate (y, m, d, h, M, s, ms) {\n    // can't just apply() to create a date:\n    // https://stackoverflow.com/q/181348\n    var date = new Date(y, m, d, h, M, s, ms);\n\n    // the date constructor remaps years 0-99 to 1900-1999\n    if (y < 100 && y >= 0 && isFinite(date.getFullYear())) {\n        date.setFullYear(y);\n    }\n    return date;\n}\n\nfunction createUTCDate (y) {\n    var date = new Date(Date.UTC.apply(null, arguments));\n\n    // the Date.UTC function remaps years 0-99 to 1900-1999\n    if (y < 100 && y >= 0 && isFinite(date.getUTCFullYear())) {\n        date.setUTCFullYear(y);\n    }\n    return date;\n}\n\n// start-of-first-week - start-of-year\nfunction firstWeekOffset(year, dow, doy) {\n    var // first-week day -- which january is always in the first week (4 for iso, 1 for other)\n        fwd = 7 + dow - doy,\n        // first-week day local weekday -- which local weekday is fwd\n        fwdlw = (7 + createUTCDate(year, 0, fwd).getUTCDay() - dow) % 7;\n\n    return -fwdlw + fwd - 1;\n}\n\n// https://en.wikipedia.org/wiki/ISO_week_date#Calculating_a_date_given_the_year.2C_week_number_and_weekday\nfunction dayOfYearFromWeeks(year, week, weekday, dow, doy) {\n    var localWeekday = (7 + weekday - dow) % 7,\n        weekOffset = firstWeekOffset(year, dow, doy),\n        dayOfYear = 1 + 7 * (week - 1) + localWeekday + weekOffset,\n        resYear, resDayOfYear;\n\n    if (dayOfYear <= 0) {\n        resYear = year - 1;\n        resDayOfYear = daysInYear(resYear) + dayOfYear;\n    } else if (dayOfYear > daysInYear(year)) {\n        resYear = year + 1;\n        resDayOfYear = dayOfYear - daysInYear(year);\n    } else {\n        resYear = year;\n        resDayOfYear = dayOfYear;\n    }\n\n    return {\n        year: resYear,\n        dayOfYear: resDayOfYear\n    };\n}\n\nfunction weekOfYear(mom, dow, doy) {\n    var weekOffset = firstWeekOffset(mom.year(), dow, doy),\n        week = Math.floor((mom.dayOfYear() - weekOffset - 1) / 7) + 1,\n        resWeek, resYear;\n\n    if (week < 1) {\n        resYear = mom.year() - 1;\n        resWeek = week + weeksInYear(resYear, dow, doy);\n    } else if (week > weeksInYear(mom.year(), dow, doy)) {\n        resWeek = week - weeksInYear(mom.year(), dow, doy);\n        resYear = mom.year() + 1;\n    } else {\n        resYear = mom.year();\n        resWeek = week;\n    }\n\n    return {\n        week: resWeek,\n        year: resYear\n    };\n}\n\nfunction weeksInYear(year, dow, doy) {\n    var weekOffset = firstWeekOffset(year, dow, doy),\n        weekOffsetNext = firstWeekOffset(year + 1, dow, doy);\n    return (daysInYear(year) - weekOffset + weekOffsetNext) / 7;\n}\n\n// FORMATTING\n\naddFormatToken('w', ['ww', 2], 'wo', 'week');\naddFormatToken('W', ['WW', 2], 'Wo', 'isoWeek');\n\n// ALIASES\n\naddUnitAlias('week', 'w');\naddUnitAlias('isoWeek', 'W');\n\n// PRIORITIES\n\naddUnitPriority('week', 5);\naddUnitPriority('isoWeek', 5);\n\n// PARSING\n\naddRegexToken('w',  match1to2);\naddRegexToken('ww', match1to2, match2);\naddRegexToken('W',  match1to2);\naddRegexToken('WW', match1to2, match2);\n\naddWeekParseToken(['w', 'ww', 'W', 'WW'], function (input, week, config, token) {\n    week[token.substr(0, 1)] = toInt(input);\n});\n\n// HELPERS\n\n// LOCALES\n\nfunction localeWeek (mom) {\n    return weekOfYear(mom, this._week.dow, this._week.doy).week;\n}\n\nvar defaultLocaleWeek = {\n    dow : 0, // Sunday is the first day of the week.\n    doy : 6  // The week that contains Jan 1st is the first week of the year.\n};\n\nfunction localeFirstDayOfWeek () {\n    return this._week.dow;\n}\n\nfunction localeFirstDayOfYear () {\n    return this._week.doy;\n}\n\n// MOMENTS\n\nfunction getSetWeek (input) {\n    var week = this.localeData().week(this);\n    return input == null ? week : this.add((input - week) * 7, 'd');\n}\n\nfunction getSetISOWeek (input) {\n    var week = weekOfYear(this, 1, 4).week;\n    return input == null ? week : this.add((input - week) * 7, 'd');\n}\n\n// FORMATTING\n\naddFormatToken('d', 0, 'do', 'day');\n\naddFormatToken('dd', 0, 0, function (format) {\n    return this.localeData().weekdaysMin(this, format);\n});\n\naddFormatToken('ddd', 0, 0, function (format) {\n    return this.localeData().weekdaysShort(this, format);\n});\n\naddFormatToken('dddd', 0, 0, function (format) {\n    return this.localeData().weekdays(this, format);\n});\n\naddFormatToken('e', 0, 0, 'weekday');\naddFormatToken('E', 0, 0, 'isoWeekday');\n\n// ALIASES\n\naddUnitAlias('day', 'd');\naddUnitAlias('weekday', 'e');\naddUnitAlias('isoWeekday', 'E');\n\n// PRIORITY\naddUnitPriority('day', 11);\naddUnitPriority('weekday', 11);\naddUnitPriority('isoWeekday', 11);\n\n// PARSING\n\naddRegexToken('d',    match1to2);\naddRegexToken('e',    match1to2);\naddRegexToken('E',    match1to2);\naddRegexToken('dd',   function (isStrict, locale) {\n    return locale.weekdaysMinRegex(isStrict);\n});\naddRegexToken('ddd',   function (isStrict, locale) {\n    return locale.weekdaysShortRegex(isStrict);\n});\naddRegexToken('dddd',   function (isStrict, locale) {\n    return locale.weekdaysRegex(isStrict);\n});\n\naddWeekParseToken(['dd', 'ddd', 'dddd'], function (input, week, config, token) {\n    var weekday = config._locale.weekdaysParse(input, token, config._strict);\n    // if we didn't get a weekday name, mark the date as invalid\n    if (weekday != null) {\n        week.d = weekday;\n    } else {\n        getParsingFlags(config).invalidWeekday = input;\n    }\n});\n\naddWeekParseToken(['d', 'e', 'E'], function (input, week, config, token) {\n    week[token] = toInt(input);\n});\n\n// HELPERS\n\nfunction parseWeekday(input, locale) {\n    if (typeof input !== 'string') {\n        return input;\n    }\n\n    if (!isNaN(input)) {\n        return parseInt(input, 10);\n    }\n\n    input = locale.weekdaysParse(input);\n    if (typeof input === 'number') {\n        return input;\n    }\n\n    return null;\n}\n\nfunction parseIsoWeekday(input, locale) {\n    if (typeof input === 'string') {\n        return locale.weekdaysParse(input) % 7 || 7;\n    }\n    return isNaN(input) ? null : input;\n}\n\n// LOCALES\n\nvar defaultLocaleWeekdays = 'Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday'.split('_');\nfunction localeWeekdays (m, format) {\n    if (!m) {\n        return isArray(this._weekdays) ? this._weekdays :\n            this._weekdays['standalone'];\n    }\n    return isArray(this._weekdays) ? this._weekdays[m.day()] :\n        this._weekdays[this._weekdays.isFormat.test(format) ? 'format' : 'standalone'][m.day()];\n}\n\nvar defaultLocaleWeekdaysShort = 'Sun_Mon_Tue_Wed_Thu_Fri_Sat'.split('_');\nfunction localeWeekdaysShort (m) {\n    return (m) ? this._weekdaysShort[m.day()] : this._weekdaysShort;\n}\n\nvar defaultLocaleWeekdaysMin = 'Su_Mo_Tu_We_Th_Fr_Sa'.split('_');\nfunction localeWeekdaysMin (m) {\n    return (m) ? this._weekdaysMin[m.day()] : this._weekdaysMin;\n}\n\nfunction handleStrictParse$1(weekdayName, format, strict) {\n    var i, ii, mom, llc = weekdayName.toLocaleLowerCase();\n    if (!this._weekdaysParse) {\n        this._weekdaysParse = [];\n        this._shortWeekdaysParse = [];\n        this._minWeekdaysParse = [];\n\n        for (i = 0; i < 7; ++i) {\n            mom = createUTC([2000, 1]).day(i);\n            this._minWeekdaysParse[i] = this.weekdaysMin(mom, '').toLocaleLowerCase();\n            this._shortWeekdaysParse[i] = this.weekdaysShort(mom, '').toLocaleLowerCase();\n            this._weekdaysParse[i] = this.weekdays(mom, '').toLocaleLowerCase();\n        }\n    }\n\n    if (strict) {\n        if (format === 'dddd') {\n            ii = indexOf$1.call(this._weekdaysParse, llc);\n            return ii !== -1 ? ii : null;\n        } else if (format === 'ddd') {\n            ii = indexOf$1.call(this._shortWeekdaysParse, llc);\n            return ii !== -1 ? ii : null;\n        } else {\n            ii = indexOf$1.call(this._minWeekdaysParse, llc);\n            return ii !== -1 ? ii : null;\n        }\n    } else {\n        if (format === 'dddd') {\n            ii = indexOf$1.call(this._weekdaysParse, llc);\n            if (ii !== -1) {\n                return ii;\n            }\n            ii = indexOf$1.call(this._shortWeekdaysParse, llc);\n            if (ii !== -1) {\n                return ii;\n            }\n            ii = indexOf$1.call(this._minWeekdaysParse, llc);\n            return ii !== -1 ? ii : null;\n        } else if (format === 'ddd') {\n            ii = indexOf$1.call(this._shortWeekdaysParse, llc);\n            if (ii !== -1) {\n                return ii;\n            }\n            ii = indexOf$1.call(this._weekdaysParse, llc);\n            if (ii !== -1) {\n                return ii;\n            }\n            ii = indexOf$1.call(this._minWeekdaysParse, llc);\n            return ii !== -1 ? ii : null;\n        } else {\n            ii = indexOf$1.call(this._minWeekdaysParse, llc);\n            if (ii !== -1) {\n                return ii;\n            }\n            ii = indexOf$1.call(this._weekdaysParse, llc);\n            if (ii !== -1) {\n                return ii;\n            }\n            ii = indexOf$1.call(this._shortWeekdaysParse, llc);\n            return ii !== -1 ? ii : null;\n        }\n    }\n}\n\nfunction localeWeekdaysParse (weekdayName, format, strict) {\n    var i, mom, regex;\n\n    if (this._weekdaysParseExact) {\n        return handleStrictParse$1.call(this, weekdayName, format, strict);\n    }\n\n    if (!this._weekdaysParse) {\n        this._weekdaysParse = [];\n        this._minWeekdaysParse = [];\n        this._shortWeekdaysParse = [];\n        this._fullWeekdaysParse = [];\n    }\n\n    for (i = 0; i < 7; i++) {\n        // make the regex if we don't have it already\n\n        mom = createUTC([2000, 1]).day(i);\n        if (strict && !this._fullWeekdaysParse[i]) {\n            this._fullWeekdaysParse[i] = new RegExp('^' + this.weekdays(mom, '').replace('.', '\\.?') + '$', 'i');\n            this._shortWeekdaysParse[i] = new RegExp('^' + this.weekdaysShort(mom, '').replace('.', '\\.?') + '$', 'i');\n            this._minWeekdaysParse[i] = new RegExp('^' + this.weekdaysMin(mom, '').replace('.', '\\.?') + '$', 'i');\n        }\n        if (!this._weekdaysParse[i]) {\n            regex = '^' + this.weekdays(mom, '') + '|^' + this.weekdaysShort(mom, '') + '|^' + this.weekdaysMin(mom, '');\n            this._weekdaysParse[i] = new RegExp(regex.replace('.', ''), 'i');\n        }\n        // test the regex\n        if (strict && format === 'dddd' && this._fullWeekdaysParse[i].test(weekdayName)) {\n            return i;\n        } else if (strict && format === 'ddd' && this._shortWeekdaysParse[i].test(weekdayName)) {\n            return i;\n        } else if (strict && format === 'dd' && this._minWeekdaysParse[i].test(weekdayName)) {\n            return i;\n        } else if (!strict && this._weekdaysParse[i].test(weekdayName)) {\n            return i;\n        }\n    }\n}\n\n// MOMENTS\n\nfunction getSetDayOfWeek (input) {\n    if (!this.isValid()) {\n        return input != null ? this : NaN;\n    }\n    var day = this._isUTC ? this._d.getUTCDay() : this._d.getDay();\n    if (input != null) {\n        input = parseWeekday(input, this.localeData());\n        return this.add(input - day, 'd');\n    } else {\n        return day;\n    }\n}\n\nfunction getSetLocaleDayOfWeek (input) {\n    if (!this.isValid()) {\n        return input != null ? this : NaN;\n    }\n    var weekday = (this.day() + 7 - this.localeData()._week.dow) % 7;\n    return input == null ? weekday : this.add(input - weekday, 'd');\n}\n\nfunction getSetISODayOfWeek (input) {\n    if (!this.isValid()) {\n        return input != null ? this : NaN;\n    }\n\n    // behaves the same as moment#day except\n    // as a getter, returns 7 instead of 0 (1-7 range instead of 0-6)\n    // as a setter, sunday should belong to the previous week.\n\n    if (input != null) {\n        var weekday = parseIsoWeekday(input, this.localeData());\n        return this.day(this.day() % 7 ? weekday : weekday - 7);\n    } else {\n        return this.day() || 7;\n    }\n}\n\nvar defaultWeekdaysRegex = matchWord;\nfunction weekdaysRegex (isStrict) {\n    if (this._weekdaysParseExact) {\n        if (!hasOwnProp(this, '_weekdaysRegex')) {\n            computeWeekdaysParse.call(this);\n        }\n        if (isStrict) {\n            return this._weekdaysStrictRegex;\n        } else {\n            return this._weekdaysRegex;\n        }\n    } else {\n        if (!hasOwnProp(this, '_weekdaysRegex')) {\n            this._weekdaysRegex = defaultWeekdaysRegex;\n        }\n        return this._weekdaysStrictRegex && isStrict ?\n            this._weekdaysStrictRegex : this._weekdaysRegex;\n    }\n}\n\nvar defaultWeekdaysShortRegex = matchWord;\nfunction weekdaysShortRegex (isStrict) {\n    if (this._weekdaysParseExact) {\n        if (!hasOwnProp(this, '_weekdaysRegex')) {\n            computeWeekdaysParse.call(this);\n        }\n        if (isStrict) {\n            return this._weekdaysShortStrictRegex;\n        } else {\n            return this._weekdaysShortRegex;\n        }\n    } else {\n        if (!hasOwnProp(this, '_weekdaysShortRegex')) {\n            this._weekdaysShortRegex = defaultWeekdaysShortRegex;\n        }\n        return this._weekdaysShortStrictRegex && isStrict ?\n            this._weekdaysShortStrictRegex : this._weekdaysShortRegex;\n    }\n}\n\nvar defaultWeekdaysMinRegex = matchWord;\nfunction weekdaysMinRegex (isStrict) {\n    if (this._weekdaysParseExact) {\n        if (!hasOwnProp(this, '_weekdaysRegex')) {\n            computeWeekdaysParse.call(this);\n        }\n        if (isStrict) {\n            return this._weekdaysMinStrictRegex;\n        } else {\n            return this._weekdaysMinRegex;\n        }\n    } else {\n        if (!hasOwnProp(this, '_weekdaysMinRegex')) {\n            this._weekdaysMinRegex = defaultWeekdaysMinRegex;\n        }\n        return this._weekdaysMinStrictRegex && isStrict ?\n            this._weekdaysMinStrictRegex : this._weekdaysMinRegex;\n    }\n}\n\n\nfunction computeWeekdaysParse () {\n    function cmpLenRev(a, b) {\n        return b.length - a.length;\n    }\n\n    var minPieces = [], shortPieces = [], longPieces = [], mixedPieces = [],\n        i, mom, minp, shortp, longp;\n    for (i = 0; i < 7; i++) {\n        // make the regex if we don't have it already\n        mom = createUTC([2000, 1]).day(i);\n        minp = this.weekdaysMin(mom, '');\n        shortp = this.weekdaysShort(mom, '');\n        longp = this.weekdays(mom, '');\n        minPieces.push(minp);\n        shortPieces.push(shortp);\n        longPieces.push(longp);\n        mixedPieces.push(minp);\n        mixedPieces.push(shortp);\n        mixedPieces.push(longp);\n    }\n    // Sorting makes sure if one weekday (or abbr) is a prefix of another it\n    // will match the longer piece.\n    minPieces.sort(cmpLenRev);\n    shortPieces.sort(cmpLenRev);\n    longPieces.sort(cmpLenRev);\n    mixedPieces.sort(cmpLenRev);\n    for (i = 0; i < 7; i++) {\n        shortPieces[i] = regexEscape(shortPieces[i]);\n        longPieces[i] = regexEscape(longPieces[i]);\n        mixedPieces[i] = regexEscape(mixedPieces[i]);\n    }\n\n    this._weekdaysRegex = new RegExp('^(' + mixedPieces.join('|') + ')', 'i');\n    this._weekdaysShortRegex = this._weekdaysRegex;\n    this._weekdaysMinRegex = this._weekdaysRegex;\n\n    this._weekdaysStrictRegex = new RegExp('^(' + longPieces.join('|') + ')', 'i');\n    this._weekdaysShortStrictRegex = new RegExp('^(' + shortPieces.join('|') + ')', 'i');\n    this._weekdaysMinStrictRegex = new RegExp('^(' + minPieces.join('|') + ')', 'i');\n}\n\n// FORMATTING\n\nfunction hFormat() {\n    return this.hours() % 12 || 12;\n}\n\nfunction kFormat() {\n    return this.hours() || 24;\n}\n\naddFormatToken('H', ['HH', 2], 0, 'hour');\naddFormatToken('h', ['hh', 2], 0, hFormat);\naddFormatToken('k', ['kk', 2], 0, kFormat);\n\naddFormatToken('hmm', 0, 0, function () {\n    return '' + hFormat.apply(this) + zeroFill(this.minutes(), 2);\n});\n\naddFormatToken('hmmss', 0, 0, function () {\n    return '' + hFormat.apply(this) + zeroFill(this.minutes(), 2) +\n        zeroFill(this.seconds(), 2);\n});\n\naddFormatToken('Hmm', 0, 0, function () {\n    return '' + this.hours() + zeroFill(this.minutes(), 2);\n});\n\naddFormatToken('Hmmss', 0, 0, function () {\n    return '' + this.hours() + zeroFill(this.minutes(), 2) +\n        zeroFill(this.seconds(), 2);\n});\n\nfunction meridiem (token, lowercase) {\n    addFormatToken(token, 0, 0, function () {\n        return this.localeData().meridiem(this.hours(), this.minutes(), lowercase);\n    });\n}\n\nmeridiem('a', true);\nmeridiem('A', false);\n\n// ALIASES\n\naddUnitAlias('hour', 'h');\n\n// PRIORITY\naddUnitPriority('hour', 13);\n\n// PARSING\n\nfunction matchMeridiem (isStrict, locale) {\n    return locale._meridiemParse;\n}\n\naddRegexToken('a',  matchMeridiem);\naddRegexToken('A',  matchMeridiem);\naddRegexToken('H',  match1to2);\naddRegexToken('h',  match1to2);\naddRegexToken('k',  match1to2);\naddRegexToken('HH', match1to2, match2);\naddRegexToken('hh', match1to2, match2);\naddRegexToken('kk', match1to2, match2);\n\naddRegexToken('hmm', match3to4);\naddRegexToken('hmmss', match5to6);\naddRegexToken('Hmm', match3to4);\naddRegexToken('Hmmss', match5to6);\n\naddParseToken(['H', 'HH'], HOUR);\naddParseToken(['k', 'kk'], function (input, array, config) {\n    var kInput = toInt(input);\n    array[HOUR] = kInput === 24 ? 0 : kInput;\n});\naddParseToken(['a', 'A'], function (input, array, config) {\n    config._isPm = config._locale.isPM(input);\n    config._meridiem = input;\n});\naddParseToken(['h', 'hh'], function (input, array, config) {\n    array[HOUR] = toInt(input);\n    getParsingFlags(config).bigHour = true;\n});\naddParseToken('hmm', function (input, array, config) {\n    var pos = input.length - 2;\n    array[HOUR] = toInt(input.substr(0, pos));\n    array[MINUTE] = toInt(input.substr(pos));\n    getParsingFlags(config).bigHour = true;\n});\naddParseToken('hmmss', function (input, array, config) {\n    var pos1 = input.length - 4;\n    var pos2 = input.length - 2;\n    array[HOUR] = toInt(input.substr(0, pos1));\n    array[MINUTE] = toInt(input.substr(pos1, 2));\n    array[SECOND] = toInt(input.substr(pos2));\n    getParsingFlags(config).bigHour = true;\n});\naddParseToken('Hmm', function (input, array, config) {\n    var pos = input.length - 2;\n    array[HOUR] = toInt(input.substr(0, pos));\n    array[MINUTE] = toInt(input.substr(pos));\n});\naddParseToken('Hmmss', function (input, array, config) {\n    var pos1 = input.length - 4;\n    var pos2 = input.length - 2;\n    array[HOUR] = toInt(input.substr(0, pos1));\n    array[MINUTE] = toInt(input.substr(pos1, 2));\n    array[SECOND] = toInt(input.substr(pos2));\n});\n\n// LOCALES\n\nfunction localeIsPM (input) {\n    // IE8 Quirks Mode & IE7 Standards Mode do not allow accessing strings like arrays\n    // Using charAt should be more compatible.\n    return ((input + '').toLowerCase().charAt(0) === 'p');\n}\n\nvar defaultLocaleMeridiemParse = /[ap]\\.?m?\\.?/i;\nfunction localeMeridiem (hours, minutes, isLower) {\n    if (hours > 11) {\n        return isLower ? 'pm' : 'PM';\n    } else {\n        return isLower ? 'am' : 'AM';\n    }\n}\n\n\n// MOMENTS\n\n// Setting the hour should keep the time, because the user explicitly\n// specified which hour he wants. So trying to maintain the same hour (in\n// a new timezone) makes sense. Adding/subtracting hours does not follow\n// this rule.\nvar getSetHour = makeGetSet('Hours', true);\n\n// months\n// week\n// weekdays\n// meridiem\nvar baseConfig = {\n    calendar: defaultCalendar,\n    longDateFormat: defaultLongDateFormat,\n    invalidDate: defaultInvalidDate,\n    ordinal: defaultOrdinal,\n    dayOfMonthOrdinalParse: defaultDayOfMonthOrdinalParse,\n    relativeTime: defaultRelativeTime,\n\n    months: defaultLocaleMonths,\n    monthsShort: defaultLocaleMonthsShort,\n\n    week: defaultLocaleWeek,\n\n    weekdays: defaultLocaleWeekdays,\n    weekdaysMin: defaultLocaleWeekdaysMin,\n    weekdaysShort: defaultLocaleWeekdaysShort,\n\n    meridiemParse: defaultLocaleMeridiemParse\n};\n\n// internal storage for locale config files\nvar locales = {};\nvar localeFamilies = {};\nvar globalLocale;\n\nfunction normalizeLocale(key) {\n    return key ? key.toLowerCase().replace('_', '-') : key;\n}\n\n// pick the locale from the array\n// try ['en-au', 'en-gb'] as 'en-au', 'en-gb', 'en', as in move through the list trying each\n// substring from most specific to least, but move to the next array item if it's a more specific variant than the current root\nfunction chooseLocale(names) {\n    var i = 0, j, next, locale, split;\n\n    while (i < names.length) {\n        split = normalizeLocale(names[i]).split('-');\n        j = split.length;\n        next = normalizeLocale(names[i + 1]);\n        next = next ? next.split('-') : null;\n        while (j > 0) {\n            locale = loadLocale(split.slice(0, j).join('-'));\n            if (locale) {\n                return locale;\n            }\n            if (next && next.length >= j && compareArrays(split, next, true) >= j - 1) {\n                //the next array item is better than a shallower substring of this one\n                break;\n            }\n            j--;\n        }\n        i++;\n    }\n    return null;\n}\n\nfunction loadLocale(name) {\n    var oldLocale = null;\n    // TODO: Find a better way to register and load all the locales in Node\n    if (!locales[name] && (typeof module !== 'undefined') &&\n            module && module.exports) {\n        try {\n            oldLocale = globalLocale._abbr;\n            require('./locale/' + name);\n            // because defineLocale currently also sets the global locale, we\n            // want to undo that for lazy loaded locales\n            getSetGlobalLocale(oldLocale);\n        } catch (e) { }\n    }\n    return locales[name];\n}\n\n// This function will load locale and then set the global locale.  If\n// no arguments are passed in, it will simply return the current global\n// locale key.\nfunction getSetGlobalLocale (key, values) {\n    var data;\n    if (key) {\n        if (isUndefined(values)) {\n            data = getLocale(key);\n        }\n        else {\n            data = defineLocale(key, values);\n        }\n\n        if (data) {\n            // moment.duration._locale = moment._locale = data;\n            globalLocale = data;\n        }\n    }\n\n    return globalLocale._abbr;\n}\n\nfunction defineLocale (name, config) {\n    if (config !== null) {\n        var parentConfig = baseConfig;\n        config.abbr = name;\n        if (locales[name] != null) {\n            deprecateSimple('defineLocaleOverride',\n                    'use moment.updateLocale(localeName, config) to change ' +\n                    'an existing locale. moment.defineLocale(localeName, ' +\n                    'config) should only be used for creating a new locale ' +\n                    'See http://momentjs.com/guides/#/warnings/define-locale/ for more info.');\n            parentConfig = locales[name]._config;\n        } else if (config.parentLocale != null) {\n            if (locales[config.parentLocale] != null) {\n                parentConfig = locales[config.parentLocale]._config;\n            } else {\n                if (!localeFamilies[config.parentLocale]) {\n                    localeFamilies[config.parentLocale] = [];\n                }\n                localeFamilies[config.parentLocale].push({\n                    name: name,\n                    config: config\n                });\n                return null;\n            }\n        }\n        locales[name] = new Locale(mergeConfigs(parentConfig, config));\n\n        if (localeFamilies[name]) {\n            localeFamilies[name].forEach(function (x) {\n                defineLocale(x.name, x.config);\n            });\n        }\n\n        // backwards compat for now: also set the locale\n        // make sure we set the locale AFTER all child locales have been\n        // created, so we won't end up with the child locale set.\n        getSetGlobalLocale(name);\n\n\n        return locales[name];\n    } else {\n        // useful for testing\n        delete locales[name];\n        return null;\n    }\n}\n\nfunction updateLocale(name, config) {\n    if (config != null) {\n        var locale, parentConfig = baseConfig;\n        // MERGE\n        if (locales[name] != null) {\n            parentConfig = locales[name]._config;\n        }\n        config = mergeConfigs(parentConfig, config);\n        locale = new Locale(config);\n        locale.parentLocale = locales[name];\n        locales[name] = locale;\n\n        // backwards compat for now: also set the locale\n        getSetGlobalLocale(name);\n    } else {\n        // pass null for config to unupdate, useful for tests\n        if (locales[name] != null) {\n            if (locales[name].parentLocale != null) {\n                locales[name] = locales[name].parentLocale;\n            } else if (locales[name] != null) {\n                delete locales[name];\n            }\n        }\n    }\n    return locales[name];\n}\n\n// returns locale data\nfunction getLocale (key) {\n    var locale;\n\n    if (key && key._locale && key._locale._abbr) {\n        key = key._locale._abbr;\n    }\n\n    if (!key) {\n        return globalLocale;\n    }\n\n    if (!isArray(key)) {\n        //short-circuit everything else\n        locale = loadLocale(key);\n        if (locale) {\n            return locale;\n        }\n        key = [key];\n    }\n\n    return chooseLocale(key);\n}\n\nfunction listLocales() {\n    return keys$1(locales);\n}\n\nfunction checkOverflow (m) {\n    var overflow;\n    var a = m._a;\n\n    if (a && getParsingFlags(m).overflow === -2) {\n        overflow =\n            a[MONTH]       < 0 || a[MONTH]       > 11  ? MONTH :\n            a[DATE]        < 1 || a[DATE]        > daysInMonth(a[YEAR], a[MONTH]) ? DATE :\n            a[HOUR]        < 0 || a[HOUR]        > 24 || (a[HOUR] === 24 && (a[MINUTE] !== 0 || a[SECOND] !== 0 || a[MILLISECOND] !== 0)) ? HOUR :\n            a[MINUTE]      < 0 || a[MINUTE]      > 59  ? MINUTE :\n            a[SECOND]      < 0 || a[SECOND]      > 59  ? SECOND :\n            a[MILLISECOND] < 0 || a[MILLISECOND] > 999 ? MILLISECOND :\n            -1;\n\n        if (getParsingFlags(m)._overflowDayOfYear && (overflow < YEAR || overflow > DATE)) {\n            overflow = DATE;\n        }\n        if (getParsingFlags(m)._overflowWeeks && overflow === -1) {\n            overflow = WEEK;\n        }\n        if (getParsingFlags(m)._overflowWeekday && overflow === -1) {\n            overflow = WEEKDAY;\n        }\n\n        getParsingFlags(m).overflow = overflow;\n    }\n\n    return m;\n}\n\n// iso 8601 regex\n// 0000-00-00 0000-W00 or 0000-W00-0 + T + 00 or 00:00 or 00:00:00 or 00:00:00.000 + +00:00 or +0000 or +00)\nvar extendedIsoRegex = /^\\s*((?:[+-]\\d{6}|\\d{4})-(?:\\d\\d-\\d\\d|W\\d\\d-\\d|W\\d\\d|\\d\\d\\d|\\d\\d))(?:(T| )(\\d\\d(?::\\d\\d(?::\\d\\d(?:[.,]\\d+)?)?)?)([\\+\\-]\\d\\d(?::?\\d\\d)?|\\s*Z)?)?$/;\nvar basicIsoRegex = /^\\s*((?:[+-]\\d{6}|\\d{4})(?:\\d\\d\\d\\d|W\\d\\d\\d|W\\d\\d|\\d\\d\\d|\\d\\d))(?:(T| )(\\d\\d(?:\\d\\d(?:\\d\\d(?:[.,]\\d+)?)?)?)([\\+\\-]\\d\\d(?::?\\d\\d)?|\\s*Z)?)?$/;\n\nvar tzRegex = /Z|[+-]\\d\\d(?::?\\d\\d)?/;\n\nvar isoDates = [\n    ['YYYYYY-MM-DD', /[+-]\\d{6}-\\d\\d-\\d\\d/],\n    ['YYYY-MM-DD', /\\d{4}-\\d\\d-\\d\\d/],\n    ['GGGG-[W]WW-E', /\\d{4}-W\\d\\d-\\d/],\n    ['GGGG-[W]WW', /\\d{4}-W\\d\\d/, false],\n    ['YYYY-DDD', /\\d{4}-\\d{3}/],\n    ['YYYY-MM', /\\d{4}-\\d\\d/, false],\n    ['YYYYYYMMDD', /[+-]\\d{10}/],\n    ['YYYYMMDD', /\\d{8}/],\n    // YYYYMM is NOT allowed by the standard\n    ['GGGG[W]WWE', /\\d{4}W\\d{3}/],\n    ['GGGG[W]WW', /\\d{4}W\\d{2}/, false],\n    ['YYYYDDD', /\\d{7}/]\n];\n\n// iso time formats and regexes\nvar isoTimes = [\n    ['HH:mm:ss.SSSS', /\\d\\d:\\d\\d:\\d\\d\\.\\d+/],\n    ['HH:mm:ss,SSSS', /\\d\\d:\\d\\d:\\d\\d,\\d+/],\n    ['HH:mm:ss', /\\d\\d:\\d\\d:\\d\\d/],\n    ['HH:mm', /\\d\\d:\\d\\d/],\n    ['HHmmss.SSSS', /\\d\\d\\d\\d\\d\\d\\.\\d+/],\n    ['HHmmss,SSSS', /\\d\\d\\d\\d\\d\\d,\\d+/],\n    ['HHmmss', /\\d\\d\\d\\d\\d\\d/],\n    ['HHmm', /\\d\\d\\d\\d/],\n    ['HH', /\\d\\d/]\n];\n\nvar aspNetJsonRegex = /^\\/?Date\\((\\-?\\d+)/i;\n\n// date from iso format\nfunction configFromISO(config) {\n    var i, l,\n        string = config._i,\n        match = extendedIsoRegex.exec(string) || basicIsoRegex.exec(string),\n        allowTime, dateFormat, timeFormat, tzFormat;\n\n    if (match) {\n        getParsingFlags(config).iso = true;\n\n        for (i = 0, l = isoDates.length; i < l; i++) {\n            if (isoDates[i][1].exec(match[1])) {\n                dateFormat = isoDates[i][0];\n                allowTime = isoDates[i][2] !== false;\n                break;\n            }\n        }\n        if (dateFormat == null) {\n            config._isValid = false;\n            return;\n        }\n        if (match[3]) {\n            for (i = 0, l = isoTimes.length; i < l; i++) {\n                if (isoTimes[i][1].exec(match[3])) {\n                    // match[2] should be 'T' or space\n                    timeFormat = (match[2] || ' ') + isoTimes[i][0];\n                    break;\n                }\n            }\n            if (timeFormat == null) {\n                config._isValid = false;\n                return;\n            }\n        }\n        if (!allowTime && timeFormat != null) {\n            config._isValid = false;\n            return;\n        }\n        if (match[4]) {\n            if (tzRegex.exec(match[4])) {\n                tzFormat = 'Z';\n            } else {\n                config._isValid = false;\n                return;\n            }\n        }\n        config._f = dateFormat + (timeFormat || '') + (tzFormat || '');\n        configFromStringAndFormat(config);\n    } else {\n        config._isValid = false;\n    }\n}\n\n// RFC 2822 regex: For details see https://tools.ietf.org/html/rfc2822#section-3.3\nvar basicRfcRegex = /^((?:Mon|Tue|Wed|Thu|Fri|Sat|Sun),?\\s)?(\\d?\\d\\s(?:Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\\s(?:\\d\\d)?\\d\\d\\s)(\\d\\d:\\d\\d)(\\:\\d\\d)?(\\s(?:UT|GMT|[ECMP][SD]T|[A-IK-Za-ik-z]|[+-]\\d{4}))$/;\n\n// date and time from ref 2822 format\nfunction configFromRFC2822(config) {\n    var string, match, dayFormat,\n        dateFormat, timeFormat, tzFormat;\n    var timezones = {\n        ' GMT': ' +0000',\n        ' EDT': ' -0400',\n        ' EST': ' -0500',\n        ' CDT': ' -0500',\n        ' CST': ' -0600',\n        ' MDT': ' -0600',\n        ' MST': ' -0700',\n        ' PDT': ' -0700',\n        ' PST': ' -0800'\n    };\n    var military = 'YXWVUTSRQPONZABCDEFGHIKLM';\n    var timezone, timezoneIndex;\n\n    string = config._i\n        .replace(/\\([^\\)]*\\)|[\\n\\t]/g, ' ') // Remove comments and folding whitespace\n        .replace(/(\\s\\s+)/g, ' ') // Replace multiple-spaces with a single space\n        .replace(/^\\s|\\s$/g, ''); // Remove leading and trailing spaces\n    match = basicRfcRegex.exec(string);\n\n    if (match) {\n        dayFormat = match[1] ? 'ddd' + ((match[1].length === 5) ? ', ' : ' ') : '';\n        dateFormat = 'D MMM ' + ((match[2].length > 10) ? 'YYYY ' : 'YY ');\n        timeFormat = 'HH:mm' + (match[4] ? ':ss' : '');\n\n        // TODO: Replace the vanilla JS Date object with an indepentent day-of-week check.\n        if (match[1]) { // day of week given\n            var momentDate = new Date(match[2]);\n            var momentDay = ['Sun','Mon','Tue','Wed','Thu','Fri','Sat'][momentDate.getDay()];\n\n            if (match[1].substr(0,3) !== momentDay) {\n                getParsingFlags(config).weekdayMismatch = true;\n                config._isValid = false;\n                return;\n            }\n        }\n\n        switch (match[5].length) {\n            case 2: // military\n                if (timezoneIndex === 0) {\n                    timezone = ' +0000';\n                } else {\n                    timezoneIndex = military.indexOf(match[5][1].toUpperCase()) - 12;\n                    timezone = ((timezoneIndex < 0) ? ' -' : ' +') +\n                        (('' + timezoneIndex).replace(/^-?/, '0')).match(/..$/)[0] + '00';\n                }\n                break;\n            case 4: // Zone\n                timezone = timezones[match[5]];\n                break;\n            default: // UT or +/-9999\n                timezone = timezones[' GMT'];\n        }\n        match[5] = timezone;\n        config._i = match.splice(1).join('');\n        tzFormat = ' ZZ';\n        config._f = dayFormat + dateFormat + timeFormat + tzFormat;\n        configFromStringAndFormat(config);\n        getParsingFlags(config).rfc2822 = true;\n    } else {\n        config._isValid = false;\n    }\n}\n\n// date from iso format or fallback\nfunction configFromString(config) {\n    var matched = aspNetJsonRegex.exec(config._i);\n\n    if (matched !== null) {\n        config._d = new Date(+matched[1]);\n        return;\n    }\n\n    configFromISO(config);\n    if (config._isValid === false) {\n        delete config._isValid;\n    } else {\n        return;\n    }\n\n    configFromRFC2822(config);\n    if (config._isValid === false) {\n        delete config._isValid;\n    } else {\n        return;\n    }\n\n    // Final attempt, use Input Fallback\n    hooks.createFromInputFallback(config);\n}\n\nhooks.createFromInputFallback = deprecate(\n    'value provided is not in a recognized RFC2822 or ISO format. moment construction falls back to js Date(), ' +\n    'which is not reliable across all browsers and versions. Non RFC2822/ISO date formats are ' +\n    'discouraged and will be removed in an upcoming major release. Please refer to ' +\n    'http://momentjs.com/guides/#/warnings/js-date/ for more info.',\n    function (config) {\n        config._d = new Date(config._i + (config._useUTC ? ' UTC' : ''));\n    }\n);\n\n// Pick the first defined of two or three arguments.\nfunction defaults(a, b, c) {\n    if (a != null) {\n        return a;\n    }\n    if (b != null) {\n        return b;\n    }\n    return c;\n}\n\nfunction currentDateArray(config) {\n    // hooks is actually the exported moment object\n    var nowValue = new Date(hooks.now());\n    if (config._useUTC) {\n        return [nowValue.getUTCFullYear(), nowValue.getUTCMonth(), nowValue.getUTCDate()];\n    }\n    return [nowValue.getFullYear(), nowValue.getMonth(), nowValue.getDate()];\n}\n\n// convert an array to a date.\n// the array should mirror the parameters below\n// note: all values past the year are optional and will default to the lowest possible value.\n// [year, month, day , hour, minute, second, millisecond]\nfunction configFromArray (config) {\n    var i, date, input = [], currentDate, yearToUse;\n\n    if (config._d) {\n        return;\n    }\n\n    currentDate = currentDateArray(config);\n\n    //compute day of the year from weeks and weekdays\n    if (config._w && config._a[DATE] == null && config._a[MONTH] == null) {\n        dayOfYearFromWeekInfo(config);\n    }\n\n    //if the day of the year is set, figure out what it is\n    if (config._dayOfYear != null) {\n        yearToUse = defaults(config._a[YEAR], currentDate[YEAR]);\n\n        if (config._dayOfYear > daysInYear(yearToUse) || config._dayOfYear === 0) {\n            getParsingFlags(config)._overflowDayOfYear = true;\n        }\n\n        date = createUTCDate(yearToUse, 0, config._dayOfYear);\n        config._a[MONTH] = date.getUTCMonth();\n        config._a[DATE] = date.getUTCDate();\n    }\n\n    // Default to current date.\n    // * if no year, month, day of month are given, default to today\n    // * if day of month is given, default month and year\n    // * if month is given, default only year\n    // * if year is given, don't default anything\n    for (i = 0; i < 3 && config._a[i] == null; ++i) {\n        config._a[i] = input[i] = currentDate[i];\n    }\n\n    // Zero out whatever was not defaulted, including time\n    for (; i < 7; i++) {\n        config._a[i] = input[i] = (config._a[i] == null) ? (i === 2 ? 1 : 0) : config._a[i];\n    }\n\n    // Check for 24:00:00.000\n    if (config._a[HOUR] === 24 &&\n            config._a[MINUTE] === 0 &&\n            config._a[SECOND] === 0 &&\n            config._a[MILLISECOND] === 0) {\n        config._nextDay = true;\n        config._a[HOUR] = 0;\n    }\n\n    config._d = (config._useUTC ? createUTCDate : createDate).apply(null, input);\n    // Apply timezone offset from input. The actual utcOffset can be changed\n    // with parseZone.\n    if (config._tzm != null) {\n        config._d.setUTCMinutes(config._d.getUTCMinutes() - config._tzm);\n    }\n\n    if (config._nextDay) {\n        config._a[HOUR] = 24;\n    }\n}\n\nfunction dayOfYearFromWeekInfo(config) {\n    var w, weekYear, week, weekday, dow, doy, temp, weekdayOverflow;\n\n    w = config._w;\n    if (w.GG != null || w.W != null || w.E != null) {\n        dow = 1;\n        doy = 4;\n\n        // TODO: We need to take the current isoWeekYear, but that depends on\n        // how we interpret now (local, utc, fixed offset). So create\n        // a now version of current config (take local/utc/offset flags, and\n        // create now).\n        weekYear = defaults(w.GG, config._a[YEAR], weekOfYear(createLocal(), 1, 4).year);\n        week = defaults(w.W, 1);\n        weekday = defaults(w.E, 1);\n        if (weekday < 1 || weekday > 7) {\n            weekdayOverflow = true;\n        }\n    } else {\n        dow = config._locale._week.dow;\n        doy = config._locale._week.doy;\n\n        var curWeek = weekOfYear(createLocal(), dow, doy);\n\n        weekYear = defaults(w.gg, config._a[YEAR], curWeek.year);\n\n        // Default to current week.\n        week = defaults(w.w, curWeek.week);\n\n        if (w.d != null) {\n            // weekday -- low day numbers are considered next week\n            weekday = w.d;\n            if (weekday < 0 || weekday > 6) {\n                weekdayOverflow = true;\n            }\n        } else if (w.e != null) {\n            // local weekday -- counting starts from begining of week\n            weekday = w.e + dow;\n            if (w.e < 0 || w.e > 6) {\n                weekdayOverflow = true;\n            }\n        } else {\n            // default to begining of week\n            weekday = dow;\n        }\n    }\n    if (week < 1 || week > weeksInYear(weekYear, dow, doy)) {\n        getParsingFlags(config)._overflowWeeks = true;\n    } else if (weekdayOverflow != null) {\n        getParsingFlags(config)._overflowWeekday = true;\n    } else {\n        temp = dayOfYearFromWeeks(weekYear, week, weekday, dow, doy);\n        config._a[YEAR] = temp.year;\n        config._dayOfYear = temp.dayOfYear;\n    }\n}\n\n// constant that refers to the ISO standard\nhooks.ISO_8601 = function () {};\n\n// constant that refers to the RFC 2822 form\nhooks.RFC_2822 = function () {};\n\n// date from string and format string\nfunction configFromStringAndFormat(config) {\n    // TODO: Move this to another part of the creation flow to prevent circular deps\n    if (config._f === hooks.ISO_8601) {\n        configFromISO(config);\n        return;\n    }\n    if (config._f === hooks.RFC_2822) {\n        configFromRFC2822(config);\n        return;\n    }\n    config._a = [];\n    getParsingFlags(config).empty = true;\n\n    // This array is used to make a Date, either with `new Date` or `Date.UTC`\n    var string = '' + config._i,\n        i, parsedInput, tokens, token, skipped,\n        stringLength = string.length,\n        totalParsedInputLength = 0;\n\n    tokens = expandFormat(config._f, config._locale).match(formattingTokens) || [];\n\n    for (i = 0; i < tokens.length; i++) {\n        token = tokens[i];\n        parsedInput = (string.match(getParseRegexForToken(token, config)) || [])[0];\n        // console.log('token', token, 'parsedInput', parsedInput,\n        //         'regex', getParseRegexForToken(token, config));\n        if (parsedInput) {\n            skipped = string.substr(0, string.indexOf(parsedInput));\n            if (skipped.length > 0) {\n                getParsingFlags(config).unusedInput.push(skipped);\n            }\n            string = string.slice(string.indexOf(parsedInput) + parsedInput.length);\n            totalParsedInputLength += parsedInput.length;\n        }\n        // don't parse if it's not a known token\n        if (formatTokenFunctions[token]) {\n            if (parsedInput) {\n                getParsingFlags(config).empty = false;\n            }\n            else {\n                getParsingFlags(config).unusedTokens.push(token);\n            }\n            addTimeToArrayFromToken(token, parsedInput, config);\n        }\n        else if (config._strict && !parsedInput) {\n            getParsingFlags(config).unusedTokens.push(token);\n        }\n    }\n\n    // add remaining unparsed input length to the string\n    getParsingFlags(config).charsLeftOver = stringLength - totalParsedInputLength;\n    if (string.length > 0) {\n        getParsingFlags(config).unusedInput.push(string);\n    }\n\n    // clear _12h flag if hour is <= 12\n    if (config._a[HOUR] <= 12 &&\n        getParsingFlags(config).bigHour === true &&\n        config._a[HOUR] > 0) {\n        getParsingFlags(config).bigHour = undefined;\n    }\n\n    getParsingFlags(config).parsedDateParts = config._a.slice(0);\n    getParsingFlags(config).meridiem = config._meridiem;\n    // handle meridiem\n    config._a[HOUR] = meridiemFixWrap(config._locale, config._a[HOUR], config._meridiem);\n\n    configFromArray(config);\n    checkOverflow(config);\n}\n\n\nfunction meridiemFixWrap (locale, hour, meridiem) {\n    var isPm;\n\n    if (meridiem == null) {\n        // nothing to do\n        return hour;\n    }\n    if (locale.meridiemHour != null) {\n        return locale.meridiemHour(hour, meridiem);\n    } else if (locale.isPM != null) {\n        // Fallback\n        isPm = locale.isPM(meridiem);\n        if (isPm && hour < 12) {\n            hour += 12;\n        }\n        if (!isPm && hour === 12) {\n            hour = 0;\n        }\n        return hour;\n    } else {\n        // this is not supposed to happen\n        return hour;\n    }\n}\n\n// date from string and array of format strings\nfunction configFromStringAndArray(config) {\n    var tempConfig,\n        bestMoment,\n\n        scoreToBeat,\n        i,\n        currentScore;\n\n    if (config._f.length === 0) {\n        getParsingFlags(config).invalidFormat = true;\n        config._d = new Date(NaN);\n        return;\n    }\n\n    for (i = 0; i < config._f.length; i++) {\n        currentScore = 0;\n        tempConfig = copyConfig({}, config);\n        if (config._useUTC != null) {\n            tempConfig._useUTC = config._useUTC;\n        }\n        tempConfig._f = config._f[i];\n        configFromStringAndFormat(tempConfig);\n\n        if (!isValid(tempConfig)) {\n            continue;\n        }\n\n        // if there is any input that was not parsed add a penalty for that format\n        currentScore += getParsingFlags(tempConfig).charsLeftOver;\n\n        //or tokens\n        currentScore += getParsingFlags(tempConfig).unusedTokens.length * 10;\n\n        getParsingFlags(tempConfig).score = currentScore;\n\n        if (scoreToBeat == null || currentScore < scoreToBeat) {\n            scoreToBeat = currentScore;\n            bestMoment = tempConfig;\n        }\n    }\n\n    extend(config, bestMoment || tempConfig);\n}\n\nfunction configFromObject(config) {\n    if (config._d) {\n        return;\n    }\n\n    var i = normalizeObjectUnits(config._i);\n    config._a = map([i.year, i.month, i.day || i.date, i.hour, i.minute, i.second, i.millisecond], function (obj) {\n        return obj && parseInt(obj, 10);\n    });\n\n    configFromArray(config);\n}\n\nfunction createFromConfig (config) {\n    var res = new Moment(checkOverflow(prepareConfig(config)));\n    if (res._nextDay) {\n        // Adding is smart enough around DST\n        res.add(1, 'd');\n        res._nextDay = undefined;\n    }\n\n    return res;\n}\n\nfunction prepareConfig (config) {\n    var input = config._i,\n        format = config._f;\n\n    config._locale = config._locale || getLocale(config._l);\n\n    if (input === null || (format === undefined && input === '')) {\n        return createInvalid({nullInput: true});\n    }\n\n    if (typeof input === 'string') {\n        config._i = input = config._locale.preparse(input);\n    }\n\n    if (isMoment(input)) {\n        return new Moment(checkOverflow(input));\n    } else if (isDate(input)) {\n        config._d = input;\n    } else if (isArray(format)) {\n        configFromStringAndArray(config);\n    } else if (format) {\n        configFromStringAndFormat(config);\n    }  else {\n        configFromInput(config);\n    }\n\n    if (!isValid(config)) {\n        config._d = null;\n    }\n\n    return config;\n}\n\nfunction configFromInput(config) {\n    var input = config._i;\n    if (isUndefined(input)) {\n        config._d = new Date(hooks.now());\n    } else if (isDate(input)) {\n        config._d = new Date(input.valueOf());\n    } else if (typeof input === 'string') {\n        configFromString(config);\n    } else if (isArray(input)) {\n        config._a = map(input.slice(0), function (obj) {\n            return parseInt(obj, 10);\n        });\n        configFromArray(config);\n    } else if (isObject(input)) {\n        configFromObject(config);\n    } else if (isNumber(input)) {\n        // from milliseconds\n        config._d = new Date(input);\n    } else {\n        hooks.createFromInputFallback(config);\n    }\n}\n\nfunction createLocalOrUTC (input, format, locale, strict, isUTC) {\n    var c = {};\n\n    if (locale === true || locale === false) {\n        strict = locale;\n        locale = undefined;\n    }\n\n    if ((isObject(input) && isObjectEmpty(input)) ||\n            (isArray(input) && input.length === 0)) {\n        input = undefined;\n    }\n    // object construction must be done this way.\n    // https://github.com/moment/moment/issues/1423\n    c._isAMomentObject = true;\n    c._useUTC = c._isUTC = isUTC;\n    c._l = locale;\n    c._i = input;\n    c._f = format;\n    c._strict = strict;\n\n    return createFromConfig(c);\n}\n\nfunction createLocal (input, format, locale, strict) {\n    return createLocalOrUTC(input, format, locale, strict, false);\n}\n\nvar prototypeMin = deprecate(\n    'moment().min is deprecated, use moment.max instead. http://momentjs.com/guides/#/warnings/min-max/',\n    function () {\n        var other = createLocal.apply(null, arguments);\n        if (this.isValid() && other.isValid()) {\n            return other < this ? this : other;\n        } else {\n            return createInvalid();\n        }\n    }\n);\n\nvar prototypeMax = deprecate(\n    'moment().max is deprecated, use moment.min instead. http://momentjs.com/guides/#/warnings/min-max/',\n    function () {\n        var other = createLocal.apply(null, arguments);\n        if (this.isValid() && other.isValid()) {\n            return other > this ? this : other;\n        } else {\n            return createInvalid();\n        }\n    }\n);\n\n// Pick a moment m from moments so that m[fn](other) is true for all\n// other. This relies on the function fn to be transitive.\n//\n// moments should either be an array of moment objects or an array, whose\n// first element is an array of moment objects.\nfunction pickBy(fn, moments) {\n    var res, i;\n    if (moments.length === 1 && isArray(moments[0])) {\n        moments = moments[0];\n    }\n    if (!moments.length) {\n        return createLocal();\n    }\n    res = moments[0];\n    for (i = 1; i < moments.length; ++i) {\n        if (!moments[i].isValid() || moments[i][fn](res)) {\n            res = moments[i];\n        }\n    }\n    return res;\n}\n\n// TODO: Use [].sort instead?\nfunction min () {\n    var args = [].slice.call(arguments, 0);\n\n    return pickBy('isBefore', args);\n}\n\nfunction max () {\n    var args = [].slice.call(arguments, 0);\n\n    return pickBy('isAfter', args);\n}\n\nvar now = function () {\n    return Date.now ? Date.now() : +(new Date());\n};\n\nvar ordering = ['year', 'quarter', 'month', 'week', 'day', 'hour', 'minute', 'second', 'millisecond'];\n\nfunction isDurationValid(m) {\n    for (var key in m) {\n        if (!(ordering.indexOf(key) !== -1 && (m[key] == null || !isNaN(m[key])))) {\n            return false;\n        }\n    }\n\n    var unitHasDecimal = false;\n    for (var i = 0; i < ordering.length; ++i) {\n        if (m[ordering[i]]) {\n            if (unitHasDecimal) {\n                return false; // only allow non-integers for smallest unit\n            }\n            if (parseFloat(m[ordering[i]]) !== toInt(m[ordering[i]])) {\n                unitHasDecimal = true;\n            }\n        }\n    }\n\n    return true;\n}\n\nfunction isValid$1() {\n    return this._isValid;\n}\n\nfunction createInvalid$1() {\n    return createDuration(NaN);\n}\n\nfunction Duration (duration) {\n    var normalizedInput = normalizeObjectUnits(duration),\n        years = normalizedInput.year || 0,\n        quarters = normalizedInput.quarter || 0,\n        months = normalizedInput.month || 0,\n        weeks = normalizedInput.week || 0,\n        days = normalizedInput.day || 0,\n        hours = normalizedInput.hour || 0,\n        minutes = normalizedInput.minute || 0,\n        seconds = normalizedInput.second || 0,\n        milliseconds = normalizedInput.millisecond || 0;\n\n    this._isValid = isDurationValid(normalizedInput);\n\n    // representation for dateAddRemove\n    this._milliseconds = +milliseconds +\n        seconds * 1e3 + // 1000\n        minutes * 6e4 + // 1000 * 60\n        hours * 1000 * 60 * 60; //using 1000 * 60 * 60 instead of 36e5 to avoid floating point rounding errors https://github.com/moment/moment/issues/2978\n    // Because of dateAddRemove treats 24 hours as different from a\n    // day when working around DST, we need to store them separately\n    this._days = +days +\n        weeks * 7;\n    // It is impossible translate months into days without knowing\n    // which months you are are talking about, so we have to store\n    // it separately.\n    this._months = +months +\n        quarters * 3 +\n        years * 12;\n\n    this._data = {};\n\n    this._locale = getLocale();\n\n    this._bubble();\n}\n\nfunction isDuration (obj) {\n    return obj instanceof Duration;\n}\n\nfunction absRound (number) {\n    if (number < 0) {\n        return Math.round(-1 * number) * -1;\n    } else {\n        return Math.round(number);\n    }\n}\n\n// FORMATTING\n\nfunction offset (token, separator) {\n    addFormatToken(token, 0, 0, function () {\n        var offset = this.utcOffset();\n        var sign = '+';\n        if (offset < 0) {\n            offset = -offset;\n            sign = '-';\n        }\n        return sign + zeroFill(~~(offset / 60), 2) + separator + zeroFill(~~(offset) % 60, 2);\n    });\n}\n\noffset('Z', ':');\noffset('ZZ', '');\n\n// PARSING\n\naddRegexToken('Z',  matchShortOffset);\naddRegexToken('ZZ', matchShortOffset);\naddParseToken(['Z', 'ZZ'], function (input, array, config) {\n    config._useUTC = true;\n    config._tzm = offsetFromString(matchShortOffset, input);\n});\n\n// HELPERS\n\n// timezone chunker\n// '+10:00' > ['10',  '00']\n// '-1530'  > ['-15', '30']\nvar chunkOffset = /([\\+\\-]|\\d\\d)/gi;\n\nfunction offsetFromString(matcher, string) {\n    var matches = (string || '').match(matcher);\n\n    if (matches === null) {\n        return null;\n    }\n\n    var chunk   = matches[matches.length - 1] || [];\n    var parts   = (chunk + '').match(chunkOffset) || ['-', 0, 0];\n    var minutes = +(parts[1] * 60) + toInt(parts[2]);\n\n    return minutes === 0 ?\n      0 :\n      parts[0] === '+' ? minutes : -minutes;\n}\n\n// Return a moment from input, that is local/utc/zone equivalent to model.\nfunction cloneWithOffset(input, model) {\n    var res, diff;\n    if (model._isUTC) {\n        res = model.clone();\n        diff = (isMoment(input) || isDate(input) ? input.valueOf() : createLocal(input).valueOf()) - res.valueOf();\n        // Use low-level api, because this fn is low-level api.\n        res._d.setTime(res._d.valueOf() + diff);\n        hooks.updateOffset(res, false);\n        return res;\n    } else {\n        return createLocal(input).local();\n    }\n}\n\nfunction getDateOffset (m) {\n    // On Firefox.24 Date#getTimezoneOffset returns a floating point.\n    // https://github.com/moment/moment/pull/1871\n    return -Math.round(m._d.getTimezoneOffset() / 15) * 15;\n}\n\n// HOOKS\n\n// This function will be called whenever a moment is mutated.\n// It is intended to keep the offset in sync with the timezone.\nhooks.updateOffset = function () {};\n\n// MOMENTS\n\n// keepLocalTime = true means only change the timezone, without\n// affecting the local hour. So 5:31:26 +0300 --[utcOffset(2, true)]-->\n// 5:31:26 +0200 It is possible that 5:31:26 doesn't exist with offset\n// +0200, so we adjust the time as needed, to be valid.\n//\n// Keeping the time actually adds/subtracts (one hour)\n// from the actual represented time. That is why we call updateOffset\n// a second time. In case it wants us to change the offset again\n// _changeInProgress == true case, then we have to adjust, because\n// there is no such time in the given timezone.\nfunction getSetOffset (input, keepLocalTime, keepMinutes) {\n    var offset = this._offset || 0,\n        localAdjust;\n    if (!this.isValid()) {\n        return input != null ? this : NaN;\n    }\n    if (input != null) {\n        if (typeof input === 'string') {\n            input = offsetFromString(matchShortOffset, input);\n            if (input === null) {\n                return this;\n            }\n        } else if (Math.abs(input) < 16 && !keepMinutes) {\n            input = input * 60;\n        }\n        if (!this._isUTC && keepLocalTime) {\n            localAdjust = getDateOffset(this);\n        }\n        this._offset = input;\n        this._isUTC = true;\n        if (localAdjust != null) {\n            this.add(localAdjust, 'm');\n        }\n        if (offset !== input) {\n            if (!keepLocalTime || this._changeInProgress) {\n                addSubtract(this, createDuration(input - offset, 'm'), 1, false);\n            } else if (!this._changeInProgress) {\n                this._changeInProgress = true;\n                hooks.updateOffset(this, true);\n                this._changeInProgress = null;\n            }\n        }\n        return this;\n    } else {\n        return this._isUTC ? offset : getDateOffset(this);\n    }\n}\n\nfunction getSetZone (input, keepLocalTime) {\n    if (input != null) {\n        if (typeof input !== 'string') {\n            input = -input;\n        }\n\n        this.utcOffset(input, keepLocalTime);\n\n        return this;\n    } else {\n        return -this.utcOffset();\n    }\n}\n\nfunction setOffsetToUTC (keepLocalTime) {\n    return this.utcOffset(0, keepLocalTime);\n}\n\nfunction setOffsetToLocal (keepLocalTime) {\n    if (this._isUTC) {\n        this.utcOffset(0, keepLocalTime);\n        this._isUTC = false;\n\n        if (keepLocalTime) {\n            this.subtract(getDateOffset(this), 'm');\n        }\n    }\n    return this;\n}\n\nfunction setOffsetToParsedOffset () {\n    if (this._tzm != null) {\n        this.utcOffset(this._tzm, false, true);\n    } else if (typeof this._i === 'string') {\n        var tZone = offsetFromString(matchOffset, this._i);\n        if (tZone != null) {\n            this.utcOffset(tZone);\n        }\n        else {\n            this.utcOffset(0, true);\n        }\n    }\n    return this;\n}\n\nfunction hasAlignedHourOffset (input) {\n    if (!this.isValid()) {\n        return false;\n    }\n    input = input ? createLocal(input).utcOffset() : 0;\n\n    return (this.utcOffset() - input) % 60 === 0;\n}\n\nfunction isDaylightSavingTime () {\n    return (\n        this.utcOffset() > this.clone().month(0).utcOffset() ||\n        this.utcOffset() > this.clone().month(5).utcOffset()\n    );\n}\n\nfunction isDaylightSavingTimeShifted () {\n    if (!isUndefined(this._isDSTShifted)) {\n        return this._isDSTShifted;\n    }\n\n    var c = {};\n\n    copyConfig(c, this);\n    c = prepareConfig(c);\n\n    if (c._a) {\n        var other = c._isUTC ? createUTC(c._a) : createLocal(c._a);\n        this._isDSTShifted = this.isValid() &&\n            compareArrays(c._a, other.toArray()) > 0;\n    } else {\n        this._isDSTShifted = false;\n    }\n\n    return this._isDSTShifted;\n}\n\nfunction isLocal () {\n    return this.isValid() ? !this._isUTC : false;\n}\n\nfunction isUtcOffset () {\n    return this.isValid() ? this._isUTC : false;\n}\n\nfunction isUtc () {\n    return this.isValid() ? this._isUTC && this._offset === 0 : false;\n}\n\n// ASP.NET json date format regex\nvar aspNetRegex = /^(\\-)?(?:(\\d*)[. ])?(\\d+)\\:(\\d+)(?:\\:(\\d+)(\\.\\d*)?)?$/;\n\n// from http://docs.closure-library.googlecode.com/git/closure_goog_date_date.js.source.html\n// somewhat more in line with 4.4.3.2 2004 spec, but allows decimal anywhere\n// and further modified to allow for strings containing both week and day\nvar isoRegex = /^(-)?P(?:(-?[0-9,.]*)Y)?(?:(-?[0-9,.]*)M)?(?:(-?[0-9,.]*)W)?(?:(-?[0-9,.]*)D)?(?:T(?:(-?[0-9,.]*)H)?(?:(-?[0-9,.]*)M)?(?:(-?[0-9,.]*)S)?)?$/;\n\nfunction createDuration (input, key) {\n    var duration = input,\n        // matching against regexp is expensive, do it on demand\n        match = null,\n        sign,\n        ret,\n        diffRes;\n\n    if (isDuration(input)) {\n        duration = {\n            ms : input._milliseconds,\n            d  : input._days,\n            M  : input._months\n        };\n    } else if (isNumber(input)) {\n        duration = {};\n        if (key) {\n            duration[key] = input;\n        } else {\n            duration.milliseconds = input;\n        }\n    } else if (!!(match = aspNetRegex.exec(input))) {\n        sign = (match[1] === '-') ? -1 : 1;\n        duration = {\n            y  : 0,\n            d  : toInt(match[DATE])                         * sign,\n            h  : toInt(match[HOUR])                         * sign,\n            m  : toInt(match[MINUTE])                       * sign,\n            s  : toInt(match[SECOND])                       * sign,\n            ms : toInt(absRound(match[MILLISECOND] * 1000)) * sign // the millisecond decimal point is included in the match\n        };\n    } else if (!!(match = isoRegex.exec(input))) {\n        sign = (match[1] === '-') ? -1 : 1;\n        duration = {\n            y : parseIso(match[2], sign),\n            M : parseIso(match[3], sign),\n            w : parseIso(match[4], sign),\n            d : parseIso(match[5], sign),\n            h : parseIso(match[6], sign),\n            m : parseIso(match[7], sign),\n            s : parseIso(match[8], sign)\n        };\n    } else if (duration == null) {// checks for null or undefined\n        duration = {};\n    } else if (typeof duration === 'object' && ('from' in duration || 'to' in duration)) {\n        diffRes = momentsDifference(createLocal(duration.from), createLocal(duration.to));\n\n        duration = {};\n        duration.ms = diffRes.milliseconds;\n        duration.M = diffRes.months;\n    }\n\n    ret = new Duration(duration);\n\n    if (isDuration(input) && hasOwnProp(input, '_locale')) {\n        ret._locale = input._locale;\n    }\n\n    return ret;\n}\n\ncreateDuration.fn = Duration.prototype;\ncreateDuration.invalid = createInvalid$1;\n\nfunction parseIso (inp, sign) {\n    // We'd normally use ~~inp for this, but unfortunately it also\n    // converts floats to ints.\n    // inp may be undefined, so careful calling replace on it.\n    var res = inp && parseFloat(inp.replace(',', '.'));\n    // apply sign while we're at it\n    return (isNaN(res) ? 0 : res) * sign;\n}\n\nfunction positiveMomentsDifference(base, other) {\n    var res = {milliseconds: 0, months: 0};\n\n    res.months = other.month() - base.month() +\n        (other.year() - base.year()) * 12;\n    if (base.clone().add(res.months, 'M').isAfter(other)) {\n        --res.months;\n    }\n\n    res.milliseconds = +other - +(base.clone().add(res.months, 'M'));\n\n    return res;\n}\n\nfunction momentsDifference(base, other) {\n    var res;\n    if (!(base.isValid() && other.isValid())) {\n        return {milliseconds: 0, months: 0};\n    }\n\n    other = cloneWithOffset(other, base);\n    if (base.isBefore(other)) {\n        res = positiveMomentsDifference(base, other);\n    } else {\n        res = positiveMomentsDifference(other, base);\n        res.milliseconds = -res.milliseconds;\n        res.months = -res.months;\n    }\n\n    return res;\n}\n\n// TODO: remove 'name' arg after deprecation is removed\nfunction createAdder(direction, name) {\n    return function (val, period) {\n        var dur, tmp;\n        //invert the arguments, but complain about it\n        if (period !== null && !isNaN(+period)) {\n            deprecateSimple(name, 'moment().' + name  + '(period, number) is deprecated. Please use moment().' + name + '(number, period). ' +\n            'See http://momentjs.com/guides/#/warnings/add-inverted-param/ for more info.');\n            tmp = val; val = period; period = tmp;\n        }\n\n        val = typeof val === 'string' ? +val : val;\n        dur = createDuration(val, period);\n        addSubtract(this, dur, direction);\n        return this;\n    };\n}\n\nfunction addSubtract (mom, duration, isAdding, updateOffset) {\n    var milliseconds = duration._milliseconds,\n        days = absRound(duration._days),\n        months = absRound(duration._months);\n\n    if (!mom.isValid()) {\n        // No op\n        return;\n    }\n\n    updateOffset = updateOffset == null ? true : updateOffset;\n\n    if (milliseconds) {\n        mom._d.setTime(mom._d.valueOf() + milliseconds * isAdding);\n    }\n    if (days) {\n        set$1(mom, 'Date', get(mom, 'Date') + days * isAdding);\n    }\n    if (months) {\n        setMonth(mom, get(mom, 'Month') + months * isAdding);\n    }\n    if (updateOffset) {\n        hooks.updateOffset(mom, days || months);\n    }\n}\n\nvar add      = createAdder(1, 'add');\nvar subtract = createAdder(-1, 'subtract');\n\nfunction getCalendarFormat(myMoment, now) {\n    var diff = myMoment.diff(now, 'days', true);\n    return diff < -6 ? 'sameElse' :\n            diff < -1 ? 'lastWeek' :\n            diff < 0 ? 'lastDay' :\n            diff < 1 ? 'sameDay' :\n            diff < 2 ? 'nextDay' :\n            diff < 7 ? 'nextWeek' : 'sameElse';\n}\n\nfunction calendar$1 (time, formats) {\n    // We want to compare the start of today, vs this.\n    // Getting start-of-today depends on whether we're local/utc/offset or not.\n    var now = time || createLocal(),\n        sod = cloneWithOffset(now, this).startOf('day'),\n        format = hooks.calendarFormat(this, sod) || 'sameElse';\n\n    var output = formats && (isFunction(formats[format]) ? formats[format].call(this, now) : formats[format]);\n\n    return this.format(output || this.localeData().calendar(format, this, createLocal(now)));\n}\n\nfunction clone () {\n    return new Moment(this);\n}\n\nfunction isAfter (input, units) {\n    var localInput = isMoment(input) ? input : createLocal(input);\n    if (!(this.isValid() && localInput.isValid())) {\n        return false;\n    }\n    units = normalizeUnits(!isUndefined(units) ? units : 'millisecond');\n    if (units === 'millisecond') {\n        return this.valueOf() > localInput.valueOf();\n    } else {\n        return localInput.valueOf() < this.clone().startOf(units).valueOf();\n    }\n}\n\nfunction isBefore (input, units) {\n    var localInput = isMoment(input) ? input : createLocal(input);\n    if (!(this.isValid() && localInput.isValid())) {\n        return false;\n    }\n    units = normalizeUnits(!isUndefined(units) ? units : 'millisecond');\n    if (units === 'millisecond') {\n        return this.valueOf() < localInput.valueOf();\n    } else {\n        return this.clone().endOf(units).valueOf() < localInput.valueOf();\n    }\n}\n\nfunction isBetween (from, to, units, inclusivity) {\n    inclusivity = inclusivity || '()';\n    return (inclusivity[0] === '(' ? this.isAfter(from, units) : !this.isBefore(from, units)) &&\n        (inclusivity[1] === ')' ? this.isBefore(to, units) : !this.isAfter(to, units));\n}\n\nfunction isSame (input, units) {\n    var localInput = isMoment(input) ? input : createLocal(input),\n        inputMs;\n    if (!(this.isValid() && localInput.isValid())) {\n        return false;\n    }\n    units = normalizeUnits(units || 'millisecond');\n    if (units === 'millisecond') {\n        return this.valueOf() === localInput.valueOf();\n    } else {\n        inputMs = localInput.valueOf();\n        return this.clone().startOf(units).valueOf() <= inputMs && inputMs <= this.clone().endOf(units).valueOf();\n    }\n}\n\nfunction isSameOrAfter (input, units) {\n    return this.isSame(input, units) || this.isAfter(input,units);\n}\n\nfunction isSameOrBefore (input, units) {\n    return this.isSame(input, units) || this.isBefore(input,units);\n}\n\nfunction diff (input, units, asFloat) {\n    var that,\n        zoneDelta,\n        delta, output;\n\n    if (!this.isValid()) {\n        return NaN;\n    }\n\n    that = cloneWithOffset(input, this);\n\n    if (!that.isValid()) {\n        return NaN;\n    }\n\n    zoneDelta = (that.utcOffset() - this.utcOffset()) * 6e4;\n\n    units = normalizeUnits(units);\n\n    if (units === 'year' || units === 'month' || units === 'quarter') {\n        output = monthDiff(this, that);\n        if (units === 'quarter') {\n            output = output / 3;\n        } else if (units === 'year') {\n            output = output / 12;\n        }\n    } else {\n        delta = this - that;\n        output = units === 'second' ? delta / 1e3 : // 1000\n            units === 'minute' ? delta / 6e4 : // 1000 * 60\n            units === 'hour' ? delta / 36e5 : // 1000 * 60 * 60\n            units === 'day' ? (delta - zoneDelta) / 864e5 : // 1000 * 60 * 60 * 24, negate dst\n            units === 'week' ? (delta - zoneDelta) / 6048e5 : // 1000 * 60 * 60 * 24 * 7, negate dst\n            delta;\n    }\n    return asFloat ? output : absFloor(output);\n}\n\nfunction monthDiff (a, b) {\n    // difference in months\n    var wholeMonthDiff = ((b.year() - a.year()) * 12) + (b.month() - a.month()),\n        // b is in (anchor - 1 month, anchor + 1 month)\n        anchor = a.clone().add(wholeMonthDiff, 'months'),\n        anchor2, adjust;\n\n    if (b - anchor < 0) {\n        anchor2 = a.clone().add(wholeMonthDiff - 1, 'months');\n        // linear across the month\n        adjust = (b - anchor) / (anchor - anchor2);\n    } else {\n        anchor2 = a.clone().add(wholeMonthDiff + 1, 'months');\n        // linear across the month\n        adjust = (b - anchor) / (anchor2 - anchor);\n    }\n\n    //check for negative zero, return zero if negative zero\n    return -(wholeMonthDiff + adjust) || 0;\n}\n\nhooks.defaultFormat = 'YYYY-MM-DDTHH:mm:ssZ';\nhooks.defaultFormatUtc = 'YYYY-MM-DDTHH:mm:ss[Z]';\n\nfunction toString () {\n    return this.clone().locale('en').format('ddd MMM DD YYYY HH:mm:ss [GMT]ZZ');\n}\n\nfunction toISOString() {\n    if (!this.isValid()) {\n        return null;\n    }\n    var m = this.clone().utc();\n    if (m.year() < 0 || m.year() > 9999) {\n        return formatMoment(m, 'YYYYYY-MM-DD[T]HH:mm:ss.SSS[Z]');\n    }\n    if (isFunction(Date.prototype.toISOString)) {\n        // native implementation is ~50x faster, use it when we can\n        return this.toDate().toISOString();\n    }\n    return formatMoment(m, 'YYYY-MM-DD[T]HH:mm:ss.SSS[Z]');\n}\n\n/**\n * Return a human readable representation of a moment that can\n * also be evaluated to get a new moment which is the same\n *\n * @link https://nodejs.org/dist/latest/docs/api/util.html#util_custom_inspect_function_on_objects\n */\nfunction inspect () {\n    if (!this.isValid()) {\n        return 'moment.invalid(/* ' + this._i + ' */)';\n    }\n    var func = 'moment';\n    var zone = '';\n    if (!this.isLocal()) {\n        func = this.utcOffset() === 0 ? 'moment.utc' : 'moment.parseZone';\n        zone = 'Z';\n    }\n    var prefix = '[' + func + '(\"]';\n    var year = (0 <= this.year() && this.year() <= 9999) ? 'YYYY' : 'YYYYYY';\n    var datetime = '-MM-DD[T]HH:mm:ss.SSS';\n    var suffix = zone + '[\")]';\n\n    return this.format(prefix + year + datetime + suffix);\n}\n\nfunction format (inputString) {\n    if (!inputString) {\n        inputString = this.isUtc() ? hooks.defaultFormatUtc : hooks.defaultFormat;\n    }\n    var output = formatMoment(this, inputString);\n    return this.localeData().postformat(output);\n}\n\nfunction from (time, withoutSuffix) {\n    if (this.isValid() &&\n            ((isMoment(time) && time.isValid()) ||\n             createLocal(time).isValid())) {\n        return createDuration({to: this, from: time}).locale(this.locale()).humanize(!withoutSuffix);\n    } else {\n        return this.localeData().invalidDate();\n    }\n}\n\nfunction fromNow (withoutSuffix) {\n    return this.from(createLocal(), withoutSuffix);\n}\n\nfunction to (time, withoutSuffix) {\n    if (this.isValid() &&\n            ((isMoment(time) && time.isValid()) ||\n             createLocal(time).isValid())) {\n        return createDuration({from: this, to: time}).locale(this.locale()).humanize(!withoutSuffix);\n    } else {\n        return this.localeData().invalidDate();\n    }\n}\n\nfunction toNow (withoutSuffix) {\n    return this.to(createLocal(), withoutSuffix);\n}\n\n// If passed a locale key, it will set the locale for this\n// instance.  Otherwise, it will return the locale configuration\n// variables for this instance.\nfunction locale (key) {\n    var newLocaleData;\n\n    if (key === undefined) {\n        return this._locale._abbr;\n    } else {\n        newLocaleData = getLocale(key);\n        if (newLocaleData != null) {\n            this._locale = newLocaleData;\n        }\n        return this;\n    }\n}\n\nvar lang = deprecate(\n    'moment().lang() is deprecated. Instead, use moment().localeData() to get the language configuration. Use moment().locale() to change languages.',\n    function (key) {\n        if (key === undefined) {\n            return this.localeData();\n        } else {\n            return this.locale(key);\n        }\n    }\n);\n\nfunction localeData () {\n    return this._locale;\n}\n\nfunction startOf (units) {\n    units = normalizeUnits(units);\n    // the following switch intentionally omits break keywords\n    // to utilize falling through the cases.\n    switch (units) {\n        case 'year':\n            this.month(0);\n            /* falls through */\n        case 'quarter':\n        case 'month':\n            this.date(1);\n            /* falls through */\n        case 'week':\n        case 'isoWeek':\n        case 'day':\n        case 'date':\n            this.hours(0);\n            /* falls through */\n        case 'hour':\n            this.minutes(0);\n            /* falls through */\n        case 'minute':\n            this.seconds(0);\n            /* falls through */\n        case 'second':\n            this.milliseconds(0);\n    }\n\n    // weeks are a special case\n    if (units === 'week') {\n        this.weekday(0);\n    }\n    if (units === 'isoWeek') {\n        this.isoWeekday(1);\n    }\n\n    // quarters are also special\n    if (units === 'quarter') {\n        this.month(Math.floor(this.month() / 3) * 3);\n    }\n\n    return this;\n}\n\nfunction endOf (units) {\n    units = normalizeUnits(units);\n    if (units === undefined || units === 'millisecond') {\n        return this;\n    }\n\n    // 'date' is an alias for 'day', so it should be considered as such.\n    if (units === 'date') {\n        units = 'day';\n    }\n\n    return this.startOf(units).add(1, (units === 'isoWeek' ? 'week' : units)).subtract(1, 'ms');\n}\n\nfunction valueOf () {\n    return this._d.valueOf() - ((this._offset || 0) * 60000);\n}\n\nfunction unix () {\n    return Math.floor(this.valueOf() / 1000);\n}\n\nfunction toDate () {\n    return new Date(this.valueOf());\n}\n\nfunction toArray () {\n    var m = this;\n    return [m.year(), m.month(), m.date(), m.hour(), m.minute(), m.second(), m.millisecond()];\n}\n\nfunction toObject () {\n    var m = this;\n    return {\n        years: m.year(),\n        months: m.month(),\n        date: m.date(),\n        hours: m.hours(),\n        minutes: m.minutes(),\n        seconds: m.seconds(),\n        milliseconds: m.milliseconds()\n    };\n}\n\nfunction toJSON () {\n    // new Date(NaN).toJSON() === null\n    return this.isValid() ? this.toISOString() : null;\n}\n\nfunction isValid$2 () {\n    return isValid(this);\n}\n\nfunction parsingFlags () {\n    return extend({}, getParsingFlags(this));\n}\n\nfunction invalidAt () {\n    return getParsingFlags(this).overflow;\n}\n\nfunction creationData() {\n    return {\n        input: this._i,\n        format: this._f,\n        locale: this._locale,\n        isUTC: this._isUTC,\n        strict: this._strict\n    };\n}\n\n// FORMATTING\n\naddFormatToken(0, ['gg', 2], 0, function () {\n    return this.weekYear() % 100;\n});\n\naddFormatToken(0, ['GG', 2], 0, function () {\n    return this.isoWeekYear() % 100;\n});\n\nfunction addWeekYearFormatToken (token, getter) {\n    addFormatToken(0, [token, token.length], 0, getter);\n}\n\naddWeekYearFormatToken('gggg',     'weekYear');\naddWeekYearFormatToken('ggggg',    'weekYear');\naddWeekYearFormatToken('GGGG',  'isoWeekYear');\naddWeekYearFormatToken('GGGGG', 'isoWeekYear');\n\n// ALIASES\n\naddUnitAlias('weekYear', 'gg');\naddUnitAlias('isoWeekYear', 'GG');\n\n// PRIORITY\n\naddUnitPriority('weekYear', 1);\naddUnitPriority('isoWeekYear', 1);\n\n\n// PARSING\n\naddRegexToken('G',      matchSigned);\naddRegexToken('g',      matchSigned);\naddRegexToken('GG',     match1to2, match2);\naddRegexToken('gg',     match1to2, match2);\naddRegexToken('GGGG',   match1to4, match4);\naddRegexToken('gggg',   match1to4, match4);\naddRegexToken('GGGGG',  match1to6, match6);\naddRegexToken('ggggg',  match1to6, match6);\n\naddWeekParseToken(['gggg', 'ggggg', 'GGGG', 'GGGGG'], function (input, week, config, token) {\n    week[token.substr(0, 2)] = toInt(input);\n});\n\naddWeekParseToken(['gg', 'GG'], function (input, week, config, token) {\n    week[token] = hooks.parseTwoDigitYear(input);\n});\n\n// MOMENTS\n\nfunction getSetWeekYear (input) {\n    return getSetWeekYearHelper.call(this,\n            input,\n            this.week(),\n            this.weekday(),\n            this.localeData()._week.dow,\n            this.localeData()._week.doy);\n}\n\nfunction getSetISOWeekYear (input) {\n    return getSetWeekYearHelper.call(this,\n            input, this.isoWeek(), this.isoWeekday(), 1, 4);\n}\n\nfunction getISOWeeksInYear () {\n    return weeksInYear(this.year(), 1, 4);\n}\n\nfunction getWeeksInYear () {\n    var weekInfo = this.localeData()._week;\n    return weeksInYear(this.year(), weekInfo.dow, weekInfo.doy);\n}\n\nfunction getSetWeekYearHelper(input, week, weekday, dow, doy) {\n    var weeksTarget;\n    if (input == null) {\n        return weekOfYear(this, dow, doy).year;\n    } else {\n        weeksTarget = weeksInYear(input, dow, doy);\n        if (week > weeksTarget) {\n            week = weeksTarget;\n        }\n        return setWeekAll.call(this, input, week, weekday, dow, doy);\n    }\n}\n\nfunction setWeekAll(weekYear, week, weekday, dow, doy) {\n    var dayOfYearData = dayOfYearFromWeeks(weekYear, week, weekday, dow, doy),\n        date = createUTCDate(dayOfYearData.year, 0, dayOfYearData.dayOfYear);\n\n    this.year(date.getUTCFullYear());\n    this.month(date.getUTCMonth());\n    this.date(date.getUTCDate());\n    return this;\n}\n\n// FORMATTING\n\naddFormatToken('Q', 0, 'Qo', 'quarter');\n\n// ALIASES\n\naddUnitAlias('quarter', 'Q');\n\n// PRIORITY\n\naddUnitPriority('quarter', 7);\n\n// PARSING\n\naddRegexToken('Q', match1);\naddParseToken('Q', function (input, array) {\n    array[MONTH] = (toInt(input) - 1) * 3;\n});\n\n// MOMENTS\n\nfunction getSetQuarter (input) {\n    return input == null ? Math.ceil((this.month() + 1) / 3) : this.month((input - 1) * 3 + this.month() % 3);\n}\n\n// FORMATTING\n\naddFormatToken('D', ['DD', 2], 'Do', 'date');\n\n// ALIASES\n\naddUnitAlias('date', 'D');\n\n// PRIOROITY\naddUnitPriority('date', 9);\n\n// PARSING\n\naddRegexToken('D',  match1to2);\naddRegexToken('DD', match1to2, match2);\naddRegexToken('Do', function (isStrict, locale) {\n    // TODO: Remove \"ordinalParse\" fallback in next major release.\n    return isStrict ?\n      (locale._dayOfMonthOrdinalParse || locale._ordinalParse) :\n      locale._dayOfMonthOrdinalParseLenient;\n});\n\naddParseToken(['D', 'DD'], DATE);\naddParseToken('Do', function (input, array) {\n    array[DATE] = toInt(input.match(match1to2)[0], 10);\n});\n\n// MOMENTS\n\nvar getSetDayOfMonth = makeGetSet('Date', true);\n\n// FORMATTING\n\naddFormatToken('DDD', ['DDDD', 3], 'DDDo', 'dayOfYear');\n\n// ALIASES\n\naddUnitAlias('dayOfYear', 'DDD');\n\n// PRIORITY\naddUnitPriority('dayOfYear', 4);\n\n// PARSING\n\naddRegexToken('DDD',  match1to3);\naddRegexToken('DDDD', match3);\naddParseToken(['DDD', 'DDDD'], function (input, array, config) {\n    config._dayOfYear = toInt(input);\n});\n\n// HELPERS\n\n// MOMENTS\n\nfunction getSetDayOfYear (input) {\n    var dayOfYear = Math.round((this.clone().startOf('day') - this.clone().startOf('year')) / 864e5) + 1;\n    return input == null ? dayOfYear : this.add((input - dayOfYear), 'd');\n}\n\n// FORMATTING\n\naddFormatToken('m', ['mm', 2], 0, 'minute');\n\n// ALIASES\n\naddUnitAlias('minute', 'm');\n\n// PRIORITY\n\naddUnitPriority('minute', 14);\n\n// PARSING\n\naddRegexToken('m',  match1to2);\naddRegexToken('mm', match1to2, match2);\naddParseToken(['m', 'mm'], MINUTE);\n\n// MOMENTS\n\nvar getSetMinute = makeGetSet('Minutes', false);\n\n// FORMATTING\n\naddFormatToken('s', ['ss', 2], 0, 'second');\n\n// ALIASES\n\naddUnitAlias('second', 's');\n\n// PRIORITY\n\naddUnitPriority('second', 15);\n\n// PARSING\n\naddRegexToken('s',  match1to2);\naddRegexToken('ss', match1to2, match2);\naddParseToken(['s', 'ss'], SECOND);\n\n// MOMENTS\n\nvar getSetSecond = makeGetSet('Seconds', false);\n\n// FORMATTING\n\naddFormatToken('S', 0, 0, function () {\n    return ~~(this.millisecond() / 100);\n});\n\naddFormatToken(0, ['SS', 2], 0, function () {\n    return ~~(this.millisecond() / 10);\n});\n\naddFormatToken(0, ['SSS', 3], 0, 'millisecond');\naddFormatToken(0, ['SSSS', 4], 0, function () {\n    return this.millisecond() * 10;\n});\naddFormatToken(0, ['SSSSS', 5], 0, function () {\n    return this.millisecond() * 100;\n});\naddFormatToken(0, ['SSSSSS', 6], 0, function () {\n    return this.millisecond() * 1000;\n});\naddFormatToken(0, ['SSSSSSS', 7], 0, function () {\n    return this.millisecond() * 10000;\n});\naddFormatToken(0, ['SSSSSSSS', 8], 0, function () {\n    return this.millisecond() * 100000;\n});\naddFormatToken(0, ['SSSSSSSSS', 9], 0, function () {\n    return this.millisecond() * 1000000;\n});\n\n\n// ALIASES\n\naddUnitAlias('millisecond', 'ms');\n\n// PRIORITY\n\naddUnitPriority('millisecond', 16);\n\n// PARSING\n\naddRegexToken('S',    match1to3, match1);\naddRegexToken('SS',   match1to3, match2);\naddRegexToken('SSS',  match1to3, match3);\n\nvar token;\nfor (token = 'SSSS'; token.length <= 9; token += 'S') {\n    addRegexToken(token, matchUnsigned);\n}\n\nfunction parseMs(input, array) {\n    array[MILLISECOND] = toInt(('0.' + input) * 1000);\n}\n\nfor (token = 'S'; token.length <= 9; token += 'S') {\n    addParseToken(token, parseMs);\n}\n// MOMENTS\n\nvar getSetMillisecond = makeGetSet('Milliseconds', false);\n\n// FORMATTING\n\naddFormatToken('z',  0, 0, 'zoneAbbr');\naddFormatToken('zz', 0, 0, 'zoneName');\n\n// MOMENTS\n\nfunction getZoneAbbr () {\n    return this._isUTC ? 'UTC' : '';\n}\n\nfunction getZoneName () {\n    return this._isUTC ? 'Coordinated Universal Time' : '';\n}\n\nvar proto = Moment.prototype;\n\nproto.add               = add;\nproto.calendar          = calendar$1;\nproto.clone             = clone;\nproto.diff              = diff;\nproto.endOf             = endOf;\nproto.format            = format;\nproto.from              = from;\nproto.fromNow           = fromNow;\nproto.to                = to;\nproto.toNow             = toNow;\nproto.get               = stringGet;\nproto.invalidAt         = invalidAt;\nproto.isAfter           = isAfter;\nproto.isBefore          = isBefore;\nproto.isBetween         = isBetween;\nproto.isSame            = isSame;\nproto.isSameOrAfter     = isSameOrAfter;\nproto.isSameOrBefore    = isSameOrBefore;\nproto.isValid           = isValid$2;\nproto.lang              = lang;\nproto.locale            = locale;\nproto.localeData        = localeData;\nproto.max               = prototypeMax;\nproto.min               = prototypeMin;\nproto.parsingFlags      = parsingFlags;\nproto.set               = stringSet;\nproto.startOf           = startOf;\nproto.subtract          = subtract;\nproto.toArray           = toArray;\nproto.toObject          = toObject;\nproto.toDate            = toDate;\nproto.toISOString       = toISOString;\nproto.inspect           = inspect;\nproto.toJSON            = toJSON;\nproto.toString          = toString;\nproto.unix              = unix;\nproto.valueOf           = valueOf;\nproto.creationData      = creationData;\n\n// Year\nproto.year       = getSetYear;\nproto.isLeapYear = getIsLeapYear;\n\n// Week Year\nproto.weekYear    = getSetWeekYear;\nproto.isoWeekYear = getSetISOWeekYear;\n\n// Quarter\nproto.quarter = proto.quarters = getSetQuarter;\n\n// Month\nproto.month       = getSetMonth;\nproto.daysInMonth = getDaysInMonth;\n\n// Week\nproto.week           = proto.weeks        = getSetWeek;\nproto.isoWeek        = proto.isoWeeks     = getSetISOWeek;\nproto.weeksInYear    = getWeeksInYear;\nproto.isoWeeksInYear = getISOWeeksInYear;\n\n// Day\nproto.date       = getSetDayOfMonth;\nproto.day        = proto.days             = getSetDayOfWeek;\nproto.weekday    = getSetLocaleDayOfWeek;\nproto.isoWeekday = getSetISODayOfWeek;\nproto.dayOfYear  = getSetDayOfYear;\n\n// Hour\nproto.hour = proto.hours = getSetHour;\n\n// Minute\nproto.minute = proto.minutes = getSetMinute;\n\n// Second\nproto.second = proto.seconds = getSetSecond;\n\n// Millisecond\nproto.millisecond = proto.milliseconds = getSetMillisecond;\n\n// Offset\nproto.utcOffset            = getSetOffset;\nproto.utc                  = setOffsetToUTC;\nproto.local                = setOffsetToLocal;\nproto.parseZone            = setOffsetToParsedOffset;\nproto.hasAlignedHourOffset = hasAlignedHourOffset;\nproto.isDST                = isDaylightSavingTime;\nproto.isLocal              = isLocal;\nproto.isUtcOffset          = isUtcOffset;\nproto.isUtc                = isUtc;\nproto.isUTC                = isUtc;\n\n// Timezone\nproto.zoneAbbr = getZoneAbbr;\nproto.zoneName = getZoneName;\n\n// Deprecations\nproto.dates  = deprecate('dates accessor is deprecated. Use date instead.', getSetDayOfMonth);\nproto.months = deprecate('months accessor is deprecated. Use month instead', getSetMonth);\nproto.years  = deprecate('years accessor is deprecated. Use year instead', getSetYear);\nproto.zone   = deprecate('moment().zone is deprecated, use moment().utcOffset instead. http://momentjs.com/guides/#/warnings/zone/', getSetZone);\nproto.isDSTShifted = deprecate('isDSTShifted is deprecated. See http://momentjs.com/guides/#/warnings/dst-shifted/ for more information', isDaylightSavingTimeShifted);\n\nfunction createUnix (input) {\n    return createLocal(input * 1000);\n}\n\nfunction createInZone () {\n    return createLocal.apply(null, arguments).parseZone();\n}\n\nfunction preParsePostFormat (string) {\n    return string;\n}\n\nvar proto$1 = Locale.prototype;\n\nproto$1.calendar        = calendar;\nproto$1.longDateFormat  = longDateFormat;\nproto$1.invalidDate     = invalidDate;\nproto$1.ordinal         = ordinal;\nproto$1.preparse        = preParsePostFormat;\nproto$1.postformat      = preParsePostFormat;\nproto$1.relativeTime    = relativeTime;\nproto$1.pastFuture      = pastFuture;\nproto$1.set             = set;\n\n// Month\nproto$1.months            =        localeMonths;\nproto$1.monthsShort       =        localeMonthsShort;\nproto$1.monthsParse       =        localeMonthsParse;\nproto$1.monthsRegex       = monthsRegex;\nproto$1.monthsShortRegex  = monthsShortRegex;\n\n// Week\nproto$1.week = localeWeek;\nproto$1.firstDayOfYear = localeFirstDayOfYear;\nproto$1.firstDayOfWeek = localeFirstDayOfWeek;\n\n// Day of Week\nproto$1.weekdays       =        localeWeekdays;\nproto$1.weekdaysMin    =        localeWeekdaysMin;\nproto$1.weekdaysShort  =        localeWeekdaysShort;\nproto$1.weekdaysParse  =        localeWeekdaysParse;\n\nproto$1.weekdaysRegex       =        weekdaysRegex;\nproto$1.weekdaysShortRegex  =        weekdaysShortRegex;\nproto$1.weekdaysMinRegex    =        weekdaysMinRegex;\n\n// Hours\nproto$1.isPM = localeIsPM;\nproto$1.meridiem = localeMeridiem;\n\nfunction get$1 (format, index, field, setter) {\n    var locale = getLocale();\n    var utc = createUTC().set(setter, index);\n    return locale[field](utc, format);\n}\n\nfunction listMonthsImpl (format, index, field) {\n    if (isNumber(format)) {\n        index = format;\n        format = undefined;\n    }\n\n    format = format || '';\n\n    if (index != null) {\n        return get$1(format, index, field, 'month');\n    }\n\n    var i;\n    var out = [];\n    for (i = 0; i < 12; i++) {\n        out[i] = get$1(format, i, field, 'month');\n    }\n    return out;\n}\n\n// ()\n// (5)\n// (fmt, 5)\n// (fmt)\n// (true)\n// (true, 5)\n// (true, fmt, 5)\n// (true, fmt)\nfunction listWeekdaysImpl (localeSorted, format, index, field) {\n    if (typeof localeSorted === 'boolean') {\n        if (isNumber(format)) {\n            index = format;\n            format = undefined;\n        }\n\n        format = format || '';\n    } else {\n        format = localeSorted;\n        index = format;\n        localeSorted = false;\n\n        if (isNumber(format)) {\n            index = format;\n            format = undefined;\n        }\n\n        format = format || '';\n    }\n\n    var locale = getLocale(),\n        shift = localeSorted ? locale._week.dow : 0;\n\n    if (index != null) {\n        return get$1(format, (index + shift) % 7, field, 'day');\n    }\n\n    var i;\n    var out = [];\n    for (i = 0; i < 7; i++) {\n        out[i] = get$1(format, (i + shift) % 7, field, 'day');\n    }\n    return out;\n}\n\nfunction listMonths (format, index) {\n    return listMonthsImpl(format, index, 'months');\n}\n\nfunction listMonthsShort (format, index) {\n    return listMonthsImpl(format, index, 'monthsShort');\n}\n\nfunction listWeekdays (localeSorted, format, index) {\n    return listWeekdaysImpl(localeSorted, format, index, 'weekdays');\n}\n\nfunction listWeekdaysShort (localeSorted, format, index) {\n    return listWeekdaysImpl(localeSorted, format, index, 'weekdaysShort');\n}\n\nfunction listWeekdaysMin (localeSorted, format, index) {\n    return listWeekdaysImpl(localeSorted, format, index, 'weekdaysMin');\n}\n\ngetSetGlobalLocale('en', {\n    dayOfMonthOrdinalParse: /\\d{1,2}(th|st|nd|rd)/,\n    ordinal : function (number) {\n        var b = number % 10,\n            output = (toInt(number % 100 / 10) === 1) ? 'th' :\n            (b === 1) ? 'st' :\n            (b === 2) ? 'nd' :\n            (b === 3) ? 'rd' : 'th';\n        return number + output;\n    }\n});\n\n// Side effect imports\nhooks.lang = deprecate('moment.lang is deprecated. Use moment.locale instead.', getSetGlobalLocale);\nhooks.langData = deprecate('moment.langData is deprecated. Use moment.localeData instead.', getLocale);\n\nvar mathAbs = Math.abs;\n\nfunction abs () {\n    var data           = this._data;\n\n    this._milliseconds = mathAbs(this._milliseconds);\n    this._days         = mathAbs(this._days);\n    this._months       = mathAbs(this._months);\n\n    data.milliseconds  = mathAbs(data.milliseconds);\n    data.seconds       = mathAbs(data.seconds);\n    data.minutes       = mathAbs(data.minutes);\n    data.hours         = mathAbs(data.hours);\n    data.months        = mathAbs(data.months);\n    data.years         = mathAbs(data.years);\n\n    return this;\n}\n\nfunction addSubtract$1 (duration, input, value, direction) {\n    var other = createDuration(input, value);\n\n    duration._milliseconds += direction * other._milliseconds;\n    duration._days         += direction * other._days;\n    duration._months       += direction * other._months;\n\n    return duration._bubble();\n}\n\n// supports only 2.0-style add(1, 's') or add(duration)\nfunction add$1 (input, value) {\n    return addSubtract$1(this, input, value, 1);\n}\n\n// supports only 2.0-style subtract(1, 's') or subtract(duration)\nfunction subtract$1 (input, value) {\n    return addSubtract$1(this, input, value, -1);\n}\n\nfunction absCeil (number) {\n    if (number < 0) {\n        return Math.floor(number);\n    } else {\n        return Math.ceil(number);\n    }\n}\n\nfunction bubble () {\n    var milliseconds = this._milliseconds;\n    var days         = this._days;\n    var months       = this._months;\n    var data         = this._data;\n    var seconds, minutes, hours, years, monthsFromDays;\n\n    // if we have a mix of positive and negative values, bubble down first\n    // check: https://github.com/moment/moment/issues/2166\n    if (!((milliseconds >= 0 && days >= 0 && months >= 0) ||\n            (milliseconds <= 0 && days <= 0 && months <= 0))) {\n        milliseconds += absCeil(monthsToDays(months) + days) * 864e5;\n        days = 0;\n        months = 0;\n    }\n\n    // The following code bubbles up values, see the tests for\n    // examples of what that means.\n    data.milliseconds = milliseconds % 1000;\n\n    seconds           = absFloor(milliseconds / 1000);\n    data.seconds      = seconds % 60;\n\n    minutes           = absFloor(seconds / 60);\n    data.minutes      = minutes % 60;\n\n    hours             = absFloor(minutes / 60);\n    data.hours        = hours % 24;\n\n    days += absFloor(hours / 24);\n\n    // convert days to months\n    monthsFromDays = absFloor(daysToMonths(days));\n    months += monthsFromDays;\n    days -= absCeil(monthsToDays(monthsFromDays));\n\n    // 12 months -> 1 year\n    years = absFloor(months / 12);\n    months %= 12;\n\n    data.days   = days;\n    data.months = months;\n    data.years  = years;\n\n    return this;\n}\n\nfunction daysToMonths (days) {\n    // 400 years have 146097 days (taking into account leap year rules)\n    // 400 years have 12 months === 4800\n    return days * 4800 / 146097;\n}\n\nfunction monthsToDays (months) {\n    // the reverse of daysToMonths\n    return months * 146097 / 4800;\n}\n\nfunction as (units) {\n    if (!this.isValid()) {\n        return NaN;\n    }\n    var days;\n    var months;\n    var milliseconds = this._milliseconds;\n\n    units = normalizeUnits(units);\n\n    if (units === 'month' || units === 'year') {\n        days   = this._days   + milliseconds / 864e5;\n        months = this._months + daysToMonths(days);\n        return units === 'month' ? months : months / 12;\n    } else {\n        // handle milliseconds separately because of floating point math errors (issue #1867)\n        days = this._days + Math.round(monthsToDays(this._months));\n        switch (units) {\n            case 'week'   : return days / 7     + milliseconds / 6048e5;\n            case 'day'    : return days         + milliseconds / 864e5;\n            case 'hour'   : return days * 24    + milliseconds / 36e5;\n            case 'minute' : return days * 1440  + milliseconds / 6e4;\n            case 'second' : return days * 86400 + milliseconds / 1000;\n            // Math.floor prevents floating point math errors here\n            case 'millisecond': return Math.floor(days * 864e5) + milliseconds;\n            default: throw new Error('Unknown unit ' + units);\n        }\n    }\n}\n\n// TODO: Use this.as('ms')?\nfunction valueOf$1 () {\n    if (!this.isValid()) {\n        return NaN;\n    }\n    return (\n        this._milliseconds +\n        this._days * 864e5 +\n        (this._months % 12) * 2592e6 +\n        toInt(this._months / 12) * 31536e6\n    );\n}\n\nfunction makeAs (alias) {\n    return function () {\n        return this.as(alias);\n    };\n}\n\nvar asMilliseconds = makeAs('ms');\nvar asSeconds      = makeAs('s');\nvar asMinutes      = makeAs('m');\nvar asHours        = makeAs('h');\nvar asDays         = makeAs('d');\nvar asWeeks        = makeAs('w');\nvar asMonths       = makeAs('M');\nvar asYears        = makeAs('y');\n\nfunction get$2 (units) {\n    units = normalizeUnits(units);\n    return this.isValid() ? this[units + 's']() : NaN;\n}\n\nfunction makeGetter(name) {\n    return function () {\n        return this.isValid() ? this._data[name] : NaN;\n    };\n}\n\nvar milliseconds = makeGetter('milliseconds');\nvar seconds      = makeGetter('seconds');\nvar minutes      = makeGetter('minutes');\nvar hours        = makeGetter('hours');\nvar days         = makeGetter('days');\nvar months       = makeGetter('months');\nvar years        = makeGetter('years');\n\nfunction weeks () {\n    return absFloor(this.days() / 7);\n}\n\nvar round = Math.round;\nvar thresholds = {\n    ss: 44,         // a few seconds to seconds\n    s : 45,         // seconds to minute\n    m : 45,         // minutes to hour\n    h : 22,         // hours to day\n    d : 26,         // days to month\n    M : 11          // months to year\n};\n\n// helper function for moment.fn.from, moment.fn.fromNow, and moment.duration.fn.humanize\nfunction substituteTimeAgo(string, number, withoutSuffix, isFuture, locale) {\n    return locale.relativeTime(number || 1, !!withoutSuffix, string, isFuture);\n}\n\nfunction relativeTime$1 (posNegDuration, withoutSuffix, locale) {\n    var duration = createDuration(posNegDuration).abs();\n    var seconds  = round(duration.as('s'));\n    var minutes  = round(duration.as('m'));\n    var hours    = round(duration.as('h'));\n    var days     = round(duration.as('d'));\n    var months   = round(duration.as('M'));\n    var years    = round(duration.as('y'));\n\n    var a = seconds <= thresholds.ss && ['s', seconds]  ||\n            seconds < thresholds.s   && ['ss', seconds] ||\n            minutes <= 1             && ['m']           ||\n            minutes < thresholds.m   && ['mm', minutes] ||\n            hours   <= 1             && ['h']           ||\n            hours   < thresholds.h   && ['hh', hours]   ||\n            days    <= 1             && ['d']           ||\n            days    < thresholds.d   && ['dd', days]    ||\n            months  <= 1             && ['M']           ||\n            months  < thresholds.M   && ['MM', months]  ||\n            years   <= 1             && ['y']           || ['yy', years];\n\n    a[2] = withoutSuffix;\n    a[3] = +posNegDuration > 0;\n    a[4] = locale;\n    return substituteTimeAgo.apply(null, a);\n}\n\n// This function allows you to set the rounding function for relative time strings\nfunction getSetRelativeTimeRounding (roundingFunction) {\n    if (roundingFunction === undefined) {\n        return round;\n    }\n    if (typeof(roundingFunction) === 'function') {\n        round = roundingFunction;\n        return true;\n    }\n    return false;\n}\n\n// This function allows you to set a threshold for relative time strings\nfunction getSetRelativeTimeThreshold (threshold, limit) {\n    if (thresholds[threshold] === undefined) {\n        return false;\n    }\n    if (limit === undefined) {\n        return thresholds[threshold];\n    }\n    thresholds[threshold] = limit;\n    if (threshold === 's') {\n        thresholds.ss = limit - 1;\n    }\n    return true;\n}\n\nfunction humanize (withSuffix) {\n    if (!this.isValid()) {\n        return this.localeData().invalidDate();\n    }\n\n    var locale = this.localeData();\n    var output = relativeTime$1(this, !withSuffix, locale);\n\n    if (withSuffix) {\n        output = locale.pastFuture(+this, output);\n    }\n\n    return locale.postformat(output);\n}\n\nvar abs$1 = Math.abs;\n\nfunction toISOString$1() {\n    // for ISO strings we do not use the normal bubbling rules:\n    //  * milliseconds bubble up until they become hours\n    //  * days do not bubble at all\n    //  * months bubble up until they become years\n    // This is because there is no context-free conversion between hours and days\n    // (think of clock changes)\n    // and also not between days and months (28-31 days per month)\n    if (!this.isValid()) {\n        return this.localeData().invalidDate();\n    }\n\n    var seconds = abs$1(this._milliseconds) / 1000;\n    var days         = abs$1(this._days);\n    var months       = abs$1(this._months);\n    var minutes, hours, years;\n\n    // 3600 seconds -> 60 minutes -> 1 hour\n    minutes           = absFloor(seconds / 60);\n    hours             = absFloor(minutes / 60);\n    seconds %= 60;\n    minutes %= 60;\n\n    // 12 months -> 1 year\n    years  = absFloor(months / 12);\n    months %= 12;\n\n\n    // inspired by https://github.com/dordille/moment-isoduration/blob/master/moment.isoduration.js\n    var Y = years;\n    var M = months;\n    var D = days;\n    var h = hours;\n    var m = minutes;\n    var s = seconds;\n    var total = this.asSeconds();\n\n    if (!total) {\n        // this is the same as C#'s (Noda) and python (isodate)...\n        // but not other JS (goog.date)\n        return 'P0D';\n    }\n\n    return (total < 0 ? '-' : '') +\n        'P' +\n        (Y ? Y + 'Y' : '') +\n        (M ? M + 'M' : '') +\n        (D ? D + 'D' : '') +\n        ((h || m || s) ? 'T' : '') +\n        (h ? h + 'H' : '') +\n        (m ? m + 'M' : '') +\n        (s ? s + 'S' : '');\n}\n\nvar proto$2 = Duration.prototype;\n\nproto$2.isValid        = isValid$1;\nproto$2.abs            = abs;\nproto$2.add            = add$1;\nproto$2.subtract       = subtract$1;\nproto$2.as             = as;\nproto$2.asMilliseconds = asMilliseconds;\nproto$2.asSeconds      = asSeconds;\nproto$2.asMinutes      = asMinutes;\nproto$2.asHours        = asHours;\nproto$2.asDays         = asDays;\nproto$2.asWeeks        = asWeeks;\nproto$2.asMonths       = asMonths;\nproto$2.asYears        = asYears;\nproto$2.valueOf        = valueOf$1;\nproto$2._bubble        = bubble;\nproto$2.get            = get$2;\nproto$2.milliseconds   = milliseconds;\nproto$2.seconds        = seconds;\nproto$2.minutes        = minutes;\nproto$2.hours          = hours;\nproto$2.days           = days;\nproto$2.weeks          = weeks;\nproto$2.months         = months;\nproto$2.years          = years;\nproto$2.humanize       = humanize;\nproto$2.toISOString    = toISOString$1;\nproto$2.toString       = toISOString$1;\nproto$2.toJSON         = toISOString$1;\nproto$2.locale         = locale;\nproto$2.localeData     = localeData;\n\n// Deprecations\nproto$2.toIsoString = deprecate('toIsoString() is deprecated. Please use toISOString() instead (notice the capitals)', toISOString$1);\nproto$2.lang = lang;\n\n// Side effect imports\n\n// FORMATTING\n\naddFormatToken('X', 0, 0, 'unix');\naddFormatToken('x', 0, 0, 'valueOf');\n\n// PARSING\n\naddRegexToken('x', matchSigned);\naddRegexToken('X', matchTimestamp);\naddParseToken('X', function (input, array, config) {\n    config._d = new Date(parseFloat(input, 10) * 1000);\n});\naddParseToken('x', function (input, array, config) {\n    config._d = new Date(toInt(input));\n});\n\n// Side effect imports\n\n\nhooks.version = '2.18.1';\n\nsetHookCallback(createLocal);\n\nhooks.fn                    = proto;\nhooks.min                   = min;\nhooks.max                   = max;\nhooks.now                   = now;\nhooks.utc                   = createUTC;\nhooks.unix                  = createUnix;\nhooks.months                = listMonths;\nhooks.isDate                = isDate;\nhooks.locale                = getSetGlobalLocale;\nhooks.invalid               = createInvalid;\nhooks.duration              = createDuration;\nhooks.isMoment              = isMoment;\nhooks.weekdays              = listWeekdays;\nhooks.parseZone             = createInZone;\nhooks.localeData            = getLocale;\nhooks.isDuration            = isDuration;\nhooks.monthsShort           = listMonthsShort;\nhooks.weekdaysMin           = listWeekdaysMin;\nhooks.defineLocale          = defineLocale;\nhooks.updateLocale          = updateLocale;\nhooks.locales               = listLocales;\nhooks.weekdaysShort         = listWeekdaysShort;\nhooks.normalizeUnits        = normalizeUnits;\nhooks.relativeTimeRounding = getSetRelativeTimeRounding;\nhooks.relativeTimeThreshold = getSetRelativeTimeThreshold;\nhooks.calendarFormat        = getCalendarFormat;\nhooks.prototype             = proto;\n\nreturn hooks;\n\n})));\n\n},{}],7:[function(require,module,exports){\n/**\n * @namespace Chart\n */\nvar Chart = require(29)();\n\nChart.helpers = require(45);\n\n// @todo dispatch these helpers into appropriated helpers/helpers.* file and write unit tests!\nrequire(27)(Chart);\n\nChart.defaults = require(25);\nChart.Element = require(26);\nChart.elements = require(40);\nChart.Interaction = require(28);\nChart.platform = require(48);\n\nrequire(31)(Chart);\nrequire(22)(Chart);\nrequire(23)(Chart);\nrequire(24)(Chart);\nrequire(30)(Chart);\nrequire(33)(Chart);\nrequire(32)(Chart);\nrequire(35)(Chart);\n\nrequire(54)(Chart);\nrequire(52)(Chart);\nrequire(53)(Chart);\nrequire(55)(Chart);\nrequire(56)(Chart);\nrequire(57)(Chart);\n\n// Controllers must be loaded after elements\n// See Chart.core.datasetController.dataElementType\nrequire(15)(Chart);\nrequire(16)(Chart);\nrequire(17)(Chart);\nrequire(18)(Chart);\nrequire(19)(Chart);\nrequire(20)(Chart);\nrequire(21)(Chart);\n\nrequire(8)(Chart);\nrequire(9)(Chart);\nrequire(10)(Chart);\nrequire(11)(Chart);\nrequire(12)(Chart);\nrequire(13)(Chart);\nrequire(14)(Chart);\n\n// Loading built-it plugins\nvar plugins = [];\n\nplugins.push(\n	require(49)(Chart),\n	require(50)(Chart),\n	require(51)(Chart)\n);\n\nChart.plugins.register(plugins);\n\nChart.platform.initialize();\n\nmodule.exports = Chart;\nif (typeof window !== 'undefined') {\n	window.Chart = Chart;\n}\n\n// DEPRECATIONS\n\n/**\n * Provided for backward compatibility, use Chart.helpers.canvas instead.\n * @namespace Chart.canvasHelpers\n * @deprecated since version 2.6.0\n * @todo remove at version 3\n * @private\n */\nChart.canvasHelpers = Chart.helpers.canvas;\n\n},{\"10\":10,\"11\":11,\"12\":12,\"13\":13,\"14\":14,\"15\":15,\"16\":16,\"17\":17,\"18\":18,\"19\":19,\"20\":20,\"21\":21,\"22\":22,\"23\":23,\"24\":24,\"25\":25,\"26\":26,\"27\":27,\"28\":28,\"29\":29,\"30\":30,\"31\":31,\"32\":32,\"33\":33,\"35\":35,\"40\":40,\"45\":45,\"48\":48,\"49\":49,\"50\":50,\"51\":51,\"52\":52,\"53\":53,\"54\":54,\"55\":55,\"56\":56,\"57\":57,\"8\":8,\"9\":9}],8:[function(require,module,exports){\n'use strict';\n\nmodule.exports = function(Chart) {\n\n	Chart.Bar = function(context, config) {\n		config.type = 'bar';\n\n		return new Chart(context, config);\n	};\n\n};\n\n},{}],9:[function(require,module,exports){\n'use strict';\n\nmodule.exports = function(Chart) {\n\n	Chart.Bubble = function(context, config) {\n		config.type = 'bubble';\n		return new Chart(context, config);\n	};\n\n};\n\n},{}],10:[function(require,module,exports){\n'use strict';\n\nmodule.exports = function(Chart) {\n\n	Chart.Doughnut = function(context, config) {\n		config.type = 'doughnut';\n\n		return new Chart(context, config);\n	};\n\n};\n\n},{}],11:[function(require,module,exports){\n'use strict';\n\nmodule.exports = function(Chart) {\n\n	Chart.Line = function(context, config) {\n		config.type = 'line';\n\n		return new Chart(context, config);\n	};\n\n};\n\n},{}],12:[function(require,module,exports){\n'use strict';\n\nmodule.exports = function(Chart) {\n\n	Chart.PolarArea = function(context, config) {\n		config.type = 'polarArea';\n\n		return new Chart(context, config);\n	};\n\n};\n\n},{}],13:[function(require,module,exports){\n'use strict';\n\nmodule.exports = function(Chart) {\n\n	Chart.Radar = function(context, config) {\n		config.type = 'radar';\n\n		return new Chart(context, config);\n	};\n\n};\n\n},{}],14:[function(require,module,exports){\n'use strict';\n\nmodule.exports = function(Chart) {\n	Chart.Scatter = function(context, config) {\n		config.type = 'scatter';\n		return new Chart(context, config);\n	};\n};\n\n},{}],15:[function(require,module,exports){\n'use strict';\n\nvar defaults = require(25);\nvar elements = require(40);\nvar helpers = require(45);\n\ndefaults._set('bar', {\n	hover: {\n		mode: 'label'\n	},\n\n	scales: {\n		xAxes: [{\n			type: 'category',\n\n			// Specific to Bar Controller\n			categoryPercentage: 0.8,\n			barPercentage: 0.9,\n\n			// offset settings\n			offset: true,\n\n			// grid line settings\n			gridLines: {\n				offsetGridLines: true\n			}\n		}],\n\n		yAxes: [{\n			type: 'linear'\n		}]\n	}\n});\n\ndefaults._set('horizontalBar', {\n	hover: {\n		mode: 'index',\n		axis: 'y'\n	},\n\n	scales: {\n		xAxes: [{\n			type: 'linear',\n			position: 'bottom'\n		}],\n\n		yAxes: [{\n			position: 'left',\n			type: 'category',\n\n			// Specific to Horizontal Bar Controller\n			categoryPercentage: 0.8,\n			barPercentage: 0.9,\n\n			// offset settings\n			offset: true,\n\n			// grid line settings\n			gridLines: {\n				offsetGridLines: true\n			}\n		}]\n	},\n\n	elements: {\n		rectangle: {\n			borderSkipped: 'left'\n		}\n	},\n\n	tooltips: {\n		callbacks: {\n			title: function(item, data) {\n				// Pick first xLabel for now\n				var title = '';\n\n				if (item.length > 0) {\n					if (item[0].yLabel) {\n						title = item[0].yLabel;\n					} else if (data.labels.length > 0 && item[0].index < data.labels.length) {\n						title = data.labels[item[0].index];\n					}\n				}\n\n				return title;\n			},\n\n			label: function(item, data) {\n				var datasetLabel = data.datasets[item.datasetIndex].label || '';\n				return datasetLabel + ': ' + item.xLabel;\n			}\n		},\n		mode: 'index',\n		axis: 'y'\n	}\n});\n\nmodule.exports = function(Chart) {\n\n	Chart.controllers.bar = Chart.DatasetController.extend({\n\n		dataElementType: elements.Rectangle,\n\n		initialize: function() {\n			var me = this;\n			var meta;\n\n			Chart.DatasetController.prototype.initialize.apply(me, arguments);\n\n			meta = me.getMeta();\n			meta.stack = me.getDataset().stack;\n			meta.bar = true;\n		},\n\n		update: function(reset) {\n			var me = this;\n			var rects = me.getMeta().data;\n			var i, ilen;\n\n			me._ruler = me.getRuler();\n\n			for (i = 0, ilen = rects.length; i < ilen; ++i) {\n				me.updateElement(rects[i], i, reset);\n			}\n		},\n\n		updateElement: function(rectangle, index, reset) {\n			var me = this;\n			var chart = me.chart;\n			var meta = me.getMeta();\n			var dataset = me.getDataset();\n			var custom = rectangle.custom || {};\n			var rectangleOptions = chart.options.elements.rectangle;\n\n			rectangle._xScale = me.getScaleForId(meta.xAxisID);\n			rectangle._yScale = me.getScaleForId(meta.yAxisID);\n			rectangle._datasetIndex = me.index;\n			rectangle._index = index;\n\n			rectangle._model = {\n				datasetLabel: dataset.label,\n				label: chart.data.labels[index],\n				borderSkipped: custom.borderSkipped ? custom.borderSkipped : rectangleOptions.borderSkipped,\n				backgroundColor: custom.backgroundColor ? custom.backgroundColor : helpers.valueAtIndexOrDefault(dataset.backgroundColor, index, rectangleOptions.backgroundColor),\n				borderColor: custom.borderColor ? custom.borderColor : helpers.valueAtIndexOrDefault(dataset.borderColor, index, rectangleOptions.borderColor),\n				borderWidth: custom.borderWidth ? custom.borderWidth : helpers.valueAtIndexOrDefault(dataset.borderWidth, index, rectangleOptions.borderWidth)\n			};\n\n			me.updateElementGeometry(rectangle, index, reset);\n\n			rectangle.pivot();\n		},\n\n		/**\n		 * @private\n		 */\n		updateElementGeometry: function(rectangle, index, reset) {\n			var me = this;\n			var model = rectangle._model;\n			var vscale = me.getValueScale();\n			var base = vscale.getBasePixel();\n			var horizontal = vscale.isHorizontal();\n			var ruler = me._ruler || me.getRuler();\n			var vpixels = me.calculateBarValuePixels(me.index, index);\n			var ipixels = me.calculateBarIndexPixels(me.index, index, ruler);\n\n			model.horizontal = horizontal;\n			model.base = reset ? base : vpixels.base;\n			model.x = horizontal ? reset ? base : vpixels.head : ipixels.center;\n			model.y = horizontal ? ipixels.center : reset ? base : vpixels.head;\n			model.height = horizontal ? ipixels.size : undefined;\n			model.width = horizontal ? undefined : ipixels.size;\n		},\n\n		/**\n		 * @private\n		 */\n		getValueScaleId: function() {\n			return this.getMeta().yAxisID;\n		},\n\n		/**\n		 * @private\n		 */\n		getIndexScaleId: function() {\n			return this.getMeta().xAxisID;\n		},\n\n		/**\n		 * @private\n		 */\n		getValueScale: function() {\n			return this.getScaleForId(this.getValueScaleId());\n		},\n\n		/**\n		 * @private\n		 */\n		getIndexScale: function() {\n			return this.getScaleForId(this.getIndexScaleId());\n		},\n\n		/**\n		 * Returns the effective number of stacks based on groups and bar visibility.\n		 * @private\n		 */\n		getStackCount: function(last) {\n			var me = this;\n			var chart = me.chart;\n			var scale = me.getIndexScale();\n			var stacked = scale.options.stacked;\n			var ilen = last === undefined ? chart.data.datasets.length : last + 1;\n			var stacks = [];\n			var i, meta;\n\n			for (i = 0; i < ilen; ++i) {\n				meta = chart.getDatasetMeta(i);\n				if (meta.bar && chart.isDatasetVisible(i) &&\n					(stacked === false ||\n					(stacked === true && stacks.indexOf(meta.stack) === -1) ||\n					(stacked === undefined && (meta.stack === undefined || stacks.indexOf(meta.stack) === -1)))) {\n					stacks.push(meta.stack);\n				}\n			}\n\n			return stacks.length;\n		},\n\n		/**\n		 * Returns the stack index for the given dataset based on groups and bar visibility.\n		 * @private\n		 */\n		getStackIndex: function(datasetIndex) {\n			return this.getStackCount(datasetIndex) - 1;\n		},\n\n		/**\n		 * @private\n		 */\n		getRuler: function() {\n			var me = this;\n			var scale = me.getIndexScale();\n			var stackCount = me.getStackCount();\n			var datasetIndex = me.index;\n			var pixels = [];\n			var isHorizontal = scale.isHorizontal();\n			var start = isHorizontal ? scale.left : scale.top;\n			var end = start + (isHorizontal ? scale.width : scale.height);\n			var i, ilen;\n\n			for (i = 0, ilen = me.getMeta().data.length; i < ilen; ++i) {\n				pixels.push(scale.getPixelForValue(null, i, datasetIndex));\n			}\n\n			return {\n				pixels: pixels,\n				start: start,\n				end: end,\n				stackCount: stackCount,\n				scale: scale\n			};\n		},\n\n		/**\n		 * Note: pixel values are not clamped to the scale area.\n		 * @private\n		 */\n		calculateBarValuePixels: function(datasetIndex, index) {\n			var me = this;\n			var chart = me.chart;\n			var meta = me.getMeta();\n			var scale = me.getValueScale();\n			var datasets = chart.data.datasets;\n			var value = scale.getRightValue(datasets[datasetIndex].data[index]);\n			var stacked = scale.options.stacked;\n			var stack = meta.stack;\n			var start = 0;\n			var i, imeta, ivalue, base, head, size;\n\n			if (stacked || (stacked === undefined && stack !== undefined)) {\n				for (i = 0; i < datasetIndex; ++i) {\n					imeta = chart.getDatasetMeta(i);\n\n					if (imeta.bar &&\n						imeta.stack === stack &&\n						imeta.controller.getValueScaleId() === scale.id &&\n						chart.isDatasetVisible(i)) {\n\n						ivalue = scale.getRightValue(datasets[i].data[index]);\n						if ((value < 0 && ivalue < 0) || (value >= 0 && ivalue > 0)) {\n							start += ivalue;\n						}\n					}\n				}\n			}\n\n			base = scale.getPixelForValue(start);\n			head = scale.getPixelForValue(start + value);\n			size = (head - base) / 2;\n\n			return {\n				size: size,\n				base: base,\n				head: head,\n				center: head + size / 2\n			};\n		},\n\n		/**\n		 * @private\n		 */\n		calculateBarIndexPixels: function(datasetIndex, index, ruler) {\n			var me = this;\n			var options = ruler.scale.options;\n			var stackIndex = me.getStackIndex(datasetIndex);\n			var pixels = ruler.pixels;\n			var base = pixels[index];\n			var length = pixels.length;\n			var start = ruler.start;\n			var end = ruler.end;\n			var leftSampleSize, rightSampleSize, leftCategorySize, rightCategorySize, fullBarSize, size;\n\n			if (length === 1) {\n				leftSampleSize = base > start ? base - start : end - base;\n				rightSampleSize = base < end ? end - base : base - start;\n			} else {\n				if (index > 0) {\n					leftSampleSize = (base - pixels[index - 1]) / 2;\n					if (index === length - 1) {\n						rightSampleSize = leftSampleSize;\n					}\n				}\n				if (index < length - 1) {\n					rightSampleSize = (pixels[index + 1] - base) / 2;\n					if (index === 0) {\n						leftSampleSize = rightSampleSize;\n					}\n				}\n			}\n\n			leftCategorySize = leftSampleSize * options.categoryPercentage;\n			rightCategorySize = rightSampleSize * options.categoryPercentage;\n			fullBarSize = (leftCategorySize + rightCategorySize) / ruler.stackCount;\n			size = fullBarSize * options.barPercentage;\n\n			size = Math.min(\n				helpers.valueOrDefault(options.barThickness, size),\n				helpers.valueOrDefault(options.maxBarThickness, Infinity));\n\n			base -= leftCategorySize;\n			base += fullBarSize * stackIndex;\n			base += (fullBarSize - size) / 2;\n\n			return {\n				size: size,\n				base: base,\n				head: base + size,\n				center: base + size / 2\n			};\n		},\n\n		draw: function() {\n			var me = this;\n			var chart = me.chart;\n			var scale = me.getValueScale();\n			var rects = me.getMeta().data;\n			var dataset = me.getDataset();\n			var ilen = rects.length;\n			var i = 0;\n\n			helpers.canvas.clipArea(chart.ctx, chart.chartArea);\n\n			for (; i < ilen; ++i) {\n				if (!isNaN(scale.getRightValue(dataset.data[i]))) {\n					rects[i].draw();\n				}\n			}\n\n			helpers.canvas.unclipArea(chart.ctx);\n		},\n\n		setHoverStyle: function(rectangle) {\n			var dataset = this.chart.data.datasets[rectangle._datasetIndex];\n			var index = rectangle._index;\n			var custom = rectangle.custom || {};\n			var model = rectangle._model;\n\n			model.backgroundColor = custom.hoverBackgroundColor ? custom.hoverBackgroundColor : helpers.valueAtIndexOrDefault(dataset.hoverBackgroundColor, index, helpers.getHoverColor(model.backgroundColor));\n			model.borderColor = custom.hoverBorderColor ? custom.hoverBorderColor : helpers.valueAtIndexOrDefault(dataset.hoverBorderColor, index, helpers.getHoverColor(model.borderColor));\n			model.borderWidth = custom.hoverBorderWidth ? custom.hoverBorderWidth : helpers.valueAtIndexOrDefault(dataset.hoverBorderWidth, index, model.borderWidth);\n		},\n\n		removeHoverStyle: function(rectangle) {\n			var dataset = this.chart.data.datasets[rectangle._datasetIndex];\n			var index = rectangle._index;\n			var custom = rectangle.custom || {};\n			var model = rectangle._model;\n			var rectangleElementOptions = this.chart.options.elements.rectangle;\n\n			model.backgroundColor = custom.backgroundColor ? custom.backgroundColor : helpers.valueAtIndexOrDefault(dataset.backgroundColor, index, rectangleElementOptions.backgroundColor);\n			model.borderColor = custom.borderColor ? custom.borderColor : helpers.valueAtIndexOrDefault(dataset.borderColor, index, rectangleElementOptions.borderColor);\n			model.borderWidth = custom.borderWidth ? custom.borderWidth : helpers.valueAtIndexOrDefault(dataset.borderWidth, index, rectangleElementOptions.borderWidth);\n		}\n	});\n\n	Chart.controllers.horizontalBar = Chart.controllers.bar.extend({\n		/**\n		 * @private\n		 */\n		getValueScaleId: function() {\n			return this.getMeta().xAxisID;\n		},\n\n		/**\n		 * @private\n		 */\n		getIndexScaleId: function() {\n			return this.getMeta().yAxisID;\n		}\n	});\n};\n\n},{\"25\":25,\"40\":40,\"45\":45}],16:[function(require,module,exports){\n'use strict';\n\nvar defaults = require(25);\nvar elements = require(40);\nvar helpers = require(45);\n\ndefaults._set('bubble', {\n	hover: {\n		mode: 'single'\n	},\n\n	scales: {\n		xAxes: [{\n			type: 'linear', // bubble should probably use a linear scale by default\n			position: 'bottom',\n			id: 'x-axis-0' // need an ID so datasets can reference the scale\n		}],\n		yAxes: [{\n			type: 'linear',\n			position: 'left',\n			id: 'y-axis-0'\n		}]\n	},\n\n	tooltips: {\n		callbacks: {\n			title: function() {\n				// Title doesn't make sense for scatter since we format the data as a point\n				return '';\n			},\n			label: function(item, data) {\n				var datasetLabel = data.datasets[item.datasetIndex].label || '';\n				var dataPoint = data.datasets[item.datasetIndex].data[item.index];\n				return datasetLabel + ': (' + item.xLabel + ', ' + item.yLabel + ', ' + dataPoint.r + ')';\n			}\n		}\n	}\n});\n\n\nmodule.exports = function(Chart) {\n\n	Chart.controllers.bubble = Chart.DatasetController.extend({\n		/**\n		 * @protected\n		 */\n		dataElementType: elements.Point,\n\n		/**\n		 * @protected\n		 */\n		update: function(reset) {\n			var me = this;\n			var meta = me.getMeta();\n			var points = meta.data;\n\n			// Update Points\n			helpers.each(points, function(point, index) {\n				me.updateElement(point, index, reset);\n			});\n		},\n\n		/**\n		 * @protected\n		 */\n		updateElement: function(point, index, reset) {\n			var me = this;\n			var meta = me.getMeta();\n			var custom = point.custom || {};\n			var xScale = me.getScaleForId(meta.xAxisID);\n			var yScale = me.getScaleForId(meta.yAxisID);\n			var options = me._resolveElementOptions(point, index);\n			var data = me.getDataset().data[index];\n			var dsIndex = me.index;\n\n			var x = reset ? xScale.getPixelForDecimal(0.5) : xScale.getPixelForValue(typeof data === 'object' ? data : NaN, index, dsIndex);\n			var y = reset ? yScale.getBasePixel() : yScale.getPixelForValue(data, index, dsIndex);\n\n			point._xScale = xScale;\n			point._yScale = yScale;\n			point._options = options;\n			point._datasetIndex = dsIndex;\n			point._index = index;\n			point._model = {\n				backgroundColor: options.backgroundColor,\n				borderColor: options.borderColor,\n				borderWidth: options.borderWidth,\n				hitRadius: options.hitRadius,\n				pointStyle: options.pointStyle,\n				radius: reset ? 0 : options.radius,\n				skip: custom.skip || isNaN(x) || isNaN(y),\n				x: x,\n				y: y,\n			};\n\n			point.pivot();\n		},\n\n		/**\n		 * @protected\n		 */\n		setHoverStyle: function(point) {\n			var model = point._model;\n			var options = point._options;\n\n			model.backgroundColor = helpers.valueOrDefault(options.hoverBackgroundColor, helpers.getHoverColor(options.backgroundColor));\n			model.borderColor = helpers.valueOrDefault(options.hoverBorderColor, helpers.getHoverColor(options.borderColor));\n			model.borderWidth = helpers.valueOrDefault(options.hoverBorderWidth, options.borderWidth);\n			model.radius = options.radius + options.hoverRadius;\n		},\n\n		/**\n		 * @protected\n		 */\n		removeHoverStyle: function(point) {\n			var model = point._model;\n			var options = point._options;\n\n			model.backgroundColor = options.backgroundColor;\n			model.borderColor = options.borderColor;\n			model.borderWidth = options.borderWidth;\n			model.radius = options.radius;\n		},\n\n		/**\n		 * @private\n		 */\n		_resolveElementOptions: function(point, index) {\n			var me = this;\n			var chart = me.chart;\n			var datasets = chart.data.datasets;\n			var dataset = datasets[me.index];\n			var custom = point.custom || {};\n			var options = chart.options.elements.point;\n			var resolve = helpers.options.resolve;\n			var data = dataset.data[index];\n			var values = {};\n			var i, ilen, key;\n\n			// Scriptable options\n			var context = {\n				chart: chart,\n				dataIndex: index,\n				dataset: dataset,\n				datasetIndex: me.index\n			};\n\n			var keys = [\n				'backgroundColor',\n				'borderColor',\n				'borderWidth',\n				'hoverBackgroundColor',\n				'hoverBorderColor',\n				'hoverBorderWidth',\n				'hoverRadius',\n				'hitRadius',\n				'pointStyle'\n			];\n\n			for (i = 0, ilen = keys.length; i < ilen; ++i) {\n				key = keys[i];\n				values[key] = resolve([\n					custom[key],\n					dataset[key],\n					options[key]\n				], context, index);\n			}\n\n			// Custom radius resolution\n			values.radius = resolve([\n				custom.radius,\n				data ? data.r : undefined,\n				dataset.radius,\n				options.radius\n			], context, index);\n\n			return values;\n		}\n	});\n};\n\n},{\"25\":25,\"40\":40,\"45\":45}],17:[function(require,module,exports){\n'use strict';\n\nvar defaults = require(25);\nvar elements = require(40);\nvar helpers = require(45);\n\ndefaults._set('doughnut', {\n	animation: {\n		// Boolean - Whether we animate the rotation of the Doughnut\n		animateRotate: true,\n		// Boolean - Whether we animate scaling the Doughnut from the centre\n		animateScale: false\n	},\n	hover: {\n		mode: 'single'\n	},\n	legendCallback: function(chart) {\n		var text = [];\n		text.push('<ul class=\"' + chart.id + '-legend\">');\n\n		var data = chart.data;\n		var datasets = data.datasets;\n		var labels = data.labels;\n\n		if (datasets.length) {\n			for (var i = 0; i < datasets[0].data.length; ++i) {\n				text.push('<li><span style=\"background-color:' + datasets[0].backgroundColor[i] + '\"></span>');\n				if (labels[i]) {\n					text.push(labels[i]);\n				}\n				text.push('</li>');\n			}\n		}\n\n		text.push('</ul>');\n		return text.join('');\n	},\n	legend: {\n		labels: {\n			generateLabels: function(chart) {\n				var data = chart.data;\n				if (data.labels.length && data.datasets.length) {\n					return data.labels.map(function(label, i) {\n						var meta = chart.getDatasetMeta(0);\n						var ds = data.datasets[0];\n						var arc = meta.data[i];\n						var custom = arc && arc.custom || {};\n						var valueAtIndexOrDefault = helpers.valueAtIndexOrDefault;\n						var arcOpts = chart.options.elements.arc;\n						var fill = custom.backgroundColor ? custom.backgroundColor : valueAtIndexOrDefault(ds.backgroundColor, i, arcOpts.backgroundColor);\n						var stroke = custom.borderColor ? custom.borderColor : valueAtIndexOrDefault(ds.borderColor, i, arcOpts.borderColor);\n						var bw = custom.borderWidth ? custom.borderWidth : valueAtIndexOrDefault(ds.borderWidth, i, arcOpts.borderWidth);\n\n						return {\n							text: label,\n							fillStyle: fill,\n							strokeStyle: stroke,\n							lineWidth: bw,\n							hidden: isNaN(ds.data[i]) || meta.data[i].hidden,\n\n							// Extra data used for toggling the correct item\n							index: i\n						};\n					});\n				}\n				return [];\n			}\n		},\n\n		onClick: function(e, legendItem) {\n			var index = legendItem.index;\n			var chart = this.chart;\n			var i, ilen, meta;\n\n			for (i = 0, ilen = (chart.data.datasets || []).length; i < ilen; ++i) {\n				meta = chart.getDatasetMeta(i);\n				// toggle visibility of index if exists\n				if (meta.data[index]) {\n					meta.data[index].hidden = !meta.data[index].hidden;\n				}\n			}\n\n			chart.update();\n		}\n	},\n\n	// The percentage of the chart that we cut out of the middle.\n	cutoutPercentage: 50,\n\n	// The rotation of the chart, where the first data arc begins.\n	rotation: Math.PI * -0.5,\n\n	// The total circumference of the chart.\n	circumference: Math.PI * 2.0,\n\n	// Need to override these to give a nice default\n	tooltips: {\n		callbacks: {\n			title: function() {\n				return '';\n			},\n			label: function(tooltipItem, data) {\n				var dataLabel = data.labels[tooltipItem.index];\n				var value = ': ' + data.datasets[tooltipItem.datasetIndex].data[tooltipItem.index];\n\n				if (helpers.isArray(dataLabel)) {\n					// show value on first line of multiline label\n					// need to clone because we are changing the value\n					dataLabel = dataLabel.slice();\n					dataLabel[0] += value;\n				} else {\n					dataLabel += value;\n				}\n\n				return dataLabel;\n			}\n		}\n	}\n});\n\ndefaults._set('pie', helpers.clone(defaults.doughnut));\ndefaults._set('pie', {\n	cutoutPercentage: 0\n});\n\nmodule.exports = function(Chart) {\n\n	Chart.controllers.doughnut = Chart.controllers.pie = Chart.DatasetController.extend({\n\n		dataElementType: elements.Arc,\n\n		linkScales: helpers.noop,\n\n		// Get index of the dataset in relation to the visible datasets. This allows determining the inner and outer radius correctly\n		getRingIndex: function(datasetIndex) {\n			var ringIndex = 0;\n\n			for (var j = 0; j < datasetIndex; ++j) {\n				if (this.chart.isDatasetVisible(j)) {\n					++ringIndex;\n				}\n			}\n\n			return ringIndex;\n		},\n\n		update: function(reset) {\n			var me = this;\n			var chart = me.chart;\n			var chartArea = chart.chartArea;\n			var opts = chart.options;\n			var arcOpts = opts.elements.arc;\n			var availableWidth = chartArea.right - chartArea.left - arcOpts.borderWidth;\n			var availableHeight = chartArea.bottom - chartArea.top - arcOpts.borderWidth;\n			var minSize = Math.min(availableWidth, availableHeight);\n			var offset = {x: 0, y: 0};\n			var meta = me.getMeta();\n			var cutoutPercentage = opts.cutoutPercentage;\n			var circumference = opts.circumference;\n\n			// If the chart's circumference isn't a full circle, calculate minSize as a ratio of the width/height of the arc\n			if (circumference < Math.PI * 2.0) {\n				var startAngle = opts.rotation % (Math.PI * 2.0);\n				startAngle += Math.PI * 2.0 * (startAngle >= Math.PI ? -1 : startAngle < -Math.PI ? 1 : 0);\n				var endAngle = startAngle + circumference;\n				var start = {x: Math.cos(startAngle), y: Math.sin(startAngle)};\n				var end = {x: Math.cos(endAngle), y: Math.sin(endAngle)};\n				var contains0 = (startAngle <= 0 && endAngle >= 0) || (startAngle <= Math.PI * 2.0 && Math.PI * 2.0 <= endAngle);\n				var contains90 = (startAngle <= Math.PI * 0.5 && Math.PI * 0.5 <= endAngle) || (startAngle <= Math.PI * 2.5 && Math.PI * 2.5 <= endAngle);\n				var contains180 = (startAngle <= -Math.PI && -Math.PI <= endAngle) || (startAngle <= Math.PI && Math.PI <= endAngle);\n				var contains270 = (startAngle <= -Math.PI * 0.5 && -Math.PI * 0.5 <= endAngle) || (startAngle <= Math.PI * 1.5 && Math.PI * 1.5 <= endAngle);\n				var cutout = cutoutPercentage / 100.0;\n				var min = {x: contains180 ? -1 : Math.min(start.x * (start.x < 0 ? 1 : cutout), end.x * (end.x < 0 ? 1 : cutout)), y: contains270 ? -1 : Math.min(start.y * (start.y < 0 ? 1 : cutout), end.y * (end.y < 0 ? 1 : cutout))};\n				var max = {x: contains0 ? 1 : Math.max(start.x * (start.x > 0 ? 1 : cutout), end.x * (end.x > 0 ? 1 : cutout)), y: contains90 ? 1 : Math.max(start.y * (start.y > 0 ? 1 : cutout), end.y * (end.y > 0 ? 1 : cutout))};\n				var size = {width: (max.x - min.x) * 0.5, height: (max.y - min.y) * 0.5};\n				minSize = Math.min(availableWidth / size.width, availableHeight / size.height);\n				offset = {x: (max.x + min.x) * -0.5, y: (max.y + min.y) * -0.5};\n			}\n\n			chart.borderWidth = me.getMaxBorderWidth(meta.data);\n			chart.outerRadius = Math.max((minSize - chart.borderWidth) / 2, 0);\n			chart.innerRadius = Math.max(cutoutPercentage ? (chart.outerRadius / 100) * (cutoutPercentage) : 0, 0);\n			chart.radiusLength = (chart.outerRadius - chart.innerRadius) / chart.getVisibleDatasetCount();\n			chart.offsetX = offset.x * chart.outerRadius;\n			chart.offsetY = offset.y * chart.outerRadius;\n\n			meta.total = me.calculateTotal();\n\n			me.outerRadius = chart.outerRadius - (chart.radiusLength * me.getRingIndex(me.index));\n			me.innerRadius = Math.max(me.outerRadius - chart.radiusLength, 0);\n\n			helpers.each(meta.data, function(arc, index) {\n				me.updateElement(arc, index, reset);\n			});\n		},\n\n		updateElement: function(arc, index, reset) {\n			var me = this;\n			var chart = me.chart;\n			var chartArea = chart.chartArea;\n			var opts = chart.options;\n			var animationOpts = opts.animation;\n			var centerX = (chartArea.left + chartArea.right) / 2;\n			var centerY = (chartArea.top + chartArea.bottom) / 2;\n			var startAngle = opts.rotation; // non reset case handled later\n			var endAngle = opts.rotation; // non reset case handled later\n			var dataset = me.getDataset();\n			var circumference = reset && animationOpts.animateRotate ? 0 : arc.hidden ? 0 : me.calculateCircumference(dataset.data[index]) * (opts.circumference / (2.0 * Math.PI));\n			var innerRadius = reset && animationOpts.animateScale ? 0 : me.innerRadius;\n			var outerRadius = reset && animationOpts.animateScale ? 0 : me.outerRadius;\n			var valueAtIndexOrDefault = helpers.valueAtIndexOrDefault;\n\n			helpers.extend(arc, {\n				// Utility\n				_datasetIndex: me.index,\n				_index: index,\n\n				// Desired view properties\n				_model: {\n					x: centerX + chart.offsetX,\n					y: centerY + chart.offsetY,\n					startAngle: startAngle,\n					endAngle: endAngle,\n					circumference: circumference,\n					outerRadius: outerRadius,\n					innerRadius: innerRadius,\n					label: valueAtIndexOrDefault(dataset.label, index, chart.data.labels[index])\n				}\n			});\n\n			var model = arc._model;\n			// Resets the visual styles\n			this.removeHoverStyle(arc);\n\n			// Set correct angles if not resetting\n			if (!reset || !animationOpts.animateRotate) {\n				if (index === 0) {\n					model.startAngle = opts.rotation;\n				} else {\n					model.startAngle = me.getMeta().data[index - 1]._model.endAngle;\n				}\n\n				model.endAngle = model.startAngle + model.circumference;\n			}\n\n			arc.pivot();\n		},\n\n		removeHoverStyle: function(arc) {\n			Chart.DatasetController.prototype.removeHoverStyle.call(this, arc, this.chart.options.elements.arc);\n		},\n\n		calculateTotal: function() {\n			var dataset = this.getDataset();\n			var meta = this.getMeta();\n			var total = 0;\n			var value;\n\n			helpers.each(meta.data, function(element, index) {\n				value = dataset.data[index];\n				if (!isNaN(value) && !element.hidden) {\n					total += Math.abs(value);\n				}\n			});\n\n			/* if (total === 0) {\n				total = NaN;\n			}*/\n\n			return total;\n		},\n\n		calculateCircumference: function(value) {\n			var total = this.getMeta().total;\n			if (total > 0 && !isNaN(value)) {\n				return (Math.PI * 2.0) * (value / total);\n			}\n			return 0;\n		},\n\n		// gets the max border or hover width to properly scale pie charts\n		getMaxBorderWidth: function(arcs) {\n			var max = 0;\n			var index = this.index;\n			var length = arcs.length;\n			var borderWidth;\n			var hoverWidth;\n\n			for (var i = 0; i < length; i++) {\n				borderWidth = arcs[i]._model ? arcs[i]._model.borderWidth : 0;\n				hoverWidth = arcs[i]._chart ? arcs[i]._chart.config.data.datasets[index].hoverBorderWidth : 0;\n\n				max = borderWidth > max ? borderWidth : max;\n				max = hoverWidth > max ? hoverWidth : max;\n			}\n			return max;\n		}\n	});\n};\n\n},{\"25\":25,\"40\":40,\"45\":45}],18:[function(require,module,exports){\n'use strict';\n\nvar defaults = require(25);\nvar elements = require(40);\nvar helpers = require(45);\n\ndefaults._set('line', {\n	showLines: true,\n	spanGaps: false,\n\n	hover: {\n		mode: 'label'\n	},\n\n	scales: {\n		xAxes: [{\n			type: 'category',\n			id: 'x-axis-0'\n		}],\n		yAxes: [{\n			type: 'linear',\n			id: 'y-axis-0'\n		}]\n	}\n});\n\nmodule.exports = function(Chart) {\n\n	function lineEnabled(dataset, options) {\n		return helpers.valueOrDefault(dataset.showLine, options.showLines);\n	}\n\n	Chart.controllers.line = Chart.DatasetController.extend({\n\n		datasetElementType: elements.Line,\n\n		dataElementType: elements.Point,\n\n		update: function(reset) {\n			var me = this;\n			var meta = me.getMeta();\n			var line = meta.dataset;\n			var points = meta.data || [];\n			var options = me.chart.options;\n			var lineElementOptions = options.elements.line;\n			var scale = me.getScaleForId(meta.yAxisID);\n			var i, ilen, custom;\n			var dataset = me.getDataset();\n			var showLine = lineEnabled(dataset, options);\n\n			// Update Line\n			if (showLine) {\n				custom = line.custom || {};\n\n				// Compatibility: If the properties are defined with only the old name, use those values\n				if ((dataset.tension !== undefined) && (dataset.lineTension === undefined)) {\n					dataset.lineTension = dataset.tension;\n				}\n\n				// Utility\n				line._scale = scale;\n				line._datasetIndex = me.index;\n				// Data\n				line._children = points;\n				// Model\n				line._model = {\n					// Appearance\n					// The default behavior of lines is to break at null values, according\n					// to https://github.com/chartjs/Chart.js/issues/2435#issuecomment-216718158\n					// This option gives lines the ability to span gaps\n					spanGaps: dataset.spanGaps ? dataset.spanGaps : options.spanGaps,\n					tension: custom.tension ? custom.tension : helpers.valueOrDefault(dataset.lineTension, lineElementOptions.tension),\n					backgroundColor: custom.backgroundColor ? custom.backgroundColor : (dataset.backgroundColor || lineElementOptions.backgroundColor),\n					borderWidth: custom.borderWidth ? custom.borderWidth : (dataset.borderWidth || lineElementOptions.borderWidth),\n					borderColor: custom.borderColor ? custom.borderColor : (dataset.borderColor || lineElementOptions.borderColor),\n					borderCapStyle: custom.borderCapStyle ? custom.borderCapStyle : (dataset.borderCapStyle || lineElementOptions.borderCapStyle),\n					borderDash: custom.borderDash ? custom.borderDash : (dataset.borderDash || lineElementOptions.borderDash),\n					borderDashOffset: custom.borderDashOffset ? custom.borderDashOffset : (dataset.borderDashOffset || lineElementOptions.borderDashOffset),\n					borderJoinStyle: custom.borderJoinStyle ? custom.borderJoinStyle : (dataset.borderJoinStyle || lineElementOptions.borderJoinStyle),\n					fill: custom.fill ? custom.fill : (dataset.fill !== undefined ? dataset.fill : lineElementOptions.fill),\n					steppedLine: custom.steppedLine ? custom.steppedLine : helpers.valueOrDefault(dataset.steppedLine, lineElementOptions.stepped),\n					cubicInterpolationMode: custom.cubicInterpolationMode ? custom.cubicInterpolationMode : helpers.valueOrDefault(dataset.cubicInterpolationMode, lineElementOptions.cubicInterpolationMode),\n				};\n\n				line.pivot();\n			}\n\n			// Update Points\n			for (i = 0, ilen = points.length; i < ilen; ++i) {\n				me.updateElement(points[i], i, reset);\n			}\n\n			if (showLine && line._model.tension !== 0) {\n				me.updateBezierControlPoints();\n			}\n\n			// Now pivot the point for animation\n			for (i = 0, ilen = points.length; i < ilen; ++i) {\n				points[i].pivot();\n			}\n		},\n\n		getPointBackgroundColor: function(point, index) {\n			var backgroundColor = this.chart.options.elements.point.backgroundColor;\n			var dataset = this.getDataset();\n			var custom = point.custom || {};\n\n			if (custom.backgroundColor) {\n				backgroundColor = custom.backgroundColor;\n			} else if (dataset.pointBackgroundColor) {\n				backgroundColor = helpers.valueAtIndexOrDefault(dataset.pointBackgroundColor, index, backgroundColor);\n			} else if (dataset.backgroundColor) {\n				backgroundColor = dataset.backgroundColor;\n			}\n\n			return backgroundColor;\n		},\n\n		getPointBorderColor: function(point, index) {\n			var borderColor = this.chart.options.elements.point.borderColor;\n			var dataset = this.getDataset();\n			var custom = point.custom || {};\n\n			if (custom.borderColor) {\n				borderColor = custom.borderColor;\n			} else if (dataset.pointBorderColor) {\n				borderColor = helpers.valueAtIndexOrDefault(dataset.pointBorderColor, index, borderColor);\n			} else if (dataset.borderColor) {\n				borderColor = dataset.borderColor;\n			}\n\n			return borderColor;\n		},\n\n		getPointBorderWidth: function(point, index) {\n			var borderWidth = this.chart.options.elements.point.borderWidth;\n			var dataset = this.getDataset();\n			var custom = point.custom || {};\n\n			if (!isNaN(custom.borderWidth)) {\n				borderWidth = custom.borderWidth;\n			} else if (!isNaN(dataset.pointBorderWidth) || helpers.isArray(dataset.pointBorderWidth)) {\n				borderWidth = helpers.valueAtIndexOrDefault(dataset.pointBorderWidth, index, borderWidth);\n			} else if (!isNaN(dataset.borderWidth)) {\n				borderWidth = dataset.borderWidth;\n			}\n\n			return borderWidth;\n		},\n\n		updateElement: function(point, index, reset) {\n			var me = this;\n			var meta = me.getMeta();\n			var custom = point.custom || {};\n			var dataset = me.getDataset();\n			var datasetIndex = me.index;\n			var value = dataset.data[index];\n			var yScale = me.getScaleForId(meta.yAxisID);\n			var xScale = me.getScaleForId(meta.xAxisID);\n			var pointOptions = me.chart.options.elements.point;\n			var x, y;\n\n			// Compatibility: If the properties are defined with only the old name, use those values\n			if ((dataset.radius !== undefined) && (dataset.pointRadius === undefined)) {\n				dataset.pointRadius = dataset.radius;\n			}\n			if ((dataset.hitRadius !== undefined) && (dataset.pointHitRadius === undefined)) {\n				dataset.pointHitRadius = dataset.hitRadius;\n			}\n\n			x = xScale.getPixelForValue(typeof value === 'object' ? value : NaN, index, datasetIndex);\n			y = reset ? yScale.getBasePixel() : me.calculatePointY(value, index, datasetIndex);\n\n			// Utility\n			point._xScale = xScale;\n			point._yScale = yScale;\n			point._datasetIndex = datasetIndex;\n			point._index = index;\n\n			// Desired view properties\n			point._model = {\n				x: x,\n				y: y,\n				skip: custom.skip || isNaN(x) || isNaN(y),\n				// Appearance\n				radius: custom.radius || helpers.valueAtIndexOrDefault(dataset.pointRadius, index, pointOptions.radius),\n				pointStyle: custom.pointStyle || helpers.valueAtIndexOrDefault(dataset.pointStyle, index, pointOptions.pointStyle),\n				backgroundColor: me.getPointBackgroundColor(point, index),\n				borderColor: me.getPointBorderColor(point, index),\n				borderWidth: me.getPointBorderWidth(point, index),\n				tension: meta.dataset._model ? meta.dataset._model.tension : 0,\n				steppedLine: meta.dataset._model ? meta.dataset._model.steppedLine : false,\n				// Tooltip\n				hitRadius: custom.hitRadius || helpers.valueAtIndexOrDefault(dataset.pointHitRadius, index, pointOptions.hitRadius)\n			};\n		},\n\n		calculatePointY: function(value, index, datasetIndex) {\n			var me = this;\n			var chart = me.chart;\n			var meta = me.getMeta();\n			var yScale = me.getScaleForId(meta.yAxisID);\n			var sumPos = 0;\n			var sumNeg = 0;\n			var i, ds, dsMeta;\n\n			if (yScale.options.stacked) {\n				for (i = 0; i < datasetIndex; i++) {\n					ds = chart.data.datasets[i];\n					dsMeta = chart.getDatasetMeta(i);\n					if (dsMeta.type === 'line' && dsMeta.yAxisID === yScale.id && chart.isDatasetVisible(i)) {\n						var stackedRightValue = Number(yScale.getRightValue(ds.data[index]));\n						if (stackedRightValue < 0) {\n							sumNeg += stackedRightValue || 0;\n						} else {\n							sumPos += stackedRightValue || 0;\n						}\n					}\n				}\n\n				var rightValue = Number(yScale.getRightValue(value));\n				if (rightValue < 0) {\n					return yScale.getPixelForValue(sumNeg + rightValue);\n				}\n				return yScale.getPixelForValue(sumPos + rightValue);\n			}\n\n			return yScale.getPixelForValue(value);\n		},\n\n		updateBezierControlPoints: function() {\n			var me = this;\n			var meta = me.getMeta();\n			var area = me.chart.chartArea;\n			var points = (meta.data || []);\n			var i, ilen, point, model, controlPoints;\n\n			// Only consider points that are drawn in case the spanGaps option is used\n			if (meta.dataset._model.spanGaps) {\n				points = points.filter(function(pt) {\n					return !pt._model.skip;\n				});\n			}\n\n			function capControlPoint(pt, min, max) {\n				return Math.max(Math.min(pt, max), min);\n			}\n\n			if (meta.dataset._model.cubicInterpolationMode === 'monotone') {\n				helpers.splineCurveMonotone(points);\n			} else {\n				for (i = 0, ilen = points.length; i < ilen; ++i) {\n					point = points[i];\n					model = point._model;\n					controlPoints = helpers.splineCurve(\n						helpers.previousItem(points, i)._model,\n						model,\n						helpers.nextItem(points, i)._model,\n						meta.dataset._model.tension\n					);\n					model.controlPointPreviousX = controlPoints.previous.x;\n					model.controlPointPreviousY = controlPoints.previous.y;\n					model.controlPointNextX = controlPoints.next.x;\n					model.controlPointNextY = controlPoints.next.y;\n				}\n			}\n\n			if (me.chart.options.elements.line.capBezierPoints) {\n				for (i = 0, ilen = points.length; i < ilen; ++i) {\n					model = points[i]._model;\n					model.controlPointPreviousX = capControlPoint(model.controlPointPreviousX, area.left, area.right);\n					model.controlPointPreviousY = capControlPoint(model.controlPointPreviousY, area.top, area.bottom);\n					model.controlPointNextX = capControlPoint(model.controlPointNextX, area.left, area.right);\n					model.controlPointNextY = capControlPoint(model.controlPointNextY, area.top, area.bottom);\n				}\n			}\n		},\n\n		draw: function() {\n			var me = this;\n			var chart = me.chart;\n			var meta = me.getMeta();\n			var points = meta.data || [];\n			var area = chart.chartArea;\n			var ilen = points.length;\n			var i = 0;\n\n			helpers.canvas.clipArea(chart.ctx, area);\n\n			if (lineEnabled(me.getDataset(), chart.options)) {\n				meta.dataset.draw();\n			}\n\n			helpers.canvas.unclipArea(chart.ctx);\n\n			// Draw the points\n			for (; i < ilen; ++i) {\n				points[i].draw(area);\n			}\n		},\n\n		setHoverStyle: function(point) {\n			// Point\n			var dataset = this.chart.data.datasets[point._datasetIndex];\n			var index = point._index;\n			var custom = point.custom || {};\n			var model = point._model;\n\n			model.radius = custom.hoverRadius || helpers.valueAtIndexOrDefault(dataset.pointHoverRadius, index, this.chart.options.elements.point.hoverRadius);\n			model.backgroundColor = custom.hoverBackgroundColor || helpers.valueAtIndexOrDefault(dataset.pointHoverBackgroundColor, index, helpers.getHoverColor(model.backgroundColor));\n			model.borderColor = custom.hoverBorderColor || helpers.valueAtIndexOrDefault(dataset.pointHoverBorderColor, index, helpers.getHoverColor(model.borderColor));\n			model.borderWidth = custom.hoverBorderWidth || helpers.valueAtIndexOrDefault(dataset.pointHoverBorderWidth, index, model.borderWidth);\n		},\n\n		removeHoverStyle: function(point) {\n			var me = this;\n			var dataset = me.chart.data.datasets[point._datasetIndex];\n			var index = point._index;\n			var custom = point.custom || {};\n			var model = point._model;\n\n			// Compatibility: If the properties are defined with only the old name, use those values\n			if ((dataset.radius !== undefined) && (dataset.pointRadius === undefined)) {\n				dataset.pointRadius = dataset.radius;\n			}\n\n			model.radius = custom.radius || helpers.valueAtIndexOrDefault(dataset.pointRadius, index, me.chart.options.elements.point.radius);\n			model.backgroundColor = me.getPointBackgroundColor(point, index);\n			model.borderColor = me.getPointBorderColor(point, index);\n			model.borderWidth = me.getPointBorderWidth(point, index);\n		}\n	});\n};\n\n},{\"25\":25,\"40\":40,\"45\":45}],19:[function(require,module,exports){\n'use strict';\n\nvar defaults = require(25);\nvar elements = require(40);\nvar helpers = require(45);\n\ndefaults._set('polarArea', {\n	scale: {\n		type: 'radialLinear',\n		angleLines: {\n			display: false\n		},\n		gridLines: {\n			circular: true\n		},\n		pointLabels: {\n			display: false\n		},\n		ticks: {\n			beginAtZero: true\n		}\n	},\n\n	// Boolean - Whether to animate the rotation of the chart\n	animation: {\n		animateRotate: true,\n		animateScale: true\n	},\n\n	startAngle: -0.5 * Math.PI,\n	legendCallback: function(chart) {\n		var text = [];\n		text.push('<ul class=\"' + chart.id + '-legend\">');\n\n		var data = chart.data;\n		var datasets = data.datasets;\n		var labels = data.labels;\n\n		if (datasets.length) {\n			for (var i = 0; i < datasets[0].data.length; ++i) {\n				text.push('<li><span style=\"background-color:' + datasets[0].backgroundColor[i] + '\"></span>');\n				if (labels[i]) {\n					text.push(labels[i]);\n				}\n				text.push('</li>');\n			}\n		}\n\n		text.push('</ul>');\n		return text.join('');\n	},\n	legend: {\n		labels: {\n			generateLabels: function(chart) {\n				var data = chart.data;\n				if (data.labels.length && data.datasets.length) {\n					return data.labels.map(function(label, i) {\n						var meta = chart.getDatasetMeta(0);\n						var ds = data.datasets[0];\n						var arc = meta.data[i];\n						var custom = arc.custom || {};\n						var valueAtIndexOrDefault = helpers.valueAtIndexOrDefault;\n						var arcOpts = chart.options.elements.arc;\n						var fill = custom.backgroundColor ? custom.backgroundColor : valueAtIndexOrDefault(ds.backgroundColor, i, arcOpts.backgroundColor);\n						var stroke = custom.borderColor ? custom.borderColor : valueAtIndexOrDefault(ds.borderColor, i, arcOpts.borderColor);\n						var bw = custom.borderWidth ? custom.borderWidth : valueAtIndexOrDefault(ds.borderWidth, i, arcOpts.borderWidth);\n\n						return {\n							text: label,\n							fillStyle: fill,\n							strokeStyle: stroke,\n							lineWidth: bw,\n							hidden: isNaN(ds.data[i]) || meta.data[i].hidden,\n\n							// Extra data used for toggling the correct item\n							index: i\n						};\n					});\n				}\n				return [];\n			}\n		},\n\n		onClick: function(e, legendItem) {\n			var index = legendItem.index;\n			var chart = this.chart;\n			var i, ilen, meta;\n\n			for (i = 0, ilen = (chart.data.datasets || []).length; i < ilen; ++i) {\n				meta = chart.getDatasetMeta(i);\n				meta.data[index].hidden = !meta.data[index].hidden;\n			}\n\n			chart.update();\n		}\n	},\n\n	// Need to override these to give a nice default\n	tooltips: {\n		callbacks: {\n			title: function() {\n				return '';\n			},\n			label: function(item, data) {\n				return data.labels[item.index] + ': ' + item.yLabel;\n			}\n		}\n	}\n});\n\nmodule.exports = function(Chart) {\n\n	Chart.controllers.polarArea = Chart.DatasetController.extend({\n\n		dataElementType: elements.Arc,\n\n		linkScales: helpers.noop,\n\n		update: function(reset) {\n			var me = this;\n			var chart = me.chart;\n			var chartArea = chart.chartArea;\n			var meta = me.getMeta();\n			var opts = chart.options;\n			var arcOpts = opts.elements.arc;\n			var minSize = Math.min(chartArea.right - chartArea.left, chartArea.bottom - chartArea.top);\n			chart.outerRadius = Math.max((minSize - arcOpts.borderWidth / 2) / 2, 0);\n			chart.innerRadius = Math.max(opts.cutoutPercentage ? (chart.outerRadius / 100) * (opts.cutoutPercentage) : 1, 0);\n			chart.radiusLength = (chart.outerRadius - chart.innerRadius) / chart.getVisibleDatasetCount();\n\n			me.outerRadius = chart.outerRadius - (chart.radiusLength * me.index);\n			me.innerRadius = me.outerRadius - chart.radiusLength;\n\n			meta.count = me.countVisibleElements();\n\n			helpers.each(meta.data, function(arc, index) {\n				me.updateElement(arc, index, reset);\n			});\n		},\n\n		updateElement: function(arc, index, reset) {\n			var me = this;\n			var chart = me.chart;\n			var dataset = me.getDataset();\n			var opts = chart.options;\n			var animationOpts = opts.animation;\n			var scale = chart.scale;\n			var labels = chart.data.labels;\n\n			var circumference = me.calculateCircumference(dataset.data[index]);\n			var centerX = scale.xCenter;\n			var centerY = scale.yCenter;\n\n			// If there is NaN data before us, we need to calculate the starting angle correctly.\n			// We could be way more efficient here, but its unlikely that the polar area chart will have a lot of data\n			var visibleCount = 0;\n			var meta = me.getMeta();\n			for (var i = 0; i < index; ++i) {\n				if (!isNaN(dataset.data[i]) && !meta.data[i].hidden) {\n					++visibleCount;\n				}\n			}\n\n			// var negHalfPI = -0.5 * Math.PI;\n			var datasetStartAngle = opts.startAngle;\n			var distance = arc.hidden ? 0 : scale.getDistanceFromCenterForValue(dataset.data[index]);\n			var startAngle = datasetStartAngle + (circumference * visibleCount);\n			var endAngle = startAngle + (arc.hidden ? 0 : circumference);\n\n			var resetRadius = animationOpts.animateScale ? 0 : scale.getDistanceFromCenterForValue(dataset.data[index]);\n\n			helpers.extend(arc, {\n				// Utility\n				_datasetIndex: me.index,\n				_index: index,\n				_scale: scale,\n\n				// Desired view properties\n				_model: {\n					x: centerX,\n					y: centerY,\n					innerRadius: 0,\n					outerRadius: reset ? resetRadius : distance,\n					startAngle: reset && animationOpts.animateRotate ? datasetStartAngle : startAngle,\n					endAngle: reset && animationOpts.animateRotate ? datasetStartAngle : endAngle,\n					label: helpers.valueAtIndexOrDefault(labels, index, labels[index])\n				}\n			});\n\n			// Apply border and fill style\n			me.removeHoverStyle(arc);\n\n			arc.pivot();\n		},\n\n		removeHoverStyle: function(arc) {\n			Chart.DatasetController.prototype.removeHoverStyle.call(this, arc, this.chart.options.elements.arc);\n		},\n\n		countVisibleElements: function() {\n			var dataset = this.getDataset();\n			var meta = this.getMeta();\n			var count = 0;\n\n			helpers.each(meta.data, function(element, index) {\n				if (!isNaN(dataset.data[index]) && !element.hidden) {\n					count++;\n				}\n			});\n\n			return count;\n		},\n\n		calculateCircumference: function(value) {\n			var count = this.getMeta().count;\n			if (count > 0 && !isNaN(value)) {\n				return (2 * Math.PI) / count;\n			}\n			return 0;\n		}\n	});\n};\n\n},{\"25\":25,\"40\":40,\"45\":45}],20:[function(require,module,exports){\n'use strict';\n\nvar defaults = require(25);\nvar elements = require(40);\nvar helpers = require(45);\n\ndefaults._set('radar', {\n	scale: {\n		type: 'radialLinear'\n	},\n	elements: {\n		line: {\n			tension: 0 // no bezier in radar\n		}\n	}\n});\n\nmodule.exports = function(Chart) {\n\n	Chart.controllers.radar = Chart.DatasetController.extend({\n\n		datasetElementType: elements.Line,\n\n		dataElementType: elements.Point,\n\n		linkScales: helpers.noop,\n\n		update: function(reset) {\n			var me = this;\n			var meta = me.getMeta();\n			var line = meta.dataset;\n			var points = meta.data;\n			var custom = line.custom || {};\n			var dataset = me.getDataset();\n			var lineElementOptions = me.chart.options.elements.line;\n			var scale = me.chart.scale;\n\n			// Compatibility: If the properties are defined with only the old name, use those values\n			if ((dataset.tension !== undefined) && (dataset.lineTension === undefined)) {\n				dataset.lineTension = dataset.tension;\n			}\n\n			helpers.extend(meta.dataset, {\n				// Utility\n				_datasetIndex: me.index,\n				_scale: scale,\n				// Data\n				_children: points,\n				_loop: true,\n				// Model\n				_model: {\n					// Appearance\n					tension: custom.tension ? custom.tension : helpers.valueOrDefault(dataset.lineTension, lineElementOptions.tension),\n					backgroundColor: custom.backgroundColor ? custom.backgroundColor : (dataset.backgroundColor || lineElementOptions.backgroundColor),\n					borderWidth: custom.borderWidth ? custom.borderWidth : (dataset.borderWidth || lineElementOptions.borderWidth),\n					borderColor: custom.borderColor ? custom.borderColor : (dataset.borderColor || lineElementOptions.borderColor),\n					fill: custom.fill ? custom.fill : (dataset.fill !== undefined ? dataset.fill : lineElementOptions.fill),\n					borderCapStyle: custom.borderCapStyle ? custom.borderCapStyle : (dataset.borderCapStyle || lineElementOptions.borderCapStyle),\n					borderDash: custom.borderDash ? custom.borderDash : (dataset.borderDash || lineElementOptions.borderDash),\n					borderDashOffset: custom.borderDashOffset ? custom.borderDashOffset : (dataset.borderDashOffset || lineElementOptions.borderDashOffset),\n					borderJoinStyle: custom.borderJoinStyle ? custom.borderJoinStyle : (dataset.borderJoinStyle || lineElementOptions.borderJoinStyle),\n				}\n			});\n\n			meta.dataset.pivot();\n\n			// Update Points\n			helpers.each(points, function(point, index) {\n				me.updateElement(point, index, reset);\n			}, me);\n\n			// Update bezier control points\n			me.updateBezierControlPoints();\n		},\n		updateElement: function(point, index, reset) {\n			var me = this;\n			var custom = point.custom || {};\n			var dataset = me.getDataset();\n			var scale = me.chart.scale;\n			var pointElementOptions = me.chart.options.elements.point;\n			var pointPosition = scale.getPointPositionForValue(index, dataset.data[index]);\n\n			// Compatibility: If the properties are defined with only the old name, use those values\n			if ((dataset.radius !== undefined) && (dataset.pointRadius === undefined)) {\n				dataset.pointRadius = dataset.radius;\n			}\n			if ((dataset.hitRadius !== undefined) && (dataset.pointHitRadius === undefined)) {\n				dataset.pointHitRadius = dataset.hitRadius;\n			}\n\n			helpers.extend(point, {\n				// Utility\n				_datasetIndex: me.index,\n				_index: index,\n				_scale: scale,\n\n				// Desired view properties\n				_model: {\n					x: reset ? scale.xCenter : pointPosition.x, // value not used in dataset scale, but we want a consistent API between scales\n					y: reset ? scale.yCenter : pointPosition.y,\n\n					// Appearance\n					tension: custom.tension ? custom.tension : helpers.valueOrDefault(dataset.lineTension, me.chart.options.elements.line.tension),\n					radius: custom.radius ? custom.radius : helpers.valueAtIndexOrDefault(dataset.pointRadius, index, pointElementOptions.radius),\n					backgroundColor: custom.backgroundColor ? custom.backgroundColor : helpers.valueAtIndexOrDefault(dataset.pointBackgroundColor, index, pointElementOptions.backgroundColor),\n					borderColor: custom.borderColor ? custom.borderColor : helpers.valueAtIndexOrDefault(dataset.pointBorderColor, index, pointElementOptions.borderColor),\n					borderWidth: custom.borderWidth ? custom.borderWidth : helpers.valueAtIndexOrDefault(dataset.pointBorderWidth, index, pointElementOptions.borderWidth),\n					pointStyle: custom.pointStyle ? custom.pointStyle : helpers.valueAtIndexOrDefault(dataset.pointStyle, index, pointElementOptions.pointStyle),\n\n					// Tooltip\n					hitRadius: custom.hitRadius ? custom.hitRadius : helpers.valueAtIndexOrDefault(dataset.pointHitRadius, index, pointElementOptions.hitRadius)\n				}\n			});\n\n			point._model.skip = custom.skip ? custom.skip : (isNaN(point._model.x) || isNaN(point._model.y));\n		},\n		updateBezierControlPoints: function() {\n			var chartArea = this.chart.chartArea;\n			var meta = this.getMeta();\n\n			helpers.each(meta.data, function(point, index) {\n				var model = point._model;\n				var controlPoints = helpers.splineCurve(\n					helpers.previousItem(meta.data, index, true)._model,\n					model,\n					helpers.nextItem(meta.data, index, true)._model,\n					model.tension\n				);\n\n				// Prevent the bezier going outside of the bounds of the graph\n				model.controlPointPreviousX = Math.max(Math.min(controlPoints.previous.x, chartArea.right), chartArea.left);\n				model.controlPointPreviousY = Math.max(Math.min(controlPoints.previous.y, chartArea.bottom), chartArea.top);\n\n				model.controlPointNextX = Math.max(Math.min(controlPoints.next.x, chartArea.right), chartArea.left);\n				model.controlPointNextY = Math.max(Math.min(controlPoints.next.y, chartArea.bottom), chartArea.top);\n\n				// Now pivot the point for animation\n				point.pivot();\n			});\n		},\n\n		setHoverStyle: function(point) {\n			// Point\n			var dataset = this.chart.data.datasets[point._datasetIndex];\n			var custom = point.custom || {};\n			var index = point._index;\n			var model = point._model;\n\n			model.radius = custom.hoverRadius ? custom.hoverRadius : helpers.valueAtIndexOrDefault(dataset.pointHoverRadius, index, this.chart.options.elements.point.hoverRadius);\n			model.backgroundColor = custom.hoverBackgroundColor ? custom.hoverBackgroundColor : helpers.valueAtIndexOrDefault(dataset.pointHoverBackgroundColor, index, helpers.getHoverColor(model.backgroundColor));\n			model.borderColor = custom.hoverBorderColor ? custom.hoverBorderColor : helpers.valueAtIndexOrDefault(dataset.pointHoverBorderColor, index, helpers.getHoverColor(model.borderColor));\n			model.borderWidth = custom.hoverBorderWidth ? custom.hoverBorderWidth : helpers.valueAtIndexOrDefault(dataset.pointHoverBorderWidth, index, model.borderWidth);\n		},\n\n		removeHoverStyle: function(point) {\n			var dataset = this.chart.data.datasets[point._datasetIndex];\n			var custom = point.custom || {};\n			var index = point._index;\n			var model = point._model;\n			var pointElementOptions = this.chart.options.elements.point;\n\n			model.radius = custom.radius ? custom.radius : helpers.valueAtIndexOrDefault(dataset.pointRadius, index, pointElementOptions.radius);\n			model.backgroundColor = custom.backgroundColor ? custom.backgroundColor : helpers.valueAtIndexOrDefault(dataset.pointBackgroundColor, index, pointElementOptions.backgroundColor);\n			model.borderColor = custom.borderColor ? custom.borderColor : helpers.valueAtIndexOrDefault(dataset.pointBorderColor, index, pointElementOptions.borderColor);\n			model.borderWidth = custom.borderWidth ? custom.borderWidth : helpers.valueAtIndexOrDefault(dataset.pointBorderWidth, index, pointElementOptions.borderWidth);\n		}\n	});\n};\n\n},{\"25\":25,\"40\":40,\"45\":45}],21:[function(require,module,exports){\n'use strict';\n\nvar defaults = require(25);\n\ndefaults._set('scatter', {\n	hover: {\n		mode: 'single'\n	},\n\n	scales: {\n		xAxes: [{\n			id: 'x-axis-1',    // need an ID so datasets can reference the scale\n			type: 'linear',    // scatter should not use a category axis\n			position: 'bottom'\n		}],\n		yAxes: [{\n			id: 'y-axis-1',\n			type: 'linear',\n			position: 'left'\n		}]\n	},\n\n	showLines: false,\n\n	tooltips: {\n		callbacks: {\n			title: function() {\n				return '';     // doesn't make sense for scatter since data are formatted as a point\n			},\n			label: function(item) {\n				return '(' + item.xLabel + ', ' + item.yLabel + ')';\n			}\n		}\n	}\n});\n\nmodule.exports = function(Chart) {\n\n	// Scatter charts use line controllers\n	Chart.controllers.scatter = Chart.controllers.line;\n\n};\n\n},{\"25\":25}],22:[function(require,module,exports){\n/* global window: false */\n'use strict';\n\nvar defaults = require(25);\nvar Element = require(26);\nvar helpers = require(45);\n\ndefaults._set('global', {\n	animation: {\n		duration: 1000,\n		easing: 'easeOutQuart',\n		onProgress: helpers.noop,\n		onComplete: helpers.noop\n	}\n});\n\nmodule.exports = function(Chart) {\n\n	Chart.Animation = Element.extend({\n		chart: null, // the animation associated chart instance\n		currentStep: 0, // the current animation step\n		numSteps: 60, // default number of steps\n		easing: '', // the easing to use for this animation\n		render: null, // render function used by the animation service\n\n		onAnimationProgress: null, // user specified callback to fire on each step of the animation\n		onAnimationComplete: null, // user specified callback to fire when the animation finishes\n	});\n\n	Chart.animationService = {\n		frameDuration: 17,\n		animations: [],\n		dropFrames: 0,\n		request: null,\n\n		/**\n		 * @param {Chart} chart - The chart to animate.\n		 * @param {Chart.Animation} animation - The animation that we will animate.\n		 * @param {Number} duration - The animation duration in ms.\n		 * @param {Boolean} lazy - if true, the chart is not marked as animating to enable more responsive interactions\n		 */\n		addAnimation: function(chart, animation, duration, lazy) {\n			var animations = this.animations;\n			var i, ilen;\n\n			animation.chart = chart;\n\n			if (!lazy) {\n				chart.animating = true;\n			}\n\n			for (i = 0, ilen = animations.length; i < ilen; ++i) {\n				if (animations[i].chart === chart) {\n					animations[i] = animation;\n					return;\n				}\n			}\n\n			animations.push(animation);\n\n			// If there are no animations queued, manually kickstart a digest, for lack of a better word\n			if (animations.length === 1) {\n				this.requestAnimationFrame();\n			}\n		},\n\n		cancelAnimation: function(chart) {\n			var index = helpers.findIndex(this.animations, function(animation) {\n				return animation.chart === chart;\n			});\n\n			if (index !== -1) {\n				this.animations.splice(index, 1);\n				chart.animating = false;\n			}\n		},\n\n		requestAnimationFrame: function() {\n			var me = this;\n			if (me.request === null) {\n				// Skip animation frame requests until the active one is executed.\n				// This can happen when processing mouse events, e.g. 'mousemove'\n				// and 'mouseout' events will trigger multiple renders.\n				me.request = helpers.requestAnimFrame.call(window, function() {\n					me.request = null;\n					me.startDigest();\n				});\n			}\n		},\n\n		/**\n		 * @private\n		 */\n		startDigest: function() {\n			var me = this;\n			var startTime = Date.now();\n			var framesToDrop = 0;\n\n			if (me.dropFrames > 1) {\n				framesToDrop = Math.floor(me.dropFrames);\n				me.dropFrames = me.dropFrames % 1;\n			}\n\n			me.advance(1 + framesToDrop);\n\n			var endTime = Date.now();\n\n			me.dropFrames += (endTime - startTime) / me.frameDuration;\n\n			// Do we have more stuff to animate?\n			if (me.animations.length > 0) {\n				me.requestAnimationFrame();\n			}\n		},\n\n		/**\n		 * @private\n		 */\n		advance: function(count) {\n			var animations = this.animations;\n			var animation, chart;\n			var i = 0;\n\n			while (i < animations.length) {\n				animation = animations[i];\n				chart = animation.chart;\n\n				animation.currentStep = (animation.currentStep || 0) + count;\n				animation.currentStep = Math.min(animation.currentStep, animation.numSteps);\n\n				helpers.callback(animation.render, [chart, animation], chart);\n				helpers.callback(animation.onAnimationProgress, [animation], chart);\n\n				if (animation.currentStep >= animation.numSteps) {\n					helpers.callback(animation.onAnimationComplete, [animation], chart);\n					chart.animating = false;\n					animations.splice(i, 1);\n				} else {\n					++i;\n				}\n			}\n		}\n	};\n\n	/**\n	 * Provided for backward compatibility, use Chart.Animation instead\n	 * @prop Chart.Animation#animationObject\n	 * @deprecated since version 2.6.0\n	 * @todo remove at version 3\n	 */\n	Object.defineProperty(Chart.Animation.prototype, 'animationObject', {\n		get: function() {\n			return this;\n		}\n	});\n\n	/**\n	 * Provided for backward compatibility, use Chart.Animation#chart instead\n	 * @prop Chart.Animation#chartInstance\n	 * @deprecated since version 2.6.0\n	 * @todo remove at version 3\n	 */\n	Object.defineProperty(Chart.Animation.prototype, 'chartInstance', {\n		get: function() {\n			return this.chart;\n		},\n		set: function(value) {\n			this.chart = value;\n		}\n	});\n\n};\n\n},{\"25\":25,\"26\":26,\"45\":45}],23:[function(require,module,exports){\n'use strict';\n\nvar defaults = require(25);\nvar helpers = require(45);\nvar Interaction = require(28);\nvar platform = require(48);\n\nmodule.exports = function(Chart) {\n	var plugins = Chart.plugins;\n\n	// Create a dictionary of chart types, to allow for extension of existing types\n	Chart.types = {};\n\n	// Store a reference to each instance - allowing us to globally resize chart instances on window resize.\n	// Destroy method on the chart will remove the instance of the chart from this reference.\n	Chart.instances = {};\n\n	// Controllers available for dataset visualization eg. bar, line, slice, etc.\n	Chart.controllers = {};\n\n	/**\n	 * Initializes the given config with global and chart default values.\n	 */\n	function initConfig(config) {\n		config = config || {};\n\n		// Do NOT use configMerge() for the data object because this method merges arrays\n		// and so would change references to labels and datasets, preventing data updates.\n		var data = config.data = config.data || {};\n		data.datasets = data.datasets || [];\n		data.labels = data.labels || [];\n\n		config.options = helpers.configMerge(\n			defaults.global,\n			defaults[config.type],\n			config.options || {});\n\n		return config;\n	}\n\n	/**\n	 * Updates the config of the chart\n	 * @param chart {Chart} chart to update the options for\n	 */\n	function updateConfig(chart) {\n		var newOptions = chart.options;\n\n		// Update Scale(s) with options\n		if (newOptions.scale) {\n			chart.scale.options = newOptions.scale;\n		} else if (newOptions.scales) {\n			newOptions.scales.xAxes.concat(newOptions.scales.yAxes).forEach(function(scaleOptions) {\n				chart.scales[scaleOptions.id].options = scaleOptions;\n			});\n		}\n\n		// Tooltip\n		chart.tooltip._options = newOptions.tooltips;\n	}\n\n	function positionIsHorizontal(position) {\n		return position === 'top' || position === 'bottom';\n	}\n\n	helpers.extend(Chart.prototype, /** @lends Chart */ {\n		/**\n		 * @private\n		 */\n		construct: function(item, config) {\n			var me = this;\n\n			config = initConfig(config);\n\n			var context = platform.acquireContext(item, config);\n			var canvas = context && context.canvas;\n			var height = canvas && canvas.height;\n			var width = canvas && canvas.width;\n\n			me.id = helpers.uid();\n			me.ctx = context;\n			me.canvas = canvas;\n			me.config = config;\n			me.width = width;\n			me.height = height;\n			me.aspectRatio = height ? width / height : null;\n			me.options = config.options;\n			me._bufferedRender = false;\n\n			/**\n			 * Provided for backward compatibility, Chart and Chart.Controller have been merged,\n			 * the \"instance\" still need to be defined since it might be called from plugins.\n			 * @prop Chart#chart\n			 * @deprecated since version 2.6.0\n			 * @todo remove at version 3\n			 * @private\n			 */\n			me.chart = me;\n			me.controller = me; // chart.chart.controller #inception\n\n			// Add the chart instance to the global namespace\n			Chart.instances[me.id] = me;\n\n			// Define alias to the config data: `chart.data === chart.config.data`\n			Object.defineProperty(me, 'data', {\n				get: function() {\n					return me.config.data;\n				},\n				set: function(value) {\n					me.config.data = value;\n				}\n			});\n\n			if (!context || !canvas) {\n				// The given item is not a compatible context2d element, let's return before finalizing\n				// the chart initialization but after setting basic chart / controller properties that\n				// can help to figure out that the chart is not valid (e.g chart.canvas !== null);\n				// https://github.com/chartjs/Chart.js/issues/2807\n				console.error(\"Failed to create chart: can't acquire context from the given item\");\n				return;\n			}\n\n			me.initialize();\n			me.update();\n		},\n\n		/**\n		 * @private\n		 */\n		initialize: function() {\n			var me = this;\n\n			// Before init plugin notification\n			plugins.notify(me, 'beforeInit');\n\n			helpers.retinaScale(me, me.options.devicePixelRatio);\n\n			me.bindEvents();\n\n			if (me.options.responsive) {\n				// Initial resize before chart draws (must be silent to preserve initial animations).\n				me.resize(true);\n			}\n\n			// Make sure scales have IDs and are built before we build any controllers.\n			me.ensureScalesHaveIDs();\n			me.buildScales();\n			me.initToolTip();\n\n			// After init plugin notification\n			plugins.notify(me, 'afterInit');\n\n			return me;\n		},\n\n		clear: function() {\n			helpers.canvas.clear(this);\n			return this;\n		},\n\n		stop: function() {\n			// Stops any current animation loop occurring\n			Chart.animationService.cancelAnimation(this);\n			return this;\n		},\n\n		resize: function(silent) {\n			var me = this;\n			var options = me.options;\n			var canvas = me.canvas;\n			var aspectRatio = (options.maintainAspectRatio && me.aspectRatio) || null;\n\n			// the canvas render width and height will be casted to integers so make sure that\n			// the canvas display style uses the same integer values to avoid blurring effect.\n\n			// Set to 0 instead of canvas.size because the size defaults to 300x150 if the element is collased\n			var newWidth = Math.max(0, Math.floor(helpers.getMaximumWidth(canvas)));\n			var newHeight = Math.max(0, Math.floor(aspectRatio ? newWidth / aspectRatio : helpers.getMaximumHeight(canvas)));\n\n			if (me.width === newWidth && me.height === newHeight) {\n				return;\n			}\n\n			canvas.width = me.width = newWidth;\n			canvas.height = me.height = newHeight;\n			canvas.style.width = newWidth + 'px';\n			canvas.style.height = newHeight + 'px';\n\n			helpers.retinaScale(me, options.devicePixelRatio);\n\n			if (!silent) {\n				// Notify any plugins about the resize\n				var newSize = {width: newWidth, height: newHeight};\n				plugins.notify(me, 'resize', [newSize]);\n\n				// Notify of resize\n				if (me.options.onResize) {\n					me.options.onResize(me, newSize);\n				}\n\n				me.stop();\n				me.update(me.options.responsiveAnimationDuration);\n			}\n		},\n\n		ensureScalesHaveIDs: function() {\n			var options = this.options;\n			var scalesOptions = options.scales || {};\n			var scaleOptions = options.scale;\n\n			helpers.each(scalesOptions.xAxes, function(xAxisOptions, index) {\n				xAxisOptions.id = xAxisOptions.id || ('x-axis-' + index);\n			});\n\n			helpers.each(scalesOptions.yAxes, function(yAxisOptions, index) {\n				yAxisOptions.id = yAxisOptions.id || ('y-axis-' + index);\n			});\n\n			if (scaleOptions) {\n				scaleOptions.id = scaleOptions.id || 'scale';\n			}\n		},\n\n		/**\n		 * Builds a map of scale ID to scale object for future lookup.\n		 */\n		buildScales: function() {\n			var me = this;\n			var options = me.options;\n			var scales = me.scales = {};\n			var items = [];\n\n			if (options.scales) {\n				items = items.concat(\n					(options.scales.xAxes || []).map(function(xAxisOptions) {\n						return {options: xAxisOptions, dtype: 'category', dposition: 'bottom'};\n					}),\n					(options.scales.yAxes || []).map(function(yAxisOptions) {\n						return {options: yAxisOptions, dtype: 'linear', dposition: 'left'};\n					})\n				);\n			}\n\n			if (options.scale) {\n				items.push({\n					options: options.scale,\n					dtype: 'radialLinear',\n					isDefault: true,\n					dposition: 'chartArea'\n				});\n			}\n\n			helpers.each(items, function(item) {\n				var scaleOptions = item.options;\n				var scaleType = helpers.valueOrDefault(scaleOptions.type, item.dtype);\n				var scaleClass = Chart.scaleService.getScaleConstructor(scaleType);\n				if (!scaleClass) {\n					return;\n				}\n\n				if (positionIsHorizontal(scaleOptions.position) !== positionIsHorizontal(item.dposition)) {\n					scaleOptions.position = item.dposition;\n				}\n\n				var scale = new scaleClass({\n					id: scaleOptions.id,\n					options: scaleOptions,\n					ctx: me.ctx,\n					chart: me\n				});\n\n				scales[scale.id] = scale;\n				scale.mergeTicksOptions();\n\n				// TODO(SB): I think we should be able to remove this custom case (options.scale)\n				// and consider it as a regular scale part of the \"scales\"\" map only! This would\n				// make the logic easier and remove some useless? custom code.\n				if (item.isDefault) {\n					me.scale = scale;\n				}\n			});\n\n			Chart.scaleService.addScalesToLayout(this);\n		},\n\n		buildOrUpdateControllers: function() {\n			var me = this;\n			var types = [];\n			var newControllers = [];\n\n			helpers.each(me.data.datasets, function(dataset, datasetIndex) {\n				var meta = me.getDatasetMeta(datasetIndex);\n				var type = dataset.type || me.config.type;\n\n				if (meta.type && meta.type !== type) {\n					me.destroyDatasetMeta(datasetIndex);\n					meta = me.getDatasetMeta(datasetIndex);\n				}\n				meta.type = type;\n\n				types.push(meta.type);\n\n				if (meta.controller) {\n					meta.controller.updateIndex(datasetIndex);\n				} else {\n					var ControllerClass = Chart.controllers[meta.type];\n					if (ControllerClass === undefined) {\n						throw new Error('\"' + meta.type + '\" is not a chart type.');\n					}\n\n					meta.controller = new ControllerClass(me, datasetIndex);\n					newControllers.push(meta.controller);\n				}\n			}, me);\n\n			return newControllers;\n		},\n\n		/**\n		 * Reset the elements of all datasets\n		 * @private\n		 */\n		resetElements: function() {\n			var me = this;\n			helpers.each(me.data.datasets, function(dataset, datasetIndex) {\n				me.getDatasetMeta(datasetIndex).controller.reset();\n			}, me);\n		},\n\n		/**\n		* Resets the chart back to it's state before the initial animation\n		*/\n		reset: function() {\n			this.resetElements();\n			this.tooltip.initialize();\n		},\n\n		update: function(config) {\n			var me = this;\n\n			if (!config || typeof config !== 'object') {\n				// backwards compatibility\n				config = {\n					duration: config,\n					lazy: arguments[1]\n				};\n			}\n\n			updateConfig(me);\n\n			if (plugins.notify(me, 'beforeUpdate') === false) {\n				return;\n			}\n\n			// In case the entire data object changed\n			me.tooltip._data = me.data;\n\n			// Make sure dataset controllers are updated and new controllers are reset\n			var newControllers = me.buildOrUpdateControllers();\n\n			// Make sure all dataset controllers have correct meta data counts\n			helpers.each(me.data.datasets, function(dataset, datasetIndex) {\n				me.getDatasetMeta(datasetIndex).controller.buildOrUpdateElements();\n			}, me);\n\n			me.updateLayout();\n\n			// Can only reset the new controllers after the scales have been updated\n			helpers.each(newControllers, function(controller) {\n				controller.reset();\n			});\n\n			me.updateDatasets();\n\n			// Need to reset tooltip in case it is displayed with elements that are removed\n			// after update.\n			me.tooltip.initialize();\n\n			// Last active contains items that were previously in the tooltip.\n			// When we reset the tooltip, we need to clear it\n			me.lastActive = [];\n\n			// Do this before render so that any plugins that need final scale updates can use it\n			plugins.notify(me, 'afterUpdate');\n\n			if (me._bufferedRender) {\n				me._bufferedRequest = {\n					duration: config.duration,\n					easing: config.easing,\n					lazy: config.lazy\n				};\n			} else {\n				me.render(config);\n			}\n		},\n\n		/**\n		 * Updates the chart layout unless a plugin returns `false` to the `beforeLayout`\n		 * hook, in which case, plugins will not be called on `afterLayout`.\n		 * @private\n		 */\n		updateLayout: function() {\n			var me = this;\n\n			if (plugins.notify(me, 'beforeLayout') === false) {\n				return;\n			}\n\n			Chart.layoutService.update(this, this.width, this.height);\n\n			/**\n			 * Provided for backward compatibility, use `afterLayout` instead.\n			 * @method IPlugin#afterScaleUpdate\n			 * @deprecated since version 2.5.0\n			 * @todo remove at version 3\n			 * @private\n			 */\n			plugins.notify(me, 'afterScaleUpdate');\n			plugins.notify(me, 'afterLayout');\n		},\n\n		/**\n		 * Updates all datasets unless a plugin returns `false` to the `beforeDatasetsUpdate`\n		 * hook, in which case, plugins will not be called on `afterDatasetsUpdate`.\n		 * @private\n		 */\n		updateDatasets: function() {\n			var me = this;\n\n			if (plugins.notify(me, 'beforeDatasetsUpdate') === false) {\n				return;\n			}\n\n			for (var i = 0, ilen = me.data.datasets.length; i < ilen; ++i) {\n				me.updateDataset(i);\n			}\n\n			plugins.notify(me, 'afterDatasetsUpdate');\n		},\n\n		/**\n		 * Updates dataset at index unless a plugin returns `false` to the `beforeDatasetUpdate`\n		 * hook, in which case, plugins will not be called on `afterDatasetUpdate`.\n		 * @private\n		 */\n		updateDataset: function(index) {\n			var me = this;\n			var meta = me.getDatasetMeta(index);\n			var args = {\n				meta: meta,\n				index: index\n			};\n\n			if (plugins.notify(me, 'beforeDatasetUpdate', [args]) === false) {\n				return;\n			}\n\n			meta.controller.update();\n\n			plugins.notify(me, 'afterDatasetUpdate', [args]);\n		},\n\n		render: function(config) {\n			var me = this;\n\n			if (!config || typeof config !== 'object') {\n				// backwards compatibility\n				config = {\n					duration: config,\n					lazy: arguments[1]\n				};\n			}\n\n			var duration = config.duration;\n			var lazy = config.lazy;\n\n			if (plugins.notify(me, 'beforeRender') === false) {\n				return;\n			}\n\n			var animationOptions = me.options.animation;\n			var onComplete = function(animation) {\n				plugins.notify(me, 'afterRender');\n				helpers.callback(animationOptions && animationOptions.onComplete, [animation], me);\n			};\n\n			if (animationOptions && ((typeof duration !== 'undefined' && duration !== 0) || (typeof duration === 'undefined' && animationOptions.duration !== 0))) {\n				var animation = new Chart.Animation({\n					numSteps: (duration || animationOptions.duration) / 16.66, // 60 fps\n					easing: config.easing || animationOptions.easing,\n\n					render: function(chart, animationObject) {\n						var easingFunction = helpers.easing.effects[animationObject.easing];\n						var currentStep = animationObject.currentStep;\n						var stepDecimal = currentStep / animationObject.numSteps;\n\n						chart.draw(easingFunction(stepDecimal), stepDecimal, currentStep);\n					},\n\n					onAnimationProgress: animationOptions.onProgress,\n					onAnimationComplete: onComplete\n				});\n\n				Chart.animationService.addAnimation(me, animation, duration, lazy);\n			} else {\n				me.draw();\n\n				// See https://github.com/chartjs/Chart.js/issues/3781\n				onComplete(new Chart.Animation({numSteps: 0, chart: me}));\n			}\n\n			return me;\n		},\n\n		draw: function(easingValue) {\n			var me = this;\n\n			me.clear();\n\n			if (helpers.isNullOrUndef(easingValue)) {\n				easingValue = 1;\n			}\n\n			me.transition(easingValue);\n\n			if (plugins.notify(me, 'beforeDraw', [easingValue]) === false) {\n				return;\n			}\n\n			// Draw all the scales\n			helpers.each(me.boxes, function(box) {\n				box.draw(me.chartArea);\n			}, me);\n\n			if (me.scale) {\n				me.scale.draw();\n			}\n\n			me.drawDatasets(easingValue);\n			me._drawTooltip(easingValue);\n\n			plugins.notify(me, 'afterDraw', [easingValue]);\n		},\n\n		/**\n		 * @private\n		 */\n		transition: function(easingValue) {\n			var me = this;\n\n			for (var i = 0, ilen = (me.data.datasets || []).length; i < ilen; ++i) {\n				if (me.isDatasetVisible(i)) {\n					me.getDatasetMeta(i).controller.transition(easingValue);\n				}\n			}\n\n			me.tooltip.transition(easingValue);\n		},\n\n		/**\n		 * Draws all datasets unless a plugin returns `false` to the `beforeDatasetsDraw`\n		 * hook, in which case, plugins will not be called on `afterDatasetsDraw`.\n		 * @private\n		 */\n		drawDatasets: function(easingValue) {\n			var me = this;\n\n			if (plugins.notify(me, 'beforeDatasetsDraw', [easingValue]) === false) {\n				return;\n			}\n\n			// Draw datasets reversed to support proper line stacking\n			for (var i = (me.data.datasets || []).length - 1; i >= 0; --i) {\n				if (me.isDatasetVisible(i)) {\n					me.drawDataset(i, easingValue);\n				}\n			}\n\n			plugins.notify(me, 'afterDatasetsDraw', [easingValue]);\n		},\n\n		/**\n		 * Draws dataset at index unless a plugin returns `false` to the `beforeDatasetDraw`\n		 * hook, in which case, plugins will not be called on `afterDatasetDraw`.\n		 * @private\n		 */\n		drawDataset: function(index, easingValue) {\n			var me = this;\n			var meta = me.getDatasetMeta(index);\n			var args = {\n				meta: meta,\n				index: index,\n				easingValue: easingValue\n			};\n\n			if (plugins.notify(me, 'beforeDatasetDraw', [args]) === false) {\n				return;\n			}\n\n			meta.controller.draw(easingValue);\n\n			plugins.notify(me, 'afterDatasetDraw', [args]);\n		},\n\n		/**\n		 * Draws tooltip unless a plugin returns `false` to the `beforeTooltipDraw`\n		 * hook, in which case, plugins will not be called on `afterTooltipDraw`.\n		 * @private\n		 */\n		_drawTooltip: function(easingValue) {\n			var me = this;\n			var tooltip = me.tooltip;\n			var args = {\n				tooltip: tooltip,\n				easingValue: easingValue\n			};\n\n			if (plugins.notify(me, 'beforeTooltipDraw', [args]) === false) {\n				return;\n			}\n\n			tooltip.draw();\n\n			plugins.notify(me, 'afterTooltipDraw', [args]);\n		},\n\n		// Get the single element that was clicked on\n		// @return : An object containing the dataset index and element index of the matching element. Also contains the rectangle that was draw\n		getElementAtEvent: function(e) {\n			return Interaction.modes.single(this, e);\n		},\n\n		getElementsAtEvent: function(e) {\n			return Interaction.modes.label(this, e, {intersect: true});\n		},\n\n		getElementsAtXAxis: function(e) {\n			return Interaction.modes['x-axis'](this, e, {intersect: true});\n		},\n\n		getElementsAtEventForMode: function(e, mode, options) {\n			var method = Interaction.modes[mode];\n			if (typeof method === 'function') {\n				return method(this, e, options);\n			}\n\n			return [];\n		},\n\n		getDatasetAtEvent: function(e) {\n			return Interaction.modes.dataset(this, e, {intersect: true});\n		},\n\n		getDatasetMeta: function(datasetIndex) {\n			var me = this;\n			var dataset = me.data.datasets[datasetIndex];\n			if (!dataset._meta) {\n				dataset._meta = {};\n			}\n\n			var meta = dataset._meta[me.id];\n			if (!meta) {\n				meta = dataset._meta[me.id] = {\n					type: null,\n					data: [],\n					dataset: null,\n					controller: null,\n					hidden: null,			// See isDatasetVisible() comment\n					xAxisID: null,\n					yAxisID: null\n				};\n			}\n\n			return meta;\n		},\n\n		getVisibleDatasetCount: function() {\n			var count = 0;\n			for (var i = 0, ilen = this.data.datasets.length; i < ilen; ++i) {\n				if (this.isDatasetVisible(i)) {\n					count++;\n				}\n			}\n			return count;\n		},\n\n		isDatasetVisible: function(datasetIndex) {\n			var meta = this.getDatasetMeta(datasetIndex);\n\n			// meta.hidden is a per chart dataset hidden flag override with 3 states: if true or false,\n			// the dataset.hidden value is ignored, else if null, the dataset hidden state is returned.\n			return typeof meta.hidden === 'boolean' ? !meta.hidden : !this.data.datasets[datasetIndex].hidden;\n		},\n\n		generateLegend: function() {\n			return this.options.legendCallback(this);\n		},\n\n		/**\n		 * @private\n		 */\n		destroyDatasetMeta: function(datasetIndex) {\n			var id = this.id;\n			var dataset = this.data.datasets[datasetIndex];\n			var meta = dataset._meta && dataset._meta[id];\n\n			if (meta) {\n				meta.controller.destroy();\n				delete dataset._meta[id];\n			}\n		},\n\n		destroy: function() {\n			var me = this;\n			var canvas = me.canvas;\n			var i, ilen;\n\n			me.stop();\n\n			// dataset controllers need to cleanup associated data\n			for (i = 0, ilen = me.data.datasets.length; i < ilen; ++i) {\n				me.destroyDatasetMeta(i);\n			}\n\n			if (canvas) {\n				me.unbindEvents();\n				helpers.canvas.clear(me);\n				platform.releaseContext(me.ctx);\n				me.canvas = null;\n				me.ctx = null;\n			}\n\n			plugins.notify(me, 'destroy');\n\n			delete Chart.instances[me.id];\n		},\n\n		toBase64Image: function() {\n			return this.canvas.toDataURL.apply(this.canvas, arguments);\n		},\n\n		initToolTip: function() {\n			var me = this;\n			me.tooltip = new Chart.Tooltip({\n				_chart: me,\n				_chartInstance: me, // deprecated, backward compatibility\n				_data: me.data,\n				_options: me.options.tooltips\n			}, me);\n		},\n\n		/**\n		 * @private\n		 */\n		bindEvents: function() {\n			var me = this;\n			var listeners = me._listeners = {};\n			var listener = function() {\n				me.eventHandler.apply(me, arguments);\n			};\n\n			helpers.each(me.options.events, function(type) {\n				platform.addEventListener(me, type, listener);\n				listeners[type] = listener;\n			});\n\n			// Elements used to detect size change should not be injected for non responsive charts.\n			// See https://github.com/chartjs/Chart.js/issues/2210\n			if (me.options.responsive) {\n				listener = function() {\n					me.resize();\n				};\n\n				platform.addEventListener(me, 'resize', listener);\n				listeners.resize = listener;\n			}\n		},\n\n		/**\n		 * @private\n		 */\n		unbindEvents: function() {\n			var me = this;\n			var listeners = me._listeners;\n			if (!listeners) {\n				return;\n			}\n\n			delete me._listeners;\n			helpers.each(listeners, function(listener, type) {\n				platform.removeEventListener(me, type, listener);\n			});\n		},\n\n		updateHoverStyle: function(elements, mode, enabled) {\n			var method = enabled ? 'setHoverStyle' : 'removeHoverStyle';\n			var element, i, ilen;\n\n			for (i = 0, ilen = elements.length; i < ilen; ++i) {\n				element = elements[i];\n				if (element) {\n					this.getDatasetMeta(element._datasetIndex).controller[method](element);\n				}\n			}\n		},\n\n		/**\n		 * @private\n		 */\n		eventHandler: function(e) {\n			var me = this;\n			var tooltip = me.tooltip;\n\n			if (plugins.notify(me, 'beforeEvent', [e]) === false) {\n				return;\n			}\n\n			// Buffer any update calls so that renders do not occur\n			me._bufferedRender = true;\n			me._bufferedRequest = null;\n\n			var changed = me.handleEvent(e);\n			changed |= tooltip && tooltip.handleEvent(e);\n\n			plugins.notify(me, 'afterEvent', [e]);\n\n			var bufferedRequest = me._bufferedRequest;\n			if (bufferedRequest) {\n				// If we have an update that was triggered, we need to do a normal render\n				me.render(bufferedRequest);\n			} else if (changed && !me.animating) {\n				// If entering, leaving, or changing elements, animate the change via pivot\n				me.stop();\n\n				// We only need to render at this point. Updating will cause scales to be\n				// recomputed generating flicker & using more memory than necessary.\n				me.render(me.options.hover.animationDuration, true);\n			}\n\n			me._bufferedRender = false;\n			me._bufferedRequest = null;\n\n			return me;\n		},\n\n		/**\n		 * Handle an event\n		 * @private\n		 * @param {IEvent} event the event to handle\n		 * @return {Boolean} true if the chart needs to re-render\n		 */\n		handleEvent: function(e) {\n			var me = this;\n			var options = me.options || {};\n			var hoverOptions = options.hover;\n			var changed = false;\n\n			me.lastActive = me.lastActive || [];\n\n			// Find Active Elements for hover and tooltips\n			if (e.type === 'mouseout') {\n				me.active = [];\n			} else {\n				me.active = me.getElementsAtEventForMode(e, hoverOptions.mode, hoverOptions);\n			}\n\n			// Invoke onHover hook\n			// Need to call with native event here to not break backwards compatibility\n			helpers.callback(options.onHover || options.hover.onHover, [e.native, me.active], me);\n\n			if (e.type === 'mouseup' || e.type === 'click') {\n				if (options.onClick) {\n					// Use e.native here for backwards compatibility\n					options.onClick.call(me, e.native, me.active);\n				}\n			}\n\n			// Remove styling for last active (even if it may still be active)\n			if (me.lastActive.length) {\n				me.updateHoverStyle(me.lastActive, hoverOptions.mode, false);\n			}\n\n			// Built in hover styling\n			if (me.active.length && hoverOptions.mode) {\n				me.updateHoverStyle(me.active, hoverOptions.mode, true);\n			}\n\n			changed = !helpers.arrayEquals(me.active, me.lastActive);\n\n			// Remember Last Actives\n			me.lastActive = me.active;\n\n			return changed;\n		}\n	});\n\n	/**\n	 * Provided for backward compatibility, use Chart instead.\n	 * @class Chart.Controller\n	 * @deprecated since version 2.6.0\n	 * @todo remove at version 3\n	 * @private\n	 */\n	Chart.Controller = Chart;\n};\n\n},{\"25\":25,\"28\":28,\"45\":45,\"48\":48}],24:[function(require,module,exports){\n'use strict';\n\nvar helpers = require(45);\n\nmodule.exports = function(Chart) {\n\n	var arrayEvents = ['push', 'pop', 'shift', 'splice', 'unshift'];\n\n	/**\n	 * Hooks the array methods that add or remove values ('push', pop', 'shift', 'splice',\n	 * 'unshift') and notify the listener AFTER the array has been altered. Listeners are\n	 * called on the 'onData*' callbacks (e.g. onDataPush, etc.) with same arguments.\n	 */\n	function listenArrayEvents(array, listener) {\n		if (array._chartjs) {\n			array._chartjs.listeners.push(listener);\n			return;\n		}\n\n		Object.defineProperty(array, '_chartjs', {\n			configurable: true,\n			enumerable: false,\n			value: {\n				listeners: [listener]\n			}\n		});\n\n		arrayEvents.forEach(function(key) {\n			var method = 'onData' + key.charAt(0).toUpperCase() + key.slice(1);\n			var base = array[key];\n\n			Object.defineProperty(array, key, {\n				configurable: true,\n				enumerable: false,\n				value: function() {\n					var args = Array.prototype.slice.call(arguments);\n					var res = base.apply(this, args);\n\n					helpers.each(array._chartjs.listeners, function(object) {\n						if (typeof object[method] === 'function') {\n							object[method].apply(object, args);\n						}\n					});\n\n					return res;\n				}\n			});\n		});\n	}\n\n	/**\n	 * Removes the given array event listener and cleanup extra attached properties (such as\n	 * the _chartjs stub and overridden methods) if array doesn't have any more listeners.\n	 */\n	function unlistenArrayEvents(array, listener) {\n		var stub = array._chartjs;\n		if (!stub) {\n			return;\n		}\n\n		var listeners = stub.listeners;\n		var index = listeners.indexOf(listener);\n		if (index !== -1) {\n			listeners.splice(index, 1);\n		}\n\n		if (listeners.length > 0) {\n			return;\n		}\n\n		arrayEvents.forEach(function(key) {\n			delete array[key];\n		});\n\n		delete array._chartjs;\n	}\n\n	// Base class for all dataset controllers (line, bar, etc)\n	Chart.DatasetController = function(chart, datasetIndex) {\n		this.initialize(chart, datasetIndex);\n	};\n\n	helpers.extend(Chart.DatasetController.prototype, {\n\n		/**\n		 * Element type used to generate a meta dataset (e.g. Chart.element.Line).\n		 * @type {Chart.core.element}\n		 */\n		datasetElementType: null,\n\n		/**\n		 * Element type used to generate a meta data (e.g. Chart.element.Point).\n		 * @type {Chart.core.element}\n		 */\n		dataElementType: null,\n\n		initialize: function(chart, datasetIndex) {\n			var me = this;\n			me.chart = chart;\n			me.index = datasetIndex;\n			me.linkScales();\n			me.addElements();\n		},\n\n		updateIndex: function(datasetIndex) {\n			this.index = datasetIndex;\n		},\n\n		linkScales: function() {\n			var me = this;\n			var meta = me.getMeta();\n			var dataset = me.getDataset();\n\n			if (meta.xAxisID === null) {\n				meta.xAxisID = dataset.xAxisID || me.chart.options.scales.xAxes[0].id;\n			}\n			if (meta.yAxisID === null) {\n				meta.yAxisID = dataset.yAxisID || me.chart.options.scales.yAxes[0].id;\n			}\n		},\n\n		getDataset: function() {\n			return this.chart.data.datasets[this.index];\n		},\n\n		getMeta: function() {\n			return this.chart.getDatasetMeta(this.index);\n		},\n\n		getScaleForId: function(scaleID) {\n			return this.chart.scales[scaleID];\n		},\n\n		reset: function() {\n			this.update(true);\n		},\n\n		/**\n		 * @private\n		 */\n		destroy: function() {\n			if (this._data) {\n				unlistenArrayEvents(this._data, this);\n			}\n		},\n\n		createMetaDataset: function() {\n			var me = this;\n			var type = me.datasetElementType;\n			return type && new type({\n				_chart: me.chart,\n				_datasetIndex: me.index\n			});\n		},\n\n		createMetaData: function(index) {\n			var me = this;\n			var type = me.dataElementType;\n			return type && new type({\n				_chart: me.chart,\n				_datasetIndex: me.index,\n				_index: index\n			});\n		},\n\n		addElements: function() {\n			var me = this;\n			var meta = me.getMeta();\n			var data = me.getDataset().data || [];\n			var metaData = meta.data;\n			var i, ilen;\n\n			for (i = 0, ilen = data.length; i < ilen; ++i) {\n				metaData[i] = metaData[i] || me.createMetaData(i);\n			}\n\n			meta.dataset = meta.dataset || me.createMetaDataset();\n		},\n\n		addElementAndReset: function(index) {\n			var element = this.createMetaData(index);\n			this.getMeta().data.splice(index, 0, element);\n			this.updateElement(element, index, true);\n		},\n\n		buildOrUpdateElements: function() {\n			var me = this;\n			var dataset = me.getDataset();\n			var data = dataset.data || (dataset.data = []);\n\n			// In order to correctly handle data addition/deletion animation (an thus simulate\n			// real-time charts), we need to monitor these data modifications and synchronize\n			// the internal meta data accordingly.\n			if (me._data !== data) {\n				if (me._data) {\n					// This case happens when the user replaced the data array instance.\n					unlistenArrayEvents(me._data, me);\n				}\n\n				listenArrayEvents(data, me);\n				me._data = data;\n			}\n\n			// Re-sync meta data in case the user replaced the data array or if we missed\n			// any updates and so make sure that we handle number of datapoints changing.\n			me.resyncElements();\n		},\n\n		update: helpers.noop,\n\n		transition: function(easingValue) {\n			var meta = this.getMeta();\n			var elements = meta.data || [];\n			var ilen = elements.length;\n			var i = 0;\n\n			for (; i < ilen; ++i) {\n				elements[i].transition(easingValue);\n			}\n\n			if (meta.dataset) {\n				meta.dataset.transition(easingValue);\n			}\n		},\n\n		draw: function() {\n			var meta = this.getMeta();\n			var elements = meta.data || [];\n			var ilen = elements.length;\n			var i = 0;\n\n			if (meta.dataset) {\n				meta.dataset.draw();\n			}\n\n			for (; i < ilen; ++i) {\n				elements[i].draw();\n			}\n		},\n\n		removeHoverStyle: function(element, elementOpts) {\n			var dataset = this.chart.data.datasets[element._datasetIndex];\n			var index = element._index;\n			var custom = element.custom || {};\n			var valueOrDefault = helpers.valueAtIndexOrDefault;\n			var model = element._model;\n\n			model.backgroundColor = custom.backgroundColor ? custom.backgroundColor : valueOrDefault(dataset.backgroundColor, index, elementOpts.backgroundColor);\n			model.borderColor = custom.borderColor ? custom.borderColor : valueOrDefault(dataset.borderColor, index, elementOpts.borderColor);\n			model.borderWidth = custom.borderWidth ? custom.borderWidth : valueOrDefault(dataset.borderWidth, index, elementOpts.borderWidth);\n		},\n\n		setHoverStyle: function(element) {\n			var dataset = this.chart.data.datasets[element._datasetIndex];\n			var index = element._index;\n			var custom = element.custom || {};\n			var valueOrDefault = helpers.valueAtIndexOrDefault;\n			var getHoverColor = helpers.getHoverColor;\n			var model = element._model;\n\n			model.backgroundColor = custom.hoverBackgroundColor ? custom.hoverBackgroundColor : valueOrDefault(dataset.hoverBackgroundColor, index, getHoverColor(model.backgroundColor));\n			model.borderColor = custom.hoverBorderColor ? custom.hoverBorderColor : valueOrDefault(dataset.hoverBorderColor, index, getHoverColor(model.borderColor));\n			model.borderWidth = custom.hoverBorderWidth ? custom.hoverBorderWidth : valueOrDefault(dataset.hoverBorderWidth, index, model.borderWidth);\n		},\n\n		/**\n		 * @private\n		 */\n		resyncElements: function() {\n			var me = this;\n			var meta = me.getMeta();\n			var data = me.getDataset().data;\n			var numMeta = meta.data.length;\n			var numData = data.length;\n\n			if (numData < numMeta) {\n				meta.data.splice(numData, numMeta - numData);\n			} else if (numData > numMeta) {\n				me.insertElements(numMeta, numData - numMeta);\n			}\n		},\n\n		/**\n		 * @private\n		 */\n		insertElements: function(start, count) {\n			for (var i = 0; i < count; ++i) {\n				this.addElementAndReset(start + i);\n			}\n		},\n\n		/**\n		 * @private\n		 */\n		onDataPush: function() {\n			this.insertElements(this.getDataset().data.length - 1, arguments.length);\n		},\n\n		/**\n		 * @private\n		 */\n		onDataPop: function() {\n			this.getMeta().data.pop();\n		},\n\n		/**\n		 * @private\n		 */\n		onDataShift: function() {\n			this.getMeta().data.shift();\n		},\n\n		/**\n		 * @private\n		 */\n		onDataSplice: function(start, count) {\n			this.getMeta().data.splice(start, count);\n			this.insertElements(start, arguments.length - 2);\n		},\n\n		/**\n		 * @private\n		 */\n		onDataUnshift: function() {\n			this.insertElements(0, arguments.length);\n		}\n	});\n\n	Chart.DatasetController.extend = helpers.inherits;\n};\n\n},{\"45\":45}],25:[function(require,module,exports){\n'use strict';\n\nvar helpers = require(45);\n\nmodule.exports = {\n	/**\n	 * @private\n	 */\n	_set: function(scope, values) {\n		return helpers.merge(this[scope] || (this[scope] = {}), values);\n	}\n};\n\n},{\"45\":45}],26:[function(require,module,exports){\n'use strict';\n\nvar color = require(2);\nvar helpers = require(45);\n\nfunction interpolate(start, view, model, ease) {\n	var keys = Object.keys(model);\n	var i, ilen, key, actual, origin, target, type, c0, c1;\n\n	for (i = 0, ilen = keys.length; i < ilen; ++i) {\n		key = keys[i];\n\n		target = model[key];\n\n		// if a value is added to the model after pivot() has been called, the view\n		// doesn't contain it, so let's initialize the view to the target value.\n		if (!view.hasOwnProperty(key)) {\n			view[key] = target;\n		}\n\n		actual = view[key];\n\n		if (actual === target || key[0] === '_') {\n			continue;\n		}\n\n		if (!start.hasOwnProperty(key)) {\n			start[key] = actual;\n		}\n\n		origin = start[key];\n\n		type = typeof target;\n\n		if (type === typeof origin) {\n			if (type === 'string') {\n				c0 = color(origin);\n				if (c0.valid) {\n					c1 = color(target);\n					if (c1.valid) {\n						view[key] = c1.mix(c0, ease).rgbString();\n						continue;\n					}\n				}\n			} else if (type === 'number' && isFinite(origin) && isFinite(target)) {\n				view[key] = origin + (target - origin) * ease;\n				continue;\n			}\n		}\n\n		view[key] = target;\n	}\n}\n\nvar Element = function(configuration) {\n	helpers.extend(this, configuration);\n	this.initialize.apply(this, arguments);\n};\n\nhelpers.extend(Element.prototype, {\n\n	initialize: function() {\n		this.hidden = false;\n	},\n\n	pivot: function() {\n		var me = this;\n		if (!me._view) {\n			me._view = helpers.clone(me._model);\n		}\n		me._start = {};\n		return me;\n	},\n\n	transition: function(ease) {\n		var me = this;\n		var model = me._model;\n		var start = me._start;\n		var view = me._view;\n\n		// No animation -> No Transition\n		if (!model || ease === 1) {\n			me._view = model;\n			me._start = null;\n			return me;\n		}\n\n		if (!view) {\n			view = me._view = {};\n		}\n\n		if (!start) {\n			start = me._start = {};\n		}\n\n		interpolate(start, view, model, ease);\n\n		return me;\n	},\n\n	tooltipPosition: function() {\n		return {\n			x: this._model.x,\n			y: this._model.y\n		};\n	},\n\n	hasValue: function() {\n		return helpers.isNumber(this._model.x) && helpers.isNumber(this._model.y);\n	}\n});\n\nElement.extend = helpers.inherits;\n\nmodule.exports = Element;\n\n},{\"2\":2,\"45\":45}],27:[function(require,module,exports){\n/* global window: false */\n/* global document: false */\n'use strict';\n\nvar color = require(2);\nvar defaults = require(25);\nvar helpers = require(45);\n\nmodule.exports = function(Chart) {\n\n	// -- Basic js utility methods\n\n	helpers.configMerge = function(/* objects ... */) {\n		return helpers.merge(helpers.clone(arguments[0]), [].slice.call(arguments, 1), {\n			merger: function(key, target, source, options) {\n				var tval = target[key] || {};\n				var sval = source[key];\n\n				if (key === 'scales') {\n					// scale config merging is complex. Add our own function here for that\n					target[key] = helpers.scaleMerge(tval, sval);\n				} else if (key === 'scale') {\n					// used in polar area & radar charts since there is only one scale\n					target[key] = helpers.merge(tval, [Chart.scaleService.getScaleDefaults(sval.type), sval]);\n				} else {\n					helpers._merger(key, target, source, options);\n				}\n			}\n		});\n	};\n\n	helpers.scaleMerge = function(/* objects ... */) {\n		return helpers.merge(helpers.clone(arguments[0]), [].slice.call(arguments, 1), {\n			merger: function(key, target, source, options) {\n				if (key === 'xAxes' || key === 'yAxes') {\n					var slen = source[key].length;\n					var i, type, scale;\n\n					if (!target[key]) {\n						target[key] = [];\n					}\n\n					for (i = 0; i < slen; ++i) {\n						scale = source[key][i];\n						type = helpers.valueOrDefault(scale.type, key === 'xAxes' ? 'category' : 'linear');\n\n						if (i >= target[key].length) {\n							target[key].push({});\n						}\n\n						if (!target[key][i].type || (scale.type && scale.type !== target[key][i].type)) {\n							// new/untyped scale or type changed: let's apply the new defaults\n							// then merge source scale to correctly overwrite the defaults.\n							helpers.merge(target[key][i], [Chart.scaleService.getScaleDefaults(type), scale]);\n						} else {\n							// scales type are the same\n							helpers.merge(target[key][i], scale);\n						}\n					}\n				} else {\n					helpers._merger(key, target, source, options);\n				}\n			}\n		});\n	};\n\n	helpers.where = function(collection, filterCallback) {\n		if (helpers.isArray(collection) && Array.prototype.filter) {\n			return collection.filter(filterCallback);\n		}\n		var filtered = [];\n\n		helpers.each(collection, function(item) {\n			if (filterCallback(item)) {\n				filtered.push(item);\n			}\n		});\n\n		return filtered;\n	};\n	helpers.findIndex = Array.prototype.findIndex ?\n		function(array, callback, scope) {\n			return array.findIndex(callback, scope);\n		} :\n		function(array, callback, scope) {\n			scope = scope === undefined ? array : scope;\n			for (var i = 0, ilen = array.length; i < ilen; ++i) {\n				if (callback.call(scope, array[i], i, array)) {\n					return i;\n				}\n			}\n			return -1;\n		};\n	helpers.findNextWhere = function(arrayToSearch, filterCallback, startIndex) {\n		// Default to start of the array\n		if (helpers.isNullOrUndef(startIndex)) {\n			startIndex = -1;\n		}\n		for (var i = startIndex + 1; i < arrayToSearch.length; i++) {\n			var currentItem = arrayToSearch[i];\n			if (filterCallback(currentItem)) {\n				return currentItem;\n			}\n		}\n	};\n	helpers.findPreviousWhere = function(arrayToSearch, filterCallback, startIndex) {\n		// Default to end of the array\n		if (helpers.isNullOrUndef(startIndex)) {\n			startIndex = arrayToSearch.length;\n		}\n		for (var i = startIndex - 1; i >= 0; i--) {\n			var currentItem = arrayToSearch[i];\n			if (filterCallback(currentItem)) {\n				return currentItem;\n			}\n		}\n	};\n\n	// -- Math methods\n	helpers.isNumber = function(n) {\n		return !isNaN(parseFloat(n)) && isFinite(n);\n	};\n	helpers.almostEquals = function(x, y, epsilon) {\n		return Math.abs(x - y) < epsilon;\n	};\n	helpers.almostWhole = function(x, epsilon) {\n		var rounded = Math.round(x);\n		return (((rounded - epsilon) < x) && ((rounded + epsilon) > x));\n	};\n	helpers.max = function(array) {\n		return array.reduce(function(max, value) {\n			if (!isNaN(value)) {\n				return Math.max(max, value);\n			}\n			return max;\n		}, Number.NEGATIVE_INFINITY);\n	};\n	helpers.min = function(array) {\n		return array.reduce(function(min, value) {\n			if (!isNaN(value)) {\n				return Math.min(min, value);\n			}\n			return min;\n		}, Number.POSITIVE_INFINITY);\n	};\n	helpers.sign = Math.sign ?\n		function(x) {\n			return Math.sign(x);\n		} :\n		function(x) {\n			x = +x; // convert to a number\n			if (x === 0 || isNaN(x)) {\n				return x;\n			}\n			return x > 0 ? 1 : -1;\n		};\n	helpers.log10 = Math.log10 ?\n		function(x) {\n			return Math.log10(x);\n		} :\n		function(x) {\n			return Math.log(x) / Math.LN10;\n		};\n	helpers.toRadians = function(degrees) {\n		return degrees * (Math.PI / 180);\n	};\n	helpers.toDegrees = function(radians) {\n		return radians * (180 / Math.PI);\n	};\n	// Gets the angle from vertical upright to the point about a centre.\n	helpers.getAngleFromPoint = function(centrePoint, anglePoint) {\n		var distanceFromXCenter = anglePoint.x - centrePoint.x;\n		var distanceFromYCenter = anglePoint.y - centrePoint.y;\n		var radialDistanceFromCenter = Math.sqrt(distanceFromXCenter * distanceFromXCenter + distanceFromYCenter * distanceFromYCenter);\n\n		var angle = Math.atan2(distanceFromYCenter, distanceFromXCenter);\n\n		if (angle < (-0.5 * Math.PI)) {\n			angle += 2.0 * Math.PI; // make sure the returned angle is in the range of (-PI/2, 3PI/2]\n		}\n\n		return {\n			angle: angle,\n			distance: radialDistanceFromCenter\n		};\n	};\n	helpers.distanceBetweenPoints = function(pt1, pt2) {\n		return Math.sqrt(Math.pow(pt2.x - pt1.x, 2) + Math.pow(pt2.y - pt1.y, 2));\n	};\n	helpers.aliasPixel = function(pixelWidth) {\n		return (pixelWidth % 2 === 0) ? 0 : 0.5;\n	};\n	helpers.splineCurve = function(firstPoint, middlePoint, afterPoint, t) {\n		// Props to Rob Spencer at scaled innovation for his post on splining between points\n		// http://scaledinnovation.com/analytics/splines/aboutSplines.html\n\n		// This function must also respect \"skipped\" points\n\n		var previous = firstPoint.skip ? middlePoint : firstPoint;\n		var current = middlePoint;\n		var next = afterPoint.skip ? middlePoint : afterPoint;\n\n		var d01 = Math.sqrt(Math.pow(current.x - previous.x, 2) + Math.pow(current.y - previous.y, 2));\n		var d12 = Math.sqrt(Math.pow(next.x - current.x, 2) + Math.pow(next.y - current.y, 2));\n\n		var s01 = d01 / (d01 + d12);\n		var s12 = d12 / (d01 + d12);\n\n		// If all points are the same, s01 & s02 will be inf\n		s01 = isNaN(s01) ? 0 : s01;\n		s12 = isNaN(s12) ? 0 : s12;\n\n		var fa = t * s01; // scaling factor for triangle Ta\n		var fb = t * s12;\n\n		return {\n			previous: {\n				x: current.x - fa * (next.x - previous.x),\n				y: current.y - fa * (next.y - previous.y)\n			},\n			next: {\n				x: current.x + fb * (next.x - previous.x),\n				y: current.y + fb * (next.y - previous.y)\n			}\n		};\n	};\n	helpers.EPSILON = Number.EPSILON || 1e-14;\n	helpers.splineCurveMonotone = function(points) {\n		// This function calculates Bézier control points in a similar way than |splineCurve|,\n		// but preserves monotonicity of the provided data and ensures no local extremums are added\n		// between the dataset discrete points due to the interpolation.\n		// See : https://en.wikipedia.org/wiki/Monotone_cubic_interpolation\n\n		var pointsWithTangents = (points || []).map(function(point) {\n			return {\n				model: point._model,\n				deltaK: 0,\n				mK: 0\n			};\n		});\n\n		// Calculate slopes (deltaK) and initialize tangents (mK)\n		var pointsLen = pointsWithTangents.length;\n		var i, pointBefore, pointCurrent, pointAfter;\n		for (i = 0; i < pointsLen; ++i) {\n			pointCurrent = pointsWithTangents[i];\n			if (pointCurrent.model.skip) {\n				continue;\n			}\n\n			pointBefore = i > 0 ? pointsWithTangents[i - 1] : null;\n			pointAfter = i < pointsLen - 1 ? pointsWithTangents[i + 1] : null;\n			if (pointAfter && !pointAfter.model.skip) {\n				var slopeDeltaX = (pointAfter.model.x - pointCurrent.model.x);\n\n				// In the case of two points that appear at the same x pixel, slopeDeltaX is 0\n				pointCurrent.deltaK = slopeDeltaX !== 0 ? (pointAfter.model.y - pointCurrent.model.y) / slopeDeltaX : 0;\n			}\n\n			if (!pointBefore || pointBefore.model.skip) {\n				pointCurrent.mK = pointCurrent.deltaK;\n			} else if (!pointAfter || pointAfter.model.skip) {\n				pointCurrent.mK = pointBefore.deltaK;\n			} else if (this.sign(pointBefore.deltaK) !== this.sign(pointCurrent.deltaK)) {\n				pointCurrent.mK = 0;\n			} else {\n				pointCurrent.mK = (pointBefore.deltaK + pointCurrent.deltaK) / 2;\n			}\n		}\n\n		// Adjust tangents to ensure monotonic properties\n		var alphaK, betaK, tauK, squaredMagnitude;\n		for (i = 0; i < pointsLen - 1; ++i) {\n			pointCurrent = pointsWithTangents[i];\n			pointAfter = pointsWithTangents[i + 1];\n			if (pointCurrent.model.skip || pointAfter.model.skip) {\n				continue;\n			}\n\n			if (helpers.almostEquals(pointCurrent.deltaK, 0, this.EPSILON)) {\n				pointCurrent.mK = pointAfter.mK = 0;\n				continue;\n			}\n\n			alphaK = pointCurrent.mK / pointCurrent.deltaK;\n			betaK = pointAfter.mK / pointCurrent.deltaK;\n			squaredMagnitude = Math.pow(alphaK, 2) + Math.pow(betaK, 2);\n			if (squaredMagnitude <= 9) {\n				continue;\n			}\n\n			tauK = 3 / Math.sqrt(squaredMagnitude);\n			pointCurrent.mK = alphaK * tauK * pointCurrent.deltaK;\n			pointAfter.mK = betaK * tauK * pointCurrent.deltaK;\n		}\n\n		// Compute control points\n		var deltaX;\n		for (i = 0; i < pointsLen; ++i) {\n			pointCurrent = pointsWithTangents[i];\n			if (pointCurrent.model.skip) {\n				continue;\n			}\n\n			pointBefore = i > 0 ? pointsWithTangents[i - 1] : null;\n			pointAfter = i < pointsLen - 1 ? pointsWithTangents[i + 1] : null;\n			if (pointBefore && !pointBefore.model.skip) {\n				deltaX = (pointCurrent.model.x - pointBefore.model.x) / 3;\n				pointCurrent.model.controlPointPreviousX = pointCurrent.model.x - deltaX;\n				pointCurrent.model.controlPointPreviousY = pointCurrent.model.y - deltaX * pointCurrent.mK;\n			}\n			if (pointAfter && !pointAfter.model.skip) {\n				deltaX = (pointAfter.model.x - pointCurrent.model.x) / 3;\n				pointCurrent.model.controlPointNextX = pointCurrent.model.x + deltaX;\n				pointCurrent.model.controlPointNextY = pointCurrent.model.y + deltaX * pointCurrent.mK;\n			}\n		}\n	};\n	helpers.nextItem = function(collection, index, loop) {\n		if (loop) {\n			return index >= collection.length - 1 ? collection[0] : collection[index + 1];\n		}\n		return index >= collection.length - 1 ? collection[collection.length - 1] : collection[index + 1];\n	};\n	helpers.previousItem = function(collection, index, loop) {\n		if (loop) {\n			return index <= 0 ? collection[collection.length - 1] : collection[index - 1];\n		}\n		return index <= 0 ? collection[0] : collection[index - 1];\n	};\n	// Implementation of the nice number algorithm used in determining where axis labels will go\n	helpers.niceNum = function(range, round) {\n		var exponent = Math.floor(helpers.log10(range));\n		var fraction = range / Math.pow(10, exponent);\n		var niceFraction;\n\n		if (round) {\n			if (fraction < 1.5) {\n				niceFraction = 1;\n			} else if (fraction < 3) {\n				niceFraction = 2;\n			} else if (fraction < 7) {\n				niceFraction = 5;\n			} else {\n				niceFraction = 10;\n			}\n		} else if (fraction <= 1.0) {\n			niceFraction = 1;\n		} else if (fraction <= 2) {\n			niceFraction = 2;\n		} else if (fraction <= 5) {\n			niceFraction = 5;\n		} else {\n			niceFraction = 10;\n		}\n\n		return niceFraction * Math.pow(10, exponent);\n	};\n	// Request animation polyfill - http://www.paulirish.com/2011/requestanimationframe-for-smart-animating/\n	helpers.requestAnimFrame = (function() {\n		if (typeof window === 'undefined') {\n			return function(callback) {\n				callback();\n			};\n		}\n		return window.requestAnimationFrame ||\n			window.webkitRequestAnimationFrame ||\n			window.mozRequestAnimationFrame ||\n			window.oRequestAnimationFrame ||\n			window.msRequestAnimationFrame ||\n			function(callback) {\n				return window.setTimeout(callback, 1000 / 60);\n			};\n	}());\n	// -- DOM methods\n	helpers.getRelativePosition = function(evt, chart) {\n		var mouseX, mouseY;\n		var e = evt.originalEvent || evt;\n		var canvas = evt.currentTarget || evt.srcElement;\n		var boundingRect = canvas.getBoundingClientRect();\n\n		var touches = e.touches;\n		if (touches && touches.length > 0) {\n			mouseX = touches[0].clientX;\n			mouseY = touches[0].clientY;\n\n		} else {\n			mouseX = e.clientX;\n			mouseY = e.clientY;\n		}\n\n		// Scale mouse coordinates into canvas coordinates\n		// by following the pattern laid out by 'jerryj' in the comments of\n		// http://www.html5canvastutorials.com/advanced/html5-canvas-mouse-coordinates/\n		var paddingLeft = parseFloat(helpers.getStyle(canvas, 'padding-left'));\n		var paddingTop = parseFloat(helpers.getStyle(canvas, 'padding-top'));\n		var paddingRight = parseFloat(helpers.getStyle(canvas, 'padding-right'));\n		var paddingBottom = parseFloat(helpers.getStyle(canvas, 'padding-bottom'));\n		var width = boundingRect.right - boundingRect.left - paddingLeft - paddingRight;\n		var height = boundingRect.bottom - boundingRect.top - paddingTop - paddingBottom;\n\n		// We divide by the current device pixel ratio, because the canvas is scaled up by that amount in each direction. However\n		// the backend model is in unscaled coordinates. Since we are going to deal with our model coordinates, we go back here\n		mouseX = Math.round((mouseX - boundingRect.left - paddingLeft) / (width) * canvas.width / chart.currentDevicePixelRatio);\n		mouseY = Math.round((mouseY - boundingRect.top - paddingTop) / (height) * canvas.height / chart.currentDevicePixelRatio);\n\n		return {\n			x: mouseX,\n			y: mouseY\n		};\n\n	};\n\n	// Private helper function to convert max-width/max-height values that may be percentages into a number\n	function parseMaxStyle(styleValue, node, parentProperty) {\n		var valueInPixels;\n		if (typeof styleValue === 'string') {\n			valueInPixels = parseInt(styleValue, 10);\n\n			if (styleValue.indexOf('%') !== -1) {\n				// percentage * size in dimension\n				valueInPixels = valueInPixels / 100 * node.parentNode[parentProperty];\n			}\n		} else {\n			valueInPixels = styleValue;\n		}\n\n		return valueInPixels;\n	}\n\n	/**\n	 * Returns if the given value contains an effective constraint.\n	 * @private\n	 */\n	function isConstrainedValue(value) {\n		return value !== undefined && value !== null && value !== 'none';\n	}\n\n	// Private helper to get a constraint dimension\n	// @param domNode : the node to check the constraint on\n	// @param maxStyle : the style that defines the maximum for the direction we are using (maxWidth / maxHeight)\n	// @param percentageProperty : property of parent to use when calculating width as a percentage\n	// @see http://www.nathanaeljones.com/blog/2013/reading-max-width-cross-browser\n	function getConstraintDimension(domNode, maxStyle, percentageProperty) {\n		var view = document.defaultView;\n		var parentNode = domNode.parentNode;\n		var constrainedNode = view.getComputedStyle(domNode)[maxStyle];\n		var constrainedContainer = view.getComputedStyle(parentNode)[maxStyle];\n		var hasCNode = isConstrainedValue(constrainedNode);\n		var hasCContainer = isConstrainedValue(constrainedContainer);\n		var infinity = Number.POSITIVE_INFINITY;\n\n		if (hasCNode || hasCContainer) {\n			return Math.min(\n				hasCNode ? parseMaxStyle(constrainedNode, domNode, percentageProperty) : infinity,\n				hasCContainer ? parseMaxStyle(constrainedContainer, parentNode, percentageProperty) : infinity);\n		}\n\n		return 'none';\n	}\n	// returns Number or undefined if no constraint\n	helpers.getConstraintWidth = function(domNode) {\n		return getConstraintDimension(domNode, 'max-width', 'clientWidth');\n	};\n	// returns Number or undefined if no constraint\n	helpers.getConstraintHeight = function(domNode) {\n		return getConstraintDimension(domNode, 'max-height', 'clientHeight');\n	};\n	helpers.getMaximumWidth = function(domNode) {\n		var container = domNode.parentNode;\n		if (!container) {\n			return domNode.clientWidth;\n		}\n\n		var paddingLeft = parseInt(helpers.getStyle(container, 'padding-left'), 10);\n		var paddingRight = parseInt(helpers.getStyle(container, 'padding-right'), 10);\n		var w = container.clientWidth - paddingLeft - paddingRight;\n		var cw = helpers.getConstraintWidth(domNode);\n		return isNaN(cw) ? w : Math.min(w, cw);\n	};\n	helpers.getMaximumHeight = function(domNode) {\n		var container = domNode.parentNode;\n		if (!container) {\n			return domNode.clientHeight;\n		}\n\n		var paddingTop = parseInt(helpers.getStyle(container, 'padding-top'), 10);\n		var paddingBottom = parseInt(helpers.getStyle(container, 'padding-bottom'), 10);\n		var h = container.clientHeight - paddingTop - paddingBottom;\n		var ch = helpers.getConstraintHeight(domNode);\n		return isNaN(ch) ? h : Math.min(h, ch);\n	};\n	helpers.getStyle = function(el, property) {\n		return el.currentStyle ?\n			el.currentStyle[property] :\n			document.defaultView.getComputedStyle(el, null).getPropertyValue(property);\n	};\n	helpers.retinaScale = function(chart, forceRatio) {\n		var pixelRatio = chart.currentDevicePixelRatio = forceRatio || window.devicePixelRatio || 1;\n		if (pixelRatio === 1) {\n			return;\n		}\n\n		var canvas = chart.canvas;\n		var height = chart.height;\n		var width = chart.width;\n\n		canvas.height = height * pixelRatio;\n		canvas.width = width * pixelRatio;\n		chart.ctx.scale(pixelRatio, pixelRatio);\n\n		// If no style has been set on the canvas, the render size is used as display size,\n		// making the chart visually bigger, so let's enforce it to the \"correct\" values.\n		// See https://github.com/chartjs/Chart.js/issues/3575\n		canvas.style.height = height + 'px';\n		canvas.style.width = width + 'px';\n	};\n	// -- Canvas methods\n	helpers.fontString = function(pixelSize, fontStyle, fontFamily) {\n		return fontStyle + ' ' + pixelSize + 'px ' + fontFamily;\n	};\n	helpers.longestText = function(ctx, font, arrayOfThings, cache) {\n		cache = cache || {};\n		var data = cache.data = cache.data || {};\n		var gc = cache.garbageCollect = cache.garbageCollect || [];\n\n		if (cache.font !== font) {\n			data = cache.data = {};\n			gc = cache.garbageCollect = [];\n			cache.font = font;\n		}\n\n		ctx.font = font;\n		var longest = 0;\n		helpers.each(arrayOfThings, function(thing) {\n			// Undefined strings and arrays should not be measured\n			if (thing !== undefined && thing !== null && helpers.isArray(thing) !== true) {\n				longest = helpers.measureText(ctx, data, gc, longest, thing);\n			} else if (helpers.isArray(thing)) {\n				// if it is an array lets measure each element\n				// to do maybe simplify this function a bit so we can do this more recursively?\n				helpers.each(thing, function(nestedThing) {\n					// Undefined strings and arrays should not be measured\n					if (nestedThing !== undefined && nestedThing !== null && !helpers.isArray(nestedThing)) {\n						longest = helpers.measureText(ctx, data, gc, longest, nestedThing);\n					}\n				});\n			}\n		});\n\n		var gcLen = gc.length / 2;\n		if (gcLen > arrayOfThings.length) {\n			for (var i = 0; i < gcLen; i++) {\n				delete data[gc[i]];\n			}\n			gc.splice(0, gcLen);\n		}\n		return longest;\n	};\n	helpers.measureText = function(ctx, data, gc, longest, string) {\n		var textWidth = data[string];\n		if (!textWidth) {\n			textWidth = data[string] = ctx.measureText(string).width;\n			gc.push(string);\n		}\n		if (textWidth > longest) {\n			longest = textWidth;\n		}\n		return longest;\n	};\n	helpers.numberOfLabelLines = function(arrayOfThings) {\n		var numberOfLines = 1;\n		helpers.each(arrayOfThings, function(thing) {\n			if (helpers.isArray(thing)) {\n				if (thing.length > numberOfLines) {\n					numberOfLines = thing.length;\n				}\n			}\n		});\n		return numberOfLines;\n	};\n\n	helpers.color = !color ?\n		function(value) {\n			console.error('Color.js not found!');\n			return value;\n		} :\n		function(value) {\n			/* global CanvasGradient */\n			if (value instanceof CanvasGradient) {\n				value = defaults.global.defaultColor;\n			}\n\n			return color(value);\n		};\n\n	helpers.getHoverColor = function(colorValue) {\n		/* global CanvasPattern */\n		return (colorValue instanceof CanvasPattern) ?\n			colorValue :\n			helpers.color(colorValue).saturate(0.5).darken(0.1).rgbString();\n	};\n};\n\n},{\"2\":2,\"25\":25,\"45\":45}],28:[function(require,module,exports){\n'use strict';\n\nvar helpers = require(45);\n\n/**\n * Helper function to get relative position for an event\n * @param {Event|IEvent} event - The event to get the position for\n * @param {Chart} chart - The chart\n * @returns {Point} the event position\n */\nfunction getRelativePosition(e, chart) {\n	if (e.native) {\n		return {\n			x: e.x,\n			y: e.y\n		};\n	}\n\n	return helpers.getRelativePosition(e, chart);\n}\n\n/**\n * Helper function to traverse all of the visible elements in the chart\n * @param chart {chart} the chart\n * @param handler {Function} the callback to execute for each visible item\n */\nfunction parseVisibleItems(chart, handler) {\n	var datasets = chart.data.datasets;\n	var meta, i, j, ilen, jlen;\n\n	for (i = 0, ilen = datasets.length; i < ilen; ++i) {\n		if (!chart.isDatasetVisible(i)) {\n			continue;\n		}\n\n		meta = chart.getDatasetMeta(i);\n		for (j = 0, jlen = meta.data.length; j < jlen; ++j) {\n			var element = meta.data[j];\n			if (!element._view.skip) {\n				handler(element);\n			}\n		}\n	}\n}\n\n/**\n * Helper function to get the items that intersect the event position\n * @param items {ChartElement[]} elements to filter\n * @param position {Point} the point to be nearest to\n * @return {ChartElement[]} the nearest items\n */\nfunction getIntersectItems(chart, position) {\n	var elements = [];\n\n	parseVisibleItems(chart, function(element) {\n		if (element.inRange(position.x, position.y)) {\n			elements.push(element);\n		}\n	});\n\n	return elements;\n}\n\n/**\n * Helper function to get the items nearest to the event position considering all visible items in teh chart\n * @param chart {Chart} the chart to look at elements from\n * @param position {Point} the point to be nearest to\n * @param intersect {Boolean} if true, only consider items that intersect the position\n * @param distanceMetric {Function} function to provide the distance between points\n * @return {ChartElement[]} the nearest items\n */\nfunction getNearestItems(chart, position, intersect, distanceMetric) {\n	var minDistance = Number.POSITIVE_INFINITY;\n	var nearestItems = [];\n\n	parseVisibleItems(chart, function(element) {\n		if (intersect && !element.inRange(position.x, position.y)) {\n			return;\n		}\n\n		var center = element.getCenterPoint();\n		var distance = distanceMetric(position, center);\n\n		if (distance < minDistance) {\n			nearestItems = [element];\n			minDistance = distance;\n		} else if (distance === minDistance) {\n			// Can have multiple items at the same distance in which case we sort by size\n			nearestItems.push(element);\n		}\n	});\n\n	return nearestItems;\n}\n\n/**\n * Get a distance metric function for two points based on the\n * axis mode setting\n * @param {String} axis the axis mode. x|y|xy\n */\nfunction getDistanceMetricForAxis(axis) {\n	var useX = axis.indexOf('x') !== -1;\n	var useY = axis.indexOf('y') !== -1;\n\n	return function(pt1, pt2) {\n		var deltaX = useX ? Math.abs(pt1.x - pt2.x) : 0;\n		var deltaY = useY ? Math.abs(pt1.y - pt2.y) : 0;\n		return Math.sqrt(Math.pow(deltaX, 2) + Math.pow(deltaY, 2));\n	};\n}\n\nfunction indexMode(chart, e, options) {\n	var position = getRelativePosition(e, chart);\n	// Default axis for index mode is 'x' to match old behaviour\n	options.axis = options.axis || 'x';\n	var distanceMetric = getDistanceMetricForAxis(options.axis);\n	var items = options.intersect ? getIntersectItems(chart, position) : getNearestItems(chart, position, false, distanceMetric);\n	var elements = [];\n\n	if (!items.length) {\n		return [];\n	}\n\n	chart.data.datasets.forEach(function(dataset, datasetIndex) {\n		if (chart.isDatasetVisible(datasetIndex)) {\n			var meta = chart.getDatasetMeta(datasetIndex);\n			var element = meta.data[items[0]._index];\n\n			// don't count items that are skipped (null data)\n			if (element && !element._view.skip) {\n				elements.push(element);\n			}\n		}\n	});\n\n	return elements;\n}\n\n/**\n * @interface IInteractionOptions\n */\n/**\n * If true, only consider items that intersect the point\n * @name IInterfaceOptions#boolean\n * @type Boolean\n */\n\n/**\n * Contains interaction related functions\n * @namespace Chart.Interaction\n */\nmodule.exports = {\n	// Helper function for different modes\n	modes: {\n		single: function(chart, e) {\n			var position = getRelativePosition(e, chart);\n			var elements = [];\n\n			parseVisibleItems(chart, function(element) {\n				if (element.inRange(position.x, position.y)) {\n					elements.push(element);\n					return elements;\n				}\n			});\n\n			return elements.slice(0, 1);\n		},\n\n		/**\n		 * @function Chart.Interaction.modes.label\n		 * @deprecated since version 2.4.0\n		 * @todo remove at version 3\n		 * @private\n		 */\n		label: indexMode,\n\n		/**\n		 * Returns items at the same index. If the options.intersect parameter is true, we only return items if we intersect something\n		 * If the options.intersect mode is false, we find the nearest item and return the items at the same index as that item\n		 * @function Chart.Interaction.modes.index\n		 * @since v2.4.0\n		 * @param chart {chart} the chart we are returning items from\n		 * @param e {Event} the event we are find things at\n		 * @param options {IInteractionOptions} options to use during interaction\n		 * @return {Chart.Element[]} Array of elements that are under the point. If none are found, an empty array is returned\n		 */\n		index: indexMode,\n\n		/**\n		 * Returns items in the same dataset. If the options.intersect parameter is true, we only return items if we intersect something\n		 * If the options.intersect is false, we find the nearest item and return the items in that dataset\n		 * @function Chart.Interaction.modes.dataset\n		 * @param chart {chart} the chart we are returning items from\n		 * @param e {Event} the event we are find things at\n		 * @param options {IInteractionOptions} options to use during interaction\n		 * @return {Chart.Element[]} Array of elements that are under the point. If none are found, an empty array is returned\n		 */\n		dataset: function(chart, e, options) {\n			var position = getRelativePosition(e, chart);\n			options.axis = options.axis || 'xy';\n			var distanceMetric = getDistanceMetricForAxis(options.axis);\n			var items = options.intersect ? getIntersectItems(chart, position) : getNearestItems(chart, position, false, distanceMetric);\n\n			if (items.length > 0) {\n				items = chart.getDatasetMeta(items[0]._datasetIndex).data;\n			}\n\n			return items;\n		},\n\n		/**\n		 * @function Chart.Interaction.modes.x-axis\n		 * @deprecated since version 2.4.0. Use index mode and intersect == true\n		 * @todo remove at version 3\n		 * @private\n		 */\n		'x-axis': function(chart, e) {\n			return indexMode(chart, e, {intersect: false});\n		},\n\n		/**\n		 * Point mode returns all elements that hit test based on the event position\n		 * of the event\n		 * @function Chart.Interaction.modes.intersect\n		 * @param chart {chart} the chart we are returning items from\n		 * @param e {Event} the event we are find things at\n		 * @return {Chart.Element[]} Array of elements that are under the point. If none are found, an empty array is returned\n		 */\n		point: function(chart, e) {\n			var position = getRelativePosition(e, chart);\n			return getIntersectItems(chart, position);\n		},\n\n		/**\n		 * nearest mode returns the element closest to the point\n		 * @function Chart.Interaction.modes.intersect\n		 * @param chart {chart} the chart we are returning items from\n		 * @param e {Event} the event we are find things at\n		 * @param options {IInteractionOptions} options to use\n		 * @return {Chart.Element[]} Array of elements that are under the point. If none are found, an empty array is returned\n		 */\n		nearest: function(chart, e, options) {\n			var position = getRelativePosition(e, chart);\n			options.axis = options.axis || 'xy';\n			var distanceMetric = getDistanceMetricForAxis(options.axis);\n			var nearestItems = getNearestItems(chart, position, options.intersect, distanceMetric);\n\n			// We have multiple items at the same distance from the event. Now sort by smallest\n			if (nearestItems.length > 1) {\n				nearestItems.sort(function(a, b) {\n					var sizeA = a.getArea();\n					var sizeB = b.getArea();\n					var ret = sizeA - sizeB;\n\n					if (ret === 0) {\n						// if equal sort by dataset index\n						ret = a._datasetIndex - b._datasetIndex;\n					}\n\n					return ret;\n				});\n			}\n\n			// Return only 1 item\n			return nearestItems.slice(0, 1);\n		},\n\n		/**\n		 * x mode returns the elements that hit-test at the current x coordinate\n		 * @function Chart.Interaction.modes.x\n		 * @param chart {chart} the chart we are returning items from\n		 * @param e {Event} the event we are find things at\n		 * @param options {IInteractionOptions} options to use\n		 * @return {Chart.Element[]} Array of elements that are under the point. If none are found, an empty array is returned\n		 */\n		x: function(chart, e, options) {\n			var position = getRelativePosition(e, chart);\n			var items = [];\n			var intersectsItem = false;\n\n			parseVisibleItems(chart, function(element) {\n				if (element.inXRange(position.x)) {\n					items.push(element);\n				}\n\n				if (element.inRange(position.x, position.y)) {\n					intersectsItem = true;\n				}\n			});\n\n			// If we want to trigger on an intersect and we don't have any items\n			// that intersect the position, return nothing\n			if (options.intersect && !intersectsItem) {\n				items = [];\n			}\n			return items;\n		},\n\n		/**\n		 * y mode returns the elements that hit-test at the current y coordinate\n		 * @function Chart.Interaction.modes.y\n		 * @param chart {chart} the chart we are returning items from\n		 * @param e {Event} the event we are find things at\n		 * @param options {IInteractionOptions} options to use\n		 * @return {Chart.Element[]} Array of elements that are under the point. If none are found, an empty array is returned\n		 */\n		y: function(chart, e, options) {\n			var position = getRelativePosition(e, chart);\n			var items = [];\n			var intersectsItem = false;\n\n			parseVisibleItems(chart, function(element) {\n				if (element.inYRange(position.y)) {\n					items.push(element);\n				}\n\n				if (element.inRange(position.x, position.y)) {\n					intersectsItem = true;\n				}\n			});\n\n			// If we want to trigger on an intersect and we don't have any items\n			// that intersect the position, return nothing\n			if (options.intersect && !intersectsItem) {\n				items = [];\n			}\n			return items;\n		}\n	}\n};\n\n},{\"45\":45}],29:[function(require,module,exports){\n'use strict';\n\nvar defaults = require(25);\n\ndefaults._set('global', {\n	responsive: true,\n	responsiveAnimationDuration: 0,\n	maintainAspectRatio: true,\n	events: ['mousemove', 'mouseout', 'click', 'touchstart', 'touchmove'],\n	hover: {\n		onHover: null,\n		mode: 'nearest',\n		intersect: true,\n		animationDuration: 400\n	},\n	onClick: null,\n	defaultColor: 'rgba(0,0,0,0.1)',\n	defaultFontColor: '#666',\n	defaultFontFamily: \"'Helvetica Neue', 'Helvetica', 'Arial', sans-serif\",\n	defaultFontSize: 12,\n	defaultFontStyle: 'normal',\n	showLines: true,\n\n	// Element defaults defined in element extensions\n	elements: {},\n\n	// Layout options such as padding\n	layout: {\n		padding: {\n			top: 0,\n			right: 0,\n			bottom: 0,\n			left: 0\n		}\n	}\n});\n\nmodule.exports = function() {\n\n	// Occupy the global variable of Chart, and create a simple base class\n	var Chart = function(item, config) {\n		this.construct(item, config);\n		return this;\n	};\n\n	Chart.Chart = Chart;\n\n	return Chart;\n};\n\n},{\"25\":25}],30:[function(require,module,exports){\n'use strict';\n\nvar helpers = require(45);\n\nmodule.exports = function(Chart) {\n\n	function filterByPosition(array, position) {\n		return helpers.where(array, function(v) {\n			return v.position === position;\n		});\n	}\n\n	function sortByWeight(array, reverse) {\n		array.forEach(function(v, i) {\n			v._tmpIndex_ = i;\n			return v;\n		});\n		array.sort(function(a, b) {\n			var v0 = reverse ? b : a;\n			var v1 = reverse ? a : b;\n			return v0.weight === v1.weight ?\n				v0._tmpIndex_ - v1._tmpIndex_ :\n				v0.weight - v1.weight;\n		});\n		array.forEach(function(v) {\n			delete v._tmpIndex_;\n		});\n	}\n\n	/**\n	 * @interface ILayoutItem\n	 * @prop {String} position - The position of the item in the chart layout. Possible values are\n	 * 'left', 'top', 'right', 'bottom', and 'chartArea'\n	 * @prop {Number} weight - The weight used to sort the item. Higher weights are further away from the chart area\n	 * @prop {Boolean} fullWidth - if true, and the item is horizontal, then push vertical boxes down\n	 * @prop {Function} isHorizontal - returns true if the layout item is horizontal (ie. top or bottom)\n	 * @prop {Function} update - Takes two parameters: width and height. Returns size of item\n	 * @prop {Function} getPadding -  Returns an object with padding on the edges\n	 * @prop {Number} width - Width of item. Must be valid after update()\n	 * @prop {Number} height - Height of item. Must be valid after update()\n	 * @prop {Number} left - Left edge of the item. Set by layout system and cannot be used in update\n	 * @prop {Number} top - Top edge of the item. Set by layout system and cannot be used in update\n	 * @prop {Number} right - Right edge of the item. Set by layout system and cannot be used in update\n	 * @prop {Number} bottom - Bottom edge of the item. Set by layout system and cannot be used in update\n	 */\n\n	// The layout service is very self explanatory.  It's responsible for the layout within a chart.\n	// Scales, Legends and Plugins all rely on the layout service and can easily register to be placed anywhere they need\n	// It is this service's responsibility of carrying out that layout.\n	Chart.layoutService = {\n		defaults: {},\n\n		/**\n		 * Register a box to a chart.\n		 * A box is simply a reference to an object that requires layout. eg. Scales, Legend, Title.\n		 * @param {Chart} chart - the chart to use\n		 * @param {ILayoutItem} item - the item to add to be layed out\n		 */\n		addBox: function(chart, item) {\n			if (!chart.boxes) {\n				chart.boxes = [];\n			}\n\n			// initialize item with default values\n			item.fullWidth = item.fullWidth || false;\n			item.position = item.position || 'top';\n			item.weight = item.weight || 0;\n\n			chart.boxes.push(item);\n		},\n\n		/**\n		 * Remove a layoutItem from a chart\n		 * @param {Chart} chart - the chart to remove the box from\n		 * @param {Object} layoutItem - the item to remove from the layout\n		 */\n		removeBox: function(chart, layoutItem) {\n			var index = chart.boxes ? chart.boxes.indexOf(layoutItem) : -1;\n			if (index !== -1) {\n				chart.boxes.splice(index, 1);\n			}\n		},\n\n		/**\n		 * Sets (or updates) options on the given `item`.\n		 * @param {Chart} chart - the chart in which the item lives (or will be added to)\n		 * @param {Object} item - the item to configure with the given options\n		 * @param {Object} options - the new item options.\n		 */\n		configure: function(chart, item, options) {\n			var props = ['fullWidth', 'position', 'weight'];\n			var ilen = props.length;\n			var i = 0;\n			var prop;\n\n			for (; i < ilen; ++i) {\n				prop = props[i];\n				if (options.hasOwnProperty(prop)) {\n					item[prop] = options[prop];\n				}\n			}\n		},\n\n		/**\n		 * Fits boxes of the given chart into the given size by having each box measure itself\n		 * then running a fitting algorithm\n		 * @param {Chart} chart - the chart\n		 * @param {Number} width - the width to fit into\n		 * @param {Number} height - the height to fit into\n		 */\n		update: function(chart, width, height) {\n			if (!chart) {\n				return;\n			}\n\n			var layoutOptions = chart.options.layout || {};\n			var padding = helpers.options.toPadding(layoutOptions.padding);\n			var leftPadding = padding.left;\n			var rightPadding = padding.right;\n			var topPadding = padding.top;\n			var bottomPadding = padding.bottom;\n\n			var leftBoxes = filterByPosition(chart.boxes, 'left');\n			var rightBoxes = filterByPosition(chart.boxes, 'right');\n			var topBoxes = filterByPosition(chart.boxes, 'top');\n			var bottomBoxes = filterByPosition(chart.boxes, 'bottom');\n			var chartAreaBoxes = filterByPosition(chart.boxes, 'chartArea');\n\n			// Sort boxes by weight. A higher weight is further away from the chart area\n			sortByWeight(leftBoxes, true);\n			sortByWeight(rightBoxes, false);\n			sortByWeight(topBoxes, true);\n			sortByWeight(bottomBoxes, false);\n\n			// Essentially we now have any number of boxes on each of the 4 sides.\n			// Our canvas looks like the following.\n			// The areas L1 and L2 are the left axes. R1 is the right axis, T1 is the top axis and\n			// B1 is the bottom axis\n			// There are also 4 quadrant-like locations (left to right instead of clockwise) reserved for chart overlays\n			// These locations are single-box locations only, when trying to register a chartArea location that is already taken,\n			// an error will be thrown.\n			//\n			// |----------------------------------------------------|\n			// |                  T1 (Full Width)                   |\n			// |----------------------------------------------------|\n			// |    |    |                 T2                  |    |\n			// |    |----|-------------------------------------|----|\n			// |    |    | C1 |                           | C2 |    |\n			// |    |    |----|                           |----|    |\n			// |    |    |                                     |    |\n			// | L1 | L2 |           ChartArea (C0)            | R1 |\n			// |    |    |                                     |    |\n			// |    |    |----|                           |----|    |\n			// |    |    | C3 |                           | C4 |    |\n			// |    |----|-------------------------------------|----|\n			// |    |    |                 B1                  |    |\n			// |----------------------------------------------------|\n			// |                  B2 (Full Width)                   |\n			// |----------------------------------------------------|\n			//\n			// What we do to find the best sizing, we do the following\n			// 1. Determine the minimum size of the chart area.\n			// 2. Split the remaining width equally between each vertical axis\n			// 3. Split the remaining height equally between each horizontal axis\n			// 4. Give each layout the maximum size it can be. The layout will return it's minimum size\n			// 5. Adjust the sizes of each axis based on it's minimum reported size.\n			// 6. Refit each axis\n			// 7. Position each axis in the final location\n			// 8. Tell the chart the final location of the chart area\n			// 9. Tell any axes that overlay the chart area the positions of the chart area\n\n			// Step 1\n			var chartWidth = width - leftPadding - rightPadding;\n			var chartHeight = height - topPadding - bottomPadding;\n			var chartAreaWidth = chartWidth / 2; // min 50%\n			var chartAreaHeight = chartHeight / 2; // min 50%\n\n			// Step 2\n			var verticalBoxWidth = (width - chartAreaWidth) / (leftBoxes.length + rightBoxes.length);\n\n			// Step 3\n			var horizontalBoxHeight = (height - chartAreaHeight) / (topBoxes.length + bottomBoxes.length);\n\n			// Step 4\n			var maxChartAreaWidth = chartWidth;\n			var maxChartAreaHeight = chartHeight;\n			var minBoxSizes = [];\n\n			function getMinimumBoxSize(box) {\n				var minSize;\n				var isHorizontal = box.isHorizontal();\n\n				if (isHorizontal) {\n					minSize = box.update(box.fullWidth ? chartWidth : maxChartAreaWidth, horizontalBoxHeight);\n					maxChartAreaHeight -= minSize.height;\n				} else {\n					minSize = box.update(verticalBoxWidth, chartAreaHeight);\n					maxChartAreaWidth -= minSize.width;\n				}\n\n				minBoxSizes.push({\n					horizontal: isHorizontal,\n					minSize: minSize,\n					box: box,\n				});\n			}\n\n			helpers.each(leftBoxes.concat(rightBoxes, topBoxes, bottomBoxes), getMinimumBoxSize);\n\n			// If a horizontal box has padding, we move the left boxes over to avoid ugly charts (see issue #2478)\n			var maxHorizontalLeftPadding = 0;\n			var maxHorizontalRightPadding = 0;\n			var maxVerticalTopPadding = 0;\n			var maxVerticalBottomPadding = 0;\n\n			helpers.each(topBoxes.concat(bottomBoxes), function(horizontalBox) {\n				if (horizontalBox.getPadding) {\n					var boxPadding = horizontalBox.getPadding();\n					maxHorizontalLeftPadding = Math.max(maxHorizontalLeftPadding, boxPadding.left);\n					maxHorizontalRightPadding = Math.max(maxHorizontalRightPadding, boxPadding.right);\n				}\n			});\n\n			helpers.each(leftBoxes.concat(rightBoxes), function(verticalBox) {\n				if (verticalBox.getPadding) {\n					var boxPadding = verticalBox.getPadding();\n					maxVerticalTopPadding = Math.max(maxVerticalTopPadding, boxPadding.top);\n					maxVerticalBottomPadding = Math.max(maxVerticalBottomPadding, boxPadding.bottom);\n				}\n			});\n\n			// At this point, maxChartAreaHeight and maxChartAreaWidth are the size the chart area could\n			// be if the axes are drawn at their minimum sizes.\n			// Steps 5 & 6\n			var totalLeftBoxesWidth = leftPadding;\n			var totalRightBoxesWidth = rightPadding;\n			var totalTopBoxesHeight = topPadding;\n			var totalBottomBoxesHeight = bottomPadding;\n\n			// Function to fit a box\n			function fitBox(box) {\n				var minBoxSize = helpers.findNextWhere(minBoxSizes, function(minBox) {\n					return minBox.box === box;\n				});\n\n				if (minBoxSize) {\n					if (box.isHorizontal()) {\n						var scaleMargin = {\n							left: Math.max(totalLeftBoxesWidth, maxHorizontalLeftPadding),\n							right: Math.max(totalRightBoxesWidth, maxHorizontalRightPadding),\n							top: 0,\n							bottom: 0\n						};\n\n						// Don't use min size here because of label rotation. When the labels are rotated, their rotation highly depends\n						// on the margin. Sometimes they need to increase in size slightly\n						box.update(box.fullWidth ? chartWidth : maxChartAreaWidth, chartHeight / 2, scaleMargin);\n					} else {\n						box.update(minBoxSize.minSize.width, maxChartAreaHeight);\n					}\n				}\n			}\n\n			// Update, and calculate the left and right margins for the horizontal boxes\n			helpers.each(leftBoxes.concat(rightBoxes), fitBox);\n\n			helpers.each(leftBoxes, function(box) {\n				totalLeftBoxesWidth += box.width;\n			});\n\n			helpers.each(rightBoxes, function(box) {\n				totalRightBoxesWidth += box.width;\n			});\n\n			// Set the Left and Right margins for the horizontal boxes\n			helpers.each(topBoxes.concat(bottomBoxes), fitBox);\n\n			// Figure out how much margin is on the top and bottom of the vertical boxes\n			helpers.each(topBoxes, function(box) {\n				totalTopBoxesHeight += box.height;\n			});\n\n			helpers.each(bottomBoxes, function(box) {\n				totalBottomBoxesHeight += box.height;\n			});\n\n			function finalFitVerticalBox(box) {\n				var minBoxSize = helpers.findNextWhere(minBoxSizes, function(minSize) {\n					return minSize.box === box;\n				});\n\n				var scaleMargin = {\n					left: 0,\n					right: 0,\n					top: totalTopBoxesHeight,\n					bottom: totalBottomBoxesHeight\n				};\n\n				if (minBoxSize) {\n					box.update(minBoxSize.minSize.width, maxChartAreaHeight, scaleMargin);\n				}\n			}\n\n			// Let the left layout know the final margin\n			helpers.each(leftBoxes.concat(rightBoxes), finalFitVerticalBox);\n\n			// Recalculate because the size of each layout might have changed slightly due to the margins (label rotation for instance)\n			totalLeftBoxesWidth = leftPadding;\n			totalRightBoxesWidth = rightPadding;\n			totalTopBoxesHeight = topPadding;\n			totalBottomBoxesHeight = bottomPadding;\n\n			helpers.each(leftBoxes, function(box) {\n				totalLeftBoxesWidth += box.width;\n			});\n\n			helpers.each(rightBoxes, function(box) {\n				totalRightBoxesWidth += box.width;\n			});\n\n			helpers.each(topBoxes, function(box) {\n				totalTopBoxesHeight += box.height;\n			});\n			helpers.each(bottomBoxes, function(box) {\n				totalBottomBoxesHeight += box.height;\n			});\n\n			// We may be adding some padding to account for rotated x axis labels\n			var leftPaddingAddition = Math.max(maxHorizontalLeftPadding - totalLeftBoxesWidth, 0);\n			totalLeftBoxesWidth += leftPaddingAddition;\n			totalRightBoxesWidth += Math.max(maxHorizontalRightPadding - totalRightBoxesWidth, 0);\n\n			var topPaddingAddition = Math.max(maxVerticalTopPadding - totalTopBoxesHeight, 0);\n			totalTopBoxesHeight += topPaddingAddition;\n			totalBottomBoxesHeight += Math.max(maxVerticalBottomPadding - totalBottomBoxesHeight, 0);\n\n			// Figure out if our chart area changed. This would occur if the dataset layout label rotation\n			// changed due to the application of the margins in step 6. Since we can only get bigger, this is safe to do\n			// without calling `fit` again\n			var newMaxChartAreaHeight = height - totalTopBoxesHeight - totalBottomBoxesHeight;\n			var newMaxChartAreaWidth = width - totalLeftBoxesWidth - totalRightBoxesWidth;\n\n			if (newMaxChartAreaWidth !== maxChartAreaWidth || newMaxChartAreaHeight !== maxChartAreaHeight) {\n				helpers.each(leftBoxes, function(box) {\n					box.height = newMaxChartAreaHeight;\n				});\n\n				helpers.each(rightBoxes, function(box) {\n					box.height = newMaxChartAreaHeight;\n				});\n\n				helpers.each(topBoxes, function(box) {\n					if (!box.fullWidth) {\n						box.width = newMaxChartAreaWidth;\n					}\n				});\n\n				helpers.each(bottomBoxes, function(box) {\n					if (!box.fullWidth) {\n						box.width = newMaxChartAreaWidth;\n					}\n				});\n\n				maxChartAreaHeight = newMaxChartAreaHeight;\n				maxChartAreaWidth = newMaxChartAreaWidth;\n			}\n\n			// Step 7 - Position the boxes\n			var left = leftPadding + leftPaddingAddition;\n			var top = topPadding + topPaddingAddition;\n\n			function placeBox(box) {\n				if (box.isHorizontal()) {\n					box.left = box.fullWidth ? leftPadding : totalLeftBoxesWidth;\n					box.right = box.fullWidth ? width - rightPadding : totalLeftBoxesWidth + maxChartAreaWidth;\n					box.top = top;\n					box.bottom = top + box.height;\n\n					// Move to next point\n					top = box.bottom;\n\n				} else {\n\n					box.left = left;\n					box.right = left + box.width;\n					box.top = totalTopBoxesHeight;\n					box.bottom = totalTopBoxesHeight + maxChartAreaHeight;\n\n					// Move to next point\n					left = box.right;\n				}\n			}\n\n			helpers.each(leftBoxes.concat(topBoxes), placeBox);\n\n			// Account for chart width and height\n			left += maxChartAreaWidth;\n			top += maxChartAreaHeight;\n\n			helpers.each(rightBoxes, placeBox);\n			helpers.each(bottomBoxes, placeBox);\n\n			// Step 8\n			chart.chartArea = {\n				left: totalLeftBoxesWidth,\n				top: totalTopBoxesHeight,\n				right: totalLeftBoxesWidth + maxChartAreaWidth,\n				bottom: totalTopBoxesHeight + maxChartAreaHeight\n			};\n\n			// Step 9\n			helpers.each(chartAreaBoxes, function(box) {\n				box.left = chart.chartArea.left;\n				box.top = chart.chartArea.top;\n				box.right = chart.chartArea.right;\n				box.bottom = chart.chartArea.bottom;\n\n				box.update(maxChartAreaWidth, maxChartAreaHeight);\n			});\n		}\n	};\n};\n\n},{\"45\":45}],31:[function(require,module,exports){\n'use strict';\n\nvar defaults = require(25);\nvar Element = require(26);\nvar helpers = require(45);\n\ndefaults._set('global', {\n	plugins: {}\n});\n\nmodule.exports = function(Chart) {\n\n	/**\n	 * The plugin service singleton\n	 * @namespace Chart.plugins\n	 * @since 2.1.0\n	 */\n	Chart.plugins = {\n		/**\n		 * Globally registered plugins.\n		 * @private\n		 */\n		_plugins: [],\n\n		/**\n		 * This identifier is used to invalidate the descriptors cache attached to each chart\n		 * when a global plugin is registered or unregistered. In this case, the cache ID is\n		 * incremented and descriptors are regenerated during following API calls.\n		 * @private\n		 */\n		_cacheId: 0,\n\n		/**\n		 * Registers the given plugin(s) if not already registered.\n		 * @param {Array|Object} plugins plugin instance(s).\n		 */\n		register: function(plugins) {\n			var p = this._plugins;\n			([]).concat(plugins).forEach(function(plugin) {\n				if (p.indexOf(plugin) === -1) {\n					p.push(plugin);\n				}\n			});\n\n			this._cacheId++;\n		},\n\n		/**\n		 * Unregisters the given plugin(s) only if registered.\n		 * @param {Array|Object} plugins plugin instance(s).\n		 */\n		unregister: function(plugins) {\n			var p = this._plugins;\n			([]).concat(plugins).forEach(function(plugin) {\n				var idx = p.indexOf(plugin);\n				if (idx !== -1) {\n					p.splice(idx, 1);\n				}\n			});\n\n			this._cacheId++;\n		},\n\n		/**\n		 * Remove all registered plugins.\n		 * @since 2.1.5\n		 */\n		clear: function() {\n			this._plugins = [];\n			this._cacheId++;\n		},\n\n		/**\n		 * Returns the number of registered plugins?\n		 * @returns {Number}\n		 * @since 2.1.5\n		 */\n		count: function() {\n			return this._plugins.length;\n		},\n\n		/**\n		 * Returns all registered plugin instances.\n		 * @returns {Array} array of plugin objects.\n		 * @since 2.1.5\n		 */\n		getAll: function() {\n			return this._plugins;\n		},\n\n		/**\n		 * Calls enabled plugins for `chart` on the specified hook and with the given args.\n		 * This method immediately returns as soon as a plugin explicitly returns false. The\n		 * returned value can be used, for instance, to interrupt the current action.\n		 * @param {Object} chart - The chart instance for which plugins should be called.\n		 * @param {String} hook - The name of the plugin method to call (e.g. 'beforeUpdate').\n		 * @param {Array} [args] - Extra arguments to apply to the hook call.\n		 * @returns {Boolean} false if any of the plugins return false, else returns true.\n		 */\n		notify: function(chart, hook, args) {\n			var descriptors = this.descriptors(chart);\n			var ilen = descriptors.length;\n			var i, descriptor, plugin, params, method;\n\n			for (i = 0; i < ilen; ++i) {\n				descriptor = descriptors[i];\n				plugin = descriptor.plugin;\n				method = plugin[hook];\n				if (typeof method === 'function') {\n					params = [chart].concat(args || []);\n					params.push(descriptor.options);\n					if (method.apply(plugin, params) === false) {\n						return false;\n					}\n				}\n			}\n\n			return true;\n		},\n\n		/**\n		 * Returns descriptors of enabled plugins for the given chart.\n		 * @returns {Array} [{ plugin, options }]\n		 * @private\n		 */\n		descriptors: function(chart) {\n			var cache = chart._plugins || (chart._plugins = {});\n			if (cache.id === this._cacheId) {\n				return cache.descriptors;\n			}\n\n			var plugins = [];\n			var descriptors = [];\n			var config = (chart && chart.config) || {};\n			var options = (config.options && config.options.plugins) || {};\n\n			this._plugins.concat(config.plugins || []).forEach(function(plugin) {\n				var idx = plugins.indexOf(plugin);\n				if (idx !== -1) {\n					return;\n				}\n\n				var id = plugin.id;\n				var opts = options[id];\n				if (opts === false) {\n					return;\n				}\n\n				if (opts === true) {\n					opts = helpers.clone(defaults.global.plugins[id]);\n				}\n\n				plugins.push(plugin);\n				descriptors.push({\n					plugin: plugin,\n					options: opts || {}\n				});\n			});\n\n			cache.descriptors = descriptors;\n			cache.id = this._cacheId;\n			return descriptors;\n		}\n	};\n\n	/**\n	 * Plugin extension hooks.\n	 * @interface IPlugin\n	 * @since 2.1.0\n	 */\n	/**\n	 * @method IPlugin#beforeInit\n	 * @desc Called before initializing `chart`.\n	 * @param {Chart.Controller} chart - The chart instance.\n	 * @param {Object} options - The plugin options.\n	 */\n	/**\n	 * @method IPlugin#afterInit\n	 * @desc Called after `chart` has been initialized and before the first update.\n	 * @param {Chart.Controller} chart - The chart instance.\n	 * @param {Object} options - The plugin options.\n	 */\n	/**\n	 * @method IPlugin#beforeUpdate\n	 * @desc Called before updating `chart`. If any plugin returns `false`, the update\n	 * is cancelled (and thus subsequent render(s)) until another `update` is triggered.\n	 * @param {Chart.Controller} chart - The chart instance.\n	 * @param {Object} options - The plugin options.\n	 * @returns {Boolean} `false` to cancel the chart update.\n	 */\n	/**\n	 * @method IPlugin#afterUpdate\n	 * @desc Called after `chart` has been updated and before rendering. Note that this\n	 * hook will not be called if the chart update has been previously cancelled.\n	 * @param {Chart.Controller} chart - The chart instance.\n	 * @param {Object} options - The plugin options.\n	 */\n	/**\n	 * @method IPlugin#beforeDatasetsUpdate\n 	 * @desc Called before updating the `chart` datasets. If any plugin returns `false`,\n	 * the datasets update is cancelled until another `update` is triggered.\n	 * @param {Chart.Controller} chart - The chart instance.\n	 * @param {Object} options - The plugin options.\n	 * @returns {Boolean} false to cancel the datasets update.\n	 * @since version 2.1.5\n	 */\n	/**\n	 * @method IPlugin#afterDatasetsUpdate\n	 * @desc Called after the `chart` datasets have been updated. Note that this hook\n	 * will not be called if the datasets update has been previously cancelled.\n	 * @param {Chart.Controller} chart - The chart instance.\n	 * @param {Object} options - The plugin options.\n	 * @since version 2.1.5\n	 */\n	/**\n	 * @method IPlugin#beforeDatasetUpdate\n 	 * @desc Called before updating the `chart` dataset at the given `args.index`. If any plugin\n	 * returns `false`, the datasets update is cancelled until another `update` is triggered.\n	 * @param {Chart} chart - The chart instance.\n	 * @param {Object} args - The call arguments.\n	 * @param {Number} args.index - The dataset index.\n	 * @param {Object} args.meta - The dataset metadata.\n	 * @param {Object} options - The plugin options.\n	 * @returns {Boolean} `false` to cancel the chart datasets drawing.\n	 */\n	/**\n	 * @method IPlugin#afterDatasetUpdate\n 	 * @desc Called after the `chart` datasets at the given `args.index` has been updated. Note\n	 * that this hook will not be called if the datasets update has been previously cancelled.\n	 * @param {Chart} chart - The chart instance.\n	 * @param {Object} args - The call arguments.\n	 * @param {Number} args.index - The dataset index.\n	 * @param {Object} args.meta - The dataset metadata.\n	 * @param {Object} options - The plugin options.\n	 */\n	/**\n	 * @method IPlugin#beforeLayout\n	 * @desc Called before laying out `chart`. If any plugin returns `false`,\n	 * the layout update is cancelled until another `update` is triggered.\n	 * @param {Chart.Controller} chart - The chart instance.\n	 * @param {Object} options - The plugin options.\n	 * @returns {Boolean} `false` to cancel the chart layout.\n	 */\n	/**\n	 * @method IPlugin#afterLayout\n	 * @desc Called after the `chart` has been layed out. Note that this hook will not\n	 * be called if the layout update has been previously cancelled.\n	 * @param {Chart.Controller} chart - The chart instance.\n	 * @param {Object} options - The plugin options.\n	 */\n	/**\n	 * @method IPlugin#beforeRender\n	 * @desc Called before rendering `chart`. If any plugin returns `false`,\n	 * the rendering is cancelled until another `render` is triggered.\n	 * @param {Chart.Controller} chart - The chart instance.\n	 * @param {Object} options - The plugin options.\n	 * @returns {Boolean} `false` to cancel the chart rendering.\n	 */\n	/**\n	 * @method IPlugin#afterRender\n	 * @desc Called after the `chart` has been fully rendered (and animation completed). Note\n	 * that this hook will not be called if the rendering has been previously cancelled.\n	 * @param {Chart.Controller} chart - The chart instance.\n	 * @param {Object} options - The plugin options.\n	 */\n	/**\n	 * @method IPlugin#beforeDraw\n	 * @desc Called before drawing `chart` at every animation frame specified by the given\n	 * easing value. If any plugin returns `false`, the frame drawing is cancelled until\n	 * another `render` is triggered.\n	 * @param {Chart.Controller} chart - The chart instance.\n	 * @param {Number} easingValue - The current animation value, between 0.0 and 1.0.\n	 * @param {Object} options - The plugin options.\n	 * @returns {Boolean} `false` to cancel the chart drawing.\n	 */\n	/**\n	 * @method IPlugin#afterDraw\n	 * @desc Called after the `chart` has been drawn for the specific easing value. Note\n	 * that this hook will not be called if the drawing has been previously cancelled.\n	 * @param {Chart.Controller} chart - The chart instance.\n	 * @param {Number} easingValue - The current animation value, between 0.0 and 1.0.\n	 * @param {Object} options - The plugin options.\n	 */\n	/**\n	 * @method IPlugin#beforeDatasetsDraw\n 	 * @desc Called before drawing the `chart` datasets. If any plugin returns `false`,\n	 * the datasets drawing is cancelled until another `render` is triggered.\n	 * @param {Chart.Controller} chart - The chart instance.\n	 * @param {Number} easingValue - The current animation value, between 0.0 and 1.0.\n	 * @param {Object} options - The plugin options.\n	 * @returns {Boolean} `false` to cancel the chart datasets drawing.\n	 */\n	/**\n	 * @method IPlugin#afterDatasetsDraw\n	 * @desc Called after the `chart` datasets have been drawn. Note that this hook\n	 * will not be called if the datasets drawing has been previously cancelled.\n	 * @param {Chart.Controller} chart - The chart instance.\n	 * @param {Number} easingValue - The current animation value, between 0.0 and 1.0.\n	 * @param {Object} options - The plugin options.\n	 */\n	/**\n	 * @method IPlugin#beforeDatasetDraw\n 	 * @desc Called before drawing the `chart` dataset at the given `args.index` (datasets\n	 * are drawn in the reverse order). If any plugin returns `false`, the datasets drawing\n	 * is cancelled until another `render` is triggered.\n	 * @param {Chart} chart - The chart instance.\n	 * @param {Object} args - The call arguments.\n	 * @param {Number} args.index - The dataset index.\n	 * @param {Object} args.meta - The dataset metadata.\n	 * @param {Number} args.easingValue - The current animation value, between 0.0 and 1.0.\n	 * @param {Object} options - The plugin options.\n	 * @returns {Boolean} `false` to cancel the chart datasets drawing.\n	 */\n	/**\n	 * @method IPlugin#afterDatasetDraw\n 	 * @desc Called after the `chart` datasets at the given `args.index` have been drawn\n	 * (datasets are drawn in the reverse order). Note that this hook will not be called\n	 * if the datasets drawing has been previously cancelled.\n	 * @param {Chart} chart - The chart instance.\n	 * @param {Object} args - The call arguments.\n	 * @param {Number} args.index - The dataset index.\n	 * @param {Object} args.meta - The dataset metadata.\n	 * @param {Number} args.easingValue - The current animation value, between 0.0 and 1.0.\n	 * @param {Object} options - The plugin options.\n	 */\n	/**\n  	 * @method IPlugin#beforeTooltipDraw\n	 * @desc Called before drawing the `tooltip`. If any plugin returns `false`,\n	 * the tooltip drawing is cancelled until another `render` is triggered.\n	 * @param {Chart} chart - The chart instance.\n	 * @param {Object} args - The call arguments.\n	 * @param {Object} args.tooltip - The tooltip.\n	 * @param {Number} args.easingValue - The current animation value, between 0.0 and 1.0.\n	 * @param {Object} options - The plugin options.\n	 * @returns {Boolean} `false` to cancel the chart tooltip drawing.\n  	 */\n	/**\n 	 * @method IPlugin#afterTooltipDraw\n  	 * @desc Called after drawing the `tooltip`. Note that this hook will not\n 	 * be called if the tooltip drawing has been previously cancelled.\n 	 * @param {Chart} chart - The chart instance.\n 	 * @param {Object} args - The call arguments.\n 	 * @param {Object} args.tooltip - The tooltip.\n	 * @param {Number} args.easingValue - The current animation value, between 0.0 and 1.0.\n 	 * @param {Object} options - The plugin options.\n 	 */\n	/**\n	 * @method IPlugin#beforeEvent\n 	 * @desc Called before processing the specified `event`. If any plugin returns `false`,\n	 * the event will be discarded.\n	 * @param {Chart.Controller} chart - The chart instance.\n	 * @param {IEvent} event - The event object.\n	 * @param {Object} options - The plugin options.\n	 */\n	/**\n	 * @method IPlugin#afterEvent\n	 * @desc Called after the `event` has been consumed. Note that this hook\n	 * will not be called if the `event` has been previously discarded.\n	 * @param {Chart.Controller} chart - The chart instance.\n	 * @param {IEvent} event - The event object.\n	 * @param {Object} options - The plugin options.\n	 */\n	/**\n	 * @method IPlugin#resize\n	 * @desc Called after the chart as been resized.\n	 * @param {Chart.Controller} chart - The chart instance.\n	 * @param {Number} size - The new canvas display size (eq. canvas.style width & height).\n	 * @param {Object} options - The plugin options.\n	 */\n	/**\n	 * @method IPlugin#destroy\n	 * @desc Called after the chart as been destroyed.\n	 * @param {Chart.Controller} chart - The chart instance.\n	 * @param {Object} options - The plugin options.\n	 */\n\n	/**\n	 * Provided for backward compatibility, use Chart.plugins instead\n	 * @namespace Chart.pluginService\n	 * @deprecated since version 2.1.5\n	 * @todo remove at version 3\n	 * @private\n	 */\n	Chart.pluginService = Chart.plugins;\n\n	/**\n	 * Provided for backward compatibility, inheriting from Chart.PlugingBase has no\n	 * effect, instead simply create/register plugins via plain JavaScript objects.\n	 * @interface Chart.PluginBase\n	 * @deprecated since version 2.5.0\n	 * @todo remove at version 3\n	 * @private\n	 */\n	Chart.PluginBase = Element.extend({});\n};\n\n},{\"25\":25,\"26\":26,\"45\":45}],32:[function(require,module,exports){\n'use strict';\n\nvar defaults = require(25);\nvar Element = require(26);\nvar helpers = require(45);\nvar Ticks = require(34);\n\ndefaults._set('scale', {\n	display: true,\n	position: 'left',\n	offset: false,\n\n	// grid line settings\n	gridLines: {\n		display: true,\n		color: 'rgba(0, 0, 0, 0.1)',\n		lineWidth: 1,\n		drawBorder: true,\n		drawOnChartArea: true,\n		drawTicks: true,\n		tickMarkLength: 10,\n		zeroLineWidth: 1,\n		zeroLineColor: 'rgba(0,0,0,0.25)',\n		zeroLineBorderDash: [],\n		zeroLineBorderDashOffset: 0.0,\n		offsetGridLines: false,\n		borderDash: [],\n		borderDashOffset: 0.0\n	},\n\n	// scale label\n	scaleLabel: {\n		// display property\n		display: false,\n\n		// actual label\n		labelString: '',\n\n		// line height\n		lineHeight: 1.2,\n\n		// top/bottom padding\n		padding: {\n			top: 4,\n			bottom: 4\n		}\n	},\n\n	// label settings\n	ticks: {\n		beginAtZero: false,\n		minRotation: 0,\n		maxRotation: 50,\n		mirror: false,\n		padding: 0,\n		reverse: false,\n		display: true,\n		autoSkip: true,\n		autoSkipPadding: 0,\n		labelOffset: 0,\n		// We pass through arrays to be rendered as multiline labels, we convert Others to strings here.\n		callback: Ticks.formatters.values,\n		minor: {},\n		major: {}\n	}\n});\n\nfunction labelsFromTicks(ticks) {\n	var labels = [];\n	var i, ilen;\n\n	for (i = 0, ilen = ticks.length; i < ilen; ++i) {\n		labels.push(ticks[i].label);\n	}\n\n	return labels;\n}\n\nfunction getLineValue(scale, index, offsetGridLines) {\n	var lineValue = scale.getPixelForTick(index);\n\n	if (offsetGridLines) {\n		if (index === 0) {\n			lineValue -= (scale.getPixelForTick(1) - lineValue) / 2;\n		} else {\n			lineValue -= (lineValue - scale.getPixelForTick(index - 1)) / 2;\n		}\n	}\n	return lineValue;\n}\n\nmodule.exports = function(Chart) {\n\n	function computeTextSize(context, tick, font) {\n		return helpers.isArray(tick) ?\n			helpers.longestText(context, font, tick) :\n			context.measureText(tick).width;\n	}\n\n	function parseFontOptions(options) {\n		var valueOrDefault = helpers.valueOrDefault;\n		var globalDefaults = defaults.global;\n		var size = valueOrDefault(options.fontSize, globalDefaults.defaultFontSize);\n		var style = valueOrDefault(options.fontStyle, globalDefaults.defaultFontStyle);\n		var family = valueOrDefault(options.fontFamily, globalDefaults.defaultFontFamily);\n\n		return {\n			size: size,\n			style: style,\n			family: family,\n			font: helpers.fontString(size, style, family)\n		};\n	}\n\n	function parseLineHeight(options) {\n		return helpers.options.toLineHeight(\n			helpers.valueOrDefault(options.lineHeight, 1.2),\n			helpers.valueOrDefault(options.fontSize, defaults.global.defaultFontSize));\n	}\n\n	Chart.Scale = Element.extend({\n		/**\n		 * Get the padding needed for the scale\n		 * @method getPadding\n		 * @private\n		 * @returns {Padding} the necessary padding\n		 */\n		getPadding: function() {\n			var me = this;\n			return {\n				left: me.paddingLeft || 0,\n				top: me.paddingTop || 0,\n				right: me.paddingRight || 0,\n				bottom: me.paddingBottom || 0\n			};\n		},\n\n		/**\n		 * Returns the scale tick objects ({label, major})\n		 * @since 2.7\n		 */\n		getTicks: function() {\n			return this._ticks;\n		},\n\n		// These methods are ordered by lifecyle. Utilities then follow.\n		// Any function defined here is inherited by all scale types.\n		// Any function can be extended by the scale type\n\n		mergeTicksOptions: function() {\n			var ticks = this.options.ticks;\n			if (ticks.minor === false) {\n				ticks.minor = {\n					display: false\n				};\n			}\n			if (ticks.major === false) {\n				ticks.major = {\n					display: false\n				};\n			}\n			for (var key in ticks) {\n				if (key !== 'major' && key !== 'minor') {\n					if (typeof ticks.minor[key] === 'undefined') {\n						ticks.minor[key] = ticks[key];\n					}\n					if (typeof ticks.major[key] === 'undefined') {\n						ticks.major[key] = ticks[key];\n					}\n				}\n			}\n		},\n		beforeUpdate: function() {\n			helpers.callback(this.options.beforeUpdate, [this]);\n		},\n		update: function(maxWidth, maxHeight, margins) {\n			var me = this;\n			var i, ilen, labels, label, ticks, tick;\n\n			// Update Lifecycle - Probably don't want to ever extend or overwrite this function ;)\n			me.beforeUpdate();\n\n			// Absorb the master measurements\n			me.maxWidth = maxWidth;\n			me.maxHeight = maxHeight;\n			me.margins = helpers.extend({\n				left: 0,\n				right: 0,\n				top: 0,\n				bottom: 0\n			}, margins);\n			me.longestTextCache = me.longestTextCache || {};\n\n			// Dimensions\n			me.beforeSetDimensions();\n			me.setDimensions();\n			me.afterSetDimensions();\n\n			// Data min/max\n			me.beforeDataLimits();\n			me.determineDataLimits();\n			me.afterDataLimits();\n\n			// Ticks - `this.ticks` is now DEPRECATED!\n			// Internal ticks are now stored as objects in the PRIVATE `this._ticks` member\n			// and must not be accessed directly from outside this class. `this.ticks` being\n			// around for long time and not marked as private, we can't change its structure\n			// without unexpected breaking changes. If you need to access the scale ticks,\n			// use scale.getTicks() instead.\n\n			me.beforeBuildTicks();\n\n			// New implementations should return an array of objects but for BACKWARD COMPAT,\n			// we still support no return (`this.ticks` internally set by calling this method).\n			ticks = me.buildTicks() || [];\n\n			me.afterBuildTicks();\n\n			me.beforeTickToLabelConversion();\n\n			// New implementations should return the formatted tick labels but for BACKWARD\n			// COMPAT, we still support no return (`this.ticks` internally changed by calling\n			// this method and supposed to contain only string values).\n			labels = me.convertTicksToLabels(ticks) || me.ticks;\n\n			me.afterTickToLabelConversion();\n\n			me.ticks = labels;   // BACKWARD COMPATIBILITY\n\n			// IMPORTANT: from this point, we consider that `this.ticks` will NEVER change!\n\n			// BACKWARD COMPAT: synchronize `_ticks` with labels (so potentially `this.ticks`)\n			for (i = 0, ilen = labels.length; i < ilen; ++i) {\n				label = labels[i];\n				tick = ticks[i];\n				if (!tick) {\n					ticks.push(tick = {\n						label: label,\n						major: false\n					});\n				} else {\n					tick.label = label;\n				}\n			}\n\n			me._ticks = ticks;\n\n			// Tick Rotation\n			me.beforeCalculateTickRotation();\n			me.calculateTickRotation();\n			me.afterCalculateTickRotation();\n			// Fit\n			me.beforeFit();\n			me.fit();\n			me.afterFit();\n			//\n			me.afterUpdate();\n\n			return me.minSize;\n\n		},\n		afterUpdate: function() {\n			helpers.callback(this.options.afterUpdate, [this]);\n		},\n\n		//\n\n		beforeSetDimensions: function() {\n			helpers.callback(this.options.beforeSetDimensions, [this]);\n		},\n		setDimensions: function() {\n			var me = this;\n			// Set the unconstrained dimension before label rotation\n			if (me.isHorizontal()) {\n				// Reset position before calculating rotation\n				me.width = me.maxWidth;\n				me.left = 0;\n				me.right = me.width;\n			} else {\n				me.height = me.maxHeight;\n\n				// Reset position before calculating rotation\n				me.top = 0;\n				me.bottom = me.height;\n			}\n\n			// Reset padding\n			me.paddingLeft = 0;\n			me.paddingTop = 0;\n			me.paddingRight = 0;\n			me.paddingBottom = 0;\n		},\n		afterSetDimensions: function() {\n			helpers.callback(this.options.afterSetDimensions, [this]);\n		},\n\n		// Data limits\n		beforeDataLimits: function() {\n			helpers.callback(this.options.beforeDataLimits, [this]);\n		},\n		determineDataLimits: helpers.noop,\n		afterDataLimits: function() {\n			helpers.callback(this.options.afterDataLimits, [this]);\n		},\n\n		//\n		beforeBuildTicks: function() {\n			helpers.callback(this.options.beforeBuildTicks, [this]);\n		},\n		buildTicks: helpers.noop,\n		afterBuildTicks: function() {\n			helpers.callback(this.options.afterBuildTicks, [this]);\n		},\n\n		beforeTickToLabelConversion: function() {\n			helpers.callback(this.options.beforeTickToLabelConversion, [this]);\n		},\n		convertTicksToLabels: function() {\n			var me = this;\n			// Convert ticks to strings\n			var tickOpts = me.options.ticks;\n			me.ticks = me.ticks.map(tickOpts.userCallback || tickOpts.callback, this);\n		},\n		afterTickToLabelConversion: function() {\n			helpers.callback(this.options.afterTickToLabelConversion, [this]);\n		},\n\n		//\n\n		beforeCalculateTickRotation: function() {\n			helpers.callback(this.options.beforeCalculateTickRotation, [this]);\n		},\n		calculateTickRotation: function() {\n			var me = this;\n			var context = me.ctx;\n			var tickOpts = me.options.ticks;\n			var labels = labelsFromTicks(me._ticks);\n\n			// Get the width of each grid by calculating the difference\n			// between x offsets between 0 and 1.\n			var tickFont = parseFontOptions(tickOpts);\n			context.font = tickFont.font;\n\n			var labelRotation = tickOpts.minRotation || 0;\n\n			if (labels.length && me.options.display && me.isHorizontal()) {\n				var originalLabelWidth = helpers.longestText(context, tickFont.font, labels, me.longestTextCache);\n				var labelWidth = originalLabelWidth;\n				var cosRotation, sinRotation;\n\n				// Allow 3 pixels x2 padding either side for label readability\n				var tickWidth = me.getPixelForTick(1) - me.getPixelForTick(0) - 6;\n\n				// Max label rotation can be set or default to 90 - also act as a loop counter\n				while (labelWidth > tickWidth && labelRotation < tickOpts.maxRotation) {\n					var angleRadians = helpers.toRadians(labelRotation);\n					cosRotation = Math.cos(angleRadians);\n					sinRotation = Math.sin(angleRadians);\n\n					if (sinRotation * originalLabelWidth > me.maxHeight) {\n						// go back one step\n						labelRotation--;\n						break;\n					}\n\n					labelRotation++;\n					labelWidth = cosRotation * originalLabelWidth;\n				}\n			}\n\n			me.labelRotation = labelRotation;\n		},\n		afterCalculateTickRotation: function() {\n			helpers.callback(this.options.afterCalculateTickRotation, [this]);\n		},\n\n		//\n\n		beforeFit: function() {\n			helpers.callback(this.options.beforeFit, [this]);\n		},\n		fit: function() {\n			var me = this;\n			// Reset\n			var minSize = me.minSize = {\n				width: 0,\n				height: 0\n			};\n\n			var labels = labelsFromTicks(me._ticks);\n\n			var opts = me.options;\n			var tickOpts = opts.ticks;\n			var scaleLabelOpts = opts.scaleLabel;\n			var gridLineOpts = opts.gridLines;\n			var display = opts.display;\n			var isHorizontal = me.isHorizontal();\n\n			var tickFont = parseFontOptions(tickOpts);\n			var tickMarkLength = opts.gridLines.tickMarkLength;\n\n			// Width\n			if (isHorizontal) {\n				// subtract the margins to line up with the chartArea if we are a full width scale\n				minSize.width = me.isFullWidth() ? me.maxWidth - me.margins.left - me.margins.right : me.maxWidth;\n			} else {\n				minSize.width = display && gridLineOpts.drawTicks ? tickMarkLength : 0;\n			}\n\n			// height\n			if (isHorizontal) {\n				minSize.height = display && gridLineOpts.drawTicks ? tickMarkLength : 0;\n			} else {\n				minSize.height = me.maxHeight; // fill all the height\n			}\n\n			// Are we showing a title for the scale?\n			if (scaleLabelOpts.display && display) {\n				var scaleLabelLineHeight = parseLineHeight(scaleLabelOpts);\n				var scaleLabelPadding = helpers.options.toPadding(scaleLabelOpts.padding);\n				var deltaHeight = scaleLabelLineHeight + scaleLabelPadding.height;\n\n				if (isHorizontal) {\n					minSize.height += deltaHeight;\n				} else {\n					minSize.width += deltaHeight;\n				}\n			}\n\n			// Don't bother fitting the ticks if we are not showing them\n			if (tickOpts.display && display) {\n				var largestTextWidth = helpers.longestText(me.ctx, tickFont.font, labels, me.longestTextCache);\n				var tallestLabelHeightInLines = helpers.numberOfLabelLines(labels);\n				var lineSpace = tickFont.size * 0.5;\n				var tickPadding = me.options.ticks.padding;\n\n				if (isHorizontal) {\n					// A horizontal axis is more constrained by the height.\n					me.longestLabelWidth = largestTextWidth;\n\n					var angleRadians = helpers.toRadians(me.labelRotation);\n					var cosRotation = Math.cos(angleRadians);\n					var sinRotation = Math.sin(angleRadians);\n\n					// TODO - improve this calculation\n					var labelHeight = (sinRotation * largestTextWidth)\n						+ (tickFont.size * tallestLabelHeightInLines)\n						+ (lineSpace * (tallestLabelHeightInLines - 1))\n						+ lineSpace; // padding\n\n					minSize.height = Math.min(me.maxHeight, minSize.height + labelHeight + tickPadding);\n\n					me.ctx.font = tickFont.font;\n					var firstLabelWidth = computeTextSize(me.ctx, labels[0], tickFont.font);\n					var lastLabelWidth = computeTextSize(me.ctx, labels[labels.length - 1], tickFont.font);\n\n					// Ensure that our ticks are always inside the canvas. When rotated, ticks are right aligned\n					// which means that the right padding is dominated by the font height\n					if (me.labelRotation !== 0) {\n						me.paddingLeft = opts.position === 'bottom' ? (cosRotation * firstLabelWidth) + 3 : (cosRotation * lineSpace) + 3; // add 3 px to move away from canvas edges\n						me.paddingRight = opts.position === 'bottom' ? (cosRotation * lineSpace) + 3 : (cosRotation * lastLabelWidth) + 3;\n					} else {\n						me.paddingLeft = firstLabelWidth / 2 + 3; // add 3 px to move away from canvas edges\n						me.paddingRight = lastLabelWidth / 2 + 3;\n					}\n				} else {\n					// A vertical axis is more constrained by the width. Labels are the\n					// dominant factor here, so get that length first and account for padding\n					if (tickOpts.mirror) {\n						largestTextWidth = 0;\n					} else {\n						// use lineSpace for consistency with horizontal axis\n						// tickPadding is not implemented for horizontal\n						largestTextWidth += tickPadding + lineSpace;\n					}\n\n					minSize.width = Math.min(me.maxWidth, minSize.width + largestTextWidth);\n\n					me.paddingTop = tickFont.size / 2;\n					me.paddingBottom = tickFont.size / 2;\n				}\n			}\n\n			me.handleMargins();\n\n			me.width = minSize.width;\n			me.height = minSize.height;\n		},\n\n		/**\n		 * Handle margins and padding interactions\n		 * @private\n		 */\n		handleMargins: function() {\n			var me = this;\n			if (me.margins) {\n				me.paddingLeft = Math.max(me.paddingLeft - me.margins.left, 0);\n				me.paddingTop = Math.max(me.paddingTop - me.margins.top, 0);\n				me.paddingRight = Math.max(me.paddingRight - me.margins.right, 0);\n				me.paddingBottom = Math.max(me.paddingBottom - me.margins.bottom, 0);\n			}\n		},\n\n		afterFit: function() {\n			helpers.callback(this.options.afterFit, [this]);\n		},\n\n		// Shared Methods\n		isHorizontal: function() {\n			return this.options.position === 'top' || this.options.position === 'bottom';\n		},\n		isFullWidth: function() {\n			return (this.options.fullWidth);\n		},\n\n		// Get the correct value. NaN bad inputs, If the value type is object get the x or y based on whether we are horizontal or not\n		getRightValue: function(rawValue) {\n			// Null and undefined values first\n			if (helpers.isNullOrUndef(rawValue)) {\n				return NaN;\n			}\n			// isNaN(object) returns true, so make sure NaN is checking for a number; Discard Infinite values\n			if (typeof rawValue === 'number' && !isFinite(rawValue)) {\n				return NaN;\n			}\n			// If it is in fact an object, dive in one more level\n			if (rawValue) {\n				if (this.isHorizontal()) {\n					if (rawValue.x !== undefined) {\n						return this.getRightValue(rawValue.x);\n					}\n				} else if (rawValue.y !== undefined) {\n					return this.getRightValue(rawValue.y);\n				}\n			}\n\n			// Value is good, return it\n			return rawValue;\n		},\n\n		/**\n		 * Used to get the value to display in the tooltip for the data at the given index\n		 * @param index\n		 * @param datasetIndex\n		 */\n		getLabelForIndex: helpers.noop,\n\n		/**\n		 * Returns the location of the given data point. Value can either be an index or a numerical value\n		 * The coordinate (0, 0) is at the upper-left corner of the canvas\n		 * @param value\n		 * @param index\n		 * @param datasetIndex\n		 */\n		getPixelForValue: helpers.noop,\n\n		/**\n		 * Used to get the data value from a given pixel. This is the inverse of getPixelForValue\n		 * The coordinate (0, 0) is at the upper-left corner of the canvas\n		 * @param pixel\n		 */\n		getValueForPixel: helpers.noop,\n\n		/**\n		 * Returns the location of the tick at the given index\n		 * The coordinate (0, 0) is at the upper-left corner of the canvas\n		 */\n		getPixelForTick: function(index) {\n			var me = this;\n			var offset = me.options.offset;\n			if (me.isHorizontal()) {\n				var innerWidth = me.width - (me.paddingLeft + me.paddingRight);\n				var tickWidth = innerWidth / Math.max((me._ticks.length - (offset ? 0 : 1)), 1);\n				var pixel = (tickWidth * index) + me.paddingLeft;\n\n				if (offset) {\n					pixel += tickWidth / 2;\n				}\n\n				var finalVal = me.left + Math.round(pixel);\n				finalVal += me.isFullWidth() ? me.margins.left : 0;\n				return finalVal;\n			}\n			var innerHeight = me.height - (me.paddingTop + me.paddingBottom);\n			return me.top + (index * (innerHeight / (me._ticks.length - 1)));\n		},\n\n		/**\n		 * Utility for getting the pixel location of a percentage of scale\n		 * The coordinate (0, 0) is at the upper-left corner of the canvas\n		 */\n		getPixelForDecimal: function(decimal) {\n			var me = this;\n			if (me.isHorizontal()) {\n				var innerWidth = me.width - (me.paddingLeft + me.paddingRight);\n				var valueOffset = (innerWidth * decimal) + me.paddingLeft;\n\n				var finalVal = me.left + Math.round(valueOffset);\n				finalVal += me.isFullWidth() ? me.margins.left : 0;\n				return finalVal;\n			}\n			return me.top + (decimal * me.height);\n		},\n\n		/**\n		 * Returns the pixel for the minimum chart value\n		 * The coordinate (0, 0) is at the upper-left corner of the canvas\n		 */\n		getBasePixel: function() {\n			return this.getPixelForValue(this.getBaseValue());\n		},\n\n		getBaseValue: function() {\n			var me = this;\n			var min = me.min;\n			var max = me.max;\n\n			return me.beginAtZero ? 0 :\n				min < 0 && max < 0 ? max :\n				min > 0 && max > 0 ? min :\n				0;\n		},\n\n		/**\n		 * Returns a subset of ticks to be plotted to avoid overlapping labels.\n		 * @private\n		 */\n		_autoSkip: function(ticks) {\n			var skipRatio;\n			var me = this;\n			var isHorizontal = me.isHorizontal();\n			var optionTicks = me.options.ticks.minor;\n			var tickCount = ticks.length;\n			var labelRotationRadians = helpers.toRadians(me.labelRotation);\n			var cosRotation = Math.cos(labelRotationRadians);\n			var longestRotatedLabel = me.longestLabelWidth * cosRotation;\n			var result = [];\n			var i, tick, shouldSkip;\n\n			// figure out the maximum number of gridlines to show\n			var maxTicks;\n			if (optionTicks.maxTicksLimit) {\n				maxTicks = optionTicks.maxTicksLimit;\n			}\n\n			if (isHorizontal) {\n				skipRatio = false;\n\n				if ((longestRotatedLabel + optionTicks.autoSkipPadding) * tickCount > (me.width - (me.paddingLeft + me.paddingRight))) {\n					skipRatio = 1 + Math.floor(((longestRotatedLabel + optionTicks.autoSkipPadding) * tickCount) / (me.width - (me.paddingLeft + me.paddingRight)));\n				}\n\n				// if they defined a max number of optionTicks,\n				// increase skipRatio until that number is met\n				if (maxTicks && tickCount > maxTicks) {\n					skipRatio = Math.max(skipRatio, Math.floor(tickCount / maxTicks));\n				}\n			}\n\n			for (i = 0; i < tickCount; i++) {\n				tick = ticks[i];\n\n				// Since we always show the last tick,we need may need to hide the last shown one before\n				shouldSkip = (skipRatio > 1 && i % skipRatio > 0) || (i % skipRatio === 0 && i + skipRatio >= tickCount);\n				if (shouldSkip && i !== tickCount - 1) {\n					// leave tick in place but make sure it's not displayed (#4635)\n					delete tick.label;\n				}\n				result.push(tick);\n			}\n			return result;\n		},\n\n		// Actually draw the scale on the canvas\n		// @param {rectangle} chartArea : the area of the chart to draw full grid lines on\n		draw: function(chartArea) {\n			var me = this;\n			var options = me.options;\n			if (!options.display) {\n				return;\n			}\n\n			var context = me.ctx;\n			var globalDefaults = defaults.global;\n			var optionTicks = options.ticks.minor;\n			var optionMajorTicks = options.ticks.major || optionTicks;\n			var gridLines = options.gridLines;\n			var scaleLabel = options.scaleLabel;\n\n			var isRotated = me.labelRotation !== 0;\n			var isHorizontal = me.isHorizontal();\n\n			var ticks = optionTicks.autoSkip ? me._autoSkip(me.getTicks()) : me.getTicks();\n			var tickFontColor = helpers.valueOrDefault(optionTicks.fontColor, globalDefaults.defaultFontColor);\n			var tickFont = parseFontOptions(optionTicks);\n			var majorTickFontColor = helpers.valueOrDefault(optionMajorTicks.fontColor, globalDefaults.defaultFontColor);\n			var majorTickFont = parseFontOptions(optionMajorTicks);\n\n			var tl = gridLines.drawTicks ? gridLines.tickMarkLength : 0;\n\n			var scaleLabelFontColor = helpers.valueOrDefault(scaleLabel.fontColor, globalDefaults.defaultFontColor);\n			var scaleLabelFont = parseFontOptions(scaleLabel);\n			var scaleLabelPadding = helpers.options.toPadding(scaleLabel.padding);\n			var labelRotationRadians = helpers.toRadians(me.labelRotation);\n\n			var itemsToDraw = [];\n\n			var xTickStart = options.position === 'right' ? me.left : me.right - tl;\n			var xTickEnd = options.position === 'right' ? me.left + tl : me.right;\n			var yTickStart = options.position === 'bottom' ? me.top : me.bottom - tl;\n			var yTickEnd = options.position === 'bottom' ? me.top + tl : me.bottom;\n\n			helpers.each(ticks, function(tick, index) {\n				// autoskipper skipped this tick (#4635)\n				if (helpers.isNullOrUndef(tick.label)) {\n					return;\n				}\n\n				var label = tick.label;\n				var lineWidth, lineColor, borderDash, borderDashOffset;\n				if (index === me.zeroLineIndex && options.offset === gridLines.offsetGridLines) {\n					// Draw the first index specially\n					lineWidth = gridLines.zeroLineWidth;\n					lineColor = gridLines.zeroLineColor;\n					borderDash = gridLines.zeroLineBorderDash;\n					borderDashOffset = gridLines.zeroLineBorderDashOffset;\n				} else {\n					lineWidth = helpers.valueAtIndexOrDefault(gridLines.lineWidth, index);\n					lineColor = helpers.valueAtIndexOrDefault(gridLines.color, index);\n					borderDash = helpers.valueOrDefault(gridLines.borderDash, globalDefaults.borderDash);\n					borderDashOffset = helpers.valueOrDefault(gridLines.borderDashOffset, globalDefaults.borderDashOffset);\n				}\n\n				// Common properties\n				var tx1, ty1, tx2, ty2, x1, y1, x2, y2, labelX, labelY;\n				var textAlign = 'middle';\n				var textBaseline = 'middle';\n				var tickPadding = optionTicks.padding;\n\n				if (isHorizontal) {\n					var labelYOffset = tl + tickPadding;\n\n					if (options.position === 'bottom') {\n						// bottom\n						textBaseline = !isRotated ? 'top' : 'middle';\n						textAlign = !isRotated ? 'center' : 'right';\n						labelY = me.top + labelYOffset;\n					} else {\n						// top\n						textBaseline = !isRotated ? 'bottom' : 'middle';\n						textAlign = !isRotated ? 'center' : 'left';\n						labelY = me.bottom - labelYOffset;\n					}\n\n					var xLineValue = getLineValue(me, index, gridLines.offsetGridLines && ticks.length > 1);\n					if (xLineValue < me.left) {\n						lineColor = 'rgba(0,0,0,0)';\n					}\n					xLineValue += helpers.aliasPixel(lineWidth);\n\n					labelX = me.getPixelForTick(index) + optionTicks.labelOffset; // x values for optionTicks (need to consider offsetLabel option)\n\n					tx1 = tx2 = x1 = x2 = xLineValue;\n					ty1 = yTickStart;\n					ty2 = yTickEnd;\n					y1 = chartArea.top;\n					y2 = chartArea.bottom;\n				} else {\n					var isLeft = options.position === 'left';\n					var labelXOffset;\n\n					if (optionTicks.mirror) {\n						textAlign = isLeft ? 'left' : 'right';\n						labelXOffset = tickPadding;\n					} else {\n						textAlign = isLeft ? 'right' : 'left';\n						labelXOffset = tl + tickPadding;\n					}\n\n					labelX = isLeft ? me.right - labelXOffset : me.left + labelXOffset;\n\n					var yLineValue = getLineValue(me, index, gridLines.offsetGridLines && ticks.length > 1);\n					if (yLineValue < me.top) {\n						lineColor = 'rgba(0,0,0,0)';\n					}\n					yLineValue += helpers.aliasPixel(lineWidth);\n\n					labelY = me.getPixelForTick(index) + optionTicks.labelOffset;\n\n					tx1 = xTickStart;\n					tx2 = xTickEnd;\n					x1 = chartArea.left;\n					x2 = chartArea.right;\n					ty1 = ty2 = y1 = y2 = yLineValue;\n				}\n\n				itemsToDraw.push({\n					tx1: tx1,\n					ty1: ty1,\n					tx2: tx2,\n					ty2: ty2,\n					x1: x1,\n					y1: y1,\n					x2: x2,\n					y2: y2,\n					labelX: labelX,\n					labelY: labelY,\n					glWidth: lineWidth,\n					glColor: lineColor,\n					glBorderDash: borderDash,\n					glBorderDashOffset: borderDashOffset,\n					rotation: -1 * labelRotationRadians,\n					label: label,\n					major: tick.major,\n					textBaseline: textBaseline,\n					textAlign: textAlign\n				});\n			});\n\n			// Draw all of the tick labels, tick marks, and grid lines at the correct places\n			helpers.each(itemsToDraw, function(itemToDraw) {\n				if (gridLines.display) {\n					context.save();\n					context.lineWidth = itemToDraw.glWidth;\n					context.strokeStyle = itemToDraw.glColor;\n					if (context.setLineDash) {\n						context.setLineDash(itemToDraw.glBorderDash);\n						context.lineDashOffset = itemToDraw.glBorderDashOffset;\n					}\n\n					context.beginPath();\n\n					if (gridLines.drawTicks) {\n						context.moveTo(itemToDraw.tx1, itemToDraw.ty1);\n						context.lineTo(itemToDraw.tx2, itemToDraw.ty2);\n					}\n\n					if (gridLines.drawOnChartArea) {\n						context.moveTo(itemToDraw.x1, itemToDraw.y1);\n						context.lineTo(itemToDraw.x2, itemToDraw.y2);\n					}\n\n					context.stroke();\n					context.restore();\n				}\n\n				if (optionTicks.display) {\n					// Make sure we draw text in the correct color and font\n					context.save();\n					context.translate(itemToDraw.labelX, itemToDraw.labelY);\n					context.rotate(itemToDraw.rotation);\n					context.font = itemToDraw.major ? majorTickFont.font : tickFont.font;\n					context.fillStyle = itemToDraw.major ? majorTickFontColor : tickFontColor;\n					context.textBaseline = itemToDraw.textBaseline;\n					context.textAlign = itemToDraw.textAlign;\n\n					var label = itemToDraw.label;\n					if (helpers.isArray(label)) {\n						for (var i = 0, y = 0; i < label.length; ++i) {\n							// We just make sure the multiline element is a string here..\n							context.fillText('' + label[i], 0, y);\n							// apply same lineSpacing as calculated @ L#320\n							y += (tickFont.size * 1.5);\n						}\n					} else {\n						context.fillText(label, 0, 0);\n					}\n					context.restore();\n				}\n			});\n\n			if (scaleLabel.display) {\n				// Draw the scale label\n				var scaleLabelX;\n				var scaleLabelY;\n				var rotation = 0;\n				var halfLineHeight = parseLineHeight(scaleLabel) / 2;\n\n				if (isHorizontal) {\n					scaleLabelX = me.left + ((me.right - me.left) / 2); // midpoint of the width\n					scaleLabelY = options.position === 'bottom'\n						? me.bottom - halfLineHeight - scaleLabelPadding.bottom\n						: me.top + halfLineHeight + scaleLabelPadding.top;\n				} else {\n					var isLeft = options.position === 'left';\n					scaleLabelX = isLeft\n						? me.left + halfLineHeight + scaleLabelPadding.top\n						: me.right - halfLineHeight - scaleLabelPadding.top;\n					scaleLabelY = me.top + ((me.bottom - me.top) / 2);\n					rotation = isLeft ? -0.5 * Math.PI : 0.5 * Math.PI;\n				}\n\n				context.save();\n				context.translate(scaleLabelX, scaleLabelY);\n				context.rotate(rotation);\n				context.textAlign = 'center';\n				context.textBaseline = 'middle';\n				context.fillStyle = scaleLabelFontColor; // render in correct colour\n				context.font = scaleLabelFont.font;\n				context.fillText(scaleLabel.labelString, 0, 0);\n				context.restore();\n			}\n\n			if (gridLines.drawBorder) {\n				// Draw the line at the edge of the axis\n				context.lineWidth = helpers.valueAtIndexOrDefault(gridLines.lineWidth, 0);\n				context.strokeStyle = helpers.valueAtIndexOrDefault(gridLines.color, 0);\n				var x1 = me.left;\n				var x2 = me.right;\n				var y1 = me.top;\n				var y2 = me.bottom;\n\n				var aliasPixel = helpers.aliasPixel(context.lineWidth);\n				if (isHorizontal) {\n					y1 = y2 = options.position === 'top' ? me.bottom : me.top;\n					y1 += aliasPixel;\n					y2 += aliasPixel;\n				} else {\n					x1 = x2 = options.position === 'left' ? me.right : me.left;\n					x1 += aliasPixel;\n					x2 += aliasPixel;\n				}\n\n				context.beginPath();\n				context.moveTo(x1, y1);\n				context.lineTo(x2, y2);\n				context.stroke();\n			}\n		}\n	});\n};\n\n},{\"25\":25,\"26\":26,\"34\":34,\"45\":45}],33:[function(require,module,exports){\n'use strict';\n\nvar defaults = require(25);\nvar helpers = require(45);\n\nmodule.exports = function(Chart) {\n\n	Chart.scaleService = {\n		// Scale registration object. Extensions can register new scale types (such as log or DB scales) and then\n		// use the new chart options to grab the correct scale\n		constructors: {},\n		// Use a registration function so that we can move to an ES6 map when we no longer need to support\n		// old browsers\n\n		// Scale config defaults\n		defaults: {},\n		registerScaleType: function(type, scaleConstructor, scaleDefaults) {\n			this.constructors[type] = scaleConstructor;\n			this.defaults[type] = helpers.clone(scaleDefaults);\n		},\n		getScaleConstructor: function(type) {\n			return this.constructors.hasOwnProperty(type) ? this.constructors[type] : undefined;\n		},\n		getScaleDefaults: function(type) {\n			// Return the scale defaults merged with the global settings so that we always use the latest ones\n			return this.defaults.hasOwnProperty(type) ? helpers.merge({}, [defaults.scale, this.defaults[type]]) : {};\n		},\n		updateScaleDefaults: function(type, additions) {\n			var me = this;\n			if (me.defaults.hasOwnProperty(type)) {\n				me.defaults[type] = helpers.extend(me.defaults[type], additions);\n			}\n		},\n		addScalesToLayout: function(chart) {\n			// Adds each scale to the chart.boxes array to be sized accordingly\n			helpers.each(chart.scales, function(scale) {\n				// Set ILayoutItem parameters for backwards compatibility\n				scale.fullWidth = scale.options.fullWidth;\n				scale.position = scale.options.position;\n				scale.weight = scale.options.weight;\n				Chart.layoutService.addBox(chart, scale);\n			});\n		}\n	};\n};\n\n},{\"25\":25,\"45\":45}],34:[function(require,module,exports){\n'use strict';\n\nvar helpers = require(45);\n\n/**\n * Namespace to hold static tick generation functions\n * @namespace Chart.Ticks\n */\nmodule.exports = {\n	/**\n	 * Namespace to hold generators for different types of ticks\n	 * @namespace Chart.Ticks.generators\n	 */\n	generators: {\n		/**\n		 * Interface for the options provided to the numeric tick generator\n		 * @interface INumericTickGenerationOptions\n		 */\n		/**\n		 * The maximum number of ticks to display\n		 * @name INumericTickGenerationOptions#maxTicks\n		 * @type Number\n		 */\n		/**\n		 * The distance between each tick.\n		 * @name INumericTickGenerationOptions#stepSize\n		 * @type Number\n		 * @optional\n		 */\n		/**\n		 * Forced minimum for the ticks. If not specified, the minimum of the data range is used to calculate the tick minimum\n		 * @name INumericTickGenerationOptions#min\n		 * @type Number\n		 * @optional\n		 */\n		/**\n		 * The maximum value of the ticks. If not specified, the maximum of the data range is used to calculate the tick maximum\n		 * @name INumericTickGenerationOptions#max\n		 * @type Number\n		 * @optional\n		 */\n\n		/**\n		 * Generate a set of linear ticks\n		 * @method Chart.Ticks.generators.linear\n		 * @param generationOptions {INumericTickGenerationOptions} the options used to generate the ticks\n		 * @param dataRange {IRange} the range of the data\n		 * @returns {Array<Number>} array of tick values\n		 */\n		linear: function(generationOptions, dataRange) {\n			var ticks = [];\n			// To get a \"nice\" value for the tick spacing, we will use the appropriately named\n			// \"nice number\" algorithm. See http://stackoverflow.com/questions/8506881/nice-label-algorithm-for-charts-with-minimum-ticks\n			// for details.\n\n			var spacing;\n			if (generationOptions.stepSize && generationOptions.stepSize > 0) {\n				spacing = generationOptions.stepSize;\n			} else {\n				var niceRange = helpers.niceNum(dataRange.max - dataRange.min, false);\n				spacing = helpers.niceNum(niceRange / (generationOptions.maxTicks - 1), true);\n			}\n			var niceMin = Math.floor(dataRange.min / spacing) * spacing;\n			var niceMax = Math.ceil(dataRange.max / spacing) * spacing;\n\n			// If min, max and stepSize is set and they make an evenly spaced scale use it.\n			if (generationOptions.min && generationOptions.max && generationOptions.stepSize) {\n				// If very close to our whole number, use it.\n				if (helpers.almostWhole((generationOptions.max - generationOptions.min) / generationOptions.stepSize, spacing / 1000)) {\n					niceMin = generationOptions.min;\n					niceMax = generationOptions.max;\n				}\n			}\n\n			var numSpaces = (niceMax - niceMin) / spacing;\n			// If very close to our rounded value, use it.\n			if (helpers.almostEquals(numSpaces, Math.round(numSpaces), spacing / 1000)) {\n				numSpaces = Math.round(numSpaces);\n			} else {\n				numSpaces = Math.ceil(numSpaces);\n			}\n\n			// Put the values into the ticks array\n			ticks.push(generationOptions.min !== undefined ? generationOptions.min : niceMin);\n			for (var j = 1; j < numSpaces; ++j) {\n				ticks.push(niceMin + (j * spacing));\n			}\n			ticks.push(generationOptions.max !== undefined ? generationOptions.max : niceMax);\n\n			return ticks;\n		},\n\n		/**\n		 * Generate a set of logarithmic ticks\n		 * @method Chart.Ticks.generators.logarithmic\n		 * @param generationOptions {INumericTickGenerationOptions} the options used to generate the ticks\n		 * @param dataRange {IRange} the range of the data\n		 * @returns {Array<Number>} array of tick values\n		 */\n		logarithmic: function(generationOptions, dataRange) {\n			var ticks = [];\n			var valueOrDefault = helpers.valueOrDefault;\n\n			// Figure out what the max number of ticks we can support it is based on the size of\n			// the axis area. For now, we say that the minimum tick spacing in pixels must be 50\n			// We also limit the maximum number of ticks to 11 which gives a nice 10 squares on\n			// the graph\n			var tickVal = valueOrDefault(generationOptions.min, Math.pow(10, Math.floor(helpers.log10(dataRange.min))));\n\n			var endExp = Math.floor(helpers.log10(dataRange.max));\n			var endSignificand = Math.ceil(dataRange.max / Math.pow(10, endExp));\n			var exp, significand;\n\n			if (tickVal === 0) {\n				exp = Math.floor(helpers.log10(dataRange.minNotZero));\n				significand = Math.floor(dataRange.minNotZero / Math.pow(10, exp));\n\n				ticks.push(tickVal);\n				tickVal = significand * Math.pow(10, exp);\n			} else {\n				exp = Math.floor(helpers.log10(tickVal));\n				significand = Math.floor(tickVal / Math.pow(10, exp));\n			}\n\n			do {\n				ticks.push(tickVal);\n\n				++significand;\n				if (significand === 10) {\n					significand = 1;\n					++exp;\n				}\n\n				tickVal = significand * Math.pow(10, exp);\n			} while (exp < endExp || (exp === endExp && significand < endSignificand));\n\n			var lastTick = valueOrDefault(generationOptions.max, tickVal);\n			ticks.push(lastTick);\n\n			return ticks;\n		}\n	},\n\n	/**\n	 * Namespace to hold formatters for different types of ticks\n	 * @namespace Chart.Ticks.formatters\n	 */\n	formatters: {\n		/**\n		 * Formatter for value labels\n		 * @method Chart.Ticks.formatters.values\n		 * @param value the value to display\n		 * @return {String|Array} the label to display\n		 */\n		values: function(value) {\n			return helpers.isArray(value) ? value : '' + value;\n		},\n\n		/**\n		 * Formatter for linear numeric ticks\n		 * @method Chart.Ticks.formatters.linear\n		 * @param tickValue {Number} the value to be formatted\n		 * @param index {Number} the position of the tickValue parameter in the ticks array\n		 * @param ticks {Array<Number>} the list of ticks being converted\n		 * @return {String} string representation of the tickValue parameter\n		 */\n		linear: function(tickValue, index, ticks) {\n			// If we have lots of ticks, don't use the ones\n			var delta = ticks.length > 3 ? ticks[2] - ticks[1] : ticks[1] - ticks[0];\n\n			// If we have a number like 2.5 as the delta, figure out how many decimal places we need\n			if (Math.abs(delta) > 1) {\n				if (tickValue !== Math.floor(tickValue)) {\n					// not an integer\n					delta = tickValue - Math.floor(tickValue);\n				}\n			}\n\n			var logDelta = helpers.log10(Math.abs(delta));\n			var tickString = '';\n\n			if (tickValue !== 0) {\n				var numDecimal = -1 * Math.floor(logDelta);\n				numDecimal = Math.max(Math.min(numDecimal, 20), 0); // toFixed has a max of 20 decimal places\n				tickString = tickValue.toFixed(numDecimal);\n			} else {\n				tickString = '0'; // never show decimal places for 0\n			}\n\n			return tickString;\n		},\n\n		logarithmic: function(tickValue, index, ticks) {\n			var remain = tickValue / (Math.pow(10, Math.floor(helpers.log10(tickValue))));\n\n			if (tickValue === 0) {\n				return '0';\n			} else if (remain === 1 || remain === 2 || remain === 5 || index === 0 || index === ticks.length - 1) {\n				return tickValue.toExponential();\n			}\n			return '';\n		}\n	}\n};\n\n},{\"45\":45}],35:[function(require,module,exports){\n'use strict';\n\nvar defaults = require(25);\nvar Element = require(26);\nvar helpers = require(45);\n\ndefaults._set('global', {\n	tooltips: {\n		enabled: true,\n		custom: null,\n		mode: 'nearest',\n		position: 'average',\n		intersect: true,\n		backgroundColor: 'rgba(0,0,0,0.8)',\n		titleFontStyle: 'bold',\n		titleSpacing: 2,\n		titleMarginBottom: 6,\n		titleFontColor: '#fff',\n		titleAlign: 'left',\n		bodySpacing: 2,\n		bodyFontColor: '#fff',\n		bodyAlign: 'left',\n		footerFontStyle: 'bold',\n		footerSpacing: 2,\n		footerMarginTop: 6,\n		footerFontColor: '#fff',\n		footerAlign: 'left',\n		yPadding: 6,\n		xPadding: 6,\n		caretPadding: 2,\n		caretSize: 5,\n		cornerRadius: 6,\n		multiKeyBackground: '#fff',\n		displayColors: true,\n		borderColor: 'rgba(0,0,0,0)',\n		borderWidth: 0,\n		callbacks: {\n			// Args are: (tooltipItems, data)\n			beforeTitle: helpers.noop,\n			title: function(tooltipItems, data) {\n				// Pick first xLabel for now\n				var title = '';\n				var labels = data.labels;\n				var labelCount = labels ? labels.length : 0;\n\n				if (tooltipItems.length > 0) {\n					var item = tooltipItems[0];\n\n					if (item.xLabel) {\n						title = item.xLabel;\n					} else if (labelCount > 0 && item.index < labelCount) {\n						title = labels[item.index];\n					}\n				}\n\n				return title;\n			},\n			afterTitle: helpers.noop,\n\n			// Args are: (tooltipItems, data)\n			beforeBody: helpers.noop,\n\n			// Args are: (tooltipItem, data)\n			beforeLabel: helpers.noop,\n			label: function(tooltipItem, data) {\n				var label = data.datasets[tooltipItem.datasetIndex].label || '';\n\n				if (label) {\n					label += ': ';\n				}\n				label += tooltipItem.yLabel;\n				return label;\n			},\n			labelColor: function(tooltipItem, chart) {\n				var meta = chart.getDatasetMeta(tooltipItem.datasetIndex);\n				var activeElement = meta.data[tooltipItem.index];\n				var view = activeElement._view;\n				return {\n					borderColor: view.borderColor,\n					backgroundColor: view.backgroundColor\n				};\n			},\n			labelTextColor: function() {\n				return this._options.bodyFontColor;\n			},\n			afterLabel: helpers.noop,\n\n			// Args are: (tooltipItems, data)\n			afterBody: helpers.noop,\n\n			// Args are: (tooltipItems, data)\n			beforeFooter: helpers.noop,\n			footer: helpers.noop,\n			afterFooter: helpers.noop\n		}\n	}\n});\n\nmodule.exports = function(Chart) {\n\n	/**\n 	 * Helper method to merge the opacity into a color\n 	 */\n	function mergeOpacity(colorString, opacity) {\n		var color = helpers.color(colorString);\n		return color.alpha(opacity * color.alpha()).rgbaString();\n	}\n\n	// Helper to push or concat based on if the 2nd parameter is an array or not\n	function pushOrConcat(base, toPush) {\n		if (toPush) {\n			if (helpers.isArray(toPush)) {\n				// base = base.concat(toPush);\n				Array.prototype.push.apply(base, toPush);\n			} else {\n				base.push(toPush);\n			}\n		}\n\n		return base;\n	}\n\n	// Private helper to create a tooltip item model\n	// @param element : the chart element (point, arc, bar) to create the tooltip item for\n	// @return : new tooltip item\n	function createTooltipItem(element) {\n		var xScale = element._xScale;\n		var yScale = element._yScale || element._scale; // handle radar || polarArea charts\n		var index = element._index;\n		var datasetIndex = element._datasetIndex;\n\n		return {\n			xLabel: xScale ? xScale.getLabelForIndex(index, datasetIndex) : '',\n			yLabel: yScale ? yScale.getLabelForIndex(index, datasetIndex) : '',\n			index: index,\n			datasetIndex: datasetIndex,\n			x: element._model.x,\n			y: element._model.y\n		};\n	}\n\n	/**\n	 * Helper to get the reset model for the tooltip\n	 * @param tooltipOpts {Object} the tooltip options\n	 */\n	function getBaseModel(tooltipOpts) {\n		var globalDefaults = defaults.global;\n		var valueOrDefault = helpers.valueOrDefault;\n\n		return {\n			// Positioning\n			xPadding: tooltipOpts.xPadding,\n			yPadding: tooltipOpts.yPadding,\n			xAlign: tooltipOpts.xAlign,\n			yAlign: tooltipOpts.yAlign,\n\n			// Body\n			bodyFontColor: tooltipOpts.bodyFontColor,\n			_bodyFontFamily: valueOrDefault(tooltipOpts.bodyFontFamily, globalDefaults.defaultFontFamily),\n			_bodyFontStyle: valueOrDefault(tooltipOpts.bodyFontStyle, globalDefaults.defaultFontStyle),\n			_bodyAlign: tooltipOpts.bodyAlign,\n			bodyFontSize: valueOrDefault(tooltipOpts.bodyFontSize, globalDefaults.defaultFontSize),\n			bodySpacing: tooltipOpts.bodySpacing,\n\n			// Title\n			titleFontColor: tooltipOpts.titleFontColor,\n			_titleFontFamily: valueOrDefault(tooltipOpts.titleFontFamily, globalDefaults.defaultFontFamily),\n			_titleFontStyle: valueOrDefault(tooltipOpts.titleFontStyle, globalDefaults.defaultFontStyle),\n			titleFontSize: valueOrDefault(tooltipOpts.titleFontSize, globalDefaults.defaultFontSize),\n			_titleAlign: tooltipOpts.titleAlign,\n			titleSpacing: tooltipOpts.titleSpacing,\n			titleMarginBottom: tooltipOpts.titleMarginBottom,\n\n			// Footer\n			footerFontColor: tooltipOpts.footerFontColor,\n			_footerFontFamily: valueOrDefault(tooltipOpts.footerFontFamily, globalDefaults.defaultFontFamily),\n			_footerFontStyle: valueOrDefault(tooltipOpts.footerFontStyle, globalDefaults.defaultFontStyle),\n			footerFontSize: valueOrDefault(tooltipOpts.footerFontSize, globalDefaults.defaultFontSize),\n			_footerAlign: tooltipOpts.footerAlign,\n			footerSpacing: tooltipOpts.footerSpacing,\n			footerMarginTop: tooltipOpts.footerMarginTop,\n\n			// Appearance\n			caretSize: tooltipOpts.caretSize,\n			cornerRadius: tooltipOpts.cornerRadius,\n			backgroundColor: tooltipOpts.backgroundColor,\n			opacity: 0,\n			legendColorBackground: tooltipOpts.multiKeyBackground,\n			displayColors: tooltipOpts.displayColors,\n			borderColor: tooltipOpts.borderColor,\n			borderWidth: tooltipOpts.borderWidth\n		};\n	}\n\n	/**\n	 * Get the size of the tooltip\n	 */\n	function getTooltipSize(tooltip, model) {\n		var ctx = tooltip._chart.ctx;\n\n		var height = model.yPadding * 2; // Tooltip Padding\n		var width = 0;\n\n		// Count of all lines in the body\n		var body = model.body;\n		var combinedBodyLength = body.reduce(function(count, bodyItem) {\n			return count + bodyItem.before.length + bodyItem.lines.length + bodyItem.after.length;\n		}, 0);\n		combinedBodyLength += model.beforeBody.length + model.afterBody.length;\n\n		var titleLineCount = model.title.length;\n		var footerLineCount = model.footer.length;\n		var titleFontSize = model.titleFontSize;\n		var bodyFontSize = model.bodyFontSize;\n		var footerFontSize = model.footerFontSize;\n\n		height += titleLineCount * titleFontSize; // Title Lines\n		height += titleLineCount ? (titleLineCount - 1) * model.titleSpacing : 0; // Title Line Spacing\n		height += titleLineCount ? model.titleMarginBottom : 0; // Title's bottom Margin\n		height += combinedBodyLength * bodyFontSize; // Body Lines\n		height += combinedBodyLength ? (combinedBodyLength - 1) * model.bodySpacing : 0; // Body Line Spacing\n		height += footerLineCount ? model.footerMarginTop : 0; // Footer Margin\n		height += footerLineCount * (footerFontSize); // Footer Lines\n		height += footerLineCount ? (footerLineCount - 1) * model.footerSpacing : 0; // Footer Line Spacing\n\n		// Title width\n		var widthPadding = 0;\n		var maxLineWidth = function(line) {\n			width = Math.max(width, ctx.measureText(line).width + widthPadding);\n		};\n\n		ctx.font = helpers.fontString(titleFontSize, model._titleFontStyle, model._titleFontFamily);\n		helpers.each(model.title, maxLineWidth);\n\n		// Body width\n		ctx.font = helpers.fontString(bodyFontSize, model._bodyFontStyle, model._bodyFontFamily);\n		helpers.each(model.beforeBody.concat(model.afterBody), maxLineWidth);\n\n		// Body lines may include some extra width due to the color box\n		widthPadding = model.displayColors ? (bodyFontSize + 2) : 0;\n		helpers.each(body, function(bodyItem) {\n			helpers.each(bodyItem.before, maxLineWidth);\n			helpers.each(bodyItem.lines, maxLineWidth);\n			helpers.each(bodyItem.after, maxLineWidth);\n		});\n\n		// Reset back to 0\n		widthPadding = 0;\n\n		// Footer width\n		ctx.font = helpers.fontString(footerFontSize, model._footerFontStyle, model._footerFontFamily);\n		helpers.each(model.footer, maxLineWidth);\n\n		// Add padding\n		width += 2 * model.xPadding;\n\n		return {\n			width: width,\n			height: height\n		};\n	}\n\n	/**\n	 * Helper to get the alignment of a tooltip given the size\n	 */\n	function determineAlignment(tooltip, size) {\n		var model = tooltip._model;\n		var chart = tooltip._chart;\n		var chartArea = tooltip._chart.chartArea;\n		var xAlign = 'center';\n		var yAlign = 'center';\n\n		if (model.y < size.height) {\n			yAlign = 'top';\n		} else if (model.y > (chart.height - size.height)) {\n			yAlign = 'bottom';\n		}\n\n		var lf, rf; // functions to determine left, right alignment\n		var olf, orf; // functions to determine if left/right alignment causes tooltip to go outside chart\n		var yf; // function to get the y alignment if the tooltip goes outside of the left or right edges\n		var midX = (chartArea.left + chartArea.right) / 2;\n		var midY = (chartArea.top + chartArea.bottom) / 2;\n\n		if (yAlign === 'center') {\n			lf = function(x) {\n				return x <= midX;\n			};\n			rf = function(x) {\n				return x > midX;\n			};\n		} else {\n			lf = function(x) {\n				return x <= (size.width / 2);\n			};\n			rf = function(x) {\n				return x >= (chart.width - (size.width / 2));\n			};\n		}\n\n		olf = function(x) {\n			return x + size.width > chart.width;\n		};\n		orf = function(x) {\n			return x - size.width < 0;\n		};\n		yf = function(y) {\n			return y <= midY ? 'top' : 'bottom';\n		};\n\n		if (lf(model.x)) {\n			xAlign = 'left';\n\n			// Is tooltip too wide and goes over the right side of the chart.?\n			if (olf(model.x)) {\n				xAlign = 'center';\n				yAlign = yf(model.y);\n			}\n		} else if (rf(model.x)) {\n			xAlign = 'right';\n\n			// Is tooltip too wide and goes outside left edge of canvas?\n			if (orf(model.x)) {\n				xAlign = 'center';\n				yAlign = yf(model.y);\n			}\n		}\n\n		var opts = tooltip._options;\n		return {\n			xAlign: opts.xAlign ? opts.xAlign : xAlign,\n			yAlign: opts.yAlign ? opts.yAlign : yAlign\n		};\n	}\n\n	/**\n	 * @Helper to get the location a tooltip needs to be placed at given the initial position (via the vm) and the size and alignment\n	 */\n	function getBackgroundPoint(vm, size, alignment) {\n		// Background Position\n		var x = vm.x;\n		var y = vm.y;\n\n		var caretSize = vm.caretSize;\n		var caretPadding = vm.caretPadding;\n		var cornerRadius = vm.cornerRadius;\n		var xAlign = alignment.xAlign;\n		var yAlign = alignment.yAlign;\n		var paddingAndSize = caretSize + caretPadding;\n		var radiusAndPadding = cornerRadius + caretPadding;\n\n		if (xAlign === 'right') {\n			x -= size.width;\n		} else if (xAlign === 'center') {\n			x -= (size.width / 2);\n		}\n\n		if (yAlign === 'top') {\n			y += paddingAndSize;\n		} else if (yAlign === 'bottom') {\n			y -= size.height + paddingAndSize;\n		} else {\n			y -= (size.height / 2);\n		}\n\n		if (yAlign === 'center') {\n			if (xAlign === 'left') {\n				x += paddingAndSize;\n			} else if (xAlign === 'right') {\n				x -= paddingAndSize;\n			}\n		} else if (xAlign === 'left') {\n			x -= radiusAndPadding;\n		} else if (xAlign === 'right') {\n			x += radiusAndPadding;\n		}\n\n		return {\n			x: x,\n			y: y\n		};\n	}\n\n	Chart.Tooltip = Element.extend({\n		initialize: function() {\n			this._model = getBaseModel(this._options);\n			this._lastActive = [];\n		},\n\n		// Get the title\n		// Args are: (tooltipItem, data)\n		getTitle: function() {\n			var me = this;\n			var opts = me._options;\n			var callbacks = opts.callbacks;\n\n			var beforeTitle = callbacks.beforeTitle.apply(me, arguments);\n			var title = callbacks.title.apply(me, arguments);\n			var afterTitle = callbacks.afterTitle.apply(me, arguments);\n\n			var lines = [];\n			lines = pushOrConcat(lines, beforeTitle);\n			lines = pushOrConcat(lines, title);\n			lines = pushOrConcat(lines, afterTitle);\n\n			return lines;\n		},\n\n		// Args are: (tooltipItem, data)\n		getBeforeBody: function() {\n			var lines = this._options.callbacks.beforeBody.apply(this, arguments);\n			return helpers.isArray(lines) ? lines : lines !== undefined ? [lines] : [];\n		},\n\n		// Args are: (tooltipItem, data)\n		getBody: function(tooltipItems, data) {\n			var me = this;\n			var callbacks = me._options.callbacks;\n			var bodyItems = [];\n\n			helpers.each(tooltipItems, function(tooltipItem) {\n				var bodyItem = {\n					before: [],\n					lines: [],\n					after: []\n				};\n				pushOrConcat(bodyItem.before, callbacks.beforeLabel.call(me, tooltipItem, data));\n				pushOrConcat(bodyItem.lines, callbacks.label.call(me, tooltipItem, data));\n				pushOrConcat(bodyItem.after, callbacks.afterLabel.call(me, tooltipItem, data));\n\n				bodyItems.push(bodyItem);\n			});\n\n			return bodyItems;\n		},\n\n		// Args are: (tooltipItem, data)\n		getAfterBody: function() {\n			var lines = this._options.callbacks.afterBody.apply(this, arguments);\n			return helpers.isArray(lines) ? lines : lines !== undefined ? [lines] : [];\n		},\n\n		// Get the footer and beforeFooter and afterFooter lines\n		// Args are: (tooltipItem, data)\n		getFooter: function() {\n			var me = this;\n			var callbacks = me._options.callbacks;\n\n			var beforeFooter = callbacks.beforeFooter.apply(me, arguments);\n			var footer = callbacks.footer.apply(me, arguments);\n			var afterFooter = callbacks.afterFooter.apply(me, arguments);\n\n			var lines = [];\n			lines = pushOrConcat(lines, beforeFooter);\n			lines = pushOrConcat(lines, footer);\n			lines = pushOrConcat(lines, afterFooter);\n\n			return lines;\n		},\n\n		update: function(changed) {\n			var me = this;\n			var opts = me._options;\n\n			// Need to regenerate the model because its faster than using extend and it is necessary due to the optimization in Chart.Element.transition\n			// that does _view = _model if ease === 1. This causes the 2nd tooltip update to set properties in both the view and model at the same time\n			// which breaks any animations.\n			var existingModel = me._model;\n			var model = me._model = getBaseModel(opts);\n			var active = me._active;\n\n			var data = me._data;\n\n			// In the case where active.length === 0 we need to keep these at existing values for good animations\n			var alignment = {\n				xAlign: existingModel.xAlign,\n				yAlign: existingModel.yAlign\n			};\n			var backgroundPoint = {\n				x: existingModel.x,\n				y: existingModel.y\n			};\n			var tooltipSize = {\n				width: existingModel.width,\n				height: existingModel.height\n			};\n			var tooltipPosition = {\n				x: existingModel.caretX,\n				y: existingModel.caretY\n			};\n\n			var i, len;\n\n			if (active.length) {\n				model.opacity = 1;\n\n				var labelColors = [];\n				var labelTextColors = [];\n				tooltipPosition = Chart.Tooltip.positioners[opts.position].call(me, active, me._eventPosition);\n\n				var tooltipItems = [];\n				for (i = 0, len = active.length; i < len; ++i) {\n					tooltipItems.push(createTooltipItem(active[i]));\n				}\n\n				// If the user provided a filter function, use it to modify the tooltip items\n				if (opts.filter) {\n					tooltipItems = tooltipItems.filter(function(a) {\n						return opts.filter(a, data);\n					});\n				}\n\n				// If the user provided a sorting function, use it to modify the tooltip items\n				if (opts.itemSort) {\n					tooltipItems = tooltipItems.sort(function(a, b) {\n						return opts.itemSort(a, b, data);\n					});\n				}\n\n				// Determine colors for boxes\n				helpers.each(tooltipItems, function(tooltipItem) {\n					labelColors.push(opts.callbacks.labelColor.call(me, tooltipItem, me._chart));\n					labelTextColors.push(opts.callbacks.labelTextColor.call(me, tooltipItem, me._chart));\n				});\n\n\n				// Build the Text Lines\n				model.title = me.getTitle(tooltipItems, data);\n				model.beforeBody = me.getBeforeBody(tooltipItems, data);\n				model.body = me.getBody(tooltipItems, data);\n				model.afterBody = me.getAfterBody(tooltipItems, data);\n				model.footer = me.getFooter(tooltipItems, data);\n\n				// Initial positioning and colors\n				model.x = Math.round(tooltipPosition.x);\n				model.y = Math.round(tooltipPosition.y);\n				model.caretPadding = opts.caretPadding;\n				model.labelColors = labelColors;\n				model.labelTextColors = labelTextColors;\n\n				// data points\n				model.dataPoints = tooltipItems;\n\n				// We need to determine alignment of the tooltip\n				tooltipSize = getTooltipSize(this, model);\n				alignment = determineAlignment(this, tooltipSize);\n				// Final Size and Position\n				backgroundPoint = getBackgroundPoint(model, tooltipSize, alignment);\n			} else {\n				model.opacity = 0;\n			}\n\n			model.xAlign = alignment.xAlign;\n			model.yAlign = alignment.yAlign;\n			model.x = backgroundPoint.x;\n			model.y = backgroundPoint.y;\n			model.width = tooltipSize.width;\n			model.height = tooltipSize.height;\n\n			// Point where the caret on the tooltip points to\n			model.caretX = tooltipPosition.x;\n			model.caretY = tooltipPosition.y;\n\n			me._model = model;\n\n			if (changed && opts.custom) {\n				opts.custom.call(me, model);\n			}\n\n			return me;\n		},\n		drawCaret: function(tooltipPoint, size) {\n			var ctx = this._chart.ctx;\n			var vm = this._view;\n			var caretPosition = this.getCaretPosition(tooltipPoint, size, vm);\n\n			ctx.lineTo(caretPosition.x1, caretPosition.y1);\n			ctx.lineTo(caretPosition.x2, caretPosition.y2);\n			ctx.lineTo(caretPosition.x3, caretPosition.y3);\n		},\n		getCaretPosition: function(tooltipPoint, size, vm) {\n			var x1, x2, x3, y1, y2, y3;\n			var caretSize = vm.caretSize;\n			var cornerRadius = vm.cornerRadius;\n			var xAlign = vm.xAlign;\n			var yAlign = vm.yAlign;\n			var ptX = tooltipPoint.x;\n			var ptY = tooltipPoint.y;\n			var width = size.width;\n			var height = size.height;\n\n			if (yAlign === 'center') {\n				y2 = ptY + (height / 2);\n\n				if (xAlign === 'left') {\n					x1 = ptX;\n					x2 = x1 - caretSize;\n					x3 = x1;\n\n					y1 = y2 + caretSize;\n					y3 = y2 - caretSize;\n				} else {\n					x1 = ptX + width;\n					x2 = x1 + caretSize;\n					x3 = x1;\n\n					y1 = y2 - caretSize;\n					y3 = y2 + caretSize;\n				}\n			} else {\n				if (xAlign === 'left') {\n					x2 = ptX + cornerRadius + (caretSize);\n					x1 = x2 - caretSize;\n					x3 = x2 + caretSize;\n				} else if (xAlign === 'right') {\n					x2 = ptX + width - cornerRadius - caretSize;\n					x1 = x2 - caretSize;\n					x3 = x2 + caretSize;\n				} else {\n					x2 = ptX + (width / 2);\n					x1 = x2 - caretSize;\n					x3 = x2 + caretSize;\n				}\n				if (yAlign === 'top') {\n					y1 = ptY;\n					y2 = y1 - caretSize;\n					y3 = y1;\n				} else {\n					y1 = ptY + height;\n					y2 = y1 + caretSize;\n					y3 = y1;\n					// invert drawing order\n					var tmp = x3;\n					x3 = x1;\n					x1 = tmp;\n				}\n			}\n			return {x1: x1, x2: x2, x3: x3, y1: y1, y2: y2, y3: y3};\n		},\n		drawTitle: function(pt, vm, ctx, opacity) {\n			var title = vm.title;\n\n			if (title.length) {\n				ctx.textAlign = vm._titleAlign;\n				ctx.textBaseline = 'top';\n\n				var titleFontSize = vm.titleFontSize;\n				var titleSpacing = vm.titleSpacing;\n\n				ctx.fillStyle = mergeOpacity(vm.titleFontColor, opacity);\n				ctx.font = helpers.fontString(titleFontSize, vm._titleFontStyle, vm._titleFontFamily);\n\n				var i, len;\n				for (i = 0, len = title.length; i < len; ++i) {\n					ctx.fillText(title[i], pt.x, pt.y);\n					pt.y += titleFontSize + titleSpacing; // Line Height and spacing\n\n					if (i + 1 === title.length) {\n						pt.y += vm.titleMarginBottom - titleSpacing; // If Last, add margin, remove spacing\n					}\n				}\n			}\n		},\n		drawBody: function(pt, vm, ctx, opacity) {\n			var bodyFontSize = vm.bodyFontSize;\n			var bodySpacing = vm.bodySpacing;\n			var body = vm.body;\n\n			ctx.textAlign = vm._bodyAlign;\n			ctx.textBaseline = 'top';\n			ctx.font = helpers.fontString(bodyFontSize, vm._bodyFontStyle, vm._bodyFontFamily);\n\n			// Before Body\n			var xLinePadding = 0;\n			var fillLineOfText = function(line) {\n				ctx.fillText(line, pt.x + xLinePadding, pt.y);\n				pt.y += bodyFontSize + bodySpacing;\n			};\n\n			// Before body lines\n			ctx.fillStyle = mergeOpacity(vm.bodyFontColor, opacity);\n			helpers.each(vm.beforeBody, fillLineOfText);\n\n			var drawColorBoxes = vm.displayColors;\n			xLinePadding = drawColorBoxes ? (bodyFontSize + 2) : 0;\n\n			// Draw body lines now\n			helpers.each(body, function(bodyItem, i) {\n				var textColor = mergeOpacity(vm.labelTextColors[i], opacity);\n				ctx.fillStyle = textColor;\n				helpers.each(bodyItem.before, fillLineOfText);\n\n				helpers.each(bodyItem.lines, function(line) {\n					// Draw Legend-like boxes if needed\n					if (drawColorBoxes) {\n						// Fill a white rect so that colours merge nicely if the opacity is < 1\n						ctx.fillStyle = mergeOpacity(vm.legendColorBackground, opacity);\n						ctx.fillRect(pt.x, pt.y, bodyFontSize, bodyFontSize);\n\n						// Border\n						ctx.lineWidth = 1;\n						ctx.strokeStyle = mergeOpacity(vm.labelColors[i].borderColor, opacity);\n						ctx.strokeRect(pt.x, pt.y, bodyFontSize, bodyFontSize);\n\n						// Inner square\n						ctx.fillStyle = mergeOpacity(vm.labelColors[i].backgroundColor, opacity);\n						ctx.fillRect(pt.x + 1, pt.y + 1, bodyFontSize - 2, bodyFontSize - 2);\n						ctx.fillStyle = textColor;\n					}\n\n					fillLineOfText(line);\n				});\n\n				helpers.each(bodyItem.after, fillLineOfText);\n			});\n\n			// Reset back to 0 for after body\n			xLinePadding = 0;\n\n			// After body lines\n			helpers.each(vm.afterBody, fillLineOfText);\n			pt.y -= bodySpacing; // Remove last body spacing\n		},\n		drawFooter: function(pt, vm, ctx, opacity) {\n			var footer = vm.footer;\n\n			if (footer.length) {\n				pt.y += vm.footerMarginTop;\n\n				ctx.textAlign = vm._footerAlign;\n				ctx.textBaseline = 'top';\n\n				ctx.fillStyle = mergeOpacity(vm.footerFontColor, opacity);\n				ctx.font = helpers.fontString(vm.footerFontSize, vm._footerFontStyle, vm._footerFontFamily);\n\n				helpers.each(footer, function(line) {\n					ctx.fillText(line, pt.x, pt.y);\n					pt.y += vm.footerFontSize + vm.footerSpacing;\n				});\n			}\n		},\n		drawBackground: function(pt, vm, ctx, tooltipSize, opacity) {\n			ctx.fillStyle = mergeOpacity(vm.backgroundColor, opacity);\n			ctx.strokeStyle = mergeOpacity(vm.borderColor, opacity);\n			ctx.lineWidth = vm.borderWidth;\n			var xAlign = vm.xAlign;\n			var yAlign = vm.yAlign;\n			var x = pt.x;\n			var y = pt.y;\n			var width = tooltipSize.width;\n			var height = tooltipSize.height;\n			var radius = vm.cornerRadius;\n\n			ctx.beginPath();\n			ctx.moveTo(x + radius, y);\n			if (yAlign === 'top') {\n				this.drawCaret(pt, tooltipSize);\n			}\n			ctx.lineTo(x + width - radius, y);\n			ctx.quadraticCurveTo(x + width, y, x + width, y + radius);\n			if (yAlign === 'center' && xAlign === 'right') {\n				this.drawCaret(pt, tooltipSize);\n			}\n			ctx.lineTo(x + width, y + height - radius);\n			ctx.quadraticCurveTo(x + width, y + height, x + width - radius, y + height);\n			if (yAlign === 'bottom') {\n				this.drawCaret(pt, tooltipSize);\n			}\n			ctx.lineTo(x + radius, y + height);\n			ctx.quadraticCurveTo(x, y + height, x, y + height - radius);\n			if (yAlign === 'center' && xAlign === 'left') {\n				this.drawCaret(pt, tooltipSize);\n			}\n			ctx.lineTo(x, y + radius);\n			ctx.quadraticCurveTo(x, y, x + radius, y);\n			ctx.closePath();\n\n			ctx.fill();\n\n			if (vm.borderWidth > 0) {\n				ctx.stroke();\n			}\n		},\n		draw: function() {\n			var ctx = this._chart.ctx;\n			var vm = this._view;\n\n			if (vm.opacity === 0) {\n				return;\n			}\n\n			var tooltipSize = {\n				width: vm.width,\n				height: vm.height\n			};\n			var pt = {\n				x: vm.x,\n				y: vm.y\n			};\n\n			// IE11/Edge does not like very small opacities, so snap to 0\n			var opacity = Math.abs(vm.opacity < 1e-3) ? 0 : vm.opacity;\n\n			// Truthy/falsey value for empty tooltip\n			var hasTooltipContent = vm.title.length || vm.beforeBody.length || vm.body.length || vm.afterBody.length || vm.footer.length;\n\n			if (this._options.enabled && hasTooltipContent) {\n				// Draw Background\n				this.drawBackground(pt, vm, ctx, tooltipSize, opacity);\n\n				// Draw Title, Body, and Footer\n				pt.x += vm.xPadding;\n				pt.y += vm.yPadding;\n\n				// Titles\n				this.drawTitle(pt, vm, ctx, opacity);\n\n				// Body\n				this.drawBody(pt, vm, ctx, opacity);\n\n				// Footer\n				this.drawFooter(pt, vm, ctx, opacity);\n			}\n		},\n\n		/**\n		 * Handle an event\n		 * @private\n		 * @param {IEvent} event - The event to handle\n		 * @returns {Boolean} true if the tooltip changed\n		 */\n		handleEvent: function(e) {\n			var me = this;\n			var options = me._options;\n			var changed = false;\n\n			me._lastActive = me._lastActive || [];\n\n			// Find Active Elements for tooltips\n			if (e.type === 'mouseout') {\n				me._active = [];\n			} else {\n				me._active = me._chart.getElementsAtEventForMode(e, options.mode, options);\n			}\n\n			// Remember Last Actives\n			changed = !helpers.arrayEquals(me._active, me._lastActive);\n\n			// If tooltip didn't change, do not handle the target event\n			if (!changed) {\n				return false;\n			}\n\n			me._lastActive = me._active;\n\n			if (options.enabled || options.custom) {\n				me._eventPosition = {\n					x: e.x,\n					y: e.y\n				};\n\n				var model = me._model;\n				me.update(true);\n				me.pivot();\n\n				// See if our tooltip position changed\n				changed |= (model.x !== me._model.x) || (model.y !== me._model.y);\n			}\n\n			return changed;\n		}\n	});\n\n	/**\n	 * @namespace Chart.Tooltip.positioners\n	 */\n	Chart.Tooltip.positioners = {\n		/**\n		 * Average mode places the tooltip at the average position of the elements shown\n		 * @function Chart.Tooltip.positioners.average\n		 * @param elements {ChartElement[]} the elements being displayed in the tooltip\n		 * @returns {Point} tooltip position\n		 */\n		average: function(elements) {\n			if (!elements.length) {\n				return false;\n			}\n\n			var i, len;\n			var x = 0;\n			var y = 0;\n			var count = 0;\n\n			for (i = 0, len = elements.length; i < len; ++i) {\n				var el = elements[i];\n				if (el && el.hasValue()) {\n					var pos = el.tooltipPosition();\n					x += pos.x;\n					y += pos.y;\n					++count;\n				}\n			}\n\n			return {\n				x: Math.round(x / count),\n				y: Math.round(y / count)\n			};\n		},\n\n		/**\n		 * Gets the tooltip position nearest of the item nearest to the event position\n		 * @function Chart.Tooltip.positioners.nearest\n		 * @param elements {Chart.Element[]} the tooltip elements\n		 * @param eventPosition {Point} the position of the event in canvas coordinates\n		 * @returns {Point} the tooltip position\n		 */\n		nearest: function(elements, eventPosition) {\n			var x = eventPosition.x;\n			var y = eventPosition.y;\n			var minDistance = Number.POSITIVE_INFINITY;\n			var i, len, nearestElement;\n\n			for (i = 0, len = elements.length; i < len; ++i) {\n				var el = elements[i];\n				if (el && el.hasValue()) {\n					var center = el.getCenterPoint();\n					var d = helpers.distanceBetweenPoints(eventPosition, center);\n\n					if (d < minDistance) {\n						minDistance = d;\n						nearestElement = el;\n					}\n				}\n			}\n\n			if (nearestElement) {\n				var tp = nearestElement.tooltipPosition();\n				x = tp.x;\n				y = tp.y;\n			}\n\n			return {\n				x: x,\n				y: y\n			};\n		}\n	};\n};\n\n},{\"25\":25,\"26\":26,\"45\":45}],36:[function(require,module,exports){\n'use strict';\n\nvar defaults = require(25);\nvar Element = require(26);\nvar helpers = require(45);\n\ndefaults._set('global', {\n	elements: {\n		arc: {\n			backgroundColor: defaults.global.defaultColor,\n			borderColor: '#fff',\n			borderWidth: 2\n		}\n	}\n});\n\nmodule.exports = Element.extend({\n	inLabelRange: function(mouseX) {\n		var vm = this._view;\n\n		if (vm) {\n			return (Math.pow(mouseX - vm.x, 2) < Math.pow(vm.radius + vm.hoverRadius, 2));\n		}\n		return false;\n	},\n\n	inRange: function(chartX, chartY) {\n		var vm = this._view;\n\n		if (vm) {\n			var pointRelativePosition = helpers.getAngleFromPoint(vm, {x: chartX, y: chartY});\n			var	angle = pointRelativePosition.angle;\n			var distance = pointRelativePosition.distance;\n\n			// Sanitise angle range\n			var startAngle = vm.startAngle;\n			var endAngle = vm.endAngle;\n			while (endAngle < startAngle) {\n				endAngle += 2.0 * Math.PI;\n			}\n			while (angle > endAngle) {\n				angle -= 2.0 * Math.PI;\n			}\n			while (angle < startAngle) {\n				angle += 2.0 * Math.PI;\n			}\n\n			// Check if within the range of the open/close angle\n			var betweenAngles = (angle >= startAngle && angle <= endAngle);\n			var withinRadius = (distance >= vm.innerRadius && distance <= vm.outerRadius);\n\n			return (betweenAngles && withinRadius);\n		}\n		return false;\n	},\n\n	getCenterPoint: function() {\n		var vm = this._view;\n		var halfAngle = (vm.startAngle + vm.endAngle) / 2;\n		var halfRadius = (vm.innerRadius + vm.outerRadius) / 2;\n		return {\n			x: vm.x + Math.cos(halfAngle) * halfRadius,\n			y: vm.y + Math.sin(halfAngle) * halfRadius\n		};\n	},\n\n	getArea: function() {\n		var vm = this._view;\n		return Math.PI * ((vm.endAngle - vm.startAngle) / (2 * Math.PI)) * (Math.pow(vm.outerRadius, 2) - Math.pow(vm.innerRadius, 2));\n	},\n\n	tooltipPosition: function() {\n		var vm = this._view;\n		var centreAngle = vm.startAngle + ((vm.endAngle - vm.startAngle) / 2);\n		var rangeFromCentre = (vm.outerRadius - vm.innerRadius) / 2 + vm.innerRadius;\n\n		return {\n			x: vm.x + (Math.cos(centreAngle) * rangeFromCentre),\n			y: vm.y + (Math.sin(centreAngle) * rangeFromCentre)\n		};\n	},\n\n	draw: function() {\n		var ctx = this._chart.ctx;\n		var vm = this._view;\n		var sA = vm.startAngle;\n		var eA = vm.endAngle;\n\n		ctx.beginPath();\n\n		ctx.arc(vm.x, vm.y, vm.outerRadius, sA, eA);\n		ctx.arc(vm.x, vm.y, vm.innerRadius, eA, sA, true);\n\n		ctx.closePath();\n		ctx.strokeStyle = vm.borderColor;\n		ctx.lineWidth = vm.borderWidth;\n\n		ctx.fillStyle = vm.backgroundColor;\n\n		ctx.fill();\n		ctx.lineJoin = 'bevel';\n\n		if (vm.borderWidth) {\n			ctx.stroke();\n		}\n	}\n});\n\n},{\"25\":25,\"26\":26,\"45\":45}],37:[function(require,module,exports){\n'use strict';\n\nvar defaults = require(25);\nvar Element = require(26);\nvar helpers = require(45);\n\nvar globalDefaults = defaults.global;\n\ndefaults._set('global', {\n	elements: {\n		line: {\n			tension: 0.4,\n			backgroundColor: globalDefaults.defaultColor,\n			borderWidth: 3,\n			borderColor: globalDefaults.defaultColor,\n			borderCapStyle: 'butt',\n			borderDash: [],\n			borderDashOffset: 0.0,\n			borderJoinStyle: 'miter',\n			capBezierPoints: true,\n			fill: true, // do we fill in the area between the line and its base axis\n		}\n	}\n});\n\nmodule.exports = Element.extend({\n	draw: function() {\n		var me = this;\n		var vm = me._view;\n		var ctx = me._chart.ctx;\n		var spanGaps = vm.spanGaps;\n		var points = me._children.slice(); // clone array\n		var globalOptionLineElements = globalDefaults.elements.line;\n		var lastDrawnIndex = -1;\n		var index, current, previous, currentVM;\n\n		// If we are looping, adding the first point again\n		if (me._loop && points.length) {\n			points.push(points[0]);\n		}\n\n		ctx.save();\n\n		// Stroke Line Options\n		ctx.lineCap = vm.borderCapStyle || globalOptionLineElements.borderCapStyle;\n\n		// IE 9 and 10 do not support line dash\n		if (ctx.setLineDash) {\n			ctx.setLineDash(vm.borderDash || globalOptionLineElements.borderDash);\n		}\n\n		ctx.lineDashOffset = vm.borderDashOffset || globalOptionLineElements.borderDashOffset;\n		ctx.lineJoin = vm.borderJoinStyle || globalOptionLineElements.borderJoinStyle;\n		ctx.lineWidth = vm.borderWidth || globalOptionLineElements.borderWidth;\n		ctx.strokeStyle = vm.borderColor || globalDefaults.defaultColor;\n\n		// Stroke Line\n		ctx.beginPath();\n		lastDrawnIndex = -1;\n\n		for (index = 0; index < points.length; ++index) {\n			current = points[index];\n			previous = helpers.previousItem(points, index);\n			currentVM = current._view;\n\n			// First point moves to it's starting position no matter what\n			if (index === 0) {\n				if (!currentVM.skip) {\n					ctx.moveTo(currentVM.x, currentVM.y);\n					lastDrawnIndex = index;\n				}\n			} else {\n				previous = lastDrawnIndex === -1 ? previous : points[lastDrawnIndex];\n\n				if (!currentVM.skip) {\n					if ((lastDrawnIndex !== (index - 1) && !spanGaps) || lastDrawnIndex === -1) {\n						// There was a gap and this is the first point after the gap\n						ctx.moveTo(currentVM.x, currentVM.y);\n					} else {\n						// Line to next point\n						helpers.canvas.lineTo(ctx, previous._view, current._view);\n					}\n					lastDrawnIndex = index;\n				}\n			}\n		}\n\n		ctx.stroke();\n		ctx.restore();\n	}\n});\n\n},{\"25\":25,\"26\":26,\"45\":45}],38:[function(require,module,exports){\n'use strict';\n\nvar defaults = require(25);\nvar Element = require(26);\nvar helpers = require(45);\n\nvar defaultColor = defaults.global.defaultColor;\n\ndefaults._set('global', {\n	elements: {\n		point: {\n			radius: 3,\n			pointStyle: 'circle',\n			backgroundColor: defaultColor,\n			borderColor: defaultColor,\n			borderWidth: 1,\n			// Hover\n			hitRadius: 1,\n			hoverRadius: 4,\n			hoverBorderWidth: 1\n		}\n	}\n});\n\nfunction xRange(mouseX) {\n	var vm = this._view;\n	return vm ? (Math.pow(mouseX - vm.x, 2) < Math.pow(vm.radius + vm.hitRadius, 2)) : false;\n}\n\nfunction yRange(mouseY) {\n	var vm = this._view;\n	return vm ? (Math.pow(mouseY - vm.y, 2) < Math.pow(vm.radius + vm.hitRadius, 2)) : false;\n}\n\nmodule.exports = Element.extend({\n	inRange: function(mouseX, mouseY) {\n		var vm = this._view;\n		return vm ? ((Math.pow(mouseX - vm.x, 2) + Math.pow(mouseY - vm.y, 2)) < Math.pow(vm.hitRadius + vm.radius, 2)) : false;\n	},\n\n	inLabelRange: xRange,\n	inXRange: xRange,\n	inYRange: yRange,\n\n	getCenterPoint: function() {\n		var vm = this._view;\n		return {\n			x: vm.x,\n			y: vm.y\n		};\n	},\n\n	getArea: function() {\n		return Math.PI * Math.pow(this._view.radius, 2);\n	},\n\n	tooltipPosition: function() {\n		var vm = this._view;\n		return {\n			x: vm.x,\n			y: vm.y,\n			padding: vm.radius + vm.borderWidth\n		};\n	},\n\n	draw: function(chartArea) {\n		var vm = this._view;\n		var model = this._model;\n		var ctx = this._chart.ctx;\n		var pointStyle = vm.pointStyle;\n		var radius = vm.radius;\n		var x = vm.x;\n		var y = vm.y;\n		var color = helpers.color;\n		var errMargin = 1.01; // 1.01 is margin for Accumulated error. (Especially Edge, IE.)\n		var ratio = 0;\n\n		if (vm.skip) {\n			return;\n		}\n\n		ctx.strokeStyle = vm.borderColor || defaultColor;\n		ctx.lineWidth = helpers.valueOrDefault(vm.borderWidth, defaults.global.elements.point.borderWidth);\n		ctx.fillStyle = vm.backgroundColor || defaultColor;\n\n		// Cliping for Points.\n		// going out from inner charArea?\n		if ((chartArea !== undefined) && ((model.x < chartArea.left) || (chartArea.right * errMargin < model.x) || (model.y < chartArea.top) || (chartArea.bottom * errMargin < model.y))) {\n			// Point fade out\n			if (model.x < chartArea.left) {\n				ratio = (x - model.x) / (chartArea.left - model.x);\n			} else if (chartArea.right * errMargin < model.x) {\n				ratio = (model.x - x) / (model.x - chartArea.right);\n			} else if (model.y < chartArea.top) {\n				ratio = (y - model.y) / (chartArea.top - model.y);\n			} else if (chartArea.bottom * errMargin < model.y) {\n				ratio = (model.y - y) / (model.y - chartArea.bottom);\n			}\n			ratio = Math.round(ratio * 100) / 100;\n			ctx.strokeStyle = color(ctx.strokeStyle).alpha(ratio).rgbString();\n			ctx.fillStyle = color(ctx.fillStyle).alpha(ratio).rgbString();\n		}\n\n		helpers.canvas.drawPoint(ctx, pointStyle, radius, x, y);\n	}\n});\n\n},{\"25\":25,\"26\":26,\"45\":45}],39:[function(require,module,exports){\n'use strict';\n\nvar defaults = require(25);\nvar Element = require(26);\n\ndefaults._set('global', {\n	elements: {\n		rectangle: {\n			backgroundColor: defaults.global.defaultColor,\n			borderColor: defaults.global.defaultColor,\n			borderSkipped: 'bottom',\n			borderWidth: 0\n		}\n	}\n});\n\nfunction isVertical(bar) {\n	return bar._view.width !== undefined;\n}\n\n/**\n * Helper function to get the bounds of the bar regardless of the orientation\n * @param bar {Chart.Element.Rectangle} the bar\n * @return {Bounds} bounds of the bar\n * @private\n */\nfunction getBarBounds(bar) {\n	var vm = bar._view;\n	var x1, x2, y1, y2;\n\n	if (isVertical(bar)) {\n		// vertical\n		var halfWidth = vm.width / 2;\n		x1 = vm.x - halfWidth;\n		x2 = vm.x + halfWidth;\n		y1 = Math.min(vm.y, vm.base);\n		y2 = Math.max(vm.y, vm.base);\n	} else {\n		// horizontal bar\n		var halfHeight = vm.height / 2;\n		x1 = Math.min(vm.x, vm.base);\n		x2 = Math.max(vm.x, vm.base);\n		y1 = vm.y - halfHeight;\n		y2 = vm.y + halfHeight;\n	}\n\n	return {\n		left: x1,\n		top: y1,\n		right: x2,\n		bottom: y2\n	};\n}\n\nmodule.exports = Element.extend({\n	draw: function() {\n		var ctx = this._chart.ctx;\n		var vm = this._view;\n		var left, right, top, bottom, signX, signY, borderSkipped;\n		var borderWidth = vm.borderWidth;\n\n		if (!vm.horizontal) {\n			// bar\n			left = vm.x - vm.width / 2;\n			right = vm.x + vm.width / 2;\n			top = vm.y;\n			bottom = vm.base;\n			signX = 1;\n			signY = bottom > top ? 1 : -1;\n			borderSkipped = vm.borderSkipped || 'bottom';\n		} else {\n			// horizontal bar\n			left = vm.base;\n			right = vm.x;\n			top = vm.y - vm.height / 2;\n			bottom = vm.y + vm.height / 2;\n			signX = right > left ? 1 : -1;\n			signY = 1;\n			borderSkipped = vm.borderSkipped || 'left';\n		}\n\n		// Canvas doesn't allow us to stroke inside the width so we can\n		// adjust the sizes to fit if we're setting a stroke on the line\n		if (borderWidth) {\n			// borderWidth shold be less than bar width and bar height.\n			var barSize = Math.min(Math.abs(left - right), Math.abs(top - bottom));\n			borderWidth = borderWidth > barSize ? barSize : borderWidth;\n			var halfStroke = borderWidth / 2;\n			// Adjust borderWidth when bar top position is near vm.base(zero).\n			var borderLeft = left + (borderSkipped !== 'left' ? halfStroke * signX : 0);\n			var borderRight = right + (borderSkipped !== 'right' ? -halfStroke * signX : 0);\n			var borderTop = top + (borderSkipped !== 'top' ? halfStroke * signY : 0);\n			var borderBottom = bottom + (borderSkipped !== 'bottom' ? -halfStroke * signY : 0);\n			// not become a vertical line?\n			if (borderLeft !== borderRight) {\n				top = borderTop;\n				bottom = borderBottom;\n			}\n			// not become a horizontal line?\n			if (borderTop !== borderBottom) {\n				left = borderLeft;\n				right = borderRight;\n			}\n		}\n\n		ctx.beginPath();\n		ctx.fillStyle = vm.backgroundColor;\n		ctx.strokeStyle = vm.borderColor;\n		ctx.lineWidth = borderWidth;\n\n		// Corner points, from bottom-left to bottom-right clockwise\n		// | 1 2 |\n		// | 0 3 |\n		var corners = [\n			[left, bottom],\n			[left, top],\n			[right, top],\n			[right, bottom]\n		];\n\n		// Find first (starting) corner with fallback to 'bottom'\n		var borders = ['bottom', 'left', 'top', 'right'];\n		var startCorner = borders.indexOf(borderSkipped, 0);\n		if (startCorner === -1) {\n			startCorner = 0;\n		}\n\n		function cornerAt(index) {\n			return corners[(startCorner + index) % 4];\n		}\n\n		// Draw rectangle from 'startCorner'\n		var corner = cornerAt(0);\n		ctx.moveTo(corner[0], corner[1]);\n\n		for (var i = 1; i < 4; i++) {\n			corner = cornerAt(i);\n			ctx.lineTo(corner[0], corner[1]);\n		}\n\n		ctx.fill();\n		if (borderWidth) {\n			ctx.stroke();\n		}\n	},\n\n	height: function() {\n		var vm = this._view;\n		return vm.base - vm.y;\n	},\n\n	inRange: function(mouseX, mouseY) {\n		var inRange = false;\n\n		if (this._view) {\n			var bounds = getBarBounds(this);\n			inRange = mouseX >= bounds.left && mouseX <= bounds.right && mouseY >= bounds.top && mouseY <= bounds.bottom;\n		}\n\n		return inRange;\n	},\n\n	inLabelRange: function(mouseX, mouseY) {\n		var me = this;\n		if (!me._view) {\n			return false;\n		}\n\n		var inRange = false;\n		var bounds = getBarBounds(me);\n\n		if (isVertical(me)) {\n			inRange = mouseX >= bounds.left && mouseX <= bounds.right;\n		} else {\n			inRange = mouseY >= bounds.top && mouseY <= bounds.bottom;\n		}\n\n		return inRange;\n	},\n\n	inXRange: function(mouseX) {\n		var bounds = getBarBounds(this);\n		return mouseX >= bounds.left && mouseX <= bounds.right;\n	},\n\n	inYRange: function(mouseY) {\n		var bounds = getBarBounds(this);\n		return mouseY >= bounds.top && mouseY <= bounds.bottom;\n	},\n\n	getCenterPoint: function() {\n		var vm = this._view;\n		var x, y;\n		if (isVertical(this)) {\n			x = vm.x;\n			y = (vm.y + vm.base) / 2;\n		} else {\n			x = (vm.x + vm.base) / 2;\n			y = vm.y;\n		}\n\n		return {x: x, y: y};\n	},\n\n	getArea: function() {\n		var vm = this._view;\n		return vm.width * Math.abs(vm.y - vm.base);\n	},\n\n	tooltipPosition: function() {\n		var vm = this._view;\n		return {\n			x: vm.x,\n			y: vm.y\n		};\n	}\n});\n\n},{\"25\":25,\"26\":26}],40:[function(require,module,exports){\n'use strict';\n\nmodule.exports = {};\nmodule.exports.Arc = require(36);\nmodule.exports.Line = require(37);\nmodule.exports.Point = require(38);\nmodule.exports.Rectangle = require(39);\n\n},{\"36\":36,\"37\":37,\"38\":38,\"39\":39}],41:[function(require,module,exports){\n'use strict';\n\nvar helpers = require(42);\n\n/**\n * @namespace Chart.helpers.canvas\n */\nvar exports = module.exports = {\n	/**\n	 * Clears the entire canvas associated to the given `chart`.\n	 * @param {Chart} chart - The chart for which to clear the canvas.\n	 */\n	clear: function(chart) {\n		chart.ctx.clearRect(0, 0, chart.width, chart.height);\n	},\n\n	/**\n	 * Creates a \"path\" for a rectangle with rounded corners at position (x, y) with a\n	 * given size (width, height) and the same `radius` for all corners.\n	 * @param {CanvasRenderingContext2D} ctx - The canvas 2D Context.\n	 * @param {Number} x - The x axis of the coordinate for the rectangle starting point.\n	 * @param {Number} y - The y axis of the coordinate for the rectangle starting point.\n	 * @param {Number} width - The rectangle's width.\n	 * @param {Number} height - The rectangle's height.\n	 * @param {Number} radius - The rounded amount (in pixels) for the four corners.\n	 * @todo handle `radius` as top-left, top-right, bottom-right, bottom-left array/object?\n	 */\n	roundedRect: function(ctx, x, y, width, height, radius) {\n		if (radius) {\n			var rx = Math.min(radius, width / 2);\n			var ry = Math.min(radius, height / 2);\n\n			ctx.moveTo(x + rx, y);\n			ctx.lineTo(x + width - rx, y);\n			ctx.quadraticCurveTo(x + width, y, x + width, y + ry);\n			ctx.lineTo(x + width, y + height - ry);\n			ctx.quadraticCurveTo(x + width, y + height, x + width - rx, y + height);\n			ctx.lineTo(x + rx, y + height);\n			ctx.quadraticCurveTo(x, y + height, x, y + height - ry);\n			ctx.lineTo(x, y + ry);\n			ctx.quadraticCurveTo(x, y, x + rx, y);\n		} else {\n			ctx.rect(x, y, width, height);\n		}\n	},\n\n	drawPoint: function(ctx, style, radius, x, y) {\n		var type, edgeLength, xOffset, yOffset, height, size;\n\n		if (style && typeof style === 'object') {\n			type = style.toString();\n			if (type === '[object HTMLImageElement]' || type === '[object HTMLCanvasElement]') {\n				ctx.drawImage(style, x - style.width / 2, y - style.height / 2, style.width, style.height);\n				return;\n			}\n		}\n\n		if (isNaN(radius) || radius <= 0) {\n			return;\n		}\n\n		switch (style) {\n		// Default includes circle\n		default:\n			ctx.beginPath();\n			ctx.arc(x, y, radius, 0, Math.PI * 2);\n			ctx.closePath();\n			ctx.fill();\n			break;\n		case 'triangle':\n			ctx.beginPath();\n			edgeLength = 3 * radius / Math.sqrt(3);\n			height = edgeLength * Math.sqrt(3) / 2;\n			ctx.moveTo(x - edgeLength / 2, y + height / 3);\n			ctx.lineTo(x + edgeLength / 2, y + height / 3);\n			ctx.lineTo(x, y - 2 * height / 3);\n			ctx.closePath();\n			ctx.fill();\n			break;\n		case 'rect':\n			size = 1 / Math.SQRT2 * radius;\n			ctx.beginPath();\n			ctx.fillRect(x - size, y - size, 2 * size, 2 * size);\n			ctx.strokeRect(x - size, y - size, 2 * size, 2 * size);\n			break;\n		case 'rectRounded':\n			var offset = radius / Math.SQRT2;\n			var leftX = x - offset;\n			var topY = y - offset;\n			var sideSize = Math.SQRT2 * radius;\n			ctx.beginPath();\n			this.roundedRect(ctx, leftX, topY, sideSize, sideSize, radius / 2);\n			ctx.closePath();\n			ctx.fill();\n			break;\n		case 'rectRot':\n			size = 1 / Math.SQRT2 * radius;\n			ctx.beginPath();\n			ctx.moveTo(x - size, y);\n			ctx.lineTo(x, y + size);\n			ctx.lineTo(x + size, y);\n			ctx.lineTo(x, y - size);\n			ctx.closePath();\n			ctx.fill();\n			break;\n		case 'cross':\n			ctx.beginPath();\n			ctx.moveTo(x, y + radius);\n			ctx.lineTo(x, y - radius);\n			ctx.moveTo(x - radius, y);\n			ctx.lineTo(x + radius, y);\n			ctx.closePath();\n			break;\n		case 'crossRot':\n			ctx.beginPath();\n			xOffset = Math.cos(Math.PI / 4) * radius;\n			yOffset = Math.sin(Math.PI / 4) * radius;\n			ctx.moveTo(x - xOffset, y - yOffset);\n			ctx.lineTo(x + xOffset, y + yOffset);\n			ctx.moveTo(x - xOffset, y + yOffset);\n			ctx.lineTo(x + xOffset, y - yOffset);\n			ctx.closePath();\n			break;\n		case 'star':\n			ctx.beginPath();\n			ctx.moveTo(x, y + radius);\n			ctx.lineTo(x, y - radius);\n			ctx.moveTo(x - radius, y);\n			ctx.lineTo(x + radius, y);\n			xOffset = Math.cos(Math.PI / 4) * radius;\n			yOffset = Math.sin(Math.PI / 4) * radius;\n			ctx.moveTo(x - xOffset, y - yOffset);\n			ctx.lineTo(x + xOffset, y + yOffset);\n			ctx.moveTo(x - xOffset, y + yOffset);\n			ctx.lineTo(x + xOffset, y - yOffset);\n			ctx.closePath();\n			break;\n		case 'line':\n			ctx.beginPath();\n			ctx.moveTo(x - radius, y);\n			ctx.lineTo(x + radius, y);\n			ctx.closePath();\n			break;\n		case 'dash':\n			ctx.beginPath();\n			ctx.moveTo(x, y);\n			ctx.lineTo(x + radius, y);\n			ctx.closePath();\n			break;\n		}\n\n		ctx.stroke();\n	},\n\n	clipArea: function(ctx, area) {\n		ctx.save();\n		ctx.beginPath();\n		ctx.rect(area.left, area.top, area.right - area.left, area.bottom - area.top);\n		ctx.clip();\n	},\n\n	unclipArea: function(ctx) {\n		ctx.restore();\n	},\n\n	lineTo: function(ctx, previous, target, flip) {\n		if (target.steppedLine) {\n			if ((target.steppedLine === 'after' && !flip) || (target.steppedLine !== 'after' && flip)) {\n				ctx.lineTo(previous.x, target.y);\n			} else {\n				ctx.lineTo(target.x, previous.y);\n			}\n			ctx.lineTo(target.x, target.y);\n			return;\n		}\n\n		if (!target.tension) {\n			ctx.lineTo(target.x, target.y);\n			return;\n		}\n\n		ctx.bezierCurveTo(\n			flip ? previous.controlPointPreviousX : previous.controlPointNextX,\n			flip ? previous.controlPointPreviousY : previous.controlPointNextY,\n			flip ? target.controlPointNextX : target.controlPointPreviousX,\n			flip ? target.controlPointNextY : target.controlPointPreviousY,\n			target.x,\n			target.y);\n	}\n};\n\n// DEPRECATIONS\n\n/**\n * Provided for backward compatibility, use Chart.helpers.canvas.clear instead.\n * @namespace Chart.helpers.clear\n * @deprecated since version 2.7.0\n * @todo remove at version 3\n * @private\n */\nhelpers.clear = exports.clear;\n\n/**\n * Provided for backward compatibility, use Chart.helpers.canvas.roundedRect instead.\n * @namespace Chart.helpers.drawRoundedRectangle\n * @deprecated since version 2.7.0\n * @todo remove at version 3\n * @private\n */\nhelpers.drawRoundedRectangle = function(ctx) {\n	ctx.beginPath();\n	exports.roundedRect.apply(exports, arguments);\n	ctx.closePath();\n};\n\n},{\"42\":42}],42:[function(require,module,exports){\n'use strict';\n\n/**\n * @namespace Chart.helpers\n */\nvar helpers = {\n	/**\n	 * An empty function that can be used, for example, for optional callback.\n	 */\n	noop: function() {},\n\n	/**\n	 * Returns a unique id, sequentially generated from a global variable.\n	 * @returns {Number}\n	 * @function\n	 */\n	uid: (function() {\n		var id = 0;\n		return function() {\n			return id++;\n		};\n	}()),\n\n	/**\n	 * Returns true if `value` is neither null nor undefined, else returns false.\n	 * @param {*} value - The value to test.\n	 * @returns {Boolean}\n	 * @since 2.7.0\n	 */\n	isNullOrUndef: function(value) {\n		return value === null || typeof value === 'undefined';\n	},\n\n	/**\n	 * Returns true if `value` is an array, else returns false.\n	 * @param {*} value - The value to test.\n	 * @returns {Boolean}\n	 * @function\n	 */\n	isArray: Array.isArray ? Array.isArray : function(value) {\n		return Object.prototype.toString.call(value) === '[object Array]';\n	},\n\n	/**\n	 * Returns true if `value` is an object (excluding null), else returns false.\n	 * @param {*} value - The value to test.\n	 * @returns {Boolean}\n	 * @since 2.7.0\n	 */\n	isObject: function(value) {\n		return value !== null && Object.prototype.toString.call(value) === '[object Object]';\n	},\n\n	/**\n	 * Returns `value` if defined, else returns `defaultValue`.\n	 * @param {*} value - The value to return if defined.\n	 * @param {*} defaultValue - The value to return if `value` is undefined.\n	 * @returns {*}\n	 */\n	valueOrDefault: function(value, defaultValue) {\n		return typeof value === 'undefined' ? defaultValue : value;\n	},\n\n	/**\n	 * Returns value at the given `index` in array if defined, else returns `defaultValue`.\n	 * @param {Array} value - The array to lookup for value at `index`.\n	 * @param {Number} index - The index in `value` to lookup for value.\n	 * @param {*} defaultValue - The value to return if `value[index]` is undefined.\n	 * @returns {*}\n	 */\n	valueAtIndexOrDefault: function(value, index, defaultValue) {\n		return helpers.valueOrDefault(helpers.isArray(value) ? value[index] : value, defaultValue);\n	},\n\n	/**\n	 * Calls `fn` with the given `args` in the scope defined by `thisArg` and returns the\n	 * value returned by `fn`. If `fn` is not a function, this method returns undefined.\n	 * @param {Function} fn - The function to call.\n	 * @param {Array|undefined|null} args - The arguments with which `fn` should be called.\n	 * @param {Object} [thisArg] - The value of `this` provided for the call to `fn`.\n	 * @returns {*}\n	 */\n	callback: function(fn, args, thisArg) {\n		if (fn && typeof fn.call === 'function') {\n			return fn.apply(thisArg, args);\n		}\n	},\n\n	/**\n	 * Note(SB) for performance sake, this method should only be used when loopable type\n	 * is unknown or in none intensive code (not called often and small loopable). Else\n	 * it's preferable to use a regular for() loop and save extra function calls.\n	 * @param {Object|Array} loopable - The object or array to be iterated.\n	 * @param {Function} fn - The function to call for each item.\n	 * @param {Object} [thisArg] - The value of `this` provided for the call to `fn`.\n	 * @param {Boolean} [reverse] - If true, iterates backward on the loopable.\n	 */\n	each: function(loopable, fn, thisArg, reverse) {\n		var i, len, keys;\n		if (helpers.isArray(loopable)) {\n			len = loopable.length;\n			if (reverse) {\n				for (i = len - 1; i >= 0; i--) {\n					fn.call(thisArg, loopable[i], i);\n				}\n			} else {\n				for (i = 0; i < len; i++) {\n					fn.call(thisArg, loopable[i], i);\n				}\n			}\n		} else if (helpers.isObject(loopable)) {\n			keys = Object.keys(loopable);\n			len = keys.length;\n			for (i = 0; i < len; i++) {\n				fn.call(thisArg, loopable[keys[i]], keys[i]);\n			}\n		}\n	},\n\n	/**\n	 * Returns true if the `a0` and `a1` arrays have the same content, else returns false.\n	 * @see http://stackoverflow.com/a/14853974\n	 * @param {Array} a0 - The array to compare\n	 * @param {Array} a1 - The array to compare\n	 * @returns {Boolean}\n	 */\n	arrayEquals: function(a0, a1) {\n		var i, ilen, v0, v1;\n\n		if (!a0 || !a1 || a0.length !== a1.length) {\n			return false;\n		}\n\n		for (i = 0, ilen = a0.length; i < ilen; ++i) {\n			v0 = a0[i];\n			v1 = a1[i];\n\n			if (v0 instanceof Array && v1 instanceof Array) {\n				if (!helpers.arrayEquals(v0, v1)) {\n					return false;\n				}\n			} else if (v0 !== v1) {\n				// NOTE: two different object instances will never be equal: {x:20} != {x:20}\n				return false;\n			}\n		}\n\n		return true;\n	},\n\n	/**\n	 * Returns a deep copy of `source` without keeping references on objects and arrays.\n	 * @param {*} source - The value to clone.\n	 * @returns {*}\n	 */\n	clone: function(source) {\n		if (helpers.isArray(source)) {\n			return source.map(helpers.clone);\n		}\n\n		if (helpers.isObject(source)) {\n			var target = {};\n			var keys = Object.keys(source);\n			var klen = keys.length;\n			var k = 0;\n\n			for (; k < klen; ++k) {\n				target[keys[k]] = helpers.clone(source[keys[k]]);\n			}\n\n			return target;\n		}\n\n		return source;\n	},\n\n	/**\n	 * The default merger when Chart.helpers.merge is called without merger option.\n	 * Note(SB): this method is also used by configMerge and scaleMerge as fallback.\n	 * @private\n	 */\n	_merger: function(key, target, source, options) {\n		var tval = target[key];\n		var sval = source[key];\n\n		if (helpers.isObject(tval) && helpers.isObject(sval)) {\n			helpers.merge(tval, sval, options);\n		} else {\n			target[key] = helpers.clone(sval);\n		}\n	},\n\n	/**\n	 * Merges source[key] in target[key] only if target[key] is undefined.\n	 * @private\n	 */\n	_mergerIf: function(key, target, source) {\n		var tval = target[key];\n		var sval = source[key];\n\n		if (helpers.isObject(tval) && helpers.isObject(sval)) {\n			helpers.mergeIf(tval, sval);\n		} else if (!target.hasOwnProperty(key)) {\n			target[key] = helpers.clone(sval);\n		}\n	},\n\n	/**\n	 * Recursively deep copies `source` properties into `target` with the given `options`.\n	 * IMPORTANT: `target` is not cloned and will be updated with `source` properties.\n	 * @param {Object} target - The target object in which all sources are merged into.\n	 * @param {Object|Array(Object)} source - Object(s) to merge into `target`.\n	 * @param {Object} [options] - Merging options:\n	 * @param {Function} [options.merger] - The merge method (key, target, source, options)\n	 * @returns {Object} The `target` object.\n	 */\n	merge: function(target, source, options) {\n		var sources = helpers.isArray(source) ? source : [source];\n		var ilen = sources.length;\n		var merge, i, keys, klen, k;\n\n		if (!helpers.isObject(target)) {\n			return target;\n		}\n\n		options = options || {};\n		merge = options.merger || helpers._merger;\n\n		for (i = 0; i < ilen; ++i) {\n			source = sources[i];\n			if (!helpers.isObject(source)) {\n				continue;\n			}\n\n			keys = Object.keys(source);\n			for (k = 0, klen = keys.length; k < klen; ++k) {\n				merge(keys[k], target, source, options);\n			}\n		}\n\n		return target;\n	},\n\n	/**\n	 * Recursively deep copies `source` properties into `target` *only* if not defined in target.\n	 * IMPORTANT: `target` is not cloned and will be updated with `source` properties.\n	 * @param {Object} target - The target object in which all sources are merged into.\n	 * @param {Object|Array(Object)} source - Object(s) to merge into `target`.\n	 * @returns {Object} The `target` object.\n	 */\n	mergeIf: function(target, source) {\n		return helpers.merge(target, source, {merger: helpers._mergerIf});\n	},\n\n	/**\n	 * Applies the contents of two or more objects together into the first object.\n	 * @param {Object} target - The target object in which all objects are merged into.\n	 * @param {Object} arg1 - Object containing additional properties to merge in target.\n	 * @param {Object} argN - Additional objects containing properties to merge in target.\n	 * @returns {Object} The `target` object.\n	 */\n	extend: function(target) {\n		var setFn = function(value, key) {\n			target[key] = value;\n		};\n		for (var i = 1, ilen = arguments.length; i < ilen; ++i) {\n			helpers.each(arguments[i], setFn);\n		}\n		return target;\n	},\n\n	/**\n	 * Basic javascript inheritance based on the model created in Backbone.js\n	 */\n	inherits: function(extensions) {\n		var me = this;\n		var ChartElement = (extensions && extensions.hasOwnProperty('constructor')) ? extensions.constructor : function() {\n			return me.apply(this, arguments);\n		};\n\n		var Surrogate = function() {\n			this.constructor = ChartElement;\n		};\n\n		Surrogate.prototype = me.prototype;\n		ChartElement.prototype = new Surrogate();\n		ChartElement.extend = helpers.inherits;\n\n		if (extensions) {\n			helpers.extend(ChartElement.prototype, extensions);\n		}\n\n		ChartElement.__super__ = me.prototype;\n		return ChartElement;\n	}\n};\n\nmodule.exports = helpers;\n\n// DEPRECATIONS\n\n/**\n * Provided for backward compatibility, use Chart.helpers.callback instead.\n * @function Chart.helpers.callCallback\n * @deprecated since version 2.6.0\n * @todo remove at version 3\n * @private\n */\nhelpers.callCallback = helpers.callback;\n\n/**\n * Provided for backward compatibility, use Array.prototype.indexOf instead.\n * Array.prototype.indexOf compatibility: Chrome, Opera, Safari, FF1.5+, IE9+\n * @function Chart.helpers.indexOf\n * @deprecated since version 2.7.0\n * @todo remove at version 3\n * @private\n */\nhelpers.indexOf = function(array, item, fromIndex) {\n	return Array.prototype.indexOf.call(array, item, fromIndex);\n};\n\n/**\n * Provided for backward compatibility, use Chart.helpers.valueOrDefault instead.\n * @function Chart.helpers.getValueOrDefault\n * @deprecated since version 2.7.0\n * @todo remove at version 3\n * @private\n */\nhelpers.getValueOrDefault = helpers.valueOrDefault;\n\n/**\n * Provided for backward compatibility, use Chart.helpers.valueAtIndexOrDefault instead.\n * @function Chart.helpers.getValueAtIndexOrDefault\n * @deprecated since version 2.7.0\n * @todo remove at version 3\n * @private\n */\nhelpers.getValueAtIndexOrDefault = helpers.valueAtIndexOrDefault;\n\n},{}],43:[function(require,module,exports){\n'use strict';\n\nvar helpers = require(42);\n\n/**\n * Easing functions adapted from Robert Penner's easing equations.\n * @namespace Chart.helpers.easingEffects\n * @see http://www.robertpenner.com/easing/\n */\nvar effects = {\n	linear: function(t) {\n		return t;\n	},\n\n	easeInQuad: function(t) {\n		return t * t;\n	},\n\n	easeOutQuad: function(t) {\n		return -t * (t - 2);\n	},\n\n	easeInOutQuad: function(t) {\n		if ((t /= 0.5) < 1) {\n			return 0.5 * t * t;\n		}\n		return -0.5 * ((--t) * (t - 2) - 1);\n	},\n\n	easeInCubic: function(t) {\n		return t * t * t;\n	},\n\n	easeOutCubic: function(t) {\n		return (t = t - 1) * t * t + 1;\n	},\n\n	easeInOutCubic: function(t) {\n		if ((t /= 0.5) < 1) {\n			return 0.5 * t * t * t;\n		}\n		return 0.5 * ((t -= 2) * t * t + 2);\n	},\n\n	easeInQuart: function(t) {\n		return t * t * t * t;\n	},\n\n	easeOutQuart: function(t) {\n		return -((t = t - 1) * t * t * t - 1);\n	},\n\n	easeInOutQuart: function(t) {\n		if ((t /= 0.5) < 1) {\n			return 0.5 * t * t * t * t;\n		}\n		return -0.5 * ((t -= 2) * t * t * t - 2);\n	},\n\n	easeInQuint: function(t) {\n		return t * t * t * t * t;\n	},\n\n	easeOutQuint: function(t) {\n		return (t = t - 1) * t * t * t * t + 1;\n	},\n\n	easeInOutQuint: function(t) {\n		if ((t /= 0.5) < 1) {\n			return 0.5 * t * t * t * t * t;\n		}\n		return 0.5 * ((t -= 2) * t * t * t * t + 2);\n	},\n\n	easeInSine: function(t) {\n		return -Math.cos(t * (Math.PI / 2)) + 1;\n	},\n\n	easeOutSine: function(t) {\n		return Math.sin(t * (Math.PI / 2));\n	},\n\n	easeInOutSine: function(t) {\n		return -0.5 * (Math.cos(Math.PI * t) - 1);\n	},\n\n	easeInExpo: function(t) {\n		return (t === 0) ? 0 : Math.pow(2, 10 * (t - 1));\n	},\n\n	easeOutExpo: function(t) {\n		return (t === 1) ? 1 : -Math.pow(2, -10 * t) + 1;\n	},\n\n	easeInOutExpo: function(t) {\n		if (t === 0) {\n			return 0;\n		}\n		if (t === 1) {\n			return 1;\n		}\n		if ((t /= 0.5) < 1) {\n			return 0.5 * Math.pow(2, 10 * (t - 1));\n		}\n		return 0.5 * (-Math.pow(2, -10 * --t) + 2);\n	},\n\n	easeInCirc: function(t) {\n		if (t >= 1) {\n			return t;\n		}\n		return -(Math.sqrt(1 - t * t) - 1);\n	},\n\n	easeOutCirc: function(t) {\n		return Math.sqrt(1 - (t = t - 1) * t);\n	},\n\n	easeInOutCirc: function(t) {\n		if ((t /= 0.5) < 1) {\n			return -0.5 * (Math.sqrt(1 - t * t) - 1);\n		}\n		return 0.5 * (Math.sqrt(1 - (t -= 2) * t) + 1);\n	},\n\n	easeInElastic: function(t) {\n		var s = 1.70158;\n		var p = 0;\n		var a = 1;\n		if (t === 0) {\n			return 0;\n		}\n		if (t === 1) {\n			return 1;\n		}\n		if (!p) {\n			p = 0.3;\n		}\n		if (a < 1) {\n			a = 1;\n			s = p / 4;\n		} else {\n			s = p / (2 * Math.PI) * Math.asin(1 / a);\n		}\n		return -(a * Math.pow(2, 10 * (t -= 1)) * Math.sin((t - s) * (2 * Math.PI) / p));\n	},\n\n	easeOutElastic: function(t) {\n		var s = 1.70158;\n		var p = 0;\n		var a = 1;\n		if (t === 0) {\n			return 0;\n		}\n		if (t === 1) {\n			return 1;\n		}\n		if (!p) {\n			p = 0.3;\n		}\n		if (a < 1) {\n			a = 1;\n			s = p / 4;\n		} else {\n			s = p / (2 * Math.PI) * Math.asin(1 / a);\n		}\n		return a * Math.pow(2, -10 * t) * Math.sin((t - s) * (2 * Math.PI) / p) + 1;\n	},\n\n	easeInOutElastic: function(t) {\n		var s = 1.70158;\n		var p = 0;\n		var a = 1;\n		if (t === 0) {\n			return 0;\n		}\n		if ((t /= 0.5) === 2) {\n			return 1;\n		}\n		if (!p) {\n			p = 0.45;\n		}\n		if (a < 1) {\n			a = 1;\n			s = p / 4;\n		} else {\n			s = p / (2 * Math.PI) * Math.asin(1 / a);\n		}\n		if (t < 1) {\n			return -0.5 * (a * Math.pow(2, 10 * (t -= 1)) * Math.sin((t - s) * (2 * Math.PI) / p));\n		}\n		return a * Math.pow(2, -10 * (t -= 1)) * Math.sin((t - s) * (2 * Math.PI) / p) * 0.5 + 1;\n	},\n	easeInBack: function(t) {\n		var s = 1.70158;\n		return t * t * ((s + 1) * t - s);\n	},\n\n	easeOutBack: function(t) {\n		var s = 1.70158;\n		return (t = t - 1) * t * ((s + 1) * t + s) + 1;\n	},\n\n	easeInOutBack: function(t) {\n		var s = 1.70158;\n		if ((t /= 0.5) < 1) {\n			return 0.5 * (t * t * (((s *= (1.525)) + 1) * t - s));\n		}\n		return 0.5 * ((t -= 2) * t * (((s *= (1.525)) + 1) * t + s) + 2);\n	},\n\n	easeInBounce: function(t) {\n		return 1 - effects.easeOutBounce(1 - t);\n	},\n\n	easeOutBounce: function(t) {\n		if (t < (1 / 2.75)) {\n			return 7.5625 * t * t;\n		}\n		if (t < (2 / 2.75)) {\n			return 7.5625 * (t -= (1.5 / 2.75)) * t + 0.75;\n		}\n		if (t < (2.5 / 2.75)) {\n			return 7.5625 * (t -= (2.25 / 2.75)) * t + 0.9375;\n		}\n		return 7.5625 * (t -= (2.625 / 2.75)) * t + 0.984375;\n	},\n\n	easeInOutBounce: function(t) {\n		if (t < 0.5) {\n			return effects.easeInBounce(t * 2) * 0.5;\n		}\n		return effects.easeOutBounce(t * 2 - 1) * 0.5 + 0.5;\n	}\n};\n\nmodule.exports = {\n	effects: effects\n};\n\n// DEPRECATIONS\n\n/**\n * Provided for backward compatibility, use Chart.helpers.easing.effects instead.\n * @function Chart.helpers.easingEffects\n * @deprecated since version 2.7.0\n * @todo remove at version 3\n * @private\n */\nhelpers.easingEffects = effects;\n\n},{\"42\":42}],44:[function(require,module,exports){\n'use strict';\n\nvar helpers = require(42);\n\n/**\n * @alias Chart.helpers.options\n * @namespace\n */\nmodule.exports = {\n	/**\n	 * Converts the given line height `value` in pixels for a specific font `size`.\n	 * @param {Number|String} value - The lineHeight to parse (eg. 1.6, '14px', '75%', '1.6em').\n	 * @param {Number} size - The font size (in pixels) used to resolve relative `value`.\n	 * @returns {Number} The effective line height in pixels (size * 1.2 if value is invalid).\n	 * @see https://developer.mozilla.org/en-US/docs/Web/CSS/line-height\n	 * @since 2.7.0\n	 */\n	toLineHeight: function(value, size) {\n		var matches = ('' + value).match(/^(normal|(\\d+(?:\\.\\d+)?)(px|em|%)?)$/);\n		if (!matches || matches[1] === 'normal') {\n			return size * 1.2;\n		}\n\n		value = +matches[2];\n\n		switch (matches[3]) {\n		case 'px':\n			return value;\n		case '%':\n			value /= 100;\n			break;\n		default:\n			break;\n		}\n\n		return size * value;\n	},\n\n	/**\n	 * Converts the given value into a padding object with pre-computed width/height.\n	 * @param {Number|Object} value - If a number, set the value to all TRBL component,\n	 *  else, if and object, use defined properties and sets undefined ones to 0.\n	 * @returns {Object} The padding values (top, right, bottom, left, width, height)\n	 * @since 2.7.0\n	 */\n	toPadding: function(value) {\n		var t, r, b, l;\n\n		if (helpers.isObject(value)) {\n			t = +value.top || 0;\n			r = +value.right || 0;\n			b = +value.bottom || 0;\n			l = +value.left || 0;\n		} else {\n			t = r = b = l = +value || 0;\n		}\n\n		return {\n			top: t,\n			right: r,\n			bottom: b,\n			left: l,\n			height: t + b,\n			width: l + r\n		};\n	},\n\n	/**\n	 * Evaluates the given `inputs` sequentially and returns the first defined value.\n	 * @param {Array[]} inputs - An array of values, falling back to the last value.\n	 * @param {Object} [context] - If defined and the current value is a function, the value\n	 * is called with `context` as first argument and the result becomes the new input.\n	 * @param {Number} [index] - If defined and the current value is an array, the value\n	 * at `index` become the new input.\n	 * @since 2.7.0\n	 */\n	resolve: function(inputs, context, index) {\n		var i, ilen, value;\n\n		for (i = 0, ilen = inputs.length; i < ilen; ++i) {\n			value = inputs[i];\n			if (value === undefined) {\n				continue;\n			}\n			if (context !== undefined && typeof value === 'function') {\n				value = value(context);\n			}\n			if (index !== undefined && helpers.isArray(value)) {\n				value = value[index];\n			}\n			if (value !== undefined) {\n				return value;\n			}\n		}\n	}\n};\n\n},{\"42\":42}],45:[function(require,module,exports){\n'use strict';\n\nmodule.exports = require(42);\nmodule.exports.easing = require(43);\nmodule.exports.canvas = require(41);\nmodule.exports.options = require(44);\n\n},{\"41\":41,\"42\":42,\"43\":43,\"44\":44}],46:[function(require,module,exports){\n/**\n * Platform fallback implementation (minimal).\n * @see https://github.com/chartjs/Chart.js/pull/4591#issuecomment-319575939\n */\n\nmodule.exports = {\n	acquireContext: function(item) {\n		if (item && item.canvas) {\n			// Support for any object associated to a canvas (including a context2d)\n			item = item.canvas;\n		}\n\n		return item && item.getContext('2d') || null;\n	}\n};\n\n},{}],47:[function(require,module,exports){\n/**\n * Chart.Platform implementation for targeting a web browser\n */\n\n'use strict';\n\nvar helpers = require(45);\n\nvar EXPANDO_KEY = '$chartjs';\nvar CSS_PREFIX = 'chartjs-';\nvar CSS_RENDER_MONITOR = CSS_PREFIX + 'render-monitor';\nvar CSS_RENDER_ANIMATION = CSS_PREFIX + 'render-animation';\nvar ANIMATION_START_EVENTS = ['animationstart', 'webkitAnimationStart'];\n\n/**\n * DOM event types -> Chart.js event types.\n * Note: only events with different types are mapped.\n * @see https://developer.mozilla.org/en-US/docs/Web/Events\n */\nvar EVENT_TYPES = {\n	touchstart: 'mousedown',\n	touchmove: 'mousemove',\n	touchend: 'mouseup',\n	pointerenter: 'mouseenter',\n	pointerdown: 'mousedown',\n	pointermove: 'mousemove',\n	pointerup: 'mouseup',\n	pointerleave: 'mouseout',\n	pointerout: 'mouseout'\n};\n\n/**\n * The \"used\" size is the final value of a dimension property after all calculations have\n * been performed. This method uses the computed style of `element` but returns undefined\n * if the computed style is not expressed in pixels. That can happen in some cases where\n * `element` has a size relative to its parent and this last one is not yet displayed,\n * for example because of `display: none` on a parent node.\n * @see https://developer.mozilla.org/en-US/docs/Web/CSS/used_value\n * @returns {Number} Size in pixels or undefined if unknown.\n */\nfunction readUsedSize(element, property) {\n	var value = helpers.getStyle(element, property);\n	var matches = value && value.match(/^(\\d+)(\\.\\d+)?px$/);\n	return matches ? Number(matches[1]) : undefined;\n}\n\n/**\n * Initializes the canvas style and render size without modifying the canvas display size,\n * since responsiveness is handled by the controller.resize() method. The config is used\n * to determine the aspect ratio to apply in case no explicit height has been specified.\n */\nfunction initCanvas(canvas, config) {\n	var style = canvas.style;\n\n	// NOTE(SB) canvas.getAttribute('width') !== canvas.width: in the first case it\n	// returns null or '' if no explicit value has been set to the canvas attribute.\n	var renderHeight = canvas.getAttribute('height');\n	var renderWidth = canvas.getAttribute('width');\n\n	// Chart.js modifies some canvas values that we want to restore on destroy\n	canvas[EXPANDO_KEY] = {\n		initial: {\n			height: renderHeight,\n			width: renderWidth,\n			style: {\n				display: style.display,\n				height: style.height,\n				width: style.width\n			}\n		}\n	};\n\n	// Force canvas to display as block to avoid extra space caused by inline\n	// elements, which would interfere with the responsive resize process.\n	// https://github.com/chartjs/Chart.js/issues/2538\n	style.display = style.display || 'block';\n\n	if (renderWidth === null || renderWidth === '') {\n		var displayWidth = readUsedSize(canvas, 'width');\n		if (displayWidth !== undefined) {\n			canvas.width = displayWidth;\n		}\n	}\n\n	if (renderHeight === null || renderHeight === '') {\n		if (canvas.style.height === '') {\n			// If no explicit render height and style height, let's apply the aspect ratio,\n			// which one can be specified by the user but also by charts as default option\n			// (i.e. options.aspectRatio). If not specified, use canvas aspect ratio of 2.\n			canvas.height = canvas.width / (config.options.aspectRatio || 2);\n		} else {\n			var displayHeight = readUsedSize(canvas, 'height');\n			if (displayWidth !== undefined) {\n				canvas.height = displayHeight;\n			}\n		}\n	}\n\n	return canvas;\n}\n\n/**\n * Detects support for options object argument in addEventListener.\n * https://developer.mozilla.org/en-US/docs/Web/API/EventTarget/addEventListener#Safely_detecting_option_support\n * @private\n */\nvar supportsEventListenerOptions = (function() {\n	var supports = false;\n	try {\n		var options = Object.defineProperty({}, 'passive', {\n			get: function() {\n				supports = true;\n			}\n		});\n		window.addEventListener('e', null, options);\n	} catch (e) {\n		// continue regardless of error\n	}\n	return supports;\n}());\n\n// Default passive to true as expected by Chrome for 'touchstart' and 'touchend' events.\n// https://github.com/chartjs/Chart.js/issues/4287\nvar eventListenerOptions = supportsEventListenerOptions ? {passive: true} : false;\n\nfunction addEventListener(node, type, listener) {\n	node.addEventListener(type, listener, eventListenerOptions);\n}\n\nfunction removeEventListener(node, type, listener) {\n	node.removeEventListener(type, listener, eventListenerOptions);\n}\n\nfunction createEvent(type, chart, x, y, nativeEvent) {\n	return {\n		type: type,\n		chart: chart,\n		native: nativeEvent || null,\n		x: x !== undefined ? x : null,\n		y: y !== undefined ? y : null,\n	};\n}\n\nfunction fromNativeEvent(event, chart) {\n	var type = EVENT_TYPES[event.type] || event.type;\n	var pos = helpers.getRelativePosition(event, chart);\n	return createEvent(type, chart, pos.x, pos.y, event);\n}\n\nfunction throttled(fn, thisArg) {\n	var ticking = false;\n	var args = [];\n\n	return function() {\n		args = Array.prototype.slice.call(arguments);\n		thisArg = thisArg || this;\n\n		if (!ticking) {\n			ticking = true;\n			helpers.requestAnimFrame.call(window, function() {\n				ticking = false;\n				fn.apply(thisArg, args);\n			});\n		}\n	};\n}\n\n// Implementation based on https://github.com/marcj/css-element-queries\nfunction createResizer(handler) {\n	var resizer = document.createElement('div');\n	var cls = CSS_PREFIX + 'size-monitor';\n	var maxSize = 1000000;\n	var style =\n		'position:absolute;' +\n		'left:0;' +\n		'top:0;' +\n		'right:0;' +\n		'bottom:0;' +\n		'overflow:hidden;' +\n		'pointer-events:none;' +\n		'visibility:hidden;' +\n		'z-index:-1;';\n\n	resizer.style.cssText = style;\n	resizer.className = cls;\n	resizer.innerHTML =\n		'<div class=\"' + cls + '-expand\" style=\"' + style + '\">' +\n			'<div style=\"' +\n				'position:absolute;' +\n				'width:' + maxSize + 'px;' +\n				'height:' + maxSize + 'px;' +\n				'left:0;' +\n				'top:0\">' +\n			'</div>' +\n		'</div>' +\n		'<div class=\"' + cls + '-shrink\" style=\"' + style + '\">' +\n			'<div style=\"' +\n				'position:absolute;' +\n				'width:200%;' +\n				'height:200%;' +\n				'left:0; ' +\n				'top:0\">' +\n			'</div>' +\n		'</div>';\n\n	var expand = resizer.childNodes[0];\n	var shrink = resizer.childNodes[1];\n\n	resizer._reset = function() {\n		expand.scrollLeft = maxSize;\n		expand.scrollTop = maxSize;\n		shrink.scrollLeft = maxSize;\n		shrink.scrollTop = maxSize;\n	};\n	var onScroll = function() {\n		resizer._reset();\n		handler();\n	};\n\n	addEventListener(expand, 'scroll', onScroll.bind(expand, 'expand'));\n	addEventListener(shrink, 'scroll', onScroll.bind(shrink, 'shrink'));\n\n	return resizer;\n}\n\n// https://davidwalsh.name/detect-node-insertion\nfunction watchForRender(node, handler) {\n	var expando = node[EXPANDO_KEY] || (node[EXPANDO_KEY] = {});\n	var proxy = expando.renderProxy = function(e) {\n		if (e.animationName === CSS_RENDER_ANIMATION) {\n			handler();\n		}\n	};\n\n	helpers.each(ANIMATION_START_EVENTS, function(type) {\n		addEventListener(node, type, proxy);\n	});\n\n	// #4737: Chrome might skip the CSS animation when the CSS_RENDER_MONITOR class\n	// is removed then added back immediately (same animation frame?). Accessing the\n	// `offsetParent` property will force a reflow and re-evaluate the CSS animation.\n	// https://gist.github.com/paulirish/5d52fb081b3570c81e3a#box-metrics\n	// https://github.com/chartjs/Chart.js/issues/4737\n	expando.reflow = !!node.offsetParent;\n\n	node.classList.add(CSS_RENDER_MONITOR);\n}\n\nfunction unwatchForRender(node) {\n	var expando = node[EXPANDO_KEY] || {};\n	var proxy = expando.renderProxy;\n\n	if (proxy) {\n		helpers.each(ANIMATION_START_EVENTS, function(type) {\n			removeEventListener(node, type, proxy);\n		});\n\n		delete expando.renderProxy;\n	}\n\n	node.classList.remove(CSS_RENDER_MONITOR);\n}\n\nfunction addResizeListener(node, listener, chart) {\n	var expando = node[EXPANDO_KEY] || (node[EXPANDO_KEY] = {});\n\n	// Let's keep track of this added resizer and thus avoid DOM query when removing it.\n	var resizer = expando.resizer = createResizer(throttled(function() {\n		if (expando.resizer) {\n			return listener(createEvent('resize', chart));\n		}\n	}));\n\n	// The resizer needs to be attached to the node parent, so we first need to be\n	// sure that `node` is attached to the DOM before injecting the resizer element.\n	watchForRender(node, function() {\n		if (expando.resizer) {\n			var container = node.parentNode;\n			if (container && container !== resizer.parentNode) {\n				container.insertBefore(resizer, container.firstChild);\n			}\n\n			// The container size might have changed, let's reset the resizer state.\n			resizer._reset();\n		}\n	});\n}\n\nfunction removeResizeListener(node) {\n	var expando = node[EXPANDO_KEY] || {};\n	var resizer = expando.resizer;\n\n	delete expando.resizer;\n	unwatchForRender(node);\n\n	if (resizer && resizer.parentNode) {\n		resizer.parentNode.removeChild(resizer);\n	}\n}\n\nfunction injectCSS(platform, css) {\n	// http://stackoverflow.com/q/3922139\n	var style = platform._style || document.createElement('style');\n	if (!platform._style) {\n		platform._style = style;\n		css = '/* Chart.js */\\n' + css;\n		style.setAttribute('type', 'text/css');\n		document.getElementsByTagName('head')[0].appendChild(style);\n	}\n\n	style.appendChild(document.createTextNode(css));\n}\n\nmodule.exports = {\n	/**\n	 * This property holds whether this platform is enabled for the current environment.\n	 * Currently used by platform.js to select the proper implementation.\n	 * @private\n	 */\n	_enabled: typeof window !== 'undefined' && typeof document !== 'undefined',\n\n	initialize: function() {\n		var keyframes = 'from{opacity:0.99}to{opacity:1}';\n\n		injectCSS(this,\n			// DOM rendering detection\n			// https://davidwalsh.name/detect-node-insertion\n			'@-webkit-keyframes ' + CSS_RENDER_ANIMATION + '{' + keyframes + '}' +\n			'@keyframes ' + CSS_RENDER_ANIMATION + '{' + keyframes + '}' +\n			'.' + CSS_RENDER_MONITOR + '{' +\n				'-webkit-animation:' + CSS_RENDER_ANIMATION + ' 0.001s;' +\n				'animation:' + CSS_RENDER_ANIMATION + ' 0.001s;' +\n			'}'\n		);\n	},\n\n	acquireContext: function(item, config) {\n		if (typeof item === 'string') {\n			item = document.getElementById(item);\n		} else if (item.length) {\n			// Support for array based queries (such as jQuery)\n			item = item[0];\n		}\n\n		if (item && item.canvas) {\n			// Support for any object associated to a canvas (including a context2d)\n			item = item.canvas;\n		}\n\n		// To prevent canvas fingerprinting, some add-ons undefine the getContext\n		// method, for example: https://github.com/kkapsner/CanvasBlocker\n		// https://github.com/chartjs/Chart.js/issues/2807\n		var context = item && item.getContext && item.getContext('2d');\n\n		// `instanceof HTMLCanvasElement/CanvasRenderingContext2D` fails when the item is\n		// inside an iframe or when running in a protected environment. We could guess the\n		// types from their toString() value but let's keep things flexible and assume it's\n		// a sufficient condition if the item has a context2D which has item as `canvas`.\n		// https://github.com/chartjs/Chart.js/issues/3887\n		// https://github.com/chartjs/Chart.js/issues/4102\n		// https://github.com/chartjs/Chart.js/issues/4152\n		if (context && context.canvas === item) {\n			initCanvas(item, config);\n			return context;\n		}\n\n		return null;\n	},\n\n	releaseContext: function(context) {\n		var canvas = context.canvas;\n		if (!canvas[EXPANDO_KEY]) {\n			return;\n		}\n\n		var initial = canvas[EXPANDO_KEY].initial;\n		['height', 'width'].forEach(function(prop) {\n			var value = initial[prop];\n			if (helpers.isNullOrUndef(value)) {\n				canvas.removeAttribute(prop);\n			} else {\n				canvas.setAttribute(prop, value);\n			}\n		});\n\n		helpers.each(initial.style || {}, function(value, key) {\n			canvas.style[key] = value;\n		});\n\n		// The canvas render size might have been changed (and thus the state stack discarded),\n		// we can't use save() and restore() to restore the initial state. So make sure that at\n		// least the canvas context is reset to the default state by setting the canvas width.\n		// https://www.w3.org/TR/2011/WD-html5-20110525/the-canvas-element.html\n		canvas.width = canvas.width;\n\n		delete canvas[EXPANDO_KEY];\n	},\n\n	addEventListener: function(chart, type, listener) {\n		var canvas = chart.canvas;\n		if (type === 'resize') {\n			// Note: the resize event is not supported on all browsers.\n			addResizeListener(canvas, listener, chart);\n			return;\n		}\n\n		var expando = listener[EXPANDO_KEY] || (listener[EXPANDO_KEY] = {});\n		var proxies = expando.proxies || (expando.proxies = {});\n		var proxy = proxies[chart.id + '_' + type] = function(event) {\n			listener(fromNativeEvent(event, chart));\n		};\n\n		addEventListener(canvas, type, proxy);\n	},\n\n	removeEventListener: function(chart, type, listener) {\n		var canvas = chart.canvas;\n		if (type === 'resize') {\n			// Note: the resize event is not supported on all browsers.\n			removeResizeListener(canvas, listener);\n			return;\n		}\n\n		var expando = listener[EXPANDO_KEY] || {};\n		var proxies = expando.proxies || {};\n		var proxy = proxies[chart.id + '_' + type];\n		if (!proxy) {\n			return;\n		}\n\n		removeEventListener(canvas, type, proxy);\n	}\n};\n\n// DEPRECATIONS\n\n/**\n * Provided for backward compatibility, use EventTarget.addEventListener instead.\n * EventTarget.addEventListener compatibility: Chrome, Opera 7, Safari, FF1.5+, IE9+\n * @see https://developer.mozilla.org/en-US/docs/Web/API/EventTarget/addEventListener\n * @function Chart.helpers.addEvent\n * @deprecated since version 2.7.0\n * @todo remove at version 3\n * @private\n */\nhelpers.addEvent = addEventListener;\n\n/**\n * Provided for backward compatibility, use EventTarget.removeEventListener instead.\n * EventTarget.removeEventListener compatibility: Chrome, Opera 7, Safari, FF1.5+, IE9+\n * @see https://developer.mozilla.org/en-US/docs/Web/API/EventTarget/removeEventListener\n * @function Chart.helpers.removeEvent\n * @deprecated since version 2.7.0\n * @todo remove at version 3\n * @private\n */\nhelpers.removeEvent = removeEventListener;\n\n},{\"45\":45}],48:[function(require,module,exports){\n'use strict';\n\nvar helpers = require(45);\nvar basic = require(46);\nvar dom = require(47);\n\n// @TODO Make possible to select another platform at build time.\nvar implementation = dom._enabled ? dom : basic;\n\n/**\n * @namespace Chart.platform\n * @see https://chartjs.gitbooks.io/proposals/content/Platform.html\n * @since 2.4.0\n */\nmodule.exports = helpers.extend({\n	/**\n	 * @since 2.7.0\n	 */\n	initialize: function() {},\n\n	/**\n	 * Called at chart construction time, returns a context2d instance implementing\n	 * the [W3C Canvas 2D Context API standard]{@link https://www.w3.org/TR/2dcontext/}.\n	 * @param {*} item - The native item from which to acquire context (platform specific)\n	 * @param {Object} options - The chart options\n	 * @returns {CanvasRenderingContext2D} context2d instance\n	 */\n	acquireContext: function() {},\n\n	/**\n	 * Called at chart destruction time, releases any resources associated to the context\n	 * previously returned by the acquireContext() method.\n	 * @param {CanvasRenderingContext2D} context - The context2d instance\n	 * @returns {Boolean} true if the method succeeded, else false\n	 */\n	releaseContext: function() {},\n\n	/**\n	 * Registers the specified listener on the given chart.\n	 * @param {Chart} chart - Chart from which to listen for event\n	 * @param {String} type - The ({@link IEvent}) type to listen for\n	 * @param {Function} listener - Receives a notification (an object that implements\n	 * the {@link IEvent} interface) when an event of the specified type occurs.\n	 */\n	addEventListener: function() {},\n\n	/**\n	 * Removes the specified listener previously registered with addEventListener.\n	 * @param {Chart} chart -Chart from which to remove the listener\n	 * @param {String} type - The ({@link IEvent}) type to remove\n	 * @param {Function} listener - The listener function to remove from the event target.\n	 */\n	removeEventListener: function() {}\n\n}, implementation);\n\n/**\n * @interface IPlatform\n * Allows abstracting platform dependencies away from the chart\n * @borrows Chart.platform.acquireContext as acquireContext\n * @borrows Chart.platform.releaseContext as releaseContext\n * @borrows Chart.platform.addEventListener as addEventListener\n * @borrows Chart.platform.removeEventListener as removeEventListener\n */\n\n/**\n * @interface IEvent\n * @prop {String} type - The event type name, possible values are:\n * 'contextmenu', 'mouseenter', 'mousedown', 'mousemove', 'mouseup', 'mouseout',\n * 'click', 'dblclick', 'keydown', 'keypress', 'keyup' and 'resize'\n * @prop {*} native - The original native event (null for emulated events, e.g. 'resize')\n * @prop {Number} x - The mouse x position, relative to the canvas (null for incompatible events)\n * @prop {Number} y - The mouse y position, relative to the canvas (null for incompatible events)\n */\n\n},{\"45\":45,\"46\":46,\"47\":47}],49:[function(require,module,exports){\n/**\n * Plugin based on discussion from the following Chart.js issues:\n * @see https://github.com/chartjs/Chart.js/issues/2380#issuecomment-279961569\n * @see https://github.com/chartjs/Chart.js/issues/2440#issuecomment-256461897\n */\n\n'use strict';\n\nvar defaults = require(25);\nvar elements = require(40);\nvar helpers = require(45);\n\ndefaults._set('global', {\n	plugins: {\n		filler: {\n			propagate: true\n		}\n	}\n});\n\nmodule.exports = function() {\n\n	var mappers = {\n		dataset: function(source) {\n			var index = source.fill;\n			var chart = source.chart;\n			var meta = chart.getDatasetMeta(index);\n			var visible = meta && chart.isDatasetVisible(index);\n			var points = (visible && meta.dataset._children) || [];\n			var length = points.length || 0;\n\n			return !length ? null : function(point, i) {\n				return (i < length && points[i]._view) || null;\n			};\n		},\n\n		boundary: function(source) {\n			var boundary = source.boundary;\n			var x = boundary ? boundary.x : null;\n			var y = boundary ? boundary.y : null;\n\n			return function(point) {\n				return {\n					x: x === null ? point.x : x,\n					y: y === null ? point.y : y,\n				};\n			};\n		}\n	};\n\n	// @todo if (fill[0] === '#')\n	function decodeFill(el, index, count) {\n		var model = el._model || {};\n		var fill = model.fill;\n		var target;\n\n		if (fill === undefined) {\n			fill = !!model.backgroundColor;\n		}\n\n		if (fill === false || fill === null) {\n			return false;\n		}\n\n		if (fill === true) {\n			return 'origin';\n		}\n\n		target = parseFloat(fill, 10);\n		if (isFinite(target) && Math.floor(target) === target) {\n			if (fill[0] === '-' || fill[0] === '+') {\n				target = index + target;\n			}\n\n			if (target === index || target < 0 || target >= count) {\n				return false;\n			}\n\n			return target;\n		}\n\n		switch (fill) {\n		// compatibility\n		case 'bottom':\n			return 'start';\n		case 'top':\n			return 'end';\n		case 'zero':\n			return 'origin';\n		// supported boundaries\n		case 'origin':\n		case 'start':\n		case 'end':\n			return fill;\n		// invalid fill values\n		default:\n			return false;\n		}\n	}\n\n	function computeBoundary(source) {\n		var model = source.el._model || {};\n		var scale = source.el._scale || {};\n		var fill = source.fill;\n		var target = null;\n		var horizontal;\n\n		if (isFinite(fill)) {\n			return null;\n		}\n\n		// Backward compatibility: until v3, we still need to support boundary values set on\n		// the model (scaleTop, scaleBottom and scaleZero) because some external plugins and\n		// controllers might still use it (e.g. the Smith chart).\n\n		if (fill === 'start') {\n			target = model.scaleBottom === undefined ? scale.bottom : model.scaleBottom;\n		} else if (fill === 'end') {\n			target = model.scaleTop === undefined ? scale.top : model.scaleTop;\n		} else if (model.scaleZero !== undefined) {\n			target = model.scaleZero;\n		} else if (scale.getBasePosition) {\n			target = scale.getBasePosition();\n		} else if (scale.getBasePixel) {\n			target = scale.getBasePixel();\n		}\n\n		if (target !== undefined && target !== null) {\n			if (target.x !== undefined && target.y !== undefined) {\n				return target;\n			}\n\n			if (typeof target === 'number' && isFinite(target)) {\n				horizontal = scale.isHorizontal();\n				return {\n					x: horizontal ? target : null,\n					y: horizontal ? null : target\n				};\n			}\n		}\n\n		return null;\n	}\n\n	function resolveTarget(sources, index, propagate) {\n		var source = sources[index];\n		var fill = source.fill;\n		var visited = [index];\n		var target;\n\n		if (!propagate) {\n			return fill;\n		}\n\n		while (fill !== false && visited.indexOf(fill) === -1) {\n			if (!isFinite(fill)) {\n				return fill;\n			}\n\n			target = sources[fill];\n			if (!target) {\n				return false;\n			}\n\n			if (target.visible) {\n				return fill;\n			}\n\n			visited.push(fill);\n			fill = target.fill;\n		}\n\n		return false;\n	}\n\n	function createMapper(source) {\n		var fill = source.fill;\n		var type = 'dataset';\n\n		if (fill === false) {\n			return null;\n		}\n\n		if (!isFinite(fill)) {\n			type = 'boundary';\n		}\n\n		return mappers[type](source);\n	}\n\n	function isDrawable(point) {\n		return point && !point.skip;\n	}\n\n	function drawArea(ctx, curve0, curve1, len0, len1) {\n		var i;\n\n		if (!len0 || !len1) {\n			return;\n		}\n\n		// building first area curve (normal)\n		ctx.moveTo(curve0[0].x, curve0[0].y);\n		for (i = 1; i < len0; ++i) {\n			helpers.canvas.lineTo(ctx, curve0[i - 1], curve0[i]);\n		}\n\n		// joining the two area curves\n		ctx.lineTo(curve1[len1 - 1].x, curve1[len1 - 1].y);\n\n		// building opposite area curve (reverse)\n		for (i = len1 - 1; i > 0; --i) {\n			helpers.canvas.lineTo(ctx, curve1[i], curve1[i - 1], true);\n		}\n	}\n\n	function doFill(ctx, points, mapper, view, color, loop) {\n		var count = points.length;\n		var span = view.spanGaps;\n		var curve0 = [];\n		var curve1 = [];\n		var len0 = 0;\n		var len1 = 0;\n		var i, ilen, index, p0, p1, d0, d1;\n\n		ctx.beginPath();\n\n		for (i = 0, ilen = (count + !!loop); i < ilen; ++i) {\n			index = i % count;\n			p0 = points[index]._view;\n			p1 = mapper(p0, index, view);\n			d0 = isDrawable(p0);\n			d1 = isDrawable(p1);\n\n			if (d0 && d1) {\n				len0 = curve0.push(p0);\n				len1 = curve1.push(p1);\n			} else if (len0 && len1) {\n				if (!span) {\n					drawArea(ctx, curve0, curve1, len0, len1);\n					len0 = len1 = 0;\n					curve0 = [];\n					curve1 = [];\n				} else {\n					if (d0) {\n						curve0.push(p0);\n					}\n					if (d1) {\n						curve1.push(p1);\n					}\n				}\n			}\n		}\n\n		drawArea(ctx, curve0, curve1, len0, len1);\n\n		ctx.closePath();\n		ctx.fillStyle = color;\n		ctx.fill();\n	}\n\n	return {\n		id: 'filler',\n\n		afterDatasetsUpdate: function(chart, options) {\n			var count = (chart.data.datasets || []).length;\n			var propagate = options.propagate;\n			var sources = [];\n			var meta, i, el, source;\n\n			for (i = 0; i < count; ++i) {\n				meta = chart.getDatasetMeta(i);\n				el = meta.dataset;\n				source = null;\n\n				if (el && el._model && el instanceof elements.Line) {\n					source = {\n						visible: chart.isDatasetVisible(i),\n						fill: decodeFill(el, i, count),\n						chart: chart,\n						el: el\n					};\n				}\n\n				meta.$filler = source;\n				sources.push(source);\n			}\n\n			for (i = 0; i < count; ++i) {\n				source = sources[i];\n				if (!source) {\n					continue;\n				}\n\n				source.fill = resolveTarget(sources, i, propagate);\n				source.boundary = computeBoundary(source);\n				source.mapper = createMapper(source);\n			}\n		},\n\n		beforeDatasetDraw: function(chart, args) {\n			var meta = args.meta.$filler;\n			if (!meta) {\n				return;\n			}\n\n			var ctx = chart.ctx;\n			var el = meta.el;\n			var view = el._view;\n			var points = el._children || [];\n			var mapper = meta.mapper;\n			var color = view.backgroundColor || defaults.global.defaultColor;\n\n			if (mapper && color && points.length) {\n				helpers.canvas.clipArea(ctx, chart.chartArea);\n				doFill(ctx, points, mapper, view, color, el._loop);\n				helpers.canvas.unclipArea(ctx);\n			}\n		}\n	};\n};\n\n},{\"25\":25,\"40\":40,\"45\":45}],50:[function(require,module,exports){\n'use strict';\n\nvar defaults = require(25);\nvar Element = require(26);\nvar helpers = require(45);\n\ndefaults._set('global', {\n	legend: {\n		display: true,\n		position: 'top',\n		fullWidth: true,\n		reverse: false,\n		weight: 1000,\n\n		// a callback that will handle\n		onClick: function(e, legendItem) {\n			var index = legendItem.datasetIndex;\n			var ci = this.chart;\n			var meta = ci.getDatasetMeta(index);\n\n			// See controller.isDatasetVisible comment\n			meta.hidden = meta.hidden === null ? !ci.data.datasets[index].hidden : null;\n\n			// We hid a dataset ... rerender the chart\n			ci.update();\n		},\n\n		onHover: null,\n\n		labels: {\n			boxWidth: 40,\n			padding: 10,\n			// Generates labels shown in the legend\n			// Valid properties to return:\n			// text : text to display\n			// fillStyle : fill of coloured box\n			// strokeStyle: stroke of coloured box\n			// hidden : if this legend item refers to a hidden item\n			// lineCap : cap style for line\n			// lineDash\n			// lineDashOffset :\n			// lineJoin :\n			// lineWidth :\n			generateLabels: function(chart) {\n				var data = chart.data;\n				return helpers.isArray(data.datasets) ? data.datasets.map(function(dataset, i) {\n					return {\n						text: dataset.label,\n						fillStyle: (!helpers.isArray(dataset.backgroundColor) ? dataset.backgroundColor : dataset.backgroundColor[0]),\n						hidden: !chart.isDatasetVisible(i),\n						lineCap: dataset.borderCapStyle,\n						lineDash: dataset.borderDash,\n						lineDashOffset: dataset.borderDashOffset,\n						lineJoin: dataset.borderJoinStyle,\n						lineWidth: dataset.borderWidth,\n						strokeStyle: dataset.borderColor,\n						pointStyle: dataset.pointStyle,\n\n						// Below is extra data used for toggling the datasets\n						datasetIndex: i\n					};\n				}, this) : [];\n			}\n		}\n	},\n\n	legendCallback: function(chart) {\n		var text = [];\n		text.push('<ul class=\"' + chart.id + '-legend\">');\n		for (var i = 0; i < chart.data.datasets.length; i++) {\n			text.push('<li><span style=\"background-color:' + chart.data.datasets[i].backgroundColor + '\"></span>');\n			if (chart.data.datasets[i].label) {\n				text.push(chart.data.datasets[i].label);\n			}\n			text.push('</li>');\n		}\n		text.push('</ul>');\n		return text.join('');\n	}\n});\n\nmodule.exports = function(Chart) {\n\n	var layout = Chart.layoutService;\n	var noop = helpers.noop;\n\n	/**\n	 * Helper function to get the box width based on the usePointStyle option\n	 * @param labelopts {Object} the label options on the legend\n	 * @param fontSize {Number} the label font size\n	 * @return {Number} width of the color box area\n	 */\n	function getBoxWidth(labelOpts, fontSize) {\n		return labelOpts.usePointStyle ?\n			fontSize * Math.SQRT2 :\n			labelOpts.boxWidth;\n	}\n\n	Chart.Legend = Element.extend({\n\n		initialize: function(config) {\n			helpers.extend(this, config);\n\n			// Contains hit boxes for each dataset (in dataset order)\n			this.legendHitBoxes = [];\n\n			// Are we in doughnut mode which has a different data type\n			this.doughnutMode = false;\n		},\n\n		// These methods are ordered by lifecycle. Utilities then follow.\n		// Any function defined here is inherited by all legend types.\n		// Any function can be extended by the legend type\n\n		beforeUpdate: noop,\n		update: function(maxWidth, maxHeight, margins) {\n			var me = this;\n\n			// Update Lifecycle - Probably don't want to ever extend or overwrite this function ;)\n			me.beforeUpdate();\n\n			// Absorb the master measurements\n			me.maxWidth = maxWidth;\n			me.maxHeight = maxHeight;\n			me.margins = margins;\n\n			// Dimensions\n			me.beforeSetDimensions();\n			me.setDimensions();\n			me.afterSetDimensions();\n			// Labels\n			me.beforeBuildLabels();\n			me.buildLabels();\n			me.afterBuildLabels();\n\n			// Fit\n			me.beforeFit();\n			me.fit();\n			me.afterFit();\n			//\n			me.afterUpdate();\n\n			return me.minSize;\n		},\n		afterUpdate: noop,\n\n		//\n\n		beforeSetDimensions: noop,\n		setDimensions: function() {\n			var me = this;\n			// Set the unconstrained dimension before label rotation\n			if (me.isHorizontal()) {\n				// Reset position before calculating rotation\n				me.width = me.maxWidth;\n				me.left = 0;\n				me.right = me.width;\n			} else {\n				me.height = me.maxHeight;\n\n				// Reset position before calculating rotation\n				me.top = 0;\n				me.bottom = me.height;\n			}\n\n			// Reset padding\n			me.paddingLeft = 0;\n			me.paddingTop = 0;\n			me.paddingRight = 0;\n			me.paddingBottom = 0;\n\n			// Reset minSize\n			me.minSize = {\n				width: 0,\n				height: 0\n			};\n		},\n		afterSetDimensions: noop,\n\n		//\n\n		beforeBuildLabels: noop,\n		buildLabels: function() {\n			var me = this;\n			var labelOpts = me.options.labels || {};\n			var legendItems = helpers.callback(labelOpts.generateLabels, [me.chart], me) || [];\n\n			if (labelOpts.filter) {\n				legendItems = legendItems.filter(function(item) {\n					return labelOpts.filter(item, me.chart.data);\n				});\n			}\n\n			if (me.options.reverse) {\n				legendItems.reverse();\n			}\n\n			me.legendItems = legendItems;\n		},\n		afterBuildLabels: noop,\n\n		//\n\n		beforeFit: noop,\n		fit: function() {\n			var me = this;\n			var opts = me.options;\n			var labelOpts = opts.labels;\n			var display = opts.display;\n\n			var ctx = me.ctx;\n\n			var globalDefault = defaults.global;\n			var valueOrDefault = helpers.valueOrDefault;\n			var fontSize = valueOrDefault(labelOpts.fontSize, globalDefault.defaultFontSize);\n			var fontStyle = valueOrDefault(labelOpts.fontStyle, globalDefault.defaultFontStyle);\n			var fontFamily = valueOrDefault(labelOpts.fontFamily, globalDefault.defaultFontFamily);\n			var labelFont = helpers.fontString(fontSize, fontStyle, fontFamily);\n\n			// Reset hit boxes\n			var hitboxes = me.legendHitBoxes = [];\n\n			var minSize = me.minSize;\n			var isHorizontal = me.isHorizontal();\n\n			if (isHorizontal) {\n				minSize.width = me.maxWidth; // fill all the width\n				minSize.height = display ? 10 : 0;\n			} else {\n				minSize.width = display ? 10 : 0;\n				minSize.height = me.maxHeight; // fill all the height\n			}\n\n			// Increase sizes here\n			if (display) {\n				ctx.font = labelFont;\n\n				if (isHorizontal) {\n					// Labels\n\n					// Width of each line of legend boxes. Labels wrap onto multiple lines when there are too many to fit on one\n					var lineWidths = me.lineWidths = [0];\n					var totalHeight = me.legendItems.length ? fontSize + (labelOpts.padding) : 0;\n\n					ctx.textAlign = 'left';\n					ctx.textBaseline = 'top';\n\n					helpers.each(me.legendItems, function(legendItem, i) {\n						var boxWidth = getBoxWidth(labelOpts, fontSize);\n						var width = boxWidth + (fontSize / 2) + ctx.measureText(legendItem.text).width;\n\n						if (lineWidths[lineWidths.length - 1] + width + labelOpts.padding >= me.width) {\n							totalHeight += fontSize + (labelOpts.padding);\n							lineWidths[lineWidths.length] = me.left;\n						}\n\n						// Store the hitbox width and height here. Final position will be updated in `draw`\n						hitboxes[i] = {\n							left: 0,\n							top: 0,\n							width: width,\n							height: fontSize\n						};\n\n						lineWidths[lineWidths.length - 1] += width + labelOpts.padding;\n					});\n\n					minSize.height += totalHeight;\n\n				} else {\n					var vPadding = labelOpts.padding;\n					var columnWidths = me.columnWidths = [];\n					var totalWidth = labelOpts.padding;\n					var currentColWidth = 0;\n					var currentColHeight = 0;\n					var itemHeight = fontSize + vPadding;\n\n					helpers.each(me.legendItems, function(legendItem, i) {\n						var boxWidth = getBoxWidth(labelOpts, fontSize);\n						var itemWidth = boxWidth + (fontSize / 2) + ctx.measureText(legendItem.text).width;\n\n						// If too tall, go to new column\n						if (currentColHeight + itemHeight > minSize.height) {\n							totalWidth += currentColWidth + labelOpts.padding;\n							columnWidths.push(currentColWidth); // previous column width\n\n							currentColWidth = 0;\n							currentColHeight = 0;\n						}\n\n						// Get max width\n						currentColWidth = Math.max(currentColWidth, itemWidth);\n						currentColHeight += itemHeight;\n\n						// Store the hitbox width and height here. Final position will be updated in `draw`\n						hitboxes[i] = {\n							left: 0,\n							top: 0,\n							width: itemWidth,\n							height: fontSize\n						};\n					});\n\n					totalWidth += currentColWidth;\n					columnWidths.push(currentColWidth);\n					minSize.width += totalWidth;\n				}\n			}\n\n			me.width = minSize.width;\n			me.height = minSize.height;\n		},\n		afterFit: noop,\n\n		// Shared Methods\n		isHorizontal: function() {\n			return this.options.position === 'top' || this.options.position === 'bottom';\n		},\n\n		// Actually draw the legend on the canvas\n		draw: function() {\n			var me = this;\n			var opts = me.options;\n			var labelOpts = opts.labels;\n			var globalDefault = defaults.global;\n			var lineDefault = globalDefault.elements.line;\n			var legendWidth = me.width;\n			var lineWidths = me.lineWidths;\n\n			if (opts.display) {\n				var ctx = me.ctx;\n				var valueOrDefault = helpers.valueOrDefault;\n				var fontColor = valueOrDefault(labelOpts.fontColor, globalDefault.defaultFontColor);\n				var fontSize = valueOrDefault(labelOpts.fontSize, globalDefault.defaultFontSize);\n				var fontStyle = valueOrDefault(labelOpts.fontStyle, globalDefault.defaultFontStyle);\n				var fontFamily = valueOrDefault(labelOpts.fontFamily, globalDefault.defaultFontFamily);\n				var labelFont = helpers.fontString(fontSize, fontStyle, fontFamily);\n				var cursor;\n\n				// Canvas setup\n				ctx.textAlign = 'left';\n				ctx.textBaseline = 'middle';\n				ctx.lineWidth = 0.5;\n				ctx.strokeStyle = fontColor; // for strikethrough effect\n				ctx.fillStyle = fontColor; // render in correct colour\n				ctx.font = labelFont;\n\n				var boxWidth = getBoxWidth(labelOpts, fontSize);\n				var hitboxes = me.legendHitBoxes;\n\n				// current position\n				var drawLegendBox = function(x, y, legendItem) {\n					if (isNaN(boxWidth) || boxWidth <= 0) {\n						return;\n					}\n\n					// Set the ctx for the box\n					ctx.save();\n\n					ctx.fillStyle = valueOrDefault(legendItem.fillStyle, globalDefault.defaultColor);\n					ctx.lineCap = valueOrDefault(legendItem.lineCap, lineDefault.borderCapStyle);\n					ctx.lineDashOffset = valueOrDefault(legendItem.lineDashOffset, lineDefault.borderDashOffset);\n					ctx.lineJoin = valueOrDefault(legendItem.lineJoin, lineDefault.borderJoinStyle);\n					ctx.lineWidth = valueOrDefault(legendItem.lineWidth, lineDefault.borderWidth);\n					ctx.strokeStyle = valueOrDefault(legendItem.strokeStyle, globalDefault.defaultColor);\n					var isLineWidthZero = (valueOrDefault(legendItem.lineWidth, lineDefault.borderWidth) === 0);\n\n					if (ctx.setLineDash) {\n						// IE 9 and 10 do not support line dash\n						ctx.setLineDash(valueOrDefault(legendItem.lineDash, lineDefault.borderDash));\n					}\n\n					if (opts.labels && opts.labels.usePointStyle) {\n						// Recalculate x and y for drawPoint() because its expecting\n						// x and y to be center of figure (instead of top left)\n						var radius = fontSize * Math.SQRT2 / 2;\n						var offSet = radius / Math.SQRT2;\n						var centerX = x + offSet;\n						var centerY = y + offSet;\n\n						// Draw pointStyle as legend symbol\n						helpers.canvas.drawPoint(ctx, legendItem.pointStyle, radius, centerX, centerY);\n					} else {\n						// Draw box as legend symbol\n						if (!isLineWidthZero) {\n							ctx.strokeRect(x, y, boxWidth, fontSize);\n						}\n						ctx.fillRect(x, y, boxWidth, fontSize);\n					}\n\n					ctx.restore();\n				};\n				var fillText = function(x, y, legendItem, textWidth) {\n					var halfFontSize = fontSize / 2;\n					var xLeft = boxWidth + halfFontSize + x;\n					var yMiddle = y + halfFontSize;\n\n					ctx.fillText(legendItem.text, xLeft, yMiddle);\n\n					if (legendItem.hidden) {\n						// Strikethrough the text if hidden\n						ctx.beginPath();\n						ctx.lineWidth = 2;\n						ctx.moveTo(xLeft, yMiddle);\n						ctx.lineTo(xLeft + textWidth, yMiddle);\n						ctx.stroke();\n					}\n				};\n\n				// Horizontal\n				var isHorizontal = me.isHorizontal();\n				if (isHorizontal) {\n					cursor = {\n						x: me.left + ((legendWidth - lineWidths[0]) / 2),\n						y: me.top + labelOpts.padding,\n						line: 0\n					};\n				} else {\n					cursor = {\n						x: me.left + labelOpts.padding,\n						y: me.top + labelOpts.padding,\n						line: 0\n					};\n				}\n\n				var itemHeight = fontSize + labelOpts.padding;\n				helpers.each(me.legendItems, function(legendItem, i) {\n					var textWidth = ctx.measureText(legendItem.text).width;\n					var width = boxWidth + (fontSize / 2) + textWidth;\n					var x = cursor.x;\n					var y = cursor.y;\n\n					if (isHorizontal) {\n						if (x + width >= legendWidth) {\n							y = cursor.y += itemHeight;\n							cursor.line++;\n							x = cursor.x = me.left + ((legendWidth - lineWidths[cursor.line]) / 2);\n						}\n					} else if (y + itemHeight > me.bottom) {\n						x = cursor.x = x + me.columnWidths[cursor.line] + labelOpts.padding;\n						y = cursor.y = me.top + labelOpts.padding;\n						cursor.line++;\n					}\n\n					drawLegendBox(x, y, legendItem);\n\n					hitboxes[i].left = x;\n					hitboxes[i].top = y;\n\n					// Fill the actual label\n					fillText(x, y, legendItem, textWidth);\n\n					if (isHorizontal) {\n						cursor.x += width + (labelOpts.padding);\n					} else {\n						cursor.y += itemHeight;\n					}\n\n				});\n			}\n		},\n\n		/**\n		 * Handle an event\n		 * @private\n		 * @param {IEvent} event - The event to handle\n		 * @return {Boolean} true if a change occured\n		 */\n		handleEvent: function(e) {\n			var me = this;\n			var opts = me.options;\n			var type = e.type === 'mouseup' ? 'click' : e.type;\n			var changed = false;\n\n			if (type === 'mousemove') {\n				if (!opts.onHover) {\n					return;\n				}\n			} else if (type === 'click') {\n				if (!opts.onClick) {\n					return;\n				}\n			} else {\n				return;\n			}\n\n			// Chart event already has relative position in it\n			var x = e.x;\n			var y = e.y;\n\n			if (x >= me.left && x <= me.right && y >= me.top && y <= me.bottom) {\n				// See if we are touching one of the dataset boxes\n				var lh = me.legendHitBoxes;\n				for (var i = 0; i < lh.length; ++i) {\n					var hitBox = lh[i];\n\n					if (x >= hitBox.left && x <= hitBox.left + hitBox.width && y >= hitBox.top && y <= hitBox.top + hitBox.height) {\n						// Touching an element\n						if (type === 'click') {\n							// use e.native for backwards compatibility\n							opts.onClick.call(me, e.native, me.legendItems[i]);\n							changed = true;\n							break;\n						} else if (type === 'mousemove') {\n							// use e.native for backwards compatibility\n							opts.onHover.call(me, e.native, me.legendItems[i]);\n							changed = true;\n							break;\n						}\n					}\n				}\n			}\n\n			return changed;\n		}\n	});\n\n	function createNewLegendAndAttach(chart, legendOpts) {\n		var legend = new Chart.Legend({\n			ctx: chart.ctx,\n			options: legendOpts,\n			chart: chart\n		});\n\n		layout.configure(chart, legend, legendOpts);\n		layout.addBox(chart, legend);\n		chart.legend = legend;\n	}\n\n	return {\n		id: 'legend',\n\n		beforeInit: function(chart) {\n			var legendOpts = chart.options.legend;\n\n			if (legendOpts) {\n				createNewLegendAndAttach(chart, legendOpts);\n			}\n		},\n\n		beforeUpdate: function(chart) {\n			var legendOpts = chart.options.legend;\n			var legend = chart.legend;\n\n			if (legendOpts) {\n				helpers.mergeIf(legendOpts, defaults.global.legend);\n\n				if (legend) {\n					layout.configure(chart, legend, legendOpts);\n					legend.options = legendOpts;\n				} else {\n					createNewLegendAndAttach(chart, legendOpts);\n				}\n			} else if (legend) {\n				layout.removeBox(chart, legend);\n				delete chart.legend;\n			}\n		},\n\n		afterEvent: function(chart, e) {\n			var legend = chart.legend;\n			if (legend) {\n				legend.handleEvent(e);\n			}\n		}\n	};\n};\n\n},{\"25\":25,\"26\":26,\"45\":45}],51:[function(require,module,exports){\n'use strict';\n\nvar defaults = require(25);\nvar Element = require(26);\nvar helpers = require(45);\n\ndefaults._set('global', {\n	title: {\n		display: false,\n		fontStyle: 'bold',\n		fullWidth: true,\n		lineHeight: 1.2,\n		padding: 10,\n		position: 'top',\n		text: '',\n		weight: 2000         // by default greater than legend (1000) to be above\n	}\n});\n\nmodule.exports = function(Chart) {\n\n	var layout = Chart.layoutService;\n	var noop = helpers.noop;\n\n	Chart.Title = Element.extend({\n		initialize: function(config) {\n			var me = this;\n			helpers.extend(me, config);\n\n			// Contains hit boxes for each dataset (in dataset order)\n			me.legendHitBoxes = [];\n		},\n\n		// These methods are ordered by lifecycle. Utilities then follow.\n\n		beforeUpdate: noop,\n		update: function(maxWidth, maxHeight, margins) {\n			var me = this;\n\n			// Update Lifecycle - Probably don't want to ever extend or overwrite this function ;)\n			me.beforeUpdate();\n\n			// Absorb the master measurements\n			me.maxWidth = maxWidth;\n			me.maxHeight = maxHeight;\n			me.margins = margins;\n\n			// Dimensions\n			me.beforeSetDimensions();\n			me.setDimensions();\n			me.afterSetDimensions();\n			// Labels\n			me.beforeBuildLabels();\n			me.buildLabels();\n			me.afterBuildLabels();\n\n			// Fit\n			me.beforeFit();\n			me.fit();\n			me.afterFit();\n			//\n			me.afterUpdate();\n\n			return me.minSize;\n\n		},\n		afterUpdate: noop,\n\n		//\n\n		beforeSetDimensions: noop,\n		setDimensions: function() {\n			var me = this;\n			// Set the unconstrained dimension before label rotation\n			if (me.isHorizontal()) {\n				// Reset position before calculating rotation\n				me.width = me.maxWidth;\n				me.left = 0;\n				me.right = me.width;\n			} else {\n				me.height = me.maxHeight;\n\n				// Reset position before calculating rotation\n				me.top = 0;\n				me.bottom = me.height;\n			}\n\n			// Reset padding\n			me.paddingLeft = 0;\n			me.paddingTop = 0;\n			me.paddingRight = 0;\n			me.paddingBottom = 0;\n\n			// Reset minSize\n			me.minSize = {\n				width: 0,\n				height: 0\n			};\n		},\n		afterSetDimensions: noop,\n\n		//\n\n		beforeBuildLabels: noop,\n		buildLabels: noop,\n		afterBuildLabels: noop,\n\n		//\n\n		beforeFit: noop,\n		fit: function() {\n			var me = this;\n			var valueOrDefault = helpers.valueOrDefault;\n			var opts = me.options;\n			var display = opts.display;\n			var fontSize = valueOrDefault(opts.fontSize, defaults.global.defaultFontSize);\n			var minSize = me.minSize;\n			var lineCount = helpers.isArray(opts.text) ? opts.text.length : 1;\n			var lineHeight = helpers.options.toLineHeight(opts.lineHeight, fontSize);\n			var textSize = display ? (lineCount * lineHeight) + (opts.padding * 2) : 0;\n\n			if (me.isHorizontal()) {\n				minSize.width = me.maxWidth; // fill all the width\n				minSize.height = textSize;\n			} else {\n				minSize.width = textSize;\n				minSize.height = me.maxHeight; // fill all the height\n			}\n\n			me.width = minSize.width;\n			me.height = minSize.height;\n\n		},\n		afterFit: noop,\n\n		// Shared Methods\n		isHorizontal: function() {\n			var pos = this.options.position;\n			return pos === 'top' || pos === 'bottom';\n		},\n\n		// Actually draw the title block on the canvas\n		draw: function() {\n			var me = this;\n			var ctx = me.ctx;\n			var valueOrDefault = helpers.valueOrDefault;\n			var opts = me.options;\n			var globalDefaults = defaults.global;\n\n			if (opts.display) {\n				var fontSize = valueOrDefault(opts.fontSize, globalDefaults.defaultFontSize);\n				var fontStyle = valueOrDefault(opts.fontStyle, globalDefaults.defaultFontStyle);\n				var fontFamily = valueOrDefault(opts.fontFamily, globalDefaults.defaultFontFamily);\n				var titleFont = helpers.fontString(fontSize, fontStyle, fontFamily);\n				var lineHeight = helpers.options.toLineHeight(opts.lineHeight, fontSize);\n				var offset = lineHeight / 2 + opts.padding;\n				var rotation = 0;\n				var top = me.top;\n				var left = me.left;\n				var bottom = me.bottom;\n				var right = me.right;\n				var maxWidth, titleX, titleY;\n\n				ctx.fillStyle = valueOrDefault(opts.fontColor, globalDefaults.defaultFontColor); // render in correct colour\n				ctx.font = titleFont;\n\n				// Horizontal\n				if (me.isHorizontal()) {\n					titleX = left + ((right - left) / 2); // midpoint of the width\n					titleY = top + offset;\n					maxWidth = right - left;\n				} else {\n					titleX = opts.position === 'left' ? left + offset : right - offset;\n					titleY = top + ((bottom - top) / 2);\n					maxWidth = bottom - top;\n					rotation = Math.PI * (opts.position === 'left' ? -0.5 : 0.5);\n				}\n\n				ctx.save();\n				ctx.translate(titleX, titleY);\n				ctx.rotate(rotation);\n				ctx.textAlign = 'center';\n				ctx.textBaseline = 'middle';\n\n				var text = opts.text;\n				if (helpers.isArray(text)) {\n					var y = 0;\n					for (var i = 0; i < text.length; ++i) {\n						ctx.fillText(text[i], 0, y, maxWidth);\n						y += lineHeight;\n					}\n				} else {\n					ctx.fillText(text, 0, 0, maxWidth);\n				}\n\n				ctx.restore();\n			}\n		}\n	});\n\n	function createNewTitleBlockAndAttach(chart, titleOpts) {\n		var title = new Chart.Title({\n			ctx: chart.ctx,\n			options: titleOpts,\n			chart: chart\n		});\n\n		layout.configure(chart, title, titleOpts);\n		layout.addBox(chart, title);\n		chart.titleBlock = title;\n	}\n\n	return {\n		id: 'title',\n\n		beforeInit: function(chart) {\n			var titleOpts = chart.options.title;\n\n			if (titleOpts) {\n				createNewTitleBlockAndAttach(chart, titleOpts);\n			}\n		},\n\n		beforeUpdate: function(chart) {\n			var titleOpts = chart.options.title;\n			var titleBlock = chart.titleBlock;\n\n			if (titleOpts) {\n				helpers.mergeIf(titleOpts, defaults.global.title);\n\n				if (titleBlock) {\n					layout.configure(chart, titleBlock, titleOpts);\n					titleBlock.options = titleOpts;\n				} else {\n					createNewTitleBlockAndAttach(chart, titleOpts);\n				}\n			} else if (titleBlock) {\n				Chart.layoutService.removeBox(chart, titleBlock);\n				delete chart.titleBlock;\n			}\n		}\n	};\n};\n\n},{\"25\":25,\"26\":26,\"45\":45}],52:[function(require,module,exports){\n'use strict';\n\nmodule.exports = function(Chart) {\n\n	// Default config for a category scale\n	var defaultConfig = {\n		position: 'bottom'\n	};\n\n	var DatasetScale = Chart.Scale.extend({\n		/**\n		* Internal function to get the correct labels. If data.xLabels or data.yLabels are defined, use those\n		* else fall back to data.labels\n		* @private\n		*/\n		getLabels: function() {\n			var data = this.chart.data;\n			return this.options.labels || (this.isHorizontal() ? data.xLabels : data.yLabels) || data.labels;\n		},\n\n		determineDataLimits: function() {\n			var me = this;\n			var labels = me.getLabels();\n			me.minIndex = 0;\n			me.maxIndex = labels.length - 1;\n			var findIndex;\n\n			if (me.options.ticks.min !== undefined) {\n				// user specified min value\n				findIndex = labels.indexOf(me.options.ticks.min);\n				me.minIndex = findIndex !== -1 ? findIndex : me.minIndex;\n			}\n\n			if (me.options.ticks.max !== undefined) {\n				// user specified max value\n				findIndex = labels.indexOf(me.options.ticks.max);\n				me.maxIndex = findIndex !== -1 ? findIndex : me.maxIndex;\n			}\n\n			me.min = labels[me.minIndex];\n			me.max = labels[me.maxIndex];\n		},\n\n		buildTicks: function() {\n			var me = this;\n			var labels = me.getLabels();\n			// If we are viewing some subset of labels, slice the original array\n			me.ticks = (me.minIndex === 0 && me.maxIndex === labels.length - 1) ? labels : labels.slice(me.minIndex, me.maxIndex + 1);\n		},\n\n		getLabelForIndex: function(index, datasetIndex) {\n			var me = this;\n			var data = me.chart.data;\n			var isHorizontal = me.isHorizontal();\n\n			if (data.yLabels && !isHorizontal) {\n				return me.getRightValue(data.datasets[datasetIndex].data[index]);\n			}\n			return me.ticks[index - me.minIndex];\n		},\n\n		// Used to get data value locations.  Value can either be an index or a numerical value\n		getPixelForValue: function(value, index) {\n			var me = this;\n			var offset = me.options.offset;\n			// 1 is added because we need the length but we have the indexes\n			var offsetAmt = Math.max((me.maxIndex + 1 - me.minIndex - (offset ? 0 : 1)), 1);\n\n			// If value is a data object, then index is the index in the data array,\n			// not the index of the scale. We need to change that.\n			var valueCategory;\n			if (value !== undefined && value !== null) {\n				valueCategory = me.isHorizontal() ? value.x : value.y;\n			}\n			if (valueCategory !== undefined || (value !== undefined && isNaN(index))) {\n				var labels = me.getLabels();\n				value = valueCategory || value;\n				var idx = labels.indexOf(value);\n				index = idx !== -1 ? idx : index;\n			}\n\n			if (me.isHorizontal()) {\n				var valueWidth = me.width / offsetAmt;\n				var widthOffset = (valueWidth * (index - me.minIndex));\n\n				if (offset) {\n					widthOffset += (valueWidth / 2);\n				}\n\n				return me.left + Math.round(widthOffset);\n			}\n			var valueHeight = me.height / offsetAmt;\n			var heightOffset = (valueHeight * (index - me.minIndex));\n\n			if (offset) {\n				heightOffset += (valueHeight / 2);\n			}\n\n			return me.top + Math.round(heightOffset);\n		},\n		getPixelForTick: function(index) {\n			return this.getPixelForValue(this.ticks[index], index + this.minIndex, null);\n		},\n		getValueForPixel: function(pixel) {\n			var me = this;\n			var offset = me.options.offset;\n			var value;\n			var offsetAmt = Math.max((me._ticks.length - (offset ? 0 : 1)), 1);\n			var horz = me.isHorizontal();\n			var valueDimension = (horz ? me.width : me.height) / offsetAmt;\n\n			pixel -= horz ? me.left : me.top;\n\n			if (offset) {\n				pixel -= (valueDimension / 2);\n			}\n\n			if (pixel <= 0) {\n				value = 0;\n			} else {\n				value = Math.round(pixel / valueDimension);\n			}\n\n			return value + me.minIndex;\n		},\n		getBasePixel: function() {\n			return this.bottom;\n		}\n	});\n\n	Chart.scaleService.registerScaleType('category', DatasetScale, defaultConfig);\n\n};\n\n},{}],53:[function(require,module,exports){\n'use strict';\n\nvar defaults = require(25);\nvar helpers = require(45);\nvar Ticks = require(34);\n\nmodule.exports = function(Chart) {\n\n	var defaultConfig = {\n		position: 'left',\n		ticks: {\n			callback: Ticks.formatters.linear\n		}\n	};\n\n	var LinearScale = Chart.LinearScaleBase.extend({\n\n		determineDataLimits: function() {\n			var me = this;\n			var opts = me.options;\n			var chart = me.chart;\n			var data = chart.data;\n			var datasets = data.datasets;\n			var isHorizontal = me.isHorizontal();\n			var DEFAULT_MIN = 0;\n			var DEFAULT_MAX = 1;\n\n			function IDMatches(meta) {\n				return isHorizontal ? meta.xAxisID === me.id : meta.yAxisID === me.id;\n			}\n\n			// First Calculate the range\n			me.min = null;\n			me.max = null;\n\n			var hasStacks = opts.stacked;\n			if (hasStacks === undefined) {\n				helpers.each(datasets, function(dataset, datasetIndex) {\n					if (hasStacks) {\n						return;\n					}\n\n					var meta = chart.getDatasetMeta(datasetIndex);\n					if (chart.isDatasetVisible(datasetIndex) && IDMatches(meta) &&\n						meta.stack !== undefined) {\n						hasStacks = true;\n					}\n				});\n			}\n\n			if (opts.stacked || hasStacks) {\n				var valuesPerStack = {};\n\n				helpers.each(datasets, function(dataset, datasetIndex) {\n					var meta = chart.getDatasetMeta(datasetIndex);\n					var key = [\n						meta.type,\n						// we have a separate stack for stack=undefined datasets when the opts.stacked is undefined\n						((opts.stacked === undefined && meta.stack === undefined) ? datasetIndex : ''),\n						meta.stack\n					].join('.');\n\n					if (valuesPerStack[key] === undefined) {\n						valuesPerStack[key] = {\n							positiveValues: [],\n							negativeValues: []\n						};\n					}\n\n					// Store these per type\n					var positiveValues = valuesPerStack[key].positiveValues;\n					var negativeValues = valuesPerStack[key].negativeValues;\n\n					if (chart.isDatasetVisible(datasetIndex) && IDMatches(meta)) {\n						helpers.each(dataset.data, function(rawValue, index) {\n							var value = +me.getRightValue(rawValue);\n							if (isNaN(value) || meta.data[index].hidden) {\n								return;\n							}\n\n							positiveValues[index] = positiveValues[index] || 0;\n							negativeValues[index] = negativeValues[index] || 0;\n\n							if (opts.relativePoints) {\n								positiveValues[index] = 100;\n							} else if (value < 0) {\n								negativeValues[index] += value;\n							} else {\n								positiveValues[index] += value;\n							}\n						});\n					}\n				});\n\n				helpers.each(valuesPerStack, function(valuesForType) {\n					var values = valuesForType.positiveValues.concat(valuesForType.negativeValues);\n					var minVal = helpers.min(values);\n					var maxVal = helpers.max(values);\n					me.min = me.min === null ? minVal : Math.min(me.min, minVal);\n					me.max = me.max === null ? maxVal : Math.max(me.max, maxVal);\n				});\n\n			} else {\n				helpers.each(datasets, function(dataset, datasetIndex) {\n					var meta = chart.getDatasetMeta(datasetIndex);\n					if (chart.isDatasetVisible(datasetIndex) && IDMatches(meta)) {\n						helpers.each(dataset.data, function(rawValue, index) {\n							var value = +me.getRightValue(rawValue);\n							if (isNaN(value) || meta.data[index].hidden) {\n								return;\n							}\n\n							if (me.min === null) {\n								me.min = value;\n							} else if (value < me.min) {\n								me.min = value;\n							}\n\n							if (me.max === null) {\n								me.max = value;\n							} else if (value > me.max) {\n								me.max = value;\n							}\n						});\n					}\n				});\n			}\n\n			me.min = isFinite(me.min) && !isNaN(me.min) ? me.min : DEFAULT_MIN;\n			me.max = isFinite(me.max) && !isNaN(me.max) ? me.max : DEFAULT_MAX;\n\n			// Common base implementation to handle ticks.min, ticks.max, ticks.beginAtZero\n			this.handleTickRangeOptions();\n		},\n		getTickLimit: function() {\n			var maxTicks;\n			var me = this;\n			var tickOpts = me.options.ticks;\n\n			if (me.isHorizontal()) {\n				maxTicks = Math.min(tickOpts.maxTicksLimit ? tickOpts.maxTicksLimit : 11, Math.ceil(me.width / 50));\n			} else {\n				// The factor of 2 used to scale the font size has been experimentally determined.\n				var tickFontSize = helpers.valueOrDefault(tickOpts.fontSize, defaults.global.defaultFontSize);\n				maxTicks = Math.min(tickOpts.maxTicksLimit ? tickOpts.maxTicksLimit : 11, Math.ceil(me.height / (2 * tickFontSize)));\n			}\n\n			return maxTicks;\n		},\n		// Called after the ticks are built. We need\n		handleDirectionalChanges: function() {\n			if (!this.isHorizontal()) {\n				// We are in a vertical orientation. The top value is the highest. So reverse the array\n				this.ticks.reverse();\n			}\n		},\n		getLabelForIndex: function(index, datasetIndex) {\n			return +this.getRightValue(this.chart.data.datasets[datasetIndex].data[index]);\n		},\n		// Utils\n		getPixelForValue: function(value) {\n			// This must be called after fit has been run so that\n			// this.left, this.top, this.right, and this.bottom have been defined\n			var me = this;\n			var start = me.start;\n\n			var rightValue = +me.getRightValue(value);\n			var pixel;\n			var range = me.end - start;\n\n			if (me.isHorizontal()) {\n				pixel = me.left + (me.width / range * (rightValue - start));\n				return Math.round(pixel);\n			}\n\n			pixel = me.bottom - (me.height / range * (rightValue - start));\n			return Math.round(pixel);\n		},\n		getValueForPixel: function(pixel) {\n			var me = this;\n			var isHorizontal = me.isHorizontal();\n			var innerDimension = isHorizontal ? me.width : me.height;\n			var offset = (isHorizontal ? pixel - me.left : me.bottom - pixel) / innerDimension;\n			return me.start + ((me.end - me.start) * offset);\n		},\n		getPixelForTick: function(index) {\n			return this.getPixelForValue(this.ticksAsNumbers[index]);\n		}\n	});\n	Chart.scaleService.registerScaleType('linear', LinearScale, defaultConfig);\n\n};\n\n},{\"25\":25,\"34\":34,\"45\":45}],54:[function(require,module,exports){\n'use strict';\n\nvar helpers = require(45);\nvar Ticks = require(34);\n\nmodule.exports = function(Chart) {\n\n	var noop = helpers.noop;\n\n	Chart.LinearScaleBase = Chart.Scale.extend({\n		getRightValue: function(value) {\n			if (typeof value === 'string') {\n				return +value;\n			}\n			return Chart.Scale.prototype.getRightValue.call(this, value);\n		},\n\n		handleTickRangeOptions: function() {\n			var me = this;\n			var opts = me.options;\n			var tickOpts = opts.ticks;\n\n			// If we are forcing it to begin at 0, but 0 will already be rendered on the chart,\n			// do nothing since that would make the chart weird. If the user really wants a weird chart\n			// axis, they can manually override it\n			if (tickOpts.beginAtZero) {\n				var minSign = helpers.sign(me.min);\n				var maxSign = helpers.sign(me.max);\n\n				if (minSign < 0 && maxSign < 0) {\n					// move the top up to 0\n					me.max = 0;\n				} else if (minSign > 0 && maxSign > 0) {\n					// move the bottom down to 0\n					me.min = 0;\n				}\n			}\n\n			var setMin = tickOpts.min !== undefined || tickOpts.suggestedMin !== undefined;\n			var setMax = tickOpts.max !== undefined || tickOpts.suggestedMax !== undefined;\n\n			if (tickOpts.min !== undefined) {\n				me.min = tickOpts.min;\n			} else if (tickOpts.suggestedMin !== undefined) {\n				if (me.min === null) {\n					me.min = tickOpts.suggestedMin;\n				} else {\n					me.min = Math.min(me.min, tickOpts.suggestedMin);\n				}\n			}\n\n			if (tickOpts.max !== undefined) {\n				me.max = tickOpts.max;\n			} else if (tickOpts.suggestedMax !== undefined) {\n				if (me.max === null) {\n					me.max = tickOpts.suggestedMax;\n				} else {\n					me.max = Math.max(me.max, tickOpts.suggestedMax);\n				}\n			}\n\n			if (setMin !== setMax) {\n				// We set the min or the max but not both.\n				// So ensure that our range is good\n				// Inverted or 0 length range can happen when\n				// ticks.min is set, and no datasets are visible\n				if (me.min >= me.max) {\n					if (setMin) {\n						me.max = me.min + 1;\n					} else {\n						me.min = me.max - 1;\n					}\n				}\n			}\n\n			if (me.min === me.max) {\n				me.max++;\n\n				if (!tickOpts.beginAtZero) {\n					me.min--;\n				}\n			}\n		},\n		getTickLimit: noop,\n		handleDirectionalChanges: noop,\n\n		buildTicks: function() {\n			var me = this;\n			var opts = me.options;\n			var tickOpts = opts.ticks;\n\n			// Figure out what the max number of ticks we can support it is based on the size of\n			// the axis area. For now, we say that the minimum tick spacing in pixels must be 50\n			// We also limit the maximum number of ticks to 11 which gives a nice 10 squares on\n			// the graph. Make sure we always have at least 2 ticks\n			var maxTicks = me.getTickLimit();\n			maxTicks = Math.max(2, maxTicks);\n\n			var numericGeneratorOptions = {\n				maxTicks: maxTicks,\n				min: tickOpts.min,\n				max: tickOpts.max,\n				stepSize: helpers.valueOrDefault(tickOpts.fixedStepSize, tickOpts.stepSize)\n			};\n			var ticks = me.ticks = Ticks.generators.linear(numericGeneratorOptions, me);\n\n			me.handleDirectionalChanges();\n\n			// At this point, we need to update our max and min given the tick values since we have expanded the\n			// range of the scale\n			me.max = helpers.max(ticks);\n			me.min = helpers.min(ticks);\n\n			if (tickOpts.reverse) {\n				ticks.reverse();\n\n				me.start = me.max;\n				me.end = me.min;\n			} else {\n				me.start = me.min;\n				me.end = me.max;\n			}\n		},\n		convertTicksToLabels: function() {\n			var me = this;\n			me.ticksAsNumbers = me.ticks.slice();\n			me.zeroLineIndex = me.ticks.indexOf(0);\n\n			Chart.Scale.prototype.convertTicksToLabels.call(me);\n		}\n	});\n};\n\n},{\"34\":34,\"45\":45}],55:[function(require,module,exports){\n'use strict';\n\nvar helpers = require(45);\nvar Ticks = require(34);\n\nmodule.exports = function(Chart) {\n\n	var defaultConfig = {\n		position: 'left',\n\n		// label settings\n		ticks: {\n			callback: Ticks.formatters.logarithmic\n		}\n	};\n\n	var LogarithmicScale = Chart.Scale.extend({\n		determineDataLimits: function() {\n			var me = this;\n			var opts = me.options;\n			var tickOpts = opts.ticks;\n			var chart = me.chart;\n			var data = chart.data;\n			var datasets = data.datasets;\n			var valueOrDefault = helpers.valueOrDefault;\n			var isHorizontal = me.isHorizontal();\n			function IDMatches(meta) {\n				return isHorizontal ? meta.xAxisID === me.id : meta.yAxisID === me.id;\n			}\n\n			// Calculate Range\n			me.min = null;\n			me.max = null;\n			me.minNotZero = null;\n\n			var hasStacks = opts.stacked;\n			if (hasStacks === undefined) {\n				helpers.each(datasets, function(dataset, datasetIndex) {\n					if (hasStacks) {\n						return;\n					}\n\n					var meta = chart.getDatasetMeta(datasetIndex);\n					if (chart.isDatasetVisible(datasetIndex) && IDMatches(meta) &&\n						meta.stack !== undefined) {\n						hasStacks = true;\n					}\n				});\n			}\n\n			if (opts.stacked || hasStacks) {\n				var valuesPerStack = {};\n\n				helpers.each(datasets, function(dataset, datasetIndex) {\n					var meta = chart.getDatasetMeta(datasetIndex);\n					var key = [\n						meta.type,\n						// we have a separate stack for stack=undefined datasets when the opts.stacked is undefined\n						((opts.stacked === undefined && meta.stack === undefined) ? datasetIndex : ''),\n						meta.stack\n					].join('.');\n\n					if (chart.isDatasetVisible(datasetIndex) && IDMatches(meta)) {\n						if (valuesPerStack[key] === undefined) {\n							valuesPerStack[key] = [];\n						}\n\n						helpers.each(dataset.data, function(rawValue, index) {\n							var values = valuesPerStack[key];\n							var value = +me.getRightValue(rawValue);\n							if (isNaN(value) || meta.data[index].hidden) {\n								return;\n							}\n\n							values[index] = values[index] || 0;\n\n							if (opts.relativePoints) {\n								values[index] = 100;\n							} else {\n								// Don't need to split positive and negative since the log scale can't handle a 0 crossing\n								values[index] += value;\n							}\n						});\n					}\n				});\n\n				helpers.each(valuesPerStack, function(valuesForType) {\n					var minVal = helpers.min(valuesForType);\n					var maxVal = helpers.max(valuesForType);\n					me.min = me.min === null ? minVal : Math.min(me.min, minVal);\n					me.max = me.max === null ? maxVal : Math.max(me.max, maxVal);\n				});\n\n			} else {\n				helpers.each(datasets, function(dataset, datasetIndex) {\n					var meta = chart.getDatasetMeta(datasetIndex);\n					if (chart.isDatasetVisible(datasetIndex) && IDMatches(meta)) {\n						helpers.each(dataset.data, function(rawValue, index) {\n							var value = +me.getRightValue(rawValue);\n							if (isNaN(value) || meta.data[index].hidden) {\n								return;\n							}\n\n							if (me.min === null) {\n								me.min = value;\n							} else if (value < me.min) {\n								me.min = value;\n							}\n\n							if (me.max === null) {\n								me.max = value;\n							} else if (value > me.max) {\n								me.max = value;\n							}\n\n							if (value !== 0 && (me.minNotZero === null || value < me.minNotZero)) {\n								me.minNotZero = value;\n							}\n						});\n					}\n				});\n			}\n\n			me.min = valueOrDefault(tickOpts.min, me.min);\n			me.max = valueOrDefault(tickOpts.max, me.max);\n\n			if (me.min === me.max) {\n				if (me.min !== 0 && me.min !== null) {\n					me.min = Math.pow(10, Math.floor(helpers.log10(me.min)) - 1);\n					me.max = Math.pow(10, Math.floor(helpers.log10(me.max)) + 1);\n				} else {\n					me.min = 1;\n					me.max = 10;\n				}\n			}\n		},\n		buildTicks: function() {\n			var me = this;\n			var opts = me.options;\n			var tickOpts = opts.ticks;\n\n			var generationOptions = {\n				min: tickOpts.min,\n				max: tickOpts.max\n			};\n			var ticks = me.ticks = Ticks.generators.logarithmic(generationOptions, me);\n\n			if (!me.isHorizontal()) {\n				// We are in a vertical orientation. The top value is the highest. So reverse the array\n				ticks.reverse();\n			}\n\n			// At this point, we need to update our max and min given the tick values since we have expanded the\n			// range of the scale\n			me.max = helpers.max(ticks);\n			me.min = helpers.min(ticks);\n\n			if (tickOpts.reverse) {\n				ticks.reverse();\n\n				me.start = me.max;\n				me.end = me.min;\n			} else {\n				me.start = me.min;\n				me.end = me.max;\n			}\n		},\n		convertTicksToLabels: function() {\n			this.tickValues = this.ticks.slice();\n\n			Chart.Scale.prototype.convertTicksToLabels.call(this);\n		},\n		// Get the correct tooltip label\n		getLabelForIndex: function(index, datasetIndex) {\n			return +this.getRightValue(this.chart.data.datasets[datasetIndex].data[index]);\n		},\n		getPixelForTick: function(index) {\n			return this.getPixelForValue(this.tickValues[index]);\n		},\n		getPixelForValue: function(value) {\n			var me = this;\n			var start = me.start;\n			var newVal = +me.getRightValue(value);\n			var opts = me.options;\n			var tickOpts = opts.ticks;\n			var innerDimension, pixel, range;\n\n			if (me.isHorizontal()) {\n				range = helpers.log10(me.end) - helpers.log10(start); // todo: if start === 0\n				if (newVal === 0) {\n					pixel = me.left;\n				} else {\n					innerDimension = me.width;\n					pixel = me.left + (innerDimension / range * (helpers.log10(newVal) - helpers.log10(start)));\n				}\n			} else {\n				// Bottom - top since pixels increase downward on a screen\n				innerDimension = me.height;\n				if (start === 0 && !tickOpts.reverse) {\n					range = helpers.log10(me.end) - helpers.log10(me.minNotZero);\n					if (newVal === start) {\n						pixel = me.bottom;\n					} else if (newVal === me.minNotZero) {\n						pixel = me.bottom - innerDimension * 0.02;\n					} else {\n						pixel = me.bottom - innerDimension * 0.02 - (innerDimension * 0.98 / range * (helpers.log10(newVal) - helpers.log10(me.minNotZero)));\n					}\n				} else if (me.end === 0 && tickOpts.reverse) {\n					range = helpers.log10(me.start) - helpers.log10(me.minNotZero);\n					if (newVal === me.end) {\n						pixel = me.top;\n					} else if (newVal === me.minNotZero) {\n						pixel = me.top + innerDimension * 0.02;\n					} else {\n						pixel = me.top + innerDimension * 0.02 + (innerDimension * 0.98 / range * (helpers.log10(newVal) - helpers.log10(me.minNotZero)));\n					}\n				} else if (newVal === 0) {\n					pixel = tickOpts.reverse ? me.top : me.bottom;\n				} else {\n					range = helpers.log10(me.end) - helpers.log10(start);\n					innerDimension = me.height;\n					pixel = me.bottom - (innerDimension / range * (helpers.log10(newVal) - helpers.log10(start)));\n				}\n			}\n			return pixel;\n		},\n		getValueForPixel: function(pixel) {\n			var me = this;\n			var range = helpers.log10(me.end) - helpers.log10(me.start);\n			var value, innerDimension;\n\n			if (me.isHorizontal()) {\n				innerDimension = me.width;\n				value = me.start * Math.pow(10, (pixel - me.left) * range / innerDimension);\n			} else { // todo: if start === 0\n				innerDimension = me.height;\n				value = Math.pow(10, (me.bottom - pixel) * range / innerDimension) / me.start;\n			}\n			return value;\n		}\n	});\n	Chart.scaleService.registerScaleType('logarithmic', LogarithmicScale, defaultConfig);\n\n};\n\n},{\"34\":34,\"45\":45}],56:[function(require,module,exports){\n'use strict';\n\nvar defaults = require(25);\nvar helpers = require(45);\nvar Ticks = require(34);\n\nmodule.exports = function(Chart) {\n\n	var globalDefaults = defaults.global;\n\n	var defaultConfig = {\n		display: true,\n\n		// Boolean - Whether to animate scaling the chart from the centre\n		animate: true,\n		position: 'chartArea',\n\n		angleLines: {\n			display: true,\n			color: 'rgba(0, 0, 0, 0.1)',\n			lineWidth: 1\n		},\n\n		gridLines: {\n			circular: false\n		},\n\n		// label settings\n		ticks: {\n			// Boolean - Show a backdrop to the scale label\n			showLabelBackdrop: true,\n\n			// String - The colour of the label backdrop\n			backdropColor: 'rgba(255,255,255,0.75)',\n\n			// Number - The backdrop padding above & below the label in pixels\n			backdropPaddingY: 2,\n\n			// Number - The backdrop padding to the side of the label in pixels\n			backdropPaddingX: 2,\n\n			callback: Ticks.formatters.linear\n		},\n\n		pointLabels: {\n			// Boolean - if true, show point labels\n			display: true,\n\n			// Number - Point label font size in pixels\n			fontSize: 10,\n\n			// Function - Used to convert point labels\n			callback: function(label) {\n				return label;\n			}\n		}\n	};\n\n	function getValueCount(scale) {\n		var opts = scale.options;\n		return opts.angleLines.display || opts.pointLabels.display ? scale.chart.data.labels.length : 0;\n	}\n\n	function getPointLabelFontOptions(scale) {\n		var pointLabelOptions = scale.options.pointLabels;\n		var fontSize = helpers.valueOrDefault(pointLabelOptions.fontSize, globalDefaults.defaultFontSize);\n		var fontStyle = helpers.valueOrDefault(pointLabelOptions.fontStyle, globalDefaults.defaultFontStyle);\n		var fontFamily = helpers.valueOrDefault(pointLabelOptions.fontFamily, globalDefaults.defaultFontFamily);\n		var font = helpers.fontString(fontSize, fontStyle, fontFamily);\n\n		return {\n			size: fontSize,\n			style: fontStyle,\n			family: fontFamily,\n			font: font\n		};\n	}\n\n	function measureLabelSize(ctx, fontSize, label) {\n		if (helpers.isArray(label)) {\n			return {\n				w: helpers.longestText(ctx, ctx.font, label),\n				h: (label.length * fontSize) + ((label.length - 1) * 1.5 * fontSize)\n			};\n		}\n\n		return {\n			w: ctx.measureText(label).width,\n			h: fontSize\n		};\n	}\n\n	function determineLimits(angle, pos, size, min, max) {\n		if (angle === min || angle === max) {\n			return {\n				start: pos - (size / 2),\n				end: pos + (size / 2)\n			};\n		} else if (angle < min || angle > max) {\n			return {\n				start: pos - size - 5,\n				end: pos\n			};\n		}\n\n		return {\n			start: pos,\n			end: pos + size + 5\n		};\n	}\n\n	/**\n	 * Helper function to fit a radial linear scale with point labels\n	 */\n	function fitWithPointLabels(scale) {\n		/*\n		 * Right, this is really confusing and there is a lot of maths going on here\n		 * The gist of the problem is here: https://gist.github.com/nnnick/696cc9c55f4b0beb8fe9\n		 *\n		 * Reaction: https://dl.dropboxusercontent.com/u/34601363/toomuchscience.gif\n		 *\n		 * Solution:\n		 *\n		 * We assume the radius of the polygon is half the size of the canvas at first\n		 * at each index we check if the text overlaps.\n		 *\n		 * Where it does, we store that angle and that index.\n		 *\n		 * After finding the largest index and angle we calculate how much we need to remove\n		 * from the shape radius to move the point inwards by that x.\n		 *\n		 * We average the left and right distances to get the maximum shape radius that can fit in the box\n		 * along with labels.\n		 *\n		 * Once we have that, we can find the centre point for the chart, by taking the x text protrusion\n		 * on each side, removing that from the size, halving it and adding the left x protrusion width.\n		 *\n		 * This will mean we have a shape fitted to the canvas, as large as it can be with the labels\n		 * and position it in the most space efficient manner\n		 *\n		 * https://dl.dropboxusercontent.com/u/34601363/yeahscience.gif\n		 */\n\n		var plFont = getPointLabelFontOptions(scale);\n\n		// Get maximum radius of the polygon. Either half the height (minus the text width) or half the width.\n		// Use this to calculate the offset + change. - Make sure L/R protrusion is at least 0 to stop issues with centre points\n		var largestPossibleRadius = Math.min(scale.height / 2, scale.width / 2);\n		var furthestLimits = {\n			r: scale.width,\n			l: 0,\n			t: scale.height,\n			b: 0\n		};\n		var furthestAngles = {};\n		var i, textSize, pointPosition;\n\n		scale.ctx.font = plFont.font;\n		scale._pointLabelSizes = [];\n\n		var valueCount = getValueCount(scale);\n		for (i = 0; i < valueCount; i++) {\n			pointPosition = scale.getPointPosition(i, largestPossibleRadius);\n			textSize = measureLabelSize(scale.ctx, plFont.size, scale.pointLabels[i] || '');\n			scale._pointLabelSizes[i] = textSize;\n\n			// Add quarter circle to make degree 0 mean top of circle\n			var angleRadians = scale.getIndexAngle(i);\n			var angle = helpers.toDegrees(angleRadians) % 360;\n			var hLimits = determineLimits(angle, pointPosition.x, textSize.w, 0, 180);\n			var vLimits = determineLimits(angle, pointPosition.y, textSize.h, 90, 270);\n\n			if (hLimits.start < furthestLimits.l) {\n				furthestLimits.l = hLimits.start;\n				furthestAngles.l = angleRadians;\n			}\n\n			if (hLimits.end > furthestLimits.r) {\n				furthestLimits.r = hLimits.end;\n				furthestAngles.r = angleRadians;\n			}\n\n			if (vLimits.start < furthestLimits.t) {\n				furthestLimits.t = vLimits.start;\n				furthestAngles.t = angleRadians;\n			}\n\n			if (vLimits.end > furthestLimits.b) {\n				furthestLimits.b = vLimits.end;\n				furthestAngles.b = angleRadians;\n			}\n		}\n\n		scale.setReductions(largestPossibleRadius, furthestLimits, furthestAngles);\n	}\n\n	/**\n	 * Helper function to fit a radial linear scale with no point labels\n	 */\n	function fit(scale) {\n		var largestPossibleRadius = Math.min(scale.height / 2, scale.width / 2);\n		scale.drawingArea = Math.round(largestPossibleRadius);\n		scale.setCenterPoint(0, 0, 0, 0);\n	}\n\n	function getTextAlignForAngle(angle) {\n		if (angle === 0 || angle === 180) {\n			return 'center';\n		} else if (angle < 180) {\n			return 'left';\n		}\n\n		return 'right';\n	}\n\n	function fillText(ctx, text, position, fontSize) {\n		if (helpers.isArray(text)) {\n			var y = position.y;\n			var spacing = 1.5 * fontSize;\n\n			for (var i = 0; i < text.length; ++i) {\n				ctx.fillText(text[i], position.x, y);\n				y += spacing;\n			}\n		} else {\n			ctx.fillText(text, position.x, position.y);\n		}\n	}\n\n	function adjustPointPositionForLabelHeight(angle, textSize, position) {\n		if (angle === 90 || angle === 270) {\n			position.y -= (textSize.h / 2);\n		} else if (angle > 270 || angle < 90) {\n			position.y -= textSize.h;\n		}\n	}\n\n	function drawPointLabels(scale) {\n		var ctx = scale.ctx;\n		var valueOrDefault = helpers.valueOrDefault;\n		var opts = scale.options;\n		var angleLineOpts = opts.angleLines;\n		var pointLabelOpts = opts.pointLabels;\n\n		ctx.lineWidth = angleLineOpts.lineWidth;\n		ctx.strokeStyle = angleLineOpts.color;\n\n		var outerDistance = scale.getDistanceFromCenterForValue(opts.ticks.reverse ? scale.min : scale.max);\n\n		// Point Label Font\n		var plFont = getPointLabelFontOptions(scale);\n\n		ctx.textBaseline = 'top';\n\n		for (var i = getValueCount(scale) - 1; i >= 0; i--) {\n			if (angleLineOpts.display) {\n				var outerPosition = scale.getPointPosition(i, outerDistance);\n				ctx.beginPath();\n				ctx.moveTo(scale.xCenter, scale.yCenter);\n				ctx.lineTo(outerPosition.x, outerPosition.y);\n				ctx.stroke();\n				ctx.closePath();\n			}\n\n			if (pointLabelOpts.display) {\n				// Extra 3px out for some label spacing\n				var pointLabelPosition = scale.getPointPosition(i, outerDistance + 5);\n\n				// Keep this in loop since we may support array properties here\n				var pointLabelFontColor = valueOrDefault(pointLabelOpts.fontColor, globalDefaults.defaultFontColor);\n				ctx.font = plFont.font;\n				ctx.fillStyle = pointLabelFontColor;\n\n				var angleRadians = scale.getIndexAngle(i);\n				var angle = helpers.toDegrees(angleRadians);\n				ctx.textAlign = getTextAlignForAngle(angle);\n				adjustPointPositionForLabelHeight(angle, scale._pointLabelSizes[i], pointLabelPosition);\n				fillText(ctx, scale.pointLabels[i] || '', pointLabelPosition, plFont.size);\n			}\n		}\n	}\n\n	function drawRadiusLine(scale, gridLineOpts, radius, index) {\n		var ctx = scale.ctx;\n		ctx.strokeStyle = helpers.valueAtIndexOrDefault(gridLineOpts.color, index - 1);\n		ctx.lineWidth = helpers.valueAtIndexOrDefault(gridLineOpts.lineWidth, index - 1);\n\n		if (scale.options.gridLines.circular) {\n			// Draw circular arcs between the points\n			ctx.beginPath();\n			ctx.arc(scale.xCenter, scale.yCenter, radius, 0, Math.PI * 2);\n			ctx.closePath();\n			ctx.stroke();\n		} else {\n			// Draw straight lines connecting each index\n			var valueCount = getValueCount(scale);\n\n			if (valueCount === 0) {\n				return;\n			}\n\n			ctx.beginPath();\n			var pointPosition = scale.getPointPosition(0, radius);\n			ctx.moveTo(pointPosition.x, pointPosition.y);\n\n			for (var i = 1; i < valueCount; i++) {\n				pointPosition = scale.getPointPosition(i, radius);\n				ctx.lineTo(pointPosition.x, pointPosition.y);\n			}\n\n			ctx.closePath();\n			ctx.stroke();\n		}\n	}\n\n	function numberOrZero(param) {\n		return helpers.isNumber(param) ? param : 0;\n	}\n\n	var LinearRadialScale = Chart.LinearScaleBase.extend({\n		setDimensions: function() {\n			var me = this;\n			var opts = me.options;\n			var tickOpts = opts.ticks;\n			// Set the unconstrained dimension before label rotation\n			me.width = me.maxWidth;\n			me.height = me.maxHeight;\n			me.xCenter = Math.round(me.width / 2);\n			me.yCenter = Math.round(me.height / 2);\n\n			var minSize = helpers.min([me.height, me.width]);\n			var tickFontSize = helpers.valueOrDefault(tickOpts.fontSize, globalDefaults.defaultFontSize);\n			me.drawingArea = opts.display ? (minSize / 2) - (tickFontSize / 2 + tickOpts.backdropPaddingY) : (minSize / 2);\n		},\n		determineDataLimits: function() {\n			var me = this;\n			var chart = me.chart;\n			var min = Number.POSITIVE_INFINITY;\n			var max = Number.NEGATIVE_INFINITY;\n\n			helpers.each(chart.data.datasets, function(dataset, datasetIndex) {\n				if (chart.isDatasetVisible(datasetIndex)) {\n					var meta = chart.getDatasetMeta(datasetIndex);\n\n					helpers.each(dataset.data, function(rawValue, index) {\n						var value = +me.getRightValue(rawValue);\n						if (isNaN(value) || meta.data[index].hidden) {\n							return;\n						}\n\n						min = Math.min(value, min);\n						max = Math.max(value, max);\n					});\n				}\n			});\n\n			me.min = (min === Number.POSITIVE_INFINITY ? 0 : min);\n			me.max = (max === Number.NEGATIVE_INFINITY ? 0 : max);\n\n			// Common base implementation to handle ticks.min, ticks.max, ticks.beginAtZero\n			me.handleTickRangeOptions();\n		},\n		getTickLimit: function() {\n			var tickOpts = this.options.ticks;\n			var tickFontSize = helpers.valueOrDefault(tickOpts.fontSize, globalDefaults.defaultFontSize);\n			return Math.min(tickOpts.maxTicksLimit ? tickOpts.maxTicksLimit : 11, Math.ceil(this.drawingArea / (1.5 * tickFontSize)));\n		},\n		convertTicksToLabels: function() {\n			var me = this;\n\n			Chart.LinearScaleBase.prototype.convertTicksToLabels.call(me);\n\n			// Point labels\n			me.pointLabels = me.chart.data.labels.map(me.options.pointLabels.callback, me);\n		},\n		getLabelForIndex: function(index, datasetIndex) {\n			return +this.getRightValue(this.chart.data.datasets[datasetIndex].data[index]);\n		},\n		fit: function() {\n			if (this.options.pointLabels.display) {\n				fitWithPointLabels(this);\n			} else {\n				fit(this);\n			}\n		},\n		/**\n		 * Set radius reductions and determine new radius and center point\n		 * @private\n		 */\n		setReductions: function(largestPossibleRadius, furthestLimits, furthestAngles) {\n			var me = this;\n			var radiusReductionLeft = furthestLimits.l / Math.sin(furthestAngles.l);\n			var radiusReductionRight = Math.max(furthestLimits.r - me.width, 0) / Math.sin(furthestAngles.r);\n			var radiusReductionTop = -furthestLimits.t / Math.cos(furthestAngles.t);\n			var radiusReductionBottom = -Math.max(furthestLimits.b - me.height, 0) / Math.cos(furthestAngles.b);\n\n			radiusReductionLeft = numberOrZero(radiusReductionLeft);\n			radiusReductionRight = numberOrZero(radiusReductionRight);\n			radiusReductionTop = numberOrZero(radiusReductionTop);\n			radiusReductionBottom = numberOrZero(radiusReductionBottom);\n\n			me.drawingArea = Math.min(\n				Math.round(largestPossibleRadius - (radiusReductionLeft + radiusReductionRight) / 2),\n				Math.round(largestPossibleRadius - (radiusReductionTop + radiusReductionBottom) / 2));\n			me.setCenterPoint(radiusReductionLeft, radiusReductionRight, radiusReductionTop, radiusReductionBottom);\n		},\n		setCenterPoint: function(leftMovement, rightMovement, topMovement, bottomMovement) {\n			var me = this;\n			var maxRight = me.width - rightMovement - me.drawingArea;\n			var maxLeft = leftMovement + me.drawingArea;\n			var maxTop = topMovement + me.drawingArea;\n			var maxBottom = me.height - bottomMovement - me.drawingArea;\n\n			me.xCenter = Math.round(((maxLeft + maxRight) / 2) + me.left);\n			me.yCenter = Math.round(((maxTop + maxBottom) / 2) + me.top);\n		},\n\n		getIndexAngle: function(index) {\n			var angleMultiplier = (Math.PI * 2) / getValueCount(this);\n			var startAngle = this.chart.options && this.chart.options.startAngle ?\n				this.chart.options.startAngle :\n				0;\n\n			var startAngleRadians = startAngle * Math.PI * 2 / 360;\n\n			// Start from the top instead of right, so remove a quarter of the circle\n			return index * angleMultiplier + startAngleRadians;\n		},\n		getDistanceFromCenterForValue: function(value) {\n			var me = this;\n\n			if (value === null) {\n				return 0; // null always in center\n			}\n\n			// Take into account half font size + the yPadding of the top value\n			var scalingFactor = me.drawingArea / (me.max - me.min);\n			if (me.options.ticks.reverse) {\n				return (me.max - value) * scalingFactor;\n			}\n			return (value - me.min) * scalingFactor;\n		},\n		getPointPosition: function(index, distanceFromCenter) {\n			var me = this;\n			var thisAngle = me.getIndexAngle(index) - (Math.PI / 2);\n			return {\n				x: Math.round(Math.cos(thisAngle) * distanceFromCenter) + me.xCenter,\n				y: Math.round(Math.sin(thisAngle) * distanceFromCenter) + me.yCenter\n			};\n		},\n		getPointPositionForValue: function(index, value) {\n			return this.getPointPosition(index, this.getDistanceFromCenterForValue(value));\n		},\n\n		getBasePosition: function() {\n			var me = this;\n			var min = me.min;\n			var max = me.max;\n\n			return me.getPointPositionForValue(0,\n				me.beginAtZero ? 0 :\n				min < 0 && max < 0 ? max :\n				min > 0 && max > 0 ? min :\n				0);\n		},\n\n		draw: function() {\n			var me = this;\n			var opts = me.options;\n			var gridLineOpts = opts.gridLines;\n			var tickOpts = opts.ticks;\n			var valueOrDefault = helpers.valueOrDefault;\n\n			if (opts.display) {\n				var ctx = me.ctx;\n				var startAngle = this.getIndexAngle(0);\n\n				// Tick Font\n				var tickFontSize = valueOrDefault(tickOpts.fontSize, globalDefaults.defaultFontSize);\n				var tickFontStyle = valueOrDefault(tickOpts.fontStyle, globalDefaults.defaultFontStyle);\n				var tickFontFamily = valueOrDefault(tickOpts.fontFamily, globalDefaults.defaultFontFamily);\n				var tickLabelFont = helpers.fontString(tickFontSize, tickFontStyle, tickFontFamily);\n\n				helpers.each(me.ticks, function(label, index) {\n					// Don't draw a centre value (if it is minimum)\n					if (index > 0 || tickOpts.reverse) {\n						var yCenterOffset = me.getDistanceFromCenterForValue(me.ticksAsNumbers[index]);\n\n						// Draw circular lines around the scale\n						if (gridLineOpts.display && index !== 0) {\n							drawRadiusLine(me, gridLineOpts, yCenterOffset, index);\n						}\n\n						if (tickOpts.display) {\n							var tickFontColor = valueOrDefault(tickOpts.fontColor, globalDefaults.defaultFontColor);\n							ctx.font = tickLabelFont;\n\n							ctx.save();\n							ctx.translate(me.xCenter, me.yCenter);\n							ctx.rotate(startAngle);\n\n							if (tickOpts.showLabelBackdrop) {\n								var labelWidth = ctx.measureText(label).width;\n								ctx.fillStyle = tickOpts.backdropColor;\n								ctx.fillRect(\n									-labelWidth / 2 - tickOpts.backdropPaddingX,\n									-yCenterOffset - tickFontSize / 2 - tickOpts.backdropPaddingY,\n									labelWidth + tickOpts.backdropPaddingX * 2,\n									tickFontSize + tickOpts.backdropPaddingY * 2\n								);\n							}\n\n							ctx.textAlign = 'center';\n							ctx.textBaseline = 'middle';\n							ctx.fillStyle = tickFontColor;\n							ctx.fillText(label, 0, -yCenterOffset);\n							ctx.restore();\n						}\n					}\n				});\n\n				if (opts.angleLines.display || opts.pointLabels.display) {\n					drawPointLabels(me);\n				}\n			}\n		}\n	});\n	Chart.scaleService.registerScaleType('radialLinear', LinearRadialScale, defaultConfig);\n\n};\n\n},{\"25\":25,\"34\":34,\"45\":45}],57:[function(require,module,exports){\n/* global window: false */\n'use strict';\n\nvar moment = require(6);\nmoment = typeof moment === 'function' ? moment : window.moment;\n\nvar defaults = require(25);\nvar helpers = require(45);\n\n// Integer constants are from the ES6 spec.\nvar MIN_INTEGER = Number.MIN_SAFE_INTEGER || -9007199254740991;\nvar MAX_INTEGER = Number.MAX_SAFE_INTEGER || 9007199254740991;\n\nvar INTERVALS = {\n	millisecond: {\n		common: true,\n		size: 1,\n		steps: [1, 2, 5, 10, 20, 50, 100, 250, 500]\n	},\n	second: {\n		common: true,\n		size: 1000,\n		steps: [1, 2, 5, 10, 30]\n	},\n	minute: {\n		common: true,\n		size: 60000,\n		steps: [1, 2, 5, 10, 30]\n	},\n	hour: {\n		common: true,\n		size: 3600000,\n		steps: [1, 2, 3, 6, 12]\n	},\n	day: {\n		common: true,\n		size: 86400000,\n		steps: [1, 2, 5]\n	},\n	week: {\n		common: false,\n		size: 604800000,\n		steps: [1, 2, 3, 4]\n	},\n	month: {\n		common: true,\n		size: 2.628e9,\n		steps: [1, 2, 3]\n	},\n	quarter: {\n		common: false,\n		size: 7.884e9,\n		steps: [1, 2, 3, 4]\n	},\n	year: {\n		common: true,\n		size: 3.154e10\n	}\n};\n\nvar UNITS = Object.keys(INTERVALS);\n\nfunction sorter(a, b) {\n	return a - b;\n}\n\nfunction arrayUnique(items) {\n	var hash = {};\n	var out = [];\n	var i, ilen, item;\n\n	for (i = 0, ilen = items.length; i < ilen; ++i) {\n		item = items[i];\n		if (!hash[item]) {\n			hash[item] = true;\n			out.push(item);\n		}\n	}\n\n	return out;\n}\n\n/**\n * Returns an array of {time, pos} objects used to interpolate a specific `time` or position\n * (`pos`) on the scale, by searching entries before and after the requested value. `pos` is\n * a decimal between 0 and 1: 0 being the start of the scale (left or top) and 1 the other\n * extremity (left + width or top + height). Note that it would be more optimized to directly\n * store pre-computed pixels, but the scale dimensions are not guaranteed at the time we need\n * to create the lookup table. The table ALWAYS contains at least two items: min and max.\n *\n * @param {Number[]} timestamps - timestamps sorted from lowest to highest.\n * @param {String} distribution - If 'linear', timestamps will be spread linearly along the min\n * and max range, so basically, the table will contains only two items: {min, 0} and {max, 1}.\n * If 'series', timestamps will be positioned at the same distance from each other. In this\n * case, only timestamps that break the time linearity are registered, meaning that in the\n * best case, all timestamps are linear, the table contains only min and max.\n */\nfunction buildLookupTable(timestamps, min, max, distribution) {\n	if (distribution === 'linear' || !timestamps.length) {\n		return [\n			{time: min, pos: 0},\n			{time: max, pos: 1}\n		];\n	}\n\n	var table = [];\n	var items = [min];\n	var i, ilen, prev, curr, next;\n\n	for (i = 0, ilen = timestamps.length; i < ilen; ++i) {\n		curr = timestamps[i];\n		if (curr > min && curr < max) {\n			items.push(curr);\n		}\n	}\n\n	items.push(max);\n\n	for (i = 0, ilen = items.length; i < ilen; ++i) {\n		next = items[i + 1];\n		prev = items[i - 1];\n		curr = items[i];\n\n		// only add points that breaks the scale linearity\n		if (prev === undefined || next === undefined || Math.round((next + prev) / 2) !== curr) {\n			table.push({time: curr, pos: i / (ilen - 1)});\n		}\n	}\n\n	return table;\n}\n\n// @see adapted from http://www.anujgakhar.com/2014/03/01/binary-search-in-javascript/\nfunction lookup(table, key, value) {\n	var lo = 0;\n	var hi = table.length - 1;\n	var mid, i0, i1;\n\n	while (lo >= 0 && lo <= hi) {\n		mid = (lo + hi) >> 1;\n		i0 = table[mid - 1] || null;\n		i1 = table[mid];\n\n		if (!i0) {\n			// given value is outside table (before first item)\n			return {lo: null, hi: i1};\n		} else if (i1[key] < value) {\n			lo = mid + 1;\n		} else if (i0[key] > value) {\n			hi = mid - 1;\n		} else {\n			return {lo: i0, hi: i1};\n		}\n	}\n\n	// given value is outside table (after last item)\n	return {lo: i1, hi: null};\n}\n\n/**\n * Linearly interpolates the given source `value` using the table items `skey` values and\n * returns the associated `tkey` value. For example, interpolate(table, 'time', 42, 'pos')\n * returns the position for a timestamp equal to 42. If value is out of bounds, values at\n * index [0, 1] or [n - 1, n] are used for the interpolation.\n */\nfunction interpolate(table, skey, sval, tkey) {\n	var range = lookup(table, skey, sval);\n\n	// Note: the lookup table ALWAYS contains at least 2 items (min and max)\n	var prev = !range.lo ? table[0] : !range.hi ? table[table.length - 2] : range.lo;\n	var next = !range.lo ? table[1] : !range.hi ? table[table.length - 1] : range.hi;\n\n	var span = next[skey] - prev[skey];\n	var ratio = span ? (sval - prev[skey]) / span : 0;\n	var offset = (next[tkey] - prev[tkey]) * ratio;\n\n	return prev[tkey] + offset;\n}\n\n/**\n * Convert the given value to a moment object using the given time options.\n * @see http://momentjs.com/docs/#/parsing/\n */\nfunction momentify(value, options) {\n	var parser = options.parser;\n	var format = options.parser || options.format;\n\n	if (typeof parser === 'function') {\n		return parser(value);\n	}\n\n	if (typeof value === 'string' && typeof format === 'string') {\n		return moment(value, format);\n	}\n\n	if (!(value instanceof moment)) {\n		value = moment(value);\n	}\n\n	if (value.isValid()) {\n		return value;\n	}\n\n	// Labels are in an incompatible moment format and no `parser` has been provided.\n	// The user might still use the deprecated `format` option to convert his inputs.\n	if (typeof format === 'function') {\n		return format(value);\n	}\n\n	return value;\n}\n\nfunction parse(input, scale) {\n	if (helpers.isNullOrUndef(input)) {\n		return null;\n	}\n\n	var options = scale.options.time;\n	var value = momentify(scale.getRightValue(input), options);\n	if (!value.isValid()) {\n		return null;\n	}\n\n	if (options.round) {\n		value.startOf(options.round);\n	}\n\n	return value.valueOf();\n}\n\n/**\n * Returns the number of unit to skip to be able to display up to `capacity` number of ticks\n * in `unit` for the given `min` / `max` range and respecting the interval steps constraints.\n */\nfunction determineStepSize(min, max, unit, capacity) {\n	var range = max - min;\n	var interval = INTERVALS[unit];\n	var milliseconds = interval.size;\n	var steps = interval.steps;\n	var i, ilen, factor;\n\n	if (!steps) {\n		return Math.ceil(range / ((capacity || 1) * milliseconds));\n	}\n\n	for (i = 0, ilen = steps.length; i < ilen; ++i) {\n		factor = steps[i];\n		if (Math.ceil(range / (milliseconds * factor)) <= capacity) {\n			break;\n		}\n	}\n\n	return factor;\n}\n\n/**\n * Figures out what unit results in an appropriate number of auto-generated ticks\n */\nfunction determineUnitForAutoTicks(minUnit, min, max, capacity) {\n	var ilen = UNITS.length;\n	var i, interval, factor;\n\n	for (i = UNITS.indexOf(minUnit); i < ilen - 1; ++i) {\n		interval = INTERVALS[UNITS[i]];\n		factor = interval.steps ? interval.steps[interval.steps.length - 1] : MAX_INTEGER;\n\n		if (interval.common && Math.ceil((max - min) / (factor * interval.size)) <= capacity) {\n			return UNITS[i];\n		}\n	}\n\n	return UNITS[ilen - 1];\n}\n\n/**\n * Figures out what unit to format a set of ticks with\n */\nfunction determineUnitForFormatting(ticks, minUnit, min, max) {\n	var duration = moment.duration(moment(max).diff(moment(min)));\n	var ilen = UNITS.length;\n	var i, unit;\n\n	for (i = ilen - 1; i >= UNITS.indexOf(minUnit); i--) {\n		unit = UNITS[i];\n		if (INTERVALS[unit].common && duration.as(unit) >= ticks.length) {\n			return unit;\n		}\n	}\n\n	return UNITS[minUnit ? UNITS.indexOf(minUnit) : 0];\n}\n\nfunction determineMajorUnit(unit) {\n	for (var i = UNITS.indexOf(unit) + 1, ilen = UNITS.length; i < ilen; ++i) {\n		if (INTERVALS[UNITS[i]].common) {\n			return UNITS[i];\n		}\n	}\n}\n\n/**\n * Generates a maximum of `capacity` timestamps between min and max, rounded to the\n * `minor` unit, aligned on the `major` unit and using the given scale time `options`.\n * Important: this method can return ticks outside the min and max range, it's the\n * responsibility of the calling code to clamp values if needed.\n */\nfunction generate(min, max, capacity, options) {\n	var timeOpts = options.time;\n	var minor = timeOpts.unit || determineUnitForAutoTicks(timeOpts.minUnit, min, max, capacity);\n	var major = determineMajorUnit(minor);\n	var stepSize = helpers.valueOrDefault(timeOpts.stepSize, timeOpts.unitStepSize);\n	var weekday = minor === 'week' ? timeOpts.isoWeekday : false;\n	var majorTicksEnabled = options.ticks.major.enabled;\n	var interval = INTERVALS[minor];\n	var first = moment(min);\n	var last = moment(max);\n	var ticks = [];\n	var time;\n\n	if (!stepSize) {\n		stepSize = determineStepSize(min, max, minor, capacity);\n	}\n\n	// For 'week' unit, handle the first day of week option\n	if (weekday) {\n		first = first.isoWeekday(weekday);\n		last = last.isoWeekday(weekday);\n	}\n\n	// Align first/last ticks on unit\n	first = first.startOf(weekday ? 'day' : minor);\n	last = last.startOf(weekday ? 'day' : minor);\n\n	// Make sure that the last tick include max\n	if (last < max) {\n		last.add(1, minor);\n	}\n\n	time = moment(first);\n\n	if (majorTicksEnabled && major && !weekday && !timeOpts.round) {\n		// Align the first tick on the previous `minor` unit aligned on the `major` unit:\n		// we first aligned time on the previous `major` unit then add the number of full\n		// stepSize there is between first and the previous major time.\n		time.startOf(major);\n		time.add(~~((first - time) / (interval.size * stepSize)) * stepSize, minor);\n	}\n\n	for (; time < last; time.add(stepSize, minor)) {\n		ticks.push(+time);\n	}\n\n	ticks.push(+time);\n\n	return ticks;\n}\n\n/**\n * Returns the right and left offsets from edges in the form of {left, right}.\n * Offsets are added when the `offset` option is true.\n */\nfunction computeOffsets(table, ticks, min, max, options) {\n	var left = 0;\n	var right = 0;\n	var upper, lower;\n\n	if (options.offset && ticks.length) {\n		if (!options.time.min) {\n			upper = ticks.length > 1 ? ticks[1] : max;\n			lower = ticks[0];\n			left = (\n				interpolate(table, 'time', upper, 'pos') -\n				interpolate(table, 'time', lower, 'pos')\n			) / 2;\n		}\n		if (!options.time.max) {\n			upper = ticks[ticks.length - 1];\n			lower = ticks.length > 1 ? ticks[ticks.length - 2] : min;\n			right = (\n				interpolate(table, 'time', upper, 'pos') -\n				interpolate(table, 'time', lower, 'pos')\n			) / 2;\n		}\n	}\n\n	return {left: left, right: right};\n}\n\nfunction ticksFromTimestamps(values, majorUnit) {\n	var ticks = [];\n	var i, ilen, value, major;\n\n	for (i = 0, ilen = values.length; i < ilen; ++i) {\n		value = values[i];\n		major = majorUnit ? value === +moment(value).startOf(majorUnit) : false;\n\n		ticks.push({\n			value: value,\n			major: major\n		});\n	}\n\n	return ticks;\n}\n\nmodule.exports = function(Chart) {\n\n	var defaultConfig = {\n		position: 'bottom',\n\n		/**\n		 * Data distribution along the scale:\n		 * - 'linear': data are spread according to their time (distances can vary),\n		 * - 'series': data are spread at the same distance from each other.\n		 * @see https://github.com/chartjs/Chart.js/pull/4507\n		 * @since 2.7.0\n		 */\n		distribution: 'linear',\n\n		/**\n		 * Scale boundary strategy (bypassed by min/max time options)\n		 * - `data`: make sure data are fully visible, ticks outside are removed\n		 * - `ticks`: make sure ticks are fully visible, data outside are truncated\n		 * @see https://github.com/chartjs/Chart.js/pull/4556\n		 * @since 2.7.0\n		 */\n		bounds: 'data',\n\n		time: {\n			parser: false, // false == a pattern string from http://momentjs.com/docs/#/parsing/string-format/ or a custom callback that converts its argument to a moment\n			format: false, // DEPRECATED false == date objects, moment object, callback or a pattern string from http://momentjs.com/docs/#/parsing/string-format/\n			unit: false, // false == automatic or override with week, month, year, etc.\n			round: false, // none, or override with week, month, year, etc.\n			displayFormat: false, // DEPRECATED\n			isoWeekday: false, // override week start day - see http://momentjs.com/docs/#/get-set/iso-weekday/\n			minUnit: 'millisecond',\n\n			// defaults to unit's corresponding unitFormat below or override using pattern string from http://momentjs.com/docs/#/displaying/format/\n			displayFormats: {\n				millisecond: 'h:mm:ss.SSS a', // 11:20:01.123 AM,\n				second: 'h:mm:ss a', // 11:20:01 AM\n				minute: 'h:mm a', // 11:20 AM\n				hour: 'hA', // 5PM\n				day: 'MMM D', // Sep 4\n				week: 'll', // Week 46, or maybe \"[W]WW - YYYY\" ?\n				month: 'MMM YYYY', // Sept 2015\n				quarter: '[Q]Q - YYYY', // Q3\n				year: 'YYYY' // 2015\n			},\n		},\n		ticks: {\n			autoSkip: false,\n\n			/**\n			 * Ticks generation input values:\n			 * - 'auto': generates \"optimal\" ticks based on scale size and time options.\n			 * - 'data': generates ticks from data (including labels from data {t|x|y} objects).\n			 * - 'labels': generates ticks from user given `data.labels` values ONLY.\n			 * @see https://github.com/chartjs/Chart.js/pull/4507\n			 * @since 2.7.0\n			 */\n			source: 'auto',\n\n			major: {\n				enabled: false\n			}\n		}\n	};\n\n	var TimeScale = Chart.Scale.extend({\n		initialize: function() {\n			if (!moment) {\n				throw new Error('Chart.js - Moment.js could not be found! You must include it before Chart.js to use the time scale. Download at https://momentjs.com');\n			}\n\n			this.mergeTicksOptions();\n\n			Chart.Scale.prototype.initialize.call(this);\n		},\n\n		update: function() {\n			var me = this;\n			var options = me.options;\n\n			// DEPRECATIONS: output a message only one time per update\n			if (options.time && options.time.format) {\n				console.warn('options.time.format is deprecated and replaced by options.time.parser.');\n			}\n\n			return Chart.Scale.prototype.update.apply(me, arguments);\n		},\n\n		/**\n		 * Allows data to be referenced via 't' attribute\n		 */\n		getRightValue: function(rawValue) {\n			if (rawValue && rawValue.t !== undefined) {\n				rawValue = rawValue.t;\n			}\n			return Chart.Scale.prototype.getRightValue.call(this, rawValue);\n		},\n\n		determineDataLimits: function() {\n			var me = this;\n			var chart = me.chart;\n			var timeOpts = me.options.time;\n			var min = MAX_INTEGER;\n			var max = MIN_INTEGER;\n			var timestamps = [];\n			var datasets = [];\n			var labels = [];\n			var i, j, ilen, jlen, data, timestamp;\n\n			// Convert labels to timestamps\n			for (i = 0, ilen = chart.data.labels.length; i < ilen; ++i) {\n				labels.push(parse(chart.data.labels[i], me));\n			}\n\n			// Convert data to timestamps\n			for (i = 0, ilen = (chart.data.datasets || []).length; i < ilen; ++i) {\n				if (chart.isDatasetVisible(i)) {\n					data = chart.data.datasets[i].data;\n\n					// Let's consider that all data have the same format.\n					if (helpers.isObject(data[0])) {\n						datasets[i] = [];\n\n						for (j = 0, jlen = data.length; j < jlen; ++j) {\n							timestamp = parse(data[j], me);\n							timestamps.push(timestamp);\n							datasets[i][j] = timestamp;\n						}\n					} else {\n						timestamps.push.apply(timestamps, labels);\n						datasets[i] = labels.slice(0);\n					}\n				} else {\n					datasets[i] = [];\n				}\n			}\n\n			if (labels.length) {\n				// Sort labels **after** data have been converted\n				labels = arrayUnique(labels).sort(sorter);\n				min = Math.min(min, labels[0]);\n				max = Math.max(max, labels[labels.length - 1]);\n			}\n\n			if (timestamps.length) {\n				timestamps = arrayUnique(timestamps).sort(sorter);\n				min = Math.min(min, timestamps[0]);\n				max = Math.max(max, timestamps[timestamps.length - 1]);\n			}\n\n			min = parse(timeOpts.min, me) || min;\n			max = parse(timeOpts.max, me) || max;\n\n			// In case there is no valid min/max, let's use today limits\n			min = min === MAX_INTEGER ? +moment().startOf('day') : min;\n			max = max === MIN_INTEGER ? +moment().endOf('day') + 1 : max;\n\n			// Make sure that max is strictly higher than min (required by the lookup table)\n			me.min = Math.min(min, max);\n			me.max = Math.max(min + 1, max);\n\n			// PRIVATE\n			me._horizontal = me.isHorizontal();\n			me._table = [];\n			me._timestamps = {\n				data: timestamps,\n				datasets: datasets,\n				labels: labels\n			};\n		},\n\n		buildTicks: function() {\n			var me = this;\n			var min = me.min;\n			var max = me.max;\n			var options = me.options;\n			var timeOpts = options.time;\n			var timestamps = [];\n			var ticks = [];\n			var i, ilen, timestamp;\n\n			switch (options.ticks.source) {\n			case 'data':\n				timestamps = me._timestamps.data;\n				break;\n			case 'labels':\n				timestamps = me._timestamps.labels;\n				break;\n			case 'auto':\n			default:\n				timestamps = generate(min, max, me.getLabelCapacity(min), options);\n			}\n\n			if (options.bounds === 'ticks' && timestamps.length) {\n				min = timestamps[0];\n				max = timestamps[timestamps.length - 1];\n			}\n\n			// Enforce limits with user min/max options\n			min = parse(timeOpts.min, me) || min;\n			max = parse(timeOpts.max, me) || max;\n\n			// Remove ticks outside the min/max range\n			for (i = 0, ilen = timestamps.length; i < ilen; ++i) {\n				timestamp = timestamps[i];\n				if (timestamp >= min && timestamp <= max) {\n					ticks.push(timestamp);\n				}\n			}\n\n			me.min = min;\n			me.max = max;\n\n			// PRIVATE\n			me._unit = timeOpts.unit || determineUnitForFormatting(ticks, timeOpts.minUnit, me.min, me.max);\n			me._majorUnit = determineMajorUnit(me._unit);\n			me._table = buildLookupTable(me._timestamps.data, min, max, options.distribution);\n			me._offsets = computeOffsets(me._table, ticks, min, max, options);\n\n			return ticksFromTimestamps(ticks, me._majorUnit);\n		},\n\n		getLabelForIndex: function(index, datasetIndex) {\n			var me = this;\n			var data = me.chart.data;\n			var timeOpts = me.options.time;\n			var label = data.labels && index < data.labels.length ? data.labels[index] : '';\n			var value = data.datasets[datasetIndex].data[index];\n\n			if (helpers.isObject(value)) {\n				label = me.getRightValue(value);\n			}\n			if (timeOpts.tooltipFormat) {\n				label = momentify(label, timeOpts).format(timeOpts.tooltipFormat);\n			}\n\n			return label;\n		},\n\n		/**\n		 * Function to format an individual tick mark\n		 * @private\n		 */\n		tickFormatFunction: function(tick, index, ticks, formatOverride) {\n			var me = this;\n			var options = me.options;\n			var time = tick.valueOf();\n			var formats = options.time.displayFormats;\n			var minorFormat = formats[me._unit];\n			var majorUnit = me._majorUnit;\n			var majorFormat = formats[majorUnit];\n			var majorTime = tick.clone().startOf(majorUnit).valueOf();\n			var majorTickOpts = options.ticks.major;\n			var major = majorTickOpts.enabled && majorUnit && majorFormat && time === majorTime;\n			var label = tick.format(formatOverride ? formatOverride : major ? majorFormat : minorFormat);\n			var tickOpts = major ? majorTickOpts : options.ticks.minor;\n			var formatter = helpers.valueOrDefault(tickOpts.callback, tickOpts.userCallback);\n\n			return formatter ? formatter(label, index, ticks) : label;\n		},\n\n		convertTicksToLabels: function(ticks) {\n			var labels = [];\n			var i, ilen;\n\n			for (i = 0, ilen = ticks.length; i < ilen; ++i) {\n				labels.push(this.tickFormatFunction(moment(ticks[i].value), i, ticks));\n			}\n\n			return labels;\n		},\n\n		/**\n		 * @private\n		 */\n		getPixelForOffset: function(time) {\n			var me = this;\n			var size = me._horizontal ? me.width : me.height;\n			var start = me._horizontal ? me.left : me.top;\n			var pos = interpolate(me._table, 'time', time, 'pos');\n\n			return start + size * (me._offsets.left + pos) / (me._offsets.left + 1 + me._offsets.right);\n		},\n\n		getPixelForValue: function(value, index, datasetIndex) {\n			var me = this;\n			var time = null;\n\n			if (index !== undefined && datasetIndex !== undefined) {\n				time = me._timestamps.datasets[datasetIndex][index];\n			}\n\n			if (time === null) {\n				time = parse(value, me);\n			}\n\n			if (time !== null) {\n				return me.getPixelForOffset(time);\n			}\n		},\n\n		getPixelForTick: function(index) {\n			var ticks = this.getTicks();\n			return index >= 0 && index < ticks.length ?\n				this.getPixelForOffset(ticks[index].value) :\n				null;\n		},\n\n		getValueForPixel: function(pixel) {\n			var me = this;\n			var size = me._horizontal ? me.width : me.height;\n			var start = me._horizontal ? me.left : me.top;\n			var pos = (size ? (pixel - start) / size : 0) * (me._offsets.left + 1 + me._offsets.left) - me._offsets.right;\n			var time = interpolate(me._table, 'pos', pos, 'time');\n\n			return moment(time);\n		},\n\n		/**\n		 * Crude approximation of what the label width might be\n		 * @private\n		 */\n		getLabelWidth: function(label) {\n			var me = this;\n			var ticksOpts = me.options.ticks;\n			var tickLabelWidth = me.ctx.measureText(label).width;\n			var angle = helpers.toRadians(ticksOpts.maxRotation);\n			var cosRotation = Math.cos(angle);\n			var sinRotation = Math.sin(angle);\n			var tickFontSize = helpers.valueOrDefault(ticksOpts.fontSize, defaults.global.defaultFontSize);\n\n			return (tickLabelWidth * cosRotation) + (tickFontSize * sinRotation);\n		},\n\n		/**\n		 * @private\n		 */\n		getLabelCapacity: function(exampleTime) {\n			var me = this;\n\n			var formatOverride = me.options.time.displayFormats.millisecond;	// Pick the longest format for guestimation\n\n			var exampleLabel = me.tickFormatFunction(moment(exampleTime), 0, [], formatOverride);\n			var tickLabelWidth = me.getLabelWidth(exampleLabel);\n			var innerWidth = me.isHorizontal() ? me.width : me.height;\n\n			return Math.floor(innerWidth / tickLabelWidth);\n		}\n	});\n\n	Chart.scaleService.registerScaleType('time', TimeScale, defaultConfig);\n};\n\n},{\"25\":25,\"45\":45,\"6\":6}]},{},[7])(7)\n});";
