
/* linux/kernel/chr_drv/sound/adlib_card.c

Detection routine for the AdLib card.

(C) 1992  Hannu Savolainen (hsavolai@cs.helsinki.fi) */

#include "sound_config.h"

#if defined(CONFIGURE_SOUNDCARD) && !defined(EXCLUDE_ADLIB)

#include <linux/types.h>
#include <linux/errno.h>
#include <linux/signal.h>
#include <linux/fcntl.h>
#include <linux/sched.h>
#include <linux/timer.h>
#include <linux/tty.h>
#include <linux/ctype.h>
#include <asm/io.h>
#include <asm/segment.h>
#include <asm/system.h>
#include <sys/kd.h>
#include <linux/wait.h>
#include <linux/soundcard.h>
#include "sound_calls.h"
#include "dev_table.h"

#define OUTB outb
#define DEB(WHAT)		/* (WHAT) */
#define DEB1(WHAT)		/* (WHAT) */

long
detect_adlib_card (long mem_start)
{

  if (ym3812_detect (FM_MONO))
    {
      mem_start = ym3812_init (mem_start);
    }
  return mem_start;
}

#endif
