/* linux/kernel/chr_drv/sound/dev_table.c

Device call tables.

(C) 1992  Hannu Savolainen (hsavolai@cs.helsinki.fi) */

#define _DEV_TABLE_C_
#include <linux/types.h>
#include <linux/errno.h>
#include <linux/signal.h>
#include <linux/fcntl.h>
#include <linux/sched.h>
#include <linux/timer.h>
#include <linux/tty.h>
#include <linux/ctype.h>
#include <sys/kd.h>
#include <linux/wait.h>
#include <linux/soundcard.h>
#include "sound_calls.h"
#include "sound_config.h"

#ifdef CONFIGURE_SOUNDCARD

#include "dev_table.h"

long
sndtable_init (long mem_start)
{
  int i, n = sizeof (supported_drivers) / sizeof (struct card_info);

  for (i = 0; i < (n-1); i++)
    {
      printk ("Detecting soundcard: %s (type %d).\n",
	      supported_drivers[i].name,
	      supported_drivers[i].card_type);

      mem_start = supported_drivers[i].detect (mem_start);
    }
  return mem_start;
}

int
sndtable_config (struct soundcard_config *conf)
{
  switch (conf->config_command)
    {

      case SNDCONF_RESET:

      soundcard_unload (0);
      num_dspdevs = num_mixers = num_synths = num_midis = 0;
      break;

    case SNDCONF_SETCARD:
      break;

    case SNDCONF_START:
      if (soundcard_init (0))
	{			/* The driver has performed illegal memory
				   allocation */
	  panic ("SoundCard: Memory damaged\n");
	}

      soundcard_start ();
      break;

    default:
      return -EINVAL;
    }

  return 0;
}

int
sndtable_get_cardcount (void)
{
  return num_dspdevs + num_mixers + num_synths + num_midis;
}

#endif
