/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	appwin.H
 *
 *	Functions(s):
 *
 *	Description:
 *		OI_app_window class header
 *
 *	RCSid = "$Id: appwin.H,v 4.18.1.1 1993/06/01 22:52:44 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_appwin_H
#define OI_appwin_H

#ifndef OI_wdtech_H
#include <OI/wdtech.H>
#endif /* OI_wdtech_H */

	// class forward reference declarations
	class OI_app_window;
	class OI_mdl_app_window;
	class OI_menu;
	class OI_static_text;
	class OI_menu_cell;
	class OI_box;
	class OI_glyph;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED DEFINITIONS, ENUMS, TYPEDEFS, ETC
		//		definitions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Definitions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		

#define	OI_app_window_def_icon	NULL			/* default icon for window */
#define	OI_APP_WINDOW_DEF_ICON	OI_app_window_def_icon

 /* ctl_bits private bits */
#define		OI_APP_WINDOW_IN_CONSTRUCTOR	0x1	/* 1 => in app_window constructor */
#define		OI_APP_WINDOW_PROTOCOL_DELETE	0x2	/* 1 => app_window should participate in WM_DELETE protocol */
#define		OI_APP_WINDOW_DECOR_MOD		0x4	/* 1 => help location has been modified for wm decoration */
#define		OI_APP_WINDOW_GROUP_LEADER	0x8	/* 1 => This app window can be it's own group leader */
#define		OI_APP_WINDOW_HYP_HLP_DEL	0x10	/* 1 => hypertext help object has been deleted */

		struct OI_hlp_stk {
			char	*hlp_strp;		/* Help string pointer. */
			OI_bool	hlp_temp;		/* Is the help string permanent or temporary (i.e. to be removed at the next user input.)? */
		} ;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED DEFINITIONS, ENUMS, TYPEDEFS, ETC
		//		definitions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		

#ifdef TYPEDEF_MEMFN
	typedef	void	(OI_app_window_fn)(OI_app_window*,void*) ;			/* function to call for app_window events */
	typedef	void	(OI_callback::OI_app_window_memfn)(OI_app_window*,void*) ;	/* mem func to call for app_window events */
#endif /* TYPEDEF_MEMFN */
	typedef	void	(*OI_app_window_fnp)(OI_app_window*,void*) ;			/* function to call for app_window events */
	typedef	void	(OI_callback::*OI_app_window_memfnp)(OI_app_window*,void*) ;	/* mem func to call for app_window events */

		enum OI_wm_state {					/* state relative to window manager */
			OI_wm_withdrawnstate	= 0,
			OI_WM_WithdrawnState	= OI_wm_withdrawnstate,
			OI_wm_iconicstate	= 1,
			OI_WM_IconicState	= OI_wm_iconicstate,
			OI_wm_normalstate	= 3,
			OI_WM_NormalState	= OI_wm_normalstate
		} ;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	END OF DOCUMENTED SECTION
		//
		//-------------------------------------------------------------------------------------------------		


	class OI_app_window : public OI_w_d_tech {
			OI_mdl_app_window	*mdl_dep ;			/* ptr to model dependent aspects of OI_box object */
			unsigned long		ctl_bits;
	 protected:
		static	XrmQuark	q_cbClick ;				/* quark for click callback */
		static	XrmQuark	q_cbDeiconify ;				/* quark for deiconify callback */
		static	XrmQuark	q_cbExpose ;				/* quark for expose callback */
		static	XrmQuark	q_cbIconify ;				/* quark for iconify callback */
		static	XrmQuark	q_cbKeyHelp ;				/* quark for keyboard help callback */
		static	XrmQuark	q_cbProtocolDelete ;			/* quark for wm delete callback */
		static	XrmQuark	q_cbSaveYourself ;			/* quark for wm save yourself callback */
			XrmQuark	app_hlp_qfil;				/* initial help file to use */
			XrmQuark	app_hlp_qtop;				/* initial help topic to use */
			OI_number	hlp_sp ;				/* index to next free slot in help stack */
			OI_number	hlp_mx ;				/* max # help strings allowed in stack */
			OI_wm_state	wm_st ;					/* window manager state */
			OI_hlp_stk	*hlp_stkp ;				/* ptr to help stack */
			char		*titlep ;				/* ptr to title string */
			char		*lngtrmp ;				/* ptr to long term message string */
	 public:
		static	OI_class	*clsp ;					/* ptr to class record */

	 private:
			void		allow_hyper_help_deleted() ;
			OI_bool		hyper_help_deleted() ;
			void		hyper_help_destroyed(OI_d_tech*,void*) ;
			OI_bool		in_my_constructor()		{return((ctl_bits&OI_APP_WINDOW_IN_CONSTRUCTOR) ? OI_YES : OI_NO);}
			void		refresh_my_callback(OI_cb_inf*) ;
			void		res_height(void *);
			void		res_width(void *);

	 protected:
					OI_app_window (OI_class *clsp, const char*usr_namp, OI_number siz_x, OI_number siz_y,
						const char *tp, OI_glyph *gp=OI_APP_WINDOW_DEF_ICON, OI_bool st=OI_NO) ;
		virtual	OI_d_tech	*callback_object(XrmQuark) ;
		virtual	OI_stat		create() ;
		virtual	void		new_model(OI_model_type) ;
		virtual	void		set_model_info() ;
		virtual	OI_d_tech	*val_assoc(OI_d_tech *) ;
		virtual	void		val_unparent(OI_d_tech*) ;
	 public:
		//-------------------------------------------------------------------------------------------------		
		//		
		//	OUT-OF-PLACE DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		These functions should be under DOCUMENTED MEMBER FUNCTIONS, but are here to prevent C++
		//		from generating out-of-line functions for them due to forward references
		//
		//-------------------------------------------------------------------------------------------------		
			OI_menu_cell	*help_menu_cell() ;
			OI_box		*interior()		{ return(nprop ? (OI_box*)*propp : NULL); }
		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED MEMBER FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
					OI_app_window (const char*,OI_number,OI_number,const char*,OI_glyph* =OI_APP_WINDOW_DEF_ICON,
						OI_bool = OI_NO) ;
					~OI_app_window() ;				/* destructor */
			void		activate_main_menu(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
		virtual	void		allow_abs_associate();
			void		allow_group_leader();
			void		app_client_message(const XEvent *ep) ;		/* ClientMessage event handler */
		virtual	OI_d_tech	*associate_parent(OI_d_tech* =NULL) ;
			void		clear_in_my_constructor()	{ctl_bits&= ~OI_APP_WINDOW_IN_CONSTRUCTOR;}
		virtual	void		clone_adjust(OI_d_tech*) ;
		virtual	void		clone_adjust_after_descendants(OI_d_tech*) ;
		virtual	void		configure(const XEvent*,void* =NULL) ;
			void		construct(OI_number, OI_number, const char*, OI_glyph*, OI_bool) ;
		virtual	long		def_loc_x() ;					/* location used for default placement */
		virtual	long		def_loc_y() ;
		virtual	OI_number	default_horz_space();
			void		default_icon_bits( Pixmap *, OI_number *, OI_number * );
		virtual	OI_number	default_vert_space();
		virtual	void		disallow_abs_associate();
			void		disallow_group_leader();
		friend	void		dmpOI_app_window(OI_app_window*) ;		/* diagnostic dump procedure */
		virtual	void		get_resources();
		virtual	Window		group_leader();
		virtual	void		handle_delete_window();
			void		hlp_strategy(OI_menu_cell*,void*,OI_number) ;	/* process activation of help button */
			char		*icon_filename();
			OI_geometry	*icon_geometry();
			OI_number	icon_x();
			OI_number	icon_y();
			OI_bool		iconic();
		static	OI_bool		init(OI_connection*) ;
		virtual	OI_bool		is_container() ;				/* OI_yes this object can be a container for other objects.*/
			OI_bool		is_group_leader()		{ return ((ctl_bits&OI_APP_WINDOW_GROUP_LEADER)?OI_YES:OI_NO); }
			OI_bool		is_main_menu() ;
			OI_bool		is_write_resq(XrmQuark);
		virtual	OI_layout_method	*layout_method() ;
			OI_menu_cell	*main_menu_help()		{ return (help_menu_cell()); }
		static	OI_app_window	*make_minimal(const char*, OI_minimal_type) ;
		virtual	void		new_def_horz_space(OI_number);
		virtual	void		new_def_vert_space(OI_number);
			OI_stat		new_help(const char *, const char *);
			OI_stat		new_help(XrmQuark t, XrmQuark f)	 {return (new_help(XrmQuarkToString(t), XrmQuarkToString(f))); }
		virtual	void		new_bkg_pixmap(OI_pixmap*) ;				/* change background pixmap generically */
			void		new_icon_geometry(OI_geometry *);
			void		new_icon_x(OI_number);
			void		new_icon_y(OI_number);
			void		new_iconic(OI_bool);
		virtual	void		new_geometry(OI_geometry *);
		virtual	void		new_layout(OI_layout, OI_number= -1, OI_number= -1) ;
		virtual	OI_stat		new_size(OI_number, OI_number);
			void		res_allow_protocol_delete(void *);		/* resource setting callback */
			void		res_longterm(void *);				/* resource setting callback */
			void		res_main_menu( void * ) ;
			void		res_title(void *);				/* resource setting callback */
			void		res_app_help_topic(void *);			/* resource setting callback */
			void		res_app_help_file(void *);			/* resource setting callback */
			void		res_icon_filename(void *);			/* resource setting callback */
			void		res_icon_geometry(void *);
			void		res_icon_x(void *);
			void		res_icon_y(void *);
			void		res_iconic(void *);
			void		set_icon_geometry(OI_geometry *);
			void		set_in_my_constructor()		{ctl_bits|=OI_APP_WINDOW_IN_CONSTRUCTOR;}
	virtual	const	char		*wm_name() ;					/* name for window manager WM_NAME property */

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OVERRIDES OF DOCUMENTED PARENT MEMBER FUNCTIONS	
		//		Functions in this section are documented in the programmer's manual under the
		//		parent(s) of this object and are also available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		virtual	void		allow_horz_resize() ;
		virtual	void		allow_vert_resize() ;
			void		avail_loc(OI_number *, OI_number *) ;
			OI_number	avail_loc_x() ;
			OI_number	avail_loc_y() ;
		virtual	OI_pixmap	*bkg_pixmap();
		virtual	void		disallow_horz_resize() ;
		virtual	void		disallow_vert_resize() ;
		virtual	OI_d_tech	*first_focus();
		virtual	OI_layout	layout() ;
		virtual	OI_d_tech	*next_child(OI_d_tech *) ;
		virtual	OI_number	num_props() ;
		virtual	OI_d_tech	*numbered_child(OI_number n) ;
			void		pop_help_str(OI_number=1, OI_bool =OI_NO) ;	/* pop help text off stack, redisplay previous */
			OI_stat		push_help_str(const char*, OI_bool =OI_NO) ;	/* push help text on help line */
		virtual	void		resume_layout(OI_bool=OI_YES);
			void		set_avail_loc(OI_number x, OI_number y) ;
			void		set_avail_loc_x(OI_number x) ;
			void		set_avail_loc_y(OI_number y) ;
		virtual	void		set_click(OI_click_fnp fp, void *ap=NULL) ;
		virtual	void		set_click(OI_callback *op, OI_click_memfnp mfp, void *ap=NULL) ;
			void		set_expose(OI_obj_event_fnp fp, void *argp=NULL) ;
			void		set_expose(OI_callback *objp, OI_obj_event_memfnp mfp, void *argp=NULL) ;
		virtual	void		set_first_focus(OI_d_tech *);
			OI_stat		set_help_str(const char* ="") ;			/* set help text as single string */
			void		set_icon_geometry(const char *);
			void		set_icon_x(OI_number);
			void		set_icon_y(OI_number);
		virtual	void		set_resize(OI_resize_fnp, void* =NULL) ;
		virtual	void		set_resize(OI_callback*, OI_resize_memfnp, void* =NULL) ;
		virtual	OI_stat		set_size(OI_number,OI_number) ;			/* change size of object */
		virtual	OI_number	size_x() ;					/* get x size of interior box */
		virtual	OI_number	size_y() ;					/* get y size of interior box */
		virtual	OI_d_tech	*subobject(const char*) ;			/* find child */
		virtual	OI_d_tech	*subobject(XrmQuark) ;				/* find child */
		virtual	void		suspend_layout();
		virtual	OI_bool		user_layout_ok() ;
		virtual	Window		X_window() ;					/* get object's X_window id */

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OBSOLETE MEMBER FUNCTIONS	
		//		Functions in this section were previously documented, but have been marked as
		//		obsolete.  These functions have been removed from the programmer's manual.
		//		These functions are subject to removal from the toolkit and should NEVER be
		//		used by toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		
		// For row/column related member functions, refer to documentation for layout methods derived from OI_lm_row_col
		virtual	OI_number	first_column(OI_number r= OI_undefined) ;
		virtual	OI_number	first_row(OI_number = OI_undefined);			/* first row in this object */
		virtual	OI_number	in_column(OI_number c, long x, OI_number r= OI_undefined, OI_number=100) ;	/* is x psn before,in,after a given column? */
		virtual	OI_number	in_row(OI_number r, long y, OI_number c= OI_undefined, OI_number=100) ;	/* is y position before,in,after a given row? */
		virtual	OI_number	last_column(OI_number = OI_undefined);			/* last column used */
		virtual	OI_number	last_row(OI_number = OI_undefined);			/* last row used */
		virtual	void		new_column(OI_number, OI_number= OI_undefined) ;	/* allocate new column number; shift existing if in use */
		virtual	void		new_row(OI_number, OI_number= OI_undefined) ;		/* allocate new row number; shift existing if in use */
		virtual	OI_number	next_column(OI_number, OI_number= OI_undefined) ;	/* next used column number */
		virtual	OI_number	next_row(OI_number, OI_number= OI_undefined) ;		/* next used row number */
		virtual	OI_number	prev_column(OI_number, OI_number= OI_undefined) ;	/* previous used column number */
		virtual	OI_number	prev_row(OI_number, OI_number= OI_undefined) ;		/* previous used row number */

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
			void		deiconify() ;					/* deiconify the window */
			void		help() ;					/* activate hypertext help */
			void		help_dismiss() ;				/* take down help object */
			char		*help_file() ;					/* retrieve help file */
			OI_menu		*help_menu() ;					/* get ptr to menu containing help button */
			OI_static_text	*help_obj() ;					/* get ptr to help object in status area */
		virtual	OI_number	help_stack_size() ;				/* get # items in help stack */
		virtual	char		*help_str() ;
			char		*help_topic() ;					/* retrieve help topic */
		virtual	OI_help		*hyper_help() ;
			OI_glyph	*icon() ;					/* get ptr to icon object */
			void		iconify() ;					/* iconify the window */
			OI_bool		is_protocol_delete();				/* is there a set_protocol_delete callback set? */
			char		*longterm()		{return(lngtrmp);}	/* change long term message portion of title */
			OI_menu		*main_menu() ;					/* get ptr to main menu */
			OI_stat		pop_help(const char *top=NULL, const char *fil=NULL);
			OI_stat		push_help(const char *top, const char *fil=NULL);
			void		set_deiconify(OI_app_window_fnp fp, void *argp=NULL) ;
			void		set_deiconify(OI_callback *objp, OI_app_window_memfnp mfp, void *argp=NULL) ;
			OI_stat		set_help(const char *top, const char *fil=NULL) ;	/* set help context */
			void		set_iconify(OI_app_window_fnp fp, void *argp=NULL) ;
			void		set_iconify(OI_callback *objp, OI_app_window_memfnp mfp, void *argp=NULL) ;
			void		set_key_help(OI_help_fnp fp, void *argp=NULL) ;
			void		set_key_help(OI_callback *objp, OI_help_memfnp mfp, void *argp=NULL) ;
			OI_stat		set_longterm(const char*) ;			/* change long term message portion of title */
			void		set_main_menu(OI_menu *);			/* Make this menu as the main menu. */
			void		set_protocol_delete(OI_destroy_fnp fp, void *argp=NULL) ;
			void		set_protocol_delete(OI_callback *objp, OI_destroy_memfnp mfp, void *argp=NULL) ;
			void		set_save_yourself(OI_app_window_fnp fp, void *argp=NULL) ;
			void		set_save_yourself(OI_callback *objp, OI_app_window_memfnp mfp, void *argp=NULL) ;
			OI_stat		set_state_str(const char*) ;			/* set state text */
			OI_stat		set_title(const char*) ;			/* change title */
			OI_static_text	*state_obj() ;					/* get ptr to state string object */
			char		*state_str() ;
			char		*title()		{return(titlep);}	/* get title */
			void		void_help_context() ;				/* to force reread of help files */
			OI_wm_state	wm_state()		{return (OI_wm_state)(X_window_id?wm_st:OI_WM_WithdrawnState);}
			/* state from window manager point of view OI_WM_WithdrawnState,OI_WM_IconicState, OI_WM_NormalState */
	} ;

//-------------------------------------------------------------------------------------------------		
//		
//	RESTRICTED FUNCTIONS
//		Functions in this section are not documented in the programmer's manual and are
//		restricted to internal use by the toolkit.
//		Functions not contained in user documentation are subject to change without notice
//		and should never be used by toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		

//-------------------------------------------------------------------------------------------------		
//		
//	DOCUMENTED FUNCTIONS	
//		Functions below this point are documented in the programmer's manual under this
//		object and are available to the toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		
	OI_app_window   *oi_create_app_window(const char*,OI_number,OI_number,const char*,OI_glyph* =OI_app_window_def_icon,
				OI_bool = OI_no) ;
									/* create a standard window */

#endif /* OI_appwin_H */
