# ----------------------------------------------------------------------
#     NAME:  Kosher Dill
#  PURPOSE:  Disk usage management utility
#
#   AUTHOR:  Michael J. McLennan       Phone: (215)770-2842
#            AT&T Bell Laboratories   E-mail: michael.mclennan@att.com
#
#     SCCS:  @(#)main.tcl	1.9 (11/13/93)
# ----------------------------------------------------------------------
#                 Copyright (c) 1993  AT&T Bell Laboratories
# ======================================================================
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted,
# provided that the above copyright notice appear in all copies and that
# both that the copyright notice and warranty disclaimer appear in
# supporting documentation, and that the names of AT&T Bell Laboratories
# any of their entities not be used in advertising or publicity
# pertaining to distribution of the software without specific, written
# prior permission.
#
# AT&T disclaims all warranties with regard to this software, including
# all implied warranties of merchantability and fitness.  In no event
# shall AT&T be liable for any special, indirect or consequential
# damages or any damages whatsoever resulting from loss of use, data or
# profits, whether in an action of contract, negligence or other
# tortuous action, arising out of or in connection with the use or
# performance of this software.
# ======================================================================

if {![info exists blt_versions] || ![info exists blt_library]} {
	puts stderr "== KOSHER DILL requires an interpreter with BLT extensions =="
	exit 1
}
if {![file exists $blt_library/dd_protocols]} {
	puts stderr "== cannot find drag&drop protocols directory =="
	exit 1
}
lappend auto_path $env(KOSHERDILL_DIR)/scripts $blt_library/dd_protocols

blt_drag&drop errors {}

# ----------------------------------------------------------------------
#  CUSTOMIZATION STUFF
# ----------------------------------------------------------------------
set KdVersion 1.0

if {[winfo screenvisual .] == "staticgray"} {
	option add Tk*background white startupFile
	option add Tk*foreground black startupFile

	option add Tk*accentBackground black startupFile
	option add Tk*accentForeground white startupFile

	option add Tk*workspaceBackground white startupFile
	option add Tk*workspaceForeground black startupFile

	option add Tk*darkBackground white startupFile
	option add Tk*darkForeground white startupFile

	option add Tk*targetBackground white startupFile
	option add Tk*targetForeground black startupFile
	option add Tk*targetBorderWidth 2 startupFile
	option add Tk*targetRelief sunken startupFile

	option add Tk*barColor black startupFile
} else {
	set base #b5c4a2
	set base1 #f5ffea
	set base2 #c8d8b3
	set base2 #daedc3
	set base2 #cee0ba
	set base3 #929e82
	set base4 #7a846e

	option add Tk*background $base startupFile
	option add Tk*foreground black startupFile
	option add Tk*activeBackground $base2 startupFile
	option add Tk*activeForeground black startupFile

	option add Tk*accentBackground maroon startupFile
	option add Tk*accentForeground white startupFile

	option add Tk*workspaceBackground bisque startupFile
	option add Tk*workspaceForeground black startupFile

	option add Tk*darkBackground $base4 startupFile
	option add Tk*darkForeground $base2 startupFile

	option add Tk*targetBackground $base2 startupFile
	option add Tk*targetForeground black startupFile
	option add Tk*targetBorderWidth 2 startupFile
	option add Tk*targetRelief sunken startupFile

	option add Tk*barColor #d67f4c startupFile
}

# ----------------------------------------------------------------------
set normalbg [option get . background Tk]
set normalfg [option get . foreground Tk]
set accentbg [option get . accentBackground Tk]
set accentfg [option get . accentForeground Tk]
set workspbg [option get . workspaceBackground Tk]
set workspfg [option get . workspaceForeground Tk]
set darkbg   [option get . darkBackground Tk]
set darkfg   [option get . darkForeground Tk]
set targetbg [option get . targetBackground Tk]
set targetfg [option get . targetForeground Tk]
set targetbd [option get . targetBorderWidth Tk]
set targetrl [option get . targetRelief Tk]

. config -bg $normalbg

option add Tk*rejectBackground $normalbg startupFile
option add Tk*tokenBackground $normalbg startupFile
option add Tk*tokenForeground $normalfg startupFile
option add Tk*DragDrop*background $normalbg startupFile
option add Tk*DragDrop*foreground $normalfg startupFile

option add Tk*selector $accentbg startupFile

option add Tk*Scrollbar.Background $darkbg startupFile
option add Tk*Scrollbar.Foreground $darkfg startupFile
option add Tk*Scrollbar.activeForeground $accentbg startupFile

option add Tk*Canvas.background $workspbg startupFile
option add Tk*Canvas.foreground $workspfg startupFile
option add Tk*Canvas.width 5i startupFile

option add Tk*FileViewer*Message.background $workspbg startupFile
option add Tk*FileViewer*Message.foreground $workspfg startupFile
option add Tk*FileViewer*Text.background $workspbg startupFile
option add Tk*FileViewer*Text.foreground $workspfg startupFile

option add Tk*Listbox.background $workspbg startupFile
option add Tk*Listbox.foreground $workspfg startupFile
option add Tk*Listbox.geometry 60x10 startupFile

option add Tk*Entry.background $workspbg startupFile
option add Tk*Entry.foreground $workspfg startupFile
option add Tk*Entry.borderWidth 2 startupFile
option add Tk*Entry.relief sunken startupFile

option add Tk*dirInfo.background $targetbg startupFile
option add Tk*dirInfo.foreground $targetfg startupFile
option add Tk*dirInfo.borderWidth $targetbd startupFile
option add Tk*dirInfo.relief $targetrl startupFile

option add Tk*examineTarget.background $targetbg startupFile
option add Tk*examineTarget.foreground $targetfg startupFile
option add Tk*examineTarget.borderWidth $targetbd startupFile
option add Tk*examineTarget.relief $targetrl startupFile

option add Tk*compressTarget.background $targetbg startupFile
option add Tk*compressTarget.foreground $targetfg startupFile
option add Tk*compressTarget.borderWidth $targetbd startupFile
option add Tk*compressTarget.relief $targetrl startupFile

option add Tk*trashTarget.background $targetbg startupFile
option add Tk*trashTarget.foreground $targetfg startupFile
option add Tk*trashTarget.borderWidth $targetbd startupFile
option add Tk*trashTarget.relief $targetrl startupFile

option add Tk*refileTarget.background $targetbg startupFile
option add Tk*refileTarget.foreground $targetfg startupFile
option add Tk*refileTarget.borderWidth $targetbd startupFile
option add Tk*refileTarget.relief $targetrl startupFile

option add Tk*abort*animate.background white startupFile
option add Tk*abort*animate.borderWidth 2 startupFile
option add Tk*abort*animate.relief sunken startupFile

option add Tk*about*title*font \
	-Adobe-Helvetica-Bold-O-Normal--*-180-* startupFile
option add Tk*about*expl*font \
	-Adobe-Helvetica-Bold-R-Normal--*-100-* startupFile
option add Tk*about*disclaimer*font \
	-Adobe-Helvetica-Bold-R-Normal--*-100-* startupFile

option add Tk*DragDrop*tokenActiveBackground $accentbg startupFile
option add Tk*DragDrop*tokenActiveForeground $accentfg startupFile

option add Tk*Notice*mesg*Background $accentbg startupFile
option add Tk*Notice*mesg*Foreground $accentfg startupFile

if {[winfo screenvisual .] == "staticgray"} {
	option add Tk*about.blt*background white startupFile
} else {
	option add Tk*about*background $base2 startupFile
	option add Tk*about.blt*Background $base startupFile
	option add Tk*about.cntl*background $base3 startupFile
}

# ----------------------------------------------------------------------
#  PATCH IN HYPERHELP (after setting up resources)
# ----------------------------------------------------------------------
hyperhelp_init "Kosher Dill" $env(KOSHERDILL_DIR)/Help

# ----------------------------------------------------------------------
#  BITMAPS
# ----------------------------------------------------------------------
blt_bitmap define dill-logo { {82 44} {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc3, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x20, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x10, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0xc8, 0x71, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c,
   0x68, 0xc0, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x0c, 0x28,
   0x9b, 0x04, 0x00, 0x00, 0x00, 0x00, 0x50, 0x02, 0x00, 0x06, 0x88, 0x24,
   0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x48, 0x44, 0x04,
   0x00, 0x00, 0x00, 0x20, 0x00, 0x28, 0x60, 0x03, 0x48, 0x5f, 0x04, 0x00,
   0x00, 0x00, 0x08, 0x4a, 0x41, 0x90, 0x04, 0x48, 0x5f, 0x04, 0x00, 0x00,
   0x00, 0x80, 0x20, 0x00, 0x90, 0x04, 0x88, 0x3b, 0x04, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x10, 0x19, 0x08, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x20, 0x90, 0x60, 0x08, 0x80, 0x04, 0x00, 0x00, 0xff, 0xff, 0xbf,
   0x87, 0xe0, 0x83, 0x89, 0x40, 0x04, 0x00, 0x00, 0x2b, 0x00, 0xe0, 0x06,
   0x60, 0x1c, 0x0e, 0x3f, 0x04, 0x00, 0x00, 0x35, 0x80, 0x67, 0x05, 0x70,
   0x60, 0x08, 0x00, 0x08, 0x00, 0x00, 0x2b, 0x80, 0xa6, 0x00, 0x3f, 0x80,
   0x09, 0x00, 0x08, 0x00, 0x00, 0x35, 0x80, 0x65, 0xfd, 0x3a, 0x00, 0x06,
   0x00, 0x08, 0x00, 0x00, 0x2b, 0x80, 0xa6, 0x84, 0x20, 0x00, 0x04, 0x00,
   0x30, 0x00, 0x00, 0x35, 0x80, 0x65, 0x32, 0x2a, 0x00, 0x04, 0x00, 0xc4,
   0x00, 0x00, 0x2b, 0x80, 0xa7, 0x06, 0x20, 0x00, 0x04, 0x00, 0x01, 0x83,
   0x01, 0x35, 0x00, 0x60, 0x78, 0x15, 0x00, 0x14, 0x00, 0x34, 0x7c, 0x02,
   0xeb, 0xff, 0xbf, 0x42, 0x14, 0x00, 0x04, 0x00, 0xd1, 0x00, 0x01, 0x55,
   0x55, 0x55, 0x85, 0x10, 0x08, 0x14, 0x00, 0x14, 0xf3, 0x00, 0xab, 0xaa,
   0xaa, 0x86, 0x12, 0x10, 0x04, 0x00, 0x11, 0x0a, 0x00, 0xfd, 0xff, 0xff,
   0x85, 0x25, 0x22, 0x04, 0x00, 0x24, 0x05, 0x00, 0x0b, 0x00, 0x80, 0x06,
   0x28, 0x24, 0x08, 0x00, 0x29, 0x02, 0x00, 0x0d, 0x00, 0x80, 0x05, 0x68,
   0x24, 0x08, 0x00, 0x22, 0x00, 0x00, 0xeb, 0xff, 0xbf, 0x06, 0x30, 0x04,
   0x08, 0x00, 0x28, 0x00, 0x00, 0x0d, 0x00, 0x80, 0x05, 0x00, 0x00, 0x08,
   0x00, 0x22, 0x00, 0x00, 0x0b, 0x00, 0x80, 0x06, 0x04, 0x00, 0x10, 0x00,
   0x28, 0x00, 0x00, 0xed, 0xff, 0xbf, 0x05, 0x38, 0x00, 0x10, 0x00, 0x22,
   0x00, 0x00, 0x0b, 0x00, 0x80, 0x06, 0x01, 0x00, 0x10, 0x00, 0x11, 0x00,
   0x00, 0x0d, 0x00, 0x80, 0x05, 0x02, 0x02, 0x20, 0x54, 0x08, 0x00, 0x00,
   0xeb, 0xff, 0xbf, 0x06, 0x1c, 0x04, 0xc0, 0x00, 0x06, 0x00, 0x00, 0x0d,
   0x00, 0x80, 0x05, 0x00, 0x00, 0x00, 0xff, 0x01, 0x00, 0x00, 0x0b, 0x00,
   0x80, 0x06, 0x00, 0x10, 0x00, 0xfc, 0x00, 0x00, 0x00, 0xed, 0xff, 0xbf,
   0x05, 0x80, 0x02, 0x80, 0xd7, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x80, 0x06,
   0x40, 0x00, 0x7c, 0x30, 0x03, 0x00, 0x00, 0xff, 0xff, 0xff, 0x07, 0x00,
   0x00, 0x02, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xfe, 0x07, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xfc, 0x1f, 0x00, 0x00
} }

blt_bitmap define dill-blt { {86 44} {
   0x00, 0x00, 0x80, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x78, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x04, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04,
   0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x40,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x39, 0x4e, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x58, 0x00, 0x80,
   0xff, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x65, 0x93, 0x00, 0x80, 0x00,
   0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x91, 0x84, 0x00, 0x80, 0x00, 0x00,
   0x40, 0x00, 0x00, 0x00, 0x00, 0x89, 0x88, 0x00, 0x80, 0x7c, 0xe6, 0x27,
   0x00, 0x00, 0x00, 0x00, 0xe9, 0x8b, 0x00, 0x80, 0xcc, 0x86, 0x21, 0x00,
   0x00, 0x00, 0x00, 0xe9, 0x8b, 0x00, 0x80, 0xcc, 0x86, 0x11, 0x00, 0x00,
   0x00, 0x00, 0x71, 0x87, 0x00, 0x80, 0x7c, 0x86, 0x11, 0x00, 0x00, 0x00,
   0x00, 0x01, 0x80, 0x00, 0x80, 0xcc, 0x86, 0x11, 0x00, 0x00, 0x00, 0x00,
   0x01, 0x90, 0x00, 0x80, 0xcc, 0x86, 0x21, 0x00, 0x00, 0x00, 0x00, 0x11,
   0x88, 0x00, 0x80, 0x7c, 0xbe, 0x21, 0x00, 0x00, 0x00, 0x00, 0xe1, 0x87,
   0x00, 0x80, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01,
   0x80, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x80,
   0xff, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x01, 0x80, 0x01,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x06, 0x80, 0x01, 0x00,
   0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x80, 0x18, 0x80, 0x01, 0xff, 0x7f,
   0x00, 0x00, 0x00, 0xa0, 0x00, 0x20, 0x60, 0xa0, 0xfd, 0x00, 0x80, 0x00,
   0x00, 0x00, 0x90, 0x00, 0x80, 0x86, 0x9f, 0x01, 0x00, 0x24, 0x01, 0x00,
   0x00, 0x88, 0x00, 0x20, 0x1a, 0x20, 0x01, 0x00, 0x40, 0x02, 0x00, 0x00,
   0x84, 0x00, 0x80, 0x62, 0xa0, 0x01, 0x00, 0x00, 0x02, 0x00, 0x00, 0xe2,
   0x04, 0x20, 0x42, 0x1f, 0x00, 0x00, 0x20, 0x03, 0x00, 0x00, 0xc2, 0x01,
   0x80, 0xa4, 0x01, 0x00, 0x00, 0x80, 0x02, 0x00, 0x00, 0x04, 0x05, 0x20,
   0x45, 0xfe, 0xff, 0xff, 0x7f, 0x03, 0x00, 0x00, 0x18, 0x01, 0x40, 0x04,
   0xaa, 0xaa, 0xaa, 0xaa, 0x01, 0x00, 0x00, 0x60, 0x01, 0x00, 0x05, 0x5d,
   0x55, 0x55, 0xd5, 0x02, 0x00, 0x00, 0x80, 0x01, 0x40, 0x84, 0xfc, 0xff,
   0xff, 0xff, 0x05, 0x00, 0x00, 0xe0, 0x02, 0x00, 0x85, 0xfe, 0xff, 0xff,
   0xff, 0x04, 0x00, 0x00, 0x10, 0x02, 0x40, 0x04, 0xdb, 0x55, 0xb5, 0xb7,
   0x05, 0x00, 0x00, 0xe0, 0x03, 0x20, 0x8e, 0xed, 0xab, 0xfa, 0x6c, 0x03,
   0x00, 0x00, 0x00, 0x84, 0x0a, 0x89, 0x77, 0xfe, 0x0f, 0xda, 0x06, 0x00,
   0x00, 0x00, 0x18, 0xc0, 0x09, 0x3f, 0x00, 0x82, 0xf9, 0x03, 0x00, 0x00,
   0x00, 0xf0, 0x3f, 0x08, 0xbc, 0xc8, 0x51, 0xf2, 0x01, 0x00, 0x00, 0x00,
   0x08, 0x1e, 0x08, 0x56, 0x26, 0x68, 0x68, 0x01, 0x00, 0x00, 0x00, 0x08,
   0x00, 0x09, 0xfa, 0x99, 0x87, 0xaf, 0x01, 0x00, 0x00, 0x00, 0xf8, 0xff,
   0x18, 0x56, 0x55, 0x78, 0x55, 0x01, 0x00, 0x00, 0x00, 0x00, 0x81, 0xf1,
   0xac, 0xaa, 0xaa, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x82, 0xf8,
   0x7f, 0x55, 0x75, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0x00, 0xc0,
   0xff, 0x1f, 0x00, 0x00
} }

blt_bitmap define dill-du-0 { {96 60} {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xe0, 0x01, 0x20, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x18, 0x1e, 0x20, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x04, 0x20, 0x20, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x02, 0x20, 0x20, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x32, 0x40, 0x20, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xc2, 0x8e, 0xe0, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x02, 0x80, 0x10, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xc1, 0x86, 0x08, 0x02, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x21, 0x89, 0x1c, 0x0e, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x11, 0x91, 0x22, 0xf1, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xd1, 0x97, 0xe2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xd1, 0x97, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xe1, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x11, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xe1, 0x87, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x80, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x80, 0x04, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x60, 0x0e, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x18, 0x5c, 0x15, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x04, 0xf8, 0xff, 0xff, 0xf7, 0x00, 0x00, 0xe0, 0xff, 0xff, 0xf7,
   0x00, 0x84, 0x73, 0x05, 0x00, 0xdc, 0x00, 0x00, 0x60, 0x05, 0x00, 0xdc,
   0x00, 0x04, 0xbc, 0x06, 0xf0, 0xac, 0x00, 0x00, 0xa0, 0x06, 0xf0, 0xac,
   0x00, 0x04, 0x60, 0x05, 0xd0, 0xd4, 0x00, 0x00, 0x60, 0x05, 0xd0, 0xd4,
   0x00, 0x18, 0xa0, 0x06, 0xb0, 0xac, 0x00, 0x00, 0xa0, 0x06, 0xb0, 0xac,
   0x00, 0xe0, 0x61, 0x05, 0xd0, 0xd4, 0x00, 0x00, 0x60, 0x05, 0xd0, 0xd4,
   0x00, 0x20, 0xbf, 0x06, 0xb0, 0xac, 0x00, 0x00, 0xa0, 0x06, 0xb0, 0xac,
   0x00, 0xa0, 0x64, 0x05, 0xf0, 0xd4, 0x00, 0x00, 0x60, 0x05, 0xf0, 0xd4,
   0x00, 0x20, 0xa2, 0x06, 0x00, 0xac, 0x00, 0x00, 0xa0, 0x06, 0x00, 0xac,
   0x00, 0xa0, 0x60, 0xfd, 0xff, 0xd7, 0x00, 0x00, 0x60, 0xfd, 0xff, 0xd7,
   0x00, 0x20, 0xa2, 0xaa, 0xaa, 0xaa, 0x00, 0x00, 0xa0, 0xaa, 0xaa, 0xaa,
   0x00, 0xa0, 0x60, 0x55, 0x55, 0xd5, 0x00, 0x00, 0x60, 0x55, 0x55, 0xd5,
   0x00, 0x20, 0xa2, 0xff, 0xff, 0xbf, 0x00, 0x00, 0xa0, 0xff, 0xff, 0xbf,
   0x00, 0x40, 0x64, 0x01, 0x00, 0xd0, 0x00, 0x00, 0x60, 0x01, 0x00, 0xd0,
   0x00, 0x80, 0xb0, 0x01, 0x00, 0xb0, 0x00, 0x00, 0xa0, 0x01, 0x00, 0xb0,
   0x00, 0x00, 0x63, 0xfd, 0xff, 0xd7, 0x00, 0x00, 0x60, 0xfd, 0xff, 0xd7,
   0x00, 0x00, 0xbc, 0x01, 0x00, 0xb0, 0x00, 0x00, 0xa0, 0x01, 0x00, 0xb0,
   0x00, 0x00, 0x78, 0x01, 0x00, 0xd0, 0x00, 0x00, 0x60, 0x01, 0x00, 0xd0,
   0x00, 0x00, 0xb8, 0xfd, 0xff, 0xb7, 0x00, 0x00, 0xa0, 0xfd, 0xff, 0xb7,
   0x00, 0x00, 0x66, 0x01, 0x00, 0xd0, 0x00, 0x00, 0x60, 0x01, 0x00, 0xd0,
   0x00, 0x80, 0xa1, 0x01, 0x00, 0xb0, 0x00, 0x00, 0xa0, 0x01, 0x00, 0xb0,
   0x00, 0x40, 0x60, 0xfd, 0xff, 0xd7, 0x00, 0x00, 0x60, 0xfd, 0xff, 0xd7,
   0x00, 0xc0, 0xbf, 0x01, 0x00, 0xb0, 0x00, 0x00, 0xa0, 0x01, 0x00, 0xb0,
   0x00, 0x00, 0x60, 0x01, 0x00, 0xd0, 0x00, 0x00, 0x60, 0x01, 0x00, 0xd0,
   0xff, 0xff, 0xbf, 0xfd, 0xff, 0xb7, 0xff, 0xff, 0xbf, 0xfd, 0xff, 0xb7,
   0xff, 0xff, 0x7f, 0x01, 0x00, 0xd0, 0xff, 0xff, 0x7f, 0x01, 0x00, 0xd0,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
} }

blt_bitmap define dill-du-1 { {96 60} {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x40, 0x08, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xe0, 0x01, 0x20, 0x08, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x18, 0x1e, 0x20, 0x08, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x04, 0x20, 0x20, 0x08, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x02, 0x20, 0x20, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x32, 0x40, 0x20, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xc2, 0x8e, 0xe0, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x02, 0x80, 0x10, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xc1, 0x86, 0x08, 0x02, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x21, 0x89, 0x1c, 0x0e, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x11, 0x91, 0x22, 0xf1, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xd1, 0x97, 0xe2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xd1, 0x97, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xe1, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x11, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xe1, 0x87, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x80, 0x04, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x80, 0x0e, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x60, 0x1c, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x18, 0x78, 0x15, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x04, 0xfe, 0xff, 0x7f, 0x0f, 0x00, 0x00, 0xfe, 0xff, 0x7f, 0x0f,
   0x00, 0x84, 0x57, 0x00, 0xc0, 0x0d, 0x00, 0x00, 0x56, 0x00, 0xc0, 0x0d,
   0x00, 0x04, 0x6a, 0x00, 0xcf, 0x0a, 0x00, 0x00, 0x6a, 0x00, 0xcf, 0x0a,
   0x00, 0x04, 0x56, 0x00, 0x4d, 0x0d, 0x00, 0x00, 0x56, 0x00, 0x4d, 0x0d,
   0x00, 0x18, 0x6a, 0x00, 0xcb, 0x0a, 0x00, 0x00, 0x6a, 0x00, 0xcb, 0x0a,
   0x00, 0xe0, 0x57, 0x00, 0x4d, 0x0d, 0x00, 0x00, 0x56, 0x00, 0x4d, 0x0d,
   0x00, 0x20, 0x6b, 0x00, 0xcb, 0x0a, 0x00, 0x00, 0x6a, 0x00, 0xcb, 0x0a,
   0x00, 0xa0, 0x56, 0x00, 0x4f, 0x0d, 0x00, 0x00, 0x56, 0x00, 0x4f, 0x0d,
   0x00, 0x20, 0x6a, 0x00, 0xc0, 0x0a, 0x00, 0x00, 0x6a, 0x00, 0xc0, 0x0a,
   0x00, 0xa0, 0xd6, 0xff, 0x7f, 0x0d, 0x00, 0x00, 0xd6, 0xff, 0x7f, 0x0d,
   0x00, 0x20, 0xaa, 0xaa, 0xaa, 0x0a, 0x00, 0x00, 0xaa, 0xaa, 0xaa, 0x0a,
   0x00, 0xa0, 0x56, 0x55, 0x55, 0x0d, 0x00, 0x00, 0x56, 0x55, 0x55, 0x0d,
   0x00, 0x20, 0xfa, 0xff, 0xff, 0x0b, 0x00, 0x00, 0xfa, 0xff, 0xff, 0x0b,
   0x00, 0x40, 0x16, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x16, 0x00, 0x00, 0x0d,
   0x00, 0x80, 0x1a, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x1a, 0x00, 0x00, 0x0b,
   0x00, 0x00, 0xd7, 0xff, 0x7f, 0x0d, 0x00, 0x00, 0xd6, 0xff, 0x7f, 0x0d,
   0x00, 0x00, 0x1a, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x1a, 0x00, 0x00, 0x0b,
   0x00, 0x00, 0x16, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x16, 0x00, 0x00, 0x0d,
   0x00, 0x00, 0xda, 0xff, 0x7f, 0x0b, 0x00, 0x00, 0xda, 0xff, 0x7f, 0x0b,
   0x00, 0x00, 0x16, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x16, 0x00, 0x00, 0x0d,
   0x00, 0x80, 0x1b, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x1a, 0x00, 0x00, 0x0b,
   0x00, 0x40, 0xd6, 0xff, 0x7f, 0x0d, 0x00, 0x00, 0xd6, 0xff, 0x7f, 0x0d,
   0x00, 0xc0, 0x1b, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x1a, 0x00, 0x00, 0x0b,
   0x00, 0x00, 0x16, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x16, 0x00, 0x00, 0x0d,
   0xff, 0xff, 0xdb, 0xff, 0x7f, 0xfb, 0xff, 0xff, 0xdb, 0xff, 0x7f, 0xfb,
   0xff, 0xff, 0x17, 0x00, 0x00, 0xfd, 0xff, 0xff, 0x17, 0x00, 0x00, 0xfd,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
} }

blt_bitmap define dill-du-2 { {96 60} {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x40, 0x08, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xe0, 0x01, 0x20, 0x08, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x18, 0x1e, 0x20, 0x08, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x04, 0x20, 0x20, 0x08, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x02, 0x20, 0x20, 0x08, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x32, 0x40, 0x20, 0x08, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xc2, 0x8e, 0xe0, 0x08, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x02, 0x80, 0x10, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xc1, 0x86, 0x08, 0x02, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x21, 0x89, 0x1c, 0x0e, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x11, 0x91, 0x22, 0xf1, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xd1, 0x97, 0xe2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xd1, 0x97, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xe1, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x11, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xe1, 0x87, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x80, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x80, 0x04, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x60, 0x0e, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x18, 0x5c, 0x15, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0xe4, 0xff, 0xff, 0xf7, 0x00, 0x00, 0xe0, 0xff, 0xff, 0xf7, 0x00,
   0x00, 0x64, 0x05, 0x00, 0xdc, 0x00, 0x00, 0x60, 0x05, 0x00, 0xdc, 0x00,
   0x00, 0xa4, 0x06, 0xf0, 0xac, 0x00, 0x00, 0xa0, 0x06, 0xf0, 0xac, 0x00,
   0x00, 0x64, 0x05, 0xd0, 0xd4, 0x00, 0x00, 0x60, 0x05, 0xd0, 0xd4, 0x00,
   0x00, 0xb8, 0x06, 0xb0, 0xac, 0x00, 0x00, 0xa0, 0x06, 0xb0, 0xac, 0x00,
   0x00, 0x60, 0x05, 0xd0, 0xd4, 0x00, 0x00, 0x60, 0x05, 0xd0, 0xd4, 0x00,
   0x00, 0xa0, 0x06, 0xb0, 0xac, 0x00, 0x00, 0xa0, 0x06, 0xb0, 0xac, 0x00,
   0x00, 0x60, 0x05, 0xf0, 0xd4, 0x00, 0x00, 0x60, 0x05, 0xf0, 0xd4, 0x00,
   0x00, 0xa0, 0x06, 0x00, 0xac, 0x00, 0x00, 0xa0, 0x06, 0x00, 0xac, 0x00,
   0x00, 0x60, 0xfd, 0xff, 0xd7, 0x00, 0x00, 0x60, 0xfd, 0xff, 0xd7, 0x00,
   0x00, 0xa0, 0xaa, 0xaa, 0xaa, 0x00, 0x00, 0xa0, 0xaa, 0xaa, 0xaa, 0x00,
   0x00, 0x60, 0x55, 0x55, 0xd5, 0x00, 0x00, 0x60, 0x55, 0x55, 0xd5, 0x00,
   0x00, 0xa0, 0xff, 0xff, 0xbf, 0x00, 0x00, 0xa0, 0xff, 0xff, 0xbf, 0x00,
   0x00, 0x60, 0x01, 0x00, 0xd0, 0x00, 0x00, 0x60, 0x01, 0x00, 0xd0, 0x00,
   0x00, 0xa0, 0x01, 0x00, 0xb0, 0x00, 0x00, 0xa0, 0x01, 0x00, 0xb0, 0x00,
   0x00, 0x60, 0xfd, 0xff, 0xd7, 0x00, 0x00, 0x60, 0xfd, 0xff, 0xd7, 0x00,
   0x00, 0xa0, 0x01, 0x00, 0xb0, 0x00, 0x00, 0xa0, 0x01, 0x00, 0xb0, 0x00,
   0x00, 0x60, 0x01, 0x00, 0xd0, 0x00, 0x00, 0x60, 0x01, 0x00, 0xd0, 0x00,
   0x00, 0xa0, 0xfd, 0xff, 0xb7, 0x00, 0x00, 0xa0, 0xfd, 0xff, 0xb7, 0x00,
   0x00, 0x60, 0x01, 0x00, 0xd0, 0x00, 0x00, 0x60, 0x01, 0x00, 0xd0, 0x00,
   0x00, 0xa0, 0x01, 0x00, 0xb0, 0x00, 0x00, 0xa0, 0x01, 0x00, 0xb0, 0x00,
   0x00, 0x60, 0xfd, 0xff, 0xd7, 0x00, 0x00, 0x60, 0xfd, 0xff, 0xd7, 0x00,
   0x00, 0xa0, 0x01, 0x00, 0xb0, 0x00, 0x00, 0xa0, 0x01, 0x00, 0xb0, 0x00,
   0x00, 0x60, 0x01, 0x00, 0xd0, 0x00, 0x00, 0x60, 0x01, 0x00, 0xd0, 0x00,
   0xff, 0xbf, 0xfd, 0xff, 0xb7, 0xff, 0xff, 0xbf, 0xfd, 0xff, 0xb7, 0xff,
   0xff, 0x7f, 0x01, 0x00, 0xd0, 0xff, 0xff, 0x7f, 0x01, 0x00, 0xd0, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
} }

blt_bitmap define dill-du-3 { {96 60} {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x40, 0x48, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xe0, 0x01, 0x20, 0x48, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x18, 0x1e, 0x20, 0x48, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x04, 0x20, 0x20, 0x48, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x02, 0x20, 0x20, 0x08, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x32, 0x40, 0x20, 0x08, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xc2, 0x8e, 0xe0, 0x08, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x02, 0x80, 0x10, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xc1, 0x86, 0x08, 0x02, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x21, 0x89, 0x1c, 0x0e, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x11, 0x91, 0x22, 0xf1, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xd1, 0x97, 0xe2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xd1, 0x97, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xe1, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x11, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xe1, 0x87, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x80, 0x04, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x80, 0x0e, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x60, 0x1c, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x18, 0x78, 0x15, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0xfe, 0xff, 0x7f, 0x1f, 0x00, 0x00, 0xfe, 0xff, 0x7f, 0x0f, 0x00,
   0x00, 0x56, 0x00, 0xc0, 0x2d, 0x00, 0x00, 0x56, 0x00, 0xc0, 0x0d, 0x00,
   0x00, 0x6a, 0x00, 0xcf, 0x2a, 0x00, 0x00, 0x6a, 0x00, 0xcf, 0x0a, 0x00,
   0x00, 0x56, 0x00, 0x4d, 0x2d, 0x00, 0x00, 0x56, 0x00, 0x4d, 0x0d, 0x00,
   0x00, 0x6a, 0x00, 0xcb, 0x1a, 0x00, 0x00, 0x6a, 0x00, 0xcb, 0x0a, 0x00,
   0x00, 0x56, 0x00, 0x4d, 0x0d, 0x00, 0x00, 0x56, 0x00, 0x4d, 0x0d, 0x00,
   0x00, 0x6a, 0x00, 0xcb, 0x0a, 0x00, 0x00, 0x6a, 0x00, 0xcb, 0x0a, 0x00,
   0x00, 0x56, 0x00, 0x4f, 0x0d, 0x00, 0x00, 0x56, 0x00, 0x4f, 0x0d, 0x00,
   0x00, 0x6a, 0x00, 0xc0, 0x0a, 0x00, 0x00, 0x6a, 0x00, 0xc0, 0x0a, 0x00,
   0x00, 0xd6, 0xff, 0x7f, 0x0d, 0x00, 0x00, 0xd6, 0xff, 0x7f, 0x0d, 0x00,
   0x00, 0xaa, 0xaa, 0xaa, 0x0a, 0x00, 0x00, 0xaa, 0xaa, 0xaa, 0x0a, 0x00,
   0x00, 0x56, 0x55, 0x55, 0x0d, 0x00, 0x00, 0x56, 0x55, 0x55, 0x0d, 0x00,
   0x00, 0xfa, 0xff, 0xff, 0x0b, 0x00, 0x00, 0xfa, 0xff, 0xff, 0x0b, 0x00,
   0x00, 0x16, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x16, 0x00, 0x00, 0x0d, 0x00,
   0x00, 0x1a, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x1a, 0x00, 0x00, 0x0b, 0x00,
   0x00, 0xd6, 0xff, 0x7f, 0x0d, 0x00, 0x00, 0xd6, 0xff, 0x7f, 0x0d, 0x00,
   0x00, 0x1a, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x1a, 0x00, 0x00, 0x0b, 0x00,
   0x00, 0x16, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x16, 0x00, 0x00, 0x0d, 0x00,
   0x00, 0xda, 0xff, 0x7f, 0x0b, 0x00, 0x00, 0xda, 0xff, 0x7f, 0x0b, 0x00,
   0x00, 0x16, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x16, 0x00, 0x00, 0x0d, 0x00,
   0x00, 0x1a, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x1a, 0x00, 0x00, 0x0b, 0x00,
   0x00, 0xd6, 0xff, 0x7f, 0x0d, 0x00, 0x00, 0xd6, 0xff, 0x7f, 0x0d, 0x00,
   0x00, 0x1a, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x1a, 0x00, 0x00, 0x0b, 0x00,
   0x00, 0x16, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x16, 0x00, 0x00, 0x0d, 0x00,
   0xff, 0xdb, 0xff, 0x7f, 0xfb, 0xff, 0xff, 0xdb, 0xff, 0x7f, 0xfb, 0xff,
   0xff, 0x17, 0x00, 0x00, 0xfd, 0xff, 0xff, 0x17, 0x00, 0x00, 0xfd, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
} }

blt_bitmap define dill-du-4 { {96 60} {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x40, 0x48, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xe0, 0x01, 0x20, 0x48, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x18, 0x1e, 0x20, 0x48, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x04, 0x20, 0x20, 0x48, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x02, 0x20, 0x20, 0x48, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x32, 0x40, 0x20, 0x48, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xc2, 0x8e, 0xe0, 0x48, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x02, 0x80, 0x10, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xc1, 0x86, 0x08, 0x02, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x21, 0x89, 0x1c, 0x0e, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x11, 0x91, 0x22, 0xf1, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xd1, 0x97, 0xe2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xd1, 0x97, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xe1, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x11, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xe1, 0x87, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x80, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x80, 0x04, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x60, 0x0e, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x18, 0x5c, 0x15, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xe0, 0xff, 0xff, 0xf7, 0x10, 0x00, 0xe0, 0xff, 0xff, 0xf7, 0x00, 0x00,
   0x60, 0x05, 0x00, 0xdc, 0x20, 0x00, 0x60, 0x05, 0x00, 0xdc, 0x00, 0x00,
   0xa0, 0x06, 0xf0, 0xac, 0x21, 0x00, 0xa0, 0x06, 0xf0, 0xac, 0x00, 0x00,
   0x60, 0x05, 0xd0, 0xd4, 0x20, 0x00, 0x60, 0x05, 0xd0, 0xd4, 0x00, 0x00,
   0xa0, 0x06, 0xb0, 0xac, 0x10, 0x00, 0xa0, 0x06, 0xb0, 0xac, 0x00, 0x00,
   0x60, 0x05, 0xd0, 0xd4, 0x0e, 0x00, 0x60, 0x05, 0xd0, 0xd4, 0x00, 0x00,
   0xa0, 0x06, 0xb0, 0xac, 0x01, 0x00, 0xa0, 0x06, 0xb0, 0xac, 0x00, 0x00,
   0x60, 0x05, 0xf0, 0xd4, 0x00, 0x00, 0x60, 0x05, 0xf0, 0xd4, 0x00, 0x00,
   0xa0, 0x06, 0x00, 0xac, 0x00, 0x00, 0xa0, 0x06, 0x00, 0xac, 0x00, 0x00,
   0x60, 0xfd, 0xff, 0xd7, 0x00, 0x00, 0x60, 0xfd, 0xff, 0xd7, 0x00, 0x00,
   0xa0, 0xaa, 0xaa, 0xaa, 0x00, 0x00, 0xa0, 0xaa, 0xaa, 0xaa, 0x00, 0x00,
   0x60, 0x55, 0x55, 0xd5, 0x00, 0x00, 0x60, 0x55, 0x55, 0xd5, 0x00, 0x00,
   0xa0, 0xff, 0xff, 0xbf, 0x00, 0x00, 0xa0, 0xff, 0xff, 0xbf, 0x00, 0x00,
   0x60, 0x01, 0x00, 0xd0, 0x00, 0x00, 0x60, 0x01, 0x00, 0xd0, 0x00, 0x00,
   0xa0, 0x01, 0x00, 0xb0, 0x00, 0x00, 0xa0, 0x01, 0x00, 0xb0, 0x00, 0x00,
   0x60, 0xfd, 0xff, 0xd7, 0x00, 0x00, 0x60, 0xfd, 0xff, 0xd7, 0x00, 0x00,
   0xa0, 0x01, 0x00, 0xb0, 0x00, 0x00, 0xa0, 0x01, 0x00, 0xb0, 0x00, 0x00,
   0x60, 0x01, 0x00, 0xd0, 0x00, 0x00, 0x60, 0x01, 0x00, 0xd0, 0x00, 0x00,
   0xa0, 0xfd, 0xff, 0xb7, 0x00, 0x00, 0xa0, 0xfd, 0xff, 0xb7, 0x00, 0x00,
   0x60, 0x01, 0x00, 0xd0, 0x01, 0x00, 0x60, 0x01, 0x00, 0xd0, 0x00, 0x00,
   0xa0, 0x01, 0x00, 0xb0, 0x02, 0x00, 0xa0, 0x01, 0x00, 0xb0, 0x00, 0x00,
   0x60, 0xfd, 0xff, 0xd7, 0x03, 0x00, 0x60, 0xfd, 0xff, 0xd7, 0x00, 0x00,
   0xa0, 0x01, 0x00, 0xb0, 0x00, 0x00, 0xa0, 0x01, 0x00, 0xb0, 0x00, 0x00,
   0x60, 0x01, 0x00, 0xd0, 0x00, 0x00, 0x60, 0x01, 0x00, 0xd0, 0x00, 0x00,
   0xbf, 0xfd, 0xff, 0xb7, 0xff, 0xff, 0xbf, 0xfd, 0xff, 0xb7, 0xff, 0xff,
   0x7f, 0x01, 0x00, 0xd0, 0xff, 0xff, 0x7f, 0x01, 0x00, 0xd0, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
} }

blt_bitmap define dill-du-5 { {96 60} {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x40, 0x48, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xe0, 0x01, 0x20, 0x48, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x18, 0x1e, 0x20, 0x48, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x04, 0x20, 0x20, 0x48, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x02, 0x20, 0x20, 0x48, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x32, 0x40, 0x20, 0x48, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xc2, 0x8e, 0xe0, 0x48, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x02, 0x80, 0x10, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xc1, 0x86, 0x08, 0x02, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x21, 0x89, 0x1c, 0x0e, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x11, 0x91, 0x22, 0xf1, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xd1, 0x97, 0xe2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xd1, 0x97, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xe1, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x11, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xe1, 0x87, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x80, 0x04, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x80, 0x0e, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x60, 0x1c, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x18, 0x78, 0x15, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xfe, 0xff, 0x7f, 0x1f, 0x10, 0x00, 0xfe, 0xff, 0x7f, 0x0f, 0x00, 0x00,
   0x56, 0x00, 0xc0, 0x9d, 0x20, 0x00, 0x56, 0x00, 0xc0, 0x0d, 0x00, 0x00,
   0x6a, 0x00, 0xcf, 0xda, 0x21, 0x00, 0x6a, 0x00, 0xcf, 0x0a, 0x00, 0x00,
   0x56, 0x00, 0x4d, 0x3d, 0x20, 0x00, 0x56, 0x00, 0x4d, 0x0d, 0x00, 0x00,
   0x6a, 0x00, 0xcb, 0x0a, 0x10, 0x00, 0x6a, 0x00, 0xcb, 0x0a, 0x00, 0x00,
   0x56, 0x00, 0x4d, 0x0d, 0x0e, 0x00, 0x56, 0x00, 0x4d, 0x0d, 0x00, 0x00,
   0x6a, 0x00, 0xcb, 0xca, 0x01, 0x00, 0x6a, 0x00, 0xcb, 0x0a, 0x00, 0x00,
   0x56, 0x00, 0x4f, 0xbd, 0x00, 0x00, 0x56, 0x00, 0x4f, 0x0d, 0x00, 0x00,
   0x6a, 0x00, 0xc0, 0x9a, 0x00, 0x00, 0x6a, 0x00, 0xc0, 0x0a, 0x00, 0x00,
   0xd6, 0xff, 0x7f, 0x9d, 0x00, 0x00, 0xd6, 0xff, 0x7f, 0x0d, 0x00, 0x00,
   0xaa, 0xaa, 0xaa, 0x8a, 0x00, 0x00, 0xaa, 0xaa, 0xaa, 0x0a, 0x00, 0x00,
   0x56, 0x55, 0x55, 0x4d, 0x00, 0x00, 0x56, 0x55, 0x55, 0x0d, 0x00, 0x00,
   0xfa, 0xff, 0xff, 0x4b, 0x00, 0x00, 0xfa, 0xff, 0xff, 0x0b, 0x00, 0x00,
   0x16, 0x00, 0x00, 0x4d, 0x00, 0x00, 0x16, 0x00, 0x00, 0x0d, 0x00, 0x00,
   0x1a, 0x00, 0x00, 0x2b, 0x00, 0x00, 0x1a, 0x00, 0x00, 0x0b, 0x00, 0x00,
   0xd6, 0xff, 0x7f, 0x1d, 0x00, 0x00, 0xd6, 0xff, 0x7f, 0x0d, 0x00, 0x00,
   0x1a, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x1a, 0x00, 0x00, 0x0b, 0x00, 0x00,
   0x16, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x16, 0x00, 0x00, 0x0d, 0x00, 0x00,
   0xda, 0xff, 0x7f, 0x0b, 0x00, 0x00, 0xda, 0xff, 0x7f, 0x0b, 0x00, 0x00,
   0x16, 0x00, 0x00, 0xfd, 0x01, 0x00, 0x16, 0x00, 0x00, 0x0d, 0x00, 0x00,
   0x1a, 0x00, 0x00, 0x0b, 0x02, 0x00, 0x1a, 0x00, 0x00, 0x0b, 0x00, 0x00,
   0xd6, 0xff, 0x7f, 0xfd, 0x03, 0x00, 0xd6, 0xff, 0x7f, 0x0d, 0x00, 0x00,
   0x1a, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x1a, 0x00, 0x00, 0x0b, 0x00, 0x00,
   0x16, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x16, 0x00, 0x00, 0x0d, 0x00, 0x00,
   0xdb, 0xff, 0x7f, 0xfb, 0xff, 0xff, 0xdb, 0xff, 0x7f, 0xfb, 0xff, 0xff,
   0x17, 0x00, 0x00, 0xfd, 0xff, 0xff, 0x17, 0x00, 0x00, 0xfd, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
} }

blt_bitmap define dill-du-6 { {96 60} {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x40, 0x48, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xe0, 0x01, 0x20, 0x48, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x18, 0x1e, 0x20, 0x48, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x04, 0x20, 0x20, 0x48, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x02, 0x20, 0x20, 0x48, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x32, 0x40, 0x20, 0x48, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xc2, 0x8e, 0xe0, 0x48, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x02, 0x80, 0x10, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xc1, 0x86, 0x08, 0x02, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x21, 0x89, 0x1c, 0x0e, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x11, 0x91, 0x22, 0xf1, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xd1, 0x97, 0xe2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xd1, 0x97, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xe1, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x11, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xe1, 0x87, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x80, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x80, 0x04, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x60, 0x0e, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x18, 0x5c, 0x15, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xff, 0xff, 0xf7, 0x1f, 0x10, 0xe0, 0xff, 0xff, 0xf7, 0x00, 0x00, 0xe0,
   0x05, 0x00, 0xdc, 0x90, 0x20, 0x60, 0x05, 0x00, 0xdc, 0x00, 0x00, 0x60,
   0x06, 0xf0, 0xac, 0xd0, 0x21, 0xa0, 0x06, 0xf0, 0xac, 0x00, 0x00, 0xa0,
   0x05, 0xd0, 0xd4, 0x3c, 0x20, 0x60, 0x05, 0xd0, 0xd4, 0x00, 0x00, 0x60,
   0x06, 0xb0, 0xac, 0x02, 0x10, 0xa0, 0x06, 0xb0, 0xac, 0x00, 0x00, 0xa0,
   0x05, 0xd0, 0xd4, 0x02, 0x0e, 0x60, 0x05, 0xd0, 0xd4, 0x00, 0x00, 0x60,
   0x06, 0xb0, 0xac, 0xc2, 0x01, 0xa0, 0x06, 0xb0, 0xac, 0x00, 0x00, 0xa0,
   0x05, 0xf0, 0xd4, 0xbc, 0x00, 0x60, 0x05, 0xf0, 0xd4, 0x00, 0x00, 0x60,
   0x06, 0x00, 0xac, 0x90, 0x00, 0xa0, 0x06, 0x00, 0xac, 0x00, 0x00, 0xa0,
   0xfd, 0xff, 0xd7, 0x9f, 0x00, 0x60, 0xfd, 0xff, 0xd7, 0x00, 0x00, 0x60,
   0xaa, 0xaa, 0xaa, 0x80, 0x00, 0xa0, 0xaa, 0xaa, 0xaa, 0x00, 0x00, 0xa0,
   0x55, 0x55, 0xd5, 0x40, 0x00, 0x60, 0x55, 0x55, 0xd5, 0x00, 0x00, 0x60,
   0xff, 0xff, 0xbf, 0x40, 0x00, 0xa0, 0xff, 0xff, 0xbf, 0x00, 0x00, 0xa0,
   0x01, 0x00, 0xd0, 0x40, 0x00, 0x60, 0x01, 0x00, 0xd0, 0x00, 0x00, 0x60,
   0x01, 0x00, 0xb0, 0x21, 0x00, 0xa0, 0x01, 0x00, 0xb0, 0x00, 0x00, 0xa0,
   0xfd, 0xff, 0xd7, 0x18, 0x00, 0x60, 0xfd, 0xff, 0xd7, 0x00, 0x00, 0x60,
   0x01, 0x00, 0xb0, 0x07, 0x00, 0xa0, 0x01, 0x00, 0xb0, 0x00, 0x00, 0xa0,
   0x01, 0x00, 0xd0, 0x01, 0x00, 0x60, 0x01, 0x00, 0xd0, 0x00, 0x00, 0x60,
   0xfd, 0xff, 0xb7, 0x0f, 0x00, 0xa0, 0xfd, 0xff, 0xb7, 0x00, 0x00, 0xa0,
   0x01, 0x00, 0xd0, 0xf0, 0x01, 0x60, 0x01, 0x00, 0xd0, 0x00, 0x00, 0x60,
   0x01, 0x00, 0xb0, 0x01, 0x02, 0xa0, 0x01, 0x00, 0xb0, 0x00, 0x00, 0xa0,
   0xfd, 0xff, 0xd7, 0xff, 0x03, 0x60, 0xfd, 0xff, 0xd7, 0x00, 0x00, 0x60,
   0x01, 0x00, 0xb0, 0x01, 0x00, 0xa0, 0x01, 0x00, 0xb0, 0x00, 0x00, 0xa0,
   0x01, 0x00, 0xd0, 0x00, 0x00, 0x60, 0x01, 0x00, 0xd0, 0x00, 0x00, 0x60,
   0xfd, 0xff, 0xb7, 0xff, 0xff, 0xbf, 0xfd, 0xff, 0xb7, 0xff, 0xff, 0xbf,
   0x01, 0x00, 0xd0, 0xff, 0xff, 0x7f, 0x01, 0x00, 0xd0, 0xff, 0xff, 0x7f,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
} }

blt_bitmap define dill-du-7 { {96 60} {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x40, 0x48, 0x12, 0x02, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xe0, 0x01, 0x20, 0x48, 0x12, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x18, 0x1e, 0x20, 0x48, 0x12, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x04, 0x20, 0x20, 0x48, 0x12, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x02, 0x20, 0x20, 0x48, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x32, 0x40, 0x20, 0x48, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xc2, 0x8e, 0xe0, 0x48, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x02, 0x80, 0x10, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xc1, 0x86, 0x08, 0x02, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x21, 0x89, 0x1c, 0x0e, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x11, 0x91, 0x22, 0xf1, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xd1, 0x97, 0xe2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xd1, 0x97, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xe1, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x11, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xe1, 0x87, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x80, 0x04, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x80, 0x0e, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x60, 0x1c, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x18, 0x78, 0x15, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xff, 0x7f, 0xff, 0x1f, 0x10, 0xfe, 0xff, 0x7f, 0x0f, 0x00, 0x00, 0xfe,
   0x00, 0xc0, 0x6d, 0x90, 0x20, 0x56, 0x00, 0xc0, 0x0d, 0x00, 0x00, 0x56,
   0x00, 0xcf, 0x4a, 0xd0, 0x21, 0x6a, 0x00, 0xcf, 0x0a, 0x00, 0x00, 0x6a,
   0x00, 0x4d, 0x4d, 0x3c, 0x20, 0x56, 0x00, 0x4d, 0x0d, 0x00, 0x00, 0x56,
   0x00, 0xcb, 0x4a, 0x02, 0x10, 0x6a, 0x00, 0xcb, 0x0a, 0x00, 0x00, 0x6a,
   0x00, 0x4d, 0x4d, 0x02, 0x0e, 0x56, 0x00, 0x4d, 0x0d, 0x00, 0x00, 0x56,
   0x00, 0xcb, 0x5a, 0xc2, 0x01, 0x6a, 0x00, 0xcb, 0x0a, 0x00, 0x00, 0x6a,
   0x00, 0x4f, 0x6d, 0xbc, 0x00, 0x56, 0x00, 0x4f, 0x0d, 0x00, 0x00, 0x56,
   0x00, 0xc0, 0x4a, 0x90, 0x00, 0x6a, 0x00, 0xc0, 0x0a, 0x00, 0x00, 0x6a,
   0xff, 0x7f, 0xcd, 0x9f, 0x00, 0xd6, 0xff, 0x7f, 0x0d, 0x00, 0x00, 0xd6,
   0xaa, 0xaa, 0x0a, 0x80, 0x00, 0xaa, 0xaa, 0xaa, 0x0a, 0x00, 0x00, 0xaa,
   0x55, 0x55, 0x0d, 0x40, 0x00, 0x56, 0x55, 0x55, 0x0d, 0x00, 0x00, 0x56,
   0xff, 0xff, 0x0b, 0x40, 0x00, 0xfa, 0xff, 0xff, 0x0b, 0x00, 0x00, 0xfa,
   0x00, 0x00, 0x0d, 0x40, 0x00, 0x16, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x16,
   0x00, 0x00, 0x5b, 0x21, 0x00, 0x1a, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x1a,
   0xff, 0x7f, 0x0d, 0x18, 0x00, 0xd6, 0xff, 0x7f, 0x0d, 0x00, 0x00, 0xd6,
   0x00, 0x00, 0xfb, 0x07, 0x00, 0x1a, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x1a,
   0x00, 0x00, 0xfd, 0x01, 0x00, 0x16, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x16,
   0xff, 0x7f, 0x5b, 0x0f, 0x00, 0xda, 0xff, 0x7f, 0x0b, 0x00, 0x00, 0xda,
   0x00, 0x00, 0x6d, 0xf0, 0x01, 0x16, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x16,
   0x00, 0x00, 0x8b, 0x01, 0x02, 0x1a, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x1a,
   0xff, 0x7f, 0x0d, 0xff, 0x03, 0xd6, 0xff, 0x7f, 0x0d, 0x00, 0x00, 0xd6,
   0x00, 0x00, 0xfb, 0x01, 0x00, 0x1a, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x1a,
   0x00, 0x00, 0x0d, 0x00, 0x00, 0x16, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x16,
   0xff, 0x7f, 0xfb, 0xff, 0xff, 0xdb, 0xff, 0x7f, 0xfb, 0xff, 0xff, 0xdb,
   0x00, 0x00, 0xfd, 0xff, 0xff, 0x17, 0x00, 0x00, 0xfd, 0xff, 0xff, 0x17,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
} }

blt_bitmap define dill-du-8 { {96 60} {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x40, 0x48, 0x12, 0x02, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xe0, 0x01, 0x20, 0x48, 0x12, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x18, 0x1e, 0x20, 0x48, 0x12, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x04, 0x20, 0x20, 0x48, 0x12, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x02, 0x20, 0x20, 0x48, 0x12, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x32, 0x40, 0x20, 0x48, 0x12, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xc2, 0x8e, 0xe0, 0x48, 0x12, 0x02, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x02, 0x80, 0x10, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xc1, 0x86, 0x08, 0x02, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x21, 0x89, 0x1c, 0x0e, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x11, 0x91, 0x22, 0xf1, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xd1, 0x97, 0xe2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xd1, 0x97, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xe1, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x11, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xe1, 0x87, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x80, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x80, 0x04, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x60, 0x0e, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x18, 0x5c, 0x15, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xff, 0xf7, 0xf8, 0x1f, 0xf0, 0xff, 0xff, 0xf7, 0x00, 0x00, 0xe0, 0xff,
   0x00, 0xdc, 0x73, 0x90, 0x60, 0x05, 0x00, 0xdc, 0x00, 0x00, 0x60, 0x05,
   0xf0, 0xac, 0x7c, 0xd0, 0xa1, 0x06, 0xf0, 0xac, 0x00, 0x00, 0xa0, 0x06,
   0xd0, 0xd4, 0x60, 0x3c, 0x60, 0x05, 0xd0, 0xd4, 0x00, 0x00, 0x60, 0x05,
   0xb0, 0xac, 0x40, 0x02, 0xb0, 0x06, 0xb0, 0xac, 0x00, 0x00, 0xa0, 0x06,
   0xd0, 0xd4, 0x41, 0x02, 0x6e, 0x05, 0xd0, 0xd4, 0x00, 0x00, 0x60, 0x05,
   0xb0, 0xac, 0x5f, 0xc2, 0xa1, 0x06, 0xb0, 0xac, 0x00, 0x00, 0xa0, 0x06,
   0xf0, 0xd4, 0x64, 0xbc, 0x60, 0x05, 0xf0, 0xd4, 0x00, 0x00, 0x60, 0x05,
   0x00, 0xac, 0x42, 0x90, 0xa0, 0x06, 0x00, 0xac, 0x00, 0x00, 0xa0, 0x06,
   0xff, 0xd7, 0xc0, 0x9f, 0x60, 0xfd, 0xff, 0xd7, 0x00, 0x00, 0x60, 0xfd,
   0xaa, 0xaa, 0x02, 0x80, 0xa0, 0xaa, 0xaa, 0xaa, 0x00, 0x00, 0xa0, 0xaa,
   0x55, 0xd5, 0x00, 0x40, 0x60, 0x55, 0x55, 0xd5, 0x00, 0x00, 0x60, 0x55,
   0xff, 0xbf, 0x02, 0x40, 0xa0, 0xff, 0xff, 0xbf, 0x00, 0x00, 0xa0, 0xff,
   0x00, 0xd0, 0x04, 0x40, 0x60, 0x01, 0x00, 0xd0, 0x00, 0x00, 0x60, 0x01,
   0x00, 0xb0, 0x50, 0x21, 0xa0, 0x01, 0x00, 0xb0, 0x00, 0x00, 0xa0, 0x01,
   0xff, 0xd7, 0x03, 0x18, 0x60, 0xfd, 0xff, 0xd7, 0x00, 0x00, 0x60, 0xfd,
   0x00, 0xb0, 0xfc, 0x07, 0xa0, 0x01, 0x00, 0xb0, 0x00, 0x00, 0xa0, 0x01,
   0x00, 0xd0, 0xf8, 0x01, 0x60, 0x01, 0x00, 0xd0, 0x00, 0x00, 0x60, 0x01,
   0xff, 0xb7, 0x58, 0x0f, 0xa0, 0xfd, 0xff, 0xb7, 0x00, 0x00, 0xa0, 0xfd,
   0x00, 0xd0, 0x66, 0xf0, 0x61, 0x01, 0x00, 0xd0, 0x00, 0x00, 0x60, 0x01,
   0x00, 0xb0, 0x81, 0x01, 0xa2, 0x01, 0x00, 0xb0, 0x00, 0x00, 0xa0, 0x01,
   0xff, 0xd7, 0x00, 0xff, 0x63, 0xfd, 0xff, 0xd7, 0x00, 0x00, 0x60, 0xfd,
   0x00, 0xb0, 0xff, 0x01, 0xa0, 0x01, 0x00, 0xb0, 0x00, 0x00, 0xa0, 0x01,
   0x00, 0xd0, 0x00, 0x00, 0x60, 0x01, 0x00, 0xd0, 0x00, 0x00, 0x60, 0x01,
   0xff, 0xb7, 0xff, 0xff, 0xbf, 0xfd, 0xff, 0xb7, 0xff, 0xff, 0xbf, 0xfd,
   0x00, 0xd0, 0xff, 0xff, 0x7f, 0x01, 0x00, 0xd0, 0xff, 0xff, 0x7f, 0x01,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
} }

blt_bitmap define dill-du-9 { {96 60} {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x40, 0x48, 0x12, 0x02, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xe0, 0x01, 0x20, 0x4e, 0x12, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x18, 0x1e, 0x20, 0x78, 0x12, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x04, 0x20, 0x20, 0xc8, 0x12, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x02, 0x20, 0x20, 0x48, 0x12, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x32, 0x40, 0x20, 0x48, 0x12, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xc2, 0x8e, 0xe0, 0x48, 0x12, 0x02, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x02, 0x80, 0x10, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xc1, 0x86, 0x08, 0x02, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x21, 0x89, 0x1c, 0x0e, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x11, 0x91, 0x22, 0xf1, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xd1, 0x97, 0xe2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xd1, 0x97, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xe1, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x11, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xe1, 0x87, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x80, 0x04, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x80, 0x0e, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x60, 0x1c, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x18, 0x78, 0x15, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x7f, 0x0f, 0xf0, 0x1f, 0xfe, 0xff, 0x7f, 0x0f, 0x00, 0x00, 0xfe, 0xff,
   0xc0, 0x8d, 0x7f, 0x90, 0x76, 0x00, 0xc0, 0x0d, 0x00, 0x00, 0x56, 0x00,
   0xcf, 0x0a, 0x60, 0xd0, 0x6b, 0x00, 0xcf, 0x0a, 0x00, 0x00, 0x6a, 0x00,
   0x4d, 0x0d, 0x40, 0x3c, 0x76, 0x00, 0x4d, 0x0d, 0x00, 0x00, 0x56, 0x00,
   0xcb, 0x1a, 0x40, 0x02, 0x7a, 0x00, 0xcb, 0x0a, 0x00, 0x00, 0x6a, 0x00,
   0x4d, 0xed, 0x41, 0x02, 0x5e, 0x00, 0x4d, 0x0d, 0x00, 0x00, 0x56, 0x00,
   0xcb, 0x2a, 0x5f, 0xc2, 0x6b, 0x00, 0xcb, 0x0a, 0x00, 0x00, 0x6a, 0x00,
   0x4f, 0xad, 0x64, 0xbc, 0x56, 0x00, 0x4f, 0x0d, 0x00, 0x00, 0x56, 0x00,
   0xc0, 0x2a, 0x42, 0x90, 0x6a, 0x00, 0xc0, 0x0a, 0x00, 0x00, 0x6a, 0x00,
   0x7f, 0xad, 0xc0, 0x9f, 0xd6, 0xff, 0x7f, 0x0d, 0x00, 0x00, 0xd6, 0xff,
   0xaa, 0x2a, 0x02, 0x80, 0xaa, 0xaa, 0xaa, 0x0a, 0x00, 0x00, 0xaa, 0xaa,
   0x55, 0xad, 0x00, 0x40, 0x56, 0x55, 0x55, 0x0d, 0x00, 0x00, 0x56, 0x55,
   0xff, 0x2b, 0x02, 0x40, 0xfa, 0xff, 0xff, 0x0b, 0x00, 0x00, 0xfa, 0xff,
   0x00, 0x4d, 0x04, 0x40, 0x16, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x16, 0x00,
   0x00, 0x8b, 0x50, 0x21, 0x1a, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x1a, 0x00,
   0x7f, 0x0d, 0x03, 0x18, 0xd6, 0xff, 0x7f, 0x0d, 0x00, 0x00, 0xd6, 0xff,
   0x00, 0x0b, 0xfc, 0x07, 0x1a, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x1a, 0x00,
   0x00, 0x0d, 0xf8, 0x01, 0x16, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x16, 0x00,
   0x7f, 0x0b, 0x58, 0x0f, 0xda, 0xff, 0x7f, 0x0b, 0x00, 0x00, 0xda, 0xff,
   0x00, 0x0d, 0x66, 0xf0, 0x17, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x16, 0x00,
   0x00, 0x8b, 0x81, 0x01, 0x1a, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x1a, 0x00,
   0x7f, 0x4d, 0x00, 0xff, 0xd7, 0xff, 0x7f, 0x0d, 0x00, 0x00, 0xd6, 0xff,
   0x00, 0xcb, 0xff, 0x01, 0x1a, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x1a, 0x00,
   0x00, 0x0d, 0x00, 0x00, 0x16, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x16, 0x00,
   0x7f, 0xfb, 0xff, 0xff, 0xdb, 0xff, 0x7f, 0xfb, 0xff, 0xff, 0xdb, 0xff,
   0x00, 0xfd, 0xff, 0xff, 0x17, 0x00, 0x00, 0xfd, 0xff, 0xff, 0x17, 0x00,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
} }

blt_bitmap define dill-du-10 { {96 60} {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x40, 0x48, 0x12, 0x02, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xe0, 0x01, 0x20, 0x4e, 0x12, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x18, 0x1e, 0x20, 0x78, 0x12, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x04, 0x20, 0x20, 0xc8, 0x13, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x02, 0x20, 0x20, 0x48, 0x1e, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x32, 0x40, 0x20, 0x48, 0x72, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xc2, 0x8e, 0xe0, 0x48, 0x12, 0x02, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x02, 0x80, 0x10, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xc1, 0x86, 0x08, 0x02, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x21, 0x89, 0x1c, 0x0e, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x11, 0x91, 0x22, 0xf1, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xd1, 0x97, 0xe2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xd1, 0x97, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xe1, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x11, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xe1, 0x87, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x80, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x80, 0x04, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x60, 0x0e, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x18, 0x5c, 0x15, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xf7, 0x04, 0xf8, 0xff, 0xff, 0xff, 0xf7, 0x00, 0x00, 0xe0, 0xff, 0xff,
   0xdc, 0x84, 0x73, 0x70, 0x05, 0x00, 0xdc, 0x00, 0x00, 0x60, 0x05, 0x00,
   0xac, 0x04, 0x7c, 0xb0, 0x06, 0xf0, 0xac, 0x00, 0x00, 0xa0, 0x06, 0xf0,
   0xd4, 0x04, 0x60, 0x7c, 0x05, 0xd0, 0xd4, 0x00, 0x00, 0x60, 0x05, 0xd0,
   0xac, 0x18, 0x40, 0xa2, 0x06, 0xb0, 0xac, 0x00, 0x00, 0xa0, 0x06, 0xb0,
   0xd4, 0xe0, 0x41, 0x62, 0x05, 0xd0, 0xd4, 0x00, 0x00, 0x60, 0x05, 0xd0,
   0xac, 0x20, 0x5f, 0xa2, 0x06, 0xb0, 0xac, 0x00, 0x00, 0xa0, 0x06, 0xb0,
   0xd4, 0xa0, 0x64, 0x7c, 0x05, 0xf0, 0xd4, 0x00, 0x00, 0x60, 0x05, 0xf0,
   0xac, 0x20, 0x42, 0xb0, 0x06, 0x00, 0xac, 0x00, 0x00, 0xa0, 0x06, 0x00,
   0xd7, 0xa0, 0xc0, 0x7f, 0xfd, 0xff, 0xd7, 0x00, 0x00, 0x60, 0xfd, 0xff,
   0xaa, 0x20, 0x02, 0xa0, 0xaa, 0xaa, 0xaa, 0x00, 0x00, 0xa0, 0xaa, 0xaa,
   0xd5, 0xa0, 0x00, 0x60, 0x55, 0x55, 0xd5, 0x00, 0x00, 0x60, 0x55, 0x55,
   0xbf, 0x20, 0x02, 0xa0, 0xff, 0xff, 0xbf, 0x00, 0x00, 0xa0, 0xff, 0xff,
   0xd0, 0x40, 0x04, 0x60, 0x01, 0x00, 0xd0, 0x00, 0x00, 0x60, 0x01, 0x00,
   0xb0, 0x80, 0x50, 0xa1, 0x01, 0x00, 0xb0, 0x00, 0x00, 0xa0, 0x01, 0x00,
   0xd7, 0x00, 0x03, 0x78, 0xfd, 0xff, 0xd7, 0x00, 0x00, 0x60, 0xfd, 0xff,
   0xb0, 0x00, 0xfc, 0xa7, 0x01, 0x00, 0xb0, 0x00, 0x00, 0xa0, 0x01, 0x00,
   0xd0, 0x00, 0xf8, 0x61, 0x01, 0x00, 0xd0, 0x00, 0x00, 0x60, 0x01, 0x00,
   0xb7, 0x00, 0x58, 0xaf, 0xfd, 0xff, 0xb7, 0x00, 0x00, 0xa0, 0xfd, 0xff,
   0xd0, 0x00, 0x66, 0x70, 0x01, 0x00, 0xd0, 0x00, 0x00, 0x60, 0x01, 0x00,
   0xb0, 0x80, 0x81, 0xa1, 0x01, 0x00, 0xb0, 0x00, 0x00, 0xa0, 0x01, 0x00,
   0xd7, 0x40, 0x00, 0x7f, 0xfd, 0xff, 0xd7, 0x00, 0x00, 0x60, 0xfd, 0xff,
   0xb0, 0xc0, 0xff, 0xa1, 0x01, 0x00, 0xb0, 0x00, 0x00, 0xa0, 0x01, 0x00,
   0xd0, 0x00, 0x00, 0x60, 0x01, 0x00, 0xd0, 0x00, 0x00, 0x60, 0x01, 0x00,
   0xb7, 0xff, 0xff, 0xbf, 0xfd, 0xff, 0xb7, 0xff, 0xff, 0xbf, 0xfd, 0xff,
   0xd0, 0xff, 0xff, 0x7f, 0x01, 0x00, 0xd0, 0xff, 0xff, 0x7f, 0x01, 0x00,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
} }

blt_bitmap define dill-du-11 { {96 60} {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x40, 0x48, 0x12, 0x02, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xe0, 0x01, 0x20, 0x4e, 0x12, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x18, 0x1e, 0x20, 0x78, 0x12, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x04, 0x20, 0x20, 0xc8, 0x13, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x02, 0x20, 0x20, 0x48, 0x1e, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x32, 0x40, 0x20, 0x48, 0x72, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xc2, 0x8e, 0xe0, 0x48, 0x12, 0x02, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x02, 0x80, 0x10, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xc1, 0x86, 0x08, 0x02, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x21, 0x89, 0x1c, 0x0e, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x11, 0x91, 0x22, 0xf1, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xd1, 0x97, 0xe2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xd1, 0x97, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xe1, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x11, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xe1, 0x87, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x80, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x80, 0x04, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x60, 0x0e, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x18, 0x5c, 0x15, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x0f, 0x04, 0xf8, 0xff, 0xff, 0x7f, 0x0f, 0x00, 0x00, 0xfe, 0xff, 0x7f,
   0x0d, 0x84, 0x73, 0x56, 0x00, 0xc0, 0x0d, 0x00, 0x00, 0x56, 0x00, 0xc0,
   0x0a, 0x04, 0x7c, 0x6a, 0x00, 0xcf, 0x0a, 0x00, 0x00, 0x6a, 0x00, 0xcf,
   0x0d, 0x04, 0x60, 0x56, 0x00, 0x4d, 0x0d, 0x00, 0x00, 0x56, 0x00, 0x4d,
   0x0a, 0x18, 0x40, 0x6a, 0x00, 0xcb, 0x0a, 0x00, 0x00, 0x6a, 0x00, 0xcb,
   0x0d, 0xe0, 0x41, 0x56, 0x00, 0x4d, 0x0d, 0x00, 0x00, 0x56, 0x00, 0x4d,
   0x0a, 0x20, 0x5f, 0x6a, 0x00, 0xcb, 0x0a, 0x00, 0x00, 0x6a, 0x00, 0xcb,
   0x0d, 0xa0, 0x64, 0x56, 0x00, 0x4f, 0x0d, 0x00, 0x00, 0x56, 0x00, 0x4f,
   0x0a, 0x20, 0x42, 0x6a, 0x00, 0xc0, 0x0a, 0x00, 0x00, 0x6a, 0x00, 0xc0,
   0x0d, 0xa0, 0xc0, 0xd7, 0xff, 0x7f, 0x0d, 0x00, 0x00, 0xd6, 0xff, 0x7f,
   0x0a, 0x20, 0x02, 0xaa, 0xaa, 0xaa, 0x0a, 0x00, 0x00, 0xaa, 0xaa, 0xaa,
   0x0d, 0xa0, 0x00, 0x56, 0x55, 0x55, 0x0d, 0x00, 0x00, 0x56, 0x55, 0x55,
   0x0b, 0x20, 0x02, 0xfa, 0xff, 0xff, 0x0b, 0x00, 0x00, 0xfa, 0xff, 0xff,
   0x0d, 0x40, 0x04, 0x16, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x16, 0x00, 0x00,
   0x0b, 0x80, 0x50, 0x1b, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x1a, 0x00, 0x00,
   0x0d, 0x00, 0x03, 0xd6, 0xff, 0x7f, 0x0d, 0x00, 0x00, 0xd6, 0xff, 0x7f,
   0x0b, 0x00, 0xfc, 0x1b, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x1a, 0x00, 0x00,
   0x0d, 0x00, 0xf8, 0x17, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x16, 0x00, 0x00,
   0x0b, 0x00, 0x58, 0xdb, 0xff, 0x7f, 0x0b, 0x00, 0x00, 0xda, 0xff, 0x7f,
   0x0d, 0x00, 0x66, 0x16, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x16, 0x00, 0x00,
   0x0b, 0x80, 0x81, 0x1b, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x1a, 0x00, 0x00,
   0x0d, 0x40, 0x00, 0xd7, 0xff, 0x7f, 0x0d, 0x00, 0x00, 0xd6, 0xff, 0x7f,
   0x0b, 0xc0, 0xff, 0x1b, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x1a, 0x00, 0x00,
   0x0d, 0x00, 0x00, 0x16, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x16, 0x00, 0x00,
   0xfb, 0xff, 0xff, 0xdb, 0xff, 0x7f, 0xfb, 0xff, 0xff, 0xdb, 0xff, 0x7f,
   0xfd, 0xff, 0xff, 0x17, 0x00, 0x00, 0xfd, 0xff, 0xff, 0x17, 0x00, 0x00,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
} }

blt_bitmap define new-folder { {32 32} {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xf8, 0x1f, 0x00, 0x00, 0x04, 0x20, 0x00, 0x00, 0x02, 0x40, 0x00, 0x00,
   0x01, 0x80, 0xff, 0x3f, 0x01, 0x00, 0x00, 0x40, 0x01, 0x00, 0x00, 0xc0,
   0xf9, 0xff, 0xff, 0xcf, 0x09, 0x00, 0x00, 0xc8, 0x09, 0x00, 0x00, 0xc8,
   0x09, 0x00, 0x00, 0xc8, 0x09, 0x00, 0x00, 0xc8, 0x09, 0x00, 0x00, 0xc8,
   0x09, 0x00, 0x00, 0xc8, 0x09, 0x00, 0x00, 0xc8, 0x09, 0x00, 0x00, 0xc8,
   0x09, 0x00, 0x00, 0xc8, 0x09, 0x00, 0x00, 0xc8, 0x09, 0x00, 0x00, 0xc8,
   0x09, 0x00, 0x00, 0xc8, 0x09, 0x00, 0x00, 0xc8, 0xf9, 0xff, 0xff, 0xcf,
   0x01, 0x00, 0x00, 0xc0, 0x01, 0x00, 0x00, 0xc0, 0xff, 0xff, 0xff, 0xff,
   0xfe, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
} }

blt_bitmap define dusty-folder { {32 32} {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xf8, 0x1f, 0x00, 0x00, 0x04, 0x20, 0x00, 0x00, 0x02, 0x40, 0x00, 0x00,
   0x01, 0x80, 0xff, 0x3f, 0x01, 0x00, 0x00, 0x40, 0x01, 0x00, 0x00, 0xc0,
   0xf9, 0xff, 0xff, 0xcf, 0x09, 0x02, 0x00, 0xc8, 0x09, 0x02, 0x00, 0xc8,
   0x09, 0x02, 0x00, 0xc8, 0x89, 0x0a, 0x00, 0xc8, 0x09, 0x07, 0x00, 0xc8,
   0x09, 0x07, 0x00, 0xc8, 0x09, 0x07, 0x00, 0xc8, 0x89, 0x08, 0x00, 0xc8,
   0x09, 0x00, 0x00, 0xc8, 0x09, 0x00, 0x00, 0xc8, 0x09, 0x00, 0x00, 0xc8,
   0x09, 0x00, 0x00, 0xc8, 0x09, 0x00, 0x00, 0xc8, 0xf9, 0xff, 0xff, 0xcf,
   0x01, 0x00, 0x00, 0xc0, 0x01, 0x00, 0x00, 0xc0, 0xff, 0xff, 0xff, 0xff,
   0xfe, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
} }

blt_bitmap define old-folder { {32 32} {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xf8, 0x1f, 0x00, 0x00, 0x04, 0x20, 0x00, 0x00, 0x02, 0x40, 0x00, 0x00,
   0x01, 0x80, 0xff, 0x3f, 0x01, 0x00, 0x00, 0x40, 0x01, 0x00, 0x00, 0xc0,
   0xf9, 0xff, 0xff, 0xcf, 0x09, 0x02, 0x00, 0xc8, 0x09, 0x02, 0x00, 0xc8,
   0x09, 0x02, 0x00, 0xcc, 0x89, 0x0a, 0x00, 0xca, 0x09, 0x07, 0x00, 0xc9,
   0x09, 0x07, 0x80, 0xc9, 0x09, 0x07, 0x40, 0xca, 0x89, 0x08, 0xa0, 0xca,
   0x09, 0x00, 0x98, 0xca, 0x09, 0x00, 0x76, 0xca, 0x29, 0x88, 0x93, 0xcb,
   0x09, 0x62, 0x7c, 0xc9, 0x49, 0x18, 0x11, 0xca, 0xf9, 0xff, 0xff, 0xcf,
   0x01, 0x00, 0x00, 0xc0, 0x01, 0x00, 0x00, 0xc0, 0xff, 0xff, 0xff, 0xff,
   0xfe, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
} }

blt_bitmap define moldy-folder { {32 32} {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xf8, 0x1f, 0x00, 0x00, 0x04, 0x20, 0x00, 0x00, 0x02, 0x40, 0x00, 0x00,
   0x01, 0x80, 0xff, 0x3f, 0x01, 0x00, 0x00, 0x40, 0x01, 0x00, 0x00, 0xc0,
   0xf9, 0xff, 0xff, 0xcf, 0x29, 0x22, 0x10, 0xc9, 0x09, 0x42, 0x10, 0xcc,
   0x19, 0x82, 0x10, 0xc8, 0x89, 0x0a, 0xfd, 0xc8, 0x09, 0x07, 0x12, 0xc9,
   0x09, 0x07, 0x75, 0xce, 0x09, 0x07, 0x99, 0xcb, 0x89, 0x08, 0xf5, 0xca,
   0x09, 0x00, 0x99, 0xca, 0x09, 0x41, 0x76, 0xca, 0xa9, 0x88, 0x93, 0xcb,
   0x09, 0x62, 0x7c, 0xc9, 0x49, 0x18, 0x11, 0xca, 0xf9, 0xff, 0xff, 0xcf,
   0x01, 0x00, 0x00, 0xc0, 0x01, 0x00, 0x00, 0xc0, 0xff, 0xff, 0xff, 0xff,
   0xfe, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
} }

blt_bitmap define new-file { {32 32} {
   0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0x03, 0x80, 0x00, 0x00, 0x06,
   0x80, 0x00, 0x00, 0x0a, 0x80, 0x00, 0x00, 0x12, 0x80, 0x00, 0x00, 0x22,
   0x80, 0x00, 0x00, 0x7e, 0x80, 0x00, 0x00, 0xc0, 0x80, 0xfc, 0xff, 0xcf,
   0x80, 0x04, 0x00, 0xc8, 0x80, 0x04, 0x00, 0xc8, 0x80, 0x04, 0x00, 0xc8,
   0x80, 0x04, 0x00, 0xc8, 0x80, 0x04, 0x00, 0xc8, 0x80, 0x04, 0x00, 0xc8,
   0x80, 0x04, 0x00, 0xc8, 0x80, 0x04, 0x00, 0xc8, 0x80, 0x04, 0x00, 0xc8,
   0x80, 0x04, 0x00, 0xc8, 0x80, 0x04, 0x00, 0xc8, 0x80, 0x04, 0x00, 0xc8,
   0x80, 0x04, 0x00, 0xc8, 0x80, 0x04, 0x00, 0xc8, 0x80, 0x04, 0x00, 0xc8,
   0x80, 0x04, 0x00, 0xc8, 0x80, 0x04, 0x00, 0xc8, 0x80, 0x04, 0x00, 0xc8,
   0x80, 0xfc, 0xff, 0xcf, 0x80, 0x00, 0x00, 0xc0, 0x80, 0x00, 0x00, 0xc0,
   0x80, 0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff
} }

blt_bitmap define dusty-file { {32 32} {
   0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0x03, 0x80, 0x00, 0x00, 0x06,
   0x80, 0x00, 0x00, 0x0a, 0x80, 0x00, 0x00, 0x12, 0x80, 0x00, 0x00, 0x22,
   0x80, 0x00, 0x00, 0x7e, 0x80, 0x00, 0x00, 0xc0, 0x80, 0xfc, 0xff, 0xcf,
   0x80, 0x84, 0x00, 0xc8, 0x80, 0x84, 0x00, 0xc8, 0x80, 0xa4, 0x02, 0xc8,
   0x80, 0xc4, 0x01, 0xc8, 0x80, 0xc4, 0x01, 0xc8, 0x80, 0xc4, 0x01, 0xc8,
   0x80, 0x24, 0x02, 0xc8, 0x80, 0x04, 0x00, 0xc8, 0x80, 0x04, 0x00, 0xc8,
   0x80, 0x04, 0x00, 0xc8, 0x80, 0x04, 0x00, 0xc8, 0x80, 0x04, 0x00, 0xc8,
   0x80, 0x04, 0x00, 0xc8, 0x80, 0x04, 0x00, 0xc8, 0x80, 0x04, 0x00, 0xc8,
   0x80, 0x04, 0x00, 0xc8, 0x80, 0x04, 0x00, 0xc8, 0x80, 0x04, 0x00, 0xc8,
   0x80, 0xfc, 0xff, 0xcf, 0x80, 0x00, 0x00, 0xc0, 0x80, 0x00, 0x00, 0xc0,
   0x80, 0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff
} }

blt_bitmap define old-file { {32 32} {
   0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0x03, 0x80, 0x00, 0x00, 0x06,
   0x80, 0x00, 0x00, 0x0a, 0x80, 0x00, 0x00, 0x12, 0x80, 0x00, 0x00, 0x22,
   0x80, 0x00, 0x00, 0x7e, 0x80, 0x00, 0x00, 0xc0, 0x80, 0xfc, 0xff, 0xcf,
   0x80, 0x84, 0x00, 0xc8, 0x80, 0x84, 0x00, 0xcc, 0x80, 0xa4, 0x82, 0xcc,
   0x80, 0xc4, 0x11, 0xca, 0x80, 0xc4, 0x01, 0xca, 0x80, 0xc4, 0x01, 0xc9,
   0x80, 0x24, 0x02, 0xc9, 0x80, 0x04, 0x80, 0xc8, 0x80, 0x04, 0x80, 0xc8,
   0x80, 0x04, 0x40, 0xc9, 0x80, 0x04, 0x40, 0xce, 0x80, 0x04, 0xa0, 0xcb,
   0x80, 0x04, 0xf0, 0xca, 0x80, 0x44, 0x98, 0xca, 0x80, 0x14, 0x76, 0xca,
   0x80, 0x84, 0x8b, 0xcb, 0x80, 0x64, 0x7c, 0xce, 0x80, 0x1c, 0x05, 0xc8,
   0x80, 0xfc, 0xff, 0xcf, 0x80, 0x00, 0x00, 0xc0, 0x80, 0x00, 0x00, 0xc0,
   0x80, 0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff
} }

blt_bitmap define moldy-file { {32 32} {
   0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0x03, 0x80, 0x00, 0x00, 0x06,
   0x80, 0x00, 0x00, 0x0a, 0x80, 0x00, 0x00, 0x12, 0x80, 0x00, 0x00, 0x22,
   0x80, 0x00, 0x00, 0x7e, 0x80, 0x00, 0x00, 0xc0, 0x80, 0xfc, 0xff, 0xcf,
   0x80, 0x84, 0x08, 0xc9, 0x80, 0x84, 0x20, 0xcc, 0x80, 0xa4, 0x82, 0xcc,
   0x80, 0xc4, 0x11, 0xca, 0x80, 0xc4, 0x01, 0xca, 0x80, 0xc4, 0x01, 0xc9,
   0x80, 0x24, 0x02, 0xc9, 0x80, 0x04, 0x80, 0xc8, 0x80, 0x04, 0xfc, 0xc8,
   0x80, 0x1c, 0x42, 0xc9, 0x80, 0x64, 0x75, 0xce, 0x80, 0x84, 0xa9, 0xcb,
   0x80, 0x04, 0xe7, 0xca, 0x80, 0x4c, 0x99, 0xca, 0x80, 0x14, 0x76, 0xca,
   0x80, 0x84, 0x8b, 0xcb, 0x80, 0x64, 0x7c, 0xce, 0x80, 0x1c, 0x85, 0xc8,
   0x80, 0xfc, 0xff, 0xcf, 0x80, 0x00, 0x00, 0xc0, 0x80, 0x00, 0x00, 0xc0,
   0x80, 0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff
} }

blt_bitmap define misc-files { {32 32} {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xfc, 0x07, 0xfe, 0x03, 0x04, 0x0c, 0x02, 0x06, 0x04, 0x14, 0x02, 0x0a,
   0x04, 0x3c, 0x02, 0x1e, 0x04, 0x60, 0x02, 0x30, 0x04, 0x60, 0x02, 0x30,
   0x04, 0x60, 0x02, 0x30, 0x04, 0x60, 0x02, 0x30, 0x04, 0x60, 0x02, 0x30,
   0x04, 0x00, 0x00, 0x30, 0x04, 0xfc, 0x07, 0x30, 0x04, 0x04, 0x0c, 0x30,
   0x04, 0x04, 0x14, 0x30, 0x04, 0x04, 0x3c, 0x30, 0xfc, 0x05, 0x60, 0x3f,
   0xf8, 0x05, 0x60, 0x3f, 0x00, 0x04, 0x60, 0x00, 0x00, 0x04, 0x60, 0x00,
   0x00, 0x04, 0x60, 0x00, 0x00, 0x04, 0x60, 0x00, 0x00, 0x04, 0x60, 0x00,
   0x00, 0x04, 0x60, 0x00, 0x00, 0x04, 0x60, 0x00, 0x00, 0x04, 0x60, 0x00,
   0x00, 0xfc, 0x7f, 0x00, 0x00, 0xf8, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
} }

blt_bitmap define examine { {36 36} {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x07,
   0x07, 0x00, 0x00, 0x80, 0x2a, 0x08, 0x00, 0x00, 0xc0, 0x81, 0x10, 0x00,
   0x00, 0x20, 0x00, 0x22, 0x00, 0x00, 0x90, 0xff, 0x47, 0x00, 0x00, 0x98,
   0x00, 0x48, 0x00, 0x00, 0x94, 0x00, 0x40, 0x00, 0x00, 0x8c, 0x00, 0x90,
   0x3e, 0x00, 0x8c, 0x00, 0x80, 0x60, 0x00, 0x8a, 0x00, 0xa0, 0xa0, 0x00,
   0x8e, 0x00, 0x80, 0x20, 0x01, 0x8a, 0x00, 0xa0, 0x20, 0x02, 0x96, 0x00,
   0x40, 0xe0, 0x07, 0x9a, 0x00, 0x60, 0x00, 0x04, 0xb6, 0x00, 0x50, 0x00,
   0x04, 0xec, 0x00, 0x30, 0x00, 0x04, 0xd4, 0x00, 0x50, 0x00, 0x04, 0xa8,
   0x01, 0xa8, 0x00, 0x04, 0x50, 0x07, 0x5f, 0x01, 0x04, 0xa0, 0xfa, 0xb2,
   0x02, 0x04, 0xc0, 0x55, 0x61, 0x05, 0x04, 0x00, 0x3f, 0xc0, 0x0a, 0x04,
   0x00, 0x00, 0x80, 0x15, 0x04, 0x00, 0x08, 0x00, 0x2b, 0x04, 0x00, 0x08,
   0x00, 0x56, 0x04, 0x00, 0x08, 0x00, 0xac, 0x04, 0x00, 0x08, 0x00, 0xd8,
   0x04, 0x00, 0x08, 0x00, 0x70, 0x04, 0x00, 0x08, 0x00, 0x00, 0x04, 0x00,
   0x08, 0x00, 0x00, 0x04, 0x00, 0x08, 0x00, 0x00, 0x04, 0x00, 0x08, 0x00,
   0x00, 0x04, 0x00, 0xf8, 0xff, 0xff, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00
} }

blt_bitmap define trash { {36 36} {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0x00, 0x00, 0x80, 0x00,
   0x80, 0x01, 0x00, 0x80, 0x00, 0x80, 0x02, 0x00, 0x80, 0x00, 0x80, 0x04,
   0x00, 0x80, 0x00, 0x80, 0x08, 0x00, 0x80, 0x00, 0x80, 0x1f, 0x00, 0xe0,
   0x00, 0x00, 0x70, 0x00, 0xf0, 0x00, 0x00, 0xf0, 0x00, 0xf8, 0x00, 0x00,
   0xf0, 0x01, 0xe8, 0x00, 0x00, 0xf0, 0x01, 0xd8, 0x00, 0x00, 0x70, 0x01,
   0xb0, 0x07, 0x00, 0xbe, 0x00, 0x50, 0xfd, 0xff, 0xd5, 0x00, 0xb0, 0xaa,
   0xaa, 0xaa, 0x00, 0x50, 0x55, 0x55, 0xc5, 0x00, 0xa0, 0xaa, 0xaa, 0xaa,
   0x00, 0x60, 0x55, 0x55, 0x45, 0x00, 0xa0, 0xaa, 0xaa, 0x62, 0x00, 0x60,
   0x55, 0x55, 0x55, 0x00, 0xa0, 0xaa, 0xaa, 0x62, 0x00, 0x40, 0x55, 0x55,
   0x55, 0x00, 0xc0, 0xaa, 0xaa, 0x22, 0x00, 0x40, 0x55, 0x55, 0x31, 0x00,
   0xc0, 0xaa, 0xaa, 0x2a, 0x00, 0x40, 0x55, 0x55, 0x31, 0x00, 0x80, 0xaa,
   0xaa, 0x2a, 0x00, 0x80, 0x55, 0x55, 0x11, 0x00, 0x80, 0xaa, 0xaa, 0x18,
   0x00, 0x80, 0x55, 0x55, 0x15, 0x00, 0x80, 0xaa, 0xaa, 0x18, 0x00, 0x00,
   0x55, 0x55, 0x15, 0x00, 0x00, 0xab, 0xaa, 0x08, 0x00, 0x00, 0x55, 0x55,
   0x0d, 0x00, 0x00, 0xae, 0xaa, 0x07, 0x00, 0x00, 0xf0, 0xff, 0x00, 0x00
} }

blt_bitmap define compress { {36 36} {
   0x00, 0x80, 0x3c, 0x00, 0x00, 0x00, 0xc0, 0x13, 0x00, 0x00, 0x00, 0x80,
   0x3c, 0x00, 0x00, 0x00, 0xc0, 0x13, 0x00, 0x00, 0x00, 0x80, 0x3c, 0x00,
   0x00, 0x00, 0xc0, 0x13, 0x00, 0x00, 0x00, 0x80, 0x3c, 0x00, 0x00, 0x00,
   0xc0, 0x13, 0x00, 0x00, 0x00, 0x80, 0x3c, 0x00, 0x00, 0xe0, 0xff, 0xff,
   0x7f, 0x00, 0x50, 0x55, 0x55, 0xd5, 0x00, 0xa8, 0xaa, 0xaa, 0x82, 0x01,
   0x58, 0x55, 0x55, 0x15, 0x01, 0xac, 0xaa, 0xaa, 0x2a, 0x02, 0x54, 0x55,
   0x55, 0x55, 0x03, 0xfc, 0xff, 0xff, 0xff, 0x03, 0x80, 0xff, 0xff, 0x00,
   0x00, 0x80, 0x00, 0x80, 0x01, 0x00, 0x80, 0x00, 0x80, 0x02, 0x00, 0x80,
   0x00, 0x80, 0x04, 0x00, 0x80, 0x00, 0x80, 0x08, 0x00, 0x80, 0x00, 0x80,
   0x1f, 0x00, 0x80, 0x00, 0x00, 0x10, 0x00, 0x80, 0x00, 0x00, 0x10, 0x00,
   0x80, 0x00, 0x00, 0x10, 0x00, 0x80, 0x00, 0x00, 0x10, 0x00, 0x80, 0x00,
   0x00, 0x10, 0x00, 0x00, 0xff, 0xff, 0x3f, 0x00, 0x00, 0x55, 0x55, 0x35,
   0x00, 0x80, 0x00, 0x00, 0x20, 0x00, 0x80, 0x00, 0x00, 0x10, 0x00, 0x00,
   0xff, 0xff, 0x3f, 0x00, 0x00, 0x55, 0x55, 0x35, 0x00, 0x80, 0x00, 0x00,
   0x20, 0x00, 0x40, 0x00, 0x00, 0x10, 0x00, 0xc0, 0xff, 0xff, 0x1f, 0x00
} }

blt_bitmap define refile { {36 36} {
   0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xff, 0xff, 0x07, 0x00, 0x0c, 0x00,
   0x00, 0x08, 0x00, 0x14, 0x00, 0x00, 0x10, 0x00, 0x24, 0x00, 0xe0, 0x2f,
   0x00, 0xc4, 0xff, 0xef, 0x6f, 0x00, 0x54, 0x00, 0xe0, 0x4f, 0x00, 0x64,
   0x00, 0xe0, 0x4f, 0x00, 0x44, 0xfe, 0xe1, 0x0f, 0x00, 0x54, 0x02, 0xfc,
   0x7f, 0x00, 0x64, 0xfa, 0xf9, 0x3f, 0x00, 0x44, 0x0a, 0xf0, 0x1f, 0x00,
   0x54, 0xea, 0xe7, 0xcf, 0x00, 0x64, 0x2e, 0xc0, 0x87, 0x00, 0x44, 0xaa,
   0xff, 0xff, 0x03, 0x54, 0xb2, 0x00, 0x00, 0x02, 0x64, 0xa6, 0x00, 0x00,
   0x02, 0x44, 0xce, 0x20, 0x08, 0x02, 0x54, 0x9a, 0xe0, 0x0f, 0x02, 0x64,
   0xb6, 0x00, 0x00, 0x02, 0x44, 0xec, 0xe0, 0x0f, 0x02, 0x54, 0xde, 0x20,
   0x08, 0x02, 0x64, 0xba, 0xe0, 0x0f, 0x02, 0x44, 0xf2, 0x00, 0x00, 0x02,
   0x54, 0xe2, 0xff, 0xff, 0x03, 0x64, 0xc2, 0xff, 0x7f, 0x00, 0x44, 0x02,
   0x00, 0x48, 0x00, 0x54, 0x82, 0x3f, 0x48, 0x00, 0x64, 0x82, 0x20, 0x48,
   0x00, 0x44, 0x82, 0x3f, 0x48, 0x00, 0x54, 0x02, 0x00, 0x48, 0x00, 0x68,
   0xfe, 0xff, 0x4f, 0x00, 0x50, 0x00, 0x00, 0x40, 0x00, 0x60, 0x00, 0x00,
   0x40, 0x00, 0xc0, 0xff, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
} }

blt_bitmap define disk { {29 29} {
   0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 0x7f, 0x0f, 0x56, 0x00, 0xc0, 0x0d,
   0x6a, 0x00, 0xcf, 0x0a, 0x56, 0x00, 0x4d, 0x0d, 0x6a, 0x00, 0xcb, 0x0a,
   0x56, 0x00, 0x4d, 0x0d, 0x6a, 0x00, 0xcb, 0x0a, 0x56, 0x00, 0x4f, 0x0d,
   0x6a, 0x00, 0xc0, 0x0a, 0xd6, 0xff, 0x7f, 0x0d, 0xaa, 0xaa, 0xaa, 0x0a,
   0x56, 0x55, 0x55, 0x0d, 0xfa, 0xff, 0xff, 0x0b, 0x16, 0x00, 0x00, 0x0d,
   0x1a, 0x00, 0x00, 0x0b, 0xd6, 0xff, 0x7f, 0x0d, 0x1a, 0x00, 0x00, 0x0b,
   0x16, 0x00, 0x00, 0x0d, 0xda, 0xff, 0x7f, 0x0b, 0x16, 0x00, 0x00, 0x0d,
   0x1a, 0x00, 0x00, 0x0b, 0xd6, 0xff, 0x7f, 0x0d, 0x1a, 0x00, 0x00, 0x0b,
   0x16, 0x00, 0x00, 0x0d, 0xda, 0xff, 0x7f, 0x0b, 0x16, 0x00, 0x00, 0x0d,
   0xfe, 0xff, 0xff, 0x0f, 0x00, 0x00, 0x00, 0x00
} }

blt_bitmap define unknown { {32 32} {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0xf0, 0xff, 0xff, 0x00, 0xb0, 0xaa, 0xaa, 0x01, 0x70, 0x55, 0x55, 0x03,
   0xd0, 0xaa, 0xaa, 0x06, 0xb0, 0x55, 0x55, 0x0d, 0x50, 0xff, 0xff, 0x1f,
   0xb0, 0x56, 0x55, 0x15, 0x50, 0x2b, 0x80, 0x1a, 0xb0, 0x16, 0x3f, 0x15,
   0x50, 0x8b, 0x7f, 0x1a, 0xb0, 0xd6, 0xe1, 0x14, 0x50, 0xcb, 0xe9, 0x1a,
   0xb0, 0x96, 0xe5, 0x14, 0x50, 0x2b, 0xf0, 0x1a, 0xb0, 0x56, 0x7c, 0x15,
   0x50, 0xab, 0x9e, 0x1a, 0xb0, 0x56, 0x4e, 0x15, 0x50, 0xab, 0xae, 0x1a,
   0xb0, 0x56, 0x40, 0x15, 0x50, 0xab, 0xae, 0x1a, 0xa0, 0x56, 0x4e, 0x15,
   0x40, 0xab, 0xae, 0x1a, 0x80, 0x56, 0x40, 0x15, 0x00, 0xab, 0xaa, 0x1a,
   0x00, 0xfe, 0xff, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
} }

blt_bitmap define ex-usage { {447 40} {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x00,0x3c,0x00,0x00,0x30,0xde,
 0x06,0x6c,0x06,0x6c,0x06,0x1e,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xff,
 0x01,0x00,0x00,0x18,0x00,0x00,0x3c,0x00,0x00,0x30,0x1e,0x06,0x6c,0x06,0x6c,
 0x06,0x33,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x00,0x02,0x00,0x00,0x68,
 0xe6,0xd9,0x34,0x8f,0xc7,0x33,0xda,0x36,0xf4,0x66,0xf4,0x66,0x30,0x60,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x04,0x00,0x00,0x6c,0x36,0xfb,0xb6,0xd9,
 0x6c,0x36,0xdb,0x6e,0x66,0x36,0x66,0x36,0x1c,0x60,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x10,0x00,0xf8,0xff,0x03,0x6c,0x76,0x38,0xb6,0xd9,0x00,0x36,0xdb,0x66,
 0x66,0x1e,0x66,0x1e,0x30,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,
 0x00,0x04,0x64,0xc6,0x19,0xb2,0xd9,0xc0,0x37,0xd9,0x66,0x62,0x1e,0x62,0x1e,
 0x30,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x0c,0x64,0x86,
 0x1b,0xb2,0xd9,0x60,0x36,0xd9,0x66,0x62,0x36,0x62,0x36,0x30,0x60,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x90,0xff,0xff,0xff,0x0c,0x66,0x37,0x1b,0xb3,0xd9,0x6c,
 0xb6,0xd9,0x6e,0x63,0x67,0x63,0x67,0x33,0x63,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x90,0x20,0x00,0x80,0x0c,0xc6,0xe6,0x19,0x33,0x8f,0xc7,0xbd,0xd9,0x36,0xc3,
 0xc6,0xc3,0xc6,0x1e,0x63,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x90,0x20,0x00,0x80,
 0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x90,0x20,0x00,0xc0,0x0c,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x90,0xa8,0x00,0xa0,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x90,
 0x70,0x00,0x90,0x0c,0xfe,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
 0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
 0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
 0xff,0xff,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x90,0x70,0x00,0x98,0x0c,
 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x1a,
 0x00,0x00,0x00,0x00,0x00,0x00,0x90,0x70,0x00,0xa4,0x0c,0x56,0x55,0x55,0x55,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x15,0x00,0x00,0x00,0x00,
 0x00,0x00,0x90,0x88,0x00,0xaa,0x0c,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x1a,0x00,0x00,0x00,0x00,0x00,0x00,0x90,0x00,
 0x80,0xa9,0x0c,0x56,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
 0x55,0x55,0x15,0x00,0x00,0x00,0x00,0x00,0x00,0x90,0x00,0x60,0xa7,0x0c,0xaa,
 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x1a,0x00,
 0x00,0x00,0x00,0x00,0x00,0x90,0x82,0x38,0xb9,0x0c,0x56,0x55,0x55,0x55,0x55,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x15,0x00,0x80,0x87,0xe1,0x31,
 0x06,0x90,0x20,0xc6,0x97,0x0c,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0xaa,0x1a,0x00,0xc0,0xec,0x31,0x33,0x03,0x90,0x84,0x11,
 0xa1,0x0c,0x56,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
 0x55,0x15,0x00,0x00,0x8c,0x31,0xb3,0x01,0x90,0xff,0xff,0xff,0x0c,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x1a,0x00,0x00,
 0x87,0x31,0xf3,0x00,0x10,0x00,0x00,0x00,0x0c,0x56,0x55,0x55,0x55,0x55,0x55,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x15,0x00,0x00,0x8c,0x31,0xf3,0x00,
 0x10,0x00,0x00,0x00,0x0c,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0x1a,0x00,0x00,0x8c,0x31,0xb3,0x01,0xf0,0xff,0xff,0xff,
 0x0f,0x56,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
 0x15,0x00,0x00,0x8c,0x31,0x33,0x03,0xe0,0xff,0xff,0xff,0x0f,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0x1a,0x00,0xc0,0x8c,
 0x31,0x33,0x06,0x00,0x00,0x00,0x00,0x00,0x56,0x55,0x55,0x55,0x55,0x55,0x55,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x15,0x00,0x80,0x87,0xe1,0x31,0x0c,0x00,
 0x00,0x00,0x00,0x00,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
 0xaa,0xaa,0xaa,0x1a,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x56,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,
 0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x15,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0xff,0xff,0xff,
 0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
 0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
 0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x1f,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00
} }

# ----------------------------------------------------------------------
#  USAGE:  kd_examine <file-or-directory>
#
#  Provides a means of examining the given path.  If a file name is
#  specified, then a file viewer window is invoked and loaded with
#  the file.  If a directory is specified, then its usage info is
#  loaded into the main canvas.  If any errors are encountered, they
#  are displayed in an error box to the user.
# ----------------------------------------------------------------------
proc kd_examine {x} {
	global KdUnique

	if {[file isfile $x]} {
		kd_examine_file $x
	} elseif {[file isdirectory $x]} {
		set viewer .usage[incr KdUnique]
		toplevel $viewer
		wm title $viewer "Kosher Dill: Usage Viewer"
		wm minsize $viewer 200 200
		kd_create_dir_viewer $viewer
		kd_examine_dir $viewer $x
	} else {
		kd_message_box error "Cannot display \"$x\""
	}
}

# ----------------------------------------------------------------------
#  USAGE:  kd_examine_file <file>
#
#  Creates a new window to display the given file.  Uses the system
#  "file" command to determine the file type, and displays the file
#  in a text widget if possible.  Otherwise, displays characteristics
#  of the file.
# ----------------------------------------------------------------------
proc kd_examine_file {file} {
	global KdUnique

	if {![file exists $file]} {
		kd_message_box error "File does not exist: $file"
		return
	}
	if {![file readable $file]} {
		kd_message_box error "Cannot open file: $file"
		return
	} else {
		set type [exec file $file]
		if {[lsearch $type "ascii"] >= 0 ||
		    [lsearch $type "text"] >= 0 ||
		    [lsearch $type "commands"] >= 0 ||
		    [lsearch $type "script"] >= 0} {

			set duinfo [kd_get_usage $file]
			if {$duinfo == ""} {
				kd_message_box error "Cannot get usage info: $file"
				return
			}
			set dAge   [kd_access $duinfo age]
			set dUsage [kd_access $duinfo usage]

			set win .file[incr KdUnique]
			toplevel $win -class FileViewer
			frame $win.view -borderwidth 2 -relief sunken
			text $win.view.text -yscrollcommand "$win.view.sbar set" \
				-width 80 -height 24
			scrollbar $win.view.sbar -command "$win.view.text yview"
			pack $win.view.text -side left -expand yes -fill both
			pack $win.view.sbar -side right -fill y

			frame $win.label
			label $win.label.icon -bitmap $dAge-file
			label $win.label.name -text "$file  (USAGE: [set dUsage]K)"
			pack $win.label.icon -side left
			pack $win.label.name -side left

			frame $win.cntl -borderwidth 2 -relief raised
			frame $win.cntl.d -borderwidth 2 -relief sunken
			button $win.cntl.d.dismiss -text " Dismiss " \
				-command "destroy $win"
			pack $win.cntl.d.dismiss -padx 4 -pady 4
			pack $win.cntl.d -padx 8 -pady 8

			pack $win.label -side top -fill both
			pack $win.view -side top -expand yes -fill both -padx 4 -pady 4
			pack $win.cntl -side top -fill x

			wm title $win "Kosher Dill: File Viewer"
			wm minsize $win 200 200
			bind $win <Key-Return> "
				$win.cntl.d.dismiss flash
				$win.cntl.d.dismiss invoke
			"
			focus $win

			if {[catch "open $file r" fid] == 0} {
				$win.view.text insert end [read $fid]
				$win.view.text config -state disabled
				close $fid
			} else {
				$win.view.text insert end "Cannot open file:\n$file"
				$win.view.text config -state disabled
			}
		} else {
			set duinfo [kd_get_usage $file]
			if {$duinfo == ""} {
				kd_message_box error "Cannot get usage info: $file"
				return
			}
			set dAge   [kd_access $duinfo age]
			set dUsage [kd_access $duinfo usage]

			set win .file[incr KdUnique]
			toplevel $win -class FileViewer
			message $win.mesg -aspect 1000 \
				-text "$file:\n[lrange $type 1 end]\n\nUSAGE: [set dUsage]K"

			frame $win.cntl -borderwidth 2 -relief raised
			label $win.cntl.icon -bitmap $dAge-file
			pack $win.cntl.icon -side top -pady 2
			frame $win.cntl.d -borderwidth 2 -relief sunken
			button $win.cntl.d.dismiss -text " Dismiss " \
				-command "destroy $win"
			pack $win.cntl.d.dismiss -padx 4 -pady 4
			pack $win.cntl.d -padx 8 -pady 8

			pack $win.cntl -side left -fill y
			pack $win.mesg -side top -expand yes -fill both

			wm title $win "Kosher Dill: File Viewer"
			bind $win <Key-Return> {
				$win.cntl.d.dismiss flash
				$win.cntl.d.dismiss invoke
			}
			focus $win
		}
	}
}

# ----------------------------------------------------------------------
#  USAGE:  kd_examine_dir <viewer> <directory>
#
#  Loads the given directory into a particular usage viewer.
#  If any errors are encountered, they are displayed in an error box
#  to the user.
# ----------------------------------------------------------------------
proc kd_examine_dir {viewer dir} {
	global KdViewers
	if {$dir == ""} {
		set KdViewers($viewer) ""
		return
	}

	if {[file isdirectory $dir]} {
		set KdViewers($viewer) $dir
		if {$viewer == "."} {
			.status.dirEntry delete 0 end
			.status.dirEntry insert 0 $dir
			.status.dirEntry icursor end

			global env
			if {[info exists env(HOME)]} {
				set top $env(HOME)
			} else {
				set top "/"
			}
			set path {}
			set parent [file dirname $dir]
			while {$parent != "." && $parent != "/"} {
				set path [linsert $path 0 $parent]
				if {$parent == $top} break
				set parent [file dirname $parent]
			}

			.status.dirLabel.m delete 0 last
			foreach parent $path {
				.status.dirLabel.m add command -label $parent \
					-command "kd_examine_dir $viewer $parent"
			}
			.view.canv delete all
		} else {
			$viewer.status.dirInfo config -text $dir
			$viewer.view.canv delete all
		}

		#
		#  Try to query usage info, and catch any error before
		#  the drawing stage.  If directory is a symbolic link,
		#  usage may need to be queried
		#
		if {[kd_get_usage $dir status] == ""} {
			if {$status == "error"} {
				set mesg "Cannot get usage for:\n$dir"
				if {[file type $dir] == "link"} {
					append mesg "\n\nThis is a symbolic link to another directory.\nTry \"$dir/.\""
				}
				kd_message_box warning $mesg
			}

		} elseif {[catch "kd_draw_usage $viewer $dir" retn] != 0} {
			blt_busy release $viewer
			kd_message_box warning $retn
		} else {
			if {$viewer == "."} {
				.view.canv yview 0
			} else {
				$viewer.view.canv yview 0
			}
		}
	} else {
		kd_message_box error "Not a directory: $dir"
	}
}

# ----------------------------------------------------------------------
#  USAGE:  kd_create_dir_viewer <toplevel>
#
#  Creates and configures the widgets representing the directory usage
#  viewer in the given <toplevel> window.  Adds the given <toplevel>
#  name to the list of active viewers, so that the display can be
#  automatically refreshed by each call to kd_view_update.
# ----------------------------------------------------------------------
proc kd_create_dir_viewer {win} {
	global KdViewers

	#
	# Make viewing canvas and scrollbar...
	#
	frame $win.view -borderwidth 2 -relief sunken
	canvas $win.view.canv -yscroll "$win.view.sbar set"
	scrollbar $win.view.sbar -command "$win.view.canv yview"
	pack $win.view.canv -side left -expand yes -fill both
	pack $win.view.sbar -side right -fill y

	bind $win.view.canv <Configure> "kd_view_update $win"
	bind $win.view.canv <ButtonPress-1> "
		set seln \[kd_usage_select $win %x %y\]
	"
	bind $win.view.canv <Double-ButtonPress-1> "
		set seln \[kd_usage_select $win %x %y\]
		if {\$seln != \"\"} {
			kd_examine_dir $win \$seln
		}
	"
	bind $win.view.canv <ButtonPress-2> {%W scan mark 0 %y}
	bind $win.view.canv <B2-Motion> {%W scan dragto 0 %y}

	blt_drag&drop source $win.view.canv config \
		-packagecmd "kd_package_viewer_file $win $win.view.canv" \
		-sitecmd kd_site_file

	blt_drag&drop source $win.view.canv handler file dd_send_file
	blt_drag&drop source $win.view.canv handler text dd_send_text

	#
	# Make status window...
	#
	frame $win.status -borderwidth 2
	label $win.status.dirLabel -text "Directory:"
	label $win.status.dirInfo -text "" -anchor w

	blt_drag&drop source $win.status.dirInfo config \
		-packagecmd "kd_package_viewer_file . $win.status.dirInfo" \
		-sitecmd kd_site_file
	blt_drag&drop source $win.status.dirInfo handler file dd_send_file
	blt_drag&drop source $win.status.dirInfo handler text dd_send_text

	blt_drag&drop target $win.status.dirInfo handler file "
		global DragDrop
		kd_examine_dir $win \$DragDrop(file)
	"

	label $win.status.usageLabel -text "Usage:"
	label $win.status.usageInfo -text "" -anchor w

	blt_table $win.status \
		$win.status.dirLabel 0,0 -anchor e \
		$win.status.dirInfo 0,1 -anchor w -fill x \
		$win.status.usageLabel 1,0 -anchor e \
		$win.status.usageInfo 1,1 -anchor w -fill x
	blt_table column $win.status config 0 \
		-width [winfo reqwidth $win.status.dirLabel]

	#
	# Make drag&drop targets...
	#
	frame $win.targets -borderwidth 4
	label $win.targets.examineTarget -bitmap examine
	label $win.targets.compressTarget -bitmap compress
	label $win.targets.trashTarget -bitmap trash
	button $win.targets.dismiss -text " Dismiss " -command "
		global KdViewers
		unset KdViewers($win)
		destroy $win
	"
	blt_drag&drop target $win.targets.examineTarget handler file {
		global DragDrop
		kd_examine $DragDrop(file)
	}
	blt_drag&drop target $win.targets.compressTarget handler file {
		global DragDrop
		kd_compress_append $DragDrop(file)
		kd_view_update containing $DragDrop(file)
	}
	blt_drag&drop target $win.targets.trashTarget handler file {
		global DragDrop
		kd_trash_append $DragDrop(file)
		kd_view_update containing $DragDrop(file)
	}

	blt_table $win.targets \
		$win.targets.examineTarget 0,0 \
		$win.targets.compressTarget 0,1 \
		$win.targets.trashTarget 0,2 \
		$win.targets.dismiss 0,3 -padx 0.1i

	pack $win.status -side top -fill x -padx 4
	pack $win.view -expand yes -fill both -padx 4 -pady 4
	pack $win.targets -side top -fill x
	set KdViewers($win) ""
}

# ----------------------------------------------------------------------
#  USAGE:  kd_view_update <viewer>
#          kd_view_update containing <file>
#
#  Freshens the drawing in the specified viewer.  If no viewer is
#  specified, then all viewers are updated.  If the directory name for
#  the viewer is not null, then the usage chart is redrawn for that
#  directory.  Usually invoked when a "View" parameter has been changed.
# ----------------------------------------------------------------------
proc kd_view_update {args} {
	global KdView KdViewers

	if {[lindex $args 0] == "containing"} {
		if {$KdView(deep-dir-hierarchy) == 0} {
			set file [lindex $args 1]
			set args {}
			foreach v [array names KdViewers] {
				if {$KdViewers($v) == [file dirname $file]} {
					lappend args $v
				}
			}
		} else {
			set file [lindex $args 1]
			set args {}
			foreach v [array names KdViewers] {
				if {[string match $KdViewers($v)/* $file]} {
					lappend args $v
				}
			}
		}
	} elseif {$args == ""} {
		set args [array names KdViewers]
	}

	foreach v $args {
		if {$KdViewers($v) != ""} {
			#
			#  Try to query usage info.  If something goes wrong,
			#  skip to next viewer.
			#
			if {[kd_get_usage $KdViewers($v)] == ""} {
				continue
			}
			if {[catch "kd_draw_usage $v $KdViewers($v)" retn] != 0} {
				blt_busy release $v
				kd_message_box warning $retn
			}
		}
	}
}

# ----------------------------------------------------------------------
#  USAGE:  kd_message_box <type> <mesg>
#
#  Pops up a dialog box with a message in it, and waits for the user
#  to dismiss it.  The "type" should be one of "error", "warning" or
#  "info".
# ----------------------------------------------------------------------
proc kd_message_box {type mesg} {
	global KdError

	.box.mesg config -text $mesg
	.box.cntl.icon config -bitmap $type
	kd_map .box
	tkwait visibility .box
	focus .box
	grab .box
	tkwait variable KdError
	grab release .box

	kd_unmap .box
}

# ----------------------------------------------------------------------
#  USAGE:  kd_have_usage <file>
#
#  Checks to see if disk usage info exists for the given file or
#  directory.  Returns non-zero if information currently exists.
# ----------------------------------------------------------------------
proc kd_have_usage {file} {
	global KdKnownFiles
	return [info exists KdKnownFiles($file)]
}

# ----------------------------------------------------------------------
#  USAGE:  kd_get_usage <file> ?<status>?
#
#  Checks to see if disk usage info exists for the given file or
#  directory.  If it does not, or if the current information is stale,
#  then disk usage is queried (via the Tcl "file" command or the usual
#  system "du" command).  Returns a token that can be used to access
#  usage info.  If the optional <status> is specified, then it is
#  treated as the name of a variable at the calling scope, and it is
#  set with a value indicating the status of the query:  ok/error/abort.
# ----------------------------------------------------------------------
proc kd_get_usage {file {status ""}} {
	global KdKnownFiles

	if {![file exists $file]} {
		set stat error
		return ""
	}
	if {$status != ""} {
		upvar $status stat
	}
	set get_usage 0
	if {![info exists KdKnownFiles($file)]} {
		set get_usage 1
	} elseif {[kd_access $KdKnownFiles($file) mtime] != [file mtime $file]} {
		set get_usage 1
	}

	set stat ok
	if {$get_usage} {
		if {[file isdirectory $file]} {
			kd_invoke_du $file stat
			if {![info exists KdKnownFiles($file)]} {
				return ""
			}
		} else {
			kd_save_usage $file [expr ([file size $file]+1023)/1024]
		}
	}
	return $KdKnownFiles($file)
}

# ----------------------------------------------------------------------
#  USAGE:  kd_invoke_du <file> ?<status>?
#
#  Invokes the system "du" to query for disk usage, and puts up a
#  dialog box allowing the user to abort the query.  If the optional
#  <status> is specified, then it is treated as the name of a variable
#  at the calling scope, and it is set with a value indicating the
#  status of the query:  ok/error/abort.
# ----------------------------------------------------------------------
proc kd_invoke_du {file {status ""}} {
	global KdViewers

	if {$status != ""} {
		upvar $status stat
	}

	foreach v [array names KdViewers] {
		blt_busy hold $v
	}
	update

	kd_show_status "Querying usage for:\n$file"

	global KdResult
	blt_bgexec -errorvar KdErrors KdResult du $file
	tkwait variable KdResult

	foreach v [array names KdViewers] {
		blt_busy release $v
	}
	kd_hide_status

	if {$KdResult == ""} {
		set stat error
	} elseif {$KdResult == "abort"} {
		set stat abort
	} else {
		set stat ok
	}
}

# ----------------------------------------------------------------------
#  USAGE:  kd_show_status
#
#  Invoked to display animation sequence during "du" queries and
#  draw operations.  Allows the user to access an "abort" button to
#  cancel work in progress.  The first such call will reset KdResult
#  to "", indicating the start of an operation.  Each call should have
#  a corresponding "kd_hide_status" call to make this box go away.
# ----------------------------------------------------------------------
proc kd_show_status {mesg} {
	global KdResult KdStatusLevel

	if {$KdStatusLevel <= 0} {
		set KdStatusLevel 0
		set KdResult ""
	}
	incr KdStatusLevel
	.abort.mesg config -text $mesg

	if {![winfo ismapped .abort]} {
		kd_map .abort
		kd_animate_status
	}
}

# ----------------------------------------------------------------------
#  USAGE:  kd_hide_status
#
#  Invoked to make the status window go away when no longer needed.
#  Parts of the program mark a "busy" period by calling kd_show_status
#  and kd_hide_status.  Calls can be nested, so that the status window
#  will remain visible as long as it is needed.
# ----------------------------------------------------------------------
proc kd_hide_status {} {
	global KdStatusLevel

	if {[incr KdStatusLevel -1] <= 0} {
		set KdStatusLevel 0
		after 500 {
			global KdStatusLevel
			if {$KdStatusLevel <= 0} {
				set KdStatusLevel -1
				kd_unmap .abort
			}
		}
	}
}

# ----------------------------------------------------------------------
#  USAGE:  kd_animate_status
#
#  Invoked to display animation sequence in status window.
# ----------------------------------------------------------------------
proc kd_animate_status {} {
	global KdAnimate KdStatusLevel

	if {$KdStatusLevel >= 0} {
		if {[winfo ismapped .abort]} {
			set next [lindex $KdAnimate 0]
			.abort.animate config -bitmap $next
			set KdAnimate [lreplace $KdAnimate 0 0]
			lappend KdAnimate $next
			update
		}
		after 100 kd_animate_status
	}
}

# ----------------------------------------------------------------------
#  USAGE:  kd_status_abort
#
#  Invoked when the user presses the "Abort" button on the status
#  window to abort some long operation.  Sets KdResult to "abort" to
#  terminate any "blt_bgexec" call, and to indicate that the operation
#  was aborted.
# ----------------------------------------------------------------------
proc kd_status_abort {} {
	global KdResult
	set KdResult "abort"
	kd_unmap .abort
}

# ----------------------------------------------------------------------
#  USAGE:  kd_access <token> <field>
#
#  Used to access usage information via the token returned by
#  kd_get_usage.  Queries for a particular <field> value of information
#  associated with the given usage <token>.  Returns the desired string.
# ----------------------------------------------------------------------
proc kd_access {token field} {
	if {$token == ""} {
		return ""
	}

	global $token
	if {![info exists $token]} {
		error "unknown token: $token"
	} elseif {![info exists [set token]($field)]} {
		error "improper usage field: $field"
	} else {
		return [set [set token]($field)]
	}
}

# ----------------------------------------------------------------------
#  USAGE:  kd_modify <token> <field> <value>
#
#  Used to modify usage information via the token returned by
#  kd_get_usage.  Modifies a particular <field> value of information
#  associated with the given usage <token>.  Returns the value string.
# ----------------------------------------------------------------------
proc kd_modify {token field val} {
	if {$token == ""} {
		return ""
	}

	global $token
	if {![info exists $token]} {
		error "unknown token: $token"
	} elseif {![info exists [set token]($field)]} {
		error "improper usage field: $field"
	} else {
		return [set [set token]($field) $val]
	}
}

# ----------------------------------------------------------------------
#  USAGE:  kd_file_link <file>
#
#  Adds a file back into any usage information that may exist for
#  parent directories.  Invoked when a file is removed from the trash
#  to put it back into the cached usage data.
# ----------------------------------------------------------------------
proc kd_file_link {file} {
	set duinfo [kd_get_usage $file]
	set fUsage [kd_access $duinfo usage]

	set dir [file dirname $file]
	set duinfo [kd_get_usage $dir]
	set dFiles [kd_access $duinfo files]
	set i [lsearch $dFiles $file]
	if {$i < 0} {
		lappend dFiles $file
		kd_modify $duinfo files $dFiles

		while {[kd_have_usage $dir]} {
			set duinfo [kd_get_usage $dir]
			set dUsage [kd_access $duinfo usage]
			kd_modify $duinfo usage [expr $dUsage+$fUsage]
			if {$dir == "."} {
				break
			} else {
				set dir [file dirname $dir]
			}
		}
	}
}

# ----------------------------------------------------------------------
#  USAGE:  kd_file_unlink <file>
#
#  Removes a file from any usage information that may exist for
#  parent directories.  Invoked when a file is removed from the trash
#  to put it back into the cached usage data.
# ----------------------------------------------------------------------
proc kd_file_unlink {file} {
	set duinfo [kd_get_usage $file]
	set fUsage [kd_access $duinfo usage]

	global KdTrash
	set i [lsearch $KdTrash $file]
	if {$i >= 0} {
		kd_trash_refile $file
	}

	global KdCompress
	set i [lsearch $KdCompress $file]
	if {$i >= 0} {
		kd_compress_refile $file
	}

	set dir [file dirname $file]
	set duinfo [kd_get_usage $dir]
	set dFiles [kd_access $duinfo files]
	set i [lsearch $dFiles $file]
	if {$i >= 0} {
		set dFiles [lreplace $dFiles $i $i]
		kd_modify $duinfo files $dFiles

		while {[kd_have_usage $dir]} {
			set duinfo [kd_get_usage $dir]
			set dUsage [kd_access $duinfo usage]
			kd_modify $duinfo usage [expr $dUsage-$fUsage]
			if {$dir == "."} {
				break
			} else {
				set dir [file dirname $dir]
			}
		}
	}
}

# ----------------------------------------------------------------------
#  USAGE:  kd_process_du_info <name1> <name2> <op>
#
#  Invoked by a trace on KdResult whenever "du" information is returned
#  by a blt_bgexec of "du".  Stores each line of usage information for
#  later use.
# ----------------------------------------------------------------------
proc kd_process_du_info {name1 name2 op} {
	global $name1
	foreach line [split [set $name1] \n] {
		if {[llength $line] == 2} {
			kd_save_usage [lindex $line 1] [lindex $line 0]
		}
		if {[set $name1] == "abort"} {
			break
		} else {
			update
		}
	}
}

# ----------------------------------------------------------------------
#  USAGE:  kd_save_usage <file> <usage>
#
#  Registers the given file in the list of known files, and saves
#  the usage for this directory.  Invoked during the processing of
#  "du" output to save each line of information.  Returns the name of
#  the new usage record.
# ----------------------------------------------------------------------
proc kd_save_usage {dir usage} {
	global KdKnownFiles KdKnownFileCnt KdCurrentTime

	if {![file exists $dir]} {
		error "directory does not exist: $dir"
	}
	if {![info exists KdKnownFiles($dir)]} {
		set dname KdInfo[incr KdKnownFileCnt]
		set KdKnownFiles($dir) $dname
	}
	set dname $KdKnownFiles($dir)
	global $dname

	set mtime [file mtime $dir]
	set [set dname](name) $dir
	set [set dname](files) [glob -nocomplain $dir/*]
	set [set dname](mtime) $mtime
	set [set dname](age)   [kd_compute_age [expr $KdCurrentTime-$mtime]]
	set [set dname](usage) $usage

	return $dname
}

# ----------------------------------------------------------------------
#  USAGE:  kd_draw_usage <viewer> <directory>
#
#  Draws a graphical display of usage for the given directory.
# ----------------------------------------------------------------------
proc kd_draw_usage {viewer dir} {
	global KdView KdResult

	set duinfo [kd_get_usage $dir]
	if {$duinfo == ""} {
		kd_message_box error "Cannot get usage info: $file"
		return
	}
	blt_busy hold $viewer; update
	kd_show_status "Drawing file list..."

	if {$viewer == "."} {
		set v ""
	} else {
		set v $viewer
	}
	set canv $v.view.canv
	set bar [option get . barColor Tk]

	set margin 5
	set canvBg [lindex [$canv config -background] 4]
	set canvWidth [winfo width $canv]

	set duinfo [kd_get_usage $dir]
	set filelist [kd_access $duinfo files]

	if {$KdView(deep-dir-hierarchy)} {
		set flist $filelist
		set filelist {}
		while {$flist != ""} {
			set file [lindex $flist 0]
			set flist [lreplace $flist 0 0]

			if {[file isdirectory $file]} {
				set duinfo [kd_get_usage $file]
				foreach file [kd_access $duinfo files] {
					lappend flist $file
				}
			} else {
				lappend filelist $file
			}

			if {$KdResult == "abort"} {
				break
			} else {
				update
			}
		}
	}

	set totalDirUsage 0
	set miscUsage 0
	set maxUsage 0
	set maxIconWidth 0
	set drawlist {}
	foreach file $filelist {
		if {![file exists $file]} {
			# symbolic link to non-existant file -- do nothing
		} elseif {[file isdirectory $file]} {
			set duinfo [kd_get_usage $file]
			if {$duinfo != ""} {
				set dUsage [kd_access $duinfo usage]
				set dMtime [kd_access $duinfo mtime]
				set dAge   [kd_access $duinfo age]

				set totalDirUsage [expr $totalDirUsage+$dUsage]
				if {$dUsage > $maxUsage} {
					set maxUsage $dUsage
				}
				set iw [blt_bitmap width $dAge-folder]
				if {$iw > $maxIconWidth} {
					set maxIconWidth $iw
				}
				lappend drawlist [list $file $dUsage $dMtime $dAge-folder $file]
			}
		} else {
			set duinfo [kd_get_usage $file]
			if {$duinfo != ""} {
				set dUsage [kd_access $duinfo usage]
				set dMtime [kd_access $duinfo mtime]
				set dAge   [kd_access $duinfo age]

				if {$KdView(only-significant-files)} {
					set show [expr $dUsage >= $KdView(significant-file-size)]
				} else {
					set show 1
				}
				if {$show} {
					if {$dUsage > $maxUsage} {
						set maxUsage $dUsage
					}
					set iw [blt_bitmap width $dAge-file]
					if {$iw > $maxIconWidth} {
						set maxIconWidth $iw
					}
					lappend drawlist [list $file $dUsage $dMtime $dAge-file $file]
				} else {
					set miscUsage [expr $miscUsage+$dUsage]
				}
			}
		}

		if {$KdResult == "abort"} {
			break
		} else {
			update
		}
	}
	set duinfo [kd_get_usage $dir]
	set dUsage [kd_access $duinfo usage]
	set dMtime [kd_access $duinfo mtime]
	set fileUsage [expr $dUsage-$totalDirUsage]
	$v.status.usageInfo config \
		-text [format "%dK (%dK files, %dK directories)" \
			$dUsage $fileUsage $totalDirUsage]

	if {$KdView(only-significant-files)} {
		if {$miscUsage > $maxUsage} {
			set maxUsage $miscUsage
		}
		set iw [blt_bitmap width misc-files]
		if {$iw > $maxIconWidth} {
			set maxIconWidth $iw
		}
		lappend drawlist [list "Misc files" $miscUsage $dMtime misc-files <misc>]
	}

	set drawlist [lsort -command kd_drawlist_cmp $drawlist]

	set id [$canv create text 0 0 -anchor nw -text "999999K"]
	set bbox [$canv bbox $id]
	set maxSizeWidth [expr [lindex $bbox 2]-[lindex $bbox 0]]

	set maxIconWidth [expr $maxIconWidth+$margin]
	set usageWidth [expr $canvWidth-$maxIconWidth-$maxSizeWidth-2*$margin]
	set x0 [expr $maxIconWidth+$margin]
	if {$maxUsage == 0} { set maxUsage 1 }

	$canv delete all
	set y $margin
	foreach elem $drawlist {
		set dName [lindex $elem 0]
		set dUsage [lindex $elem 1]
		set bitmap [lindex $elem 3]
		set dTag [lindex $elem 4]
		$canv create bitmap $maxIconWidth $y -anchor ne -bitmap $bitmap
		set id [$canv create text $x0 $y -anchor nw -text $dName]
		set bbox [$canv bbox $id]
		set htText [expr [lindex $bbox 3]-[lindex $bbox 1]]
		set y0 [expr $y+$htText]
		set y1 [expr $y+[blt_bitmap height $bitmap]]
		if {$y0 > $y1} {set y1 [expr $y0+$margin]}
		$canv create rect $x0 $y0 \
			[expr $x0+$dUsage*$usageWidth/$maxUsage] $y1 \
			-stipple gray50 -fill $bar
		$canv create text [expr $canvWidth-$margin] $y1 -anchor se \
			-text "[set dUsage]K"

		set id [$canv create rect [expr $margin-1] [expr $y-1] \
			[expr $canvWidth-$margin] [expr $y1+$margin-1] \
			-fill $canvBg -outline $canvBg -tags "ELEMS ELEM-$dTag"]
		$canv lower $id

		set y [expr $y1+$margin]

		if {$KdResult == "abort"} {
			break
		} else {
			update
		}
	}
	set bbox [$canv bbox all]
	if {$bbox != ""} {
		set x0 [lindex $bbox 0]
		set y0 [expr [lindex $bbox 1]-$margin]
		set x1 [lindex $bbox 2]
		set y1 [expr [lindex $bbox 3]+$margin]
		$canv config -scrollregion [list $x0 $y0 $x1 $y1]
	}

	if {$KdResult == "abort"} {
		$canv delete all
	}
	blt_busy release $viewer
	kd_hide_status
}

# ----------------------------------------------------------------------
#  USAGE:  kd_drawlist_cmp <entry1> <entry2>
#
#  Compares two entries in a drawlist list composed in kd_draw_usage,
#  according to the drawing mode in KdView().
#
#  RETURNS:  -1 => entry1 < entry2
#             0 => entry1 == entry2
#            +1 => entry2 > entry2
# ----------------------------------------------------------------------
proc kd_drawlist_cmp {e1 e2} {
	global KdView

	switch $KdView(sort) {
		byName {
			return [string compare [lindex $e1 0] [lindex $e2 0]]
		}
		bySize {
			set s1 [lindex $e1 1]
			set s2 [lindex $e2 1]
			if {$s1 < $s2} {
				return 1
			} elseif {$s1 > $s2} {
				return -1
			}
			return 0
		}
		byTime {
			set t1 [lindex $e1 2]
			set t2 [lindex $e2 2]
			if {$t1 < $t2} {
				return -1
			} elseif {$t1 > $t2} {
				return 1
			}
			return 0
		}
		default {
			error "bad view mode: $KdView(sort)"
		}
	}
}

# ----------------------------------------------------------------------
#  USAGE:  kd_package_viewer_file <viewer> <win> <token>
#
#  Packs the token for drag&drop operations on the given usage viewer.
#  Queries the current drag&drop location to figure out what file
#  was selected, and then packs the token window with the name of
#  the file.
# ----------------------------------------------------------------------
proc kd_package_viewer_file {viewer win token} {
	if {$viewer == "."} {
		set v ""
	} else {
		set v $viewer
	}

	if {[winfo children $token] == ""} {
		label $token.icon
		label $token.name
		pack $token.icon -side left -fill both
		pack $token.name -side right -fill both
	}

	switch [winfo class $win] {
		Canvas {
			set xy [blt_drag&drop location]
			set x [expr [lindex $xy 0]-[winfo rootx $v.view.canv]]
			set y [expr [lindex $xy 1]-[winfo rooty $v.view.canv]]

			set file [kd_usage_select $viewer $x $y]
			if {$file == ""} {
				error "no file selected"
			}
		}
		Label {
			set file [lindex [$win config -text] 4]
		}
		Entry {
			set file [$win get]
		}
	}
	if {$file == "<misc>"} {
		$token.icon config -bitmap misc-files
		$token.name config -text "Misc files"
	} else {
		set duinfo [kd_get_usage $file]
		if {$duinfo == ""} {
			$token.icon config -bitmap unknown
			$token.name config -text [file tail $file]
		} else {
			set dAge   [kd_access $duinfo age]
			if {[file isdirectory $file]} {
				$token.icon config -bitmap $dAge-folder
			} else {
				$token.icon config -bitmap $dAge-file
			}
			$token.name config -text [file tail $file]
		}
	}
	return $file
}

# ----------------------------------------------------------------------
#  USAGE:  kd_package_list_file <listbox> <token>
#
#  Packs the token for drag&drop operations on the some file list.
#  Queries the current drag&drop location to figure out what file
#  was selected, and then packs the token window with the name of
#  the file.
# ----------------------------------------------------------------------
proc kd_package_list_file {lbox token} {
	if {[winfo children $token] == ""} {
		label $token.icon
		label $token.name
		pack $token.icon -side left -fill both
		pack $token.name -side right -fill both
	}
	set xy [blt_drag&drop location]
	set y  [expr [lindex $xy 1]-[winfo rooty $lbox]]

	set file [$lbox get [$lbox nearest $y]]
	if {$file == ""} {
		error "no file selected"
	}

	set duinfo [kd_get_usage $file]
	set dAge   [kd_access $duinfo age]
	if {[file isdirectory $file]} {
		$token.icon config -bitmap $dAge-folder
	} else {
		$token.icon config -bitmap $dAge-file
	}
	$token.name config -text [file tail $file]

	return $file
}

# ----------------------------------------------------------------------
#  USAGE:  kd_site_file <over-target> <token>
#
#  Invoked whenever the drag&drop token changes its "site" status.
#  Updates the appearance of the token window to indicate whether
#  or not the token is over a valid drag&drop site.
# ----------------------------------------------------------------------
proc kd_site_file {overtarget token} {
	if {$overtarget} {
		set bg [option get $token tokenActiveBackground Tk]
		set fg [option get $token tokenActiveForeground Tk]
		$token.icon config -bg $bg -fg $fg
	} else {
		set bg [option get $token tokenBackground Tk]
		set fg [option get $token tokenForeground Tk]
		$token.icon config -bg $bg -fg $fg
	}
}

# ----------------------------------------------------------------------
#  USAGE:  kd_usage_select <viewer> <x> <y>
#
#  Returns the name of the element under the given (x,y) coordinate
#  of the viewer canvas.  Used during select or drag&drop operations on
#  the canvas to figure out what was selected.
# ----------------------------------------------------------------------
proc kd_usage_select {viewer x y} {
	if {$viewer == "."} {
		set v ""
	} else {
		set v $viewer
	}
	set inc [lindex [$v.view.canv config -scrollincrement] 4]
	set top [lindex [$v.view.sbar get] 2]
	set y [expr $y+$top*$inc]

	foreach item [$v.view.canv find overlapping $x $y $x $y] {
		foreach tag [$v.view.canv gettags $item] {
			if {[regexp {ELEM-(.*)} $tag match elem]} {
				set bg [lindex [$v.view.canv config -background] 4]
				$v.view.canv itemconfig ELEMS -outline $bg
				catch "$v.view.canv itemconfig ELEM-$elem -outline black"
				update
				return $elem
			}
		}
	}
	return ""
}

# ----------------------------------------------------------------------
#  USAGE:  kd_trash_append
#
#  Adds a new file to the list of files in the "trash" collection.
#  If the "trash" window is unmapped, this causes it to be visible.
# ----------------------------------------------------------------------
proc kd_trash_append {file} {
	global KdTrash

	if {![winfo ismapped .trash]} {
		.trash.file.list delete 0 end
		kd_map .trash
		focus .trash
	}
	if {[lsearch $KdTrash $file] < 0} {
		kd_file_unlink $file

		lappend KdTrash $file
		.trash.file.list insert end $file

		set total 0
		foreach f $KdTrash {
			set duinfo [kd_get_usage $f]
			set dUsage [kd_access $duinfo usage]
			set total [expr $total+$dUsage]
		}
		.trash.total config -text "Total: [set total]K"
	}
}

# ----------------------------------------------------------------------
#  USAGE:  kd_trash_perform
#
#  Causes all of the files in the current "trash" collection to be
#  deleted.  If the operation was successful, the "trash" window is
#  hidden until needed again.
# ----------------------------------------------------------------------
proc kd_trash_perform {} {
	global KdTrash KdResult

	blt_busy hold .trash; update
	kd_show_status "Deleting files..."

	set errors {}
	while {$KdTrash != ""} {
		set file [lindex $KdTrash 0]
		set KdTrash [lreplace $KdTrash 0 0]

		if {![file owned $file]} {
			lappend errors $file
		}
		blt_bgexec -errorvar KdErrors KdResult rm -rf $file
		tkwait variable KdResult

		if {$KdResult == "abort"} {
			break
		} else {
			update
		}
	}
	blt_busy release .trash
	kd_hide_status

	if {$KdResult == "abort"} {
		set mesg "\nDelete aborted.\n\nThe following files were not removed:\n"
		foreach file $KdTrash {
			append mesg "$file\n"
		}
		kd_message_box warning $mesg
	}

	if {[llength $errors] == 0 && [llength $KdTrash] == 0} {
		kd_unmap .trash
	} else {
		if {[llength $errors] > 0} {
			set mesg "\nCould not remove files:\n"
			foreach file $errors {
				append mesg "$file\n"
			}
			kd_message_box error $mesg
		}
		if {[llength $KdTrash] > 0} {
			eval lappend errors $KdTrash
		}

		set KdTrash {}
		.trash.file.list delete 0 end
		foreach file $errors {
			kd_trash_append $file
		}
	}
}

# ----------------------------------------------------------------------
#  USAGE:  kd_trash_cancel
#
#  Aborts the operation of removing files, clearing the current
#  trash collection and hiding the trash window.
# ----------------------------------------------------------------------
proc kd_trash_cancel {} {
	global KdTrash

	blt_busy hold .trash; update
	foreach file $KdTrash {
		kd_trash_refile $file
	}
	kd_view_update

	blt_busy release .trash
	kd_unmap .trash
}

# ----------------------------------------------------------------------
#  USAGE:  kd_trash_refile
#
#  Removes a particular file from the trash, putting it back into
#  the usage info for its associated directory.
# ----------------------------------------------------------------------
proc kd_trash_refile {file} {
	global KdTrash

	set i [lsearch $KdTrash $file]
	if {$i >= 0} {
		.trash.file.list delete $i
		set KdTrash [lreplace $KdTrash $i $i]
		kd_file_link $file

		set total 0
		foreach f $KdTrash {
			set duinfo [kd_get_usage $f]
			set dUsage [kd_access $duinfo usage]
			set total [expr $total+$dUsage]
		}
		.trash.total config -text "Total: [set total]K"
	}
}

# ----------------------------------------------------------------------
#  USAGE:  kd_compress_append
#
#  Adds a new file to the list of files in the "compress" collection.
#  If the "compress" window is unmapped, this causes it to be visible.
# ----------------------------------------------------------------------
proc kd_compress_append {file} {
	global KdCompress

	if {![winfo ismapped .compress]} {
		kd_map .compress
		focus .compress
	}
	if {[lsearch $KdCompress $file] < 0} {
		kd_file_unlink $file

		lappend KdCompress $file
		.compress.file.list insert end $file

		set total 0
		foreach f $KdCompress {
			set duinfo [kd_get_usage $f]
			set dUsage [kd_access $duinfo usage]
			set total [expr $total+$dUsage]
		}
		.compress.total config -text "Total: [set total]K"
	}
}

# ----------------------------------------------------------------------
#  USAGE:  kd_compress_perform
#
#  Causes all of the files in the current "compress" collection to be
#  deleted.  If the operation was successful, the "compress" window is
#  hidden until needed again.
# ----------------------------------------------------------------------
proc kd_compress_perform {} {
	global KdCompress KdResult

	blt_busy hold .compress; update
	kd_show_status "Compressing files..."

	set errors {}
	while {$KdCompress != ""} {
		set file [lindex $KdCompress 0]
		set KdCompress [lreplace $KdCompress 0 0]

		set dir [file dirname $file]
		if {![file owned $file] || ![file writable $dir]} {
			lappend errors $file
		} elseif {[file isdirectory $file]} {
			set tarfile $file.tar
			if {[file exists $tarfile] || [file exists $tarfile.gz]} {
				lappend errors $file
			} else {
				# CREATE TAR FILE
				set cwd [cd]
				cd [file dirname $file]
				blt_bgexec -errorvar KdErrors KdResult \
					tar cf $tarfile [file tail $file]
				cd $cwd
				puts stdout "tar cf $tarfile [file tail $file]"
				set KdErrors {}
				tkwait variable KdResult
				puts stdout "=> $KdResult ($KdErrors)"

				if {$KdResult == "abort"} {
					lappend KdCompress $file
				} elseif {![file exists $tarfile]} {
					set KdResult error
					lappend errors $file
				} else {

					# COMPRESS TAR FILE
					blt_bgexec -errorvar KdErrors KdResult \
						gzip -f $tarfile
					puts stdout "gzip -f $tarfile"
					tkwait variable KdResult
					puts stdout "=> $KdResult ($KdErrors)"

					if {$KdResult == "abort"} {
						lappend KdCompress $file
					} elseif {![file exists $tarfile.gz]} {
						set KdResult error
						lappend errors $file
					} else {

						# REMOVE ORIGINAL DIRECTORY
						blt_bgexec -errorvar KdErrors KdResult \
							rm -rf $file
						puts stdout "rm -rf $file"
						tkwait variable KdResult
						puts stdout "=> $KdResult ($KdErrors)"
					}
				}
			}
			if {$KdResult == "abort" || $KdResult == "error"} {
				blt_bgexec -errorvar KdErrors ignore \
					rm -f $tarfile $tarfile.gz
				puts stdout "rm -f $tarfile $tarfile.gz"
				set ignore {}
				tkwait variable ignore
				puts stdout "=> $ignore ($KdErrors)"
			}
		} else {
			if {[file exists $file.gz]} {
				lappend errors $file
			} else {

				# COMPRESS PLAIN FILE
				blt_bgexec -errorvar KdErrors KdResult \
					gzip -f $file
				puts stdout "gzip -f $file"
				set KdErrors {}
				tkwait variable KdResult
				puts stdout "=> $KdResult ($KdErrors)"

				if {$KdResult == "abort"} {
					lappend KdCompress $file
				} elseif {![file exists $file.gz]} {
					lappend errors $file
				}
			}
		}

		if {$KdResult == "abort"} {
			break
		} else {
			update
		}
	}
	blt_busy release .compress
	kd_hide_status

	if {$KdResult == "abort"} {
		set mesg "\nCompress aborted.\n\nThe following files were not compressed:\n"
		foreach file $KdCompress {
			append mesg "$file\n"
		}
		kd_message_box warning $mesg
	}

	if {[llength $errors] == 0 && [llength $KdCompress] == 0} {
		kd_unmap .compress
	} else {
		if {[llength $errors] > 0} {
			set mesg "\nCould not compress files:\n"
			foreach file $errors {
				append mesg "$file\n"
			}
			kd_message_box error $mesg
		}
		if {[llength $KdCompress] > 0} {
			eval lappend errors $KdCompress
		}

		set KdCompress {}
		.compress.file.list delete 0 end
		foreach file $errors {
			kd_compress_append $file
		}
	}
}

# ----------------------------------------------------------------------
#  USAGE:  kd_compress_cancel
#
#  Aborts the operation of removing files, clearing the current
#  compress collection and hiding the compress window.
# ----------------------------------------------------------------------
proc kd_compress_cancel {} {
	global KdCompress

	blt_busy hold .compress; update
	foreach file $KdCompress {
		kd_compress_refile $file
	}
	kd_view_update

	blt_busy release .compress
	kd_unmap .compress
}

# ----------------------------------------------------------------------
#  USAGE:  kd_compress_refile
#
#  Removes a particular file from the compress, putting it back into
#  the usage info for its associated directory.
# ----------------------------------------------------------------------
proc kd_compress_refile {file} {
	global KdCompress

	set i [lsearch $KdCompress $file]
	if {$i >= 0} {
		.compress.file.list delete $i
		set KdCompress [lreplace $KdCompress $i $i]
		kd_file_link $file

		set total 0
		foreach f $KdCompress {
			set duinfo [kd_get_usage $f]
			set dUsage [kd_access $duinfo usage]
			set total [expr $total+$dUsage]
		}
		.compress.total config -text "Total: [set total]K"
	}
}

# ----------------------------------------------------------------------
#  USAGE:  kd_prefs_map
#
#  Makes the "preferences" dialog box visible and fills it with
#  current preference values.
# ----------------------------------------------------------------------
proc kd_prefs_map {} {
	global KdView

	.prefs.settings.sigEntry delete 0 end
	.prefs.settings.sigEntry insert 0 $KdView(significant-file-size)

	switch $KdView(sort) {
		byName { .prefs.settings.byName invoke }
		bySize { .prefs.settings.bySize invoke }
		byAge  { .prefs.settings.byAge invoke }
	}

	if {$KdView(deep-dir-hierarchy)} {
		.prefs.settings.deepFiles invoke
	} else {
		.prefs.settings.localFiles invoke
	}

	if {$KdView(only-significant-files)} {
		.prefs.settings.sigFiles invoke
	} else {
		.prefs.settings.allFiles invoke
	}
	kd_map .prefs
	raise .prefs
	focus .prefs
}

# ----------------------------------------------------------------------
#  USAGE:  kd_prefs_apply
#
#  Checks all values in the "preferences" dialog box, and if they are
#  valid, applies them and saves them in a file in the user's home
#  directory.
# ----------------------------------------------------------------------
proc kd_prefs_apply {} {
	global env KdView
	set abort ""

	set s [.prefs.settings.sigEntry get]
	if {[catch "expr $s*1"] != 0 || $s < 0} {
		set abort "Invalid file size: $s\nshould be a number >= 0"
	}

	if {$abort != ""} {
		kd_message_box error $abort
	} else {
		set KdView(significant-file-size) $s
		set KdView(sort) $KdView(tmp:sort)
		set KdView(only-significant-files) $KdView(tmp:only-significant-files)
		set KdView(deep-dir-hierarchy) $KdView(tmp:deep-dir-hierarchy)

		set pfile $env(HOME)/.kosherdill
		if {[catch "open $pfile w" fid] != 0} {
			kd_message_box warning "Cannot write to preferences file:\n$pfile"
		} else {
			puts $fid "preference significant-file-size $s"
			puts $fid "preference sort $KdView(sort)"
			puts $fid "preference only-significant-files $KdView(only-significant-files)"
			puts $fid "preference deep-dir-hierarchy $KdView(deep-dir-hierarchy)"
			close $fid
		}
		kd_unmap .prefs
		kd_view_update
	}
}

# ----------------------------------------------------------------------
#  USAGE:  kd_prefs_cancel
#
#  Aborts any settings in the preferences panel and makes the
#  preferences dialog box invisible.
# ----------------------------------------------------------------------
proc kd_prefs_cancel {} {
	kd_unmap .prefs
}

# ----------------------------------------------------------------------
#  USAGE:  preference <name> <value>
#
#  Used in a kosherdill "preferences" file to define preference
#  settings.
# ----------------------------------------------------------------------
proc preference {name val} {
	global KdView

	switch $name {
		significant-file-size {
			if {[catch "expr $val*1"] != 0 || $val < 0} {
				error "Invalid file size: $val\nshould be a number >= 0"
			}
		}
		sort {
			if {$val != "byName" && $val != "bySize" && $val != "byAge"} {
				error "Invalid sorting scheme: $val\nshould be byName, bySize or byAge"
			}
		}
		only-significant-files {
			if {[catch "expr $val*1"] != 0} {
				error "Invalid "significant files" flag: $val\nshould 0/1"
			}
		}
		deep-dir-hierarchy {
			if {[catch "expr $val*1"] != 0} {
				error "Invalid "deep hierarchy" flag: $val\nshould 0/1"
			}
		}
		default {
			error "Preference not recognized: $name"
		}
	}
	set KdView($name) $val
}

# ----------------------------------------------------------------------
#  USAGE:  kd_option_age <age> <default>
#
#  Looks for an age option with the given <age> name and interprets
#  it as a file age in weeks.  Stores the result in the global
#  KdAgeCategories() for later use.
# ----------------------------------------------------------------------
proc kd_option_age {age def} {
	global KdAgeTimes

	set optname [set age]Age
	option add Tk*$optname $def widgetDefault
	set weeks [option get . $optname Tk]
	if {[catch "expr $weeks*7*24*60*60" secs] != 0} {
		error "invalid resource \"$optname: $weeks\": value should be age in weeks"
	}
	set KdAgeTimes($age) $secs
}

# ----------------------------------------------------------------------
#  USAGE:  kd_compute_age <age-secs>
#
#  Computes the "age" category for the given file age in seconds.
#  Returns an age category that can be used to select an appropriate
#  bitmap to represent file age.
# ----------------------------------------------------------------------
proc kd_compute_age {age} {
	global KdAgeTimes KdAgeCategories KdAgeList

	if {![info exists KdAgeCategories]} {
		set KdAgeList {}
		foreach cat [array names KdAgeTimes] {
			set KdAgeCategories($KdAgeTimes($cat)) $cat
			lappend KdAgeList $KdAgeTimes($cat)
		}
		set KdAgeList [lsort -integer $KdAgeList]
	}
	foreach t $KdAgeList {
		if {$age < $t} {
			return $KdAgeCategories($t)
		}
	}
	return $KdAgeCategories($t)
}

# ----------------------------------------------------------------------
#  USAGE:  kd_get_current_time
#
#  Called every so often to query for the current time.  Gets the
#  time using an awful hack:  touches a file in /tmp and then queries
#  for its "mtime".
# ----------------------------------------------------------------------
proc kd_get_current_time {} {
	global KdCurrentTime

	set file /tmp/kosherdill[pid]
	exec touch $file
	set KdCurrentTime [file mtime $file]
	exec rm -f $file
}

# ----------------------------------------------------------------------
#  USAGE:  kd_map <win>
#
#  Used instead of "wm deiconify" to map a window.  If the window has
#  already been mapped and has placement information, this is set just
#  before the window is mapped to put the window back in the proper
#  place.  Needed for proper interaction with virtual window managers
#  when windows are in outlying quadrants.
# ----------------------------------------------------------------------
proc kd_map {win} {
	global KdGeom

	if {[info exists KdGeom($win)]} {
		wm geometry $win $KdGeom($win)
	}
	wm deiconify $win
	raise $win
	focus $win
}

# ----------------------------------------------------------------------
#  USAGE:  kd_unmap <win>
#
#  Used instead of "wm withdraw" to unmap a window.  Saves current
#  placement information for the window, for the next call to kd_map.
#  Needed for proper interaction with virtual window managers when
#  windows are in outlying quadrants.
# ----------------------------------------------------------------------
proc kd_unmap {win} {
	global KdGeom

	set KdGeom($win) "+[winfo rootx $win]+[winfo rooty $win]"
	wm withdraw $win
}

# ----------------------------------------------------------------------
#  GLOBAL DATA
# ----------------------------------------------------------------------
kd_get_current_time
after 86400000 kd_get_current_time

set KdKnownFileCnt 0
set KdKnownFiles(x) "make-this-an-array"
unset KdKnownFiles(x)

set KdResult ""
trace variable KdResult w kd_process_du_info

set KdTrash {}
set KdCompress {}

set KdUnique 0
set KdView(sort) bySize
set KdView(only-significant-files) 0
set KdView(significant-file-size) 500
set KdView(deep-dir-hierarchy) 0
set KdViewers(.) {}

set KdStatusLevel 0
set KdAnimate {
	dill-du-0 dill-du-1 dill-du-2 dill-du-3 dill-du-4 dill-du-5
	dill-du-6 dill-du-7 dill-du-8 dill-du-9 dill-du-10 dill-du-11
}

# ----------------------------------------------------------------------
#  CUSTOMIZABLE STUFF
# ----------------------------------------------------------------------
kd_option_age new   4
kd_option_age dusty 8
kd_option_age old   20
kd_option_age moldy 40

# ----------------------------------------------------------------------
#  DIALOG FOR REMOVING FILES
# ----------------------------------------------------------------------
toplevel .trash
frame .trash.file -borderwidth 2 -relief sunken
listbox .trash.file.list -yscrollcommand ".trash.file.sbar set"
scrollbar .trash.file.sbar -command ".trash.file.list yview"
pack .trash.file.list -side left -expand yes -fill both
pack .trash.file.sbar -side right -fill y

frame .trash.cntl -borderwidth 1 -relief raised
label .trash.cntl.logo -bitmap trash
pack .trash.cntl.logo -side left
label .trash.cntl.refileTarget -bitmap refile \
	-borderwidth 2 -relief sunken
pack .trash.cntl.refileTarget -side left -padx 8 -pady 4
button .trash.cntl.cancel -text " Cancel " -command kd_trash_cancel
pack .trash.cntl.cancel -side right -padx 16
frame .trash.cntl.d -borderwidth 2 -relief sunken
button .trash.cntl.d.remove -text " Delete Files " -command kd_trash_perform
pack .trash.cntl.d.remove -padx 4 -pady 4
pack .trash.cntl.d -side right -padx 16 -pady 8
bind .trash <Key-Return> {
	.trash.cntl.d.remove flash
	.trash.cntl.d.remove invoke
}

blt_drag&drop source .trash.file.list config \
	-packagecmd "kd_package_list_file .trash.file.list" \
	-sitecmd kd_site_file

blt_drag&drop source .trash.file.list handler file dd_send_file
blt_drag&drop source .trash.file.list handler text dd_send_text

blt_drag&drop target .trash.file.list handler file {
	global DragDrop
	kd_trash_append $DragDrop(file)
	kd_view_update containing $DragDrop(file)
}

blt_drag&drop target .trash.cntl.refileTarget handler file {
	global DragDrop
	kd_trash_refile $DragDrop(file)
	kd_view_update containing $DragDrop(file)
}

label .trash.total -text "" -anchor w
pack .trash.total -side top -anchor w -padx 4
pack .trash.file -side top -expand yes -fill both -padx 4 -pady 4
pack .trash.cntl -side bottom -fill x

wm title .trash "Kosher Dill: Delete Files"
wm minsize .trash 200 200
wm withdraw .trash

# ----------------------------------------------------------------------
#  DIALOG FOR COMPRESSING FILES
# ----------------------------------------------------------------------
toplevel .compress
frame .compress.file -borderwidth 2 -relief sunken
listbox .compress.file.list -yscrollcommand ".compress.file.sbar set"
scrollbar .compress.file.sbar -command ".compress.file.list yview"
pack .compress.file.list -side left -expand yes -fill both
pack .compress.file.sbar -side right -fill y

frame .compress.cntl -borderwidth 1 -relief raised
label .compress.cntl.logo -bitmap compress
pack .compress.cntl.logo -side left
label .compress.cntl.refileTarget -bitmap refile \
	-borderwidth 2 -relief sunken
pack .compress.cntl.refileTarget -side left -padx 8 -pady 4
button .compress.cntl.cancel -text " Cancel " -command kd_compress_cancel
pack .compress.cntl.cancel -side right -padx 16
frame .compress.cntl.d -borderwidth 2 -relief sunken
button .compress.cntl.d.compress -text " Compress Files " \
	-command kd_compress_perform
pack .compress.cntl.d.compress -padx 4 -pady 4
pack .compress.cntl.d -side right -padx 16 -pady 8
bind .compress <Key-Return> {
	.compress.cntl.d.compress flash
	.compress.cntl.d.compress invoke
}

blt_drag&drop source .compress.file.list config \
	-packagecmd "kd_package_list_file .compress.file.list" \
	-sitecmd kd_site_file

blt_drag&drop source .compress.file.list handler file dd_send_file
blt_drag&drop source .compress.file.list handler text dd_send_text

blt_drag&drop target .compress.file.list handler file {
	global DragDrop
	kd_compress_append $DragDrop(file)
	kd_view_update containing $DragDrop(file)
}

blt_drag&drop target .compress.cntl.refileTarget handler file {
	global DragDrop
	kd_compress_refile $DragDrop(file)
	kd_view_update containing $DragDrop(file)
}

label .compress.total -text "" -anchor w
pack .compress.total -side top -anchor w -padx 4
pack .compress.file -side top -expand yes -fill both -padx 4 -pady 4
pack .compress.cntl -side bottom -fill x

wm title .compress "Kosher Dill: Compress Files"
wm minsize .compress 200 200
wm withdraw .compress

# ----------------------------------------------------------------------
#  DIALOG FOR PREFERENCES
# ----------------------------------------------------------------------
toplevel .prefs
frame .prefs.settings

label .prefs.settings.byLabel -text "List files..."
radiobutton .prefs.settings.byName -text "By Name" -relief flat \
	-variable KdView(tmp:sort) -value byName
radiobutton .prefs.settings.bySize -text "By Size" -relief flat \
	-variable KdView(tmp:sort) -value bySize
radiobutton .prefs.settings.byAge -text "By Age" -relief flat \
	-variable KdView(tmp:sort) -value byTime

label .prefs.settings.deepLabel -text "Show..."
radiobutton .prefs.settings.localFiles -text "Files in Local Directory" \
	-relief flat -variable KdView(tmp:deep-dir-hierarchy) -value 0
radiobutton .prefs.settings.deepFiles -text "Files in All Directories" \
	-relief flat -variable KdView(tmp:deep-dir-hierarchy) -value 1

label .prefs.settings.showLabel -text "Show..."
radiobutton .prefs.settings.allFiles -text "All Files" \
	-relief flat -variable KdView(tmp:only-significant-files) -value 0
radiobutton .prefs.settings.sigFiles -text "Only \"Significant\" Files" \
	-relief flat -variable KdView(tmp:only-significant-files) -value 1

label .prefs.settings.sigLabel -text "\"Significant\" File Size: "
entry .prefs.settings.sigEntry -width 7
bind .prefs.settings.sigEntry <Key-Return> {
	.prefs.cntl.d.apply flash
	.prefs.cntl.d.apply invoke
}
label .prefs.settings.sigUnits -text "K" -anchor w

blt_table .prefs.settings \
	.prefs.settings.byLabel 0,0 -anchor e \
	.prefs.settings.byName 0,1 -anchor w -columnspan 2 \
	.prefs.settings.bySize 1,1 -anchor w -columnspan 2 \
	.prefs.settings.byAge 2,1 -anchor w -columnspan 2 \
	.prefs.settings.deepLabel 4,0 -anchor e \
	.prefs.settings.localFiles 4,1 -anchor w -columnspan 2 \
	.prefs.settings.deepFiles 5,1 -anchor w -columnspan 2 \
	.prefs.settings.showLabel 7,0 -anchor e \
	.prefs.settings.allFiles 7,1 -anchor w -columnspan 2 \
	.prefs.settings.sigFiles 8,1 -anchor w -columnspan 2 \
	.prefs.settings.sigLabel 9,0 -anchor e \
	.prefs.settings.sigEntry 9,1 -anchor e \
	.prefs.settings.sigUnits 9,2 -anchor w

blt_table row .prefs.settings config 3 -height 8
blt_table row .prefs.settings config 6 -height 8
blt_table column .prefs.settings config 1 \
	-width [winfo reqwidth .prefs.settings.sigEntry]

frame .prefs.cntl -borderwidth 1 -relief raised
label .prefs.cntl.logo -bitmap dill-logo
pack .prefs.cntl.logo -side left
button .prefs.cntl.cancel -text " Cancel " -command kd_prefs_cancel
pack .prefs.cntl.cancel -side right -padx 16
frame .prefs.cntl.d -borderwidth 2 -relief sunken
button .prefs.cntl.d.apply -text " Apply " -command kd_prefs_apply
pack .prefs.cntl.d.apply -padx 4 -pady 4
pack .prefs.cntl.d -side right -padx 16 -pady 8
bind .prefs <Key-Return> {
	.prefs.cntl.d.apply flash
	.prefs.cntl.d.apply invoke
}

blt_drag&drop target .prefs.settings.sigEntry handler file {
	global DragDrop
	set duinfo [kd_get_usage $DragDrop(file)]
	set dUsage [kd_access $duinfo usage]
	.prefs.settings.sigEntry delete 0 end
	.prefs.settings.sigEntry insert 0 $dUsage
}

pack .prefs.settings -side top -expand yes -fill both -padx 4 -pady 16
pack .prefs.cntl -side bottom -fill x

wm title .prefs "Kosher Dill: Preferences"
wm withdraw .prefs

# ----------------------------------------------------------------------
#  ABOUT WINDOW
# ----------------------------------------------------------------------
toplevel .about
frame .about.credits
frame .about.credits.info -borderwidth 2
label .about.credits.info.title -text "Kosher Dill"
pack .about.credits.info.title -side top
message .about.credits.info.expl -justify center -aspect 200 \
	-text "KOmprehensive\nStorage HandlER\n---\nDisk ILLustrator"
pack .about.credits.info.expl -side left
label .about.credits.info.logo -bitmap dill-logo
pack .about.credits.info.logo -side right
pack .about.credits.info -side left

message .about.credits.author -justify left -aspect 300 -text \
"Copyright (c) 1993
Michael J. McLennan
AT&T Bell Laboratories
michael.mclennan@att.com"
pack .about.credits.author -side right -padx 4
pack .about.credits -side top

frame .about.blt -borderwidth 2 -relief sunken
message .about.blt.info -justify left -aspect 300 -text "Thanks to George Howlett for the many wonderful things in his BLT toolkit that made this application possible!\n\nThanks also to Maria and Maxwell for giving me time to tinker."
pack .about.blt.info -side left -ipadx 4 -ipady 4
label .about.blt.logo -bitmap dill-blt
pack .about.blt.logo -side right -anchor n -ipadx 4 -ipady 4
pack .about.blt -side top -padx 8 -pady 8

message .about.disclaimer -justify center -aspect 500 -text "AT&T disclaims all warranties with regard to this software, including all implied warranties of merchantability and fitness.  In no event shall AT&T be liable for any special, indirect or consequential damages or any damages whatsoever resulting from loss of use, data or profits, whether in an action of contract, negligence or other tortuous action, arising out of or in connection with the use or performance of this software."
pack .about.disclaimer -side top -pady 8

frame .about.cntl -borderwidth 1 -relief raised
frame .about.cntl.d -borderwidth 2 -relief sunken
button .about.cntl.d.dismiss -text " Dismiss " -command {
	kd_unmap .about
}
pack .about.cntl.d.dismiss -padx 4 -pady 4
pack .about.cntl.d -side top -padx 8 -pady 8
bind .about <Key-Return> {
	.about.cntl.d.dismiss flash
	.about.cntl.d.dismiss invoke
}
pack .about.cntl -side top -fill x

wm title .about "Kosher Dill: About"
wm withdraw .about

# ----------------------------------------------------------------------
#  "ABORT" WINDOW
# ----------------------------------------------------------------------
toplevel .abort
frame .abort.cntl -borderwidth 1 -relief raised
button .abort.cntl.abort -text " Abort " -command "kd_status_abort"
pack .abort.cntl.abort -side top -padx 6 -pady 6
pack .abort.cntl -side bottom -fill x
label .abort.animate -bitmap dill-du-0
message .abort.mesg -text "" -aspect 2000 -justify left
pack .abort.animate -side left -padx 4 -pady 4
pack .abort.mesg -side left -anchor w

bind .abort <Any-Visibility> { if {![winfo ismapped .box]} {raise %W} }

wm title .abort "Kosher Dill: Status"
wm withdraw .abort

# ----------------------------------------------------------------------
#  NOTICE WINDOW
# ----------------------------------------------------------------------
toplevel .box -class Notice
message .box.mesg -aspect 1000

frame .box.cntl -borderwidth 2 -relief raised
label .box.cntl.icon
pack .box.cntl.icon -side top -pady 2
frame .box.cntl.d -borderwidth 2 -relief sunken
button .box.cntl.d.dismiss -text " Dismiss " \
	-command "set KdError dismiss"
pack .box.cntl.d.dismiss -padx 4 -pady 4
pack .box.cntl.d -padx 8 -pady 8

pack .box.cntl -side left -fill y
pack .box.mesg -side top -expand yes -fill both

wm title .box "Kosher Dill: Notice"
bind .box <Any-Visibility> { raise %W }
bind .box <Key-Return> {
	.box.cntl.d.dismiss flash
	.box.cntl.d.dismiss invoke
}
bind .box.cntl.icon <Double-ButtonPress-1> {
	global errorInfo
	.box.mesg config -text $errorInfo
}
wm withdraw .box

# ----------------------------------------------------------------------
#  MENU BAR
# ----------------------------------------------------------------------
frame .menu -borderwidth 1 -relief raised
menubutton .menu.file -text "File" -menu .menu.file.m
menu .menu.file.m
.menu.file.m add command -label "About..." -command "kd_map .about"
.menu.file.m add command -label "Preferences..." -command kd_prefs_map
.menu.file.m add separator
.menu.file.m add command -label "Quit" -command "exit"

menubutton .menu.view -text "View" -menu .menu.view.m
menu .menu.view.m
.menu.view.m add radiobutton -label "By Name" -command kd_view_update \
	-variable KdView(sort) -value byName
.menu.view.m add radiobutton -label "By Size" -command kd_view_update \
	-variable KdView(sort) -value bySize
.menu.view.m add radiobutton -label "By Age" -command kd_view_update \
	-variable KdView(sort) -value byTime
.menu.view.m add separator
.menu.view.m add radiobutton -label "Files in Local Directory" \
	-variable KdView(deep-dir-hierarchy) -value 0 -command kd_view_update
.menu.view.m add radiobutton -label "Files in All Directories" \
	-variable KdView(deep-dir-hierarchy) -value 1 -command kd_view_update
.menu.view.m add separator
.menu.view.m add radiobutton -label "All Files" \
	-variable KdView(only-significant-files) -value 0 -command kd_view_update
.menu.view.m add radiobutton -label "Only \"Significant\" Files" \
	-variable KdView(only-significant-files) -value 1 -command kd_view_update

menubutton .menu.help -text "Help" -menu .menu.help.m
menu .menu.help.m
.menu.help.m add command -label "About HyperHelp..." \
	-command "hyperhelp_file HyperHelp"
.menu.help.m add separator
.menu.help.m add command -label "About Kosher Dill..." \
	-command "hyperhelp_file Intro"

tk_menuBar .menu .menu.file .menu.view .menu.help

pack .menu.file -side left -padx 2
pack .menu.view -side left -padx 2
pack .menu.help -side right -padx 2

# ----------------------------------------------------------------------
#  DIRECTORY USAGE CANVAS
# ----------------------------------------------------------------------
frame .view -borderwidth 2 -relief sunken
canvas .view.canv -yscroll ".view.sbar set"
scrollbar .view.sbar -command ".view.canv yview"
pack .view.canv -side left -expand yes -fill both
pack .view.sbar -side right -fill y

bind .view.canv <Configure> "kd_view_update ."
bind .view.canv <ButtonPress-1> {
	set seln [kd_usage_select . %x %y]
}
bind .view.canv <Double-ButtonPress-1> {
	set seln [kd_usage_select . %x %y]
	if {$seln != ""} {
		kd_examine_dir . $seln
	}
}
bind .view.canv <ButtonPress-2> {%W scan mark 0 %y}
bind .view.canv <B2-Motion> {%W scan dragto 0 %y}

blt_drag&drop source .view.canv config \
	-packagecmd "kd_package_viewer_file . .view.canv" \
	-sitecmd kd_site_file

blt_drag&drop source .view.canv handler file dd_send_file
blt_drag&drop source .view.canv handler text dd_send_text

# ----------------------------------------------------------------------
#  DIRECTORY STATUS WINDOW
# ----------------------------------------------------------------------
frame .status -borderwidth 2
menubutton .status.dirLabel -text "Directory:" -relief flat
menu .status.dirLabel.m
.status.dirLabel config -menu .status.dirLabel.m
entry .status.dirEntry
bind .status.dirEntry <Key-Return> \
	{kd_examine_dir . [.status.dirEntry get]}

blt_drag&drop source .status.dirEntry config \
	-packagecmd "kd_package_viewer_file . .status.dirEntry" \
	-sitecmd kd_site_file
blt_drag&drop source .status.dirEntry handler file dd_send_file
blt_drag&drop source .status.dirEntry handler text dd_send_text

blt_drag&drop target .status.dirEntry handler file {
	global DragDrop
	kd_examine_dir . $DragDrop(file)
}

label .status.usageLabel -text "Usage:"
label .status.usageInfo -text "" -anchor w

blt_table .status \
	.status.dirLabel 0,0 -anchor e \
	.status.dirEntry 0,1 -anchor w -fill x \
	.status.usageLabel 1,0 -anchor e \
	.status.usageInfo 1,1 -anchor w -fill x
blt_table column .status config 0 \
	-width [winfo reqwidth .status.dirLabel]

# ----------------------------------------------------------------------
#  DRAG&DROP TARGETS
# ----------------------------------------------------------------------
frame .targets -borderwidth 4
label .targets.examineTarget -bitmap examine
label .targets.compressTarget -bitmap compress
label .targets.trashTarget -bitmap trash

blt_drag&drop target .targets.examineTarget handler file {
	global DragDrop
	kd_examine $DragDrop(file)
}
blt_drag&drop target .targets.compressTarget handler file {
	global DragDrop
	kd_compress_append $DragDrop(file)
	kd_view_update containing $DragDrop(file)
}
blt_drag&drop target .targets.trashTarget handler file {
	global DragDrop
	kd_trash_append $DragDrop(file)
	kd_view_update containing $DragDrop(file)
}

blt_table .targets \
	.targets.examineTarget 0,0 \
	.targets.compressTarget 0,1 \
	.targets.trashTarget 0,2 \

# ----------------------------------------------------------------------
#  MAIN WINDOW
# ----------------------------------------------------------------------
pack .menu -fill x
pack .status -side top -fill x -padx 4
pack .view -expand yes -fill both -padx 4 -pady 4
pack .targets -side top -fill x

wm minsize . 200 200
wm title . "Kosher Dill - Version $KdVersion"

# set display to sort by size...
.menu.view.m invoke 1

# set display to show all files...
.menu.view.m invoke 4

# set display to show files in local directory...
.menu.view.m invoke 7

# ----------------------------------------------------------------------
#  TRY TO LOAD ANY PREFERENCES
# ----------------------------------------------------------------------
update

set pfile $env(HOME)/.kosherdill
if {[file exists $pfile]} {
	if {[catch "open $pfile r" fid] != 0} {
		kd_message_box warning "Cannot read preferences file:\n$pfile"
	} else {
		set prefs [read $fid]
		close $fid
		if {[catch $prefs mesg] != 0} {
			kd_message_box warning "Error in preferences file\n$pfile\n\n$mesg"
		}
	}
}
