#include <stdlib.h>

#include "interleave.h"

/* ---------------------------------------------------------------------- */

struct interleave *interleave_init(int size, int dir)
{
	struct interleave *s;

	if ((s = calloc(1, sizeof(struct interleave))) == NULL)
		return NULL;

	s->table = calloc(10 * size * size, sizeof(unsigned char));

	s->size = size;
	s->direction = dir;

	return s;
}

void interleave_free(struct interleave *s)
{
	if (s) {
		free(s->table);
		free(s);
	}
}

static inline unsigned char *tab(struct interleave *s, int i, int j, int k)
{
	return &s->table[(s->size * s->size * i) + (s->size * j) + k];
}

void interleave_syms(struct interleave *s, unsigned char *syms)
{
	int i, j, k;

	for (k = 0; k < 10; k++) {
		for (i = 0; i < s->size; i++)
			for (j = 0; j < s->size - 1; j++)
				*tab(s, k, i, j) = *tab(s, k, i, j + 1);

		for (i = 0; i < s->size; i++)
			*tab(s, k, i, s->size - 1) = syms[i];

		for (i = 0; i < s->size; i++) {
			if (s->direction == INTERLEAVE_FWD)
				syms[i] = *tab(s, k, i, s->size - i - 1);
			else
				syms[i] = *tab(s, k, i, i);
		}
	}
}

void interleave_bits(struct interleave *s, unsigned int *bits)
{
	unsigned char *syms;
	int i;

	syms = alloca(s->size * sizeof(unsigned char));

	for (i = 0; i < s->size; i++)
		syms[i] = (*bits >> (s->size - i - 1)) & 1;

	interleave_syms(s, syms);

	for (*bits = i = 0; i < s->size; i++)
		*bits = (*bits << 1) | syms[i];
}

/* ---------------------------------------------------------------------- */

