#include <qwmatrix.h>
#include <qpainter.h>
#include <kdebug.h>
#include "navwidget.h"
#include <qpixmap.h>


NavWidget::NavWidget(QWidget *parent, const char *name)
  : QWidget(parent, name), view(0)
{

}

NavWidget::~NavWidget()
{

}

void NavWidget::paintEvent(QPaintEvent *)
{
    if ( !view )
      return;

    double w = width();
    double h = height();

    double xfactor = w / view->width();
    double yfactor = h / view->height();
    if (xfactor < yfactor)
       yfactor = xfactor;
    else
       xfactor = yfactor;

    QWMatrix matrix;
    matrix.scale(xfactor, yfactor);

    QPainter p;
    p.begin(this);
    p.setWorldMatrix(matrix);
    p.drawPixmap(0, 0, *view);
    p.end();
}

void NavWidget::sizeChanged()
{
    repaint(true);
}

void NavWidget::setPixmap(QPixmap *p)
{
    view = p;
    repaint(true);
}

void NavWidget::pixmapChanged()
{
    // kdDebug(4400) << "NavWidget::pixmapChanged()\n" << endl;
    repaint(FALSE);
}

void NavWidget::viewportChanged(int, int, int, int)
{
  // Use this to draw the view rectangle
}

#include "navwidget.moc"
