/*
    translatorguiclient.h

    Kopete Translator Plugin

    Copyright (c) 2003 by Olivier Goffart <ogoffart@tiscalinet.be>

    Kopete    (c) 2003 by the Kopete developers  <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef TRANSLATORGUICLIENT_H
#define TRANSLATORGUICLIENT_H

#include <qobject.h>
#include <kxmlguiclient.h>

#include <kio/job.h>

#include "kopetemessage.h"
#include "kopeteplugin.h"

class KopeteMessageManager;

/**
  * @author Olivier Goffart <ogoffart@tiscalinet.be>
  */

class TranslatorGUIClient : public QObject , public KXMLGUIClient
{
	Q_OBJECT

public:
	TranslatorGUIClient( KopeteMessageManager *parent, const char *name=0L);
	~TranslatorGUIClient();

private slots:
	 void slotTranslateChat();
	 void messageTranslated(const QVariant&);

private:
	KopeteMessageManager *m_manager;
};

#endif

/*
 * Local variables:
 * c-indentation-style: k&r
 * c-basic-offset: 8
 * indent-tabs-mode: t
 * End:
 */
// vim: set noet ts=4 sts=4 sw=4:

