/*
 *  Copyright (C) 2001 Philip Langdale, Matthew Aubury
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef PROGRESSLISTENER2_H__
#define PROGRESSLISTENER2_H__

#include "galeon-embed-persist.h"
#include "galeon-embed-shell.h"
#include "downloader-view.h"

#include <gtk/gtkwidget.h>
#include <gtk/gtkwindow.h>
#include "nsIWebProgressListener.h"
#include "nsIHelperAppLauncherDialog.h"
#include "nsIExternalHelperAppService.h"
#include "nsCExternalHandlerService.h"
#include "nsIWebBrowserPersist.h"
#include "nsCOMPtr.h"
#include "nsWeakReference.h"
#include "nsIURI.h"
#include "nsILocalFile.h"
#include "nsIDOMWindow.h"
#include "nsIRequest.h"
#include "nsIMIMEInfo.h"
#include "nsIDownload.h"
#include "nsIObserver.h"
#include "nsIProgressDialog.h"

#define G_PROGRESSDIALOG_CID                \
{ /* d2a2f743-f126-4f1f-1234-d4e50490f112 */         \
    0xd2a2f743,                                      \
    0xf126,                                          \
    0x4f1f,                                          \
    {0x12, 0x34, 0xd4, 0xe5, 0x04, 0x90, 0xf1, 0x12} \
}

#define G_PROGRESSDIALOG_CLASSNAME "Galeon's Download Progress Dialog"
#define G_PROGRESSDIALOG_CONTRACTID "@mozilla.org/progressdialog;1"

class GProgressListener : public nsIProgressDialog,
#if MOZILLA_SNAPSHOT > 15
			  public nsIDownload,
#endif
			  public nsIWebProgressListener,
 			  public nsSupportsWeakReference
{
 public:
 	NS_DECL_ISUPPORTS
	NS_DECL_NSIWEBPROGRESSLISTENER
	NS_DECL_NSIPROGRESSDIALOG
	NS_DECL_NSIDOWNLOAD
#if MOZILLA_SNAPSHOT > 15
	NS_DECL_NSITRANSFER
#endif

	GProgressListener ();
	virtual ~GProgressListener ();

	NS_METHOD InitForPersist (nsIWebBrowserPersist *aPersist,
				  nsIURI *aURI,
				  nsIFile *aFile,
				  GaleonEmbedPersist *galeonPersist);

	nsresult Pause (void);
	nsresult Resume (void);
	nsresult Abort (void);

 private:
	NS_METHOD PrivateInit (void);
	NS_METHOD LaunchHelperApp (void);
	NS_METHOD SetRequest (nsIRequest *aRequest);

	nsCOMPtr<nsIWebBrowserPersist> mPersist;
	nsCOMPtr<nsIRequest> mRequest;
	
	GaleonEmbedPersist *mGaleonPersist;
	
	nsCOMPtr<nsIURI> mUri;
	nsCOMPtr<nsIFile> mFile;
#if MOZILLA_SNAPSHOT > 15
	nsCOMPtr<nsIURI> mTarget;
#endif
	
	PRInt64 mStartTime;
	PRInt64 mLastUpdate;

	PRBool mCanPause;
	PRBool mIsPaused;
	
	Download *mDownload;
	PRInt32   mContentLength;

	nsCOMPtr<nsIObserver> mObserver;

	nsCOMPtr<nsIMIMEInfo> mMIMEInfo;
};

nsresult 
InitiateMozillaDownload (nsIURI *sourceURI, nsILocalFile* inDestFile,
			 GaleonEmbedPersist *embedPersist,
			 nsIDOMDocument *domDocument, 
			 nsISupports *cacheKey,
			 nsIInputStream *postData,
			 PRBool decode,
			 nsIURI *displayURI);

nsresult
BuildDownloadPath (const char *defaultFileName, GtkWidget *parent,
		   nsILocalFile **_retval);

#endif // PROGRESSLISTENER2_H__

