// Copyright (c) 2003 Charles Samuels <charles@kde.org>
// See the file COPYING for redistribution terms.
#ifndef BASE_H
#define BASE_H

// ;)
#define unless(e) if(!(e))

#include <qstring.h>
#include <qobject.h>

#include "file.h"

class File;

class Base : public QObject
{
Q_OBJECT

	struct Private;
	Private *d; // not for BC, but for compile times :)

public:
	Base(const QString &file);
	~Base();

	File add(const QString &file);

	File find(FileId id);

	void clear();

	/**
	 * get the highest FileID
	 **/
	FileId high() const;

	/**
	 * @return first item after the given id (inclusive)
	 **/
	File first(FileId id=1);

	QString property(FileId id, const QString &property) const;
	void setProperty(FileId id, const QString &key, const QString &value);
	QStringList properties(FileId id) const;
	void clearProperty(FileId, const QString &key);

	/**
	 * same as File::remove
	 **/
	void remove(File f);

	/**
	 * change the id of a file
	 **/
	void move(FileId oldid, FileId newid);

	void dump();

public slots:
	void notifyChanged(const File &file);

signals:
	void added(File file);
	void removed(File file);
	void modified(File file);

private:
	void loadIntoCache(FileId id) const;
};


#endif
