/*****************************************************************

Copyright (c) 2001 Matthias Elter <elter@kde.org>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef __taskbar_h__
#define __taskbar_h__

#include <qptrlist.h>
#include <taskmanager.h>
#include <kpanelextension.h>

#include "panner.h"

class TaskContainer;

typedef QPtrList<QPixmap> PixmapList;
typedef QPtrList<TaskContainer> TaskContainerList;
typedef QPtrListIterator<TaskContainer> TaskContainerIterator;

class TaskBar : public Panner
{
    Q_OBJECT

public:
    // these values must match order in TaskBar::actionList()
    enum Action {
        ShowTaskList = 0,
        ShowOperationsMenu,
        ActivateRaiseOrIconify,
        Activate,
        Raise,
        Lower,
        Iconify,
        ActivateRaiseOrIconifyReverse // not used in the cfg. file at all
        };
    enum GroupMode {
        GroupNever = 0,
        GroupWhenFull,
        GroupAlways };

    TaskBar( QWidget *parent = 0, const char *name = 0 );
    ~TaskBar();

    QSize sizeHint() const;
    QSize sizeHint( KPanelExtension::Position, QSize maxSize ) const;

    void setOrientation( Orientation );
    void setArrowType( Qt::ArrowType at );
    TaskManager* taskManager();

    void configure();
    int containerCount() const;
    int taskCount() const;

signals:
    void containerCountChanged();

protected slots:
    void add( Task* );
    void add( Startup* );
    void remove( Task* );
    void remove( Startup* );

    void desktopChanged( int );
    void windowChanged( WId );

    void publishIconGeometry();

protected:
    void viewportMousePressEvent( QMouseEvent* );
    void viewportMouseReleaseEvent( QMouseEvent* );
    void viewportMouseDoubleClickEvent( QMouseEvent* );
    void viewportMouseMoveEvent( QMouseEvent* );
    void propagateMouseEvent( QMouseEvent* );
    void resizeEvent( QResizeEvent* );
    void reLayout();
    bool idMatch( const QString& id1, const QString& id2 );
    TaskContainerList filteredContainers();

private:
    static const QStringList& actionList();
    static const QStringList& groupModeList();
    static Action buttonAction( ButtonState button, const QString& actionName = QString::null );
    static GroupMode groupMode( const QString& groupModeName = QString::null );

    static			TaskManager* manager;
    bool			blocklayout;
    bool			showAllWindows;
    bool			showOnlyIconified;
    int 			currentGroupMode;
    bool			sortByDesktop;
    bool			showIcon;
    int 			maxButtonWidth;
    ArrowType 			arrowType;
    TaskContainerList		containers;
    PixmapList			*frames;
    int                         maximumButtonsWithoutShrinking() const;
    bool                        shouldGroup() const;
    bool                        isGrouping;
    void                        reGroup();
};

#endif
