/*****************************************************************

Copyright (c) 1996-2000 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#include <qvalidator.h>

#include <kapplication.h>
#include <khelpmenu.h>
#include <klocale.h>
#include <kiconloader.h>
#include <kglobal.h>
#include <kfiledialog.h>
#include <kprocess.h>
#include <kstandarddirs.h>
#include <kpopupmenu.h>
#include <kstdguiitem.h>

#include "panelop_mnu.h"
#include "panelop_mnu.moc"

#include "addcontainer_mnu.h"
#include "removecontainer_mnu.h"
#include "panel.h"
#include "containerarea.h"
#include "customSize_dlg.h"
#include "global.h"
#include "kicker.h"

PanelOpMenu::PanelOpMenu( ::Panel* panel, QWidget* parent )
    : QPopupMenu( parent, "PanelOpMenu" )
    , _panel( panel )
    , sizeMnu( 0 )
    , built( false )
{
    adjustSize();
    connect(this, SIGNAL(aboutToShow()), SLOT(buildMenu()));

}

void PanelOpMenu::slotSetupSizeMnu()
{
    sizeMnu->setItemChecked(::Tiny,false);
    sizeMnu->setItemChecked(::Small,false);
    sizeMnu->setItemChecked(::Normal,false);
    sizeMnu->setItemChecked(::Large,false);
    sizeMnu->setItemChecked(::Custom,false);
    sizeMnu->setItemChecked(_panel->size(),true);
    sizeMnu->setItemChecked(5,_panel->resizeablehandle());
    sizeMnu->setItemEnabled(5, (_panel->size()==::Custom));
}

void PanelOpMenu::slotSetSize(int size)
{
    if( static_cast<Size>(size) == ::Custom )
    {
        customSizeDialog* sizeDialog = new customSizeDialog(this);

        if (_panel->size() == ::Custom)
        {
            sizeDialog->setCurrentSize(_panel->panelSize());
        }

        connect(sizeDialog, SIGNAL(newCustomSize(int)),
                this, SLOT(slotSetCustomSize(int)));
        sizeDialog->show();
    }
    else
    {
        _panel->setSize(static_cast<Size>(size));
        sizeMnu->setItemEnabled(5, false);
    }
}

void PanelOpMenu::slotSetCustomSize(int customSize)
{
    _panel->setSize(Custom, customSize);
    sizeMnu->setItemEnabled(5, true);
}

void PanelOpMenu::slotResizeableHandleSwitch()
{
    _panel->setResizeableHandle(!_panel->resizeablehandle());
}

void PanelOpMenu::buildMenu()
{
    if(!built) {
	if (!Kicker::kicker()->isImmutable())
	{
	    // setup size menu
	    sizeMnu = new QPopupMenu(this);
	    sizeMnu->insertItem(i18n("Tiny"), this, SLOT(slotSetSize(int)), 0, ::Tiny);
	    sizeMnu->insertItem(i18n("Small"), this, SLOT(slotSetSize(int)), 0, ::Small);
	    sizeMnu->insertItem(i18n("Normal"), this, SLOT(slotSetSize(int)), 0, ::Normal);
	    sizeMnu->insertItem(i18n("Large"), this, SLOT(slotSetSize(int)), 0, ::Large);
	    sizeMnu->insertItem(i18n("Custom..."), this, SLOT(slotSetSize(int)), 0, ::Custom);
	    sizeMnu->insertSeparator();
	    sizeMnu->insertItem(i18n("Resizeable"), this, SLOT(slotResizeableHandleSwitch()), 0, 5);
	    connect(sizeMnu, SIGNAL(aboutToShow()), SLOT(slotSetupSizeMnu()));

	    insertItem(i18n("&Add"),
		   new AddContainerMenu( _panel->containerArea(), TRUE, this));
	    insertItem(i18n("&Remove"),
		   new RemoveContainerMenu( _panel->containerArea(), TRUE, this));
	    insertSeparator();
	    insertItem(i18n("Si&ze"), sizeMnu);

	    insertItem(SmallIconSet("configure"), i18n("&Configure Panel..."),
		   Kicker::kicker(), SLOT(slotLaunchConfig()));
	    insertSeparator();
	}

	KHelpMenu* help = new KHelpMenu( _panel, KGlobal::instance()->aboutData(), false);
	insertItem(SmallIconSet("help"), KStdGuiItem::help().text(), help->menu());

	built = true;
    }
}
