/***************************************************************************
                            kde_KFileTreeView.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KFILETREEVIEW
#define KDE_KFILETREEVIEW

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 The filetreeview offers a treeview on the file system which behaves like  
 a QTreeView showing files and/or directories in the file system.

 KFileTreeView is able to handle more than one URL, represented by
 @ref KFileTreeBranch.

 Typical usage:
 1. create a KFileTreeView fitting in your layout and add columns to it
 2. call addBranch to create one or more branches
 3. retrieve the root item with @ref KFileTreeBranch::root() and set it open
    if desired. That starts the listing.
 
 @short *
 The filetreeview offers a treeview on the file system which behaves like  
 a QTreeView showing files and/or directories in the file system.
*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_KFileTreeView * kde_new_KFileTreeView(qt_QWidget * parent, char* name);
void kde_del_KFileTreeView( kde_KFileTreeView* p );

/** *

*/
kde_KFileTreeViewItem* kde_KFileTreeView_currentKFileTreeViewItem(kde_KFileTreeView* instPointer);

/** *

*/
kde_KURL* kde_KFileTreeView_currentURL(kde_KFileTreeView* instPointer);

/** *
  Adds a branch to the treeview item.

  This high-level function creates the branch, adds it to the treeview and
  connects some signals. Note that directory listing does not start until
  a branch is expanded either by opening the root item by user or by setOpen
  on the root item.

*/
kde_KFileTreeBranch* kde_KFileTreeView_addBranch(kde_KFileTreeView* instPointer,kde_KURL* path, qt_QString * name, int showHidden);

/** *
  same as the function above but with a pixmap to set for the branch.
    
*/
kde_KFileTreeBranch* kde_KFileTreeView_addBranch1(kde_KFileTreeView* instPointer,kde_KURL* path, qt_QString * name, qt_QPixmap * pix, int showHidden);

/** *
  same as the function above but letting the user create the branch.
    
*/
kde_KFileTreeBranch* kde_KFileTreeView_addBranch2(kde_KFileTreeView* instPointer,kde_KFileTreeBranch* arg1);

/** *
  removes the branch from the treeview.

*/
int kde_KFileTreeView_removeBranch(kde_KFileTreeView* instPointer,kde_KFileTreeBranch* branch);

/** *

*/
kde_KFileTreeBranch* kde_KFileTreeView_branch(kde_KFileTreeView* instPointer,qt_QString * searchName);

/** *

*/

/** *
  set the directory mode for branches. If true is passed, only directories will be loaded.

*/
void kde_KFileTreeView_setDirOnlyMode(kde_KFileTreeView* instPointer,kde_KFileTreeBranch* brnch, int arg1);

/** *
 searches a branch for a @ref KFileTreeViewItem identified by the relative url given as
 second parameter. The method adds the branches base url to the relative path and finds
 the item.

*/
kde_KFileTreeViewItem* kde_KFileTreeView_findItem(kde_KFileTreeView* instPointer,kde_KFileTreeBranch* brnch, qt_QString * relUrl);

/** *
 see method above, differs only in the first parameter. Finds the branch by its name.
    
*/
kde_KFileTreeViewItem* kde_KFileTreeView_findItem1(kde_KFileTreeView* instPointer,qt_QString * branchName, qt_QString * relUrl);

/** *

*/
int kde_KFileTreeView_showFolderOpenPixmap(kde_KFileTreeView* instPointer);

/** *
 set the flag to show 'extended' folder icons on or off. If switched on, folders will
 have an open folder pixmap displayed if their children are visible, and the standard
 closed folder pixmap (from mimetype folder) if they are closed.
 If switched off, the plain mime pixmap is displayed.

*/
void kde_KFileTreeView_setShowFolderOpenPixmap(kde_KFileTreeView* instPointer,int showIt);

/** *

*/
int kde_KFileTreeView_acceptDrag(kde_KFileTreeView* instPointer,qt_QDropEvent* event);
qt_QDragObject* kde_KFileTreeView_dragObject(kde_KFileTreeView* instPointer);
void kde_KFileTreeView_startAnimation(kde_KFileTreeView* instPointer,kde_KFileTreeViewItem* item, char* iconBaseName, unsigned int iconCount);
void kde_KFileTreeView_stopAnimation(kde_KFileTreeView* instPointer,kde_KFileTreeViewItem* item);
void kde_KFileTreeView_virtual_hook(kde_KFileTreeView* instPointer,int identifier, void* data);
void kde_KFileTreeView_slotSetNextUrlToSelect(kde_KFileTreeView* instPointer,kde_KURL* url);
qt_QPixmap * kde_KFileTreeView_itemIcon(kde_KFileTreeView* instPointer,kde_KFileTreeViewItem* arg1, int gap);

#ifdef __cplusplus
}
#endif
#endif
