/***************************************************************************
                            kde_KLineEditDlg.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KLINEEDITDLG
#define KDE_KLINEEDITDLG

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 Dialog for user to enter a single line of text.

 @author David Faure <faure@kde.org>, layout management by Preston Brown <pbrown@kde.org>
 
 @version $Id: kde_KLineEditDlg.h,v 1.5 2002/12/30 14:37:06 geiseri Exp $

 @short *
 Dialog for user to enter a single line of text.
*/

/** *
 Create a dialog that asks for a single line of text. _value is
 the initial value of the line. _text appears as label on top of
 the entry box. If the internal line edit has an associated @ref
 QValidator set, the OK button is disabled as long as the
 validator doesn't return Acceptable. If there's no validator, the
 OK button is enabled whenever the line edit isn't empty.

 If you want to accept empty input, make a trivial QValidator that
 always returns Acceptable, e.g. @ref QRegExpValidator with a
 regexp of ".*".

*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_KLineEditDlg * kde_new_KLineEditDlg(qt_QString * _text, qt_QString * _value, qt_QWidget * parent);
void kde_del_KLineEditDlg( kde_KLineEditDlg* p );

/** *

*/
qt_QString * kde_KLineEditDlg_text(kde_KLineEditDlg* instPointer);

/** *

*/
kde_KLineEdit* kde_KLineEditDlg_lineEdit(kde_KLineEditDlg* instPointer);

/** *
 Clears the edit widget
   
*/
void kde_KLineEditDlg_slotClear(kde_KLineEditDlg* instPointer);

/** *
 Static convenience function to get a textual input from the user.

*/
qt_QString * kde_KLineEditDlg_getText( qt_QString * _text, qt_QString * _value, int* ok, qt_QWidget * parent, qt_QValidator * validator);

/** *
 Static convenience function to get a textual input from the user.
 This method includes a caption, and has (almost) the same API as QInputDialog::getText
 (no echo mode, we have KPasswordDialog).

*/
qt_QString * kde_KLineEditDlg_getText1( qt_QString * _caption, qt_QString * _text, qt_QString * _value, int* ok, qt_QWidget * parent, qt_QValidator * validator);

/** *
 The line edit widget
   
*/
void kde_KLineEditDlg_virtual_hook(kde_KLineEditDlg* instPointer,int identifier, void* data);

/** * 
 Enables and disables the OK button depending on the state
 returned by the lineedit's @ref QValidator.
   
*/
void kde_KLineEditDlg_slotTextChanged(kde_KLineEditDlg* instPointer,qt_QString * arg1);

#ifdef __cplusplus
}
#endif
#endif
