/***************************************************************************
                            kde_KRecentFilesAction.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KRECENTFILESACTION
#define KDE_KRECENTFILESACTION

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
  This class is an action to handle a recent files submenu.
  The best way to create the action is to use KStdAction::openRecent.
  Then you simply need to call @ref loadEntries on startup, @ref saveEntries
  on shutdown, @ref addURL when your application loads/saves a file.

 @author Michael Koch

 @short Recent files action.
*/

/** *

*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_KRecentFilesAction * kde_new_KRecentFilesAction(qt_QString * text, kde_KShortcut* cut, qt_QObject * parent, char* name, unsigned int maxItems);

/** *

*/
kde_KRecentFilesAction * kde_new_KRecentFilesAction1(qt_QString * text, kde_KShortcut* cut, qt_QObject * receiver, char* slot, qt_QObject * parent, char* name, unsigned int maxItems);

/** *

*/
kde_KRecentFilesAction * kde_new_KRecentFilesAction2(qt_QString * text, qt_QIconSet* pix, kde_KShortcut* cut, qt_QObject * parent, char* name, unsigned int maxItems);

/** *

*/
kde_KRecentFilesAction * kde_new_KRecentFilesAction3(qt_QString * text, qt_QString * pix, kde_KShortcut* cut, qt_QObject * parent, char* name, unsigned int maxItems);

/** *

*/
kde_KRecentFilesAction * kde_new_KRecentFilesAction4(qt_QString * text, qt_QIconSet* pix, kde_KShortcut* cut, qt_QObject * receiver, char* slot, qt_QObject * parent, char* name, unsigned int maxItems);

/** *

*/
kde_KRecentFilesAction * kde_new_KRecentFilesAction5(qt_QString * text, qt_QString * pix, kde_KShortcut* cut, qt_QObject * receiver, char* slot, qt_QObject * parent, char* name, unsigned int maxItems);

/** *

*/
kde_KRecentFilesAction * kde_new_KRecentFilesAction6(qt_QObject * parent, char* name, unsigned int maxItems);

/** *
  Destructor.
   
*/
void kde_del_KRecentFilesAction( kde_KRecentFilesAction* p );

/** *
  Returns the maximum of items in the recent files list.
   
*/
unsigned int kde_KRecentFilesAction_maxItems(kde_KRecentFilesAction* instPointer);

/** *
  Sets the maximum of items in the recent files list.
  The default for this value is 10 set in the constructor.

  If this value is lesser than the number of items currently
  in the recent files list the last items are deleted until
  the number of items are equal to the new maximum.
   
*/
void kde_KRecentFilesAction_setMaxItems(kde_KRecentFilesAction* instPointer,unsigned int maxItems);

/** *
  Loads the recent files entries from a given KConfig object.
  You can provide the name of the group used to load the entries.
  If the groupname is empty, entries are load from a group called 'RecentFiles'

  This method does not effect the active group of KConfig.
   
*/
void kde_KRecentFilesAction_loadEntries(kde_KRecentFilesAction* instPointer,kde_KConfig* config, qt_QString * groupname);

/** *
  Saves the current recent files entries to a given KConfig object.
  You can provide the name of the group used to load the entries.
  If the groupname is empty, entries are saved to a group called 'RecentFiles'

  This method does not effect the active group of KConfig.
   
*/
void kde_KRecentFilesAction_saveEntries(kde_KRecentFilesAction* instPointer,kde_KConfig* config, qt_QString * groupname);

/** *
  Add URL to recent files list.

*/
void kde_KRecentFilesAction_addURL(kde_KRecentFilesAction* instPointer,kde_KURL* url);

/** *
  Remove an URL from the recent files list.

*/
void kde_KRecentFilesAction_removeURL(kde_KRecentFilesAction* instPointer,kde_KURL* url);

/** *
  Removes all entries from the recent files list.
   
*/
void kde_KRecentFilesAction_clearURLList(kde_KRecentFilesAction* instPointer);
void kde_KRecentFilesAction_virtual_hook(kde_KRecentFilesAction* instPointer,int identifier, void* data);

/** *

   
*/
void kde_KRecentFilesAction_itemSelected(kde_KRecentFilesAction* instPointer,qt_QString * string);

#ifdef __cplusplus
}
#endif
#endif
