/***************************************************************************
                            kde_KRestrictedLine.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KRESTRICTEDLINE
#define KDE_KRESTRICTEDLINE

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
* 
 The KRestrictedLine widget is a variant of @ref QLineEdit which
 accepts only a restricted set of characters as input. 
 All other characters will be discarded and the signal @ref #invalidChar() 
 will be emitted for each of them.

 Valid characters can be passed as a QString to the constructor
 or set afterwards via @ref #setValidChars().
 The default key bindings of @ref QLineEdit are still in effect.

 @author Michael Wiedmann <mw@miwie.in-berlin.de>

 @version 0.0.1
 
 @short A line editor for restricted character sets.

*/

/** *
 Constructor: This contructor takes three - optional - arguments.
  The first two parameters are simply passed on to @ref QLineEdit.

*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_KRestrictedLine * kde_new_KRestrictedLine(qt_QWidget * parent, char* name, qt_QString * valid);

/** *
 Destructs the restricted line editor.
   
*/
void kde_del_KRestrictedLine( kde_KRestrictedLine* p );

/** *
 All characters in the string valid are treated as 
 acceptable characters.
   
*/
void kde_KRestrictedLine_setValidChars(kde_KRestrictedLine* instPointer,qt_QString * valid);

/** *

*/
qt_QString * kde_KRestrictedLine_validChars(kde_KRestrictedLine* instPointer);
void kde_KRestrictedLine_virtual_hook(kde_KRestrictedLine* instPointer,int identifier, void* data);

#ifdef __cplusplus
}
#endif
#endif
