/***************************************************************************
                            kde_KSpellConfig.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KSPELLCONFIG
#define KDE_KSPELLCONFIG

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 A configuration class/dialog for @ref KSpell.

 It contains all of the options settings.The options are set to default
 values by the constructor and can be reset either by using the
 public interface or by using KSpellConfig as a widget in a dialog
 (or, preferably a tabbed dialog using @ref KDialogBase) and letting
 the user change the settings. This way an application that uses
 @ref KSpell can either rely on the default settings (in the simplest
 case), offer a dialog to configure @ref KSpell, or offer a dialog to
 configure @ref KSpell _for_this_app_only_ (in which case, the application
 should save the settings for use next time it is run).
 This last option might be useful in an email program, for example, where
 people may be writing in a language different from that used for
 writing papers in their word processor.

 @author David Sweet <dsweet@kde.org>

 @version $Id: kde_KSpellConfig.h,v 1.5 2002/12/30 14:37:06 geiseri Exp $

 @short *
 A configuration class/dialog for @ref KSpell.
*/

/** *
 Constructs a KSpellConfig with default or custom settings.

     
*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_KSpellConfig * kde_new_KSpellConfig(qt_QWidget * parent, char* name, kde_KSpellConfig* spellConfig, int addHelpButton);
kde_KSpellConfig * kde_new_KSpellConfig1(kde_KSpellConfig* arg1);
void kde_del_KSpellConfig( kde_KSpellConfig* p );

/** *

 The @p _ignorelist contains words you'd like @ref KSpell
 to ignore when it is spellchecking.  When you get a KSpellConfig
 object back from @ref KSpell (using @ref KSpell::kcConfig()),
 the @p _ignorelist contains whatever was put in by you plus
 any words the user has chosen to ignore via the dialog box.
 It may be useful to save this list with the document being
 edited to facilitate quicker future spellchecking.
     
*/
void kde_KSpellConfig_setIgnoreList(kde_KSpellConfig* instPointer,qt_QStringList* _ignorelist);

/** *
 The @p _replaceAllList contains word you like that replace
 word. Becarefull this list contains word which is replaced
 and new word.
     
*/
void kde_KSpellConfig_setReplaceAllList(kde_KSpellConfig* instPointer,qt_QStringList* _replaceAllList);

/** *
 Set an ISpell option.

 If @p true, don't create root-affix combinations.
     
*/
void kde_KSpellConfig_setNoRootAffix(kde_KSpellConfig* instPointer,int arg1);

/** *
 Set an ISpell option.

 If @p true, treat run-together words a valid.
     
*/
void kde_KSpellConfig_setRunTogether(kde_KSpellConfig* instPointer,int arg1);

/** *
 Set the name of the dictionary to use.
     
*/
void kde_KSpellConfig_setDictionary(kde_KSpellConfig* instPointer,qt_QString * qs);
void kde_KSpellConfig_setDictFromList(kde_KSpellConfig* instPointer,int dfl);

/** *

     
*/
void kde_KSpellConfig_setEncoding(kde_KSpellConfig* instPointer,int enctype);
void kde_KSpellConfig_setClient(kde_KSpellConfig* instPointer,int client);

/** *
 Options reading routines.
     
*/
int kde_KSpellConfig_noRootAffix(kde_KSpellConfig* instPointer);
int kde_KSpellConfig_runTogether(kde_KSpellConfig* instPointer);
qt_QString * kde_KSpellConfig_dictionary(kde_KSpellConfig* instPointer);
int kde_KSpellConfig_dictFromList(kde_KSpellConfig* instPointer);
int kde_KSpellConfig_encoding(kde_KSpellConfig* instPointer);
qt_QStringList* kde_KSpellConfig_ignoreList(kde_KSpellConfig* instPointer);
qt_QStringList* kde_KSpellConfig_replaceAllList(kde_KSpellConfig* instPointer);
int kde_KSpellConfig_client(kde_KSpellConfig* instPointer);

/** *
 Call this method before this class is deleted  if you want
 the settings you have (or the user has) chosen to become the
 global, default settings.
     
*/
int kde_KSpellConfig_writeGlobalSettings(kde_KSpellConfig* instPointer);

/** *
 Use this function to activate the help information for this
 widget. The function is particulary useful if the help button is
 not displayed as specified by the constructor. Normally you want
 to hide the help button if this widget is embedded into a larger
 dialog box that has its own help button. See kedit
 (optiondialog.cpp) for an example
     
*/
void kde_KSpellConfig_activateHelp(kde_KSpellConfig* instPointer);
#ifdef __cplusplus
}
#endif
#define KSPELLCONFIG_rdictlist	3
#define KSPELLCONFIG_rencoding	4
#define KSPELLCONFIG_rhelp	6
#ifdef __cplusplus
extern   "C" {
#endif
void kde_KSpellConfig_fillInDialog(kde_KSpellConfig* instPointer);
int kde_KSpellConfig_readGlobalSettings(kde_KSpellConfig* instPointer);

/** *
 This takes a dictionary file name (fname) and returns a language
 abbreviation (lname; like de for German), appropriate for the
 $LANG variable, and a human-readble name (hname; like "Deutsch").

 It also truncates ".aff" at the end of fname.

 TRUE is returned if lname.data()==$LANG
     
*/
int kde_KSpellConfig_interpret(kde_KSpellConfig* instPointer,qt_QString * fname, qt_QString * lname, qt_QString * hname);
void kde_KSpellConfig_sHelp(kde_KSpellConfig* instPointer);
void kde_KSpellConfig_sNoAff(kde_KSpellConfig* instPointer,int arg1);
void kde_KSpellConfig_sRunTogether(kde_KSpellConfig* instPointer,int arg1);
void kde_KSpellConfig_sDictionary(kde_KSpellConfig* instPointer,int arg1);
void kde_KSpellConfig_sPathDictionary(kde_KSpellConfig* instPointer,int arg1);
void kde_KSpellConfig_sSetDictionary(kde_KSpellConfig* instPointer,int arg1);
void kde_KSpellConfig_sChangeEncoding(kde_KSpellConfig* instPointer,int arg1);
void kde_KSpellConfig_sChangeClient(kde_KSpellConfig* instPointer,int arg1);

#ifdef __cplusplus
}
#endif
#endif
