/***************************************************************************
                            KPasswordDialog.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KPASSWORDDIALOG_H
#define KPASSWORDDIALOG_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KDialogBase.h>

/**

 This dialog asks the user to enter a password. The functions you're 
 probably interested in are the static methods, @ref  #--getPassword and
 @ref  #--getNewPassword.

 <pre>
 QCString password;
 int result = -[KPasswordDialog getPassword](password, i18n("Password"));
 if (result == -[KPasswordDialog Accepted])
     use(password);
 </pre>

 Keeping passwords in memory can be a potential security hole. You should
 handle this situation with care.

 @author Geert Jansen <jansen@kde.org>
 
 @short A password input dialog.

*/

@interface KPasswordDialog : KDialogBase 

/** 
 Constructs a password dialog.

*/
- initWithInt: (int)type enableKeep: (BOOL)enableKeep extraBttn: (int)extraBttn parent: (QWidget *)parent name: (NSString *)name;
- initWithInt: (int)type enableKeep: (BOOL)enableKeep extraBttn: (int)extraBttn ;

/** 

 possibility to specify a parent. May be removed in KDE 4.0
     
*/
- initWithInt: (int)type prompt: (NSString *)prompt enableKeep: (BOOL)enableKeep extraBttn: (int)extraBttn;
- initWithInt: (int)type prompt: (NSString *)prompt ;

/** 
 Destructs the password dialog.
     
*/
- (void) dealloc;

/** 
 Sets the password prompt.
     
*/
- setPrompt: (NSString *)prompt;

/** 
 Returns the password prompt.
     
*/
- (NSString *) prompt;

/** 
 Adds a line of information to the dialog.
     
*/
- addLine: (NSString *)key value: (NSString *)value;

/**  
 Returns the password entered. The memory is freed in the destructor,
 so you should make a copy.
     
*/
- (NSString *) password;

/**  Returns true if the user wants to keep the password. 
*/
- (BOOL) keep;

/** 
 Pops up the dialog, asks the user for a password, and returns it.

*/
+ (int) getPassword: (NSString *)password prompt: (NSString *)prompt keep: (int*)keep;
+ (int) getPassword: (NSString *)password prompt: (NSString *)prompt ;

/**  
 Pops up the dialog, asks the user for a password and returns it. The
 user has to enter the password twice to make sure it was entered
 correctly.

*/
+ (int) getNewPassword: (NSString *)password prompt: (NSString *)prompt;

/**  Static helper funtion that disables core dumps. 
*/
+ disableCoreDumps;

/**  Virtual function that can be overridden to provide password
 checking in derived classes. It should return @p true if the
 password is valid, @p false otherwise. 
*/
- (BOOL) checkPassword: (NSString *)arg1;
- slotOk;
- slotCancel;
- slotKeep: (BOOL)arg1;
+ (int) /***Theuserisaskedtoenterapassword.*/Password;
+ (int) /***Theuserisaskedtoenterapasswordandtoconfirmit*asecondtime.Thisisusuallyusedwhentheuser*changeshispassword.*/NewPassword;
@end

/** Override these methods in subclasses of KPasswordDialog to customise event handling behaviour */
@protocol KPasswordDialogEventHandling

/** 
 Maps some keys to the actions buttons. F1 is mapped to the Help
 button if present and Escape to the Cancel or Close if present. The
 button action event is animated.
     
*/
- keyPressEvent:(QKeyEvent*) e;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;

/** 
 Emits the @ref hidden signal. You can connect to that signal to
 detect when a dialog has been closed.
     
*/
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;

/** 
 Detects when a dialog is being closed from the window manager
 controls. If the Cancel or Close button is present then the button
 is activated. Otherwise standard @ref QDialog behavior
 will take place.
     
*/
- closeEvent:(QCloseEvent*) e;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
